/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep;

import org.jxmpp.JxmppContext;
import org.jxmpp.XmppAddressParttype;
import org.jxmpp.stringprep.XmppStringprep;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.stringprep.simple.SimpleXmppStringprep;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class XmppStringPrepUtil {
    private static final Cache<String, String> NODEPREP_CACHE;
    private static final Cache<String, String> DOMAINPREP_CACHE;
    private static final Cache<String, String> RESOURCEPREP_CACHE;

    @Deprecated
    public static void setXmppStringprep(XmppStringprep xmppStringprep) {
        JxmppContext.setDefaultXmppStringprep(xmppStringprep);
    }

    public static String localprep(String string) throws XmppStringprepException {
        return XmppStringPrepUtil.localprep(string, JxmppContext.getDefaultContext());
    }

    public static String localprep(String string, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string, XmppAddressParttype.localpart);
        if (context.isCachingEnabled() && (res = NODEPREP_CACHE.lookup(string)) != null) {
            return res;
        }
        res = context.xmppStringprep.localprep(string);
        if (context.isCachingEnabled()) {
            NODEPREP_CACHE.put(string, res);
        }
        return res;
    }

    public static String domainprep(String string) throws XmppStringprepException {
        return XmppStringPrepUtil.domainprep(string, JxmppContext.getDefaultContext());
    }

    public static String domainprep(String string, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string, XmppAddressParttype.domainpart);
        if (context.isCachingEnabled() && (res = DOMAINPREP_CACHE.lookup(string)) != null) {
            return res;
        }
        res = context.xmppStringprep.domainprep(string);
        if (context.isCachingEnabled()) {
            DOMAINPREP_CACHE.put(string, res);
        }
        return res;
    }

    public static String resourceprep(String string) throws XmppStringprepException {
        return XmppStringPrepUtil.resourceprep(string, JxmppContext.getDefaultContext());
    }

    public static String resourceprep(String string, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string, XmppAddressParttype.resourcepart);
        if (context.isCachingEnabled() && (res = RESOURCEPREP_CACHE.lookup(string)) != null) {
            return res;
        }
        res = context.xmppStringprep.resourceprep(string);
        if (context.isCachingEnabled()) {
            RESOURCEPREP_CACHE.put(string, res);
        }
        return res;
    }

    public static void setMaxCacheSizes(int size) {
        NODEPREP_CACHE.setMaxCacheSize(size);
        DOMAINPREP_CACHE.setMaxCacheSize(size);
        RESOURCEPREP_CACHE.setMaxCacheSize(size);
    }

    private static void throwIfNullOrEmpty(String string, XmppAddressParttype type2) throws XmppStringprepException {
        if (string == null) {
            throw new XmppStringprepException(string, (Object)((Object)type2) + " can't be null");
        }
        if (string.isEmpty()) {
            throw new XmppStringprepException(string, (Object)((Object)type2) + " can't be the empty string");
        }
    }

    static {
        SimpleXmppStringprep.setup();
        NODEPREP_CACHE = new LruCache<String, String>(100);
        DOMAINPREP_CACHE = new LruCache<String, String>(100);
        RESOURCEPREP_CACHE = new LruCache<String, String>(100);
    }
}

