# E.2 What do eco-anarchists propose instead of capitalism?

Given what eco-anarchists consider to be the root cause of our ecological
problems (as discussed in the [last section](secE1.md)), it should come as
no surprise that they think that the current ecological crisis can only be
really solved by eliminating those root causes, namely by ending domination
within humanity and creating an anarchist society. So here we will summarise
the vision of the free society eco-anarchists advocate before discussing the
limitations of various non-anarchist proposals to solve environmental problems
in subsequent sections.

However, before so doing it is important to stress that eco-anarchists
consider it important to fight against ecological and social problems today.
Like all anarchists, they argue for direct action and solidarity to struggle
for improvements and reforms under the current system. This means that eco-
anarchism _"supports every effort to conserve the environment"_ in the here
and now. The key difference between them and environmentalists is that eco-
anarchists place such partial struggles within a larger context of changing
society as a whole. The former is part of _"waging a delaying action against
the rampant destruction of the environment"_ the other is _"a create movement
to totally revolutionise the social relations of humans to each other and of
humanity to nature."_ [Murray Bookchin, **Toward an Ecological Society** , p.
43] This is one of the key differences between an ecological perspective and
an environmental one (a difference discussed in [section
E.1.2](secE1.md#sece12)). Finding ways to resist capitalism's reduction of
the living world to resources and commodities and its plunder of the planet,
our resistance to specific aspects of an eco-cidal system, are merely a
starting point in the critique of the whole system and of a wider struggle for
a better society. As such, our outline of an ecological society (or ecotopia)
is not meant to suggest an indifference to partial struggles and reforms
within capitalism. It is simply to indicate why anarchists are confident that
ending capitalism and the state will create the necessary preconditions for a
free and ecologically viable society.

This perspective flows from the basic insight of eco-anarchism, namely that
ecological problems are not separate from social ones. As we are part of
nature, it means that how we interact and shape with it will be influenced by
how we interact and shape ourselves. As Reclus put it _"every people gives, so
to speak, new clothing to the surrounding nature. By means of its fields and
roads, by its dwelling and every manner of construction, by the way it
arranges the trees and the landscape in general, the populace expresses the
character of its own ideals. If it really has a feeling for beauty, it will
make nature more beautiful. If, on the other hand, the great mass of humanity
should remain as it is today, crude, egoistic and inauthentic, it will
continue to mark the face of the earth with its wretched traces. Thus will the
poet's cry of desperation become a reality: 'Where can I flee? Nature itself
has become hideous.'"_ In order to transform how we interact with nature, we
need to transform how we interact with each other. _"Fortunately,"_ Reclus
notes, _"a complete alliance of the beautiful and the useful is possible."_
[quoted by Clark and Martin (eds.) , **Anarchy, Geography, Modernity** , p.
125 and p. 28]

Over a century later, Murray Bookchin echoed this insight:

> _"The views advanced by anarchists were deliberately called **social**
> ecology to emphasise that major ecological problems have their roots in
> social problems -- problems that go back to the very beginnings of
> patricentric culture itself. The rise of capitalism, with a law of life
> based on competition, capital accumulation, and limitless growth, brought
> these problems -- ecological and social -- to an acute point; indeed, one
> that was unprecedented in any prior epoch of human development. Capitalist
> society, by recycling the organise world into an increasingly inanimate,
> inorganic assemblage of commodities, was destined to simplify the biosphere,
> thereby cutting across the grain of natural evolution with its ages-long
> thrust towards differentiation and diversity.  
>  _
>
> _"To reverse this trend, capitalism had to be replaced by an ecological
> society based on non-hierarchical relationships, decentralised communities,
> eco-technologies like solar power, organic agriculture, and humanly scaled
> industries -- in short, by face-to-face democratic forms of settlement
> economically and structurally tailored to the ecosystems in which they were
> located."_ [ **Remaking Society** , pp. 154-5]

The vision of an ecological society rests on the obvious fact that people can
have both positive and negative impacts on the environment. In current
society, there are vast differences and antagonisms between privileged whites
and people of colour, men and women, rich and poor, oppressor and oppressed.
Remove those differences and antagonisms and our interactions with ourselves
and nature change radically. In other words, there is a vast difference
between free, non-hierarchical, class, and stateless societies on the one
hand, and hierarchical, class-ridden, statist, and authoritarian ones and how
they interact with the environment.

Given the nature of ecology, it should come as no surprise that social
anarchists have been at the forefront of eco-anarchist theory and activism. It
would be fair to say that most eco-anarchists, like most anarchists in
general, envision an ecotopia based on communist-anarchist principles. This
does not mean that individualist anarchists are indifferent to environmental
issues, simply that most anarchists are unconvinced that such solutions will
actually end the ecological crisis we face. Certain of the proposals in this
section are applicable to individualist anarchism (for example, the arguments
that co-operatives will produce less growth and be less likely to pollute).
However, others are not. Most obviously, arguments in favour of common
ownership and against the price mechanism are not applicable to the market
based solutions of individualist anarchism. It should also be pointed out,
that much of the eco-anarchist critique of capitalist approaches to ecological
problems are also applicable to individualist and mutualist anarchism as well
(particularly the former, as the latter does recognise the need to regulate
the market). While certain aspects of capitalism would be removed in an
individualist anarchism (such as massive inequalities of wealth, capitalist
property rights as well as direct and indirect subsidies to big business), it
is still has the informational problems associated with markets as well as a
growth orientation.

Here we discuss the typical eco-anarchist view of a free ecological society,
namely one rooted in social anarchist principles. Eco-anarchists, like all
consistent anarchists advocate workers' self-management of the economy as a
necessary component of an ecologically sustainable society. This usually means
society-wide ownership of the means of production and all productive
enterprises self-managed by their workers (as described further in [section
I.3](secI3.md)). This is a key aspect of making a truly ecological society.
Most greens, even if they are not anarchists, recognise the pernicious
ecological effects of the capitalist "grow or die" principle; but unless they
are also anarchists, they usually fail to make the connection between that
principle and the **hierarchical form** of the typical capitalist corporation.
The capitalist firm, like the state, is centralised, top-down and autocratic.
These are the opposite of what an ecological ethos would suggest. In contrast,
eco-anarchists emphasise the need for socially owned and worker self-managed
firms.

This vision of co-operative rather than hierarchical production is a common
position for almost all anarchists. Communist and non-communist social
anarchists, like mutualists and collectivists, propose co-operative workplaces
but differ in how best to distribute the products produced. The former urge
the abolition of money and sharing according to need while the latter see
income related to work and surpluses are shared equally among all members.
Both of these systems would produce workplaces which would be under far less
pressure toward rapid expansion than the traditional capitalist firm (as
individualist anarchism aims for the abolition of rent, profit and interest
it, too, will have less expansive workplaces).

The slower growth rate of co-operatives has been documented in a number of
studies, which show that in the traditional capitalist firm, owners' and
executives' percentage share of profits greatly increases as more employees
are added to the payroll. This is because the corporate hierarchy is designed
to facilitate exploitation by funnelling a disproportionate share of the
surplus value produced by workers to those at the top of the pyramid (see
[section C.2](secC2.md)) Such a design gives ownership and management a very
strong incentive to expand, since, other things being equal, their income
rises with every new employee hired. [David Schweickart, **Against
Capitalism** , pp. 153-4] Hence the hierarchical form of the capitalist
corporation is one of the main causes of runaway growth as well as social
inequality and the rise of big business and oligopoly in the so-called "free"
market.

By contrast, in an equal-share worker co-operative, the addition of more
members simply means more people with whom the available pie will have to be
equally divided -- a situation that immensely reduces the incentive to expand.
Thus a libertarian-socialist economy will not be under the same pressure to
grow. Moreover, when introducing technological innovations or facing declining
decline for goods, a self-managed workplace would be more likely to increase
leisure time among producers rather than increase workloads or reduce numbers
of staff.

This means that rather than produce a few big firms, a worker-controlled
economy would tend to create an economy with more small and medium sized
workplaces. This would make integrating them into local communities and eco-
systems far easier as well as making them more easily dependent on green
sources of energy. Then there are the other ecological advantages to workers'
self-management beyond the relative lack of expansion of specific workplaces
and the decentralisation this implies. These are explained well by market
socialist David Schweickart:

> _"To the extent that emissions affect the workers directly on the job (as
> they often do), we can expect a self-managed firm to pollute less. Workers
> will control the technology; it will not be imposed on them from without.  
>  _
>
> _"To the extent that emissions affect the local community, they are likely
> to be less severe, for two reasons. Firstly, workers (unlike capitalist
> owners) will necessarily live nearby, and so the decision-makers will bear
> more of the environmental costs directly. Second . . . a self-managed firm
> will not be able to avoid local regulation by running away (or threatening
> to do so). The great stick that a capitalist firm holds over the head of a
> local community will be absent. Hence absent will be the macrophenomenon of
> various regions of the country trying to compete for firms by offering a
> 'better business climate' (i.e. fewer environmental restrictions)."_ [ **Op.
> Cit.** , p. 145]

For an ecological society to work, it requires the active participation of
those doing productive activity. They are often the first to be affected by
industrial pollution and have the best knowledge of how to stop it happening.
As such, workplace self-management is an essential requirement for a society
which aims to life in harmony with its surrounds (and with itself, as a key
aspect of social unfreedom would be eliminated in the form of wage slavery).

For these reasons, libertarian socialism based on producer co-operatives is
essential for the type of economy necessary to solve the ecological crisis.
These all feed directly into the green vision as _"ecology points to the
necessity of decentralisation, diversity in natural and social systems, human-
scale technology, and an end to the exploitation of nature."_ [John Clark,
**The Anarchist Moment** , p. 115] This can only be achieved on a society
which bases itself on workers' self-management as this would facilitate the
decentralisation of industries in ways which are harmonious with nature.

So far, all forms of social anarchism are in agreement. However, eco-
anarchists tend to be communist-anarchists and oppose both mutualism and
collectivism. This is because workers' ownership and self-management places
the workers of an enterprise in a position where they can become a
particularistic interest within their community. This may lead to these firms
acting purely in their own narrow interests and against the local community.
They would be, in other words, outside of community input and be solely
accountable to themselves. This could lead to a situation where they become
"collective capitalists" with a common interest in expanding their
enterprises, increasing their "profits" and even subjecting themselves to
irrational practices to survive in the market (i.e., harming their own wider
and long-term interests as market pressures have a distinct tendency to
produce a race to the bottom -- see [section I.1.3](secI1.md#seci13) for
more discussion). This leads most eco-anarchists to call for a confederal
economy and society in which communities will be decentralised and freely give
of their resources without the use of money.

As a natural compliment to workplace self-management, eco-anarchists propose
communal self-management. So, although it may have appeared that we focus our
attention on the economic aspects of the ecological crisis and its solution,
this is not the case. It should always be kept in mind that all anarchists see
that a complete solution to our many ecological and social problems must be
multi-dimensional, addressing all aspects of the total system of hierarchy and
domination. This means that only anarchism, with its emphasis on the
elimination of authority in **all** areas of life, goes to the fundamental
root of the ecological crisis.

The eco-anarchist argument for direct (participatory) democracy is that
effective protection of the planet's ecosystems requires that all people are
able to take part at the grassroots level in decision-making that affects
their environment, since they are more aware of their immediate eco-systems
and more likely to favour stringent environmental safeguards than politicians,
state bureaucrats and the large, polluting special interests that now dominate
the "representative" system of government. Moreover, real change must come
from below, not from above as this is the very source of the social and
ecological problems that we face as it divests individuals, communities and
society as a whole of their power, indeed right, to shape their own destinies
as well as draining them of their material and "spiritual" resources (i.e.,
the thoughts, hopes and dreams of people).

Simply put, it should be hardly necessary to explore in any great depth the
sound ecological and social reasons for decentralising decision making power
to the grassroots of society, i.e. to the people who have to live with the
decisions being reached. The decentralised nature of anarchism would mean that
any new investments and proposed solutions to existing problems would be
tailored to local conditions. Due to the mobility of capital, laws passed
under capitalism to protect the environment have to be created and implemented
by the central government to be effective. Yet the state, as discussed in
[section E.1](secE1.md), is a centralised structure unsuited to the task of
collecting and processing the information and knowledge required to customise
decisions to local ecological and social circumstances. This means that
legislation, precisely due to its scope, cannot be finely tuned to local
conditions (and so can generate local opposition, particularly if whipped up
by corporate front organisations). In an eco-anarchist society,
decentralisation would not have the threat of economic power hanging over it
and so decisions would be reached which reflected the actual local needs of
the population. As they would be unlikely to want to pollute themselves or
their neighbours, eco-anarchists are confident that such local empowerment
will produce a society which lives with, rather than upon, the environment.

Thus eco-communities (or eco-communes) are a key aspect of an ecotopia. Eco-
communes, Bookchin argued, will be _"networked confederally through
ecosystems, bioregions, and biomes"_ and be _"artistically tailored to their
naturally surrounding. We can envision that their squares will be interlaced
by streams, their places of assembly surrounded by groves, their physical
contours respected and tastefully landscaped, their soils nurtured caringly to
foster plant variety for ourselves, our domestic animals, and wherever
possible the wildlife they may support on their fringes."_ They would be
decentralised and _"scaled to human dimensions,"_ using recycling as well as
integrating _"solar, wind, hydraulic, and methane-producing installations into
a highly variegated pattern for producing power. Agriculture, aquaculture,
stockraising, and hunting would be regarded as crafts -- an orientation that
we hope would be extended as much as possible to the fabrication of use-values
of nearly all kinds. The need to mass-produce goods in highly mechanised
installations would be vastly diminished by the communities' overwhelming
emphasis on quality and permanence."_ [ **The Ecology of Freedom** , p. 444]

This means that local communities will generate social and economic policies
tailored to their own unique ecological circumstances, in co-operation with
others (it is important stress that eco-communes do not imply supporting local
self-sufficiency and economic autarchy as values in themselves). Decisions
that have regional impact are worked out by confederations of local
assemblies, so that everybody affected by a decision can participate in making
it. Such a system would be self-sufficient as workplace and community
participation would foster creativity, spontaneity, responsibility,
independence, and respect for individuality -- the qualities needed for a
self-management to function effectively. Just as hierarchy shapes those
subject to it in negative ways, participation would shape us in positive ways
which would strengthen our individuality and enrich our freedom and
interaction with others and nature.

That is not all. The communal framework would also impact on how industry
would develop. It would allow eco-technologies to be prioritised in terms of
R&D and subsidised in terms of consumption. No more would green alternatives
and eco-technologies be left unused simply because most people cannot afford
to buy them nor would their development be under-funded simply because a
capitalist sees little profit form it or a politician cannot see any benefit
from it. It also means that the broad outlines of production are established
at the community assembly level while they are implemented in practice by
smaller collective bodies which also operate on an egalitarian, participatory,
and democratic basis. Co-operative workplaces form an integral part of this
process, having control over the production process and the best way to
implement any general outlines.

It is for these reasons that anarchists argue that common ownership combined
with a use-rights based system of possession is better for the environment as
it allows everyone the right to take action to stop pollution, not simply
those who are directly affected by it. As a framework for ecological ethics,
the communal system envisioned by social anarchists would be far better than
private property and markets in protecting the environment. This is because
the pressures that markets exert on their members would not exist, as would
the perverse incentives which reward anti-social and anti-ecological
practices. Equally, the anti-ecological centralisation and hierarchy of the
state would be ended and replaced with a participatory system which can take
into account the needs of the local environment and utilise the local
knowledge and information that both the state and capitalism suppresses.

Thus a genuine solution to the ecological crisis presupposes communes, i.e.
participatory democracy in the social sphere. This is a transformation that
would amount to a political revolution. However, as Bakunin continually
emphasised, a political revolution of this nature cannot be envisioned without
a **socio-economic** revolution based on workers' self-management. This is
because the daily experience of participatory decision-making, non-
authoritarian modes of organisation, and personalistic human relationships
would not survive if those values were denied during working hours. Moreover,
as mentioned above, participatory communities would be hard pressed to survive
the pressure that big business would subject them to.

Needless to say, the economic and social aspects of life cannot be considered
in isolation. For example, the negative results of workplace hierarchy and its
master-servant dynamic will hardly remain there. Given the amount of time that
most people spend working, the political importance of turning it into a
training ground for the development of libertarian values can scarcely be
overstated. As history has demonstrated, political revolutions that are not
based upon social changes and mass psychological transformation -- that is, by
a deconditioning from the master/slave attitudes absorbed from the current
system -- result only in the substitution of new ruling elites for the old
ones (e.g. Lenin becoming the new "Tsar" and Communist Party aparatchiks
becoming the new "aristocracy"). Therefore, besides having a slower growth
rate, worker co-operatives with democratic self-management would lay the
psychological foundations for the kind of directly democratic political system
necessary to protect the biosphere. Thus "green" libertarian socialism is the
only proposal radical enough to solve the ecological crisis.

Ecological crises become possible only within the context of social relations
which weaken people's capacities to fight an organised defence of the planet's
ecology and their own environment. This means that the restriction of
participation in decision-making processes within hierarchical organisations
such as the state and capitalism firms help create environmental along with
social problems by denying those most affected by a problem the means of
fixing it. Needless to say, hierarchy within the workplace is a prerequisite
to accumulation and so growth while hierarchy within a community is a
prerequisite to defend economic and social inequality as well as minority rule
as the disempowered become indifferent to community and social issues they
have little or no say in. Both combine to create the basis of our current
ecological crisis and both need to be ended.

Ultimately, a free nature can only begin to emerge when we live in a fully
participatory society which itself is free of oppression, domination and
exploitation. Only then will we be able to rid ourselves of the idea of
dominating nature and fulfil our potential as individuals and be a creative
force in natural as well social evolution. That means replacing the current
system with one based on freedom, equality and solidarity. Once this is
achieved, _"social life will yield a sensitive development of human and
natural diversity, falling together into a well balanced harmonious whole.
Ranging from community through region to entire continents, we will see a
colourful differentiation of human groups and ecosystems, each developing its
unique potentialities and exposing members of the community to a wide spectrum
of economic, cultural and behavioural stimuli. Falling within our purview will
be an exciting, often dramatic, variety of communal forms -- here marked by
architectural and industrial adaptations to semi-arid ecosystems, there to
grasslands, elsewhere by adaptation to forested areas. We will witness a
creative interplay between individual and group, community and environment,
humanity and nature."_ [Bookchin, **Post-Scarcity Anarchism** , p. 39]

So, to conclude, in place of capitalism eco-anarchists favour ecologically
responsible forms of libertarian socialism, with an economy based on the
principles of complementarily with nature; decentralisation (where possible
and desirable) of large-scale industries, reskilling of workers, and a return
to more artisan-like modes of production; the use of eco-technologies and
ecologically friendly energy sources to create green products; the use of
recycled and recyclable raw materials and renewable resources; the integration
of town and country, industry and agriculture; the creation of self-managed
eco-communities which exist in harmony with their surroundings; and self-
managed workplaces responsive to the wishes of local community assemblies and
labour councils in which decisions are made by direct democracy and co-
ordinated (where appropriate and applicable) from the bottom-up in a free
federation. Such a society would aim to develop the individuality and freedom
of all its members in order to ensure that we end the domination of nature by
humanity by ending domination within humanity itself.

This is the vision of a green society put forth by Murray Bookchin. To quote
him:

> _"We must create an ecological society -- not merely because such a society
> is desirable but because it is direly necessary. We must begin to live in
> order to survive. Such a society involves a fundamental reversal of all the
> trends that mark the historic development of capitalist technology and
> bourgeois society -- the minute specialisation or machines and labour, the
> concentration of resources and people in gigantic industrial enterprises and
> urban entities, the stratification and bureaucratisation of life, the
> divorce of town from country, the objectification of nature and human
> beings. In my view, this sweeping reversal means that we must begin to
> decentralise our cities and establish entirely new eco-communities that are
> artistically moulded to the ecosystems in which they are located . . .  
>  _
>
> _"Such an eco-community . . . would heal the split between town and country,
> indeed, between mind and body by fusing intellectual with physical work,
> industry with agriculture in a rotation or diversification of vocational
> tasks. An eco-community would be supported by a new kind of technology -- or
> eco-technology -- one composed of flexible, versatile machinery whose
> productive applications would emphasise durability and quality . . ."_ [
> **Toward an Ecological Society** , pp. 68-9]

Lastly, we need to quickly sketch out how anarchists see the change to an
ecological society happening as there is little point having an aim if you
have no idea how to achieve it.

As noted above, eco-anarchists (like all anarchists) do not counterpoise an
ideal utopia to existing society but rather participate in current ecological
struggles. Moreover, we see that struggle itself as the link between what is
and what could be. This implies, at minimum, a two pronged strategy of
neighbourhood movements and workplace organising as a means of both fighting
and abolishing capitalism. These would work together, with the former
targeting, say, the disposal of toxic wastes and the latter stopping the
production of toxins in the first place. Only when workers are in a position
to refuse to engage in destructive practices or produce destructive goods can
lasting ecological change emerge. Unsurprisingly, modern anarchists and
anarcho-syndicalists have been keen to stress the need for a green syndicalism
which addresses ecological as well as economical exploitation. The ideas of
community and industrial unionism are discussed in more detail in [section
J.5](secJ5.md) along with other anarchist tactics for social change.
Needless to say, such organisations would use direct action as their means of
achieving their goals (see [section J.2](secJ2.md)). It should be noted that
some of Bookchin's social ecologist followers advocate, like him, greens
standing in local elections as a means to create a counter-power to the state.
As we discuss in [section J.5.14](secJ5.md#secj514), this strategy (called
Libertarian Municipalism) finds few supporters in the wider anarchist
movement.

This strategy flows, of course, into the structures of an ecological society.
As we discuss in [section I.2.3](secI2.md#seci23), anarchists argue that the
framework of a free society will be created in the process of fighting the
existing one. Thus the structures of an eco-anarchist society (i.e. eco-
communes and self-managed workplaces) will be created by fighting the ecocidal
tendencies of the current system. In other words, like all anarchists eco-
anarchists seek to create the new world while fighting the old one. This means
what we do now is, however imperfect, an example of what we propose instead of
capitalism. That means we act in an ecological fashion today in order to
ensure that we can create an ecological society tomorrow.

For more discussion of how an anarchist society would work, see [section
I](secIcon.md). We will discuss the limitations of various proposed
solutions to the environmental crisis in the following sections.

[‹ E.1 What are the root causes of our ecological problems?](secE1.md "Go to
previous page") [up](secEcon.md "Go to parent page") [E.3 Can private
property rights protect the environment? ›](secE3.md "Go to next page")

