#ifndef GUI_QUALITY__GRAYSCALEPLOTPAGE_H
#define GUI_QUALITY__GRAYSCALEPLOTPAGE_H

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/separator.h>
#include <gtkmm/togglebutton.h>

#include "../plot/plotwidget.h"

#include "../quality/qualitytablesformatter.h"

#include "../structures/timefrequencydata.h"
#include "../structures/timefrequencymetadata.h"

#include "plotsheet.h"

class GrayScalePlotPage : public PlotSheet {
 public:
  explicit GrayScalePlotPage(class HeatMapPageController* controller);
  virtual ~GrayScalePlotPage();

  void InitializeToolbar(Gtk::Box& toolbar) final;

  bool NormalizeXAxis() const { return _normalizeXAxisButton.get_active(); }
  bool NormalizeYAxis() const { return _normalizeYAxisButton.get_active(); }

  void Redraw();

 protected:
  QualityTablesFormatter::StatisticKind getSelectedStatisticKind() const {
    return _selectStatisticKind;
  }

  void updateImage();

  PlotWidget& grayScaleWidget() { return _imageWidget; }

 private:
  void initStatisticKinds(Gtk::Box& toolbar);
  void initPolarizations(Gtk::Box& toolbar);
  void initPhaseButtons(Gtk::Box& toolbar);
  void initPlotOptions(Gtk::Box& toolbar);

  aocommon::PolarizationEnum getSelectedPolarization() const;
  enum TimeFrequencyData::ComplexRepresentation getSelectedPhase() const;

  void onSelectCount() {
    _selectStatisticKind = QualityTablesFormatter::CountStatistic;
    updateImage();
  }
  void onSelectMean() {
    _selectStatisticKind = QualityTablesFormatter::MeanStatistic;
    updateImage();
  }
  void onSelectStdDev() {
    _selectStatisticKind = QualityTablesFormatter::StandardDeviationStatistic;
    updateImage();
  }
  void onSelectDCount() {
    _selectStatisticKind = QualityTablesFormatter::DCountStatistic;
    updateImage();
  }
  void onSelectDMean() {
    _selectStatisticKind = QualityTablesFormatter::DMeanStatistic;
    updateImage();
  }
  void onSelectDStdDev() {
    _selectStatisticKind = QualityTablesFormatter::DStandardDeviationStatistic;
    updateImage();
  }
  void onSelectRFIPercentage() {
    _selectStatisticKind = QualityTablesFormatter::RFIPercentageStatistic;
    updateImage();
  }
  void onSelectSNR() {
    _selectStatisticKind = QualityTablesFormatter::SignalToNoiseStatistic;
    updateImage();
  }
  void onPropertiesClicked();

  void onSelectMinMaxRange();
  void onSelectWinsorizedRange();
  void onSelectSpecifiedRange();
  void onLogarithmicScaleClicked();
  void onNormalizeAxesButtonClicked() { updateImage(); }
  void onChangeNormMethod() {
    if (_normalizeYAxisButton.get_active()) updateImage();
  }

  class HeatMapPageController* _controller;

  Gtk::Separator _separator1, _separator2, _separator3, _separator4,
      _separator5, _separator6;

  Gtk::ToggleButton _countButton{"#"};
  Gtk::ToggleButton _meanButton{"μ"};
  Gtk::ToggleButton _stdDevButton{"σ"};
  Gtk::ToggleButton _dMeanButton{"Δμ"};
  Gtk::ToggleButton _dStdDevButton{"Δσ"};
  Gtk::ToggleButton _rfiPercentageButton{"%"};

  Gtk::ToggleButton _polPPButton{"pp"}, _polPQButton{"pq"}, _polQPButton{"qp"},
      _polQQButton{"qq"}, _polIButton{"I"};

  Gtk::ToggleButton _amplitudePhaseButton{"A"};
  Gtk::ToggleButton _phasePhaseButton{"ϕ"};
  Gtk::ToggleButton _realPhaseButton{"r"};
  Gtk::ToggleButton _imaginaryPhaseButton{"i"};

  Gtk::ToggleButton _rangeMinMaxButton{"M"};
  Gtk::ToggleButton _rangeWinsorizedButton{"W"};
  Gtk::ToggleButton _rangeSpecified{"S"};

  Gtk::ToggleButton _logarithmicScaleButton{"L"};
  Gtk::ToggleButton _normalizeXAxisButton{"NX"};
  Gtk::ToggleButton _normalizeYAxisButton{"NY"};

  Gtk::ToggleButton _meanNormButton{"Nμ"};
  Gtk::ToggleButton _winsorNormButton{"NW"};
  Gtk::ToggleButton _medianNormButton{"NM"};

  Gtk::Button _plotPropertiesButton{"P"};

  QualityTablesFormatter::StatisticKind _selectStatisticKind;
  PlotWidget _imageWidget;

  class ImagePropertiesWindow* _imagePropertiesWindow;
};

#endif
