#ifndef GUI_QUALITY__2DPLOTPAGE_H
#define GUI_QUALITY__2DPLOTPAGE_H

#include <memory>

#include "controllers/aoqplotpagecontroller.h"

#include "../quality/qualitytablesformatter.h"

#include "../plot/plotwidget.h"
#include "../plot/xyplot.h"

#include "plotsheet.h"

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/separator.h>

#include <set>
#include <vector>

class TwoDimensionalPlotPage : public PlotSheet {
 public:
  explicit TwoDimensionalPlotPage(AOQPlotPageController* _controller);
  virtual ~TwoDimensionalPlotPage();

  void InitializeToolbar(Gtk::Box& toolbar) override final;

  std::vector<QualityTablesFormatter::StatisticKind> GetSelectedKinds() const;
  std::set<AOQPlotPageController::SelectedPol> GetSelectedPolarizations() const;
  std::set<AOQPlotPageController::PhaseType> GetSelectedPhases() const;

  void Redraw();

 protected:
  virtual void addCustomPlotButtons(Gtk::Box& container) {}

 private:
  void updatePlotConfig();
  void updateDataWindow();

  void initStatisticKindButtons(Gtk::Box& toolbar);
  void initPolarizationButtons(Gtk::Box& toolbar);
  void initPhaseButtons(Gtk::Box& toolbar);
  void initPlotButtons(Gtk::Box& toolbar);

  void onLogarithmicClicked() {
    _zeroAxisButton.set_sensitive(!_logarithmicButton.get_active());
    updatePlotConfig();
  }
  void onPlotPropertiesClicked();
  void onDataExportClicked();

  AOQPlotPageController* _controller;

  Gtk::Separator _separator1, _separator2, _separator3, _separator4;

  Gtk::ToggleButton _countButton, _meanButton, _stdDevButton, _varianceButton,
      _dCountButton, _dMeanButton, _dStdDevButton, _rfiPercentageButton;

  Gtk::ToggleButton _polPPButton, _polPQButton, _polQPButton, _polQQButton,
      _polIButton;

  Gtk::ToggleButton _amplitudeButton, _phaseButton, _realButton,
      _imaginaryButton;

  Gtk::ToggleButton _logarithmicButton, _zeroAxisButton;
  Gtk::Button _plotPropertiesButton, _dataExportButton;

  PlotWidget _plotWidget;

  std::unique_ptr<class PlotPropertiesWindow> _plotPropertiesWindow;
  std::unique_ptr<class DataWindow> _dataWindow;

  bool _customButtonsCreated;
};

#endif
