#include "initialization.h"

#include <filesystem>
#include <memory>

#include <gtkmm/icontheme.h>

#include <version.h>

void SetupIconTheme(const std::string& argv0) {
  const std::shared_ptr<Gtk::IconTheme> iconTheme =
      Gtk::IconTheme::get_for_display(Gdk::Display::get_default());

  const std::filesystem::path argv0Root =
      std::filesystem::path(argv0).remove_filename();
  if (!std::filesystem::equivalent(
          argv0Root / "..", std::filesystem::path(AOFLAGGER_INSTALL_PATH))) {
    const std::filesystem::path iconPathC =
        std::filesystem::path(AOFLAGGER_INSTALL_PATH) / "share/icons";
    iconTheme->add_search_path(iconPathC.string());
  }
  const std::filesystem::path iconPathA = argv0Root / "../share/icons";
  iconTheme->add_search_path(iconPathA.string());
  const std::filesystem::path iconPathB = argv0Root / "../data/icons";
  iconTheme->add_search_path(iconPathB.string());
}
