ios::pos_type StreamBuf::seekoff(ios::off_type step,
                                 ios::seekdir way, ios::openmode mode)
{
    off_type offs;

    switch (way)
    {
        default:                    // ios::beg: buffOffset is step
            offs = step;
        break;

        case ios::cur:
            switch (d_last)
            {
                                    // default: case SEEK
                default:            // no read/write used so far
                    offs = offset;
                break;              // add step to bufOffset (below)

                case READ:          // setg was used, set bufOffset to
                                    // the abs offset of gptr()
                    offs = bufbeg + gptr() - eback();
                break;

                case WRITE:         // setp was used, set bufOffset to
                                    // the abs offset of pptr()
                    offs = bufbeg + pptr() - pbase();

                                    // may extend the writing area
                    if (offs > static_cast<off_type>(getend))
                        getend = offs;
                break;
            }

            offs += step;         // add the step
        break;

        case ios::end:
            offs = getend + step; // shift from the last write position
        break;
    }

    if (offs < 0)
        offs = 0;                 // offset always >= 0

    d_last = SEEK;

    setg(0, 0, 0);                  // reset the buffers
    setp(0, 0);

    return offset = offs;      // the updated offset
}
