/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;

public class ScoreColourScheme
extends ResidueColourScheme {
    public double min;
    public double max;
    public double[] scores;

    public ScoreColourScheme(double[] scores, double min, double max) {
        this.scores = scores;
        this.min = min;
        this.max = max;
        int iSize = scores.length;
        this.colors = new Color[scores.length];
        for (int i = 0; i < iSize; ++i) {
            float red = (float)(scores[i] - (double)((float)min)) / (float)(max - min);
            if (red > 1.0f) {
                red = 1.0f;
            }
            if (red < 0.0f) {
                red = 0.0f;
            }
            this.colors[i] = this.makeColour(red);
        }
    }

    public Color findColour(char c, int j) {
        if (this.threshold > 0 && !this.aboveThreshold(c, j)) {
            return Color.white;
        }
        if (Comparison.isGap(c)) {
            return Color.white;
        }
        Color currentColour = this.colors[ResidueProperties.aaIndex[c]];
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }

    public Color makeColour(float c) {
        return new Color(c, 0.0f, 1.0f - c);
    }
}

