/* foundry-git-commit-private.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <git2.h>

#include "foundry-git-commit.h"
#include "foundry-git-repository-paths-private.h"

G_BEGIN_DECLS

FoundryGitCommit *_foundry_git_commit_new         (git_commit                *commit,
                                                   GDestroyNotify             commit_destroy,
                                                   FoundryGitRepositoryPaths *paths);
void              _foundry_git_commit_get_oid     (FoundryGitCommit          *self,
                                                   git_oid                   *oid);
gboolean          _foundry_git_commit_get_tree_id (FoundryGitCommit          *self,
                                                   git_oid                   *tree_id);

G_END_DECLS
