---
date: 2026-02-19
section: 1
title: GOFMT
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

gofmt - format Go programs

# SYNOPSIS

**gofmt** \[*flags*\] \[*path ...*\]

# DESCRIPTION

Gofmt formats Go programs. It uses tabs for indentation and blanks for
alignment. Alignment assumes that an editor is using a fixed-width font.

Without an explicit path, it processes the standard input. Given a file,
it operates on that file; given a directory, it operates on all .go
files in that directory, recursively. (Files starting with a period are
ignored.) By default, gofmt prints the reformatted sources to standard
output.

# OPTIONS

**-cpuprofile** *string*

:   write cpu profile to this file

**-d**

:   display diffs instead of rewriting files

**-e**

:   report all errors (not just the first 10 on different lines)

**-l**

:   list files whose formatting differs from gofmt's

**-r** *string*

:   rewrite rule (e.g., 'a\[b:len(a)\] -\> a\[b:\]')

**-s**

:   simplify code

**-w**

:   write result to (source) file instead of stdout

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
