//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: ClientNamenodeProtocol.proto

package hadoop_hdfs

import (
	hadoop_common "github.com/colinmarc/hdfs/v2/internal/protocol/hadoop_common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateFlagProto int32

const (
	CreateFlagProto_CREATE           CreateFlagProto = 1   // Create a file
	CreateFlagProto_OVERWRITE        CreateFlagProto = 2   // Truncate/overwrite a file. Same as POSIX O_TRUNC
	CreateFlagProto_APPEND           CreateFlagProto = 4   // Append to a file
	CreateFlagProto_LAZY_PERSIST     CreateFlagProto = 16  // File with reduced durability guarantees.
	CreateFlagProto_NEW_BLOCK        CreateFlagProto = 32  // Write data to a new block when appending
	CreateFlagProto_SHOULD_REPLICATE CreateFlagProto = 128 // Enforce to create a replicate file
)

// Enum value maps for CreateFlagProto.
var (
	CreateFlagProto_name = map[int32]string{
		1:   "CREATE",
		2:   "OVERWRITE",
		4:   "APPEND",
		16:  "LAZY_PERSIST",
		32:  "NEW_BLOCK",
		128: "SHOULD_REPLICATE",
	}
	CreateFlagProto_value = map[string]int32{
		"CREATE":           1,
		"OVERWRITE":        2,
		"APPEND":           4,
		"LAZY_PERSIST":     16,
		"NEW_BLOCK":        32,
		"SHOULD_REPLICATE": 128,
	}
)

func (x CreateFlagProto) Enum() *CreateFlagProto {
	p := new(CreateFlagProto)
	*p = x
	return p
}

func (x CreateFlagProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateFlagProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[0].Descriptor()
}

func (CreateFlagProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[0]
}

func (x CreateFlagProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CreateFlagProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CreateFlagProto(num)
	return nil
}

// Deprecated: Use CreateFlagProto.Descriptor instead.
func (CreateFlagProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{0}
}

type AddBlockFlagProto int32

const (
	AddBlockFlagProto_NO_LOCAL_WRITE         AddBlockFlagProto = 1 // avoid writing to local node.
	AddBlockFlagProto_IGNORE_CLIENT_LOCALITY AddBlockFlagProto = 2 // write to a random node
)

// Enum value maps for AddBlockFlagProto.
var (
	AddBlockFlagProto_name = map[int32]string{
		1: "NO_LOCAL_WRITE",
		2: "IGNORE_CLIENT_LOCALITY",
	}
	AddBlockFlagProto_value = map[string]int32{
		"NO_LOCAL_WRITE":         1,
		"IGNORE_CLIENT_LOCALITY": 2,
	}
)

func (x AddBlockFlagProto) Enum() *AddBlockFlagProto {
	p := new(AddBlockFlagProto)
	*p = x
	return p
}

func (x AddBlockFlagProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddBlockFlagProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[1].Descriptor()
}

func (AddBlockFlagProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[1]
}

func (x AddBlockFlagProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *AddBlockFlagProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = AddBlockFlagProto(num)
	return nil
}

// Deprecated: Use AddBlockFlagProto.Descriptor instead.
func (AddBlockFlagProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{1}
}

type DatanodeReportTypeProto int32

const (
	DatanodeReportTypeProto_ALL                  DatanodeReportTypeProto = 1
	DatanodeReportTypeProto_LIVE                 DatanodeReportTypeProto = 2
	DatanodeReportTypeProto_DEAD                 DatanodeReportTypeProto = 3
	DatanodeReportTypeProto_DECOMMISSIONING      DatanodeReportTypeProto = 4
	DatanodeReportTypeProto_ENTERING_MAINTENANCE DatanodeReportTypeProto = 5
	DatanodeReportTypeProto_IN_MAINTENANCE       DatanodeReportTypeProto = 6
)

// Enum value maps for DatanodeReportTypeProto.
var (
	DatanodeReportTypeProto_name = map[int32]string{
		1: "ALL",
		2: "LIVE",
		3: "DEAD",
		4: "DECOMMISSIONING",
		5: "ENTERING_MAINTENANCE",
		6: "IN_MAINTENANCE",
	}
	DatanodeReportTypeProto_value = map[string]int32{
		"ALL":                  1,
		"LIVE":                 2,
		"DEAD":                 3,
		"DECOMMISSIONING":      4,
		"ENTERING_MAINTENANCE": 5,
		"IN_MAINTENANCE":       6,
	}
)

func (x DatanodeReportTypeProto) Enum() *DatanodeReportTypeProto {
	p := new(DatanodeReportTypeProto)
	*p = x
	return p
}

func (x DatanodeReportTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatanodeReportTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[2].Descriptor()
}

func (DatanodeReportTypeProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[2]
}

func (x DatanodeReportTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *DatanodeReportTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = DatanodeReportTypeProto(num)
	return nil
}

// Deprecated: Use DatanodeReportTypeProto.Descriptor instead.
func (DatanodeReportTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{2}
}

type SafeModeActionProto int32

const (
	SafeModeActionProto_SAFEMODE_LEAVE      SafeModeActionProto = 1
	SafeModeActionProto_SAFEMODE_ENTER      SafeModeActionProto = 2
	SafeModeActionProto_SAFEMODE_GET        SafeModeActionProto = 3
	SafeModeActionProto_SAFEMODE_FORCE_EXIT SafeModeActionProto = 4
)

// Enum value maps for SafeModeActionProto.
var (
	SafeModeActionProto_name = map[int32]string{
		1: "SAFEMODE_LEAVE",
		2: "SAFEMODE_ENTER",
		3: "SAFEMODE_GET",
		4: "SAFEMODE_FORCE_EXIT",
	}
	SafeModeActionProto_value = map[string]int32{
		"SAFEMODE_LEAVE":      1,
		"SAFEMODE_ENTER":      2,
		"SAFEMODE_GET":        3,
		"SAFEMODE_FORCE_EXIT": 4,
	}
)

func (x SafeModeActionProto) Enum() *SafeModeActionProto {
	p := new(SafeModeActionProto)
	*p = x
	return p
}

func (x SafeModeActionProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafeModeActionProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[3].Descriptor()
}

func (SafeModeActionProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[3]
}

func (x SafeModeActionProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SafeModeActionProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SafeModeActionProto(num)
	return nil
}

// Deprecated: Use SafeModeActionProto.Descriptor instead.
func (SafeModeActionProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{3}
}

type RollingUpgradeActionProto int32

const (
	RollingUpgradeActionProto_QUERY    RollingUpgradeActionProto = 1
	RollingUpgradeActionProto_START    RollingUpgradeActionProto = 2
	RollingUpgradeActionProto_FINALIZE RollingUpgradeActionProto = 3
)

// Enum value maps for RollingUpgradeActionProto.
var (
	RollingUpgradeActionProto_name = map[int32]string{
		1: "QUERY",
		2: "START",
		3: "FINALIZE",
	}
	RollingUpgradeActionProto_value = map[string]int32{
		"QUERY":    1,
		"START":    2,
		"FINALIZE": 3,
	}
)

func (x RollingUpgradeActionProto) Enum() *RollingUpgradeActionProto {
	p := new(RollingUpgradeActionProto)
	*p = x
	return p
}

func (x RollingUpgradeActionProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RollingUpgradeActionProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[4].Descriptor()
}

func (RollingUpgradeActionProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[4]
}

func (x RollingUpgradeActionProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RollingUpgradeActionProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RollingUpgradeActionProto(num)
	return nil
}

// Deprecated: Use RollingUpgradeActionProto.Descriptor instead.
func (RollingUpgradeActionProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{4}
}

type CacheFlagProto int32

const (
	CacheFlagProto_FORCE CacheFlagProto = 1 // Ignore pool resource limits
)

// Enum value maps for CacheFlagProto.
var (
	CacheFlagProto_name = map[int32]string{
		1: "FORCE",
	}
	CacheFlagProto_value = map[string]int32{
		"FORCE": 1,
	}
)

func (x CacheFlagProto) Enum() *CacheFlagProto {
	p := new(CacheFlagProto)
	*p = x
	return p
}

func (x CacheFlagProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CacheFlagProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[5].Descriptor()
}

func (CacheFlagProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[5]
}

func (x CacheFlagProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CacheFlagProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CacheFlagProto(num)
	return nil
}

// Deprecated: Use CacheFlagProto.Descriptor instead.
func (CacheFlagProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{5}
}

type OpenFilesTypeProto int32

const (
	OpenFilesTypeProto_ALL_OPEN_FILES        OpenFilesTypeProto = 1
	OpenFilesTypeProto_BLOCKING_DECOMMISSION OpenFilesTypeProto = 2
)

// Enum value maps for OpenFilesTypeProto.
var (
	OpenFilesTypeProto_name = map[int32]string{
		1: "ALL_OPEN_FILES",
		2: "BLOCKING_DECOMMISSION",
	}
	OpenFilesTypeProto_value = map[string]int32{
		"ALL_OPEN_FILES":        1,
		"BLOCKING_DECOMMISSION": 2,
	}
)

func (x OpenFilesTypeProto) Enum() *OpenFilesTypeProto {
	p := new(OpenFilesTypeProto)
	*p = x
	return p
}

func (x OpenFilesTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpenFilesTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_ClientNamenodeProtocol_proto_enumTypes[6].Descriptor()
}

func (OpenFilesTypeProto) Type() protoreflect.EnumType {
	return &file_ClientNamenodeProtocol_proto_enumTypes[6]
}

func (x OpenFilesTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *OpenFilesTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = OpenFilesTypeProto(num)
	return nil
}

// Deprecated: Use OpenFilesTypeProto.Descriptor instead.
func (OpenFilesTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{6}
}

type GetBlockLocationsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src    *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`        // file name
	Offset *uint64 `protobuf:"varint,2,req,name=offset" json:"offset,omitempty"` // range start offset
	Length *uint64 `protobuf:"varint,3,req,name=length" json:"length,omitempty"` // range length
}

func (x *GetBlockLocationsRequestProto) Reset() {
	*x = GetBlockLocationsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBlockLocationsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBlockLocationsRequestProto) ProtoMessage() {}

func (x *GetBlockLocationsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBlockLocationsRequestProto.ProtoReflect.Descriptor instead.
func (*GetBlockLocationsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{0}
}

func (x *GetBlockLocationsRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *GetBlockLocationsRequestProto) GetOffset() uint64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *GetBlockLocationsRequestProto) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

type GetBlockLocationsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Locations *LocatedBlocksProto `protobuf:"bytes,1,opt,name=locations" json:"locations,omitempty"`
}

func (x *GetBlockLocationsResponseProto) Reset() {
	*x = GetBlockLocationsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBlockLocationsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBlockLocationsResponseProto) ProtoMessage() {}

func (x *GetBlockLocationsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBlockLocationsResponseProto.ProtoReflect.Descriptor instead.
func (*GetBlockLocationsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{1}
}

func (x *GetBlockLocationsResponseProto) GetLocations() *LocatedBlocksProto {
	if x != nil {
		return x.Locations
	}
	return nil
}

type GetServerDefaultsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetServerDefaultsRequestProto) Reset() {
	*x = GetServerDefaultsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServerDefaultsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServerDefaultsRequestProto) ProtoMessage() {}

func (x *GetServerDefaultsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServerDefaultsRequestProto.ProtoReflect.Descriptor instead.
func (*GetServerDefaultsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{2}
}

type GetServerDefaultsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServerDefaults *FsServerDefaultsProto `protobuf:"bytes,1,req,name=serverDefaults" json:"serverDefaults,omitempty"`
}

func (x *GetServerDefaultsResponseProto) Reset() {
	*x = GetServerDefaultsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServerDefaultsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServerDefaultsResponseProto) ProtoMessage() {}

func (x *GetServerDefaultsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServerDefaultsResponseProto.ProtoReflect.Descriptor instead.
func (*GetServerDefaultsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{3}
}

func (x *GetServerDefaultsResponseProto) GetServerDefaults() *FsServerDefaultsProto {
	if x != nil {
		return x.ServerDefaults
	}
	return nil
}

type CreateRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src                   *string                      `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Masked                *FsPermissionProto           `protobuf:"bytes,2,req,name=masked" json:"masked,omitempty"`
	ClientName            *string                      `protobuf:"bytes,3,req,name=clientName" json:"clientName,omitempty"`
	CreateFlag            *uint32                      `protobuf:"varint,4,req,name=createFlag" json:"createFlag,omitempty"` // bits set using CreateFlag
	CreateParent          *bool                        `protobuf:"varint,5,req,name=createParent" json:"createParent,omitempty"`
	Replication           *uint32                      `protobuf:"varint,6,req,name=replication" json:"replication,omitempty"` // Short: Only 16 bits used
	BlockSize             *uint64                      `protobuf:"varint,7,req,name=blockSize" json:"blockSize,omitempty"`
	CryptoProtocolVersion []CryptoProtocolVersionProto `protobuf:"varint,8,rep,name=cryptoProtocolVersion,enum=hadoop.hdfs.CryptoProtocolVersionProto" json:"cryptoProtocolVersion,omitempty"`
	Unmasked              *FsPermissionProto           `protobuf:"bytes,9,opt,name=unmasked" json:"unmasked,omitempty"`
	EcPolicyName          *string                      `protobuf:"bytes,10,opt,name=ecPolicyName" json:"ecPolicyName,omitempty"`
	StoragePolicy         *string                      `protobuf:"bytes,11,opt,name=storagePolicy" json:"storagePolicy,omitempty"`
}

func (x *CreateRequestProto) Reset() {
	*x = CreateRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRequestProto) ProtoMessage() {}

func (x *CreateRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRequestProto.ProtoReflect.Descriptor instead.
func (*CreateRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{4}
}

func (x *CreateRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *CreateRequestProto) GetMasked() *FsPermissionProto {
	if x != nil {
		return x.Masked
	}
	return nil
}

func (x *CreateRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *CreateRequestProto) GetCreateFlag() uint32 {
	if x != nil && x.CreateFlag != nil {
		return *x.CreateFlag
	}
	return 0
}

func (x *CreateRequestProto) GetCreateParent() bool {
	if x != nil && x.CreateParent != nil {
		return *x.CreateParent
	}
	return false
}

func (x *CreateRequestProto) GetReplication() uint32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

func (x *CreateRequestProto) GetBlockSize() uint64 {
	if x != nil && x.BlockSize != nil {
		return *x.BlockSize
	}
	return 0
}

func (x *CreateRequestProto) GetCryptoProtocolVersion() []CryptoProtocolVersionProto {
	if x != nil {
		return x.CryptoProtocolVersion
	}
	return nil
}

func (x *CreateRequestProto) GetUnmasked() *FsPermissionProto {
	if x != nil {
		return x.Unmasked
	}
	return nil
}

func (x *CreateRequestProto) GetEcPolicyName() string {
	if x != nil && x.EcPolicyName != nil {
		return *x.EcPolicyName
	}
	return ""
}

func (x *CreateRequestProto) GetStoragePolicy() string {
	if x != nil && x.StoragePolicy != nil {
		return *x.StoragePolicy
	}
	return ""
}

type CreateResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fs *HdfsFileStatusProto `protobuf:"bytes,1,opt,name=fs" json:"fs,omitempty"`
}

func (x *CreateResponseProto) Reset() {
	*x = CreateResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateResponseProto) ProtoMessage() {}

func (x *CreateResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateResponseProto.ProtoReflect.Descriptor instead.
func (*CreateResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{5}
}

func (x *CreateResponseProto) GetFs() *HdfsFileStatusProto {
	if x != nil {
		return x.Fs
	}
	return nil
}

type AppendRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	ClientName *string `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
	Flag       *uint32 `protobuf:"varint,3,opt,name=flag" json:"flag,omitempty"` // bits set using CreateFlag
}

func (x *AppendRequestProto) Reset() {
	*x = AppendRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRequestProto) ProtoMessage() {}

func (x *AppendRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRequestProto.ProtoReflect.Descriptor instead.
func (*AppendRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{6}
}

func (x *AppendRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *AppendRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *AppendRequestProto) GetFlag() uint32 {
	if x != nil && x.Flag != nil {
		return *x.Flag
	}
	return 0
}

type AppendResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *LocatedBlockProto   `protobuf:"bytes,1,opt,name=block" json:"block,omitempty"`
	Stat  *HdfsFileStatusProto `protobuf:"bytes,2,opt,name=stat" json:"stat,omitempty"`
}

func (x *AppendResponseProto) Reset() {
	*x = AppendResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendResponseProto) ProtoMessage() {}

func (x *AppendResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendResponseProto.ProtoReflect.Descriptor instead.
func (*AppendResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{7}
}

func (x *AppendResponseProto) GetBlock() *LocatedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *AppendResponseProto) GetStat() *HdfsFileStatusProto {
	if x != nil {
		return x.Stat
	}
	return nil
}

type SetReplicationRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src         *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Replication *uint32 `protobuf:"varint,2,req,name=replication" json:"replication,omitempty"` // Short: Only 16 bits used
}

func (x *SetReplicationRequestProto) Reset() {
	*x = SetReplicationRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetReplicationRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetReplicationRequestProto) ProtoMessage() {}

func (x *SetReplicationRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetReplicationRequestProto.ProtoReflect.Descriptor instead.
func (*SetReplicationRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{8}
}

func (x *SetReplicationRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *SetReplicationRequestProto) GetReplication() uint32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

type SetReplicationResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *SetReplicationResponseProto) Reset() {
	*x = SetReplicationResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetReplicationResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetReplicationResponseProto) ProtoMessage() {}

func (x *SetReplicationResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetReplicationResponseProto.ProtoReflect.Descriptor instead.
func (*SetReplicationResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{9}
}

func (x *SetReplicationResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type SetStoragePolicyRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	PolicyName *string `protobuf:"bytes,2,req,name=policyName" json:"policyName,omitempty"`
}

func (x *SetStoragePolicyRequestProto) Reset() {
	*x = SetStoragePolicyRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetStoragePolicyRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStoragePolicyRequestProto) ProtoMessage() {}

func (x *SetStoragePolicyRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetStoragePolicyRequestProto.ProtoReflect.Descriptor instead.
func (*SetStoragePolicyRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{10}
}

func (x *SetStoragePolicyRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *SetStoragePolicyRequestProto) GetPolicyName() string {
	if x != nil && x.PolicyName != nil {
		return *x.PolicyName
	}
	return ""
}

type SetStoragePolicyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetStoragePolicyResponseProto) Reset() {
	*x = SetStoragePolicyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetStoragePolicyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStoragePolicyResponseProto) ProtoMessage() {}

func (x *SetStoragePolicyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetStoragePolicyResponseProto.ProtoReflect.Descriptor instead.
func (*SetStoragePolicyResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{11}
}

type UnsetStoragePolicyRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *UnsetStoragePolicyRequestProto) Reset() {
	*x = UnsetStoragePolicyRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnsetStoragePolicyRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnsetStoragePolicyRequestProto) ProtoMessage() {}

func (x *UnsetStoragePolicyRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnsetStoragePolicyRequestProto.ProtoReflect.Descriptor instead.
func (*UnsetStoragePolicyRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{12}
}

func (x *UnsetStoragePolicyRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type UnsetStoragePolicyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnsetStoragePolicyResponseProto) Reset() {
	*x = UnsetStoragePolicyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnsetStoragePolicyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnsetStoragePolicyResponseProto) ProtoMessage() {}

func (x *UnsetStoragePolicyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnsetStoragePolicyResponseProto.ProtoReflect.Descriptor instead.
func (*UnsetStoragePolicyResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{13}
}

type GetStoragePolicyRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
}

func (x *GetStoragePolicyRequestProto) Reset() {
	*x = GetStoragePolicyRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoragePolicyRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoragePolicyRequestProto) ProtoMessage() {}

func (x *GetStoragePolicyRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoragePolicyRequestProto.ProtoReflect.Descriptor instead.
func (*GetStoragePolicyRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{14}
}

func (x *GetStoragePolicyRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

type GetStoragePolicyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoragePolicy *BlockStoragePolicyProto `protobuf:"bytes,1,req,name=storagePolicy" json:"storagePolicy,omitempty"`
}

func (x *GetStoragePolicyResponseProto) Reset() {
	*x = GetStoragePolicyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoragePolicyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoragePolicyResponseProto) ProtoMessage() {}

func (x *GetStoragePolicyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoragePolicyResponseProto.ProtoReflect.Descriptor instead.
func (*GetStoragePolicyResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{15}
}

func (x *GetStoragePolicyResponseProto) GetStoragePolicy() *BlockStoragePolicyProto {
	if x != nil {
		return x.StoragePolicy
	}
	return nil
}

type GetStoragePoliciesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetStoragePoliciesRequestProto) Reset() {
	*x = GetStoragePoliciesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoragePoliciesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoragePoliciesRequestProto) ProtoMessage() {}

func (x *GetStoragePoliciesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoragePoliciesRequestProto.ProtoReflect.Descriptor instead.
func (*GetStoragePoliciesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{16}
}

type GetStoragePoliciesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policies []*BlockStoragePolicyProto `protobuf:"bytes,1,rep,name=policies" json:"policies,omitempty"`
}

func (x *GetStoragePoliciesResponseProto) Reset() {
	*x = GetStoragePoliciesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoragePoliciesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoragePoliciesResponseProto) ProtoMessage() {}

func (x *GetStoragePoliciesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoragePoliciesResponseProto.ProtoReflect.Descriptor instead.
func (*GetStoragePoliciesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{17}
}

func (x *GetStoragePoliciesResponseProto) GetPolicies() []*BlockStoragePolicyProto {
	if x != nil {
		return x.Policies
	}
	return nil
}

type SetPermissionRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string            `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Permission *FsPermissionProto `protobuf:"bytes,2,req,name=permission" json:"permission,omitempty"`
}

func (x *SetPermissionRequestProto) Reset() {
	*x = SetPermissionRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPermissionRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPermissionRequestProto) ProtoMessage() {}

func (x *SetPermissionRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPermissionRequestProto.ProtoReflect.Descriptor instead.
func (*SetPermissionRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{18}
}

func (x *SetPermissionRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *SetPermissionRequestProto) GetPermission() *FsPermissionProto {
	if x != nil {
		return x.Permission
	}
	return nil
}

type SetPermissionResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetPermissionResponseProto) Reset() {
	*x = SetPermissionResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPermissionResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPermissionResponseProto) ProtoMessage() {}

func (x *SetPermissionResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPermissionResponseProto.ProtoReflect.Descriptor instead.
func (*SetPermissionResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{19}
}

type SetOwnerRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src       *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Username  *string `protobuf:"bytes,2,opt,name=username" json:"username,omitempty"`
	Groupname *string `protobuf:"bytes,3,opt,name=groupname" json:"groupname,omitempty"`
}

func (x *SetOwnerRequestProto) Reset() {
	*x = SetOwnerRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetOwnerRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOwnerRequestProto) ProtoMessage() {}

func (x *SetOwnerRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetOwnerRequestProto.ProtoReflect.Descriptor instead.
func (*SetOwnerRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{20}
}

func (x *SetOwnerRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *SetOwnerRequestProto) GetUsername() string {
	if x != nil && x.Username != nil {
		return *x.Username
	}
	return ""
}

func (x *SetOwnerRequestProto) GetGroupname() string {
	if x != nil && x.Groupname != nil {
		return *x.Groupname
	}
	return ""
}

type SetOwnerResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetOwnerResponseProto) Reset() {
	*x = SetOwnerResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetOwnerResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOwnerResponseProto) ProtoMessage() {}

func (x *SetOwnerResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetOwnerResponseProto.ProtoReflect.Descriptor instead.
func (*SetOwnerResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{21}
}

type AbandonBlockRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	B      *ExtendedBlockProto `protobuf:"bytes,1,req,name=b" json:"b,omitempty"`
	Src    *string             `protobuf:"bytes,2,req,name=src" json:"src,omitempty"`
	Holder *string             `protobuf:"bytes,3,req,name=holder" json:"holder,omitempty"`
	FileId *uint64             `protobuf:"varint,4,opt,name=fileId,def=0" json:"fileId,omitempty"` // default to GRANDFATHER_INODE_ID
}

// Default values for AbandonBlockRequestProto fields.
const (
	Default_AbandonBlockRequestProto_FileId = uint64(0)
)

func (x *AbandonBlockRequestProto) Reset() {
	*x = AbandonBlockRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonBlockRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonBlockRequestProto) ProtoMessage() {}

func (x *AbandonBlockRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonBlockRequestProto.ProtoReflect.Descriptor instead.
func (*AbandonBlockRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{22}
}

func (x *AbandonBlockRequestProto) GetB() *ExtendedBlockProto {
	if x != nil {
		return x.B
	}
	return nil
}

func (x *AbandonBlockRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *AbandonBlockRequestProto) GetHolder() string {
	if x != nil && x.Holder != nil {
		return *x.Holder
	}
	return ""
}

func (x *AbandonBlockRequestProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_AbandonBlockRequestProto_FileId
}

type AbandonBlockResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AbandonBlockResponseProto) Reset() {
	*x = AbandonBlockResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonBlockResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonBlockResponseProto) ProtoMessage() {}

func (x *AbandonBlockResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonBlockResponseProto.ProtoReflect.Descriptor instead.
func (*AbandonBlockResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{23}
}

type AddBlockRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src          *string              `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	ClientName   *string              `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
	Previous     *ExtendedBlockProto  `protobuf:"bytes,3,opt,name=previous" json:"previous,omitempty"`
	ExcludeNodes []*DatanodeInfoProto `protobuf:"bytes,4,rep,name=excludeNodes" json:"excludeNodes,omitempty"`
	FileId       *uint64              `protobuf:"varint,5,opt,name=fileId,def=0" json:"fileId,omitempty"`                            // default as a bogus id
	FavoredNodes []string             `protobuf:"bytes,6,rep,name=favoredNodes" json:"favoredNodes,omitempty"`                       //the set of datanodes to use for the block
	Flags        []AddBlockFlagProto  `protobuf:"varint,7,rep,name=flags,enum=hadoop.hdfs.AddBlockFlagProto" json:"flags,omitempty"` // default to empty.
}

// Default values for AddBlockRequestProto fields.
const (
	Default_AddBlockRequestProto_FileId = uint64(0)
)

func (x *AddBlockRequestProto) Reset() {
	*x = AddBlockRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBlockRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBlockRequestProto) ProtoMessage() {}

func (x *AddBlockRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBlockRequestProto.ProtoReflect.Descriptor instead.
func (*AddBlockRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{24}
}

func (x *AddBlockRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *AddBlockRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *AddBlockRequestProto) GetPrevious() *ExtendedBlockProto {
	if x != nil {
		return x.Previous
	}
	return nil
}

func (x *AddBlockRequestProto) GetExcludeNodes() []*DatanodeInfoProto {
	if x != nil {
		return x.ExcludeNodes
	}
	return nil
}

func (x *AddBlockRequestProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_AddBlockRequestProto_FileId
}

func (x *AddBlockRequestProto) GetFavoredNodes() []string {
	if x != nil {
		return x.FavoredNodes
	}
	return nil
}

func (x *AddBlockRequestProto) GetFlags() []AddBlockFlagProto {
	if x != nil {
		return x.Flags
	}
	return nil
}

type AddBlockResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *LocatedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
}

func (x *AddBlockResponseProto) Reset() {
	*x = AddBlockResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBlockResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBlockResponseProto) ProtoMessage() {}

func (x *AddBlockResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBlockResponseProto.ProtoReflect.Descriptor instead.
func (*AddBlockResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{25}
}

func (x *AddBlockResponseProto) GetBlock() *LocatedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

type GetAdditionalDatanodeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src                  *string              `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Blk                  *ExtendedBlockProto  `protobuf:"bytes,2,req,name=blk" json:"blk,omitempty"`
	Existings            []*DatanodeInfoProto `protobuf:"bytes,3,rep,name=existings" json:"existings,omitempty"`
	Excludes             []*DatanodeInfoProto `protobuf:"bytes,4,rep,name=excludes" json:"excludes,omitempty"`
	NumAdditionalNodes   *uint32              `protobuf:"varint,5,req,name=numAdditionalNodes" json:"numAdditionalNodes,omitempty"`
	ClientName           *string              `protobuf:"bytes,6,req,name=clientName" json:"clientName,omitempty"`
	ExistingStorageUuids []string             `protobuf:"bytes,7,rep,name=existingStorageUuids" json:"existingStorageUuids,omitempty"`
	FileId               *uint64              `protobuf:"varint,8,opt,name=fileId,def=0" json:"fileId,omitempty"` // default to GRANDFATHER_INODE_ID
}

// Default values for GetAdditionalDatanodeRequestProto fields.
const (
	Default_GetAdditionalDatanodeRequestProto_FileId = uint64(0)
)

func (x *GetAdditionalDatanodeRequestProto) Reset() {
	*x = GetAdditionalDatanodeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdditionalDatanodeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdditionalDatanodeRequestProto) ProtoMessage() {}

func (x *GetAdditionalDatanodeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdditionalDatanodeRequestProto.ProtoReflect.Descriptor instead.
func (*GetAdditionalDatanodeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{26}
}

func (x *GetAdditionalDatanodeRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *GetAdditionalDatanodeRequestProto) GetBlk() *ExtendedBlockProto {
	if x != nil {
		return x.Blk
	}
	return nil
}

func (x *GetAdditionalDatanodeRequestProto) GetExistings() []*DatanodeInfoProto {
	if x != nil {
		return x.Existings
	}
	return nil
}

func (x *GetAdditionalDatanodeRequestProto) GetExcludes() []*DatanodeInfoProto {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *GetAdditionalDatanodeRequestProto) GetNumAdditionalNodes() uint32 {
	if x != nil && x.NumAdditionalNodes != nil {
		return *x.NumAdditionalNodes
	}
	return 0
}

func (x *GetAdditionalDatanodeRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *GetAdditionalDatanodeRequestProto) GetExistingStorageUuids() []string {
	if x != nil {
		return x.ExistingStorageUuids
	}
	return nil
}

func (x *GetAdditionalDatanodeRequestProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_GetAdditionalDatanodeRequestProto_FileId
}

type GetAdditionalDatanodeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *LocatedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
}

func (x *GetAdditionalDatanodeResponseProto) Reset() {
	*x = GetAdditionalDatanodeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdditionalDatanodeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdditionalDatanodeResponseProto) ProtoMessage() {}

func (x *GetAdditionalDatanodeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdditionalDatanodeResponseProto.ProtoReflect.Descriptor instead.
func (*GetAdditionalDatanodeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{27}
}

func (x *GetAdditionalDatanodeResponseProto) GetBlock() *LocatedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

type CompleteRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string             `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	ClientName *string             `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
	Last       *ExtendedBlockProto `protobuf:"bytes,3,opt,name=last" json:"last,omitempty"`
	FileId     *uint64             `protobuf:"varint,4,opt,name=fileId,def=0" json:"fileId,omitempty"` // default to GRANDFATHER_INODE_ID
}

// Default values for CompleteRequestProto fields.
const (
	Default_CompleteRequestProto_FileId = uint64(0)
)

func (x *CompleteRequestProto) Reset() {
	*x = CompleteRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteRequestProto) ProtoMessage() {}

func (x *CompleteRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteRequestProto.ProtoReflect.Descriptor instead.
func (*CompleteRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{28}
}

func (x *CompleteRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *CompleteRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *CompleteRequestProto) GetLast() *ExtendedBlockProto {
	if x != nil {
		return x.Last
	}
	return nil
}

func (x *CompleteRequestProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_CompleteRequestProto_FileId
}

type CompleteResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *CompleteResponseProto) Reset() {
	*x = CompleteResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteResponseProto) ProtoMessage() {}

func (x *CompleteResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteResponseProto.ProtoReflect.Descriptor instead.
func (*CompleteResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{29}
}

func (x *CompleteResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type ReportBadBlocksRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Blocks []*LocatedBlockProto `protobuf:"bytes,1,rep,name=blocks" json:"blocks,omitempty"`
}

func (x *ReportBadBlocksRequestProto) Reset() {
	*x = ReportBadBlocksRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBadBlocksRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBadBlocksRequestProto) ProtoMessage() {}

func (x *ReportBadBlocksRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBadBlocksRequestProto.ProtoReflect.Descriptor instead.
func (*ReportBadBlocksRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{30}
}

func (x *ReportBadBlocksRequestProto) GetBlocks() []*LocatedBlockProto {
	if x != nil {
		return x.Blocks
	}
	return nil
}

type ReportBadBlocksResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportBadBlocksResponseProto) Reset() {
	*x = ReportBadBlocksResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBadBlocksResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBadBlocksResponseProto) ProtoMessage() {}

func (x *ReportBadBlocksResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBadBlocksResponseProto.ProtoReflect.Descriptor instead.
func (*ReportBadBlocksResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{31}
}

type ConcatRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Trg  *string  `protobuf:"bytes,1,req,name=trg" json:"trg,omitempty"`
	Srcs []string `protobuf:"bytes,2,rep,name=srcs" json:"srcs,omitempty"`
}

func (x *ConcatRequestProto) Reset() {
	*x = ConcatRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcatRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcatRequestProto) ProtoMessage() {}

func (x *ConcatRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcatRequestProto.ProtoReflect.Descriptor instead.
func (*ConcatRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{32}
}

func (x *ConcatRequestProto) GetTrg() string {
	if x != nil && x.Trg != nil {
		return *x.Trg
	}
	return ""
}

func (x *ConcatRequestProto) GetSrcs() []string {
	if x != nil {
		return x.Srcs
	}
	return nil
}

type ConcatResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ConcatResponseProto) Reset() {
	*x = ConcatResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcatResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcatResponseProto) ProtoMessage() {}

func (x *ConcatResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcatResponseProto.ProtoReflect.Descriptor instead.
func (*ConcatResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{33}
}

type TruncateRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	NewLength  *uint64 `protobuf:"varint,2,req,name=newLength" json:"newLength,omitempty"`
	ClientName *string `protobuf:"bytes,3,req,name=clientName" json:"clientName,omitempty"`
}

func (x *TruncateRequestProto) Reset() {
	*x = TruncateRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncateRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncateRequestProto) ProtoMessage() {}

func (x *TruncateRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncateRequestProto.ProtoReflect.Descriptor instead.
func (*TruncateRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{34}
}

func (x *TruncateRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *TruncateRequestProto) GetNewLength() uint64 {
	if x != nil && x.NewLength != nil {
		return *x.NewLength
	}
	return 0
}

func (x *TruncateRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

type TruncateResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *TruncateResponseProto) Reset() {
	*x = TruncateResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncateResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncateResponseProto) ProtoMessage() {}

func (x *TruncateResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncateResponseProto.ProtoReflect.Descriptor instead.
func (*TruncateResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{35}
}

func (x *TruncateResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type RenameRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Dst *string `protobuf:"bytes,2,req,name=dst" json:"dst,omitempty"`
}

func (x *RenameRequestProto) Reset() {
	*x = RenameRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameRequestProto) ProtoMessage() {}

func (x *RenameRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameRequestProto.ProtoReflect.Descriptor instead.
func (*RenameRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{36}
}

func (x *RenameRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *RenameRequestProto) GetDst() string {
	if x != nil && x.Dst != nil {
		return *x.Dst
	}
	return ""
}

type RenameResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *RenameResponseProto) Reset() {
	*x = RenameResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameResponseProto) ProtoMessage() {}

func (x *RenameResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameResponseProto.ProtoReflect.Descriptor instead.
func (*RenameResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{37}
}

func (x *RenameResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type Rename2RequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src           *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Dst           *string `protobuf:"bytes,2,req,name=dst" json:"dst,omitempty"`
	OverwriteDest *bool   `protobuf:"varint,3,req,name=overwriteDest" json:"overwriteDest,omitempty"`
	MoveToTrash   *bool   `protobuf:"varint,4,opt,name=moveToTrash" json:"moveToTrash,omitempty"`
}

func (x *Rename2RequestProto) Reset() {
	*x = Rename2RequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rename2RequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rename2RequestProto) ProtoMessage() {}

func (x *Rename2RequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rename2RequestProto.ProtoReflect.Descriptor instead.
func (*Rename2RequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{38}
}

func (x *Rename2RequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *Rename2RequestProto) GetDst() string {
	if x != nil && x.Dst != nil {
		return *x.Dst
	}
	return ""
}

func (x *Rename2RequestProto) GetOverwriteDest() bool {
	if x != nil && x.OverwriteDest != nil {
		return *x.OverwriteDest
	}
	return false
}

func (x *Rename2RequestProto) GetMoveToTrash() bool {
	if x != nil && x.MoveToTrash != nil {
		return *x.MoveToTrash
	}
	return false
}

type Rename2ResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Rename2ResponseProto) Reset() {
	*x = Rename2ResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rename2ResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rename2ResponseProto) ProtoMessage() {}

func (x *Rename2ResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rename2ResponseProto.ProtoReflect.Descriptor instead.
func (*Rename2ResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{39}
}

type DeleteRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src       *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Recursive *bool   `protobuf:"varint,2,req,name=recursive" json:"recursive,omitempty"`
}

func (x *DeleteRequestProto) Reset() {
	*x = DeleteRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRequestProto) ProtoMessage() {}

func (x *DeleteRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRequestProto.ProtoReflect.Descriptor instead.
func (*DeleteRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{40}
}

func (x *DeleteRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *DeleteRequestProto) GetRecursive() bool {
	if x != nil && x.Recursive != nil {
		return *x.Recursive
	}
	return false
}

type DeleteResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *DeleteResponseProto) Reset() {
	*x = DeleteResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteResponseProto) ProtoMessage() {}

func (x *DeleteResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteResponseProto.ProtoReflect.Descriptor instead.
func (*DeleteResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{41}
}

func (x *DeleteResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type MkdirsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src          *string            `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Masked       *FsPermissionProto `protobuf:"bytes,2,req,name=masked" json:"masked,omitempty"`
	CreateParent *bool              `protobuf:"varint,3,req,name=createParent" json:"createParent,omitempty"`
	Unmasked     *FsPermissionProto `protobuf:"bytes,4,opt,name=unmasked" json:"unmasked,omitempty"`
}

func (x *MkdirsRequestProto) Reset() {
	*x = MkdirsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MkdirsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MkdirsRequestProto) ProtoMessage() {}

func (x *MkdirsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MkdirsRequestProto.ProtoReflect.Descriptor instead.
func (*MkdirsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{42}
}

func (x *MkdirsRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *MkdirsRequestProto) GetMasked() *FsPermissionProto {
	if x != nil {
		return x.Masked
	}
	return nil
}

func (x *MkdirsRequestProto) GetCreateParent() bool {
	if x != nil && x.CreateParent != nil {
		return *x.CreateParent
	}
	return false
}

func (x *MkdirsRequestProto) GetUnmasked() *FsPermissionProto {
	if x != nil {
		return x.Unmasked
	}
	return nil
}

type MkdirsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *MkdirsResponseProto) Reset() {
	*x = MkdirsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MkdirsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MkdirsResponseProto) ProtoMessage() {}

func (x *MkdirsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MkdirsResponseProto.ProtoReflect.Descriptor instead.
func (*MkdirsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{43}
}

func (x *MkdirsResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type GetListingRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src          *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	StartAfter   []byte  `protobuf:"bytes,2,req,name=startAfter" json:"startAfter,omitempty"`
	NeedLocation *bool   `protobuf:"varint,3,req,name=needLocation" json:"needLocation,omitempty"`
}

func (x *GetListingRequestProto) Reset() {
	*x = GetListingRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetListingRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetListingRequestProto) ProtoMessage() {}

func (x *GetListingRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetListingRequestProto.ProtoReflect.Descriptor instead.
func (*GetListingRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{44}
}

func (x *GetListingRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *GetListingRequestProto) GetStartAfter() []byte {
	if x != nil {
		return x.StartAfter
	}
	return nil
}

func (x *GetListingRequestProto) GetNeedLocation() bool {
	if x != nil && x.NeedLocation != nil {
		return *x.NeedLocation
	}
	return false
}

type GetListingResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DirList *DirectoryListingProto `protobuf:"bytes,1,opt,name=dirList" json:"dirList,omitempty"`
}

func (x *GetListingResponseProto) Reset() {
	*x = GetListingResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetListingResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetListingResponseProto) ProtoMessage() {}

func (x *GetListingResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetListingResponseProto.ProtoReflect.Descriptor instead.
func (*GetListingResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{45}
}

func (x *GetListingResponseProto) GetDirList() *DirectoryListingProto {
	if x != nil {
		return x.DirList
	}
	return nil
}

type GetBatchedListingRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Paths        []string `protobuf:"bytes,1,rep,name=paths" json:"paths,omitempty"`
	StartAfter   []byte   `protobuf:"bytes,2,req,name=startAfter" json:"startAfter,omitempty"`
	NeedLocation *bool    `protobuf:"varint,3,req,name=needLocation" json:"needLocation,omitempty"`
}

func (x *GetBatchedListingRequestProto) Reset() {
	*x = GetBatchedListingRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBatchedListingRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBatchedListingRequestProto) ProtoMessage() {}

func (x *GetBatchedListingRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBatchedListingRequestProto.ProtoReflect.Descriptor instead.
func (*GetBatchedListingRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{46}
}

func (x *GetBatchedListingRequestProto) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *GetBatchedListingRequestProto) GetStartAfter() []byte {
	if x != nil {
		return x.StartAfter
	}
	return nil
}

func (x *GetBatchedListingRequestProto) GetNeedLocation() bool {
	if x != nil && x.NeedLocation != nil {
		return *x.NeedLocation
	}
	return false
}

type GetBatchedListingResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Listings   []*BatchedDirectoryListingProto `protobuf:"bytes,1,rep,name=listings" json:"listings,omitempty"`
	HasMore    *bool                           `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
	StartAfter []byte                          `protobuf:"bytes,3,req,name=startAfter" json:"startAfter,omitempty"`
}

func (x *GetBatchedListingResponseProto) Reset() {
	*x = GetBatchedListingResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBatchedListingResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBatchedListingResponseProto) ProtoMessage() {}

func (x *GetBatchedListingResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBatchedListingResponseProto.ProtoReflect.Descriptor instead.
func (*GetBatchedListingResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{47}
}

func (x *GetBatchedListingResponseProto) GetListings() []*BatchedDirectoryListingProto {
	if x != nil {
		return x.Listings
	}
	return nil
}

func (x *GetBatchedListingResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

func (x *GetBatchedListingResponseProto) GetStartAfter() []byte {
	if x != nil {
		return x.StartAfter
	}
	return nil
}

type GetSnapshottableDirListingRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetSnapshottableDirListingRequestProto) Reset() {
	*x = GetSnapshottableDirListingRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshottableDirListingRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshottableDirListingRequestProto) ProtoMessage() {}

func (x *GetSnapshottableDirListingRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshottableDirListingRequestProto.ProtoReflect.Descriptor instead.
func (*GetSnapshottableDirListingRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{48}
}

type GetSnapshottableDirListingResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshottableDirList *SnapshottableDirectoryListingProto `protobuf:"bytes,1,opt,name=snapshottableDirList" json:"snapshottableDirList,omitempty"`
}

func (x *GetSnapshottableDirListingResponseProto) Reset() {
	*x = GetSnapshottableDirListingResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshottableDirListingResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshottableDirListingResponseProto) ProtoMessage() {}

func (x *GetSnapshottableDirListingResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshottableDirListingResponseProto.ProtoReflect.Descriptor instead.
func (*GetSnapshottableDirListingResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{49}
}

func (x *GetSnapshottableDirListingResponseProto) GetSnapshottableDirList() *SnapshottableDirectoryListingProto {
	if x != nil {
		return x.SnapshottableDirList
	}
	return nil
}

type GetSnapshotDiffReportRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	FromSnapshot *string `protobuf:"bytes,2,req,name=fromSnapshot" json:"fromSnapshot,omitempty"`
	ToSnapshot   *string `protobuf:"bytes,3,req,name=toSnapshot" json:"toSnapshot,omitempty"`
}

func (x *GetSnapshotDiffReportRequestProto) Reset() {
	*x = GetSnapshotDiffReportRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshotDiffReportRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotDiffReportRequestProto) ProtoMessage() {}

func (x *GetSnapshotDiffReportRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotDiffReportRequestProto.ProtoReflect.Descriptor instead.
func (*GetSnapshotDiffReportRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{50}
}

func (x *GetSnapshotDiffReportRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *GetSnapshotDiffReportRequestProto) GetFromSnapshot() string {
	if x != nil && x.FromSnapshot != nil {
		return *x.FromSnapshot
	}
	return ""
}

func (x *GetSnapshotDiffReportRequestProto) GetToSnapshot() string {
	if x != nil && x.ToSnapshot != nil {
		return *x.ToSnapshot
	}
	return ""
}

type GetSnapshotDiffReportResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DiffReport *SnapshotDiffReportProto `protobuf:"bytes,1,req,name=diffReport" json:"diffReport,omitempty"`
}

func (x *GetSnapshotDiffReportResponseProto) Reset() {
	*x = GetSnapshotDiffReportResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshotDiffReportResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotDiffReportResponseProto) ProtoMessage() {}

func (x *GetSnapshotDiffReportResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotDiffReportResponseProto.ProtoReflect.Descriptor instead.
func (*GetSnapshotDiffReportResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{51}
}

func (x *GetSnapshotDiffReportResponseProto) GetDiffReport() *SnapshotDiffReportProto {
	if x != nil {
		return x.DiffReport
	}
	return nil
}

type GetSnapshotDiffReportListingRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string                        `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	FromSnapshot *string                        `protobuf:"bytes,2,req,name=fromSnapshot" json:"fromSnapshot,omitempty"`
	ToSnapshot   *string                        `protobuf:"bytes,3,req,name=toSnapshot" json:"toSnapshot,omitempty"`
	Cursor       *SnapshotDiffReportCursorProto `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
}

func (x *GetSnapshotDiffReportListingRequestProto) Reset() {
	*x = GetSnapshotDiffReportListingRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshotDiffReportListingRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotDiffReportListingRequestProto) ProtoMessage() {}

func (x *GetSnapshotDiffReportListingRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotDiffReportListingRequestProto.ProtoReflect.Descriptor instead.
func (*GetSnapshotDiffReportListingRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{52}
}

func (x *GetSnapshotDiffReportListingRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *GetSnapshotDiffReportListingRequestProto) GetFromSnapshot() string {
	if x != nil && x.FromSnapshot != nil {
		return *x.FromSnapshot
	}
	return ""
}

func (x *GetSnapshotDiffReportListingRequestProto) GetToSnapshot() string {
	if x != nil && x.ToSnapshot != nil {
		return *x.ToSnapshot
	}
	return ""
}

func (x *GetSnapshotDiffReportListingRequestProto) GetCursor() *SnapshotDiffReportCursorProto {
	if x != nil {
		return x.Cursor
	}
	return nil
}

type GetSnapshotDiffReportListingResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DiffReport *SnapshotDiffReportListingProto `protobuf:"bytes,1,req,name=diffReport" json:"diffReport,omitempty"`
}

func (x *GetSnapshotDiffReportListingResponseProto) Reset() {
	*x = GetSnapshotDiffReportListingResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshotDiffReportListingResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotDiffReportListingResponseProto) ProtoMessage() {}

func (x *GetSnapshotDiffReportListingResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotDiffReportListingResponseProto.ProtoReflect.Descriptor instead.
func (*GetSnapshotDiffReportListingResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{53}
}

func (x *GetSnapshotDiffReportListingResponseProto) GetDiffReport() *SnapshotDiffReportListingProto {
	if x != nil {
		return x.DiffReport
	}
	return nil
}

type RenewLeaseRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientName *string `protobuf:"bytes,1,req,name=clientName" json:"clientName,omitempty"`
}

func (x *RenewLeaseRequestProto) Reset() {
	*x = RenewLeaseRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenewLeaseRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewLeaseRequestProto) ProtoMessage() {}

func (x *RenewLeaseRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewLeaseRequestProto.ProtoReflect.Descriptor instead.
func (*RenewLeaseRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{54}
}

func (x *RenewLeaseRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

type RenewLeaseResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RenewLeaseResponseProto) Reset() {
	*x = RenewLeaseResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenewLeaseResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewLeaseResponseProto) ProtoMessage() {}

func (x *RenewLeaseResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewLeaseResponseProto.ProtoReflect.Descriptor instead.
func (*RenewLeaseResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{55}
}

type RecoverLeaseRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src        *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	ClientName *string `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
}

func (x *RecoverLeaseRequestProto) Reset() {
	*x = RecoverLeaseRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoverLeaseRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoverLeaseRequestProto) ProtoMessage() {}

func (x *RecoverLeaseRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoverLeaseRequestProto.ProtoReflect.Descriptor instead.
func (*RecoverLeaseRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{56}
}

func (x *RecoverLeaseRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *RecoverLeaseRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

type RecoverLeaseResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *RecoverLeaseResponseProto) Reset() {
	*x = RecoverLeaseResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoverLeaseResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoverLeaseResponseProto) ProtoMessage() {}

func (x *RecoverLeaseResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoverLeaseResponseProto.ProtoReflect.Descriptor instead.
func (*RecoverLeaseResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{57}
}

func (x *RecoverLeaseResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type GetFsStatusRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetFsStatusRequestProto) Reset() {
	*x = GetFsStatusRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsStatusRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsStatusRequestProto) ProtoMessage() {}

func (x *GetFsStatusRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsStatusRequestProto.ProtoReflect.Descriptor instead.
func (*GetFsStatusRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{58}
}

type GetFsStatsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Capacity              *uint64 `protobuf:"varint,1,req,name=capacity" json:"capacity,omitempty"`
	Used                  *uint64 `protobuf:"varint,2,req,name=used" json:"used,omitempty"`
	Remaining             *uint64 `protobuf:"varint,3,req,name=remaining" json:"remaining,omitempty"`
	UnderReplicated       *uint64 `protobuf:"varint,4,req,name=under_replicated,json=underReplicated" json:"under_replicated,omitempty"`
	CorruptBlocks         *uint64 `protobuf:"varint,5,req,name=corrupt_blocks,json=corruptBlocks" json:"corrupt_blocks,omitempty"`
	MissingBlocks         *uint64 `protobuf:"varint,6,req,name=missing_blocks,json=missingBlocks" json:"missing_blocks,omitempty"`
	MissingReplOneBlocks  *uint64 `protobuf:"varint,7,opt,name=missing_repl_one_blocks,json=missingReplOneBlocks" json:"missing_repl_one_blocks,omitempty"`
	BlocksInFuture        *uint64 `protobuf:"varint,8,opt,name=blocks_in_future,json=blocksInFuture" json:"blocks_in_future,omitempty"`
	PendingDeletionBlocks *uint64 `protobuf:"varint,9,opt,name=pending_deletion_blocks,json=pendingDeletionBlocks" json:"pending_deletion_blocks,omitempty"`
}

func (x *GetFsStatsResponseProto) Reset() {
	*x = GetFsStatsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsStatsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsStatsResponseProto) ProtoMessage() {}

func (x *GetFsStatsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsStatsResponseProto.ProtoReflect.Descriptor instead.
func (*GetFsStatsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{59}
}

func (x *GetFsStatsResponseProto) GetCapacity() uint64 {
	if x != nil && x.Capacity != nil {
		return *x.Capacity
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetUsed() uint64 {
	if x != nil && x.Used != nil {
		return *x.Used
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetRemaining() uint64 {
	if x != nil && x.Remaining != nil {
		return *x.Remaining
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetUnderReplicated() uint64 {
	if x != nil && x.UnderReplicated != nil {
		return *x.UnderReplicated
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetCorruptBlocks() uint64 {
	if x != nil && x.CorruptBlocks != nil {
		return *x.CorruptBlocks
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetMissingBlocks() uint64 {
	if x != nil && x.MissingBlocks != nil {
		return *x.MissingBlocks
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetMissingReplOneBlocks() uint64 {
	if x != nil && x.MissingReplOneBlocks != nil {
		return *x.MissingReplOneBlocks
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetBlocksInFuture() uint64 {
	if x != nil && x.BlocksInFuture != nil {
		return *x.BlocksInFuture
	}
	return 0
}

func (x *GetFsStatsResponseProto) GetPendingDeletionBlocks() uint64 {
	if x != nil && x.PendingDeletionBlocks != nil {
		return *x.PendingDeletionBlocks
	}
	return 0
}

type GetFsReplicatedBlockStatsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetFsReplicatedBlockStatsRequestProto) Reset() {
	*x = GetFsReplicatedBlockStatsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsReplicatedBlockStatsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsReplicatedBlockStatsRequestProto) ProtoMessage() {}

func (x *GetFsReplicatedBlockStatsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsReplicatedBlockStatsRequestProto.ProtoReflect.Descriptor instead.
func (*GetFsReplicatedBlockStatsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{60}
}

type GetFsReplicatedBlockStatsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LowRedundancy                  *uint64 `protobuf:"varint,1,req,name=low_redundancy,json=lowRedundancy" json:"low_redundancy,omitempty"`
	CorruptBlocks                  *uint64 `protobuf:"varint,2,req,name=corrupt_blocks,json=corruptBlocks" json:"corrupt_blocks,omitempty"`
	MissingBlocks                  *uint64 `protobuf:"varint,3,req,name=missing_blocks,json=missingBlocks" json:"missing_blocks,omitempty"`
	MissingReplOneBlocks           *uint64 `protobuf:"varint,4,req,name=missing_repl_one_blocks,json=missingReplOneBlocks" json:"missing_repl_one_blocks,omitempty"`
	BlocksInFuture                 *uint64 `protobuf:"varint,5,req,name=blocks_in_future,json=blocksInFuture" json:"blocks_in_future,omitempty"`
	PendingDeletionBlocks          *uint64 `protobuf:"varint,6,req,name=pending_deletion_blocks,json=pendingDeletionBlocks" json:"pending_deletion_blocks,omitempty"`
	HighestPrioLowRedundancyBlocks *uint64 `protobuf:"varint,7,opt,name=highest_prio_low_redundancy_blocks,json=highestPrioLowRedundancyBlocks" json:"highest_prio_low_redundancy_blocks,omitempty"`
}

func (x *GetFsReplicatedBlockStatsResponseProto) Reset() {
	*x = GetFsReplicatedBlockStatsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsReplicatedBlockStatsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsReplicatedBlockStatsResponseProto) ProtoMessage() {}

func (x *GetFsReplicatedBlockStatsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsReplicatedBlockStatsResponseProto.ProtoReflect.Descriptor instead.
func (*GetFsReplicatedBlockStatsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{61}
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetLowRedundancy() uint64 {
	if x != nil && x.LowRedundancy != nil {
		return *x.LowRedundancy
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetCorruptBlocks() uint64 {
	if x != nil && x.CorruptBlocks != nil {
		return *x.CorruptBlocks
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetMissingBlocks() uint64 {
	if x != nil && x.MissingBlocks != nil {
		return *x.MissingBlocks
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetMissingReplOneBlocks() uint64 {
	if x != nil && x.MissingReplOneBlocks != nil {
		return *x.MissingReplOneBlocks
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetBlocksInFuture() uint64 {
	if x != nil && x.BlocksInFuture != nil {
		return *x.BlocksInFuture
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetPendingDeletionBlocks() uint64 {
	if x != nil && x.PendingDeletionBlocks != nil {
		return *x.PendingDeletionBlocks
	}
	return 0
}

func (x *GetFsReplicatedBlockStatsResponseProto) GetHighestPrioLowRedundancyBlocks() uint64 {
	if x != nil && x.HighestPrioLowRedundancyBlocks != nil {
		return *x.HighestPrioLowRedundancyBlocks
	}
	return 0
}

type GetFsECBlockGroupStatsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetFsECBlockGroupStatsRequestProto) Reset() {
	*x = GetFsECBlockGroupStatsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsECBlockGroupStatsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsECBlockGroupStatsRequestProto) ProtoMessage() {}

func (x *GetFsECBlockGroupStatsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsECBlockGroupStatsRequestProto.ProtoReflect.Descriptor instead.
func (*GetFsECBlockGroupStatsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{62}
}

type GetFsECBlockGroupStatsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LowRedundancy                  *uint64 `protobuf:"varint,1,req,name=low_redundancy,json=lowRedundancy" json:"low_redundancy,omitempty"`
	CorruptBlocks                  *uint64 `protobuf:"varint,2,req,name=corrupt_blocks,json=corruptBlocks" json:"corrupt_blocks,omitempty"`
	MissingBlocks                  *uint64 `protobuf:"varint,3,req,name=missing_blocks,json=missingBlocks" json:"missing_blocks,omitempty"`
	BlocksInFuture                 *uint64 `protobuf:"varint,4,req,name=blocks_in_future,json=blocksInFuture" json:"blocks_in_future,omitempty"`
	PendingDeletionBlocks          *uint64 `protobuf:"varint,5,req,name=pending_deletion_blocks,json=pendingDeletionBlocks" json:"pending_deletion_blocks,omitempty"`
	HighestPrioLowRedundancyBlocks *uint64 `protobuf:"varint,6,opt,name=highest_prio_low_redundancy_blocks,json=highestPrioLowRedundancyBlocks" json:"highest_prio_low_redundancy_blocks,omitempty"`
}

func (x *GetFsECBlockGroupStatsResponseProto) Reset() {
	*x = GetFsECBlockGroupStatsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFsECBlockGroupStatsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFsECBlockGroupStatsResponseProto) ProtoMessage() {}

func (x *GetFsECBlockGroupStatsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFsECBlockGroupStatsResponseProto.ProtoReflect.Descriptor instead.
func (*GetFsECBlockGroupStatsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{63}
}

func (x *GetFsECBlockGroupStatsResponseProto) GetLowRedundancy() uint64 {
	if x != nil && x.LowRedundancy != nil {
		return *x.LowRedundancy
	}
	return 0
}

func (x *GetFsECBlockGroupStatsResponseProto) GetCorruptBlocks() uint64 {
	if x != nil && x.CorruptBlocks != nil {
		return *x.CorruptBlocks
	}
	return 0
}

func (x *GetFsECBlockGroupStatsResponseProto) GetMissingBlocks() uint64 {
	if x != nil && x.MissingBlocks != nil {
		return *x.MissingBlocks
	}
	return 0
}

func (x *GetFsECBlockGroupStatsResponseProto) GetBlocksInFuture() uint64 {
	if x != nil && x.BlocksInFuture != nil {
		return *x.BlocksInFuture
	}
	return 0
}

func (x *GetFsECBlockGroupStatsResponseProto) GetPendingDeletionBlocks() uint64 {
	if x != nil && x.PendingDeletionBlocks != nil {
		return *x.PendingDeletionBlocks
	}
	return 0
}

func (x *GetFsECBlockGroupStatsResponseProto) GetHighestPrioLowRedundancyBlocks() uint64 {
	if x != nil && x.HighestPrioLowRedundancyBlocks != nil {
		return *x.HighestPrioLowRedundancyBlocks
	}
	return 0
}

type GetDatanodeReportRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *DatanodeReportTypeProto `protobuf:"varint,1,req,name=type,enum=hadoop.hdfs.DatanodeReportTypeProto" json:"type,omitempty"`
}

func (x *GetDatanodeReportRequestProto) Reset() {
	*x = GetDatanodeReportRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeReportRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeReportRequestProto) ProtoMessage() {}

func (x *GetDatanodeReportRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeReportRequestProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeReportRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{64}
}

func (x *GetDatanodeReportRequestProto) GetType() DatanodeReportTypeProto {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return DatanodeReportTypeProto_ALL
}

type GetDatanodeReportResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Di []*DatanodeInfoProto `protobuf:"bytes,1,rep,name=di" json:"di,omitempty"`
}

func (x *GetDatanodeReportResponseProto) Reset() {
	*x = GetDatanodeReportResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeReportResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeReportResponseProto) ProtoMessage() {}

func (x *GetDatanodeReportResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeReportResponseProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeReportResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{65}
}

func (x *GetDatanodeReportResponseProto) GetDi() []*DatanodeInfoProto {
	if x != nil {
		return x.Di
	}
	return nil
}

type GetDatanodeStorageReportRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *DatanodeReportTypeProto `protobuf:"varint,1,req,name=type,enum=hadoop.hdfs.DatanodeReportTypeProto" json:"type,omitempty"`
}

func (x *GetDatanodeStorageReportRequestProto) Reset() {
	*x = GetDatanodeStorageReportRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeStorageReportRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeStorageReportRequestProto) ProtoMessage() {}

func (x *GetDatanodeStorageReportRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeStorageReportRequestProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeStorageReportRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{66}
}

func (x *GetDatanodeStorageReportRequestProto) GetType() DatanodeReportTypeProto {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return DatanodeReportTypeProto_ALL
}

type DatanodeStorageReportProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DatanodeInfo   *DatanodeInfoProto    `protobuf:"bytes,1,req,name=datanodeInfo" json:"datanodeInfo,omitempty"`
	StorageReports []*StorageReportProto `protobuf:"bytes,2,rep,name=storageReports" json:"storageReports,omitempty"`
}

func (x *DatanodeStorageReportProto) Reset() {
	*x = DatanodeStorageReportProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeStorageReportProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeStorageReportProto) ProtoMessage() {}

func (x *DatanodeStorageReportProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeStorageReportProto.ProtoReflect.Descriptor instead.
func (*DatanodeStorageReportProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{67}
}

func (x *DatanodeStorageReportProto) GetDatanodeInfo() *DatanodeInfoProto {
	if x != nil {
		return x.DatanodeInfo
	}
	return nil
}

func (x *DatanodeStorageReportProto) GetStorageReports() []*StorageReportProto {
	if x != nil {
		return x.StorageReports
	}
	return nil
}

type GetDatanodeStorageReportResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DatanodeStorageReports []*DatanodeStorageReportProto `protobuf:"bytes,1,rep,name=datanodeStorageReports" json:"datanodeStorageReports,omitempty"`
}

func (x *GetDatanodeStorageReportResponseProto) Reset() {
	*x = GetDatanodeStorageReportResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeStorageReportResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeStorageReportResponseProto) ProtoMessage() {}

func (x *GetDatanodeStorageReportResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeStorageReportResponseProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeStorageReportResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{68}
}

func (x *GetDatanodeStorageReportResponseProto) GetDatanodeStorageReports() []*DatanodeStorageReportProto {
	if x != nil {
		return x.DatanodeStorageReports
	}
	return nil
}

type GetPreferredBlockSizeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filename *string `protobuf:"bytes,1,req,name=filename" json:"filename,omitempty"`
}

func (x *GetPreferredBlockSizeRequestProto) Reset() {
	*x = GetPreferredBlockSizeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPreferredBlockSizeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPreferredBlockSizeRequestProto) ProtoMessage() {}

func (x *GetPreferredBlockSizeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPreferredBlockSizeRequestProto.ProtoReflect.Descriptor instead.
func (*GetPreferredBlockSizeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{69}
}

func (x *GetPreferredBlockSizeRequestProto) GetFilename() string {
	if x != nil && x.Filename != nil {
		return *x.Filename
	}
	return ""
}

type GetPreferredBlockSizeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bsize *uint64 `protobuf:"varint,1,req,name=bsize" json:"bsize,omitempty"`
}

func (x *GetPreferredBlockSizeResponseProto) Reset() {
	*x = GetPreferredBlockSizeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPreferredBlockSizeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPreferredBlockSizeResponseProto) ProtoMessage() {}

func (x *GetPreferredBlockSizeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPreferredBlockSizeResponseProto.ProtoReflect.Descriptor instead.
func (*GetPreferredBlockSizeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{70}
}

func (x *GetPreferredBlockSizeResponseProto) GetBsize() uint64 {
	if x != nil && x.Bsize != nil {
		return *x.Bsize
	}
	return 0
}

type SetSafeModeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action  *SafeModeActionProto `protobuf:"varint,1,req,name=action,enum=hadoop.hdfs.SafeModeActionProto" json:"action,omitempty"`
	Checked *bool                `protobuf:"varint,2,opt,name=checked,def=0" json:"checked,omitempty"`
}

// Default values for SetSafeModeRequestProto fields.
const (
	Default_SetSafeModeRequestProto_Checked = bool(false)
)

func (x *SetSafeModeRequestProto) Reset() {
	*x = SetSafeModeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSafeModeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSafeModeRequestProto) ProtoMessage() {}

func (x *SetSafeModeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSafeModeRequestProto.ProtoReflect.Descriptor instead.
func (*SetSafeModeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{71}
}

func (x *SetSafeModeRequestProto) GetAction() SafeModeActionProto {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return SafeModeActionProto_SAFEMODE_LEAVE
}

func (x *SetSafeModeRequestProto) GetChecked() bool {
	if x != nil && x.Checked != nil {
		return *x.Checked
	}
	return Default_SetSafeModeRequestProto_Checked
}

type SetSafeModeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *SetSafeModeResponseProto) Reset() {
	*x = SetSafeModeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSafeModeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSafeModeResponseProto) ProtoMessage() {}

func (x *SetSafeModeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSafeModeResponseProto.ProtoReflect.Descriptor instead.
func (*SetSafeModeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{72}
}

func (x *SetSafeModeResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type SaveNamespaceRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimeWindow *uint64 `protobuf:"varint,1,opt,name=timeWindow,def=0" json:"timeWindow,omitempty"`
	TxGap      *uint64 `protobuf:"varint,2,opt,name=txGap,def=0" json:"txGap,omitempty"`
}

// Default values for SaveNamespaceRequestProto fields.
const (
	Default_SaveNamespaceRequestProto_TimeWindow = uint64(0)
	Default_SaveNamespaceRequestProto_TxGap      = uint64(0)
)

func (x *SaveNamespaceRequestProto) Reset() {
	*x = SaveNamespaceRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SaveNamespaceRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SaveNamespaceRequestProto) ProtoMessage() {}

func (x *SaveNamespaceRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SaveNamespaceRequestProto.ProtoReflect.Descriptor instead.
func (*SaveNamespaceRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{73}
}

func (x *SaveNamespaceRequestProto) GetTimeWindow() uint64 {
	if x != nil && x.TimeWindow != nil {
		return *x.TimeWindow
	}
	return Default_SaveNamespaceRequestProto_TimeWindow
}

func (x *SaveNamespaceRequestProto) GetTxGap() uint64 {
	if x != nil && x.TxGap != nil {
		return *x.TxGap
	}
	return Default_SaveNamespaceRequestProto_TxGap
}

type SaveNamespaceResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Saved *bool `protobuf:"varint,1,opt,name=saved,def=1" json:"saved,omitempty"`
}

// Default values for SaveNamespaceResponseProto fields.
const (
	Default_SaveNamespaceResponseProto_Saved = bool(true)
)

func (x *SaveNamespaceResponseProto) Reset() {
	*x = SaveNamespaceResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SaveNamespaceResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SaveNamespaceResponseProto) ProtoMessage() {}

func (x *SaveNamespaceResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SaveNamespaceResponseProto.ProtoReflect.Descriptor instead.
func (*SaveNamespaceResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{74}
}

func (x *SaveNamespaceResponseProto) GetSaved() bool {
	if x != nil && x.Saved != nil {
		return *x.Saved
	}
	return Default_SaveNamespaceResponseProto_Saved
}

type RollEditsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RollEditsRequestProto) Reset() {
	*x = RollEditsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollEditsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollEditsRequestProto) ProtoMessage() {}

func (x *RollEditsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollEditsRequestProto.ProtoReflect.Descriptor instead.
func (*RollEditsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{75}
}

type RollEditsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NewSegmentTxId *uint64 `protobuf:"varint,1,req,name=newSegmentTxId" json:"newSegmentTxId,omitempty"`
}

func (x *RollEditsResponseProto) Reset() {
	*x = RollEditsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollEditsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollEditsResponseProto) ProtoMessage() {}

func (x *RollEditsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollEditsResponseProto.ProtoReflect.Descriptor instead.
func (*RollEditsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{76}
}

func (x *RollEditsResponseProto) GetNewSegmentTxId() uint64 {
	if x != nil && x.NewSegmentTxId != nil {
		return *x.NewSegmentTxId
	}
	return 0
}

type RestoreFailedStorageRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Arg *string `protobuf:"bytes,1,req,name=arg" json:"arg,omitempty"`
}

func (x *RestoreFailedStorageRequestProto) Reset() {
	*x = RestoreFailedStorageRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreFailedStorageRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreFailedStorageRequestProto) ProtoMessage() {}

func (x *RestoreFailedStorageRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreFailedStorageRequestProto.ProtoReflect.Descriptor instead.
func (*RestoreFailedStorageRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{77}
}

func (x *RestoreFailedStorageRequestProto) GetArg() string {
	if x != nil && x.Arg != nil {
		return *x.Arg
	}
	return ""
}

type RestoreFailedStorageResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *RestoreFailedStorageResponseProto) Reset() {
	*x = RestoreFailedStorageResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreFailedStorageResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreFailedStorageResponseProto) ProtoMessage() {}

func (x *RestoreFailedStorageResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreFailedStorageResponseProto.ProtoReflect.Descriptor instead.
func (*RestoreFailedStorageResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{78}
}

func (x *RestoreFailedStorageResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type RefreshNodesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RefreshNodesRequestProto) Reset() {
	*x = RefreshNodesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshNodesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshNodesRequestProto) ProtoMessage() {}

func (x *RefreshNodesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshNodesRequestProto.ProtoReflect.Descriptor instead.
func (*RefreshNodesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{79}
}

type RefreshNodesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RefreshNodesResponseProto) Reset() {
	*x = RefreshNodesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshNodesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshNodesResponseProto) ProtoMessage() {}

func (x *RefreshNodesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshNodesResponseProto.ProtoReflect.Descriptor instead.
func (*RefreshNodesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{80}
}

type FinalizeUpgradeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FinalizeUpgradeRequestProto) Reset() {
	*x = FinalizeUpgradeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeUpgradeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeUpgradeRequestProto) ProtoMessage() {}

func (x *FinalizeUpgradeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeUpgradeRequestProto.ProtoReflect.Descriptor instead.
func (*FinalizeUpgradeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{81}
}

type FinalizeUpgradeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FinalizeUpgradeResponseProto) Reset() {
	*x = FinalizeUpgradeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeUpgradeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeUpgradeResponseProto) ProtoMessage() {}

func (x *FinalizeUpgradeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeUpgradeResponseProto.ProtoReflect.Descriptor instead.
func (*FinalizeUpgradeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{82}
}

type UpgradeStatusRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpgradeStatusRequestProto) Reset() {
	*x = UpgradeStatusRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeStatusRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeStatusRequestProto) ProtoMessage() {}

func (x *UpgradeStatusRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeStatusRequestProto.ProtoReflect.Descriptor instead.
func (*UpgradeStatusRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{83}
}

type UpgradeStatusResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UpgradeFinalized *bool `protobuf:"varint,1,req,name=upgradeFinalized" json:"upgradeFinalized,omitempty"`
}

func (x *UpgradeStatusResponseProto) Reset() {
	*x = UpgradeStatusResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeStatusResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeStatusResponseProto) ProtoMessage() {}

func (x *UpgradeStatusResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeStatusResponseProto.ProtoReflect.Descriptor instead.
func (*UpgradeStatusResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{84}
}

func (x *UpgradeStatusResponseProto) GetUpgradeFinalized() bool {
	if x != nil && x.UpgradeFinalized != nil {
		return *x.UpgradeFinalized
	}
	return false
}

type RollingUpgradeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action *RollingUpgradeActionProto `protobuf:"varint,1,req,name=action,enum=hadoop.hdfs.RollingUpgradeActionProto" json:"action,omitempty"`
}

func (x *RollingUpgradeRequestProto) Reset() {
	*x = RollingUpgradeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollingUpgradeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollingUpgradeRequestProto) ProtoMessage() {}

func (x *RollingUpgradeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollingUpgradeRequestProto.ProtoReflect.Descriptor instead.
func (*RollingUpgradeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{85}
}

func (x *RollingUpgradeRequestProto) GetAction() RollingUpgradeActionProto {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return RollingUpgradeActionProto_QUERY
}

type RollingUpgradeInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status                *RollingUpgradeStatusProto `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	StartTime             *uint64                    `protobuf:"varint,2,req,name=startTime" json:"startTime,omitempty"`
	FinalizeTime          *uint64                    `protobuf:"varint,3,req,name=finalizeTime" json:"finalizeTime,omitempty"`
	CreatedRollbackImages *bool                      `protobuf:"varint,4,req,name=createdRollbackImages" json:"createdRollbackImages,omitempty"`
}

func (x *RollingUpgradeInfoProto) Reset() {
	*x = RollingUpgradeInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollingUpgradeInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollingUpgradeInfoProto) ProtoMessage() {}

func (x *RollingUpgradeInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollingUpgradeInfoProto.ProtoReflect.Descriptor instead.
func (*RollingUpgradeInfoProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{86}
}

func (x *RollingUpgradeInfoProto) GetStatus() *RollingUpgradeStatusProto {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *RollingUpgradeInfoProto) GetStartTime() uint64 {
	if x != nil && x.StartTime != nil {
		return *x.StartTime
	}
	return 0
}

func (x *RollingUpgradeInfoProto) GetFinalizeTime() uint64 {
	if x != nil && x.FinalizeTime != nil {
		return *x.FinalizeTime
	}
	return 0
}

func (x *RollingUpgradeInfoProto) GetCreatedRollbackImages() bool {
	if x != nil && x.CreatedRollbackImages != nil {
		return *x.CreatedRollbackImages
	}
	return false
}

type RollingUpgradeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RollingUpgradeInfo *RollingUpgradeInfoProto `protobuf:"bytes,1,opt,name=rollingUpgradeInfo" json:"rollingUpgradeInfo,omitempty"`
}

func (x *RollingUpgradeResponseProto) Reset() {
	*x = RollingUpgradeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollingUpgradeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollingUpgradeResponseProto) ProtoMessage() {}

func (x *RollingUpgradeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollingUpgradeResponseProto.ProtoReflect.Descriptor instead.
func (*RollingUpgradeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{87}
}

func (x *RollingUpgradeResponseProto) GetRollingUpgradeInfo() *RollingUpgradeInfoProto {
	if x != nil {
		return x.RollingUpgradeInfo
	}
	return nil
}

type ListCorruptFileBlocksRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path   *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Cookie *string `protobuf:"bytes,2,opt,name=cookie" json:"cookie,omitempty"`
}

func (x *ListCorruptFileBlocksRequestProto) Reset() {
	*x = ListCorruptFileBlocksRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorruptFileBlocksRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorruptFileBlocksRequestProto) ProtoMessage() {}

func (x *ListCorruptFileBlocksRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorruptFileBlocksRequestProto.ProtoReflect.Descriptor instead.
func (*ListCorruptFileBlocksRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{88}
}

func (x *ListCorruptFileBlocksRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *ListCorruptFileBlocksRequestProto) GetCookie() string {
	if x != nil && x.Cookie != nil {
		return *x.Cookie
	}
	return ""
}

type ListCorruptFileBlocksResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Corrupt *CorruptFileBlocksProto `protobuf:"bytes,1,req,name=corrupt" json:"corrupt,omitempty"`
}

func (x *ListCorruptFileBlocksResponseProto) Reset() {
	*x = ListCorruptFileBlocksResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorruptFileBlocksResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorruptFileBlocksResponseProto) ProtoMessage() {}

func (x *ListCorruptFileBlocksResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorruptFileBlocksResponseProto.ProtoReflect.Descriptor instead.
func (*ListCorruptFileBlocksResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{89}
}

func (x *ListCorruptFileBlocksResponseProto) GetCorrupt() *CorruptFileBlocksProto {
	if x != nil {
		return x.Corrupt
	}
	return nil
}

type MetaSaveRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filename *string `protobuf:"bytes,1,req,name=filename" json:"filename,omitempty"`
}

func (x *MetaSaveRequestProto) Reset() {
	*x = MetaSaveRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetaSaveRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetaSaveRequestProto) ProtoMessage() {}

func (x *MetaSaveRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetaSaveRequestProto.ProtoReflect.Descriptor instead.
func (*MetaSaveRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{90}
}

func (x *MetaSaveRequestProto) GetFilename() string {
	if x != nil && x.Filename != nil {
		return *x.Filename
	}
	return ""
}

type MetaSaveResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MetaSaveResponseProto) Reset() {
	*x = MetaSaveResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetaSaveResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetaSaveResponseProto) ProtoMessage() {}

func (x *MetaSaveResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetaSaveResponseProto.ProtoReflect.Descriptor instead.
func (*MetaSaveResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{91}
}

type GetFileInfoRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *GetFileInfoRequestProto) Reset() {
	*x = GetFileInfoRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFileInfoRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileInfoRequestProto) ProtoMessage() {}

func (x *GetFileInfoRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileInfoRequestProto.ProtoReflect.Descriptor instead.
func (*GetFileInfoRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{92}
}

func (x *GetFileInfoRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type GetFileInfoResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fs *HdfsFileStatusProto `protobuf:"bytes,1,opt,name=fs" json:"fs,omitempty"`
}

func (x *GetFileInfoResponseProto) Reset() {
	*x = GetFileInfoResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFileInfoResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileInfoResponseProto) ProtoMessage() {}

func (x *GetFileInfoResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileInfoResponseProto.ProtoReflect.Descriptor instead.
func (*GetFileInfoResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{93}
}

func (x *GetFileInfoResponseProto) GetFs() *HdfsFileStatusProto {
	if x != nil {
		return x.Fs
	}
	return nil
}

type GetLocatedFileInfoRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src            *string `protobuf:"bytes,1,opt,name=src" json:"src,omitempty"`
	NeedBlockToken *bool   `protobuf:"varint,2,opt,name=needBlockToken,def=0" json:"needBlockToken,omitempty"`
}

// Default values for GetLocatedFileInfoRequestProto fields.
const (
	Default_GetLocatedFileInfoRequestProto_NeedBlockToken = bool(false)
)

func (x *GetLocatedFileInfoRequestProto) Reset() {
	*x = GetLocatedFileInfoRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLocatedFileInfoRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocatedFileInfoRequestProto) ProtoMessage() {}

func (x *GetLocatedFileInfoRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLocatedFileInfoRequestProto.ProtoReflect.Descriptor instead.
func (*GetLocatedFileInfoRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{94}
}

func (x *GetLocatedFileInfoRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *GetLocatedFileInfoRequestProto) GetNeedBlockToken() bool {
	if x != nil && x.NeedBlockToken != nil {
		return *x.NeedBlockToken
	}
	return Default_GetLocatedFileInfoRequestProto_NeedBlockToken
}

type GetLocatedFileInfoResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fs *HdfsFileStatusProto `protobuf:"bytes,1,opt,name=fs" json:"fs,omitempty"`
}

func (x *GetLocatedFileInfoResponseProto) Reset() {
	*x = GetLocatedFileInfoResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLocatedFileInfoResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocatedFileInfoResponseProto) ProtoMessage() {}

func (x *GetLocatedFileInfoResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLocatedFileInfoResponseProto.ProtoReflect.Descriptor instead.
func (*GetLocatedFileInfoResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{95}
}

func (x *GetLocatedFileInfoResponseProto) GetFs() *HdfsFileStatusProto {
	if x != nil {
		return x.Fs
	}
	return nil
}

type IsFileClosedRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *IsFileClosedRequestProto) Reset() {
	*x = IsFileClosedRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsFileClosedRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsFileClosedRequestProto) ProtoMessage() {}

func (x *IsFileClosedRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsFileClosedRequestProto.ProtoReflect.Descriptor instead.
func (*IsFileClosedRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{96}
}

func (x *IsFileClosedRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type IsFileClosedResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *bool `protobuf:"varint,1,req,name=result" json:"result,omitempty"`
}

func (x *IsFileClosedResponseProto) Reset() {
	*x = IsFileClosedResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsFileClosedResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsFileClosedResponseProto) ProtoMessage() {}

func (x *IsFileClosedResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsFileClosedResponseProto.ProtoReflect.Descriptor instead.
func (*IsFileClosedResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{97}
}

func (x *IsFileClosedResponseProto) GetResult() bool {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return false
}

type CacheDirectiveInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          *int64                             `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Path        *string                            `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	Replication *uint32                            `protobuf:"varint,3,opt,name=replication" json:"replication,omitempty"`
	Pool        *string                            `protobuf:"bytes,4,opt,name=pool" json:"pool,omitempty"`
	Expiration  *CacheDirectiveInfoExpirationProto `protobuf:"bytes,5,opt,name=expiration" json:"expiration,omitempty"`
}

func (x *CacheDirectiveInfoProto) Reset() {
	*x = CacheDirectiveInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheDirectiveInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheDirectiveInfoProto) ProtoMessage() {}

func (x *CacheDirectiveInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheDirectiveInfoProto.ProtoReflect.Descriptor instead.
func (*CacheDirectiveInfoProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{98}
}

func (x *CacheDirectiveInfoProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *CacheDirectiveInfoProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *CacheDirectiveInfoProto) GetReplication() uint32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

func (x *CacheDirectiveInfoProto) GetPool() string {
	if x != nil && x.Pool != nil {
		return *x.Pool
	}
	return ""
}

func (x *CacheDirectiveInfoProto) GetExpiration() *CacheDirectiveInfoExpirationProto {
	if x != nil {
		return x.Expiration
	}
	return nil
}

type CacheDirectiveInfoExpirationProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Millis     *int64 `protobuf:"varint,1,req,name=millis" json:"millis,omitempty"`
	IsRelative *bool  `protobuf:"varint,2,req,name=isRelative" json:"isRelative,omitempty"`
}

func (x *CacheDirectiveInfoExpirationProto) Reset() {
	*x = CacheDirectiveInfoExpirationProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheDirectiveInfoExpirationProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheDirectiveInfoExpirationProto) ProtoMessage() {}

func (x *CacheDirectiveInfoExpirationProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheDirectiveInfoExpirationProto.ProtoReflect.Descriptor instead.
func (*CacheDirectiveInfoExpirationProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{99}
}

func (x *CacheDirectiveInfoExpirationProto) GetMillis() int64 {
	if x != nil && x.Millis != nil {
		return *x.Millis
	}
	return 0
}

func (x *CacheDirectiveInfoExpirationProto) GetIsRelative() bool {
	if x != nil && x.IsRelative != nil {
		return *x.IsRelative
	}
	return false
}

type CacheDirectiveStatsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BytesNeeded *int64 `protobuf:"varint,1,req,name=bytesNeeded" json:"bytesNeeded,omitempty"`
	BytesCached *int64 `protobuf:"varint,2,req,name=bytesCached" json:"bytesCached,omitempty"`
	FilesNeeded *int64 `protobuf:"varint,3,req,name=filesNeeded" json:"filesNeeded,omitempty"`
	FilesCached *int64 `protobuf:"varint,4,req,name=filesCached" json:"filesCached,omitempty"`
	HasExpired  *bool  `protobuf:"varint,5,req,name=hasExpired" json:"hasExpired,omitempty"`
}

func (x *CacheDirectiveStatsProto) Reset() {
	*x = CacheDirectiveStatsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheDirectiveStatsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheDirectiveStatsProto) ProtoMessage() {}

func (x *CacheDirectiveStatsProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheDirectiveStatsProto.ProtoReflect.Descriptor instead.
func (*CacheDirectiveStatsProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{100}
}

func (x *CacheDirectiveStatsProto) GetBytesNeeded() int64 {
	if x != nil && x.BytesNeeded != nil {
		return *x.BytesNeeded
	}
	return 0
}

func (x *CacheDirectiveStatsProto) GetBytesCached() int64 {
	if x != nil && x.BytesCached != nil {
		return *x.BytesCached
	}
	return 0
}

func (x *CacheDirectiveStatsProto) GetFilesNeeded() int64 {
	if x != nil && x.FilesNeeded != nil {
		return *x.FilesNeeded
	}
	return 0
}

func (x *CacheDirectiveStatsProto) GetFilesCached() int64 {
	if x != nil && x.FilesCached != nil {
		return *x.FilesCached
	}
	return 0
}

func (x *CacheDirectiveStatsProto) GetHasExpired() bool {
	if x != nil && x.HasExpired != nil {
		return *x.HasExpired
	}
	return false
}

type AddCacheDirectiveRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info       *CacheDirectiveInfoProto `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
	CacheFlags *uint32                  `protobuf:"varint,2,opt,name=cacheFlags" json:"cacheFlags,omitempty"` // bits set using CacheFlag
}

func (x *AddCacheDirectiveRequestProto) Reset() {
	*x = AddCacheDirectiveRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCacheDirectiveRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCacheDirectiveRequestProto) ProtoMessage() {}

func (x *AddCacheDirectiveRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCacheDirectiveRequestProto.ProtoReflect.Descriptor instead.
func (*AddCacheDirectiveRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{101}
}

func (x *AddCacheDirectiveRequestProto) GetInfo() *CacheDirectiveInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *AddCacheDirectiveRequestProto) GetCacheFlags() uint32 {
	if x != nil && x.CacheFlags != nil {
		return *x.CacheFlags
	}
	return 0
}

type AddCacheDirectiveResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *int64 `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
}

func (x *AddCacheDirectiveResponseProto) Reset() {
	*x = AddCacheDirectiveResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCacheDirectiveResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCacheDirectiveResponseProto) ProtoMessage() {}

func (x *AddCacheDirectiveResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCacheDirectiveResponseProto.ProtoReflect.Descriptor instead.
func (*AddCacheDirectiveResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{102}
}

func (x *AddCacheDirectiveResponseProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

type ModifyCacheDirectiveRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info       *CacheDirectiveInfoProto `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
	CacheFlags *uint32                  `protobuf:"varint,2,opt,name=cacheFlags" json:"cacheFlags,omitempty"` // bits set using CacheFlag
}

func (x *ModifyCacheDirectiveRequestProto) Reset() {
	*x = ModifyCacheDirectiveRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyCacheDirectiveRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyCacheDirectiveRequestProto) ProtoMessage() {}

func (x *ModifyCacheDirectiveRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyCacheDirectiveRequestProto.ProtoReflect.Descriptor instead.
func (*ModifyCacheDirectiveRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{103}
}

func (x *ModifyCacheDirectiveRequestProto) GetInfo() *CacheDirectiveInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *ModifyCacheDirectiveRequestProto) GetCacheFlags() uint32 {
	if x != nil && x.CacheFlags != nil {
		return *x.CacheFlags
	}
	return 0
}

type ModifyCacheDirectiveResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ModifyCacheDirectiveResponseProto) Reset() {
	*x = ModifyCacheDirectiveResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyCacheDirectiveResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyCacheDirectiveResponseProto) ProtoMessage() {}

func (x *ModifyCacheDirectiveResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyCacheDirectiveResponseProto.ProtoReflect.Descriptor instead.
func (*ModifyCacheDirectiveResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{104}
}

type RemoveCacheDirectiveRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *int64 `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
}

func (x *RemoveCacheDirectiveRequestProto) Reset() {
	*x = RemoveCacheDirectiveRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCacheDirectiveRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCacheDirectiveRequestProto) ProtoMessage() {}

func (x *RemoveCacheDirectiveRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCacheDirectiveRequestProto.ProtoReflect.Descriptor instead.
func (*RemoveCacheDirectiveRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{105}
}

func (x *RemoveCacheDirectiveRequestProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

type RemoveCacheDirectiveResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveCacheDirectiveResponseProto) Reset() {
	*x = RemoveCacheDirectiveResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCacheDirectiveResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCacheDirectiveResponseProto) ProtoMessage() {}

func (x *RemoveCacheDirectiveResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCacheDirectiveResponseProto.ProtoReflect.Descriptor instead.
func (*RemoveCacheDirectiveResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{106}
}

type ListCacheDirectivesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrevId *int64                   `protobuf:"varint,1,req,name=prevId" json:"prevId,omitempty"`
	Filter *CacheDirectiveInfoProto `protobuf:"bytes,2,req,name=filter" json:"filter,omitempty"`
}

func (x *ListCacheDirectivesRequestProto) Reset() {
	*x = ListCacheDirectivesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCacheDirectivesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCacheDirectivesRequestProto) ProtoMessage() {}

func (x *ListCacheDirectivesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCacheDirectivesRequestProto.ProtoReflect.Descriptor instead.
func (*ListCacheDirectivesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{107}
}

func (x *ListCacheDirectivesRequestProto) GetPrevId() int64 {
	if x != nil && x.PrevId != nil {
		return *x.PrevId
	}
	return 0
}

func (x *ListCacheDirectivesRequestProto) GetFilter() *CacheDirectiveInfoProto {
	if x != nil {
		return x.Filter
	}
	return nil
}

type CacheDirectiveEntryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info  *CacheDirectiveInfoProto  `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
	Stats *CacheDirectiveStatsProto `protobuf:"bytes,2,req,name=stats" json:"stats,omitempty"`
}

func (x *CacheDirectiveEntryProto) Reset() {
	*x = CacheDirectiveEntryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheDirectiveEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheDirectiveEntryProto) ProtoMessage() {}

func (x *CacheDirectiveEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheDirectiveEntryProto.ProtoReflect.Descriptor instead.
func (*CacheDirectiveEntryProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{108}
}

func (x *CacheDirectiveEntryProto) GetInfo() *CacheDirectiveInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *CacheDirectiveEntryProto) GetStats() *CacheDirectiveStatsProto {
	if x != nil {
		return x.Stats
	}
	return nil
}

type ListCacheDirectivesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Elements []*CacheDirectiveEntryProto `protobuf:"bytes,1,rep,name=elements" json:"elements,omitempty"`
	HasMore  *bool                       `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
}

func (x *ListCacheDirectivesResponseProto) Reset() {
	*x = ListCacheDirectivesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCacheDirectivesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCacheDirectivesResponseProto) ProtoMessage() {}

func (x *ListCacheDirectivesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCacheDirectivesResponseProto.ProtoReflect.Descriptor instead.
func (*ListCacheDirectivesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{109}
}

func (x *ListCacheDirectivesResponseProto) GetElements() []*CacheDirectiveEntryProto {
	if x != nil {
		return x.Elements
	}
	return nil
}

func (x *ListCacheDirectivesResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

type CachePoolInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PoolName           *string `protobuf:"bytes,1,opt,name=poolName" json:"poolName,omitempty"`
	OwnerName          *string `protobuf:"bytes,2,opt,name=ownerName" json:"ownerName,omitempty"`
	GroupName          *string `protobuf:"bytes,3,opt,name=groupName" json:"groupName,omitempty"`
	Mode               *int32  `protobuf:"varint,4,opt,name=mode" json:"mode,omitempty"`
	Limit              *int64  `protobuf:"varint,5,opt,name=limit" json:"limit,omitempty"`
	MaxRelativeExpiry  *int64  `protobuf:"varint,6,opt,name=maxRelativeExpiry" json:"maxRelativeExpiry,omitempty"`
	DefaultReplication *uint32 `protobuf:"varint,7,opt,name=defaultReplication,def=1" json:"defaultReplication,omitempty"`
}

// Default values for CachePoolInfoProto fields.
const (
	Default_CachePoolInfoProto_DefaultReplication = uint32(1)
)

func (x *CachePoolInfoProto) Reset() {
	*x = CachePoolInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CachePoolInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CachePoolInfoProto) ProtoMessage() {}

func (x *CachePoolInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CachePoolInfoProto.ProtoReflect.Descriptor instead.
func (*CachePoolInfoProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{110}
}

func (x *CachePoolInfoProto) GetPoolName() string {
	if x != nil && x.PoolName != nil {
		return *x.PoolName
	}
	return ""
}

func (x *CachePoolInfoProto) GetOwnerName() string {
	if x != nil && x.OwnerName != nil {
		return *x.OwnerName
	}
	return ""
}

func (x *CachePoolInfoProto) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *CachePoolInfoProto) GetMode() int32 {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return 0
}

func (x *CachePoolInfoProto) GetLimit() int64 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

func (x *CachePoolInfoProto) GetMaxRelativeExpiry() int64 {
	if x != nil && x.MaxRelativeExpiry != nil {
		return *x.MaxRelativeExpiry
	}
	return 0
}

func (x *CachePoolInfoProto) GetDefaultReplication() uint32 {
	if x != nil && x.DefaultReplication != nil {
		return *x.DefaultReplication
	}
	return Default_CachePoolInfoProto_DefaultReplication
}

type CachePoolStatsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BytesNeeded    *int64 `protobuf:"varint,1,req,name=bytesNeeded" json:"bytesNeeded,omitempty"`
	BytesCached    *int64 `protobuf:"varint,2,req,name=bytesCached" json:"bytesCached,omitempty"`
	BytesOverlimit *int64 `protobuf:"varint,3,req,name=bytesOverlimit" json:"bytesOverlimit,omitempty"`
	FilesNeeded    *int64 `protobuf:"varint,4,req,name=filesNeeded" json:"filesNeeded,omitempty"`
	FilesCached    *int64 `protobuf:"varint,5,req,name=filesCached" json:"filesCached,omitempty"`
}

func (x *CachePoolStatsProto) Reset() {
	*x = CachePoolStatsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CachePoolStatsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CachePoolStatsProto) ProtoMessage() {}

func (x *CachePoolStatsProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CachePoolStatsProto.ProtoReflect.Descriptor instead.
func (*CachePoolStatsProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{111}
}

func (x *CachePoolStatsProto) GetBytesNeeded() int64 {
	if x != nil && x.BytesNeeded != nil {
		return *x.BytesNeeded
	}
	return 0
}

func (x *CachePoolStatsProto) GetBytesCached() int64 {
	if x != nil && x.BytesCached != nil {
		return *x.BytesCached
	}
	return 0
}

func (x *CachePoolStatsProto) GetBytesOverlimit() int64 {
	if x != nil && x.BytesOverlimit != nil {
		return *x.BytesOverlimit
	}
	return 0
}

func (x *CachePoolStatsProto) GetFilesNeeded() int64 {
	if x != nil && x.FilesNeeded != nil {
		return *x.FilesNeeded
	}
	return 0
}

func (x *CachePoolStatsProto) GetFilesCached() int64 {
	if x != nil && x.FilesCached != nil {
		return *x.FilesCached
	}
	return 0
}

type AddCachePoolRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info *CachePoolInfoProto `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
}

func (x *AddCachePoolRequestProto) Reset() {
	*x = AddCachePoolRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCachePoolRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCachePoolRequestProto) ProtoMessage() {}

func (x *AddCachePoolRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCachePoolRequestProto.ProtoReflect.Descriptor instead.
func (*AddCachePoolRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{112}
}

func (x *AddCachePoolRequestProto) GetInfo() *CachePoolInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

type AddCachePoolResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddCachePoolResponseProto) Reset() {
	*x = AddCachePoolResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCachePoolResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCachePoolResponseProto) ProtoMessage() {}

func (x *AddCachePoolResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCachePoolResponseProto.ProtoReflect.Descriptor instead.
func (*AddCachePoolResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{113}
}

type ModifyCachePoolRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info *CachePoolInfoProto `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
}

func (x *ModifyCachePoolRequestProto) Reset() {
	*x = ModifyCachePoolRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyCachePoolRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyCachePoolRequestProto) ProtoMessage() {}

func (x *ModifyCachePoolRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyCachePoolRequestProto.ProtoReflect.Descriptor instead.
func (*ModifyCachePoolRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{114}
}

func (x *ModifyCachePoolRequestProto) GetInfo() *CachePoolInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

type ModifyCachePoolResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ModifyCachePoolResponseProto) Reset() {
	*x = ModifyCachePoolResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyCachePoolResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyCachePoolResponseProto) ProtoMessage() {}

func (x *ModifyCachePoolResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyCachePoolResponseProto.ProtoReflect.Descriptor instead.
func (*ModifyCachePoolResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{115}
}

type RemoveCachePoolRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PoolName *string `protobuf:"bytes,1,req,name=poolName" json:"poolName,omitempty"`
}

func (x *RemoveCachePoolRequestProto) Reset() {
	*x = RemoveCachePoolRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCachePoolRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCachePoolRequestProto) ProtoMessage() {}

func (x *RemoveCachePoolRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCachePoolRequestProto.ProtoReflect.Descriptor instead.
func (*RemoveCachePoolRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{116}
}

func (x *RemoveCachePoolRequestProto) GetPoolName() string {
	if x != nil && x.PoolName != nil {
		return *x.PoolName
	}
	return ""
}

type RemoveCachePoolResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveCachePoolResponseProto) Reset() {
	*x = RemoveCachePoolResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCachePoolResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCachePoolResponseProto) ProtoMessage() {}

func (x *RemoveCachePoolResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCachePoolResponseProto.ProtoReflect.Descriptor instead.
func (*RemoveCachePoolResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{117}
}

type ListCachePoolsRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrevPoolName *string `protobuf:"bytes,1,req,name=prevPoolName" json:"prevPoolName,omitempty"`
}

func (x *ListCachePoolsRequestProto) Reset() {
	*x = ListCachePoolsRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCachePoolsRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCachePoolsRequestProto) ProtoMessage() {}

func (x *ListCachePoolsRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCachePoolsRequestProto.ProtoReflect.Descriptor instead.
func (*ListCachePoolsRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{118}
}

func (x *ListCachePoolsRequestProto) GetPrevPoolName() string {
	if x != nil && x.PrevPoolName != nil {
		return *x.PrevPoolName
	}
	return ""
}

type ListCachePoolsResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entries []*CachePoolEntryProto `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	HasMore *bool                  `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
}

func (x *ListCachePoolsResponseProto) Reset() {
	*x = ListCachePoolsResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCachePoolsResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCachePoolsResponseProto) ProtoMessage() {}

func (x *ListCachePoolsResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCachePoolsResponseProto.ProtoReflect.Descriptor instead.
func (*ListCachePoolsResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{119}
}

func (x *ListCachePoolsResponseProto) GetEntries() []*CachePoolEntryProto {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListCachePoolsResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

type CachePoolEntryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info  *CachePoolInfoProto  `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
	Stats *CachePoolStatsProto `protobuf:"bytes,2,req,name=stats" json:"stats,omitempty"`
}

func (x *CachePoolEntryProto) Reset() {
	*x = CachePoolEntryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CachePoolEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CachePoolEntryProto) ProtoMessage() {}

func (x *CachePoolEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CachePoolEntryProto.ProtoReflect.Descriptor instead.
func (*CachePoolEntryProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{120}
}

func (x *CachePoolEntryProto) GetInfo() *CachePoolInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *CachePoolEntryProto) GetStats() *CachePoolStatsProto {
	if x != nil {
		return x.Stats
	}
	return nil
}

type GetFileLinkInfoRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *GetFileLinkInfoRequestProto) Reset() {
	*x = GetFileLinkInfoRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFileLinkInfoRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileLinkInfoRequestProto) ProtoMessage() {}

func (x *GetFileLinkInfoRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileLinkInfoRequestProto.ProtoReflect.Descriptor instead.
func (*GetFileLinkInfoRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{121}
}

func (x *GetFileLinkInfoRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type GetFileLinkInfoResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fs *HdfsFileStatusProto `protobuf:"bytes,1,opt,name=fs" json:"fs,omitempty"`
}

func (x *GetFileLinkInfoResponseProto) Reset() {
	*x = GetFileLinkInfoResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFileLinkInfoResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileLinkInfoResponseProto) ProtoMessage() {}

func (x *GetFileLinkInfoResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileLinkInfoResponseProto.ProtoReflect.Descriptor instead.
func (*GetFileLinkInfoResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{122}
}

func (x *GetFileLinkInfoResponseProto) GetFs() *HdfsFileStatusProto {
	if x != nil {
		return x.Fs
	}
	return nil
}

type GetContentSummaryRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
}

func (x *GetContentSummaryRequestProto) Reset() {
	*x = GetContentSummaryRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetContentSummaryRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetContentSummaryRequestProto) ProtoMessage() {}

func (x *GetContentSummaryRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetContentSummaryRequestProto.ProtoReflect.Descriptor instead.
func (*GetContentSummaryRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{123}
}

func (x *GetContentSummaryRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

type GetContentSummaryResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Summary *ContentSummaryProto `protobuf:"bytes,1,req,name=summary" json:"summary,omitempty"`
}

func (x *GetContentSummaryResponseProto) Reset() {
	*x = GetContentSummaryResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetContentSummaryResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetContentSummaryResponseProto) ProtoMessage() {}

func (x *GetContentSummaryResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetContentSummaryResponseProto.ProtoReflect.Descriptor instead.
func (*GetContentSummaryResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{124}
}

func (x *GetContentSummaryResponseProto) GetSummary() *ContentSummaryProto {
	if x != nil {
		return x.Summary
	}
	return nil
}

type GetQuotaUsageRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
}

func (x *GetQuotaUsageRequestProto) Reset() {
	*x = GetQuotaUsageRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetQuotaUsageRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQuotaUsageRequestProto) ProtoMessage() {}

func (x *GetQuotaUsageRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQuotaUsageRequestProto.ProtoReflect.Descriptor instead.
func (*GetQuotaUsageRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{125}
}

func (x *GetQuotaUsageRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

type GetQuotaUsageResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Usage *QuotaUsageProto `protobuf:"bytes,1,req,name=usage" json:"usage,omitempty"`
}

func (x *GetQuotaUsageResponseProto) Reset() {
	*x = GetQuotaUsageResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetQuotaUsageResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQuotaUsageResponseProto) ProtoMessage() {}

func (x *GetQuotaUsageResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQuotaUsageResponseProto.ProtoReflect.Descriptor instead.
func (*GetQuotaUsageResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{126}
}

func (x *GetQuotaUsageResponseProto) GetUsage() *QuotaUsageProto {
	if x != nil {
		return x.Usage
	}
	return nil
}

type SetQuotaRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path              *string           `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	NamespaceQuota    *uint64           `protobuf:"varint,2,req,name=namespaceQuota" json:"namespaceQuota,omitempty"`
	StoragespaceQuota *uint64           `protobuf:"varint,3,req,name=storagespaceQuota" json:"storagespaceQuota,omitempty"`
	StorageType       *StorageTypeProto `protobuf:"varint,4,opt,name=storageType,enum=hadoop.hdfs.StorageTypeProto" json:"storageType,omitempty"`
}

func (x *SetQuotaRequestProto) Reset() {
	*x = SetQuotaRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetQuotaRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetQuotaRequestProto) ProtoMessage() {}

func (x *SetQuotaRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetQuotaRequestProto.ProtoReflect.Descriptor instead.
func (*SetQuotaRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{127}
}

func (x *SetQuotaRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *SetQuotaRequestProto) GetNamespaceQuota() uint64 {
	if x != nil && x.NamespaceQuota != nil {
		return *x.NamespaceQuota
	}
	return 0
}

func (x *SetQuotaRequestProto) GetStoragespaceQuota() uint64 {
	if x != nil && x.StoragespaceQuota != nil {
		return *x.StoragespaceQuota
	}
	return 0
}

func (x *SetQuotaRequestProto) GetStorageType() StorageTypeProto {
	if x != nil && x.StorageType != nil {
		return *x.StorageType
	}
	return StorageTypeProto_DISK
}

type SetQuotaResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetQuotaResponseProto) Reset() {
	*x = SetQuotaResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetQuotaResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetQuotaResponseProto) ProtoMessage() {}

func (x *SetQuotaResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetQuotaResponseProto.ProtoReflect.Descriptor instead.
func (*SetQuotaResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{128}
}

type FsyncRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src             *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Client          *string `protobuf:"bytes,2,req,name=client" json:"client,omitempty"`
	LastBlockLength *int64  `protobuf:"zigzag64,3,opt,name=lastBlockLength,def=-1" json:"lastBlockLength,omitempty"`
	FileId          *uint64 `protobuf:"varint,4,opt,name=fileId,def=0" json:"fileId,omitempty"` // default to GRANDFATHER_INODE_ID
}

// Default values for FsyncRequestProto fields.
const (
	Default_FsyncRequestProto_LastBlockLength = int64(-1)
	Default_FsyncRequestProto_FileId          = uint64(0)
)

func (x *FsyncRequestProto) Reset() {
	*x = FsyncRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FsyncRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FsyncRequestProto) ProtoMessage() {}

func (x *FsyncRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FsyncRequestProto.ProtoReflect.Descriptor instead.
func (*FsyncRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{129}
}

func (x *FsyncRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *FsyncRequestProto) GetClient() string {
	if x != nil && x.Client != nil {
		return *x.Client
	}
	return ""
}

func (x *FsyncRequestProto) GetLastBlockLength() int64 {
	if x != nil && x.LastBlockLength != nil {
		return *x.LastBlockLength
	}
	return Default_FsyncRequestProto_LastBlockLength
}

func (x *FsyncRequestProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_FsyncRequestProto_FileId
}

type FsyncResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FsyncResponseProto) Reset() {
	*x = FsyncResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FsyncResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FsyncResponseProto) ProtoMessage() {}

func (x *FsyncResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FsyncResponseProto.ProtoReflect.Descriptor instead.
func (*FsyncResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{130}
}

type SetTimesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src   *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	Mtime *uint64 `protobuf:"varint,2,req,name=mtime" json:"mtime,omitempty"`
	Atime *uint64 `protobuf:"varint,3,req,name=atime" json:"atime,omitempty"`
}

func (x *SetTimesRequestProto) Reset() {
	*x = SetTimesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetTimesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTimesRequestProto) ProtoMessage() {}

func (x *SetTimesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTimesRequestProto.ProtoReflect.Descriptor instead.
func (*SetTimesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{131}
}

func (x *SetTimesRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *SetTimesRequestProto) GetMtime() uint64 {
	if x != nil && x.Mtime != nil {
		return *x.Mtime
	}
	return 0
}

func (x *SetTimesRequestProto) GetAtime() uint64 {
	if x != nil && x.Atime != nil {
		return *x.Atime
	}
	return 0
}

type SetTimesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetTimesResponseProto) Reset() {
	*x = SetTimesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetTimesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTimesResponseProto) ProtoMessage() {}

func (x *SetTimesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTimesResponseProto.ProtoReflect.Descriptor instead.
func (*SetTimesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{132}
}

type CreateSymlinkRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Target       *string            `protobuf:"bytes,1,req,name=target" json:"target,omitempty"`
	Link         *string            `protobuf:"bytes,2,req,name=link" json:"link,omitempty"`
	DirPerm      *FsPermissionProto `protobuf:"bytes,3,req,name=dirPerm" json:"dirPerm,omitempty"`
	CreateParent *bool              `protobuf:"varint,4,req,name=createParent" json:"createParent,omitempty"`
}

func (x *CreateSymlinkRequestProto) Reset() {
	*x = CreateSymlinkRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSymlinkRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSymlinkRequestProto) ProtoMessage() {}

func (x *CreateSymlinkRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSymlinkRequestProto.ProtoReflect.Descriptor instead.
func (*CreateSymlinkRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{133}
}

func (x *CreateSymlinkRequestProto) GetTarget() string {
	if x != nil && x.Target != nil {
		return *x.Target
	}
	return ""
}

func (x *CreateSymlinkRequestProto) GetLink() string {
	if x != nil && x.Link != nil {
		return *x.Link
	}
	return ""
}

func (x *CreateSymlinkRequestProto) GetDirPerm() *FsPermissionProto {
	if x != nil {
		return x.DirPerm
	}
	return nil
}

func (x *CreateSymlinkRequestProto) GetCreateParent() bool {
	if x != nil && x.CreateParent != nil {
		return *x.CreateParent
	}
	return false
}

type CreateSymlinkResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateSymlinkResponseProto) Reset() {
	*x = CreateSymlinkResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSymlinkResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSymlinkResponseProto) ProtoMessage() {}

func (x *CreateSymlinkResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSymlinkResponseProto.ProtoReflect.Descriptor instead.
func (*CreateSymlinkResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{134}
}

type GetLinkTargetRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
}

func (x *GetLinkTargetRequestProto) Reset() {
	*x = GetLinkTargetRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLinkTargetRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLinkTargetRequestProto) ProtoMessage() {}

func (x *GetLinkTargetRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLinkTargetRequestProto.ProtoReflect.Descriptor instead.
func (*GetLinkTargetRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{135}
}

func (x *GetLinkTargetRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

type GetLinkTargetResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TargetPath *string `protobuf:"bytes,1,opt,name=targetPath" json:"targetPath,omitempty"`
}

func (x *GetLinkTargetResponseProto) Reset() {
	*x = GetLinkTargetResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLinkTargetResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLinkTargetResponseProto) ProtoMessage() {}

func (x *GetLinkTargetResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLinkTargetResponseProto.ProtoReflect.Descriptor instead.
func (*GetLinkTargetResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{136}
}

func (x *GetLinkTargetResponseProto) GetTargetPath() string {
	if x != nil && x.TargetPath != nil {
		return *x.TargetPath
	}
	return ""
}

type UpdateBlockForPipelineRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block      *ExtendedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
	ClientName *string             `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
}

func (x *UpdateBlockForPipelineRequestProto) Reset() {
	*x = UpdateBlockForPipelineRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBlockForPipelineRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBlockForPipelineRequestProto) ProtoMessage() {}

func (x *UpdateBlockForPipelineRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBlockForPipelineRequestProto.ProtoReflect.Descriptor instead.
func (*UpdateBlockForPipelineRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{137}
}

func (x *UpdateBlockForPipelineRequestProto) GetBlock() *ExtendedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *UpdateBlockForPipelineRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

type UpdateBlockForPipelineResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *LocatedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
}

func (x *UpdateBlockForPipelineResponseProto) Reset() {
	*x = UpdateBlockForPipelineResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBlockForPipelineResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBlockForPipelineResponseProto) ProtoMessage() {}

func (x *UpdateBlockForPipelineResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBlockForPipelineResponseProto.ProtoReflect.Descriptor instead.
func (*UpdateBlockForPipelineResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{138}
}

func (x *UpdateBlockForPipelineResponseProto) GetBlock() *LocatedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

type UpdatePipelineRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientName *string             `protobuf:"bytes,1,req,name=clientName" json:"clientName,omitempty"`
	OldBlock   *ExtendedBlockProto `protobuf:"bytes,2,req,name=oldBlock" json:"oldBlock,omitempty"`
	NewBlock   *ExtendedBlockProto `protobuf:"bytes,3,req,name=newBlock" json:"newBlock,omitempty"`
	NewNodes   []*DatanodeIDProto  `protobuf:"bytes,4,rep,name=newNodes" json:"newNodes,omitempty"`
	StorageIDs []string            `protobuf:"bytes,5,rep,name=storageIDs" json:"storageIDs,omitempty"`
}

func (x *UpdatePipelineRequestProto) Reset() {
	*x = UpdatePipelineRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePipelineRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePipelineRequestProto) ProtoMessage() {}

func (x *UpdatePipelineRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePipelineRequestProto.ProtoReflect.Descriptor instead.
func (*UpdatePipelineRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{139}
}

func (x *UpdatePipelineRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *UpdatePipelineRequestProto) GetOldBlock() *ExtendedBlockProto {
	if x != nil {
		return x.OldBlock
	}
	return nil
}

func (x *UpdatePipelineRequestProto) GetNewBlock() *ExtendedBlockProto {
	if x != nil {
		return x.NewBlock
	}
	return nil
}

func (x *UpdatePipelineRequestProto) GetNewNodes() []*DatanodeIDProto {
	if x != nil {
		return x.NewNodes
	}
	return nil
}

func (x *UpdatePipelineRequestProto) GetStorageIDs() []string {
	if x != nil {
		return x.StorageIDs
	}
	return nil
}

type UpdatePipelineResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdatePipelineResponseProto) Reset() {
	*x = UpdatePipelineResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePipelineResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePipelineResponseProto) ProtoMessage() {}

func (x *UpdatePipelineResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePipelineResponseProto.ProtoReflect.Descriptor instead.
func (*UpdatePipelineResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{140}
}

type SetBalancerBandwidthRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bandwidth *int64 `protobuf:"varint,1,req,name=bandwidth" json:"bandwidth,omitempty"`
}

func (x *SetBalancerBandwidthRequestProto) Reset() {
	*x = SetBalancerBandwidthRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBalancerBandwidthRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBalancerBandwidthRequestProto) ProtoMessage() {}

func (x *SetBalancerBandwidthRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBalancerBandwidthRequestProto.ProtoReflect.Descriptor instead.
func (*SetBalancerBandwidthRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{141}
}

func (x *SetBalancerBandwidthRequestProto) GetBandwidth() int64 {
	if x != nil && x.Bandwidth != nil {
		return *x.Bandwidth
	}
	return 0
}

type SetBalancerBandwidthResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetBalancerBandwidthResponseProto) Reset() {
	*x = SetBalancerBandwidthResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBalancerBandwidthResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBalancerBandwidthResponseProto) ProtoMessage() {}

func (x *SetBalancerBandwidthResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBalancerBandwidthResponseProto.ProtoReflect.Descriptor instead.
func (*SetBalancerBandwidthResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{142}
}

type GetDataEncryptionKeyRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetDataEncryptionKeyRequestProto) Reset() {
	*x = GetDataEncryptionKeyRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataEncryptionKeyRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataEncryptionKeyRequestProto) ProtoMessage() {}

func (x *GetDataEncryptionKeyRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataEncryptionKeyRequestProto.ProtoReflect.Descriptor instead.
func (*GetDataEncryptionKeyRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{143}
}

type GetDataEncryptionKeyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataEncryptionKey *DataEncryptionKeyProto `protobuf:"bytes,1,opt,name=dataEncryptionKey" json:"dataEncryptionKey,omitempty"`
}

func (x *GetDataEncryptionKeyResponseProto) Reset() {
	*x = GetDataEncryptionKeyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataEncryptionKeyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataEncryptionKeyResponseProto) ProtoMessage() {}

func (x *GetDataEncryptionKeyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataEncryptionKeyResponseProto.ProtoReflect.Descriptor instead.
func (*GetDataEncryptionKeyResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{144}
}

func (x *GetDataEncryptionKeyResponseProto) GetDataEncryptionKey() *DataEncryptionKeyProto {
	if x != nil {
		return x.DataEncryptionKey
	}
	return nil
}

type CreateSnapshotRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	SnapshotName *string `protobuf:"bytes,2,opt,name=snapshotName" json:"snapshotName,omitempty"`
}

func (x *CreateSnapshotRequestProto) Reset() {
	*x = CreateSnapshotRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSnapshotRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotRequestProto) ProtoMessage() {}

func (x *CreateSnapshotRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotRequestProto.ProtoReflect.Descriptor instead.
func (*CreateSnapshotRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{145}
}

func (x *CreateSnapshotRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *CreateSnapshotRequestProto) GetSnapshotName() string {
	if x != nil && x.SnapshotName != nil {
		return *x.SnapshotName
	}
	return ""
}

type CreateSnapshotResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotPath *string `protobuf:"bytes,1,req,name=snapshotPath" json:"snapshotPath,omitempty"`
}

func (x *CreateSnapshotResponseProto) Reset() {
	*x = CreateSnapshotResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSnapshotResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotResponseProto) ProtoMessage() {}

func (x *CreateSnapshotResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotResponseProto.ProtoReflect.Descriptor instead.
func (*CreateSnapshotResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{146}
}

func (x *CreateSnapshotResponseProto) GetSnapshotPath() string {
	if x != nil && x.SnapshotPath != nil {
		return *x.SnapshotPath
	}
	return ""
}

type RenameSnapshotRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot    *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	SnapshotOldName *string `protobuf:"bytes,2,req,name=snapshotOldName" json:"snapshotOldName,omitempty"`
	SnapshotNewName *string `protobuf:"bytes,3,req,name=snapshotNewName" json:"snapshotNewName,omitempty"`
}

func (x *RenameSnapshotRequestProto) Reset() {
	*x = RenameSnapshotRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameSnapshotRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameSnapshotRequestProto) ProtoMessage() {}

func (x *RenameSnapshotRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameSnapshotRequestProto.ProtoReflect.Descriptor instead.
func (*RenameSnapshotRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{147}
}

func (x *RenameSnapshotRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *RenameSnapshotRequestProto) GetSnapshotOldName() string {
	if x != nil && x.SnapshotOldName != nil {
		return *x.SnapshotOldName
	}
	return ""
}

func (x *RenameSnapshotRequestProto) GetSnapshotNewName() string {
	if x != nil && x.SnapshotNewName != nil {
		return *x.SnapshotNewName
	}
	return ""
}

type RenameSnapshotResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RenameSnapshotResponseProto) Reset() {
	*x = RenameSnapshotResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameSnapshotResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameSnapshotResponseProto) ProtoMessage() {}

func (x *RenameSnapshotResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameSnapshotResponseProto.ProtoReflect.Descriptor instead.
func (*RenameSnapshotResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{148}
}

type AllowSnapshotRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
}

func (x *AllowSnapshotRequestProto) Reset() {
	*x = AllowSnapshotRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllowSnapshotRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllowSnapshotRequestProto) ProtoMessage() {}

func (x *AllowSnapshotRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllowSnapshotRequestProto.ProtoReflect.Descriptor instead.
func (*AllowSnapshotRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{149}
}

func (x *AllowSnapshotRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

type AllowSnapshotResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AllowSnapshotResponseProto) Reset() {
	*x = AllowSnapshotResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllowSnapshotResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllowSnapshotResponseProto) ProtoMessage() {}

func (x *AllowSnapshotResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllowSnapshotResponseProto.ProtoReflect.Descriptor instead.
func (*AllowSnapshotResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{150}
}

type DisallowSnapshotRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
}

func (x *DisallowSnapshotRequestProto) Reset() {
	*x = DisallowSnapshotRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisallowSnapshotRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisallowSnapshotRequestProto) ProtoMessage() {}

func (x *DisallowSnapshotRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisallowSnapshotRequestProto.ProtoReflect.Descriptor instead.
func (*DisallowSnapshotRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{151}
}

func (x *DisallowSnapshotRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

type DisallowSnapshotResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisallowSnapshotResponseProto) Reset() {
	*x = DisallowSnapshotResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisallowSnapshotResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisallowSnapshotResponseProto) ProtoMessage() {}

func (x *DisallowSnapshotResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisallowSnapshotResponseProto.ProtoReflect.Descriptor instead.
func (*DisallowSnapshotResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{152}
}

type DeleteSnapshotRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotRoot *string `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	SnapshotName *string `protobuf:"bytes,2,req,name=snapshotName" json:"snapshotName,omitempty"`
}

func (x *DeleteSnapshotRequestProto) Reset() {
	*x = DeleteSnapshotRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSnapshotRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotRequestProto) ProtoMessage() {}

func (x *DeleteSnapshotRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotRequestProto.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{153}
}

func (x *DeleteSnapshotRequestProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *DeleteSnapshotRequestProto) GetSnapshotName() string {
	if x != nil && x.SnapshotName != nil {
		return *x.SnapshotName
	}
	return ""
}

type DeleteSnapshotResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteSnapshotResponseProto) Reset() {
	*x = DeleteSnapshotResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSnapshotResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotResponseProto) ProtoMessage() {}

func (x *DeleteSnapshotResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotResponseProto.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{154}
}

type CheckAccessRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string                      `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Mode *AclEntryProto_FsActionProto `protobuf:"varint,2,req,name=mode,enum=hadoop.hdfs.AclEntryProto_FsActionProto" json:"mode,omitempty"`
}

func (x *CheckAccessRequestProto) Reset() {
	*x = CheckAccessRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckAccessRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAccessRequestProto) ProtoMessage() {}

func (x *CheckAccessRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAccessRequestProto.ProtoReflect.Descriptor instead.
func (*CheckAccessRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{155}
}

func (x *CheckAccessRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *CheckAccessRequestProto) GetMode() AclEntryProto_FsActionProto {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return AclEntryProto_NONE
}

type CheckAccessResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CheckAccessResponseProto) Reset() {
	*x = CheckAccessResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckAccessResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAccessResponseProto) ProtoMessage() {}

func (x *CheckAccessResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAccessResponseProto.ProtoReflect.Descriptor instead.
func (*CheckAccessResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{156}
}

type GetCurrentEditLogTxidRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetCurrentEditLogTxidRequestProto) Reset() {
	*x = GetCurrentEditLogTxidRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCurrentEditLogTxidRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCurrentEditLogTxidRequestProto) ProtoMessage() {}

func (x *GetCurrentEditLogTxidRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCurrentEditLogTxidRequestProto.ProtoReflect.Descriptor instead.
func (*GetCurrentEditLogTxidRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{157}
}

type GetCurrentEditLogTxidResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Txid *int64 `protobuf:"varint,1,req,name=txid" json:"txid,omitempty"`
}

func (x *GetCurrentEditLogTxidResponseProto) Reset() {
	*x = GetCurrentEditLogTxidResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCurrentEditLogTxidResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCurrentEditLogTxidResponseProto) ProtoMessage() {}

func (x *GetCurrentEditLogTxidResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCurrentEditLogTxidResponseProto.ProtoReflect.Descriptor instead.
func (*GetCurrentEditLogTxidResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{158}
}

func (x *GetCurrentEditLogTxidResponseProto) GetTxid() int64 {
	if x != nil && x.Txid != nil {
		return *x.Txid
	}
	return 0
}

type GetEditsFromTxidRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Txid *int64 `protobuf:"varint,1,req,name=txid" json:"txid,omitempty"`
}

func (x *GetEditsFromTxidRequestProto) Reset() {
	*x = GetEditsFromTxidRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[159]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEditsFromTxidRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEditsFromTxidRequestProto) ProtoMessage() {}

func (x *GetEditsFromTxidRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[159]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEditsFromTxidRequestProto.ProtoReflect.Descriptor instead.
func (*GetEditsFromTxidRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{159}
}

func (x *GetEditsFromTxidRequestProto) GetTxid() int64 {
	if x != nil && x.Txid != nil {
		return *x.Txid
	}
	return 0
}

type GetEditsFromTxidResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EventsList *EventsListProto `protobuf:"bytes,1,req,name=eventsList" json:"eventsList,omitempty"`
}

func (x *GetEditsFromTxidResponseProto) Reset() {
	*x = GetEditsFromTxidResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEditsFromTxidResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEditsFromTxidResponseProto) ProtoMessage() {}

func (x *GetEditsFromTxidResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEditsFromTxidResponseProto.ProtoReflect.Descriptor instead.
func (*GetEditsFromTxidResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{160}
}

func (x *GetEditsFromTxidResponseProto) GetEventsList() *EventsListProto {
	if x != nil {
		return x.EventsList
	}
	return nil
}

type ListOpenFilesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id    *int64               `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
	Types []OpenFilesTypeProto `protobuf:"varint,2,rep,name=types,enum=hadoop.hdfs.OpenFilesTypeProto" json:"types,omitempty"`
	Path  *string              `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
}

func (x *ListOpenFilesRequestProto) Reset() {
	*x = ListOpenFilesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[161]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOpenFilesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOpenFilesRequestProto) ProtoMessage() {}

func (x *ListOpenFilesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[161]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOpenFilesRequestProto.ProtoReflect.Descriptor instead.
func (*ListOpenFilesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{161}
}

func (x *ListOpenFilesRequestProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ListOpenFilesRequestProto) GetTypes() []OpenFilesTypeProto {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *ListOpenFilesRequestProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

type OpenFilesBatchResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id            *int64  `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
	Path          *string `protobuf:"bytes,2,req,name=path" json:"path,omitempty"`
	ClientName    *string `protobuf:"bytes,3,req,name=clientName" json:"clientName,omitempty"`
	ClientMachine *string `protobuf:"bytes,4,req,name=clientMachine" json:"clientMachine,omitempty"`
}

func (x *OpenFilesBatchResponseProto) Reset() {
	*x = OpenFilesBatchResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[162]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenFilesBatchResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenFilesBatchResponseProto) ProtoMessage() {}

func (x *OpenFilesBatchResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[162]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenFilesBatchResponseProto.ProtoReflect.Descriptor instead.
func (*OpenFilesBatchResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{162}
}

func (x *OpenFilesBatchResponseProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *OpenFilesBatchResponseProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *OpenFilesBatchResponseProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *OpenFilesBatchResponseProto) GetClientMachine() string {
	if x != nil && x.ClientMachine != nil {
		return *x.ClientMachine
	}
	return ""
}

type ListOpenFilesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entries []*OpenFilesBatchResponseProto `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	HasMore *bool                          `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
	Types   []OpenFilesTypeProto           `protobuf:"varint,3,rep,name=types,enum=hadoop.hdfs.OpenFilesTypeProto" json:"types,omitempty"`
}

func (x *ListOpenFilesResponseProto) Reset() {
	*x = ListOpenFilesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOpenFilesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOpenFilesResponseProto) ProtoMessage() {}

func (x *ListOpenFilesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOpenFilesResponseProto.ProtoReflect.Descriptor instead.
func (*ListOpenFilesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{163}
}

func (x *ListOpenFilesResponseProto) GetEntries() []*OpenFilesBatchResponseProto {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListOpenFilesResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

func (x *ListOpenFilesResponseProto) GetTypes() []OpenFilesTypeProto {
	if x != nil {
		return x.Types
	}
	return nil
}

type MsyncRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MsyncRequestProto) Reset() {
	*x = MsyncRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MsyncRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MsyncRequestProto) ProtoMessage() {}

func (x *MsyncRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MsyncRequestProto.ProtoReflect.Descriptor instead.
func (*MsyncRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{164}
}

type MsyncResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MsyncResponseProto) Reset() {
	*x = MsyncResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MsyncResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MsyncResponseProto) ProtoMessage() {}

func (x *MsyncResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MsyncResponseProto.ProtoReflect.Descriptor instead.
func (*MsyncResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{165}
}

type SatisfyStoragePolicyRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *SatisfyStoragePolicyRequestProto) Reset() {
	*x = SatisfyStoragePolicyRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SatisfyStoragePolicyRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SatisfyStoragePolicyRequestProto) ProtoMessage() {}

func (x *SatisfyStoragePolicyRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SatisfyStoragePolicyRequestProto.ProtoReflect.Descriptor instead.
func (*SatisfyStoragePolicyRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{166}
}

func (x *SatisfyStoragePolicyRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type SatisfyStoragePolicyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SatisfyStoragePolicyResponseProto) Reset() {
	*x = SatisfyStoragePolicyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SatisfyStoragePolicyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SatisfyStoragePolicyResponseProto) ProtoMessage() {}

func (x *SatisfyStoragePolicyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SatisfyStoragePolicyResponseProto.ProtoReflect.Descriptor instead.
func (*SatisfyStoragePolicyResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{167}
}

type HAServiceStateRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HAServiceStateRequestProto) Reset() {
	*x = HAServiceStateRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HAServiceStateRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HAServiceStateRequestProto) ProtoMessage() {}

func (x *HAServiceStateRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HAServiceStateRequestProto.ProtoReflect.Descriptor instead.
func (*HAServiceStateRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{168}
}

type HAServiceStateResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State *hadoop_common.HAServiceStateProto `protobuf:"varint,1,req,name=state,enum=hadoop.common.HAServiceStateProto" json:"state,omitempty"`
}

func (x *HAServiceStateResponseProto) Reset() {
	*x = HAServiceStateResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientNamenodeProtocol_proto_msgTypes[169]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HAServiceStateResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HAServiceStateResponseProto) ProtoMessage() {}

func (x *HAServiceStateResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientNamenodeProtocol_proto_msgTypes[169]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HAServiceStateResponseProto.ProtoReflect.Descriptor instead.
func (*HAServiceStateResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientNamenodeProtocol_proto_rawDescGZIP(), []int{169}
}

func (x *HAServiceStateResponseProto) GetState() hadoop_common.HAServiceStateProto {
	if x != nil && x.State != nil {
		return *x.State
	}
	return hadoop_common.HAServiceStateProto(0)
}

var File_ClientNamenodeProtocol_proto protoreflect.FileDescriptor

var file_ClientNamenodeProtocol_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a, 0x0e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0a, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x09, 0x61, 0x63, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x0b, 0x78, 0x61, 0x74, 0x74, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x0d, 0x69, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x13, 0x65, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x48, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x61,
	0x0a, 0x1d, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72,
	0x63, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x22, 0x5f, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x1f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x6c, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x22, 0xe7, 0x03, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x36, 0x0a, 0x06, 0x6d, 0x61,
	0x73, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x6d, 0x61, 0x73, 0x6b,
	0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x61, 0x67,
	0x18, 0x04, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6c,
	0x61, 0x67, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0b, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x5d, 0x0a, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x15,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x08, 0x75, 0x6e, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x75, 0x6e, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x12, 0x22, 0x0a, 0x0c, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x47, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x30, 0x0a, 0x02, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66,
	0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x02, 0x66, 0x73, 0x22, 0x5a, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72,
	0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x66, 0x6c, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67,
	0x22, 0x81, 0x01, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x34, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x34,
	0x0a, 0x04, 0x73, 0x74, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04,
	0x73, 0x74, 0x61, 0x74, 0x22, 0x50, 0x0a, 0x1a, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x72, 0x63, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x35, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x50, 0x0a,
	0x1c, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12,
	0x1e, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0x1f, 0x0a, 0x1d, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x32, 0x0a, 0x1e, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x72, 0x63, 0x22, 0x21, 0x0a, 0x1f, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x32, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x6b, 0x0a, 0x1d, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4a, 0x0a, 0x0d,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x20, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x63, 0x0a, 0x1f, 0x47, 0x65,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x40, 0x0a,
	0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22,
	0x6d, 0x0a, 0x19, 0x53, 0x65, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03,
	0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x3e,
	0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x1c,
	0x0a, 0x1a, 0x53, 0x65, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x62, 0x0a, 0x14,
	0x53, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x17, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x18, 0x41, 0x62,
	0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x0a, 0x01, 0x62, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x01, 0x62, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12,
	0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a,
	0x01, 0x30, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x1b, 0x0a, 0x19, 0x41, 0x62,
	0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x02, 0x0a, 0x14, 0x41, 0x64, 0x64, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x72, 0x63, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x12,
	0x42, 0x0a, 0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x22,
	0x0a, 0x0c, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x41, 0x64, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x46, 0x6c, 0x61, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x4d, 0x0a, 0x15, 0x41, 0x64, 0x64, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x81, 0x03, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x41,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12,
	0x31, 0x0a, 0x03, 0x62, 0x6c, 0x6b, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x03, 0x62,
	0x6c, 0x6b, 0x12, 0x3c, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x12,
	0x6e, 0x75, 0x6d, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x12, 0x6e, 0x75, 0x6d, 0x41, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x14,
	0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55,
	0x75, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73,
	0x12, 0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x5a, 0x0a, 0x22, 0x47,
	0x65, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x98, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x72, 0x63, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x6c, 0x61, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x04, 0x6c, 0x61, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x22, 0x2f, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x22, 0x55, 0x0a, 0x1b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x64,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x36, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x1e, 0x0a, 0x1c, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3a, 0x0a, 0x12, 0x43, 0x6f,
	0x6e, 0x63, 0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x74, 0x72, 0x67, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x74,
	0x72, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x72, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x04, 0x73, 0x72, 0x63, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x63, 0x61, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x66, 0x0a,
	0x14, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x4c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x15, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x38, 0x0a, 0x12, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03,
	0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x10,
	0x0a, 0x03, 0x64, 0x73, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x64, 0x73, 0x74,
	0x22, 0x2d, 0x0a, 0x13, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x81, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x64, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x6f,
	0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x65, 0x73,
	0x74, 0x12, 0x20, 0x0a, 0x0b, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x6f, 0x54, 0x72, 0x61, 0x73, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x6f, 0x54, 0x72,
	0x61, 0x73, 0x68, 0x22, 0x16, 0x0a, 0x14, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x44, 0x0a, 0x12, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03,
	0x73, 0x72, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76,
	0x65, 0x22, 0x2d, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0xbe, 0x01, 0x0a, 0x12, 0x4d, 0x6b, 0x64, 0x69, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x36, 0x0a, 0x06, 0x6d, 0x61, 0x73,
	0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x08, 0x75, 0x6e, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x75, 0x6e, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x22, 0x2d, 0x0a, 0x13, 0x4d, 0x6b, 0x64, 0x69, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x6e, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72,
	0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0c,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0c,
	0x6e, 0x65, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x0c, 0x6e, 0x65, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x57, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3c, 0x0a, 0x07, 0x64,
	0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x07, 0x64, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x22, 0x79, 0x0a, 0x1d, 0x47, 0x65, 0x74,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61,
	0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73,
	0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x12, 0x22, 0x0a, 0x0c, 0x6e, 0x65, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0c, 0x6e, 0x65, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52,
	0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x22, 0x28, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x27, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63,
	0x0a, 0x14, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44,
	0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x22, 0x8b, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x22, 0x0a,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18,
	0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x22, 0x6a, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x44, 0x0a, 0x0a, 0x64, 0x69, 0x66, 0x66, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0a, 0x64, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xd6, 0x01,
	0x0a, 0x28, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66,
	0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x22,
	0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0x78, 0x0a, 0x29, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x0a, 0x64, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69,
	0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x64, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x22, 0x38, 0x0a, 0x16, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65,
	0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4c, 0x0a, 0x18, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03,
	0x73, 0x72, 0x63, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x19, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08,
	0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x19, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x02, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x0a, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x04, 0x75, 0x73, 0x65, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a,
	0x10, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x72, 0x72,
	0x75, 0x70, 0x74, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x0d, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12,
	0x25, 0x0a, 0x0e, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x18, 0x06, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x70, 0x6c, 0x4f, 0x6e, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x28, 0x0a,
	0x10, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x66, 0x75, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x49,
	0x6e, 0x46, 0x75, 0x74, 0x75, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x15, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22,
	0x27, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x46, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x82, 0x03, 0x0a, 0x26, 0x47, 0x65, 0x74,
	0x46, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e,
	0x64, 0x61, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x6c, 0x6f, 0x77,
	0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f,
	0x72, 0x72, 0x75, 0x70, 0x74, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x0d, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x14, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x4f, 0x6e, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x66, 0x75, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0e, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x49, 0x6e, 0x46, 0x75, 0x74, 0x75, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x02, 0x28, 0x04, 0x52, 0x15, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x12, 0x4a, 0x0a, 0x22, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x69,
	0x6f, 0x5f, 0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79,
	0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1e, 0x68,
	0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6f, 0x4c, 0x6f, 0x77, 0x52, 0x65, 0x64,
	0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x24, 0x0a,
	0x22, 0x47, 0x65, 0x74, 0x46, 0x73, 0x45, 0x43, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x02, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x46, 0x73, 0x45, 0x43, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x6c,
	0x6f, 0x77, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x0d, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e,
	0x63, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x63, 0x6f, 0x72, 0x72,
	0x75, 0x70, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73,
	0x12, 0x28, 0x0a, 0x10, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x66, 0x75,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0e, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x49, 0x6e, 0x46, 0x75, 0x74, 0x75, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x02, 0x28, 0x04, 0x52, 0x15, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x12, 0x4a, 0x0a, 0x22, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x72,
	0x69, 0x6f, 0x5f, 0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63,
	0x79, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1e,
	0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6f, 0x4c, 0x6f, 0x77, 0x52, 0x65,
	0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x59,
	0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x38, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x50, 0x0a, 0x1e, 0x47, 0x65, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2e, 0x0a, 0x02, 0x64,
	0x69, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x64, 0x69, 0x22, 0x60, 0x0a, 0x24, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0e, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa9, 0x01,
	0x0a, 0x1a, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x42, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x47, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0x88, 0x01, 0x0a, 0x25, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x5f, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x16, 0x64, 0x61,
	0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x22, 0x3f, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3a, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x62,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x62, 0x73, 0x69, 0x7a,
	0x65, 0x22, 0x74, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x53, 0x61, 0x66, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x07,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x32, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x53, 0x61,
	0x66, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x57, 0x0a, 0x19, 0x53,
	0x61, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0a, 0x74, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x17, 0x0a, 0x05, 0x74,
	0x78, 0x47, 0x61, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x05, 0x74,
	0x78, 0x47, 0x61, 0x70, 0x22, 0x38, 0x0a, 0x1a, 0x53, 0x61, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x05, 0x73, 0x61, 0x76, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x05, 0x73, 0x61, 0x76, 0x65, 0x64, 0x22, 0x17,
	0x0a, 0x15, 0x52, 0x6f, 0x6c, 0x6c, 0x45, 0x64, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x40, 0x0a, 0x16, 0x52, 0x6f, 0x6c, 0x6c, 0x45,
	0x64, 0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x26, 0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x78, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0e, 0x6e, 0x65, 0x77, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x78, 0x49, 0x64, 0x22, 0x34, 0x0a, 0x20, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a,
	0x03, 0x61, 0x72, 0x67, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x61, 0x72, 0x67, 0x22,
	0x3b, 0x0a, 0x21, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x1a, 0x0a, 0x18,
	0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1d, 0x0a, 0x1b, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1e, 0x0a, 0x1c, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1b, 0x0a, 0x19, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x48, 0x0a, 0x1a, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x2a, 0x0a, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x5c, 0x0a, 0x1a, 0x52,
	0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x52, 0x6f,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3e, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0c, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x02, 0x28, 0x08, 0x52, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x52,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x22, 0x73, 0x0a,
	0x1b, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x54, 0x0a, 0x12,
	0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x12,
	0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x4f, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x72, 0x75, 0x70,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x63,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x22, 0x63, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x72, 0x75,
	0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x0a, 0x07, 0x63, 0x6f, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x07, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x22, 0x32, 0x0a, 0x14, 0x4d, 0x65, 0x74, 0x61,
	0x53, 0x61, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x17, 0x0a, 0x15,
	0x4d, 0x65, 0x74, 0x61, 0x53, 0x61, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2b, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x72, 0x63, 0x22, 0x4c, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x30,
	0x0a, 0x02, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x66, 0x73,
	0x22, 0x61, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69,
	0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x72, 0x63, 0x12, 0x2d, 0x0a, 0x0e, 0x6e, 0x65, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x52, 0x0e, 0x6e, 0x65, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x53, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x30, 0x0a, 0x02, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x66, 0x73, 0x22, 0x2c, 0x0a, 0x18, 0x49, 0x73, 0x46, 0x69,
	0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x22, 0x33, 0x0a, 0x19, 0x49, 0x73, 0x46, 0x69, 0x6c, 0x65,
	0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xc3, 0x01, 0x0a, 0x17,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x20, 0x0a, 0x0b, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x6f,
	0x6c, 0x12, 0x4e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5b, 0x0a, 0x21, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x69, 0x73, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x22, 0xc2,
	0x01, 0x0a, 0x18, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03,
	0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x20, 0x0a,
	0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x03, 0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x12,
	0x20, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x61, 0x73, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x64, 0x22, 0x79, 0x0a, 0x1d, 0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x30,
	0x0a, 0x1e, 0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64,
	0x22, 0x7c, 0x0a, 0x20, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x23,
	0x0a, 0x21, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x32, 0x0a, 0x20, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x22, 0x23, 0x0a, 0x21, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x77, 0x0a, 0x1f,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x76, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x76, 0x49, 0x64, 0x12, 0x3c, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x91, 0x01, 0x0a, 0x18, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x38, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x7f, 0x0a, 0x20, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x41, 0x0a,
	0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x22, 0xf7, 0x01, 0x0a, 0x12, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11,
	0x6d, 0x61, 0x78, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72,
	0x79, 0x12, 0x31, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x31,
	0x52, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0x0a, 0x13, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x03, 0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x20,
	0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x12, 0x26, 0x0a, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4f,
	0x76, 0x65, 0x72, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x04, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0b, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x05, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x22, 0x4f, 0x0a, 0x18,
	0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x1b, 0x0a,
	0x19, 0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x52, 0x0a, 0x1b, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x0a, 0x04, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x1e,
	0x0a, 0x1c, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x39,
	0x0a, 0x1b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x40, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x50,
	0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x72, 0x65, 0x76, 0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x73, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3a, 0x0a, 0x07, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72,
	0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65,
	0x22, 0x82, 0x01, 0x0a, 0x13, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x2f, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x22, 0x50, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x30, 0x0a, 0x02, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x66, 0x73, 0x22, 0x33, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x5c, 0x0a,
	0x1e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x3a, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x2f, 0x0a, 0x19, 0x47,
	0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x50, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x32, 0x0a, 0x05, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x22, 0xc1,
	0x01, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x26, 0x0a, 0x0e, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x11, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x11,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x12, 0x3f, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x17, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x86, 0x01, 0x0a, 0x11,
	0x46, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03,
	0x73, 0x72, 0x63, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x6c,
	0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x12, 0x3a, 0x02, 0x2d, 0x31, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x65, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x65, 0x49, 0x64, 0x22, 0x14, 0x0a, 0x12, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x54, 0x0a, 0x14, 0x53, 0x65,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x72, 0x63, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x61, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0x17, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x01, 0x0a, 0x19, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0x38, 0x0a, 0x07, 0x64, 0x69, 0x72, 0x50, 0x65, 0x72, 0x6d, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x64, 0x69, 0x72, 0x50, 0x65, 0x72, 0x6d, 0x12, 0x22, 0x0a,
	0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x22, 0x1c, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6d, 0x6c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x2f, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x22, 0x3c, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0x7b,
	0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x46, 0x6f, 0x72,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a, 0x23, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x46, 0x6f, 0x72, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x34, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x90, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x6f, 0x6c, 0x64, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x6f, 0x6c, 0x64, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3b, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x38, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x44, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x44, 0x73, 0x22, 0x1d, 0x0a, 0x1b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x40, 0x0a, 0x20, 0x53, 0x65,
	0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x03, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x22, 0x23, 0x0a, 0x21,
	0x53, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x22, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x76, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a, 0x11, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x64, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12,
	0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x41, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0x94, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x4f, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4f, 0x6c, 0x64, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e,
	0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1d, 0x0a,
	0x1b, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3f, 0x0a, 0x19,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x1c, 0x0a,
	0x1a, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x42, 0x0a, 0x1c, 0x44,
	0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x22,
	0x1f, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x64, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f,
	0x6f, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x6b, 0x0a, 0x17, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x12, 0x3c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46,
	0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x23,
	0x0a, 0x21, 0x47, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x64, 0x69, 0x74,
	0x4c, 0x6f, 0x67, 0x54, 0x78, 0x69, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x38, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x54, 0x78, 0x69, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x04, 0x74, 0x78, 0x69, 0x64, 0x22, 0x32, 0x0a,
	0x1c, 0x47, 0x65, 0x74, 0x45, 0x64, 0x69, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x78, 0x69,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x04, 0x74, 0x78, 0x69,
	0x64, 0x22, 0x5d, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x45, 0x64, 0x69, 0x74, 0x73, 0x46, 0x72, 0x6f,
	0x6d, 0x54, 0x78, 0x69, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x3c, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x22, 0x76, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x35, 0x0a,
	0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x87, 0x01, 0x0a, 0x1b, 0x4f, 0x70, 0x65,
	0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x42, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x12,
	0x35, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x22, 0x13, 0x0a, 0x11, 0x4d, 0x73, 0x79, 0x6e, 0x63, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x14, 0x0a, 0x12, 0x4d,
	0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x34, 0x0a, 0x20, 0x53, 0x61, 0x74, 0x69, 0x73, 0x66, 0x79, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x22, 0x23, 0x0a, 0x21, 0x53, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x79, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1c, 0x0a, 0x1a,
	0x48, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x57, 0x0a, 0x1b, 0x48, 0x41,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x2a, 0x70, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x61,
	0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x56, 0x45, 0x52, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x10, 0x0a,
	0x0c, 0x4c, 0x41, 0x5a, 0x59, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x10, 0x10, 0x12,
	0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x57, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x10, 0x20, 0x12, 0x15,
	0x0a, 0x10, 0x53, 0x48, 0x4f, 0x55, 0x4c, 0x44, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x10, 0x80, 0x01, 0x2a, 0x43, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x46, 0x6c, 0x61, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f,
	0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f,
	0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x02, 0x2a, 0x79, 0x0a, 0x17, 0x44, 0x61,
	0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44,
	0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x54, 0x45, 0x52,
	0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10,
	0x05, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41,
	0x4e, 0x43, 0x45, 0x10, 0x06, 0x2a, 0x68, 0x0a, 0x13, 0x53, 0x61, 0x66, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x41, 0x46, 0x45, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4c, 0x45, 0x41, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x41, 0x46, 0x45, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x45, 0x4e, 0x54,
	0x45, 0x52, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x41, 0x46, 0x45, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x47, 0x45, 0x54, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x41, 0x46, 0x45, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x58, 0x49, 0x54, 0x10, 0x04, 0x2a,
	0x3f, 0x0a, 0x19, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x0a, 0x05,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x10, 0x03,
	0x2a, 0x1b, 0x0a, 0x0e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x10, 0x01, 0x2a, 0x43, 0x0a,
	0x12, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4c, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x4e, 0x5f,
	0x46, 0x49, 0x4c, 0x45, 0x53, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x32, 0xfc, 0x58, 0x0a, 0x16, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x6c, 0x0a,
	0x11, 0x67, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x6c, 0x0a, 0x11, 0x67,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64,
	0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x63, 0x0a, 0x0e, 0x73, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x73, 0x65, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x29, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x6f, 0x0a, 0x12, 0x75, 0x6e, 0x73, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x6f, 0x0a, 0x12, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x60, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x65, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x51, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x21,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5d, 0x0a, 0x0c, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x62, 0x61, 0x6e, 0x64,
	0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a, 0x08, 0x61, 0x64, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41,
	0x64, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x41, 0x64, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x78, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x41, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x12, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x51, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x21, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61,
	0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x64, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a, 0x08, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x12, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06,
	0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4e, 0x0a, 0x07, 0x72, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x32, 0x12, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x06, 0x6d, 0x6b, 0x64, 0x69, 0x72, 0x73,
	0x12, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d,
	0x6b, 0x64, 0x69, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4d, 0x6b, 0x64, 0x69, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x57, 0x0a, 0x0a, 0x67, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x6c, 0x0a, 0x11,
	0x67, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x57, 0x0a, 0x0a, 0x72, 0x65,
	0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x65,
	0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x12, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x58, 0x0a, 0x0a, 0x67, 0x65, 0x74, 0x46, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x46, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x84, 0x01, 0x0a,
	0x19, 0x67, 0x65, 0x74, 0x46, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x73, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x46, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x7b, 0x0a, 0x16, 0x67, 0x65, 0x74, 0x46, 0x73, 0x45, 0x43, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2f, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x46,
	0x73, 0x45, 0x43, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x46, 0x73, 0x45, 0x43, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x6c, 0x0a, 0x11, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x81,
	0x01, 0x0a, 0x18, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x31, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x78, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5a, 0x0a, 0x0b,
	0x73, 0x65, 0x74, 0x53, 0x61, 0x66, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x61, 0x66,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x65, 0x74, 0x53, 0x61, 0x66, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x73, 0x61, 0x76, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x61, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x54, 0x0a, 0x09, 0x72, 0x6f,
	0x6c, 0x6c, 0x45, 0x64, 0x69, 0x74, 0x73, 0x12, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x45, 0x64, 0x69, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x45, 0x64,
	0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x75, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60,
	0x0a, 0x0d, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x63, 0x0a, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x12, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x78, 0x0a, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x2e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x51, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x53, 0x61, 0x76, 0x65, 0x12, 0x21, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x53, 0x61,
	0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x53, 0x61, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x5a, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x6f,
	0x0a, 0x12, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x6c, 0x0a, 0x11, 0x61, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41,
	0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a,
	0x14, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2d, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x72, 0x0a, 0x13, 0x6c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x12, 0x2c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x5d, 0x0a, 0x0c, 0x61, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x64,
	0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66,
	0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63,
	0x0a, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x12, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x67, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x6c, 0x0a, 0x11, 0x67,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x12, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a, 0x08, 0x73, 0x65, 0x74,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x05,
	0x66, 0x73, 0x79, 0x6e, 0x63, 0x12, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x12, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x53, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x67,
	0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x26, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69,
	0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x7b, 0x0a,
	0x16, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x46, 0x6f, 0x72, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x46, 0x6f, 0x72, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x46, 0x6f, 0x72, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63, 0x0a, 0x0e, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x27, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x73, 0x0a, 0x12, 0x67, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x79, 0x0a, 0x14, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x6c,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6e,
	0x65, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x6e, 0x65, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x7c, 0x0a, 0x15, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44,
	0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a,
	0x14, 0x73, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x2d, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63, 0x0a, 0x0e, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x27, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x63, 0x0a, 0x0e, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x29, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x87, 0x01, 0x0a, 0x1a, 0x67, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x33, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x44, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63, 0x0a, 0x0e,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x27,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x78, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2e, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x8d, 0x01, 0x0a, 0x1c,
	0x67, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x35, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66,
	0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5d, 0x0a, 0x0c, 0x69,
	0x73, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x12, 0x25, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x49, 0x73, 0x46, 0x69, 0x6c, 0x65,
	0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x49, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x6d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x29,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x79, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x41, 0x63,
	0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41,
	0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x63,
	0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x69, 0x0a, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x41, 0x63, 0x6c, 0x12, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x41, 0x63, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x54, 0x0a, 0x09, 0x72,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x63, 0x6c, 0x12, 0x22, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x63, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x41, 0x63, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x1f, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x63, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x63,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5d,
	0x0a, 0x0c, 0x67, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x63, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x51, 0x0a,
	0x08, 0x73, 0x65, 0x74, 0x58, 0x41, 0x74, 0x74, 0x72, 0x12, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x58, 0x41, 0x74, 0x74, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x58, 0x41,
	0x74, 0x74, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x54, 0x0a, 0x09, 0x67, 0x65, 0x74, 0x58, 0x41, 0x74, 0x74, 0x72, 0x73, 0x12, 0x22, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x58,
	0x41, 0x74, 0x74, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x58, 0x41, 0x74, 0x74, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x57, 0x0a, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x58, 0x41,
	0x74, 0x74, 0x72, 0x73, 0x12, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x58, 0x41, 0x74, 0x74, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x58, 0x41, 0x74, 0x74,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x5a, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x58, 0x41, 0x74, 0x74, 0x72, 0x12, 0x24,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x58, 0x41, 0x74, 0x74, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x58, 0x41, 0x74, 0x74, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5a, 0x0a, 0x0b, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x24, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x12,
	0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f,
	0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x72,
	0x0a, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x7e, 0x0a, 0x17, 0x72, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x30, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a,
	0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x31, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x7b, 0x0a, 0x16, 0x6c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x5d, 0x0a, 0x0c, 0x67, 0x65, 0x74, 0x45, 0x5a, 0x46, 0x6f, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x5a, 0x46, 0x6f, 0x72, 0x50, 0x61, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x5a, 0x46, 0x6f, 0x72, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x7b,
	0x0a, 0x16, 0x73, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x81, 0x01, 0x0a, 0x18,
	0x75, 0x6e, 0x73, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x31, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x55, 0x6e, 0x73, 0x65, 0x74, 0x45,
	0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x93, 0x01, 0x0a, 0x1e, 0x67, 0x65, 0x74, 0x45, 0x43, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x37, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x43, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x43, 0x54,
	0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x78, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x54, 0x78, 0x69, 0x64, 0x12, 0x2e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x54, 0x78,
	0x69, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x54, 0x78,
	0x69, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x69, 0x0a, 0x10, 0x67, 0x65, 0x74, 0x45, 0x64, 0x69, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x54,
	0x78, 0x69, 0x64, 0x12, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x64, 0x69, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x78,
	0x69, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x64, 0x69, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x78, 0x69, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x81, 0x01, 0x0a, 0x18, 0x67,
	0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x81,
	0x01, 0x0a, 0x18, 0x61, 0x64, 0x64, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x72, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x41, 0x64, 0x64,
	0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x84, 0x01, 0x0a, 0x19, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x72, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x32, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x84, 0x01, 0x0a, 0x19, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x32, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x72, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x87, 0x01, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x72, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x33, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x7b, 0x0a, 0x16, 0x67, 0x65,
	0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x7b, 0x0a, 0x16, 0x67, 0x65, 0x74, 0x45, 0x72,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x73, 0x12, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x67, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x60, 0x0a, 0x0d, 0x6c, 0x69, 0x73, 0x74, 0x4f, 0x70,
	0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x05, 0x6d, 0x73, 0x79, 0x6e,
	0x63, 0x12, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4d, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4d, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x79, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x61, 0x74, 0x69, 0x73, 0x66, 0x79,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x61, 0x74, 0x69, 0x73, 0x66, 0x79, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x11, 0x67, 0x65, 0x74,
	0x48, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x27,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x41, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x42, 0x87, 0x01, 0x0a, 0x25, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x1c, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c, 0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f,
	0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x5f, 0x68, 0x64, 0x66, 0x73, 0x88, 0x01, 0x01, 0xa0, 0x01, 0x01,
}

var (
	file_ClientNamenodeProtocol_proto_rawDescOnce sync.Once
	file_ClientNamenodeProtocol_proto_rawDescData = file_ClientNamenodeProtocol_proto_rawDesc
)

func file_ClientNamenodeProtocol_proto_rawDescGZIP() []byte {
	file_ClientNamenodeProtocol_proto_rawDescOnce.Do(func() {
		file_ClientNamenodeProtocol_proto_rawDescData = protoimpl.X.CompressGZIP(file_ClientNamenodeProtocol_proto_rawDescData)
	})
	return file_ClientNamenodeProtocol_proto_rawDescData
}

var file_ClientNamenodeProtocol_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_ClientNamenodeProtocol_proto_msgTypes = make([]protoimpl.MessageInfo, 170)
var file_ClientNamenodeProtocol_proto_goTypes = []interface{}{
	(CreateFlagProto)(0),                                     // 0: hadoop.hdfs.CreateFlagProto
	(AddBlockFlagProto)(0),                                   // 1: hadoop.hdfs.AddBlockFlagProto
	(DatanodeReportTypeProto)(0),                             // 2: hadoop.hdfs.DatanodeReportTypeProto
	(SafeModeActionProto)(0),                                 // 3: hadoop.hdfs.SafeModeActionProto
	(RollingUpgradeActionProto)(0),                           // 4: hadoop.hdfs.RollingUpgradeActionProto
	(CacheFlagProto)(0),                                      // 5: hadoop.hdfs.CacheFlagProto
	(OpenFilesTypeProto)(0),                                  // 6: hadoop.hdfs.OpenFilesTypeProto
	(*GetBlockLocationsRequestProto)(nil),                    // 7: hadoop.hdfs.GetBlockLocationsRequestProto
	(*GetBlockLocationsResponseProto)(nil),                   // 8: hadoop.hdfs.GetBlockLocationsResponseProto
	(*GetServerDefaultsRequestProto)(nil),                    // 9: hadoop.hdfs.GetServerDefaultsRequestProto
	(*GetServerDefaultsResponseProto)(nil),                   // 10: hadoop.hdfs.GetServerDefaultsResponseProto
	(*CreateRequestProto)(nil),                               // 11: hadoop.hdfs.CreateRequestProto
	(*CreateResponseProto)(nil),                              // 12: hadoop.hdfs.CreateResponseProto
	(*AppendRequestProto)(nil),                               // 13: hadoop.hdfs.AppendRequestProto
	(*AppendResponseProto)(nil),                              // 14: hadoop.hdfs.AppendResponseProto
	(*SetReplicationRequestProto)(nil),                       // 15: hadoop.hdfs.SetReplicationRequestProto
	(*SetReplicationResponseProto)(nil),                      // 16: hadoop.hdfs.SetReplicationResponseProto
	(*SetStoragePolicyRequestProto)(nil),                     // 17: hadoop.hdfs.SetStoragePolicyRequestProto
	(*SetStoragePolicyResponseProto)(nil),                    // 18: hadoop.hdfs.SetStoragePolicyResponseProto
	(*UnsetStoragePolicyRequestProto)(nil),                   // 19: hadoop.hdfs.UnsetStoragePolicyRequestProto
	(*UnsetStoragePolicyResponseProto)(nil),                  // 20: hadoop.hdfs.UnsetStoragePolicyResponseProto
	(*GetStoragePolicyRequestProto)(nil),                     // 21: hadoop.hdfs.GetStoragePolicyRequestProto
	(*GetStoragePolicyResponseProto)(nil),                    // 22: hadoop.hdfs.GetStoragePolicyResponseProto
	(*GetStoragePoliciesRequestProto)(nil),                   // 23: hadoop.hdfs.GetStoragePoliciesRequestProto
	(*GetStoragePoliciesResponseProto)(nil),                  // 24: hadoop.hdfs.GetStoragePoliciesResponseProto
	(*SetPermissionRequestProto)(nil),                        // 25: hadoop.hdfs.SetPermissionRequestProto
	(*SetPermissionResponseProto)(nil),                       // 26: hadoop.hdfs.SetPermissionResponseProto
	(*SetOwnerRequestProto)(nil),                             // 27: hadoop.hdfs.SetOwnerRequestProto
	(*SetOwnerResponseProto)(nil),                            // 28: hadoop.hdfs.SetOwnerResponseProto
	(*AbandonBlockRequestProto)(nil),                         // 29: hadoop.hdfs.AbandonBlockRequestProto
	(*AbandonBlockResponseProto)(nil),                        // 30: hadoop.hdfs.AbandonBlockResponseProto
	(*AddBlockRequestProto)(nil),                             // 31: hadoop.hdfs.AddBlockRequestProto
	(*AddBlockResponseProto)(nil),                            // 32: hadoop.hdfs.AddBlockResponseProto
	(*GetAdditionalDatanodeRequestProto)(nil),                // 33: hadoop.hdfs.GetAdditionalDatanodeRequestProto
	(*GetAdditionalDatanodeResponseProto)(nil),               // 34: hadoop.hdfs.GetAdditionalDatanodeResponseProto
	(*CompleteRequestProto)(nil),                             // 35: hadoop.hdfs.CompleteRequestProto
	(*CompleteResponseProto)(nil),                            // 36: hadoop.hdfs.CompleteResponseProto
	(*ReportBadBlocksRequestProto)(nil),                      // 37: hadoop.hdfs.ReportBadBlocksRequestProto
	(*ReportBadBlocksResponseProto)(nil),                     // 38: hadoop.hdfs.ReportBadBlocksResponseProto
	(*ConcatRequestProto)(nil),                               // 39: hadoop.hdfs.ConcatRequestProto
	(*ConcatResponseProto)(nil),                              // 40: hadoop.hdfs.ConcatResponseProto
	(*TruncateRequestProto)(nil),                             // 41: hadoop.hdfs.TruncateRequestProto
	(*TruncateResponseProto)(nil),                            // 42: hadoop.hdfs.TruncateResponseProto
	(*RenameRequestProto)(nil),                               // 43: hadoop.hdfs.RenameRequestProto
	(*RenameResponseProto)(nil),                              // 44: hadoop.hdfs.RenameResponseProto
	(*Rename2RequestProto)(nil),                              // 45: hadoop.hdfs.Rename2RequestProto
	(*Rename2ResponseProto)(nil),                             // 46: hadoop.hdfs.Rename2ResponseProto
	(*DeleteRequestProto)(nil),                               // 47: hadoop.hdfs.DeleteRequestProto
	(*DeleteResponseProto)(nil),                              // 48: hadoop.hdfs.DeleteResponseProto
	(*MkdirsRequestProto)(nil),                               // 49: hadoop.hdfs.MkdirsRequestProto
	(*MkdirsResponseProto)(nil),                              // 50: hadoop.hdfs.MkdirsResponseProto
	(*GetListingRequestProto)(nil),                           // 51: hadoop.hdfs.GetListingRequestProto
	(*GetListingResponseProto)(nil),                          // 52: hadoop.hdfs.GetListingResponseProto
	(*GetBatchedListingRequestProto)(nil),                    // 53: hadoop.hdfs.GetBatchedListingRequestProto
	(*GetBatchedListingResponseProto)(nil),                   // 54: hadoop.hdfs.GetBatchedListingResponseProto
	(*GetSnapshottableDirListingRequestProto)(nil),           // 55: hadoop.hdfs.GetSnapshottableDirListingRequestProto
	(*GetSnapshottableDirListingResponseProto)(nil),          // 56: hadoop.hdfs.GetSnapshottableDirListingResponseProto
	(*GetSnapshotDiffReportRequestProto)(nil),                // 57: hadoop.hdfs.GetSnapshotDiffReportRequestProto
	(*GetSnapshotDiffReportResponseProto)(nil),               // 58: hadoop.hdfs.GetSnapshotDiffReportResponseProto
	(*GetSnapshotDiffReportListingRequestProto)(nil),         // 59: hadoop.hdfs.GetSnapshotDiffReportListingRequestProto
	(*GetSnapshotDiffReportListingResponseProto)(nil),        // 60: hadoop.hdfs.GetSnapshotDiffReportListingResponseProto
	(*RenewLeaseRequestProto)(nil),                           // 61: hadoop.hdfs.RenewLeaseRequestProto
	(*RenewLeaseResponseProto)(nil),                          // 62: hadoop.hdfs.RenewLeaseResponseProto
	(*RecoverLeaseRequestProto)(nil),                         // 63: hadoop.hdfs.RecoverLeaseRequestProto
	(*RecoverLeaseResponseProto)(nil),                        // 64: hadoop.hdfs.RecoverLeaseResponseProto
	(*GetFsStatusRequestProto)(nil),                          // 65: hadoop.hdfs.GetFsStatusRequestProto
	(*GetFsStatsResponseProto)(nil),                          // 66: hadoop.hdfs.GetFsStatsResponseProto
	(*GetFsReplicatedBlockStatsRequestProto)(nil),            // 67: hadoop.hdfs.GetFsReplicatedBlockStatsRequestProto
	(*GetFsReplicatedBlockStatsResponseProto)(nil),           // 68: hadoop.hdfs.GetFsReplicatedBlockStatsResponseProto
	(*GetFsECBlockGroupStatsRequestProto)(nil),               // 69: hadoop.hdfs.GetFsECBlockGroupStatsRequestProto
	(*GetFsECBlockGroupStatsResponseProto)(nil),              // 70: hadoop.hdfs.GetFsECBlockGroupStatsResponseProto
	(*GetDatanodeReportRequestProto)(nil),                    // 71: hadoop.hdfs.GetDatanodeReportRequestProto
	(*GetDatanodeReportResponseProto)(nil),                   // 72: hadoop.hdfs.GetDatanodeReportResponseProto
	(*GetDatanodeStorageReportRequestProto)(nil),             // 73: hadoop.hdfs.GetDatanodeStorageReportRequestProto
	(*DatanodeStorageReportProto)(nil),                       // 74: hadoop.hdfs.DatanodeStorageReportProto
	(*GetDatanodeStorageReportResponseProto)(nil),            // 75: hadoop.hdfs.GetDatanodeStorageReportResponseProto
	(*GetPreferredBlockSizeRequestProto)(nil),                // 76: hadoop.hdfs.GetPreferredBlockSizeRequestProto
	(*GetPreferredBlockSizeResponseProto)(nil),               // 77: hadoop.hdfs.GetPreferredBlockSizeResponseProto
	(*SetSafeModeRequestProto)(nil),                          // 78: hadoop.hdfs.SetSafeModeRequestProto
	(*SetSafeModeResponseProto)(nil),                         // 79: hadoop.hdfs.SetSafeModeResponseProto
	(*SaveNamespaceRequestProto)(nil),                        // 80: hadoop.hdfs.SaveNamespaceRequestProto
	(*SaveNamespaceResponseProto)(nil),                       // 81: hadoop.hdfs.SaveNamespaceResponseProto
	(*RollEditsRequestProto)(nil),                            // 82: hadoop.hdfs.RollEditsRequestProto
	(*RollEditsResponseProto)(nil),                           // 83: hadoop.hdfs.RollEditsResponseProto
	(*RestoreFailedStorageRequestProto)(nil),                 // 84: hadoop.hdfs.RestoreFailedStorageRequestProto
	(*RestoreFailedStorageResponseProto)(nil),                // 85: hadoop.hdfs.RestoreFailedStorageResponseProto
	(*RefreshNodesRequestProto)(nil),                         // 86: hadoop.hdfs.RefreshNodesRequestProto
	(*RefreshNodesResponseProto)(nil),                        // 87: hadoop.hdfs.RefreshNodesResponseProto
	(*FinalizeUpgradeRequestProto)(nil),                      // 88: hadoop.hdfs.FinalizeUpgradeRequestProto
	(*FinalizeUpgradeResponseProto)(nil),                     // 89: hadoop.hdfs.FinalizeUpgradeResponseProto
	(*UpgradeStatusRequestProto)(nil),                        // 90: hadoop.hdfs.UpgradeStatusRequestProto
	(*UpgradeStatusResponseProto)(nil),                       // 91: hadoop.hdfs.UpgradeStatusResponseProto
	(*RollingUpgradeRequestProto)(nil),                       // 92: hadoop.hdfs.RollingUpgradeRequestProto
	(*RollingUpgradeInfoProto)(nil),                          // 93: hadoop.hdfs.RollingUpgradeInfoProto
	(*RollingUpgradeResponseProto)(nil),                      // 94: hadoop.hdfs.RollingUpgradeResponseProto
	(*ListCorruptFileBlocksRequestProto)(nil),                // 95: hadoop.hdfs.ListCorruptFileBlocksRequestProto
	(*ListCorruptFileBlocksResponseProto)(nil),               // 96: hadoop.hdfs.ListCorruptFileBlocksResponseProto
	(*MetaSaveRequestProto)(nil),                             // 97: hadoop.hdfs.MetaSaveRequestProto
	(*MetaSaveResponseProto)(nil),                            // 98: hadoop.hdfs.MetaSaveResponseProto
	(*GetFileInfoRequestProto)(nil),                          // 99: hadoop.hdfs.GetFileInfoRequestProto
	(*GetFileInfoResponseProto)(nil),                         // 100: hadoop.hdfs.GetFileInfoResponseProto
	(*GetLocatedFileInfoRequestProto)(nil),                   // 101: hadoop.hdfs.GetLocatedFileInfoRequestProto
	(*GetLocatedFileInfoResponseProto)(nil),                  // 102: hadoop.hdfs.GetLocatedFileInfoResponseProto
	(*IsFileClosedRequestProto)(nil),                         // 103: hadoop.hdfs.IsFileClosedRequestProto
	(*IsFileClosedResponseProto)(nil),                        // 104: hadoop.hdfs.IsFileClosedResponseProto
	(*CacheDirectiveInfoProto)(nil),                          // 105: hadoop.hdfs.CacheDirectiveInfoProto
	(*CacheDirectiveInfoExpirationProto)(nil),                // 106: hadoop.hdfs.CacheDirectiveInfoExpirationProto
	(*CacheDirectiveStatsProto)(nil),                         // 107: hadoop.hdfs.CacheDirectiveStatsProto
	(*AddCacheDirectiveRequestProto)(nil),                    // 108: hadoop.hdfs.AddCacheDirectiveRequestProto
	(*AddCacheDirectiveResponseProto)(nil),                   // 109: hadoop.hdfs.AddCacheDirectiveResponseProto
	(*ModifyCacheDirectiveRequestProto)(nil),                 // 110: hadoop.hdfs.ModifyCacheDirectiveRequestProto
	(*ModifyCacheDirectiveResponseProto)(nil),                // 111: hadoop.hdfs.ModifyCacheDirectiveResponseProto
	(*RemoveCacheDirectiveRequestProto)(nil),                 // 112: hadoop.hdfs.RemoveCacheDirectiveRequestProto
	(*RemoveCacheDirectiveResponseProto)(nil),                // 113: hadoop.hdfs.RemoveCacheDirectiveResponseProto
	(*ListCacheDirectivesRequestProto)(nil),                  // 114: hadoop.hdfs.ListCacheDirectivesRequestProto
	(*CacheDirectiveEntryProto)(nil),                         // 115: hadoop.hdfs.CacheDirectiveEntryProto
	(*ListCacheDirectivesResponseProto)(nil),                 // 116: hadoop.hdfs.ListCacheDirectivesResponseProto
	(*CachePoolInfoProto)(nil),                               // 117: hadoop.hdfs.CachePoolInfoProto
	(*CachePoolStatsProto)(nil),                              // 118: hadoop.hdfs.CachePoolStatsProto
	(*AddCachePoolRequestProto)(nil),                         // 119: hadoop.hdfs.AddCachePoolRequestProto
	(*AddCachePoolResponseProto)(nil),                        // 120: hadoop.hdfs.AddCachePoolResponseProto
	(*ModifyCachePoolRequestProto)(nil),                      // 121: hadoop.hdfs.ModifyCachePoolRequestProto
	(*ModifyCachePoolResponseProto)(nil),                     // 122: hadoop.hdfs.ModifyCachePoolResponseProto
	(*RemoveCachePoolRequestProto)(nil),                      // 123: hadoop.hdfs.RemoveCachePoolRequestProto
	(*RemoveCachePoolResponseProto)(nil),                     // 124: hadoop.hdfs.RemoveCachePoolResponseProto
	(*ListCachePoolsRequestProto)(nil),                       // 125: hadoop.hdfs.ListCachePoolsRequestProto
	(*ListCachePoolsResponseProto)(nil),                      // 126: hadoop.hdfs.ListCachePoolsResponseProto
	(*CachePoolEntryProto)(nil),                              // 127: hadoop.hdfs.CachePoolEntryProto
	(*GetFileLinkInfoRequestProto)(nil),                      // 128: hadoop.hdfs.GetFileLinkInfoRequestProto
	(*GetFileLinkInfoResponseProto)(nil),                     // 129: hadoop.hdfs.GetFileLinkInfoResponseProto
	(*GetContentSummaryRequestProto)(nil),                    // 130: hadoop.hdfs.GetContentSummaryRequestProto
	(*GetContentSummaryResponseProto)(nil),                   // 131: hadoop.hdfs.GetContentSummaryResponseProto
	(*GetQuotaUsageRequestProto)(nil),                        // 132: hadoop.hdfs.GetQuotaUsageRequestProto
	(*GetQuotaUsageResponseProto)(nil),                       // 133: hadoop.hdfs.GetQuotaUsageResponseProto
	(*SetQuotaRequestProto)(nil),                             // 134: hadoop.hdfs.SetQuotaRequestProto
	(*SetQuotaResponseProto)(nil),                            // 135: hadoop.hdfs.SetQuotaResponseProto
	(*FsyncRequestProto)(nil),                                // 136: hadoop.hdfs.FsyncRequestProto
	(*FsyncResponseProto)(nil),                               // 137: hadoop.hdfs.FsyncResponseProto
	(*SetTimesRequestProto)(nil),                             // 138: hadoop.hdfs.SetTimesRequestProto
	(*SetTimesResponseProto)(nil),                            // 139: hadoop.hdfs.SetTimesResponseProto
	(*CreateSymlinkRequestProto)(nil),                        // 140: hadoop.hdfs.CreateSymlinkRequestProto
	(*CreateSymlinkResponseProto)(nil),                       // 141: hadoop.hdfs.CreateSymlinkResponseProto
	(*GetLinkTargetRequestProto)(nil),                        // 142: hadoop.hdfs.GetLinkTargetRequestProto
	(*GetLinkTargetResponseProto)(nil),                       // 143: hadoop.hdfs.GetLinkTargetResponseProto
	(*UpdateBlockForPipelineRequestProto)(nil),               // 144: hadoop.hdfs.UpdateBlockForPipelineRequestProto
	(*UpdateBlockForPipelineResponseProto)(nil),              // 145: hadoop.hdfs.UpdateBlockForPipelineResponseProto
	(*UpdatePipelineRequestProto)(nil),                       // 146: hadoop.hdfs.UpdatePipelineRequestProto
	(*UpdatePipelineResponseProto)(nil),                      // 147: hadoop.hdfs.UpdatePipelineResponseProto
	(*SetBalancerBandwidthRequestProto)(nil),                 // 148: hadoop.hdfs.SetBalancerBandwidthRequestProto
	(*SetBalancerBandwidthResponseProto)(nil),                // 149: hadoop.hdfs.SetBalancerBandwidthResponseProto
	(*GetDataEncryptionKeyRequestProto)(nil),                 // 150: hadoop.hdfs.GetDataEncryptionKeyRequestProto
	(*GetDataEncryptionKeyResponseProto)(nil),                // 151: hadoop.hdfs.GetDataEncryptionKeyResponseProto
	(*CreateSnapshotRequestProto)(nil),                       // 152: hadoop.hdfs.CreateSnapshotRequestProto
	(*CreateSnapshotResponseProto)(nil),                      // 153: hadoop.hdfs.CreateSnapshotResponseProto
	(*RenameSnapshotRequestProto)(nil),                       // 154: hadoop.hdfs.RenameSnapshotRequestProto
	(*RenameSnapshotResponseProto)(nil),                      // 155: hadoop.hdfs.RenameSnapshotResponseProto
	(*AllowSnapshotRequestProto)(nil),                        // 156: hadoop.hdfs.AllowSnapshotRequestProto
	(*AllowSnapshotResponseProto)(nil),                       // 157: hadoop.hdfs.AllowSnapshotResponseProto
	(*DisallowSnapshotRequestProto)(nil),                     // 158: hadoop.hdfs.DisallowSnapshotRequestProto
	(*DisallowSnapshotResponseProto)(nil),                    // 159: hadoop.hdfs.DisallowSnapshotResponseProto
	(*DeleteSnapshotRequestProto)(nil),                       // 160: hadoop.hdfs.DeleteSnapshotRequestProto
	(*DeleteSnapshotResponseProto)(nil),                      // 161: hadoop.hdfs.DeleteSnapshotResponseProto
	(*CheckAccessRequestProto)(nil),                          // 162: hadoop.hdfs.CheckAccessRequestProto
	(*CheckAccessResponseProto)(nil),                         // 163: hadoop.hdfs.CheckAccessResponseProto
	(*GetCurrentEditLogTxidRequestProto)(nil),                // 164: hadoop.hdfs.GetCurrentEditLogTxidRequestProto
	(*GetCurrentEditLogTxidResponseProto)(nil),               // 165: hadoop.hdfs.GetCurrentEditLogTxidResponseProto
	(*GetEditsFromTxidRequestProto)(nil),                     // 166: hadoop.hdfs.GetEditsFromTxidRequestProto
	(*GetEditsFromTxidResponseProto)(nil),                    // 167: hadoop.hdfs.GetEditsFromTxidResponseProto
	(*ListOpenFilesRequestProto)(nil),                        // 168: hadoop.hdfs.ListOpenFilesRequestProto
	(*OpenFilesBatchResponseProto)(nil),                      // 169: hadoop.hdfs.OpenFilesBatchResponseProto
	(*ListOpenFilesResponseProto)(nil),                       // 170: hadoop.hdfs.ListOpenFilesResponseProto
	(*MsyncRequestProto)(nil),                                // 171: hadoop.hdfs.MsyncRequestProto
	(*MsyncResponseProto)(nil),                               // 172: hadoop.hdfs.MsyncResponseProto
	(*SatisfyStoragePolicyRequestProto)(nil),                 // 173: hadoop.hdfs.SatisfyStoragePolicyRequestProto
	(*SatisfyStoragePolicyResponseProto)(nil),                // 174: hadoop.hdfs.SatisfyStoragePolicyResponseProto
	(*HAServiceStateRequestProto)(nil),                       // 175: hadoop.hdfs.HAServiceStateRequestProto
	(*HAServiceStateResponseProto)(nil),                      // 176: hadoop.hdfs.HAServiceStateResponseProto
	(*LocatedBlocksProto)(nil),                               // 177: hadoop.hdfs.LocatedBlocksProto
	(*FsServerDefaultsProto)(nil),                            // 178: hadoop.hdfs.FsServerDefaultsProto
	(*FsPermissionProto)(nil),                                // 179: hadoop.hdfs.FsPermissionProto
	(CryptoProtocolVersionProto)(0),                          // 180: hadoop.hdfs.CryptoProtocolVersionProto
	(*HdfsFileStatusProto)(nil),                              // 181: hadoop.hdfs.HdfsFileStatusProto
	(*LocatedBlockProto)(nil),                                // 182: hadoop.hdfs.LocatedBlockProto
	(*BlockStoragePolicyProto)(nil),                          // 183: hadoop.hdfs.BlockStoragePolicyProto
	(*ExtendedBlockProto)(nil),                               // 184: hadoop.hdfs.ExtendedBlockProto
	(*DatanodeInfoProto)(nil),                                // 185: hadoop.hdfs.DatanodeInfoProto
	(*DirectoryListingProto)(nil),                            // 186: hadoop.hdfs.DirectoryListingProto
	(*BatchedDirectoryListingProto)(nil),                     // 187: hadoop.hdfs.BatchedDirectoryListingProto
	(*SnapshottableDirectoryListingProto)(nil),               // 188: hadoop.hdfs.SnapshottableDirectoryListingProto
	(*SnapshotDiffReportProto)(nil),                          // 189: hadoop.hdfs.SnapshotDiffReportProto
	(*SnapshotDiffReportCursorProto)(nil),                    // 190: hadoop.hdfs.SnapshotDiffReportCursorProto
	(*SnapshotDiffReportListingProto)(nil),                   // 191: hadoop.hdfs.SnapshotDiffReportListingProto
	(*StorageReportProto)(nil),                               // 192: hadoop.hdfs.StorageReportProto
	(*RollingUpgradeStatusProto)(nil),                        // 193: hadoop.hdfs.RollingUpgradeStatusProto
	(*CorruptFileBlocksProto)(nil),                           // 194: hadoop.hdfs.CorruptFileBlocksProto
	(*ContentSummaryProto)(nil),                              // 195: hadoop.hdfs.ContentSummaryProto
	(*QuotaUsageProto)(nil),                                  // 196: hadoop.hdfs.QuotaUsageProto
	(StorageTypeProto)(0),                                    // 197: hadoop.hdfs.StorageTypeProto
	(*DatanodeIDProto)(nil),                                  // 198: hadoop.hdfs.DatanodeIDProto
	(*DataEncryptionKeyProto)(nil),                           // 199: hadoop.hdfs.DataEncryptionKeyProto
	(AclEntryProto_FsActionProto)(0),                         // 200: hadoop.hdfs.AclEntryProto.FsActionProto
	(*EventsListProto)(nil),                                  // 201: hadoop.hdfs.EventsListProto
	(hadoop_common.HAServiceStateProto)(0),                   // 202: hadoop.common.HAServiceStateProto
	(*hadoop_common.GetDelegationTokenRequestProto)(nil),     // 203: hadoop.common.GetDelegationTokenRequestProto
	(*hadoop_common.RenewDelegationTokenRequestProto)(nil),   // 204: hadoop.common.RenewDelegationTokenRequestProto
	(*hadoop_common.CancelDelegationTokenRequestProto)(nil),  // 205: hadoop.common.CancelDelegationTokenRequestProto
	(*ModifyAclEntriesRequestProto)(nil),                     // 206: hadoop.hdfs.ModifyAclEntriesRequestProto
	(*RemoveAclEntriesRequestProto)(nil),                     // 207: hadoop.hdfs.RemoveAclEntriesRequestProto
	(*RemoveDefaultAclRequestProto)(nil),                     // 208: hadoop.hdfs.RemoveDefaultAclRequestProto
	(*RemoveAclRequestProto)(nil),                            // 209: hadoop.hdfs.RemoveAclRequestProto
	(*SetAclRequestProto)(nil),                               // 210: hadoop.hdfs.SetAclRequestProto
	(*GetAclStatusRequestProto)(nil),                         // 211: hadoop.hdfs.GetAclStatusRequestProto
	(*SetXAttrRequestProto)(nil),                             // 212: hadoop.hdfs.SetXAttrRequestProto
	(*GetXAttrsRequestProto)(nil),                            // 213: hadoop.hdfs.GetXAttrsRequestProto
	(*ListXAttrsRequestProto)(nil),                           // 214: hadoop.hdfs.ListXAttrsRequestProto
	(*RemoveXAttrRequestProto)(nil),                          // 215: hadoop.hdfs.RemoveXAttrRequestProto
	(*CreateEncryptionZoneRequestProto)(nil),                 // 216: hadoop.hdfs.CreateEncryptionZoneRequestProto
	(*ListEncryptionZonesRequestProto)(nil),                  // 217: hadoop.hdfs.ListEncryptionZonesRequestProto
	(*ReencryptEncryptionZoneRequestProto)(nil),              // 218: hadoop.hdfs.ReencryptEncryptionZoneRequestProto
	(*ListReencryptionStatusRequestProto)(nil),               // 219: hadoop.hdfs.ListReencryptionStatusRequestProto
	(*GetEZForPathRequestProto)(nil),                         // 220: hadoop.hdfs.GetEZForPathRequestProto
	(*SetErasureCodingPolicyRequestProto)(nil),               // 221: hadoop.hdfs.SetErasureCodingPolicyRequestProto
	(*UnsetErasureCodingPolicyRequestProto)(nil),             // 222: hadoop.hdfs.UnsetErasureCodingPolicyRequestProto
	(*GetECTopologyResultForPoliciesRequestProto)(nil),       // 223: hadoop.hdfs.GetECTopologyResultForPoliciesRequestProto
	(*GetErasureCodingPoliciesRequestProto)(nil),             // 224: hadoop.hdfs.GetErasureCodingPoliciesRequestProto
	(*AddErasureCodingPoliciesRequestProto)(nil),             // 225: hadoop.hdfs.AddErasureCodingPoliciesRequestProto
	(*RemoveErasureCodingPolicyRequestProto)(nil),            // 226: hadoop.hdfs.RemoveErasureCodingPolicyRequestProto
	(*EnableErasureCodingPolicyRequestProto)(nil),            // 227: hadoop.hdfs.EnableErasureCodingPolicyRequestProto
	(*DisableErasureCodingPolicyRequestProto)(nil),           // 228: hadoop.hdfs.DisableErasureCodingPolicyRequestProto
	(*GetErasureCodingPolicyRequestProto)(nil),               // 229: hadoop.hdfs.GetErasureCodingPolicyRequestProto
	(*GetErasureCodingCodecsRequestProto)(nil),               // 230: hadoop.hdfs.GetErasureCodingCodecsRequestProto
	(*hadoop_common.GetDelegationTokenResponseProto)(nil),    // 231: hadoop.common.GetDelegationTokenResponseProto
	(*hadoop_common.RenewDelegationTokenResponseProto)(nil),  // 232: hadoop.common.RenewDelegationTokenResponseProto
	(*hadoop_common.CancelDelegationTokenResponseProto)(nil), // 233: hadoop.common.CancelDelegationTokenResponseProto
	(*ModifyAclEntriesResponseProto)(nil),                    // 234: hadoop.hdfs.ModifyAclEntriesResponseProto
	(*RemoveAclEntriesResponseProto)(nil),                    // 235: hadoop.hdfs.RemoveAclEntriesResponseProto
	(*RemoveDefaultAclResponseProto)(nil),                    // 236: hadoop.hdfs.RemoveDefaultAclResponseProto
	(*RemoveAclResponseProto)(nil),                           // 237: hadoop.hdfs.RemoveAclResponseProto
	(*SetAclResponseProto)(nil),                              // 238: hadoop.hdfs.SetAclResponseProto
	(*GetAclStatusResponseProto)(nil),                        // 239: hadoop.hdfs.GetAclStatusResponseProto
	(*SetXAttrResponseProto)(nil),                            // 240: hadoop.hdfs.SetXAttrResponseProto
	(*GetXAttrsResponseProto)(nil),                           // 241: hadoop.hdfs.GetXAttrsResponseProto
	(*ListXAttrsResponseProto)(nil),                          // 242: hadoop.hdfs.ListXAttrsResponseProto
	(*RemoveXAttrResponseProto)(nil),                         // 243: hadoop.hdfs.RemoveXAttrResponseProto
	(*CreateEncryptionZoneResponseProto)(nil),                // 244: hadoop.hdfs.CreateEncryptionZoneResponseProto
	(*ListEncryptionZonesResponseProto)(nil),                 // 245: hadoop.hdfs.ListEncryptionZonesResponseProto
	(*ReencryptEncryptionZoneResponseProto)(nil),             // 246: hadoop.hdfs.ReencryptEncryptionZoneResponseProto
	(*ListReencryptionStatusResponseProto)(nil),              // 247: hadoop.hdfs.ListReencryptionStatusResponseProto
	(*GetEZForPathResponseProto)(nil),                        // 248: hadoop.hdfs.GetEZForPathResponseProto
	(*SetErasureCodingPolicyResponseProto)(nil),              // 249: hadoop.hdfs.SetErasureCodingPolicyResponseProto
	(*UnsetErasureCodingPolicyResponseProto)(nil),            // 250: hadoop.hdfs.UnsetErasureCodingPolicyResponseProto
	(*GetECTopologyResultForPoliciesResponseProto)(nil),      // 251: hadoop.hdfs.GetECTopologyResultForPoliciesResponseProto
	(*GetErasureCodingPoliciesResponseProto)(nil),            // 252: hadoop.hdfs.GetErasureCodingPoliciesResponseProto
	(*AddErasureCodingPoliciesResponseProto)(nil),            // 253: hadoop.hdfs.AddErasureCodingPoliciesResponseProto
	(*RemoveErasureCodingPolicyResponseProto)(nil),           // 254: hadoop.hdfs.RemoveErasureCodingPolicyResponseProto
	(*EnableErasureCodingPolicyResponseProto)(nil),           // 255: hadoop.hdfs.EnableErasureCodingPolicyResponseProto
	(*DisableErasureCodingPolicyResponseProto)(nil),          // 256: hadoop.hdfs.DisableErasureCodingPolicyResponseProto
	(*GetErasureCodingPolicyResponseProto)(nil),              // 257: hadoop.hdfs.GetErasureCodingPolicyResponseProto
	(*GetErasureCodingCodecsResponseProto)(nil),              // 258: hadoop.hdfs.GetErasureCodingCodecsResponseProto
}
var file_ClientNamenodeProtocol_proto_depIdxs = []int32{
	177, // 0: hadoop.hdfs.GetBlockLocationsResponseProto.locations:type_name -> hadoop.hdfs.LocatedBlocksProto
	178, // 1: hadoop.hdfs.GetServerDefaultsResponseProto.serverDefaults:type_name -> hadoop.hdfs.FsServerDefaultsProto
	179, // 2: hadoop.hdfs.CreateRequestProto.masked:type_name -> hadoop.hdfs.FsPermissionProto
	180, // 3: hadoop.hdfs.CreateRequestProto.cryptoProtocolVersion:type_name -> hadoop.hdfs.CryptoProtocolVersionProto
	179, // 4: hadoop.hdfs.CreateRequestProto.unmasked:type_name -> hadoop.hdfs.FsPermissionProto
	181, // 5: hadoop.hdfs.CreateResponseProto.fs:type_name -> hadoop.hdfs.HdfsFileStatusProto
	182, // 6: hadoop.hdfs.AppendResponseProto.block:type_name -> hadoop.hdfs.LocatedBlockProto
	181, // 7: hadoop.hdfs.AppendResponseProto.stat:type_name -> hadoop.hdfs.HdfsFileStatusProto
	183, // 8: hadoop.hdfs.GetStoragePolicyResponseProto.storagePolicy:type_name -> hadoop.hdfs.BlockStoragePolicyProto
	183, // 9: hadoop.hdfs.GetStoragePoliciesResponseProto.policies:type_name -> hadoop.hdfs.BlockStoragePolicyProto
	179, // 10: hadoop.hdfs.SetPermissionRequestProto.permission:type_name -> hadoop.hdfs.FsPermissionProto
	184, // 11: hadoop.hdfs.AbandonBlockRequestProto.b:type_name -> hadoop.hdfs.ExtendedBlockProto
	184, // 12: hadoop.hdfs.AddBlockRequestProto.previous:type_name -> hadoop.hdfs.ExtendedBlockProto
	185, // 13: hadoop.hdfs.AddBlockRequestProto.excludeNodes:type_name -> hadoop.hdfs.DatanodeInfoProto
	1,   // 14: hadoop.hdfs.AddBlockRequestProto.flags:type_name -> hadoop.hdfs.AddBlockFlagProto
	182, // 15: hadoop.hdfs.AddBlockResponseProto.block:type_name -> hadoop.hdfs.LocatedBlockProto
	184, // 16: hadoop.hdfs.GetAdditionalDatanodeRequestProto.blk:type_name -> hadoop.hdfs.ExtendedBlockProto
	185, // 17: hadoop.hdfs.GetAdditionalDatanodeRequestProto.existings:type_name -> hadoop.hdfs.DatanodeInfoProto
	185, // 18: hadoop.hdfs.GetAdditionalDatanodeRequestProto.excludes:type_name -> hadoop.hdfs.DatanodeInfoProto
	182, // 19: hadoop.hdfs.GetAdditionalDatanodeResponseProto.block:type_name -> hadoop.hdfs.LocatedBlockProto
	184, // 20: hadoop.hdfs.CompleteRequestProto.last:type_name -> hadoop.hdfs.ExtendedBlockProto
	182, // 21: hadoop.hdfs.ReportBadBlocksRequestProto.blocks:type_name -> hadoop.hdfs.LocatedBlockProto
	179, // 22: hadoop.hdfs.MkdirsRequestProto.masked:type_name -> hadoop.hdfs.FsPermissionProto
	179, // 23: hadoop.hdfs.MkdirsRequestProto.unmasked:type_name -> hadoop.hdfs.FsPermissionProto
	186, // 24: hadoop.hdfs.GetListingResponseProto.dirList:type_name -> hadoop.hdfs.DirectoryListingProto
	187, // 25: hadoop.hdfs.GetBatchedListingResponseProto.listings:type_name -> hadoop.hdfs.BatchedDirectoryListingProto
	188, // 26: hadoop.hdfs.GetSnapshottableDirListingResponseProto.snapshottableDirList:type_name -> hadoop.hdfs.SnapshottableDirectoryListingProto
	189, // 27: hadoop.hdfs.GetSnapshotDiffReportResponseProto.diffReport:type_name -> hadoop.hdfs.SnapshotDiffReportProto
	190, // 28: hadoop.hdfs.GetSnapshotDiffReportListingRequestProto.cursor:type_name -> hadoop.hdfs.SnapshotDiffReportCursorProto
	191, // 29: hadoop.hdfs.GetSnapshotDiffReportListingResponseProto.diffReport:type_name -> hadoop.hdfs.SnapshotDiffReportListingProto
	2,   // 30: hadoop.hdfs.GetDatanodeReportRequestProto.type:type_name -> hadoop.hdfs.DatanodeReportTypeProto
	185, // 31: hadoop.hdfs.GetDatanodeReportResponseProto.di:type_name -> hadoop.hdfs.DatanodeInfoProto
	2,   // 32: hadoop.hdfs.GetDatanodeStorageReportRequestProto.type:type_name -> hadoop.hdfs.DatanodeReportTypeProto
	185, // 33: hadoop.hdfs.DatanodeStorageReportProto.datanodeInfo:type_name -> hadoop.hdfs.DatanodeInfoProto
	192, // 34: hadoop.hdfs.DatanodeStorageReportProto.storageReports:type_name -> hadoop.hdfs.StorageReportProto
	74,  // 35: hadoop.hdfs.GetDatanodeStorageReportResponseProto.datanodeStorageReports:type_name -> hadoop.hdfs.DatanodeStorageReportProto
	3,   // 36: hadoop.hdfs.SetSafeModeRequestProto.action:type_name -> hadoop.hdfs.SafeModeActionProto
	4,   // 37: hadoop.hdfs.RollingUpgradeRequestProto.action:type_name -> hadoop.hdfs.RollingUpgradeActionProto
	193, // 38: hadoop.hdfs.RollingUpgradeInfoProto.status:type_name -> hadoop.hdfs.RollingUpgradeStatusProto
	93,  // 39: hadoop.hdfs.RollingUpgradeResponseProto.rollingUpgradeInfo:type_name -> hadoop.hdfs.RollingUpgradeInfoProto
	194, // 40: hadoop.hdfs.ListCorruptFileBlocksResponseProto.corrupt:type_name -> hadoop.hdfs.CorruptFileBlocksProto
	181, // 41: hadoop.hdfs.GetFileInfoResponseProto.fs:type_name -> hadoop.hdfs.HdfsFileStatusProto
	181, // 42: hadoop.hdfs.GetLocatedFileInfoResponseProto.fs:type_name -> hadoop.hdfs.HdfsFileStatusProto
	106, // 43: hadoop.hdfs.CacheDirectiveInfoProto.expiration:type_name -> hadoop.hdfs.CacheDirectiveInfoExpirationProto
	105, // 44: hadoop.hdfs.AddCacheDirectiveRequestProto.info:type_name -> hadoop.hdfs.CacheDirectiveInfoProto
	105, // 45: hadoop.hdfs.ModifyCacheDirectiveRequestProto.info:type_name -> hadoop.hdfs.CacheDirectiveInfoProto
	105, // 46: hadoop.hdfs.ListCacheDirectivesRequestProto.filter:type_name -> hadoop.hdfs.CacheDirectiveInfoProto
	105, // 47: hadoop.hdfs.CacheDirectiveEntryProto.info:type_name -> hadoop.hdfs.CacheDirectiveInfoProto
	107, // 48: hadoop.hdfs.CacheDirectiveEntryProto.stats:type_name -> hadoop.hdfs.CacheDirectiveStatsProto
	115, // 49: hadoop.hdfs.ListCacheDirectivesResponseProto.elements:type_name -> hadoop.hdfs.CacheDirectiveEntryProto
	117, // 50: hadoop.hdfs.AddCachePoolRequestProto.info:type_name -> hadoop.hdfs.CachePoolInfoProto
	117, // 51: hadoop.hdfs.ModifyCachePoolRequestProto.info:type_name -> hadoop.hdfs.CachePoolInfoProto
	127, // 52: hadoop.hdfs.ListCachePoolsResponseProto.entries:type_name -> hadoop.hdfs.CachePoolEntryProto
	117, // 53: hadoop.hdfs.CachePoolEntryProto.info:type_name -> hadoop.hdfs.CachePoolInfoProto
	118, // 54: hadoop.hdfs.CachePoolEntryProto.stats:type_name -> hadoop.hdfs.CachePoolStatsProto
	181, // 55: hadoop.hdfs.GetFileLinkInfoResponseProto.fs:type_name -> hadoop.hdfs.HdfsFileStatusProto
	195, // 56: hadoop.hdfs.GetContentSummaryResponseProto.summary:type_name -> hadoop.hdfs.ContentSummaryProto
	196, // 57: hadoop.hdfs.GetQuotaUsageResponseProto.usage:type_name -> hadoop.hdfs.QuotaUsageProto
	197, // 58: hadoop.hdfs.SetQuotaRequestProto.storageType:type_name -> hadoop.hdfs.StorageTypeProto
	179, // 59: hadoop.hdfs.CreateSymlinkRequestProto.dirPerm:type_name -> hadoop.hdfs.FsPermissionProto
	184, // 60: hadoop.hdfs.UpdateBlockForPipelineRequestProto.block:type_name -> hadoop.hdfs.ExtendedBlockProto
	182, // 61: hadoop.hdfs.UpdateBlockForPipelineResponseProto.block:type_name -> hadoop.hdfs.LocatedBlockProto
	184, // 62: hadoop.hdfs.UpdatePipelineRequestProto.oldBlock:type_name -> hadoop.hdfs.ExtendedBlockProto
	184, // 63: hadoop.hdfs.UpdatePipelineRequestProto.newBlock:type_name -> hadoop.hdfs.ExtendedBlockProto
	198, // 64: hadoop.hdfs.UpdatePipelineRequestProto.newNodes:type_name -> hadoop.hdfs.DatanodeIDProto
	199, // 65: hadoop.hdfs.GetDataEncryptionKeyResponseProto.dataEncryptionKey:type_name -> hadoop.hdfs.DataEncryptionKeyProto
	200, // 66: hadoop.hdfs.CheckAccessRequestProto.mode:type_name -> hadoop.hdfs.AclEntryProto.FsActionProto
	201, // 67: hadoop.hdfs.GetEditsFromTxidResponseProto.eventsList:type_name -> hadoop.hdfs.EventsListProto
	6,   // 68: hadoop.hdfs.ListOpenFilesRequestProto.types:type_name -> hadoop.hdfs.OpenFilesTypeProto
	169, // 69: hadoop.hdfs.ListOpenFilesResponseProto.entries:type_name -> hadoop.hdfs.OpenFilesBatchResponseProto
	6,   // 70: hadoop.hdfs.ListOpenFilesResponseProto.types:type_name -> hadoop.hdfs.OpenFilesTypeProto
	202, // 71: hadoop.hdfs.HAServiceStateResponseProto.state:type_name -> hadoop.common.HAServiceStateProto
	7,   // 72: hadoop.hdfs.ClientNamenodeProtocol.getBlockLocations:input_type -> hadoop.hdfs.GetBlockLocationsRequestProto
	9,   // 73: hadoop.hdfs.ClientNamenodeProtocol.getServerDefaults:input_type -> hadoop.hdfs.GetServerDefaultsRequestProto
	11,  // 74: hadoop.hdfs.ClientNamenodeProtocol.create:input_type -> hadoop.hdfs.CreateRequestProto
	13,  // 75: hadoop.hdfs.ClientNamenodeProtocol.append:input_type -> hadoop.hdfs.AppendRequestProto
	15,  // 76: hadoop.hdfs.ClientNamenodeProtocol.setReplication:input_type -> hadoop.hdfs.SetReplicationRequestProto
	17,  // 77: hadoop.hdfs.ClientNamenodeProtocol.setStoragePolicy:input_type -> hadoop.hdfs.SetStoragePolicyRequestProto
	19,  // 78: hadoop.hdfs.ClientNamenodeProtocol.unsetStoragePolicy:input_type -> hadoop.hdfs.UnsetStoragePolicyRequestProto
	21,  // 79: hadoop.hdfs.ClientNamenodeProtocol.getStoragePolicy:input_type -> hadoop.hdfs.GetStoragePolicyRequestProto
	23,  // 80: hadoop.hdfs.ClientNamenodeProtocol.getStoragePolicies:input_type -> hadoop.hdfs.GetStoragePoliciesRequestProto
	25,  // 81: hadoop.hdfs.ClientNamenodeProtocol.setPermission:input_type -> hadoop.hdfs.SetPermissionRequestProto
	27,  // 82: hadoop.hdfs.ClientNamenodeProtocol.setOwner:input_type -> hadoop.hdfs.SetOwnerRequestProto
	29,  // 83: hadoop.hdfs.ClientNamenodeProtocol.abandonBlock:input_type -> hadoop.hdfs.AbandonBlockRequestProto
	31,  // 84: hadoop.hdfs.ClientNamenodeProtocol.addBlock:input_type -> hadoop.hdfs.AddBlockRequestProto
	33,  // 85: hadoop.hdfs.ClientNamenodeProtocol.getAdditionalDatanode:input_type -> hadoop.hdfs.GetAdditionalDatanodeRequestProto
	35,  // 86: hadoop.hdfs.ClientNamenodeProtocol.complete:input_type -> hadoop.hdfs.CompleteRequestProto
	37,  // 87: hadoop.hdfs.ClientNamenodeProtocol.reportBadBlocks:input_type -> hadoop.hdfs.ReportBadBlocksRequestProto
	39,  // 88: hadoop.hdfs.ClientNamenodeProtocol.concat:input_type -> hadoop.hdfs.ConcatRequestProto
	41,  // 89: hadoop.hdfs.ClientNamenodeProtocol.truncate:input_type -> hadoop.hdfs.TruncateRequestProto
	43,  // 90: hadoop.hdfs.ClientNamenodeProtocol.rename:input_type -> hadoop.hdfs.RenameRequestProto
	45,  // 91: hadoop.hdfs.ClientNamenodeProtocol.rename2:input_type -> hadoop.hdfs.Rename2RequestProto
	47,  // 92: hadoop.hdfs.ClientNamenodeProtocol.delete:input_type -> hadoop.hdfs.DeleteRequestProto
	49,  // 93: hadoop.hdfs.ClientNamenodeProtocol.mkdirs:input_type -> hadoop.hdfs.MkdirsRequestProto
	51,  // 94: hadoop.hdfs.ClientNamenodeProtocol.getListing:input_type -> hadoop.hdfs.GetListingRequestProto
	53,  // 95: hadoop.hdfs.ClientNamenodeProtocol.getBatchedListing:input_type -> hadoop.hdfs.GetBatchedListingRequestProto
	61,  // 96: hadoop.hdfs.ClientNamenodeProtocol.renewLease:input_type -> hadoop.hdfs.RenewLeaseRequestProto
	63,  // 97: hadoop.hdfs.ClientNamenodeProtocol.recoverLease:input_type -> hadoop.hdfs.RecoverLeaseRequestProto
	65,  // 98: hadoop.hdfs.ClientNamenodeProtocol.getFsStats:input_type -> hadoop.hdfs.GetFsStatusRequestProto
	67,  // 99: hadoop.hdfs.ClientNamenodeProtocol.getFsReplicatedBlockStats:input_type -> hadoop.hdfs.GetFsReplicatedBlockStatsRequestProto
	69,  // 100: hadoop.hdfs.ClientNamenodeProtocol.getFsECBlockGroupStats:input_type -> hadoop.hdfs.GetFsECBlockGroupStatsRequestProto
	71,  // 101: hadoop.hdfs.ClientNamenodeProtocol.getDatanodeReport:input_type -> hadoop.hdfs.GetDatanodeReportRequestProto
	73,  // 102: hadoop.hdfs.ClientNamenodeProtocol.getDatanodeStorageReport:input_type -> hadoop.hdfs.GetDatanodeStorageReportRequestProto
	76,  // 103: hadoop.hdfs.ClientNamenodeProtocol.getPreferredBlockSize:input_type -> hadoop.hdfs.GetPreferredBlockSizeRequestProto
	78,  // 104: hadoop.hdfs.ClientNamenodeProtocol.setSafeMode:input_type -> hadoop.hdfs.SetSafeModeRequestProto
	80,  // 105: hadoop.hdfs.ClientNamenodeProtocol.saveNamespace:input_type -> hadoop.hdfs.SaveNamespaceRequestProto
	82,  // 106: hadoop.hdfs.ClientNamenodeProtocol.rollEdits:input_type -> hadoop.hdfs.RollEditsRequestProto
	84,  // 107: hadoop.hdfs.ClientNamenodeProtocol.restoreFailedStorage:input_type -> hadoop.hdfs.RestoreFailedStorageRequestProto
	86,  // 108: hadoop.hdfs.ClientNamenodeProtocol.refreshNodes:input_type -> hadoop.hdfs.RefreshNodesRequestProto
	88,  // 109: hadoop.hdfs.ClientNamenodeProtocol.finalizeUpgrade:input_type -> hadoop.hdfs.FinalizeUpgradeRequestProto
	90,  // 110: hadoop.hdfs.ClientNamenodeProtocol.upgradeStatus:input_type -> hadoop.hdfs.UpgradeStatusRequestProto
	92,  // 111: hadoop.hdfs.ClientNamenodeProtocol.rollingUpgrade:input_type -> hadoop.hdfs.RollingUpgradeRequestProto
	95,  // 112: hadoop.hdfs.ClientNamenodeProtocol.listCorruptFileBlocks:input_type -> hadoop.hdfs.ListCorruptFileBlocksRequestProto
	97,  // 113: hadoop.hdfs.ClientNamenodeProtocol.metaSave:input_type -> hadoop.hdfs.MetaSaveRequestProto
	99,  // 114: hadoop.hdfs.ClientNamenodeProtocol.getFileInfo:input_type -> hadoop.hdfs.GetFileInfoRequestProto
	101, // 115: hadoop.hdfs.ClientNamenodeProtocol.getLocatedFileInfo:input_type -> hadoop.hdfs.GetLocatedFileInfoRequestProto
	108, // 116: hadoop.hdfs.ClientNamenodeProtocol.addCacheDirective:input_type -> hadoop.hdfs.AddCacheDirectiveRequestProto
	110, // 117: hadoop.hdfs.ClientNamenodeProtocol.modifyCacheDirective:input_type -> hadoop.hdfs.ModifyCacheDirectiveRequestProto
	112, // 118: hadoop.hdfs.ClientNamenodeProtocol.removeCacheDirective:input_type -> hadoop.hdfs.RemoveCacheDirectiveRequestProto
	114, // 119: hadoop.hdfs.ClientNamenodeProtocol.listCacheDirectives:input_type -> hadoop.hdfs.ListCacheDirectivesRequestProto
	119, // 120: hadoop.hdfs.ClientNamenodeProtocol.addCachePool:input_type -> hadoop.hdfs.AddCachePoolRequestProto
	121, // 121: hadoop.hdfs.ClientNamenodeProtocol.modifyCachePool:input_type -> hadoop.hdfs.ModifyCachePoolRequestProto
	123, // 122: hadoop.hdfs.ClientNamenodeProtocol.removeCachePool:input_type -> hadoop.hdfs.RemoveCachePoolRequestProto
	125, // 123: hadoop.hdfs.ClientNamenodeProtocol.listCachePools:input_type -> hadoop.hdfs.ListCachePoolsRequestProto
	128, // 124: hadoop.hdfs.ClientNamenodeProtocol.getFileLinkInfo:input_type -> hadoop.hdfs.GetFileLinkInfoRequestProto
	130, // 125: hadoop.hdfs.ClientNamenodeProtocol.getContentSummary:input_type -> hadoop.hdfs.GetContentSummaryRequestProto
	134, // 126: hadoop.hdfs.ClientNamenodeProtocol.setQuota:input_type -> hadoop.hdfs.SetQuotaRequestProto
	136, // 127: hadoop.hdfs.ClientNamenodeProtocol.fsync:input_type -> hadoop.hdfs.FsyncRequestProto
	138, // 128: hadoop.hdfs.ClientNamenodeProtocol.setTimes:input_type -> hadoop.hdfs.SetTimesRequestProto
	140, // 129: hadoop.hdfs.ClientNamenodeProtocol.createSymlink:input_type -> hadoop.hdfs.CreateSymlinkRequestProto
	142, // 130: hadoop.hdfs.ClientNamenodeProtocol.getLinkTarget:input_type -> hadoop.hdfs.GetLinkTargetRequestProto
	144, // 131: hadoop.hdfs.ClientNamenodeProtocol.updateBlockForPipeline:input_type -> hadoop.hdfs.UpdateBlockForPipelineRequestProto
	146, // 132: hadoop.hdfs.ClientNamenodeProtocol.updatePipeline:input_type -> hadoop.hdfs.UpdatePipelineRequestProto
	203, // 133: hadoop.hdfs.ClientNamenodeProtocol.getDelegationToken:input_type -> hadoop.common.GetDelegationTokenRequestProto
	204, // 134: hadoop.hdfs.ClientNamenodeProtocol.renewDelegationToken:input_type -> hadoop.common.RenewDelegationTokenRequestProto
	205, // 135: hadoop.hdfs.ClientNamenodeProtocol.cancelDelegationToken:input_type -> hadoop.common.CancelDelegationTokenRequestProto
	148, // 136: hadoop.hdfs.ClientNamenodeProtocol.setBalancerBandwidth:input_type -> hadoop.hdfs.SetBalancerBandwidthRequestProto
	150, // 137: hadoop.hdfs.ClientNamenodeProtocol.getDataEncryptionKey:input_type -> hadoop.hdfs.GetDataEncryptionKeyRequestProto
	152, // 138: hadoop.hdfs.ClientNamenodeProtocol.createSnapshot:input_type -> hadoop.hdfs.CreateSnapshotRequestProto
	154, // 139: hadoop.hdfs.ClientNamenodeProtocol.renameSnapshot:input_type -> hadoop.hdfs.RenameSnapshotRequestProto
	156, // 140: hadoop.hdfs.ClientNamenodeProtocol.allowSnapshot:input_type -> hadoop.hdfs.AllowSnapshotRequestProto
	158, // 141: hadoop.hdfs.ClientNamenodeProtocol.disallowSnapshot:input_type -> hadoop.hdfs.DisallowSnapshotRequestProto
	55,  // 142: hadoop.hdfs.ClientNamenodeProtocol.getSnapshottableDirListing:input_type -> hadoop.hdfs.GetSnapshottableDirListingRequestProto
	160, // 143: hadoop.hdfs.ClientNamenodeProtocol.deleteSnapshot:input_type -> hadoop.hdfs.DeleteSnapshotRequestProto
	57,  // 144: hadoop.hdfs.ClientNamenodeProtocol.getSnapshotDiffReport:input_type -> hadoop.hdfs.GetSnapshotDiffReportRequestProto
	59,  // 145: hadoop.hdfs.ClientNamenodeProtocol.getSnapshotDiffReportListing:input_type -> hadoop.hdfs.GetSnapshotDiffReportListingRequestProto
	103, // 146: hadoop.hdfs.ClientNamenodeProtocol.isFileClosed:input_type -> hadoop.hdfs.IsFileClosedRequestProto
	206, // 147: hadoop.hdfs.ClientNamenodeProtocol.modifyAclEntries:input_type -> hadoop.hdfs.ModifyAclEntriesRequestProto
	207, // 148: hadoop.hdfs.ClientNamenodeProtocol.removeAclEntries:input_type -> hadoop.hdfs.RemoveAclEntriesRequestProto
	208, // 149: hadoop.hdfs.ClientNamenodeProtocol.removeDefaultAcl:input_type -> hadoop.hdfs.RemoveDefaultAclRequestProto
	209, // 150: hadoop.hdfs.ClientNamenodeProtocol.removeAcl:input_type -> hadoop.hdfs.RemoveAclRequestProto
	210, // 151: hadoop.hdfs.ClientNamenodeProtocol.setAcl:input_type -> hadoop.hdfs.SetAclRequestProto
	211, // 152: hadoop.hdfs.ClientNamenodeProtocol.getAclStatus:input_type -> hadoop.hdfs.GetAclStatusRequestProto
	212, // 153: hadoop.hdfs.ClientNamenodeProtocol.setXAttr:input_type -> hadoop.hdfs.SetXAttrRequestProto
	213, // 154: hadoop.hdfs.ClientNamenodeProtocol.getXAttrs:input_type -> hadoop.hdfs.GetXAttrsRequestProto
	214, // 155: hadoop.hdfs.ClientNamenodeProtocol.listXAttrs:input_type -> hadoop.hdfs.ListXAttrsRequestProto
	215, // 156: hadoop.hdfs.ClientNamenodeProtocol.removeXAttr:input_type -> hadoop.hdfs.RemoveXAttrRequestProto
	162, // 157: hadoop.hdfs.ClientNamenodeProtocol.checkAccess:input_type -> hadoop.hdfs.CheckAccessRequestProto
	216, // 158: hadoop.hdfs.ClientNamenodeProtocol.createEncryptionZone:input_type -> hadoop.hdfs.CreateEncryptionZoneRequestProto
	217, // 159: hadoop.hdfs.ClientNamenodeProtocol.listEncryptionZones:input_type -> hadoop.hdfs.ListEncryptionZonesRequestProto
	218, // 160: hadoop.hdfs.ClientNamenodeProtocol.reencryptEncryptionZone:input_type -> hadoop.hdfs.ReencryptEncryptionZoneRequestProto
	219, // 161: hadoop.hdfs.ClientNamenodeProtocol.listReencryptionStatus:input_type -> hadoop.hdfs.ListReencryptionStatusRequestProto
	220, // 162: hadoop.hdfs.ClientNamenodeProtocol.getEZForPath:input_type -> hadoop.hdfs.GetEZForPathRequestProto
	221, // 163: hadoop.hdfs.ClientNamenodeProtocol.setErasureCodingPolicy:input_type -> hadoop.hdfs.SetErasureCodingPolicyRequestProto
	222, // 164: hadoop.hdfs.ClientNamenodeProtocol.unsetErasureCodingPolicy:input_type -> hadoop.hdfs.UnsetErasureCodingPolicyRequestProto
	223, // 165: hadoop.hdfs.ClientNamenodeProtocol.getECTopologyResultForPolicies:input_type -> hadoop.hdfs.GetECTopologyResultForPoliciesRequestProto
	164, // 166: hadoop.hdfs.ClientNamenodeProtocol.getCurrentEditLogTxid:input_type -> hadoop.hdfs.GetCurrentEditLogTxidRequestProto
	166, // 167: hadoop.hdfs.ClientNamenodeProtocol.getEditsFromTxid:input_type -> hadoop.hdfs.GetEditsFromTxidRequestProto
	224, // 168: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingPolicies:input_type -> hadoop.hdfs.GetErasureCodingPoliciesRequestProto
	225, // 169: hadoop.hdfs.ClientNamenodeProtocol.addErasureCodingPolicies:input_type -> hadoop.hdfs.AddErasureCodingPoliciesRequestProto
	226, // 170: hadoop.hdfs.ClientNamenodeProtocol.removeErasureCodingPolicy:input_type -> hadoop.hdfs.RemoveErasureCodingPolicyRequestProto
	227, // 171: hadoop.hdfs.ClientNamenodeProtocol.enableErasureCodingPolicy:input_type -> hadoop.hdfs.EnableErasureCodingPolicyRequestProto
	228, // 172: hadoop.hdfs.ClientNamenodeProtocol.disableErasureCodingPolicy:input_type -> hadoop.hdfs.DisableErasureCodingPolicyRequestProto
	229, // 173: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingPolicy:input_type -> hadoop.hdfs.GetErasureCodingPolicyRequestProto
	230, // 174: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingCodecs:input_type -> hadoop.hdfs.GetErasureCodingCodecsRequestProto
	132, // 175: hadoop.hdfs.ClientNamenodeProtocol.getQuotaUsage:input_type -> hadoop.hdfs.GetQuotaUsageRequestProto
	168, // 176: hadoop.hdfs.ClientNamenodeProtocol.listOpenFiles:input_type -> hadoop.hdfs.ListOpenFilesRequestProto
	171, // 177: hadoop.hdfs.ClientNamenodeProtocol.msync:input_type -> hadoop.hdfs.MsyncRequestProto
	173, // 178: hadoop.hdfs.ClientNamenodeProtocol.satisfyStoragePolicy:input_type -> hadoop.hdfs.SatisfyStoragePolicyRequestProto
	175, // 179: hadoop.hdfs.ClientNamenodeProtocol.getHAServiceState:input_type -> hadoop.hdfs.HAServiceStateRequestProto
	8,   // 180: hadoop.hdfs.ClientNamenodeProtocol.getBlockLocations:output_type -> hadoop.hdfs.GetBlockLocationsResponseProto
	10,  // 181: hadoop.hdfs.ClientNamenodeProtocol.getServerDefaults:output_type -> hadoop.hdfs.GetServerDefaultsResponseProto
	12,  // 182: hadoop.hdfs.ClientNamenodeProtocol.create:output_type -> hadoop.hdfs.CreateResponseProto
	14,  // 183: hadoop.hdfs.ClientNamenodeProtocol.append:output_type -> hadoop.hdfs.AppendResponseProto
	16,  // 184: hadoop.hdfs.ClientNamenodeProtocol.setReplication:output_type -> hadoop.hdfs.SetReplicationResponseProto
	18,  // 185: hadoop.hdfs.ClientNamenodeProtocol.setStoragePolicy:output_type -> hadoop.hdfs.SetStoragePolicyResponseProto
	20,  // 186: hadoop.hdfs.ClientNamenodeProtocol.unsetStoragePolicy:output_type -> hadoop.hdfs.UnsetStoragePolicyResponseProto
	22,  // 187: hadoop.hdfs.ClientNamenodeProtocol.getStoragePolicy:output_type -> hadoop.hdfs.GetStoragePolicyResponseProto
	24,  // 188: hadoop.hdfs.ClientNamenodeProtocol.getStoragePolicies:output_type -> hadoop.hdfs.GetStoragePoliciesResponseProto
	26,  // 189: hadoop.hdfs.ClientNamenodeProtocol.setPermission:output_type -> hadoop.hdfs.SetPermissionResponseProto
	28,  // 190: hadoop.hdfs.ClientNamenodeProtocol.setOwner:output_type -> hadoop.hdfs.SetOwnerResponseProto
	30,  // 191: hadoop.hdfs.ClientNamenodeProtocol.abandonBlock:output_type -> hadoop.hdfs.AbandonBlockResponseProto
	32,  // 192: hadoop.hdfs.ClientNamenodeProtocol.addBlock:output_type -> hadoop.hdfs.AddBlockResponseProto
	34,  // 193: hadoop.hdfs.ClientNamenodeProtocol.getAdditionalDatanode:output_type -> hadoop.hdfs.GetAdditionalDatanodeResponseProto
	36,  // 194: hadoop.hdfs.ClientNamenodeProtocol.complete:output_type -> hadoop.hdfs.CompleteResponseProto
	38,  // 195: hadoop.hdfs.ClientNamenodeProtocol.reportBadBlocks:output_type -> hadoop.hdfs.ReportBadBlocksResponseProto
	40,  // 196: hadoop.hdfs.ClientNamenodeProtocol.concat:output_type -> hadoop.hdfs.ConcatResponseProto
	42,  // 197: hadoop.hdfs.ClientNamenodeProtocol.truncate:output_type -> hadoop.hdfs.TruncateResponseProto
	44,  // 198: hadoop.hdfs.ClientNamenodeProtocol.rename:output_type -> hadoop.hdfs.RenameResponseProto
	46,  // 199: hadoop.hdfs.ClientNamenodeProtocol.rename2:output_type -> hadoop.hdfs.Rename2ResponseProto
	48,  // 200: hadoop.hdfs.ClientNamenodeProtocol.delete:output_type -> hadoop.hdfs.DeleteResponseProto
	50,  // 201: hadoop.hdfs.ClientNamenodeProtocol.mkdirs:output_type -> hadoop.hdfs.MkdirsResponseProto
	52,  // 202: hadoop.hdfs.ClientNamenodeProtocol.getListing:output_type -> hadoop.hdfs.GetListingResponseProto
	54,  // 203: hadoop.hdfs.ClientNamenodeProtocol.getBatchedListing:output_type -> hadoop.hdfs.GetBatchedListingResponseProto
	62,  // 204: hadoop.hdfs.ClientNamenodeProtocol.renewLease:output_type -> hadoop.hdfs.RenewLeaseResponseProto
	64,  // 205: hadoop.hdfs.ClientNamenodeProtocol.recoverLease:output_type -> hadoop.hdfs.RecoverLeaseResponseProto
	66,  // 206: hadoop.hdfs.ClientNamenodeProtocol.getFsStats:output_type -> hadoop.hdfs.GetFsStatsResponseProto
	68,  // 207: hadoop.hdfs.ClientNamenodeProtocol.getFsReplicatedBlockStats:output_type -> hadoop.hdfs.GetFsReplicatedBlockStatsResponseProto
	70,  // 208: hadoop.hdfs.ClientNamenodeProtocol.getFsECBlockGroupStats:output_type -> hadoop.hdfs.GetFsECBlockGroupStatsResponseProto
	72,  // 209: hadoop.hdfs.ClientNamenodeProtocol.getDatanodeReport:output_type -> hadoop.hdfs.GetDatanodeReportResponseProto
	75,  // 210: hadoop.hdfs.ClientNamenodeProtocol.getDatanodeStorageReport:output_type -> hadoop.hdfs.GetDatanodeStorageReportResponseProto
	77,  // 211: hadoop.hdfs.ClientNamenodeProtocol.getPreferredBlockSize:output_type -> hadoop.hdfs.GetPreferredBlockSizeResponseProto
	79,  // 212: hadoop.hdfs.ClientNamenodeProtocol.setSafeMode:output_type -> hadoop.hdfs.SetSafeModeResponseProto
	81,  // 213: hadoop.hdfs.ClientNamenodeProtocol.saveNamespace:output_type -> hadoop.hdfs.SaveNamespaceResponseProto
	83,  // 214: hadoop.hdfs.ClientNamenodeProtocol.rollEdits:output_type -> hadoop.hdfs.RollEditsResponseProto
	85,  // 215: hadoop.hdfs.ClientNamenodeProtocol.restoreFailedStorage:output_type -> hadoop.hdfs.RestoreFailedStorageResponseProto
	87,  // 216: hadoop.hdfs.ClientNamenodeProtocol.refreshNodes:output_type -> hadoop.hdfs.RefreshNodesResponseProto
	89,  // 217: hadoop.hdfs.ClientNamenodeProtocol.finalizeUpgrade:output_type -> hadoop.hdfs.FinalizeUpgradeResponseProto
	91,  // 218: hadoop.hdfs.ClientNamenodeProtocol.upgradeStatus:output_type -> hadoop.hdfs.UpgradeStatusResponseProto
	94,  // 219: hadoop.hdfs.ClientNamenodeProtocol.rollingUpgrade:output_type -> hadoop.hdfs.RollingUpgradeResponseProto
	96,  // 220: hadoop.hdfs.ClientNamenodeProtocol.listCorruptFileBlocks:output_type -> hadoop.hdfs.ListCorruptFileBlocksResponseProto
	98,  // 221: hadoop.hdfs.ClientNamenodeProtocol.metaSave:output_type -> hadoop.hdfs.MetaSaveResponseProto
	100, // 222: hadoop.hdfs.ClientNamenodeProtocol.getFileInfo:output_type -> hadoop.hdfs.GetFileInfoResponseProto
	102, // 223: hadoop.hdfs.ClientNamenodeProtocol.getLocatedFileInfo:output_type -> hadoop.hdfs.GetLocatedFileInfoResponseProto
	109, // 224: hadoop.hdfs.ClientNamenodeProtocol.addCacheDirective:output_type -> hadoop.hdfs.AddCacheDirectiveResponseProto
	111, // 225: hadoop.hdfs.ClientNamenodeProtocol.modifyCacheDirective:output_type -> hadoop.hdfs.ModifyCacheDirectiveResponseProto
	113, // 226: hadoop.hdfs.ClientNamenodeProtocol.removeCacheDirective:output_type -> hadoop.hdfs.RemoveCacheDirectiveResponseProto
	116, // 227: hadoop.hdfs.ClientNamenodeProtocol.listCacheDirectives:output_type -> hadoop.hdfs.ListCacheDirectivesResponseProto
	120, // 228: hadoop.hdfs.ClientNamenodeProtocol.addCachePool:output_type -> hadoop.hdfs.AddCachePoolResponseProto
	122, // 229: hadoop.hdfs.ClientNamenodeProtocol.modifyCachePool:output_type -> hadoop.hdfs.ModifyCachePoolResponseProto
	124, // 230: hadoop.hdfs.ClientNamenodeProtocol.removeCachePool:output_type -> hadoop.hdfs.RemoveCachePoolResponseProto
	126, // 231: hadoop.hdfs.ClientNamenodeProtocol.listCachePools:output_type -> hadoop.hdfs.ListCachePoolsResponseProto
	129, // 232: hadoop.hdfs.ClientNamenodeProtocol.getFileLinkInfo:output_type -> hadoop.hdfs.GetFileLinkInfoResponseProto
	131, // 233: hadoop.hdfs.ClientNamenodeProtocol.getContentSummary:output_type -> hadoop.hdfs.GetContentSummaryResponseProto
	135, // 234: hadoop.hdfs.ClientNamenodeProtocol.setQuota:output_type -> hadoop.hdfs.SetQuotaResponseProto
	137, // 235: hadoop.hdfs.ClientNamenodeProtocol.fsync:output_type -> hadoop.hdfs.FsyncResponseProto
	139, // 236: hadoop.hdfs.ClientNamenodeProtocol.setTimes:output_type -> hadoop.hdfs.SetTimesResponseProto
	141, // 237: hadoop.hdfs.ClientNamenodeProtocol.createSymlink:output_type -> hadoop.hdfs.CreateSymlinkResponseProto
	143, // 238: hadoop.hdfs.ClientNamenodeProtocol.getLinkTarget:output_type -> hadoop.hdfs.GetLinkTargetResponseProto
	145, // 239: hadoop.hdfs.ClientNamenodeProtocol.updateBlockForPipeline:output_type -> hadoop.hdfs.UpdateBlockForPipelineResponseProto
	147, // 240: hadoop.hdfs.ClientNamenodeProtocol.updatePipeline:output_type -> hadoop.hdfs.UpdatePipelineResponseProto
	231, // 241: hadoop.hdfs.ClientNamenodeProtocol.getDelegationToken:output_type -> hadoop.common.GetDelegationTokenResponseProto
	232, // 242: hadoop.hdfs.ClientNamenodeProtocol.renewDelegationToken:output_type -> hadoop.common.RenewDelegationTokenResponseProto
	233, // 243: hadoop.hdfs.ClientNamenodeProtocol.cancelDelegationToken:output_type -> hadoop.common.CancelDelegationTokenResponseProto
	149, // 244: hadoop.hdfs.ClientNamenodeProtocol.setBalancerBandwidth:output_type -> hadoop.hdfs.SetBalancerBandwidthResponseProto
	151, // 245: hadoop.hdfs.ClientNamenodeProtocol.getDataEncryptionKey:output_type -> hadoop.hdfs.GetDataEncryptionKeyResponseProto
	153, // 246: hadoop.hdfs.ClientNamenodeProtocol.createSnapshot:output_type -> hadoop.hdfs.CreateSnapshotResponseProto
	155, // 247: hadoop.hdfs.ClientNamenodeProtocol.renameSnapshot:output_type -> hadoop.hdfs.RenameSnapshotResponseProto
	157, // 248: hadoop.hdfs.ClientNamenodeProtocol.allowSnapshot:output_type -> hadoop.hdfs.AllowSnapshotResponseProto
	159, // 249: hadoop.hdfs.ClientNamenodeProtocol.disallowSnapshot:output_type -> hadoop.hdfs.DisallowSnapshotResponseProto
	56,  // 250: hadoop.hdfs.ClientNamenodeProtocol.getSnapshottableDirListing:output_type -> hadoop.hdfs.GetSnapshottableDirListingResponseProto
	161, // 251: hadoop.hdfs.ClientNamenodeProtocol.deleteSnapshot:output_type -> hadoop.hdfs.DeleteSnapshotResponseProto
	58,  // 252: hadoop.hdfs.ClientNamenodeProtocol.getSnapshotDiffReport:output_type -> hadoop.hdfs.GetSnapshotDiffReportResponseProto
	60,  // 253: hadoop.hdfs.ClientNamenodeProtocol.getSnapshotDiffReportListing:output_type -> hadoop.hdfs.GetSnapshotDiffReportListingResponseProto
	104, // 254: hadoop.hdfs.ClientNamenodeProtocol.isFileClosed:output_type -> hadoop.hdfs.IsFileClosedResponseProto
	234, // 255: hadoop.hdfs.ClientNamenodeProtocol.modifyAclEntries:output_type -> hadoop.hdfs.ModifyAclEntriesResponseProto
	235, // 256: hadoop.hdfs.ClientNamenodeProtocol.removeAclEntries:output_type -> hadoop.hdfs.RemoveAclEntriesResponseProto
	236, // 257: hadoop.hdfs.ClientNamenodeProtocol.removeDefaultAcl:output_type -> hadoop.hdfs.RemoveDefaultAclResponseProto
	237, // 258: hadoop.hdfs.ClientNamenodeProtocol.removeAcl:output_type -> hadoop.hdfs.RemoveAclResponseProto
	238, // 259: hadoop.hdfs.ClientNamenodeProtocol.setAcl:output_type -> hadoop.hdfs.SetAclResponseProto
	239, // 260: hadoop.hdfs.ClientNamenodeProtocol.getAclStatus:output_type -> hadoop.hdfs.GetAclStatusResponseProto
	240, // 261: hadoop.hdfs.ClientNamenodeProtocol.setXAttr:output_type -> hadoop.hdfs.SetXAttrResponseProto
	241, // 262: hadoop.hdfs.ClientNamenodeProtocol.getXAttrs:output_type -> hadoop.hdfs.GetXAttrsResponseProto
	242, // 263: hadoop.hdfs.ClientNamenodeProtocol.listXAttrs:output_type -> hadoop.hdfs.ListXAttrsResponseProto
	243, // 264: hadoop.hdfs.ClientNamenodeProtocol.removeXAttr:output_type -> hadoop.hdfs.RemoveXAttrResponseProto
	163, // 265: hadoop.hdfs.ClientNamenodeProtocol.checkAccess:output_type -> hadoop.hdfs.CheckAccessResponseProto
	244, // 266: hadoop.hdfs.ClientNamenodeProtocol.createEncryptionZone:output_type -> hadoop.hdfs.CreateEncryptionZoneResponseProto
	245, // 267: hadoop.hdfs.ClientNamenodeProtocol.listEncryptionZones:output_type -> hadoop.hdfs.ListEncryptionZonesResponseProto
	246, // 268: hadoop.hdfs.ClientNamenodeProtocol.reencryptEncryptionZone:output_type -> hadoop.hdfs.ReencryptEncryptionZoneResponseProto
	247, // 269: hadoop.hdfs.ClientNamenodeProtocol.listReencryptionStatus:output_type -> hadoop.hdfs.ListReencryptionStatusResponseProto
	248, // 270: hadoop.hdfs.ClientNamenodeProtocol.getEZForPath:output_type -> hadoop.hdfs.GetEZForPathResponseProto
	249, // 271: hadoop.hdfs.ClientNamenodeProtocol.setErasureCodingPolicy:output_type -> hadoop.hdfs.SetErasureCodingPolicyResponseProto
	250, // 272: hadoop.hdfs.ClientNamenodeProtocol.unsetErasureCodingPolicy:output_type -> hadoop.hdfs.UnsetErasureCodingPolicyResponseProto
	251, // 273: hadoop.hdfs.ClientNamenodeProtocol.getECTopologyResultForPolicies:output_type -> hadoop.hdfs.GetECTopologyResultForPoliciesResponseProto
	165, // 274: hadoop.hdfs.ClientNamenodeProtocol.getCurrentEditLogTxid:output_type -> hadoop.hdfs.GetCurrentEditLogTxidResponseProto
	167, // 275: hadoop.hdfs.ClientNamenodeProtocol.getEditsFromTxid:output_type -> hadoop.hdfs.GetEditsFromTxidResponseProto
	252, // 276: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingPolicies:output_type -> hadoop.hdfs.GetErasureCodingPoliciesResponseProto
	253, // 277: hadoop.hdfs.ClientNamenodeProtocol.addErasureCodingPolicies:output_type -> hadoop.hdfs.AddErasureCodingPoliciesResponseProto
	254, // 278: hadoop.hdfs.ClientNamenodeProtocol.removeErasureCodingPolicy:output_type -> hadoop.hdfs.RemoveErasureCodingPolicyResponseProto
	255, // 279: hadoop.hdfs.ClientNamenodeProtocol.enableErasureCodingPolicy:output_type -> hadoop.hdfs.EnableErasureCodingPolicyResponseProto
	256, // 280: hadoop.hdfs.ClientNamenodeProtocol.disableErasureCodingPolicy:output_type -> hadoop.hdfs.DisableErasureCodingPolicyResponseProto
	257, // 281: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingPolicy:output_type -> hadoop.hdfs.GetErasureCodingPolicyResponseProto
	258, // 282: hadoop.hdfs.ClientNamenodeProtocol.getErasureCodingCodecs:output_type -> hadoop.hdfs.GetErasureCodingCodecsResponseProto
	133, // 283: hadoop.hdfs.ClientNamenodeProtocol.getQuotaUsage:output_type -> hadoop.hdfs.GetQuotaUsageResponseProto
	170, // 284: hadoop.hdfs.ClientNamenodeProtocol.listOpenFiles:output_type -> hadoop.hdfs.ListOpenFilesResponseProto
	172, // 285: hadoop.hdfs.ClientNamenodeProtocol.msync:output_type -> hadoop.hdfs.MsyncResponseProto
	174, // 286: hadoop.hdfs.ClientNamenodeProtocol.satisfyStoragePolicy:output_type -> hadoop.hdfs.SatisfyStoragePolicyResponseProto
	176, // 287: hadoop.hdfs.ClientNamenodeProtocol.getHAServiceState:output_type -> hadoop.hdfs.HAServiceStateResponseProto
	180, // [180:288] is the sub-list for method output_type
	72,  // [72:180] is the sub-list for method input_type
	72,  // [72:72] is the sub-list for extension type_name
	72,  // [72:72] is the sub-list for extension extendee
	0,   // [0:72] is the sub-list for field type_name
}

func init() { file_ClientNamenodeProtocol_proto_init() }
func file_ClientNamenodeProtocol_proto_init() {
	if File_ClientNamenodeProtocol_proto != nil {
		return
	}
	file_hdfs_proto_init()
	file_acl_proto_init()
	file_xattr_proto_init()
	file_encryption_proto_init()
	file_inotify_proto_init()
	file_erasurecoding_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ClientNamenodeProtocol_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBlockLocationsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBlockLocationsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServerDefaultsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServerDefaultsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetReplicationRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetReplicationResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetStoragePolicyRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetStoragePolicyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnsetStoragePolicyRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnsetStoragePolicyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoragePolicyRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoragePolicyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoragePoliciesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoragePoliciesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPermissionRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPermissionResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetOwnerRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetOwnerResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonBlockRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonBlockResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBlockRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBlockResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdditionalDatanodeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdditionalDatanodeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBadBlocksRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBadBlocksResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcatRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcatResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncateRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncateResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rename2RequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rename2ResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MkdirsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MkdirsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetListingRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetListingResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBatchedListingRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBatchedListingResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshottableDirListingRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshottableDirListingResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshotDiffReportRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshotDiffReportResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshotDiffReportListingRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshotDiffReportListingResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenewLeaseRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenewLeaseResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoverLeaseRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoverLeaseResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsStatusRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsStatsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsReplicatedBlockStatsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsReplicatedBlockStatsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsECBlockGroupStatsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFsECBlockGroupStatsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeReportRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeReportResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeStorageReportRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeStorageReportProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeStorageReportResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPreferredBlockSizeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPreferredBlockSizeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetSafeModeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetSafeModeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SaveNamespaceRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SaveNamespaceResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollEditsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollEditsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreFailedStorageRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreFailedStorageResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshNodesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshNodesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeUpgradeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeUpgradeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeStatusRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeStatusResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollingUpgradeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollingUpgradeInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollingUpgradeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorruptFileBlocksRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorruptFileBlocksResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetaSaveRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetaSaveResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFileInfoRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFileInfoResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLocatedFileInfoRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLocatedFileInfoResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsFileClosedRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsFileClosedResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CacheDirectiveInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CacheDirectiveInfoExpirationProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CacheDirectiveStatsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCacheDirectiveRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCacheDirectiveResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyCacheDirectiveRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyCacheDirectiveResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCacheDirectiveRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCacheDirectiveResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCacheDirectivesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CacheDirectiveEntryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCacheDirectivesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CachePoolInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CachePoolStatsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCachePoolRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCachePoolResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyCachePoolRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyCachePoolResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCachePoolRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCachePoolResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCachePoolsRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCachePoolsResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CachePoolEntryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFileLinkInfoRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFileLinkInfoResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetContentSummaryRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetContentSummaryResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetQuotaUsageRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetQuotaUsageResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[127].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetQuotaRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetQuotaResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FsyncRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FsyncResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetTimesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetTimesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSymlinkRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSymlinkResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLinkTargetRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLinkTargetResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBlockForPipelineRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBlockForPipelineResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePipelineRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[140].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePipelineResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[141].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBalancerBandwidthRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[142].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBalancerBandwidthResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[143].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataEncryptionKeyRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataEncryptionKeyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSnapshotRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSnapshotResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[147].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameSnapshotRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[148].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameSnapshotResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[149].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllowSnapshotRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[150].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllowSnapshotResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[151].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisallowSnapshotRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[152].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisallowSnapshotResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[153].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSnapshotRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[154].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSnapshotResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckAccessRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckAccessResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCurrentEditLogTxidRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCurrentEditLogTxidResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[159].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEditsFromTxidRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[160].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEditsFromTxidResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[161].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOpenFilesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[162].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenFilesBatchResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[163].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOpenFilesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MsyncRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[165].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MsyncResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[166].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SatisfyStoragePolicyRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[167].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SatisfyStoragePolicyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[168].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HAServiceStateRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientNamenodeProtocol_proto_msgTypes[169].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HAServiceStateResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ClientNamenodeProtocol_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   170,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ClientNamenodeProtocol_proto_goTypes,
		DependencyIndexes: file_ClientNamenodeProtocol_proto_depIdxs,
		EnumInfos:         file_ClientNamenodeProtocol_proto_enumTypes,
		MessageInfos:      file_ClientNamenodeProtocol_proto_msgTypes,
	}.Build()
	File_ClientNamenodeProtocol_proto = out.File
	file_ClientNamenodeProtocol_proto_rawDesc = nil
	file_ClientNamenodeProtocol_proto_goTypes = nil
	file_ClientNamenodeProtocol_proto_depIdxs = nil
}
