# Buildah version 1.4 Release Announcement

![buildah logo](https://buildah.io/images/buildah.png)

We're pleased to announce the release of Buildah version 1.4 which is now available from GitHub for any Linux distro.  We are shipping this release on Fedora, RHEL 7, CentOS, openSUSE and Ubuntu in the near future.

The Buildah project has continued to grow over the past several weeks, welcoming several new contributors to the mix.  The highlights of this release are fixes for "rootless" users, improvements in symbolic link and chroot handling in Dockerfiles, the addition of a `pull` command, better error messaging for OCI containers and several other enhancements and bug fixes.

## The major highlights for this release are:

* Issues with a rootless user cleaned up.
    - A variety of issues were cleaned up in this space.  They include:
        * Additional groups were not reset for a rootless user when creating a new user namespace.  For example users of the 'docker' group are now able to use the docker-daemon: destination.
        * Builtin volumes are now owned by the UID/GID of the container.
        * Removed the --no-pivot functionality as it could cause EPERM issues in a rootless user environment.

* Symbolic links handling for ADD and COPY

    If a symbolic link was used as part of an ADD or COPY command in a Dockerfile, the link itself and not the underlying file(s) were copied.  This has been corrected so that the files pointed to by the symbolic link are now copied.

* COPY --chown in a Dockerfile

    The COPY command with the --chown parameter in a Dockerfile is now processed correctly.

* The pull command has been created.

    The `buildah pull` command has been created.  It works like the `from` command however it only pulls the image and does not build a container like the `from` command does.

* Non-OCI command handling in a Dockerfile

    If a command that is not OCI compliant is encountered when building an OCI formatted container image, better error messages are now displayed.  If a non-OCI formatted container image is desired, the '--format=docker' option should be passed to the bud command.

* We've moved!

    The Buildah project has moved from projectatomic/buildah to containers/buildah in GitHub.com.  Come check out our new home!

* buildah.io website created!

    Not really tied to this release, but shortly before this release the buildah.io website was created.  There you can find blogs, release announcements, talks and more.  Go check it out if you haven't already!

## Release Changes

* Add the isolation option to the `from` command.
* Change SELinux MCS Label handling to avoid collisions with Podman.
* Fixed a number of issues with the `bud` --layers option.
* The `rmi --prune` option no longer accepts an ImageID .
* Additional groups are not reset for a rootless user when creating a new user namespace.
* Builtin volumes are now owned by the UID/GID of the container.
* Better error reporting for image-pulling errors with the `from` and `pull` commands.
* Allow an empty destination for the `push` command.  If empty, the source image parameter is reused for the destination.
* Missing parent directories for volume mounts.
* A number of commands have added verification to the flag ordering.
* Error messages have been cleaned up when options are misordered.
* Fixed a rare race condition in the `bud` command when pulling and naming the image.
* Symbolic links in ADD/COPY Dockerfile commands are handled correctly.
* The `push` command now shows the image digest after it succeeds.
* The `rename` command verifies that the container name is not already in use.
* The `containers` command no longer exits early when the --json option is used.
* Provide better errors when non-OCI commands are in a Dockerfile when building an OCI container image.
* After renaming a container, the correct name is now always shown in the `containers` command.
* A number of small changes were made to Buildah images building process to more closely match Docker images.
* Documented BUILDAH_* environment variables in `buildah bud --help` usage output.
* Using the ADD command in a Dockerfile is now handled correctly when the --layers option is used with the bud command.
* After deleting an image the correct image ID is now displayed.
* COPY --chown in a Dockerfile is processed correctly.
* The `run` command processing now bind mounts an empty directory for masking when using chroot.
* Removed --no-pivot for rootless isolation.
* Removed the stream option from the `bud` command.
* Added a `pull` command.
* Added a Docker conformance test suite.
* Documentation Changes:
    * Created a Container Tools Guide.
* Updated the following packages to newer versions:  CNI, containers/image, containers/storage, imagebuilder, libpod, runc, and urfave/cli.
* Plus a number of smaller fixes.

## Try it Out.

If you haven’t yet, install Buildah from one of the Linux repos or GitHub and give it a spin.  We’re betting you'll find it’s an easy and quick way to build containers in your environment without a daemon being involved!

For those of you who contributed to this release, thank you very much for your contributions!  If you haven't joined our community yet, don't wait any longer!  Come join us in GitHub, where Open Source communities live.

## Buildah == Simplicity
