// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

//go:build go1.10 && !go1.13

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "10.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 670 elements
	// Entry 0 - 1F
	0x00000001000ac130, 0x00010002f8000000, 0x0003f801080ac130, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80038286000, 0x002b080138289800,
	0x002c48001029d000, 0x002c68001829e000, 0x002c8801b829f800, 0x002e8000d82bb000,
	0x002f8000282c8800, 0x00300000e82cb000, 0x0030f007802d9800, 0x00387801e0351800,
	0x003a68032836f800, 0x003e0001d83a2000, 0x00400001703bf800, 0x00418000783d6800,
	0x00420000e03de000, 0x0042f000083ec000, 0x00430000583ec800, 0x00450000a83f2000,
	0x0045b000403fc800, 0x0046a00580400800, 0x004c280040458800, 0x004c78001045c800,
	// Entry 20 - 3F
	0x004c9800b045d800, 0x004d500038468800, 0x004d90000846c000, 0x004db0002046c800,
	0x004de0004846e800, 0x004e380010473000, 0x004e580020474000, 0x004eb80008476000,
	0x004ee00010476800, 0x004ef80028477800, 0x004f3000c047a000, 0x0050080018486000,
	0x0050280030487800, 0x005078001048a800, 0x00509800b048b800, 0x0051500038496800,
	0x005190001049a000, 0x0051a8001049b000, 0x0051c0001049c000, 0x0051e0000849d000,
	0x0051f0002849d800, 0x00523800104a0000, 0x00525800184a1000, 0x00528800084a2800,
	0x0052c800204a3000, 0x0052f000084a5000, 0x00533000804a5800, 0x00540800184ad800,
	0x00542800484af000, 0x00547800184b3800, 0x00549800404b5000, 0x0054d800704b9020,
	// Entry 40 - 5F
	0x00555000384c0020, 0x00559000104c3820, 0x0055a800284c4820, 0x0055e000504c7020,
	0x00563800184cc020, 0x00565800184cd820, 0x00568000084cf020, 0x00570000204cf820,
	0x00573000604d1820, 0x0057c800384d7820, 0x00580800184db020, 0x00582800404dc820,
	0x00587800104e0820, 0x00589800b04e1820, 0x00595000384ec820, 0x00599000104f0020,
	0x0059a800284f1020, 0x0059e000484f3820, 0x005a3800104f8020, 0x005a5800184f9020,
	0x005ab000104fa820, 0x005ae000104fb820, 0x005af800284fc820, 0x005b3000904ff020,
	0x005c100010508020, 0x005c280030509020, 0x005c70001850c020, 0x005c90002050d820,
	0x005cc8001050f820, 0x005ce00008510820, 0x005cf00010511020, 0x005d180010512020,
	// Entry 60 - 7F
	0x005d400018513020, 0x005d700060514820, 0x005df0002851a820, 0x005e30001851d020,
	0x005e50002051e820, 0x005e800008520820, 0x005eb80008521020, 0x005f3000a8521820,
	0x006000002052c020, 0x006028004052e020, 0x0060700018532020, 0x00609000b8533820,
	0x006150008053f020, 0x0061e80040547020, 0x006230001854b020, 0x006250002054c820,
	0x0062a8001054e820, 0x0062c0001854f820, 0x0063000020551020, 0x0063300050553020,
	0x0063c00060558020, 0x006428004055e020, 0x0064700018562020, 0x00649000b8563820,
	0x006550005056f020, 0x0065a80028574020, 0x0065e00048576820, 0x006630001857b020,
	0x006650002057c820, 0x0066a8001057e820, 0x0066f0000857f820, 0x0067000020580020,
	// Entry 80 - 9F
	0x0067300050582020, 0x0067880010587020, 0x0068000020588020, 0x006828004058a020,
	0x006870001858e020, 0x006890019858f820, 0x006a3000185a9020, 0x006a5000305aa820,
	0x006aa000805ad820, 0x006b3000d05b5820, 0x006c1000105c2820, 0x006c2800905c3820,
	0x006cd000c05cc820, 0x006d9800485d8820, 0x006de800085dd020, 0x006e0000385dd820,
	0x006e5000085e1020, 0x006e7800305e1820, 0x006eb000085e4820, 0x006ec000405e5020,
	0x006f3000505e9020, 0x006f9000185ee020, 0x00700801d05ef820, 0x0071f800e860c820,
	0x007408001061b020, 0x007420000861c020, 0x007438001061c820, 0x007450000861d820,
	0x007468000861e020, 0x0074a0002061e820, 0x0074c80038620820, 0x0075080018624020,
	// Entry A0 - BF
	0x0075280008625820, 0x0075380008626020, 0x0075500010626820, 0x0075680068627820,
	0x0075d8001862e020, 0x007600002862f820, 0x0076300008632020, 0x0076400030632820,
	0x0076800050635820, 0x0076e0002063a820, 0x007800024063c820, 0x007a480120660820,
	0x007b880138672820, 0x007cc80120686020, 0x007df00078698020, 0x007e70006869f820,
	0x00800006306a6020, 0x0086380008709020, 0x0086680008709820, 0x0086800bc870a020,
	0x00925000207c6820, 0x00928000387c8820, 0x0092c000087cc020, 0x0092d000207cc820,
	0x00930001487ce820, 0x00945000207e3020, 0x00948001087e5020, 0x00959000207f5820,
	0x0095c000387f7820, 0x00960000087fb020, 0x00961000207fb820, 0x00964000787fd820,
	// Entry C0 - DF
	0x0096c001c8805020, 0x0098900020821820, 0x0098c00218823820, 0x009ae80100845020,
	0x009c0000d0855020, 0x009d0002b0862020, 0x009fc0003088d020, 0x00a00014e8890020,
	0x00b50002c89de820, 0x00b8000068a0b020, 0x00b8700038a11820, 0x00b90000b8a15020,
	0x00ba0000a0a20820, 0x00bb000068a2a820, 0x00bb700018a31020, 0x00bb900010a32820,
	0x00bc000090a33820, 0x00bc900260a3c840, 0x00bf000050a62840, 0x00bf800050a67840,
	0x00c0000078a6c840, 0x00c0800050a74040, 0x00c10002c0a79040, 0x00c4000158aa5040,
	0x00c5800230aba840, 0x00c80000f8add840, 0x00c9000060aed040, 0x00c9800060af3040,
	0x00ca000008af9040, 0x00ca200150af9840, 0x00cb800028b0e840, 0x00cc000160b11040,
	// Entry E0 - FF
	0x00cd8000d0b27040, 0x00ce800058b34040, 0x00cef001f0b39840, 0x00d0f00208b58840,
	0x00d30000e8b79040, 0x00d3f80058b87840, 0x00d4800050b8d040, 0x00d5000070b92040,
	0x00d5800078b99040, 0x00d8000260ba0840, 0x00da800168bc6840, 0x00dc0003a0bdd040,
	0x00dfe001e0c17040, 0x00e1d80078c35040, 0x00e26801e0c3c840, 0x00e6000040c5a840,
	0x00e6800150c5e840, 0x00e80007d0c73840, 0x00efd808d8cf0840, 0x00f8c00030d7e040,
	0x00f9000130d81040, 0x00fa400030d94040, 0x00fa800040d97040, 0x00fac80008d9b040,
	0x00fad80008d9b840, 0x00fae80008d9c040, 0x00faf800f8d9c840, 0x00fc0001a8dac040,
	0x00fdb00078dc6840, 0x00fe300070dce040, 0x00feb00030dd5040, 0x00fee80098dd8040,
	// Entry 100 - 11F
	0x00ff900018de1840, 0x00ffb00048de3040, 0x0100000328de7840, 0x0103300060e1a040,
	0x0103a000d8e20040, 0x0104800068e2d840, 0x0105000100e34040, 0x0106800108e44040,
	0x0108000460e54840, 0x010c8003b0e9a840, 0x0110301108ed5860, 0x0122000058fe6060,
	0x01230038a0feb860, 0x015bb00101375860, 0x015cc000c1385860, 0x015d800051391880,
	0x015de80061396880, 0x015e50004939c880, 0x015f6000213a1080, 0x01600001793a3080,
	0x01618001793ba880, 0x01630004a13d2080, 0x0167c8016941c080, 0x0169380009432880,
	0x0169680009433080, 0x01698001c1433880, 0x016b78001144f880, 0x016bf800c1450880,
	0x016d00003945c880, 0x016d400039460080, 0x016d800039463880, 0x016dc00039467080,
	// Entry 120 - 13F
	0x016e00003946a880, 0x016e40003946e080, 0x016e800039471880, 0x016ec00039475080,
	0x016f000351478880, 0x01740000d14ad880, 0x0174d802c94ba880, 0x01780006b14e7080,
	0x017f800061552080, 0x0180000201558080, 0x01820802b1578080, 0x0184c803395a3080,
	0x01882801515d6880, 0x01898802f15eb880, 0x018c80015961a880, 0x018e000121630080,
	0x018f800179642080, 0x01910006f9659880, 0x01980008016c9080, 0x01a000cdb0000370,
	0x026e000201749080, 0x0270028f580511f0, 0x0500002469769080, 0x05248001b99af880,
	0x05268002519cb080, 0x0528d008919f00a0, 0x05320005c1a790a0, 0x0538000579ad50a0,
	0x053d800041b2c8a0, 0x053fb801a9b308a0, 0x0541800051b4b0a0, 0x05420001c1b500a0,
	// Entry 140 - 15F
	0x0544000231b6c0a0, 0x0546700061b8f0a0, 0x05470000f1b950a0, 0x05480002a1ba40a0,
	0x054af800f1bce0a0, 0x054c000271bdd0a0, 0x054e780059c040a0, 0x054ef00109c098a0,
	0x05500001b9c1a0a0, 0x0552000071c358a0, 0x0552800051c3c8a0, 0x0552e00339c418a0,
	0x0556d800e1c750a0, 0x0558080031c830a0, 0x0558480031c860a0, 0x0558880031c890a0,
	0x0559000039c8c0a0, 0x0559400039c8f8a0, 0x05598001b1c930a0, 0x055b8003f1cae0a0,
	0x055f800051ced0a0, 0x0560015d20058a30, 0x06bd8000b9cf20a0, 0x06be580189cfd8a0,
	0x06c0001c00068c10, 0x06dc00040008eb90, 0x06e00020000611f0, 0x070000c80009c9b0,
	0x07c8000b71d160a0, 0x07d3800351dcd0a0, 0x07d8000039e020a0, 0x07d8980029e058a0,
	// Entry 160 - 17F
	0x07d8e800d1e080a0, 0x07d9c00029e150a0, 0x07d9f00009e178a0, 0x07da000011e180a0,
	0x07da180011e190a0, 0x07da3003e1e1a0a0, 0x07de9804f1e580a0, 0x07e3880679ea70c0,
	0x07ea800201f0e8c0, 0x07ec9001b1f2e8c0, 0x07ef800071f498c0, 0x07f00000d1f508c0,
	0x07f1000199f5d8c0, 0x07f2a00099f770c0, 0x07f3400021f808c0, 0x07f3800029f828c0,
	0x07f3b00439f850c0, 0x07f7f80009fc88c0, 0x07f80805f1fc90c0, 0x07fe1000320280c0,
	0x07fe50003202b0c0, 0x07fe90003202e0c0, 0x07fed0001a0310c0, 0x07ff00003a0328c0,
	0x07ff40003a0360c0, 0x07ffc8002a0398c0, 0x080000006203c0c0, 0x08006800d20420c0,
	0x080140009a04f0c0, 0x0801e000120588c0, 0x0801f8007a0598c0, 0x08028000720610c0,
	// Entry 180 - 19F
	0x08040003da0680c0, 0x080800001a0a58c0, 0x080838016a0a70c0, 0x0809b802c20bd8c0,
	0x080c8000620e98c0, 0x080d00000a0ef8c0, 0x080e8001720f00c0, 0x08140000ea1070c0,
	0x081500018a1158c0, 0x08170000e212e0c0, 0x081800012213c0c0, 0x08196800f214e0c0,
	0x081a80015a15d0c0, 0x081c0000f21728c0, 0x081cf8012a1818c0, 0x081e4000721940c0,
	0x08200004f219b0c0, 0x08250000521ea0c0, 0x08258001221ef0c0, 0x0826c001222010c0,
	0x08280001422130c0, 0x08298001a22270c0, 0x082b78000a2410c0, 0x08300009ba2418c0,
	0x083a0000b22dd0c0, 0x083b0000422e80c0, 0x08400000322ec0c0, 0x084040000a2ef0c0,
	0x08405001622ef8c0, 0x0841b800123058c0, 0x0841e0000a3068c0, 0x0841f800ba3070c0,
	// Entry 1A0 - 1BF
	0x0842b802423128c0, 0x084538004a3368c0, 0x084700009a33b0c0, 0x0847a000123448c0,
	0x0847d8010a3458c0, 0x0848f800da3560c0, 0x0849f8000a3638c0, 0x084c00004a3640c0,
	0x084c48017a3688e0, 0x084de000a23800e0, 0x084e90019238a0e0, 0x08502800123a30e0,
	0x08506000423a40e0, 0x0850a8001a3a80e0, 0x0850c800da3a98e0, 0x0851c0001a3b70e0,
	0x0851f8004a3b88e0, 0x085280004a3bd0e0, 0x08530002023c18e0, 0x085600013a3e18e0,
	0x08575800623f50e0, 0x08580001b23fb0e0, 0x0859c800ea4160e0, 0x085ac000da4248e0,
	0x085bc000d24320e0, 0x085cc8002243f0e0, 0x085d48003a4410e0, 0x086000024a4448e0,
	0x086400019a4690e0, 0x086600019a4828e0, 0x0867d0003249c0e0, 0x08730000fa49f0e0,
	// Entry 1C0 - 1DF
	0x08800002724ae8e0, 0x08829000f24d58e0, 0x0883f8021a4e48e0, 0x08868000ca5060e0,
	0x08878000525128e0, 0x08880001aa5178e0, 0x0889b000725320e0, 0x088a80013a5390e0,
	0x088c00027254c8e0, 0x088e8000825738e0, 0x088f0800a257b8e0, 0x08900000925858e0,
	0x089098016258e8e0, 0x089400003a5a48e0, 0x089440000a5a80e0, 0x08945000225a88e0,
	0x089478007a5aa8e0, 0x0894f8005a5b20e0, 0x08958001da5b78e0, 0x08978000525d50e0,
	0x08980000225da0e0, 0x08982800425dc0e0, 0x08987800125e00e0, 0x08989800b25e10e0,
	0x089950003a5ec0e0, 0x08999000125ef8e0, 0x0899a8002a5f08e0, 0x0899e0004a5f30e0,
	0x089a3800125f78e0, 0x089a58001a5f88e0, 0x089a80000a5fa0e0, 0x089ab8000a5fa8e0,
	// Entry 1E0 - 1FF
	0x089ae8003a5fb0e0, 0x089b30003a5fe8e0, 0x089b80002a6020e0, 0x08a00002d26048e0,
	0x08a2d8000a6318e0, 0x08a2e8000a6320e0, 0x08a40002426328e0, 0x08a68000526568e0,
	0x08ac0001b265b8e0, 0x08adc001326768e0, 0x08b000022a6898e0, 0x08b28000526ac0e0,
	0x08b300006a6b10e0, 0x08b40001c26b78e0, 0x08b60000526d38e0, 0x08b80000d26d88e0,
	0x08b8e8007a6e58e0, 0x08b98000826ed0e0, 0x08c500029a6f50e0, 0x08c7f8000a71e8e0,
	0x08d000024271f0e0, 0x08d28001a27430e0, 0x08d43000ba75d0e0, 0x08d4f0002a7688e0,
	0x08d60001ca76b0e0, 0x08e000004a7878e0, 0x08e050016a78c0e0, 0x08e1c000727a28e0,
	0x08e28000ea7a98e0, 0x08e38001027b80e0, 0x08e49000b27c80e0, 0x08e54800727d30e0,
	// Entry 200 - 21F
	0x08e800003a7da0e0, 0x08e84000127dd8e0, 0x08e85801627de8e0, 0x08e9d0000a7f48e0,
	0x08e9e000127f50e0, 0x08e9f8004a7f60e0, 0x08ea8000527fa8e0, 0x0900000de27ff8e0,
	0x090de00ef28dd900, 0x092000037a9cc900, 0x092380002aa04100, 0x0924000622a06900,
	0x098000217aa68900, 0x0a2000123ac80100, 0x0b400001e2da3900, 0x0b41e00feadc1920,
	0x0b520000faec0120, 0x0b53000052ecf920, 0x0b53700012ed4920, 0x0b568000f2ed5920,
	0x0b57800032ee4920, 0x0b58000232ee7920, 0x0b5a800052f0a920, 0x0b5ad8003af0f920,
	0x0b5b1800aaf13120, 0x0b5be8009af1d920, 0x0b7800022af27120, 0x0b7a80017af49920,
	0x0b7c78008af61120, 0x0b7f000012f69920, 0x0b8000bf680a3250, 0x0c4000179af6a920,
	// Entry 220 - 23F
	0x0d800008fb0e4120, 0x0d8b800c63173920, 0x0de000035b239920, 0x0de380006b26f120,
	0x0de400004b275920, 0x0de480005327a120, 0x0de4e0004327f120, 0x0e800007b3283120,
	0x0e8800013b2fe120, 0x0e8948015b311920, 0x0e8aa004ab327140, 0x0e90000233371940,
	0x0e980002bb394940, 0x0e9b0000933c0140, 0x0ea00002ab3c9140, 0x0ea2b0023b3f3940,
	0x0ea4f00013417140, 0x0ea510000b418140, 0x0ea5280013418940, 0x0ea5480023419940,
	0x0ea570006341b940, 0x0ea5d8000b421940, 0x0ea5e8003b422140, 0x0ea628020b425940,
	0x0ea8380023446140, 0x0ea8680043448140, 0x0ea8b0003b44c140, 0x0ea8f000e344f940,
	0x0ea9d8002345d940, 0x0eaa00002b45f940, 0x0eaa30000b462140, 0x0eaa50003b462940,
	// Entry 240 - 25F
	0x0eaa900aa3466140, 0x0eb5400923510140, 0x0ebe7010f35a2140, 0x0ecf6005036b1160,
	0x0ed4d8002b701160, 0x0ed508007b703960, 0x0f0000003b70b160, 0x0f0040008b70e960,
	0x0f00d8003b717160, 0x0f0118001371a960, 0x0f0130002b71b960, 0x0f4000062b71e160,
	0x0f46380083780960, 0x0f4800025b788960, 0x0f4a8000537ae160, 0x0f4af000137b3160,
	0x0f700000237b4160, 0x0f702800db7b6160, 0x0f710800137c3960, 0x0f7120000b7c4960,
	0x0f7138000b7c5160, 0x0f714800537c5960, 0x0f71a000237ca960, 0x0f71c8000b7cc960,
	0x0f71d8000b7cd160, 0x0f7210000b7cd960, 0x0f7238000b7ce160, 0x0f7248000b7ce960,
	0x0f7258000b7cf160, 0x0f7268001b7cf960, 0x0f728800137d1160, 0x0f72a0000b7d2160,
	// Entry 260 - 27F
	0x0f72b8000b7d2960, 0x0f72c8000b7d3160, 0x0f72d8000b7d3960, 0x0f72e8000b7d4160,
	0x0f72f8000b7d4960, 0x0f730800137d5160, 0x0f7320000b7d6160, 0x0f733800237d6960,
	0x0f7360003b7d8960, 0x0f73a000237dc160, 0x0f73c800237de160, 0x0f73f0000b7e0160,
	0x0f740000537e0960, 0x0f7458008b7e5960, 0x0f7508001b7ee160, 0x0f7528002b7ef960,
	0x0f7558008b7f2160, 0x0f778000137fa960, 0x0f800001637fb960, 0x0f81800323811960,
	0x0f8500007b843960, 0x0f8588007b84b160, 0x0f8608007b852960, 0x0f8688012b85a160,
	0x0f8800006b86c960, 0x0f888000fb873160, 0x0f898001e3882960, 0x0f8b8001eb8a0960,
	0x0f8f3000eb8bf160, 0x0f908001638cd960, 0x0f9200004b8e3960, 0x0f928000138e8160,
	// Entry 280 - 29F
	0x0f930000338e9160, 0x0f98001eab8ec160, 0x0fb700006bad6960, 0x0fb780004badd160,
	0x0fb80003a3ae1960, 0x0fbc0002abb1b960, 0x0fc0000063b46160, 0x0fc08001c3b4c160,
	0x0fc2800053b68160, 0x0fc3000143b6d160, 0x0fc48000f3b81160, 0x0fc8000063b90160,
	0x0fc880017bb96160, 0x0fca00006bbad960, 0x0fca8000e3bb4160, 0x0fcc0000c3bc2160,
	0x0fce00000bbce160, 0x0fce8000bbbce960, 0x10000536b800db70, 0x15380081a801b370,
	0x15ba0006f0028b70, 0x15c100b410036370, 0x167580e988043b70, 0x17c0000193bda160,
	0x17c1900f63bf3180, 0x700008000bce9180, 0x7001000303ce9980, 0x7008000783d19980,
	0x780007fff0078ad0, 0x800007fff0083ad0,
} // Size: 5384 bytes

var index = []uint16{ // 31524 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x9693, 0x96ac, 0x96c5, 0x96dd,
	0x96f6, 0x970e, 0x9726, 0x973e, 0x9756, 0x976f, 0x9788, 0x97a2,
	0x97bb, 0x97d3, 0x97ec, 0x9804, 0x981c, 0x9836, 0x9850, 0x9869,
	0x9881, 0x989a, 0x98b3, 0x98cb, 0x98e4, 0x98fd, 0x9917, 0x992f,
	0x9948, 0x9961, 0x997b, 0x9994, 0x99ac, 0x99c6, 0x99e0, 0x99f9,
	0x9a11, 0x9a2a, 0x9a4a, 0x9a5c, 0x9a6b, 0x9a8e, 0x9ab0, 0x9ac2,
	// Entry 540 - 57F
	0x9ad7, 0x9aea, 0x9b02, 0x9b1b, 0x9b34, 0x9b48, 0x9b5b, 0x9b6e,
	0x9b82, 0x9b95, 0x9ba8, 0x9bbc, 0x9bd7, 0x9bee, 0x9c07, 0x9c23,
	0x9c36, 0x9c50, 0x9c63, 0x9c79, 0x9c8d, 0x9ca8, 0x9cbb, 0x9cce,
	0x9cea, 0x9d06, 0x9d17, 0x9d29, 0x9d3b, 0x9d4e, 0x9d67, 0x9d79,
	0x9d91, 0x9da9, 0x9dc2, 0x9dd4, 0x9de6, 0x9df8, 0x9e0a, 0x9e1d,
	0x9e2f, 0x9e4f, 0x9e62, 0x9e7e, 0x9e90, 0x9ea8, 0x9eb9, 0x9ed1,
	0x9ee6, 0x9efa, 0x9f16, 0x9f2b, 0x9f40, 0x9f5e, 0x9f77, 0x9f89,
	0x9f9a, 0x9fad, 0x9fc0, 0x9fd0, 0x9fe1, 0x9ff4, 0xa005, 0xa016,
	// Entry 580 - 5BF
	0xa027, 0xa03e, 0xa04f, 0xa062, 0xa079, 0xa08a, 0xa0a1, 0xa0b2,
	0xa0c6, 0xa0d8, 0xa0ee, 0xa0fe, 0xa117, 0xa12a, 0xa13b, 0xa14d,
	0xa15f, 0xa170, 0xa192, 0xa1b1, 0xa1d3, 0xa1ec, 0xa208, 0xa21a,
	0xa22b, 0xa241, 0xa252, 0xa264, 0xa27c, 0xa292, 0xa2aa, 0xa2b4,
	0xa2cf, 0xa2f1, 0xa2fd, 0xa309, 0xa31e, 0xa336, 0xa347, 0xa36f,
	0xa38a, 0xa3a8, 0xa3c5, 0xa3da, 0xa3ef, 0xa420, 0xa436, 0xa448,
	0xa45a, 0xa46c, 0xa47c, 0xa48e, 0xa4b0, 0xa4c4, 0xa4de, 0xa4f1,
	0xa514, 0xa537, 0xa559, 0xa57c, 0xa59e, 0xa5b0, 0xa5c1, 0xa5da,
	// Entry 5C0 - 5FF
	0xa5eb, 0xa5fd, 0xa60f, 0xa620, 0xa632, 0xa643, 0xa655, 0xa666,
	0xa678, 0xa68a, 0xa69d, 0xa6ae, 0xa6bf, 0xa6d0, 0xa6e1, 0xa6f2,
	0xa705, 0xa72c, 0xa755, 0xa77c, 0xa7a7, 0xa7d4, 0xa7e2, 0xa7f3,
	0xa804, 0xa815, 0xa826, 0xa838, 0xa84a, 0xa85b, 0xa86c, 0xa886,
	0xa897, 0xa8a6, 0xa8b5, 0xa8c4, 0xa8d0, 0xa8dc, 0xa8e8, 0xa8f5,
	0xa901, 0xa914, 0xa926, 0xa938, 0xa94d, 0xa962, 0xa979, 0xa988,
	0xa9a7, 0xa9cf, 0xa9ea, 0xa9ff, 0xaa19, 0xaa30, 0xaa47, 0xaa5d,
	0xaa73, 0xaa8b, 0xaaa2, 0xaab9, 0xaacf, 0xaae7, 0xaaff, 0xab16,
	// Entry 600 - 63F
	0xab29, 0xab41, 0xab5b, 0xab73, 0xab8c, 0xaba5, 0xabc3, 0xabdb,
	0xac03, 0xac2b, 0xac43, 0xac60, 0xac7c, 0xac9c, 0xacb8, 0xacca,
	0xacde, 0xacf0, 0xad0b, 0xad3c, 0xad4d, 0xad60, 0xad73, 0xad95,
	0xadc3, 0xadd5, 0xade7, 0xae0e, 0xae21, 0xae36, 0xae48, 0xae63,
	0xae83, 0xaeb1, 0xaec4, 0xaed8, 0xaee9, 0xaf1a, 0xaf40, 0xaf52,
	0xaf70, 0xaf8b, 0xafab, 0xafcf, 0xaffd, 0xb022, 0xb033, 0xb059,
	0xb088, 0xb0b0, 0xb0ed, 0xb112, 0xb139, 0xb160, 0xb187, 0xb1a0,
	0xb1c6, 0xb1e6, 0xb1f7, 0xb21e, 0xb231, 0xb251, 0xb278, 0xb28b,
	// Entry 640 - 67F
	0xb2a2, 0xb2bd, 0xb2dd, 0xb2ed, 0xb314, 0xb325, 0xb340, 0xb353,
	0xb378, 0xb38a, 0xb3b1, 0xb3cf, 0xb3ef, 0xb416, 0xb43d, 0xb45e,
	0xb477, 0xb48a, 0xb4a6, 0xb4ce, 0xb4eb, 0xb50d, 0xb52d, 0xb543,
	0xb56a, 0xb588, 0xb5a3, 0xb5bb, 0xb5cb, 0xb5da, 0xb5ea, 0xb602,
	0xb627, 0xb637, 0xb64e, 0xb669, 0xb687, 0xb6a7, 0xb6b6, 0xb6dd,
	0xb6f5, 0xb71e, 0xb72e, 0xb73e, 0xb777, 0xb7b0, 0xb7d3, 0xb7ed,
	0xb803, 0xb81f, 0xb835, 0xb847, 0xb862, 0xb880, 0xb8aa, 0xb8d0,
	0xb8f4, 0xb909, 0xb920, 0xb930, 0xb940, 0xb955, 0xb96b, 0xb981,
	// Entry 680 - 6BF
	0xb99d, 0xb9ba, 0xb9e5, 0xb9fa, 0xba1b, 0xba3c, 0xba5c, 0xba7b,
	0xba9a, 0xbabb, 0xbadb, 0xbafb, 0xbb1a, 0xbb3b, 0xbb5c, 0xbb7c,
	0xbb9e, 0xbbbe, 0xbbe0, 0xbbfc, 0xbc1f, 0xbc40, 0xbc57, 0xbc73,
	0xbc8d, 0xbca5, 0xbcbb, 0xbcd2, 0xbcea, 0xbd03, 0xbd27, 0xbd4a,
	0xbd5c, 0xbd72, 0xbd8b, 0xbda5, 0xbdbd, 0xbdd0, 0xbdef, 0xbe01,
	0xbe14, 0xbe30, 0xbe44, 0xbe65, 0xbe75, 0xbe86, 0xbe98, 0xbeaa,
	0xbebc, 0xbed7, 0xbee9, 0xbefe, 0xbf10, 0xbf24, 0xbf35, 0xbf46,
	0xbf5b, 0xbf76, 0xbf85, 0xbf95, 0xbfae, 0xbfc1, 0xbfd3, 0xbfe5,
	// Entry 6C0 - 6FF
	0xbff7, 0xc008, 0xc023, 0xc03f, 0xc05c, 0xc06f, 0xc082, 0xc096,
	0xc0a9, 0xc0bc, 0xc0d0, 0xc0e2, 0xc0f4, 0xc112, 0xc12d, 0xc13f,
	0xc151, 0xc16a, 0xc17c, 0xc18e, 0xc19a, 0xc1ad, 0xc1bd, 0xc1cc,
	0xc1ea, 0xc208, 0xc21f, 0xc236, 0xc24f, 0xc268, 0xc274, 0xc282,
	0xc29d, 0xc2b8, 0xc2d0, 0xc304, 0xc339, 0xc371, 0xc3bc, 0xc3ef,
	0xc41c, 0xc43a, 0xc45f, 0xc497, 0xc4d5, 0xc502, 0xc51f, 0xc546,
	0xc56b, 0xc5a5, 0xc5d5, 0xc5fa, 0xc632, 0xc654, 0xc67d, 0xc6b7,
	0xc6d8, 0xc6f9, 0xc71f, 0xc740, 0xc75f, 0xc779, 0xc7a9, 0xc7cb,
	// Entry 700 - 73F
	0xc7fc, 0xc830, 0xc86b, 0xc8a7, 0xc8e2, 0xc916, 0xc953, 0xc992,
	0xc9d4, 0xca18, 0xca5b, 0xca97, 0xcad5, 0xcb18, 0xcb5d, 0xcb9a,
	0xcbd8, 0xcbfa, 0xcc1f, 0xcc30, 0xcc47, 0xcc5a, 0xcc6b, 0xcc7c,
	0xcc93, 0xcca6, 0xccb9, 0xcccc, 0xccdf, 0xccf2, 0xcd06, 0xcd18,
	0xcd2b, 0xcd3e, 0xcd55, 0xcd68, 0xcd7e, 0xcd94, 0xcdaa, 0xcdbb,
	0xcdd1, 0xcde7, 0xcdfe, 0xce10, 0xce22, 0xce34, 0xce48, 0xce59,
	0xce6d, 0xce81, 0xce95, 0xcea5, 0xceb5, 0xcec7, 0xcedb, 0xceee,
	0xcf01, 0xcf0f, 0xcf1f, 0xcf2d, 0xcf3d, 0xcf4b, 0xcf5b, 0xcf69,
	// Entry 740 - 77F
	0xcf79, 0xcf87, 0xcf97, 0xcfa3, 0xcfb4, 0xcfc2, 0xcfcf, 0xcfdc,
	0xcfeb, 0xcff9, 0xd007, 0xd014, 0xd023, 0xd032, 0xd040, 0xd04c,
	0xd059, 0xd065, 0xd071, 0xd07d, 0xd08a, 0xd096, 0xd0ab, 0xd0b7,
	0xd0c4, 0xd0d1, 0xd0de, 0xd0eb, 0xd0f9, 0xd106, 0xd113, 0xd121,
	0xd12e, 0xd13c, 0xd149, 0xd156, 0xd163, 0xd177, 0xd184, 0xd192,
	0xd19f, 0xd1ac, 0xd1b9, 0xd1c6, 0xd1db, 0xd1ed, 0xd200, 0xd212,
	0xd22f, 0xd24b, 0xd26a, 0xd28c, 0xd2a8, 0xd2c3, 0xd2e1, 0xd300,
	0xd31e, 0xd336, 0xd34d, 0xd361, 0xd376, 0xd37f, 0xd393, 0xd3a1,
	// Entry 780 - 7BF
	0xd3b6, 0xd3ca, 0xd3e0, 0xd3f6, 0xd409, 0xd41d, 0xd431, 0xd444,
	0xd458, 0xd46c, 0xd481, 0xd497, 0xd4ab, 0xd4bf, 0xd4d7, 0xd4ea,
	0xd4fd, 0xd515, 0xd529, 0xd53e, 0xd553, 0xd568, 0xd579, 0xd58f,
	0xd5a7, 0xd5bc, 0xd5e4, 0xd601, 0xd61c, 0xd632, 0xd652, 0xd66e,
	0xd685, 0xd6a4, 0xd6bf, 0xd6d5, 0xd6f6, 0xd712, 0xd72d, 0xd743,
	0xd75e, 0xd779, 0xd78f, 0xd7a5, 0xd7bf, 0xd7d5, 0xd7f2, 0xd80e,
	0xd829, 0xd842, 0xd85e, 0xd87e, 0xd899, 0xd8bc, 0xd8d7, 0xd8f2,
	0xd90c, 0xd926, 0xd943, 0xd965, 0xd981, 0xd995, 0xd9a6, 0xd9b7,
	// Entry 7C0 - 7FF
	0xd9c8, 0xd9d9, 0xd9ef, 0xda00, 0xda11, 0xda23, 0xda36, 0xda47,
	0xda58, 0xda69, 0xda7a, 0xda8b, 0xda9c, 0xdaad, 0xdabf, 0xdad0,
	0xdae1, 0xdaf3, 0xdb04, 0xdb1b, 0xdb2d, 0xdb3f, 0xdb57, 0xdb70,
	0xdb87, 0xdb9a, 0xdbb5, 0xdbcf, 0xdbea, 0xdc05, 0xdc20, 0xdc3c,
	0xdc57, 0xdc71, 0xdc8c, 0xdca8, 0xdcc3, 0xdce7, 0xdd09, 0xdd2f,
	0xdd54, 0xdd89, 0xdda9, 0xddca, 0xddf2, 0xde27, 0xde5a, 0xde75,
	0xde96, 0xdeb0, 0xdec6, 0xdeed, 0xdf14, 0xdf3a, 0xdf54, 0xdf7c,
	0xdfa3, 0xdfc3, 0xdfea, 0xe011, 0xe037, 0xe05e, 0xe098, 0xe0b1,
	// Entry 800 - 83F
	0xe0ca, 0xe0e4, 0xe101, 0xe116, 0xe12b, 0xe140, 0xe161, 0xe181,
	0xe1a4, 0xe1c3, 0xe1e1, 0xe1fd, 0xe217, 0xe233, 0xe254, 0xe270,
	0xe28b, 0xe2a4, 0xe2b6, 0xe2c8, 0xe2da, 0xe2ef, 0xe304, 0xe319,
	0xe332, 0xe34c, 0xe362, 0xe37b, 0xe395, 0xe3ab, 0xe3bf, 0xe3d3,
	0xe3e7, 0xe3fc, 0xe412, 0xe42d, 0xe448, 0xe463, 0xe47f, 0xe49a,
	0xe4b6, 0xe4d9, 0xe505, 0xe52a, 0xe53f, 0xe55f, 0xe583, 0xe59e,
	0xe5b6, 0xe5cd, 0xe5e6, 0xe5f9, 0xe60d, 0xe620, 0xe634, 0xe647,
	0xe65b, 0xe676, 0xe691, 0xe6ab, 0xe6c4, 0xe6d7, 0xe6eb, 0xe705,
	// Entry 840 - 87F
	0xe71e, 0xe731, 0xe745, 0xe759, 0xe76e, 0xe782, 0xe797, 0xe7ac,
	0xe7c0, 0xe7d5, 0xe7e9, 0xe7fe, 0xe813, 0xe828, 0xe83e, 0xe853,
	0xe869, 0xe87e, 0xe892, 0xe8a7, 0xe8bb, 0xe8d0, 0xe8e4, 0xe8fa,
	0xe90e, 0xe923, 0xe937, 0xe94c, 0xe960, 0xe974, 0xe988, 0xe99d,
	0xe9b1, 0xe9c6, 0xe9dc, 0xe9f0, 0xea05, 0xea1a, 0xea2e, 0xea42,
	0xea5a, 0xea73, 0xea88, 0xeaa0, 0xeab8, 0xeacf, 0xeae7, 0xeafe,
	0xeb16, 0xeb35, 0xeb55, 0xeb73, 0xeb90, 0xeba7, 0xebbf, 0xebdd,
	0xebfa, 0xec11, 0xec29, 0xec3f, 0xec64, 0xec7c, 0xec89, 0xeca6,
	// Entry 880 - 8BF
	0xecc5, 0xecdc, 0xecf3, 0xed16, 0xed2e, 0xed47, 0xed5b, 0xed71,
	0xed87, 0xed9b, 0xedb2, 0xedc7, 0xeddb, 0xedf0, 0xee0c, 0xee28,
	0xee47, 0xee67, 0xee77, 0xee8e, 0xeea3, 0xeeb7, 0xeecb, 0xeee1,
	0xeef6, 0xef0b, 0xef1f, 0xef35, 0xef4b, 0xef60, 0xef7c, 0xef9c,
	0xefb6, 0xefca, 0xefdf, 0xeff3, 0xf007, 0xf01c, 0xf039, 0xf04e,
	0xf068, 0xf07d, 0xf092, 0xf0b0, 0xf0c6, 0xf0db, 0xf0e7, 0xf0ff,
	0xf114, 0xf128, 0xf138, 0xf149, 0xf159, 0xf16a, 0xf17a, 0xf18b,
	0xf1a3, 0xf1bb, 0xf1cb, 0xf1dc, 0xf1ec, 0xf1fd, 0xf20e, 0xf220,
	// Entry 8C0 - 8FF
	0xf231, 0xf243, 0xf255, 0xf266, 0xf278, 0xf289, 0xf29b, 0xf2ad,
	0xf2bf, 0xf2d2, 0xf2e4, 0xf2f7, 0xf309, 0xf31a, 0xf32c, 0xf33d,
	0xf34f, 0xf360, 0xf371, 0xf383, 0xf394, 0xf3a6, 0xf3b7, 0xf3c8,
	0xf3d9, 0xf3ea, 0xf3fc, 0xf40e, 0xf41f, 0xf430, 0xf442, 0xf457,
	0xf46c, 0xf480, 0xf495, 0xf4a9, 0xf4be, 0xf4da, 0xf4f7, 0xf50b,
	0xf520, 0xf534, 0xf549, 0xf55c, 0xf574, 0xf58a, 0xf59c, 0xf5ae,
	0xf5c0, 0xf5d9, 0xf5f2, 0xf60e, 0xf62b, 0xf63d, 0xf64e, 0xf65f,
	0xf672, 0xf684, 0xf696, 0xf6a7, 0xf6ba, 0xf6cd, 0xf6df, 0xf705,
	// Entry 900 - 93F
	0xf72a, 0xf73c, 0xf74e, 0xf76c, 0xf78a, 0xf7aa, 0xf7c9, 0xf801,
	0xf825, 0xf833, 0xf845, 0xf862, 0xf87b, 0xf893, 0xf8a6, 0xf8bb,
	0xf8cc, 0xf8de, 0xf8ef, 0xf901, 0xf912, 0xf924, 0xf936, 0xf948,
	0xf95a, 0xf96c, 0xf97e, 0xf991, 0xf9a3, 0xf9b6, 0xf9c9, 0xf9db,
	0xf9ee, 0xfa00, 0xfa13, 0xfa26, 0xfa39, 0xfa4d, 0xfa60, 0xfa74,
	0xfa87, 0xfa99, 0xfaac, 0xfabe, 0xfad1, 0xfae3, 0xfaf5, 0xfb08,
	0xfb1a, 0xfb2d, 0xfb3f, 0xfb51, 0xfb63, 0xfb75, 0xfb88, 0xfb9a,
	0xfbad, 0xfbbf, 0xfbd1, 0xfbe4, 0xfbfa, 0xfc0f, 0xfc25, 0xfc3a,
	// Entry 940 - 97F
	0xfc50, 0xfc66, 0xfc7c, 0xfc92, 0xfca8, 0xfcbc, 0xfccf, 0xfce3,
	0xfcf7, 0xfd09, 0xfd1c, 0xfd2e, 0xfd41, 0xfd53, 0xfd65, 0xfd79,
	0xfd8c, 0xfd9f, 0xfdb1, 0xfdc5, 0xfdd9, 0xfdec, 0xfdfa, 0xfe08,
	0xfe14, 0xfe20, 0xfe31, 0xfe45, 0xfe5e, 0xfe74, 0xfe89, 0xfe9a,
	0xfeac, 0xfebd, 0xfecf, 0xfee0, 0xfef2, 0xff0b, 0xff24, 0xff3b,
	0xff4c, 0xff5e, 0xff75, 0xff86, 0xff98, 0xffaa, 0xffbd, 0xffcf,
	0xffe2, 0xfff5, 0x0007, 0x001a, 0x002c, 0x003f, 0x0052, 0x0065,
	0x0079, 0x008c, 0x00a0, 0x00b3, 0x00c5, 0x00d8, 0x00ea, 0x00fd,
	// Entry 980 - 9BF
	0x010f, 0x0121, 0x0134, 0x0146, 0x0159, 0x016b, 0x017d, 0x018f,
	0x01a1, 0x01b4, 0x01c6, 0x01d9, 0x01ec, 0x01fe, 0x0210, 0x0223,
	0x0239, 0x024f, 0x0264, 0x027a, 0x028f, 0x02a5, 0x02c2, 0x02e0,
	0x02fc, 0x0311, 0x0327, 0x0343, 0x0358, 0x036e, 0x0382, 0x038d,
	0x03a7, 0x03c1, 0x03de, 0x03fc, 0x040f, 0x0421, 0x0433, 0x0447,
	0x045a, 0x046d, 0x047f, 0x0493, 0x04a7, 0x04ba, 0x04d4, 0x04e7,
	0x04fa, 0x050d, 0x0521, 0x0535, 0x0558, 0x0578, 0x059c, 0x05b2,
	0x05c5, 0x05d7, 0x05e5, 0x05f4, 0x0602, 0x0611, 0x061f, 0x062e,
	// Entry 9C0 - 9FF
	0x0644, 0x065a, 0x0668, 0x0677, 0x0685, 0x0694, 0x06a3, 0x06b3,
	0x06c2, 0x06d2, 0x06e2, 0x06f1, 0x0701, 0x0710, 0x0720, 0x0730,
	0x0740, 0x0751, 0x0761, 0x0772, 0x0782, 0x0791, 0x07a1, 0x07b0,
	0x07c0, 0x07cf, 0x07de, 0x07ee, 0x07fd, 0x080d, 0x081c, 0x082b,
	0x083a, 0x0849, 0x0859, 0x0868, 0x0878, 0x0888, 0x0897, 0x08a6,
	0x08b6, 0x08c9, 0x08dc, 0x08ee, 0x0901, 0x0913, 0x0926, 0x0940,
	0x095b, 0x096d, 0x0980, 0x0992, 0x09a5, 0x09b6, 0x09ca, 0x09de,
	0x09ee, 0x09fe, 0x0a0e, 0x0a25, 0x0a3c, 0x0a56, 0x0a71, 0x0a81,
	// Entry A00 - A3F
	0x0a90, 0x0a9f, 0x0ab0, 0x0ac0, 0x0ad0, 0x0adf, 0x0af0, 0x0b01,
	0x0b11, 0x0b1d, 0x0b2c, 0x0b46, 0x0b5d, 0x0b7a, 0x0b96, 0x0baf,
	0x0bce, 0x0be1, 0x0bf3, 0x0c01, 0x0c10, 0x0c1e, 0x0c2d, 0x0c3b,
	0x0c4a, 0x0c58, 0x0c67, 0x0c76, 0x0c84, 0x0c93, 0x0ca2, 0x0cb1,
	0x0cc1, 0x0cd0, 0x0cdf, 0x0cef, 0x0cff, 0x0d0f, 0x0d1e, 0x0d2d,
	0x0d3e, 0x0d4d, 0x0d5c, 0x0d6b, 0x0d7a, 0x0d8a, 0x0d99, 0x0da9,
	0x0dba, 0x0dc9, 0x0dd9, 0x0de9, 0x0df8, 0x0e07, 0x0e1a, 0x0e2c,
	0x0e3f, 0x0e51, 0x0e64, 0x0e76, 0x0e89, 0x0e9c, 0x0eae, 0x0ec1,
	// Entry A40 - A7F
	0x0ed4, 0x0ee5, 0x0eed, 0x0f01, 0x0f11, 0x0f20, 0x0f2f, 0x0f40,
	0x0f50, 0x0f60, 0x0f6f, 0x0f80, 0x0f91, 0x0fa1, 0x0fb1, 0x0fc9,
	0x0fe2, 0x0ff0, 0x1000, 0x100f, 0x101f, 0x1030, 0x1043, 0x1053,
	0x1064, 0x108b, 0x10a2, 0x10b6, 0x10c9, 0x10d8, 0x10e8, 0x10f7,
	0x1107, 0x1116, 0x1126, 0x113d, 0x1154, 0x1163, 0x1173, 0x1183,
	0x1192, 0x11a2, 0x11b2, 0x11c2, 0x11d3, 0x11e3, 0x11f4, 0x1205,
	0x1215, 0x1226, 0x1236, 0x1247, 0x1258, 0x1269, 0x127b, 0x128c,
	0x129e, 0x12af, 0x12bf, 0x12d0, 0x12e0, 0x12f1, 0x1301, 0x1311,
	// Entry A80 - ABF
	0x1322, 0x1332, 0x1343, 0x1353, 0x1363, 0x1373, 0x1384, 0x1394,
	0x13a5, 0x13b7, 0x13c7, 0x13d8, 0x13e9, 0x13f9, 0x1409, 0x141d,
	0x1431, 0x1444, 0x1458, 0x146b, 0x147f, 0x149a, 0x14b6, 0x14c9,
	0x14dd, 0x14f1, 0x1504, 0x1518, 0x152c, 0x153e, 0x1550, 0x1565,
	0x1576, 0x1587, 0x1599, 0x15b1, 0x15c9, 0x15e4, 0x1600, 0x1611,
	0x1621, 0x1631, 0x1643, 0x1654, 0x1665, 0x1675, 0x1687, 0x1699,
	0x16aa, 0x16db, 0x170b, 0x173b, 0x176d, 0x179e, 0x17cf, 0x1802,
	0x1813, 0x1833, 0x184b, 0x1860, 0x1874, 0x1884, 0x1895, 0x18a5,
	// Entry AC0 - AFF
	0x18b6, 0x18c6, 0x18d7, 0x18ef, 0x1907, 0x1917, 0x1928, 0x1939,
	0x1949, 0x195a, 0x196b, 0x197c, 0x198e, 0x199f, 0x19b1, 0x19c3,
	0x19d4, 0x19e6, 0x19f7, 0x1a09, 0x1a1b, 0x1a2d, 0x1a40, 0x1a52,
	0x1a65, 0x1a77, 0x1a88, 0x1a9a, 0x1aab, 0x1abd, 0x1ace, 0x1adf,
	0x1af1, 0x1b02, 0x1b14, 0x1b25, 0x1b36, 0x1b47, 0x1b59, 0x1b6a,
	0x1b7c, 0x1b8d, 0x1b9f, 0x1bb1, 0x1bc2, 0x1bd3, 0x1be5, 0x1bfa,
	0x1c0f, 0x1c23, 0x1c38, 0x1c4c, 0x1c61, 0x1c7d, 0x1c9a, 0x1cae,
	0x1cc3, 0x1cd8, 0x1cec, 0x1d01, 0x1d16, 0x1d29, 0x1d3c, 0x1d52,
	// Entry B00 - B3F
	0x1d63, 0x1d7c, 0x1d95, 0x1db1, 0x1dce, 0x1de0, 0x1df1, 0x1e02,
	0x1e15, 0x1e27, 0x1e39, 0x1e4a, 0x1e5d, 0x1e70, 0x1e82, 0x1e9a,
	0x1eb2, 0x1ed9, 0x1ef3, 0x1f0a, 0x1f20, 0x1f32, 0x1f45, 0x1f57,
	0x1f6a, 0x1f7c, 0x1f8f, 0x1fa9, 0x1fc3, 0x1fd5, 0x1fe8, 0x1ffb,
	0x200d, 0x2020, 0x2033, 0x2046, 0x205a, 0x206d, 0x2081, 0x2095,
	0x20a8, 0x20bc, 0x20cf, 0x20e3, 0x20f7, 0x210b, 0x2120, 0x2134,
	0x2149, 0x215d, 0x2170, 0x2184, 0x2197, 0x21ab, 0x21be, 0x21d3,
	0x21e6, 0x21fa, 0x220d, 0x2221, 0x2234, 0x2247, 0x225a, 0x226e,
	// Entry B40 - B7F
	0x2281, 0x2295, 0x22aa, 0x22bd, 0x22d1, 0x22e5, 0x22f8, 0x230b,
	0x2320, 0x2342, 0x2360, 0x2377, 0x238e, 0x23a4, 0x23bb, 0x23d1,
	0x23e8, 0x2406, 0x2425, 0x243b, 0x2452, 0x2469, 0x247f, 0x2496,
	0x24ad, 0x24c2, 0x24db, 0x24ee, 0x2507, 0x2520, 0x253b, 0x2553,
	0x2582, 0x25a1, 0x25c4, 0x25e4, 0x2600, 0x2623, 0x263f, 0x265a,
	0x2675, 0x2690, 0x26ae, 0x26cd, 0x26e1, 0x26f4, 0x2707, 0x271c,
	0x2730, 0x2744, 0x2757, 0x276c, 0x2781, 0x2795, 0x27a9, 0x27c5,
	0x27e2, 0x2800, 0x281b, 0x283c, 0x285c, 0x2879, 0x289c, 0x28af,
	// Entry B80 - BBF
	0x28c9, 0x28e2, 0x28fc, 0x2915, 0x292f, 0x2948, 0x295f, 0x2975,
	0x298a, 0x29a0, 0x29b6, 0x29cd, 0x29e2, 0x29f8, 0x2a0d, 0x2a23,
	0x2a3a, 0x2a52, 0x2a69, 0x2a81, 0x2a96, 0x2aac, 0x2ac2, 0x2ad7,
	0x2aed, 0x2b03, 0x2b24, 0x2b46, 0x2b67, 0x2b89, 0x2baa, 0x2bc8,
	0x2be9, 0x2c0b, 0x2c2c, 0x2c4e, 0x2c6f, 0x2c9a, 0x2cb8, 0x2cda,
	0x2cfd, 0x2d1f, 0x2d42, 0x2d62, 0x2d81, 0x2da2, 0x2dc4, 0x2de5,
	0x2e07, 0x2e25, 0x2e43, 0x2e64, 0x2e86, 0x2ea7, 0x2ec9, 0x2edf,
	0x2efa, 0x2f10, 0x2f26, 0x2f44, 0x2f5a, 0x2f78, 0x2f98, 0x2fb6,
	// Entry BC0 - BFF
	0x2fcc, 0x2fec, 0x3002, 0x3018, 0x3035, 0x3058, 0x307a, 0x309b,
	0x30bb, 0x30dd, 0x30fe, 0x311d, 0x3137, 0x3156, 0x3173, 0x319c,
	0x31ca, 0x31f4, 0x3212, 0x3229, 0x323f, 0x3255, 0x326d, 0x3284,
	0x329b, 0x32b1, 0x32c9, 0x32e1, 0x32f8, 0x331c, 0x333f, 0x335d,
	0x3372, 0x3389, 0x33a1, 0x33b9, 0x33d0, 0x33ea, 0x3400, 0x3417,
	0x342f, 0x3447, 0x345b, 0x3472, 0x3488, 0x349f, 0x34b6, 0x34cd,
	0x34ea, 0x3504, 0x3519, 0x352e, 0x3543, 0x355b, 0x3574, 0x358c,
	0x35a0, 0x35b8, 0x35cd, 0x35e5, 0x35f9, 0x3610, 0x3625, 0x363f,
	// Entry C00 - C3F
	0x3653, 0x3668, 0x367d, 0x368e, 0x36a4, 0x36b5, 0x36cb, 0x36e1,
	0x36f7, 0x370c, 0x3721, 0x3738, 0x374c, 0x3764, 0x377c, 0x3791,
	0x37ac, 0x37c2, 0x37d8, 0x37ed, 0x3803, 0x3819, 0x3830, 0x3845,
	0x385b, 0x3871, 0x388a, 0x389f, 0x38b5, 0x38ca, 0x38e8, 0x3907,
	0x3921, 0x3938, 0x3950, 0x3965, 0x397b, 0x3991, 0x39ac, 0x39c6,
	0x39dd, 0x39f4, 0x3a0a, 0x3a19, 0x3a27, 0x3a35, 0x3a45, 0x3a54,
	0x3a63, 0x3a71, 0x3a81, 0x3a91, 0x3aa0, 0x3ab9, 0x3ace, 0x3adb,
	0x3aee, 0x3b00, 0x3b0e, 0x3b1b, 0x3b2c, 0x3b3a, 0x3b47, 0x3b54,
	// Entry C40 - C7F
	0x3b67, 0x3b79, 0x3b86, 0x3b93, 0x3ba0, 0x3bb3, 0x3bc4, 0x3bd6,
	0x3be8, 0x3bf5, 0x3c02, 0x3c14, 0x3c26, 0x3c33, 0x3c45, 0x3c57,
	0x3c63, 0x3c74, 0x3c80, 0x3c90, 0x3ca6, 0x3cb7, 0x3cc8, 0x3cd8,
	0x3ce9, 0x3cf9, 0x3d0a, 0x3d1a, 0x3d2b, 0x3d41, 0x3d56, 0x3d6c,
	0x3d7c, 0x3d8d, 0x3d9d, 0x3dae, 0x3dbf, 0x3dc8, 0x3dd7, 0x3de7,
	0x3df6, 0x3e09, 0x3e1e, 0x3e2b, 0x3e39, 0x3e46, 0x3e53, 0x3e62,
	0x3e70, 0x3e7e, 0x3e8b, 0x3e9a, 0x3ea9, 0x3eb7, 0x3ec0, 0x3ec9,
	0x3edb, 0x3eee, 0x3f01, 0x3f26, 0x3f50, 0x3f7b, 0x3f9f, 0x3fc3,
	// Entry C80 - CBF
	0x3fea, 0x400c, 0x4023, 0x403d, 0x405b, 0x407b, 0x409d, 0x40ae,
	0x40c4, 0x40db, 0x40f7, 0x4118, 0x4133, 0x415d, 0x4174, 0x4194,
	0x41b4, 0x41e3, 0x4206, 0x422c, 0x4247, 0x4263, 0x427e, 0x4298,
	0x42b3, 0x42d2, 0x42e4, 0x42f5, 0x4306, 0x4319, 0x432b, 0x433d,
	0x434e, 0x4361, 0x4374, 0x4386, 0x439c, 0x43b2, 0x43ca, 0x43e1,
	0x43f8, 0x440e, 0x4426, 0x443e, 0x4455, 0x446c, 0x4484, 0x44a3,
	0x44ce, 0x44f0, 0x4504, 0x451a, 0x4535, 0x4550, 0x456b, 0x4586,
	0x459c, 0x45b2, 0x45c3, 0x45d5, 0x45e6, 0x45f8, 0x460a, 0x461b,
	// Entry CC0 - CFF
	0x462d, 0x463e, 0x4650, 0x4662, 0x4675, 0x4687, 0x469a, 0x46ac,
	0x46bd, 0x46cf, 0x46e0, 0x46f2, 0x4703, 0x4714, 0x4726, 0x4737,
	0x4749, 0x475a, 0x476c, 0x477f, 0x4791, 0x47a4, 0x47b5, 0x47c7,
	0x47d8, 0x47e9, 0x47fa, 0x480b, 0x481c, 0x482e, 0x4840, 0x4851,
	0x4862, 0x4872, 0x4885, 0x48a1, 0x48b3, 0x48c5, 0x48da, 0x48ee,
	0x4903, 0x4917, 0x492c, 0x4948, 0x4965, 0x4981, 0x499e, 0x49b2,
	0x49c7, 0x49db, 0x49f0, 0x4a0b, 0x4a21, 0x4a3e, 0x4a5c, 0x4a77,
	0x4a8c, 0x4aa0, 0x4ab3, 0x4ac9, 0x4ae0, 0x4af8, 0x4b0d, 0x4b29,
	// Entry D00 - D3F
	0x4b45, 0x4b63, 0x4b85, 0x4ba4, 0x4bcc, 0x4be7, 0x4c03, 0x4c1e,
	0x4c3a, 0x4c56, 0x4c71, 0x4c8d, 0x4ca8, 0x4cc4, 0x4ce0, 0x4cfd,
	0x4d19, 0x4d36, 0x4d52, 0x4d6d, 0x4d89, 0x4da4, 0x4dc0, 0x4ddb,
	0x4df6, 0x4e12, 0x4e2d, 0x4e49, 0x4e64, 0x4e80, 0x4e9d, 0x4eb9,
	0x4ed6, 0x4ef1, 0x4f0d, 0x4f28, 0x4f43, 0x4f5e, 0x4f79, 0x4f94,
	0x4fb0, 0x4fcc, 0x4fe7, 0x5002, 0x501c, 0x5039, 0x505f, 0x5085,
	0x50ab, 0x50bc, 0x50da, 0x50fe, 0x5122, 0x5145, 0x5169, 0x517f,
	0x5195, 0x51ae, 0x51ce, 0x51e4, 0x51f9, 0x521a, 0x523b, 0x525c,
	// Entry D40 - D7F
	0x527b, 0x5295, 0x52b9, 0x52dc, 0x52f3, 0x5323, 0x5353, 0x536b,
	0x5382, 0x53a4, 0x53c5, 0x53e5, 0x5406, 0x5417, 0x5429, 0x543a,
	0x544c, 0x545e, 0x546f, 0x5481, 0x5492, 0x54a4, 0x54b6, 0x54c9,
	0x54db, 0x54ee, 0x5500, 0x5513, 0x5525, 0x5536, 0x5548, 0x5559,
	0x556b, 0x557c, 0x558d, 0x559f, 0x55b0, 0x55c2, 0x55d3, 0x55e4,
	0x55f5, 0x5606, 0x5617, 0x5628, 0x5639, 0x564b, 0x565b, 0x5670,
	0x5680, 0x5691, 0x56a1, 0x56b2, 0x56c2, 0x56d6, 0x56e6, 0x56f7,
	0x5711, 0x5726, 0x573a, 0x574f, 0x5763, 0x5778, 0x578c, 0x57a1,
	// Entry D80 - DBF
	0x57ba, 0x57d2, 0x57ec, 0x5801, 0x5817, 0x582b, 0x583e, 0x584f,
	0x586f, 0x588f, 0x58af, 0x58cf, 0x58e6, 0x58f8, 0x5909, 0x591a,
	0x592d, 0x593f, 0x5951, 0x5962, 0x5975, 0x5988, 0x599a, 0x59b5,
	0x59c9, 0x59e0, 0x59f8, 0x5a15, 0x5a2c, 0x5a3e, 0x5a50, 0x5a68,
	0x5a81, 0x5a99, 0x5ab2, 0x5ace, 0x5aeb, 0x5b07, 0x5b24, 0x5b3a,
	0x5b50, 0x5b66, 0x5b7c, 0x5ba0, 0x5bc4, 0x5be8, 0x5c05, 0x5c25,
	0x5c47, 0x5c6a, 0x5c8e, 0x5cb2, 0x5cd9, 0x5d00, 0x5d25, 0x5d4a,
	0x5d6f, 0x5d94, 0x5db9, 0x5ddd, 0x5e01, 0x5e26, 0x5e45, 0x5e60,
	// Entry DC0 - DFF
	0x5e7a, 0x5e95, 0x5eab, 0x5ec2, 0x5ed8, 0x5eee, 0x5f04, 0x5f1b,
	0x5f31, 0x5f47, 0x5f5e, 0x5f74, 0x5f8a, 0x5fa1, 0x5fb7, 0x5fdc,
	0x5ff6, 0x600f, 0x602e, 0x604d, 0x6065, 0x607d, 0x6095, 0x60ad,
	0x60cd, 0x60ed, 0x6114, 0x6133, 0x6154, 0x616b, 0x6181, 0x6197,
	0x61af, 0x61c6, 0x61dd, 0x61f3, 0x620b, 0x6223, 0x623a, 0x6254,
	0x626e, 0x6288, 0x62a3, 0x62ba, 0x62d9, 0x62f3, 0x630e, 0x6329,
	0x6344, 0x635e, 0x6379, 0x6394, 0x63af, 0x63c9, 0x63e4, 0x63ff,
	0x641a, 0x6435, 0x644f, 0x646a, 0x6486, 0x64a1, 0x64bc, 0x64d7,
	// Entry E00 - E3F
	0x64f1, 0x650d, 0x6529, 0x6545, 0x6560, 0x657c, 0x6598, 0x65b3,
	0x65ce, 0x65e9, 0x6605, 0x6620, 0x663c, 0x6657, 0x6671, 0x668c,
	0x66a6, 0x66c1, 0x66dc, 0x66f6, 0x6711, 0x6723, 0x6736, 0x6749,
	0x675c, 0x676e, 0x6781, 0x6794, 0x67a7, 0x67b9, 0x67cc, 0x67df,
	0x67f2, 0x6805, 0x6817, 0x682a, 0x683e, 0x6851, 0x6864, 0x6877,
	0x6889, 0x689d, 0x68b1, 0x68c5, 0x68d8, 0x68ec, 0x6900, 0x6913,
	0x6926, 0x6939, 0x694d, 0x6960, 0x6974, 0x6987, 0x6999, 0x69ac,
	0x69be, 0x69d1, 0x69e4, 0x69f6, 0x6a08, 0x6a1d, 0x6a37, 0x6a4a,
	// Entry E40 - E7F
	0x6a66, 0x6a82, 0x6a95, 0x6aae, 0x6ac9, 0x6adf, 0x6afa, 0x6b0f,
	0x6b25, 0x6b40, 0x6b55, 0x6b6a, 0x6b7f, 0x6b99, 0x6bad, 0x6bc6,
	0x6bdb, 0x6bf0, 0x6c0a, 0x6c21, 0x6c38, 0x6c4f, 0x6c66, 0x6c7b,
	0x6c97, 0x6cb1, 0x6ccd, 0x6ce8, 0x6d05, 0x6d20, 0x6d3a, 0x6d55,
	0x6d72, 0x6d8d, 0x6daa, 0x6dc6, 0x6de1, 0x6dfd, 0x6e17, 0x6e38,
	0x6e59, 0x6e79, 0x6e98, 0x6eb8, 0x6ed3, 0x6ef0, 0x6f0d, 0x6f2a,
	0x6f47, 0x6f69, 0x6f84, 0x6f9e, 0x6fb9, 0x6fd3, 0x6fed, 0x7007,
	0x7028, 0x7046, 0x7060, 0x707a, 0x7096, 0x70b2, 0x70ce, 0x70ea,
	// Entry E80 - EBF
	0x7104, 0x7120, 0x7141, 0x7160, 0x7184, 0x719b, 0x71b7, 0x71d3,
	0x71ee, 0x7209, 0x7223, 0x7240, 0x725a, 0x7275, 0x7292, 0x72af,
	0x72cc, 0x72e4, 0x72ff, 0x731c, 0x733e, 0x735e, 0x7383, 0x73a2,
	0x73bf, 0x73de, 0x7400, 0x741d, 0x743c, 0x7456, 0x7471, 0x748e,
	0x74a8, 0x74c3, 0x74de, 0x74fa, 0x7510, 0x7527, 0x7539, 0x754c,
	0x755f, 0x7573, 0x7586, 0x7598, 0x75ac, 0x75bf, 0x75d1, 0x75e4,
	0x75f8, 0x760b, 0x761e, 0x7630, 0x7644, 0x7657, 0x766a, 0x767d,
	0x7690, 0x76a3, 0x76b5, 0x76c9, 0x76dd, 0x76f2, 0x7708, 0x771d,
	// Entry EC0 - EFF
	0x7732, 0x7748, 0x775e, 0x7774, 0x7789, 0x779d, 0x77b2, 0x77c6,
	0x77da, 0x77f0, 0x7807, 0x781e, 0x7833, 0x7848, 0x785c, 0x7871,
	0x7889, 0x789e, 0x78b2, 0x78c7, 0x78dd, 0x78f2, 0x7909, 0x791f,
	0x7934, 0x7949, 0x795e, 0x7974, 0x7989, 0x799d, 0x79b2, 0x79c6,
	0x79da, 0x79ef, 0x7a07, 0x7a1d, 0x7a36, 0x7a4e, 0x7a66, 0x7a81,
	0x7a96, 0x7aab, 0x7ac2, 0x7ad7, 0x7aed, 0x7b04, 0x7b20, 0x7b3c,
	0x7b52, 0x7b6e, 0x7b8a, 0x7ba1, 0x7bb7, 0x7bd4, 0x7bf0, 0x7c0c,
	0x7c27, 0x7c45, 0x7c63, 0x7c7f, 0x7c95, 0x7cab, 0x7cc6, 0x7cdb,
	// Entry F00 - F3F
	0x7cf5, 0x7d0b, 0x7d21, 0x7d39, 0x7d51, 0x7d69, 0x7d81, 0x7d97,
	0x7db4, 0x7dd7, 0x7df4, 0x7e11, 0x7e2c, 0x7e4a, 0x7e68, 0x7e86,
	0x7ea3, 0x7ec5, 0x7ee1, 0x7efe, 0x7f21, 0x7f3c, 0x7f5f, 0x7f80,
	0x7fa1, 0x7fc3, 0x7fe7, 0x8007, 0x8025, 0x8043, 0x8065, 0x8082,
	0x809e, 0x80ba, 0x80d5, 0x80f5, 0x8113, 0x8131, 0x814d, 0x816b,
	0x8187, 0x81a5, 0x81c1, 0x81df, 0x81fb, 0x8217, 0x8232, 0x824d,
	0x8265, 0x8282, 0x82a4, 0x82bf, 0x82dd, 0x82f6, 0x8314, 0x8335,
	0x8353, 0x8373, 0x838f, 0x83ab, 0x83c7, 0x83e3, 0x83ff, 0x841c,
	// Entry F40 - F7F
	0x8439, 0x8458, 0x8477, 0x8494, 0x84af, 0x84c3, 0x84d7, 0x84eb,
	0x8500, 0x8515, 0x8529, 0x853d, 0x8552, 0x8566, 0x857a, 0x858e,
	0x85a3, 0x85b8, 0x85cc, 0x85e0, 0x85f5, 0x860a, 0x861f, 0x8634,
	0x864a, 0x8660, 0x8675, 0x868a, 0x86a0, 0x86b4, 0x86c8, 0x86dc,
	0x86f1, 0x8706, 0x871a, 0x872e, 0x8743, 0x8758, 0x876d, 0x8782,
	0x8798, 0x87ae, 0x87c3, 0x87d8, 0x87ee, 0x8802, 0x8816, 0x882a,
	0x883f, 0x8854, 0x8868, 0x887c, 0x8891, 0x88a5, 0x88b9, 0x88cd,
	0x88e2, 0x88f7, 0x890b, 0x891f, 0x8934, 0x8949, 0x895e, 0x8973,
	// Entry F80 - FBF
	0x8989, 0x899f, 0x89b4, 0x89c9, 0x89df, 0x89f3, 0x8a07, 0x8a1b,
	0x8a30, 0x8a45, 0x8a59, 0x8a6d, 0x8a82, 0x8a97, 0x8aac, 0x8ac2,
	0x8ad8, 0x8aed, 0x8b02, 0x8b17, 0x8b2c, 0x8b42, 0x8b58, 0x8b6d,
	0x8b82, 0x8b98, 0x8bae, 0x8bc5, 0x8bdc, 0x8bf2, 0x8c06, 0x8c1a,
	0x8c2e, 0x8c43, 0x8c58, 0x8c6c, 0x8c80, 0x8c95, 0x8ca9, 0x8cbd,
	0x8cd1, 0x8ce6, 0x8cfb, 0x8d0f, 0x8d23, 0x8d38, 0x8d4c, 0x8d60,
	0x8d74, 0x8d89, 0x8d9e, 0x8db2, 0x8dc6, 0x8ddb, 0x8def, 0x8e03,
	0x8e17, 0x8e2c, 0x8e41, 0x8e55, 0x8e69, 0x8e7e, 0x8e92, 0x8ea6,
	// Entry FC0 - FFF
	0x8eba, 0x8ecf, 0x8ee4, 0x8ef8, 0x8f0c, 0x8f21, 0x8f36, 0x8f4b,
	0x8f61, 0x8f77, 0x8f8c, 0x8fa0, 0x8fb4, 0x8fc8, 0x8fdd, 0x8ff2,
	0x9006, 0x901a, 0x902f, 0x9044, 0x9059, 0x906e, 0x9084, 0x909a,
	0x90af, 0x90c4, 0x90da, 0x90f5, 0x9110, 0x912b, 0x9147, 0x9163,
	0x917e, 0x9199, 0x91b5, 0x91c9, 0x91dd, 0x91f1, 0x9206, 0x921b,
	0x922f, 0x9243, 0x9258, 0x926d, 0x9282, 0x9298, 0x92ae, 0x92c3,
	0x92d8, 0x92ed, 0x9302, 0x9318, 0x932e, 0x9343, 0x9358, 0x936e,
	0x9384, 0x939b, 0x93b2, 0x93c8, 0x93dc, 0x93f0, 0x9404, 0x9419,
	// Entry 1000 - 103F
	0x942e, 0x9442, 0x9456, 0x946b, 0x9489, 0x94a7, 0x94c5, 0x94e4,
	0x9503, 0x9521, 0x953f, 0x9553, 0x9567, 0x957b, 0x9590, 0x95a5,
	0x95b9, 0x95cd, 0x95e2, 0x95f7, 0x960c, 0x9621, 0x9637, 0x964d,
	0x9662, 0x9677, 0x968d, 0x96a1, 0x96b5, 0x96c9, 0x96de, 0x96f3,
	0x9707, 0x971b, 0x9730, 0x9744, 0x9758, 0x976c, 0x9781, 0x9796,
	0x97aa, 0x97be, 0x97d3, 0x97e8, 0x97fd, 0x9812, 0x9828, 0x983e,
	0x9853, 0x9868, 0x987e, 0x9892, 0x98a6, 0x98ba, 0x98cf, 0x98e4,
	0x98f8, 0x990c, 0x9921, 0x9935, 0x9949, 0x995d, 0x9972, 0x9987,
	// Entry 1040 - 107F
	0x999b, 0x99af, 0x99c4, 0x99d9, 0x99ee, 0x9a04, 0x9a1a, 0x9a2f,
	0x9a44, 0x9a59, 0x9a6e, 0x9a84, 0x9a9a, 0x9aaf, 0x9ac4, 0x9adb,
	0x9af0, 0x9b05, 0x9b1a, 0x9b30, 0x9b46, 0x9b5b, 0x9b70, 0x9b86,
	0x9b9b, 0x9bb0, 0x9bc5, 0x9bdb, 0x9bf1, 0x9c06, 0x9c1b, 0x9c31,
	0x9c46, 0x9c5b, 0x9c70, 0x9c86, 0x9c9c, 0x9cb1, 0x9cc6, 0x9cdc,
	0x9cf1, 0x9d06, 0x9d1b, 0x9d31, 0x9d47, 0x9d5c, 0x9d71, 0x9d87,
	0x9d9c, 0x9db1, 0x9dc6, 0x9ddc, 0x9df2, 0x9e07, 0x9e1c, 0x9e32,
	0x9e46, 0x9e5a, 0x9e6e, 0x9e83, 0x9e98, 0x9eac, 0x9ec0, 0x9ed5,
	// Entry 1080 - 10BF
	0x9ee9, 0x9efd, 0x9f11, 0x9f26, 0x9f3b, 0x9f4f, 0x9f63, 0x9f78,
	0x9f8d, 0x9fa2, 0x9fb7, 0x9fea, 0xa00e, 0xa030, 0xa045, 0xa057,
	0xa069, 0xa077, 0xa089, 0xa097, 0xa0ad, 0xa0c3, 0xa0df, 0xa0f1,
	0xa103, 0xa117, 0xa12a, 0xa13d, 0xa14f, 0xa163, 0xa177, 0xa18a,
	0xa19d, 0xa1b3, 0xa1c9, 0xa1de, 0xa1f3, 0xa208, 0xa21f, 0xa235,
	0xa24b, 0xa262, 0xa27e, 0xa29d, 0xa2b2, 0xa2c8, 0xa2dd, 0xa2fc,
	0xa311, 0xa327, 0xa33c, 0xa35b, 0xa370, 0xa386, 0xa39b, 0xa3ba,
	0xa3cf, 0xa3e5, 0xa3fa, 0xa413, 0xa42c, 0xa446, 0xa466, 0xa47f,
	// Entry 10C0 - 10FF
	0xa498, 0xa4b2, 0xa4cb, 0xa4ea, 0xa502, 0xa513, 0xa524, 0xa535,
	0xa546, 0xa557, 0xa568, 0xa57a, 0xa58c, 0xa59e, 0xa5b0, 0xa5c2,
	0xa5d4, 0xa5e6, 0xa5f8, 0xa60a, 0xa61c, 0xa62e, 0xa640, 0xa652,
	0xa664, 0xa676, 0xa688, 0xa69a, 0xa6ac, 0xa6be, 0xa6d0, 0xa6e2,
	0xa6f4, 0xa706, 0xa718, 0xa72a, 0xa73d, 0xa750, 0xa762, 0xa774,
	0xa786, 0xa798, 0xa7aa, 0xa7bd, 0xa7d0, 0xa7e3, 0xa7f6, 0xa809,
	0xa81c, 0xa82e, 0xa83f, 0xa851, 0xa863, 0xa875, 0xa887, 0xa899,
	0xa8ab, 0xa8bd, 0xa8cf, 0xa8e1, 0xa8f3, 0xa905, 0xa917, 0xa929,
	// Entry 1100 - 113F
	0xa93b, 0xa94e, 0xa961, 0xa974, 0xa987, 0xa99a, 0xa9ad, 0xa9c0,
	0xa9d3, 0xa9e6, 0xa9f9, 0xaa0c, 0xaa1f, 0xaa32, 0xaa44, 0xaa56,
	0xaa68, 0xaa7a, 0xaa8c, 0xaa9e, 0xaab0, 0xaac2, 0xaad4, 0xaae6,
	0xaaf8, 0xab0a, 0xab1c, 0xab34, 0xab4c, 0xab64, 0xab7c, 0xab94,
	0xabac, 0xabc5, 0xabd9, 0xabef, 0xac03, 0xac18, 0xac2c, 0xac41,
	0xac5d, 0xac7a, 0xac96, 0xacaa, 0xacbf, 0xacd4, 0xacf3, 0xad08,
	0xad27, 0xad3d, 0xad5d, 0xad72, 0xad91, 0xada7, 0xadc7, 0xade5,
	0xadfa, 0xae19, 0xae2f, 0xae4f, 0xae6d, 0xae82, 0xae9d, 0xaebc,
	// Entry 1140 - 117F
	0xaeda, 0xaef8, 0xaf21, 0xaf47, 0xaf6f, 0xaf8c, 0xafb1, 0xafe7,
	0xb00a, 0xb03a, 0xb057, 0xb079, 0xb08e, 0xb0a3, 0xb0b8, 0xb0cd,
	0xb0e2, 0xb0f9, 0xb10e, 0xb124, 0xb139, 0xb14f, 0xb16c, 0xb18a,
	0xb1a7, 0xb1bc, 0xb1d2, 0xb1e8, 0xb208, 0xb21e, 0xb23e, 0xb255,
	0xb276, 0xb28c, 0xb2ac, 0xb2c3, 0xb2e4, 0xb2fa, 0xb31a, 0xb331,
	0xb352, 0xb370, 0xb384, 0xb3a2, 0xb3be, 0xb3d3, 0xb3ea, 0xb3ff,
	0xb415, 0xb42a, 0xb440, 0xb45d, 0xb47b, 0xb498, 0xb4ad, 0xb4c3,
	0xb4d9, 0xb4f9, 0xb50f, 0xb52f, 0xb546, 0xb567, 0xb57d, 0xb59d,
	// Entry 1180 - 11BF
	0xb5b4, 0xb5d5, 0xb5eb, 0xb60b, 0xb622, 0xb643, 0xb662, 0xb676,
	0xb68c, 0xb6a2, 0xb6b8, 0xb6ce, 0xb6e3, 0xb6fa, 0xb70f, 0xb725,
	0xb73a, 0xb750, 0xb76d, 0xb782, 0xb798, 0xb7ae, 0xb7ce, 0xb7e4,
	0xb804, 0xb81b, 0xb83c, 0xb852, 0xb872, 0xb889, 0xb8aa, 0xb8c0,
	0xb8e0, 0xb8f7, 0xb918, 0xb937, 0xb94b, 0xb960, 0xb983, 0xb9a6,
	0xb9c9, 0xb9ec, 0xba01, 0xba18, 0xba2d, 0xba43, 0xba58, 0xba6e,
	0xba8b, 0xbaa0, 0xbab6, 0xbacc, 0xbaec, 0xbb02, 0xbb22, 0xbb39,
	0xbb5a, 0xbb70, 0xbb90, 0xbba7, 0xbbc8, 0xbbde, 0xbbfe, 0xbc15,
	// Entry 11C0 - 11FF
	0xbc36, 0xbc55, 0xbc69, 0xbc85, 0xbc9a, 0xbcb1, 0xbcc6, 0xbcdc,
	0xbcf1, 0xbd07, 0xbd24, 0xbd39, 0xbd4f, 0xbd65, 0xbd85, 0xbd9b,
	0xbdbb, 0xbdd2, 0xbdf3, 0xbe09, 0xbe29, 0xbe40, 0xbe61, 0xbe77,
	0xbe97, 0xbeae, 0xbecf, 0xbeee, 0xbf02, 0xbf20, 0xbf35, 0xbf54,
	0xbf6f, 0xbf84, 0xbf9b, 0xbfb0, 0xbfc6, 0xbfdb, 0xbff1, 0xc00e,
	0xc023, 0xc039, 0xc04f, 0xc06f, 0xc085, 0xc0a5, 0xc0bc, 0xc0dd,
	0xc0fc, 0xc110, 0xc12d, 0xc142, 0xc157, 0xc16e, 0xc183, 0xc199,
	0xc1ae, 0xc1c4, 0xc1e1, 0xc1f6, 0xc20c, 0xc222, 0xc242, 0xc258,
	// Entry 1200 - 123F
	0xc278, 0xc28f, 0xc2b0, 0xc2c6, 0xc2e6, 0xc2fd, 0xc31e, 0xc334,
	0xc354, 0xc36b, 0xc38c, 0xc3a0, 0xc3be, 0xc3d9, 0xc3ee, 0xc405,
	0xc41a, 0xc430, 0xc445, 0xc45b, 0xc478, 0xc48d, 0xc4a3, 0xc4b9,
	0xc4d9, 0xc4ef, 0xc50f, 0xc526, 0xc547, 0xc55d, 0xc57d, 0xc594,
	0xc5b5, 0xc5cb, 0xc5eb, 0xc602, 0xc623, 0xc642, 0xc656, 0xc675,
	0xc68a, 0xc6a8, 0xc6c8, 0xc6e6, 0xc704, 0xc723, 0xc742, 0xc761,
	0xc780, 0xc796, 0xc7ac, 0xc7c3, 0xc7d9, 0xc7f0, 0xc806, 0xc81d,
	0xc834, 0xc855, 0xc86c, 0xc88d, 0xc8a5, 0xc8c7, 0xc8de, 0xc8ff,
	// Entry 1240 - 127F
	0xc917, 0xc939, 0xc950, 0xc971, 0xc989, 0xc9ab, 0xc9c0, 0xc9d5,
	0xc9ec, 0xca01, 0xca17, 0xca2c, 0xca42, 0xca5f, 0xca74, 0xca8a,
	0xcaa0, 0xcac0, 0xcad6, 0xcaf6, 0xcb0d, 0xcb2e, 0xcb44, 0xcb64,
	0xcb7b, 0xcb9c, 0xcbb2, 0xcbd2, 0xcbe9, 0xcc0a, 0xcc29, 0xcc3d,
	0xcc5c, 0xcc7a, 0xcc96, 0xccab, 0xccc7, 0xcce6, 0xccfd, 0xcd12,
	0xcd28, 0xcd3d, 0xcd53, 0xcd72, 0xcd87, 0xcd9d, 0xcdbc, 0xcdd3,
	0xcdf4, 0xce08, 0xce26, 0xce41, 0xce56, 0xce6d, 0xce82, 0xce98,
	0xcead, 0xcec3, 0xced8, 0xceee, 0xcf05, 0xcf26, 0xcf3a, 0xcf50,
	// Entry 1280 - 12BF
	0xcf6d, 0xcf83, 0xcfa0, 0xcfb7, 0xcfd5, 0xcfeb, 0xd002, 0xd018,
	0xd02f, 0xd047, 0xd069, 0xd07e, 0xd095, 0xd0ac, 0xd0c3, 0xd0da,
	0xd0f0, 0xd106, 0xd11c, 0xd132, 0xd148, 0xd165, 0xd182, 0xd1a0,
	0xd1bd, 0xd1db, 0xd1f8, 0xd216, 0xd232, 0xd24e, 0xd263, 0xd27a,
	0xd28f, 0xd2a5, 0xd2ba, 0xd2d0, 0xd2e5, 0xd2fb, 0xd30f, 0xd326,
	0xd33d, 0xd354, 0xd36b, 0xd38a, 0xd3a9, 0xd3c8, 0xd3e7, 0xd3ff,
	0xd415, 0xd42c, 0xd442, 0xd459, 0xd46f, 0xd486, 0xd49b, 0xd4b1,
	0xd4ce, 0xd4eb, 0xd508, 0xd525, 0xd546, 0xd567, 0xd588, 0xd5a9,
	// Entry 12C0 - 12FF
	0xd5c9, 0xd5df, 0xd5f6, 0xd60c, 0xd623, 0xd639, 0xd650, 0xd665,
	0xd683, 0xd6a1, 0xd6c0, 0xd6de, 0xd6fd, 0xd71b, 0xd73a, 0xd757,
	0xd773, 0xd791, 0xd7af, 0xd7cd, 0xd7eb, 0xd80a, 0xd829, 0xd848,
	0xd867, 0xd886, 0xd8a5, 0xd8c4, 0xd8e3, 0xd902, 0xd921, 0xd940,
	0xd95f, 0xd97b, 0xd997, 0xd9b3, 0xd9cf, 0xd9ed, 0xda0b, 0xda29,
	0xda48, 0xda66, 0xda84, 0xdaa1, 0xdabe, 0xdadb, 0xdaf9, 0xdb16,
	0xdb33, 0xdb50, 0xdb6d, 0xdb8a, 0xdba8, 0xdbc5, 0xdbe2, 0xdc00,
	0xdc1e, 0xdc3c, 0xdc5b, 0xdc79, 0xdc97, 0xdcb5, 0xdcd3, 0xdcf1,
	// Entry 1300 - 133F
	0xdd10, 0xdd2e, 0xdd4c, 0xdd6a, 0xdd88, 0xdda6, 0xddc5, 0xdde3,
	0xde01, 0xde1e, 0xde3b, 0xde58, 0xde76, 0xde93, 0xdeb0, 0xdecc,
	0xdee9, 0xdf06, 0xdf23, 0xdf41, 0xdf5e, 0xdf7b, 0xdf99, 0xdfb7,
	0xdfd5, 0xdff4, 0xe012, 0xe030, 0xe04e, 0xe06c, 0xe08a, 0xe0a9,
	0xe0c7, 0xe0e5, 0xe102, 0xe11f, 0xe13c, 0xe159, 0xe177, 0xe194,
	0xe1b1, 0xe1ce, 0xe1eb, 0xe208, 0xe226, 0xe243, 0xe260, 0xe27d,
	0xe29a, 0xe2b7, 0xe2d5, 0xe2f2, 0xe30f, 0xe32c, 0xe348, 0xe365,
	0xe382, 0xe3a0, 0xe3bd, 0xe3d9, 0xe3f6, 0xe414, 0xe432, 0xe450,
	// Entry 1340 - 137F
	0xe46f, 0xe48d, 0xe4ab, 0xe4c8, 0xe4e5, 0xe502, 0xe520, 0xe53d,
	0xe55a, 0xe578, 0xe596, 0xe5b4, 0xe5d3, 0xe5f1, 0xe60f, 0xe62d,
	0xe64b, 0xe669, 0xe688, 0xe6a6, 0xe6c4, 0xe6e3, 0xe702, 0xe721,
	0xe741, 0xe760, 0xe77f, 0xe79d, 0xe7bb, 0xe7d9, 0xe7f8, 0xe816,
	0xe834, 0xe851, 0xe86e, 0xe88b, 0xe8a9, 0xe8c6, 0xe8e3, 0xe8ff,
	0xe923, 0xe941, 0xe95f, 0xe97d, 0xe99c, 0xe9ba, 0xe9d8, 0xe9f5,
	0xea12, 0xea2f, 0xea4d, 0xea6a, 0xea87, 0xeaa5, 0xeac3, 0xeae1,
	0xeb00, 0xeb1e, 0xeb3c, 0xeb59, 0xeb77, 0xeb95, 0xebb3, 0xebd2,
	// Entry 1380 - 13BF
	0xebf0, 0xec0e, 0xec2c, 0xec4a, 0xec68, 0xec87, 0xeca5, 0xecc3,
	0xece2, 0xed01, 0xed20, 0xed40, 0xed5f, 0xed7e, 0xed99, 0xedb5,
	0xedcb, 0xede2, 0xedf9, 0xee11, 0xee28, 0xee40, 0xee57, 0xee6f,
	0xee92, 0xeeb4, 0xeed7, 0xeef9, 0xef1c, 0xef3e, 0xef61, 0xef87,
	0xefa5, 0xefb5, 0xefc7, 0xefd8, 0xefea, 0xeffb, 0xf00c, 0xf01d,
	0xf02e, 0xf040, 0xf051, 0xf063, 0xf074, 0xf085, 0xf099, 0xf0ac,
	0xf0bd, 0xf0ce, 0xf0de, 0xf0ed, 0xf101, 0xf115, 0xf129, 0xf138,
	0xf14d, 0xf15e, 0xf176, 0xf188, 0xf19a, 0xf1b5, 0xf1d0, 0xf1de,
	// Entry 13C0 - 13FF
	0xf1f4, 0xf203, 0xf211, 0xf21f, 0xf240, 0xf250, 0xf264, 0xf275,
	0xf286, 0xf297, 0xf2b5, 0xf2d2, 0xf2e0, 0xf2ef, 0xf2fe, 0xf31b,
	0xf32d, 0xf33d, 0xf350, 0xf35e, 0xf36e, 0xf386, 0xf396, 0xf3af,
	0xf3c4, 0xf3d8, 0xf3f9, 0xf419, 0xf437, 0xf455, 0xf46a, 0xf484,
	0xf492, 0xf4a6, 0xf4b6, 0xf4d4, 0xf4f0, 0xf505, 0xf521, 0xf539,
	0xf54e, 0xf572, 0xf58f, 0xf59d, 0xf5ab, 0xf5c7, 0xf5e4, 0xf5f2,
	0xf617, 0xf638, 0xf64d, 0xf660, 0xf677, 0xf690, 0xf6af, 0xf6cd,
	0xf6ec, 0xf701, 0xf714, 0xf724, 0xf73d, 0xf759, 0xf769, 0xf779,
	// Entry 1400 - 143F
	0xf78d, 0xf79e, 0xf7b0, 0xf7c1, 0xf7dc, 0xf7f6, 0xf80f, 0xf81d,
	0xf82b, 0xf843, 0xf85d, 0xf874, 0xf887, 0xf89c, 0xf8b1, 0xf8bf,
	0xf8ce, 0xf8dd, 0xf8fa, 0xf917, 0xf934, 0xf951, 0xf970, 0xf980,
	0xf990, 0xf9a0, 0xf9b1, 0xf9c2, 0xf9d4, 0xf9e5, 0xf9f6, 0xfa07,
	0xfa18, 0xfa29, 0xfa3a, 0xfa4b, 0xfa5c, 0xfa6d, 0xfa7e, 0xfa8f,
	0xfaa3, 0xfab7, 0xfaca, 0xfada, 0xfaea, 0xfafa, 0xfb0b, 0xfb1c,
	0xfb2e, 0xfb3f, 0xfb50, 0xfb61, 0xfb72, 0xfb83, 0xfb94, 0xfba5,
	0xfbb6, 0xfbc7, 0xfbd8, 0xfbe9, 0xfbfa, 0xfc0e, 0xfc22, 0xfc37,
	// Entry 1440 - 147F
	0xfc54, 0xfc71, 0xfc7f, 0xfc8d, 0xfc9b, 0xfcaa, 0xfcb9, 0xfcc9,
	0xfcd8, 0xfce7, 0xfcf6, 0xfd05, 0xfd14, 0xfd23, 0xfd32, 0xfd41,
	0xfd50, 0xfd5f, 0xfd6e, 0xfd7d, 0xfd8f, 0xfda1, 0xfdb2, 0xfdc3,
	0xfdd4, 0xfde6, 0xfdf8, 0xfe0b, 0xfe1d, 0xfe2f, 0xfe41, 0xfe53,
	0xfe65, 0xfe77, 0xfe89, 0xfe9b, 0xfead, 0xfebf, 0xfed4, 0xfee9,
	0xfef8, 0xff08, 0xff17, 0xff27, 0xff37, 0xff46, 0xff56, 0xff65,
	0xff75, 0xff85, 0xff94, 0xffa5, 0xffb4, 0xffc5, 0xffd5, 0xffe4,
	0xfff4, 0x0003, 0x0013, 0x0022, 0x0031, 0x0041, 0x0050, 0x0060,
	// Entry 1480 - 14BF
	0x006f, 0x007e, 0x008d, 0x009c, 0x00ab, 0x00bb, 0x00cb, 0x00da,
	0x00e9, 0x00f8, 0x0107, 0x0122, 0x013d, 0x0157, 0x0172, 0x018c,
	0x01a7, 0x01c2, 0x01de, 0x01f8, 0x0213, 0x022d, 0x0248, 0x0262,
	0x027d, 0x02a1, 0x02c5, 0x02e0, 0x02f7, 0x030e, 0x0321, 0x0333,
	0x0346, 0x0358, 0x036b, 0x037d, 0x0390, 0x03a3, 0x03b6, 0x03c9,
	0x03dc, 0x03ee, 0x0401, 0x0414, 0x0427, 0x043a, 0x044c, 0x045e,
	0x0476, 0x048c, 0x049e, 0x04af, 0x04bf, 0x04d5, 0x04e7, 0x04f7,
	0x050f, 0x0520, 0x0530, 0x0545, 0x0554, 0x0569, 0x0583, 0x0595,
	// Entry 14C0 - 14FF
	0x05a6, 0x05bc, 0x05ce, 0x05e8, 0x0600, 0x0613, 0x0623, 0x0632,
	0x0641, 0x0652, 0x0662, 0x0672, 0x0681, 0x0692, 0x06a3, 0x06b3,
	0x06cd, 0x06e8, 0x0702, 0x071c, 0x0737, 0x0752, 0x0772, 0x0791,
	0x07b0, 0x07d0, 0x07df, 0x07f1, 0x0800, 0x0813, 0x0822, 0x0835,
	0x084f, 0x0876, 0x088c, 0x08a6, 0x08b6, 0x08db, 0x0900, 0x0927,
	0x0940, 0x0954, 0x0967, 0x097a, 0x098f, 0x09a3, 0x09b7, 0x09ca,
	0x09df, 0x09f4, 0x0a08, 0x0a1a, 0x0a2c, 0x0a3e, 0x0a50, 0x0a62,
	0x0a75, 0x0a88, 0x0a9b, 0x0aae, 0x0ac2, 0x0ad5, 0x0ae8, 0x0afb,
	// Entry 1500 - 153F
	0x0b0e, 0x0b21, 0x0b34, 0x0b47, 0x0b5b, 0x0b6e, 0x0b81, 0x0b95,
	0x0ba8, 0x0bbb, 0x0bce, 0x0be1, 0x0bf4, 0x0c07, 0x0c1b, 0x0c2f,
	0x0c42, 0x0c56, 0x0c6a, 0x0c7e, 0x0c92, 0x0ca6, 0x0ccb, 0x0ce2,
	0x0cf9, 0x0d10, 0x0d27, 0x0d3f, 0x0d57, 0x0d70, 0x0d88, 0x0da0,
	0x0db8, 0x0dd0, 0x0de8, 0x0e00, 0x0e18, 0x0e31, 0x0e49, 0x0e62,
	0x0e7a, 0x0e92, 0x0eaa, 0x0ec3, 0x0edc, 0x0ef5, 0x0f0e, 0x0f27,
	0x0f3e, 0x0f55, 0x0f6d, 0x0f85, 0x0f9c, 0x0fb5, 0x0fcd, 0x0fe5,
	0x0ffd, 0x1015, 0x102e, 0x1046, 0x105e, 0x1076, 0x108e, 0x10a7,
	// Entry 1540 - 157F
	0x10c0, 0x10d9, 0x10f1, 0x110a, 0x1123, 0x113c, 0x1155, 0x116f,
	0x1189, 0x11a3, 0x11be, 0x11e4, 0x1209, 0x1229, 0x124a, 0x1274,
	0x1294, 0x12ba, 0x12d5, 0x12f0, 0x130c, 0x1329, 0x1345, 0x1362,
	0x1380, 0x139d, 0x13ba, 0x13d6, 0x13f2, 0x140e, 0x142b, 0x1448,
	0x1465, 0x1481, 0x149d, 0x14be, 0x14e0, 0x1504, 0x1528, 0x154b,
	0x156f, 0x1593, 0x15b8, 0x15db, 0x15ff, 0x1623, 0x1647, 0x166b,
	0x168e, 0x16ae, 0x16cf, 0x16f3, 0x1714, 0x1738, 0x174d, 0x1762,
	0x1778, 0x178e, 0x17a4, 0x17ba, 0x17d1, 0x17e7, 0x17fd, 0x1814,
	// Entry 1580 - 15BF
	0x182a, 0x1840, 0x1856, 0x186c, 0x1882, 0x1898, 0x18af, 0x18c6,
	0x18de, 0x18f4, 0x190a, 0x1920, 0x1936, 0x1954, 0x196b, 0x198a,
	0x19a0, 0x19be, 0x19d5, 0x19f4, 0x1a0b, 0x1a21, 0x1a38, 0x1a4e,
	0x1a65, 0x1a7b, 0x1a97, 0x1ab3, 0x1acf, 0x1aeb, 0x1b07, 0x1b23,
	0x1b3f, 0x1b5c, 0x1b78, 0x1b94, 0x1bb7, 0x1bda, 0x1bf7, 0x1c17,
	0x1c37, 0x1c4e, 0x1c65, 0x1c7d, 0x1c95, 0x1cad, 0x1cc5, 0x1cdd,
	0x1cfb, 0x1d19, 0x1d36, 0x1d54, 0x1d77, 0x1d95, 0x1db3, 0x1dd0,
	0x1dee, 0x1e0e, 0x1e2e, 0x1e51, 0x1e6b, 0x1e7a, 0x1e8a, 0x1e99,
	// Entry 15C0 - 15FF
	0x1ea9, 0x1eb9, 0x1ec8, 0x1ed8, 0x1ee7, 0x1ef7, 0x1f07, 0x1f16,
	0x1f26, 0x1f35, 0x1f45, 0x1f54, 0x1f63, 0x1f73, 0x1f82, 0x1f92,
	0x1fa1, 0x1fb0, 0x1fbf, 0x1fce, 0x1fdd, 0x1fed, 0x1ffd, 0x200c,
	0x201b, 0x202c, 0x203c, 0x204e, 0x2060, 0x2072, 0x2085, 0x2098,
	0x20ab, 0x20be, 0x20d0, 0x20e2, 0x20fb, 0x2114, 0x212d, 0x2142,
	0x2158, 0x2173, 0x2188, 0x219d, 0x21b2, 0x21c7, 0x21dc, 0x21f1,
	0x2205, 0x2219, 0x2228, 0x2236, 0x224c, 0x225f, 0x226f, 0x227e,
	0x228d, 0x229e, 0x22ae, 0x22be, 0x22cd, 0x22de, 0x22ef, 0x22ff,
	// Entry 1600 - 163F
	0x230f, 0x231f, 0x2330, 0x2341, 0x2351, 0x2361, 0x2371, 0x2382,
	0x2392, 0x23a2, 0x23b3, 0x23c3, 0x23d3, 0x23e3, 0x23f3, 0x2403,
	0x2414, 0x2426, 0x2436, 0x2445, 0x2454, 0x2464, 0x2474, 0x2483,
	0x2493, 0x24a2, 0x24b2, 0x24c1, 0x24d2, 0x24e2, 0x24f6, 0x250a,
	0x251e, 0x2532, 0x2546, 0x2560, 0x2579, 0x2593, 0x25ad, 0x25c8,
	0x25e1, 0x25fa, 0x2614, 0x262f, 0x2649, 0x2663, 0x267d, 0x2696,
	0x26af, 0x26c9, 0x26e4, 0x26fe, 0x2717, 0x2731, 0x274a, 0x2764,
	0x277f, 0x2799, 0x27b2, 0x27cc, 0x27e5, 0x27ff, 0x2819, 0x2833,
	// Entry 1640 - 167F
	0x284c, 0x2865, 0x287e, 0x2898, 0x28b2, 0x28cc, 0x28e5, 0x28fe,
	0x2917, 0x2932, 0x294d, 0x2967, 0x2981, 0x299c, 0x29b6, 0x29dc,
	0x29f5, 0x2a0e, 0x2a26, 0x2a3f, 0x2a57, 0x2a70, 0x2a88, 0x2aa1,
	0x2aba, 0x2ad3, 0x2aed, 0x2b06, 0x2b1f, 0x2b39, 0x2b53, 0x2b6c,
	0x2b86, 0x2ba1, 0x2bbb, 0x2bd5, 0x2bef, 0x2c09, 0x2c23, 0x2c3a,
	0x2c51, 0x2c67, 0x2c7c, 0x2c91, 0x2ca8, 0x2cbe, 0x2cd4, 0x2ce9,
	0x2d00, 0x2d17, 0x2d2d, 0x2d47, 0x2d5b, 0x2d70, 0x2d87, 0x2d9d,
	0x2db2, 0x2dc7, 0x2ddd, 0x2df3, 0x2e0e, 0x2e28, 0x2e42, 0x2e5d,
	// Entry 1680 - 16BF
	0x2e72, 0x2e8c, 0x2ea5, 0x2ebe, 0x2ed8, 0x2ef2, 0x2f08, 0x2f1d,
	0x2f31, 0x2f45, 0x2f5a, 0x2f6f, 0x2f89, 0x2fa2, 0x2fbb, 0x2fd5,
	0x2fe9, 0x3002, 0x301a, 0x3032, 0x304b, 0x3064, 0x3076, 0x3088,
	0x309b, 0x30af, 0x30c1, 0x30d3, 0x30e5, 0x30f8, 0x310a, 0x311c,
	0x312e, 0x3141, 0x3153, 0x3165, 0x3178, 0x318c, 0x319e, 0x31b0,
	0x31c2, 0x31d4, 0x31e6, 0x31f7, 0x3209, 0x321e, 0x3233, 0x3248,
	0x325d, 0x3273, 0x3283, 0x329a, 0x32b1, 0x32c9, 0x32e1, 0x32f7,
	0x330e, 0x3325, 0x3338, 0x334f, 0x3367, 0x337d, 0x3393, 0x33aa,
	// Entry 16C0 - 16FF
	0x33bd, 0x33d1, 0x33eb, 0x33fd, 0x3416, 0x342a, 0x3441, 0x3459,
	0x346f, 0x3486, 0x3498, 0x34aa, 0x34c1, 0x34d9, 0x34f0, 0x3506,
	0x351c, 0x3533, 0x3545, 0x355b, 0x3572, 0x3584, 0x3597, 0x35a9,
	0x35bc, 0x35ce, 0x35e6, 0x35fe, 0x3615, 0x362c, 0x363f, 0x3650,
	0x3666, 0x3677, 0x3689, 0x369a, 0x36ac, 0x36be, 0x36d0, 0x36e3,
	0x36fb, 0x371c, 0x373d, 0x3760, 0x377a, 0x379b, 0x37b9, 0x37e5,
	0x37ff, 0x3819, 0x3833, 0x3846, 0x385b, 0x3876, 0x388c, 0x38a7,
	0x38bc, 0x38d2, 0x38e8, 0x38ff, 0x3914, 0x392a, 0x393f, 0x395b,
	// Entry 1700 - 173F
	0x3971, 0x3986, 0x399c, 0x39b2, 0x39c8, 0x39e3, 0x39ff, 0x3a15,
	0x3a29, 0x3a3d, 0x3a57, 0x3a71, 0x3a8b, 0x3aa0, 0x3ab5, 0x3ad2,
	0x3af6, 0x3b0e, 0x3b25, 0x3b3c, 0x3b55, 0x3b6d, 0x3b85, 0x3b9c,
	0x3bb5, 0x3bce, 0x3be6, 0x3bfe, 0x3c15, 0x3c2c, 0x3c45, 0x3c5d,
	0x3c75, 0x3c8c, 0x3ca5, 0x3cbe, 0x3cd6, 0x3ce9, 0x3d00, 0x3d13,
	0x3d25, 0x3d36, 0x3d4a, 0x3d6d, 0x3d84, 0x3d96, 0x3dab, 0x3dc0,
	0x3dd8, 0x3dea, 0x3dfd, 0x3e20, 0x3e38, 0x3e4a, 0x3e63, 0x3e77,
	0x3e8a, 0x3ea5, 0x3ebe, 0x3ede, 0x3f09, 0x3f35, 0x3f50, 0x3f72,
	// Entry 1740 - 177F
	0x3f8d, 0x3faa, 0x3fc1, 0x3fd9, 0x3fec, 0x4000, 0x4013, 0x4028,
	0x4044, 0x4059, 0x4075, 0x408a, 0x40a6, 0x40bd, 0x40db, 0x40f3,
	0x4112, 0x4127, 0x413d, 0x4152, 0x416e, 0x4180, 0x419c, 0x41ae,
	0x41c5, 0x41d8, 0x41ea, 0x4201, 0x4213, 0x422a, 0x423d, 0x4255,
	0x4277, 0x4299, 0x42bb, 0x42d4, 0x42e6, 0x42fd, 0x430f, 0x4326,
	0x4338, 0x434a, 0x4362, 0x4374, 0x438e, 0x43a0, 0x43b2, 0x43c4,
	0x43d6, 0x43e8, 0x43ff, 0x4416, 0x4428, 0x443a, 0x444f, 0x4469,
	0x4480, 0x449c, 0x44b4, 0x44d1, 0x44ec, 0x450e, 0x452a, 0x454d,
	// Entry 1780 - 17BF
	0x4567, 0x4586, 0x45a7, 0x45cd, 0x45e6, 0x4606, 0x4618, 0x4631,
	0x464b, 0x4665, 0x467d, 0x4695, 0x46ae, 0x46ca, 0x46dd, 0x46ef,
	0x4701, 0x4715, 0x4728, 0x473b, 0x474d, 0x4761, 0x4775, 0x4788,
	0x4796, 0x47a5, 0x47b3, 0x47cb, 0x47de, 0x47f4, 0x4805, 0x4821,
	0x483d, 0x4859, 0x4875, 0x4898, 0x48b4, 0x48d1, 0x48ee, 0x490b,
	0x492c, 0x4953, 0x497a, 0x49a2, 0x49ca, 0x49f3, 0x4a28, 0x4a5d,
	0x4a84, 0x4aaa, 0x4ad5, 0x4b00, 0x4b2d, 0x4b5a, 0x4b85, 0x4bb0,
	0x4bdd, 0x4c0a, 0x4c35, 0x4c4c, 0x4c64, 0x4c7c, 0x4c8e, 0x4ca0,
	// Entry 17C0 - 17FF
	0x4cb2, 0x4cc5, 0x4cd7, 0x4ce9, 0x4cfc, 0x4d0f, 0x4d22, 0x4d35,
	0x4d49, 0x4d5c, 0x4d6f, 0x4d82, 0x4d96, 0x4da9, 0x4dbc, 0x4dcf,
	0x4de2, 0x4df5, 0x4e08, 0x4e1b, 0x4e2e, 0x4e41, 0x4e54, 0x4e67,
	0x4e7a, 0x4e8d, 0x4ea0, 0x4eb3, 0x4ed5, 0x4ef6, 0x4f16, 0x4f33,
	0x4f4f, 0x4f6e, 0x4f8b, 0x4fa7, 0x4fc6, 0x4fdc, 0x4ff1, 0x5015,
	0x5039, 0x504d, 0x5061, 0x5075, 0x5088, 0x509b, 0x50b0, 0x50c4,
	0x50d8, 0x50eb, 0x5100, 0x5115, 0x5129, 0x513b, 0x514f, 0x5163,
	0x5177, 0x518f, 0x51a7, 0x51b5, 0x51ce, 0x51dd, 0x51f7, 0x5211,
	// Entry 1800 - 183F
	0x5220, 0x5234, 0x5243, 0x525d, 0x526c, 0x5286, 0x5295, 0x52af,
	0x52c5, 0x52d4, 0x52ee, 0x52fd, 0x530c, 0x531b, 0x5335, 0x5344,
	0x535e, 0x5376, 0x538e, 0x539d, 0x53b7, 0x53d1, 0x53e0, 0x53fa,
	0x540a, 0x5419, 0x5433, 0x5443, 0x5452, 0x5462, 0x5472, 0x5480,
	0x548e, 0x549e, 0x54b0, 0x54c9, 0x54dc, 0x54ee, 0x5505, 0x5517,
	0x552e, 0x5540, 0x5564, 0x557b, 0x5591, 0x559f, 0x55af, 0x55ca,
	0x55e7, 0x55ff, 0x561a, 0x562a, 0x563b, 0x564c, 0x565c, 0x566d,
	0x567e, 0x568e, 0x569f, 0x56af, 0x56c0, 0x56d0, 0x56e1, 0x56f1,
	// Entry 1840 - 187F
	0x5701, 0x5711, 0x5722, 0x5733, 0x5743, 0x5754, 0x5764, 0x5775,
	0x5785, 0x5796, 0x57a7, 0x57b9, 0x57ca, 0x57da, 0x57ea, 0x57fa,
	0x580a, 0x581b, 0x582b, 0x583b, 0x584c, 0x585c, 0x586b, 0x5885,
	0x589f, 0x58b3, 0x58c6, 0x58d9, 0x58ed, 0x5900, 0x5914, 0x5927,
	0x593e, 0x5955, 0x596c, 0x5983, 0x599a, 0x59b1, 0x59c8, 0x59e5,
	0x59ff, 0x5a0e, 0x5a1f, 0x5a38, 0x5a5d, 0x5a76, 0x5a96, 0x5aaf,
	0x5ac0, 0x5ad0, 0x5ae0, 0x5af2, 0x5b03, 0x5b14, 0x5b24, 0x5b36,
	0x5b48, 0x5b59, 0x5b6a, 0x5b7c, 0x5b8d, 0x5ba0, 0x5bb2, 0x5bc4,
	// Entry 1880 - 18BF
	0x5bd8, 0x5beb, 0x5bfe, 0x5c10, 0x5c24, 0x5c38, 0x5c4b, 0x5c5d,
	0x5c6f, 0x5c81, 0x5c94, 0x5ca6, 0x5cb9, 0x5ccc, 0x5cdf, 0x5cf2,
	0x5d05, 0x5d17, 0x5d29, 0x5d3b, 0x5d4e, 0x5d60, 0x5d72, 0x5d84,
	0x5d96, 0x5da9, 0x5dbb, 0x5dcd, 0x5ddf, 0x5df2, 0x5e04, 0x5e17,
	0x5e29, 0x5e3c, 0x5e4e, 0x5e60, 0x5e72, 0x5e85, 0x5e9e, 0x5eba,
	0x5ec8, 0x5ed9, 0x5ee6, 0x5f01, 0x5f23, 0x5f43, 0x5f67, 0x5f85,
	0x5fa2, 0x5fbf, 0x5fe4, 0x6008, 0x6026, 0x6048, 0x6069, 0x608d,
	0x60b0, 0x60d1, 0x60f8, 0x611e, 0x6144, 0x616a, 0x617d, 0x618d,
	// Entry 18C0 - 18FF
	0x619f, 0x61b3, 0x61d8, 0x620c, 0x6235, 0x6266, 0x627d, 0x62b8,
	0x62d1, 0x62ea, 0x6305, 0x6319, 0x6332, 0x634d, 0x637d, 0x63a8,
	0x63c2, 0x63db, 0x63fd, 0x6418, 0x643c, 0x645f, 0x6484, 0x64a4,
	0x64c4, 0x64e3, 0x650c, 0x651d, 0x653e, 0x6556, 0x6575, 0x6597,
	0x65ae, 0x65cd, 0x65e4, 0x65fa, 0x6610, 0x6623, 0x6638, 0x6654,
	0x6670, 0x668d, 0x66a9, 0x66cc, 0x66e8, 0x6704, 0x6722, 0x673e,
	0x675e, 0x6779, 0x6795, 0x67b1, 0x67d9, 0x67f5, 0x681a, 0x6836,
	0x6857, 0x6874, 0x6896, 0x68bf, 0x68db, 0x68f8, 0x6915, 0x6935,
	// Entry 1900 - 193F
	0x6951, 0x6976, 0x6999, 0x69b5, 0x69d1, 0x69ee, 0x6a17, 0x6a3b,
	0x6a57, 0x6a73, 0x6a8f, 0x6aad, 0x6ad2, 0x6ae2, 0x6b02, 0x6b22,
	0x6b3f, 0x6b5d, 0x6b7b, 0x6b9b, 0x6bb4, 0x6bce, 0x6be7, 0x6c07,
	0x6c20, 0x6c39, 0x6c5b, 0x6c74, 0x6c8d, 0x6ca6, 0x6cbf, 0x6cd8,
	0x6cf1, 0x6d0a, 0x6d23, 0x6d45, 0x6d5e, 0x6d78, 0x6d91, 0x6daa,
	0x6dc3, 0x6ddc, 0x6df5, 0x6e0c, 0x6e2a, 0x6e45, 0x6e64, 0x6e7b,
	0x6e92, 0x6ea9, 0x6ec4, 0x6ee0, 0x6f03, 0x6f1a, 0x6f38, 0x6f4f,
	0x6f66, 0x6f7f, 0x6f96, 0x6fb2, 0x6fd2, 0x6ff5, 0x700c, 0x7023,
	// Entry 1940 - 197F
	0x703a, 0x705a, 0x7078, 0x708f, 0x70a8, 0x70c2, 0x70e3, 0x70fe,
	0x711d, 0x7136, 0x7154, 0x7172, 0x7190, 0x71ae, 0x71cf, 0x71f1,
	0x7211, 0x7231, 0x7251, 0x7266, 0x728c, 0x72b2, 0x72d8, 0x72fe,
	0x7324, 0x734a, 0x7370, 0x73a3, 0x73c9, 0x73ef, 0x7415, 0x7430,
	0x744b, 0x7467, 0x748f, 0x74b7, 0x74da, 0x74fa, 0x7522, 0x7548,
	0x756e, 0x7594, 0x75ba, 0x75e0, 0x7606, 0x762c, 0x7652, 0x7678,
	0x769e, 0x76c4, 0x76ea, 0x7712, 0x7738, 0x775e, 0x7784, 0x77ac,
	0x77d8, 0x77ff, 0x7827, 0x7854, 0x788a, 0x78b6, 0x78de, 0x790b,
	// Entry 1980 - 19BF
	0x7935, 0x795d, 0x7987, 0x79a9, 0x79c0, 0x79e1, 0x79fa, 0x7a1f,
	0x7a36, 0x7a61, 0x7a7f, 0x7a9d, 0x7ac0, 0x7ada, 0x7af9, 0x7b24,
	0x7b4d, 0x7b78, 0x7ba1, 0x7bc0, 0x7be1, 0x7c0d, 0x7c33, 0x7c5e,
	0x7c7d, 0x7c9b, 0x7cb4, 0x7cd5, 0x7cee, 0x7d17, 0x7d32, 0x7d4f,
	0x7d6e, 0x7d8f, 0x7dad, 0x7dc4, 0x7def, 0x7e10, 0x7e29, 0x7e44,
	0x7e61, 0x7e7e, 0x7e93, 0x7eac, 0x7ec2, 0x7ed8, 0x7eee, 0x7f04,
	0x7f1f, 0x7f3a, 0x7f5e, 0x7f74, 0x7f8a, 0x7fab, 0x7fc1, 0x7fd7,
	0x7fe9, 0x7ffb, 0x800d, 0x8040, 0x805f, 0x807e, 0x809d, 0x80c3,
	// Entry 19C0 - 19FF
	0x80e9, 0x8109, 0x8127, 0x814d, 0x816b, 0x8189, 0x81af, 0x81d5,
	0x81f3, 0x8219, 0x823f, 0x8265, 0x8283, 0x82a6, 0x82c4, 0x82e6,
	0x8304, 0x8325, 0x8347, 0x8365, 0x839c, 0x83db, 0x83f9, 0x8419,
	0x8458, 0x8476, 0x84a3, 0x84d0, 0x84fd, 0x8514, 0x8530, 0x854b,
	0x8563, 0x8587, 0x859e, 0x85c3, 0x85e2, 0x8600, 0x8632, 0x8658,
	0x867c, 0x86a1, 0x86c4, 0x86e9, 0x870c, 0x8732, 0x8756, 0x8783,
	0x87ae, 0x87d3, 0x87f6, 0x881b, 0x883e, 0x8864, 0x8888, 0x88ab,
	0x88cc, 0x88f8, 0x8922, 0x894e, 0x8978, 0x89a4, 0x89ce, 0x89fa,
	// Entry 1A00 - 1A3F
	0x8a24, 0x8a4b, 0x8a70, 0x8a9d, 0x8ac8, 0x8aed, 0x8b10, 0x8b32,
	0x8b52, 0x8b77, 0x8b9a, 0x8bbf, 0x8be2, 0x8c07, 0x8c2a, 0x8c4d,
	0x8c6e, 0x8c95, 0x8cba, 0x8ce1, 0x8d06, 0x8d35, 0x8d62, 0x8d83,
	0x8da2, 0x8dc7, 0x8dea, 0x8e10, 0x8e34, 0x8e59, 0x8e7c, 0x8eac,
	0x8eda, 0x8f00, 0x8f24, 0x8f50, 0x8f7a, 0x8f9b, 0x8fba, 0x8fdf,
	0x9002, 0x9027, 0x904a, 0x906f, 0x9092, 0x90b7, 0x90da, 0x9100,
	0x9124, 0x9150, 0x917a, 0x91a5, 0x91ce, 0x91fd, 0x922a, 0x9256,
	0x9280, 0x92ac, 0x92d6, 0x92f7, 0x9316, 0x933b, 0x935e, 0x9383,
	// Entry 1A40 - 1A7F
	0x93a6, 0x93cb, 0x93ee, 0x941e, 0x944c, 0x9472, 0x9496, 0x94bb,
	0x94de, 0x9503, 0x9526, 0x9555, 0x9582, 0x95b1, 0x95de, 0x9611,
	0x9642, 0x9667, 0x968a, 0x96af, 0x96d2, 0x96f8, 0x971c, 0x9748,
	0x9772, 0x979d, 0x97c6, 0x97ed, 0x9812, 0x983e, 0x9868, 0x9893,
	0x98bc, 0x98ec, 0x991a, 0x993b, 0x995a, 0x997f, 0x99a2, 0x99c3,
	0x99e2, 0x9a03, 0x9a22, 0x9a47, 0x9a6a, 0x9a8f, 0x9ab2, 0x9ad7,
	0x9afa, 0x9b1f, 0x9b42, 0x9b67, 0x9b8a, 0x9baf, 0x9bd2, 0x9bf8,
	0x9c1c, 0x9c41, 0x9c64, 0x9c8a, 0x9cae, 0x9cd2, 0x9cf5, 0x9d19,
	// Entry 1A80 - 1ABF
	0x9d3d, 0x9d66, 0x9d8e, 0x9dbc, 0x9de6, 0x9e02, 0x9e1a, 0x9e3f,
	0x9e62, 0x9e88, 0x9eac, 0x9edc, 0x9f0a, 0x9f3a, 0x9f68, 0x9f9d,
	0x9fd0, 0xa000, 0xa02e, 0xa062, 0xa094, 0xa0bf, 0xa0e8, 0xa113,
	0xa13c, 0xa16c, 0xa19a, 0xa1c5, 0xa1ee, 0xa21d, 0xa24a, 0xa26f,
	0xa292, 0xa2b8, 0xa2dc, 0xa2fd, 0xa31c, 0xa34c, 0xa37a, 0xa3aa,
	0xa3d8, 0xa40d, 0xa440, 0xa470, 0xa49e, 0xa4d2, 0xa504, 0xa52a,
	0xa54e, 0xa573, 0xa596, 0xa5bb, 0xa5de, 0xa604, 0xa628, 0xa658,
	0xa686, 0xa6b6, 0xa6e4, 0xa719, 0xa74c, 0xa77c, 0xa7aa, 0xa7de,
	// Entry 1AC0 - 1AFF
	0xa810, 0xa83a, 0xa862, 0xa88c, 0xa8b4, 0xa8e3, 0xa910, 0xa93a,
	0xa962, 0xa990, 0xa9bc, 0xa9e1, 0xaa04, 0xaa2a, 0xaa4e, 0xaa78,
	0xaaa0, 0xaaca, 0xaaf2, 0xab21, 0xab4e, 0xab78, 0xaba0, 0xabce,
	0xabfa, 0xac1b, 0xac3a, 0xac5f, 0xac82, 0xaca8, 0xaccc, 0xaced,
	0xad0c, 0xad30, 0xad52, 0xad75, 0xad96, 0xadb6, 0xadd4, 0xadf7,
	0xae1a, 0xae47, 0xae74, 0xaea0, 0xaecc, 0xaeff, 0xaf32, 0xaf57,
	0xaf7c, 0xafab, 0xafda, 0xb008, 0xb036, 0xb06b, 0xb0a0, 0xb0c5,
	0xb0ea, 0xb119, 0xb148, 0xb176, 0xb1a4, 0xb1cb, 0xb1f2, 0xb223,
	// Entry 1B00 - 1B3F
	0xb254, 0xb284, 0xb2b4, 0xb2d5, 0xb2f6, 0xb321, 0xb34c, 0xb376,
	0xb3a0, 0xb3d1, 0xb402, 0xb425, 0xb448, 0xb475, 0xb4a2, 0xb4ce,
	0xb4fa, 0xb52d, 0xb560, 0xb582, 0xb5a4, 0xb5d0, 0xb5fc, 0xb627,
	0xb652, 0xb684, 0xb6b6, 0xb6da, 0xb6fe, 0xb72c, 0xb75a, 0xb787,
	0xb7b4, 0xb7e8, 0xb81c, 0xb841, 0xb866, 0xb895, 0xb8c4, 0xb8f2,
	0xb920, 0xb947, 0xb96e, 0xb99f, 0xb9d0, 0xba00, 0xba30, 0xba55,
	0xba7a, 0xbaa9, 0xbad8, 0xbb06, 0xbb34, 0xbb69, 0xbb9e, 0xbbc5,
	0xbbf6, 0xbc26, 0xbc5d, 0xbc80, 0xbca3, 0xbcd0, 0xbcfd, 0xbd29,
	// Entry 1B40 - 1B7F
	0xbd55, 0xbd88, 0xbdbb, 0xbde0, 0xbe05, 0xbe34, 0xbe63, 0xbe91,
	0xbebf, 0xbef4, 0xbf29, 0xbf4c, 0xbf6e, 0xbf93, 0xbfb7, 0xbfd8,
	0xbff8, 0xc01a, 0xc03b, 0xc060, 0xc084, 0xc0a9, 0xc0cd, 0xc0f0,
	0xc112, 0xc147, 0xc17c, 0xc1bb, 0xc1fa, 0xc238, 0xc276, 0xc2bb,
	0xc300, 0xc338, 0xc370, 0xc3b2, 0xc3f4, 0xc435, 0xc476, 0xc4be,
	0xc506, 0xc539, 0xc56c, 0xc5a9, 0xc5e6, 0xc622, 0xc65e, 0xc6a1,
	0xc6e4, 0xc71a, 0xc750, 0xc790, 0xc7d0, 0xc80f, 0xc84e, 0xc894,
	0xc8da, 0xc90f, 0xc944, 0xc983, 0xc9c2, 0xca00, 0xca3e, 0xca83,
	// Entry 1B80 - 1BBF
	0xcac8, 0xcb00, 0xcb38, 0xcb7a, 0xcbbc, 0xcbfd, 0xcc3e, 0xcc86,
	0xccce, 0xccf2, 0xcd16, 0xcd4b, 0xcd76, 0xcdaa, 0xcdd3, 0xce0e,
	0xce34, 0xce5a, 0xce7f, 0xcea3, 0xced1, 0xcede, 0xcef2, 0xcefd,
	0xcf0e, 0xcf2d, 0xcf60, 0xcf89, 0xcfbb, 0xcfe2, 0xd01b, 0xd042,
	0xd068, 0xd08b, 0xd0ad, 0xd0d9, 0xd0ee, 0xd102, 0xd11d, 0xd140,
	0xd163, 0xd193, 0xd1c2, 0xd1ea, 0xd220, 0xd245, 0xd26a, 0xd28e,
	0xd2b1, 0xd2c6, 0xd2da, 0xd2f5, 0xd31b, 0xd341, 0xd374, 0xd3a6,
	0xd3c7, 0xd3e8, 0xd413, 0xd44c, 0xd474, 0xd49c, 0xd4c3, 0xd4e9,
	// Entry 1BC0 - 1BFF
	0xd50c, 0xd525, 0xd53d, 0xd548, 0xd57d, 0xd5a8, 0xd5dc, 0xd605,
	0xd640, 0xd667, 0xd68d, 0xd6b2, 0xd6d6, 0xd704, 0xd70e, 0xd719,
	0xd720, 0xd727, 0xd72f, 0xd737, 0xd749, 0xd75a, 0xd76a, 0xd776,
	0xd787, 0xd791, 0xd79b, 0xd7ab, 0xd7c0, 0xd7d1, 0xd7e3, 0xd7f5,
	0xd7fb, 0xd80e, 0xd819, 0xd820, 0xd827, 0xd835, 0xd849, 0xd858,
	0xd872, 0xd88d, 0xd8a8, 0xd8cd, 0xd8e7, 0xd902, 0xd91d, 0xd942,
	0xd948, 0xd955, 0xd95b, 0xd96c, 0xd97a, 0xd988, 0xd99b, 0xd9ac,
	0xd9ba, 0xd9cd, 0xd9e4, 0xd9fb, 0xda15, 0xda2b, 0xda41, 0xda56,
	// Entry 1C00 - 1C3F
	0xda64, 0xda79, 0xda7e, 0xda8a, 0xda96, 0xdaa4, 0xdab9, 0xdace,
	0xdad3, 0xdafc, 0xdb26, 0xdb34, 0xdb4b, 0xdb56, 0xdb5e, 0xdb66,
	0xdb73, 0xdb88, 0xdb90, 0xdb9d, 0xdbab, 0xdbc9, 0xdbe8, 0xdbfc,
	0xdc15, 0xdc2e, 0xdc3e, 0xdc53, 0xdc69, 0xdc80, 0xdc8c, 0xdc9e,
	0xdca6, 0xdcc6, 0xdcdb, 0xdce5, 0xdcf6, 0xdd0d, 0xdd22, 0xdd31,
	0xdd45, 0xdd59, 0xdd6c, 0xdd79, 0xdd85, 0xdd8d, 0xdd9f, 0xddb8,
	0xddc3, 0xddd7, 0xdde6, 0xddf9, 0xde07, 0xde1c, 0xde31, 0xde45,
	0xde5c, 0xde76, 0xde91, 0xdeac, 0xdec8, 0xdedd, 0xdef1, 0xdf01,
	// Entry 1C40 - 1C7F
	0xdf21, 0xdf31, 0xdf41, 0xdf50, 0xdf61, 0xdf72, 0xdf82, 0xdf97,
	0xdfa8, 0xdfbf, 0xdfdb, 0xdff8, 0xe018, 0xe026, 0xe033, 0xe040,
	0xe04f, 0xe05d, 0xe06b, 0xe078, 0xe087, 0xe096, 0xe0a4, 0xe0b7,
	0xe0c6, 0xe0db, 0xe0f5, 0xe110, 0xe12e, 0xe14c, 0xe16a, 0xe188,
	0xe1aa, 0xe1c8, 0xe1e6, 0xe204, 0xe222, 0xe240, 0xe25e, 0xe27c,
	0xe29a, 0xe2ac, 0xe2b6, 0xe2c3, 0xe2d4, 0xe2dd, 0xe2e6, 0xe2f0,
	0xe2fb, 0xe305, 0xe30d, 0xe31c, 0xe325, 0xe32e, 0xe336, 0xe341,
	0xe34d, 0xe35e, 0xe367, 0xe373, 0xe37f, 0xe38b, 0xe394, 0xe3a7,
	// Entry 1C80 - 1CBF
	0xe3b4, 0xe3be, 0xe3cf, 0xe3e0, 0xe3f0, 0xe3fa, 0xe404, 0xe40d,
	0xe419, 0xe435, 0xe452, 0xe476, 0xe49b, 0xe4be, 0xe4dd, 0xe4f7,
	0xe512, 0xe528, 0xe548, 0xe56c, 0xe586, 0xe59f, 0xe5b9, 0xe5d3,
	0xe5ee, 0xe612, 0xe632, 0xe64c, 0xe666, 0xe692, 0xe6b3, 0xe6db,
	0xe6f3, 0xe70c, 0xe727, 0xe748, 0xe76d, 0xe79d, 0xe7cc, 0xe7e6,
	0xe801, 0xe819, 0xe823, 0xe83b, 0xe852, 0xe860, 0xe872, 0xe879,
	0xe881, 0xe88f, 0xe896, 0xe8a7, 0xe8b5, 0xe8c5, 0xe8db, 0xe8f2,
	0xe901, 0xe91c, 0xe92c, 0xe942, 0xe952, 0xe960, 0xe96e, 0xe985,
	// Entry 1CC0 - 1CFF
	0xe990, 0xe9a9, 0xe9b9, 0xe9d0, 0xe9e7, 0xe9f7, 0xea0d, 0xea24,
	0xea35, 0xea3d, 0xea49, 0xea57, 0xea66, 0xea6e, 0xea85, 0xea8f,
	0xea97, 0xeaa8, 0xeabe, 0xeadc, 0xeae7, 0xeaf4, 0xeb04, 0xeb1a,
	0xeb2a, 0xeb38, 0xeb48, 0xeb58, 0xeb68, 0xeb78, 0xeb86, 0xeb91,
	0xeb9b, 0xeba7, 0xebb3, 0xebc5, 0xebd6, 0xebe4, 0xebfa, 0xec13,
	0xec2e, 0xec46, 0xec63, 0xec7e, 0xec99, 0xecb6, 0xecd1, 0xecef,
	0xed0b, 0xed27, 0xed43, 0xed5f, 0xed6c, 0xed7c, 0xed84, 0xed90,
	0xed9e, 0xedb9, 0xedd4, 0xeded, 0xee06, 0xee1f, 0xee39, 0xee52,
	// Entry 1D00 - 1D3F
	0xee6c, 0xee88, 0xeea3, 0xeebc, 0xeed7, 0xeef1, 0xef0e, 0xef2a,
	0xef47, 0xef5d, 0xef6e, 0xef7f, 0xef92, 0xefa4, 0xefb6, 0xefc7,
	0xefda, 0xefed, 0xefff, 0xf010, 0xf024, 0xf038, 0xf04b, 0xf064,
	0xf07e, 0xf098, 0xf0af, 0xf0c6, 0xf0df, 0xf0f7, 0xf10f, 0xf126,
	0xf13f, 0xf158, 0xf170, 0xf187, 0xf1a1, 0xf1bb, 0xf1d4, 0xf1f3,
	0xf213, 0xf233, 0xf251, 0xf26c, 0xf286, 0xf2a8, 0xf2c5, 0xf2e0,
	0xf2fe, 0xf31a, 0xf33c, 0xf357, 0xf367, 0xf379, 0xf388, 0xf395,
	0xf3a5, 0xf3b4, 0xf3c4, 0xf3d1, 0xf3e1, 0xf3f1, 0xf401, 0xf411,
	// Entry 1D40 - 1D7F
	0xf42c, 0xf448, 0xf45c, 0xf471, 0xf48b, 0xf4a3, 0xf4be, 0xf4d8,
	0xf4f1, 0xf50b, 0xf523, 0xf539, 0xf552, 0xf56a, 0xf581, 0xf59a,
	0xf5b4, 0xf5cd, 0xf5e7, 0xf5fc, 0xf618, 0xf62e, 0xf64e, 0xf66f,
	0xf691, 0xf6b4, 0xf6da, 0xf6ff, 0xf721, 0xf73f, 0xf75b, 0xf78e,
	0xf7ad, 0xf7c8, 0xf7eb, 0xf810, 0xf834, 0xf857, 0xf87b, 0xf8a1,
	0xf8c7, 0xf8ec, 0xf911, 0xf93b, 0xf960, 0xf977, 0xf98c, 0xf9a4,
	0xf9bb, 0xf9e4, 0xfa0d, 0xfa2f, 0xfa52, 0xfa75, 0xfa8b, 0xfa9f,
	0xfab6, 0xfacc, 0xfae3, 0xfaf7, 0xfb0e, 0xfb25, 0xfb3c, 0xfb53,
	// Entry 1D80 - 1DBF
	0xfb69, 0xfb80, 0xfb98, 0xfbb1, 0xfbd1, 0xfbf3, 0xfc09, 0xfc1d,
	0xfc34, 0xfc4a, 0xfc60, 0xfc77, 0xfc8c, 0xfc9f, 0xfcb5, 0xfcca,
	0xfce6, 0xfd05, 0xfd38, 0xfd69, 0xfd83, 0xfda9, 0xfdc9, 0xfde3,
	0xfdfd, 0xfe10, 0xfe2d, 0xfe57, 0xfe6e, 0xfe92, 0xfeb7, 0xfedc,
	0xff07, 0xff33, 0xff5f, 0xff7a, 0xff96, 0xffb2, 0xffb9, 0xffc3,
	0xffd7, 0xffe3, 0xfff7, 0x0000, 0x0009, 0x000e, 0x0018, 0x0029,
	0x0039, 0x004b, 0x0065, 0x007d, 0x0089, 0x0096, 0x00a5, 0x00b4,
	0x00be, 0x00d0, 0x00d8, 0x00e6, 0x00ef, 0x0100, 0x010d, 0x011c,
	// Entry 1DC0 - 1DFF
	0x0127, 0x0130, 0x013b, 0x014a, 0x0152, 0x015d, 0x0162, 0x0170,
	0x017f, 0x0186, 0x0195, 0x01a0, 0x01af, 0x01ba, 0x01c4, 0x01d0,
	0x01d5, 0x01dd, 0x01ec, 0x01fb, 0x020b, 0x021b, 0x022a, 0x023c,
	0x0256, 0x0274, 0x027d, 0x0284, 0x0289, 0x0293, 0x029c, 0x02a2,
	0x02b6, 0x02c0, 0x02ce, 0x02dc, 0x02eb, 0x02f4, 0x0302, 0x030b,
	0x0316, 0x032d, 0x0348, 0x035e, 0x0385, 0x03b0, 0x03bf, 0x03d2,
	0x03ea, 0x03f6, 0x0402, 0x040f, 0x042a, 0x043c, 0x0450, 0x0466,
	0x048c, 0x04ae, 0x04ba, 0x04c6, 0x04d6, 0x04e3, 0x04f1, 0x04fa,
	// Entry 1E00 - 1E3F
	0x0508, 0x0513, 0x0521, 0x0537, 0x0542, 0x0555, 0x0561, 0x056d,
	0x057d, 0x0593, 0x05a8, 0x05c0, 0x05d7, 0x05f1, 0x060b, 0x0628,
	0x0636, 0x0647, 0x064e, 0x065f, 0x066c, 0x067c, 0x069a, 0x06bb,
	0x06d5, 0x06f2, 0x0715, 0x073b, 0x0754, 0x076d, 0x078f, 0x07b1,
	0x07b9, 0x07c1, 0x07d5, 0x07e9, 0x0802, 0x081b, 0x082b, 0x083b,
	0x0844, 0x084f, 0x085e, 0x086f, 0x0884, 0x089b, 0x08bb, 0x08dd,
	0x08f8, 0x0915, 0x091d, 0x0934, 0x0942, 0x0951, 0x0963, 0x097e,
	0x099c, 0x09a6, 0x09b0, 0x09bc, 0x09c9, 0x09d6, 0x09ec, 0x0a00,
	// Entry 1E40 - 1E7F
	0x0a15, 0x0a2e, 0x0a3c, 0x0a48, 0x0a54, 0x0a61, 0x0a6e, 0x0a82,
	0x0a8c, 0x0a95, 0x0a9e, 0x0aa5, 0x0aae, 0x0ab4, 0x0ab8, 0x0abe,
	0x0ae1, 0x0b0b, 0x0b19, 0x0b21, 0x0b2f, 0x0b61, 0x0b78, 0x0b8f,
	0x0ba1, 0x0bbc, 0x0bda, 0x0c01, 0x0c0c, 0x0c14, 0x0c1c, 0x0c36,
	0x0c41, 0x0c44, 0x0c48, 0x0c4b, 0x0c5f, 0x0c6d, 0x0c7e, 0x0c8e,
	0x0ca0, 0x0cab, 0x0cbb, 0x0cc7, 0x0cd4, 0x0ce2, 0x0ce8, 0x0d0d,
	0x0d33, 0x0d4a, 0x0d62, 0x0d77, 0x0d87, 0x0d98, 0x0da5, 0x0db4,
	0x0dc7, 0x0dd3, 0x0ddc, 0x0df1, 0x0e03, 0x0e18, 0x0e2b, 0x0e41,
	// Entry 1E80 - 1EBF
	0x0e63, 0x0e85, 0x0e9a, 0x0eb2, 0x0ec6, 0x0eda, 0x0ef3, 0x0f0c,
	0x0f2b, 0x0f4d, 0x0f6c, 0x0f8e, 0x0fad, 0x0fcf, 0x0fed, 0x100b,
	0x1021, 0x1044, 0x1066, 0x1092, 0x10a3, 0x10be, 0x10d8, 0x10f4,
	0x111a, 0x1152, 0x1190, 0x11a9, 0x11c0, 0x11dd, 0x11f5, 0x121b,
	0x123f, 0x1275, 0x12b1, 0x12c6, 0x12e1, 0x12fa, 0x1307, 0x1315,
	0x131a, 0x1326, 0x1334, 0x133e, 0x1349, 0x1352, 0x135e, 0x136b,
	0x1375, 0x1380, 0x1391, 0x13a1, 0x13af, 0x13bc, 0x13cd, 0x13db,
	0x13de, 0x13e5, 0x13eb, 0x13fd, 0x140f, 0x141e, 0x1434, 0x1443,
	// Entry 1EC0 - 1EFF
	0x1448, 0x1451, 0x1460, 0x1470, 0x1482, 0x1495, 0x14a6, 0x14ba,
	0x14bf, 0x14c4, 0x14ec, 0x14f6, 0x1508, 0x151c, 0x1524, 0x153f,
	0x155b, 0x156c, 0x1578, 0x1584, 0x1596, 0x159e, 0x15aa, 0x15ba,
	0x15c7, 0x15cc, 0x15d7, 0x15e2, 0x15fe, 0x161f, 0x163f, 0x1660,
	0x1682, 0x16a0, 0x16c1, 0x16e3, 0x1703, 0x1722, 0x1745, 0x1765,
	0x1789, 0x17ad, 0x17d4, 0x17f8, 0x181d, 0x1847, 0x1872, 0x1898,
	0x18c0, 0x18e1, 0x1906, 0x1926, 0x1949, 0x196b, 0x1993, 0x19b8,
	0x19d7, 0x19fa, 0x1a18, 0x1a39, 0x1a5d, 0x1a87, 0x1aab, 0x1acf,
	// Entry 1F00 - 1F3F
	0x1af5, 0x1b17, 0x1b3c, 0x1b5d, 0x1b7d, 0x1b9e, 0x1bbe, 0x1be5,
	0x1c08, 0x1c2c, 0x1c4f, 0x1c75, 0x1c9a, 0x1cbf, 0x1ce4, 0x1d10,
	0x1d2f, 0x1d4e, 0x1d69, 0x1d8a, 0x1db2, 0x1dd6, 0x1df9, 0x1e1f,
	0x1e43, 0x1e5d, 0x1e76, 0x1e91, 0x1eb5, 0x1edb, 0x1efe, 0x1f22,
	0x1f3d, 0x1f4b, 0x1f72, 0x1f85, 0x1f90, 0x1fad, 0x1fbd, 0x1fd8,
	0x1ff6, 0x2005, 0x2017, 0x203d, 0x2049, 0x205f, 0x206a, 0x208b,
	0x20a0, 0x20c2, 0x20cd, 0x20de, 0x20ef, 0x2110, 0x2131, 0x2150,
	0x216d, 0x218b, 0x21a3, 0x21bd, 0x21d9, 0x21e6, 0x21ef, 0x2202,
	// Entry 1F40 - 1F7F
	0x2215, 0x2230, 0x224a, 0x2265, 0x2281, 0x229c, 0x22b8, 0x22d8,
	0x22f5, 0x2315, 0x2336, 0x2354, 0x2375, 0x2392, 0x23b1, 0x23ce,
	0x23e5, 0x2403, 0x2423, 0x2441, 0x2453, 0x246c, 0x249b, 0x24ca,
	0x24d7, 0x24e7, 0x24f9, 0x250e, 0x253b, 0x2550, 0x2566, 0x257d,
	0x2593, 0x25a9, 0x25bf, 0x25d5, 0x2602, 0x2632, 0x265d, 0x2693,
	0x26c7, 0x26f4, 0x272c, 0x2762, 0x278a, 0x27be, 0x27f0, 0x281a,
	0x2842, 0x286e, 0x289d, 0x28a8, 0x28b5, 0x28c1, 0x28d8, 0x28e6,
	0x28fe, 0x2916, 0x2933, 0x2950, 0x296a, 0x297a, 0x298c, 0x299e,
	// Entry 1F80 - 1FBF
	0x29aa, 0x29ae, 0x29bd, 0x29cf, 0x29e0, 0x29f4, 0x2a0e, 0x2a2b,
	0x2a3a, 0x2a52, 0x2a5e, 0x2a66, 0x2a70, 0x2a87, 0x2a9e, 0x2ac2,
	0x2ae5, 0x2b06, 0x2b29, 0x2b5f, 0x2b94, 0x2bca, 0x2bd5, 0x2bde,
	0x2be9, 0x2c04, 0x2c27, 0x2c4b, 0x2c6c, 0x2c8f, 0x2ca2, 0x2cb7,
	0x2cce, 0x2cda, 0x2ced, 0x2cfc, 0x2d0e, 0x2d21, 0x2d30, 0x2d4b,
	0x2d63, 0x2d79, 0x2d97, 0x2da9, 0x2dbf, 0x2dce, 0x2de2, 0x2e02,
	0x2e16, 0x2e34, 0x2e48, 0x2e62, 0x2e76, 0x2e89, 0x2ea4, 0x2ec1,
	0x2ede, 0x2efd, 0x2f1b, 0x2f3a, 0x2f55, 0x2f79, 0x2f8a, 0x2fa2,
	// Entry 1FC0 - 1FFF
	0x2fb7, 0x2fc8, 0x2fe1, 0x2ffb, 0x3016, 0x302f, 0x303f, 0x3050,
	0x305c, 0x3064, 0x3076, 0x3090, 0x30ae, 0x30b6, 0x30bf, 0x30c7,
	0x30d8, 0x30e7, 0x30f2, 0x3110, 0x3123, 0x312b, 0x3146, 0x315a,
	0x316b, 0x317c, 0x318f, 0x31a1, 0x31b3, 0x31c4, 0x31d7, 0x31ea,
	0x31fc, 0x320e, 0x3223, 0x3238, 0x324f, 0x3266, 0x327c, 0x3292,
	0x32aa, 0x32c1, 0x32d8, 0x32ed, 0x3304, 0x331b, 0x3334, 0x334c,
	0x3364, 0x337b, 0x3394, 0x33ad, 0x33c5, 0x33dd, 0x33f8, 0x3413,
	0x3430, 0x344d, 0x3469, 0x3485, 0x34a3, 0x34c0, 0x34dd, 0x34f8,
	// Entry 2000 - 203F
	0x350b, 0x351e, 0x3533, 0x3547, 0x355b, 0x356e, 0x3583, 0x3598,
	0x35ac, 0x35c0, 0x35d7, 0x35ee, 0x3607, 0x3620, 0x3638, 0x3650,
	0x366a, 0x3683, 0x369c, 0x36b3, 0x36d5, 0x36f7, 0x3719, 0x373b,
	0x375d, 0x377f, 0x37a1, 0x37c3, 0x37e5, 0x3807, 0x3829, 0x384b,
	0x386d, 0x388f, 0x38b1, 0x38d3, 0x38f5, 0x3917, 0x3939, 0x395b,
	0x397d, 0x399f, 0x39c1, 0x39e3, 0x3a05, 0x3a27, 0x3a45, 0x3a63,
	0x3a81, 0x3a9f, 0x3abd, 0x3adb, 0x3af9, 0x3b17, 0x3b35, 0x3b53,
	0x3b71, 0x3b8f, 0x3bad, 0x3bcb, 0x3be9, 0x3c07, 0x3c25, 0x3c43,
	// Entry 2040 - 207F
	0x3c61, 0x3c7f, 0x3c9d, 0x3cbb, 0x3cd9, 0x3cf7, 0x3d15, 0x3d33,
	0x3d4f, 0x3d6b, 0x3d87, 0x3da3, 0x3dbf, 0x3ddb, 0x3df7, 0x3e13,
	0x3e2f, 0x3e4b, 0x3e67, 0x3e83, 0x3e9f, 0x3ebb, 0x3ed7, 0x3ef3,
	0x3f0f, 0x3f2b, 0x3f47, 0x3f63, 0x3f7f, 0x3f9b, 0x3fb7, 0x3fd3,
	0x3fef, 0x400b, 0x401d, 0x403b, 0x4059, 0x4079, 0x4099, 0x40b8,
	0x40d7, 0x40f8, 0x4118, 0x4138, 0x4156, 0x416e, 0x4186, 0x41a0,
	0x41b9, 0x41d2, 0x41ea, 0x4204, 0x421e, 0x4237, 0x4250, 0x426b,
	0x4288, 0x42a5, 0x42c0, 0x42db, 0x4304, 0x432d, 0x4354, 0x437b,
	// Entry 2080 - 20BF
	0x43a7, 0x43d3, 0x43fd, 0x4427, 0x4448, 0x446f, 0x4496, 0x44b7,
	0x44d7, 0x44fd, 0x4523, 0x4543, 0x4562, 0x4587, 0x45ac, 0x45cb,
	0x45e9, 0x460d, 0x4631, 0x464f, 0x4674, 0x469f, 0x46c9, 0x46f3,
	0x471e, 0x4748, 0x4772, 0x4797, 0x47bb, 0x47e5, 0x480e, 0x4837,
	0x4861, 0x488a, 0x48b3, 0x48d7, 0x48fd, 0x4929, 0x4955, 0x4981,
	0x49ad, 0x49d9, 0x4a05, 0x4a2b, 0x4a4f, 0x4a79, 0x4aa3, 0x4acd,
	0x4af7, 0x4b21, 0x4b4b, 0x4b6f, 0x4b99, 0x4bc9, 0x4bf9, 0x4c29,
	0x4c58, 0x4c87, 0x4cb7, 0x4ce6, 0x4d15, 0x4d44, 0x4d73, 0x4da2,
	// Entry 20C0 - 20FF
	0x4dd1, 0x4e01, 0x4e31, 0x4e5b, 0x4e84, 0x4ead, 0x4ed4, 0x4efb,
	0x4f19, 0x4f35, 0x4f5e, 0x4f87, 0x4fa9, 0x4fd1, 0x4ff9, 0x501a,
	0x5041, 0x5068, 0x5088, 0x50ae, 0x50d4, 0x50f3, 0x5120, 0x514d,
	0x5173, 0x519f, 0x51cb, 0x51f0, 0x521e, 0x524c, 0x5273, 0x529f,
	0x52cb, 0x52f0, 0x5322, 0x5354, 0x537f, 0x53a4, 0x53c8, 0x53ea,
	0x540d, 0x5442, 0x5477, 0x5498, 0x54af, 0x54c4, 0x54dc, 0x54f3,
	0x550a, 0x551f, 0x5537, 0x554e, 0x5575, 0x5599, 0x55c0, 0x55e4,
	0x55f4, 0x560a, 0x5621, 0x563a, 0x564a, 0x5662, 0x567c, 0x5695,
	// Entry 2100 - 213F
	0x569f, 0x56b7, 0x56d0, 0x56e7, 0x56f6, 0x570e, 0x5724, 0x5739,
	0x5749, 0x5754, 0x5760, 0x576a, 0x5780, 0x5796, 0x57a9, 0x57bd,
	0x57d0, 0x5802, 0x5825, 0x5857, 0x588a, 0x589e, 0x58c1, 0x58f4,
	0x5900, 0x590c, 0x592d, 0x5957, 0x5972, 0x598b, 0x59b1, 0x59db,
	0x5a05, 0x5a29, 0x5a3b, 0x5a4d, 0x5a5c, 0x5a6b, 0x5a83, 0x5a9b,
	0x5aae, 0x5ac1, 0x5adb, 0x5af5, 0x5b15, 0x5b35, 0x5b52, 0x5b6f,
	0x5b92, 0x5bb5, 0x5bd1, 0x5bed, 0x5c09, 0x5c25, 0x5c47, 0x5c69,
	0x5c85, 0x5ca1, 0x5cc3, 0x5ce5, 0x5d00, 0x5d1b, 0x5d28, 0x5d35,
	// Entry 2140 - 217F
	0x5d61, 0x5d68, 0x5d6f, 0x5d7b, 0x5d88, 0x5da1, 0x5da9, 0x5db5,
	0x5dd0, 0x5dec, 0x5e08, 0x5e24, 0x5e4a, 0x5e77, 0x5e8d, 0x5ea4,
	0x5eb2, 0x5ec6, 0x5ee5, 0x5f04, 0x5f24, 0x5f45, 0x5f66, 0x5f86,
	0x5f97, 0x5fa8, 0x5fc2, 0x5fdb, 0x5ff4, 0x600e, 0x601a, 0x6035,
	0x6051, 0x607b, 0x60a6, 0x60cf, 0x60f2, 0x611b, 0x6145, 0x6151,
	0x6176, 0x619b, 0x61c1, 0x61e7, 0x620c, 0x6231, 0x6257, 0x627d,
	0x6290, 0x62a4, 0x62b7, 0x62ca, 0x62dd, 0x62f6, 0x630f, 0x6323,
	0x6336, 0x633b, 0x6343, 0x634a, 0x634f, 0x6359, 0x6363, 0x636c,
	// Entry 2180 - 21BF
	0x6378, 0x637b, 0x6389, 0x6398, 0x63a3, 0x63ad, 0x63bc, 0x63cb,
	0x63d5, 0x63ea, 0x63fb, 0x6402, 0x641a, 0x6426, 0x6437, 0x6448,
	0x6450, 0x6474, 0x648d, 0x64a7, 0x64c0, 0x64d7, 0x64f1, 0x650a,
	0x651e, 0x652a, 0x653a, 0x6548, 0x6550, 0x6554, 0x6562, 0x6569,
	0x657a, 0x658c, 0x659d, 0x65a9, 0x65b3, 0x65c4, 0x65d0, 0x65d8,
	0x65ea, 0x65fa, 0x660a, 0x661d, 0x662d, 0x663e, 0x6652, 0x6663,
	0x6672, 0x6685, 0x6697, 0x66a9, 0x66bc, 0x66ce, 0x66df, 0x66e6,
	0x66f1, 0x66f6, 0x66ff, 0x6706, 0x670c, 0x6712, 0x6719, 0x671e,
	// Entry 21C0 - 21FF
	0x6723, 0x6729, 0x672f, 0x6735, 0x6738, 0x673d, 0x6742, 0x674a,
	0x6755, 0x675e, 0x6766, 0x676c, 0x677c, 0x678d, 0x679d, 0x67af,
	0x67c1, 0x67d1, 0x67e1, 0x67f2, 0x6802, 0x6814, 0x6826, 0x6836,
	0x6846, 0x6856, 0x6868, 0x6877, 0x6887, 0x6897, 0x68a9, 0x68b8,
	0x68c3, 0x68cf, 0x68da, 0x68ed, 0x6903, 0x6912, 0x6924, 0x6934,
	0x6945, 0x6956, 0x6970, 0x6994, 0x69b8, 0x69dc, 0x6a00, 0x6a24,
	0x6a48, 0x6a6c, 0x6a92, 0x6ab2, 0x6ac7, 0x6ae6, 0x6afa, 0x6b0b,
	0x6b15, 0x6b1f, 0x6b29, 0x6b33, 0x6b3d, 0x6b47, 0x6b62, 0x6b7c,
	// Entry 2200 - 223F
	0x6b9d, 0x6bbd, 0x6bce, 0x6bde, 0x6bf5, 0x6c0a, 0x6c20, 0x6c36,
	0x6c40, 0x6c4a, 0x6c59, 0x6c5f, 0x6c6d, 0x6c81, 0x6c87, 0x6c8e,
	0x6c94, 0x6c98, 0x6ca7, 0x6cb2, 0x6cbe, 0x6cd1, 0x6ced, 0x6d08,
	0x6d14, 0x6d25, 0x6d38, 0x6d49, 0x6d69, 0x6d7d, 0x6d92, 0x6dbb,
	0x6dd9, 0x6df9, 0x6e0c, 0x6e1f, 0x6e38, 0x6e47, 0x6e55, 0x6e71,
	0x6e77, 0x6e82, 0x6e88, 0x6e8d, 0x6e93, 0x6e97, 0x6e9c, 0x6ea2,
	0x6eb3, 0x6eba, 0x6ec5, 0x6ecd, 0x6edb, 0x6ee6, 0x6eee, 0x6ef9,
	0x6f0b, 0x6f1e, 0x6f30, 0x6f43, 0x6f57, 0x6f67, 0x6f6b, 0x6f78,
	// Entry 2240 - 227F
	0x6f8e, 0x6fa6, 0x6fbe, 0x6fd5, 0x6fe3, 0x6fef, 0x6ff8, 0x6ffc,
	0x7007, 0x701e, 0x7034, 0x703a, 0x7042, 0x7064, 0x7082, 0x70a0,
	0x70b5, 0x70ca, 0x70d9, 0x70fb, 0x710c, 0x711b, 0x714b, 0x7156,
	0x716d, 0x7184, 0x71a2, 0x71cd, 0x71d6, 0x71f7, 0x7217, 0x7229,
	0x723e, 0x724b, 0x7251, 0x7257, 0x7264, 0x7274, 0x7285, 0x729e,
	0x72a6, 0x72b8, 0x72c0, 0x72cc, 0x72d1, 0x72d9, 0x72ec, 0x72f1,
	0x72fa, 0x730a, 0x730e, 0x7322, 0x733c, 0x7345, 0x7358, 0x7386,
	0x739b, 0x73af, 0x73bd, 0x73d1, 0x73df, 0x73f5, 0x740c, 0x7416,
	// Entry 2280 - 22BF
	0x741e, 0x7426, 0x7431, 0x743c, 0x7448, 0x7454, 0x7466, 0x746c,
	0x747e, 0x7487, 0x7490, 0x749a, 0x74aa, 0x74ba, 0x74d0, 0x74d8,
	0x74e6, 0x74fa, 0x750b, 0x751c, 0x7533, 0x753e, 0x7558, 0x756c,
	0x7579, 0x7586, 0x75a3, 0x75bf, 0x75e1, 0x75fa, 0x7611, 0x7628,
	0x7630, 0x764a, 0x765c, 0x7672, 0x7689, 0x769c, 0x76b5, 0x76c2,
	0x76d5, 0x76e3, 0x76f7, 0x770c, 0x7724, 0x773f, 0x7755, 0x7779,
	0x77a3, 0x77bc, 0x77d4, 0x77ec, 0x7810, 0x782e, 0x7853, 0x7861,
	0x786f, 0x7895, 0x78bb, 0x78e2, 0x78eb, 0x7905, 0x791c, 0x7923,
	// Entry 22C0 - 22FF
	0x7930, 0x7947, 0x796f, 0x799d, 0x79a7, 0x79bc, 0x79d7, 0x79fd,
	0x7a23, 0x7a44, 0x7a65, 0x7a81, 0x7a9d, 0x7abc, 0x7ad7, 0x7af4,
	0x7b06, 0x7b19, 0x7b2b, 0x7b5c, 0x7b86, 0x7bb7, 0x7be1, 0x7c0f,
	0x7c3d, 0x7c60, 0x7c7f, 0x7ca4, 0x7cb5, 0x7cd5, 0x7ce1, 0x7cfc,
	0x7d1c, 0x7d3d, 0x7d67, 0x7d92, 0x7dbd, 0x7de9, 0x7e1a, 0x7e4c,
	0x7e76, 0x7ea1, 0x7ecb, 0x7ef6, 0x7f18, 0x7f3b, 0x7f5d, 0x7f7f,
	0x7fa3, 0x7fc6, 0x7fe9, 0x800b, 0x802f, 0x8053, 0x8076, 0x8099,
	0x80bd, 0x80e1, 0x8107, 0x812c, 0x8151, 0x8175, 0x819b, 0x81c1,
	// Entry 2300 - 233F
	0x81e6, 0x820b, 0x8238, 0x8265, 0x8294, 0x82c2, 0x82f0, 0x831d,
	0x834c, 0x837b, 0x83a9, 0x83d7, 0x83f9, 0x8408, 0x8418, 0x842b,
	0x8441, 0x8457, 0x846d, 0x848c, 0x84af, 0x84cf, 0x84f5, 0x851c,
	0x8549, 0x855f, 0x8587, 0x85b2, 0x85cc, 0x85fd, 0x862c, 0x8648,
	0x8674, 0x8697, 0x86b9, 0x86e4, 0x8710, 0x8741, 0x8772, 0x87a5,
	0x87af, 0x87e2, 0x8806, 0x8826, 0x8846, 0x8866, 0x8886, 0x88ac,
	0x88d2, 0x88f8, 0x8918, 0x893f, 0x895c, 0x897f, 0x899d, 0x89ae,
	0x89c5, 0x89f3, 0x8a00, 0x8a0b, 0x8a18, 0x8a33, 0x8a4f, 0x8a61,
	// Entry 2340 - 237F
	0x8a81, 0x8a9b, 0x8abe, 0x8ada, 0x8ae7, 0x8b04, 0x8b17, 0x8b29,
	0x8b47, 0x8b53, 0x8b6d, 0x8b88, 0x8ba2, 0x8bb1, 0x8bc1, 0x8bd0,
	0x8bdd, 0x8bec, 0x8c0b, 0x8c1e, 0x8c2b, 0x8c3a, 0x8c48, 0x8c61,
	0x8c83, 0x8c9e, 0x8ccd, 0x8cfd, 0x8d1d, 0x8d3e, 0x8d64, 0x8d8b,
	0x8daa, 0x8dca, 0x8df0, 0x8e17, 0x8e45, 0x8e74, 0x8e9b, 0x8ec3,
	0x8eda, 0x8ef3, 0x8f14, 0x8f31, 0x8f4e, 0x8f62, 0x8f77, 0x8f8c,
	0x8fa7, 0x8fc3, 0x8fdf, 0x8ffc, 0x901a, 0x903e, 0x9063, 0x9081,
	0x9096, 0x90ac, 0x90c2, 0x90d9, 0x90ef, 0x9106, 0x911d, 0x9135,
	// Entry 2380 - 23BF
	0x914b, 0x9162, 0x9179, 0x9191, 0x91a8, 0x91c0, 0x91d8, 0x91f1,
	0x9207, 0x921e, 0x9235, 0x924d, 0x9264, 0x927c, 0x9294, 0x92ad,
	0x92c4, 0x92dc, 0x92f4, 0x930d, 0x9325, 0x933e, 0x9357, 0x9371,
	0x9387, 0x939e, 0x93b5, 0x93cd, 0x93e4, 0x93fc, 0x9414, 0x942d,
	0x9444, 0x945c, 0x9474, 0x948d, 0x94a5, 0x94be, 0x94d7, 0x94f1,
	0x9508, 0x9520, 0x9538, 0x9551, 0x9569, 0x9582, 0x959b, 0x95b5,
	0x95cd, 0x95e6, 0x95ff, 0x9619, 0x9632, 0x964c, 0x9666, 0x9681,
	0x9697, 0x96ae, 0x96c5, 0x96dd, 0x96f4, 0x970c, 0x9724, 0x973d,
	// Entry 23C0 - 23FF
	0x9754, 0x976c, 0x9784, 0x979d, 0x97b5, 0x97ce, 0x97e7, 0x9801,
	0x9818, 0x9830, 0x9848, 0x9861, 0x9879, 0x9892, 0x98ab, 0x98c5,
	0x98dd, 0x98f6, 0x990f, 0x9929, 0x9942, 0x995c, 0x9976, 0x9991,
	0x99a8, 0x99c0, 0x99d8, 0x99f1, 0x9a09, 0x9a22, 0x9a3b, 0x9a55,
	0x9a6d, 0x9a86, 0x9a9f, 0x9ab9, 0x9ad2, 0x9aec, 0x9b06, 0x9b21,
	0x9b39, 0x9b52, 0x9b6b, 0x9b85, 0x9b9e, 0x9bb8, 0x9bd2, 0x9bed,
	0x9c06, 0x9c20, 0x9c3a, 0x9c55, 0x9c6f, 0x9c8a, 0x9ca5, 0x9cc1,
	0x9cd7, 0x9cee, 0x9d05, 0x9d1d, 0x9d34, 0x9d4c, 0x9d64, 0x9d7d,
	// Entry 2400 - 243F
	0x9d94, 0x9dac, 0x9dc4, 0x9ddd, 0x9df5, 0x9e0e, 0x9e27, 0x9e41,
	0x9e58, 0x9e70, 0x9e88, 0x9ea1, 0x9eb9, 0x9ed2, 0x9eeb, 0x9f05,
	0x9f1d, 0x9f36, 0x9f4f, 0x9f69, 0x9f82, 0x9f9c, 0x9fb6, 0x9fd1,
	0x9fe8, 0xa000, 0xa018, 0xa031, 0xa049, 0xa062, 0xa07b, 0xa095,
	0xa0ad, 0xa0c6, 0xa0df, 0xa0f9, 0xa112, 0xa12c, 0xa146, 0xa161,
	0xa179, 0xa192, 0xa1ab, 0xa1c5, 0xa1de, 0xa1f8, 0xa212, 0xa22d,
	0xa246, 0xa260, 0xa27a, 0xa295, 0xa2af, 0xa2ca, 0xa2e5, 0xa301,
	0xa318, 0xa330, 0xa348, 0xa361, 0xa379, 0xa392, 0xa3ab, 0xa3c5,
	// Entry 2440 - 247F
	0xa3dd, 0xa3f6, 0xa40f, 0xa429, 0xa442, 0xa45c, 0xa476, 0xa491,
	0xa4a9, 0xa4c2, 0xa4db, 0xa4f5, 0xa50e, 0xa528, 0xa542, 0xa55d,
	0xa576, 0xa590, 0xa5aa, 0xa5c5, 0xa5df, 0xa5fa, 0xa615, 0xa631,
	0xa649, 0xa662, 0xa67b, 0xa695, 0xa6ae, 0xa6c8, 0xa6e2, 0xa6fd,
	0xa716, 0xa730, 0xa74a, 0xa765, 0xa77f, 0xa79a, 0xa7b5, 0xa7d1,
	0xa7ea, 0xa804, 0xa81e, 0xa839, 0xa853, 0xa86e, 0xa889, 0xa8a5,
	0xa8bf, 0xa8da, 0xa8f5, 0xa911, 0xa92c, 0xa948, 0xa964, 0xa981,
	0xa9b1, 0xa9e8, 0xaa13, 0xaa3f, 0xaa6b, 0xaa8f, 0xaaae, 0xaace,
	// Entry 2480 - 24BF
	0xaaf4, 0xab18, 0xab2c, 0xab42, 0xab5d, 0xab79, 0xab94, 0xabb0,
	0xabd7, 0xabf8, 0xac0c, 0xac22, 0xac51, 0xac87, 0xacac, 0xace6,
	0xad27, 0xad3b, 0xad50, 0xad6b, 0xad87, 0xada7, 0xadc8, 0xadf1,
	0xae1b, 0xae3a, 0xae59, 0xae73, 0xae8d, 0xaea7, 0xaec1, 0xaee6,
	0xaf0b, 0xaf30, 0xaf55, 0xaf7e, 0xafa7, 0xafd1, 0xaffb, 0xb025,
	0xb04e, 0xb078, 0xb0a2, 0xb0c4, 0xb0f2, 0xb122, 0xb151, 0xb181,
	0xb19f, 0xb1c0, 0xb1db, 0xb1f9, 0xb21b, 0xb240, 0xb268, 0xb293,
	0xb2b4, 0xb2d1, 0xb2fd, 0xb329, 0xb355, 0xb375, 0xb394, 0xb3ae,
	// Entry 24C0 - 24FF
	0xb3d3, 0xb3fd, 0xb421, 0xb445, 0xb469, 0xb48d, 0xb4af, 0xb4d4,
	0xb4fa, 0xb51d, 0xb542, 0xb568, 0xb58e, 0xb5b6, 0xb5dd, 0xb605,
	0xb62a, 0xb651, 0xb678, 0xb6a0, 0xb6c8, 0xb6f2, 0xb71b, 0xb745,
	0xb76c, 0xb795, 0xb7da, 0xb81f, 0xb866, 0xb8af, 0xb8f3, 0xb93b,
	0xb97f, 0xb9c7, 0xb9f5, 0xba25, 0xba54, 0xba85, 0xbacc, 0xbb13,
	0xbb37, 0xbb59, 0xbb7e, 0xbba2, 0xbbc7, 0xbbed, 0xbc0c, 0xbc2d,
	0xbc50, 0xbc6d, 0xbc8b, 0xbca9, 0xbcb7, 0xbcc6, 0xbcd2, 0xbce0,
	0xbcfd, 0xbd0c, 0xbd21, 0xbd39, 0xbd52, 0xbd68, 0xbd7f, 0xbd9c,
	// Entry 2500 - 253F
	0xbdba, 0xbdd9, 0xbdf9, 0xbe1a, 0xbe3c, 0xbe67, 0xbe96, 0xbec4,
	0xbef0, 0xbf0b, 0xbf27, 0xbf41, 0xbf5f, 0xbf83, 0xbfa5, 0xbfc6,
	0xbfe8, 0xbff4, 0xc008, 0xc023, 0xc042, 0xc05f, 0xc072, 0xc07d,
	0xc099, 0xc0b3, 0xc0bf, 0xc0cd, 0xc0e0, 0xc0fc, 0xc114, 0xc12e,
	0xc170, 0xc1b1, 0xc1f5, 0xc238, 0xc27a, 0xc2bb, 0xc2ff, 0xc342,
	0xc354, 0xc36a, 0xc38b, 0xc3ab, 0xc3ca, 0xc3e4, 0xc3f8, 0xc408,
	0xc41f, 0xc434, 0xc479, 0xc493, 0xc4be, 0xc4d5, 0xc4e9, 0xc4f7,
	0xc508, 0xc51c, 0xc541, 0xc570, 0xc58d, 0xc5ab, 0xc5bb, 0xc5cf,
	// Entry 2540 - 257F
	0xc5dd, 0xc5ef, 0xc606, 0xc61c, 0xc629, 0xc647, 0xc669, 0xc68a,
	0xc6ac, 0xc6c7, 0xc6e3, 0xc6ef, 0xc709, 0xc724, 0xc733, 0xc742,
	0xc753, 0xc765, 0xc77d, 0xc796, 0xc7a9, 0xc7ba, 0xc7dc, 0xc7f1,
	0xc80e, 0xc81a, 0xc829, 0xc849, 0xc87a, 0xc89b, 0xc8a7, 0xc8b4,
	0xc8df, 0xc90b, 0xc928, 0xc935, 0xc951, 0xc96d, 0xc986, 0xc99f,
	0xc9b9, 0xc9d3, 0xc9ec, 0xca05, 0xca11, 0xca29, 0xca3d, 0xca63,
	0xca6e, 0xca81, 0xca8c, 0xca97, 0xcab9, 0xcadc, 0xcae0, 0xcae4,
	0xcafe, 0xcb19, 0xcb35, 0xcb52, 0xcb70, 0xcb92, 0xcbad, 0xcbc5,
	// Entry 2580 - 25BF
	0xcbdc, 0xcbf0, 0xcbfe, 0xcc15, 0xcc30, 0xcc44, 0xcc5f, 0xcc7a,
	0xcc8e, 0xcca7, 0xccd9, 0xcd0c, 0xcd33, 0xcd53, 0xcd6f, 0xcd96,
	0xcdae, 0xcdc8, 0xcddb, 0xcdf0, 0xce06, 0xce0a, 0xce26, 0xce43,
	0xce5b, 0xce77, 0xce98, 0xcebe, 0xced8, 0xcef0, 0xcf0a, 0xcf26,
	0xcf43, 0xcf5e, 0xcf77, 0xcf93, 0xcfae, 0xcfcb, 0xcfe9, 0xd000,
	0xd022, 0xd043, 0xd068, 0xd075, 0xd09c, 0xd0c4, 0xd0f6, 0xd11a,
	0xd12f, 0xd144, 0xd15a, 0xd179, 0xd189, 0xd1a3, 0xd1c4, 0xd1dd,
	0xd1f2, 0xd207, 0xd219, 0xd232, 0xd24f, 0xd264, 0xd27c, 0xd294,
	// Entry 25C0 - 25FF
	0xd2b6, 0xd2d8, 0xd2fa, 0xd32a, 0xd342, 0xd361, 0xd37b, 0xd38e,
	0xd3b8, 0xd3d2, 0xd3eb, 0xd3fd, 0xd40e, 0xd42a, 0xd445, 0xd455,
	0xd466, 0xd488, 0xd4a4, 0xd4bf, 0xd4df, 0xd4fe, 0xd51d, 0xd536,
	0xd556, 0xd56d, 0xd58b, 0xd5aa, 0xd5cb, 0xd5eb, 0xd605, 0xd61d,
	0xd64e, 0xd67f, 0xd69c, 0xd6bb, 0xd6d0, 0xd6e8, 0xd6fc, 0xd722,
	0xd741, 0xd75c, 0xd777, 0xd797, 0xd7a9, 0xd7c5, 0xd7e3, 0xd815,
	0xd834, 0xd850, 0xd86f, 0xd891, 0xd8b6, 0xd8d3, 0xd8f3, 0xd920,
	0xd950, 0xd97c, 0xd9ab, 0xd9dd, 0xda11, 0xda29, 0xda44, 0xda6a,
	// Entry 2600 - 263F
	0xda93, 0xdab0, 0xdad0, 0xdb04, 0xdb38, 0xdb58, 0xdb7b, 0xdba5,
	0xdbcf, 0xdc03, 0xdc37, 0xdc7b, 0xdcbf, 0xdcdc, 0xdcfc, 0xdd29,
	0xdd59, 0xdd7a, 0xdd9e, 0xddc7, 0xddf3, 0xde07, 0xde1e, 0xde47,
	0xde73, 0xde8a, 0xdea4, 0xdec9, 0xdeeb, 0xdf08, 0xdf21, 0xdf3d,
	0xdf6a, 0xdf9a, 0xdfa6, 0xdfb1, 0xdfc9, 0xdfe0, 0xdffc, 0xe022,
	0xe048, 0xe06f, 0xe096, 0xe0b0, 0xe0ca, 0xe0e5, 0xe100, 0xe11e,
	0xe13c, 0xe15e, 0xe180, 0xe18f, 0xe19e, 0xe1ad, 0xe1be, 0xe1d9,
	0xe1f6, 0xe21b, 0xe242, 0xe266, 0xe28c, 0xe2a7, 0xe2c4, 0xe2e2,
	// Entry 2640 - 267F
	0xe302, 0xe321, 0xe342, 0xe35e, 0xe37c, 0xe399, 0xe3b7, 0xe3c4,
	0xe3d3, 0xe3ec, 0xe407, 0xe41c, 0xe431, 0xe444, 0xe45b, 0xe471,
	0xe49f, 0xe4bb, 0xe4d1, 0xe4e9, 0xe4f0, 0xe4fa, 0xe509, 0xe518,
	0xe525, 0xe539, 0xe55c, 0xe57e, 0xe5a0, 0xe5c9, 0xe5f6, 0xe612,
	0xe62d, 0xe650, 0xe660, 0xe66e, 0xe684, 0xe6a3, 0xe6cf, 0xe6ee,
	0xe70d, 0xe728, 0xe747, 0xe763, 0xe786, 0xe7b0, 0xe7c5, 0xe7dc,
	0xe7f6, 0xe81f, 0xe84b, 0xe869, 0xe88b, 0xe8a2, 0xe8b4, 0xe8cc,
	0xe8e2, 0xe8f8, 0xe90e, 0xe924, 0xe93a, 0xe94f, 0xe962, 0xe977,
	// Entry 2680 - 26BF
	0xe98d, 0xe9a3, 0xe9b9, 0xe9cf, 0xe9e5, 0xe9f8, 0xea1b, 0xea3c,
	0xea5e, 0xea7e, 0xea98, 0xeab5, 0xeae0, 0xeb0a, 0xeb26, 0xeb43,
	0xeb5e, 0xeb7c, 0xeb89, 0xeb9b, 0xebad, 0xebc4, 0xebdb, 0xebe9,
	0xebf7, 0xec04, 0xec11, 0xec29, 0xec3b, 0xec4f, 0xec63, 0xec77,
	0xec8b, 0xec9e, 0xecb1, 0xecc4, 0xecdc, 0xecf4, 0xed0a, 0xed20,
	0xed3c, 0xed52, 0xed6e, 0xed8b, 0xedba, 0xedf0, 0xee13, 0xee39,
	0xee59, 0xee87, 0xeebc, 0xeee0, 0xef19, 0xef59, 0xef72, 0xef93,
	0xefb4, 0xefe0, 0xf00d, 0xf032, 0xf053, 0xf06c, 0xf086, 0xf0b3,
	// Entry 26C0 - 26FF
	0xf0e1, 0xf105, 0xf12a, 0xf156, 0xf183, 0xf1a9, 0xf1c2, 0xf1df,
	0xf1f0, 0xf200, 0xf210, 0xf22d, 0xf24a, 0xf25c, 0xf277, 0xf296,
	0xf2a2, 0xf2b7, 0xf2db, 0xf303, 0xf32b, 0xf357, 0xf384, 0xf3b7,
	0xf3d6, 0xf3f3, 0xf413, 0xf432, 0xf452, 0xf46f, 0xf48f, 0xf4af,
	0xf4cf, 0xf4ef, 0xf515, 0xf539, 0xf560, 0xf586, 0xf5b1, 0xf5e0,
	0xf606, 0xf62a, 0xf651, 0xf677, 0xf69e, 0xf6c5, 0xf6ec, 0xf713,
	0xf750, 0xf78b, 0xf7c9, 0xf806, 0xf818, 0xf828, 0xf86d, 0xf8b7,
	0xf8fc, 0xf946, 0xf96d, 0xf992, 0xf9ba, 0xf9e1, 0xfa04, 0xfa25,
	// Entry 2700 - 273F
	0xfa49, 0xfa6c, 0xfa9e, 0xfad1, 0xfb02, 0xfb32, 0xfb3d, 0xfb49,
	0xfb55, 0xfb62, 0xfb8b, 0xfba1, 0xfbd4, 0xfc07, 0xfc3b, 0xfc6f,
	0xfc94, 0xfcb7, 0xfcdd, 0xfd02, 0xfd39, 0xfd71, 0xfda6, 0xfddc,
	0xfe11, 0xfe47, 0xfe7e, 0xfeb6, 0xfee0, 0xff0b, 0xff33, 0xff5c,
	0xff84, 0xffad, 0xffd7, 0x0002, 0x0018, 0x002f, 0x0043, 0x0058,
	0x006c, 0x0081, 0x0097, 0x00ae, 0x00de, 0x00fd, 0x0114, 0x011d,
	0x012b, 0x013f, 0x0154, 0x0169, 0x0181, 0x018e, 0x01b7, 0x01e2,
	0x020d, 0x0239, 0x024e, 0x0266, 0x0283, 0x02a8, 0x02bf, 0x02de,
	// Entry 2740 - 277F
	0x02f7, 0x0307, 0x0311, 0x0344, 0x0375, 0x03a9, 0x03dc, 0x03f9,
	0x0417, 0x0435, 0x0456, 0x0475, 0x0494, 0x04b5, 0x04d4, 0x04f4,
	0x0512, 0x0538, 0x0553, 0x0573, 0x0591, 0x05b2, 0x05d3, 0x05f2,
	0x060f, 0x062f, 0x064e, 0x066d, 0x068d, 0x06aa, 0x06c9, 0x06e7,
	0x0704, 0x0720, 0x073e, 0x075b, 0x077b, 0x0798, 0x07b6, 0x07d4,
	0x07f2, 0x0816, 0x0832, 0x0855, 0x0882, 0x089e, 0x08c9, 0x08ea,
	0x0913, 0x0931, 0x0952, 0x0973, 0x0999, 0x09c3, 0x09de, 0x09fa,
	0x0a16, 0x0a35, 0x0a52, 0x0a6f, 0x0a8e, 0x0aab, 0x0ac9, 0x0ae5,
	// Entry 2780 - 27BF
	0x0b09, 0x0b22, 0x0b40, 0x0b5c, 0x0b7b, 0x0b9a, 0x0bb7, 0x0bd2,
	0x0bf0, 0x0c0d, 0x0c2a, 0x0c48, 0x0c63, 0x0c80, 0x0c9c, 0x0cb7,
	0x0cd1, 0x0ced, 0x0d08, 0x0d26, 0x0d41, 0x0d5d, 0x0d79, 0x0d95,
	0x0db7, 0x0dd1, 0x0df2, 0x0e1d, 0x0e37, 0x0e60, 0x0e7f, 0x0ea6,
	0x0ec2, 0x0ee1, 0x0f00, 0x0f24, 0x0f4c, 0x0f72, 0x0f96, 0x0fbe,
	0x0fe0, 0x1000, 0x1020, 0x1049, 0x106e, 0x1091, 0x10b6, 0x10d9,
	0x10fe, 0x1121, 0x113b, 0x115b, 0x1178, 0x1199, 0x11bd, 0x11dd,
	0x11fb, 0x1219, 0x1234, 0x124d, 0x126c, 0x128b, 0x12b0, 0x12d9,
	// Entry 27C0 - 27FF
	0x12fc, 0x131a, 0x1333, 0x1359, 0x137f, 0x1399, 0x13b1, 0x13cb,
	0x13e3, 0x13fe, 0x1417, 0x1432, 0x144b, 0x1464, 0x147b, 0x1494,
	0x14ab, 0x14c5, 0x14dd, 0x14f7, 0x150f, 0x152b, 0x1545, 0x1560,
	0x1579, 0x1593, 0x15ab, 0x15c6, 0x15df, 0x15f7, 0x160d, 0x1625,
	0x163b, 0x1654, 0x166b, 0x1682, 0x1697, 0x16af, 0x16c5, 0x16dd,
	0x16f3, 0x170d, 0x1725, 0x173e, 0x1755, 0x176d, 0x1783, 0x179b,
	0x17b1, 0x17ca, 0x17e1, 0x17fa, 0x1811, 0x182a, 0x1841, 0x1865,
	0x1887, 0x18ab, 0x18cd, 0x18f4, 0x1919, 0x193d, 0x195f, 0x1981,
	// Entry 2800 - 283F
	0x19a1, 0x19c7, 0x19eb, 0x1a0f, 0x1a31, 0x1a4c, 0x1a65, 0x1a87,
	0x1aa7, 0x1acc, 0x1aef, 0x1b13, 0x1b35, 0x1b58, 0x1b79, 0x1b9d,
	0x1bbf, 0x1be4, 0x1c07, 0x1c2a, 0x1c4b, 0x1c6c, 0x1c8b, 0x1caf,
	0x1cd1, 0x1cf5, 0x1d17, 0x1d3e, 0x1d63, 0x1d87, 0x1da9, 0x1dcf,
	0x1df3, 0x1e19, 0x1e3d, 0x1e61, 0x1e83, 0x1ea7, 0x1ec9, 0x1eed,
	0x1f0f, 0x1f20, 0x1f33, 0x1f46, 0x1f5b, 0x1f6f, 0x1f83, 0x1f9b,
	0x1fc3, 0x1fe9, 0x2013, 0x203b, 0x2054, 0x2073, 0x2092, 0x20b5,
	0x20d6, 0x20f1, 0x2117, 0x213f, 0x215e, 0x2176, 0x2186, 0x21a2,
	// Entry 2840 - 287F
	0x21ba, 0x21d3, 0x21ec, 0x2205, 0x221d, 0x2236, 0x224f, 0x2268,
	0x2280, 0x2299, 0x22b2, 0x22cb, 0x22e4, 0x22fc, 0x2315, 0x232f,
	0x2348, 0x2361, 0x237a, 0x2392, 0x23ac, 0x23c6, 0x23e0, 0x23f9,
	0x2413, 0x242d, 0x2446, 0x245f, 0x2478, 0x2492, 0x24ab, 0x24c5,
	0x24de, 0x24f6, 0x250f, 0x2527, 0x2540, 0x2559, 0x2571, 0x258a,
	0x259c, 0x25af, 0x25c3, 0x25d6, 0x25eb, 0x260d, 0x2620, 0x2633,
	0x2647, 0x265b, 0x2670, 0x2683, 0x2696, 0x26a9, 0x26c3, 0x26d8,
	0x26eb, 0x270d, 0x2727, 0x273b, 0x274e, 0x2762, 0x277d, 0x2790,
	// Entry 2880 - 28BF
	0x27aa, 0x27bc, 0x27d0, 0x27ec, 0x2807, 0x281a, 0x282d, 0x2840,
	0x285b, 0x2876, 0x2889, 0x289b, 0x28ae, 0x28c2, 0x28d6, 0x28f1,
	0x290a, 0x291d, 0x2931, 0x2945, 0x2958, 0x296c, 0x2980, 0x2994,
	0x29a7, 0x29ba, 0x29cd, 0x29e0, 0x29fe, 0x2a12, 0x2a24, 0x2a36,
	0x2a61, 0x2a78, 0x2a91, 0x2aa6, 0x2abb, 0x2ad0, 0x2ae5, 0x2afb,
	0x2b10, 0x2b25, 0x2b3a, 0x2b4f, 0x2b65, 0x2b81, 0x2b96, 0x2bab,
	0x2bc1, 0x2bd6, 0x2bec, 0x2c02, 0x2c18, 0x2c2d, 0x2c43, 0x2c59,
	0x2c70, 0x2c86, 0x2c9b, 0x2cb0, 0x2cc5, 0x2cdb, 0x2cf1, 0x2d06,
	// Entry 28C0 - 28FF
	0x2d1b, 0x2d30, 0x2d45, 0x2d5a, 0x2d70, 0x2d86, 0x2d9b, 0x2db0,
	0x2dc5, 0x2dda, 0x2def, 0x2e05, 0x2e1b, 0x2e30, 0x2e45, 0x2e5b,
	0x2e71, 0x2e87, 0x2e9e, 0x2eb5, 0x2ecb, 0x2ee1, 0x2ef6, 0x2f0b,
	0x2f20, 0x2f36, 0x2f4c, 0x2f61, 0x2f76, 0x2f8b, 0x2fa0, 0x2fb5,
	0x2fcb, 0x2fe1, 0x2ff6, 0x300b, 0x3020, 0x3035, 0x304a, 0x3060,
	0x3076, 0x308b, 0x30a0, 0x30b5, 0x30ca, 0x30df, 0x30f5, 0x310b,
	0x3120, 0x3135, 0x3151, 0x316d, 0x318a, 0x31a6, 0x31c3, 0x31df,
	0x31fb, 0x3217, 0x3233, 0x324f, 0x326a, 0x3286, 0x32a2, 0x32be,
	// Entry 2900 - 293F
	0x32da, 0x32f6, 0x3313, 0x3330, 0x334d, 0x336c, 0x338a, 0x33a9,
	0x33c4, 0x33e0, 0x33ff, 0x3425, 0x3442, 0x345e, 0x3482, 0x34a6,
	0x34c7, 0x34f1, 0x3510, 0x3536, 0x354f, 0x3569, 0x3589, 0x35aa,
	0x35c5, 0x35e7, 0x3602, 0x361c, 0x3637, 0x3644, 0x3660, 0x367d,
	0x368e, 0x3699, 0x36ab, 0x36c6, 0x36d2, 0x36df, 0x36ef, 0x36fd,
	0x3718, 0x372d, 0x3741, 0x374c, 0x3761, 0x3776, 0x3791, 0x37ad,
	0x37c1, 0x37d5, 0x37f1, 0x380e, 0x3823, 0x3839, 0x3851, 0x386a,
	0x3881, 0x3899, 0x38b0, 0x38c8, 0x38e9, 0x390a, 0x3926, 0x3933,
	// Entry 2940 - 297F
	0x3949, 0x3957, 0x3961, 0x397a, 0x3986, 0x3990, 0x399c, 0x39ac,
	0x39c2, 0x39d9, 0x39e6, 0x39fb, 0x3a06, 0x3a13, 0x3a29, 0x3a3a,
	0x3a4e, 0x3a57, 0x3a64, 0x3a72, 0x3a96, 0x3aab, 0x3ac1, 0x3ad4,
	0x3af9, 0x3b03, 0x3b16, 0x3b2a, 0x3b3c, 0x3b4d, 0x3b63, 0x3b79,
	0x3b91, 0x3ba3, 0x3bb2, 0x3bc3, 0x3bd8, 0x3bed, 0x3c03, 0x3c13,
	0x3c28, 0x3c3d, 0x3c51, 0x3c65, 0x3c7b, 0x3c90, 0x3ca1, 0x3cb3,
	0x3cc8, 0x3cdd, 0x3cf2, 0x3d07, 0x3d17, 0x3d26, 0x3d37, 0x3d46,
	0x3d56, 0x3d67, 0x3d79, 0x3d8d, 0x3da2, 0x3db7, 0x3dc7, 0x3dda,
	// Entry 2980 - 29BF
	0x3ded, 0x3e13, 0x3e22, 0x3e31, 0x3e41, 0x3e5a, 0x3e69, 0x3e7f,
	0x3e95, 0x3ea7, 0x3eb7, 0x3ed4, 0x3ee7, 0x3efa, 0x3f0f, 0x3f23,
	0x3f33, 0x3f44, 0x3f53, 0x3f62, 0x3f71, 0x3f86, 0x3f9b, 0x3fab,
	0x3fbd, 0x3fd2, 0x3fe7, 0x3ffe, 0x400f, 0x4022, 0x4036, 0x404a,
	0x4066, 0x4081, 0x4091, 0x40b0, 0x40ce, 0x40de, 0x40fb, 0x4116,
	0x412a, 0x413e, 0x414e, 0x416b, 0x417f, 0x4193, 0x41b0, 0x41cd,
	0x41e2, 0x41f7, 0x4207, 0x4217, 0x423e, 0x425b, 0x4278, 0x4294,
	0x42a7, 0x42ba, 0x42cf, 0x42eb, 0x42fb, 0x4319, 0x4329, 0x433a,
	// Entry 29C0 - 29FF
	0x4357, 0x4374, 0x4391, 0x43ad, 0x43ca, 0x43e7, 0x4404, 0x4421,
	0x443f, 0x445d, 0x447c, 0x449b, 0x44ad, 0x44cc, 0x44eb, 0x44fd,
	0x4510, 0x4522, 0x4536, 0x454b, 0x455e, 0x4570, 0x4582, 0x4594,
	0x45a7, 0x45bb, 0x45cf, 0x45e6, 0x45fa, 0x460c, 0x4620, 0x4637,
	0x464b, 0x465f, 0x4672, 0x4686, 0x46a3, 0x46c2, 0x46d4, 0x46ed,
	0x4700, 0x4714, 0x472a, 0x473e, 0x4752, 0x476a, 0x477e, 0x4794,
	0x47a5, 0x47bd, 0x47d3, 0x47e5, 0x47f9, 0x480d, 0x4820, 0x4833,
	0x4847, 0x485a, 0x486f, 0x4884, 0x489b, 0x48af, 0x48c2, 0x48d8,
	// Entry 2A00 - 2A3F
	0x48ed, 0x48ff, 0x491a, 0x4935, 0x494f, 0x4967, 0x497b, 0x498d,
	0x49a1, 0x49b7, 0x49ca, 0x49de, 0x49f4, 0x4a07, 0x4a1a, 0x4a2f,
	0x4a41, 0x4a56, 0x4a6b, 0x4a7d, 0x4a92, 0x4aa4, 0x4ab6, 0x4ac8,
	0x4adb, 0x4aee, 0x4b01, 0x4b14, 0x4b28, 0x4b3d, 0x4b52, 0x4b68,
	0x4b7a, 0x4b8d, 0x4ba1, 0x4bb5, 0x4bc8, 0x4bdb, 0x4bf0, 0x4c07,
	0x4c25, 0x4c39, 0x4c4c, 0x4c5e, 0x4c70, 0x4c87, 0x4c9a, 0x4cae,
	0x4cc1, 0x4cd5, 0x4ce8, 0x4cfa, 0x4d0e, 0x4d2a, 0x4d41, 0x4d5b,
	0x4d6f, 0x4d82, 0x4d95, 0x4da7, 0x4dbb, 0x4dcf, 0x4de3, 0x4df8,
	// Entry 2A40 - 2A7F
	0x4e0c, 0x4e20, 0x4e33, 0x4e47, 0x4e5c, 0x4e6f, 0x4e82, 0x4e94,
	0x4ea6, 0x4eba, 0x4ed0, 0x4ee2, 0x4ef4, 0x4f07, 0x4f19, 0x4f2d,
	0x4f40, 0x4f57, 0x4f6a, 0x4f7f, 0x4f94, 0x4fa9, 0x4fbe, 0x4fd1,
	0x4fe8, 0x4ffc, 0x5010, 0x5024, 0x5039, 0x504d, 0x506a, 0x5080,
	0x5093, 0x50a5, 0x50b8, 0x50cd, 0x50e2, 0x50f5, 0x5107, 0x511c,
	0x5130, 0x5142, 0x5154, 0x5167, 0x517a, 0x518d, 0x51a2, 0x51b8,
	0x51cb, 0x51de, 0x51f1, 0x520b, 0x5221, 0x5234, 0x5247, 0x525a,
	0x526e, 0x5282, 0x52a2, 0x52b5, 0x52c8, 0x52dc, 0x52ef, 0x5305,
	// Entry 2A80 - 2ABF
	0x5322, 0x5335, 0x5349, 0x535c, 0x536f, 0x5381, 0x5393, 0x53a6,
	0x53bd, 0x53d1, 0x53e4, 0x53f7, 0x540a, 0x541e, 0x543d, 0x5454,
	0x5468, 0x547b, 0x548e, 0x54a1, 0x54b4, 0x54c8, 0x54db, 0x54f0,
	0x5505, 0x5519, 0x5532, 0x5545, 0x555a, 0x556d, 0x557f, 0x5592,
	0x55a5, 0x55b9, 0x55ce, 0x55e3, 0x55f7, 0x5626, 0x5656, 0x5690,
	0x56cb, 0x56fa, 0x572f, 0x5764, 0x5798, 0x57d2, 0x580d, 0x5847,
	0x5871, 0x5882, 0x5893, 0x58a8, 0x58b2, 0x58d5, 0x58ef, 0x5907,
	0x591e, 0x5930, 0x5943, 0x595c, 0x5976, 0x5989, 0x599d, 0x59b6,
	// Entry 2AC0 - 2AFF
	0x59d0, 0x59ed, 0x5a0b, 0x5a16, 0x5a1f, 0x5a3a, 0x5a56, 0x5a73,
	0x5a91, 0x5ab2, 0x5ad4, 0x5aed, 0x5b07, 0x5b10, 0x5b34, 0x5b4f,
	0x5b6e, 0x5b7e, 0x5b92, 0x5ba6, 0x5bbc, 0x5bd1, 0x5be6, 0x5bfa,
	0x5c10, 0x5c26, 0x5c3b, 0x5c56, 0x5c72, 0x5c91, 0x5caf, 0x5cca,
	0x5ce5, 0x5cee, 0x5d07, 0x5d32, 0x5d56, 0x5d8c, 0x5db0, 0x5dc3,
	0x5df3, 0x5e07, 0x5e1e, 0x5e35, 0x5e58, 0x5e61, 0x5e76, 0x5e95,
	0x5eb0, 0x5ec7, 0x5ed8, 0x5eef, 0x5f00, 0x5f17, 0x5f28, 0x5f3f,
	0x5f50, 0x5f67, 0x5f78, 0x5f8a, 0x5f9c, 0x5fae, 0x5fc0, 0x5fd2,
	// Entry 2B00 - 2B3F
	0x5fe4, 0x5ff6, 0x6008, 0x601a, 0x602c, 0x603e, 0x6050, 0x6062,
	0x6074, 0x6086, 0x6098, 0x60aa, 0x60bc, 0x60ce, 0x60e0, 0x60f2,
	0x6104, 0x6116, 0x6128, 0x6140, 0x6152, 0x6164, 0x6176, 0x6188,
	0x619a, 0x61ac, 0x61be, 0x61d0, 0x61e2, 0x61f4, 0x6206, 0x6218,
	0x622a, 0x623c, 0x624e, 0x6260, 0x6272, 0x6284, 0x6296, 0x62a8,
	0x62ba, 0x62cc, 0x62de, 0x62f0, 0x6302, 0x6314, 0x6326, 0x6338,
	0x634a, 0x635c, 0x636e, 0x6386, 0x6398, 0x63b0, 0x63c2, 0x63da,
	0x63ec, 0x63fe, 0x6410, 0x6422, 0x6434, 0x6446, 0x645e, 0x6470,
	// Entry 2B40 - 2B7F
	0x6482, 0x6494, 0x64a6, 0x64b7, 0x64c9, 0x64e1, 0x64f9, 0x6526,
	0x6558, 0x657b, 0x65a3, 0x65ba, 0x65d8, 0x65ed, 0x660c, 0x6623,
	0x6634, 0x664b, 0x665c, 0x6673, 0x6684, 0x669b, 0x66ac, 0x66c3,
	0x66d4, 0x66e6, 0x66f8, 0x670a, 0x671c, 0x672e, 0x6740, 0x6752,
	0x6764, 0x6776, 0x6788, 0x679a, 0x67ac, 0x67be, 0x67d0, 0x67e2,
	0x67f4, 0x6806, 0x6818, 0x682a, 0x683c, 0x684e, 0x6860, 0x6872,
	0x6884, 0x689c, 0x68ae, 0x68c0, 0x68d2, 0x68e4, 0x68f6, 0x6908,
	0x691a, 0x692c, 0x693e, 0x6950, 0x6962, 0x6974, 0x6986, 0x6998,
	// Entry 2B80 - 2BBF
	0x69aa, 0x69bc, 0x69ce, 0x69e0, 0x69f2, 0x6a04, 0x6a16, 0x6a28,
	0x6a3a, 0x6a4c, 0x6a5e, 0x6a70, 0x6a82, 0x6a94, 0x6aa6, 0x6ab8,
	0x6aca, 0x6ae2, 0x6af4, 0x6b0c, 0x6b1e, 0x6b36, 0x6b48, 0x6b5a,
	0x6b6c, 0x6b7e, 0x6b90, 0x6ba2, 0x6bba, 0x6bcc, 0x6bde, 0x6bf0,
	0x6c02, 0x6c13, 0x6c25, 0x6c3d, 0x6c55, 0x6c67, 0x6c79, 0x6c8b,
	0x6c9d, 0x6cb0, 0x6cd6, 0x6ced, 0x6d0b, 0x6d20, 0x6d31, 0x6d42,
	0x6d53, 0x6d64, 0x6d75, 0x6d86, 0x6d97, 0x6da8, 0x6db9, 0x6dca,
	0x6ddb, 0x6dec, 0x6dfd, 0x6e0e, 0x6e20, 0x6e32, 0x6e44, 0x6e55,
	// Entry 2BC0 - 2BFF
	0x6e66, 0x6e77, 0x6e88, 0x6e99, 0x6eaa, 0x6ebb, 0x6ecd, 0x6edf,
	0x6ef1, 0x6f03, 0x6f15, 0x6f27, 0x6f39, 0x6f4c, 0x6f5f, 0x6f71,
	0x6f82, 0x6f93, 0x6fa5, 0x6fb6, 0x6fc8, 0x6fda, 0x6fec, 0x700c,
	0x7020, 0x7039, 0x7052, 0x7065, 0x707e, 0x7097, 0x70ab, 0x70c4,
	0x70d7, 0x70f1, 0x710a, 0x7123, 0x713b, 0x7156, 0x7171, 0x718a,
	0x719d, 0x71b0, 0x71c8, 0x71e0, 0x71f2, 0x7209, 0x721c, 0x722f,
	0x7247, 0x725c, 0x7271, 0x7286, 0x729b, 0x72ae, 0x72bd, 0x72cd,
	0x72dd, 0x72ee, 0x72fe, 0x730d, 0x731e, 0x732e, 0x733d, 0x734d,
	// Entry 2C00 - 2C3F
	0x735e, 0x736e, 0x737e, 0x738d, 0x739e, 0x73ae, 0x73be, 0x73ce,
	0x73de, 0x73ee, 0x73fd, 0x740a, 0x7422, 0x743c, 0x7454, 0x746f,
	0x748e, 0x74a8, 0x74c6, 0x74e1, 0x7500, 0x7519, 0x7531, 0x754c,
	0x7567, 0x7581, 0x759b, 0x75ba, 0x75d9, 0x75f2, 0x760d, 0x7628,
	0x7648, 0x7661, 0x7679, 0x7692, 0x76aa, 0x76c2, 0x76d7, 0x76ef,
	0x7705, 0x7720, 0x773e, 0x775b, 0x7773, 0x778c, 0x779f, 0x77b3,
	0x77c5, 0x77d9, 0x77ec, 0x77fe, 0x7811, 0x7825, 0x7848, 0x786b,
	0x788a, 0x78a9, 0x78ca, 0x78ea, 0x7909, 0x792b, 0x794d, 0x796e,
	// Entry 2C40 - 2C7F
	0x7990, 0x79b1, 0x79d3, 0x79f5, 0x7a16, 0x7a35, 0x7a47, 0x7a59,
	0x7a6b, 0x7a7d, 0x7a8f, 0x7aa2, 0x7ab4, 0x7ac7, 0x7ad9, 0x7aec,
	0x7aff, 0x7b12, 0x7b24, 0x7b37, 0x7b4b, 0x7b5f, 0x7b71, 0x7b83,
	0x7b96, 0x7baa, 0x7bc1, 0x7bd8, 0x7bef, 0x7c06, 0x7c18, 0x7c2a,
	0x7c3c, 0x7c48, 0x7c55, 0x7c62, 0x7c70, 0x7c7d, 0x7c8b, 0x7c99,
	0x7ca6, 0x7cb5, 0x7cc4, 0x7cd2, 0x7ce1, 0x7cf0, 0x7cfe, 0x7d0d,
	0x7d19, 0x7d25, 0x7d31, 0x7d3d, 0x7d4a, 0x7d56, 0x7d63, 0x7d70,
	0x7d7d, 0x7d8b, 0x7d98, 0x7da5, 0x7db2, 0x7dbf, 0x7dcc, 0x7dda,
	// Entry 2C80 - 2CBF
	0x7de8, 0x7df7, 0x7e07, 0x7e14, 0x7e20, 0x7e38, 0x7e50, 0x7e68,
	0x7e80, 0x7e98, 0x7eb0, 0x7ec8, 0x7ee0, 0x7ef8, 0x7f10, 0x7f28,
	0x7f40, 0x7f58, 0x7f70, 0x7f88, 0x7fa0, 0x7fbb, 0x7fd5, 0x7ff0,
	0x800a, 0x8024, 0x803e, 0x8057, 0x8071, 0x808b, 0x80a7, 0x80c3,
	0x80df, 0x80fb, 0x8115, 0x8132, 0x814e, 0x816b, 0x8187, 0x81a3,
	0x81bf, 0x81da, 0x81f6, 0x8212, 0x8230, 0x824e, 0x826c, 0x828a,
	0x82a6, 0x82c2, 0x82e6, 0x8309, 0x8324, 0x833f, 0x835c, 0x8378,
	0x8394, 0x83af, 0x83cc, 0x83e9, 0x8405, 0x8420, 0x843c, 0x8458,
	// Entry 2CC0 - 2CFF
	0x8475, 0x8491, 0x84ae, 0x84cb, 0x84e6, 0x8503, 0x851f, 0x853e,
	0x855a, 0x8579, 0x859a, 0x85c0, 0x85dd, 0x85fe, 0x861a, 0x8637,
	0x8658, 0x867a, 0x869a, 0x86ba, 0x86da, 0x86f6, 0x8712, 0x872f,
	0x8749, 0x8767, 0x877f, 0x8795, 0x87b7, 0x87dc, 0x8801, 0x8825,
	0x8849, 0x886d, 0x8893, 0x88b8, 0x88c8, 0x88e1, 0x88fa, 0x8915,
	0x892f, 0x8949, 0x8962, 0x897d, 0x8998, 0x89b2, 0x89c7, 0x89e0,
	0x89f9, 0x8a14, 0x8a2e, 0x8a48, 0x8a5d, 0x8a71, 0x8a86, 0x8a9a,
	0x8aae, 0x8ac2, 0x8ad5, 0x8ae9, 0x8afd, 0x8b13, 0x8b29, 0x8b3f,
	// Entry 2D00 - 2D3F
	0x8b55, 0x8b69, 0x8b80, 0x8b96, 0x8bad, 0x8bc3, 0x8bd9, 0x8bef,
	0x8c04, 0x8c1a, 0x8c30, 0x8c48, 0x8c60, 0x8c78, 0x8c90, 0x8ca6,
	0x8cc5, 0x8ce3, 0x8cf9, 0x8d0f, 0x8d24, 0x8d39, 0x8d50, 0x8d66,
	0x8d7c, 0x8d91, 0x8da8, 0x8dbf, 0x8dd5, 0x8dea, 0x8e00, 0x8e16,
	0x8e2d, 0x8e43, 0x8e5a, 0x8e71, 0x8e86, 0x8e9d, 0x8eb3, 0x8ecc,
	0x8ee2, 0x8efb, 0x8f16, 0x8f36, 0x8f4d, 0x8f65, 0x8f7b, 0x8f93,
	0x8fad, 0x8fc8, 0x8fdf, 0x8ffa, 0x9010, 0x9026, 0x903c, 0x9055,
	0x906b, 0x9083, 0x9098, 0x90ae, 0x90c5, 0x90df, 0x90f9, 0x9110,
	// Entry 2D40 - 2D7F
	0x912b, 0x9147, 0x9161, 0x917b, 0x9192, 0x91ab, 0x91c6, 0x91e1,
	0x91fb, 0x920f, 0x9227, 0x923f, 0x9259, 0x9272, 0x928b, 0x92a3,
	0x92bd, 0x92d7, 0x92f0, 0x9304, 0x932c, 0x9355, 0x937b, 0x93a1,
	0x93c5, 0x93ea, 0x940f, 0x9436, 0x9460, 0x9488, 0x94b1, 0x94da,
	0x94e3, 0x94ed, 0x94f6, 0x950c, 0x951e, 0x9530, 0x9542, 0x9554,
	0x9566, 0x9579, 0x958c, 0x959f, 0x95b2, 0x95c5, 0x95d8, 0x95eb,
	0x95fe, 0x9611, 0x9624, 0x9637, 0x964a, 0x965d, 0x9670, 0x9683,
	0x9696, 0x96a9, 0x96bc, 0x96cf, 0x96e2, 0x96f5, 0x9708, 0x971b,
	// Entry 2D80 - 2DBF
	0x972e, 0x9741, 0x9754, 0x9767, 0x977a, 0x978d, 0x97a0, 0x97b3,
	0x97c6, 0x97d9, 0x97ec, 0x97ff, 0x9812, 0x9825, 0x9838, 0x984b,
	0x985e, 0x9871, 0x9884, 0x9891, 0x989e, 0x98aa, 0x98b5, 0x98c2,
	0x98cd, 0x98d7, 0x98e6, 0x98f2, 0x98fd, 0x9908, 0x9914, 0x9922,
	0x9930, 0x993c, 0x9948, 0x9953, 0x995f, 0x996c, 0x997a, 0x9985,
	0x9996, 0x99a8, 0x99b8, 0x99c5, 0x99d5, 0x99e5, 0x99f3, 0x99ff,
	0x9a0c, 0x9a18, 0x9a26, 0x9a35, 0x9a43, 0x9a4f, 0x9a5b, 0x9a67,
	0x9a72, 0x9a7d, 0x9a87, 0x9a92, 0x9a9e, 0x9aaa, 0x9ab9, 0x9ac5,
	// Entry 2DC0 - 2DFF
	0x9ad3, 0x9ae3, 0x9af0, 0x9afb, 0x9b06, 0x9b15, 0x9b22, 0x9b31,
	0x9b3d, 0x9b4d, 0x9b58, 0x9b65, 0x9b72, 0x9b7e, 0x9b8a, 0x9b96,
	0x9ba3, 0x9bb0, 0x9bba, 0x9bc6, 0x9bd2, 0x9bdd, 0x9beb, 0x9bf7,
	0x9c03, 0x9c10, 0x9c1e, 0x9c2c, 0x9c37, 0x9c47, 0x9c52, 0x9c60,
	0x9c6e, 0x9c7a, 0x9c86, 0x9c91, 0x9c9f, 0x9caa, 0x9cb6, 0x9cc4,
	0x9ccf, 0x9cde, 0x9cea, 0x9d14, 0x9d3d, 0x9d66, 0x9d91, 0x9dbb,
	0x9de5, 0x9e0e, 0x9e39, 0x9e64, 0x9e8e, 0x9eb7, 0x9ee3, 0x9f0f,
	0x9f3d, 0x9f6b, 0x9f98, 0x9fc5, 0x9ff4, 0xa022, 0xa050, 0xa07c,
	// Entry 2E00 - 2E3F
	0xa0ac, 0xa0dc, 0xa10e, 0xa13f, 0xa149, 0xa152, 0xa15b, 0xa165,
	0xa16e, 0xa177, 0xa180, 0xa191, 0xa1a0, 0xa1a9, 0xa1bf, 0xa1d5,
	0xa1ec, 0xa201, 0xa213, 0xa221, 0xa22a, 0xa235, 0xa23e, 0xa247,
	0xa250, 0xa259, 0xa262, 0xa26c, 0xa277, 0xa280, 0xa289, 0xa294,
	0xa29f, 0xa2a8, 0xa2b1, 0xa2ba, 0xa2c4, 0xa2ce, 0xa2d8, 0xa2e2,
	0xa2ed, 0xa2f6, 0xa2ff, 0xa308, 0xa311, 0xa31a, 0xa325, 0xa32e,
	0xa337, 0xa340, 0xa351, 0xa362, 0xa372, 0xa383, 0xa392, 0xa3a1,
	0xa3af, 0xa3be, 0xa3cd, 0xa3e4, 0xa3ed, 0xa3f7, 0xa401, 0xa40b,
	// Entry 2E40 - 2E7F
	0xa415, 0xa426, 0xa43f, 0xa448, 0xa451, 0xa45c, 0xa465, 0xa46e,
	0xa477, 0xa482, 0xa48b, 0xa494, 0xa4a2, 0xa4ab, 0xa4b4, 0xa4bf,
	0xa4c8, 0xa4d1, 0xa4df, 0xa4eb, 0xa4f7, 0xa500, 0xa509, 0xa512,
	0xa51b, 0xa52b, 0xa534, 0xa53d, 0xa546, 0xa54f, 0xa558, 0xa561,
	0xa56a, 0xa57b, 0xa584, 0xa58d, 0xa596, 0xa5a0, 0xa5a9, 0xa5b8,
	0xa5c2, 0xa5cc, 0xa5d5, 0xa5de, 0xa5e8, 0xa5f1, 0xa5fa, 0xa603,
	0xa60c, 0xa61b, 0xa62a, 0xa652, 0xa67a, 0xa6a4, 0xa6cd, 0xa6f6,
	0xa71e, 0xa748, 0xa772, 0xa79b, 0xa7c3, 0xa7ee, 0xa819, 0xa846,
	// Entry 2E80 - 2EBF
	0xa873, 0xa89f, 0xa8cb, 0xa8f9, 0xa926, 0xa953, 0xa97e, 0xa9ad,
	0xa9dc, 0xaa0d, 0xaa3d, 0xaa6d, 0xaa9c, 0xaacd, 0xaafe, 0xab2e,
	0xab59, 0xab88, 0xab92, 0xabb2, 0xabd2, 0xabfa, 0xac15, 0xac29,
	0xac3e, 0xac53, 0xac70, 0xac89, 0xac9e, 0xacb0, 0xacc7, 0xacde,
	0xacfb, 0xad0f, 0xad26, 0xad3c, 0xad5c, 0xad71, 0xad8b, 0xada6,
	0xadb8, 0xadd4, 0xade7, 0xadfd, 0xae16, 0xae30, 0xae50, 0xae6e,
	0xae8c, 0xaea2, 0xaeb7, 0xaecb, 0xaee3, 0xaef8, 0xaf1b, 0xaf32,
	0xaf49, 0xaf61, 0xaf79, 0xaf8e, 0xafa3, 0xafbc, 0xafd7, 0xaff6,
	// Entry 2EC0 - 2EFF
	0xb011, 0xb028, 0xb03d, 0xb054, 0xb06d, 0xb08e, 0xb0b5, 0xb0cd,
	0xb0ed, 0xb103, 0xb11c, 0xb138, 0xb154, 0xb16b, 0xb182, 0xb19a,
	0xb1ba, 0xb1d7, 0xb1f5, 0xb203, 0xb211, 0xb21e, 0xb22c, 0xb23b,
	0xb24a, 0xb258, 0xb267, 0xb275, 0xb283, 0xb290, 0xb29e, 0xb2ad,
	0xb2bb, 0xb2ca, 0xb2d8, 0xb2e6, 0xb2f3, 0xb301, 0xb30f, 0xb31c,
	0xb32a, 0xb339, 0xb348, 0xb356, 0xb365, 0xb375, 0xb385, 0xb394,
	0xb3a4, 0xb3b3, 0xb3c2, 0xb3d0, 0xb3df, 0xb3ef, 0xb3fe, 0xb40e,
	0xb41d, 0xb42c, 0xb43a, 0xb449, 0xb458, 0xb466, 0xb475, 0xb484,
	// Entry 2F00 - 2F3F
	0xb493, 0xb4a1, 0xb4b0, 0xb4c0, 0xb4cf, 0xb4de, 0xb4ed, 0xb4fb,
	0xb50a, 0xb51a, 0xb529, 0xb538, 0xb547, 0xb555, 0xb564, 0xb574,
	0xb583, 0xb593, 0xb5a2, 0xb5b1, 0xb5bf, 0xb5ce, 0xb5de, 0xb5ed,
	0xb5fd, 0xb60c, 0xb61b, 0xb629, 0xb638, 0xb647, 0xb656, 0xb664,
	0xb673, 0xb683, 0xb692, 0xb6a1, 0xb6b0, 0xb6be, 0xb6cd, 0xb6dd,
	0xb6ec, 0xb6fc, 0xb70c, 0xb71b, 0xb72b, 0xb73c, 0xb74d, 0xb75d,
	0xb76e, 0xb77e, 0xb78e, 0xb79d, 0xb7ad, 0xb7be, 0xb7ce, 0xb7df,
	0xb7ef, 0xb7ff, 0xb80e, 0xb81e, 0xb82e, 0xb83d, 0xb84d, 0xb85d,
	// Entry 2F40 - 2F7F
	0xb86d, 0xb87c, 0xb88c, 0xb89d, 0xb8ad, 0xb8bd, 0xb8cd, 0xb8dc,
	0xb8ec, 0xb8fc, 0xb90c, 0xb91b, 0xb92b, 0xb93c, 0xb94c, 0xb95d,
	0xb96d, 0xb97d, 0xb98c, 0xb99c, 0xb9ac, 0xb9bc, 0xb9cb, 0xb9db,
	0xb9eb, 0xb9fb, 0xba0a, 0xba1a, 0xba2b, 0xba3b, 0xba4b, 0xba5b,
	0xba6a, 0xba7a, 0xba8b, 0xba9b, 0xbaab, 0xbabb, 0xbaca, 0xbada,
	0xbaeb, 0xbafb, 0xbb0c, 0xbb1c, 0xbb2c, 0xbb3b, 0xbb4b, 0xbb5c,
	0xbb6c, 0xbb7d, 0xbb8d, 0xbb9d, 0xbbac, 0xbbbc, 0xbbcc, 0xbbdc,
	0xbbeb, 0xbbfb, 0xbc0c, 0xbc1c, 0xbc2c, 0xbc3b, 0xbc4b, 0xbc5c,
	// Entry 2F80 - 2FBF
	0xbc6c, 0xbc7b, 0xbc8a, 0xbc98, 0xbca7, 0xbcb7, 0xbcc6, 0xbcd6,
	0xbce5, 0xbcf4, 0xbd02, 0xbd11, 0xbd21, 0xbd31, 0xbd40, 0xbd50,
	0xbd5f, 0xbd6e, 0xbd7c, 0xbd8b, 0xbd9a, 0xbda8, 0xbdb7, 0xbdc6,
	0xbdd4, 0xbde3, 0xbdf3, 0xbe02, 0xbe11, 0xbe20, 0xbe2e, 0xbe3d,
	0xbe4c, 0xbe5b, 0xbe69, 0xbe78, 0xbe87, 0xbe96, 0xbea4, 0xbeb3,
	0xbec2, 0xbed0, 0xbedf, 0xbeee, 0xbefd, 0xbf0b, 0xbf1a, 0xbf2a,
	0xbf39, 0xbf48, 0xbf57, 0xbf65, 0xbf74, 0xbf83, 0xbf92, 0xbfa0,
	0xbfaf, 0xbfbf, 0xbfcf, 0xbfde, 0xbfee, 0xbffd, 0xc00c, 0xc01a,
	// Entry 2FC0 - 2FFF
	0xc029, 0xc038, 0xc047, 0xc055, 0xc064, 0xc073, 0xc082, 0xc091,
	0xc0a0, 0xc0ae, 0xc0bd, 0xc0cd, 0xc0dc, 0xc0eb, 0xc0fa, 0xc108,
	0xc117, 0xc127, 0xc136, 0xc145, 0xc154, 0xc162, 0xc171, 0xc181,
	0xc190, 0xc1a0, 0xc1af, 0xc1be, 0xc1cc, 0xc1db, 0xc1eb, 0xc1fa,
	0xc209, 0xc218, 0xc226, 0xc235, 0xc244, 0xc252, 0xc261, 0xc270,
	0xc27f, 0xc28d, 0xc29c, 0xc2ac, 0xc2bb, 0xc2ca, 0xc2d9, 0xc2e7,
	0xc2f6, 0xc306, 0xc315, 0xc325, 0xc334, 0xc343, 0xc351, 0xc360,
	0xc370, 0xc380, 0xc38f, 0xc39f, 0xc3ae, 0xc3bd, 0xc3cb, 0xc3da,
	// Entry 3000 - 303F
	0xc3e9, 0xc3f7, 0xc406, 0xc415, 0xc424, 0xc432, 0xc441, 0xc451,
	0xc460, 0xc470, 0xc480, 0xc48f, 0xc49f, 0xc4b0, 0xc4c0, 0xc4d1,
	0xc4e1, 0xc4f1, 0xc500, 0xc510, 0xc521, 0xc531, 0xc542, 0xc552,
	0xc562, 0xc571, 0xc581, 0xc591, 0xc5a0, 0xc5b0, 0xc5c0, 0xc5d0,
	0xc5df, 0xc5ef, 0xc600, 0xc610, 0xc620, 0xc630, 0xc63f, 0xc64f,
	0xc660, 0xc670, 0xc680, 0xc690, 0xc69f, 0xc6af, 0xc6bf, 0xc6cf,
	0xc6de, 0xc6ee, 0xc6fe, 0xc70d, 0xc71d, 0xc72d, 0xc73d, 0xc74c,
	0xc75c, 0xc76d, 0xc77d, 0xc78d, 0xc79d, 0xc7ac, 0xc7bc, 0xc7cd,
	// Entry 3040 - 307F
	0xc7de, 0xc7ee, 0xc7ff, 0xc80f, 0xc81f, 0xc82e, 0xc83e, 0xc84f,
	0xc85f, 0xc86f, 0xc87f, 0xc88f, 0xc89f, 0xc8ae, 0xc8be, 0xc8ce,
	0xc8dd, 0xc8ec, 0xc8fa, 0xc909, 0xc919, 0xc928, 0xc938, 0xc947,
	0xc955, 0xc964, 0xc974, 0xc983, 0xc993, 0xc9a2, 0xc9b1, 0xc9bf,
	0xc9ce, 0xc9dd, 0xc9eb, 0xc9fa, 0xca09, 0xca18, 0xca26, 0xca35,
	0xca45, 0xca54, 0xca64, 0xca74, 0xca83, 0xca93, 0xcaa4, 0xcab4,
	0xcac5, 0xcad5, 0xcae5, 0xcaf4, 0xcb04, 0xcb15, 0xcb25, 0xcb36,
	0xcb46, 0xcb55, 0xcb65, 0xcb75, 0xcb84, 0xcb94, 0xcba4, 0xcbb4,
	// Entry 3080 - 30BF
	0xcbc3, 0xcbd3, 0xcbe4, 0xcbf4, 0xcc04, 0xcc14, 0xcc23, 0xcc33,
	0xcc44, 0xcc54, 0xcc63, 0xcc72, 0xcc80, 0xcc8f, 0xcc9f, 0xccaf,
	0xccbe, 0xccce, 0xccdd, 0xccec, 0xccfa, 0xcd09, 0xcd19, 0xcd29,
	0xcd38, 0xcd48, 0xcd57, 0xcd66, 0xcd74, 0xcd83, 0xcd92, 0xcda0,
	0xcdaf, 0xcdbe, 0xcdcd, 0xcddb, 0xcdea, 0xcdfa, 0xce09, 0xce18,
	0xce27, 0xce35, 0xce44, 0xce54, 0xce63, 0xce72, 0xce81, 0xce8f,
	0xce9e, 0xceae, 0xcebe, 0xcecd, 0xcedd, 0xceec, 0xcefb, 0xcf09,
	0xcf18, 0xcf28, 0xcf38, 0xcf47, 0xcf57, 0xcf66, 0xcf75, 0xcf83,
	// Entry 30C0 - 30FF
	0xcf92, 0xcfa1, 0xcfb0, 0xcfbe, 0xcfcd, 0xcfdc, 0xcfeb, 0xcff9,
	0xd008, 0xd018, 0xd027, 0xd036, 0xd045, 0xd053, 0xd062, 0xd072,
	0xd081, 0xd091, 0xd0a0, 0xd0af, 0xd0bd, 0xd0cc, 0xd0dc, 0xd0eb,
	0xd0fb, 0xd10a, 0xd119, 0xd127, 0xd136, 0xd145, 0xd154, 0xd162,
	0xd171, 0xd180, 0xd18f, 0xd19d, 0xd1ac, 0xd1bc, 0xd1cb, 0xd1db,
	0xd1eb, 0xd1fa, 0xd20b, 0xd21b, 0xd22c, 0xd23c, 0xd24c, 0xd25b,
	0xd26b, 0xd27c, 0xd28d, 0xd29d, 0xd2ae, 0xd2be, 0xd2ce, 0xd2dd,
	0xd2ed, 0xd2fd, 0xd30d, 0xd31c, 0xd32c, 0xd33c, 0xd34c, 0xd35b,
	// Entry 3100 - 313F
	0xd36b, 0xd37c, 0xd38c, 0xd39d, 0xd3ad, 0xd3bd, 0xd3cd, 0xd3dc,
	0xd3ec, 0xd3fd, 0xd40d, 0xd41e, 0xd42e, 0xd43e, 0xd44d, 0xd45d,
	0xd46d, 0xd47c, 0xd48c, 0xd49c, 0xd4ac, 0xd4bb, 0xd4cb, 0xd4dc,
	0xd4ec, 0xd4fc, 0xd50c, 0xd51b, 0xd52b, 0xd53c, 0xd54d, 0xd55d,
	0xd56e, 0xd57e, 0xd58e, 0xd59d, 0xd5ad, 0xd5be, 0xd5cf, 0xd5df,
	0xd5f0, 0xd600, 0xd610, 0xd61f, 0xd62f, 0xd63f, 0xd64e, 0xd65e,
	0xd66f, 0xd67f, 0xd690, 0xd6a0, 0xd6b0, 0xd6bf, 0xd6cf, 0xd6e0,
	0xd6f1, 0xd701, 0xd711, 0xd721, 0xd730, 0xd740, 0xd750, 0xd75f,
	// Entry 3140 - 317F
	0xd76f, 0xd77e, 0xd78e, 0xd79d, 0xd7ac, 0xd7bb, 0xd7c9, 0xd7d8,
	0xd7e8, 0xd7f8, 0xd807, 0xd817, 0xd826, 0xd835, 0xd843, 0xd852,
	0xd861, 0xd86f, 0xd87e, 0xd88d, 0xd89c, 0xd8aa, 0xd8b9, 0xd8c9,
	0xd8d8, 0xd8e8, 0xd8f7, 0xd905, 0xd914, 0xd923, 0xd931, 0xd940,
	0xd94f, 0xd95e, 0xd96c, 0xd97b, 0xd98b, 0xd99a, 0xd9aa, 0xd9b9,
	0xd9c8, 0xd9d6, 0xd9e5, 0xd9f5, 0xda04, 0xda14, 0xda23, 0xda32,
	0xda40, 0xda4f, 0xda5e, 0xda6c, 0xda7b, 0xda8a, 0xda99, 0xdaa7,
	0xdab6, 0xdac6, 0xdad5, 0xdae4, 0xdaf3, 0xdb01, 0xdb10, 0xdb20,
	// Entry 3180 - 31BF
	0xdb2f, 0xdb3e, 0xdb4d, 0xdb5b, 0xdb6a, 0xdb7a, 0xdb8a, 0xdb99,
	0xdba9, 0xdbb8, 0xdbc7, 0xdbd5, 0xdbe4, 0xdbf4, 0xdc03, 0xdc13,
	0xdc22, 0xdc31, 0xdc3f, 0xdc4e, 0xdc5d, 0xdc6b, 0xdc7a, 0xdc89,
	0xdc98, 0xdca6, 0xdcb5, 0xdcc5, 0xdcd4, 0xdce3, 0xdcf2, 0xdd00,
	0xdd0f, 0xdd1f, 0xdd2e, 0xdd3e, 0xdd4e, 0xdd5d, 0xdd6d, 0xdd7e,
	0xdd8f, 0xdd9f, 0xddb0, 0xddc0, 0xddd0, 0xdddf, 0xddef, 0xddff,
	0xde0e, 0xde1e, 0xde2e, 0xde3d, 0xde4d, 0xde5d, 0xde6c, 0xde7c,
	0xde8d, 0xde9d, 0xdead, 0xdebd, 0xdecc, 0xdedc, 0xdeed, 0xdefd,
	// Entry 31C0 - 31FF
	0xdf0d, 0xdf1d, 0xdf2c, 0xdf3c, 0xdf4d, 0xdf5d, 0xdf6e, 0xdf7e,
	0xdf8e, 0xdf9d, 0xdfad, 0xdfbe, 0xdfce, 0xdfde, 0xdfee, 0xdffe,
	0xe00d, 0xe01d, 0xe02c, 0xe03c, 0xe04d, 0xe05d, 0xe06d, 0xe07d,
	0xe08c, 0xe09c, 0xe0ad, 0xe0bd, 0xe0cc, 0xe0db, 0xe0e9, 0xe0f8,
	0xe108, 0xe117, 0xe127, 0xe136, 0xe145, 0xe153, 0xe162, 0xe172,
	0xe181, 0xe191, 0xe1a0, 0xe1af, 0xe1bd, 0xe1cc, 0xe1db, 0xe1e9,
	0xe1f8, 0xe207, 0xe216, 0xe224, 0xe233, 0xe243, 0xe252, 0xe261,
	0xe270, 0xe27e, 0xe28d, 0xe29d, 0xe2ac, 0xe2bc, 0xe2cc, 0xe2db,
	// Entry 3200 - 323F
	0xe2eb, 0xe2fc, 0xe30c, 0xe31d, 0xe32d, 0xe33d, 0xe34c, 0xe35c,
	0xe36c, 0xe37c, 0xe38b, 0xe39b, 0xe3ab, 0xe3ba, 0xe3ca, 0xe3da,
	0xe3ea, 0xe3f9, 0xe409, 0xe419, 0xe429, 0xe438, 0xe448, 0xe459,
	0xe469, 0xe479, 0xe489, 0xe498, 0xe4a8, 0xe4b9, 0xe4c9, 0xe4da,
	0xe4ea, 0xe4fa, 0xe509, 0xe519, 0xe529, 0xe539, 0xe548, 0xe558,
	0xe568, 0xe578, 0xe587, 0xe597, 0xe5a8, 0xe5b8, 0xe5c8, 0xe5d8,
	0xe5e7, 0xe5f7, 0xe608, 0xe618, 0xe628, 0xe638, 0xe647, 0xe657,
	0xe668, 0xe679, 0xe689, 0xe69a, 0xe6aa, 0xe6ba, 0xe6c9, 0xe6d9,
	// Entry 3240 - 327F
	0xe6e9, 0xe6f9, 0xe708, 0xe718, 0xe728, 0xe737, 0xe747, 0xe758,
	0xe768, 0xe778, 0xe788, 0xe797, 0xe7a7, 0xe7b8, 0xe7c8, 0xe7d8,
	0xe7e7, 0xe7f8, 0xe808, 0xe818, 0xe828, 0xe837, 0xe847, 0xe857,
	0xe867, 0xe876, 0xe886, 0xe896, 0xe8a6, 0xe8b5, 0xe8c5, 0xe8d6,
	0xe8e6, 0xe8f6, 0xe906, 0xe915, 0xe925, 0xe936, 0xe946, 0xe956,
	0xe966, 0xe975, 0xe985, 0xe995, 0xe9a4, 0xe9b4, 0xe9c4, 0xe9d4,
	0xe9e3, 0xe9f3, 0xea03, 0xea13, 0xea22, 0xea32, 0xea43, 0xea53,
	0xea63, 0xea73, 0xea82, 0xea92, 0xeaa3, 0xeab3, 0xeac3, 0xead3,
	// Entry 3280 - 32BF
	0xeae2, 0xeaf2, 0xeb03, 0xeb13, 0xeb24, 0xeb34, 0xeb44, 0xeb53,
	0xeb63, 0xeb73, 0xeb83, 0xeb92, 0xeba2, 0xebb2, 0xebc2, 0xebd1,
	0xebe1, 0xebf2, 0xec02, 0xec12, 0xec22, 0xec31, 0xec41, 0xec52,
	0xec62, 0xec71, 0xec80, 0xec8e, 0xec9d, 0xecad, 0xecbc, 0xeccc,
	0xecdb, 0xecea, 0xecf8, 0xed07, 0xed16, 0xed24, 0xed33, 0xed42,
	0xed51, 0xed5f, 0xed6e, 0xed7e, 0xed8d, 0xed9c, 0xedab, 0xedb9,
	0xedc8, 0xedd8, 0xede7, 0xedf6, 0xee05, 0xee13, 0xee22, 0xee32,
	0xee42, 0xee51, 0xee61, 0xee71, 0xee81, 0xee90, 0xeea0, 0xeeaf,
	// Entry 32C0 - 32FF
	0xeebe, 0xeecc, 0xeedb, 0xeeea, 0xeef9, 0xef07, 0xef16, 0xef26,
	0xef35, 0xef44, 0xef53, 0xef61, 0xef70, 0xef80, 0xef8f, 0xef9e,
	0xefad, 0xefbb, 0xefca, 0xefda, 0xefea, 0xeff9, 0xf009, 0xf019,
	0xf029, 0xf038, 0xf048, 0xf057, 0xf066, 0xf074, 0xf083, 0xf092,
	0xf0a1, 0xf0af, 0xf0be, 0xf0ce, 0xf0dd, 0xf0ec, 0xf0fb, 0xf109,
	0xf118, 0xf128, 0xf137, 0xf147, 0xf157, 0xf166, 0xf176, 0xf187,
	0xf198, 0xf1a8, 0xf1b9, 0xf1ca, 0xf1da, 0xf1eb, 0xf1fb, 0xf20b,
	0xf21a, 0xf22a, 0xf23a, 0xf24a, 0xf259, 0xf269, 0xf27a, 0xf28a,
	// Entry 3300 - 333F
	0xf29a, 0xf2aa, 0xf2b9, 0xf2c9, 0xf2d9, 0xf2e9, 0xf2f8, 0xf308,
	0xf319, 0xf32a, 0xf33a, 0xf34b, 0xf35c, 0xf36c, 0xf37c, 0xf38c,
	0xf39b, 0xf3ab, 0xf3bb, 0xf3ca, 0xf3da, 0xf3eb, 0xf3fb, 0xf40b,
	0xf41b, 0xf42a, 0xf43a, 0xf44b, 0xf45b, 0xf46b, 0xf47b, 0xf48a,
	0xf49a, 0xf4ab, 0xf4bc, 0xf4cc, 0xf4dd, 0xf4ee, 0xf4fe, 0xf50f,
	0xf51f, 0xf52f, 0xf53e, 0xf54e, 0xf55e, 0xf56e, 0xf57d, 0xf58d,
	0xf59c, 0xf5ab, 0xf5b9, 0xf5c8, 0xf5d8, 0xf5e8, 0xf5f7, 0xf607,
	0xf617, 0xf626, 0xf635, 0xf644, 0xf652, 0xf661, 0xf670, 0xf67f,
	// Entry 3340 - 337F
	0xf68d, 0xf69c, 0xf6ac, 0xf6bb, 0xf6ca, 0xf6d9, 0xf6e7, 0xf6f6,
	0xf706, 0xf716, 0xf725, 0xf735, 0xf745, 0xf755, 0xf764, 0xf774,
	0xf783, 0xf792, 0xf7a0, 0xf7af, 0xf7be, 0xf7cd, 0xf7db, 0xf7ea,
	0xf7fa, 0xf809, 0xf818, 0xf827, 0xf835, 0xf844, 0xf854, 0xf863,
	0xf871, 0xf87e, 0xf88c, 0xf89b, 0xf8a9, 0xf8b7, 0xf8c6, 0xf8d4,
	0xf8e1, 0xf8f0, 0xf8fe, 0xf90d, 0xf91b, 0xf928, 0xf936, 0xf945,
	0xf953, 0xf960, 0xf96e, 0xf97c, 0xf98b, 0xf999, 0xf9a8, 0xf9b7,
	0xf9c4, 0xf9d1, 0xf9e0, 0xf9ee, 0xf9fc, 0xfa0a, 0xfa18, 0xfa26,
	// Entry 3380 - 33BF
	0xfa34, 0xfa42, 0xfa4f, 0xfa5c, 0xfa6b, 0xfa79, 0xfa87, 0xfa96,
	0xfaa3, 0xfab0, 0xfabf, 0xfacd, 0xfada, 0xfae9, 0xfaf7, 0xfb06,
	0xfb15, 0xfb23, 0xfb32, 0xfb40, 0xfb50, 0xfb5f, 0xfb6c, 0xfb7a,
	0xfb88, 0xfb97, 0xfba5, 0xfbb3, 0xfbc2, 0xfbd0, 0xfbde, 0xfbed,
	0xfbfb, 0xfc09, 0xfc18, 0xfc27, 0xfc36, 0xfc46, 0xfc54, 0xfc62,
	0xfc70, 0xfc7e, 0xfc8d, 0xfc9b, 0xfcaa, 0xfcb8, 0xfcc6, 0xfcd5,
	0xfce3, 0xfcf1, 0xfd00, 0xfd0e, 0xfd1d, 0xfd2a, 0xfd38, 0xfd45,
	0xfd53, 0xfd60, 0xfd6d, 0xfd7a, 0xfd88, 0xfd96, 0xfda4, 0xfdbb,
	// Entry 33C0 - 33FF
	0xfdd1, 0xfde9, 0xfe00, 0xfe17, 0xfe2f, 0xfe45, 0xfe5f, 0xfe6e,
	0xfe7e, 0xfe8e, 0xfe9e, 0xfeaf, 0xfebf, 0xfed0, 0xfee0, 0xfef1,
	0xff02, 0xff14, 0xff25, 0xff35, 0xff45, 0xff55, 0xff66, 0xff77,
	0xff89, 0xff99, 0xffa9, 0xffb9, 0xffca, 0xffda, 0xffeb, 0xfffb,
	0x000c, 0x001c, 0x002c, 0x003d, 0x004d, 0x005d, 0x006f, 0x007f,
	0x008f, 0x009f, 0x00b0, 0x00be, 0x00cd, 0x00dc, 0x00ec, 0x00fb,
	0x010b, 0x011a, 0x012a, 0x0139, 0x0149, 0x0159, 0x016a, 0x017a,
	0x0189, 0x0198, 0x01a7, 0x01b7, 0x01c7, 0x01d8, 0x01e7, 0x01f6,
	// Entry 3400 - 343F
	0x0205, 0x0215, 0x0224, 0x0234, 0x0243, 0x0253, 0x0262, 0x0271,
	0x0281, 0x0290, 0x029f, 0x02b0, 0x02bf, 0x02ce, 0x02dd, 0x02ed,
	0x02fb, 0x030a, 0x031b, 0x032a, 0x033a, 0x0349, 0x0359, 0x0368,
	0x0378, 0x0387, 0x0397, 0x03a7, 0x03b8, 0x03c9, 0x03d9, 0x03e8,
	0x03f7, 0x0406, 0x0416, 0x0426, 0x0437, 0x0446, 0x0455, 0x0464,
	0x0474, 0x0483, 0x0493, 0x04a2, 0x04b2, 0x04c1, 0x04d0, 0x04e0,
	0x04ef, 0x04fe, 0x050e, 0x051f, 0x052e, 0x053d, 0x054c, 0x055c,
	0x056b, 0x057b, 0x058b, 0x059b, 0x05ac, 0x05bc, 0x05cd, 0x05dd,
	// Entry 3440 - 347F
	0x05ee, 0x05ff, 0x0611, 0x0622, 0x0632, 0x0642, 0x0652, 0x0663,
	0x0674, 0x0686, 0x0696, 0x06a6, 0x06b6, 0x06c7, 0x06d7, 0x06e8,
	0x06f8, 0x0709, 0x0719, 0x0729, 0x073a, 0x074a, 0x075a, 0x076c,
	0x077c, 0x078c, 0x079c, 0x07ad, 0x07bb, 0x07ca, 0x07d9, 0x07e9,
	0x07f8, 0x0808, 0x0817, 0x0827, 0x0836, 0x0846, 0x0856, 0x0867,
	0x0877, 0x0886, 0x0895, 0x08a4, 0x08b4, 0x08c4, 0x08d5, 0x08e4,
	0x08f3, 0x0902, 0x0912, 0x0921, 0x0931, 0x0940, 0x0950, 0x095f,
	0x096e, 0x097e, 0x098d, 0x099c, 0x09ad, 0x09bc, 0x09cb, 0x09da,
	// Entry 3480 - 34BF
	0x09ea, 0x09f8, 0x0a07, 0x0a18, 0x0a27, 0x0a37, 0x0a46, 0x0a56,
	0x0a65, 0x0a75, 0x0a84, 0x0a94, 0x0aa4, 0x0ab5, 0x0ac5, 0x0ad6,
	0x0ae5, 0x0af4, 0x0b03, 0x0b13, 0x0b23, 0x0b34, 0x0b43, 0x0b52,
	0x0b61, 0x0b71, 0x0b80, 0x0b90, 0x0b9f, 0x0baf, 0x0bbe, 0x0bcd,
	0x0bdd, 0x0bec, 0x0bfb, 0x0c0c, 0x0c1b, 0x0c2a, 0x0c39, 0x0c49,
	0x0c57, 0x0c66, 0x0c77, 0x0c86, 0x0c96, 0x0ca5, 0x0cb5, 0x0cc4,
	0x0cd4, 0x0ce3, 0x0cf3, 0x0d03, 0x0d14, 0x0d25, 0x0d35, 0x0d46,
	0x0d55, 0x0d64, 0x0d73, 0x0d83, 0x0d93, 0x0da4, 0x0db3, 0x0dc2,
	// Entry 34C0 - 34FF
	0x0dd1, 0x0de1, 0x0df0, 0x0e00, 0x0e0f, 0x0e1f, 0x0e2e, 0x0e3d,
	0x0e4d, 0x0e5c, 0x0e6b, 0x0e7c, 0x0e8e, 0x0e9d, 0x0ead, 0x0ebc,
	0x0ecb, 0x0edb, 0x0eea, 0x0f01, 0x0f0a, 0x0f17, 0x0f28, 0x0f3d,
	0x0f52, 0x0f68, 0x0f78, 0x0f88, 0x0f97, 0x0fa5, 0x0fb4, 0x0fc2,
	0x0fd0, 0x0fdf, 0x0fef, 0x0ffe, 0x100d, 0x101c, 0x102b, 0x1039,
	0x1046, 0x1053, 0x1062, 0x1070, 0x107e, 0x108b, 0x109a, 0x10a9,
	0x10b7, 0x10cc, 0x10e1, 0x10ff, 0x111b, 0x1138, 0x1153, 0x1177,
	0x1199, 0x11b5, 0x11cf, 0x11ec, 0x1207, 0x122b, 0x124d, 0x1270,
	// Entry 3500 - 353F
	0x1291, 0x12b4, 0x12d5, 0x12ff, 0x1327, 0x134b, 0x136d, 0x1390,
	0x13b1, 0x13d3, 0x13f3, 0x141c, 0x1443, 0x1466, 0x1487, 0x14b9,
	0x14e9, 0x1503, 0x151b, 0x153f, 0x1561, 0x1580, 0x159d, 0x15bc,
	0x15d9, 0x15f8, 0x1615, 0x1638, 0x1659, 0x167c, 0x169d, 0x16c7,
	0x16ef, 0x170c, 0x1724, 0x1748, 0x1770, 0x1799, 0x17aa, 0x17d0,
	0x17eb, 0x1807, 0x1822, 0x1845, 0x1863, 0x1886, 0x18a5, 0x18be,
	0x18d8, 0x18e7, 0x18f7, 0x1912, 0x192b, 0x1947, 0x1961, 0x197d,
	0x1997, 0x19b3, 0x19cd, 0x19e9, 0x1a03, 0x1a2e, 0x1a57, 0x1a72,
	// Entry 3540 - 357F
	0x1a8b, 0x1aa7, 0x1ac1, 0x1add, 0x1af7, 0x1b13, 0x1b2d, 0x1b48,
	0x1b61, 0x1b7d, 0x1b97, 0x1bb7, 0x1bd5, 0x1bf6, 0x1c15, 0x1c37,
	0x1c59, 0x1c75, 0x1c99, 0x1ca7, 0x1cb6, 0x1cc4, 0x1cd3, 0x1ce2,
	0x1cf2, 0x1d02, 0x1d10, 0x1d20, 0x1d2e, 0x1d3d, 0x1d4c, 0x1d5c,
	0x1d6d, 0x1d7f, 0x1d91, 0x1da1, 0x1db2, 0x1dc4, 0x1dd2, 0x1de2,
	0x1df1, 0x1e02, 0x1e11, 0x1e23, 0x1e34, 0x1e45, 0x1e55, 0x1e66,
	0x1e75, 0x1e87, 0x1e97, 0x1ea7, 0x1eb7, 0x1ec6, 0x1ed7, 0x1ee8,
	0x1ef9, 0x1f0a, 0x1f1b, 0x1f2b, 0x1f3b, 0x1f4b, 0x1f5b, 0x1f6a,
	// Entry 3580 - 35BF
	0x1f79, 0x1f88, 0x1f97, 0x1fa8, 0x1fb8, 0x1fc8, 0x1fdc, 0x1fed,
	0x1ffd, 0x200d, 0x201e, 0x202d, 0x203d, 0x204c, 0x205b, 0x206a,
	0x2079, 0x2089, 0x2098, 0x20a9, 0x20b9, 0x20c9, 0x20d8, 0x20e7,
	0x20f6, 0x2105, 0x2116, 0x2126, 0x2136, 0x2146, 0x2157, 0x2169,
	0x217c, 0x218e, 0x21a1, 0x21bd, 0x21db, 0x21e8, 0x21f7, 0x2202,
	0x220d, 0x221c, 0x222f, 0x2254, 0x227a, 0x22a0, 0x22c7, 0x22ea,
	0x230e, 0x2331, 0x2355, 0x237f, 0x23a3, 0x23c6, 0x23e9, 0x2412,
	0x2446, 0x2474, 0x24a1, 0x24ce, 0x2501, 0x252e, 0x2555, 0x257b,
	// Entry 35C0 - 35FF
	0x25a1, 0x25cd, 0x25ed, 0x2606, 0x2628, 0x2650, 0x266f, 0x2690,
	0x26b7, 0x26e7, 0x2714, 0x2738, 0x275b, 0x2782, 0x27a7, 0x27cd,
	0x27f1, 0x280a, 0x2821, 0x2838, 0x284d, 0x286a, 0x2885, 0x28a3,
	0x28bf, 0x28e8, 0x290f, 0x292b, 0x2947, 0x295e, 0x2973, 0x298a,
	0x299f, 0x29b6, 0x29cb, 0x29e2, 0x29f7, 0x2a22, 0x2a4b, 0x2a62,
	0x2a77, 0x2a9f, 0x2ac5, 0x2ae7, 0x2b07, 0x2b32, 0x2b5b, 0x2b91,
	0x2bc5, 0x2be2, 0x2bfd, 0x2c24, 0x2c49, 0x2c78, 0x2ca5, 0x2cc5,
	0x2ce3, 0x2cfa, 0x2d0f, 0x2d43, 0x2d75, 0x2d99, 0x2dbb, 0x2de4,
	// Entry 3600 - 363F
	0x2e0b, 0x2e3f, 0x2e71, 0x2e9c, 0x2ec5, 0x2ee3, 0x2eff, 0x2f1f,
	0x2f3d, 0x2f68, 0x2f91, 0x2fa8, 0x2fbd, 0x2fde, 0x2ffd, 0x3023,
	0x3047, 0x307f, 0x30b5, 0x30ce, 0x30e5, 0x30fc, 0x3111, 0x3128,
	0x313d, 0x3155, 0x316b, 0x317d, 0x3193, 0x31a9, 0x31bf, 0x31d5,
	0x31eb, 0x3209, 0x321f, 0x3234, 0x3252, 0x326e, 0x328c, 0x32a8,
	0x32c6, 0x32eb, 0x330e, 0x332b, 0x3346, 0x3364, 0x3380, 0x339e,
	0x33ba, 0x33d8, 0x33f4, 0x3419, 0x342e, 0x344f, 0x346c, 0x3487,
	0x34a4, 0x34d5, 0x34f1, 0x3516, 0x3539, 0x3558, 0x3575, 0x359b,
	// Entry 3640 - 367F
	0x35c1, 0x35e5, 0x3607, 0x3629, 0x3649, 0x3668, 0x3685, 0x36a4,
	0x36c1, 0x36e0, 0x36fd, 0x3727, 0x374f, 0x3779, 0x37a1, 0x37cb,
	0x37f3, 0x381d, 0x3845, 0x386f, 0x3897, 0x38b7, 0x38db, 0x38f8,
	0x3918, 0x393c, 0x3959, 0x3976, 0x399e, 0x39b6, 0x39cf, 0x39e6,
	0x3a00, 0x3a18, 0x3a3a, 0x3a5f, 0x3a80, 0x3aa3, 0x3ac5, 0x3ae7,
	0x3b09, 0x3b28, 0x3b49, 0x3b5e, 0x3b73, 0x3b8d, 0x3ba2, 0x3bb7,
	0x3bcc, 0x3be5, 0x3bfb, 0x3c12, 0x3c28, 0x3c3f, 0x3c59, 0x3c6f,
	0x3c86, 0x3c9c, 0x3cb3, 0x3cca, 0x3ce2, 0x3cf9, 0x3d11, 0x3d27,
	// Entry 3680 - 36BF
	0x3d3e, 0x3d54, 0x3d6b, 0x3d81, 0x3d97, 0x3dae, 0x3dc4, 0x3ddb,
	0x3df1, 0x3e07, 0x3e1d, 0x3e34, 0x3e4a, 0x3e60, 0x3e79, 0x3e92,
	0x3eab, 0x3ec4, 0x3ede, 0x3ef8, 0x3f12, 0x3f2c, 0x3f46, 0x3f66,
	0x3f83, 0x3fa6, 0x3fc8, 0x3fe7, 0x400c, 0x4024, 0x4040, 0x4056,
	0x406f, 0x4081, 0x4094, 0x40a6, 0x40b9, 0x40cb, 0x40de, 0x40f0,
	0x4103, 0x4115, 0x4128, 0x413a, 0x414c, 0x415e, 0x4171, 0x4183,
	0x4195, 0x41a8, 0x41bc, 0x41cf, 0x41e1, 0x41f4, 0x4206, 0x421d,
	0x422f, 0x4241, 0x4253, 0x4266, 0x4278, 0x428a, 0x429b, 0x42ac,
	// Entry 36C0 - 36FF
	0x42bd, 0x42ce, 0x42df, 0x42f1, 0x4303, 0x4315, 0x4328, 0x433a,
	0x4356, 0x4372, 0x4385, 0x4399, 0x43ac, 0x43bf, 0x43db, 0x43f8,
	0x4411, 0x442d, 0x4449, 0x4466, 0x4481, 0x449a, 0x44b3, 0x44c5,
	0x44de, 0x44f6, 0x450d, 0x4520, 0x4534, 0x4547, 0x455b, 0x456e,
	0x4582, 0x459d, 0x45b9, 0x45d4, 0x45f0, 0x4603, 0x4617, 0x462b,
	0x463e, 0x4652, 0x4666, 0x467a, 0x468f, 0x46a3, 0x46b8, 0x46cd,
	0x46e1, 0x46f6, 0x470a, 0x471f, 0x4734, 0x4749, 0x475f, 0x4774,
	0x478a, 0x479f, 0x47b3, 0x47c8, 0x47dc, 0x47f1, 0x4805, 0x4819,
	// Entry 3700 - 373F
	0x482e, 0x4842, 0x4857, 0x486b, 0x487f, 0x4893, 0x48a7, 0x48bb,
	0x48d0, 0x48e5, 0x48f9, 0x490d, 0x4922, 0x4941, 0x4959, 0x4970,
	0x4988, 0x499f, 0x49b7, 0x49d6, 0x49f6, 0x4a15, 0x4a35, 0x4a4c,
	0x4a64, 0x4a7c, 0x4a93, 0x4aab, 0x4ac3, 0x4ad9, 0x4af4, 0x4b04,
	0x4b1b, 0x4b30, 0x4b44, 0x4b58, 0x4b6e, 0x4b83, 0x4b98, 0x4bac,
	0x4bc2, 0x4bd8, 0x4bed, 0x4c0c, 0x4c2a, 0x4c48, 0x4c68, 0x4c87,
	0x4ca6, 0x4cc4, 0x4ce4, 0x4d04, 0x4d23, 0x4d40, 0x4d5d, 0x4d7b,
	0x4d99, 0x4db7, 0x4dd5, 0x4df3, 0x4e15, 0x4e38, 0x4e5a, 0x4e83,
	// Entry 3740 - 377F
	0x4ea2, 0x4ec3, 0x4ee7, 0x4eff, 0x4f14, 0x4f24, 0x4f39, 0x4f50,
	0x4f62, 0x4f75, 0x4f87, 0x4f99, 0x4fad, 0x4fc0, 0x4fd3, 0x4fe5,
	0x4ff9, 0x500d, 0x5020, 0x5032, 0x5045, 0x5057, 0x506a, 0x507c,
	0x508f, 0x50a1, 0x50b4, 0x50c6, 0x50d9, 0x50eb, 0x50fd, 0x5110,
	0x5122, 0x5134, 0x5146, 0x5158, 0x516a, 0x517c, 0x518e, 0x51a1,
	0x51b3, 0x51c5, 0x51d7, 0x51e8, 0x51fa, 0x520b, 0x521d, 0x522e,
	0x523e, 0x524e, 0x525f, 0x526f, 0x5283, 0x5296, 0x52b0, 0x52c1,
	0x52d3, 0x52e3, 0x52f3, 0x5304, 0x5314, 0x5324, 0x5334, 0x5344,
	// Entry 3780 - 37BF
	0x5354, 0x5364, 0x5374, 0x5384, 0x5395, 0x53a5, 0x53b5, 0x53c5,
	0x53d5, 0x53e5, 0x53f5, 0x5406, 0x5418, 0x5429, 0x543b, 0x544a,
	0x545d, 0x5470, 0x5483, 0x5497, 0x54aa, 0x54be, 0x54d2, 0x54e6,
	0x54fe, 0x5515, 0x552c, 0x5543, 0x5550, 0x5563, 0x557f, 0x559b,
	0x55b6, 0x55d2, 0x55ee, 0x560f, 0x562b, 0x564c, 0x5667, 0x5682,
	0x56a2, 0x56c5, 0x56df, 0x56fa, 0x5717, 0x5733, 0x574f, 0x5769,
	0x578b, 0x57a8, 0x57c3, 0x57e2, 0x57fd, 0x5818, 0x5838, 0x5854,
	0x5871, 0x588b, 0x58ab, 0x58c2, 0x58d5, 0x58e8, 0x58fd, 0x590e,
	// Entry 37C0 - 37FF
	0x5924, 0x5935, 0x5947, 0x5958, 0x5970, 0x5989, 0x59aa, 0x59bb,
	0x59cd, 0x59de, 0x59f0, 0x5a08, 0x5a20, 0x5a32, 0x5a4a, 0x5a5d,
	0x5a6f, 0x5a87, 0x5a99, 0x5ab2, 0x5ace, 0x5ae1, 0x5af4, 0x5b11,
	0x5b24, 0x5b41, 0x5b59, 0x5b6b, 0x5b83, 0x5b95, 0x5bb1, 0x5bc3,
	0x5bd5, 0x5bed, 0x5bff, 0x5c17, 0x5c29, 0x5c3b, 0x5c4d, 0x5c65,
	0x5c77, 0x5c89, 0x5ca1, 0x5cbd, 0x5ccf, 0x5ce1, 0x5cf9, 0x5d13,
	0x5d2d, 0x5d45, 0x5d63, 0x5d7b, 0x5d9a, 0x5db4, 0x5dd2, 0x5deb,
	0x5e08, 0x5e27, 0x5e44, 0x5e54, 0x5e6b, 0x5e83, 0x5e96, 0x5ea9,
	// Entry 3800 - 383F
	0x5ebc, 0x5ecf, 0x5ee4, 0x5ef8, 0x5f0c, 0x5f1e, 0x5f35, 0x5f4a,
	0x5f66, 0x5f7a, 0x5f8d, 0x5f9f, 0x5fb1, 0x5fc5, 0x5fd8, 0x5feb,
	0x5ffd, 0x6011, 0x6025, 0x6038, 0x6053, 0x606a, 0x6081, 0x6098,
	0x60af, 0x60c6, 0x60dd, 0x60f2, 0x611c, 0x6138, 0x6153, 0x616e,
	0x618a, 0x61a5, 0x61c1, 0x61dd, 0x61fa, 0x6216, 0x6232, 0x624d,
	0x6268, 0x6285, 0x62a1, 0x62bd, 0x62d8, 0x62f5, 0x6312, 0x632e,
	0x634a, 0x6365, 0x6381, 0x639c, 0x63b8, 0x63c5, 0x63d2, 0x63df,
	0x63ec, 0x63fa, 0x6407, 0x6415, 0x6424, 0x6432, 0x6441, 0x6451,
	// Entry 3840 - 387F
	0x6460, 0x646f, 0x647f, 0x648d, 0x649c, 0x64ac, 0x64bb, 0x64cb,
	0x64d9, 0x64e8, 0x64f6, 0x6505, 0x6514, 0x6522, 0x6531, 0x653f,
	0x654e, 0x655d, 0x656b, 0x657a, 0x6589, 0x6597, 0x65a6, 0x65b4,
	0x65c2, 0x65d0, 0x65de, 0x65ed, 0x65fb, 0x6609, 0x661b, 0x662c,
	0x663e, 0x6650, 0x6661, 0x6673, 0x6684, 0x6696, 0x66a8, 0x66ba,
	0x66d0, 0x66e6, 0x66fc, 0x6712, 0x6725, 0x6738, 0x674c, 0x6768,
	0x677c, 0x678f, 0x67a2, 0x67b5, 0x67c8, 0x67db, 0x67ee, 0x6802,
	0x681d, 0x6838, 0x6847, 0x6855, 0x6863, 0x6873, 0x6882, 0x6891,
	// Entry 3880 - 38BF
	0x689f, 0x68af, 0x68bf, 0x68ce, 0x68e5, 0x68fb, 0x6918, 0x6935,
	0x694d, 0x6965, 0x697e, 0x6996, 0x69af, 0x69c8, 0x69e1, 0x69fb,
	0x6a14, 0x6a2e, 0x6a47, 0x6a5f, 0x6a77, 0x6a8f, 0x6aa8, 0x6ac0,
	0x6aec, 0x6b04, 0x6b1c, 0x6b34, 0x6b4f, 0x6b69, 0x6b83, 0x6ba3,
	0x6bbb, 0x6bd3, 0x6bea, 0x6c05, 0x6c22, 0x6c3f, 0x6c5e, 0x6c7d,
	0x6c93, 0x6caa, 0x6cc1, 0x6cd9, 0x6cf1, 0x6d0a, 0x6d20, 0x6d37,
	0x6d4e, 0x6d66, 0x6d7c, 0x6d93, 0x6daa, 0x6dc2, 0x6dd8, 0x6def,
	0x6e06, 0x6e1e, 0x6e34, 0x6e4b, 0x6e61, 0x6e78, 0x6e8f, 0x6ea7,
	// Entry 38C0 - 38FF
	0x6ebd, 0x6ed4, 0x6eea, 0x6f01, 0x6f17, 0x6f2e, 0x6f45, 0x6f5d,
	0x6f73, 0x6f8a, 0x6fa0, 0x6fb7, 0x6fcd, 0x6fe4, 0x6ffa, 0x7011,
	0x7027, 0x703e, 0x7054, 0x706b, 0x7081, 0x7098, 0x70ad, 0x70c3,
	0x70d4, 0x70e5, 0x70f5, 0x7106, 0x7116, 0x7126, 0x7136, 0x7147,
	0x7158, 0x716a, 0x717b, 0x718d, 0x719e, 0x71af, 0x71c0, 0x71d4,
	0x71eb, 0x7200, 0x7216, 0x7229, 0x723e, 0x7251, 0x7267, 0x727e,
	0x7293, 0x72a8, 0x72bf, 0x72d6, 0x72ed, 0x7305, 0x731c, 0x7334,
	0x734b, 0x7362, 0x7379, 0x7393, 0x73ad, 0x73c8, 0x73e2, 0x73fd,
	// Entry 3900 - 393F
	0x7412, 0x742b, 0x743c, 0x7461, 0x7482, 0x74a1, 0x74b4, 0x74ca,
	0x74e0, 0x74f7, 0x750e, 0x7524, 0x753a, 0x7550, 0x7566, 0x757d,
	0x7594, 0x75aa, 0x75c0, 0x75d5, 0x75ea, 0x7600, 0x7616, 0x762b,
	0x7640, 0x7657, 0x766e, 0x7685, 0x769d, 0x76b5, 0x76cc, 0x76e3,
	0x76f8, 0x770d, 0x7722, 0x7738, 0x774e, 0x7763, 0x7778, 0x7797,
	0x77ba, 0x77da, 0x77f5, 0x7817, 0x7831, 0x785e, 0x7887, 0x78b4,
	0x78d9, 0x78ff, 0x7925, 0x794d, 0x796d, 0x7999, 0x79be, 0x79dc,
	0x7a04, 0x7a37, 0x7a59, 0x7a87, 0x7aa3, 0x7ace, 0x7af1, 0x7b0c,
	// Entry 3940 - 397F
	0x7b32, 0x7b5f, 0x7b7a, 0x7b9f, 0x7bbe, 0x7be7, 0x7c14, 0x7c29,
	0x7c45, 0x7c68, 0x7c7e, 0x7ca8, 0x7cd2, 0x7cfa, 0x7d21, 0x7d5b,
	0x7d8d, 0x7db6, 0x7dd8, 0x7df2, 0x7e1e, 0x7e47, 0x7e6d, 0x7e89,
	0x7ea6, 0x7ec0, 0x7ed5, 0x7ef6, 0x7f16, 0x7f2d, 0x7f44, 0x7f5b,
	0x7f72, 0x7f89, 0x7fa0, 0x7fb8, 0x7fd0, 0x7fe8, 0x8000, 0x8018,
	0x8030, 0x8048, 0x8060, 0x8078, 0x8090, 0x80a8, 0x80c0, 0x80d8,
	0x80f0, 0x8108, 0x8120, 0x8138, 0x8150, 0x8168, 0x8180, 0x8198,
	0x81b0, 0x81c8, 0x81e0, 0x81f8, 0x8211, 0x822a, 0x8242, 0x825a,
	// Entry 3980 - 39BF
	0x8272, 0x828a, 0x82a2, 0x82bb, 0x82d4, 0x82ed, 0x8306, 0x831f,
	0x8338, 0x8350, 0x8367, 0x837f, 0x8397, 0x83af, 0x83c7, 0x83df,
	0x83f7, 0x840f, 0x8427, 0x843f, 0x8457, 0x846f, 0x8487, 0x849f,
	0x84b7, 0x84d0, 0x84e9, 0x8502, 0x851b, 0x8534, 0x854d, 0x8566,
	0x857f, 0x8598, 0x85b1, 0x85ca, 0x85e3, 0x85fc, 0x8614, 0x862c,
	0x8644, 0x865c, 0x8674, 0x868c, 0x86a4, 0x86bb, 0x86d2, 0x86e9,
	0x8700, 0x8716, 0x872c, 0x8744, 0x875b, 0x8773, 0x878b, 0x87a3,
	0x87ba, 0x87d2, 0x87e9, 0x87ff, 0x8814, 0x882c, 0x8845, 0x885c,
	// Entry 39C0 - 39FF
	0x8874, 0x888b, 0x88a1, 0x88b8, 0x88cf, 0x88e7, 0x88ff, 0x8917,
	0x8935, 0x8953, 0x8971, 0x898e, 0x89ab, 0x89c9, 0x89e8, 0x8a04,
	0x8a20, 0x8a3c, 0x8a58, 0x8a75, 0x8a93, 0x8aaf, 0x8ace, 0x8aea,
	0x8aff, 0x8b14, 0x8b2a, 0x8b41, 0x8b57, 0x8b6d, 0x8b85, 0x8b9c,
	0x8bb3, 0x8bc9, 0x8be1, 0x8bf9, 0x8c10, 0x8c26, 0x8c3c, 0x8c51,
	0x8c67, 0x8c7d, 0x8c93, 0x8ca9, 0x8cbf, 0x8cd4, 0x8ce9, 0x8cff,
	0x8d14, 0x8d29, 0x8d40, 0x8d56, 0x8d6c, 0x8d81, 0x8d97, 0x8dac,
	0x8dc1, 0x8dd5, 0x8ded, 0x8e05, 0x8e21, 0x8e3f, 0x8e5b, 0x8e7d,
	// Entry 3A00 - 3A3F
	0x8e9a, 0x8eb6, 0x8ed9, 0x8ef6, 0x8f15, 0x8f34, 0x8f56, 0x8f79,
	0x8f9c, 0x8fbe, 0x8fe1, 0x9005, 0x9024, 0x904c, 0x906a, 0x9086,
	0x90a7, 0x90c2, 0x90e3, 0x90ff, 0x911c, 0x9140, 0x915c, 0x9177,
	0x9199, 0x91b5, 0x91d3, 0x91ee, 0x9211, 0x9232, 0x9253, 0x9270,
	0x928b, 0x92a8, 0x92c5, 0x92e0, 0x92fe, 0x9324, 0x9343, 0x9362,
	0x937e, 0x939f, 0x93ba, 0x93d7, 0x93f7, 0x9417, 0x9437, 0x9457,
	0x9477, 0x9497, 0x94b7, 0x94d7, 0x94f7, 0x9517, 0x9537, 0x9557,
	0x9577, 0x9597, 0x95b7, 0x95d7, 0x95f7, 0x9617, 0x9637, 0x9657,
	// Entry 3A40 - 3A7F
	0x9677, 0x9697, 0x96b7, 0x96d7, 0x96f7, 0x9717, 0x9737, 0x9757,
	0x9777, 0x9797, 0x97b7, 0x97d7, 0x97f7, 0x9817, 0x9837, 0x9857,
	0x9877, 0x9897, 0x98b7, 0x98d7, 0x98f7, 0x9917, 0x9937, 0x9957,
	0x9977, 0x9997, 0x99b7, 0x99d7, 0x99f7, 0x9a17, 0x9a37, 0x9a57,
	0x9a77, 0x9a97, 0x9ab7, 0x9ad7, 0x9af7, 0x9b17, 0x9b37, 0x9b57,
	0x9b77, 0x9b97, 0x9bb7, 0x9bd7, 0x9bf7, 0x9c17, 0x9c37, 0x9c57,
	0x9c77, 0x9c97, 0x9cb7, 0x9cd7, 0x9cf7, 0x9d17, 0x9d37, 0x9d57,
	0x9d77, 0x9d97, 0x9db7, 0x9dd7, 0x9df7, 0x9e17, 0x9e37, 0x9e57,
	// Entry 3A80 - 3ABF
	0x9e77, 0x9e97, 0x9eb7, 0x9ed7, 0x9ef7, 0x9f17, 0x9f37, 0x9f57,
	0x9f77, 0x9f97, 0x9fb7, 0x9fd7, 0x9ff7, 0xa017, 0xa037, 0xa057,
	0xa077, 0xa097, 0xa0b7, 0xa0d7, 0xa0f7, 0xa117, 0xa137, 0xa157,
	0xa177, 0xa197, 0xa1b7, 0xa1d7, 0xa1f7, 0xa217, 0xa237, 0xa257,
	0xa277, 0xa297, 0xa2b7, 0xa2d7, 0xa2f7, 0xa317, 0xa337, 0xa357,
	0xa377, 0xa397, 0xa3b7, 0xa3d7, 0xa3f7, 0xa417, 0xa437, 0xa457,
	0xa477, 0xa497, 0xa4b7, 0xa4d7, 0xa4f7, 0xa517, 0xa537, 0xa557,
	0xa577, 0xa597, 0xa5b7, 0xa5d7, 0xa5f7, 0xa617, 0xa637, 0xa657,
	// Entry 3AC0 - 3AFF
	0xa677, 0xa697, 0xa6b7, 0xa6d7, 0xa6f7, 0xa717, 0xa737, 0xa757,
	0xa777, 0xa797, 0xa7b7, 0xa7d7, 0xa7f7, 0xa817, 0xa837, 0xa857,
	0xa877, 0xa897, 0xa8b7, 0xa8d7, 0xa8f7, 0xa917, 0xa937, 0xa957,
	0xa977, 0xa997, 0xa9b7, 0xa9d7, 0xa9f7, 0xaa17, 0xaa37, 0xaa57,
	0xaa77, 0xaa97, 0xaab7, 0xaad7, 0xaaf7, 0xab17, 0xab37, 0xab57,
	0xab77, 0xab97, 0xabb7, 0xabd7, 0xabf7, 0xac17, 0xac37, 0xac57,
	0xac77, 0xac97, 0xacb7, 0xacd7, 0xacf7, 0xad17, 0xad37, 0xad57,
	0xad77, 0xad97, 0xadb7, 0xadd7, 0xadf7, 0xae17, 0xae37, 0xae57,
	// Entry 3B00 - 3B3F
	0xae77, 0xae97, 0xaeb7, 0xaed7, 0xaef7, 0xaf17, 0xaf37, 0xaf57,
	0xaf77, 0xaf97, 0xafb7, 0xafd7, 0xaff7, 0xb017, 0xb037, 0xb057,
	0xb077, 0xb097, 0xb0b7, 0xb0d7, 0xb0f7, 0xb117, 0xb137, 0xb157,
	0xb177, 0xb197, 0xb1b7, 0xb1d7, 0xb1f7, 0xb217, 0xb237, 0xb257,
	0xb277, 0xb297, 0xb2b7, 0xb2d7, 0xb2f7, 0xb317, 0xb337, 0xb357,
	0xb377, 0xb397, 0xb3b7, 0xb3d7, 0xb3f7, 0xb417, 0xb437, 0xb457,
	0xb477, 0xb497, 0xb4b7, 0xb4d7, 0xb4f7, 0xb517, 0xb537, 0xb557,
	0xb577, 0xb597, 0xb5b7, 0xb5d7, 0xb5f7, 0xb617, 0xb637, 0xb657,
	// Entry 3B40 - 3B7F
	0xb677, 0xb697, 0xb6b7, 0xb6d7, 0xb6f7, 0xb717, 0xb737, 0xb757,
	0xb777, 0xb797, 0xb7b7, 0xb7d7, 0xb7f7, 0xb817, 0xb837, 0xb857,
	0xb877, 0xb897, 0xb8b7, 0xb8d7, 0xb8f7, 0xb917, 0xb937, 0xb957,
	0xb977, 0xb997, 0xb9b7, 0xb9d7, 0xb9f7, 0xba17, 0xba37, 0xba57,
	0xba77, 0xba97, 0xbab7, 0xbad7, 0xbaf7, 0xbb17, 0xbb37, 0xbb57,
	0xbb77, 0xbb97, 0xbbb7, 0xbbd7, 0xbbf7, 0xbc17, 0xbc37, 0xbc57,
	0xbc77, 0xbc97, 0xbcb7, 0xbcd7, 0xbcf7, 0xbd17, 0xbd37, 0xbd57,
	0xbd77, 0xbd97, 0xbdb7, 0xbdd7, 0xbdf7, 0xbe17, 0xbe37, 0xbe57,
	// Entry 3B80 - 3BBF
	0xbe77, 0xbe97, 0xbeb7, 0xbed7, 0xbef7, 0xbf17, 0xbf37, 0xbf57,
	0xbf77, 0xbf97, 0xbfb7, 0xbfd7, 0xbff7, 0xc017, 0xc037, 0xc057,
	0xc077, 0xc097, 0xc0b7, 0xc0d7, 0xc0f7, 0xc117, 0xc137, 0xc157,
	0xc177, 0xc197, 0xc1b7, 0xc1d7, 0xc1f7, 0xc217, 0xc237, 0xc257,
	0xc277, 0xc297, 0xc2b7, 0xc2d7, 0xc2f7, 0xc317, 0xc337, 0xc357,
	0xc377, 0xc397, 0xc3b7, 0xc3d7, 0xc3f7, 0xc417, 0xc437, 0xc457,
	0xc477, 0xc497, 0xc4b7, 0xc4d7, 0xc4f7, 0xc517, 0xc537, 0xc557,
	0xc577, 0xc597, 0xc5b7, 0xc5d7, 0xc5f7, 0xc617, 0xc637, 0xc657,
	// Entry 3BC0 - 3BFF
	0xc677, 0xc697, 0xc6b7, 0xc6d7, 0xc6f7, 0xc717, 0xc737, 0xc757,
	0xc777, 0xc797, 0xc7b7, 0xc7d7, 0xc7f7, 0xc817, 0xc837, 0xc857,
	0xc877, 0xc897, 0xc8b7, 0xc8d7, 0xc8f7, 0xc917, 0xc937, 0xc957,
	0xc977, 0xc997, 0xc9b7, 0xc9d7, 0xc9f7, 0xca17, 0xca37, 0xca57,
	0xca77, 0xca97, 0xcab7, 0xcad7, 0xcaf7, 0xcb17, 0xcb37, 0xcb57,
	0xcb77, 0xcb97, 0xcbb7, 0xcbd7, 0xcbf7, 0xcc17, 0xcc37, 0xcc57,
	0xcc77, 0xcc97, 0xccb7, 0xccd7, 0xccf7, 0xcd17, 0xcd37, 0xcd57,
	0xcd77, 0xcd97, 0xcdb7, 0xcdd7, 0xcdf7, 0xce17, 0xce37, 0xce57,
	// Entry 3C00 - 3C3F
	0xce77, 0xce97, 0xceb7, 0xced7, 0xcef7, 0xcf0e, 0xcf25, 0xcf3c,
	0xcf54, 0xcf6c, 0xcf89, 0xcfa0, 0xcfbf, 0xcfde, 0xcffd, 0xd01c,
	0xd03b, 0xd057, 0xd078, 0xd09d, 0xd0bb, 0xd0d2, 0xd0ea, 0xd0ff,
	0xd115, 0xd12d, 0xd149, 0xd160, 0xd176, 0xd199, 0xd1b9, 0xd1d8,
	0xd203, 0xd22d, 0xd24a, 0xd268, 0xd285, 0xd2a2, 0xd2c1, 0xd2e0,
	0xd2fb, 0xd318, 0xd337, 0xd354, 0xd371, 0xd394, 0xd3b1, 0xd3d0,
	0xd3ed, 0xd40a, 0xd42a, 0xd44c, 0xd468, 0xd487, 0xd4a4, 0xd4c2,
	0xd4e0, 0xd4fd, 0xd519, 0xd534, 0xd54f, 0xd569, 0xd583, 0xd5a9,
	// Entry 3C40 - 3C7F
	0xd5cc, 0xd5ec, 0xd609, 0xd628, 0xd646, 0xd665, 0xd681, 0xd69f,
	0xd6bc, 0xd6dd, 0xd6fb, 0xd71b, 0xd73a, 0xd75c, 0xd77b, 0xd79c,
	0xd7bc, 0xd7dd, 0xd7fb, 0xd81b, 0xd83a, 0xd85a, 0xd877, 0xd896,
	0xd8b4, 0xd8d3, 0xd8ef, 0xd90d, 0xd92a, 0xd94b, 0xd969, 0xd989,
	0xd9a8, 0xd9c8, 0xd9e5, 0xda04, 0xda22, 0xda42, 0xda5f, 0xda7e,
	0xda9c, 0xdabd, 0xdadb, 0xdafb, 0xdb1a, 0xdb3d, 0xdb5d, 0xdb7f,
	0xdba0, 0xdbc2, 0xdbe1, 0xdc02, 0xdc20, 0xdc3f, 0xdc5b, 0xdc7b,
	0xdc98, 0xdcb7, 0xdcd3, 0xdcf3, 0xdd10, 0xdd31, 0xdd4f, 0xdd6f,
	// Entry 3C80 - 3CBF
	0xdd8e, 0xddad, 0xddc9, 0xdde7, 0xde04, 0xde24, 0xde41, 0xde60,
	0xde7e, 0xde9f, 0xdebd, 0xdedd, 0xdefc, 0xdf23, 0xdf47, 0xdf68,
	0xdf86, 0xdfa6, 0xdfc5, 0xdff3, 0xe01e, 0xe042, 0xe063, 0xe086,
	0xe0a8, 0xe0d3, 0xe0fb, 0xe125, 0xe14e, 0xe174, 0xe197, 0xe1ce,
	0xe202, 0xe219, 0xe230, 0xe24c, 0xe268, 0xe286, 0xe2a4, 0xe2d5,
	0xe306, 0xe323, 0xe340, 0xe367, 0xe38e, 0xe3b5, 0xe3c7, 0xe3e4,
	0xe401, 0xe41f, 0xe43a, 0xe457, 0xe473, 0xe490, 0xe4aa, 0xe4c8,
	0xe4e3, 0xe501, 0xe51c, 0xe54a, 0xe568, 0xe583, 0xe5a9, 0xe5cc,
	// Entry 3CC0 - 3CFF
	0xe5f2, 0xe615, 0xe632, 0xe64c, 0xe668, 0xe683, 0xe6c0, 0xe6fc,
	0xe738, 0xe771, 0xe7ab, 0xe7e2, 0xe81d, 0xe855, 0xe88e, 0xe8c4,
	0xe8fe, 0xe935, 0xe96f, 0xe9a6, 0xe9df, 0xea15, 0xea4d, 0xeaa0,
	0xeaf0, 0xeb42, 0xeb67, 0xeb89, 0xebad, 0xebd0, 0xec0c, 0xec47,
	0xec83, 0xecc7, 0xed02, 0xed2d, 0xed57, 0xed82, 0xedad, 0xede0,
	0xee0a, 0xee35, 0xee5f, 0xee8a, 0xeeb5, 0xeee8, 0xef12, 0xef3e,
	0xef6a, 0xef9e, 0xefc9, 0xeff4, 0xf020, 0xf04b, 0xf076, 0xf0a2,
	0xf0cd, 0xf0f9, 0xf125, 0xf150, 0xf17c, 0xf1a8, 0xf1d2, 0xf1fd,
	// Entry 3D00 - 3D3F
	0xf228, 0xf252, 0xf27d, 0xf2a8, 0xf2d2, 0xf2fd, 0xf328, 0xf353,
	0xf37e, 0xf3ab, 0xf3d8, 0xf403, 0xf42d, 0xf458, 0xf483, 0xf4b6,
	0xf4e0, 0xf50a, 0xf535, 0xf568, 0xf592, 0xf5bd, 0xf5e8, 0xf612,
	0xf63d, 0xf667, 0xf692, 0xf6c5, 0xf6ef, 0xf71a, 0xf744, 0xf76f,
	0xf79a, 0xf7cd, 0xf7f7, 0xf823, 0xf84e, 0xf87a, 0xf8a6, 0xf8da,
	0xf905, 0xf931, 0xf95c, 0xf988, 0xf9b4, 0xf9e8, 0xfa13, 0xfa3e,
	0xfa69, 0xfa9c, 0xfac6, 0xfaf1, 0xfb1b, 0xfb46, 0xfb71, 0xfba4,
	0xfbce, 0xfc06, 0xfc3d, 0xfc7d, 0xfcaf, 0xfce1, 0xfd10, 0xfd3f,
	// Entry 3D40 - 3D7F
	0xfd6e, 0xfda8, 0xfde0, 0xfe19, 0xfe52, 0xfe8b, 0xfecc, 0xff04,
	0xff2b, 0xff53, 0xff7b, 0xffa3, 0xffd3, 0xfffa, 0x0021, 0x0049,
	0x0071, 0x0099, 0x00c9, 0x00f0, 0x0118, 0x0141, 0x016a, 0x0193,
	0x01c4, 0x01ec, 0x021c, 0x0243, 0x0273, 0x029a, 0x02c2, 0x02e9,
	0x0311, 0x0341, 0x0368, 0x0390, 0x03c0, 0x03e7, 0x0410, 0x0439,
	0x0461, 0x048a, 0x04b3, 0x04dc, 0x050d, 0x0535, 0x0572, 0x0599,
	0x05c1, 0x05e9, 0x0611, 0x0641, 0x0668, 0x06a3, 0x06dd, 0x0718,
	0x0753, 0x078d, 0x07b7, 0x07e0, 0x080a, 0x0834, 0x085d, 0x0887,
	// Entry 3D80 - 3DBF
	0x08b0, 0x08da, 0x0904, 0x092d, 0x0958, 0x0982, 0x09ad, 0x09d7,
	0x0a01, 0x0a2c, 0x0a57, 0x0a82, 0x0aac, 0x0ad7, 0x0b02, 0x0b2b,
	0x0b55, 0x0b7f, 0x0ba9, 0x0bd2, 0x0bfc, 0x0c26, 0x0c4f, 0x0c79,
	0x0ca3, 0x0ccd, 0x0cf9, 0x0d25, 0x0d4f, 0x0d78, 0x0da2, 0x0dcc,
	0x0df5, 0x0e1f, 0x0e49, 0x0e72, 0x0e9c, 0x0ec5, 0x0eef, 0x0f19,
	0x0f42, 0x0f6c, 0x0f96, 0x0fbf, 0x0fea, 0x1014, 0x103f, 0x106a,
	0x1095, 0x10bf, 0x10ea, 0x1115, 0x113f, 0x1169, 0x1193, 0x11c9,
	0x11f3, 0x121c, 0x1246, 0x1270, 0x1299, 0x12d3, 0x130c, 0x1335,
	// Entry 3DC0 - 3DFF
	0x135d, 0x1386, 0x13ae, 0x13d8, 0x1401, 0x142b, 0x1454, 0x147f,
	0x14a9, 0x14d1, 0x14fa, 0x1523, 0x154d, 0x1576, 0x159f, 0x15c7,
	0x15f4, 0x1621, 0x164e, 0x1681, 0x16ab, 0x16de, 0x1708, 0x173d,
	0x1769, 0x179d, 0x17c8, 0x17fd, 0x1829, 0x185c, 0x1886, 0x18ba,
	0x18e5, 0x1919, 0x1944, 0x1977, 0x19a1, 0x19d4, 0x19fe, 0x1a2b,
	0x1a57, 0x1a84, 0x1ab1, 0x1add, 0x1b08, 0x1b32, 0x1b5c, 0x1b8c,
	0x1bb3, 0x1be3, 0x1c0a, 0x1c3c, 0x1c65, 0x1c96, 0x1cbe, 0x1cf0,
	0x1d19, 0x1d49, 0x1d70, 0x1da1, 0x1dc9, 0x1dfa, 0x1e22, 0x1e52,
	// Entry 3E00 - 3E3F
	0x1e79, 0x1ea9, 0x1ed0, 0x1efa, 0x1f23, 0x1f4d, 0x1f77, 0x1fa0,
	0x1fc8, 0x1fef, 0x2016, 0x2042, 0x206d, 0x2099, 0x20c5, 0x20ef,
	0x211a, 0x2144, 0x216e, 0x2197, 0x21c1, 0x21ec, 0x2216, 0x2241,
	0x226a, 0x2293, 0x22c0, 0x22f0, 0x2307, 0x231f, 0x2353, 0x2384,
	0x23b7, 0x23ea, 0x241e, 0x2452, 0x2485, 0x24b9, 0x24eb, 0x251f,
	0x2550, 0x258a, 0x25be, 0x25f2, 0x262d, 0x265f, 0x2693, 0x26c8,
	0x26fb, 0x2730, 0x2760, 0x2792, 0x27c4, 0x27f7, 0x282c, 0x285f,
	0x2893, 0x28c9, 0x28fd, 0x2933, 0x296c, 0x299e, 0x29d2, 0x2a03,
	// Entry 3E40 - 3E7F
	0x2a36, 0x2a6a, 0x2a9b, 0x2acd, 0x2aff, 0x2b33, 0x2b6d, 0x2ba1,
	0x2bd4, 0x2c10, 0x2c42, 0x2c76, 0x2ca7, 0x2cd9, 0x2d0a, 0x2d3a,
	0x2d73, 0x2da7, 0x2dd9, 0x2e0b, 0x2e3f, 0x2e70, 0x2ea3, 0x2ed7,
	0x2f0b, 0x2f3c, 0x2f70, 0x2fa5, 0x2fda, 0x300f, 0x3044, 0x3078,
	0x30ac, 0x30e0, 0x311a, 0x314d, 0x3182, 0x31bd, 0x31ef, 0x322a,
	0x325c, 0x3290, 0x32c1, 0x32f2, 0x332c, 0x335d, 0x3397, 0x33c8,
	0x3402, 0x3434, 0x346e, 0x34a9, 0x34e4, 0x3514, 0x3546, 0x3576,
	0x35a7, 0x35d8, 0x3608, 0x3639, 0x366a, 0x369c, 0x36cd, 0x36fe,
	// Entry 3E80 - 3EBF
	0x3731, 0x3764, 0x3795, 0x37c6, 0x37fa, 0x382c, 0x3860, 0x3892,
	0x38c4, 0x38f6, 0x3927, 0x3958, 0x398a, 0x39bb, 0x39eb, 0x3a1f,
	0x3a53, 0x3a87, 0x3ab9, 0x3aeb, 0x3b28, 0x3b64, 0x3b87, 0x3baa,
	0x3bd0, 0x3bf3, 0x3c17, 0x3c3b, 0x3c61, 0x3c84, 0x3caf, 0x3cce,
	0x3cd7, 0x3d04, 0x3d18, 0x3d2c, 0x3d40, 0x3d54, 0x3d68, 0x3d7c,
	0x3d90, 0x3da4, 0x3db8, 0x3dcd, 0x3de2, 0x3df7, 0x3e0c, 0x3e21,
	0x3e36, 0x3e4b, 0x3e6f, 0x3e9f, 0x3ed3, 0x3ef7, 0x3f1f, 0x3f4e,
	0x3f7a, 0x3fb6, 0x3ff3, 0x4025, 0x4041, 0x405e, 0x407e, 0x409f,
	// Entry 3EC0 - 3EFF
	0x40b9, 0x40d4, 0x40ef, 0x4111, 0x4134, 0x4153, 0x4173, 0x4193,
	0x41b4, 0x41d5, 0x41f7, 0x421a, 0x4247, 0x426d, 0x4293, 0x42ba,
	0x42e6, 0x4315, 0x4345, 0x4376, 0x43a8, 0x43e2, 0x441d, 0x4459,
	0x4496, 0x44ce, 0x4507, 0x4538, 0x456a, 0x459c, 0x45cf, 0x4607,
	0x4640, 0x464a, 0x465a, 0x468c, 0x46bf, 0x46ce, 0x46e1, 0x46ee,
	0x4702, 0x4711, 0x4724, 0x4731, 0x473c, 0x4753, 0x4762, 0x4771,
	0x477c, 0x478f, 0x47a5, 0x47b2, 0x47c8, 0x47df, 0x47f7, 0x4810,
	0x4831, 0x4853, 0x4864, 0x4873, 0x4881, 0x4890, 0x48a2, 0x48b6,
	// Entry 3F00 - 3F3F
	0x48cd, 0x48de, 0x48f3, 0x4904, 0x4916, 0x4929, 0x4946, 0x4968,
	0x4985, 0x4999, 0x49b6, 0x49d0, 0x49e8, 0x4a02, 0x4a1a, 0x4a34,
	0x4a4c, 0x4a67, 0x4a80, 0x4a9a, 0x4ab2, 0x4ad3, 0x4b04, 0x4b32,
	0x4b63, 0x4b91, 0x4bc1, 0x4bee, 0x4c1f, 0x4c4d, 0x4c7d, 0x4caa,
	0x4cd9, 0x4d07, 0x4d27, 0x4d44, 0x4d63, 0x4d7f, 0x4d9d, 0x4dba,
	0x4de1, 0x4e05, 0x4e24, 0x4e40, 0x4e5e, 0x4e7b, 0x4e9b, 0x4eb8,
	0x4ed7, 0x4ef5, 0x4f15, 0x4f32, 0x4f51, 0x4f6f, 0x4f8e, 0x4faa,
	0x4fc8, 0x4fe5, 0x5005, 0x5022, 0x5041, 0x505f, 0x507e, 0x509a,
	// Entry 3F40 - 3F7F
	0x50ba, 0x50d7, 0x50f6, 0x5112, 0x5132, 0x514f, 0x516f, 0x518c,
	0x51ab, 0x51c9, 0x51ea, 0x5208, 0x5228, 0x5247, 0x5266, 0x5282,
	0x52a0, 0x52bd, 0x52dc, 0x52f8, 0x5316, 0x5333, 0x5352, 0x536e,
	0x538c, 0x53a9, 0x53c8, 0x53e4, 0x5402, 0x541f, 0x543e, 0x545a,
	0x5478, 0x5495, 0x54b6, 0x54d4, 0x54f4, 0x5513, 0x5532, 0x554e,
	0x556c, 0x5589, 0x55a8, 0x55c4, 0x55e2, 0x55ff, 0x561e, 0x563a,
	0x5658, 0x5675, 0x5694, 0x56b0, 0x56ce, 0x56eb, 0x570b, 0x5728,
	0x5747, 0x5765, 0x5785, 0x57a2, 0x57c1, 0x57df, 0x57fe, 0x581a,
	// Entry 3F80 - 3FBF
	0x5838, 0x5855, 0x5874, 0x5890, 0x58b8, 0x58dd, 0x58fc, 0x5918,
	0x5936, 0x5953, 0x598f, 0x59c8, 0x5a04, 0x5a3d, 0x5a79, 0x5ab2,
	0x5add, 0x5b05, 0x5b1e, 0x5b38, 0x5b50, 0x5b65, 0x5b7a, 0x5b90,
	0x5ba3, 0x5bb7, 0x5bd1, 0x5bec, 0x5bfe, 0x5c11, 0x5c20, 0x5c36,
	0x5c49, 0x5c5a, 0x5c6e, 0x5c81, 0x5c94, 0x5ca9, 0x5cbd, 0x5cd1,
	0x5ce4, 0x5cf9, 0x5d0e, 0x5d22, 0x5d31, 0x5d44, 0x5d5c, 0x5d71,
	0x5d8c, 0x5da3, 0x5dba, 0x5dda, 0x5dfa, 0x5e1a, 0x5e3a, 0x5e5a,
	0x5e7a, 0x5e9a, 0x5eba, 0x5eda, 0x5efa, 0x5f1a, 0x5f3a, 0x5f5a,
	// Entry 3FC0 - 3FFF
	0x5f7a, 0x5f9a, 0x5fba, 0x5fda, 0x5ffa, 0x601a, 0x603a, 0x605a,
	0x607a, 0x609a, 0x60ba, 0x60da, 0x60fa, 0x6117, 0x6130, 0x614e,
	0x6169, 0x617b, 0x6191, 0x61af, 0x61cd, 0x61eb, 0x6209, 0x6227,
	0x6245, 0x6263, 0x6281, 0x629f, 0x62bd, 0x62db, 0x62f9, 0x6317,
	0x6335, 0x6353, 0x6371, 0x638f, 0x63ad, 0x63cb, 0x63e9, 0x6407,
	0x6425, 0x6443, 0x6461, 0x647f, 0x649d, 0x64b9, 0x64d0, 0x64ed,
	0x64fc, 0x651c, 0x653d, 0x655c, 0x6579, 0x6597, 0x65b2, 0x65cf,
	0x65eb, 0x660c, 0x662d, 0x664e, 0x666f, 0x6690, 0x66b2, 0x66d4,
	// Entry 4000 - 403F
	0x66f6, 0x6718, 0x6748, 0x6763, 0x677e, 0x6799, 0x67b4, 0x67cf,
	0x67eb, 0x6807, 0x6823, 0x683f, 0x685b, 0x6877, 0x6893, 0x68af,
	0x68cb, 0x68e7, 0x6903, 0x691f, 0x693b, 0x6957, 0x6973, 0x698f,
	0x69ab, 0x69c7, 0x69e3, 0x69ff, 0x6a1b, 0x6a37, 0x6a53, 0x6a6f,
	0x6a8b, 0x6aa7, 0x6ac3, 0x6adf, 0x6afb, 0x6b17, 0x6b33, 0x6b4f,
	0x6b6b, 0x6b87, 0x6ba3, 0x6bbf, 0x6bdb, 0x6bf7, 0x6c13, 0x6c2e,
	0x6c52, 0x6c7b, 0x6c92, 0x6cb0, 0x6cd3, 0x6cf6, 0x6d13, 0x6d36,
	0x6d59, 0x6d77, 0x6d9a, 0x6db7, 0x6ddb, 0x6dfe, 0x6e21, 0x6e43,
	// Entry 4040 - 407F
	0x6e68, 0x6e8d, 0x6eb0, 0x6ecd, 0x6eea, 0x6f0c, 0x6f2e, 0x6f4a,
	0x6f6b, 0x6f88, 0x6fa5, 0x6fc7, 0x6fe6, 0x7005, 0x7024, 0x7043,
	0x7060, 0x7079, 0x7093, 0x70ad, 0x70c8, 0x70e2, 0x70fb, 0x7116,
	0x7130, 0x7149, 0x7163, 0x717e, 0x7198, 0x71b2, 0x71cb, 0x71e6,
	0x7200, 0x721a, 0x7234, 0x724e, 0x7268, 0x7281, 0x7294, 0x72a8,
	0x72ba, 0x72ca, 0x72de, 0x72f0, 0x7302, 0x7320, 0x7339, 0x7350,
	0x736a, 0x7383, 0x7399, 0x73af, 0x73cc, 0x73ec, 0x740d, 0x7429,
	0x743e, 0x7456, 0x746e, 0x7486, 0x749e, 0x74b6, 0x74cf, 0x74e8,
	// Entry 4080 - 40BF
	0x7501, 0x751a, 0x7533, 0x754c, 0x7565, 0x757e, 0x7597, 0x75b0,
	0x75c9, 0x75e2, 0x75fb, 0x7614, 0x762d, 0x7646, 0x765f, 0x7678,
	0x7691, 0x76aa, 0x76c3, 0x76dc, 0x76f5, 0x770e, 0x7727, 0x7740,
	0x7759, 0x7772, 0x778b, 0x77a4, 0x77bd, 0x77d6, 0x77ef, 0x7808,
	0x7821, 0x783a, 0x7853, 0x786c, 0x7885, 0x789e, 0x78b7, 0x78d0,
	0x78e9, 0x7902, 0x791b, 0x7934, 0x794d, 0x7966, 0x797f, 0x7998,
	0x79b1, 0x79ca, 0x79e3, 0x79fc, 0x7a15, 0x7a2e, 0x7a47, 0x7a60,
	0x7a7a, 0x7a94, 0x7aae, 0x7ac8, 0x7ae2, 0x7afc, 0x7b16, 0x7b30,
	// Entry 40C0 - 40FF
	0x7b4a, 0x7b64, 0x7b7e, 0x7b92, 0x7ba6, 0x7bba, 0x7bce, 0x7be2,
	0x7bf6, 0x7c0a, 0x7c1e, 0x7c32, 0x7c46, 0x7c5a, 0x7c6e, 0x7c82,
	0x7c96, 0x7cb0, 0x7ccc, 0x7ce7, 0x7d03, 0x7d1f, 0x7d3f, 0x7d5a,
	0x7d75, 0x7d95, 0x7db4, 0x7dcf, 0x7deb, 0x7e06, 0x7e22, 0x7e3e,
	0x7e5b, 0x7e77, 0x7e93, 0x7eb1, 0x7ecc, 0x7ee9, 0x7f03, 0x7f1e,
	0x7f34, 0x7f50, 0x7f6b, 0x7f88, 0x7fa3, 0x7fb9, 0x7fd4, 0x7fea,
	0x8000, 0x801b, 0x8031, 0x8047, 0x805d, 0x8079, 0x808f, 0x80a5,
	0x80c1, 0x80d7, 0x80ed, 0x810b, 0x8128, 0x813e, 0x8154, 0x816a,
	// Entry 4100 - 413F
	0x8180, 0x8196, 0x81ac, 0x81c2, 0x81d8, 0x81ee, 0x820a, 0x8220,
	0x823b, 0x8251, 0x8267, 0x827d, 0x8293, 0x82a9, 0x82bf, 0x82d5,
	0x82eb, 0x8301, 0x8317, 0x832d, 0x834a, 0x836a, 0x8388, 0x83a4,
	0x83c0, 0x83d6, 0x83f2, 0x8408, 0x841e, 0x8444, 0x8462, 0x8486,
	0x84a2, 0x84b8, 0x84ce, 0x84ea, 0x8500, 0x8516, 0x852c, 0x8542,
	0x8558, 0x8573, 0x8589, 0x859f, 0x85b5, 0x85cb, 0x85e1, 0x85fe,
	0x861b, 0x8638, 0x8655, 0x8672, 0x868f, 0x86ac, 0x86c9, 0x86e6,
	0x8703, 0x8720, 0x873d, 0x875a, 0x8777, 0x8794, 0x87b1, 0x87ce,
	// Entry 4140 - 417F
	0x87eb, 0x8808, 0x8825, 0x8842, 0x885f, 0x887c, 0x8899, 0x88b6,
	0x88d3, 0x88f0, 0x890d, 0x892a, 0x8944, 0x895d, 0x896e, 0x897f,
	0x8990, 0x89a3, 0x89b5, 0x89c7, 0x89d8, 0x89eb, 0x89fe, 0x8a10,
	0x8a21, 0x8a35, 0x8a49, 0x8a5c, 0x8a6f, 0x8a82, 0x8a97, 0x8aab,
	0x8abf, 0x8ad8, 0x8af1, 0x8b0c, 0x8b26, 0x8b40, 0x8b59, 0x8b74,
	0x8b8f, 0x8ba9, 0x8bc3, 0x8bdd, 0x8bf9, 0x8c14, 0x8c2f, 0x8c49,
	0x8c65, 0x8c81, 0x8c9c, 0x8cb6, 0x8cd3, 0x8cf0, 0x8d0c, 0x8d28,
	0x8d44, 0x8d62, 0x8d7f, 0x8d9c, 0x8db3, 0x8dce, 0x8dea, 0x8e05,
	// Entry 4180 - 41BF
	0x8e21, 0x8e41, 0x8e64, 0x8e81, 0x8e9d, 0x8ebf, 0x8ede, 0x8f00,
	0x8f1b, 0x8f37, 0x8f5a, 0x8f7e, 0x8fa3, 0x8fc6, 0x8fe8, 0x900c,
	0x9036, 0x9061, 0x908c, 0x90b8, 0x90db, 0x90fd, 0x9121, 0x914b,
	0x9176, 0x91a1, 0x91cc, 0x91f9, 0x9218, 0x923d, 0x925a, 0x9279,
	0x9298, 0x92b5, 0x92db, 0x9303, 0x9323, 0x9342, 0x9370, 0x938f,
	0x93ad, 0x93ca, 0x93ea, 0x940b, 0x943b, 0x945c, 0x947b, 0x94a0,
	0x94c7, 0x94ef, 0x9517, 0x953d, 0x9564, 0x9588, 0x95ae, 0x95d5,
	0x95f7, 0x961b, 0x962e, 0x9650, 0x9665, 0x967e, 0x968d, 0x969e,
	// Entry 41C0 - 41FF
	0x96b0, 0x96bf, 0x96d3, 0x96e9, 0x96fe, 0x9713, 0x9726, 0x973d,
	0x974d, 0x975e, 0x976f, 0x9780, 0x9791, 0x97a2, 0x97ba, 0x97c9,
	0x97df, 0x97f2, 0x9806, 0x9812, 0x9824, 0x9834, 0x9847, 0x9859,
	0x9873, 0x9885, 0x9898, 0x98ac, 0x98c1, 0x98d5, 0x98e2, 0x98f6,
	0x990a, 0x9927, 0x9945, 0x9965, 0x997f, 0x9997, 0x99af, 0x99c8,
	0x99e3, 0x99fb, 0x9a13, 0x9a29, 0x9a42, 0x9a59, 0x9a74, 0x9a8e,
	0x9aa4, 0x9aba, 0x9ad6, 0x9af8, 0x9b11, 0x9b28, 0x9b40, 0x9b59,
	0x9b73, 0x9b8a, 0x9ba1, 0x9bb8, 0x9bd4, 0x9bea, 0x9c00, 0x9c18,
	// Entry 4200 - 423F
	0x9c2f, 0x9c47, 0x9c5d, 0x9c7a, 0x9c91, 0x9cab, 0x9cc5, 0x9cdc,
	0x9cf6, 0x9d0e, 0x9d27, 0x9d42, 0x9d5e, 0x9d7a, 0x9da5, 0x9db4,
	0x9dc3, 0x9dd2, 0x9de2, 0x9df1, 0x9e00, 0x9e0f, 0x9e1e, 0x9e2d,
	0x9e3d, 0x9e4c, 0x9e5b, 0x9e6a, 0x9e79, 0x9e88, 0x9e97, 0x9ea7,
	0x9eb7, 0x9ec6, 0x9ed5, 0x9ee5, 0x9ef4, 0x9f03, 0x9f12, 0x9f22,
	0x9f32, 0x9f42, 0x9f51, 0x9f60, 0x9f6f, 0x9f7f, 0x9f8e, 0x9f9d,
	0x9fae, 0x9fbd, 0x9fcd, 0x9fdd, 0x9fec, 0x9ffb, 0xa00a, 0xa019,
	0xa029, 0xa038, 0xa048, 0xa059, 0xa068, 0xa07a, 0xa089, 0xa099,
	// Entry 4240 - 427F
	0xa0a8, 0xa0b7, 0xa0c8, 0xa0d7, 0xa0e7, 0xa0f6, 0xa105, 0xa117,
	0xa126, 0xa136, 0xa146, 0xa156, 0xa165, 0xa175, 0xa185, 0xa196,
	0xa1a6, 0xa1b6, 0xa1c8, 0xa1d8, 0xa1ea, 0xa1fa, 0xa20a, 0xa21b,
	0xa22c, 0xa23d, 0xa24e, 0xa25e, 0xa270, 0xa28b, 0xa2a1, 0xa2b7,
	0xa2cf, 0xa2e6, 0xa2fd, 0xa313, 0xa32b, 0xa343, 0xa35a, 0xa371,
	0xa38b, 0xa3a5, 0xa3be, 0xa3d7, 0xa3f0, 0xa40b, 0xa425, 0xa43f,
	0xa45e, 0xa47d, 0xa49e, 0xa4be, 0xa4de, 0xa4fd, 0xa51e, 0xa53f,
	0xa55f, 0xa572, 0xa586, 0xa59a, 0xa5ae, 0xa5c1, 0xa5d5, 0xa5e9,
	// Entry 4280 - 42BF
	0xa5fd, 0xa612, 0xa625, 0xa639, 0xa64d, 0xa661, 0xa675, 0xa68a,
	0xa69d, 0xa6b1, 0xa6c6, 0xa6da, 0xa6ee, 0xa702, 0xa716, 0xa729,
	0xa73e, 0xa753, 0xa768, 0xa77c, 0xa791, 0xa7a6, 0xa7ba, 0xa7ce,
	0xa7e3, 0xa7f9, 0xa810, 0xa826, 0xa83e, 0xa852, 0xa870, 0xa88e,
	0xa8a0, 0xa8b5, 0xa8c7, 0xa8d9, 0xa8ed, 0xa903, 0xa915, 0xa927,
	0xa93b, 0xa94c, 0xa95f, 0xa972, 0xa985, 0xa999, 0xa9aa, 0xa9bc,
	0xa9d2, 0xa9e6, 0xa9f9, 0xaa0c, 0xaa1f, 0xaa32, 0xaa45, 0xaa58,
	0xaa6b, 0xaa7e, 0xaa98, 0xaaac, 0xaac1, 0xaad6, 0xaaeb, 0xaafe,
	// Entry 42C0 - 42FF
	0xab14, 0xab2b, 0xab41, 0xab58, 0xab6b, 0xab81, 0xab96, 0xabad,
	0xabc4, 0xabda, 0xabf0, 0xac05, 0xac1a, 0xac2f, 0xac42, 0xac59,
	0xac70, 0xac89, 0xac9e, 0xacb4, 0xacc7, 0xacdb, 0xacef, 0xad03,
	0xad19, 0xad2e, 0xad43, 0xad59, 0xad6e, 0xad82, 0xad96, 0xadaa,
	0xadbe, 0xaddc, 0xadfb, 0xae1b, 0xae3c, 0xae5b, 0xae6f, 0xae83,
	0xae98, 0xaeab, 0xaec0, 0xaed2, 0xaee4, 0xaef8, 0xaf0c, 0xaf1f,
	0xaf32, 0xaf45, 0xaf59, 0xaf6e, 0xaf81, 0xaf95, 0xafa8, 0xafba,
	0xafcf, 0xafe2, 0xaff4, 0xb008, 0xb01c, 0xb031, 0xb047, 0xb05c,
	// Entry 4300 - 433F
	0xb06e, 0xb07f, 0xb090, 0xb0a3, 0xb0b8, 0xb0ca, 0xb0dc, 0xb0ee,
	0xb101, 0xb114, 0xb127, 0xb13a, 0xb14d, 0xb160, 0xb173, 0xb186,
	0xb199, 0xb1ac, 0xb1bf, 0xb1d2, 0xb1e5, 0xb1f9, 0xb20c, 0xb21f,
	0xb232, 0xb245, 0xb258, 0xb26b, 0xb27e, 0xb291, 0xb2a4, 0xb2b7,
	0xb2ca, 0xb2dd, 0xb2f0, 0xb303, 0xb316, 0xb329, 0xb33d, 0xb351,
	0xb364, 0xb37f, 0xb39c, 0xb3b9, 0xb3d6, 0xb3f0, 0xb40c, 0xb421,
	0xb439, 0xb451, 0xb467, 0xb47d, 0xb493, 0xb4ac, 0xb4c6, 0xb4e3,
	0xb500, 0xb51d, 0xb53b, 0xb558, 0xb576, 0xb594, 0xb5b2, 0xb5d0,
	// Entry 4340 - 437F
	0xb5ef, 0xb60d, 0xb62c, 0xb645, 0xb65e, 0xb677, 0xb691, 0xb6a9,
	0xb6c3, 0xb6dd, 0xb6f7, 0xb711, 0xb72c, 0xb746, 0xb760, 0xb77a,
	0xb793, 0xb7ad, 0xb7c7, 0xb7e2, 0xb7fb, 0xb815, 0xb82f, 0xb84a,
	0xb863, 0xb87c, 0xb895, 0xb8ae, 0xb8c8, 0xb8e1, 0xb8fa, 0xb915,
	0xb930, 0xb94b, 0xb967, 0xb982, 0xb99e, 0xb9ba, 0xb9d6, 0xb9f2,
	0xba0f, 0xba2b, 0xba48, 0xba5f, 0xba76, 0xba8d, 0xbaa5, 0xbabb,
	0xbad3, 0xbaeb, 0xbb03, 0xbb1b, 0xbb34, 0xbb4c, 0xbb64, 0xbb7c,
	0xbb93, 0xbbab, 0xbbc3, 0xbbdc, 0xbbf3, 0xbc0b, 0xbc23, 0xbc3c,
	// Entry 4380 - 43BF
	0xbc53, 0xbc6a, 0xbc81, 0xbc98, 0xbcb0, 0xbcc7, 0xbcde, 0xbcf1,
	0xbd03, 0xbd16, 0xbd28, 0xbd3c, 0xbd4d, 0xbd60, 0xbd75, 0xbd87,
	0xbd9a, 0xbdac, 0xbdbf, 0xbdd1, 0xbde3, 0xbdf6, 0xbe08, 0xbe1e,
	0xbe32, 0xbe44, 0xbe58, 0xbe6b, 0xbe7e, 0xbe8f, 0xbea1, 0xbeb3,
	0xbec5, 0xbed6, 0xbee9, 0xbefb, 0xbf0c, 0xbf1f, 0xbf31, 0xbf43,
	0xbf55, 0xbf67, 0xbf78, 0xbf8a, 0xbf9d, 0xbfaf, 0xbfc1, 0xbfd3,
	0xbfe4, 0xbff6, 0xc008, 0xc01c, 0xc02e, 0xc040, 0xc052, 0xc065,
	0xc076, 0xc087, 0xc098, 0xc0a9, 0xc0bb, 0xc0ce, 0xc0df, 0xc0f0,
	// Entry 43C0 - 43FF
	0xc104, 0xc116, 0xc129, 0xc13a, 0xc14b, 0xc15e, 0xc171, 0xc184,
	0xc197, 0xc1aa, 0xc1bc, 0xc1cd, 0xc1de, 0xc1ee, 0xc1fe, 0xc20e,
	0xc21e, 0xc22e, 0xc23f, 0xc250, 0xc261, 0xc273, 0xc284, 0xc295,
	0xc2a8, 0xc2ba, 0xc2cc, 0xc2dd, 0xc2f0, 0xc303, 0xc315, 0xc32b,
	0xc342, 0xc35a, 0xc371, 0xc389, 0xc3a1, 0xc3bb, 0xc3d1, 0xc3e9,
	0xc400, 0xc418, 0xc42e, 0xc445, 0xc45e, 0xc476, 0xc48d, 0xc4a4,
	0xc4bb, 0xc4d1, 0xc4e9, 0xc500, 0xc519, 0xc530, 0xc548, 0xc55f,
	0xc578, 0xc590, 0xc5aa, 0xc5c3, 0xc5db, 0xc5f1, 0xc608, 0xc620,
	// Entry 4400 - 443F
	0xc638, 0xc64f, 0xc667, 0xc67b, 0xc690, 0xc6a6, 0xc6bb, 0xc6d1,
	0xc6e7, 0xc6ff, 0xc713, 0xc729, 0xc73e, 0xc754, 0xc768, 0xc77d,
	0xc794, 0xc7aa, 0xc7bf, 0xc7d4, 0xc7e9, 0xc7fd, 0xc813, 0xc828,
	0xc83f, 0xc854, 0xc86a, 0xc87f, 0xc896, 0xc8ac, 0xc8c4, 0xc8db,
	0xc8f1, 0xc905, 0xc91a, 0xc930, 0xc946, 0xc95b, 0xc971, 0xc981,
	0xc992, 0xc9a3, 0xc9b5, 0xc9c6, 0xc9d8, 0xc9ea, 0xc9fb, 0xca0b,
	0xca1c, 0xca2d, 0xca3f, 0xca50, 0xca60, 0xca71, 0xca82, 0xca93,
	0xcaa5, 0xcab6, 0xcac7, 0xcad8, 0xcaea, 0xcafa, 0xcb0b, 0xcb1c,
	// Entry 4440 - 447F
	0xcb2d, 0xcb3f, 0xcb50, 0xcb62, 0xcb73, 0xcb85, 0xcb95, 0xcba6,
	0xcbb7, 0xcbc7, 0xcbd8, 0xcbea, 0xcbfc, 0xcc11, 0xcc23, 0xcc40,
	0xcc5d, 0xcc7a, 0xcc97, 0xccb3, 0xccd1, 0xccee, 0xcd0c, 0xcd29,
	0xcd46, 0xcd64, 0xcd81, 0xcd9e, 0xcdbb, 0xcdd8, 0xcdf6, 0xce14,
	0xce32, 0xce4f, 0xce6d, 0xce8a, 0xcea8, 0xcec6, 0xcee3, 0xcf00,
	0xcf1e, 0xcf3b, 0xcf59, 0xcf76, 0xcf93, 0xcfb1, 0xcfd0, 0xcfee,
	0xd00c, 0xd028, 0xd046, 0xd063, 0xd081, 0xd09f, 0xd0bc, 0xd0db,
	0xd0f8, 0xd116, 0xd134, 0xd152, 0xd170, 0xd18d, 0xd1ab, 0xd1c9,
	// Entry 4480 - 44BF
	0xd1e7, 0xd205, 0xd222, 0xd242, 0xd255, 0xd268, 0xd27b, 0xd28e,
	0xd2a1, 0xd2b4, 0xd2c7, 0xd2da, 0xd2ed, 0xd300, 0xd313, 0xd326,
	0xd339, 0xd34c, 0xd35f, 0xd372, 0xd386, 0xd39a, 0xd3ad, 0xd3c1,
	0xd3d5, 0xd3e8, 0xd3fc, 0xd40f, 0xd422, 0xd435, 0xd448, 0xd45b,
	0xd46e, 0xd481, 0xd494, 0xd4a7, 0xd4ba, 0xd4cd, 0xd4e0, 0xd4f3,
	0xd506, 0xd519, 0xd52c, 0xd53f, 0xd552, 0xd565, 0xd578, 0xd58b,
	0xd59e, 0xd5b1, 0xd5c4, 0xd5d7, 0xd5ea, 0xd5fd, 0xd610, 0xd623,
	0xd636, 0xd649, 0xd65c, 0xd66f, 0xd682, 0xd695, 0xd6a8, 0xd6bb,
	// Entry 44C0 - 44FF
	0xd6ce, 0xd6e1, 0xd6f4, 0xd707, 0xd71a, 0xd72d, 0xd740, 0xd753,
	0xd766, 0xd779, 0xd78c, 0xd7a2, 0xd7b5, 0xd7c8, 0xd7db, 0xd7ee,
	0xd801, 0xd815, 0xd829, 0xd83c, 0xd84f, 0xd862, 0xd875, 0xd888,
	0xd89b, 0xd8ad, 0xd8bf, 0xd8d1, 0xd8e3, 0xd8f5, 0xd907, 0xd919,
	0xd92b, 0xd93e, 0xd951, 0xd964, 0xd976, 0xd988, 0xd99a, 0xd9ad,
	0xd9c0, 0xd9d3, 0xd9e5, 0xd9f7, 0xda09, 0xda1b, 0xda2d, 0xda3f,
	0xda51, 0xda63, 0xda75, 0xda87, 0xda99, 0xdaab, 0xdabd, 0xdacf,
	0xdae1, 0xdaf3, 0xdb05, 0xdb17, 0xdb29, 0xdb3b, 0xdb4d, 0xdb5f,
	// Entry 4500 - 453F
	0xdb71, 0xdb83, 0xdb95, 0xdba7, 0xdbb9, 0xdbcb, 0xdbdd, 0xdbef,
	0xdc01, 0xdc13, 0xdc25, 0xdc37, 0xdc49, 0xdc5b, 0xdc6d, 0xdc7f,
	0xdc91, 0xdca3, 0xdcb5, 0xdcc7, 0xdcd9, 0xdceb, 0xdcfd, 0xdd0f,
	0xdd21, 0xdd33, 0xdd45, 0xdd57, 0xdd69, 0xdd7b, 0xdd8d, 0xdd9f,
	0xddb1, 0xddc3, 0xddd5, 0xdde7, 0xddfd, 0xde13, 0xde29, 0xde3f,
	0xde55, 0xde6b, 0xde81, 0xde97, 0xdead, 0xdec3, 0xded9, 0xdeef,
	0xdf05, 0xdf1b, 0xdf31, 0xdf47, 0xdf5d, 0xdf73, 0xdf89, 0xdf9b,
	0xdfad, 0xdfbf, 0xdfd1, 0xdfe3, 0xdff5, 0xe007, 0xe019, 0xe02b,
	// Entry 4540 - 457F
	0xe03d, 0xe04f, 0xe061, 0xe073, 0xe085, 0xe097, 0xe0a9, 0xe0bb,
	0xe0cd, 0xe0df, 0xe0f1, 0xe103, 0xe115, 0xe127, 0xe139, 0xe14b,
	0xe15d, 0xe16f, 0xe181, 0xe193, 0xe1a5, 0xe1b7, 0xe1c9, 0xe1db,
	0xe1ed, 0xe1ff, 0xe211, 0xe223, 0xe235, 0xe247, 0xe259, 0xe26b,
	0xe27d, 0xe28f, 0xe2a1, 0xe2b3, 0xe2c5, 0xe2d7, 0xe2e9, 0xe2fb,
	0xe30d, 0xe31f, 0xe331, 0xe343, 0xe355, 0xe367, 0xe379, 0xe38b,
	0xe39d, 0xe3af, 0xe3c1, 0xe3d3, 0xe3e5, 0xe3f7, 0xe409, 0xe41b,
	0xe42d, 0xe43f, 0xe451, 0xe463, 0xe475, 0xe487, 0xe499, 0xe4ab,
	// Entry 4580 - 45BF
	0xe4bd, 0xe4cf, 0xe4e1, 0xe4f3, 0xe505, 0xe517, 0xe529, 0xe53b,
	0xe54d, 0xe55f, 0xe571, 0xe583, 0xe595, 0xe5a7, 0xe5b9, 0xe5cb,
	0xe5dd, 0xe5ef, 0xe601, 0xe613, 0xe625, 0xe637, 0xe649, 0xe65b,
	0xe66d, 0xe67f, 0xe691, 0xe6a3, 0xe6b5, 0xe6c7, 0xe6d9, 0xe6eb,
	0xe6fd, 0xe70f, 0xe721, 0xe733, 0xe745, 0xe757, 0xe769, 0xe77b,
	0xe78d, 0xe79f, 0xe7b1, 0xe7c3, 0xe7d5, 0xe7e7, 0xe7f9, 0xe80b,
	0xe81d, 0xe82f, 0xe841, 0xe853, 0xe865, 0xe877, 0xe889, 0xe89b,
	0xe8ad, 0xe8bf, 0xe8d1, 0xe8e5, 0xe8f9, 0xe90d, 0xe921, 0xe935,
	// Entry 45C0 - 45FF
	0xe949, 0xe95d, 0xe971, 0xe985, 0xe99c, 0xe9b3, 0xe9ca, 0xe9e1,
	0xe9f5, 0xea09, 0xea1d, 0xea35, 0xea4b, 0xea60, 0xea75, 0xea8c,
	0xeaa1, 0xeab3, 0xeac5, 0xead7, 0xeae9, 0xeafb, 0xeb0d, 0xeb1f,
	0xeb31, 0xeb43, 0xeb55, 0xeb67, 0xeb79, 0xeb8b, 0xeb9e, 0xebb1,
	0xebc4, 0xebd7, 0xebea, 0xebfd, 0xec10, 0xec23, 0xec36, 0xec49,
	0xec5c, 0xec6f, 0xec82, 0xec95, 0xeca8, 0xecbb, 0xecce, 0xece1,
	0xecf4, 0xed07, 0xed1a, 0xed2d, 0xed40, 0xed53, 0xed66, 0xed79,
	0xed8c, 0xed9f, 0xedb2, 0xedc5, 0xedd8, 0xedeb, 0xedfe, 0xee11,
	// Entry 4600 - 463F
	0xee24, 0xee37, 0xee4a, 0xee5d, 0xee70, 0xee83, 0xee96, 0xeea9,
	0xeebc, 0xeecf, 0xeee2, 0xeef5, 0xef08, 0xef1b, 0xef2e, 0xef41,
	0xef5e, 0xef7a, 0xef97, 0xefb5, 0xefcf, 0xefea, 0xf007, 0xf023,
	0xf03f, 0xf05b, 0xf077, 0xf095, 0xf0b0, 0xf0cb, 0xf0e9, 0xf105,
	0xf11f, 0xf13c, 0xf158, 0xf174, 0xf190, 0xf1ab, 0xf1c8, 0xf1e3,
	0xf1fe, 0xf21b, 0xf236, 0xf254, 0xf277, 0xf29b, 0xf2bf, 0xf2d5,
	0xf2ea, 0xf300, 0xf317, 0xf32a, 0xf33e, 0xf354, 0xf369, 0xf37e,
	0xf393, 0xf3a8, 0xf3bf, 0xf3d3, 0xf3ed, 0xf401, 0xf418, 0xf42d,
	// Entry 4640 - 467F
	0xf440, 0xf456, 0xf46b, 0xf480, 0xf495, 0xf4a9, 0xf4c8, 0xf4e8,
	0xf4fc, 0xf510, 0xf526, 0xf53b, 0xf550, 0xf564, 0xf57b, 0xf597,
	0xf5ad, 0xf5c8, 0xf5dd, 0xf5f3, 0xf60a, 0xf623, 0xf636, 0xf64a,
	0xf660, 0xf675, 0xf68a, 0xf6a5, 0xf6ba, 0xf6d5, 0xf6ea, 0xf707,
	0xf71e, 0xf738, 0xf74c, 0xf766, 0xf77a, 0xf791, 0xf7a6, 0xf7b9,
	0xf7cf, 0xf7e4, 0xf7f9, 0xf814, 0xf829, 0xf83d, 0xf851, 0xf865,
	0xf87b, 0xf890, 0xf8af, 0xf8c4, 0xf8d8, 0xf8ef, 0xf90b, 0xf91e,
	0xf930, 0xf943, 0xf95c, 0xf96c, 0xf97d, 0xf98f, 0xf9a1, 0xf9b3,
	// Entry 4680 - 46BF
	0xf9c5, 0xf9d7, 0xf9eb, 0xf9fc, 0xfa0d, 0xfa21, 0xfa32, 0xfa42,
	0xfa55, 0xfa67, 0xfa79, 0xfa8a, 0xfa9b, 0xfaad, 0xfabe, 0xfad2,
	0xfaeb, 0xfb00, 0xfb15, 0xfb2b, 0xfb41, 0xfb55, 0xfb6a, 0xfb7f,
	0xfb94, 0xfba9, 0xfbbe, 0xfbd3, 0xfbe9, 0xfbfe, 0xfc13, 0xfc29,
	0xfc3e, 0xfc52, 0xfc68, 0xfc7d, 0xfc93, 0xfca9, 0xfcbe, 0xfcd3,
	0xfce8, 0xfd00, 0xfd1d, 0xfd32, 0xfd49, 0xfd62, 0xfd71, 0xfd80,
	0xfd8f, 0xfd9e, 0xfdad, 0xfdbc, 0xfdcb, 0xfdda, 0xfde9, 0xfdf8,
	0xfe07, 0xfe16, 0xfe25, 0xfe34, 0xfe44, 0xfe53, 0xfe62, 0xfe71,
	// Entry 46C0 - 46FF
	0xfe80, 0xfe8f, 0xfe9f, 0xfeaf, 0xfebf, 0xfecf, 0xfedf, 0xfeee,
	0xff04, 0xff22, 0xff40, 0xff5e, 0xff7c, 0xff9b, 0xffba, 0xffd9,
	0xfffa, 0x0019, 0x0038, 0x0057, 0x0078, 0x0097, 0x00b8, 0x00d7,
	0x00f8, 0x0117, 0x0137, 0x0157, 0x0176, 0x0197, 0x01b6, 0x01d5,
	0x01f4, 0x0213, 0x0234, 0x0253, 0x0274, 0x0293, 0x02b2, 0x02d3,
	0x02f6, 0x030f, 0x0328, 0x0341, 0x035a, 0x0374, 0x038e, 0x03a8,
	0x03c2, 0x03dc, 0x03f6, 0x0410, 0x042a, 0x0444, 0x045f, 0x047a,
	0x0494, 0x04b6, 0x04d0, 0x04ea, 0x0504, 0x051e, 0x0538, 0x0552,
	// Entry 4700 - 473F
	0x056c, 0x0595, 0x05b7, 0x05d4, 0x05f1, 0x060c, 0x0627, 0x0644,
	0x0660, 0x067c, 0x0697, 0x06b4, 0x06d1, 0x06ed, 0x0708, 0x0726,
	0x0744, 0x0761, 0x077e, 0x079b, 0x07ba, 0x07dd, 0x0800, 0x0825,
	0x0849, 0x086d, 0x0890, 0x08b5, 0x08da, 0x08fe, 0x0922, 0x0946,
	0x096c, 0x0991, 0x09b6, 0x09da, 0x0a00, 0x0a26, 0x0a4b, 0x0a6f,
	0x0a96, 0x0abd, 0x0ae3, 0x0b09, 0x0b2f, 0x0b57, 0x0b7e, 0x0ba5,
	0x0bd1, 0x0bfd, 0x0c2b, 0x0c58, 0x0c85, 0x0cb1, 0x0cdf, 0x0d0d,
	0x0d3a, 0x0d5f, 0x0d85, 0x0dad, 0x0dd4, 0x0dfb, 0x0e21, 0x0e49,
	// Entry 4740 - 477F
	0x0e71, 0x0e98, 0x0ebe, 0x0ed1, 0x0ee8, 0x0eff, 0x0f1e, 0x0f35,
	0x0f4c, 0x0f68, 0x0f89, 0x0fa1, 0x0fb8, 0x0fcc, 0x0fe1, 0x0ff5,
	0x100a, 0x101e, 0x1033, 0x1047, 0x105c, 0x1071, 0x1087, 0x109c,
	0x10b2, 0x10c7, 0x10db, 0x10f0, 0x1104, 0x1119, 0x112d, 0x1141,
	0x1156, 0x116a, 0x117f, 0x1193, 0x11a7, 0x11bb, 0x11cf, 0x11e3,
	0x11f8, 0x120d, 0x1221, 0x1235, 0x1249, 0x125e, 0x1275, 0x128e,
	0x12a3, 0x12bc, 0x12cd, 0x12e1, 0x12f5, 0x130b, 0x1320, 0x1335,
	0x134d, 0x136a, 0x1388, 0x13a2, 0x13c5, 0x13e2, 0x1405, 0x1424,
	// Entry 4780 - 47BF
	0x1440, 0x145c, 0x147f, 0x149b, 0x14b6, 0x14d5, 0x14f2, 0x150e,
	0x152b, 0x1547, 0x1564, 0x1581, 0x159e, 0x15ba, 0x15d6, 0x15f3,
	0x160f, 0x162d, 0x164b, 0x166a, 0x1685, 0x16a2, 0x16be, 0x16dd,
	0x16fb, 0x171a, 0x1738, 0x1755, 0x1772, 0x1792, 0x17af, 0x17cc,
	0x17ea, 0x1806, 0x1824, 0x1847, 0x1863, 0x187f, 0x189b, 0x18b8,
	0x18d4, 0x18f0, 0x190d, 0x1929, 0x1945, 0x1961, 0x197e, 0x199a,
	0x19b7, 0x19d4, 0x19f0, 0x1a0d, 0x1a29, 0x1a46, 0x1a62, 0x1a7e,
	0x1a9b, 0x1ab7, 0x1ad5, 0x1af1, 0x1b0e, 0x1b2b, 0x1b47, 0x1b64,
	// Entry 47C0 - 47FF
	0x1b80, 0x1b9c, 0x1bb8, 0x1bd7, 0x1bee, 0x1c04, 0x1c1b, 0x1c32,
	0x1c4a, 0x1c62, 0x1c76, 0x1c8b, 0x1c9d, 0x1cb4, 0x1ccc, 0x1ce3,
	0x1cfb, 0x1d11, 0x1d27, 0x1d3d, 0x1d53, 0x1d69, 0x1d80, 0x1d98,
	0x1db1, 0x1dca, 0x1ddf, 0x1df4, 0x1e0c, 0x1e22, 0x1e39, 0x1e4d,
	0x1e61, 0x1e78, 0x1e8e, 0x1ea4, 0x1ebb, 0x1ed1, 0x1ee7, 0x1efe,
	0x1f13, 0x1f35, 0x1f57, 0x1f6c, 0x1f82, 0x1f97, 0x1faf, 0x1fcc,
	0x1fe7, 0x2005, 0x2031, 0x2056, 0x2070, 0x208f, 0x20b1, 0x20c1,
	0x20d2, 0x20e3, 0x20f5, 0x2106, 0x2118, 0x2129, 0x213b, 0x214b,
	// Entry 4800 - 483F
	0x215c, 0x216c, 0x217d, 0x218d, 0x219e, 0x21ae, 0x21bf, 0x21d0,
	0x21e1, 0x21f3, 0x2205, 0x2216, 0x2228, 0x223a, 0x224b, 0x225c,
	0x226d, 0x227f, 0x2290, 0x22a2, 0x22b4, 0x22c5, 0x22d6, 0x22e7,
	0x22f9, 0x230b, 0x231e, 0x2331, 0x2342, 0x2354, 0x2366, 0x2377,
	0x2389, 0x239b, 0x23ac, 0x23bd, 0x23ce, 0x23df, 0x23f0, 0x2401,
	0x2413, 0x2425, 0x2438, 0x244b, 0x245c, 0x2475, 0x249b, 0x24c2,
	0x24e9, 0x2510, 0x2539, 0x2562, 0x2585, 0x25a7, 0x25ca, 0x25ee,
	0x260e, 0x262f, 0x2652, 0x2674, 0x2696, 0x26b8, 0x26da, 0x26fe,
	// Entry 4840 - 487F
	0x271f, 0x2740, 0x2764, 0x2786, 0x27a6, 0x27c9, 0x27eb, 0x280d,
	0x282f, 0x2850, 0x2871, 0x2892, 0x28b5, 0x28d7, 0x28f8, 0x291c,
	0x2945, 0x296f, 0x2991, 0x29b2, 0x29d4, 0x29f7, 0x2a16, 0x2a40,
	0x2a62, 0x2a83, 0x2aa4, 0x2ac5, 0x2ae6, 0x2b09, 0x2b2e, 0x2b4e,
	0x2b71, 0x2b90, 0x2bb2, 0x2bd3, 0x2bf3, 0x2c13, 0x2c33, 0x2c55,
	0x2c76, 0x2c96, 0x2cb9, 0x2ce1, 0x2d0a, 0x2d26, 0x2d41, 0x2d5d,
	0x2d7a, 0x2d93, 0x2db7, 0x2dd3, 0x2dee, 0x2e09, 0x2e24, 0x2e41,
	0x2e60, 0x2e7a, 0x2e97, 0x2eb0, 0x2ecc, 0x2ee7, 0x2f01, 0x2f1d,
	// Entry 4880 - 48BF
	0x2f40, 0x2f64, 0x2f86, 0x2fa0, 0x2fba, 0x2fd6, 0x2ff1, 0x300b,
	0x3028, 0x304a, 0x3064, 0x307f, 0x309b, 0x30b5, 0x30d0, 0x30eb,
	0x3105, 0x3120, 0x313c, 0x3157, 0x3173, 0x318f, 0x31ac, 0x31c7,
	0x31e3, 0x31ff, 0x321c, 0x3237, 0x3253, 0x326f, 0x328a, 0x32a6,
	0x32c1, 0x32dd, 0x32f9, 0x3316, 0x3332, 0x334f, 0x336b, 0x3388,
	0x33a3, 0x33bf, 0x33db, 0x33f7, 0x3412, 0x342d, 0x3449, 0x3466,
	0x3482, 0x349f, 0x34bb, 0x34d8, 0x34f4, 0x3511, 0x352e, 0x354a,
	0x3568, 0x3583, 0x359e, 0x35b9, 0x35d4, 0x35f0, 0x360b, 0x3627,
	// Entry 48C0 - 48FF
	0x3642, 0x365e, 0x3679, 0x3695, 0x36b0, 0x36cc, 0x36e8, 0x3703,
	0x371f, 0x373b, 0x3758, 0x3774, 0x3791, 0x37ac, 0x37c8, 0x37e4,
	0x3801, 0x381c, 0x3839, 0x3857, 0x3876, 0x3895, 0x38b5, 0x38d4,
	0x38f4, 0x3914, 0x3933, 0x3953, 0x3971, 0x3995, 0x39b4, 0x39d3,
	0x39f2, 0x3a12, 0x3a31, 0x3a4f, 0x3a6e, 0x3a8d, 0x3aac, 0x3acb,
	0x3aeb, 0x3b0a, 0x3b2a, 0x3b49, 0x3b68, 0x3b88, 0x3ba6, 0x3bc5,
	0x3bef, 0x3c18, 0x3c38, 0x3c57, 0x3c77, 0x3c96, 0x3cbb, 0x3cda,
	0x3cfa, 0x3d19, 0x3d39, 0x3d59, 0x3d79, 0x3d97, 0x3db6, 0x3de0,
	// Entry 4900 - 493F
	0x3e09, 0x3e28, 0x3e47, 0x3e67, 0x3e93, 0x3eb2, 0x3ece, 0x3eeb,
	0x3f08, 0x3f26, 0x3f43, 0x3f61, 0x3f7f, 0x3f9c, 0x3fba, 0x3fd6,
	0x3ff8, 0x4015, 0x4032, 0x404f, 0x406d, 0x408a, 0x40a6, 0x40c3,
	0x40e0, 0x40fd, 0x411a, 0x4138, 0x4155, 0x4173, 0x4190, 0x41ad,
	0x41cb, 0x41e7, 0x4204, 0x422c, 0x4253, 0x4271, 0x428e, 0x42ac,
	0x42c9, 0x42ec, 0x4309, 0x4327, 0x4344, 0x4362, 0x4380, 0x439e,
	0x43ba, 0x43d7, 0x43ff, 0x4426, 0x4443, 0x4460, 0x447e, 0x44a8,
	0x44c5, 0x44dd, 0x44f6, 0x450e, 0x4528, 0x4548, 0x4569, 0x4577,
	// Entry 4940 - 497F
	0x4585, 0x4595, 0x45a4, 0x45b3, 0x45c1, 0x45d1, 0x45e1, 0x45f0,
	0x45ff, 0x4611, 0x4623, 0x4634, 0x4645, 0x4656, 0x4669, 0x467b,
	0x468d, 0x46a4, 0x46bb, 0x46d4, 0x46ec, 0x4704, 0x471b, 0x4734,
	0x474d, 0x4765, 0x477b, 0x4794, 0x47ab, 0x47c3, 0x47da, 0x47ee,
	0x4801, 0x4818, 0x482f, 0x483e, 0x484e, 0x485d, 0x486d, 0x487c,
	0x488c, 0x48a3, 0x48bb, 0x48d2, 0x48ea, 0x48f9, 0x4909, 0x4918,
	0x4928, 0x4938, 0x4949, 0x4959, 0x496a, 0x497b, 0x498b, 0x499c,
	0x49ac, 0x49bd, 0x49ce, 0x49df, 0x49f1, 0x4a02, 0x4a14, 0x4a25,
	// Entry 4980 - 49BF
	0x4a35, 0x4a46, 0x4a56, 0x4a67, 0x4a77, 0x4a87, 0x4a98, 0x4aa8,
	0x4ab9, 0x4ac9, 0x4ad9, 0x4ae9, 0x4af9, 0x4b09, 0x4b1a, 0x4b2b,
	0x4b3b, 0x4b4b, 0x4b5c, 0x4b78, 0x4b93, 0x4baf, 0x4bc3, 0x4be3,
	0x4bf6, 0x4c0a, 0x4c1d, 0x4c31, 0x4c4c, 0x4c68, 0x4c83, 0x4c9f,
	0x4cb2, 0x4cc6, 0x4cd9, 0x4ced, 0x4cfa, 0x4d06, 0x4d19, 0x4d2f,
	0x4d4c, 0x4d63, 0x4d82, 0x4d9a, 0x4dab, 0x4dbc, 0x4dcf, 0x4de1,
	0x4df3, 0x4e04, 0x4e17, 0x4e2a, 0x4e3c, 0x4e4d, 0x4e61, 0x4e75,
	0x4e88, 0x4e9b, 0x4eae, 0x4ec3, 0x4ed7, 0x4eeb, 0x4f04, 0x4f1e,
	// Entry 49C0 - 49FF
	0x4f2f, 0x4f3f, 0x4f4f, 0x4f61, 0x4f72, 0x4f83, 0x4f93, 0x4fa5,
	0x4fb7, 0x4fc8, 0x4fdc, 0x4ff3, 0x5007, 0x501a, 0x5029, 0x5039,
	0x5048, 0x5058, 0x5067, 0x5077, 0x5086, 0x5096, 0x50a5, 0x50b5,
	0x50c5, 0x50d6, 0x50e6, 0x50f7, 0x5108, 0x5118, 0x5129, 0x5139,
	0x514a, 0x515b, 0x516c, 0x517e, 0x518f, 0x51a2, 0x51b4, 0x51c5,
	0x51d6, 0x51e6, 0x51f7, 0x5207, 0x5218, 0x5228, 0x5238, 0x5249,
	0x5259, 0x526a, 0x527a, 0x528a, 0x529a, 0x52aa, 0x52ba, 0x52cb,
	0x52dc, 0x52ec, 0x52fc, 0x5310, 0x5323, 0x5337, 0x534a, 0x535e,
	// Entry 4A00 - 4A3F
	0x5371, 0x5385, 0x5398, 0x53ac, 0x53be, 0x53cf, 0x53e7, 0x53fe,
	0x5410, 0x5423, 0x543d, 0x5449, 0x545c, 0x5473, 0x548a, 0x54a1,
	0x54b8, 0x54cf, 0x54e6, 0x54fd, 0x5515, 0x552c, 0x5543, 0x555a,
	0x5571, 0x5588, 0x559f, 0x55b6, 0x55cd, 0x55e4, 0x55fc, 0x5612,
	0x5629, 0x563f, 0x5655, 0x566b, 0x5681, 0x5698, 0x56af, 0x56c5,
	0x56db, 0x56f3, 0x570a, 0x5721, 0x5737, 0x574f, 0x5767, 0x577e,
	0x5795, 0x57a9, 0x57bc, 0x57cc, 0x57db, 0x57ea, 0x57f9, 0x580a,
	0x581c, 0x582d, 0x583f, 0x5851, 0x5862, 0x5874, 0x5885, 0x5897,
	// Entry 4A40 - 4A7F
	0x58a9, 0x58bb, 0x58ce, 0x58e0, 0x58f3, 0x5905, 0x5916, 0x5928,
	0x5939, 0x594b, 0x595c, 0x596d, 0x597f, 0x5990, 0x59a2, 0x59b3,
	0x59c5, 0x59d6, 0x59e7, 0x59f8, 0x5a09, 0x5a1a, 0x5a2b, 0x5a3e,
	0x5a51, 0x5a65, 0x5a78, 0x5a8c, 0x5a9f, 0x5ab3, 0x5ac6, 0x5ada,
	0x5aee, 0x5afb, 0x5b09, 0x5b16, 0x5b24, 0x5b35, 0x5b45, 0x5b55,
	0x5b67, 0x5b78, 0x5b89, 0x5b99, 0x5bab, 0x5bbd, 0x5bce, 0x5be1,
	0x5bed, 0x5c00, 0x5c14, 0x5c25, 0x5c36, 0x5c47, 0x5c58, 0x5c69,
	0x5c7b, 0x5c8e, 0x5ca0, 0x5cb3, 0x5cc5, 0x5cd8, 0x5cea, 0x5cfd,
	// Entry 4A80 - 4ABF
	0x5d10, 0x5d23, 0x5d37, 0x5d4a, 0x5d5e, 0x5d71, 0x5d83, 0x5d96,
	0x5da8, 0x5dbb, 0x5dcd, 0x5ddf, 0x5df2, 0x5e04, 0x5e17, 0x5e29,
	0x5e3b, 0x5e4d, 0x5e5f, 0x5e71, 0x5e83, 0x5e96, 0x5ea9, 0x5ec3,
	0x5ed8, 0x5eee, 0x5f06, 0x5f1b, 0x5f2f, 0x5f3f, 0x5f50, 0x5f60,
	0x5f71, 0x5f81, 0x5f92, 0x5faa, 0x5fc3, 0x5fdb, 0x5ff4, 0x6004,
	0x6015, 0x6025, 0x6036, 0x6047, 0x6059, 0x606a, 0x607c, 0x608e,
	0x609f, 0x60b1, 0x60c2, 0x60d4, 0x60e6, 0x60f8, 0x610b, 0x611d,
	0x6130, 0x6142, 0x6153, 0x6165, 0x6176, 0x6188, 0x6199, 0x61aa,
	// Entry 4AC0 - 4AFF
	0x61bc, 0x61cd, 0x61df, 0x61f0, 0x6201, 0x6212, 0x6223, 0x6235,
	0x6246, 0x6258, 0x626a, 0x627b, 0x628c, 0x62a1, 0x62b5, 0x62ca,
	0x62de, 0x62f3, 0x630f, 0x632c, 0x6348, 0x6365, 0x6379, 0x638e,
	0x63a2, 0x63b7, 0x63ca, 0x63df, 0x63f7, 0x640f, 0x6419, 0x6426,
	0x643a, 0x6453, 0x6464, 0x6477, 0x6489, 0x64a4, 0x64c2, 0x64d4,
	0x64e6, 0x64f7, 0x6508, 0x651b, 0x652d, 0x653f, 0x6550, 0x6563,
	0x6576, 0x6588, 0x6594, 0x65a8, 0x65ba, 0x65d3, 0x65e9, 0x65ff,
	0x6618, 0x6631, 0x664c, 0x6666, 0x6680, 0x6699, 0x66b4, 0x66cf,
	// Entry 4B00 - 4B3F
	0x66e9, 0x6703, 0x6720, 0x673d, 0x6759, 0x6775, 0x6791, 0x67af,
	0x67cc, 0x67e9, 0x680b, 0x682e, 0x683d, 0x684d, 0x685c, 0x686b,
	0x687a, 0x688a, 0x6899, 0x68a9, 0x68b9, 0x68ca, 0x68da, 0x68eb,
	0x68fc, 0x690d, 0x691d, 0x692e, 0x693e, 0x694f, 0x6960, 0x6971,
	0x6983, 0x6994, 0x69a6, 0x69b7, 0x69c7, 0x69d8, 0x69e8, 0x69fa,
	0x6a0b, 0x6a1b, 0x6a2b, 0x6a3c, 0x6a4c, 0x6a5d, 0x6a6e, 0x6a7e,
	0x6a8e, 0x6a9e, 0x6aae, 0x6abe, 0x6ace, 0x6ade, 0x6aef, 0x6b03,
	0x6b16, 0x6b2a, 0x6b3d, 0x6b50, 0x6b64, 0x6b77, 0x6b8b, 0x6b9f,
	// Entry 4B40 - 4B7F
	0x6bb1, 0x6bc2, 0x6bd4, 0x6be0, 0x6bf3, 0x6c08, 0x6c1b, 0x6c35,
	0x6c4d, 0x6c5e, 0x6c6e, 0x6c7e, 0x6c8e, 0x6c9e, 0x6caf, 0x6cc1,
	0x6cd2, 0x6ce4, 0x6cf5, 0x6d07, 0x6d18, 0x6d2a, 0x6d3c, 0x6d4e,
	0x6d61, 0x6d73, 0x6d86, 0x6d99, 0x6dab, 0x6dbc, 0x6dce, 0x6ddf,
	0x6df1, 0x6e02, 0x6e13, 0x6e25, 0x6e36, 0x6e48, 0x6e59, 0x6e6a,
	0x6e7b, 0x6e8c, 0x6e9d, 0x6eae, 0x6ebf, 0x6ed1, 0x6ee3, 0x6ef7,
	0x6f09, 0x6f1c, 0x6f2e, 0x6f41, 0x6f53, 0x6f66, 0x6f78, 0x6f8b,
	0x6f9d, 0x6fb0, 0x6fc3, 0x6fd7, 0x6fea, 0x6ffe, 0x7012, 0x7026,
	// Entry 4B80 - 4BBF
	0x7039, 0x704d, 0x7060, 0x7074, 0x7088, 0x709c, 0x70b0, 0x70c5,
	0x70d9, 0x70ee, 0x7102, 0x7117, 0x712b, 0x713e, 0x7152, 0x7165,
	0x7179, 0x718c, 0x719f, 0x71b3, 0x71c6, 0x71da, 0x71ee, 0x7201,
	0x7214, 0x7227, 0x723a, 0x724d, 0x7261, 0x7274, 0x7287, 0x729e,
	0x72b5, 0x72cb, 0x72e2, 0x72f8, 0x730f, 0x7325, 0x733c, 0x7352,
	0x7369, 0x737d, 0x7392, 0x73a6, 0x73b9, 0x73cc, 0x73e1, 0x73f5,
	0x7409, 0x741c, 0x7431, 0x7446, 0x745a, 0x747f, 0x7497, 0x74ac,
	0x74c0, 0x74d0, 0x74e1, 0x74f1, 0x7502, 0x7512, 0x7523, 0x753b,
	// Entry 4BC0 - 4BFF
	0x7553, 0x7564, 0x7575, 0x7586, 0x7597, 0x75a8, 0x75ba, 0x75cb,
	0x75dd, 0x75ef, 0x7600, 0x7612, 0x7623, 0x7635, 0x7647, 0x7659,
	0x766c, 0x767e, 0x7691, 0x76a3, 0x76b4, 0x76c6, 0x76d7, 0x76e9,
	0x76fa, 0x770b, 0x771d, 0x772e, 0x7740, 0x7751, 0x7762, 0x7773,
	0x7784, 0x7796, 0x77a7, 0x77b9, 0x77cb, 0x77dc, 0x77ed, 0x77ff,
	0x7814, 0x7829, 0x783d, 0x7852, 0x7866, 0x787b, 0x7897, 0x78b4,
	0x78c9, 0x78de, 0x78f3, 0x7908, 0x791b, 0x7925, 0x793b, 0x794d,
	0x796a, 0x798e, 0x79a7, 0x79c0, 0x79dc, 0x79f9, 0x7a15, 0x7a30,
	// Entry 4C00 - 4C3F
	0x7a4b, 0x7a68, 0x7a84, 0x7aa0, 0x7abb, 0x7ad5, 0x7af0, 0x7b0b,
	0x7b26, 0x7b41, 0x7b4e, 0x7b5c, 0x7b69, 0x7b77, 0x7b84, 0x7b92,
	0x7ba7, 0x7bbd, 0x7bd2, 0x7be8, 0x7bf5, 0x7c03, 0x7c10, 0x7c1e,
	0x7c2c, 0x7c3b, 0x7c49, 0x7c58, 0x7c67, 0x7c77, 0x7c85, 0x7c94,
	0x7ca2, 0x7cb1, 0x7cc0, 0x7cd0, 0x7cdf, 0x7cef, 0x7cfe, 0x7d0e,
	0x7d1d, 0x7d2b, 0x7d3a, 0x7d48, 0x7d57, 0x7d65, 0x7d74, 0x7d82,
	0x7d91, 0x7d9f, 0x7dae, 0x7dbc, 0x7dcb, 0x7dd9, 0x7de7, 0x7df6,
	0x7e04, 0x7e13, 0x7e21, 0x7e30, 0x7e3f, 0x7e4d, 0x7e5b, 0x7e6d,
	// Entry 4C40 - 4C7F
	0x7e7e, 0x7e90, 0x7ea1, 0x7eb3, 0x7ecc, 0x7ee6, 0x7eff, 0x7f19,
	0x7f2a, 0x7f3c, 0x7f4d, 0x7f5f, 0x7f6f, 0x7f84, 0x7f96, 0x7fa7,
	0x7fb6, 0x7fc8, 0x7fe0, 0x7fe7, 0x7ff2, 0x7ffc, 0x800d, 0x8017,
	0x8026, 0x803c, 0x804b, 0x8059, 0x8067, 0x8077, 0x8086, 0x8095,
	0x80a3, 0x80b3, 0x80c3, 0x80d2, 0x80e7, 0x80fa, 0x8106, 0x8116,
	0x8127, 0x8137, 0x8148, 0x8158, 0x8169, 0x8181, 0x819a, 0x81b2,
	0x81cb, 0x81db, 0x81ec, 0x81fc, 0x820d, 0x821e, 0x8230, 0x8241,
	0x8253, 0x8265, 0x8276, 0x8288, 0x8299, 0x82ab, 0x82bd, 0x82cf,
	// Entry 4C80 - 4CBF
	0x82e2, 0x82f4, 0x8307, 0x8319, 0x832a, 0x833c, 0x834d, 0x835f,
	0x8370, 0x8381, 0x8393, 0x83a4, 0x83b6, 0x83c7, 0x83d8, 0x83e9,
	0x83fa, 0x840b, 0x841d, 0x842f, 0x8440, 0x8451, 0x8466, 0x847a,
	0x848f, 0x84a3, 0x84b8, 0x84d4, 0x84f1, 0x850d, 0x852a, 0x853e,
	0x8558, 0x856d, 0x8581, 0x859b, 0x85b0, 0x85c8, 0x85dd, 0x85f1,
	0x8604, 0x8616, 0x862b, 0x8638, 0x8651, 0x865b, 0x866d, 0x867e,
	0x868f, 0x86a2, 0x86b4, 0x86c6, 0x86d7, 0x86ea, 0x86fd, 0x870f,
	0x871f, 0x8730, 0x8740, 0x8751, 0x8761, 0x8772, 0x878a, 0x87a3,
	// Entry 4CC0 - 4CFF
	0x87bb, 0x87d4, 0x87e4, 0x87f5, 0x8805, 0x8816, 0x8827, 0x8839,
	0x884a, 0x885c, 0x886e, 0x887f, 0x8891, 0x88a2, 0x88b4, 0x88c6,
	0x88d8, 0x88eb, 0x88fd, 0x8910, 0x8922, 0x8933, 0x8945, 0x8956,
	0x8968, 0x8979, 0x898a, 0x899c, 0x89ad, 0x89bf, 0x89d0, 0x89e1,
	0x89f2, 0x8a03, 0x8a14, 0x8a26, 0x8a38, 0x8a49, 0x8a5a, 0x8a6f,
	0x8a83, 0x8a98, 0x8aac, 0x8ac1, 0x8add, 0x8afa, 0x8b0e, 0x8b23,
	0x8b37, 0x8b4c, 0x8b64, 0x8b79, 0x8b8d, 0x8ba0, 0x8bb2, 0x8bc6,
	0x8bd3, 0x8be7, 0x8bfc, 0x8c11, 0x8c2a, 0x8c43, 0x8c5c, 0x8c74,
	// Entry 4D00 - 4D3F
	0x8cac, 0x8ce2, 0x8d15, 0x8d4f, 0x8d89, 0x8da9, 0x8dd3, 0x8dfd,
	0x8e27, 0x8e54, 0x8e80, 0x8eaa, 0x8ede, 0x8f13, 0x8f3a, 0x8f5f,
	0x8f85, 0x8f9f, 0x8fbd, 0x8fdc, 0x8fe9, 0x8ff7, 0x9004, 0x9012,
	0x901f, 0x902d, 0x9042, 0x9058, 0x906d, 0x9083, 0x9090, 0x909e,
	0x90ab, 0x90b9, 0x90c7, 0x90d6, 0x90e4, 0x90f3, 0x9102, 0x9110,
	0x911f, 0x912d, 0x913c, 0x914b, 0x915a, 0x916a, 0x9179, 0x9189,
	0x9198, 0x91a6, 0x91b5, 0x91c3, 0x91d2, 0x91e0, 0x91ee, 0x91fd,
	0x920b, 0x921a, 0x9228, 0x9236, 0x9244, 0x9252, 0x9260, 0x926f,
	// Entry 4D40 - 4D7F
	0x927e, 0x928c, 0x929a, 0x92a9, 0x92bb, 0x92cc, 0x92de, 0x92ef,
	0x9301, 0x931a, 0x9334, 0x934d, 0x9367, 0x9378, 0x938a, 0x939b,
	0x93ad, 0x93bf, 0x93d0, 0x93e0, 0x93f5, 0x93ff, 0x9410, 0x9426,
	0x9434, 0x9443, 0x9451, 0x945f, 0x946f, 0x947e, 0x948d, 0x949b,
	0x94ab, 0x94bb, 0x94ca, 0x94e7, 0x94fe, 0x9522, 0x9546, 0x956a,
	0x958f, 0x95bb, 0x95d3, 0x9600, 0x9615, 0x9638, 0x9662, 0x9693,
	0x96a1, 0x96b0, 0x96be, 0x96cd, 0x96db, 0x96ea, 0x96f8, 0x9707,
	0x9715, 0x9724, 0x9733, 0x9743, 0x9752, 0x9762, 0x9772, 0x9781,
	// Entry 4D80 - 4DBF
	0x9791, 0x97a0, 0x97b0, 0x97c0, 0x97d0, 0x97e1, 0x97f1, 0x9802,
	0x9812, 0x9821, 0x9831, 0x9840, 0x9850, 0x985f, 0x986e, 0x987e,
	0x988d, 0x989d, 0x98ac, 0x98bb, 0x98ca, 0x98d9, 0x98e8, 0x98f8,
	0x9907, 0x9916, 0x9926, 0x9939, 0x994b, 0x995e, 0x9970, 0x9983,
	0x9995, 0x99a8, 0x99ba, 0x99cd, 0x99df, 0x99f2, 0x9a03, 0x9a13,
	0x9a23, 0x9a32, 0x9a41, 0x9a52, 0x9a62, 0x9a72, 0x9a81, 0x9a92,
	0x9aa3, 0x9ab3, 0x9ac1, 0x9ad0, 0x9adf, 0x9aed, 0x9afb, 0x9b13,
	0x9b21, 0x9b30, 0x9b3e, 0x9b4c, 0x9b5a, 0x9b69, 0x9b78, 0x9b86,
	// Entry 4DC0 - 4DFF
	0x9b94, 0x9ba2, 0x9bb1, 0x9bbf, 0x9bcc, 0x9bda, 0x9be9, 0x9bf7,
	0x9c0f, 0x9c1e, 0x9c2d, 0x9c3c, 0x9c59, 0x9c76, 0x9c9c, 0x9cad,
	0x9cbf, 0x9cd0, 0x9ce2, 0x9cf3, 0x9d05, 0x9d16, 0x9d28, 0x9d39,
	0x9d4b, 0x9d5d, 0x9d6d, 0x9d7c, 0x9d8a, 0x9d98, 0x9da8, 0x9db7,
	0x9dc6, 0x9dd4, 0x9de4, 0x9df4, 0x9e03, 0x9e12, 0x9e24, 0x9e3b,
	0x9e4c, 0x9e5b, 0x9e69, 0x9e88, 0x9ea4, 0x9ec1, 0x9ede, 0x9efb,
	0x9f18, 0x9f35, 0x9f52, 0x9f6e, 0x9f8a, 0x9fa8, 0x9fc5, 0x9fe2,
	0xa000, 0xa01e, 0xa03b, 0xa059, 0xa077, 0xa095, 0xa0b4, 0xa0d1,
	// Entry 4E00 - 4E3F
	0xa0ee, 0xa10b, 0xa128, 0xa145, 0xa164, 0xa183, 0xa1a2, 0xa1c0,
	0xa1df, 0xa1fd, 0xa21c, 0xa239, 0xa253, 0xa26e, 0xa289, 0xa2a4,
	0xa2bf, 0xa2da, 0xa2f5, 0xa30f, 0xa329, 0xa345, 0xa360, 0xa37b,
	0xa397, 0xa3b3, 0xa3ce, 0xa3ea, 0xa406, 0xa422, 0xa43f, 0xa45a,
	0xa475, 0xa490, 0xa4ab, 0xa4c6, 0xa4e3, 0xa500, 0xa51d, 0xa539,
	0xa556, 0xa572, 0xa58f, 0xa5a5, 0xa5ba, 0xa5cf, 0xa5e6, 0xa5fc,
	0xa612, 0xa627, 0xa63e, 0xa655, 0xa66b, 0xa681, 0xa69a, 0xa6b3,
	0xa6cb, 0xa6e3, 0xa6fb, 0xa715, 0xa72e, 0xa747, 0xa755, 0xa76e,
	// Entry 4E40 - 4E7F
	0xa78b, 0xa7a9, 0xa7c6, 0xa7e3, 0xa801, 0xa81e, 0xa83c, 0xa85a,
	0xa880, 0xa8a2, 0xa8bc, 0xa8d7, 0xa8f1, 0xa90c, 0xa927, 0xa941,
	0xa95c, 0xa976, 0xa991, 0xa9ac, 0xa9c8, 0xa9e3, 0xa9ff, 0xaa1a,
	0xaa34, 0xaa4f, 0xaa69, 0xaa84, 0xaa9e, 0xaab8, 0xaad3, 0xaaed,
	0xab08, 0xab22, 0xab3d, 0xab59, 0xab74, 0xab90, 0xabab, 0xabc5,
	0xabdf, 0xabf9, 0xac13, 0xac2d, 0xac47, 0xac62, 0xac7d, 0xac97,
	0xacb1, 0xaccd, 0xacf2, 0xad0e, 0xad2f, 0xad5e, 0xad88, 0xada6,
	0xadc3, 0xaded, 0xae15, 0xae3d, 0xae65, 0xae8d, 0xaeaf, 0xaed1,
	// Entry 4E80 - 4EBF
	0xaeec, 0xaf06, 0xaf27, 0xaf47, 0xaf76, 0xafa5, 0xafbf, 0xafcf,
	0xafe3, 0xaff8, 0xb00c, 0xb020, 0xb034, 0xb049, 0xb05e, 0xb073,
	0xb08f, 0xb0ab, 0xb0c4, 0xb0d5, 0xb0e7, 0xb0f8, 0xb10a, 0xb11c,
	0xb12d, 0xb13f, 0xb150, 0xb162, 0xb174, 0xb186, 0xb199, 0xb1ab,
	0xb1be, 0xb1d0, 0xb1e1, 0xb1f3, 0xb204, 0xb216, 0xb227, 0xb238,
	0xb24a, 0xb25b, 0xb26d, 0xb27e, 0xb290, 0xb2a3, 0xb2b5, 0xb2c7,
	0xb2d8, 0xb2e9, 0xb2fa, 0xb30b, 0xb31c, 0xb32d, 0xb33f, 0xb351,
	0xb362, 0xb373, 0xb386, 0xb3a7, 0xb3c8, 0xb3ea, 0xb40b, 0xb429,
	// Entry 4EC0 - 4EFF
	0xb447, 0xb466, 0xb484, 0xb4a2, 0xb4c0, 0xb4de, 0xb4fc, 0xb51a,
	0xb539, 0xb557, 0xb576, 0xb58b, 0xb59f, 0xb5b6, 0xb5c7, 0xb5d9,
	0xb5ea, 0xb602, 0xb636, 0xb663, 0xb686, 0xb69d, 0xb6b4, 0xb6c9,
	0xb6de, 0xb6f3, 0xb708, 0xb71d, 0xb732, 0xb747, 0xb75d, 0xb772,
	0xb787, 0xb79d, 0xb7b2, 0xb7c7, 0xb7dc, 0xb7f1, 0xb807, 0xb81c,
	0xb832, 0xb847, 0xb85c, 0xb872, 0xb886, 0xb89a, 0xb8ae, 0xb8c2,
	0xb8d6, 0xb8eb, 0xb900, 0xb91a, 0xb934, 0xb94e, 0xb968, 0xb982,
	0xb99c, 0xb9b6, 0xb9d1, 0xb9eb, 0xba07, 0xba1e, 0xba3d, 0xba5f,
	// Entry 4F00 - 4F3F
	0xba7c, 0xbaa1, 0xbabd, 0xbad4, 0xbaf6, 0xbb13, 0xbb2d, 0xbb4d,
	0xbb72, 0xbb92, 0xbbb3, 0xbbcf, 0xbbe7, 0xbc0e, 0xbc30, 0xbc4e,
	0xbc60, 0xbc73, 0xbc85, 0xbc98, 0xbcaa, 0xbcbd, 0xbcd7, 0xbcf2,
	0xbd0c, 0xbd1e, 0xbd31, 0xbd43, 0xbd56, 0xbd69, 0xbd7d, 0xbd90,
	0xbda4, 0xbdb8, 0xbdcb, 0xbddf, 0xbdf2, 0xbe06, 0xbe1a, 0xbe2e,
	0xbe43, 0xbe57, 0xbe6c, 0xbe80, 0xbe93, 0xbea7, 0xbeba, 0xbece,
	0xbee1, 0xbef4, 0xbf08, 0xbf1b, 0xbf2f, 0xbf42, 0xbf55, 0xbf68,
	0xbf7b, 0xbf8e, 0xbfa2, 0xbfb6, 0xbfc9, 0xbfdc, 0xbff3, 0xc009,
	// Entry 4F40 - 4F7F
	0xc020, 0xc036, 0xc04d, 0xc06b, 0xc08a, 0xc0a8, 0xc0be, 0xc0d5,
	0xc0eb, 0xc102, 0xc11c, 0xc133, 0xc149, 0xc15e, 0xc175, 0xc184,
	0xc19a, 0xc1b2, 0xc1c8, 0xc1de, 0xc1f2, 0xc205, 0xc218, 0xc22d,
	0xc241, 0xc255, 0xc268, 0xc27d, 0xc292, 0xc2a6, 0xc2ba, 0xc2ce,
	0xc2e4, 0xc2f9, 0xc30e, 0xc322, 0xc338, 0xc34e, 0xc363, 0xc377,
	0xc38e, 0xc3a5, 0xc3bb, 0xc3d1, 0xc3e7, 0xc3ff, 0xc416, 0xc42d,
	0xc449, 0xc45a, 0xc46b, 0xc47c, 0xc48e, 0xc49f, 0xc4b1, 0xc4c2,
	0xc4d4, 0xc4e5, 0xc4f7, 0xc508, 0xc51a, 0xc52b, 0xc53c, 0xc54d,
	// Entry 4F80 - 4FBF
	0xc55f, 0xc570, 0xc581, 0xc593, 0xc5a6, 0xc5b8, 0xc5c9, 0xc5db,
	0xc5ec, 0xc5fd, 0xc60e, 0xc61f, 0xc630, 0xc642, 0xc653, 0xc664,
	0xc674, 0xc68f, 0xc6ab, 0xc6c6, 0xc6e2, 0xc6fd, 0xc719, 0xc734,
	0xc750, 0xc76b, 0xc787, 0xc7a2, 0xc7bd, 0xc7d8, 0xc7f4, 0xc80f,
	0xc82a, 0xc846, 0xc863, 0xc87f, 0xc89a, 0xc8b6, 0xc8d1, 0xc8ec,
	0xc907, 0xc922, 0xc93e, 0xc959, 0xc974, 0xc98e, 0xc9a3, 0xc9b7,
	0xc9cb, 0xc9df, 0xc9f3, 0xca08, 0xca20, 0xca36, 0xca4d, 0xca63,
	0xca7a, 0xca90, 0xcaa7, 0xcabd, 0xcad4, 0xcaea, 0xcb01, 0xcb18,
	// Entry 4FC0 - 4FFF
	0xcb30, 0xcb47, 0xcb5f, 0xcb77, 0xcb8e, 0xcba6, 0xcbbd, 0xcbd5,
	0xcbed, 0xcc05, 0xcc1e, 0xcc36, 0xcc4f, 0xcc67, 0xcc7e, 0xcc96,
	0xccad, 0xccc5, 0xccdc, 0xccf3, 0xcd0b, 0xcd22, 0xcd3a, 0xcd51,
	0xcd68, 0xcd7f, 0xcd96, 0xcdad, 0xcdc5, 0xcddd, 0xcdf4, 0xce0b,
	0xce23, 0xce3c, 0xce55, 0xce6d, 0xce88, 0xcea2, 0xcebd, 0xced7,
	0xcef2, 0xcf14, 0xcf2e, 0xcf49, 0xcf63, 0xcf7e, 0xcf99, 0xcfb3,
	0xcfcb, 0xcfe4, 0xcffe, 0xd012, 0xd025, 0xd03a, 0xd052, 0xd069,
	0xd080, 0xd099, 0xd0b1, 0xd0c9, 0xd0e0, 0xd0f9, 0xd112, 0xd12a,
	// Entry 5000 - 503F
	0xd13a, 0xd152, 0xd16c, 0xd18c, 0xd1a5, 0xd1bf, 0xd1e0, 0xd1fb,
	0xd215, 0xd226, 0xd237, 0xd253, 0xd274, 0xd28f, 0xd2b0, 0xd2ca,
	0xd2ea, 0xd306, 0xd323, 0xd340, 0xd367, 0xd37d, 0xd38f, 0xd3ad,
	0xd3cf, 0xd3f2, 0xd40f, 0xd42c, 0xd43d, 0xd44e, 0xd46b, 0xd492,
	0xd4a3, 0xd4bd, 0xd4d9, 0xd4f5, 0xd50f, 0xd52b, 0xd545, 0xd560,
	0xd57b, 0xd58e, 0xd5a2, 0xd5b5, 0xd5d2, 0xd5e3, 0xd5fc, 0xd619,
	0xd64a, 0xd66d, 0xd681, 0xd694, 0xd6a7, 0xd6c4, 0xd6d8, 0xd6ec,
	0xd6fe, 0xd71a, 0xd736, 0xd773, 0xd797, 0xd7da, 0xd7ed, 0xd802,
	// Entry 5040 - 507F
	0xd813, 0xd825, 0xd838, 0xd84d, 0xd85f, 0xd87a, 0xd88e, 0xd8a0,
	0xd8b4, 0xd8c5, 0xd8de, 0xd8f9, 0xd919, 0xd92a, 0xd946, 0xd962,
	0xd97f, 0xd993, 0xd9b2, 0xd9c4, 0xd9d7, 0xd9e8, 0xd9fa, 0xda25,
	0xda49, 0xda6e, 0xda90, 0xdab2, 0xdade, 0xdb00, 0xdb24, 0xdb47,
	0xdb69, 0xdb8b, 0xdbb5, 0xdbd8, 0xdbfa, 0xdc1c, 0xdc49, 0xdc6c,
	0xdc8e, 0xdcba, 0xdcdc, 0xdd00, 0xdd2c, 0xdd4f, 0xdd61, 0xdd73,
	0xdd87, 0xdd9b, 0xddac, 0xddbe, 0xddd0, 0xddec, 0xddff, 0xde11,
	0xde36, 0xde49, 0xde5a, 0xde73, 0xde89, 0xdea2, 0xdeb4, 0xded1,
	// Entry 5080 - 50BF
	0xdee4, 0xdef6, 0xdf0a, 0xdf1c, 0xdf2e, 0xdf41, 0xdf59, 0xdf76,
	0xdf89, 0xdf9c, 0xdfac, 0xdfc6, 0xdfea, 0xdffb, 0xe024, 0xe03f,
	0xe059, 0xe074, 0xe08f, 0xe0a8, 0xe0bb, 0xe0ce, 0xe0df, 0xe0f0,
	0xe10c, 0xe12d, 0xe147, 0xe164, 0xe181, 0xe19a, 0xe1ad, 0xe1c1,
	0xe1d4, 0xe1e7, 0xe202, 0xe226, 0xe254, 0xe270, 0xe28d, 0xe2b0,
	0xe2d8, 0xe2f4, 0xe315, 0xe337, 0xe357, 0xe37f, 0xe39c, 0xe3b8,
	0xe3df, 0xe3fb, 0xe417, 0xe433, 0xe44f, 0xe460, 0xe476, 0xe488,
	0xe4b2, 0xe4d4, 0xe4f7, 0xe521, 0xe53c, 0xe558, 0xe57e, 0xe59a,
	// Entry 50C0 - 50FF
	0xe5be, 0xe5da, 0xe5fe, 0xe619, 0xe634, 0xe65a, 0xe676, 0xe691,
	0xe6b4, 0xe6cf, 0xe6fa, 0xe71c, 0xe738, 0xe753, 0xe76f, 0xe792,
	0xe7b7, 0xe7e4, 0xe800, 0xe824, 0xe847, 0xe864, 0xe885, 0xe8b2,
	0xe8ce, 0xe8ed, 0xe909, 0xe92e, 0xe952, 0xe96d, 0xe990, 0xe9ab,
	0xe9c7, 0xe9ec, 0xea07, 0xea23, 0xea3f, 0xea5b, 0xea80, 0xea9d,
	0xeab9, 0xead6, 0xeaf0, 0xeb0b, 0xeb2e, 0xeb49, 0xeb5c, 0xeb7d,
	0xeb8f, 0xebb7, 0xebc9, 0xebf5, 0xec09, 0xec1b, 0xec2d, 0xec40,
	0xec58, 0xec75, 0xec96, 0xeca8, 0xecbb, 0xecd0, 0xece6, 0xed06,
	// Entry 5100 - 513F
	0xed17, 0xed30, 0xed49, 0xed66, 0xed78, 0xed93, 0xedb2, 0xedc6,
	0xedd9, 0xedf1, 0xee04, 0xee28, 0xee4b, 0xee68, 0xee8d, 0xeea9,
	0xeebd, 0xeed0, 0xeef1, 0xef0e, 0xef2c, 0xef44, 0xef55, 0xef72,
	0xef84, 0xefa0, 0xefcb, 0xefe7, 0xf00d, 0xf024, 0xf036, 0xf059,
	0xf075, 0xf096, 0xf0a8, 0xf0ba, 0xf0d6, 0xf0e8, 0xf0fb, 0xf10f,
	0xf124, 0xf135, 0xf14b, 0xf161, 0xf173, 0xf184, 0xf19f, 0xf1bb,
	0xf1d6, 0xf1f2, 0xf20d, 0xf228, 0xf243, 0xf25e, 0xf277, 0xf288,
	0xf29b, 0xf2b7, 0xf2d4, 0xf2f4, 0xf312, 0xf32e, 0xf341, 0xf351,
	// Entry 5140 - 517F
	0xf363, 0xf374, 0xf387, 0xf3a8, 0xf3cd, 0xf3de, 0xf3f0, 0xf406,
	0xf41b, 0xf450, 0xf467, 0xf478, 0xf499, 0xf4ab, 0xf4bc, 0xf4d8,
	0xf4f5, 0xf512, 0xf52b, 0xf53e, 0xf54f, 0xf560, 0xf572, 0xf583,
	0xf59c, 0xf5b6, 0xf5d9, 0xf5f5, 0xf610, 0xf62d, 0xf648, 0xf662,
	0xf67f, 0xf69b, 0xf6b5, 0xf6d0, 0xf6f1, 0xf70c, 0xf738, 0xf752,
	0xf76e, 0xf793, 0xf7bd, 0xf7d7, 0xf7f3, 0xf80e, 0xf828, 0xf843,
	0xf85d, 0xf878, 0xf892, 0xf8ac, 0xf8c6, 0xf8e8, 0xf90a, 0xf92c,
	0xf946, 0xf96b, 0xf985, 0xf9a0, 0xf9ba, 0xf9d4, 0xf9ee, 0xfa09,
	// Entry 5180 - 51BF
	0xfa24, 0xfa3f, 0xfa5b, 0xfa76, 0xfa91, 0xfaae, 0xfac9, 0xfae2,
	0xfafc, 0xfb16, 0xfb3b, 0xfb56, 0xfb70, 0xfb82, 0xfba1, 0xfbb3,
	0xfbc6, 0xfbd9, 0xfbec, 0xfbff, 0xfc1c, 0xfc2e, 0xfc4f, 0xfc61,
	0xfc7d, 0xfc9c, 0xfcaf, 0xfcc2, 0xfcd7, 0xfd0d, 0xfd4f, 0xfd63,
	0xfd74, 0xfd8f, 0xfda8, 0xfdc2, 0xfdd4, 0xfde6, 0xfdfa, 0xfe0d,
	0xfe22, 0xfe43, 0xfe54, 0xfe8e, 0xfea0, 0xfeb2, 0xfed1, 0xfee3,
	0xfef5, 0xff0c, 0xff1e, 0xff30, 0xff4f, 0xff64, 0xff79, 0xff8a,
	0xff9e, 0xffba, 0xffe6, 0x000b, 0x0030, 0x004d, 0x006a, 0x0092,
	// Entry 51C0 - 51FF
	0x00b0, 0x00cd, 0x00eb, 0x0108, 0x0125, 0x0143, 0x0161, 0x0188,
	0x01a5, 0x01c3, 0x01ea, 0x020d, 0x022a, 0x024f, 0x0274, 0x0291,
	0x02af, 0x02cd, 0x02eb, 0x0318, 0x0338, 0x0357, 0x0374, 0x0392,
	0x03af, 0x03d4, 0x03f3, 0x0410, 0x0437, 0x046c, 0x049b, 0x04ba,
	0x04e3, 0x0501, 0x051f, 0x053e, 0x0572, 0x058e, 0x05b1, 0x05db,
	0x0601, 0x061e, 0x063c, 0x0658, 0x066c, 0x068a, 0x06b1, 0x06ca,
	0x06f7, 0x070c, 0x071e, 0x073a, 0x074c, 0x0768, 0x078c, 0x079d,
	0x07af, 0x07c4, 0x07d7, 0x07e8, 0x0803, 0x0815, 0x0830, 0x084c,
	// Entry 5200 - 523F
	0x0869, 0x088b, 0x08ad, 0x08d2, 0x08ed, 0x090a, 0x0927, 0x094d,
	0x0968, 0x098c, 0x09aa, 0x09cd, 0x09e8, 0x0a03, 0x0a27, 0x0a4c,
	0x0a69, 0x0a80, 0x0a9f, 0x0abe, 0x0ad8, 0x0af2, 0x0b04, 0x0b18,
	0x0b37, 0x0b5a, 0x0b76, 0x0b88, 0x0b9a, 0x0bac, 0x0bc7, 0x0bef,
	0x0c00, 0x0c1c, 0x0c32, 0x0c44, 0x0c56, 0x0c68, 0x0c7b, 0x0c8f,
	0x0ca0, 0x0cb2, 0x0cc3, 0x0cd5, 0x0ce6, 0x0cff, 0x0d11, 0x0d28,
	0x0d3d, 0x0d52, 0x0d65, 0x0d80, 0x0d9d, 0x0db9, 0x0dd6, 0x0e03,
	0x0e24, 0x0e38, 0x0e54, 0x0e78, 0x0e95, 0x0eae, 0x0ebf, 0x0ed1,
	// Entry 5240 - 527F
	0x0ee4, 0x0f00, 0x0f22, 0x0f43, 0x0f57, 0x0f71, 0x0f83, 0x0f96,
	0x0fa7, 0x0fc0, 0x0fda, 0x0ff3, 0x1004, 0x101d, 0x102f, 0x1041,
	0x1063, 0x108e, 0x10a3, 0x10c1, 0x10e0, 0x1108, 0x1127, 0x1154,
	0x1172, 0x1191, 0x11b0, 0x11d9, 0x1201, 0x1232, 0x1259, 0x1278,
	0x128c, 0x129d, 0x12b0, 0x12c2, 0x12e4, 0x1307, 0x1329, 0x1364,
	0x1386, 0x139d, 0x13b8, 0x13d7, 0x1407, 0x141b, 0x1440, 0x1461,
	0x1483, 0x14a5, 0x14cc, 0x14ef, 0x1510, 0x1531, 0x1555, 0x1576,
	0x159a, 0x15c0, 0x15d1, 0x15e3, 0x15f5, 0x1607, 0x161b, 0x162c,
	// Entry 5280 - 52BF
	0x1645, 0x165f, 0x1679, 0x1693, 0x16ac, 0x16c5, 0x16df, 0x16f8,
	0x1712, 0x172f, 0x1743, 0x1761, 0x177e, 0x179b, 0x17be, 0x17cf,
	0x17e1, 0x17f2, 0x1803, 0x1814, 0x182e, 0x1840, 0x185a, 0x1875,
	0x1891, 0x18ac, 0x18c8, 0x18e4, 0x1900, 0x191b, 0x1937, 0x1953,
	0x1970, 0x198c, 0x19a7, 0x19c2, 0x19dd, 0x19f8, 0x1a14, 0x1a2f,
	0x1a46, 0x1a58, 0x1a7b, 0x1a90, 0x1aa2, 0x1ab4, 0x1ac7, 0x1ae2,
	0x1aff, 0x1b1d, 0x1b39, 0x1b57, 0x1b74, 0x1b8f, 0x1bb1, 0x1bc4,
	0x1bd8, 0x1bec, 0x1bfe, 0x1c13, 0x1c48, 0x1c7d, 0x1c91, 0x1ca4,
	// Entry 52C0 - 52FF
	0x1cb8, 0x1ccd, 0x1ce4, 0x1cf7, 0x1d12, 0x1d2e, 0x1d41, 0x1d5c,
	0x1d79, 0x1d98, 0x1db5, 0x1dd2, 0x1def, 0x1e11, 0x1e31, 0x1e4e,
	0x1e6b, 0x1e88, 0x1e9d, 0x1eb0, 0x1ec8, 0x1ef2, 0x1f06, 0x1f18,
	0x1f3c, 0x1f4f, 0x1f64, 0x1f75, 0x1f8b, 0x1f9d, 0x1fb0, 0x1fd2,
	0x1fe5, 0x1ff9, 0x200a, 0x2023, 0x2035, 0x2048, 0x205c, 0x206e,
	0x2083, 0x2095, 0x20a8, 0x20b9, 0x20d3, 0x20ed, 0x2107, 0x211d,
	0x212f, 0x2164, 0x217e, 0x2190, 0x21ab, 0x21c7, 0x21e3, 0x21ff,
	0x221c, 0x2237, 0x224a, 0x225c, 0x226d, 0x2283, 0x2294, 0x22aa,
	// Entry 5300 - 533F
	0x22bc, 0x22ce, 0x22eb, 0x2306, 0x233b, 0x234c, 0x235f, 0x2371,
	0x2383, 0x2395, 0x23bb, 0x23cb, 0x23df, 0x23f3, 0x2422, 0x2446,
	0x2478, 0x2489, 0x249a, 0x24ab, 0x24c3, 0x24de, 0x24f8, 0x251f,
	0x254b, 0x2561, 0x257a, 0x259d, 0x25b0, 0x25c1, 0x25de, 0x2600,
	0x261c, 0x2635, 0x2649, 0x265c, 0x267c, 0x2698, 0x26a9, 0x26bf,
	0x26d0, 0x26ed, 0x2706, 0x2718, 0x273a, 0x275c, 0x2777, 0x2792,
	0x27ae, 0x27c9, 0x27ed, 0x2810, 0x2822, 0x2834, 0x2847, 0x2859,
	0x2873, 0x2892, 0x28ae, 0x28ca, 0x28e5, 0x2901, 0x2923, 0x293f,
	// Entry 5340 - 537F
	0x295a, 0x2975, 0x2991, 0x29ac, 0x29c8, 0x29e3, 0x29ff, 0x2a1b,
	0x2a36, 0x2a52, 0x2a6f, 0x2a8a, 0x2aad, 0x2ac8, 0x2ae6, 0x2afa,
	0x2b16, 0x2b28, 0x2b42, 0x2b5d, 0x2b79, 0x2b96, 0x2ba9, 0x2bbc,
	0x2bd1, 0x2be5, 0x2bf7, 0x2c16, 0x2c28, 0x2c39, 0x2c4f, 0x2c72,
	0x2c84, 0x2c97, 0x2ca9, 0x2cba, 0x2cd3, 0x2ce5, 0x2cf7, 0x2d13,
	0x2d25, 0x2d38, 0x2d49, 0x2d5b, 0x2d75, 0x2d89, 0x2d9b, 0x2db5,
	0x2dd0, 0x2dea, 0x2e07, 0x2e33, 0x2e46, 0x2e62, 0x2e7e, 0x2e9b,
	0x2eb8, 0x2ee3, 0x2f00, 0x2f13, 0x2f25, 0x2f38, 0x2f55, 0x2f71,
	// Entry 5380 - 53BF
	0x2f8d, 0x2fa8, 0x2fcd, 0x2fe8, 0x3002, 0x301e, 0x3038, 0x3053,
	0x3070, 0x3094, 0x30ba, 0x30d6, 0x30e9, 0x3106, 0x3118, 0x312a,
	0x313d, 0x315c, 0x317a, 0x31a4, 0x31c1, 0x31d4, 0x31f5, 0x3207,
	0x3221, 0x3233, 0x3251, 0x3271, 0x3290, 0x32af, 0x32cd, 0x32ed,
	0x330d, 0x332c, 0x334d, 0x336d, 0x338d, 0x33ac, 0x33cd, 0x33ee,
	0x340e, 0x342b, 0x3448, 0x3464, 0x3482, 0x34a0, 0x34bd, 0x34dd,
	0x34fd, 0x351f, 0x3540, 0x3561, 0x3581, 0x35a3, 0x35c5, 0x35e6,
	0x3606, 0x3626, 0x3648, 0x3669, 0x368a, 0x36aa, 0x36cc, 0x36fb,
	// Entry 53C0 - 53FF
	0x371c, 0x373d, 0x375d, 0x377f, 0x37a1, 0x37c2, 0x37e2, 0x3802,
	0x3824, 0x3853, 0x3874, 0x3895, 0x38c5, 0x38f4, 0x3913, 0x3932,
	0x3953, 0x3981, 0x39a1, 0x39c1, 0x39f0, 0x3a1f, 0x3a4d, 0x3a7c,
	0x3aac, 0x3adc, 0x3b08, 0x3b37, 0x3b67, 0x3b97, 0x3bc5, 0x3bf4,
	0x3c23, 0x3c53, 0x3c83, 0x3cb4, 0x3cd7, 0x3cfc, 0x3d20, 0x3d44,
	0x3d67, 0x3d86, 0x3da5, 0x3dc6, 0x3de6, 0x3e13, 0x3e33, 0x3e60,
	0x3e80, 0x3ea0, 0x3ec0, 0x3ee0, 0x3f05, 0x3f2b, 0x3f52, 0x3f81,
	0x3fb1, 0x3fd6, 0x3ffc, 0x4029, 0x4058, 0x407e, 0x40a1, 0x40c9,
	// Entry 5400 - 543F
	0x40f2, 0x4116, 0x413a, 0x4164, 0x418e, 0x41b7, 0x41e2, 0x420d,
	0x4237, 0x426b, 0x4294, 0x42bd, 0x42e9, 0x4316, 0x4336, 0x4352,
	0x436e, 0x4390, 0x43af, 0x43cd, 0x43eb, 0x440e, 0x442a, 0x4446,
	0x4462, 0x4480, 0x449c, 0x44ba, 0x44d6, 0x44fa, 0x4516, 0x4532,
	0x4550, 0x456b, 0x4586, 0x45a8, 0x45c5, 0x45e0, 0x45fb, 0x461c,
	0x463b, 0x4657, 0x4676, 0x46a1, 0x46c1, 0x46dd, 0x4703, 0x4729,
	0x4746, 0x4762, 0x477d, 0x4798, 0x47b3, 0x47cf, 0x47ef, 0x480a,
	0x4825, 0x483b, 0x485c, 0x4881, 0x48a5, 0x48cf, 0x48f3, 0x4918,
	// Entry 5440 - 547F
	0x493c, 0x4961, 0x4985, 0x49a1, 0x49c0, 0x49e1, 0x4a0c, 0x4a35,
	0x4a52, 0x4a6d, 0x4a91, 0x4ab5, 0x4ad7, 0x4b02, 0x4b1e, 0x4b44,
	0x4b60, 0x4b7d, 0x4b98, 0x4bbb, 0x4bde, 0x4bfb, 0x4c18, 0x4c42,
	0x4c60, 0x4c8c, 0x4cad, 0x4cd4, 0x4cef, 0x4d1c, 0x4d36, 0x4d50,
	0x4d6d, 0x4d87, 0x4dac, 0x4dc2, 0x4dd8, 0x4dee, 0x4e04, 0x4e1a,
	0x4e30, 0x4e46, 0x4e6e, 0x4e84, 0x4ea7, 0x4ebd, 0x4ed3, 0x4ee9,
	0x4eff, 0x4f15, 0x4f2b, 0x4f41, 0x4f57, 0x4f6d, 0x4f83, 0x4f99,
	0x4faf, 0x4fc5, 0x4fdb, 0x4ff1, 0x5007, 0x501d, 0x5033, 0x5049,
	// Entry 5480 - 54BF
	0x5068, 0x5088, 0x50b1, 0x50e3, 0x510a, 0x5120, 0x5136, 0x514c,
	0x5162, 0x5178, 0x518e, 0x51a4, 0x51ba, 0x51d0, 0x51e6, 0x51fc,
	0x521c, 0x523c, 0x5267, 0x5287, 0x52a6, 0x52c6, 0x52e5, 0x5304,
	0x5323, 0x5345, 0x535b, 0x5371, 0x5391, 0x53b0, 0x53d0, 0x53f5,
	0x5414, 0x5446, 0x5470, 0x548f, 0x54b1, 0x54c7, 0x54dd, 0x54fe,
	0x551b, 0x5537, 0x5553, 0x5581, 0x559e, 0x55b8, 0x55de, 0x5605,
	0x5629, 0x5649, 0x5668, 0x5686, 0x56a7, 0x56ca, 0x56ea, 0x5712,
	0x572f, 0x5753, 0x5774, 0x5794, 0x57af, 0x57d3, 0x57f0, 0x5808,
	// Entry 54C0 - 54FF
	0x5823, 0x583f, 0x585b, 0x5876, 0x589b, 0x58bf, 0x58db, 0x58f7,
	0x5919, 0x593c, 0x5957, 0x5972, 0x5990, 0x59b0, 0x59cc, 0x59de,
	0x5a00, 0x5a28, 0x5a40, 0x5a58, 0x5a70, 0x5a88, 0x5aa0, 0x5ab9,
	0x5ad1, 0x5aea, 0x5b03, 0x5b1b, 0x5b33, 0x5b4b, 0x5b63, 0x5b7b,
	0x5b93, 0x5bab, 0x5bc3, 0x5bdc, 0x5bf4, 0x5c0c, 0x5c24, 0x5c3d,
	0x5c55, 0x5c6d, 0x5c85, 0x5c9d, 0x5cb5, 0x5ccd, 0x5ce5, 0x5cfd,
	0x5d15, 0x5d2d, 0x5d45, 0x5d5d, 0x5d75, 0x5d8d, 0x5da5, 0x5dbe,
	0x5dd6, 0x5dee, 0x5e06, 0x5e1e, 0x5e36, 0x5e4e, 0x5e66, 0x5e7e,
	// Entry 5500 - 553F
	0x5e97, 0x5eaf, 0x5ec7, 0x5ee0, 0x5ef8, 0x5f11, 0x5f29, 0x5f41,
	0x5f5a, 0x5f72, 0x5f8a, 0x5fa2, 0x5fba, 0x5fd2, 0x5fea, 0x6002,
	0x601a, 0x6032, 0x604a, 0x6062, 0x607a, 0x6092, 0x60aa, 0x60c2,
	0x60da, 0x60f2, 0x610a, 0x6122, 0x613a, 0x6152, 0x616a, 0x6182,
	0x619a, 0x61b2, 0x61ca, 0x61e2, 0x61fa, 0x6212, 0x622a, 0x6243,
	0x625b, 0x6273, 0x628b, 0x62a3, 0x62bb, 0x62d3, 0x62ec, 0x6305,
	0x631e, 0x6336, 0x634e, 0x6366, 0x637e, 0x6396, 0x63ae, 0x63c6,
	0x63de, 0x63f7, 0x640f, 0x6427, 0x643f, 0x6457, 0x646f, 0x6487,
	// Entry 5540 - 557F
	0x649f, 0x64b7, 0x64cf, 0x64e7, 0x64ff, 0x6517, 0x652f, 0x6547,
	0x655f, 0x6577, 0x658f, 0x65a7, 0x65bf, 0x65d7, 0x65ef, 0x6607,
	0x6620, 0x6638, 0x6650, 0x6668, 0x6680, 0x6698, 0x66b0, 0x66c8,
	0x66e0, 0x66f8, 0x6710, 0x6728, 0x6740, 0x6758, 0x6770, 0x6788,
	0x67a0, 0x67b8, 0x67d0, 0x67e8, 0x6801, 0x6819, 0x6831, 0x6849,
	0x6861, 0x687a, 0x6892, 0x68aa, 0x68c2, 0x68db, 0x68f3, 0x690b,
	0x6923, 0x693b, 0x6953, 0x696b, 0x6983, 0x699b, 0x69b3, 0x69cb,
	0x69e3, 0x69fb, 0x6a14, 0x6a2c, 0x6a44, 0x6a5d, 0x6a75, 0x6a8d,
	// Entry 5580 - 55BF
	0x6aa6, 0x6abf, 0x6ad8, 0x6af1, 0x6b0a, 0x6b23, 0x6b3c, 0x6b55,
	0x6b6e, 0x6b86, 0x6b9e, 0x6bb7, 0x6bcf, 0x6be7, 0x6c00, 0x6c18,
	0x6c30, 0x6c48, 0x6c60, 0x6c78, 0x6c90, 0x6ca8, 0x6cc0, 0x6cd8,
	0x6cf0, 0x6d08, 0x6d20, 0x6d38, 0x6d51, 0x6d6a, 0x6d83, 0x6d9c,
	0x6db5, 0x6dce, 0x6de7, 0x6e00, 0x6e18, 0x6e30, 0x6e48, 0x6e60,
	0x6e78, 0x6e90, 0x6ea8, 0x6ec0, 0x6ed9, 0x6ef1, 0x6f0a, 0x6f22,
	0x6f3a, 0x6f52, 0x6f6a, 0x6f82, 0x6f9a, 0x6fb2, 0x6fcb, 0x6fe3,
	0x6ffc, 0x7014, 0x702c, 0x7044, 0x705d, 0x7075, 0x708d, 0x70a5,
	// Entry 55C0 - 55FF
	0x70bd, 0x70d5, 0x70ed, 0x7105, 0x711d, 0x7136, 0x714e, 0x7166,
	0x717e, 0x7196, 0x71ae, 0x71c6, 0x71df, 0x71f7, 0x720f, 0x7227,
	0x723f, 0x7258, 0x7270, 0x7288, 0x72a0, 0x72b8, 0x72d0, 0x72e8,
	0x7300, 0x7318, 0x7330, 0x7348, 0x7360, 0x7378, 0x7391, 0x73a9,
	0x73c1, 0x73d9, 0x73f1, 0x7409, 0x7421, 0x7439, 0x7451, 0x746a,
	0x7482, 0x749a, 0x74b2, 0x74ca, 0x74e2, 0x74fa, 0x7512, 0x752a,
	0x7542, 0x755a, 0x7573, 0x758b, 0x75a3, 0x75bb, 0x75d3, 0x75eb,
	0x7603, 0x761c, 0x7634, 0x764d, 0x7665, 0x767d, 0x7695, 0x76ad,
	// Entry 5600 - 563F
	0x76c5, 0x76dd, 0x76f5, 0x770e, 0x7726, 0x773f, 0x7757, 0x7770,
	0x7788, 0x77a0, 0x77b8, 0x77d0, 0x77e9, 0x7802, 0x781b, 0x7833,
	0x784b, 0x7863, 0x787b, 0x7893, 0x78ab, 0x78c3, 0x78db, 0x78f4,
	0x790c, 0x7925, 0x793e, 0x7956, 0x796e, 0x7986, 0x799e, 0x79b7,
	0x79cf, 0x79e7, 0x79ff, 0x7a17, 0x7a2f, 0x7a47, 0x7a5f, 0x7a77,
	0x7a8f, 0x7aa8, 0x7ac0, 0x7ad8, 0x7af0, 0x7b08, 0x7b20, 0x7b38,
	0x7b51, 0x7b69, 0x7b81, 0x7b99, 0x7bb1, 0x7bc9, 0x7be1, 0x7bf9,
	0x7c11, 0x7c29, 0x7c41, 0x7c5a, 0x7c72, 0x7c8b, 0x7ca3, 0x7cbb,
	// Entry 5640 - 567F
	0x7cd3, 0x7ceb, 0x7d03, 0x7d1b, 0x7d34, 0x7d4c, 0x7d64, 0x7d7d,
	0x7d95, 0x7dad, 0x7dc5, 0x7ddd, 0x7df5, 0x7e0d, 0x7e25, 0x7e3d,
	0x7e55, 0x7e6d, 0x7e85, 0x7e9d, 0x7eb5, 0x7ecd, 0x7ee5, 0x7efe,
	0x7f16, 0x7f2e, 0x7f46, 0x7f5e, 0x7f76, 0x7f8e, 0x7fa6, 0x7fbf,
	0x7fd7, 0x7fef, 0x8007, 0x801f, 0x8038, 0x8050, 0x8069, 0x8081,
	0x809a, 0x80b2, 0x80ca, 0x80e2, 0x80fa, 0x8112, 0x812a, 0x8142,
	0x815a, 0x8172, 0x818a, 0x81a2, 0x81ba, 0x81d2, 0x81ea, 0x8203,
	0x821b, 0x8233, 0x824b, 0x8263, 0x827c, 0x8294, 0x82ac, 0x82c4,
	// Entry 5680 - 56BF
	0x82dd, 0x82f6, 0x830e, 0x8326, 0x833f, 0x8357, 0x836f, 0x8387,
	0x839f, 0x83b7, 0x83cf, 0x83e7, 0x8400, 0x8418, 0x8430, 0x8449,
	0x8462, 0x847b, 0x8494, 0x84ad, 0x84c6, 0x84df, 0x84f8, 0x8510,
	0x8528, 0x8540, 0x8559, 0x8571, 0x858a, 0x85a2, 0x85bb, 0x85d3,
	0x85eb, 0x8603, 0x861b, 0x8633, 0x864c, 0x8664, 0x867c, 0x8695,
	0x86ad, 0x86c5, 0x86dd, 0x86f5, 0x870e, 0x8726, 0x873e, 0x8756,
	0x876f, 0x8787, 0x879f, 0x87b8, 0x87d1, 0x87e9, 0x8801, 0x8819,
	0x8831, 0x8849, 0x8861, 0x8879, 0x8892, 0x88aa, 0x88c2, 0x88da,
	// Entry 56C0 - 56FF
	0x88f2, 0x890a, 0x8922, 0x893a, 0x8952, 0x896a, 0x8982, 0x899a,
	0x89b2, 0x89ca, 0x89e2, 0x89fa, 0x8a12, 0x8a2a, 0x8a42, 0x8a5a,
	0x8a72, 0x8a8a, 0x8aa2, 0x8abb, 0x8ad4, 0x8aec, 0x8b04, 0x8b1c,
	0x8b34, 0x8b4c, 0x8b64, 0x8b7c, 0x8b95, 0x8bad, 0x8bc5, 0x8bdd,
	0x8bf5, 0x8c0d, 0x8c25, 0x8c3d, 0x8c55, 0x8c6e, 0x8c86, 0x8c9f,
	0x8cb7, 0x8cd0, 0x8ce8, 0x8d00, 0x8d19, 0x8d31, 0x8d49, 0x8d61,
	0x8d79, 0x8d91, 0x8daa, 0x8dc3, 0x8ddc, 0x8df5, 0x8e0e, 0x8e28,
	0x8e41, 0x8e5a, 0x8e73, 0x8e8c, 0x8ea5, 0x8ebe, 0x8ed7, 0x8ef0,
	// Entry 5700 - 573F
	0x8f09, 0x8f22, 0x8f3b, 0x8f54, 0x8f6e, 0x8f87, 0x8fa0, 0x8fb9,
	0x8fd2, 0x8feb, 0x9004, 0x901d, 0x9036, 0x904f, 0x9068, 0x9081,
	0x909a, 0x90b3, 0x90cd, 0x90e6, 0x9100, 0x9119, 0x9132, 0x914b,
	0x9164, 0x917d, 0x9196, 0x91af, 0x91c9, 0x91e2, 0x91fb, 0x9214,
	0x922d, 0x9247, 0x925f, 0x9278, 0x9290, 0x92a8, 0x92c0, 0x92d8,
	0x92f1, 0x9309, 0x9322, 0x933b, 0x9354, 0x936d, 0x9386, 0x939f,
	0x93b7, 0x93cf, 0x93e7, 0x93ff, 0x9418, 0x9431, 0x944a, 0x9462,
	0x947a, 0x9492, 0x94aa, 0x94c2, 0x94da, 0x94f2, 0x950a, 0x9522,
	// Entry 5740 - 577F
	0x953b, 0x9553, 0x956c, 0x9584, 0x959c, 0x95b4, 0x95cc, 0x95e5,
	0x95fd, 0x9616, 0x962e, 0x9646, 0x965e, 0x9676, 0x968f, 0x96a7,
	0x96c0, 0x96d8, 0x96f0, 0x9708, 0x9721, 0x9739, 0x9751, 0x9769,
	0x9782, 0x979b, 0x97b4, 0x97cd, 0x97e5, 0x97fd, 0x9815, 0x982d,
	0x9845, 0x985d, 0x9875, 0x988d, 0x98a5, 0x98bd, 0x98d5, 0x98ed,
	0x9905, 0x991d, 0x9936, 0x994f, 0x9967, 0x997f, 0x9998, 0x99b0,
	0x99c8, 0x99e1, 0x99f9, 0x9a11, 0x9a29, 0x9a41, 0x9a59, 0x9a71,
	0x9a89, 0x9aa1, 0x9ab9, 0x9ad1, 0x9ae9, 0x9b01, 0x9b19, 0x9b31,
	// Entry 5780 - 57BF
	0x9b49, 0x9b61, 0x9b79, 0x9b92, 0x9baa, 0x9bc3, 0x9bdc, 0x9bf4,
	0x9c0c, 0x9c24, 0x9c3c, 0x9c54, 0x9c6c, 0x9c84, 0x9c9d, 0x9cb5,
	0x9ccd, 0x9ce5, 0x9cfd, 0x9d15, 0x9d2d, 0x9d46, 0x9d5e, 0x9d76,
	0x9d8e, 0x9da6, 0x9dbe, 0x9dd6, 0x9dee, 0x9e06, 0x9e1e, 0x9e36,
	0x9e4e, 0x9e66, 0x9e7e, 0x9e96, 0x9eae, 0x9ec7, 0x9edf, 0x9ef7,
	0x9f0f, 0x9f27, 0x9f40, 0x9f58, 0x9f70, 0x9f88, 0x9fa0, 0x9fb8,
	0x9fd0, 0x9fe8, 0xa000, 0xa019, 0xa032, 0xa04a, 0xa062, 0xa07a,
	0xa093, 0xa0ab, 0xa0c3, 0xa0db, 0xa0f3, 0xa10b, 0xa123, 0xa13b,
	// Entry 57C0 - 57FF
	0xa153, 0xa16b, 0xa184, 0xa19d, 0xa1b5, 0xa1cd, 0xa1e5, 0xa1fd,
	0xa215, 0xa22d, 0xa245, 0xa25d, 0xa275, 0xa28e, 0xa2a6, 0xa2be,
	0xa2d6, 0xa2ee, 0xa306, 0xa31e, 0xa336, 0xa34e, 0xa366, 0xa37e,
	0xa396, 0xa3ae, 0xa3c6, 0xa3de, 0xa3f7, 0xa40f, 0xa427, 0xa43f,
	0xa457, 0xa470, 0xa488, 0xa4a1, 0xa4b9, 0xa4d2, 0xa4ea, 0xa502,
	0xa51b, 0xa533, 0xa54b, 0xa563, 0xa57b, 0xa593, 0xa5ac, 0xa5c4,
	0xa5dc, 0xa5f4, 0xa60c, 0xa624, 0xa63c, 0xa654, 0xa66c, 0xa684,
	0xa69c, 0xa6b4, 0xa6cc, 0xa6e4, 0xa6fc, 0xa714, 0xa72c, 0xa745,
	// Entry 5800 - 583F
	0xa75d, 0xa776, 0xa78e, 0xa7a6, 0xa7be, 0xa7d6, 0xa7ee, 0xa806,
	0xa81e, 0xa836, 0xa84e, 0xa867, 0xa880, 0xa898, 0xa8b0, 0xa8c8,
	0xa8e0, 0xa8f8, 0xa910, 0xa928, 0xa940, 0xa958, 0xa970, 0xa988,
	0xa9a0, 0xa9b8, 0xa9d0, 0xa9e8, 0xaa00, 0xaa18, 0xaa31, 0xaa49,
	0xaa61, 0xaa79, 0xaa91, 0xaaa9, 0xaac1, 0xaada, 0xaaf2, 0xab0a,
	0xab22, 0xab3b, 0xab53, 0xab6b, 0xab83, 0xab9b, 0xabb3, 0xabcb,
	0xabe3, 0xabfb, 0xac13, 0xac2b, 0xac43, 0xac5c, 0xac75, 0xac8e,
	0xaca7, 0xacc0, 0xacd9, 0xacf2, 0xad0b, 0xad24, 0xad3c, 0xad55,
	// Entry 5840 - 587F
	0xad6d, 0xad85, 0xad9d, 0xadb5, 0xadcd, 0xade6, 0xadff, 0xae17,
	0xae2f, 0xae47, 0xae5f, 0xae78, 0xae91, 0xaeaa, 0xaec2, 0xaedb,
	0xaef4, 0xaf0c, 0xaf24, 0xaf3c, 0xaf54, 0xaf6c, 0xaf84, 0xaf9c,
	0xafb4, 0xafcd, 0xafe6, 0xafff, 0xb018, 0xb031, 0xb04a, 0xb063,
	0xb07c, 0xb095, 0xb0ae, 0xb0c7, 0xb0e0, 0xb0f8, 0xb110, 0xb128,
	0xb141, 0xb159, 0xb171, 0xb189, 0xb1a1, 0xb1b9, 0xb1d2, 0xb1ea,
	0xb203, 0xb21b, 0xb234, 0xb24c, 0xb265, 0xb27d, 0xb295, 0xb2ae,
	0xb2c6, 0xb2de, 0xb2f6, 0xb30e, 0xb327, 0xb33f, 0xb357, 0xb36f,
	// Entry 5880 - 58BF
	0xb388, 0xb3a0, 0xb3b8, 0xb3d0, 0xb3e9, 0xb401, 0xb419, 0xb431,
	0xb449, 0xb461, 0xb479, 0xb492, 0xb4aa, 0xb4c3, 0xb4db, 0xb4f3,
	0xb50b, 0xb523, 0xb53c, 0xb554, 0xb56c, 0xb584, 0xb59d, 0xb5b5,
	0xb5ce, 0xb5e6, 0xb5fe, 0xb616, 0xb62e, 0xb646, 0xb65e, 0xb677,
	0xb68f, 0xb6a7, 0xb6bf, 0xb6d7, 0xb6ef, 0xb708, 0xb721, 0xb739,
	0xb751, 0xb76a, 0xb782, 0xb79a, 0xb7b3, 0xb7cb, 0xb7e4, 0xb7fc,
	0xb814, 0xb82c, 0xb844, 0xb85c, 0xb874, 0xb88c, 0xb8a4, 0xb8bc,
	0xb8d5, 0xb8ee, 0xb907, 0xb920, 0xb938, 0xb951, 0xb96a, 0xb982,
	// Entry 58C0 - 58FF
	0xb99b, 0xb9b3, 0xb9cc, 0xb9e4, 0xb9fc, 0xba14, 0xba2c, 0xba44,
	0xba5c, 0xba74, 0xba8c, 0xbaa4, 0xbabc, 0xbad5, 0xbaee, 0xbb07,
	0xbb20, 0xbb39, 0xbb52, 0xbb6b, 0xbb84, 0xbb9d, 0xbbb5, 0xbbce,
	0xbbe7, 0xbc00, 0xbc19, 0xbc32, 0xbc4b, 0xbc64, 0xbc7d, 0xbc96,
	0xbcaf, 0xbcc8, 0xbce1, 0xbcfa, 0xbd13, 0xbd2c, 0xbd46, 0xbd60,
	0xbd79, 0xbd92, 0xbdab, 0xbdc4, 0xbddd, 0xbdf6, 0xbe0f, 0xbe28,
	0xbe41, 0xbe5a, 0xbe73, 0xbe8c, 0xbea5, 0xbebe, 0xbed7, 0xbef0,
	0xbf09, 0xbf22, 0xbf3b, 0xbf54, 0xbf6d, 0xbf86, 0xbf9f, 0xbfb8,
	// Entry 5900 - 593F
	0xbfd1, 0xbfea, 0xc003, 0xc01c, 0xc035, 0xc04e, 0xc067, 0xc080,
	0xc099, 0xc0b2, 0xc0cb, 0xc0e5, 0xc0fe, 0xc117, 0xc130, 0xc149,
	0xc162, 0xc17b, 0xc194, 0xc1ad, 0xc1c6, 0xc1df, 0xc1f8, 0xc211,
	0xc22a, 0xc243, 0xc25c, 0xc275, 0xc28f, 0xc2a8, 0xc2c1, 0xc2da,
	0xc2f3, 0xc30c, 0xc325, 0xc33e, 0xc357, 0xc370, 0xc389, 0xc3a2,
	0xc3bb, 0xc3d4, 0xc3ee, 0xc407, 0xc420, 0xc43a, 0xc453, 0xc46c,
	0xc485, 0xc49e, 0xc4b8, 0xc4d1, 0xc4eb, 0xc505, 0xc51e, 0xc537,
	0xc550, 0xc569, 0xc582, 0xc59b, 0xc5b4, 0xc5cd, 0xc5e6, 0xc5ff,
	// Entry 5940 - 597F
	0xc618, 0xc631, 0xc64a, 0xc663, 0xc67c, 0xc695, 0xc6ae, 0xc6c7,
	0xc6e0, 0xc6f9, 0xc713, 0xc72d, 0xc747, 0xc760, 0xc779, 0xc792,
	0xc7ab, 0xc7c4, 0xc7dd, 0xc7f6, 0xc80f, 0xc828, 0xc841, 0xc85a,
	0xc873, 0xc88c, 0xc8a5, 0xc8be, 0xc8d7, 0xc8f0, 0xc909, 0xc922,
	0xc93b, 0xc954, 0xc96d, 0xc986, 0xc99f, 0xc9b8, 0xc9d1, 0xc9ea,
	0xca03, 0xca1c, 0xca35, 0xca4e, 0xca68, 0xca81, 0xca9b, 0xcab4,
	0xcacd, 0xcae7, 0xcb00, 0xcb1a, 0xcb33, 0xcb4d, 0xcb66, 0xcb7f,
	0xcb99, 0xcbb3, 0xcbcd, 0xcbe6, 0xcc00, 0xcc1a, 0xcc33, 0xcc4c,
	// Entry 5980 - 59BF
	0xcc66, 0xcc80, 0xcc9a, 0xccb3, 0xcccc, 0xcce5, 0xccff, 0xcd19,
	0xcd32, 0xcd4b, 0xcd64, 0xcd7d, 0xcd96, 0xcdb0, 0xcdc9, 0xcde2,
	0xcdfb, 0xce14, 0xce2d, 0xce46, 0xce5f, 0xce78, 0xce91, 0xceaa,
	0xcec4, 0xcedd, 0xcef6, 0xcf0f, 0xcf28, 0xcf41, 0xcf5a, 0xcf73,
	0xcf8c, 0xcfa5, 0xcfbe, 0xcfd8, 0xcff1, 0xd00a, 0xd023, 0xd03c,
	0xd055, 0xd06e, 0xd087, 0xd0a0, 0xd0b9, 0xd0d2, 0xd0eb, 0xd104,
	0xd11d, 0xd136, 0xd14f, 0xd168, 0xd181, 0xd19a, 0xd1b3, 0xd1cc,
	0xd1e5, 0xd1fe, 0xd217, 0xd230, 0xd249, 0xd262, 0xd27b, 0xd294,
	// Entry 59C0 - 59FF
	0xd2ad, 0xd2c6, 0xd2df, 0xd2f8, 0xd311, 0xd32a, 0xd343, 0xd35c,
	0xd375, 0xd38e, 0xd3a7, 0xd3c0, 0xd3d9, 0xd3f2, 0xd40b, 0xd424,
	0xd43d, 0xd456, 0xd46f, 0xd488, 0xd4a1, 0xd4ba, 0xd4d3, 0xd4ec,
	0xd505, 0xd51e, 0xd537, 0xd550, 0xd569, 0xd582, 0xd59b, 0xd5b4,
	0xd5cd, 0xd5e6, 0xd5ff, 0xd618, 0xd631, 0xd64a, 0xd663, 0xd67d,
	0xd697, 0xd6b0, 0xd6c9, 0xd6e2, 0xd6fb, 0xd714, 0xd72e, 0xd747,
	0xd760, 0xd77a, 0xd793, 0xd7ac, 0xd7c5, 0xd7de, 0xd7f7, 0xd810,
	0xd82a, 0xd843, 0xd85d, 0xd876, 0xd88f, 0xd8a8, 0xd8c1, 0xd8da,
	// Entry 5A00 - 5A3F
	0xd8f3, 0xd90c, 0xd925, 0xd93e, 0xd957, 0xd970, 0xd98a, 0xd9a3,
	0xd9bc, 0xd9d5, 0xd9ee, 0xda07, 0xda20, 0xda39, 0xda52, 0xda6b,
	0xda84, 0xda9d, 0xdab6, 0xdacf, 0xdae8, 0xdb01, 0xdb1a, 0xdb33,
	0xdb4c, 0xdb65, 0xdb7e, 0xdb97, 0xdbb0, 0xdbc9, 0xdbe2, 0xdbfb,
	0xdc14, 0xdc2d, 0xdc46, 0xdc5f, 0xdc78, 0xdc91, 0xdcaa, 0xdcc3,
	0xdcdc, 0xdcf5, 0xdd0e, 0xdd27, 0xdd40, 0xdd59, 0xdd72, 0xdd8c,
	0xdda5, 0xddbe, 0xddd7, 0xddf0, 0xde09, 0xde22, 0xde3b, 0xde54,
	0xde6d, 0xde86, 0xde9f, 0xdeb8, 0xded1, 0xdeea, 0xdf03, 0xdf1c,
	// Entry 5A40 - 5A7F
	0xdf35, 0xdf4e, 0xdf67, 0xdf80, 0xdf99, 0xdfb2, 0xdfcc, 0xdfe5,
	0xdffe, 0xe017, 0xe030, 0xe049, 0xe063, 0xe07c, 0xe095, 0xe0ae,
	0xe0c7, 0xe0e0, 0xe0fa, 0xe113, 0xe12c, 0xe145, 0xe15e, 0xe177,
	0xe190, 0xe1a9, 0xe1c2, 0xe1db, 0xe1f4, 0xe20e, 0xe227, 0xe240,
	0xe259, 0xe272, 0xe28b, 0xe2a4, 0xe2bd, 0xe2d6, 0xe2ef, 0xe308,
	0xe321, 0xe33a, 0xe353, 0xe36c, 0xe385, 0xe39e, 0xe3b7, 0xe3d0,
	0xe3e9, 0xe402, 0xe41c, 0xe435, 0xe44e, 0xe468, 0xe482, 0xe49c,
	0xe4b5, 0xe4ce, 0xe4e7, 0xe500, 0xe51a, 0xe534, 0xe54e, 0xe567,
	// Entry 5A80 - 5ABF
	0xe580, 0xe599, 0xe5b2, 0xe5cb, 0xe5e4, 0xe5fd, 0xe616, 0xe62f,
	0xe648, 0xe661, 0xe67a, 0xe693, 0xe6ac, 0xe6c5, 0xe6de, 0xe6f7,
	0xe710, 0xe729, 0xe742, 0xe75b, 0xe774, 0xe78d, 0xe7a7, 0xe7c0,
	0xe7d9, 0xe7f2, 0xe80b, 0xe824, 0xe83e, 0xe857, 0xe870, 0xe889,
	0xe8a2, 0xe8bc, 0xe8d5, 0xe8ee, 0xe907, 0xe921, 0xe93a, 0xe953,
	0xe96c, 0xe985, 0xe99e, 0xe9b7, 0xe9d0, 0xe9e9, 0xea02, 0xea1b,
	0xea35, 0xea4e, 0xea70, 0xea8a, 0xeaa3, 0xeabc, 0xead5, 0xeaef,
	0xeb08, 0xeb21, 0xeb3a, 0xeb53, 0xeb6c, 0xeb85, 0xeba4, 0xebbd,
	// Entry 5AC0 - 5AFF
	0xebd6, 0xebef, 0xec08, 0xec21, 0xec3a, 0xec53, 0xec6c, 0xec85,
	0xec9e, 0xecb7, 0xecd0, 0xece9, 0xed02, 0xed1b, 0xed34, 0xed61,
	0xed8d, 0xeda6, 0xedbf, 0xedd8, 0xedf1, 0xee0a, 0xee23, 0xee3c,
	0xee55, 0xee6e, 0xee87, 0xeea0, 0xeeb9, 0xeed2, 0xeeeb, 0xef04,
	0xef1d, 0xef36, 0xef4f, 0xef68, 0xef81, 0xef9a, 0xefb3, 0xefcc,
	0xefe5, 0xeffe, 0xf017, 0xf030, 0xf049, 0xf062, 0xf07b, 0xf094,
	0xf0ad, 0xf0c6, 0xf0df, 0xf0f8, 0xf111, 0xf12a, 0xf143, 0xf15c,
	0xf175, 0xf18f, 0xf1a8, 0xf1c1, 0xf1da, 0xf1f3, 0xf20c, 0xf225,
	// Entry 5B00 - 5B3F
	0xf23e, 0xf258, 0xf271, 0xf28a, 0xf2a3, 0xf2bc, 0xf2d5, 0xf2ee,
	0xf307, 0xf320, 0xf339, 0xf352, 0xf36b, 0xf384, 0xf39d, 0xf3b6,
	0xf3cf, 0xf3e8, 0xf401, 0xf41a, 0xf433, 0xf44c, 0xf465, 0xf47e,
	0xf497, 0xf4b0, 0xf4c9, 0xf4e2, 0xf4fb, 0xf514, 0xf52d, 0xf546,
	0xf55f, 0xf578, 0xf591, 0xf5aa, 0xf5c3, 0xf5dc, 0xf5f5, 0xf60e,
	0xf627, 0xf640, 0xf659, 0xf672, 0xf68b, 0xf6a4, 0xf6bd, 0xf6d6,
	0xf6ef, 0xf708, 0xf721, 0xf73a, 0xf753, 0xf76c, 0xf785, 0xf79e,
	0xf7b7, 0xf7d0, 0xf7e9, 0xf802, 0xf81b, 0xf834, 0xf84d, 0xf866,
	// Entry 5B40 - 5B7F
	0xf87f, 0xf898, 0xf8b1, 0xf8ca, 0xf8e3, 0xf8fc, 0xf915, 0xf92e,
	0xf94d, 0xf96b, 0xf994, 0xf9ba, 0xf9d7, 0xf9f6, 0xfa14, 0xfa31,
	0xfa53, 0xfa7e, 0xfaa6, 0xfac5, 0xfae3, 0xfafe, 0xfb1b, 0xfb37,
	0xfb56, 0xfb72, 0xfb8e, 0xfbad, 0xfbc8, 0xfbe0, 0xfbff, 0xfc19,
	0xfc35, 0xfc53, 0xfc6f, 0xfc8a, 0xfca8, 0xfcc4, 0xfce5, 0xfd03,
	0xfd21, 0xfd42, 0xfd60, 0xfd79, 0xfd94, 0xfdb5, 0xfdd1, 0xfdea,
	0xfe0a, 0xfe2b, 0xfe43, 0xfe60, 0xfe79, 0xfe91, 0xfeab, 0xfec5,
	0xfee0, 0xfefe, 0xff19, 0xff31, 0xff52, 0xff6b, 0xff87, 0xffa0,
	// Entry 5B80 - 5BBF
	0xffbb, 0xffd4, 0xffec, 0x0005, 0x001d, 0x003b, 0x0056, 0x006f,
	0x0092, 0x00b6, 0x00d1, 0x00ed, 0x0109, 0x0123, 0x013d, 0x0156,
	0x0171, 0x018a, 0x01a5, 0x01bd, 0x01d6, 0x01f1, 0x020a, 0x0222,
	0x023a, 0x0253, 0x026b, 0x0282, 0x029a, 0x02b2, 0x02cb, 0x02e6,
	0x0307, 0x0320, 0x033b, 0x0359, 0x0378, 0x0392, 0x03ad, 0x03c9,
	0x03e1, 0x03fc, 0x041e, 0x0441, 0x0462, 0x047f, 0x049f, 0x04b7,
	0x04d4, 0x04f2, 0x0510, 0x0530, 0x0551, 0x056f, 0x058a, 0x05a7,
	0x05c3, 0x05de, 0x05f8, 0x0611, 0x0632, 0x0650, 0x066a, 0x0686,
	// Entry 5BC0 - 5BFF
	0x069f, 0x06b8, 0x06d3, 0x06f4, 0x070f, 0x0727, 0x0742, 0x075f,
	0x077b, 0x0797, 0x07b7, 0x07d0, 0x07ea, 0x0802, 0x081d, 0x083d,
	0x085a, 0x0872, 0x088d, 0x08a6, 0x08bd, 0x08d5, 0x08ee, 0x090f,
	0x0927, 0x093f, 0x095c, 0x0976, 0x0994, 0x09ae, 0x09c9, 0x09e6,
	0x0a00, 0x0a26, 0x0a43, 0x0a5d, 0x0a79, 0x0a94, 0x0aba, 0x0ad9,
	0x0af2, 0x0b0d, 0x0b2b, 0x0b45, 0x0b5e, 0x0b7a, 0x0b93, 0x0bac,
	0x0bc7, 0x0bdf, 0x0bf8, 0x0c12, 0x0c2e, 0x0c48, 0x0c65, 0x0c7f,
	0x0ca0, 0x0cb9, 0x0cd6, 0x0cf5, 0x0d0e, 0x0d29, 0x0d41, 0x0d5e,
	// Entry 5C00 - 5C3F
	0x0d7a, 0x0d97, 0x0db3, 0x0dcd, 0x0de5, 0x0dff, 0x0e17, 0x0e31,
	0x0e4a, 0x0e67, 0x0e82, 0x0e99, 0x0eb3, 0x0ecb, 0x0ee7, 0x0f06,
	0x0f21, 0x0f39, 0x0f52, 0x0f6c, 0x0f87, 0x0f9e, 0x0fb6, 0x0fcf,
	0x0fe8, 0x1000, 0x101c, 0x1035, 0x104e, 0x106f, 0x1088, 0x10a1,
	0x10be, 0x10d6, 0x10ef, 0x1109, 0x1124, 0x113c, 0x1157, 0x1172,
	0x118e, 0x11a8, 0x11c1, 0x11e1, 0x11fb, 0x1215, 0x122e, 0x1247,
	0x1260, 0x127c, 0x129c, 0x12b5, 0x12cd, 0x12e5, 0x12fd, 0x1315,
	0x132d, 0x1346, 0x135e, 0x1376, 0x138f, 0x13a9, 0x13c2, 0x13dc,
	// Entry 5C40 - 5C7F
	0x13f6, 0x1413, 0x142c, 0x1446, 0x1460, 0x1479, 0x1493, 0x14b2,
	0x14cb, 0x14e6, 0x14ff, 0x1517, 0x152f, 0x154b, 0x1564, 0x157c,
	0x1596, 0x15b0, 0x15cc, 0x15e5, 0x1600, 0x1618, 0x1634, 0x1654,
	0x1670, 0x1687, 0x16a0, 0x16bb, 0x16d9, 0x16f2, 0x170e, 0x1729,
	0x1742, 0x175b, 0x1776, 0x178f, 0x17aa, 0x17c2, 0x17da, 0x17f5,
	0x180e, 0x1828, 0x1841, 0x185c, 0x1874, 0x188e, 0x18a7, 0x18c0,
	0x18da, 0x18f7, 0x1912, 0x192d, 0x1946, 0x195e, 0x1979, 0x1992,
	0x19aa, 0x19c5, 0x19df, 0x19fb, 0x1a14, 0x1a2c, 0x1a45, 0x1a5e,
	// Entry 5C80 - 5CBF
	0x1a78, 0x1a91, 0x1aa9, 0x1ac4, 0x1adf, 0x1af8, 0x1b11, 0x1b29,
	0x1b42, 0x1b5b, 0x1b77, 0x1b91, 0x1baa, 0x1bc5, 0x1bdf, 0x1bf9,
	0x1c14, 0x1c2b, 0x1c47, 0x1c5f, 0x1c77, 0x1c8f, 0x1ca7, 0x1cc1,
	0x1cdb, 0x1cf1, 0x1d09, 0x1d20, 0x1d39, 0x1d53, 0x1d6c, 0x1d83,
	0x1d9b, 0x1db4, 0x1dcc, 0x1de3, 0x1dfc, 0x1e14, 0x1e2d, 0x1e45,
	0x1e62, 0x1e79, 0x1e92, 0x1eb1, 0x1ec9, 0x1ee1, 0x1efa, 0x1f13,
	0x1f2d, 0x1f45, 0x1f5d, 0x1f76, 0x1f8e, 0x1fa6, 0x1fbe, 0x1fd9,
	0x1ff2, 0x200b, 0x2023, 0x203c, 0x2056, 0x206e, 0x2086, 0x20a3,
	// Entry 5CC0 - 5CFF
	0x20bc, 0x20d4, 0x20ed, 0x2105, 0x2120, 0x2139, 0x2152, 0x216d,
	0x2186, 0x21a0, 0x21bb, 0x21d5, 0x21ee, 0x2206, 0x2222, 0x223b,
	0x2255, 0x2272, 0x228e, 0x22a6, 0x22bf, 0x22db, 0x22f4, 0x2313,
	0x232b, 0x2343, 0x2365, 0x2389, 0x23a2, 0x23bc, 0x23d5, 0x23ef,
	0x2406, 0x2420, 0x243a, 0x2454, 0x246f, 0x2489, 0x24a2, 0x24bb,
	0x24d2, 0x24eb, 0x2507, 0x2524, 0x2540, 0x255a, 0x2573, 0x258c,
	0x25a5, 0x25be, 0x25d6, 0x25ef, 0x2607, 0x2627, 0x263f, 0x2659,
	0x2673, 0x268d, 0x26a6, 0x26c1, 0x26d9, 0x26f3, 0x270d, 0x2725,
	// Entry 5D00 - 5D3F
	0x273d, 0x2759, 0x2772, 0x2789, 0x27a2, 0x27bb, 0x27d4, 0x27f0,
	0x2810, 0x2829, 0x2842, 0x285b, 0x2874, 0x288c, 0x28a5, 0x28c0,
	0x28d9, 0x28f1, 0x290a, 0x2924, 0x293c, 0x2955, 0x296e, 0x2989,
	0x29a3, 0x29c1, 0x29dd, 0x29f5, 0x2a0e, 0x2a24, 0x2a3c, 0x2a52,
	0x2a68, 0x2a80, 0x2a9e, 0x2ab6, 0x2ace, 0x2af0, 0x2b09, 0x2b22,
	0x2b3c, 0x2b56, 0x2b77, 0x2b95, 0x2bad, 0x2bc5, 0x2bde, 0x2bf7,
	0x2c16, 0x2c2e, 0x2c46, 0x2c5e, 0x2c76, 0x2c8d, 0x2ca4, 0x2cbd,
	0x2cd5, 0x2cf0, 0x2d08, 0x2d20, 0x2d39, 0x2d57, 0x2d6e, 0x2d85,
	// Entry 5D40 - 5D7F
	0x2d9d, 0x2db4, 0x2dcc, 0x2de3, 0x2dfb, 0x2e13, 0x2e2a, 0x2e42,
	0x2e5a, 0x2e72, 0x2e8b, 0x2ea2, 0x2eb8, 0x2ecf, 0x2ee6, 0x2efe,
	0x2f16, 0x2f2e, 0x2f45, 0x2f5d, 0x2f76, 0x2f90, 0x2fa8, 0x2fc1,
	0x2fdb, 0x2ff1, 0x3009, 0x3022, 0x3039, 0x3052, 0x306b, 0x3083,
	0x309c, 0x30b3, 0x30cd, 0x30e5, 0x30fd, 0x3114, 0x312d, 0x3146,
	0x315f, 0x3177, 0x318f, 0x31a6, 0x31bd, 0x31d6, 0x31ee, 0x320a,
	0x3223, 0x323b, 0x3254, 0x326c, 0x3283, 0x329a, 0x32b2, 0x32c9,
	0x32e2, 0x32fa, 0x3311, 0x3328, 0x3341, 0x3359, 0x3371, 0x338b,
	// Entry 5D80 - 5DBF
	0x33a4, 0x33b1, 0x33bf, 0x33cc, 0x33da, 0x33e7, 0x33f4, 0x3400,
	0x340e, 0x341d, 0x342b, 0x3439, 0x3447, 0x3457, 0x3464, 0x3473,
	0x3481, 0x348e, 0x349b, 0x34a7, 0x34b4, 0x34c2, 0x34d1, 0x34de,
	0x34eb, 0x34f7, 0x3504, 0x3512, 0x351f, 0x352d, 0x353a, 0x3548,
	0x3556, 0x3563, 0x3570, 0x357f, 0x358d, 0x359b, 0x35a8, 0x35b7,
	0x35c6, 0x35d4, 0x35dd, 0x35ed, 0x3602, 0x3615, 0x3628, 0x363b,
	0x364f, 0x3663, 0x3677, 0x368c, 0x36a1, 0x36b4, 0x36c9, 0x36dc,
	0x36ef, 0x3703, 0x3716, 0x3729, 0x373d, 0x3750, 0x3763, 0x3776,
	// Entry 5DC0 - 5DFF
	0x378b, 0x379e, 0x37b4, 0x37c6, 0x37d8, 0x37eb, 0x37fd, 0x3810,
	0x3822, 0x3834, 0x3851, 0x386d, 0x3889, 0x38a9, 0x38ca, 0x38dd,
	0x38f4, 0x390b, 0x3921, 0x3937, 0x394e, 0x3965, 0x397b, 0x3991,
	0x39a7, 0x39bd, 0x39d4, 0x39eb, 0x3a02, 0x3a19, 0x3a30, 0x3a47,
	0x3a5e, 0x3a75, 0x3a8b, 0x3aa1, 0x3ab8, 0x3acf, 0x3ae5, 0x3afb,
	0x3b11, 0x3b27, 0x3b3e, 0x3b55, 0x3b6f, 0x3b8b, 0x3ba5, 0x3bbf,
	0x3bda, 0x3bf4, 0x3c0f, 0x3c2a, 0x3c44, 0x3c5f, 0x3c79, 0x3c94,
	0x3cb0, 0x3ccb, 0x3ce7, 0x3d03, 0x3d1d, 0x3d36, 0x3d50, 0x3d6a,
	// Entry 5E00 - 5E3F
	0x3d83, 0x3d9b, 0x3db4, 0x3dce, 0x3de8, 0x3e01, 0x3e1b, 0x3e35,
	0x3e55, 0x3e70, 0x3e8b, 0x3ea5, 0x3ec2, 0x3edd, 0x3ef8, 0x3f14,
	0x3f2e, 0x3f49, 0x3f63, 0x3f7b, 0x3f91, 0x3faf, 0x3fc6, 0x3fdc,
	0x3ff2, 0x400a, 0x4021, 0x4038, 0x404e, 0x4066, 0x407e, 0x4095,
	0x40ad, 0x40c9, 0x40ea, 0x4106, 0x412a, 0x414a, 0x4167, 0x4180,
	0x4196, 0x41ab, 0x41cc, 0x41e6, 0x41fc, 0x4212, 0x4228, 0x423e,
	0x4252, 0x426f, 0x428b, 0x42a0, 0x42b5, 0x42ca, 0x42f2, 0x4313,
	0x432d, 0x434c, 0x436a, 0x4388, 0x43a5, 0x43c0, 0x43da, 0x43f5,
	// Entry 5E40 - 5E7F
	0x4411, 0x442b, 0x4446, 0x4461, 0x447c, 0x4497, 0x44b2, 0x44cd,
	0x44e7, 0x4501, 0x451b, 0x4535, 0x4550, 0x456a, 0x4584, 0x4592,
	0x45a0, 0x45b1, 0x45c0, 0x45ce, 0x45dd, 0x45f3, 0x4601, 0x460f,
	0x461e, 0x462c, 0x463a, 0x464c, 0x465d, 0x466c, 0x467b, 0x4689,
	0x4698, 0x46aa, 0x46c0, 0x46cf, 0x46df, 0x46ed, 0x46fc, 0x470b,
	0x471b, 0x472b, 0x473b, 0x474c, 0x475d, 0x476b, 0x4779, 0x478a,
	0x4798, 0x47a7, 0x47b6, 0x47c6, 0x47dd, 0x47eb, 0x47f9, 0x4808,
	0x4818, 0x4828, 0x4838, 0x4847, 0x4857, 0x4867, 0x4877, 0x488a,
	// Entry 5E80 - 5EBF
	0x489d, 0x48b6, 0x48c5, 0x48d4, 0x48e3, 0x48f3, 0x4902, 0x4911,
	0x4923, 0x4931, 0x493f, 0x494e, 0x495d, 0x496d, 0x4984, 0x4994,
	0x49a5, 0x49b3, 0x49c1, 0x49d0, 0x49e8, 0x49fc, 0x4a16, 0x4a33,
	0x4a44, 0x4a56, 0x4a69, 0x4a7b, 0x4a8e, 0x4a9f, 0x4ab1, 0x4ac3,
	0x4ad4, 0x4ae5, 0x4af7, 0x4b0a, 0x4b1d, 0x4b2e, 0x4b40, 0x4b53,
	0x4b67, 0x4b79, 0x4b8b, 0x4b9d, 0x4baf, 0x4bc2, 0x4bd3, 0x4be5,
	0x4bf8, 0x4c0c, 0x4c1e, 0x4c31, 0x4c44, 0x4c55, 0x4c67, 0x4c79,
	0x4c8c, 0x4c9f, 0x4cba, 0x4ccc, 0x4ce6, 0x4cf8, 0x4d0a, 0x4d1c,
	// Entry 5EC0 - 5EFF
	0x4d2e, 0x4d3f, 0x4d51, 0x4d60, 0x4d73, 0x4d82, 0x4d91, 0x4da3,
	0x4db5, 0x4dc7, 0x4dd9, 0x4deb, 0x4dfd, 0x4e0f, 0x4e2a, 0x4e45,
	0x4e60, 0x4e7b, 0x4e96, 0x4eb1, 0x4ec6, 0x4eda, 0x4eee, 0x4f02,
	0x4f16, 0x4f2a, 0x4f3e, 0x4f52, 0x4f66, 0x4f7a, 0x4f8e, 0x4fa2,
	0x4fb6, 0x4fca, 0x4fde, 0x4ff2, 0x5006, 0x501a, 0x502e, 0x5042,
	0x5056, 0x506a, 0x507e, 0x5092, 0x50a6, 0x50ba, 0x50ce, 0x50e2,
	0x50f6, 0x510a, 0x511e, 0x5132, 0x5146, 0x515a, 0x516e, 0x5182,
	0x5196, 0x51aa, 0x51be, 0x51d2, 0x51e6, 0x51fa, 0x520e, 0x5222,
	// Entry 5F00 - 5F3F
	0x5236, 0x524a, 0x525e, 0x5272, 0x5286, 0x529a, 0x52ae, 0x52c2,
	0x52d6, 0x52ea, 0x52fe, 0x5312, 0x5326, 0x533a, 0x534e, 0x5362,
	0x5376, 0x538a, 0x539e, 0x53b2, 0x53c6, 0x53da, 0x53ee, 0x5402,
	0x5416, 0x542a, 0x543e, 0x5452, 0x5466, 0x547a, 0x548e, 0x54a2,
	0x54b6, 0x54ca, 0x54de, 0x54f2, 0x5506, 0x551a, 0x552e, 0x5542,
	0x5556, 0x556a, 0x557e, 0x5592, 0x55a6, 0x55ba, 0x55ce, 0x55e2,
	0x55f6, 0x560a, 0x561e, 0x5632, 0x5646, 0x565a, 0x566e, 0x5682,
	0x5696, 0x56aa, 0x56be, 0x56d2, 0x56e6, 0x56fa, 0x570e, 0x5722,
	// Entry 5F40 - 5F7F
	0x5736, 0x574a, 0x575e, 0x5772, 0x5786, 0x579a, 0x57ae, 0x57c2,
	0x57d6, 0x57ea, 0x57fe, 0x5812, 0x5826, 0x583a, 0x584e, 0x5862,
	0x5876, 0x588a, 0x589e, 0x58b2, 0x58c6, 0x58da, 0x58ee, 0x5902,
	0x5916, 0x592a, 0x593e, 0x5952, 0x5966, 0x597a, 0x598e, 0x59a2,
	0x59b6, 0x59ca, 0x59de, 0x59f2, 0x5a06, 0x5a1a, 0x5a2e, 0x5a42,
	0x5a56, 0x5a6a, 0x5a7e, 0x5a92, 0x5aa6, 0x5aba, 0x5ace, 0x5ae2,
	0x5af6, 0x5b0a, 0x5b1e, 0x5b32, 0x5b46, 0x5b5a, 0x5b6e, 0x5b82,
	0x5b96, 0x5baa, 0x5bbe, 0x5bd2, 0x5be6, 0x5bfa, 0x5c0e, 0x5c22,
	// Entry 5F80 - 5FBF
	0x5c36, 0x5c4a, 0x5c5e, 0x5c72, 0x5c86, 0x5c9a, 0x5cae, 0x5cc2,
	0x5cd6, 0x5cea, 0x5cfe, 0x5d12, 0x5d26, 0x5d3a, 0x5d4e, 0x5d62,
	0x5d76, 0x5d8a, 0x5d9e, 0x5db2, 0x5dc6, 0x5dda, 0x5dee, 0x5e02,
	0x5e16, 0x5e2a, 0x5e3e, 0x5e52, 0x5e66, 0x5e7a, 0x5e8e, 0x5ea2,
	0x5eb6, 0x5eca, 0x5ede, 0x5ef2, 0x5f06, 0x5f1a, 0x5f2e, 0x5f42,
	0x5f56, 0x5f6a, 0x5f7e, 0x5f92, 0x5fa6, 0x5fba, 0x5fce, 0x5fe2,
	0x5ff6, 0x600a, 0x601e, 0x6032, 0x6046, 0x605a, 0x606e, 0x6082,
	0x6096, 0x60aa, 0x60be, 0x60d2, 0x60e6, 0x60fa, 0x610e, 0x6122,
	// Entry 5FC0 - 5FFF
	0x6136, 0x614a, 0x615e, 0x6172, 0x6186, 0x619a, 0x61ae, 0x61c2,
	0x61d6, 0x61ea, 0x61fe, 0x6212, 0x6226, 0x623a, 0x624e, 0x6262,
	0x6276, 0x628a, 0x629e, 0x62b2, 0x62c6, 0x62da, 0x62ee, 0x6302,
	0x6316, 0x632a, 0x633e, 0x6352, 0x6366, 0x637a, 0x638e, 0x63a2,
	0x63b6, 0x63ca, 0x63de, 0x63f2, 0x6406, 0x641a, 0x642e, 0x6442,
	0x6456, 0x646a, 0x647e, 0x6492, 0x64a6, 0x64ba, 0x64ce, 0x64e2,
	0x64f6, 0x650a, 0x651e, 0x6532, 0x6546, 0x655a, 0x656e, 0x6582,
	0x6596, 0x65aa, 0x65be, 0x65d2, 0x65e6, 0x65fa, 0x660e, 0x6622,
	// Entry 6000 - 603F
	0x6636, 0x664a, 0x665e, 0x6672, 0x6686, 0x669a, 0x66ae, 0x66c2,
	0x66d6, 0x66ea, 0x66fe, 0x6712, 0x6726, 0x673a, 0x674e, 0x6762,
	0x6776, 0x678a, 0x679e, 0x67b2, 0x67c6, 0x67da, 0x67ee, 0x6802,
	0x6816, 0x682a, 0x683e, 0x6852, 0x6866, 0x687a, 0x688e, 0x68a2,
	0x68b6, 0x68ca, 0x68de, 0x68f2, 0x6906, 0x691a, 0x692e, 0x6942,
	0x6956, 0x696a, 0x697e, 0x6992, 0x69a6, 0x69ba, 0x69ce, 0x69e2,
	0x69f6, 0x6a0a, 0x6a1e, 0x6a32, 0x6a46, 0x6a5a, 0x6a6e, 0x6a82,
	0x6a96, 0x6aaa, 0x6abe, 0x6ad2, 0x6ae6, 0x6afa, 0x6b0e, 0x6b22,
	// Entry 6040 - 607F
	0x6b36, 0x6b4a, 0x6b5e, 0x6b72, 0x6b86, 0x6b9a, 0x6bae, 0x6bc2,
	0x6bd6, 0x6bea, 0x6bfe, 0x6c12, 0x6c26, 0x6c3a, 0x6c4e, 0x6c62,
	0x6c76, 0x6c8a, 0x6c9e, 0x6cb2, 0x6cc6, 0x6cda, 0x6cee, 0x6d02,
	0x6d16, 0x6d2a, 0x6d3e, 0x6d52, 0x6d66, 0x6d7a, 0x6d8e, 0x6da2,
	0x6db6, 0x6dca, 0x6dde, 0x6df2, 0x6e06, 0x6e1a, 0x6e2e, 0x6e42,
	0x6e56, 0x6e6a, 0x6e7e, 0x6e92, 0x6ea6, 0x6eba, 0x6ece, 0x6ee2,
	0x6ef6, 0x6f0a, 0x6f1e, 0x6f32, 0x6f46, 0x6f5a, 0x6f6e, 0x6f82,
	0x6f96, 0x6faa, 0x6fbe, 0x6fd2, 0x6fe6, 0x6ffa, 0x700e, 0x7022,
	// Entry 6080 - 60BF
	0x7036, 0x704a, 0x705e, 0x7072, 0x7086, 0x709a, 0x70ae, 0x70c2,
	0x70d6, 0x70ea, 0x70fe, 0x7112, 0x7126, 0x713a, 0x714e, 0x7162,
	0x7176, 0x718a, 0x719e, 0x71b2, 0x71c6, 0x71da, 0x71ee, 0x7202,
	0x7216, 0x722a, 0x723e, 0x7252, 0x7266, 0x727a, 0x728e, 0x72a2,
	0x72b6, 0x72ca, 0x72de, 0x72f2, 0x7306, 0x731a, 0x732e, 0x7342,
	0x7356, 0x736a, 0x737e, 0x7392, 0x73a6, 0x73ba, 0x73ce, 0x73e2,
	0x73f6, 0x740a, 0x741e, 0x7432, 0x7446, 0x745a, 0x746e, 0x7482,
	0x7496, 0x74aa, 0x74be, 0x74d2, 0x74e6, 0x74fa, 0x750e, 0x7522,
	// Entry 60C0 - 60FF
	0x7536, 0x754a, 0x755e, 0x7572, 0x7586, 0x759a, 0x75ae, 0x75c2,
	0x75d6, 0x75ea, 0x75fe, 0x7612, 0x7626, 0x763a, 0x764e, 0x7662,
	0x7676, 0x768a, 0x769e, 0x76b2, 0x76c6, 0x76da, 0x76ee, 0x7702,
	0x7716, 0x772a, 0x773e, 0x7752, 0x7766, 0x777a, 0x778e, 0x77a2,
	0x77b6, 0x77ca, 0x77de, 0x77f2, 0x7806, 0x781a, 0x782e, 0x7842,
	0x7856, 0x786a, 0x787e, 0x7892, 0x78a6, 0x78ba, 0x78ce, 0x78e2,
	0x78f6, 0x790a, 0x791e, 0x7932, 0x7946, 0x795a, 0x796e, 0x7982,
	0x7996, 0x79aa, 0x79be, 0x79d2, 0x79e6, 0x79fa, 0x7a0e, 0x7a22,
	// Entry 6100 - 613F
	0x7a36, 0x7a4a, 0x7a5e, 0x7a72, 0x7a86, 0x7a9a, 0x7aae, 0x7ac2,
	0x7ad6, 0x7aea, 0x7afe, 0x7b12, 0x7b26, 0x7b3a, 0x7b4e, 0x7b62,
	0x7b76, 0x7b8a, 0x7b9e, 0x7bb2, 0x7bc6, 0x7bda, 0x7bee, 0x7c02,
	0x7c16, 0x7c2a, 0x7c3e, 0x7c52, 0x7c66, 0x7c7a, 0x7c8e, 0x7ca2,
	0x7cb6, 0x7cca, 0x7cde, 0x7cf2, 0x7d06, 0x7d1a, 0x7d2e, 0x7d42,
	0x7d56, 0x7d6a, 0x7d7e, 0x7d92, 0x7da6, 0x7dba, 0x7dce, 0x7de2,
	0x7df6, 0x7e0a, 0x7e1e, 0x7e32, 0x7e46, 0x7e5a, 0x7e6e, 0x7e82,
	0x7e96, 0x7eaa, 0x7ebe, 0x7ed2, 0x7ee6, 0x7efa, 0x7f0e, 0x7f22,
	// Entry 6140 - 617F
	0x7f36, 0x7f4a, 0x7f5e, 0x7f72, 0x7f86, 0x7f9a, 0x7fae, 0x7fc2,
	0x7fd6, 0x7fea, 0x7ffe, 0x8012, 0x8026, 0x803a, 0x804e, 0x8062,
	0x8076, 0x808a, 0x809e, 0x80b2, 0x80c6, 0x80da, 0x80ee, 0x8102,
	0x8116, 0x812a, 0x813e, 0x8152, 0x8166, 0x817a, 0x818e, 0x81a2,
	0x81b6, 0x81ca, 0x81de, 0x81f2, 0x8206, 0x821a, 0x822e, 0x8242,
	0x8256, 0x826a, 0x827e, 0x8292, 0x82a6, 0x82ba, 0x82ce, 0x82e2,
	0x82f6, 0x830a, 0x831e, 0x8332, 0x8346, 0x835a, 0x836e, 0x8382,
	0x8396, 0x83aa, 0x83be, 0x83d2, 0x83e6, 0x83fa, 0x840e, 0x8422,
	// Entry 6180 - 61BF
	0x8436, 0x844a, 0x845e, 0x8472, 0x8486, 0x849a, 0x84ae, 0x84c2,
	0x84d6, 0x84ea, 0x84fe, 0x8512, 0x8526, 0x853a, 0x854e, 0x8562,
	0x8576, 0x858a, 0x859e, 0x85b2, 0x85c6, 0x85da, 0x85ee, 0x8602,
	0x8616, 0x862a, 0x863e, 0x8652, 0x8666, 0x867a, 0x868e, 0x86a2,
	0x86b6, 0x86ca, 0x86de, 0x86f2, 0x8706, 0x871a, 0x872e, 0x8742,
	0x8756, 0x876a, 0x877e, 0x8792, 0x87a6, 0x87ba, 0x87ce, 0x87e2,
	0x87f6, 0x880a, 0x881e, 0x8832, 0x8846, 0x885a, 0x886e, 0x8882,
	0x8896, 0x88aa, 0x88be, 0x88d2, 0x88e6, 0x88fa, 0x890e, 0x8922,
	// Entry 61C0 - 61FF
	0x8936, 0x894a, 0x895e, 0x8972, 0x8986, 0x899a, 0x89ae, 0x89c2,
	0x89d6, 0x89ef, 0x8a09, 0x8a1e, 0x8a33, 0x8a48, 0x8a5e, 0x8a73,
	0x8a88, 0x8a9d, 0x8ab2, 0x8ac7, 0x8adc, 0x8af1, 0x8b06, 0x8b1b,
	0x8b30, 0x8b45, 0x8b5a, 0x8b6f, 0x8b84, 0x8b99, 0x8bae, 0x8bc3,
	0x8bd9, 0x8bef, 0x8c05, 0x8c1b, 0x8c31, 0x8c47, 0x8c5d, 0x8c73,
	0x8c89, 0x8ca0, 0x8cb7, 0x8cce, 0x8ce4, 0x8cfa, 0x8d10, 0x8d26,
	0x8d3c, 0x8d52, 0x8d68, 0x8d7e, 0x8d94, 0x8daa, 0x8dc0, 0x8dd6,
	0x8dec, 0x8e02, 0x8e18, 0x8e2e, 0x8e44, 0x8e5a, 0x8e70, 0x8e86,
	// Entry 6200 - 623F
	0x8e9c, 0x8eb2, 0x8ec8, 0x8ede, 0x8ef5, 0x8f0b, 0x8f21, 0x8f37,
	0x8f4d, 0x8f63, 0x8f79, 0x8f8f, 0x8fa5, 0x8fbb, 0x8fd1, 0x8fe7,
	0x8ffd, 0x9013, 0x9029, 0x903f, 0x9055, 0x906b, 0x9081, 0x9097,
	0x90ad, 0x90c3, 0x90d9, 0x90ef, 0x9105, 0x911b, 0x9131, 0x9147,
	0x915d, 0x9173, 0x9189, 0x919f, 0x91b5, 0x91cb, 0x91e1, 0x91f7,
	0x920d, 0x9223, 0x9239, 0x924f, 0x9265, 0x927b, 0x9291, 0x92a7,
	0x92bd, 0x92d3, 0x92e9, 0x92ff, 0x9315, 0x932b, 0x9342, 0x9358,
	0x936e, 0x9384, 0x939a, 0x93b0, 0x93c6, 0x93dc, 0x93f2, 0x9408,
	// Entry 6240 - 627F
	0x941e, 0x9434, 0x944a, 0x9460, 0x9476, 0x948c, 0x94a3, 0x94b9,
	0x94cf, 0x94e5, 0x94fb, 0x9511, 0x9527, 0x953d, 0x9553, 0x9569,
	0x957f, 0x9595, 0x95ab, 0x95c1, 0x95d7, 0x95ed, 0x9603, 0x961a,
	0x9630, 0x9646, 0x965c, 0x9672, 0x9688, 0x969e, 0x96b4, 0x96ca,
	0x96e0, 0x96f7, 0x970d, 0x9723, 0x9739, 0x974f, 0x9765, 0x977b,
	0x9791, 0x97a7, 0x97bd, 0x97d3, 0x97e9, 0x97ff, 0x9815, 0x982b,
	0x9842, 0x9859, 0x986f, 0x9885, 0x989b, 0x98b1, 0x98c7, 0x98dd,
	0x98f3, 0x9909, 0x991f, 0x9935, 0x994b, 0x9961, 0x9977, 0x998d,
	// Entry 6280 - 62BF
	0x99a3, 0x99b9, 0x99cf, 0x99e5, 0x99fb, 0x9a11, 0x9a27, 0x9a3d,
	0x9a53, 0x9a69, 0x9a7f, 0x9a95, 0x9aab, 0x9ac1, 0x9ad7, 0x9aed,
	0x9b03, 0x9b19, 0x9b2f, 0x9b45, 0x9b5b, 0x9b71, 0x9b87, 0x9b9d,
	0x9bb3, 0x9bc9, 0x9bdf, 0x9bf5, 0x9c0b, 0x9c21, 0x9c37, 0x9c4e,
	0x9c64, 0x9c7a, 0x9c90, 0x9ca6, 0x9cbc, 0x9cd2, 0x9ce8, 0x9cfe,
	0x9d14, 0x9d2a, 0x9d40, 0x9d57, 0x9d6d, 0x9d83, 0x9d99, 0x9daf,
	0x9dc5, 0x9ddb, 0x9df1, 0x9e07, 0x9e1d, 0x9e33, 0x9e49, 0x9e5f,
	0x9e75, 0x9e8b, 0x9ea1, 0x9eb7, 0x9ecd, 0x9ee3, 0x9ef9, 0x9f0f,
	// Entry 62C0 - 62FF
	0x9f25, 0x9f3b, 0x9f51, 0x9f67, 0x9f7d, 0x9f93, 0x9fa9, 0x9fbf,
	0x9fd5, 0x9feb, 0xa001, 0xa017, 0xa02d, 0xa043, 0xa059, 0xa06f,
	0xa085, 0xa09b, 0xa0b1, 0xa0c7, 0xa0dd, 0xa0f3, 0xa109, 0xa11f,
	0xa135, 0xa14b, 0xa161, 0xa177, 0xa18d, 0xa1a3, 0xa1b9, 0xa1cf,
	0xa1e5, 0xa1fb, 0xa211, 0xa227, 0xa23d, 0xa253, 0xa26e, 0xa289,
	0xa29e, 0xa2b3, 0xa2c8, 0xa2dd, 0xa2f2, 0xa307, 0xa31c, 0xa331,
	0xa346, 0xa35b, 0xa370, 0xa385, 0xa39a, 0xa3af, 0xa3c4, 0xa3d9,
	0xa3ee, 0xa403, 0xa418, 0xa42d, 0xa442, 0xa457, 0xa46c, 0xa481,
	// Entry 6300 - 633F
	0xa496, 0xa4ab, 0xa4c0, 0xa4d5, 0xa4ea, 0xa4ff, 0xa514, 0xa529,
	0xa53e, 0xa553, 0xa568, 0xa57d, 0xa592, 0xa5a7, 0xa5bc, 0xa5d1,
	0xa5e6, 0xa5fb, 0xa610, 0xa625, 0xa63a, 0xa64f, 0xa664, 0xa679,
	0xa68e, 0xa6a3, 0xa6b8, 0xa6cd, 0xa6e2, 0xa6f7, 0xa70c, 0xa721,
	0xa736, 0xa74b, 0xa760, 0xa775, 0xa78a, 0xa79f, 0xa7b4, 0xa7c9,
	0xa7de, 0xa7f3, 0xa808, 0xa81d, 0xa832, 0xa847, 0xa85c, 0xa871,
	0xa886, 0xa89b, 0xa8b0, 0xa8c5, 0xa8da, 0xa8ef, 0xa904, 0xa919,
	0xa92e, 0xa943, 0xa958, 0xa96d, 0xa982, 0xa997, 0xa9ac, 0xa9c1,
	// Entry 6340 - 637F
	0xa9d6, 0xa9eb, 0xaa00, 0xaa15, 0xaa2a, 0xaa3f, 0xaa54, 0xaa69,
	0xaa7e, 0xaa93, 0xaaa8, 0xaabd, 0xaad2, 0xaae7, 0xaafc, 0xab11,
	0xab26, 0xab3b, 0xab50, 0xab65, 0xab7a, 0xab8f, 0xaba4, 0xabb9,
	0xabce, 0xabe3, 0xabf8, 0xac0d, 0xac22, 0xac37, 0xac4c, 0xac61,
	0xac76, 0xac8b, 0xaca0, 0xacb5, 0xacca, 0xacdf, 0xacf4, 0xad09,
	0xad1e, 0xad33, 0xad48, 0xad5d, 0xad72, 0xad87, 0xad9c, 0xadb1,
	0xadc6, 0xaddb, 0xadf0, 0xae05, 0xae1a, 0xae2f, 0xae44, 0xae59,
	0xae6e, 0xae83, 0xae98, 0xaead, 0xaec2, 0xaed7, 0xaeec, 0xaf01,
	// Entry 6380 - 63BF
	0xaf16, 0xaf2b, 0xaf40, 0xaf55, 0xaf6a, 0xaf7f, 0xaf94, 0xafa9,
	0xafbe, 0xafd3, 0xafe8, 0xaffd, 0xb012, 0xb027, 0xb03c, 0xb051,
	0xb066, 0xb07b, 0xb090, 0xb0a5, 0xb0ba, 0xb0cf, 0xb0e4, 0xb0f9,
	0xb10e, 0xb123, 0xb138, 0xb14d, 0xb162, 0xb177, 0xb18c, 0xb1a1,
	0xb1b6, 0xb1cb, 0xb1e0, 0xb1f5, 0xb20a, 0xb21f, 0xb234, 0xb249,
	0xb25e, 0xb273, 0xb288, 0xb29d, 0xb2b2, 0xb2c7, 0xb2dc, 0xb2f1,
	0xb306, 0xb31b, 0xb330, 0xb345, 0xb35a, 0xb36f, 0xb384, 0xb399,
	0xb3ae, 0xb3c3, 0xb3d8, 0xb3ed, 0xb402, 0xb417, 0xb42c, 0xb441,
	// Entry 63C0 - 63FF
	0xb456, 0xb46b, 0xb480, 0xb495, 0xb4aa, 0xb4bf, 0xb4d4, 0xb4e9,
	0xb4fe, 0xb513, 0xb528, 0xb53d, 0xb552, 0xb567, 0xb57c, 0xb591,
	0xb5a6, 0xb5bb, 0xb5d0, 0xb5e5, 0xb5fa, 0xb60f, 0xb624, 0xb639,
	0xb64e, 0xb663, 0xb678, 0xb68d, 0xb6a2, 0xb6b7, 0xb6cc, 0xb6e1,
	0xb6f6, 0xb70b, 0xb720, 0xb735, 0xb74a, 0xb75f, 0xb774, 0xb789,
	0xb79e, 0xb7b3, 0xb7c8, 0xb7dd, 0xb7f2, 0xb807, 0xb81c, 0xb831,
	0xb846, 0xb85b, 0xb870, 0xb885, 0xb89a, 0xb8af, 0xb8c4, 0xb8d9,
	0xb8ee, 0xb903, 0xb918, 0xb92d, 0xb942, 0xb957, 0xb96c, 0xb981,
	// Entry 6400 - 643F
	0xb996, 0xb9ab, 0xb9c0, 0xb9d5, 0xb9ea, 0xb9ff, 0xba14, 0xba29,
	0xba3e, 0xba53, 0xba68, 0xba7d, 0xba92, 0xbaa7, 0xbabc, 0xbad1,
	0xbae6, 0xbafb, 0xbb10, 0xbb25, 0xbb3a, 0xbb4f, 0xbb64, 0xbb79,
	0xbb8e, 0xbba3, 0xbbb8, 0xbbcd, 0xbbe2, 0xbbf7, 0xbc0c, 0xbc21,
	0xbc36, 0xbc4b, 0xbc60, 0xbc75, 0xbc8a, 0xbc9f, 0xbcb4, 0xbcc9,
	0xbcde, 0xbcf3, 0xbd08, 0xbd1d, 0xbd32, 0xbd47, 0xbd5c, 0xbd71,
	0xbd86, 0xbd9b, 0xbdb0, 0xbdc5, 0xbdda, 0xbdef, 0xbe04, 0xbe19,
	0xbe2e, 0xbe43, 0xbe58, 0xbe6d, 0xbe82, 0xbe97, 0xbeac, 0xbec1,
	// Entry 6440 - 647F
	0xbed6, 0xbeeb, 0xbf00, 0xbf15, 0xbf2a, 0xbf3f, 0xbf54, 0xbf69,
	0xbf7e, 0xbf93, 0xbfa8, 0xbfbd, 0xbfd2, 0xbfe7, 0xbffc, 0xc011,
	0xc026, 0xc03b, 0xc050, 0xc065, 0xc07a, 0xc08f, 0xc0a4, 0xc0b9,
	0xc0ce, 0xc0e3, 0xc0f8, 0xc10d, 0xc122, 0xc137, 0xc14c, 0xc161,
	0xc176, 0xc18b, 0xc1a0, 0xc1b5, 0xc1ca, 0xc1df, 0xc1f4, 0xc209,
	0xc21e, 0xc233, 0xc248, 0xc25d, 0xc272, 0xc287, 0xc29c, 0xc2b1,
	0xc2c6, 0xc2db, 0xc2f0, 0xc305, 0xc316, 0xc327, 0xc338, 0xc349,
	0xc35a, 0xc36b, 0xc37c, 0xc38d, 0xc39e, 0xc3af, 0xc3c0, 0xc3d1,
	// Entry 6480 - 64BF
	0xc3e4, 0xc3f7, 0xc40a, 0xc41d, 0xc430, 0xc442, 0xc45a, 0xc46c,
	0xc47e, 0xc495, 0xc4a7, 0xc4b9, 0xc4cb, 0xc4dc, 0xc4ed, 0xc4fe,
	0xc50f, 0xc522, 0xc535, 0xc548, 0xc55b, 0xc575, 0xc58f, 0xc5a9,
	0xc5d5, 0xc5ef, 0xc60f, 0xc622, 0xc635, 0xc648, 0xc65b, 0xc670,
	0xc685, 0xc69a, 0xc6af, 0xc6cb, 0xc6de, 0xc6f3, 0xc706, 0xc71b,
	0xc72e, 0xc743, 0xc756, 0xc76b, 0xc77c, 0xc78e, 0xc7a1, 0xc7b4,
	0xc7c7, 0xc7dc, 0xc7f1, 0xc804, 0xc819, 0xc82a, 0xc842, 0xc854,
	0xc865, 0xc878, 0xc889, 0xc89a, 0xc8ac, 0xc8c3, 0xc8d5, 0xc8e7,
	// Entry 64C0 - 64FF
	0xc8ff, 0xc919, 0xc931, 0xc947, 0xc959, 0xc96a, 0xc97c, 0xc98e,
	0xc9a1, 0xc9b7, 0xc9d1, 0xc9e3, 0xc9fa, 0xca0d, 0xca1f, 0xca31,
	0xca43, 0xca55, 0xca67, 0xca7a, 0xca8d, 0xcaa4, 0xcabb, 0xcad2,
	0xcae9, 0xcb02, 0xcb1b, 0xcb33, 0xcb4b, 0xcb63, 0xcb7c, 0xcba1,
	0xcbc5, 0xcbeb, 0xcc0d, 0xcc2f, 0xcc52, 0xcc70, 0xcc9c, 0xccbb,
	0xccd7, 0xccf5, 0xcd13, 0xcd37, 0xcd50, 0xcd6f, 0xcd88, 0xcda6,
	0xcdbd, 0xcdd7, 0xcdef, 0xce07, 0xce23, 0xce3b, 0xce59, 0xce71,
	0xce8e, 0xcea4, 0xcebd, 0xced4, 0xceeb, 0xcf06, 0xcf1e, 0xcf38,
	// Entry 6500 - 653F
	0xcf56, 0xcf6a, 0xcf90, 0xcfaf, 0xcfd2, 0xcfec, 0xd004, 0xd022,
	0xd041, 0xd065, 0xd08f, 0xd0b3, 0xd0de, 0xd103, 0xd124, 0xd146,
	0xd16a, 0xd18c, 0xd1b4, 0xd1d5, 0xd1ff, 0xd227, 0xd246, 0xd268,
	0xd28b, 0xd2b4, 0xd2d4, 0xd2f2, 0xd31a, 0xd342, 0xd361, 0xd382,
	0xd3a0, 0xd3c6, 0xd3ef, 0xd41a, 0xd43b, 0xd45c, 0xd485, 0xd4ad,
	0xd4d6, 0xd500, 0xd521, 0xd540, 0xd55e, 0xd586, 0xd5a6, 0xd5cb,
	0xd5ea, 0xd613, 0xd640, 0xd66b, 0xd689, 0xd6a7, 0xd6c3, 0xd6e0,
	0xd700, 0xd722, 0xd748, 0xd770, 0xd792, 0xd7bc, 0xd7e4, 0xd805,
	// Entry 6540 - 657F
	0xd827, 0xd848, 0xd872, 0xd892, 0xd8bf, 0xd8ec, 0xd90c, 0xd929,
	0xd949, 0xd96f, 0xd995, 0xd9ba, 0xd9df, 0xda00, 0xda23, 0xda45,
	0xda65, 0xda86, 0xdaae, 0xdad6, 0xdafb, 0xdb25, 0xdb4d, 0xdb6c,
	0xdb93, 0xdbc4, 0xdbe4, 0xdc0c, 0xdc2c, 0xdc4c, 0xdc70, 0xdc93,
	0xdcb6, 0xdcdc, 0xdcfb, 0xdd1e, 0xdd3e, 0xdd66, 0xdd8e, 0xddb9,
	0xddd9, 0xde01, 0xde26, 0xde49, 0xde6d, 0xde8b, 0xdeb0, 0xded1,
	0xdef4, 0xdf19, 0xdf42, 0xdf6a, 0xdf91, 0xdfbc, 0xdfe8, 0xe00f,
	0xe037, 0xe05e, 0xe084, 0xe0b1, 0xe0d7, 0xe0ff, 0xe127, 0xe14c,
	// Entry 6580 - 65BF
	0xe175, 0xe197, 0xe1b9, 0xe1db, 0xe1fc, 0xe21c, 0xe23f, 0xe266,
	0xe28f, 0xe2b4, 0xe2d8, 0xe2fd, 0xe31a, 0xe338, 0xe357, 0xe378,
	0xe398, 0xe3c4, 0xe3ef, 0xe41c, 0xe44c, 0xe47b, 0xe4a2, 0xe4d8,
	0xe50b, 0xe52c, 0xe569, 0xe5a5, 0xe5da, 0xe5fc, 0xe61a, 0xe63d,
	0xe65d, 0xe685, 0xe6ac, 0xe6cf, 0xe6f4, 0xe717, 0xe73b, 0xe763,
	0xe78c, 0xe7ba, 0xe7ed, 0xe81d, 0xe852, 0xe880, 0xe8ab, 0xe8db,
	0xe913, 0xe942, 0xe971, 0xe9a1, 0xe9d5, 0xea03, 0xea30, 0xea5b,
	0xea88, 0xeaba, 0xeaf2, 0xeb1e, 0xeb4b, 0xeb7a, 0xeb9b, 0xebbe,
	// Entry 65C0 - 65FF
	0xebf5, 0xec21, 0xec4f, 0xec79, 0xeca5, 0xecd8, 0xed04, 0xed30,
	0xed61, 0xed91, 0xedc8, 0xee01, 0xee35, 0xee6a, 0xee90, 0xeeb4,
	0xeed9, 0xeefe, 0xef34, 0xef68, 0xef93, 0xefbe, 0xefeb, 0xf01c,
	0xf058, 0xf08d, 0xf0c5, 0xf0f6, 0xf132, 0xf167, 0xf19f, 0xf1c5,
	0xf1eb, 0xf217, 0xf244, 0xf26b, 0xf294, 0xf2bd, 0xf2ee, 0xf320,
	0xf354, 0xf37c, 0xf3ac, 0xf3dd, 0xf410, 0xf434, 0xf459, 0xf478,
	0xf49b, 0xf4bf, 0xf4e2, 0xf505, 0xf528, 0xf54b, 0xf56e, 0xf599,
	0xf5c2, 0xf5ed, 0xf616, 0xf63a, 0xf662, 0xf67f, 0xf69c, 0xf6b8,
	// Entry 6600 - 663F
	0xf6dc, 0xf6f9, 0xf715, 0xf734, 0xf754, 0xf76e, 0xf786, 0xf79c,
	0xf7b0, 0xf7c3, 0xf7e3, 0xf803, 0xf823, 0xf839, 0xf855, 0xf86f,
	0xf885, 0xf899, 0xf8af, 0xf8cc, 0xf8e9, 0xf908, 0xf926, 0xf944,
	0xf961, 0xf984, 0xf9a8, 0xf9bd, 0xf9de, 0xfa00, 0xfa15, 0xfa2a,
	0xfa4b, 0xfa6d, 0xfa87, 0xfaa1, 0xfac5, 0xfae0, 0xfafa, 0xfb10,
	0xfb28, 0xfb41, 0xfb5c, 0xfb73, 0xfb8c, 0xfbad, 0xfbcd, 0xfbe7,
	0xfbfe, 0xfc18, 0xfc33, 0xfc53, 0xfc74, 0xfc8d, 0xfca6, 0xfcbe,
	0xfcd9, 0xfcf3, 0xfd10, 0xfd31, 0xfd51, 0xfd7e, 0xfd97, 0xfdb3,
	// Entry 6640 - 667F
	0xfdd3, 0xfdf7, 0xfe1b, 0xfe44, 0xfe6d, 0xfe98, 0xfec3, 0xfeef,
	0xff1b, 0xff46, 0xff71, 0xffa0, 0xffcf, 0xfff1, 0x0013, 0x0044,
	0x0075, 0x0098, 0x00b4, 0x00d1, 0x00ed, 0x0112, 0x0137, 0x014b,
	0x0164, 0x017c, 0x0197, 0x01b1, 0x01ce, 0x01ef, 0x020f, 0x023c,
	0x0259, 0x0283, 0x02a5, 0x02c7, 0x02e9, 0x030a, 0x032b, 0x034c,
	0x0375, 0x0394, 0x03b3, 0x03d2, 0x03f1, 0x0410, 0x0429, 0x0440,
	0x0458, 0x046e, 0x0487, 0x049e, 0x04b9, 0x04d2, 0x04f1, 0x0512,
	0x0531, 0x0557, 0x0577, 0x05a0, 0x05c8, 0x05e6, 0x0602, 0x0620,
	// Entry 6680 - 66BF
	0x063d, 0x0659, 0x0676, 0x0694, 0x06b1, 0x06d7, 0x06fd, 0x0717,
	0x072c, 0x073c, 0x0750, 0x0764, 0x0778, 0x0790, 0x07aa, 0x07c9,
	0x07eb, 0x07fc, 0x080f, 0x082b, 0x0844, 0x085a, 0x087a, 0x089a,
	0x08ba, 0x08da, 0x08fa, 0x091a, 0x093a, 0x095a, 0x097a, 0x099b,
	0x09bc, 0x09d6, 0x09f0, 0x0a0c, 0x0a27, 0x0a48, 0x0a67, 0x0a88,
	0x0aaf, 0x0ac8, 0x0ae4, 0x0b02, 0x0b1d, 0x0b3a, 0x0b59, 0x0b6c,
	0x0b83, 0x0b98, 0x0bac, 0x0bc1, 0x0be0, 0x0bff, 0x0c14, 0x0c2f,
	0x0c4e, 0x0c6d, 0x0c86, 0x0c9f, 0x0cc1, 0x0ce5, 0x0cff, 0x0d1d,
	// Entry 66C0 - 66FF
	0x0d37, 0x0d55, 0x0d8c, 0x0dc5, 0x0e09, 0x0e42, 0x0e7d, 0x0ec5,
	0x0f0d, 0x0f55, 0x0f69, 0x0f88, 0x0fa7, 0x0fbe, 0x0fd2, 0x0fe8,
	0x0ffd, 0x1015, 0x102c, 0x1043, 0x105b, 0x107a, 0x1099, 0x10ba,
	0x10d7, 0x10f3, 0x1115, 0x1135, 0x115a, 0x117a, 0x1199, 0x11c5,
	0x11ef, 0x121a, 0x1243, 0x1262, 0x127f, 0x129c, 0x12b9, 0x12d6,
	0x12f3, 0x1310, 0x132d, 0x134a, 0x1367, 0x1385, 0x13a3, 0x13c1,
	0x13df, 0x13fd, 0x141b, 0x1439, 0x1457, 0x1475, 0x1493, 0x14b1,
	0x14cf, 0x14ed, 0x150b, 0x1529, 0x1547, 0x1565, 0x1583, 0x15a1,
	// Entry 6700 - 673F
	0x15bf, 0x15e3, 0x1607, 0x162b, 0x164f, 0x1673, 0x1697, 0x16bc,
	0x16e1, 0x1706, 0x172b, 0x1750, 0x1775, 0x179a, 0x17bf, 0x17e4,
	0x1809, 0x182e, 0x1853, 0x1878, 0x189d, 0x18c2, 0x18e7, 0x190c,
	0x1931, 0x1956, 0x197b, 0x19a0, 0x19c5, 0x19ea, 0x1a0f, 0x1a34,
	0x1a59, 0x1a7e, 0x1aa3, 0x1ac8, 0x1aed, 0x1b12, 0x1b31, 0x1b52,
	0x1b73, 0x1b87, 0x1b99, 0x1bb2, 0x1bc8, 0x1be1, 0x1bf9, 0x1c09,
	0x1c1d, 0x1c36, 0x1c49, 0x1c5e, 0x1c79, 0x1c92, 0x1ca6, 0x1cbe,
	0x1cd9, 0x1d02, 0x1d1a, 0x1d34, 0x1d4a, 0x1d63, 0x1d76, 0x1d8b,
	// Entry 6740 - 677F
	0x1da5, 0x1dba, 0x1dd1, 0x1de6, 0x1dfb, 0x1e13, 0x1e25, 0x1e36,
	0x1e4e, 0x1e65, 0x1e79, 0x1e8d, 0x1ea7, 0x1ec4, 0x1ed9, 0x1eed,
	0x1f04, 0x1f19, 0x1f30, 0x1f46, 0x1f5a, 0x1f70, 0x1f87, 0x1fa1,
	0x1fb7, 0x1fd2, 0x1fea, 0x1ffd, 0x2014, 0x202d, 0x2042, 0x2056,
	0x206a, 0x208b, 0x20a2, 0x20b7, 0x20cd, 0x20e0, 0x20fa, 0x2114,
	0x212d, 0x2147, 0x215c, 0x2176, 0x2191, 0x21a4, 0x21b7, 0x21cc,
	0x21df, 0x21f6, 0x220d, 0x2222, 0x223a, 0x2251, 0x2267, 0x227d,
	0x2295, 0x22aa, 0x22bf, 0x22d8, 0x22f0, 0x230a, 0x2324, 0x233b,
	// Entry 6780 - 67BF
	0x2352, 0x236d, 0x2388, 0x23a5, 0x23c1, 0x23dd, 0x23f8, 0x2415,
	0x2432, 0x244e, 0x2469, 0x2484, 0x24a1, 0x24bd, 0x24d9, 0x24f4,
	0x2511, 0x252e, 0x254a, 0x2565, 0x2580, 0x259b, 0x25b6, 0x25d1,
	0x25ec, 0x2607, 0x2622, 0x263d, 0x2658, 0x2673, 0x268e, 0x26a9,
	0x26c4, 0x26df, 0x26fa, 0x2715, 0x2730, 0x274b, 0x2766, 0x2781,
	0x279c, 0x27b7, 0x27d2, 0x27ed, 0x2808, 0x2821, 0x283a, 0x2853,
	0x286c, 0x2885, 0x289e, 0x28b7, 0x28d0, 0x28e9, 0x2902, 0x291b,
	0x2934, 0x294d, 0x2966, 0x297f, 0x2998, 0x29b1, 0x29ca, 0x29e3,
	// Entry 67C0 - 67FF
	0x29fc, 0x2a15, 0x2a2e, 0x2a47, 0x2a60, 0x2a79, 0x2a92, 0x2aaf,
	0x2acc, 0x2ae9, 0x2b06, 0x2b23, 0x2b40, 0x2b5d, 0x2b7a, 0x2b97,
	0x2bb4, 0x2bd1, 0x2bee, 0x2c0b, 0x2c28, 0x2c45, 0x2c62, 0x2c7f,
	0x2c9c, 0x2cb9, 0x2cd6, 0x2cf3, 0x2d10, 0x2d2d, 0x2d4a, 0x2d67,
	0x2d84, 0x2d9f, 0x2dba, 0x2dd5, 0x2df0, 0x2e0b, 0x2e26, 0x2e41,
	0x2e5c, 0x2e77, 0x2e92, 0x2ead, 0x2ec8, 0x2ee3, 0x2efe, 0x2f19,
	0x2f34, 0x2f4f, 0x2f6a, 0x2f85, 0x2fa0, 0x2fbb, 0x2fd6, 0x2ff1,
	0x300c, 0x3027, 0x3049, 0x306b, 0x308d, 0x30af, 0x30d1, 0x30f3,
	// Entry 6800 - 683F
	0x3115, 0x3137, 0x3159, 0x317b, 0x319d, 0x31bf, 0x31e1, 0x3203,
	0x3225, 0x3247, 0x3269, 0x328b, 0x32ad, 0x32cf, 0x32f1, 0x3313,
	0x3335, 0x3357, 0x3379, 0x339b, 0x33bb, 0x33db, 0x33fb, 0x341b,
	0x343b, 0x345b, 0x347b, 0x349b, 0x34bb, 0x34db, 0x34fb, 0x351b,
	0x353b, 0x355b, 0x357b, 0x359b, 0x35bb, 0x35db, 0x35fb, 0x361b,
	0x363b, 0x365b, 0x367b, 0x369b, 0x36bb, 0x36db, 0x36f8, 0x3715,
	0x3732, 0x374f, 0x376c, 0x3789, 0x37a6, 0x37c3, 0x37e0, 0x37fd,
	0x381a, 0x3837, 0x3854, 0x3871, 0x388e, 0x38ab, 0x38c8, 0x38e5,
	// Entry 6840 - 687F
	0x3900, 0x391b, 0x3936, 0x3951, 0x396c, 0x3987, 0x39a2, 0x39bd,
	0x39d8, 0x39f3, 0x3a0e, 0x3a29, 0x3a44, 0x3a5f, 0x3a7a, 0x3a95,
	0x3ab0, 0x3acb, 0x3ae6, 0x3b01, 0x3b1c, 0x3b37, 0x3b52, 0x3b74,
	0x3b96, 0x3bb8, 0x3bda, 0x3bfc, 0x3c1e, 0x3c40, 0x3c62, 0x3c84,
	0x3ca6, 0x3cc8, 0x3cea, 0x3d0c, 0x3d2e, 0x3d50, 0x3d72, 0x3d94,
	0x3db6, 0x3dd8, 0x3dfa, 0x3e1c, 0x3e3e, 0x3e60, 0x3e82, 0x3ea4,
	0x3ec6, 0x3ee6, 0x3f06, 0x3f26, 0x3f46, 0x3f66, 0x3f86, 0x3fa6,
	0x3fc6, 0x3fe6, 0x4006, 0x4026, 0x4046, 0x4066, 0x4086, 0x40a6,
	// Entry 6880 - 68BF
	0x40c6, 0x40e6, 0x4106, 0x4126, 0x4146, 0x4166, 0x4186, 0x41a6,
	0x41c6, 0x41e6, 0x4206, 0x4224, 0x4242, 0x4260, 0x427e, 0x429c,
	0x42ba, 0x42d8, 0x42f6, 0x4314, 0x4332, 0x4350, 0x436e, 0x438c,
	0x43aa, 0x43c8, 0x43e6, 0x4404, 0x4422, 0x4440, 0x445e, 0x447c,
	0x4498, 0x44b4, 0x44d0, 0x44ec, 0x4508, 0x4524, 0x4540, 0x455c,
	0x4578, 0x4594, 0x45b0, 0x45cc, 0x45e8, 0x4604, 0x4620, 0x463c,
	0x4658, 0x4674, 0x4690, 0x46ac, 0x46c8, 0x46e4, 0x4700, 0x471c,
	0x4738, 0x4754, 0x4778, 0x479c, 0x47c0, 0x47e4, 0x4808, 0x482c,
	// Entry 68C0 - 68FF
	0x4850, 0x4874, 0x4898, 0x48bc, 0x48e0, 0x4904, 0x4928, 0x494c,
	0x4970, 0x4994, 0x49b8, 0x49dc, 0x4a00, 0x4a22, 0x4a44, 0x4a66,
	0x4a88, 0x4aaa, 0x4acc, 0x4aee, 0x4b10, 0x4b32, 0x4b54, 0x4b76,
	0x4b98, 0x4bba, 0x4bdc, 0x4bfe, 0x4c20, 0x4c42, 0x4c64, 0x4c86,
	0x4ca8, 0x4cca, 0x4cec, 0x4d0e, 0x4d30, 0x4d52, 0x4d74, 0x4d97,
	0x4dba, 0x4ddd, 0x4e00, 0x4e23, 0x4e46, 0x4e69, 0x4e8c, 0x4eaf,
	0x4ed2, 0x4ef5, 0x4f18, 0x4f3b, 0x4f5e, 0x4f81, 0x4fa4, 0x4fc7,
	0x4fea, 0x500d, 0x5030, 0x5053, 0x5076, 0x5099, 0x50bc, 0x50df,
	// Entry 6900 - 693F
	0x5102, 0x5123, 0x5144, 0x5165, 0x5186, 0x51a7, 0x51c8, 0x51e9,
	0x520a, 0x522b, 0x524c, 0x526d, 0x528e, 0x52af, 0x52d0, 0x52f1,
	0x5312, 0x5333, 0x5354, 0x5375, 0x5396, 0x53b7, 0x53d8, 0x53f9,
	0x541a, 0x543b, 0x545c, 0x547d, 0x549e, 0x54bf, 0x54e0, 0x5501,
	0x5522, 0x5543, 0x5564, 0x5585, 0x55a6, 0x55c7, 0x55e8, 0x5609,
	0x562a, 0x564b, 0x566c, 0x568d, 0x56ae, 0x56cf, 0x56f0, 0x5711,
	0x5732, 0x5753, 0x5774, 0x5795, 0x57b6, 0x57d5, 0x57f4, 0x5813,
	0x5832, 0x5851, 0x5870, 0x588f, 0x58ae, 0x58cd, 0x58ec, 0x590b,
	// Entry 6940 - 697F
	0x592a, 0x5949, 0x5968, 0x5987, 0x59a6, 0x59c5, 0x59e4, 0x5a03,
	0x5a22, 0x5a41, 0x5a60, 0x5a7f, 0x5a9e, 0x5abd, 0x5adc, 0x5b02,
	0x5b28, 0x5b4e, 0x5b74, 0x5b9a, 0x5bc0, 0x5be6, 0x5c0c, 0x5c32,
	0x5c58, 0x5c7e, 0x5ca4, 0x5cca, 0x5cf0, 0x5d16, 0x5d3c, 0x5d62,
	0x5d88, 0x5dae, 0x5dd4, 0x5dfa, 0x5e20, 0x5e46, 0x5e6c, 0x5e92,
	0x5eb8, 0x5edc, 0x5f00, 0x5f24, 0x5f48, 0x5f6c, 0x5f90, 0x5fb4,
	0x5fd8, 0x5ffc, 0x6020, 0x6044, 0x6068, 0x608c, 0x60b0, 0x60d4,
	0x60f8, 0x611c, 0x6140, 0x6164, 0x6188, 0x61ac, 0x61d0, 0x61f4,
	// Entry 6980 - 69BF
	0x6218, 0x623c, 0x6260, 0x6288, 0x62b0, 0x62d8, 0x6300, 0x6328,
	0x6350, 0x6378, 0x63a0, 0x63c8, 0x63f0, 0x6418, 0x6440, 0x6468,
	0x6490, 0x64b8, 0x64e0, 0x6508, 0x6530, 0x6558, 0x6580, 0x65a8,
	0x65d0, 0x65f8, 0x6620, 0x6648, 0x6670, 0x6696, 0x66bc, 0x66e2,
	0x6708, 0x672e, 0x6754, 0x677a, 0x67a0, 0x67c6, 0x67ec, 0x6812,
	0x6838, 0x685e, 0x6884, 0x68aa, 0x68d0, 0x68f6, 0x691c, 0x6942,
	0x6968, 0x698e, 0x69b4, 0x69da, 0x6a00, 0x6a26, 0x6a4c, 0x6a79,
	0x6aa6, 0x6ad3, 0x6b00, 0x6b2d, 0x6b5a, 0x6b87, 0x6bb4, 0x6be1,
	// Entry 69C0 - 69FF
	0x6c0e, 0x6c3b, 0x6c68, 0x6c95, 0x6cc2, 0x6cef, 0x6d1c, 0x6d49,
	0x6d76, 0x6da3, 0x6dd0, 0x6dfd, 0x6e2a, 0x6e57, 0x6e84, 0x6eb1,
	0x6ede, 0x6f09, 0x6f34, 0x6f5f, 0x6f8a, 0x6fb5, 0x6fe0, 0x700b,
	0x7036, 0x7061, 0x708c, 0x70b7, 0x70e2, 0x710d, 0x7138, 0x7163,
	0x718e, 0x71b9, 0x71e4, 0x720f, 0x723a, 0x7265, 0x7290, 0x72bb,
	0x72e6, 0x7311, 0x733c, 0x735c, 0x737c, 0x739c, 0x73bc, 0x73dc,
	0x73fc, 0x741c, 0x743c, 0x745c, 0x747c, 0x749c, 0x74bc, 0x74dc,
	0x74fc, 0x751c, 0x753c, 0x755c, 0x757c, 0x759c, 0x75bc, 0x75dc,
	// Entry 6A00 - 6A3F
	0x75fc, 0x761c, 0x763c, 0x765c, 0x767c, 0x769a, 0x76b8, 0x76d6,
	0x76f4, 0x7712, 0x7730, 0x774e, 0x776c, 0x778a, 0x77a8, 0x77c6,
	0x77e4, 0x7802, 0x7820, 0x783e, 0x785c, 0x787a, 0x7898, 0x78b6,
	0x78d4, 0x78f2, 0x7910, 0x792e, 0x794c, 0x796a, 0x7988, 0x79ab,
	0x79ce, 0x79ed, 0x7a0b, 0x7a2a, 0x7a49, 0x7a6a, 0x7a88, 0x7aa5,
	0x7ac4, 0x7ae2, 0x7b01, 0x7b20, 0x7b3c, 0x7b58, 0x7b74, 0x7b95,
	0x7bb1, 0x7bce, 0x7bf4, 0x7c13, 0x7c30, 0x7c51, 0x7c6e, 0x7c8b,
	0x7ca8, 0x7cc7, 0x7cde, 0x7cfb, 0x7d17, 0x7d34, 0x7d51, 0x7d70,
	// Entry 6A40 - 6A7F
	0x7d8c, 0x7da7, 0x7dc4, 0x7de0, 0x7dfd, 0x7e1a, 0x7e34, 0x7e4e,
	0x7e68, 0x7e87, 0x7ea1, 0x7ebc, 0x7edf, 0x7efc, 0x7f17, 0x7f36,
	0x7f51, 0x7f6c, 0x7f87, 0x7fa4, 0x7fca, 0x7fea, 0x8008, 0x8026,
	0x8042, 0x805e, 0x8079, 0x809a, 0x80ba, 0x80db, 0x80fc, 0x811f,
	0x813f, 0x815e, 0x817f, 0x819f, 0x81c0, 0x81e1, 0x81ff, 0x821d,
	0x823b, 0x825e, 0x827c, 0x829b, 0x82c3, 0x82e4, 0x8303, 0x8326,
	0x8345, 0x8364, 0x8383, 0x83a4, 0x83bd, 0x83dc, 0x83fa, 0x8419,
	0x8438, 0x8459, 0x8477, 0x8494, 0x84b3, 0x84d1, 0x84f0, 0x850f,
	// Entry 6A80 - 6ABF
	0x852b, 0x8547, 0x8563, 0x8584, 0x85a0, 0x85bd, 0x85e2, 0x8601,
	0x861e, 0x863f, 0x865c, 0x8679, 0x8696, 0x86b5, 0x86dd, 0x86ff,
	0x871f, 0x873f, 0x875d, 0x877b, 0x8798, 0x87be, 0x87e3, 0x8809,
	0x882f, 0x8857, 0x887c, 0x88a0, 0x88c6, 0x88eb, 0x8911, 0x8937,
	0x895a, 0x897d, 0x89a0, 0x89c8, 0x89eb, 0x8a0f, 0x8a3c, 0x8a62,
	0x8a86, 0x8aae, 0x8ad2, 0x8af6, 0x8b1a, 0x8b40, 0x8b5e, 0x8b82,
	0x8ba5, 0x8bc9, 0x8bed, 0x8c13, 0x8c36, 0x8c58, 0x8c7c, 0x8c9f,
	0x8cc3, 0x8ce7, 0x8d08, 0x8d29, 0x8d4a, 0x8d70, 0x8d91, 0x8db3,
	// Entry 6AC0 - 6AFF
	0x8ddd, 0x8e01, 0x8e23, 0x8e49, 0x8e6b, 0x8e8d, 0x8eaf, 0x8ed3,
	0x8f00, 0x8f27, 0x8f4c, 0x8f71, 0x8f94, 0x8fb7, 0x8fd9, 0x9003,
	0x902c, 0x9056, 0x9080, 0x90ac, 0x90d5, 0x90fd, 0x9127, 0x9150,
	0x917a, 0x91a4, 0x91cb, 0x91f2, 0x9219, 0x9245, 0x926c, 0x9294,
	0x92c5, 0x92ef, 0x9317, 0x9343, 0x936b, 0x9393, 0x93bb, 0x93e5,
	0x9407, 0x942f, 0x9456, 0x947e, 0x94a6, 0x94d0, 0x94f7, 0x951d,
	0x9545, 0x956c, 0x9594, 0x95bc, 0x95e1, 0x9606, 0x962b, 0x9655,
	0x967a, 0x96a0, 0x96ce, 0x96f6, 0x971c, 0x9746, 0x976c, 0x9792,
	// Entry 6B00 - 6B3F
	0x97b8, 0x97e0, 0x9811, 0x983c, 0x9865, 0x988e, 0x98b5, 0x98dc,
	0x9902, 0x9933, 0x9963, 0x9994, 0x99c5, 0x99f8, 0x9a28, 0x9a57,
	0x9a88, 0x9ab8, 0x9ae9, 0x9b1a, 0x9b48, 0x9b76, 0x9ba4, 0x9bd7,
	0x9c05, 0x9c34, 0x9c6c, 0x9c9d, 0x9ccc, 0x9cff, 0x9d2e, 0x9d5d,
	0x9d8c, 0x9dbd, 0x9de6, 0x9e15, 0x9e43, 0x9e72, 0x9ea1, 0x9ed2,
	0x9f00, 0x9f2d, 0x9f5c, 0x9f8a, 0x9fb9, 0x9fe8, 0xa014, 0xa040,
	0xa06c, 0xa09d, 0xa0c9, 0xa0f6, 0xa12b, 0xa15a, 0xa187, 0xa1b8,
	0xa1e5, 0xa212, 0xa23f, 0xa26e, 0xa2a6, 0xa2d8, 0xa308, 0xa338,
	// Entry 6B40 - 6B7F
	0xa366, 0xa394, 0xa3c1, 0xa3e2, 0xa401, 0xa41d, 0xa438, 0xa453,
	0xa470, 0xa48c, 0xa4a8, 0xa4c3, 0xa4e0, 0xa4fd, 0xa519, 0xa53e,
	0xa562, 0xa586, 0xa5ac, 0xa5d1, 0xa5f6, 0xa61a, 0xa640, 0xa666,
	0xa68b, 0xa6ad, 0xa6ce, 0xa6ef, 0xa712, 0xa734, 0xa756, 0xa777,
	0xa79a, 0xa7bd, 0xa7df, 0xa806, 0xa82c, 0xa852, 0xa87a, 0xa8a1,
	0xa8c8, 0xa8ee, 0xa916, 0xa93e, 0xa965, 0xa986, 0xa9a6, 0xa9c6,
	0xa9e8, 0xaa09, 0xaa2a, 0xaa4a, 0xaa6c, 0xaa8e, 0xaaaf, 0xaaca,
	0xaae7, 0xab01, 0xab1c, 0xab38, 0xab54, 0xab74, 0xab96, 0xabc2,
	// Entry 6B80 - 6BBF
	0xabec, 0xac0e, 0xac30, 0xac56, 0xac79, 0xac9b, 0xacbf, 0xace6,
	0xad18, 0xad41, 0xad6d, 0xad99, 0xadc5, 0xadfc, 0xae34, 0xae67,
	0xae9a, 0xaec4, 0xaef0, 0xaf1c, 0xaf48, 0xaf70, 0xaf9a, 0xafd0,
	0xb006, 0xb033, 0xb06e, 0xb0a5, 0xb0e1, 0xb118, 0xb152, 0xb181,
	0xb1b1, 0xb1e0, 0xb20f, 0xb248, 0xb27f, 0xb2c0, 0xb2fc, 0xb32e,
	0xb360, 0xb39e, 0xb3d3, 0xb40d, 0xb44e, 0xb480, 0xb4b2, 0xb4e5,
	0xb51c, 0xb552, 0xb587, 0xb5ba, 0xb5f3, 0xb626, 0xb655, 0xb68b,
	0xb6c6, 0xb6f8, 0xb72e, 0xb750, 0xb777, 0xb7a0, 0xb7cc, 0xb7fe,
	// Entry 6BC0 - 6BFF
	0xb82a, 0xb85b, 0xb888, 0xb8b1, 0xb8df, 0xb912, 0xb94a, 0xb978,
	0xb9ab, 0xb9e2, 0xba0a, 0xba37, 0xba66, 0xba8f, 0xbabf, 0xbafa,
	0xbb33, 0xbb48, 0xbb72, 0xbb8c, 0xbbac, 0xbbd1, 0xbbf1, 0xbc14,
	0xbc40, 0xbc62, 0xbc8f, 0xbcc1, 0xbce3, 0xbcf8, 0xbd18, 0xbd36,
	0xbd59, 0xbd77, 0xbd8c, 0xbda5, 0xbdb9, 0xbddd, 0xbdfc, 0xbe1e,
	0xbe3b, 0xbe62, 0xbe84, 0xbea2, 0xbebb, 0xbed2, 0xbee7, 0xbf07,
	0xbf25, 0xbf48, 0xbf63, 0xbf8c, 0xbfa2, 0xbfbe, 0xbfe4, 0xc005,
	0xc029, 0xc048, 0xc078, 0xc0a8, 0xc0be, 0xc0e5, 0xc10e, 0xc136,
	// Entry 6C00 - 6C3F
	0xc15e, 0xc17b, 0xc1a7, 0xc1d8, 0xc20a, 0xc22b, 0xc25c, 0xc28b,
	0xc2bb, 0xc2da, 0xc305, 0xc326, 0xc345, 0xc365, 0xc390, 0xc3b1,
	0xc3db, 0xc3fd, 0xc420, 0xc448, 0xc471, 0xc4aa, 0xc4df, 0xc501,
	0xc525, 0xc548, 0xc56b, 0xc594, 0xc5bf, 0xc5e9, 0xc604, 0xc62e,
	0xc65d, 0xc68e, 0xc6ad, 0xc6e5, 0xc71e, 0xc73b, 0xc764, 0xc785,
	0xc7a8, 0xc7c9, 0xc7eb, 0xc80c, 0xc837, 0xc868, 0xc888, 0xc8a8,
	0xc8c8, 0xc8ef, 0xc918, 0xc946, 0xc971, 0xc99b, 0xc9c8, 0xc9ee,
	0xca16, 0xca42, 0xca6a, 0xca8b, 0xcaa8, 0xcac7, 0xcae8, 0xcb13,
	// Entry 6C40 - 6C7F
	0xcb3d, 0xcb5f, 0xcb88, 0xcbab, 0xcbd3, 0xcbfd, 0xcc2c, 0xcc53,
	0xcc7c, 0xcca9, 0xccd5, 0xccfe, 0xcd2d, 0xcd5f, 0xcd96, 0xcdcc,
	0xce01, 0xce33, 0xce56, 0xce7c, 0xcea3, 0xced8, 0xcf0e, 0xcf3f,
	0xcf70, 0xcfa0, 0xcfd2, 0xd00a, 0xd03e, 0xd064, 0xd08e, 0xd0c2,
	0xd0f6, 0xd129, 0xd151, 0xd171, 0xd196, 0xd1bd, 0xd1e5, 0xd207,
	0xd22f, 0xd255, 0xd27a, 0xd29c, 0xd2b7, 0xd2d7, 0xd300, 0xd32a,
	0xd34f, 0xd372, 0xd3a2, 0xd3d1, 0xd400, 0xd42d, 0xd459, 0xd488,
	0xd4b6, 0xd4eb, 0xd500, 0xd51a, 0xd532, 0xd54c, 0xd565, 0xd57d,
	// Entry 6C80 - 6CBF
	0xd597, 0xd5b0, 0xd5c9, 0xd5e4, 0xd5fe, 0xd616, 0xd630, 0xd649,
	0xd65f, 0xd677, 0xd68e, 0xd6a9, 0xd6c4, 0xd6e4, 0xd704, 0xd726,
	0xd748, 0xd766, 0xd784, 0xd7a2, 0xd7c2, 0xd7e2, 0xd7fe, 0xd823,
	0xd84b, 0xd873, 0xd89b, 0xd8c5, 0xd8f9, 0xd92d, 0xd95d, 0xd98a,
	0xd9b8, 0xd9ec, 0xda21, 0xda55, 0xda8b, 0xdabb, 0xdae9, 0xdb19,
	0xdb4a, 0xdb86, 0xdbaa, 0xdbe1, 0xdc11, 0xdc42, 0xdc7e, 0xdca7,
	0xdcd1, 0xdcfa, 0xdd25, 0xdd51, 0xdd7c, 0xddaa, 0xddd4, 0xddff,
	0xde29, 0xde51, 0xde7a, 0xdea2, 0xdecd, 0xdef9, 0xdf24, 0xdf4e,
	// Entry 6CC0 - 6CFF
	0xdf79, 0xdfa3, 0xdfd9, 0xe00f, 0xe04a, 0xe081, 0xe0b8, 0xe0f4,
	0xe118, 0xe146, 0xe174, 0xe1a2, 0xe1ca, 0xe1f3, 0xe21b, 0xe245,
	0xe270, 0xe29c, 0xe2c7, 0xe2f4, 0xe324, 0xe355, 0xe385, 0xe3b7,
	0xe3ea, 0xe41e, 0xe451, 0xe486, 0xe4bb, 0xe4f1, 0xe526, 0xe55d,
	0xe58e, 0xe5bd, 0xe5ee, 0xe620, 0xe65d, 0xe682, 0xe6ba, 0xe6eb,
	0xe726, 0xe763, 0xe787, 0xe7b3, 0xe7e0, 0xe80c, 0xe831, 0xe85a,
	0xe884, 0xe8ad, 0xe8d9, 0xe906, 0xe932, 0xe95d, 0xe989, 0xe9b4,
	0xe9ec, 0xea24, 0xea61, 0xea98, 0xeacf, 0xeb0b, 0xeb30, 0xeb62,
	// Entry 6D00 - 6D3F
	0xeb95, 0xebc7, 0xebfb, 0xec31, 0xec68, 0xec9e, 0xecd6, 0xed15,
	0xed55, 0xed7e, 0xeda8, 0xedd1, 0xedfa, 0xee24, 0xee4d, 0xee7d,
	0xeeb3, 0xeeea, 0xef20, 0xef56, 0xef8d, 0xefc3, 0xeff5, 0xf026,
	0xf058, 0xf07d, 0xf0a2, 0xf0ca, 0xf0f0, 0xf127, 0xf15d, 0xf193,
	0xf1c9, 0xf201, 0xf239, 0xf276, 0xf2a8, 0xf2d9, 0xf30a, 0xf33b,
	0xf36e, 0xf3a1, 0xf3d9, 0xf410, 0xf448, 0xf47f, 0xf4ba, 0xf4f5,
	0xf536, 0xf577, 0xf5b8, 0xf5f9, 0xf63a, 0xf67b, 0xf6bc, 0xf6fd,
	0xf737, 0xf771, 0xf7a7, 0xf7dd, 0xf818, 0xf851, 0xf88a, 0xf8c9,
	// Entry 6D40 - 6D7F
	0xf908, 0xf94e, 0xf994, 0xf9d3, 0xfa12, 0xfa51, 0xfa90, 0xfac8,
	0xfb00, 0xfb34, 0xfb68, 0xfba1, 0xfbcc, 0xfbf8, 0xfc23, 0xfc50,
	0xfc7e, 0xfca8, 0xfcd2, 0xfcfc, 0xfd26, 0xfd50, 0xfd76, 0xfd9c,
	0xfdc7, 0xfdf7, 0xfe2d, 0xfe64, 0xfe9a, 0xfed1, 0xff15, 0xff5a,
	0xff9e, 0xffe2, 0x0027, 0x006b, 0x00a3, 0x00db, 0x011b, 0x015b,
	0x018f, 0x01c3, 0x0205, 0x0247, 0x026a, 0x028d, 0x02a5, 0x02bd,
	0x02d6, 0x02f1, 0x0311, 0x033d, 0x0361, 0x037c, 0x038c, 0x03a0,
	0x03cc, 0x03f4, 0x0421, 0x044a, 0x0474, 0x0494, 0x04cc, 0x04ff,
	// Entry 6D80 - 6DBF
	0x053a, 0x055a, 0x057f, 0x05a1, 0x05c9, 0x05f1, 0x0617, 0x063d,
	0x0659, 0x0675, 0x0692, 0x06a7, 0x06c0, 0x06d7, 0x06f3, 0x0711,
	0x072b, 0x0745, 0x0761, 0x0783, 0x0797, 0x07af, 0x07c9, 0x07e9,
	0x080f, 0x083c, 0x086e, 0x0895, 0x08c3, 0x08f6, 0x091a, 0x093f,
	0x0965, 0x097e, 0x0998, 0x09b1, 0x09ce, 0x09ed, 0x0a09, 0x0a19,
	0x0a31, 0x0a49, 0x0a62, 0x0a7a, 0x0a95, 0x0aaf, 0x0ad3, 0x0af7,
	0x0b10, 0x0b29, 0x0b49, 0x0b69, 0x0b89, 0x0ba0, 0x0bc0, 0x0bdc,
	0x0bf3, 0x0c13, 0x0c2f, 0x0c4c, 0x0c6a, 0x0c89, 0x0ca4, 0x0cc8,
	// Entry 6DC0 - 6DFF
	0x0ce8, 0x0d08, 0x0d31, 0x0d56, 0x0d6c, 0x0d8a, 0x0da9, 0x0dc0,
	0x0ddf, 0x0dfd, 0x0e1e, 0x0e3e, 0x0e5e, 0x0e77, 0x0e98, 0x0eb9,
	0x0edc, 0x0efb, 0x0f1e, 0x0f4a, 0x0f71, 0x0f97, 0x0fbd, 0x0fe3,
	0x0ff4, 0x100e, 0x1029, 0x104d, 0x1066, 0x1088, 0x10a3, 0x10c5,
	0x10e8, 0x10f8, 0x1108, 0x111e, 0x113c, 0x115e, 0x1185, 0x11ad,
	0x11d4, 0x1200, 0x1227, 0x124c, 0x127a, 0x1296, 0x12af, 0x12c8,
	0x12e1, 0x12fa, 0x1313, 0x132c, 0x1345, 0x1357, 0x137b, 0x13a0,
	0x13bb, 0x13d5, 0x13ef, 0x140d, 0x1427, 0x1448, 0x1459, 0x146e,
	// Entry 6E00 - 6E3F
	0x1483, 0x1494, 0x14ab, 0x14c6, 0x14e1, 0x14fc, 0x1517, 0x1532,
	0x1551, 0x1570, 0x158f, 0x15ae, 0x15cd, 0x15ec, 0x160b, 0x162a,
	0x164a, 0x166a, 0x168a, 0x16aa, 0x16ca, 0x16ea, 0x170a, 0x1729,
	0x1749, 0x1769, 0x178c, 0x17ad, 0x17ce, 0x17f1, 0x1813, 0x1833,
	0x185b, 0x1878, 0x189a, 0x18ba, 0x18dd, 0x1900, 0x1921, 0x1940,
	0x1962, 0x1983, 0x19a4, 0x19c6, 0x19e5, 0x1a06, 0x1a26, 0x1a46,
	0x1a65, 0x1a87, 0x1aa6, 0x1ac6, 0x1ae6, 0x1b06, 0x1b24, 0x1b49,
	0x1b67, 0x1b94, 0x1bb7, 0x1be2, 0x1c02, 0x1c20, 0x1c3e, 0x1c5c,
	// Entry 6E40 - 6E7F
	0x1c7b, 0x1c99, 0x1cb8, 0x1cd6, 0x1cf5, 0x1d13, 0x1d31, 0x1d4f,
	0x1d6e, 0x1d8c, 0x1dab, 0x1dc9, 0x1de8, 0x1e07, 0x1e26, 0x1e45,
	0x1e64, 0x1e83, 0x1ea2, 0x1ec1, 0x1ee0, 0x1eff, 0x1f1f, 0x1f3f,
	0x1f5d, 0x1f7b, 0x1f99, 0x1fb8, 0x1fd6, 0x1ff5, 0x2013, 0x2030,
	0x204d, 0x206a, 0x2088, 0x20a5, 0x20c3, 0x20e0, 0x20fe, 0x211c,
	0x213a, 0x2158, 0x2176, 0x2194, 0x21b2, 0x21d0, 0x21ef, 0x220d,
	0x222c, 0x224a, 0x2269, 0x2287, 0x22a5, 0x22c3, 0x22e2, 0x2300,
	0x231f, 0x233d, 0x2360, 0x237e, 0x239c, 0x23ba, 0x23d9, 0x23f8,
	// Entry 6E80 - 6EBF
	0x2416, 0x2434, 0x2452, 0x2470, 0x248f, 0x24ad, 0x24cc, 0x24ea,
	0x2508, 0x2526, 0x2544, 0x2563, 0x2581, 0x25a0, 0x25be, 0x25e1,
	0x25ff, 0x261d, 0x263b, 0x265a, 0x2678, 0x2697, 0x26b5, 0x26d3,
	0x26f1, 0x270f, 0x272e, 0x274c, 0x276b, 0x2789, 0x27a8, 0x27c7,
	0x27e6, 0x2805, 0x2824, 0x2843, 0x2862, 0x2880, 0x289e, 0x28bc,
	0x28db, 0x28f9, 0x2918, 0x2936, 0x2956, 0x2976, 0x2995, 0x29b4,
	0x29d3, 0x29f2, 0x2a11, 0x2a31, 0x2a51, 0x2a71, 0x2a91, 0x2ab2,
	0x2ad2, 0x2af3, 0x2b13, 0x2b34, 0x2b55, 0x2b7a, 0x2ba0, 0x2bc5,
	// Entry 6EC0 - 6EFF
	0x2be3, 0x2c01, 0x2c1f, 0x2c3e, 0x2c5e, 0x2c7e, 0x2c9e, 0x2cbe,
	0x2cdf, 0x2cfd, 0x2d1b, 0x2d39, 0x2d58, 0x2d76, 0x2d95, 0x2db3,
	0x2dd2, 0x2df1, 0x2e10, 0x2e30, 0x2e50, 0x2e6f, 0x2e8f, 0x2eae,
	0x2ece, 0x2ef2, 0x2f17, 0x2f3b, 0x2f5a, 0x2f79, 0x2f98, 0x2fb8,
	0x2fd7, 0x2ff7, 0x3016, 0x3035, 0x3054, 0x3073, 0x3093, 0x30b2,
	0x30d2, 0x30f1, 0x310f, 0x312e, 0x314d, 0x316c, 0x318c, 0x31ab,
	0x31cb, 0x31ea, 0x3209, 0x3228, 0x3248, 0x3268, 0x3286, 0x32a4,
	0x32c2, 0x32e1, 0x32ff, 0x331e, 0x333c, 0x335c, 0x337c, 0x339c,
	// Entry 6F00 - 6F3F
	0x33bc, 0x33dc, 0x33f3, 0x340a, 0x3423, 0x343b, 0x3453, 0x346a,
	0x3483, 0x349c, 0x34b4, 0x34d8, 0x34fb, 0x3522, 0x354a, 0x3576,
	0x35a6, 0x35cd, 0x35e6, 0x3600, 0x3619, 0x3632, 0x3649, 0x3668,
	0x367f, 0x3697, 0x36ae, 0x36c4, 0x36db, 0x36f1, 0x3707, 0x371f,
	0x3737, 0x374f, 0x3767, 0x377f, 0x3796, 0x37ac, 0x37c5, 0x37dd,
	0x37f4, 0x380d, 0x3824, 0x383c, 0x3853, 0x386b, 0x3882, 0x389a,
	0x38b2, 0x38ca, 0x38e2, 0x38fa, 0x3911, 0x3929, 0x3940, 0x3957,
	0x396c, 0x3989, 0x399e, 0x39b4, 0x39c9, 0x39dd, 0x39f2, 0x3a06,
	// Entry 6F40 - 6F7F
	0x3a1a, 0x3a30, 0x3a46, 0x3a5c, 0x3a72, 0x3a88, 0x3a9d, 0x3ab1,
	0x3ac8, 0x3ade, 0x3af3, 0x3b0a, 0x3b1f, 0x3b35, 0x3b4a, 0x3b60,
	0x3b75, 0x3b8b, 0x3ba1, 0x3bb7, 0x3bcd, 0x3be3, 0x3bf8, 0x3c0e,
	0x3c23, 0x3c2e, 0x3c46, 0x3c67, 0x3c72, 0x3c82, 0x3c91, 0x3ca0,
	0x3cb1, 0x3cc1, 0x3cd1, 0x3ce0, 0x3cf1, 0x3d02, 0x3d12, 0x3d30,
	0x3d4b, 0x3d63, 0x3d7a, 0x3d92, 0x3da9, 0x3dc0, 0x3dd8, 0x3def,
	0x3e06, 0x3e1d, 0x3e34, 0x3e4b, 0x3e63, 0x3e7b, 0x3e93, 0x3eaa,
	0x3ec1, 0x3ed8, 0x3eef, 0x3f06, 0x3f1f, 0x3f36, 0x3f4e, 0x3f66,
	// Entry 6F80 - 6FBF
	0x3f7e, 0x3f95, 0x3fac, 0x3fc5, 0x3fe4, 0x4004, 0x4023, 0x4042,
	0x4061, 0x4081, 0x40a0, 0x40bf, 0x40de, 0x40fd, 0x411c, 0x413c,
	0x415c, 0x417c, 0x419b, 0x41ba, 0x41d9, 0x41f8, 0x4219, 0x4238,
	0x4258, 0x4278, 0x4297, 0x42b8, 0x42d7, 0x42f5, 0x4313, 0x4331,
	0x4350, 0x436f, 0x438d, 0x43ab, 0x43c9, 0x43e9, 0x4408, 0x4426,
	0x4446, 0x446d, 0x4493, 0x44b4, 0x44d6, 0x44f7, 0x4518, 0x4539,
	0x455a, 0x457b, 0x459d, 0x45bf, 0x45e1, 0x4602, 0x4623, 0x4644,
	0x4665, 0x4688, 0x46a9, 0x46cb, 0x46ed, 0x470e, 0x472f, 0x4752,
	// Entry 6FC0 - 6FFF
	0x477b, 0x47a4, 0x47c3, 0x47e1, 0x4800, 0x481e, 0x483c, 0x485a,
	0x4879, 0x4897, 0x48b5, 0x48d3, 0x48f1, 0x4910, 0x492f, 0x494e,
	0x496c, 0x498a, 0x49a8, 0x49c6, 0x49e4, 0x4a04, 0x4a22, 0x4a41,
	0x4a60, 0x4a7f, 0x4a9d, 0x4abb, 0x4adb, 0x4b00, 0x4b26, 0x4b4b,
	0x4b70, 0x4b96, 0x4bbb, 0x4be0, 0x4c05, 0x4c2a, 0x4c50, 0x4c76,
	0x4c9c, 0x4cc1, 0x4ce6, 0x4d0b, 0x4d30, 0x4d55, 0x4d7c, 0x4da1,
	0x4dc7, 0x4ded, 0x4e13, 0x4e38, 0x4e5d, 0x4e84, 0x4ebb, 0x4ee4,
	0x4efa, 0x4f11, 0x4f27, 0x4f3e, 0x4f55, 0x4f6e, 0x4f87, 0x4fa5,
	// Entry 7000 - 703F
	0x4fc3, 0x4fe3, 0x5002, 0x5021, 0x503f, 0x505f, 0x507f, 0x509e,
	0x50b9, 0x50d4, 0x50f1, 0x510d, 0x5129, 0x5144, 0x5161, 0x517e,
	0x519a, 0x51b5, 0x51d0, 0x51ed, 0x5209, 0x5225, 0x5240, 0x525d,
	0x527a, 0x5296, 0x52a7, 0x52ba, 0x52cd, 0x52e7, 0x52fa, 0x530d,
	0x5320, 0x5333, 0x5345, 0x5356, 0x5371, 0x538d, 0x53a9, 0x53c5,
	0x53e1, 0x53fd, 0x5419, 0x5435, 0x5451, 0x546d, 0x5489, 0x54a5,
	0x54c1, 0x54dd, 0x54f9, 0x5515, 0x5531, 0x554d, 0x5569, 0x5585,
	0x55a1, 0x55bd, 0x55d9, 0x55f5, 0x5611, 0x562d, 0x5649, 0x5665,
	// Entry 7040 - 707F
	0x5681, 0x569d, 0x56b9, 0x56d5, 0x56f1, 0x570d, 0x5729, 0x5745,
	0x5761, 0x577d, 0x5799, 0x57b5, 0x57d1, 0x57ed, 0x5809, 0x5825,
	0x5841, 0x585d, 0x5879, 0x5895, 0x58b1, 0x58cd, 0x58e6, 0x5900,
	0x591a, 0x5934, 0x594e, 0x5968, 0x5982, 0x599c, 0x59b6, 0x59d0,
	0x59ea, 0x5a04, 0x5a1e, 0x5a38, 0x5a52, 0x5a6c, 0x5a86, 0x5aa0,
	0x5aba, 0x5ad4, 0x5aee, 0x5b08, 0x5b22, 0x5b3c, 0x5b56, 0x5b70,
	0x5b8a, 0x5ba4, 0x5bbe, 0x5bd8, 0x5bf2, 0x5c0c, 0x5c26, 0x5c40,
	0x5c5a, 0x5c74, 0x5c8e, 0x5ca8, 0x5cc2, 0x5cdc, 0x5cf6, 0x5d10,
	// Entry 7080 - 70BF
	0x5d2a, 0x5d44, 0x5d5e, 0x5d78, 0x5d92, 0x5dac, 0x5dc6, 0x5de0,
	0x5df1, 0x5e0b, 0x5e25, 0x5e41, 0x5e5c, 0x5e77, 0x5e91, 0x5ead,
	0x5ec9, 0x5ee4, 0x5efe, 0x5f19, 0x5f36, 0x5f52, 0x5f6d, 0x5f87,
	0x5fa1, 0x5fbd, 0x5fd8, 0x5ff3, 0x600d, 0x6029, 0x6045, 0x6060,
	0x607a, 0x6095, 0x60b2, 0x60ce, 0x60e9, 0x60ff, 0x611b, 0x6137,
	0x6155, 0x6172, 0x618f, 0x61ab, 0x61c9, 0x61e7, 0x6204, 0x6220,
	0x623d, 0x625c, 0x627a, 0x6297, 0x62af, 0x62c8, 0x62e1, 0x62fc,
	0x6316, 0x6330, 0x6349, 0x6364, 0x637f, 0x6399, 0x63b2, 0x63cc,
	// Entry 70C0 - 70FF
	0x63e8, 0x6403, 0x641d, 0x6435, 0x6446, 0x645a, 0x646e, 0x6482,
	0x6496, 0x64aa, 0x64be, 0x64d2, 0x64e6, 0x64fa, 0x650f, 0x6524,
	0x6539, 0x654e, 0x6563, 0x6578, 0x658d, 0x65a2, 0x65b7, 0x65cc,
	0x65e1, 0x65f6, 0x660a, 0x661a, 0x6629, 0x6638, 0x6649, 0x6659,
	0x6669, 0x6678, 0x6689, 0x669a, 0x66aa, 0x66cf, 0x66fd, 0x6721,
	0x6745, 0x6769, 0x678d, 0x67b1, 0x67d5, 0x67f9, 0x681d, 0x6841,
	0x6865, 0x6889, 0x68ad, 0x68d1, 0x68f5, 0x6919, 0x693d, 0x6961,
	0x6985, 0x69a9, 0x69cd, 0x69f1, 0x6a15, 0x6a39, 0x6a5d, 0x6a81,
	// Entry 7100 - 713F
	0x6aa5, 0x6ad4, 0x6af9, 0x6b1e, 0x6b28, 0x6b32, 0x6b50, 0x6b6e,
	0x6b8c, 0x6baa, 0x6bc8, 0x6be6, 0x6c04, 0x6c22, 0x6c40, 0x6c5e,
	0x6c7c, 0x6c9a, 0x6cb8, 0x6cd6, 0x6cf4, 0x6d12, 0x6d30, 0x6d4e,
	0x6d6c, 0x6d8a, 0x6da8, 0x6dc6, 0x6de4, 0x6e02, 0x6e20, 0x6e3e,
	0x6e48, 0x6e52, 0x6e5c, 0x6e66, 0x6e71, 0x6e7b, 0x6ea2, 0x6ec9,
	0x6ef0, 0x6f17, 0x6f3e, 0x6f65, 0x6f8c, 0x6fb3, 0x6fda, 0x7001,
	0x7028, 0x704f, 0x7076, 0x709d, 0x70c4, 0x70eb, 0x7112, 0x7139,
	0x7160, 0x7187, 0x71ae, 0x71d5, 0x71fc, 0x7223, 0x724a, 0x7271,
	// Entry 7140 - 717F
	0x727f, 0x728d, 0x72b4, 0x72db, 0x7302, 0x7329, 0x7350, 0x7377,
	0x739e, 0x73c5, 0x73ec, 0x7413, 0x743a, 0x7461, 0x7488, 0x74af,
	0x74d6, 0x74fd, 0x7524, 0x754b, 0x7572, 0x7599, 0x75c0, 0x75e7,
	0x760e, 0x7635, 0x765c, 0x7683, 0x76b2, 0x76c5, 0x76d8, 0x76eb,
	0x76fe, 0x7711, 0x771a, 0x7724, 0x7730, 0x773c, 0x7746, 0x7751,
	0x775b, 0x7765, 0x7770, 0x7790, 0x779a, 0x77a9, 0x77be, 0x77cb,
	0x77d9, 0x77e8, 0x77fe, 0x7815, 0x7831, 0x7840, 0x785c, 0x7878,
	0x7882, 0x788d, 0x789b, 0x78ab, 0x78b6, 0x78c1, 0x78cc, 0x78ee,
	// Entry 7180 - 71BF
	0x7910, 0x7932, 0x7954, 0x7976, 0x7998, 0x79ba, 0x79dc, 0x79fe,
	0x7a20, 0x7a42, 0x7a64, 0x7a86, 0x7aa8, 0x7aca, 0x7aec, 0x7b0e,
	0x7b30, 0x7b52, 0x7b74, 0x7b96, 0x7bb8, 0x7bda, 0x7bfc, 0x7c1e,
	0x7c40, 0x7c54, 0x7c69, 0x7c7c, 0x7c9e, 0x7cc0, 0x7ce2, 0x7cf5,
	0x7d17, 0x7d39, 0x7d5b, 0x7d7d, 0x7d9f, 0x7dc1, 0x7de3, 0x7e05,
	0x7e27, 0x7e49, 0x7e6b, 0x7e8d, 0x7eaf, 0x7ed1, 0x7ef3, 0x7f15,
	0x7f37, 0x7f59, 0x7f7b, 0x7f9d, 0x7fbf, 0x7fe1, 0x8003, 0x8025,
	0x8047, 0x8069, 0x808b, 0x80ad, 0x80cf, 0x80f1, 0x8113, 0x8135,
	// Entry 71C0 - 71FF
	0x8157, 0x8179, 0x819b, 0x81bd, 0x81df, 0x8201, 0x8223, 0x8245,
	0x8278, 0x82ab, 0x82de, 0x8311, 0x8344, 0x8377, 0x83aa, 0x83dd,
	0x8410, 0x842b, 0x8443, 0x8458, 0x846d, 0x8484, 0x8499, 0x84b4,
	0x84ca, 0x84d1, 0x84d6, 0x84e5, 0x84f5, 0x850b, 0x8512, 0x8523,
	0x8538, 0x853f, 0x854e, 0x8558, 0x855f, 0x8568, 0x8581, 0x8595,
	0x85af, 0x85c3, 0x85d2, 0x85ed, 0x8606, 0x8620, 0x8630, 0x864a,
	0x8662, 0x867d, 0x868a, 0x869c, 0x86b8, 0x86d3, 0x86e6, 0x86f3,
	0x86ff, 0x870c, 0x8717, 0x8724, 0x872d, 0x8747, 0x875d, 0x877d,
	// Entry 7200 - 723F
	0x878c, 0x879b, 0x87af, 0x87c1, 0x87c4, 0x87d5, 0x87dc, 0x87e0,
	0x87e7, 0x87ef, 0x87f7, 0x8805, 0x8813, 0x881c, 0x8822, 0x882c,
	0x8831, 0x883f, 0x8843, 0x884b, 0x8854, 0x885b, 0x8867, 0x8872,
	0x8876, 0x8886, 0x8890, 0x889b, 0x88b2, 0x88ba, 0x88c0, 0x88c9,
	0x88cf, 0x88d4, 0x88de, 0x88e7, 0x88ec, 0x88f2, 0x88fb, 0x8904,
	0x890f, 0x8913, 0x8918, 0x8920, 0x892a, 0x8933, 0x8941, 0x894d,
	0x8958, 0x8964, 0x896d, 0x8978, 0x8986, 0x8993, 0x899c, 0x89a1,
	0x89ad, 0x89c1, 0x89c6, 0x89ca, 0x89cf, 0x89db, 0x89f6, 0x8a04,
	// Entry 7240 - 727F
	0x8a0e, 0x8a17, 0x8a1f, 0x8a25, 0x8a32, 0x8a37, 0x8a3f, 0x8a46,
	0x8a4f, 0x8a58, 0x8a61, 0x8a6c, 0x8a73, 0x8a81, 0x8a96, 0x8aa9,
	0x8ab3, 0x8ac1, 0x8acf, 0x8ad7, 0x8ae9, 0x8af4, 0x8b0d, 0x8b25,
	0x8b2c, 0x8b32, 0x8b41, 0x8b4e, 0x8b5c, 0x8b6a, 0x8b7a, 0x8b83,
	0x8b94, 0x8b9b, 0x8ba7, 0x8bb4, 0x8bc1, 0x8bce, 0x8bdd, 0x8beb,
	0x8bf8, 0x8c02, 0x8c17, 0x8c25, 0x8c33, 0x8c4d, 0x8c5f, 0x8c6d,
	0x8c7c, 0x8c97, 0x8ca8, 0x8cb4, 0x8cc1, 0x8cdf, 0x8cfe, 0x8d09,
	0x8d1a, 0x8d28, 0x8d34, 0x8d42, 0x8d57, 0x8d61, 0x8d6d, 0x8d73,
	// Entry 7280 - 72BF
	0x8d7c, 0x8d8a, 0x8d91, 0x8d9c, 0x8da2, 0x8daf, 0x8dbe, 0x8dc8,
	0x8dd2, 0x8dde, 0x8de7, 0x8def, 0x8df6, 0x8e0a, 0x8e16, 0x8e2c,
	0x8e35, 0x8e3b, 0x8e4b, 0x8e52, 0x8e58, 0x8e65, 0x8e7c, 0x8e93,
	0x8ea3, 0x8eb6, 0x8ec4, 0x8ecf, 0x8ed5, 0x8edb, 0x8ee7, 0x8eed,
	0x8ef9, 0x8f0a, 0x8f18, 0x8f1f, 0x8f2c, 0x8f32, 0x8f43, 0x8f4d,
	0x8f61, 0x8f6b, 0x8f86, 0x8f9f, 0x8fbb, 0x8fcf, 0x8fd6, 0x8fe9,
	0x8ffe, 0x900d, 0x9016, 0x902d, 0x903f, 0x9045, 0x9052, 0x905f,
	0x9066, 0x9074, 0x9085, 0x9094, 0x90a8, 0x90bc, 0x90c4, 0x90c8,
	// Entry 72C0 - 72FF
	0x90e0, 0x90e5, 0x90ef, 0x9100, 0x9106, 0x9116, 0x911d, 0x912c,
	0x913b, 0x914a, 0x9157, 0x9164, 0x9175, 0x9186, 0x918d, 0x919a,
	0x919f, 0x91c0, 0x91cd, 0x91d4, 0x91f7, 0x9218, 0x9239, 0x925a,
	0x927b, 0x927e, 0x9283, 0x9285, 0x9292, 0x9295, 0x929a, 0x92a1,
	0x92a7, 0x92aa, 0x92b0, 0x92b9, 0x92be, 0x92c3, 0x92c8, 0x92cd,
	0x92d0, 0x92d4, 0x92d9, 0x92df, 0x92e6, 0x92ed, 0x92f0, 0x92f3,
	0x92f7, 0x92ff, 0x9306, 0x9312, 0x9315, 0x9318, 0x9320, 0x932b,
	0x932f, 0x933c, 0x9344, 0x934a, 0x9358, 0x9362, 0x9379, 0x937d,
	// Entry 7300 - 733F
	0x9384, 0x9389, 0x938f, 0x939e, 0x93ac, 0x93b3, 0x93bd, 0x93c5,
	0x93cf, 0x93da, 0x93e2, 0x93ed, 0x93fb, 0x9405, 0x9410, 0x9418,
	0x9420, 0x9429, 0x9435, 0x943e, 0x9447, 0x9451, 0x9459, 0x9463,
	0x946b, 0x946f, 0x9472, 0x9475, 0x9479, 0x947e, 0x9484, 0x94a4,
	0x94c6, 0x94e8, 0x950b, 0x951b, 0x952b, 0x9537, 0x9545, 0x9555,
	0x9568, 0x9577, 0x957c, 0x9586, 0x9590, 0x9597, 0x959e, 0x95a3,
	0x95a8, 0x95ae, 0x95b4, 0x95c2, 0x95c7, 0x95ce, 0x95d3, 0x95dc,
	0x95e9, 0x95f9, 0x9606, 0x9612, 0x961c, 0x962e, 0x9641, 0x9644,
	// Entry 7340 - 737F
	0x9648, 0x964b, 0x9650, 0x9656, 0x9671, 0x9686, 0x969d, 0x96ab,
	0x96c0, 0x96cf, 0x96e5, 0x96f8, 0x9707, 0x9710, 0x971b, 0x971f,
	0x9732, 0x973a, 0x9747, 0x9756, 0x975b, 0x9765, 0x977b, 0x9788,
	0x978b, 0x9790, 0x97a7, 0x97b0, 0x97b6, 0x97be, 0x97c9, 0x97d5,
	0x97dc, 0x97e7, 0x97ee, 0x97f2, 0x97fb, 0x9806, 0x980a, 0x9813,
	0x9817, 0x981e, 0x982f, 0x9836, 0x9843, 0x984f, 0x9859, 0x9868,
	0x9875, 0x9885, 0x988f, 0x989a, 0x98a6, 0x98b2, 0x98c3, 0x98d3,
	0x98e3, 0x9902, 0x9915, 0x9921, 0x9925, 0x9934, 0x9944, 0x995a,
	// Entry 7380 - 73BF
	0x9961, 0x996c, 0x9977, 0x9984, 0x9990, 0x999e, 0x99ad, 0x99b9,
	0x99ce, 0x99d7, 0x99e8, 0x99f9, 0x9a04, 0x9a1a, 0x9a33, 0x9a4a,
	0x9a62, 0x9a72, 0x9a97, 0x9a9b, 0x9aac, 0x9ab5, 0x9abd, 0x9ac8,
	0x9ad4, 0x9ad7, 0x9ae2, 0x9af2, 0x9b00, 0x9b0e, 0x9b16, 0x9b27,
	0x9b31, 0x9b49, 0x9b63, 0x9b6c, 0x9b75, 0x9b7c, 0x9b89, 0x9b92,
	0x9ba0, 0x9bb0, 0x9bbd, 0x9bc3, 0x9bcb, 0x9be9, 0x9bf4, 0x9bfd,
	0x9c07, 0x9c10, 0x9c1b, 0x9c20, 0x9c2a, 0x9c30, 0x9c34, 0x9c46,
	0x9c4b, 0x9c56, 0x9c67, 0x9c81, 0x9c93, 0x9c9e, 0x9ca8, 0x9caf,
	// Entry 73C0 - 73FF
	0x9cbc, 0x9ccd, 0x9cf0, 0x9d10, 0x9d2f, 0x9d4c, 0x9d6a, 0x9d71,
	0x9d7c, 0x9d85, 0x9d91, 0x9dbb, 0x9dc9, 0x9dd9, 0x9de9, 0x9dfa,
	0x9e00, 0x9e11, 0x9e1d, 0x9e27, 0x9e2c, 0x9e39, 0x9e47, 0x9e56,
	0x9e62, 0x9e7b, 0x9eb0, 0x9efe, 0x9f30, 0x9f66, 0x9f7b, 0x9f91,
	0x9fb1, 0x9fb8, 0x9fd3, 0x9ff1, 0x9ff8, 0xa005, 0xa023, 0xa042,
	0xa053, 0xa067, 0xa06a, 0xa06e, 0xa077, 0xa07b, 0xa098, 0xa0a0,
	0xa0ab, 0xa0b7, 0xa0d6, 0xa0f4, 0xa128, 0xa148, 0xa164, 0xa180,
	0xa18a, 0xa1b0, 0xa1d4, 0xa1ec, 0xa204, 0xa222, 0xa226, 0xa234,
	// Entry 7400 - 743F
	0xa23a, 0xa240, 0xa24c, 0xa251, 0xa257, 0xa261, 0xa26a, 0xa276,
	0xa296, 0xa2b2, 0xa2c0, 0xa2d3, 0xa2e6, 0xa2f6, 0xa307, 0xa31b,
	0xa32d, 0xa341, 0xa353, 0xa36b, 0xa385, 0xa3a3, 0xa3c3, 0xa3e4,
	0xa405, 0xa419, 0xa43c, 0xa448, 0xa46f, 0xa497, 0xa4af, 0xa4c0,
	0xa4d1, 0xa4dd, 0xa4e6, 0xa4f3, 0xa4f8, 0xa4fe, 0xa507, 0xa521,
	0xa530, 0xa545, 0xa55a, 0xa571, 0xa587, 0xa59d, 0xa5b2, 0xa5c9,
	0xa5e0, 0xa5f6, 0xa60b, 0xa623, 0xa63b, 0xa650, 0xa665, 0xa67c,
	0xa692, 0xa6a8, 0xa6bd, 0xa6d4, 0xa6eb, 0xa701, 0xa716, 0xa72e,
	// Entry 7440 - 747F
	0xa746, 0xa753, 0xa774, 0xa798, 0xa7a0, 0xa7b9, 0xa7c5, 0xa7c9,
	0xa7cf, 0xa7e0, 0xa7fa, 0xa803, 0xa807, 0xa826, 0xa833, 0xa842,
	0xa848, 0xa852, 0xa85a, 0xa865, 0xa881, 0xa89d, 0xa8ba, 0xa8d3,
	0xa8ec, 0xa905, 0xa91b, 0xa92b, 0xa93b, 0xa952, 0xa961, 0xa97a,
	0xa98b, 0xa998, 0xa9a9, 0xa9c1, 0xa9d8, 0xa9ed, 0xa9fe, 0xaa0f,
	0xaa22, 0xaa42, 0xaa6b, 0xaa82, 0xaa9b, 0xaab0, 0xaad9, 0xab0e,
	0xab31, 0xab53, 0xab76, 0xab98, 0xabbb, 0xabdd, 0xac00, 0xac20,
	0xac42, 0xac62, 0xac84, 0xaca4, 0xacc6, 0xacd1, 0xace1, 0xacf3,
	// Entry 7480 - 74BF
	0xad0c, 0xad13, 0xad24, 0xad40, 0xad5c, 0xad72, 0xad80, 0xad8e,
	0xad9e, 0xadae, 0xadc0, 0xadc9, 0xadde, 0xade7, 0xaded, 0xadf9,
	0xae01, 0xae12, 0xae24, 0xae42, 0xae57, 0xae69, 0xae79, 0xae88,
	0xae94, 0xae9a, 0xaea5, 0xaeb8, 0xaec5, 0xaed1, 0xaedb, 0xaeea,
	0xaef8, 0xaefc, 0xaf05, 0xaf0d, 0xaf1b, 0xaf25, 0xaf30, 0xaf38,
	0xaf3c, 0xaf41, 0xaf4c, 0xaf5b, 0xaf6e, 0xaf7c, 0xaf84, 0xaf8c,
	0xaf93, 0xafbd, 0xafcb, 0xafe4, 0xaffd, 0xb008, 0xb00f, 0xb022,
	0xb038, 0xb043, 0xb04f, 0xb053, 0xb06e, 0xb07e, 0xb08e, 0xb09d,
	// Entry 74C0 - 74FF
	0xb0ad, 0xb0bf, 0xb0d2, 0xb0e4, 0xb0f8, 0xb10b, 0xb11f, 0xb130,
	0xb142, 0xb14d, 0xb162, 0xb170, 0xb186, 0xb195, 0xb1ad, 0xb1c1,
	0xb1de, 0xb1ee, 0xb208, 0xb211, 0xb21b, 0xb226, 0xb237, 0xb24a,
	0xb24f, 0xb25c, 0xb27b, 0xb291, 0xb2ad, 0xb2da, 0xb305, 0xb339,
	0xb34f, 0xb366, 0xb372, 0xb390, 0xb3ad, 0xb3ba, 0xb3dd, 0xb3f9,
	0xb406, 0xb412, 0xb425, 0xb432, 0xb446, 0xb452, 0xb45f, 0xb46e,
	0xb47a, 0xb48e, 0xb4ac, 0xb4c9, 0xb4e3, 0xb50d, 0xb53f, 0xb550,
	0xb55c, 0xb566, 0xb572, 0xb57d, 0xb58d, 0xb5a6, 0xb5c4, 0xb5e1,
	// Entry 7500 - 753F
	0xb5ef, 0xb5fb, 0xb605, 0xb610, 0xb61a, 0xb628, 0xb63a, 0xb64e,
	0xb659, 0xb67c, 0xb692, 0xb6a1, 0xb6ad, 0xb6ba, 0xb6c4, 0xb6d6,
	0xb6ec, 0xb70f, 0xb729, 0xb749, 0xb770, 0xb787, 0xb7a8, 0xb7b8,
	0xb7c7, 0xb7d5, 0xb7eb, 0xb800, 0xb810, 0xb826, 0xb83f, 0xb853,
	0xb867, 0xb879, 0xb88c, 0xb8a0, 0xb8bd, 0xb8e5, 0xb8f4, 0xb90c,
	0xb924, 0xb93c, 0xb954, 0xb96c, 0xb984, 0xb9a3, 0xb9c2, 0xb9e1,
	0xba00, 0xba1d, 0xba3a, 0xba57, 0xba74, 0xba97, 0xbaba, 0xbadd,
	0xbb00, 0xbb17, 0xbb2e, 0xbb45, 0xbb5c, 0xbb79, 0xbb96, 0xbbb3,
	// Entry 7540 - 757F
	0xbbd0, 0xbbec, 0xbc18, 0xbc33, 0xbc5e, 0xbc6e, 0xbc7c, 0xbc8d,
	0xbc9d, 0xbcb8, 0xbcd9, 0xbcf2, 0xbd11, 0xbd29, 0xbd41, 0xbd7d,
	0xbdb2, 0xbdeb, 0xbe05, 0xbe24, 0xbe49, 0xbe5b, 0xbe75, 0xbe82,
	0xbe97, 0xbe9d, 0xbea7, 0xbeb7, 0xbec2, 0xbed2, 0xbef3, 0xbef8,
	0xbefd, 0xbf07, 0xbf0e, 0xbf12, 0xbf1a, 0xbf1d, 0xbf29, 0xbf33,
	0xbf3b, 0xbf42, 0xbf4b, 0xbf56, 0xbf60, 0xbf73, 0xbf77, 0xbf84,
	0xbf8e, 0xbfa1, 0xbfb5, 0xbfc3, 0xbfd4, 0xbfdb, 0xbfe3, 0xbff3,
	0xc005, 0xc016, 0xc024, 0xc028, 0xc02f, 0xc038, 0xc050, 0xc066,
	// Entry 7580 - 75BF
	0xc077, 0xc092, 0xc0a9, 0xc0ad, 0xc0ba, 0xc0c8, 0xc0d9, 0xc0f7,
	0xc10b, 0xc11f, 0xc137, 0xc13e, 0xc149, 0xc152, 0xc164, 0xc16e,
	0xc17c, 0xc18d, 0xc198, 0xc1a5, 0xc1ad, 0xc1b8, 0xc1be, 0xc1ca,
	0xc1d0, 0xc1d4, 0xc1db, 0xc1eb, 0xc1f2, 0xc1ff, 0xc20b, 0xc228,
	0xc237, 0xc251, 0xc25c, 0xc268, 0xc276, 0xc28c, 0xc299, 0xc2a5,
	0xc2a8, 0xc2b8, 0xc2c6, 0xc2d6, 0xc2db, 0xc2e1, 0xc2f2, 0xc2f8,
	0xc300, 0xc308, 0xc315, 0xc31f, 0xc33c, 0xc350, 0xc36a, 0xc378,
	0xc393, 0xc3a5, 0xc3b6, 0xc3bf, 0xc3d3, 0xc3e4, 0xc3f2, 0xc3f9,
	// Entry 75C0 - 75FF
	0xc406, 0xc40b, 0xc40f, 0xc41c, 0xc43e, 0xc457, 0xc471, 0xc48c,
	0xc4a7, 0xc4c7, 0xc4e7, 0xc509, 0xc529, 0xc54b, 0xc568, 0xc587,
	0xc5a6, 0xc5c2, 0xc5eb, 0xc60d, 0xc634, 0xc65d, 0xc686, 0xc6a4,
	0xc6be, 0xc6d9, 0xc6f6, 0xc715, 0xc734, 0xc755, 0xc76f, 0xc78b,
	0xc7a9, 0xc7c9, 0xc7ed, 0xc812, 0xc832, 0xc857, 0xc880, 0xc8a6,
	0xc8ce, 0xc8f6, 0xc926, 0xc957, 0xc976, 0xc993, 0xc9b1, 0xc9d3,
	0xc9fe, 0xca24, 0xca57, 0xca80, 0xcaa9, 0xcad4, 0xcaf1, 0xcb10,
	0xcb2f, 0xcb4e, 0xcb6a, 0xcb88, 0xcba7, 0xcbc9, 0xcbe6, 0xcc03,
	// Entry 7600 - 763F
	0xcc22, 0xcc43, 0xcc64, 0xcc80, 0xcc9e, 0xccbe, 0xccd9, 0xccf6,
	0xcd13, 0xcd2d, 0xcd46, 0xcd62, 0xcd80, 0xcd99, 0xcdb2, 0xcdce,
	0xcde8, 0xce03, 0xce26, 0xce4b, 0xce69, 0xce86, 0xceab, 0xceca,
	0xcee4, 0xceff, 0xcf1f, 0xcf3a, 0xcf59, 0xcf74, 0xcf98, 0xcfb5,
	0xcfe0, 0xd00d, 0xd02e, 0xd04f, 0xd06c, 0xd08a, 0xd0aa, 0xd0c6,
	0xd0e8, 0xd106, 0xd126, 0xd146, 0xd166, 0xd186, 0xd1a3, 0xd1c5,
	0xd1ea, 0xd206, 0xd220, 0xd23b, 0xd25a, 0xd275, 0xd294, 0xd2b4,
	0xd2e0, 0xd30a, 0xd337, 0xd363, 0xd37e, 0xd396, 0xd3a7, 0xd3b9,
	// Entry 7640 - 767F
	0xd3d0, 0xd3ec, 0xd416, 0xd422, 0xd433, 0xd44e, 0xd460, 0xd473,
	0xd484, 0xd496, 0xd4ad, 0xd4c9, 0xd4f8, 0xd523, 0xd530, 0xd542,
	0xd55a, 0xd574, 0xd5a5, 0xd5d2, 0xd5e0, 0xd5f2, 0xd60a, 0xd624,
	0xd650, 0xd660, 0xd671, 0xd683, 0xd693, 0xd6a8, 0xd6be, 0xd6d9,
	0xd6e5, 0xd6f2, 0xd700, 0xd70c, 0xd719, 0xd72b, 0xd742, 0xd75c,
	0xd777, 0xd790, 0xd7aa, 0xd7c9, 0xd7ed, 0xd806, 0xd820, 0xd838,
	0xd851, 0xd86f, 0xd892, 0xd8ad, 0xd8c9, 0xd8e3, 0xd8fe, 0xd91e,
	0xd93c, 0xd95b, 0xd973, 0xd995, 0xd9b2, 0xd9d0, 0xd9e7, 0xda08,
	// Entry 7680 - 76BF
	0xda30, 0xda4d, 0xda6a, 0xda87, 0xdaa3, 0xdabc, 0xdadb, 0xdaf9,
	0xdb1c, 0xdb3d, 0xdb5c, 0xdb7b, 0xdb9d, 0xdbca, 0xdbf5, 0xdc23,
	0xdc50, 0xdc7e, 0xdcaa, 0xdcd9, 0xdd07, 0xdd34, 0xdd5f, 0xdd8d,
	0xddba, 0xddea, 0xde18, 0xde49, 0xde79, 0xdea3, 0xdecb, 0xdef6,
	0xdf20, 0xdf50, 0xdf7e, 0xdfaf, 0xdfdf, 0xe015, 0xe049, 0xe080,
	0xe0b6, 0xe0e7, 0xe116, 0xe148, 0xe179, 0xe1aa, 0xe1d9, 0xe20b,
	0xe23c, 0xe26b, 0xe298, 0xe2c8, 0xe2f7, 0xe327, 0xe355, 0xe386,
	0xe3b6, 0xe3eb, 0xe41e, 0xe454, 0xe489, 0xe4a4, 0xe4bd, 0xe4d9,
	// Entry 76C0 - 76FF
	0xe4f4, 0xe50b, 0xe520, 0xe538, 0xe54f, 0xe569, 0xe581, 0xe59c,
	0xe5b6, 0xe5d6, 0xe5f4, 0xe615, 0xe635, 0xe64a, 0xe65d, 0xe673,
	0xe688, 0xe6a2, 0xe6ba, 0xe6d5, 0xe6ef, 0xe70a, 0xe725, 0xe740,
	0xe75b, 0xe776, 0xe78e, 0xe7b4, 0xe7d8, 0xe7ff, 0xe825, 0xe84c,
	0xe873, 0xe89a, 0xe8c1, 0xe8e1, 0xe8ff, 0xe920, 0xe940, 0xe961,
	0xe982, 0xe9a3, 0xe9c4, 0xe9eb, 0xea10, 0xea38, 0xea5f, 0xea87,
	0xeaaf, 0xead7, 0xeaff, 0xeb25, 0xeb49, 0xeb70, 0xeb96, 0xebbd,
	0xebe4, 0xec0b, 0xec32, 0xec5d, 0xec86, 0xecb2, 0xecdd, 0xed09,
	// Entry 7700 - 773F
	0xed35, 0xed61, 0xed8d, 0xeda9, 0xedc3, 0xede0, 0xedfc, 0xee2b,
	0xee58, 0xee88, 0xeeb7, 0xeed8, 0xeef7, 0xef19, 0xef3a, 0xef55,
	0xef77, 0xef97, 0xefb8, 0xefdb, 0xefff, 0xf01f, 0xf040, 0xf061,
	0xf084, 0xf0a6, 0xf0c8, 0xf0f2, 0xf11d, 0xf148, 0xf174, 0xf18f,
	0xf1b1, 0xf1d4, 0xf1f6, 0xf20a, 0xf229, 0xf249, 0xf267, 0xf280,
	0xf290, 0xf2a4, 0xf2c0, 0xf2dd, 0xf302, 0xf313, 0xf323, 0xf338,
	0xf341, 0xf34e, 0xf364, 0xf36e, 0xf37a, 0xf38b, 0xf397, 0xf3aa,
	0xf3ba, 0xf3cb, 0xf3d4, 0xf3fe, 0xf412, 0xf426, 0xf430, 0xf43e,
	// Entry 7740 - 777F
	0xf45b, 0xf468, 0xf472, 0xf47b, 0xf488, 0xf4a4, 0xf4c0, 0xf4ee,
	0xf513, 0xf53b, 0xf571, 0xf58e, 0xf5ae, 0xf5bc, 0xf5ca, 0xf5db,
	0xf5e1, 0xf5e7, 0xf5f4, 0xf604, 0xf609, 0xf61f, 0xf627, 0xf62d,
	0xf63e, 0xf647, 0xf651, 0xf659, 0xf666, 0xf67a, 0xf68a, 0xf697,
	0xf69c, 0xf6a4, 0xf6a9, 0xf6ba, 0xf6cc, 0xf6dd, 0xf6e9, 0xf6fd,
	0xf70a, 0xf713, 0xf71a, 0xf722, 0xf727, 0xf72d, 0xf733, 0xf741,
	0xf74c, 0xf75f, 0xf770, 0xf773, 0xf780, 0xf787, 0xf790, 0xf798,
	0xf7a0, 0xf7ae, 0xf7b9, 0xf7c3, 0xf7d2, 0xf7e0, 0xf7e7, 0xf7ef,
	// Entry 7780 - 77BF
	0xf7f2, 0xf7f9, 0xf804, 0xf80c, 0xf817, 0xf81b, 0xf824, 0xf82c,
	0xf832, 0xf83e, 0xf843, 0xf847, 0xf84a, 0xf84f, 0xf852, 0xf85a,
	0xf863, 0xf867, 0xf86e, 0xf874, 0xf87e, 0xf884, 0xf889, 0xf895,
	0xf89f, 0xf8a7, 0xf8af, 0xf8b4, 0xf8bb, 0xf8c7, 0xf8d8, 0xf8dd,
	0xf8e2, 0xf8ed, 0xf8fb, 0xf910, 0xf925, 0xf934, 0xf94c, 0xf950,
	0xf955, 0xf95c, 0xf965, 0xf968, 0xf96d, 0xf973, 0xf978, 0xf984,
	0xf98e, 0xf993, 0xf999, 0xf99d, 0xf9a2, 0xf9c3, 0xf9e4, 0xfa05,
	0xfa26, 0xfa47, 0xfa68, 0xfa89, 0xfaaa, 0xfacb, 0xfaec, 0xfb0d,
	// Entry 77C0 - 77FF
	0xfb2e, 0xfb4f, 0xfb70, 0xfb91, 0xfbb2, 0xfbd3, 0xfbf4, 0xfc15,
	0xfc36, 0xfc57, 0xfc78, 0xfc99, 0xfcba, 0xfcdb, 0xfcfc, 0xfd1d,
	0xfd3e, 0xfd5f, 0xfd80, 0xfda1, 0xfdc2, 0xfde3, 0xfe04, 0xfe25,
	0xfe46, 0xfe67, 0xfe88, 0xfea9, 0xfeca, 0xfeeb, 0xff0c, 0xff2d,
	0xff4e, 0xff6f, 0xff90, 0xffb1, 0xffd2, 0xfff3, 0x0014, 0x0035,
	0x0056, 0x0077, 0x0098, 0x00b9, 0x00da, 0x00fb, 0x011c, 0x013d,
	0x015e, 0x017f, 0x01a0, 0x01c1, 0x01e2, 0x0203, 0x0224, 0x0245,
	0x0266, 0x0287, 0x02a8, 0x02c9, 0x02ea, 0x030b, 0x032c, 0x034d,
	// Entry 7800 - 783F
	0x036e, 0x038f, 0x03b0, 0x03d1, 0x03f2, 0x0413, 0x0434, 0x0455,
	0x0476, 0x0497, 0x04b8, 0x04d9, 0x04fa, 0x051b, 0x053c, 0x055d,
	0x057e, 0x059f, 0x05c0, 0x05e1, 0x0602, 0x0623, 0x0644, 0x0665,
	0x0686, 0x06a7, 0x06c8, 0x06e9, 0x070a, 0x072b, 0x074c, 0x076d,
	0x078e, 0x07af, 0x07d0, 0x07f1, 0x0812, 0x0833, 0x0854, 0x0875,
	0x0896, 0x08b7, 0x08d8, 0x08f9, 0x091a, 0x093b, 0x095c, 0x097d,
	0x099e, 0x09bf, 0x09e0, 0x0a01, 0x0a22, 0x0a43, 0x0a64, 0x0a85,
	0x0aa6, 0x0ac7, 0x0ae8, 0x0b09, 0x0b2a, 0x0b4b, 0x0b6c, 0x0b8d,
	// Entry 7840 - 787F
	0x0bae, 0x0bcf, 0x0bf0, 0x0c11, 0x0c32, 0x0c53, 0x0c74, 0x0c95,
	0x0cb6, 0x0cd7, 0x0cf8, 0x0d19, 0x0d3a, 0x0d5b, 0x0d7c, 0x0d9d,
	0x0dbe, 0x0ddf, 0x0e00, 0x0e21, 0x0e42, 0x0e63, 0x0e84, 0x0ea5,
	0x0ec6, 0x0ee7, 0x0f08, 0x0f29, 0x0f4a, 0x0f6b, 0x0f8c, 0x0fad,
	0x0fce, 0x0fef, 0x1010, 0x1031, 0x1052, 0x1073, 0x1094, 0x10b5,
	0x10d6, 0x10f7, 0x1118, 0x1139, 0x115a, 0x117b, 0x119c, 0x11bd,
	0x11de, 0x11ff, 0x1220, 0x1241, 0x1262, 0x1283, 0x12a4, 0x12c5,
	0x12e6, 0x1307, 0x1328, 0x1349, 0x136a, 0x138b, 0x13ac, 0x13cd,
	// Entry 7880 - 78BF
	0x13ee, 0x140f, 0x1430, 0x1451, 0x1472, 0x1493, 0x14b4, 0x14d5,
	0x14f6, 0x1517, 0x1538, 0x1559, 0x157a, 0x159b, 0x15bc, 0x15dd,
	0x15fe, 0x161f, 0x1640, 0x1661, 0x1682, 0x16a3, 0x16c4, 0x16e5,
	0x1706, 0x1727, 0x1748, 0x1769, 0x178a, 0x17ab, 0x17cc, 0x17ed,
	0x180e, 0x182f, 0x1850, 0x1871, 0x1892, 0x18b3, 0x18d4, 0x18f5,
	0x1916, 0x1937, 0x1958, 0x1979, 0x199a, 0x19bb, 0x19dc, 0x19fd,
	0x1a1e, 0x1a3f, 0x1a60, 0x1a81, 0x1aa2, 0x1ac3, 0x1ae4, 0x1b05,
	0x1b26, 0x1b47, 0x1b68, 0x1b89, 0x1baa, 0x1bcb, 0x1bec, 0x1c0d,
	// Entry 78C0 - 78FF
	0x1c2e, 0x1c4f, 0x1c70, 0x1c91, 0x1cb2, 0x1cd3, 0x1cf4, 0x1d15,
	0x1d36, 0x1d57, 0x1d78, 0x1d99, 0x1dba, 0x1ddb, 0x1dfc, 0x1e1d,
	0x1e3e, 0x1e5f, 0x1e80, 0x1ea1, 0x1ec2, 0x1ee3, 0x1f04, 0x1f25,
	0x1f46, 0x1f67, 0x1f88, 0x1fa9, 0x1fca, 0x1feb, 0x200c, 0x202d,
	0x204e, 0x206f, 0x2090, 0x20b1, 0x20d2, 0x20f3, 0x2114, 0x2135,
	0x2156, 0x2177, 0x2198, 0x21b9, 0x21da, 0x21fb, 0x221c, 0x223d,
	0x225e, 0x227f, 0x22a0, 0x22c1, 0x22e2, 0x2303, 0x2324, 0x2345,
	0x2366, 0x2387, 0x23a8, 0x23c9, 0x23ea, 0x240b, 0x242c, 0x244d,
	// Entry 7900 - 793F
	0x246e, 0x248f, 0x24b0, 0x24d1, 0x24f2, 0x2513, 0x2534, 0x2555,
	0x2576, 0x2597, 0x25b8, 0x25d9, 0x25fa, 0x261b, 0x263c, 0x265d,
	0x267e, 0x269f, 0x26c0, 0x26e1, 0x2702, 0x2723, 0x2744, 0x2765,
	0x2786, 0x27a7, 0x27c8, 0x27e9, 0x280a, 0x282b, 0x284c, 0x286d,
	0x288e, 0x28af, 0x28d0, 0x28f1, 0x2912, 0x2933, 0x2954, 0x2975,
	0x2996, 0x29b7, 0x29d8, 0x29f9, 0x2a1a, 0x2a3b, 0x2a5c, 0x2a7d,
	0x2a9e, 0x2abf, 0x2ae0, 0x2b01, 0x2b22, 0x2b43, 0x2b64, 0x2b85,
	0x2ba6, 0x2bc7, 0x2be8, 0x2c09, 0x2c2a, 0x2c4b, 0x2c6c, 0x2c8d,
	// Entry 7940 - 797F
	0x2cae, 0x2ccf, 0x2cf0, 0x2d11, 0x2d32, 0x2d53, 0x2d74, 0x2d95,
	0x2db6, 0x2dd7, 0x2df8, 0x2e19, 0x2e3a, 0x2e5b, 0x2e7c, 0x2e9d,
	0x2ebe, 0x2edf, 0x2f00, 0x2f21, 0x2f42, 0x2f63, 0x2f84, 0x2fa5,
	0x2fc6, 0x2fe7, 0x3008, 0x3029, 0x304a, 0x306b, 0x308c, 0x30ad,
	0x30ce, 0x30ef, 0x3110, 0x3131, 0x3152, 0x3173, 0x3194, 0x31b5,
	0x31d6, 0x31f7, 0x3218, 0x3239, 0x325a, 0x327b, 0x329c, 0x32bd,
	0x32de, 0x32ff, 0x3320, 0x3341, 0x3362, 0x3383, 0x33a4, 0x33c5,
	0x33e6, 0x3407, 0x3428, 0x3449, 0x346a, 0x348b, 0x34ac, 0x34cd,
	// Entry 7980 - 79BF
	0x34ee, 0x350f, 0x3530, 0x3551, 0x3572, 0x3593, 0x35b4, 0x35d5,
	0x35f6, 0x3617, 0x3638, 0x3659, 0x367a, 0x369b, 0x36bc, 0x36dd,
	0x36fe, 0x371f, 0x3740, 0x3761, 0x3782, 0x37a3, 0x37c4, 0x37e5,
	0x3806, 0x3827, 0x3848, 0x3869, 0x388a, 0x38ab, 0x38cc, 0x38ed,
	0x390e, 0x392f, 0x3950, 0x3971, 0x3992, 0x39b3, 0x39d4, 0x39f5,
	0x3a16, 0x3a37, 0x3a58, 0x3a79, 0x3a9a, 0x3abb, 0x3adc, 0x3afd,
	0x3b1e, 0x3b3f, 0x3b60, 0x3b81, 0x3ba2, 0x3bc3, 0x3be4, 0x3c05,
	0x3c26, 0x3c47, 0x3c68, 0x3c89, 0x3caa, 0x3ccb, 0x3cec, 0x3d0d,
	// Entry 79C0 - 79FF
	0x3d2e, 0x3d4f, 0x3d70, 0x3d91, 0x3db2, 0x3dd3, 0x3df4, 0x3e15,
	0x3e36, 0x3e57, 0x3e78, 0x3e99, 0x3eba, 0x3edb, 0x3efc, 0x3f1d,
	0x3f3e, 0x3f5f, 0x3f80, 0x3f8c, 0x3f95, 0x3fa9, 0x3fbb, 0x3fca,
	0x3fd9, 0x3fe9, 0x3ff6, 0x4004, 0x4018, 0x402d, 0x4039, 0x4046,
	0x404f, 0x405f, 0x406c, 0x4077, 0x4085, 0x4092, 0x409f, 0x40ae,
	0x40bc, 0x40ca, 0x40d7, 0x40e6, 0x40f5, 0x4103, 0x410c, 0x4119,
	0x412b, 0x413a, 0x414f, 0x4160, 0x4171, 0x418b, 0x41a5, 0x41bf,
	0x41d9, 0x41f3, 0x420d, 0x4227, 0x4241, 0x425b, 0x4275, 0x428f,
	// Entry 7A00 - 7A3F
	0x42a9, 0x42c3, 0x42dd, 0x42f7, 0x4311, 0x432b, 0x4345, 0x435f,
	0x4379, 0x4393, 0x43ad, 0x43c7, 0x43e1, 0x43fb, 0x4415, 0x442c,
	0x443f, 0x4457, 0x446c, 0x4478, 0x4488, 0x44a0, 0x44b8, 0x44d0,
	0x44e8, 0x4500, 0x4518, 0x4530, 0x4548, 0x4560, 0x4578, 0x4590,
	0x45a8, 0x45c0, 0x45d8, 0x45f0, 0x4608, 0x4620, 0x4638, 0x4650,
	0x4668, 0x4680, 0x4698, 0x46b0, 0x46c8, 0x46e0, 0x46f8, 0x470e,
	0x471f, 0x4736, 0x473f, 0x4749, 0x475e, 0x4773, 0x4788, 0x479d,
	0x47b2, 0x47c7, 0x47dc, 0x47f1, 0x4806, 0x481b, 0x4830, 0x4845,
	// Entry 7A40 - 7A7F
	0x485a, 0x486f, 0x4884, 0x4899, 0x48ae, 0x48c3, 0x48d8, 0x48ed,
	0x4902, 0x4917, 0x492c, 0x4941, 0x4956, 0x496b, 0x4980, 0x4995,
	0x49aa, 0x49bf, 0x49d4, 0x49e9, 0x49fe, 0x4a13, 0x4a28, 0x4a3d,
	0x4a52, 0x4a67, 0x4a7c, 0x4a91, 0x4aa6, 0x4abb, 0x4ad0, 0x4ae5,
	0x4afa, 0x4b0f, 0x4b24, 0x4b39, 0x4b4e, 0x4b63, 0x4b78, 0x4b8d,
	0x4ba2, 0x4bb7, 0x4bcc, 0x4be1, 0x4bf6, 0x4c0b, 0x4c20, 0x4c35,
	0x4c4a, 0x4c5f, 0x4c74, 0x4c89, 0x4c9e, 0x4cb3, 0x4cc8, 0x4cdd,
	0x4cf2, 0x4d07, 0x4d1c, 0x4d31, 0x4d46, 0x4d5b, 0x4d70, 0x4d85,
	// Entry 7A80 - 7ABF
	0x4d9a, 0x4daf, 0x4dc4, 0x4dd9, 0x4dee, 0x4e03, 0x4e18, 0x4e2e,
	0x4e44, 0x4e5a, 0x4e70, 0x4e86, 0x4e9c, 0x4eb2, 0x4ec8, 0x4ede,
	0x4ef4, 0x4f0a, 0x4f20, 0x4f36, 0x4f4c, 0x4f62, 0x4f78, 0x4f8e,
	0x4fa4, 0x4fba, 0x4fd0, 0x4fe6, 0x4ffc, 0x5012, 0x5028, 0x503e,
	0x5054, 0x506a, 0x5080, 0x5096, 0x50ac, 0x50c2, 0x50d8, 0x50ee,
	0x5104, 0x511a, 0x5130, 0x5146, 0x515c, 0x5172, 0x5188, 0x519e,
	0x51b4, 0x51ca, 0x51e0, 0x51f6, 0x520c, 0x5222, 0x5238, 0x524e,
	0x5264, 0x527a, 0x5290, 0x52a6, 0x52bc, 0x52d2, 0x52e8, 0x52fe,
	// Entry 7AC0 - 7AFF
	0x5314, 0x532a, 0x5340, 0x5356, 0x536c, 0x5382, 0x5398, 0x53ae,
	0x53c4, 0x53da, 0x53f0, 0x5406, 0x541c, 0x5432, 0x5448, 0x545e,
	0x5474, 0x548a, 0x54a0, 0x54b6, 0x54cc, 0x54e2, 0x54f8, 0x550e,
	0x5524, 0x553a, 0x5550, 0x5566, 0x557c, 0x5592, 0x55a8, 0x55be,
	0x55d4, 0x55ea, 0x5600, 0x5616, 0x562c, 0x5642, 0x5658, 0x566e,
	0x5684, 0x569a, 0x56b0, 0x56c6, 0x56dc, 0x56f2, 0x5708, 0x571e,
	0x5734, 0x574a, 0x5760, 0x5776, 0x578c, 0x57a2, 0x57b8, 0x57ce,
	0x57e4, 0x57fa, 0x5810, 0x5826, 0x583c, 0x5852, 0x5868, 0x587e,
	// Entry 7B00 - 7B3F
	0x5894, 0x58aa, 0x58c0, 0x58d6, 0x58ec, 0x5902, 0x5918, 0x592e,
	0x5944, 0x595a, 0x5970, 0x5986, 0x599c, 0x59b2, 0x59c8, 0x59de,
	0x59f4, 0x5a0a, 0x5a20, 0x5a36, 0x5a4c, 0x5a62, 0x5a78, 0x5a8e,
	0x5aa4, 0x5aba, 0x5ad0, 0x5ae6, 0x5afc, 0x5b12, 0x5b28, 0x5b3e,
	0x5b54, 0x5b6a, 0x5b80, 0x5b96,
} // Size: 63072 bytes

const directData string = "" + // Size: 353 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph><Hangul Syllable><Low Surrogate><Non Pr" +
	"ivate Use High Surrogate><Plane 15 Private Use><Plane 16 Private Use><Pr" +
	"ivate Use High Surrogate><Private Use><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 809878 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER AYBARMENIAN SMALL LETTER BENARMENIAN SMALL LETTE" +
	"R GIMARMENIAN SMALL LETTER DAARMENIAN SMALL LETTER ECHARMENIAN SMALL LET" +
	"TER ZAARMENIAN SMALL LETTER EHARMENIAN SMALL LETTER ETARMENIAN SMALL LET" +
	"TER TOARMENIAN SMALL LETTER ZHEARMENIAN SMALL LETTER INIARMENIAN SMALL L" +
	"ETTER LIWNARMENIAN SMALL LETTER XEHARMENIAN SMALL LETTER CAARMENIAN SMAL" +
	"L LETTER KENARMENIAN SMALL LETTER HOARMENIAN SMALL LETTER JAARMENIAN SMA" +
	"LL LETTER GHADARMENIAN SMALL LETTER CHEHARMENIAN SMALL LETTER MENARMENIA" +
	"N SMALL LETTER YIARMENIAN SMALL LETTER NOWARMENIAN SMALL LETTER SHAARMEN" +
	"IAN SMALL LETTER VOARMENIAN SMALL LETTER CHAARMENIAN SMALL LETTER PEHARM" +
	"ENIAN SMALL LETTER JHEHARMENIAN SMALL LETTER RAARMENIAN SMALL LETTER SEH" +
	"ARMENIAN SMALL LETTER VEWARMENIAN SMALL LETTER TIWNARMENIAN SMALL LETTER" +
	" REHARMENIAN SMALL LETTER COARMENIAN SMALL LETTER YIWNARMENIAN SMALL LET" +
	"TER PIWRARMENIAN SMALL LETTER KEHARMENIAN SMALL LETTER OHARMENIAN SMALL " +
	"LETTER FEHARMENIAN SMALL LIGATURE ECH YIWNARMENIAN FULL STOPARMENIAN HYP" +
	"HENRIGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGN" +
	"ARMENIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT " +
	"SHALSHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCEN" +
	"T TIPEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW" +
	" ACCENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH" +
	" MUQDAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TEL" +
	"ISHA GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MU" +
	"NAHHEBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULA" +
	"HEBREW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW" +
	" ACCENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT D" +
	"EHIHEBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW " +
	"POINT HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW" +
	" POINT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW" +
	" POINT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW PO" +
	"INT QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATI" +
	"ON MAQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHE" +
	"BREW POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBRE" +
	"W MARK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANH" +
	"EBREW LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALET" +
	"HEBREW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEB" +
	"REW LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFH" +
	"EBREW LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER " +
	"FINAL NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW L" +
	"ETTER FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSA" +
	"DIHEBREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAV" +
	"HEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH VAV YODHEBREW ") + ("" +
	"LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBREW PUNCTUATION G" +
	"ERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOTE MARKERARABIC " +
	"SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABIC-INDIC CUBE RO" +
	"OTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILLE SIGNARABIC-IN" +
	"DIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC DATE SEPARATORAR" +
	"ABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLALLAHOU ALAYHE WA" +
	"SSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH ALAYHEARABIC S" +
	"IGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HIGH TAHARABIC SM" +
	"ALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH ZAINARABIC SMA" +
	"LL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICOLONARABIC LETTE" +
	"R MARKARABIC TRIPLE DOT PUNCTUATION MARKARABIC QUESTION MARKARABIC LETTE" +
	"R KASHMIRI YEHARABIC LETTER HAMZAARABIC LETTER ALEF WITH MADDA ABOVEARAB" +
	"IC LETTER ALEF WITH HAMZA ABOVEARABIC LETTER WAW WITH HAMZA ABOVEARABIC " +
	"LETTER ALEF WITH HAMZA BELOWARABIC LETTER YEH WITH HAMZA ABOVEARABIC LET" +
	"TER ALEFARABIC LETTER BEHARABIC LETTER TEH MARBUTAARABIC LETTER TEHARABI" +
	"C LETTER THEHARABIC LETTER JEEMARABIC LETTER HAHARABIC LETTER KHAHARABIC" +
	" LETTER DALARABIC LETTER THALARABIC LETTER REHARABIC LETTER ZAINARABIC L" +
	"ETTER SEENARABIC LETTER SHEENARABIC LETTER SADARABIC LETTER DADARABIC LE" +
	"TTER TAHARABIC LETTER ZAHARABIC LETTER AINARABIC LETTER GHAINARABIC LETT" +
	"ER KEHEH WITH TWO DOTS ABOVEARABIC LETTER KEHEH WITH THREE DOTS BELOWARA" +
	"BIC LETTER FARSI YEH WITH INVERTED VARABIC LETTER FARSI YEH WITH TWO DOT" +
	"S ABOVEARABIC LETTER FARSI YEH WITH THREE DOTS ABOVEARABIC TATWEELARABIC" +
	" LETTER FEHARABIC LETTER QAFARABIC LETTER KAFARABIC LETTER LAMARABIC LET" +
	"TER MEEMARABIC LETTER NOONARABIC LETTER HEHARABIC LETTER WAWARABIC LETTE" +
	"R ALEF MAKSURAARABIC LETTER YEHARABIC FATHATANARABIC DAMMATANARABIC KASR" +
	"ATANARABIC FATHAARABIC DAMMAARABIC KASRAARABIC SHADDAARABIC SUKUNARABIC " +
	"MADDAH ABOVEARABIC HAMZA ABOVEARABIC HAMZA BELOWARABIC SUBSCRIPT ALEFARA" +
	"BIC INVERTED DAMMAARABIC MARK NOON GHUNNAARABIC ZWARAKAYARABIC VOWEL SIG" +
	"N SMALL V ABOVEARABIC VOWEL SIGN INVERTED SMALL V ABOVEARABIC VOWEL SIGN" +
	" DOT BELOWARABIC REVERSED DAMMAARABIC FATHA WITH TWO DOTSARABIC WAVY HAM" +
	"ZA BELOWARABIC-INDIC DIGIT ZEROARABIC-INDIC DIGIT ONEARABIC-INDIC DIGIT " +
	"TWOARABIC-INDIC DIGIT THREEARABIC-INDIC DIGIT FOURARABIC-INDIC DIGIT FIV" +
	"EARABIC-INDIC DIGIT SIXARABIC-INDIC DIGIT SEVENARABIC-INDIC DIGIT EIGHTA" +
	"RABIC-INDIC DIGIT NINEARABIC PERCENT SIGNARABIC DECIMAL SEPARATORARABIC " +
	"THOUSANDS SEPARATORARABIC FIVE POINTED STARARABIC LETTER DOTLESS BEHARAB" +
	"IC LETTER DOTLESS QAFARABIC LETTER SUPERSCRIPT ALEFARABIC LETTER ALEF WA" +
	"SLAARABIC LETTER ALEF WITH WAVY HAMZA ABOVEARABIC LETTER ALEF WITH WAVY " +
	"HAMZA BELOWARABIC LETTER HIGH HAMZAARABIC LETTER HIGH HAMZA ALEFARABIC L" +
	"ETTER HIGH HAMZA WAWARABIC LETTER U WITH HAMZA ABOVEARABIC LETTER HIGH H" +
	"AMZA YEHARABIC LETTER TTEHARABIC LETTER TTEHEHARABIC LETTER BEEHARABIC L" +
	"ETTER TEH WITH RINGARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDSARAB" +
	"IC LETTER PEHARABIC LETTER TEHEHARABIC LETTER BEHEHARABIC LETTER HAH WIT" +
	"H HAMZA ABOVEARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVEARABIC LETTER" +
	" NYEHARABIC LETTER DYEHARABIC LETTER HAH WITH THREE DOTS ABOVEARABIC LET" +
	"TER TCHEHARABIC LETTER TCHEHEHARABIC LETTER DDALARABIC LETTER DAL WITH R" +
	"INGARABIC LETTER DAL WITH DOT BELOWARABIC LETTER DAL WITH DOT BELOW AND " +
	"SMALL TAHARABIC LETTER DAHALARABIC LETTER DDAHALARABIC LETTER DULARABIC " +
	"LETTER DAL WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER DAL WITH FOUR DO" +
	"TS ABOVEARABIC LETTER RREHARABIC LETTER REH WITH SMALL VARABIC LETTER RE" +
	"H WITH RINGARABIC LETTER REH WITH DOT BELOWARABIC LETTER REH WITH SMALL " +
	"V BELOWARABIC LETTER REH WITH DOT BELOW AND DOT ABOVEARABIC LETTER REH W" +
	"ITH TWO DOTS ABOVEARABIC LETTER JEHARABIC LETTER REH WITH FOUR DOTS ABOV" +
	"EARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVEARABIC LETTER SEEN WITH " +
	"THREE DOTS BELOWARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS " +
	"ABOVEARABIC LETTER SAD WITH TWO DOTS BELOWARABIC LETTER SAD WITH THREE D" +
	"OTS ABOVEARABIC LETTER TAH WITH THREE DOTS ABOVEARABIC LETTER AIN WITH T" +
	"HREE DOTS ABOVEARABIC LETTER DOTLESS FEHARABIC LETTER FEH WITH DOT MOVED" +
	" BELOWARABIC LETTER FEH WITH DOT BELOWARABIC LETTER VEHARABIC LETTER FEH" +
	" WITH THREE DOTS BELOWARABIC LETTER PEHEHARABIC LETTER QAF WITH DOT ABOV" +
	"EARABIC LETTER QAF WITH THREE DOTS ABOVEARABIC LETTER KEHEHARABIC LETTER" +
	" SWASH KAFARABIC LETTER KAF WITH RINGARABIC LETTER KAF WITH DOT ABOVEARA" +
	"BIC LETTER NGARABIC LETTER KAF WITH THREE DOTS BELOWARABIC LETTER GAFARA" +
	"BIC LETTER GAF WITH RINGARABIC LETTER NGOEHARABIC LETTER GAF WITH TWO DO" +
	"TS BELOWARABIC LETTER GUEHARABIC LETTER GAF WITH THREE DOTS ABOVEARABIC ") + ("" +
	"LETTER LAM WITH SMALL VARABIC LETTER LAM WITH DOT ABOVEARABIC LETTER LAM" +
	" WITH THREE DOTS ABOVEARABIC LETTER LAM WITH THREE DOTS BELOWARABIC LETT" +
	"ER NOON WITH DOT BELOWARABIC LETTER NOON GHUNNAARABIC LETTER RNOONARABIC" +
	" LETTER NOON WITH RINGARABIC LETTER NOON WITH THREE DOTS ABOVEARABIC LET" +
	"TER HEH DOACHASHMEEARABIC LETTER TCHEH WITH DOT ABOVEARABIC LETTER HEH W" +
	"ITH YEH ABOVEARABIC LETTER HEH GOALARABIC LETTER HEH GOAL WITH HAMZA ABO" +
	"VEARABIC LETTER TEH MARBUTA GOALARABIC LETTER WAW WITH RINGARABIC LETTER" +
	" KIRGHIZ OEARABIC LETTER OEARABIC LETTER UARABIC LETTER YUARABIC LETTER " +
	"KIRGHIZ YUARABIC LETTER WAW WITH TWO DOTS ABOVEARABIC LETTER VEARABIC LE" +
	"TTER FARSI YEHARABIC LETTER YEH WITH TAILARABIC LETTER YEH WITH SMALL VA" +
	"RABIC LETTER WAW WITH DOT ABOVEARABIC LETTER EARABIC LETTER YEH WITH THR" +
	"EE DOTS BELOWARABIC LETTER YEH BARREEARABIC LETTER YEH BARREE WITH HAMZA" +
	" ABOVEARABIC FULL STOPARABIC LETTER AEARABIC SMALL HIGH LIGATURE SAD WIT" +
	"H LAM WITH ALEF MAKSURAARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF" +
	" MAKSURAARABIC SMALL HIGH MEEM INITIAL FORMARABIC SMALL HIGH LAM ALEFARA" +
	"BIC SMALL HIGH JEEMARABIC SMALL HIGH THREE DOTSARABIC SMALL HIGH SEENARA" +
	"BIC END OF AYAHARABIC START OF RUB EL HIZBARABIC SMALL HIGH ROUNDED ZERO" +
	"ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZEROARABIC SMALL HIGH DOTLESS HEAD" +
	" OF KHAHARABIC SMALL HIGH MEEM ISOLATED FORMARABIC SMALL LOW SEENARABIC " +
	"SMALL HIGH MADDAARABIC SMALL WAWARABIC SMALL YEHARABIC SMALL HIGH YEHARA" +
	"BIC SMALL HIGH NOONARABIC PLACE OF SAJDAHARABIC EMPTY CENTRE LOW STOPARA" +
	"BIC EMPTY CENTRE HIGH STOPARABIC ROUNDED HIGH STOP WITH FILLED CENTREARA" +
	"BIC SMALL LOW MEEMARABIC LETTER DAL WITH INVERTED VARABIC LETTER REH WIT" +
	"H INVERTED VEXTENDED ARABIC-INDIC DIGIT ZEROEXTENDED ARABIC-INDIC DIGIT " +
	"ONEEXTENDED ARABIC-INDIC DIGIT TWOEXTENDED ARABIC-INDIC DIGIT THREEEXTEN" +
	"DED ARABIC-INDIC DIGIT FOUREXTENDED ARABIC-INDIC DIGIT FIVEEXTENDED ARAB" +
	"IC-INDIC DIGIT SIXEXTENDED ARABIC-INDIC DIGIT SEVENEXTENDED ARABIC-INDIC" +
	" DIGIT EIGHTEXTENDED ARABIC-INDIC DIGIT NINEARABIC LETTER SHEEN WITH DOT" +
	" BELOWARABIC LETTER DAD WITH DOT BELOWARABIC LETTER GHAIN WITH DOT BELOW" +
	"ARABIC SIGN SINDHI AMPERSANDARABIC SIGN SINDHI POSTPOSITION MENARABIC LE" +
	"TTER HEH WITH INVERTED VSYRIAC END OF PARAGRAPHSYRIAC SUPRALINEAR FULL S" +
	"TOPSYRIAC SUBLINEAR FULL STOPSYRIAC SUPRALINEAR COLONSYRIAC SUBLINEAR CO" +
	"LONSYRIAC HORIZONTAL COLONSYRIAC COLON SKEWED LEFTSYRIAC COLON SKEWED RI" +
	"GHTSYRIAC SUPRALINEAR COLON SKEWED LEFTSYRIAC SUBLINEAR COLON SKEWED RIG" +
	"HTSYRIAC CONTRACTIONSYRIAC HARKLEAN OBELUSSYRIAC HARKLEAN METOBELUSSYRIA" +
	"C HARKLEAN ASTERISCUSSYRIAC ABBREVIATION MARKSYRIAC LETTER ALAPHSYRIAC L" +
	"ETTER SUPERSCRIPT ALAPHSYRIAC LETTER BETHSYRIAC LETTER GAMALSYRIAC LETTE" +
	"R GAMAL GARSHUNISYRIAC LETTER DALATHSYRIAC LETTER DOTLESS DALATH RISHSYR" +
	"IAC LETTER HESYRIAC LETTER WAWSYRIAC LETTER ZAINSYRIAC LETTER HETHSYRIAC" +
	" LETTER TETHSYRIAC LETTER TETH GARSHUNISYRIAC LETTER YUDHSYRIAC LETTER Y" +
	"UDH HESYRIAC LETTER KAPHSYRIAC LETTER LAMADHSYRIAC LETTER MIMSYRIAC LETT" +
	"ER NUNSYRIAC LETTER SEMKATHSYRIAC LETTER FINAL SEMKATHSYRIAC LETTER ESYR" +
	"IAC LETTER PESYRIAC LETTER REVERSED PESYRIAC LETTER SADHESYRIAC LETTER Q" +
	"APHSYRIAC LETTER RISHSYRIAC LETTER SHINSYRIAC LETTER TAWSYRIAC LETTER PE" +
	"RSIAN BHETHSYRIAC LETTER PERSIAN GHAMALSYRIAC LETTER PERSIAN DHALATHSYRI" +
	"AC PTHAHA ABOVESYRIAC PTHAHA BELOWSYRIAC PTHAHA DOTTEDSYRIAC ZQAPHA ABOV" +
	"ESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA DOTTEDSYRIAC RBASA ABOVESYRIAC RBASA B" +
	"ELOWSYRIAC DOTTED ZLAMA HORIZONTALSYRIAC DOTTED ZLAMA ANGULARSYRIAC HBAS" +
	"A ABOVESYRIAC HBASA BELOWSYRIAC HBASA-ESASA DOTTEDSYRIAC ESASA ABOVESYRI" +
	"AC ESASA BELOWSYRIAC RWAHASYRIAC FEMININE DOTSYRIAC QUSHSHAYASYRIAC RUKK" +
	"AKHASYRIAC TWO VERTICAL DOTS ABOVESYRIAC TWO VERTICAL DOTS BELOWSYRIAC T" +
	"HREE DOTS ABOVESYRIAC THREE DOTS BELOWSYRIAC OBLIQUE LINE ABOVESYRIAC OB" +
	"LIQUE LINE BELOWSYRIAC MUSICSYRIAC BARREKHSYRIAC LETTER SOGDIAN ZHAINSYR" +
	"IAC LETTER SOGDIAN KHAPHSYRIAC LETTER SOGDIAN FEARABIC LETTER BEH WITH T" +
	"HREE DOTS HORIZONTALLY BELOWARABIC LETTER BEH WITH DOT BELOW AND THREE D" +
	"OTS ABOVEARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC " +
	"LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVEARAB" +
	"IC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LETTER BEH WITH IN" +
	"VERTED SMALL V BELOWARABIC LETTER BEH WITH SMALL VARABIC LETTER HAH WITH" +
	" TWO DOTS ABOVEARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOWA" +
	"RABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAHARABIC LETT" +
	"ER DAL WITH INVERTED SMALL V BELOWARABIC LETTER REH WITH STROKEARABIC LE" +
	"TTER SEEN WITH FOUR DOTS ABOVEARABIC LETTER AIN WITH TWO DOTS ABOVEARABI" +
	"C LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVEARABIC LETTER AIN W") + ("" +
	"ITH TWO DOTS VERTICALLY ABOVEARABIC LETTER FEH WITH TWO DOTS BELOWARABIC" +
	" LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER KEHEH WI" +
	"TH DOT ABOVEARABIC LETTER KEHEH WITH THREE DOTS ABOVEARABIC LETTER KEHEH" +
	" WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER MEEM WITH DOT ABOVE" +
	"ARABIC LETTER MEEM WITH DOT BELOWARABIC LETTER NOON WITH TWO DOTS BELOWA" +
	"RABIC LETTER NOON WITH SMALL TAHARABIC LETTER NOON WITH SMALL VARABIC LE" +
	"TTER LAM WITH BARARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVEARABIC " +
	"LETTER REH WITH HAMZA ABOVEARABIC LETTER SEEN WITH TWO DOTS VERTICALLY A" +
	"BOVEARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOWARABIC LETTER HA" +
	"H WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER SEEN WITH SMALL" +
	" ARABIC LETTER TAH AND TWO DOTSARABIC LETTER REH WITH SMALL ARABIC LETTE" +
	"R TAH AND TWO DOTSARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVEAR" +
	"ABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER" +
	" ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FARSI YE" +
	"H WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER FARSI YEH WITH" +
	" EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FARSI YEH WITH EXT" +
	"ENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER WAW WITH EXTENDED ARABI" +
	"C-INDIC DIGIT TWO ABOVEARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGI" +
	"T THREE ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT T" +
	"WO ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE " +
	"ABOVEARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC" +
	" LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVEARABIC LETTER SE" +
	"EN WITH INVERTED VARABIC LETTER KAF WITH TWO DOTS ABOVETHAANA LETTER HAA" +
	"THAANA LETTER SHAVIYANITHAANA LETTER NOONUTHAANA LETTER RAATHAANA LETTER" +
	" BAATHAANA LETTER LHAVIYANITHAANA LETTER KAAFUTHAANA LETTER ALIFUTHAANA " +
	"LETTER VAAVUTHAANA LETTER MEEMUTHAANA LETTER FAAFUTHAANA LETTER DHAALUTH" +
	"AANA LETTER THAATHAANA LETTER LAAMUTHAANA LETTER GAAFUTHAANA LETTER GNAV" +
	"IYANITHAANA LETTER SEENUTHAANA LETTER DAVIYANITHAANA LETTER ZAVIYANITHAA" +
	"NA LETTER TAVIYANITHAANA LETTER YAATHAANA LETTER PAVIYANITHAANA LETTER J" +
	"AVIYANITHAANA LETTER CHAVIYANITHAANA LETTER TTAATHAANA LETTER HHAATHAANA" +
	" LETTER KHAATHAANA LETTER THAALUTHAANA LETTER ZAATHAANA LETTER SHEENUTHA" +
	"ANA LETTER SAADHUTHAANA LETTER DAADHUTHAANA LETTER TOTHAANA LETTER ZOTHA" +
	"ANA LETTER AINUTHAANA LETTER GHAINUTHAANA LETTER QAAFUTHAANA LETTER WAAV" +
	"UTHAANA ABAFILITHAANA AABAAFILITHAANA IBIFILITHAANA EEBEEFILITHAANA UBUF" +
	"ILITHAANA OOBOOFILITHAANA EBEFILITHAANA EYBEYFILITHAANA OBOFILITHAANA OA" +
	"BOAFILITHAANA SUKUNTHAANA LETTER NAANKO DIGIT ZERONKO DIGIT ONENKO DIGIT" +
	" TWONKO DIGIT THREENKO DIGIT FOURNKO DIGIT FIVENKO DIGIT SIXNKO DIGIT SE" +
	"VENNKO DIGIT EIGHTNKO DIGIT NINENKO LETTER ANKO LETTER EENKO LETTER INKO" +
	" LETTER ENKO LETTER UNKO LETTER OONKO LETTER ONKO LETTER DAGBASINNANKO L" +
	"ETTER NNKO LETTER BANKO LETTER PANKO LETTER TANKO LETTER JANKO LETTER CH" +
	"ANKO LETTER DANKO LETTER RANKO LETTER RRANKO LETTER SANKO LETTER GBANKO " +
	"LETTER FANKO LETTER KANKO LETTER LANKO LETTER NA WOLOSONKO LETTER MANKO " +
	"LETTER NYANKO LETTER NANKO LETTER HANKO LETTER WANKO LETTER YANKO LETTER" +
	" NYA WOLOSONKO LETTER JONA JANKO LETTER JONA CHANKO LETTER JONA RANKO CO" +
	"MBINING SHORT HIGH TONENKO COMBINING SHORT LOW TONENKO COMBINING SHORT R" +
	"ISING TONENKO COMBINING LONG DESCENDING TONENKO COMBINING LONG HIGH TONE" +
	"NKO COMBINING LONG LOW TONENKO COMBINING LONG RISING TONENKO COMBINING N" +
	"ASALIZATION MARKNKO COMBINING DOUBLE DOT ABOVENKO HIGH TONE APOSTROPHENK" +
	"O LOW TONE APOSTROPHENKO SYMBOL OO DENNENNKO SYMBOL GBAKURUNENNKO COMMAN" +
	"KO EXCLAMATION MARKNKO LAJANYALANSAMARITAN LETTER ALAFSAMARITAN LETTER B" +
	"ITSAMARITAN LETTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER IYSAMARIT" +
	"AN LETTER BAASAMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN LETTER TIT" +
	"SAMARITAN LETTER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABATSAMARITAN" +
	" LETTER MIMSAMARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITAN LETTER " +
	"INSAMARITAN LETTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER QUFSAMARIT" +
	"AN LETTER RISHSAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARITAN MARK I" +
	"NSAMARITAN MARK IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK DAGESHSAMA" +
	"RITAN MODIFIER LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC YUTSAMARIT" +
	"AN VOWEL SIGN LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN OVERLONG " +
	"AASAMARITAN VOWEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN VOWEL SIG" +
	"N OVERLONG ASAMARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASAMARITAN M" +
	"ODIFIER LETTER SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOWEL SIGN L" +
	"ONG USAMARITAN VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN VOWEL SI" +
	"GN LONG ISAMARITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN VOWEL SIG") + ("" +
	"N SUKUNSAMARITAN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMARITAN PUNC" +
	"TUATION AFSAAQSAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION BAUSAMARI" +
	"TAN PUNCTUATION ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN ABBREVIA" +
	"TION MARKSAMARITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATION ZIQAAS" +
	"AMARITAN PUNCTUATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN PUNCTUATIO" +
	"N TURUSAMARITAN PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MASHFAATSAM" +
	"ARITAN PUNCTUATION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABMANDAIC LE" +
	"TTER AGMANDAIC LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNAMANDAIC L" +
	"ETTER AZMANDAIC LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAMANDAIC LE" +
	"TTER AKMANDAIC LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDAIC LETTER" +
	" ASMANDAIC LETTER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC LETTER AQ" +
	"MANDAIC LETTER ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LETTER DUSHE" +
	"NNAMANDAIC LETTER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARKMANDAIC V" +
	"OCALIZATION MARKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIAC LETTER " +
	"MALAYALAM NGASYRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM NYASYRIAC" +
	" LETTER MALAYALAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER MALAYALAM " +
	"NNNASYRIAC LETTER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC LETTER M" +
	"ALAYALAM LLASYRIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM SSAARABI" +
	"C LETTER BEH WITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC " +
	"LETTER JEEM WITH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARAB" +
	"IC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH " +
	"DOT BELOWARABIC LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE " +
	"DOTS ABOVEARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC LE" +
	"TTER YEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPARA" +
	"BIC LETTER WAW WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER LO" +
	"W ALEFARABIC LETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THRE" +
	"E DOTS BELOWARABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGHT" +
	" WAWARABIC LETTER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THREE" +
	" DOTS BELOWARABIC LETTER KAF WITH DOT BELOWARABIC LETTER BEH WITH SMALL " +
	"MEEM ABOVEARABIC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH " +
	"SMALL TEH ABOVEARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH " +
	"WITH TWO DOTS BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC " +
	"LETTER AFRICAN QAFARABIC LETTER AFRICAN NOONARABIC SMALL HIGH WORD AR-RU" +
	"BARABIC SMALL HIGH SADARABIC SMALL HIGH AINARABIC SMALL HIGH QAFARABIC S" +
	"MALL HIGH NOON WITH KASRAARABIC SMALL LOW NOON WITH KASRAARABIC SMALL HI" +
	"GH WORD ATH-THALATHAARABIC SMALL HIGH WORD AS-SAJDAARABIC SMALL HIGH WOR" +
	"D AN-NISFARABIC SMALL HIGH WORD SAKTAARABIC SMALL HIGH WORD QIFARABIC SM" +
	"ALL HIGH WORD WAQFAARABIC SMALL HIGH FOOTNOTE MARKERARABIC SMALL HIGH SI" +
	"GN SAFHAARABIC DISPUTED END OF AYAHARABIC TURNED DAMMA BELOWARABIC CURLY" +
	" FATHAARABIC CURLY DAMMAARABIC CURLY KASRAARABIC CURLY FATHATANARABIC CU" +
	"RLY DAMMATANARABIC CURLY KASRATANARABIC TONE ONE DOT ABOVEARABIC TONE TW" +
	"O DOTS ABOVEARABIC TONE LOOP ABOVEARABIC TONE ONE DOT BELOWARABIC TONE T" +
	"WO DOTS BELOWARABIC TONE LOOP BELOWARABIC OPEN FATHATANARABIC OPEN DAMMA" +
	"TANARABIC OPEN KASRATANARABIC SMALL HIGH WAWARABIC FATHA WITH RINGARABIC" +
	" FATHA WITH DOT ABOVEARABIC KASRA WITH DOT BELOWARABIC LEFT ARROWHEAD AB" +
	"OVEARABIC RIGHT ARROWHEAD ABOVEARABIC LEFT ARROWHEAD BELOWARABIC RIGHT A" +
	"RROWHEAD BELOWARABIC DOUBLE RIGHT ARROWHEAD ABOVEARABIC DOUBLE RIGHT ARR" +
	"OWHEAD ABOVE WITH DOTARABIC RIGHT ARROWHEAD ABOVE WITH DOTARABIC DAMMA W" +
	"ITH DOTARABIC MARK SIDEWAYS NOON GHUNNADEVANAGARI SIGN INVERTED CANDRABI" +
	"NDUDEVANAGARI SIGN CANDRABINDUDEVANAGARI SIGN ANUSVARADEVANAGARI SIGN VI" +
	"SARGADEVANAGARI LETTER SHORT ADEVANAGARI LETTER ADEVANAGARI LETTER AADEV" +
	"ANAGARI LETTER IDEVANAGARI LETTER IIDEVANAGARI LETTER UDEVANAGARI LETTER" +
	" UUDEVANAGARI LETTER VOCALIC RDEVANAGARI LETTER VOCALIC LDEVANAGARI LETT" +
	"ER CANDRA EDEVANAGARI LETTER SHORT EDEVANAGARI LETTER EDEVANAGARI LETTER" +
	" AIDEVANAGARI LETTER CANDRA ODEVANAGARI LETTER SHORT ODEVANAGARI LETTER " +
	"ODEVANAGARI LETTER AUDEVANAGARI LETTER KADEVANAGARI LETTER KHADEVANAGARI" +
	" LETTER GADEVANAGARI LETTER GHADEVANAGARI LETTER NGADEVANAGARI LETTER CA" +
	"DEVANAGARI LETTER CHADEVANAGARI LETTER JADEVANAGARI LETTER JHADEVANAGARI" +
	" LETTER NYADEVANAGARI LETTER TTADEVANAGARI LETTER TTHADEVANAGARI LETTER " +
	"DDADEVANAGARI LETTER DDHADEVANAGARI LETTER NNADEVANAGARI LETTER TADEVANA" +
	"GARI LETTER THADEVANAGARI LETTER DADEVANAGARI LETTER DHADEVANAGARI LETTE" +
	"R NADEVANAGARI LETTER NNNADEVANAGARI LETTER PADEVANAGARI LETTER PHADEVAN" +
	"AGARI LETTER BADEVANAGARI LETTER BHADEVANAGARI LETTER MADEVANAGARI LETTE" +
	"R YADEVANAGARI LETTER RADEVANAGARI LETTER RRADEVANAGARI LETTER LADEVANAG") + ("" +
	"ARI LETTER LLADEVANAGARI LETTER LLLADEVANAGARI LETTER VADEVANAGARI LETTE" +
	"R SHADEVANAGARI LETTER SSADEVANAGARI LETTER SADEVANAGARI LETTER HADEVANA" +
	"GARI VOWEL SIGN OEDEVANAGARI VOWEL SIGN OOEDEVANAGARI SIGN NUKTADEVANAGA" +
	"RI SIGN AVAGRAHADEVANAGARI VOWEL SIGN AADEVANAGARI VOWEL SIGN IDEVANAGAR" +
	"I VOWEL SIGN IIDEVANAGARI VOWEL SIGN UDEVANAGARI VOWEL SIGN UUDEVANAGARI" +
	" VOWEL SIGN VOCALIC RDEVANAGARI VOWEL SIGN VOCALIC RRDEVANAGARI VOWEL SI" +
	"GN CANDRA EDEVANAGARI VOWEL SIGN SHORT EDEVANAGARI VOWEL SIGN EDEVANAGAR" +
	"I VOWEL SIGN AIDEVANAGARI VOWEL SIGN CANDRA ODEVANAGARI VOWEL SIGN SHORT" +
	" ODEVANAGARI VOWEL SIGN ODEVANAGARI VOWEL SIGN AUDEVANAGARI SIGN VIRAMAD" +
	"EVANAGARI VOWEL SIGN PRISHTHAMATRA EDEVANAGARI VOWEL SIGN AWDEVANAGARI O" +
	"MDEVANAGARI STRESS SIGN UDATTADEVANAGARI STRESS SIGN ANUDATTADEVANAGARI " +
	"GRAVE ACCENTDEVANAGARI ACUTE ACCENTDEVANAGARI VOWEL SIGN CANDRA LONG EDE" +
	"VANAGARI VOWEL SIGN UEDEVANAGARI VOWEL SIGN UUEDEVANAGARI LETTER QADEVAN" +
	"AGARI LETTER KHHADEVANAGARI LETTER GHHADEVANAGARI LETTER ZADEVANAGARI LE" +
	"TTER DDDHADEVANAGARI LETTER RHADEVANAGARI LETTER FADEVANAGARI LETTER YYA" +
	"DEVANAGARI LETTER VOCALIC RRDEVANAGARI LETTER VOCALIC LLDEVANAGARI VOWEL" +
	" SIGN VOCALIC LDEVANAGARI VOWEL SIGN VOCALIC LLDEVANAGARI DANDADEVANAGAR" +
	"I DOUBLE DANDADEVANAGARI DIGIT ZERODEVANAGARI DIGIT ONEDEVANAGARI DIGIT " +
	"TWODEVANAGARI DIGIT THREEDEVANAGARI DIGIT FOURDEVANAGARI DIGIT FIVEDEVAN" +
	"AGARI DIGIT SIXDEVANAGARI DIGIT SEVENDEVANAGARI DIGIT EIGHTDEVANAGARI DI" +
	"GIT NINEDEVANAGARI ABBREVIATION SIGNDEVANAGARI SIGN HIGH SPACING DOTDEVA" +
	"NAGARI LETTER CANDRA ADEVANAGARI LETTER OEDEVANAGARI LETTER OOEDEVANAGAR" +
	"I LETTER AWDEVANAGARI LETTER UEDEVANAGARI LETTER UUEDEVANAGARI LETTER MA" +
	"RWARI DDADEVANAGARI LETTER ZHADEVANAGARI LETTER HEAVY YADEVANAGARI LETTE" +
	"R GGADEVANAGARI LETTER JJADEVANAGARI LETTER GLOTTAL STOPDEVANAGARI LETTE" +
	"R DDDADEVANAGARI LETTER BBABENGALI ANJIBENGALI SIGN CANDRABINDUBENGALI S" +
	"IGN ANUSVARABENGALI SIGN VISARGABENGALI LETTER ABENGALI LETTER AABENGALI" +
	" LETTER IBENGALI LETTER IIBENGALI LETTER UBENGALI LETTER UUBENGALI LETTE" +
	"R VOCALIC RBENGALI LETTER VOCALIC LBENGALI LETTER EBENGALI LETTER AIBENG" +
	"ALI LETTER OBENGALI LETTER AUBENGALI LETTER KABENGALI LETTER KHABENGALI " +
	"LETTER GABENGALI LETTER GHABENGALI LETTER NGABENGALI LETTER CABENGALI LE" +
	"TTER CHABENGALI LETTER JABENGALI LETTER JHABENGALI LETTER NYABENGALI LET" +
	"TER TTABENGALI LETTER TTHABENGALI LETTER DDABENGALI LETTER DDHABENGALI L" +
	"ETTER NNABENGALI LETTER TABENGALI LETTER THABENGALI LETTER DABENGALI LET" +
	"TER DHABENGALI LETTER NABENGALI LETTER PABENGALI LETTER PHABENGALI LETTE" +
	"R BABENGALI LETTER BHABENGALI LETTER MABENGALI LETTER YABENGALI LETTER R" +
	"ABENGALI LETTER LABENGALI LETTER SHABENGALI LETTER SSABENGALI LETTER SAB" +
	"ENGALI LETTER HABENGALI SIGN NUKTABENGALI SIGN AVAGRAHABENGALI VOWEL SIG" +
	"N AABENGALI VOWEL SIGN IBENGALI VOWEL SIGN IIBENGALI VOWEL SIGN UBENGALI" +
	" VOWEL SIGN UUBENGALI VOWEL SIGN VOCALIC RBENGALI VOWEL SIGN VOCALIC RRB" +
	"ENGALI VOWEL SIGN EBENGALI VOWEL SIGN AIBENGALI VOWEL SIGN OBENGALI VOWE" +
	"L SIGN AUBENGALI SIGN VIRAMABENGALI LETTER KHANDA TABENGALI AU LENGTH MA" +
	"RKBENGALI LETTER RRABENGALI LETTER RHABENGALI LETTER YYABENGALI LETTER V" +
	"OCALIC RRBENGALI LETTER VOCALIC LLBENGALI VOWEL SIGN VOCALIC LBENGALI VO" +
	"WEL SIGN VOCALIC LLBENGALI DIGIT ZEROBENGALI DIGIT ONEBENGALI DIGIT TWOB" +
	"ENGALI DIGIT THREEBENGALI DIGIT FOURBENGALI DIGIT FIVEBENGALI DIGIT SIXB" +
	"ENGALI DIGIT SEVENBENGALI DIGIT EIGHTBENGALI DIGIT NINEBENGALI LETTER RA" +
	" WITH MIDDLE DIAGONALBENGALI LETTER RA WITH LOWER DIAGONALBENGALI RUPEE " +
	"MARKBENGALI RUPEE SIGNBENGALI CURRENCY NUMERATOR ONEBENGALI CURRENCY NUM" +
	"ERATOR TWOBENGALI CURRENCY NUMERATOR THREEBENGALI CURRENCY NUMERATOR FOU" +
	"RBENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATORBENGALI CURRENC" +
	"Y DENOMINATOR SIXTEENBENGALI ISSHARBENGALI GANDA MARKBENGALI LETTER VEDI" +
	"C ANUSVARABENGALI ABBREVIATION SIGNGURMUKHI SIGN ADAK BINDIGURMUKHI SIGN" +
	" BINDIGURMUKHI SIGN VISARGAGURMUKHI LETTER AGURMUKHI LETTER AAGURMUKHI L" +
	"ETTER IGURMUKHI LETTER IIGURMUKHI LETTER UGURMUKHI LETTER UUGURMUKHI LET" +
	"TER EEGURMUKHI LETTER AIGURMUKHI LETTER OOGURMUKHI LETTER AUGURMUKHI LET" +
	"TER KAGURMUKHI LETTER KHAGURMUKHI LETTER GAGURMUKHI LETTER GHAGURMUKHI L" +
	"ETTER NGAGURMUKHI LETTER CAGURMUKHI LETTER CHAGURMUKHI LETTER JAGURMUKHI" +
	" LETTER JHAGURMUKHI LETTER NYAGURMUKHI LETTER TTAGURMUKHI LETTER TTHAGUR" +
	"MUKHI LETTER DDAGURMUKHI LETTER DDHAGURMUKHI LETTER NNAGURMUKHI LETTER T" +
	"AGURMUKHI LETTER THAGURMUKHI LETTER DAGURMUKHI LETTER DHAGURMUKHI LETTER" +
	" NAGURMUKHI LETTER PAGURMUKHI LETTER PHAGURMUKHI LETTER BAGURMUKHI LETTE" +
	"R BHAGURMUKHI LETTER MAGURMUKHI LETTER YAGURMUKHI LETTER RAGURMUKHI LETT" +
	"ER LAGURMUKHI LETTER LLAGURMUKHI LETTER VAGURMUKHI LETTER SHAGURMUKHI LE") + ("" +
	"TTER SAGURMUKHI LETTER HAGURMUKHI SIGN NUKTAGURMUKHI VOWEL SIGN AAGURMUK" +
	"HI VOWEL SIGN IGURMUKHI VOWEL SIGN IIGURMUKHI VOWEL SIGN UGURMUKHI VOWEL" +
	" SIGN UUGURMUKHI VOWEL SIGN EEGURMUKHI VOWEL SIGN AIGURMUKHI VOWEL SIGN " +
	"OOGURMUKHI VOWEL SIGN AUGURMUKHI SIGN VIRAMAGURMUKHI SIGN UDAATGURMUKHI " +
	"LETTER KHHAGURMUKHI LETTER GHHAGURMUKHI LETTER ZAGURMUKHI LETTER RRAGURM" +
	"UKHI LETTER FAGURMUKHI DIGIT ZEROGURMUKHI DIGIT ONEGURMUKHI DIGIT TWOGUR" +
	"MUKHI DIGIT THREEGURMUKHI DIGIT FOURGURMUKHI DIGIT FIVEGURMUKHI DIGIT SI" +
	"XGURMUKHI DIGIT SEVENGURMUKHI DIGIT EIGHTGURMUKHI DIGIT NINEGURMUKHI TIP" +
	"PIGURMUKHI ADDAKGURMUKHI IRIGURMUKHI URAGURMUKHI EK ONKARGURMUKHI SIGN Y" +
	"AKASHGUJARATI SIGN CANDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SIGN VISARG" +
	"AGUJARATI LETTER AGUJARATI LETTER AAGUJARATI LETTER IGUJARATI LETTER IIG" +
	"UJARATI LETTER UGUJARATI LETTER UUGUJARATI LETTER VOCALIC RGUJARATI LETT" +
	"ER VOCALIC LGUJARATI VOWEL CANDRA EGUJARATI LETTER EGUJARATI LETTER AIGU" +
	"JARATI VOWEL CANDRA OGUJARATI LETTER OGUJARATI LETTER AUGUJARATI LETTER " +
	"KAGUJARATI LETTER KHAGUJARATI LETTER GAGUJARATI LETTER GHAGUJARATI LETTE" +
	"R NGAGUJARATI LETTER CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJARATI LET" +
	"TER JHAGUJARATI LETTER NYAGUJARATI LETTER TTAGUJARATI LETTER TTHAGUJARAT" +
	"I LETTER DDAGUJARATI LETTER DDHAGUJARATI LETTER NNAGUJARATI LETTER TAGUJ" +
	"ARATI LETTER THAGUJARATI LETTER DAGUJARATI LETTER DHAGUJARATI LETTER NAG" +
	"UJARATI LETTER PAGUJARATI LETTER PHAGUJARATI LETTER BAGUJARATI LETTER BH" +
	"AGUJARATI LETTER MAGUJARATI LETTER YAGUJARATI LETTER RAGUJARATI LETTER L" +
	"AGUJARATI LETTER LLAGUJARATI LETTER VAGUJARATI LETTER SHAGUJARATI LETTER" +
	" SSAGUJARATI LETTER SAGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJARATI SIGN" +
	" AVAGRAHAGUJARATI VOWEL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VOWEL SIGN " +
	"IIGUJARATI VOWEL SIGN UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIGN VOCALIC" +
	" RGUJARATI VOWEL SIGN VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJARATI VOW" +
	"EL SIGN EGUJARATI VOWEL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJARATI VOWE" +
	"L SIGN OGUJARATI VOWEL SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGUJARATI LE" +
	"TTER VOCALIC RRGUJARATI LETTER VOCALIC LLGUJARATI VOWEL SIGN VOCALIC LGU" +
	"JARATI VOWEL SIGN VOCALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT ONEGUJARAT" +
	"I DIGIT TWOGUJARATI DIGIT THREEGUJARATI DIGIT FOURGUJARATI DIGIT FIVEGUJ" +
	"ARATI DIGIT SIXGUJARATI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI DIGIT NI" +
	"NEGUJARATI ABBREVIATION SIGNGUJARATI RUPEE SIGNGUJARATI LETTER ZHAGUJARA" +
	"TI SIGN SUKUNGUJARATI SIGN SHADDAGUJARATI SIGN MADDAHGUJARATI SIGN THREE" +
	"-DOT NUKTA ABOVEGUJARATI SIGN CIRCLE NUKTA ABOVEGUJARATI SIGN TWO-CIRCLE" +
	" NUKTA ABOVEORIYA SIGN CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARGAO" +
	"RIYA LETTER AORIYA LETTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER UO" +
	"RIYA LETTER UUORIYA LETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER E" +
	"ORIYA LETTER AIORIYA LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTER " +
	"KHAORIYA LETTER GAORIYA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA L" +
	"ETTER CHAORIYA LETTER JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER TTA" +
	"ORIYA LETTER TTHAORIYA LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIYA " +
	"LETTER TAORIYA LETTER THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER NAO" +
	"RIYA LETTER PAORIYA LETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LETTE" +
	"R MAORIYA LETTER YAORIYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA L" +
	"ETTER VAORIYA LETTER SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HAOR" +
	"IYA SIGN NUKTAORIYA SIGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN IOR" +
	"IYA VOWEL SIGN IIORIYA VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN V" +
	"OCALIC RORIYA VOWEL SIGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN AI" +
	"ORIYA VOWEL SIGN OORIYA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA AI LENGTH MA" +
	"RKORIYA AU LENGTH MARKORIYA LETTER RRAORIYA LETTER RHAORIYA LETTER YYAOR" +
	"IYA LETTER VOCALIC RRORIYA LETTER VOCALIC LLORIYA VOWEL SIGN VOCALIC LOR" +
	"IYA VOWEL SIGN VOCALIC LLORIYA DIGIT ZEROORIYA DIGIT ONEORIYA DIGIT TWOO" +
	"RIYA DIGIT THREEORIYA DIGIT FOURORIYA DIGIT FIVEORIYA DIGIT SIXORIYA DIG" +
	"IT SEVENORIYA DIGIT EIGHTORIYA DIGIT NINEORIYA ISSHARORIYA LETTER WAORIY" +
	"A FRACTION ONE QUARTERORIYA FRACTION ONE HALFORIYA FRACTION THREE QUARTE" +
	"RSORIYA FRACTION ONE SIXTEENTHORIYA FRACTION ONE EIGHTHORIYA FRACTION TH" +
	"REE SIXTEENTHSTAMIL SIGN ANUSVARATAMIL SIGN VISARGATAMIL LETTER ATAMIL L" +
	"ETTER AATAMIL LETTER ITAMIL LETTER IITAMIL LETTER UTAMIL LETTER UUTAMIL " +
	"LETTER ETAMIL LETTER EETAMIL LETTER AITAMIL LETTER OTAMIL LETTER OOTAMIL" +
	" LETTER AUTAMIL LETTER KATAMIL LETTER NGATAMIL LETTER CATAMIL LETTER JAT" +
	"AMIL LETTER NYATAMIL LETTER TTATAMIL LETTER NNATAMIL LETTER TATAMIL LETT" +
	"ER NATAMIL LETTER NNNATAMIL LETTER PATAMIL LETTER MATAMIL LETTER YATAMIL" +
	" LETTER RATAMIL LETTER RRATAMIL LETTER LATAMIL LETTER LLATAMIL LETTER LL") + ("" +
	"LATAMIL LETTER VATAMIL LETTER SHATAMIL LETTER SSATAMIL LETTER SATAMIL LE" +
	"TTER HATAMIL VOWEL SIGN AATAMIL VOWEL SIGN ITAMIL VOWEL SIGN IITAMIL VOW" +
	"EL SIGN UTAMIL VOWEL SIGN UUTAMIL VOWEL SIGN ETAMIL VOWEL SIGN EETAMIL V" +
	"OWEL SIGN AITAMIL VOWEL SIGN OTAMIL VOWEL SIGN OOTAMIL VOWEL SIGN AUTAMI" +
	"L SIGN VIRAMATAMIL OMTAMIL AU LENGTH MARKTAMIL DIGIT ZEROTAMIL DIGIT ONE" +
	"TAMIL DIGIT TWOTAMIL DIGIT THREETAMIL DIGIT FOURTAMIL DIGIT FIVETAMIL DI" +
	"GIT SIXTAMIL DIGIT SEVENTAMIL DIGIT EIGHTTAMIL DIGIT NINETAMIL NUMBER TE" +
	"NTAMIL NUMBER ONE HUNDREDTAMIL NUMBER ONE THOUSANDTAMIL DAY SIGNTAMIL MO" +
	"NTH SIGNTAMIL YEAR SIGNTAMIL DEBIT SIGNTAMIL CREDIT SIGNTAMIL AS ABOVE S" +
	"IGNTAMIL RUPEE SIGNTAMIL NUMBER SIGNTELUGU SIGN COMBINING CANDRABINDU AB" +
	"OVETELUGU SIGN CANDRABINDUTELUGU SIGN ANUSVARATELUGU SIGN VISARGATELUGU " +
	"LETTER ATELUGU LETTER AATELUGU LETTER ITELUGU LETTER IITELUGU LETTER UTE" +
	"LUGU LETTER UUTELUGU LETTER VOCALIC RTELUGU LETTER VOCALIC LTELUGU LETTE" +
	"R ETELUGU LETTER EETELUGU LETTER AITELUGU LETTER OTELUGU LETTER OOTELUGU" +
	" LETTER AUTELUGU LETTER KATELUGU LETTER KHATELUGU LETTER GATELUGU LETTER" +
	" GHATELUGU LETTER NGATELUGU LETTER CATELUGU LETTER CHATELUGU LETTER JATE" +
	"LUGU LETTER JHATELUGU LETTER NYATELUGU LETTER TTATELUGU LETTER TTHATELUG" +
	"U LETTER DDATELUGU LETTER DDHATELUGU LETTER NNATELUGU LETTER TATELUGU LE" +
	"TTER THATELUGU LETTER DATELUGU LETTER DHATELUGU LETTER NATELUGU LETTER P" +
	"ATELUGU LETTER PHATELUGU LETTER BATELUGU LETTER BHATELUGU LETTER MATELUG" +
	"U LETTER YATELUGU LETTER RATELUGU LETTER RRATELUGU LETTER LATELUGU LETTE" +
	"R LLATELUGU LETTER LLLATELUGU LETTER VATELUGU LETTER SHATELUGU LETTER SS" +
	"ATELUGU LETTER SATELUGU LETTER HATELUGU SIGN AVAGRAHATELUGU VOWEL SIGN A" +
	"ATELUGU VOWEL SIGN ITELUGU VOWEL SIGN IITELUGU VOWEL SIGN UTELUGU VOWEL " +
	"SIGN UUTELUGU VOWEL SIGN VOCALIC RTELUGU VOWEL SIGN VOCALIC RRTELUGU VOW" +
	"EL SIGN ETELUGU VOWEL SIGN EETELUGU VOWEL SIGN AITELUGU VOWEL SIGN OTELU" +
	"GU VOWEL SIGN OOTELUGU VOWEL SIGN AUTELUGU SIGN VIRAMATELUGU LENGTH MARK" +
	"TELUGU AI LENGTH MARKTELUGU LETTER TSATELUGU LETTER DZATELUGU LETTER RRR" +
	"ATELUGU LETTER VOCALIC RRTELUGU LETTER VOCALIC LLTELUGU VOWEL SIGN VOCAL" +
	"IC LTELUGU VOWEL SIGN VOCALIC LLTELUGU DIGIT ZEROTELUGU DIGIT ONETELUGU " +
	"DIGIT TWOTELUGU DIGIT THREETELUGU DIGIT FOURTELUGU DIGIT FIVETELUGU DIGI" +
	"T SIXTELUGU DIGIT SEVENTELUGU DIGIT EIGHTTELUGU DIGIT NINETELUGU FRACTIO" +
	"N DIGIT ZERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR ODD POW" +
	"ERS OF FOURTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOURTELUGU FRACTI" +
	"ON DIGIT THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR EVEN " +
	"POWERS OF FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOURTELUGU FR" +
	"ACTION DIGIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUUMUKANNADA SIGN " +
	"SPACING CANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN ANUSVARAKANNADA " +
	"SIGN VISARGAKANNADA LETTER AKANNADA LETTER AAKANNADA LETTER IKANNADA LET" +
	"TER IIKANNADA LETTER UKANNADA LETTER UUKANNADA LETTER VOCALIC RKANNADA L" +
	"ETTER VOCALIC LKANNADA LETTER EKANNADA LETTER EEKANNADA LETTER AIKANNADA" +
	" LETTER OKANNADA LETTER OOKANNADA LETTER AUKANNADA LETTER KAKANNADA LETT" +
	"ER KHAKANNADA LETTER GAKANNADA LETTER GHAKANNADA LETTER NGAKANNADA LETTE" +
	"R CAKANNADA LETTER CHAKANNADA LETTER JAKANNADA LETTER JHAKANNADA LETTER " +
	"NYAKANNADA LETTER TTAKANNADA LETTER TTHAKANNADA LETTER DDAKANNADA LETTER" +
	" DDHAKANNADA LETTER NNAKANNADA LETTER TAKANNADA LETTER THAKANNADA LETTER" +
	" DAKANNADA LETTER DHAKANNADA LETTER NAKANNADA LETTER PAKANNADA LETTER PH" +
	"AKANNADA LETTER BAKANNADA LETTER BHAKANNADA LETTER MAKANNADA LETTER YAKA" +
	"NNADA LETTER RAKANNADA LETTER RRAKANNADA LETTER LAKANNADA LETTER LLAKANN" +
	"ADA LETTER VAKANNADA LETTER SHAKANNADA LETTER SSAKANNADA LETTER SAKANNAD" +
	"A LETTER HAKANNADA SIGN NUKTAKANNADA SIGN AVAGRAHAKANNADA VOWEL SIGN AAK" +
	"ANNADA VOWEL SIGN IKANNADA VOWEL SIGN IIKANNADA VOWEL SIGN UKANNADA VOWE" +
	"L SIGN UUKANNADA VOWEL SIGN VOCALIC RKANNADA VOWEL SIGN VOCALIC RRKANNAD" +
	"A VOWEL SIGN EKANNADA VOWEL SIGN EEKANNADA VOWEL SIGN AIKANNADA VOWEL SI" +
	"GN OKANNADA VOWEL SIGN OOKANNADA VOWEL SIGN AUKANNADA SIGN VIRAMAKANNADA" +
	" LENGTH MARKKANNADA AI LENGTH MARKKANNADA LETTER FAKANNADA LETTER VOCALI" +
	"C RRKANNADA LETTER VOCALIC LLKANNADA VOWEL SIGN VOCALIC LKANNADA VOWEL S" +
	"IGN VOCALIC LLKANNADA DIGIT ZEROKANNADA DIGIT ONEKANNADA DIGIT TWOKANNAD" +
	"A DIGIT THREEKANNADA DIGIT FOURKANNADA DIGIT FIVEKANNADA DIGIT SIXKANNAD" +
	"A DIGIT SEVENKANNADA DIGIT EIGHTKANNADA DIGIT NINEKANNADA SIGN JIHVAMULI" +
	"YAKANNADA SIGN UPADHMANIYAMALAYALAM SIGN COMBINING ANUSVARA ABOVEMALAYAL" +
	"AM SIGN CANDRABINDUMALAYALAM SIGN ANUSVARAMALAYALAM SIGN VISARGAMALAYALA" +
	"M LETTER AMALAYALAM LETTER AAMALAYALAM LETTER IMALAYALAM LETTER IIMALAYA" +
	"LAM LETTER UMALAYALAM LETTER UUMALAYALAM LETTER VOCALIC RMALAYALAM LETTE") + ("" +
	"R VOCALIC LMALAYALAM LETTER EMALAYALAM LETTER EEMALAYALAM LETTER AIMALAY" +
	"ALAM LETTER OMALAYALAM LETTER OOMALAYALAM LETTER AUMALAYALAM LETTER KAMA" +
	"LAYALAM LETTER KHAMALAYALAM LETTER GAMALAYALAM LETTER GHAMALAYALAM LETTE" +
	"R NGAMALAYALAM LETTER CAMALAYALAM LETTER CHAMALAYALAM LETTER JAMALAYALAM" +
	" LETTER JHAMALAYALAM LETTER NYAMALAYALAM LETTER TTAMALAYALAM LETTER TTHA" +
	"MALAYALAM LETTER DDAMALAYALAM LETTER DDHAMALAYALAM LETTER NNAMALAYALAM L" +
	"ETTER TAMALAYALAM LETTER THAMALAYALAM LETTER DAMALAYALAM LETTER DHAMALAY" +
	"ALAM LETTER NAMALAYALAM LETTER NNNAMALAYALAM LETTER PAMALAYALAM LETTER P" +
	"HAMALAYALAM LETTER BAMALAYALAM LETTER BHAMALAYALAM LETTER MAMALAYALAM LE" +
	"TTER YAMALAYALAM LETTER RAMALAYALAM LETTER RRAMALAYALAM LETTER LAMALAYAL" +
	"AM LETTER LLAMALAYALAM LETTER LLLAMALAYALAM LETTER VAMALAYALAM LETTER SH" +
	"AMALAYALAM LETTER SSAMALAYALAM LETTER SAMALAYALAM LETTER HAMALAYALAM LET" +
	"TER TTTAMALAYALAM SIGN VERTICAL BAR VIRAMAMALAYALAM SIGN CIRCULAR VIRAMA" +
	"MALAYALAM SIGN AVAGRAHAMALAYALAM VOWEL SIGN AAMALAYALAM VOWEL SIGN IMALA" +
	"YALAM VOWEL SIGN IIMALAYALAM VOWEL SIGN UMALAYALAM VOWEL SIGN UUMALAYALA" +
	"M VOWEL SIGN VOCALIC RMALAYALAM VOWEL SIGN VOCALIC RRMALAYALAM VOWEL SIG" +
	"N EMALAYALAM VOWEL SIGN EEMALAYALAM VOWEL SIGN AIMALAYALAM VOWEL SIGN OM" +
	"ALAYALAM VOWEL SIGN OOMALAYALAM VOWEL SIGN AUMALAYALAM SIGN VIRAMAMALAYA" +
	"LAM LETTER DOT REPHMALAYALAM SIGN PARAMALAYALAM LETTER CHILLU MMALAYALAM" +
	" LETTER CHILLU YMALAYALAM LETTER CHILLU LLLMALAYALAM AU LENGTH MARKMALAY" +
	"ALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETHMALAYALAM FRACTION ONE FORTIET" +
	"HMALAYALAM FRACTION THREE EIGHTIETHSMALAYALAM FRACTION ONE TWENTIETHMALA" +
	"YALAM FRACTION ONE TENTHMALAYALAM FRACTION THREE TWENTIETHSMALAYALAM FRA" +
	"CTION ONE FIFTHMALAYALAM LETTER ARCHAIC IIMALAYALAM LETTER VOCALIC RRMAL" +
	"AYALAM LETTER VOCALIC LLMALAYALAM VOWEL SIGN VOCALIC LMALAYALAM VOWEL SI" +
	"GN VOCALIC LLMALAYALAM DIGIT ZEROMALAYALAM DIGIT ONEMALAYALAM DIGIT TWOM" +
	"ALAYALAM DIGIT THREEMALAYALAM DIGIT FOURMALAYALAM DIGIT FIVEMALAYALAM DI" +
	"GIT SIXMALAYALAM DIGIT SEVENMALAYALAM DIGIT EIGHTMALAYALAM DIGIT NINEMAL" +
	"AYALAM NUMBER TENMALAYALAM NUMBER ONE HUNDREDMALAYALAM NUMBER ONE THOUSA" +
	"NDMALAYALAM FRACTION ONE QUARTERMALAYALAM FRACTION ONE HALFMALAYALAM FRA" +
	"CTION THREE QUARTERSMALAYALAM FRACTION ONE SIXTEENTHMALAYALAM FRACTION O" +
	"NE EIGHTHMALAYALAM FRACTION THREE SIXTEENTHSMALAYALAM DATE MARKMALAYALAM" +
	" LETTER CHILLU NNMALAYALAM LETTER CHILLU NMALAYALAM LETTER CHILLU RRMALA" +
	"YALAM LETTER CHILLU LMALAYALAM LETTER CHILLU LLMALAYALAM LETTER CHILLU K" +
	"SINHALA SIGN ANUSVARAYASINHALA SIGN VISARGAYASINHALA LETTER AYANNASINHAL" +
	"A LETTER AAYANNASINHALA LETTER AEYANNASINHALA LETTER AEEYANNASINHALA LET" +
	"TER IYANNASINHALA LETTER IIYANNASINHALA LETTER UYANNASINHALA LETTER UUYA" +
	"NNASINHALA LETTER IRUYANNASINHALA LETTER IRUUYANNASINHALA LETTER ILUYANN" +
	"ASINHALA LETTER ILUUYANNASINHALA LETTER EYANNASINHALA LETTER EEYANNASINH" +
	"ALA LETTER AIYANNASINHALA LETTER OYANNASINHALA LETTER OOYANNASINHALA LET" +
	"TER AUYANNASINHALA LETTER ALPAPRAANA KAYANNASINHALA LETTER MAHAAPRAANA K" +
	"AYANNASINHALA LETTER ALPAPRAANA GAYANNASINHALA LETTER MAHAAPRAANA GAYANN" +
	"ASINHALA LETTER KANTAJA NAASIKYAYASINHALA LETTER SANYAKA GAYANNASINHALA " +
	"LETTER ALPAPRAANA CAYANNASINHALA LETTER MAHAAPRAANA CAYANNASINHALA LETTE" +
	"R ALPAPRAANA JAYANNASINHALA LETTER MAHAAPRAANA JAYANNASINHALA LETTER TAA" +
	"LUJA NAASIKYAYASINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYASINHALA LETTER" +
	" SANYAKA JAYANNASINHALA LETTER ALPAPRAANA TTAYANNASINHALA LETTER MAHAAPR" +
	"AANA TTAYANNASINHALA LETTER ALPAPRAANA DDAYANNASINHALA LETTER MAHAAPRAAN" +
	"A DDAYANNASINHALA LETTER MUURDHAJA NAYANNASINHALA LETTER SANYAKA DDAYANN" +
	"ASINHALA LETTER ALPAPRAANA TAYANNASINHALA LETTER MAHAAPRAANA TAYANNASINH" +
	"ALA LETTER ALPAPRAANA DAYANNASINHALA LETTER MAHAAPRAANA DAYANNASINHALA L" +
	"ETTER DANTAJA NAYANNASINHALA LETTER SANYAKA DAYANNASINHALA LETTER ALPAPR" +
	"AANA PAYANNASINHALA LETTER MAHAAPRAANA PAYANNASINHALA LETTER ALPAPRAANA " +
	"BAYANNASINHALA LETTER MAHAAPRAANA BAYANNASINHALA LETTER MAYANNASINHALA L" +
	"ETTER AMBA BAYANNASINHALA LETTER YAYANNASINHALA LETTER RAYANNASINHALA LE" +
	"TTER DANTAJA LAYANNASINHALA LETTER VAYANNASINHALA LETTER TAALUJA SAYANNA" +
	"SINHALA LETTER MUURDHAJA SAYANNASINHALA LETTER DANTAJA SAYANNASINHALA LE" +
	"TTER HAYANNASINHALA LETTER MUURDHAJA LAYANNASINHALA LETTER FAYANNASINHAL" +
	"A SIGN AL-LAKUNASINHALA VOWEL SIGN AELA-PILLASINHALA VOWEL SIGN KETTI AE" +
	"DA-PILLASINHALA VOWEL SIGN DIGA AEDA-PILLASINHALA VOWEL SIGN KETTI IS-PI" +
	"LLASINHALA VOWEL SIGN DIGA IS-PILLASINHALA VOWEL SIGN KETTI PAA-PILLASIN" +
	"HALA VOWEL SIGN DIGA PAA-PILLASINHALA VOWEL SIGN GAETTA-PILLASINHALA VOW" +
	"EL SIGN KOMBUVASINHALA VOWEL SIGN DIGA KOMBUVASINHALA VOWEL SIGN KOMBU D" +
	"EKASINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLASINHALA VOWEL SIGN KOMBUVA H") + ("" +
	"AA DIGA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTASINHALA VOWE" +
	"L SIGN GAYANUKITTASINHALA LITH DIGIT ZEROSINHALA LITH DIGIT ONESINHALA L" +
	"ITH DIGIT TWOSINHALA LITH DIGIT THREESINHALA LITH DIGIT FOURSINHALA LITH" +
	" DIGIT FIVESINHALA LITH DIGIT SIXSINHALA LITH DIGIT SEVENSINHALA LITH DI" +
	"GIT EIGHTSINHALA LITH DIGIT NINESINHALA VOWEL SIGN DIGA GAETTA-PILLASINH" +
	"ALA VOWEL SIGN DIGA GAYANUKITTASINHALA PUNCTUATION KUNDDALIYATHAI CHARAC" +
	"TER KO KAITHAI CHARACTER KHO KHAITHAI CHARACTER KHO KHUATTHAI CHARACTER " +
	"KHO KHWAITHAI CHARACTER KHO KHONTHAI CHARACTER KHO RAKHANGTHAI CHARACTER" +
	" NGO NGUTHAI CHARACTER CHO CHANTHAI CHARACTER CHO CHINGTHAI CHARACTER CH" +
	"O CHANGTHAI CHARACTER SO SOTHAI CHARACTER CHO CHOETHAI CHARACTER YO YING" +
	"THAI CHARACTER DO CHADATHAI CHARACTER TO PATAKTHAI CHARACTER THO THANTHA" +
	"I CHARACTER THO NANGMONTHOTHAI CHARACTER THO PHUTHAOTHAI CHARACTER NO NE" +
	"NTHAI CHARACTER DO DEKTHAI CHARACTER TO TAOTHAI CHARACTER THO THUNGTHAI " +
	"CHARACTER THO THAHANTHAI CHARACTER THO THONGTHAI CHARACTER NO NUTHAI CHA" +
	"RACTER BO BAIMAITHAI CHARACTER PO PLATHAI CHARACTER PHO PHUNGTHAI CHARAC" +
	"TER FO FATHAI CHARACTER PHO PHANTHAI CHARACTER FO FANTHAI CHARACTER PHO " +
	"SAMPHAOTHAI CHARACTER MO MATHAI CHARACTER YO YAKTHAI CHARACTER RO RUATHA" +
	"I CHARACTER RUTHAI CHARACTER LO LINGTHAI CHARACTER LUTHAI CHARACTER WO W" +
	"AENTHAI CHARACTER SO SALATHAI CHARACTER SO RUSITHAI CHARACTER SO SUATHAI" +
	" CHARACTER HO HIPTHAI CHARACTER LO CHULATHAI CHARACTER O ANGTHAI CHARACT" +
	"ER HO NOKHUKTHAI CHARACTER PAIYANNOITHAI CHARACTER SARA ATHAI CHARACTER " +
	"MAI HAN-AKATTHAI CHARACTER SARA AATHAI CHARACTER SARA AMTHAI CHARACTER S" +
	"ARA ITHAI CHARACTER SARA IITHAI CHARACTER SARA UETHAI CHARACTER SARA UEE" +
	"THAI CHARACTER SARA UTHAI CHARACTER SARA UUTHAI CHARACTER PHINTHUTHAI CU" +
	"RRENCY SYMBOL BAHTTHAI CHARACTER SARA ETHAI CHARACTER SARA AETHAI CHARAC" +
	"TER SARA OTHAI CHARACTER SARA AI MAIMUANTHAI CHARACTER SARA AI MAIMALAIT" +
	"HAI CHARACTER LAKKHANGYAOTHAI CHARACTER MAIYAMOKTHAI CHARACTER MAITAIKHU" +
	"THAI CHARACTER MAI EKTHAI CHARACTER MAI THOTHAI CHARACTER MAI TRITHAI CH" +
	"ARACTER MAI CHATTAWATHAI CHARACTER THANTHAKHATTHAI CHARACTER NIKHAHITTHA" +
	"I CHARACTER YAMAKKANTHAI CHARACTER FONGMANTHAI DIGIT ZEROTHAI DIGIT ONET" +
	"HAI DIGIT TWOTHAI DIGIT THREETHAI DIGIT FOURTHAI DIGIT FIVETHAI DIGIT SI" +
	"XTHAI DIGIT SEVENTHAI DIGIT EIGHTTHAI DIGIT NINETHAI CHARACTER ANGKHANKH" +
	"UTHAI CHARACTER KHOMUTLAO LETTER KOLAO LETTER KHO SUNGLAO LETTER KHO TAM" +
	"LAO LETTER NGOLAO LETTER COLAO LETTER SO TAMLAO LETTER NYOLAO LETTER DOL" +
	"AO LETTER TOLAO LETTER THO SUNGLAO LETTER THO TAMLAO LETTER NOLAO LETTER" +
	" BOLAO LETTER POLAO LETTER PHO SUNGLAO LETTER FO TAMLAO LETTER PHO TAMLA" +
	"O LETTER FO SUNGLAO LETTER MOLAO LETTER YOLAO LETTER LO LINGLAO LETTER L" +
	"O LOOTLAO LETTER WOLAO LETTER SO SUNGLAO LETTER HO SUNGLAO LETTER OLAO L" +
	"ETTER HO TAMLAO ELLIPSISLAO VOWEL SIGN ALAO VOWEL SIGN MAI KANLAO VOWEL " +
	"SIGN AALAO VOWEL SIGN AMLAO VOWEL SIGN ILAO VOWEL SIGN IILAO VOWEL SIGN " +
	"YLAO VOWEL SIGN YYLAO VOWEL SIGN ULAO VOWEL SIGN UULAO VOWEL SIGN MAI KO" +
	"NLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL SIGN NYOLAO VOWEL SIGN ELAO VOWEL SI" +
	"GN EILAO VOWEL SIGN OLAO VOWEL SIGN AYLAO VOWEL SIGN AILAO KO LALAO TONE" +
	" MAI EKLAO TONE MAI THOLAO TONE MAI TILAO TONE MAI CATAWALAO CANCELLATIO" +
	"N MARKLAO NIGGAHITALAO DIGIT ZEROLAO DIGIT ONELAO DIGIT TWOLAO DIGIT THR" +
	"EELAO DIGIT FOURLAO DIGIT FIVELAO DIGIT SIXLAO DIGIT SEVENLAO DIGIT EIGH" +
	"TLAO DIGIT NINELAO HO NOLAO HO MOLAO LETTER KHMU GOLAO LETTER KHMU NYOTI" +
	"BETAN SYLLABLE OMTIBETAN MARK GTER YIG MGO TRUNCATED ATIBETAN MARK GTER " +
	"YIG MGO -UM RNAM BCAD MATIBETAN MARK GTER YIG MGO -UM GTER TSHEG MATIBET" +
	"AN MARK INITIAL YIG MGO MDUN MATIBETAN MARK CLOSING YIG MGO SGAB MATIBET" +
	"AN MARK CARET YIG MGO PHUR SHAD MATIBETAN MARK YIG MGO TSHEG SHAD MATIBE" +
	"TAN MARK SBRUL SHADTIBETAN MARK BSKUR YIG MGOTIBETAN MARK BKA- SHOG YIG " +
	"MGOTIBETAN MARK INTERSYLLABIC TSHEGTIBETAN MARK DELIMITER TSHEG BSTARTIB" +
	"ETAN MARK SHADTIBETAN MARK NYIS SHADTIBETAN MARK TSHEG SHADTIBETAN MARK " +
	"NYIS TSHEG SHADTIBETAN MARK RIN CHEN SPUNGS SHADTIBETAN MARK RGYA GRAM S" +
	"HADTIBETAN MARK CARET -DZUD RTAGS ME LONG CANTIBETAN MARK GTER TSHEGTIBE" +
	"TAN LOGOTYPE SIGN CHAD RTAGSTIBETAN LOGOTYPE SIGN LHAG RTAGSTIBETAN ASTR" +
	"OLOGICAL SIGN SGRA GCAN -CHAR RTAGSTIBETAN ASTROLOGICAL SIGN -KHYUD PATI" +
	"BETAN ASTROLOGICAL SIGN SDONG TSHUGSTIBETAN SIGN RDEL DKAR GCIGTIBETAN S" +
	"IGN RDEL DKAR GNYISTIBETAN SIGN RDEL DKAR GSUMTIBETAN SIGN RDEL NAG GCIG" +
	"TIBETAN SIGN RDEL NAG GNYISTIBETAN SIGN RDEL DKAR RDEL NAGTIBETAN DIGIT " +
	"ZEROTIBETAN DIGIT ONETIBETAN DIGIT TWOTIBETAN DIGIT THREETIBETAN DIGIT F" +
	"OURTIBETAN DIGIT FIVETIBETAN DIGIT SIXTIBETAN DIGIT SEVENTIBETAN DIGIT E" +
	"IGHTTIBETAN DIGIT NINETIBETAN DIGIT HALF ONETIBETAN DIGIT HALF TWOTIBETA") + ("" +
	"N DIGIT HALF THREETIBETAN DIGIT HALF FOURTIBETAN DIGIT HALF FIVETIBETAN " +
	"DIGIT HALF SIXTIBETAN DIGIT HALF SEVENTIBETAN DIGIT HALF EIGHTTIBETAN DI" +
	"GIT HALF NINETIBETAN DIGIT HALF ZEROTIBETAN MARK BSDUS RTAGSTIBETAN MARK" +
	" NGAS BZUNG NYI ZLATIBETAN MARK CARET -DZUD RTAGS BZHI MIG CANTIBETAN MA" +
	"RK NGAS BZUNG SGOR RTAGSTIBETAN MARK CHE MGOTIBETAN MARK TSA -PHRUTIBETA" +
	"N MARK GUG RTAGS GYONTIBETAN MARK GUG RTAGS GYASTIBETAN MARK ANG KHANG G" +
	"YONTIBETAN MARK ANG KHANG GYASTIBETAN SIGN YAR TSHESTIBETAN SIGN MAR TSH" +
	"ESTIBETAN LETTER KATIBETAN LETTER KHATIBETAN LETTER GATIBETAN LETTER GHA" +
	"TIBETAN LETTER NGATIBETAN LETTER CATIBETAN LETTER CHATIBETAN LETTER JATI" +
	"BETAN LETTER NYATIBETAN LETTER TTATIBETAN LETTER TTHATIBETAN LETTER DDAT" +
	"IBETAN LETTER DDHATIBETAN LETTER NNATIBETAN LETTER TATIBETAN LETTER THAT" +
	"IBETAN LETTER DATIBETAN LETTER DHATIBETAN LETTER NATIBETAN LETTER PATIBE" +
	"TAN LETTER PHATIBETAN LETTER BATIBETAN LETTER BHATIBETAN LETTER MATIBETA" +
	"N LETTER TSATIBETAN LETTER TSHATIBETAN LETTER DZATIBETAN LETTER DZHATIBE" +
	"TAN LETTER WATIBETAN LETTER ZHATIBETAN LETTER ZATIBETAN LETTER -ATIBETAN" +
	" LETTER YATIBETAN LETTER RATIBETAN LETTER LATIBETAN LETTER SHATIBETAN LE" +
	"TTER SSATIBETAN LETTER SATIBETAN LETTER HATIBETAN LETTER ATIBETAN LETTER" +
	" KSSATIBETAN LETTER FIXED-FORM RATIBETAN LETTER KKATIBETAN LETTER RRATIB" +
	"ETAN VOWEL SIGN AATIBETAN VOWEL SIGN ITIBETAN VOWEL SIGN IITIBETAN VOWEL" +
	" SIGN UTIBETAN VOWEL SIGN UUTIBETAN VOWEL SIGN VOCALIC RTIBETAN VOWEL SI" +
	"GN VOCALIC RRTIBETAN VOWEL SIGN VOCALIC LTIBETAN VOWEL SIGN VOCALIC LLTI" +
	"BETAN VOWEL SIGN ETIBETAN VOWEL SIGN EETIBETAN VOWEL SIGN OTIBETAN VOWEL" +
	" SIGN OOTIBETAN SIGN RJES SU NGA ROTIBETAN SIGN RNAM BCADTIBETAN VOWEL S" +
	"IGN REVERSED ITIBETAN VOWEL SIGN REVERSED IITIBETAN SIGN NYI ZLA NAA DAT" +
	"IBETAN SIGN SNA LDANTIBETAN MARK HALANTATIBETAN MARK PALUTATIBETAN SIGN " +
	"LCI RTAGSTIBETAN SIGN YANG RTAGSTIBETAN SIGN LCE TSA CANTIBETAN SIGN MCH" +
	"U CANTIBETAN SIGN GRU CAN RGYINGSTIBETAN SIGN GRU MED RGYINGSTIBETAN SIG" +
	"N INVERTED MCHU CANTIBETAN SUBJOINED SIGN LCE TSA CANTIBETAN SUBJOINED S" +
	"IGN MCHU CANTIBETAN SUBJOINED SIGN INVERTED MCHU CANTIBETAN SUBJOINED LE" +
	"TTER KATIBETAN SUBJOINED LETTER KHATIBETAN SUBJOINED LETTER GATIBETAN SU" +
	"BJOINED LETTER GHATIBETAN SUBJOINED LETTER NGATIBETAN SUBJOINED LETTER C" +
	"ATIBETAN SUBJOINED LETTER CHATIBETAN SUBJOINED LETTER JATIBETAN SUBJOINE" +
	"D LETTER NYATIBETAN SUBJOINED LETTER TTATIBETAN SUBJOINED LETTER TTHATIB" +
	"ETAN SUBJOINED LETTER DDATIBETAN SUBJOINED LETTER DDHATIBETAN SUBJOINED " +
	"LETTER NNATIBETAN SUBJOINED LETTER TATIBETAN SUBJOINED LETTER THATIBETAN" +
	" SUBJOINED LETTER DATIBETAN SUBJOINED LETTER DHATIBETAN SUBJOINED LETTER" +
	" NATIBETAN SUBJOINED LETTER PATIBETAN SUBJOINED LETTER PHATIBETAN SUBJOI" +
	"NED LETTER BATIBETAN SUBJOINED LETTER BHATIBETAN SUBJOINED LETTER MATIBE" +
	"TAN SUBJOINED LETTER TSATIBETAN SUBJOINED LETTER TSHATIBETAN SUBJOINED L" +
	"ETTER DZATIBETAN SUBJOINED LETTER DZHATIBETAN SUBJOINED LETTER WATIBETAN" +
	" SUBJOINED LETTER ZHATIBETAN SUBJOINED LETTER ZATIBETAN SUBJOINED LETTER" +
	" -ATIBETAN SUBJOINED LETTER YATIBETAN SUBJOINED LETTER RATIBETAN SUBJOIN" +
	"ED LETTER LATIBETAN SUBJOINED LETTER SHATIBETAN SUBJOINED LETTER SSATIBE" +
	"TAN SUBJOINED LETTER SATIBETAN SUBJOINED LETTER HATIBETAN SUBJOINED LETT" +
	"ER ATIBETAN SUBJOINED LETTER KSSATIBETAN SUBJOINED LETTER FIXED-FORM WAT" +
	"IBETAN SUBJOINED LETTER FIXED-FORM YATIBETAN SUBJOINED LETTER FIXED-FORM" +
	" RATIBETAN KU RU KHATIBETAN KU RU KHA BZHI MIG CANTIBETAN CANTILLATION S" +
	"IGN HEAVY BEATTIBETAN CANTILLATION SIGN LIGHT BEATTIBETAN CANTILLATION S" +
	"IGN CANG TE-UTIBETAN CANTILLATION SIGN SBUB -CHALTIBETAN SYMBOL DRIL BUT" +
	"IBETAN SYMBOL RDO RJETIBETAN SYMBOL PADMA GDANTIBETAN SYMBOL RDO RJE RGY" +
	"A GRAMTIBETAN SYMBOL PHUR PATIBETAN SYMBOL NOR BUTIBETAN SYMBOL NOR BU N" +
	"YIS -KHYILTIBETAN SYMBOL NOR BU GSUM -KHYILTIBETAN SYMBOL NOR BU BZHI -K" +
	"HYILTIBETAN SIGN RDEL NAG RDEL DKARTIBETAN SIGN RDEL NAG GSUMTIBETAN MAR" +
	"K BSKA- SHOG GI MGO RGYANTIBETAN MARK MNYAM YIG GI MGO RGYANTIBETAN MARK" +
	" NYIS TSHEGTIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MATIBETAN MARK " +
	"CLOSING BRDA RNYING YIG MGO SGAB MARIGHT-FACING SVASTI SIGNLEFT-FACING S" +
	"VASTI SIGNRIGHT-FACING SVASTI SIGN WITH DOTSLEFT-FACING SVASTI SIGN WITH" +
	" DOTSTIBETAN MARK LEADING MCHAN RTAGSTIBETAN MARK TRAILING MCHAN RTAGSMY" +
	"ANMAR LETTER KAMYANMAR LETTER KHAMYANMAR LETTER GAMYANMAR LETTER GHAMYAN" +
	"MAR LETTER NGAMYANMAR LETTER CAMYANMAR LETTER CHAMYANMAR LETTER JAMYANMA" +
	"R LETTER JHAMYANMAR LETTER NYAMYANMAR LETTER NNYAMYANMAR LETTER TTAMYANM" +
	"AR LETTER TTHAMYANMAR LETTER DDAMYANMAR LETTER DDHAMYANMAR LETTER NNAMYA" +
	"NMAR LETTER TAMYANMAR LETTER THAMYANMAR LETTER DAMYANMAR LETTER DHAMYANM" +
	"AR LETTER NAMYANMAR LETTER PAMYANMAR LETTER PHAMYANMAR LETTER BAMYANMAR ") + ("" +
	"LETTER BHAMYANMAR LETTER MAMYANMAR LETTER YAMYANMAR LETTER RAMYANMAR LET" +
	"TER LAMYANMAR LETTER WAMYANMAR LETTER SAMYANMAR LETTER HAMYANMAR LETTER " +
	"LLAMYANMAR LETTER AMYANMAR LETTER SHAN AMYANMAR LETTER IMYANMAR LETTER I" +
	"IMYANMAR LETTER UMYANMAR LETTER UUMYANMAR LETTER EMYANMAR LETTER MON EMY" +
	"ANMAR LETTER OMYANMAR LETTER AUMYANMAR VOWEL SIGN TALL AAMYANMAR VOWEL S" +
	"IGN AAMYANMAR VOWEL SIGN IMYANMAR VOWEL SIGN IIMYANMAR VOWEL SIGN UMYANM" +
	"AR VOWEL SIGN UUMYANMAR VOWEL SIGN EMYANMAR VOWEL SIGN AIMYANMAR VOWEL S" +
	"IGN MON IIMYANMAR VOWEL SIGN MON OMYANMAR VOWEL SIGN E ABOVEMYANMAR SIGN" +
	" ANUSVARAMYANMAR SIGN DOT BELOWMYANMAR SIGN VISARGAMYANMAR SIGN VIRAMAMY" +
	"ANMAR SIGN ASATMYANMAR CONSONANT SIGN MEDIAL YAMYANMAR CONSONANT SIGN ME" +
	"DIAL RAMYANMAR CONSONANT SIGN MEDIAL WAMYANMAR CONSONANT SIGN MEDIAL HAM" +
	"YANMAR LETTER GREAT SAMYANMAR DIGIT ZEROMYANMAR DIGIT ONEMYANMAR DIGIT T" +
	"WOMYANMAR DIGIT THREEMYANMAR DIGIT FOURMYANMAR DIGIT FIVEMYANMAR DIGIT S" +
	"IXMYANMAR DIGIT SEVENMYANMAR DIGIT EIGHTMYANMAR DIGIT NINEMYANMAR SIGN L" +
	"ITTLE SECTIONMYANMAR SIGN SECTIONMYANMAR SYMBOL LOCATIVEMYANMAR SYMBOL C" +
	"OMPLETEDMYANMAR SYMBOL AFOREMENTIONEDMYANMAR SYMBOL GENITIVEMYANMAR LETT" +
	"ER SHAMYANMAR LETTER SSAMYANMAR LETTER VOCALIC RMYANMAR LETTER VOCALIC R" +
	"RMYANMAR LETTER VOCALIC LMYANMAR LETTER VOCALIC LLMYANMAR VOWEL SIGN VOC" +
	"ALIC RMYANMAR VOWEL SIGN VOCALIC RRMYANMAR VOWEL SIGN VOCALIC LMYANMAR V" +
	"OWEL SIGN VOCALIC LLMYANMAR LETTER MON NGAMYANMAR LETTER MON JHAMYANMAR " +
	"LETTER MON BBAMYANMAR LETTER MON BBEMYANMAR CONSONANT SIGN MON MEDIAL NA" +
	"MYANMAR CONSONANT SIGN MON MEDIAL MAMYANMAR CONSONANT SIGN MON MEDIAL LA" +
	"MYANMAR LETTER SGAW KAREN SHAMYANMAR VOWEL SIGN SGAW KAREN EUMYANMAR TON" +
	"E MARK SGAW KAREN HATHIMYANMAR TONE MARK SGAW KAREN KE PHOMYANMAR LETTER" +
	" WESTERN PWO KAREN THAMYANMAR LETTER WESTERN PWO KAREN PWAMYANMAR VOWEL " +
	"SIGN WESTERN PWO KAREN EUMYANMAR VOWEL SIGN WESTERN PWO KAREN UEMYANMAR " +
	"SIGN WESTERN PWO KAREN TONE-1MYANMAR SIGN WESTERN PWO KAREN TONE-2MYANMA" +
	"R SIGN WESTERN PWO KAREN TONE-3MYANMAR SIGN WESTERN PWO KAREN TONE-4MYAN" +
	"MAR SIGN WESTERN PWO KAREN TONE-5MYANMAR LETTER EASTERN PWO KAREN NNAMYA" +
	"NMAR LETTER EASTERN PWO KAREN YWAMYANMAR LETTER EASTERN PWO KAREN GHWAMY" +
	"ANMAR VOWEL SIGN GEBA KAREN IMYANMAR VOWEL SIGN KAYAH OEMYANMAR VOWEL SI" +
	"GN KAYAH UMYANMAR VOWEL SIGN KAYAH EEMYANMAR LETTER SHAN KAMYANMAR LETTE" +
	"R SHAN KHAMYANMAR LETTER SHAN GAMYANMAR LETTER SHAN CAMYANMAR LETTER SHA" +
	"N ZAMYANMAR LETTER SHAN NYAMYANMAR LETTER SHAN DAMYANMAR LETTER SHAN NAM" +
	"YANMAR LETTER SHAN PHAMYANMAR LETTER SHAN FAMYANMAR LETTER SHAN BAMYANMA" +
	"R LETTER SHAN THAMYANMAR LETTER SHAN HAMYANMAR CONSONANT SIGN SHAN MEDIA" +
	"L WAMYANMAR VOWEL SIGN SHAN AAMYANMAR VOWEL SIGN SHAN EMYANMAR VOWEL SIG" +
	"N SHAN E ABOVEMYANMAR VOWEL SIGN SHAN FINAL YMYANMAR SIGN SHAN TONE-2MYA" +
	"NMAR SIGN SHAN TONE-3MYANMAR SIGN SHAN TONE-5MYANMAR SIGN SHAN TONE-6MYA" +
	"NMAR SIGN SHAN COUNCIL TONE-2MYANMAR SIGN SHAN COUNCIL TONE-3MYANMAR SIG" +
	"N SHAN COUNCIL EMPHATIC TONEMYANMAR LETTER RUMAI PALAUNG FAMYANMAR SIGN " +
	"RUMAI PALAUNG TONE-5MYANMAR SHAN DIGIT ZEROMYANMAR SHAN DIGIT ONEMYANMAR" +
	" SHAN DIGIT TWOMYANMAR SHAN DIGIT THREEMYANMAR SHAN DIGIT FOURMYANMAR SH" +
	"AN DIGIT FIVEMYANMAR SHAN DIGIT SIXMYANMAR SHAN DIGIT SEVENMYANMAR SHAN " +
	"DIGIT EIGHTMYANMAR SHAN DIGIT NINEMYANMAR SIGN KHAMTI TONE-1MYANMAR SIGN" +
	" KHAMTI TONE-3MYANMAR VOWEL SIGN AITON AMYANMAR VOWEL SIGN AITON AIMYANM" +
	"AR SYMBOL SHAN ONEMYANMAR SYMBOL SHAN EXCLAMATIONGEORGIAN CAPITAL LETTER" +
	" ANGEORGIAN CAPITAL LETTER BANGEORGIAN CAPITAL LETTER GANGEORGIAN CAPITA" +
	"L LETTER DONGEORGIAN CAPITAL LETTER ENGEORGIAN CAPITAL LETTER VINGEORGIA" +
	"N CAPITAL LETTER ZENGEORGIAN CAPITAL LETTER TANGEORGIAN CAPITAL LETTER I" +
	"NGEORGIAN CAPITAL LETTER KANGEORGIAN CAPITAL LETTER LASGEORGIAN CAPITAL " +
	"LETTER MANGEORGIAN CAPITAL LETTER NARGEORGIAN CAPITAL LETTER ONGEORGIAN " +
	"CAPITAL LETTER PARGEORGIAN CAPITAL LETTER ZHARGEORGIAN CAPITAL LETTER RA" +
	"EGEORGIAN CAPITAL LETTER SANGEORGIAN CAPITAL LETTER TARGEORGIAN CAPITAL " +
	"LETTER UNGEORGIAN CAPITAL LETTER PHARGEORGIAN CAPITAL LETTER KHARGEORGIA" +
	"N CAPITAL LETTER GHANGEORGIAN CAPITAL LETTER QARGEORGIAN CAPITAL LETTER " +
	"SHINGEORGIAN CAPITAL LETTER CHINGEORGIAN CAPITAL LETTER CANGEORGIAN CAPI" +
	"TAL LETTER JILGEORGIAN CAPITAL LETTER CILGEORGIAN CAPITAL LETTER CHARGEO" +
	"RGIAN CAPITAL LETTER XANGEORGIAN CAPITAL LETTER JHANGEORGIAN CAPITAL LET" +
	"TER HAEGEORGIAN CAPITAL LETTER HEGEORGIAN CAPITAL LETTER HIEGEORGIAN CAP" +
	"ITAL LETTER WEGEORGIAN CAPITAL LETTER HARGEORGIAN CAPITAL LETTER HOEGEOR" +
	"GIAN CAPITAL LETTER YNGEORGIAN CAPITAL LETTER AENGEORGIAN LETTER ANGEORG" +
	"IAN LETTER BANGEORGIAN LETTER GANGEORGIAN LETTER DONGEORGIAN LETTER ENGE" +
	"ORGIAN LETTER VINGEORGIAN LETTER ZENGEORGIAN LETTER TANGEORGIAN LETTER I") + ("" +
	"NGEORGIAN LETTER KANGEORGIAN LETTER LASGEORGIAN LETTER MANGEORGIAN LETTE" +
	"R NARGEORGIAN LETTER ONGEORGIAN LETTER PARGEORGIAN LETTER ZHARGEORGIAN L" +
	"ETTER RAEGEORGIAN LETTER SANGEORGIAN LETTER TARGEORGIAN LETTER UNGEORGIA" +
	"N LETTER PHARGEORGIAN LETTER KHARGEORGIAN LETTER GHANGEORGIAN LETTER QAR" +
	"GEORGIAN LETTER SHINGEORGIAN LETTER CHINGEORGIAN LETTER CANGEORGIAN LETT" +
	"ER JILGEORGIAN LETTER CILGEORGIAN LETTER CHARGEORGIAN LETTER XANGEORGIAN" +
	" LETTER JHANGEORGIAN LETTER HAEGEORGIAN LETTER HEGEORGIAN LETTER HIEGEOR" +
	"GIAN LETTER WEGEORGIAN LETTER HARGEORGIAN LETTER HOEGEORGIAN LETTER FIGE" +
	"ORGIAN LETTER YNGEORGIAN LETTER ELIFIGEORGIAN LETTER TURNED GANGEORGIAN " +
	"LETTER AINGEORGIAN PARAGRAPH SEPARATORMODIFIER LETTER GEORGIAN NARGEORGI" +
	"AN LETTER AENGEORGIAN LETTER HARD SIGNGEORGIAN LETTER LABIAL SIGNHANGUL " +
	"CHOSEONG KIYEOKHANGUL CHOSEONG SSANGKIYEOKHANGUL CHOSEONG NIEUNHANGUL CH" +
	"OSEONG TIKEUTHANGUL CHOSEONG SSANGTIKEUTHANGUL CHOSEONG RIEULHANGUL CHOS" +
	"EONG MIEUMHANGUL CHOSEONG PIEUPHANGUL CHOSEONG SSANGPIEUPHANGUL CHOSEONG" +
	" SIOSHANGUL CHOSEONG SSANGSIOSHANGUL CHOSEONG IEUNGHANGUL CHOSEONG CIEUC" +
	"HANGUL CHOSEONG SSANGCIEUCHANGUL CHOSEONG CHIEUCHHANGUL CHOSEONG KHIEUKH" +
	"HANGUL CHOSEONG THIEUTHHANGUL CHOSEONG PHIEUPHHANGUL CHOSEONG HIEUHHANGU" +
	"L CHOSEONG NIEUN-KIYEOKHANGUL CHOSEONG SSANGNIEUNHANGUL CHOSEONG NIEUN-T" +
	"IKEUTHANGUL CHOSEONG NIEUN-PIEUPHANGUL CHOSEONG TIKEUT-KIYEOKHANGUL CHOS" +
	"EONG RIEUL-NIEUNHANGUL CHOSEONG SSANGRIEULHANGUL CHOSEONG RIEUL-HIEUHHAN" +
	"GUL CHOSEONG KAPYEOUNRIEULHANGUL CHOSEONG MIEUM-PIEUPHANGUL CHOSEONG KAP" +
	"YEOUNMIEUMHANGUL CHOSEONG PIEUP-KIYEOKHANGUL CHOSEONG PIEUP-NIEUNHANGUL " +
	"CHOSEONG PIEUP-TIKEUTHANGUL CHOSEONG PIEUP-SIOSHANGUL CHOSEONG PIEUP-SIO" +
	"S-KIYEOKHANGUL CHOSEONG PIEUP-SIOS-TIKEUTHANGUL CHOSEONG PIEUP-SIOS-PIEU" +
	"PHANGUL CHOSEONG PIEUP-SSANGSIOSHANGUL CHOSEONG PIEUP-SIOS-CIEUCHANGUL C" +
	"HOSEONG PIEUP-CIEUCHANGUL CHOSEONG PIEUP-CHIEUCHHANGUL CHOSEONG PIEUP-TH" +
	"IEUTHHANGUL CHOSEONG PIEUP-PHIEUPHHANGUL CHOSEONG KAPYEOUNPIEUPHANGUL CH" +
	"OSEONG KAPYEOUNSSANGPIEUPHANGUL CHOSEONG SIOS-KIYEOKHANGUL CHOSEONG SIOS" +
	"-NIEUNHANGUL CHOSEONG SIOS-TIKEUTHANGUL CHOSEONG SIOS-RIEULHANGUL CHOSEO" +
	"NG SIOS-MIEUMHANGUL CHOSEONG SIOS-PIEUPHANGUL CHOSEONG SIOS-PIEUP-KIYEOK" +
	"HANGUL CHOSEONG SIOS-SSANGSIOSHANGUL CHOSEONG SIOS-IEUNGHANGUL CHOSEONG " +
	"SIOS-CIEUCHANGUL CHOSEONG SIOS-CHIEUCHHANGUL CHOSEONG SIOS-KHIEUKHHANGUL" +
	" CHOSEONG SIOS-THIEUTHHANGUL CHOSEONG SIOS-PHIEUPHHANGUL CHOSEONG SIOS-H" +
	"IEUHHANGUL CHOSEONG CHITUEUMSIOSHANGUL CHOSEONG CHITUEUMSSANGSIOSHANGUL " +
	"CHOSEONG CEONGCHIEUMSIOSHANGUL CHOSEONG CEONGCHIEUMSSANGSIOSHANGUL CHOSE" +
	"ONG PANSIOSHANGUL CHOSEONG IEUNG-KIYEOKHANGUL CHOSEONG IEUNG-TIKEUTHANGU" +
	"L CHOSEONG IEUNG-MIEUMHANGUL CHOSEONG IEUNG-PIEUPHANGUL CHOSEONG IEUNG-S" +
	"IOSHANGUL CHOSEONG IEUNG-PANSIOSHANGUL CHOSEONG SSANGIEUNGHANGUL CHOSEON" +
	"G IEUNG-CIEUCHANGUL CHOSEONG IEUNG-CHIEUCHHANGUL CHOSEONG IEUNG-THIEUTHH" +
	"ANGUL CHOSEONG IEUNG-PHIEUPHHANGUL CHOSEONG YESIEUNGHANGUL CHOSEONG CIEU" +
	"C-IEUNGHANGUL CHOSEONG CHITUEUMCIEUCHANGUL CHOSEONG CHITUEUMSSANGCIEUCHA" +
	"NGUL CHOSEONG CEONGCHIEUMCIEUCHANGUL CHOSEONG CEONGCHIEUMSSANGCIEUCHANGU" +
	"L CHOSEONG CHIEUCH-KHIEUKHHANGUL CHOSEONG CHIEUCH-HIEUHHANGUL CHOSEONG C" +
	"HITUEUMCHIEUCHHANGUL CHOSEONG CEONGCHIEUMCHIEUCHHANGUL CHOSEONG PHIEUPH-" +
	"PIEUPHANGUL CHOSEONG KAPYEOUNPHIEUPHHANGUL CHOSEONG SSANGHIEUHHANGUL CHO" +
	"SEONG YEORINHIEUHHANGUL CHOSEONG KIYEOK-TIKEUTHANGUL CHOSEONG NIEUN-SIOS" +
	"HANGUL CHOSEONG NIEUN-CIEUCHANGUL CHOSEONG NIEUN-HIEUHHANGUL CHOSEONG TI" +
	"KEUT-RIEULHANGUL CHOSEONG FILLERHANGUL JUNGSEONG FILLERHANGUL JUNGSEONG " +
	"AHANGUL JUNGSEONG AEHANGUL JUNGSEONG YAHANGUL JUNGSEONG YAEHANGUL JUNGSE" +
	"ONG EOHANGUL JUNGSEONG EHANGUL JUNGSEONG YEOHANGUL JUNGSEONG YEHANGUL JU" +
	"NGSEONG OHANGUL JUNGSEONG WAHANGUL JUNGSEONG WAEHANGUL JUNGSEONG OEHANGU" +
	"L JUNGSEONG YOHANGUL JUNGSEONG UHANGUL JUNGSEONG WEOHANGUL JUNGSEONG WEH" +
	"ANGUL JUNGSEONG WIHANGUL JUNGSEONG YUHANGUL JUNGSEONG EUHANGUL JUNGSEONG" +
	" YIHANGUL JUNGSEONG IHANGUL JUNGSEONG A-OHANGUL JUNGSEONG A-UHANGUL JUNG" +
	"SEONG YA-OHANGUL JUNGSEONG YA-YOHANGUL JUNGSEONG EO-OHANGUL JUNGSEONG EO" +
	"-UHANGUL JUNGSEONG EO-EUHANGUL JUNGSEONG YEO-OHANGUL JUNGSEONG YEO-UHANG" +
	"UL JUNGSEONG O-EOHANGUL JUNGSEONG O-EHANGUL JUNGSEONG O-YEHANGUL JUNGSEO" +
	"NG O-OHANGUL JUNGSEONG O-UHANGUL JUNGSEONG YO-YAHANGUL JUNGSEONG YO-YAEH" +
	"ANGUL JUNGSEONG YO-YEOHANGUL JUNGSEONG YO-OHANGUL JUNGSEONG YO-IHANGUL J" +
	"UNGSEONG U-AHANGUL JUNGSEONG U-AEHANGUL JUNGSEONG U-EO-EUHANGUL JUNGSEON" +
	"G U-YEHANGUL JUNGSEONG U-UHANGUL JUNGSEONG YU-AHANGUL JUNGSEONG YU-EOHAN" +
	"GUL JUNGSEONG YU-EHANGUL JUNGSEONG YU-YEOHANGUL JUNGSEONG YU-YEHANGUL JU" +
	"NGSEONG YU-UHANGUL JUNGSEONG YU-IHANGUL JUNGSEONG EU-UHANGUL JUNGSEONG E" +
	"U-EUHANGUL JUNGSEONG YI-UHANGUL JUNGSEONG I-AHANGUL JUNGSEONG I-YAHANGUL") + ("" +
	" JUNGSEONG I-OHANGUL JUNGSEONG I-UHANGUL JUNGSEONG I-EUHANGUL JUNGSEONG " +
	"I-ARAEAHANGUL JUNGSEONG ARAEAHANGUL JUNGSEONG ARAEA-EOHANGUL JUNGSEONG A" +
	"RAEA-UHANGUL JUNGSEONG ARAEA-IHANGUL JUNGSEONG SSANGARAEAHANGUL JUNGSEON" +
	"G A-EUHANGUL JUNGSEONG YA-UHANGUL JUNGSEONG YEO-YAHANGUL JUNGSEONG O-YAH" +
	"ANGUL JUNGSEONG O-YAEHANGUL JONGSEONG KIYEOKHANGUL JONGSEONG SSANGKIYEOK" +
	"HANGUL JONGSEONG KIYEOK-SIOSHANGUL JONGSEONG NIEUNHANGUL JONGSEONG NIEUN" +
	"-CIEUCHANGUL JONGSEONG NIEUN-HIEUHHANGUL JONGSEONG TIKEUTHANGUL JONGSEON" +
	"G RIEULHANGUL JONGSEONG RIEUL-KIYEOKHANGUL JONGSEONG RIEUL-MIEUMHANGUL J" +
	"ONGSEONG RIEUL-PIEUPHANGUL JONGSEONG RIEUL-SIOSHANGUL JONGSEONG RIEUL-TH" +
	"IEUTHHANGUL JONGSEONG RIEUL-PHIEUPHHANGUL JONGSEONG RIEUL-HIEUHHANGUL JO" +
	"NGSEONG MIEUMHANGUL JONGSEONG PIEUPHANGUL JONGSEONG PIEUP-SIOSHANGUL JON" +
	"GSEONG SIOSHANGUL JONGSEONG SSANGSIOSHANGUL JONGSEONG IEUNGHANGUL JONGSE" +
	"ONG CIEUCHANGUL JONGSEONG CHIEUCHHANGUL JONGSEONG KHIEUKHHANGUL JONGSEON" +
	"G THIEUTHHANGUL JONGSEONG PHIEUPHHANGUL JONGSEONG HIEUHHANGUL JONGSEONG " +
	"KIYEOK-RIEULHANGUL JONGSEONG KIYEOK-SIOS-KIYEOKHANGUL JONGSEONG NIEUN-KI" +
	"YEOKHANGUL JONGSEONG NIEUN-TIKEUTHANGUL JONGSEONG NIEUN-SIOSHANGUL JONGS" +
	"EONG NIEUN-PANSIOSHANGUL JONGSEONG NIEUN-THIEUTHHANGUL JONGSEONG TIKEUT-" +
	"KIYEOKHANGUL JONGSEONG TIKEUT-RIEULHANGUL JONGSEONG RIEUL-KIYEOK-SIOSHAN" +
	"GUL JONGSEONG RIEUL-NIEUNHANGUL JONGSEONG RIEUL-TIKEUTHANGUL JONGSEONG R" +
	"IEUL-TIKEUT-HIEUHHANGUL JONGSEONG SSANGRIEULHANGUL JONGSEONG RIEUL-MIEUM" +
	"-KIYEOKHANGUL JONGSEONG RIEUL-MIEUM-SIOSHANGUL JONGSEONG RIEUL-PIEUP-SIO" +
	"SHANGUL JONGSEONG RIEUL-PIEUP-HIEUHHANGUL JONGSEONG RIEUL-KAPYEOUNPIEUPH" +
	"ANGUL JONGSEONG RIEUL-SSANGSIOSHANGUL JONGSEONG RIEUL-PANSIOSHANGUL JONG" +
	"SEONG RIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-YEORINHIEUHHANGUL JONGSEONG MI" +
	"EUM-KIYEOKHANGUL JONGSEONG MIEUM-RIEULHANGUL JONGSEONG MIEUM-PIEUPHANGUL" +
	" JONGSEONG MIEUM-SIOSHANGUL JONGSEONG MIEUM-SSANGSIOSHANGUL JONGSEONG MI" +
	"EUM-PANSIOSHANGUL JONGSEONG MIEUM-CHIEUCHHANGUL JONGSEONG MIEUM-HIEUHHAN" +
	"GUL JONGSEONG KAPYEOUNMIEUMHANGUL JONGSEONG PIEUP-RIEULHANGUL JONGSEONG " +
	"PIEUP-PHIEUPHHANGUL JONGSEONG PIEUP-HIEUHHANGUL JONGSEONG KAPYEOUNPIEUPH" +
	"ANGUL JONGSEONG SIOS-KIYEOKHANGUL JONGSEONG SIOS-TIKEUTHANGUL JONGSEONG " +
	"SIOS-RIEULHANGUL JONGSEONG SIOS-PIEUPHANGUL JONGSEONG PANSIOSHANGUL JONG" +
	"SEONG IEUNG-KIYEOKHANGUL JONGSEONG IEUNG-SSANGKIYEOKHANGUL JONGSEONG SSA" +
	"NGIEUNGHANGUL JONGSEONG IEUNG-KHIEUKHHANGUL JONGSEONG YESIEUNGHANGUL JON" +
	"GSEONG YESIEUNG-SIOSHANGUL JONGSEONG YESIEUNG-PANSIOSHANGUL JONGSEONG PH" +
	"IEUPH-PIEUPHANGUL JONGSEONG KAPYEOUNPHIEUPHHANGUL JONGSEONG HIEUH-NIEUNH" +
	"ANGUL JONGSEONG HIEUH-RIEULHANGUL JONGSEONG HIEUH-MIEUMHANGUL JONGSEONG " +
	"HIEUH-PIEUPHANGUL JONGSEONG YEORINHIEUHHANGUL JONGSEONG KIYEOK-NIEUNHANG" +
	"UL JONGSEONG KIYEOK-PIEUPHANGUL JONGSEONG KIYEOK-CHIEUCHHANGUL JONGSEONG" +
	" KIYEOK-KHIEUKHHANGUL JONGSEONG KIYEOK-HIEUHHANGUL JONGSEONG SSANGNIEUNE" +
	"THIOPIC SYLLABLE HAETHIOPIC SYLLABLE HUETHIOPIC SYLLABLE HIETHIOPIC SYLL" +
	"ABLE HAAETHIOPIC SYLLABLE HEEETHIOPIC SYLLABLE HEETHIOPIC SYLLABLE HOETH" +
	"IOPIC SYLLABLE HOAETHIOPIC SYLLABLE LAETHIOPIC SYLLABLE LUETHIOPIC SYLLA" +
	"BLE LIETHIOPIC SYLLABLE LAAETHIOPIC SYLLABLE LEEETHIOPIC SYLLABLE LEETHI" +
	"OPIC SYLLABLE LOETHIOPIC SYLLABLE LWAETHIOPIC SYLLABLE HHAETHIOPIC SYLLA" +
	"BLE HHUETHIOPIC SYLLABLE HHIETHIOPIC SYLLABLE HHAAETHIOPIC SYLLABLE HHEE" +
	"ETHIOPIC SYLLABLE HHEETHIOPIC SYLLABLE HHOETHIOPIC SYLLABLE HHWAETHIOPIC" +
	" SYLLABLE MAETHIOPIC SYLLABLE MUETHIOPIC SYLLABLE MIETHIOPIC SYLLABLE MA" +
	"AETHIOPIC SYLLABLE MEEETHIOPIC SYLLABLE MEETHIOPIC SYLLABLE MOETHIOPIC S" +
	"YLLABLE MWAETHIOPIC SYLLABLE SZAETHIOPIC SYLLABLE SZUETHIOPIC SYLLABLE S" +
	"ZIETHIOPIC SYLLABLE SZAAETHIOPIC SYLLABLE SZEEETHIOPIC SYLLABLE SZEETHIO" +
	"PIC SYLLABLE SZOETHIOPIC SYLLABLE SZWAETHIOPIC SYLLABLE RAETHIOPIC SYLLA" +
	"BLE RUETHIOPIC SYLLABLE RIETHIOPIC SYLLABLE RAAETHIOPIC SYLLABLE REEETHI" +
	"OPIC SYLLABLE REETHIOPIC SYLLABLE ROETHIOPIC SYLLABLE RWAETHIOPIC SYLLAB" +
	"LE SAETHIOPIC SYLLABLE SUETHIOPIC SYLLABLE SIETHIOPIC SYLLABLE SAAETHIOP" +
	"IC SYLLABLE SEEETHIOPIC SYLLABLE SEETHIOPIC SYLLABLE SOETHIOPIC SYLLABLE" +
	" SWAETHIOPIC SYLLABLE SHAETHIOPIC SYLLABLE SHUETHIOPIC SYLLABLE SHIETHIO" +
	"PIC SYLLABLE SHAAETHIOPIC SYLLABLE SHEEETHIOPIC SYLLABLE SHEETHIOPIC SYL" +
	"LABLE SHOETHIOPIC SYLLABLE SHWAETHIOPIC SYLLABLE QAETHIOPIC SYLLABLE QUE" +
	"THIOPIC SYLLABLE QIETHIOPIC SYLLABLE QAAETHIOPIC SYLLABLE QEEETHIOPIC SY" +
	"LLABLE QEETHIOPIC SYLLABLE QOETHIOPIC SYLLABLE QOAETHIOPIC SYLLABLE QWAE" +
	"THIOPIC SYLLABLE QWIETHIOPIC SYLLABLE QWAAETHIOPIC SYLLABLE QWEEETHIOPIC" +
	" SYLLABLE QWEETHIOPIC SYLLABLE QHAETHIOPIC SYLLABLE QHUETHIOPIC SYLLABLE" +
	" QHIETHIOPIC SYLLABLE QHAAETHIOPIC SYLLABLE QHEEETHIOPIC SYLLABLE QHEETH" +
	"IOPIC SYLLABLE QHOETHIOPIC SYLLABLE QHWAETHIOPIC SYLLABLE QHWIETHIOPIC S") + ("" +
	"YLLABLE QHWAAETHIOPIC SYLLABLE QHWEEETHIOPIC SYLLABLE QHWEETHIOPIC SYLLA" +
	"BLE BAETHIOPIC SYLLABLE BUETHIOPIC SYLLABLE BIETHIOPIC SYLLABLE BAAETHIO" +
	"PIC SYLLABLE BEEETHIOPIC SYLLABLE BEETHIOPIC SYLLABLE BOETHIOPIC SYLLABL" +
	"E BWAETHIOPIC SYLLABLE VAETHIOPIC SYLLABLE VUETHIOPIC SYLLABLE VIETHIOPI" +
	"C SYLLABLE VAAETHIOPIC SYLLABLE VEEETHIOPIC SYLLABLE VEETHIOPIC SYLLABLE" +
	" VOETHIOPIC SYLLABLE VWAETHIOPIC SYLLABLE TAETHIOPIC SYLLABLE TUETHIOPIC" +
	" SYLLABLE TIETHIOPIC SYLLABLE TAAETHIOPIC SYLLABLE TEEETHIOPIC SYLLABLE " +
	"TEETHIOPIC SYLLABLE TOETHIOPIC SYLLABLE TWAETHIOPIC SYLLABLE CAETHIOPIC " +
	"SYLLABLE CUETHIOPIC SYLLABLE CIETHIOPIC SYLLABLE CAAETHIOPIC SYLLABLE CE" +
	"EETHIOPIC SYLLABLE CEETHIOPIC SYLLABLE COETHIOPIC SYLLABLE CWAETHIOPIC S" +
	"YLLABLE XAETHIOPIC SYLLABLE XUETHIOPIC SYLLABLE XIETHIOPIC SYLLABLE XAAE" +
	"THIOPIC SYLLABLE XEEETHIOPIC SYLLABLE XEETHIOPIC SYLLABLE XOETHIOPIC SYL" +
	"LABLE XOAETHIOPIC SYLLABLE XWAETHIOPIC SYLLABLE XWIETHIOPIC SYLLABLE XWA" +
	"AETHIOPIC SYLLABLE XWEEETHIOPIC SYLLABLE XWEETHIOPIC SYLLABLE NAETHIOPIC" +
	" SYLLABLE NUETHIOPIC SYLLABLE NIETHIOPIC SYLLABLE NAAETHIOPIC SYLLABLE N" +
	"EEETHIOPIC SYLLABLE NEETHIOPIC SYLLABLE NOETHIOPIC SYLLABLE NWAETHIOPIC " +
	"SYLLABLE NYAETHIOPIC SYLLABLE NYUETHIOPIC SYLLABLE NYIETHIOPIC SYLLABLE " +
	"NYAAETHIOPIC SYLLABLE NYEEETHIOPIC SYLLABLE NYEETHIOPIC SYLLABLE NYOETHI" +
	"OPIC SYLLABLE NYWAETHIOPIC SYLLABLE GLOTTAL AETHIOPIC SYLLABLE GLOTTAL U" +
	"ETHIOPIC SYLLABLE GLOTTAL IETHIOPIC SYLLABLE GLOTTAL AAETHIOPIC SYLLABLE" +
	" GLOTTAL EEETHIOPIC SYLLABLE GLOTTAL EETHIOPIC SYLLABLE GLOTTAL OETHIOPI" +
	"C SYLLABLE GLOTTAL WAETHIOPIC SYLLABLE KAETHIOPIC SYLLABLE KUETHIOPIC SY" +
	"LLABLE KIETHIOPIC SYLLABLE KAAETHIOPIC SYLLABLE KEEETHIOPIC SYLLABLE KEE" +
	"THIOPIC SYLLABLE KOETHIOPIC SYLLABLE KOAETHIOPIC SYLLABLE KWAETHIOPIC SY" +
	"LLABLE KWIETHIOPIC SYLLABLE KWAAETHIOPIC SYLLABLE KWEEETHIOPIC SYLLABLE " +
	"KWEETHIOPIC SYLLABLE KXAETHIOPIC SYLLABLE KXUETHIOPIC SYLLABLE KXIETHIOP" +
	"IC SYLLABLE KXAAETHIOPIC SYLLABLE KXEEETHIOPIC SYLLABLE KXEETHIOPIC SYLL" +
	"ABLE KXOETHIOPIC SYLLABLE KXWAETHIOPIC SYLLABLE KXWIETHIOPIC SYLLABLE KX" +
	"WAAETHIOPIC SYLLABLE KXWEEETHIOPIC SYLLABLE KXWEETHIOPIC SYLLABLE WAETHI" +
	"OPIC SYLLABLE WUETHIOPIC SYLLABLE WIETHIOPIC SYLLABLE WAAETHIOPIC SYLLAB" +
	"LE WEEETHIOPIC SYLLABLE WEETHIOPIC SYLLABLE WOETHIOPIC SYLLABLE WOAETHIO" +
	"PIC SYLLABLE PHARYNGEAL AETHIOPIC SYLLABLE PHARYNGEAL UETHIOPIC SYLLABLE" +
	" PHARYNGEAL IETHIOPIC SYLLABLE PHARYNGEAL AAETHIOPIC SYLLABLE PHARYNGEAL" +
	" EEETHIOPIC SYLLABLE PHARYNGEAL EETHIOPIC SYLLABLE PHARYNGEAL OETHIOPIC " +
	"SYLLABLE ZAETHIOPIC SYLLABLE ZUETHIOPIC SYLLABLE ZIETHIOPIC SYLLABLE ZAA" +
	"ETHIOPIC SYLLABLE ZEEETHIOPIC SYLLABLE ZEETHIOPIC SYLLABLE ZOETHIOPIC SY" +
	"LLABLE ZWAETHIOPIC SYLLABLE ZHAETHIOPIC SYLLABLE ZHUETHIOPIC SYLLABLE ZH" +
	"IETHIOPIC SYLLABLE ZHAAETHIOPIC SYLLABLE ZHEEETHIOPIC SYLLABLE ZHEETHIOP" +
	"IC SYLLABLE ZHOETHIOPIC SYLLABLE ZHWAETHIOPIC SYLLABLE YAETHIOPIC SYLLAB" +
	"LE YUETHIOPIC SYLLABLE YIETHIOPIC SYLLABLE YAAETHIOPIC SYLLABLE YEEETHIO" +
	"PIC SYLLABLE YEETHIOPIC SYLLABLE YOETHIOPIC SYLLABLE YOAETHIOPIC SYLLABL" +
	"E DAETHIOPIC SYLLABLE DUETHIOPIC SYLLABLE DIETHIOPIC SYLLABLE DAAETHIOPI" +
	"C SYLLABLE DEEETHIOPIC SYLLABLE DEETHIOPIC SYLLABLE DOETHIOPIC SYLLABLE " +
	"DWAETHIOPIC SYLLABLE DDAETHIOPIC SYLLABLE DDUETHIOPIC SYLLABLE DDIETHIOP" +
	"IC SYLLABLE DDAAETHIOPIC SYLLABLE DDEEETHIOPIC SYLLABLE DDEETHIOPIC SYLL" +
	"ABLE DDOETHIOPIC SYLLABLE DDWAETHIOPIC SYLLABLE JAETHIOPIC SYLLABLE JUET" +
	"HIOPIC SYLLABLE JIETHIOPIC SYLLABLE JAAETHIOPIC SYLLABLE JEEETHIOPIC SYL" +
	"LABLE JEETHIOPIC SYLLABLE JOETHIOPIC SYLLABLE JWAETHIOPIC SYLLABLE GAETH" +
	"IOPIC SYLLABLE GUETHIOPIC SYLLABLE GIETHIOPIC SYLLABLE GAAETHIOPIC SYLLA" +
	"BLE GEEETHIOPIC SYLLABLE GEETHIOPIC SYLLABLE GOETHIOPIC SYLLABLE GOAETHI" +
	"OPIC SYLLABLE GWAETHIOPIC SYLLABLE GWIETHIOPIC SYLLABLE GWAAETHIOPIC SYL" +
	"LABLE GWEEETHIOPIC SYLLABLE GWEETHIOPIC SYLLABLE GGAETHIOPIC SYLLABLE GG" +
	"UETHIOPIC SYLLABLE GGIETHIOPIC SYLLABLE GGAAETHIOPIC SYLLABLE GGEEETHIOP" +
	"IC SYLLABLE GGEETHIOPIC SYLLABLE GGOETHIOPIC SYLLABLE GGWAAETHIOPIC SYLL" +
	"ABLE THAETHIOPIC SYLLABLE THUETHIOPIC SYLLABLE THIETHIOPIC SYLLABLE THAA" +
	"ETHIOPIC SYLLABLE THEEETHIOPIC SYLLABLE THEETHIOPIC SYLLABLE THOETHIOPIC" +
	" SYLLABLE THWAETHIOPIC SYLLABLE CHAETHIOPIC SYLLABLE CHUETHIOPIC SYLLABL" +
	"E CHIETHIOPIC SYLLABLE CHAAETHIOPIC SYLLABLE CHEEETHIOPIC SYLLABLE CHEET" +
	"HIOPIC SYLLABLE CHOETHIOPIC SYLLABLE CHWAETHIOPIC SYLLABLE PHAETHIOPIC S" +
	"YLLABLE PHUETHIOPIC SYLLABLE PHIETHIOPIC SYLLABLE PHAAETHIOPIC SYLLABLE " +
	"PHEEETHIOPIC SYLLABLE PHEETHIOPIC SYLLABLE PHOETHIOPIC SYLLABLE PHWAETHI" +
	"OPIC SYLLABLE TSAETHIOPIC SYLLABLE TSUETHIOPIC SYLLABLE TSIETHIOPIC SYLL" +
	"ABLE TSAAETHIOPIC SYLLABLE TSEEETHIOPIC SYLLABLE TSEETHIOPIC SYLLABLE TS" +
	"OETHIOPIC SYLLABLE TSWAETHIOPIC SYLLABLE TZAETHIOPIC SYLLABLE TZUETHIOPI") + ("" +
	"C SYLLABLE TZIETHIOPIC SYLLABLE TZAAETHIOPIC SYLLABLE TZEEETHIOPIC SYLLA" +
	"BLE TZEETHIOPIC SYLLABLE TZOETHIOPIC SYLLABLE TZOAETHIOPIC SYLLABLE FAET" +
	"HIOPIC SYLLABLE FUETHIOPIC SYLLABLE FIETHIOPIC SYLLABLE FAAETHIOPIC SYLL" +
	"ABLE FEEETHIOPIC SYLLABLE FEETHIOPIC SYLLABLE FOETHIOPIC SYLLABLE FWAETH" +
	"IOPIC SYLLABLE PAETHIOPIC SYLLABLE PUETHIOPIC SYLLABLE PIETHIOPIC SYLLAB" +
	"LE PAAETHIOPIC SYLLABLE PEEETHIOPIC SYLLABLE PEETHIOPIC SYLLABLE POETHIO" +
	"PIC SYLLABLE PWAETHIOPIC SYLLABLE RYAETHIOPIC SYLLABLE MYAETHIOPIC SYLLA" +
	"BLE FYAETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARKETHIOPIC COMBI" +
	"NING VOWEL LENGTH MARKETHIOPIC COMBINING GEMINATION MARKETHIOPIC SECTION" +
	" MARKETHIOPIC WORDSPACEETHIOPIC FULL STOPETHIOPIC COMMAETHIOPIC SEMICOLO" +
	"NETHIOPIC COLONETHIOPIC PREFACE COLONETHIOPIC QUESTION MARKETHIOPIC PARA" +
	"GRAPH SEPARATORETHIOPIC DIGIT ONEETHIOPIC DIGIT TWOETHIOPIC DIGIT THREEE" +
	"THIOPIC DIGIT FOURETHIOPIC DIGIT FIVEETHIOPIC DIGIT SIXETHIOPIC DIGIT SE" +
	"VENETHIOPIC DIGIT EIGHTETHIOPIC DIGIT NINEETHIOPIC NUMBER TENETHIOPIC NU" +
	"MBER TWENTYETHIOPIC NUMBER THIRTYETHIOPIC NUMBER FORTYETHIOPIC NUMBER FI" +
	"FTYETHIOPIC NUMBER SIXTYETHIOPIC NUMBER SEVENTYETHIOPIC NUMBER EIGHTYETH" +
	"IOPIC NUMBER NINETYETHIOPIC NUMBER HUNDREDETHIOPIC NUMBER TEN THOUSANDET" +
	"HIOPIC SYLLABLE SEBATBEIT MWAETHIOPIC SYLLABLE MWIETHIOPIC SYLLABLE MWEE" +
	"ETHIOPIC SYLLABLE MWEETHIOPIC SYLLABLE SEBATBEIT BWAETHIOPIC SYLLABLE BW" +
	"IETHIOPIC SYLLABLE BWEEETHIOPIC SYLLABLE BWEETHIOPIC SYLLABLE SEBATBEIT " +
	"FWAETHIOPIC SYLLABLE FWIETHIOPIC SYLLABLE FWEEETHIOPIC SYLLABLE FWEETHIO" +
	"PIC SYLLABLE SEBATBEIT PWAETHIOPIC SYLLABLE PWIETHIOPIC SYLLABLE PWEEETH" +
	"IOPIC SYLLABLE PWEETHIOPIC TONAL MARK YIZETETHIOPIC TONAL MARK DERETETHI" +
	"OPIC TONAL MARK RIKRIKETHIOPIC TONAL MARK SHORT RIKRIKETHIOPIC TONAL MAR" +
	"K DIFATETHIOPIC TONAL MARK KENATETHIOPIC TONAL MARK CHIRETETHIOPIC TONAL" +
	" MARK HIDETETHIOPIC TONAL MARK DERET-HIDETETHIOPIC TONAL MARK KURTCHEROK" +
	"EE LETTER ACHEROKEE LETTER ECHEROKEE LETTER ICHEROKEE LETTER OCHEROKEE L" +
	"ETTER UCHEROKEE LETTER VCHEROKEE LETTER GACHEROKEE LETTER KACHEROKEE LET" +
	"TER GECHEROKEE LETTER GICHEROKEE LETTER GOCHEROKEE LETTER GUCHEROKEE LET" +
	"TER GVCHEROKEE LETTER HACHEROKEE LETTER HECHEROKEE LETTER HICHEROKEE LET" +
	"TER HOCHEROKEE LETTER HUCHEROKEE LETTER HVCHEROKEE LETTER LACHEROKEE LET" +
	"TER LECHEROKEE LETTER LICHEROKEE LETTER LOCHEROKEE LETTER LUCHEROKEE LET" +
	"TER LVCHEROKEE LETTER MACHEROKEE LETTER MECHEROKEE LETTER MICHEROKEE LET" +
	"TER MOCHEROKEE LETTER MUCHEROKEE LETTER NACHEROKEE LETTER HNACHEROKEE LE" +
	"TTER NAHCHEROKEE LETTER NECHEROKEE LETTER NICHEROKEE LETTER NOCHEROKEE L" +
	"ETTER NUCHEROKEE LETTER NVCHEROKEE LETTER QUACHEROKEE LETTER QUECHEROKEE" +
	" LETTER QUICHEROKEE LETTER QUOCHEROKEE LETTER QUUCHEROKEE LETTER QUVCHER" +
	"OKEE LETTER SACHEROKEE LETTER SCHEROKEE LETTER SECHEROKEE LETTER SICHERO" +
	"KEE LETTER SOCHEROKEE LETTER SUCHEROKEE LETTER SVCHEROKEE LETTER DACHERO" +
	"KEE LETTER TACHEROKEE LETTER DECHEROKEE LETTER TECHEROKEE LETTER DICHERO" +
	"KEE LETTER TICHEROKEE LETTER DOCHEROKEE LETTER DUCHEROKEE LETTER DVCHERO" +
	"KEE LETTER DLACHEROKEE LETTER TLACHEROKEE LETTER TLECHEROKEE LETTER TLIC" +
	"HEROKEE LETTER TLOCHEROKEE LETTER TLUCHEROKEE LETTER TLVCHEROKEE LETTER " +
	"TSACHEROKEE LETTER TSECHEROKEE LETTER TSICHEROKEE LETTER TSOCHEROKEE LET" +
	"TER TSUCHEROKEE LETTER TSVCHEROKEE LETTER WACHEROKEE LETTER WECHEROKEE L" +
	"ETTER WICHEROKEE LETTER WOCHEROKEE LETTER WUCHEROKEE LETTER WVCHEROKEE L" +
	"ETTER YACHEROKEE LETTER YECHEROKEE LETTER YICHEROKEE LETTER YOCHEROKEE L" +
	"ETTER YUCHEROKEE LETTER YVCHEROKEE LETTER MVCHEROKEE SMALL LETTER YECHER" +
	"OKEE SMALL LETTER YICHEROKEE SMALL LETTER YOCHEROKEE SMALL LETTER YUCHER" +
	"OKEE SMALL LETTER YVCHEROKEE SMALL LETTER MVCANADIAN SYLLABICS HYPHENCAN" +
	"ADIAN SYLLABICS ECANADIAN SYLLABICS AAICANADIAN SYLLABICS ICANADIAN SYLL" +
	"ABICS IICANADIAN SYLLABICS OCANADIAN SYLLABICS OOCANADIAN SYLLABICS Y-CR" +
	"EE OOCANADIAN SYLLABICS CARRIER EECANADIAN SYLLABICS CARRIER ICANADIAN S" +
	"YLLABICS ACANADIAN SYLLABICS AACANADIAN SYLLABICS WECANADIAN SYLLABICS W" +
	"EST-CREE WECANADIAN SYLLABICS WICANADIAN SYLLABICS WEST-CREE WICANADIAN " +
	"SYLLABICS WIICANADIAN SYLLABICS WEST-CREE WIICANADIAN SYLLABICS WOCANADI" +
	"AN SYLLABICS WEST-CREE WOCANADIAN SYLLABICS WOOCANADIAN SYLLABICS WEST-C" +
	"REE WOOCANADIAN SYLLABICS NASKAPI WOOCANADIAN SYLLABICS WACANADIAN SYLLA" +
	"BICS WEST-CREE WACANADIAN SYLLABICS WAACANADIAN SYLLABICS WEST-CREE WAAC" +
	"ANADIAN SYLLABICS NASKAPI WAACANADIAN SYLLABICS AICANADIAN SYLLABICS Y-C" +
	"REE WCANADIAN SYLLABICS GLOTTAL STOPCANADIAN SYLLABICS FINAL ACUTECANADI" +
	"AN SYLLABICS FINAL GRAVECANADIAN SYLLABICS FINAL BOTTOM HALF RINGCANADIA" +
	"N SYLLABICS FINAL TOP HALF RINGCANADIAN SYLLABICS FINAL RIGHT HALF RINGC" +
	"ANADIAN SYLLABICS FINAL RINGCANADIAN SYLLABICS FINAL DOUBLE ACUTECANADIA") + ("" +
	"N SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKESCANADIAN SYLLABICS FINAL " +
	"MIDDLE DOTCANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKECANADIAN SYLLA" +
	"BICS FINAL PLUSCANADIAN SYLLABICS FINAL DOWN TACKCANADIAN SYLLABICS ENCA" +
	"NADIAN SYLLABICS INCANADIAN SYLLABICS ONCANADIAN SYLLABICS ANCANADIAN SY" +
	"LLABICS PECANADIAN SYLLABICS PAAICANADIAN SYLLABICS PICANADIAN SYLLABICS" +
	" PIICANADIAN SYLLABICS POCANADIAN SYLLABICS POOCANADIAN SYLLABICS Y-CREE" +
	" POOCANADIAN SYLLABICS CARRIER HEECANADIAN SYLLABICS CARRIER HICANADIAN " +
	"SYLLABICS PACANADIAN SYLLABICS PAACANADIAN SYLLABICS PWECANADIAN SYLLABI" +
	"CS WEST-CREE PWECANADIAN SYLLABICS PWICANADIAN SYLLABICS WEST-CREE PWICA" +
	"NADIAN SYLLABICS PWIICANADIAN SYLLABICS WEST-CREE PWIICANADIAN SYLLABICS" +
	" PWOCANADIAN SYLLABICS WEST-CREE PWOCANADIAN SYLLABICS PWOOCANADIAN SYLL" +
	"ABICS WEST-CREE PWOOCANADIAN SYLLABICS PWACANADIAN SYLLABICS WEST-CREE P" +
	"WACANADIAN SYLLABICS PWAACANADIAN SYLLABICS WEST-CREE PWAACANADIAN SYLLA" +
	"BICS Y-CREE PWAACANADIAN SYLLABICS PCANADIAN SYLLABICS WEST-CREE PCANADI" +
	"AN SYLLABICS CARRIER HCANADIAN SYLLABICS TECANADIAN SYLLABICS TAAICANADI" +
	"AN SYLLABICS TICANADIAN SYLLABICS TIICANADIAN SYLLABICS TOCANADIAN SYLLA" +
	"BICS TOOCANADIAN SYLLABICS Y-CREE TOOCANADIAN SYLLABICS CARRIER DEECANAD" +
	"IAN SYLLABICS CARRIER DICANADIAN SYLLABICS TACANADIAN SYLLABICS TAACANAD" +
	"IAN SYLLABICS TWECANADIAN SYLLABICS WEST-CREE TWECANADIAN SYLLABICS TWIC" +
	"ANADIAN SYLLABICS WEST-CREE TWICANADIAN SYLLABICS TWIICANADIAN SYLLABICS" +
	" WEST-CREE TWIICANADIAN SYLLABICS TWOCANADIAN SYLLABICS WEST-CREE TWOCAN" +
	"ADIAN SYLLABICS TWOOCANADIAN SYLLABICS WEST-CREE TWOOCANADIAN SYLLABICS " +
	"TWACANADIAN SYLLABICS WEST-CREE TWACANADIAN SYLLABICS TWAACANADIAN SYLLA" +
	"BICS WEST-CREE TWAACANADIAN SYLLABICS NASKAPI TWAACANADIAN SYLLABICS TCA" +
	"NADIAN SYLLABICS TTECANADIAN SYLLABICS TTICANADIAN SYLLABICS TTOCANADIAN" +
	" SYLLABICS TTACANADIAN SYLLABICS KECANADIAN SYLLABICS KAAICANADIAN SYLLA" +
	"BICS KICANADIAN SYLLABICS KIICANADIAN SYLLABICS KOCANADIAN SYLLABICS KOO" +
	"CANADIAN SYLLABICS Y-CREE KOOCANADIAN SYLLABICS KACANADIAN SYLLABICS KAA" +
	"CANADIAN SYLLABICS KWECANADIAN SYLLABICS WEST-CREE KWECANADIAN SYLLABICS" +
	" KWICANADIAN SYLLABICS WEST-CREE KWICANADIAN SYLLABICS KWIICANADIAN SYLL" +
	"ABICS WEST-CREE KWIICANADIAN SYLLABICS KWOCANADIAN SYLLABICS WEST-CREE K" +
	"WOCANADIAN SYLLABICS KWOOCANADIAN SYLLABICS WEST-CREE KWOOCANADIAN SYLLA" +
	"BICS KWACANADIAN SYLLABICS WEST-CREE KWACANADIAN SYLLABICS KWAACANADIAN " +
	"SYLLABICS WEST-CREE KWAACANADIAN SYLLABICS NASKAPI KWAACANADIAN SYLLABIC" +
	"S KCANADIAN SYLLABICS KWCANADIAN SYLLABICS SOUTH-SLAVEY KEHCANADIAN SYLL" +
	"ABICS SOUTH-SLAVEY KIHCANADIAN SYLLABICS SOUTH-SLAVEY KOHCANADIAN SYLLAB" +
	"ICS SOUTH-SLAVEY KAHCANADIAN SYLLABICS CECANADIAN SYLLABICS CAAICANADIAN" +
	" SYLLABICS CICANADIAN SYLLABICS CIICANADIAN SYLLABICS COCANADIAN SYLLABI" +
	"CS COOCANADIAN SYLLABICS Y-CREE COOCANADIAN SYLLABICS CACANADIAN SYLLABI" +
	"CS CAACANADIAN SYLLABICS CWECANADIAN SYLLABICS WEST-CREE CWECANADIAN SYL" +
	"LABICS CWICANADIAN SYLLABICS WEST-CREE CWICANADIAN SYLLABICS CWIICANADIA" +
	"N SYLLABICS WEST-CREE CWIICANADIAN SYLLABICS CWOCANADIAN SYLLABICS WEST-" +
	"CREE CWOCANADIAN SYLLABICS CWOOCANADIAN SYLLABICS WEST-CREE CWOOCANADIAN" +
	" SYLLABICS CWACANADIAN SYLLABICS WEST-CREE CWACANADIAN SYLLABICS CWAACAN" +
	"ADIAN SYLLABICS WEST-CREE CWAACANADIAN SYLLABICS NASKAPI CWAACANADIAN SY" +
	"LLABICS CCANADIAN SYLLABICS SAYISI THCANADIAN SYLLABICS MECANADIAN SYLLA" +
	"BICS MAAICANADIAN SYLLABICS MICANADIAN SYLLABICS MIICANADIAN SYLLABICS M" +
	"OCANADIAN SYLLABICS MOOCANADIAN SYLLABICS Y-CREE MOOCANADIAN SYLLABICS M" +
	"ACANADIAN SYLLABICS MAACANADIAN SYLLABICS MWECANADIAN SYLLABICS WEST-CRE" +
	"E MWECANADIAN SYLLABICS MWICANADIAN SYLLABICS WEST-CREE MWICANADIAN SYLL" +
	"ABICS MWIICANADIAN SYLLABICS WEST-CREE MWIICANADIAN SYLLABICS MWOCANADIA" +
	"N SYLLABICS WEST-CREE MWOCANADIAN SYLLABICS MWOOCANADIAN SYLLABICS WEST-" +
	"CREE MWOOCANADIAN SYLLABICS MWACANADIAN SYLLABICS WEST-CREE MWACANADIAN " +
	"SYLLABICS MWAACANADIAN SYLLABICS WEST-CREE MWAACANADIAN SYLLABICS NASKAP" +
	"I MWAACANADIAN SYLLABICS MCANADIAN SYLLABICS WEST-CREE MCANADIAN SYLLABI" +
	"CS MHCANADIAN SYLLABICS ATHAPASCAN MCANADIAN SYLLABICS SAYISI MCANADIAN " +
	"SYLLABICS NECANADIAN SYLLABICS NAAICANADIAN SYLLABICS NICANADIAN SYLLABI" +
	"CS NIICANADIAN SYLLABICS NOCANADIAN SYLLABICS NOOCANADIAN SYLLABICS Y-CR" +
	"EE NOOCANADIAN SYLLABICS NACANADIAN SYLLABICS NAACANADIAN SYLLABICS NWEC" +
	"ANADIAN SYLLABICS WEST-CREE NWECANADIAN SYLLABICS NWACANADIAN SYLLABICS " +
	"WEST-CREE NWACANADIAN SYLLABICS NWAACANADIAN SYLLABICS WEST-CREE NWAACAN" +
	"ADIAN SYLLABICS NASKAPI NWAACANADIAN SYLLABICS NCANADIAN SYLLABICS CARRI" +
	"ER NGCANADIAN SYLLABICS NHCANADIAN SYLLABICS LECANADIAN SYLLABICS LAAICA" +
	"NADIAN SYLLABICS LICANADIAN SYLLABICS LIICANADIAN SYLLABICS LOCANADIAN S") + ("" +
	"YLLABICS LOOCANADIAN SYLLABICS Y-CREE LOOCANADIAN SYLLABICS LACANADIAN S" +
	"YLLABICS LAACANADIAN SYLLABICS LWECANADIAN SYLLABICS WEST-CREE LWECANADI" +
	"AN SYLLABICS LWICANADIAN SYLLABICS WEST-CREE LWICANADIAN SYLLABICS LWIIC" +
	"ANADIAN SYLLABICS WEST-CREE LWIICANADIAN SYLLABICS LWOCANADIAN SYLLABICS" +
	" WEST-CREE LWOCANADIAN SYLLABICS LWOOCANADIAN SYLLABICS WEST-CREE LWOOCA" +
	"NADIAN SYLLABICS LWACANADIAN SYLLABICS WEST-CREE LWACANADIAN SYLLABICS L" +
	"WAACANADIAN SYLLABICS WEST-CREE LWAACANADIAN SYLLABICS LCANADIAN SYLLABI" +
	"CS WEST-CREE LCANADIAN SYLLABICS MEDIAL LCANADIAN SYLLABICS SECANADIAN S" +
	"YLLABICS SAAICANADIAN SYLLABICS SICANADIAN SYLLABICS SIICANADIAN SYLLABI" +
	"CS SOCANADIAN SYLLABICS SOOCANADIAN SYLLABICS Y-CREE SOOCANADIAN SYLLABI" +
	"CS SACANADIAN SYLLABICS SAACANADIAN SYLLABICS SWECANADIAN SYLLABICS WEST" +
	"-CREE SWECANADIAN SYLLABICS SWICANADIAN SYLLABICS WEST-CREE SWICANADIAN " +
	"SYLLABICS SWIICANADIAN SYLLABICS WEST-CREE SWIICANADIAN SYLLABICS SWOCAN" +
	"ADIAN SYLLABICS WEST-CREE SWOCANADIAN SYLLABICS SWOOCANADIAN SYLLABICS W" +
	"EST-CREE SWOOCANADIAN SYLLABICS SWACANADIAN SYLLABICS WEST-CREE SWACANAD" +
	"IAN SYLLABICS SWAACANADIAN SYLLABICS WEST-CREE SWAACANADIAN SYLLABICS NA" +
	"SKAPI SWAACANADIAN SYLLABICS SCANADIAN SYLLABICS ATHAPASCAN SCANADIAN SY" +
	"LLABICS SWCANADIAN SYLLABICS BLACKFOOT SCANADIAN SYLLABICS MOOSE-CREE SK" +
	"CANADIAN SYLLABICS NASKAPI SKWCANADIAN SYLLABICS NASKAPI S-WCANADIAN SYL" +
	"LABICS NASKAPI SPWACANADIAN SYLLABICS NASKAPI STWACANADIAN SYLLABICS NAS" +
	"KAPI SKWACANADIAN SYLLABICS NASKAPI SCWACANADIAN SYLLABICS SHECANADIAN S" +
	"YLLABICS SHICANADIAN SYLLABICS SHIICANADIAN SYLLABICS SHOCANADIAN SYLLAB" +
	"ICS SHOOCANADIAN SYLLABICS SHACANADIAN SYLLABICS SHAACANADIAN SYLLABICS " +
	"SHWECANADIAN SYLLABICS WEST-CREE SHWECANADIAN SYLLABICS SHWICANADIAN SYL" +
	"LABICS WEST-CREE SHWICANADIAN SYLLABICS SHWIICANADIAN SYLLABICS WEST-CRE" +
	"E SHWIICANADIAN SYLLABICS SHWOCANADIAN SYLLABICS WEST-CREE SHWOCANADIAN " +
	"SYLLABICS SHWOOCANADIAN SYLLABICS WEST-CREE SHWOOCANADIAN SYLLABICS SHWA" +
	"CANADIAN SYLLABICS WEST-CREE SHWACANADIAN SYLLABICS SHWAACANADIAN SYLLAB" +
	"ICS WEST-CREE SHWAACANADIAN SYLLABICS SHCANADIAN SYLLABICS YECANADIAN SY" +
	"LLABICS YAAICANADIAN SYLLABICS YICANADIAN SYLLABICS YIICANADIAN SYLLABIC" +
	"S YOCANADIAN SYLLABICS YOOCANADIAN SYLLABICS Y-CREE YOOCANADIAN SYLLABIC" +
	"S YACANADIAN SYLLABICS YAACANADIAN SYLLABICS YWECANADIAN SYLLABICS WEST-" +
	"CREE YWECANADIAN SYLLABICS YWICANADIAN SYLLABICS WEST-CREE YWICANADIAN S" +
	"YLLABICS YWIICANADIAN SYLLABICS WEST-CREE YWIICANADIAN SYLLABICS YWOCANA" +
	"DIAN SYLLABICS WEST-CREE YWOCANADIAN SYLLABICS YWOOCANADIAN SYLLABICS WE" +
	"ST-CREE YWOOCANADIAN SYLLABICS YWACANADIAN SYLLABICS WEST-CREE YWACANADI" +
	"AN SYLLABICS YWAACANADIAN SYLLABICS WEST-CREE YWAACANADIAN SYLLABICS NAS" +
	"KAPI YWAACANADIAN SYLLABICS YCANADIAN SYLLABICS BIBLE-CREE YCANADIAN SYL" +
	"LABICS WEST-CREE YCANADIAN SYLLABICS SAYISI YICANADIAN SYLLABICS RECANAD" +
	"IAN SYLLABICS R-CREE RECANADIAN SYLLABICS WEST-CREE LECANADIAN SYLLABICS" +
	" RAAICANADIAN SYLLABICS RICANADIAN SYLLABICS RIICANADIAN SYLLABICS ROCAN" +
	"ADIAN SYLLABICS ROOCANADIAN SYLLABICS WEST-CREE LOCANADIAN SYLLABICS RAC" +
	"ANADIAN SYLLABICS RAACANADIAN SYLLABICS WEST-CREE LACANADIAN SYLLABICS R" +
	"WAACANADIAN SYLLABICS WEST-CREE RWAACANADIAN SYLLABICS RCANADIAN SYLLABI" +
	"CS WEST-CREE RCANADIAN SYLLABICS MEDIAL RCANADIAN SYLLABICS FECANADIAN S" +
	"YLLABICS FAAICANADIAN SYLLABICS FICANADIAN SYLLABICS FIICANADIAN SYLLABI" +
	"CS FOCANADIAN SYLLABICS FOOCANADIAN SYLLABICS FACANADIAN SYLLABICS FAACA" +
	"NADIAN SYLLABICS FWAACANADIAN SYLLABICS WEST-CREE FWAACANADIAN SYLLABICS" +
	" FCANADIAN SYLLABICS THECANADIAN SYLLABICS N-CREE THECANADIAN SYLLABICS " +
	"THICANADIAN SYLLABICS N-CREE THICANADIAN SYLLABICS THIICANADIAN SYLLABIC" +
	"S N-CREE THIICANADIAN SYLLABICS THOCANADIAN SYLLABICS THOOCANADIAN SYLLA" +
	"BICS THACANADIAN SYLLABICS THAACANADIAN SYLLABICS THWAACANADIAN SYLLABIC" +
	"S WEST-CREE THWAACANADIAN SYLLABICS THCANADIAN SYLLABICS TTHECANADIAN SY" +
	"LLABICS TTHICANADIAN SYLLABICS TTHOCANADIAN SYLLABICS TTHACANADIAN SYLLA" +
	"BICS TTHCANADIAN SYLLABICS TYECANADIAN SYLLABICS TYICANADIAN SYLLABICS T" +
	"YOCANADIAN SYLLABICS TYACANADIAN SYLLABICS NUNAVIK HECANADIAN SYLLABICS " +
	"NUNAVIK HICANADIAN SYLLABICS NUNAVIK HIICANADIAN SYLLABICS NUNAVIK HOCAN" +
	"ADIAN SYLLABICS NUNAVIK HOOCANADIAN SYLLABICS NUNAVIK HACANADIAN SYLLABI" +
	"CS NUNAVIK HAACANADIAN SYLLABICS NUNAVIK HCANADIAN SYLLABICS NUNAVUT HCA" +
	"NADIAN SYLLABICS HKCANADIAN SYLLABICS QAAICANADIAN SYLLABICS QICANADIAN " +
	"SYLLABICS QIICANADIAN SYLLABICS QOCANADIAN SYLLABICS QOOCANADIAN SYLLABI" +
	"CS QACANADIAN SYLLABICS QAACANADIAN SYLLABICS QCANADIAN SYLLABICS TLHECA" +
	"NADIAN SYLLABICS TLHICANADIAN SYLLABICS TLHOCANADIAN SYLLABICS TLHACANAD" +
	"IAN SYLLABICS WEST-CREE RECANADIAN SYLLABICS WEST-CREE RICANADIAN SYLLAB") + ("" +
	"ICS WEST-CREE ROCANADIAN SYLLABICS WEST-CREE RACANADIAN SYLLABICS NGAAIC" +
	"ANADIAN SYLLABICS NGICANADIAN SYLLABICS NGIICANADIAN SYLLABICS NGOCANADI" +
	"AN SYLLABICS NGOOCANADIAN SYLLABICS NGACANADIAN SYLLABICS NGAACANADIAN S" +
	"YLLABICS NGCANADIAN SYLLABICS NNGCANADIAN SYLLABICS SAYISI SHECANADIAN S" +
	"YLLABICS SAYISI SHICANADIAN SYLLABICS SAYISI SHOCANADIAN SYLLABICS SAYIS" +
	"I SHACANADIAN SYLLABICS WOODS-CREE THECANADIAN SYLLABICS WOODS-CREE THIC" +
	"ANADIAN SYLLABICS WOODS-CREE THOCANADIAN SYLLABICS WOODS-CREE THACANADIA" +
	"N SYLLABICS WOODS-CREE THCANADIAN SYLLABICS LHICANADIAN SYLLABICS LHIICA" +
	"NADIAN SYLLABICS LHOCANADIAN SYLLABICS LHOOCANADIAN SYLLABICS LHACANADIA" +
	"N SYLLABICS LHAACANADIAN SYLLABICS LHCANADIAN SYLLABICS TH-CREE THECANAD" +
	"IAN SYLLABICS TH-CREE THICANADIAN SYLLABICS TH-CREE THIICANADIAN SYLLABI" +
	"CS TH-CREE THOCANADIAN SYLLABICS TH-CREE THOOCANADIAN SYLLABICS TH-CREE " +
	"THACANADIAN SYLLABICS TH-CREE THAACANADIAN SYLLABICS TH-CREE THCANADIAN " +
	"SYLLABICS AIVILIK BCANADIAN SYLLABICS BLACKFOOT ECANADIAN SYLLABICS BLAC" +
	"KFOOT ICANADIAN SYLLABICS BLACKFOOT OCANADIAN SYLLABICS BLACKFOOT ACANAD" +
	"IAN SYLLABICS BLACKFOOT WECANADIAN SYLLABICS BLACKFOOT WICANADIAN SYLLAB" +
	"ICS BLACKFOOT WOCANADIAN SYLLABICS BLACKFOOT WACANADIAN SYLLABICS BLACKF" +
	"OOT NECANADIAN SYLLABICS BLACKFOOT NICANADIAN SYLLABICS BLACKFOOT NOCANA" +
	"DIAN SYLLABICS BLACKFOOT NACANADIAN SYLLABICS BLACKFOOT KECANADIAN SYLLA" +
	"BICS BLACKFOOT KICANADIAN SYLLABICS BLACKFOOT KOCANADIAN SYLLABICS BLACK" +
	"FOOT KACANADIAN SYLLABICS SAYISI HECANADIAN SYLLABICS SAYISI HICANADIAN " +
	"SYLLABICS SAYISI HOCANADIAN SYLLABICS SAYISI HACANADIAN SYLLABICS CARRIE" +
	"R GHUCANADIAN SYLLABICS CARRIER GHOCANADIAN SYLLABICS CARRIER GHECANADIA" +
	"N SYLLABICS CARRIER GHEECANADIAN SYLLABICS CARRIER GHICANADIAN SYLLABICS" +
	" CARRIER GHACANADIAN SYLLABICS CARRIER RUCANADIAN SYLLABICS CARRIER ROCA" +
	"NADIAN SYLLABICS CARRIER RECANADIAN SYLLABICS CARRIER REECANADIAN SYLLAB" +
	"ICS CARRIER RICANADIAN SYLLABICS CARRIER RACANADIAN SYLLABICS CARRIER WU" +
	"CANADIAN SYLLABICS CARRIER WOCANADIAN SYLLABICS CARRIER WECANADIAN SYLLA" +
	"BICS CARRIER WEECANADIAN SYLLABICS CARRIER WICANADIAN SYLLABICS CARRIER " +
	"WACANADIAN SYLLABICS CARRIER HWUCANADIAN SYLLABICS CARRIER HWOCANADIAN S" +
	"YLLABICS CARRIER HWECANADIAN SYLLABICS CARRIER HWEECANADIAN SYLLABICS CA" +
	"RRIER HWICANADIAN SYLLABICS CARRIER HWACANADIAN SYLLABICS CARRIER THUCAN" +
	"ADIAN SYLLABICS CARRIER THOCANADIAN SYLLABICS CARRIER THECANADIAN SYLLAB" +
	"ICS CARRIER THEECANADIAN SYLLABICS CARRIER THICANADIAN SYLLABICS CARRIER" +
	" THACANADIAN SYLLABICS CARRIER TTUCANADIAN SYLLABICS CARRIER TTOCANADIAN" +
	" SYLLABICS CARRIER TTECANADIAN SYLLABICS CARRIER TTEECANADIAN SYLLABICS " +
	"CARRIER TTICANADIAN SYLLABICS CARRIER TTACANADIAN SYLLABICS CARRIER PUCA" +
	"NADIAN SYLLABICS CARRIER POCANADIAN SYLLABICS CARRIER PECANADIAN SYLLABI" +
	"CS CARRIER PEECANADIAN SYLLABICS CARRIER PICANADIAN SYLLABICS CARRIER PA" +
	"CANADIAN SYLLABICS CARRIER PCANADIAN SYLLABICS CARRIER GUCANADIAN SYLLAB" +
	"ICS CARRIER GOCANADIAN SYLLABICS CARRIER GECANADIAN SYLLABICS CARRIER GE" +
	"ECANADIAN SYLLABICS CARRIER GICANADIAN SYLLABICS CARRIER GACANADIAN SYLL" +
	"ABICS CARRIER KHUCANADIAN SYLLABICS CARRIER KHOCANADIAN SYLLABICS CARRIE" +
	"R KHECANADIAN SYLLABICS CARRIER KHEECANADIAN SYLLABICS CARRIER KHICANADI" +
	"AN SYLLABICS CARRIER KHACANADIAN SYLLABICS CARRIER KKUCANADIAN SYLLABICS" +
	" CARRIER KKOCANADIAN SYLLABICS CARRIER KKECANADIAN SYLLABICS CARRIER KKE" +
	"ECANADIAN SYLLABICS CARRIER KKICANADIAN SYLLABICS CARRIER KKACANADIAN SY" +
	"LLABICS CARRIER KKCANADIAN SYLLABICS CARRIER NUCANADIAN SYLLABICS CARRIE" +
	"R NOCANADIAN SYLLABICS CARRIER NECANADIAN SYLLABICS CARRIER NEECANADIAN " +
	"SYLLABICS CARRIER NICANADIAN SYLLABICS CARRIER NACANADIAN SYLLABICS CARR" +
	"IER MUCANADIAN SYLLABICS CARRIER MOCANADIAN SYLLABICS CARRIER MECANADIAN" +
	" SYLLABICS CARRIER MEECANADIAN SYLLABICS CARRIER MICANADIAN SYLLABICS CA" +
	"RRIER MACANADIAN SYLLABICS CARRIER YUCANADIAN SYLLABICS CARRIER YOCANADI" +
	"AN SYLLABICS CARRIER YECANADIAN SYLLABICS CARRIER YEECANADIAN SYLLABICS " +
	"CARRIER YICANADIAN SYLLABICS CARRIER YACANADIAN SYLLABICS CARRIER JUCANA" +
	"DIAN SYLLABICS SAYISI JUCANADIAN SYLLABICS CARRIER JOCANADIAN SYLLABICS " +
	"CARRIER JECANADIAN SYLLABICS CARRIER JEECANADIAN SYLLABICS CARRIER JICAN" +
	"ADIAN SYLLABICS SAYISI JICANADIAN SYLLABICS CARRIER JACANADIAN SYLLABICS" +
	" CARRIER JJUCANADIAN SYLLABICS CARRIER JJOCANADIAN SYLLABICS CARRIER JJE" +
	"CANADIAN SYLLABICS CARRIER JJEECANADIAN SYLLABICS CARRIER JJICANADIAN SY" +
	"LLABICS CARRIER JJACANADIAN SYLLABICS CARRIER LUCANADIAN SYLLABICS CARRI" +
	"ER LOCANADIAN SYLLABICS CARRIER LECANADIAN SYLLABICS CARRIER LEECANADIAN" +
	" SYLLABICS CARRIER LICANADIAN SYLLABICS CARRIER LACANADIAN SYLLABICS CAR" +
	"RIER DLUCANADIAN SYLLABICS CARRIER DLOCANADIAN SYLLABICS CARRIER DLECANA") + ("" +
	"DIAN SYLLABICS CARRIER DLEECANADIAN SYLLABICS CARRIER DLICANADIAN SYLLAB" +
	"ICS CARRIER DLACANADIAN SYLLABICS CARRIER LHUCANADIAN SYLLABICS CARRIER " +
	"LHOCANADIAN SYLLABICS CARRIER LHECANADIAN SYLLABICS CARRIER LHEECANADIAN" +
	" SYLLABICS CARRIER LHICANADIAN SYLLABICS CARRIER LHACANADIAN SYLLABICS C" +
	"ARRIER TLHUCANADIAN SYLLABICS CARRIER TLHOCANADIAN SYLLABICS CARRIER TLH" +
	"ECANADIAN SYLLABICS CARRIER TLHEECANADIAN SYLLABICS CARRIER TLHICANADIAN" +
	" SYLLABICS CARRIER TLHACANADIAN SYLLABICS CARRIER TLUCANADIAN SYLLABICS " +
	"CARRIER TLOCANADIAN SYLLABICS CARRIER TLECANADIAN SYLLABICS CARRIER TLEE" +
	"CANADIAN SYLLABICS CARRIER TLICANADIAN SYLLABICS CARRIER TLACANADIAN SYL" +
	"LABICS CARRIER ZUCANADIAN SYLLABICS CARRIER ZOCANADIAN SYLLABICS CARRIER" +
	" ZECANADIAN SYLLABICS CARRIER ZEECANADIAN SYLLABICS CARRIER ZICANADIAN S" +
	"YLLABICS CARRIER ZACANADIAN SYLLABICS CARRIER ZCANADIAN SYLLABICS CARRIE" +
	"R INITIAL ZCANADIAN SYLLABICS CARRIER DZUCANADIAN SYLLABICS CARRIER DZOC" +
	"ANADIAN SYLLABICS CARRIER DZECANADIAN SYLLABICS CARRIER DZEECANADIAN SYL" +
	"LABICS CARRIER DZICANADIAN SYLLABICS CARRIER DZACANADIAN SYLLABICS CARRI" +
	"ER SUCANADIAN SYLLABICS CARRIER SOCANADIAN SYLLABICS CARRIER SECANADIAN " +
	"SYLLABICS CARRIER SEECANADIAN SYLLABICS CARRIER SICANADIAN SYLLABICS CAR" +
	"RIER SACANADIAN SYLLABICS CARRIER SHUCANADIAN SYLLABICS CARRIER SHOCANAD" +
	"IAN SYLLABICS CARRIER SHECANADIAN SYLLABICS CARRIER SHEECANADIAN SYLLABI" +
	"CS CARRIER SHICANADIAN SYLLABICS CARRIER SHACANADIAN SYLLABICS CARRIER S" +
	"HCANADIAN SYLLABICS CARRIER TSUCANADIAN SYLLABICS CARRIER TSOCANADIAN SY" +
	"LLABICS CARRIER TSECANADIAN SYLLABICS CARRIER TSEECANADIAN SYLLABICS CAR" +
	"RIER TSICANADIAN SYLLABICS CARRIER TSACANADIAN SYLLABICS CARRIER CHUCANA" +
	"DIAN SYLLABICS CARRIER CHOCANADIAN SYLLABICS CARRIER CHECANADIAN SYLLABI" +
	"CS CARRIER CHEECANADIAN SYLLABICS CARRIER CHICANADIAN SYLLABICS CARRIER " +
	"CHACANADIAN SYLLABICS CARRIER TTSUCANADIAN SYLLABICS CARRIER TTSOCANADIA" +
	"N SYLLABICS CARRIER TTSECANADIAN SYLLABICS CARRIER TTSEECANADIAN SYLLABI" +
	"CS CARRIER TTSICANADIAN SYLLABICS CARRIER TTSACANADIAN SYLLABICS CHI SIG" +
	"NCANADIAN SYLLABICS FULL STOPCANADIAN SYLLABICS QAICANADIAN SYLLABICS NG" +
	"AICANADIAN SYLLABICS NNGICANADIAN SYLLABICS NNGIICANADIAN SYLLABICS NNGO" +
	"CANADIAN SYLLABICS NNGOOCANADIAN SYLLABICS NNGACANADIAN SYLLABICS NNGAAC" +
	"ANADIAN SYLLABICS WOODS-CREE THWEECANADIAN SYLLABICS WOODS-CREE THWICANA" +
	"DIAN SYLLABICS WOODS-CREE THWIICANADIAN SYLLABICS WOODS-CREE THWOCANADIA" +
	"N SYLLABICS WOODS-CREE THWOOCANADIAN SYLLABICS WOODS-CREE THWACANADIAN S" +
	"YLLABICS WOODS-CREE THWAACANADIAN SYLLABICS WOODS-CREE FINAL THCANADIAN " +
	"SYLLABICS BLACKFOOT WOGHAM SPACE MARKOGHAM LETTER BEITHOGHAM LETTER LUIS" +
	"OGHAM LETTER FEARNOGHAM LETTER SAILOGHAM LETTER NIONOGHAM LETTER UATHOGH" +
	"AM LETTER DAIROGHAM LETTER TINNEOGHAM LETTER COLLOGHAM LETTER CEIRTOGHAM" +
	" LETTER MUINOGHAM LETTER GORTOGHAM LETTER NGEADALOGHAM LETTER STRAIFOGHA" +
	"M LETTER RUISOGHAM LETTER AILMOGHAM LETTER ONNOGHAM LETTER UROGHAM LETTE" +
	"R EADHADHOGHAM LETTER IODHADHOGHAM LETTER EABHADHOGHAM LETTER OROGHAM LE" +
	"TTER UILLEANNOGHAM LETTER IFINOGHAM LETTER EAMHANCHOLLOGHAM LETTER PEITH" +
	"OGHAM FEATHER MARKOGHAM REVERSED FEATHER MARKRUNIC LETTER FEHU FEOH FE F" +
	"RUNIC LETTER VRUNIC LETTER URUZ UR URUNIC LETTER YRRUNIC LETTER YRUNIC L" +
	"ETTER WRUNIC LETTER THURISAZ THURS THORNRUNIC LETTER ETHRUNIC LETTER ANS" +
	"UZ ARUNIC LETTER OS ORUNIC LETTER AC ARUNIC LETTER AESCRUNIC LETTER LONG" +
	"-BRANCH-OSS ORUNIC LETTER SHORT-TWIG-OSS ORUNIC LETTER ORUNIC LETTER OER" +
	"UNIC LETTER ONRUNIC LETTER RAIDO RAD REID RRUNIC LETTER KAUNARUNIC LETTE" +
	"R CENRUNIC LETTER KAUN KRUNIC LETTER GRUNIC LETTER ENGRUNIC LETTER GEBO " +
	"GYFU GRUNIC LETTER GARRUNIC LETTER WUNJO WYNN WRUNIC LETTER HAGLAZ HRUNI" +
	"C LETTER HAEGL HRUNIC LETTER LONG-BRANCH-HAGALL HRUNIC LETTER SHORT-TWIG" +
	"-HAGALL HRUNIC LETTER NAUDIZ NYD NAUD NRUNIC LETTER SHORT-TWIG-NAUD NRUN" +
	"IC LETTER DOTTED-NRUNIC LETTER ISAZ IS ISS IRUNIC LETTER ERUNIC LETTER J" +
	"ERAN JRUNIC LETTER GERRUNIC LETTER LONG-BRANCH-AR AERUNIC LETTER SHORT-T" +
	"WIG-AR ARUNIC LETTER IWAZ EOHRUNIC LETTER PERTHO PEORTH PRUNIC LETTER AL" +
	"GIZ EOLHXRUNIC LETTER SOWILO SRUNIC LETTER SIGEL LONG-BRANCH-SOL SRUNIC " +
	"LETTER SHORT-TWIG-SOL SRUNIC LETTER CRUNIC LETTER ZRUNIC LETTER TIWAZ TI" +
	"R TYR TRUNIC LETTER SHORT-TWIG-TYR TRUNIC LETTER DRUNIC LETTER BERKANAN " +
	"BEORC BJARKAN BRUNIC LETTER SHORT-TWIG-BJARKAN BRUNIC LETTER DOTTED-PRUN" +
	"IC LETTER OPEN-PRUNIC LETTER EHWAZ EH ERUNIC LETTER MANNAZ MAN MRUNIC LE" +
	"TTER LONG-BRANCH-MADR MRUNIC LETTER SHORT-TWIG-MADR MRUNIC LETTER LAUKAZ" +
	" LAGU LOGR LRUNIC LETTER DOTTED-LRUNIC LETTER INGWAZRUNIC LETTER INGRUNI" +
	"C LETTER DAGAZ DAEG DRUNIC LETTER OTHALAN ETHEL ORUNIC LETTER EARRUNIC L" +
	"ETTER IORRUNIC LETTER CWEORTHRUNIC LETTER CALCRUNIC LETTER CEALCRUNIC LE") + ("" +
	"TTER STANRUNIC LETTER LONG-BRANCH-YRRUNIC LETTER SHORT-TWIG-YRRUNIC LETT" +
	"ER ICELANDIC-YRRUNIC LETTER QRUNIC LETTER XRUNIC SINGLE PUNCTUATIONRUNIC" +
	" MULTIPLE PUNCTUATIONRUNIC CROSS PUNCTUATIONRUNIC ARLAUG SYMBOLRUNIC TVI" +
	"MADUR SYMBOLRUNIC BELGTHOR SYMBOLRUNIC LETTER KRUNIC LETTER SHRUNIC LETT" +
	"ER OORUNIC LETTER FRANKS CASKET OSRUNIC LETTER FRANKS CASKET ISRUNIC LET" +
	"TER FRANKS CASKET EHRUNIC LETTER FRANKS CASKET ACRUNIC LETTER FRANKS CAS" +
	"KET AESCTAGALOG LETTER ATAGALOG LETTER ITAGALOG LETTER UTAGALOG LETTER K" +
	"ATAGALOG LETTER GATAGALOG LETTER NGATAGALOG LETTER TATAGALOG LETTER DATA" +
	"GALOG LETTER NATAGALOG LETTER PATAGALOG LETTER BATAGALOG LETTER MATAGALO" +
	"G LETTER YATAGALOG LETTER LATAGALOG LETTER WATAGALOG LETTER SATAGALOG LE" +
	"TTER HATAGALOG VOWEL SIGN ITAGALOG VOWEL SIGN UTAGALOG SIGN VIRAMAHANUNO" +
	"O LETTER AHANUNOO LETTER IHANUNOO LETTER UHANUNOO LETTER KAHANUNOO LETTE" +
	"R GAHANUNOO LETTER NGAHANUNOO LETTER TAHANUNOO LETTER DAHANUNOO LETTER N" +
	"AHANUNOO LETTER PAHANUNOO LETTER BAHANUNOO LETTER MAHANUNOO LETTER YAHAN" +
	"UNOO LETTER RAHANUNOO LETTER LAHANUNOO LETTER WAHANUNOO LETTER SAHANUNOO" +
	" LETTER HAHANUNOO VOWEL SIGN IHANUNOO VOWEL SIGN UHANUNOO SIGN PAMUDPODP" +
	"HILIPPINE SINGLE PUNCTUATIONPHILIPPINE DOUBLE PUNCTUATIONBUHID LETTER AB" +
	"UHID LETTER IBUHID LETTER UBUHID LETTER KABUHID LETTER GABUHID LETTER NG" +
	"ABUHID LETTER TABUHID LETTER DABUHID LETTER NABUHID LETTER PABUHID LETTE" +
	"R BABUHID LETTER MABUHID LETTER YABUHID LETTER RABUHID LETTER LABUHID LE" +
	"TTER WABUHID LETTER SABUHID LETTER HABUHID VOWEL SIGN IBUHID VOWEL SIGN " +
	"UTAGBANWA LETTER ATAGBANWA LETTER ITAGBANWA LETTER UTAGBANWA LETTER KATA" +
	"GBANWA LETTER GATAGBANWA LETTER NGATAGBANWA LETTER TATAGBANWA LETTER DAT" +
	"AGBANWA LETTER NATAGBANWA LETTER PATAGBANWA LETTER BATAGBANWA LETTER MAT" +
	"AGBANWA LETTER YATAGBANWA LETTER LATAGBANWA LETTER WATAGBANWA LETTER SAT" +
	"AGBANWA VOWEL SIGN ITAGBANWA VOWEL SIGN UKHMER LETTER KAKHMER LETTER KHA" +
	"KHMER LETTER KOKHMER LETTER KHOKHMER LETTER NGOKHMER LETTER CAKHMER LETT" +
	"ER CHAKHMER LETTER COKHMER LETTER CHOKHMER LETTER NYOKHMER LETTER DAKHME" +
	"R LETTER TTHAKHMER LETTER DOKHMER LETTER TTHOKHMER LETTER NNOKHMER LETTE" +
	"R TAKHMER LETTER THAKHMER LETTER TOKHMER LETTER THOKHMER LETTER NOKHMER " +
	"LETTER BAKHMER LETTER PHAKHMER LETTER POKHMER LETTER PHOKHMER LETTER MOK" +
	"HMER LETTER YOKHMER LETTER ROKHMER LETTER LOKHMER LETTER VOKHMER LETTER " +
	"SHAKHMER LETTER SSOKHMER LETTER SAKHMER LETTER HAKHMER LETTER LAKHMER LE" +
	"TTER QAKHMER INDEPENDENT VOWEL QAQKHMER INDEPENDENT VOWEL QAAKHMER INDEP" +
	"ENDENT VOWEL QIKHMER INDEPENDENT VOWEL QIIKHMER INDEPENDENT VOWEL QUKHME" +
	"R INDEPENDENT VOWEL QUKKHMER INDEPENDENT VOWEL QUUKHMER INDEPENDENT VOWE" +
	"L QUUVKHMER INDEPENDENT VOWEL RYKHMER INDEPENDENT VOWEL RYYKHMER INDEPEN" +
	"DENT VOWEL LYKHMER INDEPENDENT VOWEL LYYKHMER INDEPENDENT VOWEL QEKHMER " +
	"INDEPENDENT VOWEL QAIKHMER INDEPENDENT VOWEL QOO TYPE ONEKHMER INDEPENDE" +
	"NT VOWEL QOO TYPE TWOKHMER INDEPENDENT VOWEL QAUKHMER VOWEL INHERENT AQK" +
	"HMER VOWEL INHERENT AAKHMER VOWEL SIGN AAKHMER VOWEL SIGN IKHMER VOWEL S" +
	"IGN IIKHMER VOWEL SIGN YKHMER VOWEL SIGN YYKHMER VOWEL SIGN UKHMER VOWEL" +
	" SIGN UUKHMER VOWEL SIGN UAKHMER VOWEL SIGN OEKHMER VOWEL SIGN YAKHMER V" +
	"OWEL SIGN IEKHMER VOWEL SIGN EKHMER VOWEL SIGN AEKHMER VOWEL SIGN AIKHME" +
	"R VOWEL SIGN OOKHMER VOWEL SIGN AUKHMER SIGN NIKAHITKHMER SIGN REAHMUKKH" +
	"MER SIGN YUUKALEAPINTUKHMER SIGN MUUSIKATOANKHMER SIGN TRIISAPKHMER SIGN" +
	" BANTOCKHMER SIGN ROBATKHMER SIGN TOANDAKHIATKHMER SIGN KAKABATKHMER SIG" +
	"N AHSDAKHMER SIGN SAMYOK SANNYAKHMER SIGN VIRIAMKHMER SIGN COENGKHMER SI" +
	"GN BATHAMASATKHMER SIGN KHANKHMER SIGN BARIYOOSANKHMER SIGN CAMNUC PII K" +
	"UUHKHMER SIGN LEK TOOKHMER SIGN BEYYALKHMER SIGN PHNAEK MUANKHMER SIGN K" +
	"OOMUUTKHMER CURRENCY SYMBOL RIELKHMER SIGN AVAKRAHASANYAKHMER SIGN ATTHA" +
	"CANKHMER DIGIT ZEROKHMER DIGIT ONEKHMER DIGIT TWOKHMER DIGIT THREEKHMER " +
	"DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT SIXKHMER DIGIT SEVENKHMER DIGIT EI" +
	"GHTKHMER DIGIT NINEKHMER SYMBOL LEK ATTAK SONKHMER SYMBOL LEK ATTAK MUOY" +
	"KHMER SYMBOL LEK ATTAK PIIKHMER SYMBOL LEK ATTAK BEIKHMER SYMBOL LEK ATT" +
	"AK BUONKHMER SYMBOL LEK ATTAK PRAMKHMER SYMBOL LEK ATTAK PRAM-MUOYKHMER " +
	"SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL LEK ATTAK PRAM-BEIKHMER SYMBOL LEK" +
	" ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOLIAN ELLIPSISMONGOLIAN COMMAMONGOLIA" +
	"N FULL STOPMONGOLIAN COLONMONGOLIAN FOUR DOTSMONGOLIAN TODO SOFT HYPHENM" +
	"ONGOLIAN SIBE SYLLABLE BOUNDARY MARKERMONGOLIAN MANCHU COMMAMONGOLIAN MA" +
	"NCHU FULL STOPMONGOLIAN NIRUGUMONGOLIAN FREE VARIATION SELECTOR ONEMONGO" +
	"LIAN FREE VARIATION SELECTOR TWOMONGOLIAN FREE VARIATION SELECTOR THREEM" +
	"ONGOLIAN VOWEL SEPARATORMONGOLIAN DIGIT ZEROMONGOLIAN DIGIT ONEMONGOLIAN" +
	" DIGIT TWOMONGOLIAN DIGIT THREEMONGOLIAN DIGIT FOURMONGOLIAN DIGIT FIVEM") + ("" +
	"ONGOLIAN DIGIT SIXMONGOLIAN DIGIT SEVENMONGOLIAN DIGIT EIGHTMONGOLIAN DI" +
	"GIT NINEMONGOLIAN LETTER AMONGOLIAN LETTER EMONGOLIAN LETTER IMONGOLIAN " +
	"LETTER OMONGOLIAN LETTER UMONGOLIAN LETTER OEMONGOLIAN LETTER UEMONGOLIA" +
	"N LETTER EEMONGOLIAN LETTER NAMONGOLIAN LETTER ANGMONGOLIAN LETTER BAMON" +
	"GOLIAN LETTER PAMONGOLIAN LETTER QAMONGOLIAN LETTER GAMONGOLIAN LETTER M" +
	"AMONGOLIAN LETTER LAMONGOLIAN LETTER SAMONGOLIAN LETTER SHAMONGOLIAN LET" +
	"TER TAMONGOLIAN LETTER DAMONGOLIAN LETTER CHAMONGOLIAN LETTER JAMONGOLIA" +
	"N LETTER YAMONGOLIAN LETTER RAMONGOLIAN LETTER WAMONGOLIAN LETTER FAMONG" +
	"OLIAN LETTER KAMONGOLIAN LETTER KHAMONGOLIAN LETTER TSAMONGOLIAN LETTER " +
	"ZAMONGOLIAN LETTER HAAMONGOLIAN LETTER ZRAMONGOLIAN LETTER LHAMONGOLIAN " +
	"LETTER ZHIMONGOLIAN LETTER CHIMONGOLIAN LETTER TODO LONG VOWEL SIGNMONGO" +
	"LIAN LETTER TODO EMONGOLIAN LETTER TODO IMONGOLIAN LETTER TODO OMONGOLIA" +
	"N LETTER TODO UMONGOLIAN LETTER TODO OEMONGOLIAN LETTER TODO UEMONGOLIAN" +
	" LETTER TODO ANGMONGOLIAN LETTER TODO BAMONGOLIAN LETTER TODO PAMONGOLIA" +
	"N LETTER TODO QAMONGOLIAN LETTER TODO GAMONGOLIAN LETTER TODO MAMONGOLIA" +
	"N LETTER TODO TAMONGOLIAN LETTER TODO DAMONGOLIAN LETTER TODO CHAMONGOLI" +
	"AN LETTER TODO JAMONGOLIAN LETTER TODO TSAMONGOLIAN LETTER TODO YAMONGOL" +
	"IAN LETTER TODO WAMONGOLIAN LETTER TODO KAMONGOLIAN LETTER TODO GAAMONGO" +
	"LIAN LETTER TODO HAAMONGOLIAN LETTER TODO JIAMONGOLIAN LETTER TODO NIAMO" +
	"NGOLIAN LETTER TODO DZAMONGOLIAN LETTER SIBE EMONGOLIAN LETTER SIBE IMON" +
	"GOLIAN LETTER SIBE IYMONGOLIAN LETTER SIBE UEMONGOLIAN LETTER SIBE UMONG" +
	"OLIAN LETTER SIBE ANGMONGOLIAN LETTER SIBE KAMONGOLIAN LETTER SIBE GAMON" +
	"GOLIAN LETTER SIBE HAMONGOLIAN LETTER SIBE PAMONGOLIAN LETTER SIBE SHAMO" +
	"NGOLIAN LETTER SIBE TAMONGOLIAN LETTER SIBE DAMONGOLIAN LETTER SIBE JAMO" +
	"NGOLIAN LETTER SIBE FAMONGOLIAN LETTER SIBE GAAMONGOLIAN LETTER SIBE HAA" +
	"MONGOLIAN LETTER SIBE TSAMONGOLIAN LETTER SIBE ZAMONGOLIAN LETTER SIBE R" +
	"AAMONGOLIAN LETTER SIBE CHAMONGOLIAN LETTER SIBE ZHAMONGOLIAN LETTER MAN" +
	"CHU IMONGOLIAN LETTER MANCHU KAMONGOLIAN LETTER MANCHU RAMONGOLIAN LETTE" +
	"R MANCHU FAMONGOLIAN LETTER MANCHU ZHAMONGOLIAN LETTER ALI GALI ANUSVARA" +
	" ONEMONGOLIAN LETTER ALI GALI VISARGA ONEMONGOLIAN LETTER ALI GALI DAMAR" +
	"UMONGOLIAN LETTER ALI GALI UBADAMAMONGOLIAN LETTER ALI GALI INVERTED UBA" +
	"DAMAMONGOLIAN LETTER ALI GALI BALUDAMONGOLIAN LETTER ALI GALI THREE BALU" +
	"DAMONGOLIAN LETTER ALI GALI AMONGOLIAN LETTER ALI GALI IMONGOLIAN LETTER" +
	" ALI GALI KAMONGOLIAN LETTER ALI GALI NGAMONGOLIAN LETTER ALI GALI CAMON" +
	"GOLIAN LETTER ALI GALI TTAMONGOLIAN LETTER ALI GALI TTHAMONGOLIAN LETTER" +
	" ALI GALI DDAMONGOLIAN LETTER ALI GALI NNAMONGOLIAN LETTER ALI GALI TAMO" +
	"NGOLIAN LETTER ALI GALI DAMONGOLIAN LETTER ALI GALI PAMONGOLIAN LETTER A" +
	"LI GALI PHAMONGOLIAN LETTER ALI GALI SSAMONGOLIAN LETTER ALI GALI ZHAMON" +
	"GOLIAN LETTER ALI GALI ZAMONGOLIAN LETTER ALI GALI AHMONGOLIAN LETTER TO" +
	"DO ALI GALI TAMONGOLIAN LETTER TODO ALI GALI ZHAMONGOLIAN LETTER MANCHU " +
	"ALI GALI GHAMONGOLIAN LETTER MANCHU ALI GALI NGAMONGOLIAN LETTER MANCHU " +
	"ALI GALI CAMONGOLIAN LETTER MANCHU ALI GALI JHAMONGOLIAN LETTER MANCHU A" +
	"LI GALI TTAMONGOLIAN LETTER MANCHU ALI GALI DDHAMONGOLIAN LETTER MANCHU " +
	"ALI GALI TAMONGOLIAN LETTER MANCHU ALI GALI DHAMONGOLIAN LETTER MANCHU A" +
	"LI GALI SSAMONGOLIAN LETTER MANCHU ALI GALI CYAMONGOLIAN LETTER MANCHU A" +
	"LI GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI ZAMONGOLIAN LETTER ALI GALI " +
	"HALF UMONGOLIAN LETTER ALI GALI HALF YAMONGOLIAN LETTER MANCHU ALI GALI " +
	"BHAMONGOLIAN LETTER ALI GALI DAGALGAMONGOLIAN LETTER MANCHU ALI GALI LHA" +
	"CANADIAN SYLLABICS OYCANADIAN SYLLABICS AYCANADIAN SYLLABICS AAYCANADIAN" +
	" SYLLABICS WAYCANADIAN SYLLABICS POYCANADIAN SYLLABICS PAYCANADIAN SYLLA" +
	"BICS PWOYCANADIAN SYLLABICS TAYCANADIAN SYLLABICS KAYCANADIAN SYLLABICS " +
	"KWAYCANADIAN SYLLABICS MAYCANADIAN SYLLABICS NOYCANADIAN SYLLABICS NAYCA" +
	"NADIAN SYLLABICS LAYCANADIAN SYLLABICS SOYCANADIAN SYLLABICS SAYCANADIAN" +
	" SYLLABICS SHOYCANADIAN SYLLABICS SHAYCANADIAN SYLLABICS SHWOYCANADIAN S" +
	"YLLABICS YOYCANADIAN SYLLABICS YAYCANADIAN SYLLABICS RAYCANADIAN SYLLABI" +
	"CS NWICANADIAN SYLLABICS OJIBWAY NWICANADIAN SYLLABICS NWIICANADIAN SYLL" +
	"ABICS OJIBWAY NWIICANADIAN SYLLABICS NWOCANADIAN SYLLABICS OJIBWAY NWOCA" +
	"NADIAN SYLLABICS NWOOCANADIAN SYLLABICS OJIBWAY NWOOCANADIAN SYLLABICS R" +
	"WEECANADIAN SYLLABICS RWICANADIAN SYLLABICS RWIICANADIAN SYLLABICS RWOCA" +
	"NADIAN SYLLABICS RWOOCANADIAN SYLLABICS RWACANADIAN SYLLABICS OJIBWAY PC" +
	"ANADIAN SYLLABICS OJIBWAY TCANADIAN SYLLABICS OJIBWAY KCANADIAN SYLLABIC" +
	"S OJIBWAY CCANADIAN SYLLABICS OJIBWAY MCANADIAN SYLLABICS OJIBWAY NCANAD" +
	"IAN SYLLABICS OJIBWAY SCANADIAN SYLLABICS OJIBWAY SHCANADIAN SYLLABICS E" +
	"ASTERN WCANADIAN SYLLABICS WESTERN WCANADIAN SYLLABICS FINAL SMALL RINGC") + ("" +
	"ANADIAN SYLLABICS FINAL RAISED DOTCANADIAN SYLLABICS R-CREE RWECANADIAN " +
	"SYLLABICS WEST-CREE LOOCANADIAN SYLLABICS WEST-CREE LAACANADIAN SYLLABIC" +
	"S THWECANADIAN SYLLABICS THWACANADIAN SYLLABICS TTHWECANADIAN SYLLABICS " +
	"TTHOOCANADIAN SYLLABICS TTHAACANADIAN SYLLABICS TLHWECANADIAN SYLLABICS " +
	"TLHOOCANADIAN SYLLABICS SAYISI SHWECANADIAN SYLLABICS SAYISI SHOOCANADIA" +
	"N SYLLABICS SAYISI HOOCANADIAN SYLLABICS CARRIER GWUCANADIAN SYLLABICS C" +
	"ARRIER DENE GEECANADIAN SYLLABICS CARRIER GAACANADIAN SYLLABICS CARRIER " +
	"GWACANADIAN SYLLABICS SAYISI JUUCANADIAN SYLLABICS CARRIER JWACANADIAN S" +
	"YLLABICS BEAVER DENE LCANADIAN SYLLABICS BEAVER DENE RCANADIAN SYLLABICS" +
	" CARRIER DENTAL SLIMBU VOWEL-CARRIER LETTERLIMBU LETTER KALIMBU LETTER K" +
	"HALIMBU LETTER GALIMBU LETTER GHALIMBU LETTER NGALIMBU LETTER CALIMBU LE" +
	"TTER CHALIMBU LETTER JALIMBU LETTER JHALIMBU LETTER YANLIMBU LETTER TALI" +
	"MBU LETTER THALIMBU LETTER DALIMBU LETTER DHALIMBU LETTER NALIMBU LETTER" +
	" PALIMBU LETTER PHALIMBU LETTER BALIMBU LETTER BHALIMBU LETTER MALIMBU L" +
	"ETTER YALIMBU LETTER RALIMBU LETTER LALIMBU LETTER WALIMBU LETTER SHALIM" +
	"BU LETTER SSALIMBU LETTER SALIMBU LETTER HALIMBU LETTER GYANLIMBU LETTER" +
	" TRALIMBU VOWEL SIGN ALIMBU VOWEL SIGN ILIMBU VOWEL SIGN ULIMBU VOWEL SI" +
	"GN EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN OOLIMBU VOWEL SIGN AULIMBU VOWE" +
	"L SIGN ELIMBU VOWEL SIGN OLIMBU SUBJOINED LETTER YALIMBU SUBJOINED LETTE" +
	"R RALIMBU SUBJOINED LETTER WALIMBU SMALL LETTER KALIMBU SMALL LETTER NGA" +
	"LIMBU SMALL LETTER ANUSVARALIMBU SMALL LETTER TALIMBU SMALL LETTER NALIM" +
	"BU SMALL LETTER PALIMBU SMALL LETTER MALIMBU SMALL LETTER RALIMBU SMALL " +
	"LETTER LALIMBU SIGN MUKPHRENGLIMBU SIGN KEMPHRENGLIMBU SIGN SA-ILIMBU SI" +
	"GN LOOLIMBU EXCLAMATION MARKLIMBU QUESTION MARKLIMBU DIGIT ZEROLIMBU DIG" +
	"IT ONELIMBU DIGIT TWOLIMBU DIGIT THREELIMBU DIGIT FOURLIMBU DIGIT FIVELI" +
	"MBU DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGIT EIGHTLIMBU DIGIT NINETAI LE LE" +
	"TTER KATAI LE LETTER XATAI LE LETTER NGATAI LE LETTER TSATAI LE LETTER S" +
	"ATAI LE LETTER YATAI LE LETTER TATAI LE LETTER THATAI LE LETTER LATAI LE" +
	" LETTER PATAI LE LETTER PHATAI LE LETTER MATAI LE LETTER FATAI LE LETTER" +
	" VATAI LE LETTER HATAI LE LETTER QATAI LE LETTER KHATAI LE LETTER TSHATA" +
	"I LE LETTER NATAI LE LETTER ATAI LE LETTER ITAI LE LETTER EETAI LE LETTE" +
	"R EHTAI LE LETTER UTAI LE LETTER OOTAI LE LETTER OTAI LE LETTER UETAI LE" +
	" LETTER ETAI LE LETTER AUETAI LE LETTER AITAI LE LETTER TONE-2TAI LE LET" +
	"TER TONE-3TAI LE LETTER TONE-4TAI LE LETTER TONE-5TAI LE LETTER TONE-6NE" +
	"W TAI LUE LETTER HIGH QANEW TAI LUE LETTER LOW QANEW TAI LUE LETTER HIGH" +
	" KANEW TAI LUE LETTER HIGH XANEW TAI LUE LETTER HIGH NGANEW TAI LUE LETT" +
	"ER LOW KANEW TAI LUE LETTER LOW XANEW TAI LUE LETTER LOW NGANEW TAI LUE " +
	"LETTER HIGH TSANEW TAI LUE LETTER HIGH SANEW TAI LUE LETTER HIGH YANEW T" +
	"AI LUE LETTER LOW TSANEW TAI LUE LETTER LOW SANEW TAI LUE LETTER LOW YAN" +
	"EW TAI LUE LETTER HIGH TANEW TAI LUE LETTER HIGH THANEW TAI LUE LETTER H" +
	"IGH NANEW TAI LUE LETTER LOW TANEW TAI LUE LETTER LOW THANEW TAI LUE LET" +
	"TER LOW NANEW TAI LUE LETTER HIGH PANEW TAI LUE LETTER HIGH PHANEW TAI L" +
	"UE LETTER HIGH MANEW TAI LUE LETTER LOW PANEW TAI LUE LETTER LOW PHANEW " +
	"TAI LUE LETTER LOW MANEW TAI LUE LETTER HIGH FANEW TAI LUE LETTER HIGH V" +
	"ANEW TAI LUE LETTER HIGH LANEW TAI LUE LETTER LOW FANEW TAI LUE LETTER L" +
	"OW VANEW TAI LUE LETTER LOW LANEW TAI LUE LETTER HIGH HANEW TAI LUE LETT" +
	"ER HIGH DANEW TAI LUE LETTER HIGH BANEW TAI LUE LETTER LOW HANEW TAI LUE" +
	" LETTER LOW DANEW TAI LUE LETTER LOW BANEW TAI LUE LETTER HIGH KVANEW TA" +
	"I LUE LETTER HIGH XVANEW TAI LUE LETTER LOW KVANEW TAI LUE LETTER LOW XV" +
	"ANEW TAI LUE LETTER HIGH SUANEW TAI LUE LETTER LOW SUANEW TAI LUE VOWEL " +
	"SIGN VOWEL SHORTENERNEW TAI LUE VOWEL SIGN AANEW TAI LUE VOWEL SIGN IINE" +
	"W TAI LUE VOWEL SIGN UNEW TAI LUE VOWEL SIGN UUNEW TAI LUE VOWEL SIGN EN" +
	"EW TAI LUE VOWEL SIGN AENEW TAI LUE VOWEL SIGN ONEW TAI LUE VOWEL SIGN O" +
	"ANEW TAI LUE VOWEL SIGN UENEW TAI LUE VOWEL SIGN AYNEW TAI LUE VOWEL SIG" +
	"N AAYNEW TAI LUE VOWEL SIGN UYNEW TAI LUE VOWEL SIGN OYNEW TAI LUE VOWEL" +
	" SIGN OAYNEW TAI LUE VOWEL SIGN UEYNEW TAI LUE VOWEL SIGN IYNEW TAI LUE " +
	"LETTER FINAL VNEW TAI LUE LETTER FINAL NGNEW TAI LUE LETTER FINAL NNEW T" +
	"AI LUE LETTER FINAL MNEW TAI LUE LETTER FINAL KNEW TAI LUE LETTER FINAL " +
	"DNEW TAI LUE LETTER FINAL BNEW TAI LUE TONE MARK-1NEW TAI LUE TONE MARK-" +
	"2NEW TAI LUE DIGIT ZERONEW TAI LUE DIGIT ONENEW TAI LUE DIGIT TWONEW TAI" +
	" LUE DIGIT THREENEW TAI LUE DIGIT FOURNEW TAI LUE DIGIT FIVENEW TAI LUE " +
	"DIGIT SIXNEW TAI LUE DIGIT SEVENNEW TAI LUE DIGIT EIGHTNEW TAI LUE DIGIT" +
	" NINENEW TAI LUE THAM DIGIT ONENEW TAI LUE SIGN LAENEW TAI LUE SIGN LAEV" +
	"KHMER SYMBOL PATHAMASATKHMER SYMBOL MUOY KOETKHMER SYMBOL PII KOETKHMER ") + ("" +
	"SYMBOL BEI KOETKHMER SYMBOL BUON KOETKHMER SYMBOL PRAM KOETKHMER SYMBOL " +
	"PRAM-MUOY KOETKHMER SYMBOL PRAM-PII KOETKHMER SYMBOL PRAM-BEI KOETKHMER " +
	"SYMBOL PRAM-BUON KOETKHMER SYMBOL DAP KOETKHMER SYMBOL DAP-MUOY KOETKHME" +
	"R SYMBOL DAP-PII KOETKHMER SYMBOL DAP-BEI KOETKHMER SYMBOL DAP-BUON KOET" +
	"KHMER SYMBOL DAP-PRAM KOETKHMER SYMBOL TUTEYASATKHMER SYMBOL MUOY ROCKHM" +
	"ER SYMBOL PII ROCKHMER SYMBOL BEI ROCKHMER SYMBOL BUON ROCKHMER SYMBOL P" +
	"RAM ROCKHMER SYMBOL PRAM-MUOY ROCKHMER SYMBOL PRAM-PII ROCKHMER SYMBOL P" +
	"RAM-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHMER SYMBOL DAP ROCKHMER SYMBOL DA" +
	"P-MUOY ROCKHMER SYMBOL DAP-PII ROCKHMER SYMBOL DAP-BEI ROCKHMER SYMBOL D" +
	"AP-BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGINESE LETTER KABUGINESE LETTER GA" +
	"BUGINESE LETTER NGABUGINESE LETTER NGKABUGINESE LETTER PABUGINESE LETTER" +
	" BABUGINESE LETTER MABUGINESE LETTER MPABUGINESE LETTER TABUGINESE LETTE" +
	"R DABUGINESE LETTER NABUGINESE LETTER NRABUGINESE LETTER CABUGINESE LETT" +
	"ER JABUGINESE LETTER NYABUGINESE LETTER NYCABUGINESE LETTER YABUGINESE L" +
	"ETTER RABUGINESE LETTER LABUGINESE LETTER VABUGINESE LETTER SABUGINESE L" +
	"ETTER ABUGINESE LETTER HABUGINESE VOWEL SIGN IBUGINESE VOWEL SIGN UBUGIN" +
	"ESE VOWEL SIGN EBUGINESE VOWEL SIGN OBUGINESE VOWEL SIGN AEBUGINESE PALL" +
	"AWABUGINESE END OF SECTIONTAI THAM LETTER HIGH KATAI THAM LETTER HIGH KH" +
	"ATAI THAM LETTER HIGH KXATAI THAM LETTER LOW KATAI THAM LETTER LOW KXATA" +
	"I THAM LETTER LOW KHATAI THAM LETTER NGATAI THAM LETTER HIGH CATAI THAM " +
	"LETTER HIGH CHATAI THAM LETTER LOW CATAI THAM LETTER LOW SATAI THAM LETT" +
	"ER LOW CHATAI THAM LETTER NYATAI THAM LETTER RATATAI THAM LETTER HIGH RA" +
	"THATAI THAM LETTER DATAI THAM LETTER LOW RATHATAI THAM LETTER RANATAI TH" +
	"AM LETTER HIGH TATAI THAM LETTER HIGH THATAI THAM LETTER LOW TATAI THAM " +
	"LETTER LOW THATAI THAM LETTER NATAI THAM LETTER BATAI THAM LETTER HIGH P" +
	"ATAI THAM LETTER HIGH PHATAI THAM LETTER HIGH FATAI THAM LETTER LOW PATA" +
	"I THAM LETTER LOW FATAI THAM LETTER LOW PHATAI THAM LETTER MATAI THAM LE" +
	"TTER LOW YATAI THAM LETTER HIGH YATAI THAM LETTER RATAI THAM LETTER RUET" +
	"AI THAM LETTER LATAI THAM LETTER LUETAI THAM LETTER WATAI THAM LETTER HI" +
	"GH SHATAI THAM LETTER HIGH SSATAI THAM LETTER HIGH SATAI THAM LETTER HIG" +
	"H HATAI THAM LETTER LLATAI THAM LETTER ATAI THAM LETTER LOW HATAI THAM L" +
	"ETTER ITAI THAM LETTER IITAI THAM LETTER UTAI THAM LETTER UUTAI THAM LET" +
	"TER EETAI THAM LETTER OOTAI THAM LETTER LAETAI THAM LETTER GREAT SATAI T" +
	"HAM CONSONANT SIGN MEDIAL RATAI THAM CONSONANT SIGN MEDIAL LATAI THAM CO" +
	"NSONANT SIGN LA TANG LAITAI THAM SIGN MAI KANG LAITAI THAM CONSONANT SIG" +
	"N FINAL NGATAI THAM CONSONANT SIGN LOW PATAI THAM CONSONANT SIGN HIGH RA" +
	"THA OR LOW PATAI THAM CONSONANT SIGN MATAI THAM CONSONANT SIGN BATAI THA" +
	"M CONSONANT SIGN SATAI THAM SIGN SAKOTTAI THAM VOWEL SIGN ATAI THAM VOWE" +
	"L SIGN MAI SATTAI THAM VOWEL SIGN AATAI THAM VOWEL SIGN TALL AATAI THAM " +
	"VOWEL SIGN ITAI THAM VOWEL SIGN IITAI THAM VOWEL SIGN UETAI THAM VOWEL S" +
	"IGN UUETAI THAM VOWEL SIGN UTAI THAM VOWEL SIGN UUTAI THAM VOWEL SIGN OT" +
	"AI THAM VOWEL SIGN OA BELOWTAI THAM VOWEL SIGN OYTAI THAM VOWEL SIGN ETA" +
	"I THAM VOWEL SIGN AETAI THAM VOWEL SIGN OOTAI THAM VOWEL SIGN AITAI THAM" +
	" VOWEL SIGN THAM AITAI THAM VOWEL SIGN OA ABOVETAI THAM SIGN MAI KANGTAI" +
	" THAM SIGN TONE-1TAI THAM SIGN TONE-2TAI THAM SIGN KHUEN TONE-3TAI THAM " +
	"SIGN KHUEN TONE-4TAI THAM SIGN KHUEN TONE-5TAI THAM SIGN RA HAAMTAI THAM" +
	" SIGN MAI SAMTAI THAM SIGN KHUEN-LUE KARANTAI THAM COMBINING CRYPTOGRAMM" +
	"IC DOTTAI THAM HORA DIGIT ZEROTAI THAM HORA DIGIT ONETAI THAM HORA DIGIT" +
	" TWOTAI THAM HORA DIGIT THREETAI THAM HORA DIGIT FOURTAI THAM HORA DIGIT" +
	" FIVETAI THAM HORA DIGIT SIXTAI THAM HORA DIGIT SEVENTAI THAM HORA DIGIT" +
	" EIGHTTAI THAM HORA DIGIT NINETAI THAM THAM DIGIT ZEROTAI THAM THAM DIGI" +
	"T ONETAI THAM THAM DIGIT TWOTAI THAM THAM DIGIT THREETAI THAM THAM DIGIT" +
	" FOURTAI THAM THAM DIGIT FIVETAI THAM THAM DIGIT SIXTAI THAM THAM DIGIT " +
	"SEVENTAI THAM THAM DIGIT EIGHTTAI THAM THAM DIGIT NINETAI THAM SIGN WIAN" +
	"GTAI THAM SIGN WIANGWAAKTAI THAM SIGN SAWANTAI THAM SIGN KEOWTAI THAM SI" +
	"GN HOYTAI THAM SIGN DOKMAITAI THAM SIGN REVERSED ROTATED RANATAI THAM SI" +
	"GN MAI YAMOKTAI THAM SIGN KAANTAI THAM SIGN KAANKUUTAI THAM SIGN SATKAAN" +
	"TAI THAM SIGN SATKAANKUUTAI THAM SIGN HANGTAI THAM SIGN CAANGCOMBINING D" +
	"OUBLED CIRCUMFLEX ACCENTCOMBINING DIAERESIS-RINGCOMBINING INFINITYCOMBIN" +
	"ING DOWNWARDS ARROWCOMBINING TRIPLE DOTCOMBINING X-X BELOWCOMBINING WIGG" +
	"LY LINE BELOWCOMBINING OPEN MARK BELOWCOMBINING DOUBLE OPEN MARK BELOWCO" +
	"MBINING LIGHT CENTRALIZATION STROKE BELOWCOMBINING STRONG CENTRALIZATION" +
	" STROKE BELOWCOMBINING PARENTHESES ABOVECOMBINING DOUBLE PARENTHESES ABO" +
	"VECOMBINING PARENTHESES BELOWCOMBINING PARENTHESES OVERLAYBALINESE SIGN ") + ("" +
	"ULU RICEMBALINESE SIGN ULU CANDRABALINESE SIGN CECEKBALINESE SIGN SURANG" +
	"BALINESE SIGN BISAHBALINESE LETTER AKARABALINESE LETTER AKARA TEDUNGBALI" +
	"NESE LETTER IKARABALINESE LETTER IKARA TEDUNGBALINESE LETTER UKARABALINE" +
	"SE LETTER UKARA TEDUNGBALINESE LETTER RA REPABALINESE LETTER RA REPA TED" +
	"UNGBALINESE LETTER LA LENGABALINESE LETTER LA LENGA TEDUNGBALINESE LETTE" +
	"R EKARABALINESE LETTER AIKARABALINESE LETTER OKARABALINESE LETTER OKARA " +
	"TEDUNGBALINESE LETTER KABALINESE LETTER KA MAHAPRANABALINESE LETTER GABA" +
	"LINESE LETTER GA GORABALINESE LETTER NGABALINESE LETTER CABALINESE LETTE" +
	"R CA LACABALINESE LETTER JABALINESE LETTER JA JERABALINESE LETTER NYABAL" +
	"INESE LETTER TA LATIKBALINESE LETTER TA MURDA MAHAPRANABALINESE LETTER D" +
	"A MURDA ALPAPRANABALINESE LETTER DA MURDA MAHAPRANABALINESE LETTER NA RA" +
	"MBATBALINESE LETTER TABALINESE LETTER TA TAWABALINESE LETTER DABALINESE " +
	"LETTER DA MADUBALINESE LETTER NABALINESE LETTER PABALINESE LETTER PA KAP" +
	"ALBALINESE LETTER BABALINESE LETTER BA KEMBANGBALINESE LETTER MABALINESE" +
	" LETTER YABALINESE LETTER RABALINESE LETTER LABALINESE LETTER WABALINESE" +
	" LETTER SA SAGABALINESE LETTER SA SAPABALINESE LETTER SABALINESE LETTER " +
	"HABALINESE SIGN REREKANBALINESE VOWEL SIGN TEDUNGBALINESE VOWEL SIGN ULU" +
	"BALINESE VOWEL SIGN ULU SARIBALINESE VOWEL SIGN SUKUBALINESE VOWEL SIGN " +
	"SUKU ILUTBALINESE VOWEL SIGN RA REPABALINESE VOWEL SIGN RA REPA TEDUNGBA" +
	"LINESE VOWEL SIGN LA LENGABALINESE VOWEL SIGN LA LENGA TEDUNGBALINESE VO" +
	"WEL SIGN TALINGBALINESE VOWEL SIGN TALING REPABALINESE VOWEL SIGN TALING" +
	" TEDUNGBALINESE VOWEL SIGN TALING REPA TEDUNGBALINESE VOWEL SIGN PEPETBA" +
	"LINESE VOWEL SIGN PEPET TEDUNGBALINESE ADEG ADEGBALINESE LETTER KAF SASA" +
	"KBALINESE LETTER KHOT SASAKBALINESE LETTER TZIR SASAKBALINESE LETTER EF " +
	"SASAKBALINESE LETTER VE SASAKBALINESE LETTER ZAL SASAKBALINESE LETTER AS" +
	"YURA SASAKBALINESE DIGIT ZEROBALINESE DIGIT ONEBALINESE DIGIT TWOBALINES" +
	"E DIGIT THREEBALINESE DIGIT FOURBALINESE DIGIT FIVEBALINESE DIGIT SIXBAL" +
	"INESE DIGIT SEVENBALINESE DIGIT EIGHTBALINESE DIGIT NINEBALINESE PANTIBA" +
	"LINESE PAMADABALINESE WINDUBALINESE CARIK PAMUNGKAHBALINESE CARIK SIKIBA" +
	"LINESE CARIK PARERENBALINESE PAMENENGBALINESE MUSICAL SYMBOL DONGBALINES" +
	"E MUSICAL SYMBOL DENGBALINESE MUSICAL SYMBOL DUNGBALINESE MUSICAL SYMBOL" +
	" DANGBALINESE MUSICAL SYMBOL DANG SURANGBALINESE MUSICAL SYMBOL DINGBALI" +
	"NESE MUSICAL SYMBOL DAENGBALINESE MUSICAL SYMBOL DEUNGBALINESE MUSICAL S" +
	"YMBOL DAINGBALINESE MUSICAL SYMBOL DANG GEDEBALINESE MUSICAL SYMBOL COMB" +
	"INING TEGEHBALINESE MUSICAL SYMBOL COMBINING ENDEPBALINESE MUSICAL SYMBO" +
	"L COMBINING KEMPULBALINESE MUSICAL SYMBOL COMBINING KEMPLIBALINESE MUSIC" +
	"AL SYMBOL COMBINING JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH" +
	" JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGANBALINESE MU" +
	"SICAL SYMBOL COMBINING BENDEBALINESE MUSICAL SYMBOL COMBINING GONGBALINE" +
	"SE MUSICAL SYMBOL RIGHT-HAND OPEN DUGBALINESE MUSICAL SYMBOL RIGHT-HAND " +
	"OPEN DAGBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUKBALINESE MUSICAL SY" +
	"MBOL RIGHT-HAND CLOSED TAKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANGBAL" +
	"INESE MUSICAL SYMBOL LEFT-HAND OPEN PUNGBALINESE MUSICAL SYMBOL LEFT-HAN" +
	"D CLOSED PLAKBALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUKBALINESE MUSIC" +
	"AL SYMBOL LEFT-HAND OPEN PINGSUNDANESE SIGN PANYECEKSUNDANESE SIGN PANGL" +
	"AYARSUNDANESE SIGN PANGWISADSUNDANESE LETTER ASUNDANESE LETTER ISUNDANES" +
	"E LETTER USUNDANESE LETTER AESUNDANESE LETTER OSUNDANESE LETTER ESUNDANE" +
	"SE LETTER EUSUNDANESE LETTER KASUNDANESE LETTER QASUNDANESE LETTER GASUN" +
	"DANESE LETTER NGASUNDANESE LETTER CASUNDANESE LETTER JASUNDANESE LETTER " +
	"ZASUNDANESE LETTER NYASUNDANESE LETTER TASUNDANESE LETTER DASUNDANESE LE" +
	"TTER NASUNDANESE LETTER PASUNDANESE LETTER FASUNDANESE LETTER VASUNDANES" +
	"E LETTER BASUNDANESE LETTER MASUNDANESE LETTER YASUNDANESE LETTER RASUND" +
	"ANESE LETTER LASUNDANESE LETTER WASUNDANESE LETTER SASUNDANESE LETTER XA" +
	"SUNDANESE LETTER HASUNDANESE CONSONANT SIGN PAMINGKALSUNDANESE CONSONANT" +
	" SIGN PANYAKRASUNDANESE CONSONANT SIGN PANYIKUSUNDANESE VOWEL SIGN PANGH" +
	"ULUSUNDANESE VOWEL SIGN PANYUKUSUNDANESE VOWEL SIGN PANAELAENGSUNDANESE " +
	"VOWEL SIGN PANOLONGSUNDANESE VOWEL SIGN PAMEPETSUNDANESE VOWEL SIGN PANE" +
	"ULEUNGSUNDANESE SIGN PAMAAEHSUNDANESE SIGN VIRAMASUNDANESE CONSONANT SIG" +
	"N PASANGAN MASUNDANESE CONSONANT SIGN PASANGAN WASUNDANESE LETTER KHASUN" +
	"DANESE LETTER SYASUNDANESE DIGIT ZEROSUNDANESE DIGIT ONESUNDANESE DIGIT " +
	"TWOSUNDANESE DIGIT THREESUNDANESE DIGIT FOURSUNDANESE DIGIT FIVESUNDANES" +
	"E DIGIT SIXSUNDANESE DIGIT SEVENSUNDANESE DIGIT EIGHTSUNDANESE DIGIT NIN" +
	"ESUNDANESE AVAGRAHASUNDANESE LETTER REUSUNDANESE LETTER LEUSUNDANESE LET" +
	"TER BHASUNDANESE LETTER FINAL KSUNDANESE LETTER FINAL MBATAK LETTER ABAT") + ("" +
	"AK LETTER SIMALUNGUN ABATAK LETTER HABATAK LETTER SIMALUNGUN HABATAK LET" +
	"TER MANDAILING HABATAK LETTER BABATAK LETTER KARO BABATAK LETTER PABATAK" +
	" LETTER SIMALUNGUN PABATAK LETTER NABATAK LETTER MANDAILING NABATAK LETT" +
	"ER WABATAK LETTER SIMALUNGUN WABATAK LETTER PAKPAK WABATAK LETTER GABATA" +
	"K LETTER SIMALUNGUN GABATAK LETTER JABATAK LETTER DABATAK LETTER RABATAK" +
	" LETTER SIMALUNGUN RABATAK LETTER MABATAK LETTER SIMALUNGUN MABATAK LETT" +
	"ER SOUTHERN TABATAK LETTER NORTHERN TABATAK LETTER SABATAK LETTER SIMALU" +
	"NGUN SABATAK LETTER MANDAILING SABATAK LETTER YABATAK LETTER SIMALUNGUN " +
	"YABATAK LETTER NGABATAK LETTER LABATAK LETTER SIMALUNGUN LABATAK LETTER " +
	"NYABATAK LETTER CABATAK LETTER NDABATAK LETTER MBABATAK LETTER IBATAK LE" +
	"TTER UBATAK SIGN TOMPIBATAK VOWEL SIGN EBATAK VOWEL SIGN PAKPAK EBATAK V" +
	"OWEL SIGN EEBATAK VOWEL SIGN IBATAK VOWEL SIGN KARO IBATAK VOWEL SIGN OB" +
	"ATAK VOWEL SIGN KARO OBATAK VOWEL SIGN UBATAK VOWEL SIGN U FOR SIMALUNGU" +
	"N SABATAK CONSONANT SIGN NGBATAK CONSONANT SIGN HBATAK PANGOLATBATAK PAN" +
	"ONGONANBATAK SYMBOL BINDU NA METEKBATAK SYMBOL BINDU PINARBORASBATAK SYM" +
	"BOL BINDU JUDULBATAK SYMBOL BINDU PANGOLATLEPCHA LETTER KALEPCHA LETTER " +
	"KLALEPCHA LETTER KHALEPCHA LETTER GALEPCHA LETTER GLALEPCHA LETTER NGALE" +
	"PCHA LETTER CALEPCHA LETTER CHALEPCHA LETTER JALEPCHA LETTER NYALEPCHA L" +
	"ETTER TALEPCHA LETTER THALEPCHA LETTER DALEPCHA LETTER NALEPCHA LETTER P" +
	"ALEPCHA LETTER PLALEPCHA LETTER PHALEPCHA LETTER FALEPCHA LETTER FLALEPC" +
	"HA LETTER BALEPCHA LETTER BLALEPCHA LETTER MALEPCHA LETTER MLALEPCHA LET" +
	"TER TSALEPCHA LETTER TSHALEPCHA LETTER DZALEPCHA LETTER YALEPCHA LETTER " +
	"RALEPCHA LETTER LALEPCHA LETTER HALEPCHA LETTER HLALEPCHA LETTER VALEPCH" +
	"A LETTER SALEPCHA LETTER SHALEPCHA LETTER WALEPCHA LETTER ALEPCHA SUBJOI" +
	"NED LETTER YALEPCHA SUBJOINED LETTER RALEPCHA VOWEL SIGN AALEPCHA VOWEL " +
	"SIGN ILEPCHA VOWEL SIGN OLEPCHA VOWEL SIGN OOLEPCHA VOWEL SIGN ULEPCHA V" +
	"OWEL SIGN UULEPCHA VOWEL SIGN ELEPCHA CONSONANT SIGN KLEPCHA CONSONANT S" +
	"IGN MLEPCHA CONSONANT SIGN LLEPCHA CONSONANT SIGN NLEPCHA CONSONANT SIGN" +
	" PLEPCHA CONSONANT SIGN RLEPCHA CONSONANT SIGN TLEPCHA CONSONANT SIGN NY" +
	"IN-DOLEPCHA CONSONANT SIGN KANGLEPCHA SIGN RANLEPCHA SIGN NUKTALEPCHA PU" +
	"NCTUATION TA-ROLLEPCHA PUNCTUATION NYET THYOOM TA-ROLLEPCHA PUNCTUATION " +
	"CER-WALEPCHA PUNCTUATION TSHOOK CER-WALEPCHA PUNCTUATION TSHOOKLEPCHA DI" +
	"GIT ZEROLEPCHA DIGIT ONELEPCHA DIGIT TWOLEPCHA DIGIT THREELEPCHA DIGIT F" +
	"OURLEPCHA DIGIT FIVELEPCHA DIGIT SIXLEPCHA DIGIT SEVENLEPCHA DIGIT EIGHT" +
	"LEPCHA DIGIT NINELEPCHA LETTER TTALEPCHA LETTER TTHALEPCHA LETTER DDAOL " +
	"CHIKI DIGIT ZEROOL CHIKI DIGIT ONEOL CHIKI DIGIT TWOOL CHIKI DIGIT THREE" +
	"OL CHIKI DIGIT FOUROL CHIKI DIGIT FIVEOL CHIKI DIGIT SIXOL CHIKI DIGIT S" +
	"EVENOL CHIKI DIGIT EIGHTOL CHIKI DIGIT NINEOL CHIKI LETTER LAOL CHIKI LE" +
	"TTER ATOL CHIKI LETTER AGOL CHIKI LETTER ANGOL CHIKI LETTER ALOL CHIKI L" +
	"ETTER LAAOL CHIKI LETTER AAKOL CHIKI LETTER AAJOL CHIKI LETTER AAMOL CHI" +
	"KI LETTER AAWOL CHIKI LETTER LIOL CHIKI LETTER ISOL CHIKI LETTER IHOL CH" +
	"IKI LETTER INYOL CHIKI LETTER IROL CHIKI LETTER LUOL CHIKI LETTER UCOL C" +
	"HIKI LETTER UDOL CHIKI LETTER UNNOL CHIKI LETTER UYOL CHIKI LETTER LEOL " +
	"CHIKI LETTER EPOL CHIKI LETTER EDDOL CHIKI LETTER ENOL CHIKI LETTER ERRO" +
	"L CHIKI LETTER LOOL CHIKI LETTER OTTOL CHIKI LETTER OBOL CHIKI LETTER OV" +
	"OL CHIKI LETTER OHOL CHIKI MU TTUDDAGOL CHIKI GAAHLAA TTUDDAAGOL CHIKI M" +
	"U-GAAHLAA TTUDDAAGOL CHIKI RELAAOL CHIKI PHAARKAAOL CHIKI AHADOL CHIKI P" +
	"UNCTUATION MUCAADOL CHIKI PUNCTUATION DOUBLE MUCAADCYRILLIC SMALL LETTER" +
	" ROUNDED VECYRILLIC SMALL LETTER LONG-LEGGED DECYRILLIC SMALL LETTER NAR" +
	"ROW OCYRILLIC SMALL LETTER WIDE ESCYRILLIC SMALL LETTER TALL TECYRILLIC " +
	"SMALL LETTER THREE-LEGGED TECYRILLIC SMALL LETTER TALL HARD SIGNCYRILLIC" +
	" SMALL LETTER TALL YATCYRILLIC SMALL LETTER UNBLENDED UKSUNDANESE PUNCTU" +
	"ATION BINDU SURYASUNDANESE PUNCTUATION BINDU PANGLONGSUNDANESE PUNCTUATI" +
	"ON BINDU PURNAMASUNDANESE PUNCTUATION BINDU CAKRASUNDANESE PUNCTUATION B" +
	"INDU LEU SATANGASUNDANESE PUNCTUATION BINDU KA SATANGASUNDANESE PUNCTUAT" +
	"ION BINDU DA SATANGASUNDANESE PUNCTUATION BINDU BA SATANGAVEDIC TONE KAR" +
	"SHANAVEDIC TONE SHARAVEDIC TONE PRENKHAVEDIC SIGN NIHSHVASAVEDIC SIGN YA" +
	"JURVEDIC MIDLINE SVARITAVEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVA" +
	"RITAVEDIC TONE YAJURVEDIC INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC KATHA" +
	"KA INDEPENDENT SVARITAVEDIC TONE CANDRA BELOWVEDIC TONE YAJURVEDIC KATHA" +
	"KA INDEPENDENT SVARITA SCHROEDERVEDIC TONE DOUBLE SVARITAVEDIC TONE TRIP" +
	"LE SVARITAVEDIC TONE KATHAKA ANUDATTAVEDIC TONE DOT BELOWVEDIC TONE TWO " +
	"DOTS BELOWVEDIC TONE THREE DOTS BELOWVEDIC TONE RIGVEDIC KASHMIRI INDEPE" +
	"NDENT SVARITAVEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITAVEDIC SIGN VISAR") + ("" +
	"GA SVARITAVEDIC SIGN VISARGA UDATTAVEDIC SIGN REVERSED VISARGA UDATTAVED" +
	"IC SIGN VISARGA ANUDATTAVEDIC SIGN REVERSED VISARGA ANUDATTAVEDIC SIGN V" +
	"ISARGA UDATTA WITH TAILVEDIC SIGN VISARGA ANUDATTA WITH TAILVEDIC SIGN A" +
	"NUSVARA ANTARGOMUKHAVEDIC SIGN ANUSVARA BAHIRGOMUKHAVEDIC SIGN ANUSVARA " +
	"VAMAGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAILVEDIC SIGN TIRYAKVED" +
	"IC SIGN HEXIFORM LONG ANUSVARAVEDIC SIGN LONG ANUSVARAVEDIC SIGN RTHANG " +
	"LONG ANUSVARAVEDIC SIGN ANUSVARA UBHAYATO MUKHAVEDIC SIGN ARDHAVISARGAVE" +
	"DIC SIGN ROTATED ARDHAVISARGAVEDIC TONE CANDRA ABOVEVEDIC SIGN JIHVAMULI" +
	"YAVEDIC SIGN UPADHMANIYAVEDIC SIGN ATIKRAMAVEDIC TONE RING ABOVEVEDIC TO" +
	"NE DOUBLE RING ABOVELATIN LETTER SMALL CAPITAL ALATIN LETTER SMALL CAPIT" +
	"AL AELATIN SMALL LETTER TURNED AELATIN LETTER SMALL CAPITAL BARRED BLATI" +
	"N LETTER SMALL CAPITAL CLATIN LETTER SMALL CAPITAL DLATIN LETTER SMALL C" +
	"APITAL ETHLATIN LETTER SMALL CAPITAL ELATIN SMALL LETTER TURNED OPEN ELA" +
	"TIN SMALL LETTER TURNED ILATIN LETTER SMALL CAPITAL JLATIN LETTER SMALL " +
	"CAPITAL KLATIN LETTER SMALL CAPITAL L WITH STROKELATIN LETTER SMALL CAPI" +
	"TAL MLATIN LETTER SMALL CAPITAL REVERSED NLATIN LETTER SMALL CAPITAL OLA" +
	"TIN LETTER SMALL CAPITAL OPEN OLATIN SMALL LETTER SIDEWAYS OLATIN SMALL " +
	"LETTER SIDEWAYS OPEN OLATIN SMALL LETTER SIDEWAYS O WITH STROKELATIN SMA" +
	"LL LETTER TURNED OELATIN LETTER SMALL CAPITAL OULATIN SMALL LETTER TOP H" +
	"ALF OLATIN SMALL LETTER BOTTOM HALF OLATIN LETTER SMALL CAPITAL PLATIN L" +
	"ETTER SMALL CAPITAL REVERSED RLATIN LETTER SMALL CAPITAL TURNED RLATIN L" +
	"ETTER SMALL CAPITAL TLATIN LETTER SMALL CAPITAL ULATIN SMALL LETTER SIDE" +
	"WAYS ULATIN SMALL LETTER SIDEWAYS DIAERESIZED ULATIN SMALL LETTER SIDEWA" +
	"YS TURNED MLATIN LETTER SMALL CAPITAL VLATIN LETTER SMALL CAPITAL WLATIN" +
	" LETTER SMALL CAPITAL ZLATIN LETTER SMALL CAPITAL EZHLATIN LETTER VOICED" +
	" LARYNGEAL SPIRANTLATIN LETTER AINGREEK LETTER SMALL CAPITAL GAMMAGREEK " +
	"LETTER SMALL CAPITAL LAMDAGREEK LETTER SMALL CAPITAL PIGREEK LETTER SMAL" +
	"L CAPITAL RHOGREEK LETTER SMALL CAPITAL PSICYRILLIC LETTER SMALL CAPITAL" +
	" ELMODIFIER LETTER CAPITAL AMODIFIER LETTER CAPITAL AEMODIFIER LETTER CA" +
	"PITAL BMODIFIER LETTER CAPITAL BARRED BMODIFIER LETTER CAPITAL DMODIFIER" +
	" LETTER CAPITAL EMODIFIER LETTER CAPITAL REVERSED EMODIFIER LETTER CAPIT" +
	"AL GMODIFIER LETTER CAPITAL HMODIFIER LETTER CAPITAL IMODIFIER LETTER CA" +
	"PITAL JMODIFIER LETTER CAPITAL KMODIFIER LETTER CAPITAL LMODIFIER LETTER" +
	" CAPITAL MMODIFIER LETTER CAPITAL NMODIFIER LETTER CAPITAL REVERSED NMOD" +
	"IFIER LETTER CAPITAL OMODIFIER LETTER CAPITAL OUMODIFIER LETTER CAPITAL " +
	"PMODIFIER LETTER CAPITAL RMODIFIER LETTER CAPITAL TMODIFIER LETTER CAPIT" +
	"AL UMODIFIER LETTER CAPITAL WMODIFIER LETTER SMALL AMODIFIER LETTER SMAL" +
	"L TURNED AMODIFIER LETTER SMALL ALPHAMODIFIER LETTER SMALL TURNED AEMODI" +
	"FIER LETTER SMALL BMODIFIER LETTER SMALL DMODIFIER LETTER SMALL EMODIFIE" +
	"R LETTER SMALL SCHWAMODIFIER LETTER SMALL OPEN EMODIFIER LETTER SMALL TU" +
	"RNED OPEN EMODIFIER LETTER SMALL GMODIFIER LETTER SMALL TURNED IMODIFIER" +
	" LETTER SMALL KMODIFIER LETTER SMALL MMODIFIER LETTER SMALL ENGMODIFIER " +
	"LETTER SMALL OMODIFIER LETTER SMALL OPEN OMODIFIER LETTER SMALL TOP HALF" +
	" OMODIFIER LETTER SMALL BOTTOM HALF OMODIFIER LETTER SMALL PMODIFIER LET" +
	"TER SMALL TMODIFIER LETTER SMALL UMODIFIER LETTER SMALL SIDEWAYS UMODIFI" +
	"ER LETTER SMALL TURNED MMODIFIER LETTER SMALL VMODIFIER LETTER SMALL AIN" +
	"MODIFIER LETTER SMALL BETAMODIFIER LETTER SMALL GREEK GAMMAMODIFIER LETT" +
	"ER SMALL DELTAMODIFIER LETTER SMALL GREEK PHIMODIFIER LETTER SMALL CHILA" +
	"TIN SUBSCRIPT SMALL LETTER ILATIN SUBSCRIPT SMALL LETTER RLATIN SUBSCRIP" +
	"T SMALL LETTER ULATIN SUBSCRIPT SMALL LETTER VGREEK SUBSCRIPT SMALL LETT" +
	"ER BETAGREEK SUBSCRIPT SMALL LETTER GAMMAGREEK SUBSCRIPT SMALL LETTER RH" +
	"OGREEK SUBSCRIPT SMALL LETTER PHIGREEK SUBSCRIPT SMALL LETTER CHILATIN S" +
	"MALL LETTER UELATIN SMALL LETTER B WITH MIDDLE TILDELATIN SMALL LETTER D" +
	" WITH MIDDLE TILDELATIN SMALL LETTER F WITH MIDDLE TILDELATIN SMALL LETT" +
	"ER M WITH MIDDLE TILDELATIN SMALL LETTER N WITH MIDDLE TILDELATIN SMALL " +
	"LETTER P WITH MIDDLE TILDELATIN SMALL LETTER R WITH MIDDLE TILDELATIN SM" +
	"ALL LETTER R WITH FISHHOOK AND MIDDLE TILDELATIN SMALL LETTER S WITH MID" +
	"DLE TILDELATIN SMALL LETTER T WITH MIDDLE TILDELATIN SMALL LETTER Z WITH" +
	" MIDDLE TILDELATIN SMALL LETTER TURNED GMODIFIER LETTER CYRILLIC ENLATIN" +
	" SMALL LETTER INSULAR GLATIN SMALL LETTER TH WITH STRIKETHROUGHLATIN SMA" +
	"LL CAPITAL LETTER I WITH STROKELATIN SMALL LETTER IOTA WITH STROKELATIN " +
	"SMALL LETTER P WITH STROKELATIN SMALL CAPITAL LETTER U WITH STROKELATIN " +
	"SMALL LETTER UPSILON WITH STROKELATIN SMALL LETTER B WITH PALATAL HOOKLA" +
	"TIN SMALL LETTER D WITH PALATAL HOOKLATIN SMALL LETTER F WITH PALATAL HO") + ("" +
	"OKLATIN SMALL LETTER G WITH PALATAL HOOKLATIN SMALL LETTER K WITH PALATA" +
	"L HOOKLATIN SMALL LETTER L WITH PALATAL HOOKLATIN SMALL LETTER M WITH PA" +
	"LATAL HOOKLATIN SMALL LETTER N WITH PALATAL HOOKLATIN SMALL LETTER P WIT" +
	"H PALATAL HOOKLATIN SMALL LETTER R WITH PALATAL HOOKLATIN SMALL LETTER S" +
	" WITH PALATAL HOOKLATIN SMALL LETTER ESH WITH PALATAL HOOKLATIN SMALL LE" +
	"TTER V WITH PALATAL HOOKLATIN SMALL LETTER X WITH PALATAL HOOKLATIN SMAL" +
	"L LETTER Z WITH PALATAL HOOKLATIN SMALL LETTER A WITH RETROFLEX HOOKLATI" +
	"N SMALL LETTER ALPHA WITH RETROFLEX HOOKLATIN SMALL LETTER D WITH HOOK A" +
	"ND TAILLATIN SMALL LETTER E WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN E" +
	" WITH RETROFLEX HOOKLATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HO" +
	"OKLATIN SMALL LETTER SCHWA WITH RETROFLEX HOOKLATIN SMALL LETTER I WITH " +
	"RETROFLEX HOOKLATIN SMALL LETTER OPEN O WITH RETROFLEX HOOKLATIN SMALL L" +
	"ETTER ESH WITH RETROFLEX HOOKLATIN SMALL LETTER U WITH RETROFLEX HOOKLAT" +
	"IN SMALL LETTER EZH WITH RETROFLEX HOOKMODIFIER LETTER SMALL TURNED ALPH" +
	"AMODIFIER LETTER SMALL CMODIFIER LETTER SMALL C WITH CURLMODIFIER LETTER" +
	" SMALL ETHMODIFIER LETTER SMALL REVERSED OPEN EMODIFIER LETTER SMALL FMO" +
	"DIFIER LETTER SMALL DOTLESS J WITH STROKEMODIFIER LETTER SMALL SCRIPT GM" +
	"ODIFIER LETTER SMALL TURNED HMODIFIER LETTER SMALL I WITH STROKEMODIFIER" +
	" LETTER SMALL IOTAMODIFIER LETTER SMALL CAPITAL IMODIFIER LETTER SMALL C" +
	"APITAL I WITH STROKEMODIFIER LETTER SMALL J WITH CROSSED-TAILMODIFIER LE" +
	"TTER SMALL L WITH RETROFLEX HOOKMODIFIER LETTER SMALL L WITH PALATAL HOO" +
	"KMODIFIER LETTER SMALL CAPITAL LMODIFIER LETTER SMALL M WITH HOOKMODIFIE" +
	"R LETTER SMALL TURNED M WITH LONG LEGMODIFIER LETTER SMALL N WITH LEFT H" +
	"OOKMODIFIER LETTER SMALL N WITH RETROFLEX HOOKMODIFIER LETTER SMALL CAPI" +
	"TAL NMODIFIER LETTER SMALL BARRED OMODIFIER LETTER SMALL PHIMODIFIER LET" +
	"TER SMALL S WITH HOOKMODIFIER LETTER SMALL ESHMODIFIER LETTER SMALL T WI" +
	"TH PALATAL HOOKMODIFIER LETTER SMALL U BARMODIFIER LETTER SMALL UPSILONM" +
	"ODIFIER LETTER SMALL CAPITAL UMODIFIER LETTER SMALL V WITH HOOKMODIFIER " +
	"LETTER SMALL TURNED VMODIFIER LETTER SMALL ZMODIFIER LETTER SMALL Z WITH" +
	" RETROFLEX HOOKMODIFIER LETTER SMALL Z WITH CURLMODIFIER LETTER SMALL EZ" +
	"HMODIFIER LETTER SMALL THETACOMBINING DOTTED GRAVE ACCENTCOMBINING DOTTE" +
	"D ACUTE ACCENTCOMBINING SNAKE BELOWCOMBINING SUSPENSION MARKCOMBINING MA" +
	"CRON-ACUTECOMBINING GRAVE-MACRONCOMBINING MACRON-GRAVECOMBINING ACUTE-MA" +
	"CRONCOMBINING GRAVE-ACUTE-GRAVECOMBINING ACUTE-GRAVE-ACUTECOMBINING LATI" +
	"N SMALL LETTER R BELOWCOMBINING BREVE-MACRONCOMBINING MACRON-BREVECOMBIN" +
	"ING DOUBLE CIRCUMFLEX ABOVECOMBINING OGONEK ABOVECOMBINING ZIGZAG BELOWC" +
	"OMBINING IS BELOWCOMBINING UR ABOVECOMBINING US ABOVECOMBINING LATIN SMA" +
	"LL LETTER FLATTENED OPEN A ABOVECOMBINING LATIN SMALL LETTER AECOMBINING" +
	" LATIN SMALL LETTER AOCOMBINING LATIN SMALL LETTER AVCOMBINING LATIN SMA" +
	"LL LETTER C CEDILLACOMBINING LATIN SMALL LETTER INSULAR DCOMBINING LATIN" +
	" SMALL LETTER ETHCOMBINING LATIN SMALL LETTER GCOMBINING LATIN LETTER SM" +
	"ALL CAPITAL GCOMBINING LATIN SMALL LETTER KCOMBINING LATIN SMALL LETTER " +
	"LCOMBINING LATIN LETTER SMALL CAPITAL LCOMBINING LATIN LETTER SMALL CAPI" +
	"TAL MCOMBINING LATIN SMALL LETTER NCOMBINING LATIN LETTER SMALL CAPITAL " +
	"NCOMBINING LATIN LETTER SMALL CAPITAL RCOMBINING LATIN SMALL LETTER R RO" +
	"TUNDACOMBINING LATIN SMALL LETTER SCOMBINING LATIN SMALL LETTER LONG SCO" +
	"MBINING LATIN SMALL LETTER ZCOMBINING LATIN SMALL LETTER ALPHACOMBINING " +
	"LATIN SMALL LETTER BCOMBINING LATIN SMALL LETTER BETACOMBINING LATIN SMA" +
	"LL LETTER SCHWACOMBINING LATIN SMALL LETTER FCOMBINING LATIN SMALL LETTE" +
	"R L WITH DOUBLE MIDDLE TILDECOMBINING LATIN SMALL LETTER O WITH LIGHT CE" +
	"NTRALIZATION STROKECOMBINING LATIN SMALL LETTER PCOMBINING LATIN SMALL L" +
	"ETTER ESHCOMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE" +
	"COMBINING LATIN SMALL LETTER WCOMBINING LATIN SMALL LETTER A WITH DIAERE" +
	"SISCOMBINING LATIN SMALL LETTER O WITH DIAERESISCOMBINING LATIN SMALL LE" +
	"TTER U WITH DIAERESISCOMBINING UP TACK ABOVECOMBINING KAVYKA ABOVE RIGHT" +
	"COMBINING KAVYKA ABOVE LEFTCOMBINING DOT ABOVE LEFTCOMBINING WIDE INVERT" +
	"ED BRIDGE BELOWCOMBINING DELETION MARKCOMBINING DOUBLE INVERTED BREVE BE" +
	"LOWCOMBINING ALMOST EQUAL TO BELOWCOMBINING LEFT ARROWHEAD ABOVECOMBININ" +
	"G RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOWLATIN CAPITAL LETTER A WITH RI" +
	"NG BELOWLATIN SMALL LETTER A WITH RING BELOWLATIN CAPITAL LETTER B WITH " +
	"DOT ABOVELATIN SMALL LETTER B WITH DOT ABOVELATIN CAPITAL LETTER B WITH " +
	"DOT BELOWLATIN SMALL LETTER B WITH DOT BELOWLATIN CAPITAL LETTER B WITH " +
	"LINE BELOWLATIN SMALL LETTER B WITH LINE BELOWLATIN CAPITAL LETTER C WIT" +
	"H CEDILLA AND ACUTELATIN SMALL LETTER C WITH CEDILLA AND ACUTELATIN CAPI") + ("" +
	"TAL LETTER D WITH DOT ABOVELATIN SMALL LETTER D WITH DOT ABOVELATIN CAPI" +
	"TAL LETTER D WITH DOT BELOWLATIN SMALL LETTER D WITH DOT BELOWLATIN CAPI" +
	"TAL LETTER D WITH LINE BELOWLATIN SMALL LETTER D WITH LINE BELOWLATIN CA" +
	"PITAL LETTER D WITH CEDILLALATIN SMALL LETTER D WITH CEDILLALATIN CAPITA" +
	"L LETTER D WITH CIRCUMFLEX BELOWLATIN SMALL LETTER D WITH CIRCUMFLEX BEL" +
	"OWLATIN CAPITAL LETTER E WITH MACRON AND GRAVELATIN SMALL LETTER E WITH " +
	"MACRON AND GRAVELATIN CAPITAL LETTER E WITH MACRON AND ACUTELATIN SMALL " +
	"LETTER E WITH MACRON AND ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEX BEL" +
	"OWLATIN SMALL LETTER E WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH " +
	"TILDE BELOWLATIN SMALL LETTER E WITH TILDE BELOWLATIN CAPITAL LETTER E W" +
	"ITH CEDILLA AND BREVELATIN SMALL LETTER E WITH CEDILLA AND BREVELATIN CA" +
	"PITAL LETTER F WITH DOT ABOVELATIN SMALL LETTER F WITH DOT ABOVELATIN CA" +
	"PITAL LETTER G WITH MACRONLATIN SMALL LETTER G WITH MACRONLATIN CAPITAL " +
	"LETTER H WITH DOT ABOVELATIN SMALL LETTER H WITH DOT ABOVELATIN CAPITAL " +
	"LETTER H WITH DOT BELOWLATIN SMALL LETTER H WITH DOT BELOWLATIN CAPITAL " +
	"LETTER H WITH DIAERESISLATIN SMALL LETTER H WITH DIAERESISLATIN CAPITAL " +
	"LETTER H WITH CEDILLALATIN SMALL LETTER H WITH CEDILLALATIN CAPITAL LETT" +
	"ER H WITH BREVE BELOWLATIN SMALL LETTER H WITH BREVE BELOWLATIN CAPITAL " +
	"LETTER I WITH TILDE BELOWLATIN SMALL LETTER I WITH TILDE BELOWLATIN CAPI" +
	"TAL LETTER I WITH DIAERESIS AND ACUTELATIN SMALL LETTER I WITH DIAERESIS" +
	" AND ACUTELATIN CAPITAL LETTER K WITH ACUTELATIN SMALL LETTER K WITH ACU" +
	"TELATIN CAPITAL LETTER K WITH DOT BELOWLATIN SMALL LETTER K WITH DOT BEL" +
	"OWLATIN CAPITAL LETTER K WITH LINE BELOWLATIN SMALL LETTER K WITH LINE B" +
	"ELOWLATIN CAPITAL LETTER L WITH DOT BELOWLATIN SMALL LETTER L WITH DOT B" +
	"ELOWLATIN CAPITAL LETTER L WITH DOT BELOW AND MACRONLATIN SMALL LETTER L" +
	" WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER L WITH LINE BELOWLATIN SM" +
	"ALL LETTER L WITH LINE BELOWLATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW" +
	"LATIN SMALL LETTER L WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER M WITH AC" +
	"UTELATIN SMALL LETTER M WITH ACUTELATIN CAPITAL LETTER M WITH DOT ABOVEL" +
	"ATIN SMALL LETTER M WITH DOT ABOVELATIN CAPITAL LETTER M WITH DOT BELOWL" +
	"ATIN SMALL LETTER M WITH DOT BELOWLATIN CAPITAL LETTER N WITH DOT ABOVEL" +
	"ATIN SMALL LETTER N WITH DOT ABOVELATIN CAPITAL LETTER N WITH DOT BELOWL" +
	"ATIN SMALL LETTER N WITH DOT BELOWLATIN CAPITAL LETTER N WITH LINE BELOW" +
	"LATIN SMALL LETTER N WITH LINE BELOWLATIN CAPITAL LETTER N WITH CIRCUMFL" +
	"EX BELOWLATIN SMALL LETTER N WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER O" +
	" WITH TILDE AND ACUTELATIN SMALL LETTER O WITH TILDE AND ACUTELATIN CAPI" +
	"TAL LETTER O WITH TILDE AND DIAERESISLATIN SMALL LETTER O WITH TILDE AND" +
	" DIAERESISLATIN CAPITAL LETTER O WITH MACRON AND GRAVELATIN SMALL LETTER" +
	" O WITH MACRON AND GRAVELATIN CAPITAL LETTER O WITH MACRON AND ACUTELATI" +
	"N SMALL LETTER O WITH MACRON AND ACUTELATIN CAPITAL LETTER P WITH ACUTEL" +
	"ATIN SMALL LETTER P WITH ACUTELATIN CAPITAL LETTER P WITH DOT ABOVELATIN" +
	" SMALL LETTER P WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT ABOVELATIN" +
	" SMALL LETTER R WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT BELOWLATIN" +
	" SMALL LETTER R WITH DOT BELOWLATIN CAPITAL LETTER R WITH DOT BELOW AND " +
	"MACRONLATIN SMALL LETTER R WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER" +
	" R WITH LINE BELOWLATIN SMALL LETTER R WITH LINE BELOWLATIN CAPITAL LETT" +
	"ER S WITH DOT ABOVELATIN SMALL LETTER S WITH DOT ABOVELATIN CAPITAL LETT" +
	"ER S WITH DOT BELOWLATIN SMALL LETTER S WITH DOT BELOWLATIN CAPITAL LETT" +
	"ER S WITH ACUTE AND DOT ABOVELATIN SMALL LETTER S WITH ACUTE AND DOT ABO" +
	"VELATIN CAPITAL LETTER S WITH CARON AND DOT ABOVELATIN SMALL LETTER S WI" +
	"TH CARON AND DOT ABOVELATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOV" +
	"ELATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVELATIN CAPITAL LETTER T" +
	" WITH DOT ABOVELATIN SMALL LETTER T WITH DOT ABOVELATIN CAPITAL LETTER T" +
	" WITH DOT BELOWLATIN SMALL LETTER T WITH DOT BELOWLATIN CAPITAL LETTER T" +
	" WITH LINE BELOWLATIN SMALL LETTER T WITH LINE BELOWLATIN CAPITAL LETTER" +
	" T WITH CIRCUMFLEX BELOWLATIN SMALL LETTER T WITH CIRCUMFLEX BELOWLATIN " +
	"CAPITAL LETTER U WITH DIAERESIS BELOWLATIN SMALL LETTER U WITH DIAERESIS" +
	" BELOWLATIN CAPITAL LETTER U WITH TILDE BELOWLATIN SMALL LETTER U WITH T" +
	"ILDE BELOWLATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOWLATIN SMALL LETTER" +
	" U WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH TILDE AND ACUTELATIN" +
	" SMALL LETTER U WITH TILDE AND ACUTELATIN CAPITAL LETTER U WITH MACRON A" +
	"ND DIAERESISLATIN SMALL LETTER U WITH MACRON AND DIAERESISLATIN CAPITAL " +
	"LETTER V WITH TILDELATIN SMALL LETTER V WITH TILDELATIN CAPITAL LETTER V" +
	" WITH DOT BELOWLATIN SMALL LETTER V WITH DOT BELOWLATIN CAPITAL LETTER W") + ("" +
	" WITH GRAVELATIN SMALL LETTER W WITH GRAVELATIN CAPITAL LETTER W WITH AC" +
	"UTELATIN SMALL LETTER W WITH ACUTELATIN CAPITAL LETTER W WITH DIAERESISL" +
	"ATIN SMALL LETTER W WITH DIAERESISLATIN CAPITAL LETTER W WITH DOT ABOVEL" +
	"ATIN SMALL LETTER W WITH DOT ABOVELATIN CAPITAL LETTER W WITH DOT BELOWL" +
	"ATIN SMALL LETTER W WITH DOT BELOWLATIN CAPITAL LETTER X WITH DOT ABOVEL" +
	"ATIN SMALL LETTER X WITH DOT ABOVELATIN CAPITAL LETTER X WITH DIAERESISL" +
	"ATIN SMALL LETTER X WITH DIAERESISLATIN CAPITAL LETTER Y WITH DOT ABOVEL" +
	"ATIN SMALL LETTER Y WITH DOT ABOVELATIN CAPITAL LETTER Z WITH CIRCUMFLEX" +
	"LATIN SMALL LETTER Z WITH CIRCUMFLEXLATIN CAPITAL LETTER Z WITH DOT BELO" +
	"WLATIN SMALL LETTER Z WITH DOT BELOWLATIN CAPITAL LETTER Z WITH LINE BEL" +
	"OWLATIN SMALL LETTER Z WITH LINE BELOWLATIN SMALL LETTER H WITH LINE BEL" +
	"OWLATIN SMALL LETTER T WITH DIAERESISLATIN SMALL LETTER W WITH RING ABOV" +
	"ELATIN SMALL LETTER Y WITH RING ABOVELATIN SMALL LETTER A WITH RIGHT HAL" +
	"F RINGLATIN SMALL LETTER LONG S WITH DOT ABOVELATIN SMALL LETTER LONG S " +
	"WITH DIAGONAL STROKELATIN SMALL LETTER LONG S WITH HIGH STROKELATIN CAPI" +
	"TAL LETTER SHARP SLATIN SMALL LETTER DELTALATIN CAPITAL LETTER A WITH DO" +
	"T BELOWLATIN SMALL LETTER A WITH DOT BELOWLATIN CAPITAL LETTER A WITH HO" +
	"OK ABOVELATIN SMALL LETTER A WITH HOOK ABOVELATIN CAPITAL LETTER A WITH " +
	"CIRCUMFLEX AND ACUTELATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTELATIN " +
	"CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER A WITH CIRC" +
	"UMFLEX AND GRAVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELAT" +
	"IN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER A W" +
	"ITH CIRCUMFLEX AND TILDELATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDELA" +
	"TIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER A W" +
	"ITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER A WITH BREVE AND ACUTEL" +
	"ATIN SMALL LETTER A WITH BREVE AND ACUTELATIN CAPITAL LETTER A WITH BREV" +
	"E AND GRAVELATIN SMALL LETTER A WITH BREVE AND GRAVELATIN CAPITAL LETTER" +
	" A WITH BREVE AND HOOK ABOVELATIN SMALL LETTER A WITH BREVE AND HOOK ABO" +
	"VELATIN CAPITAL LETTER A WITH BREVE AND TILDELATIN SMALL LETTER A WITH B" +
	"REVE AND TILDELATIN CAPITAL LETTER A WITH BREVE AND DOT BELOWLATIN SMALL" +
	" LETTER A WITH BREVE AND DOT BELOWLATIN CAPITAL LETTER E WITH DOT BELOWL" +
	"ATIN SMALL LETTER E WITH DOT BELOWLATIN CAPITAL LETTER E WITH HOOK ABOVE" +
	"LATIN SMALL LETTER E WITH HOOK ABOVELATIN CAPITAL LETTER E WITH TILDELAT" +
	"IN SMALL LETTER E WITH TILDELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND A" +
	"CUTELATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER E" +
	" WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE" +
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER " +
	"E WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER E WITH CIRCUMFLEX A" +
	"ND TILDELATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETT" +
	"ER E WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER E WITH CIRCUMFLEX A" +
	"ND DOT BELOWLATIN CAPITAL LETTER I WITH HOOK ABOVELATIN SMALL LETTER I W" +
	"ITH HOOK ABOVELATIN CAPITAL LETTER I WITH DOT BELOWLATIN SMALL LETTER I " +
	"WITH DOT BELOWLATIN CAPITAL LETTER O WITH DOT BELOWLATIN SMALL LETTER O " +
	"WITH DOT BELOWLATIN CAPITAL LETTER O WITH HOOK ABOVELATIN SMALL LETTER O" +
	" WITH HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTELATIN SM" +
	"ALL LETTER O WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER O WITH CIRCUM" +
	"FLEX AND GRAVELATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVELATIN CAPITA" +
	"L LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER O WITH CIRCU" +
	"MFLEX AND HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDELATI" +
	"N SMALL LETTER O WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER O WITH CI" +
	"RCUMFLEX AND DOT BELOWLATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW" +
	"LATIN CAPITAL LETTER O WITH HORN AND ACUTELATIN SMALL LETTER O WITH HORN" +
	" AND ACUTELATIN CAPITAL LETTER O WITH HORN AND GRAVELATIN SMALL LETTER O" +
	" WITH HORN AND GRAVELATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVELATIN" +
	" SMALL LETTER O WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER O WITH HORN" +
	" AND TILDELATIN SMALL LETTER O WITH HORN AND TILDELATIN CAPITAL LETTER O" +
	" WITH HORN AND DOT BELOWLATIN SMALL LETTER O WITH HORN AND DOT BELOWLATI" +
	"N CAPITAL LETTER U WITH DOT BELOWLATIN SMALL LETTER U WITH DOT BELOWLATI" +
	"N CAPITAL LETTER U WITH HOOK ABOVELATIN SMALL LETTER U WITH HOOK ABOVELA" +
	"TIN CAPITAL LETTER U WITH HORN AND ACUTELATIN SMALL LETTER U WITH HORN A" +
	"ND ACUTELATIN CAPITAL LETTER U WITH HORN AND GRAVELATIN SMALL LETTER U W" +
	"ITH HORN AND GRAVELATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVELATIN S" +
	"MALL LETTER U WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER U WITH HORN A" +
	"ND TILDELATIN SMALL LETTER U WITH HORN AND TILDELATIN CAPITAL LETTER U W") + ("" +
	"ITH HORN AND DOT BELOWLATIN SMALL LETTER U WITH HORN AND DOT BELOWLATIN " +
	"CAPITAL LETTER Y WITH GRAVELATIN SMALL LETTER Y WITH GRAVELATIN CAPITAL " +
	"LETTER Y WITH DOT BELOWLATIN SMALL LETTER Y WITH DOT BELOWLATIN CAPITAL " +
	"LETTER Y WITH HOOK ABOVELATIN SMALL LETTER Y WITH HOOK ABOVELATIN CAPITA" +
	"L LETTER Y WITH TILDELATIN SMALL LETTER Y WITH TILDELATIN CAPITAL LETTER" +
	" MIDDLE-WELSH LLLATIN SMALL LETTER MIDDLE-WELSH LLLATIN CAPITAL LETTER M" +
	"IDDLE-WELSH VLATIN SMALL LETTER MIDDLE-WELSH VLATIN CAPITAL LETTER Y WIT" +
	"H LOOPLATIN SMALL LETTER Y WITH LOOPGREEK SMALL LETTER ALPHA WITH PSILIG" +
	"REEK SMALL LETTER ALPHA WITH DASIAGREEK SMALL LETTER ALPHA WITH PSILI AN" +
	"D VARIAGREEK SMALL LETTER ALPHA WITH DASIA AND VARIAGREEK SMALL LETTER A" +
	"LPHA WITH PSILI AND OXIAGREEK SMALL LETTER ALPHA WITH DASIA AND OXIAGREE" +
	"K SMALL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER ALPHA " +
	"WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH PSILIGREEK CAP" +
	"ITAL LETTER ALPHA WITH DASIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND VA" +
	"RIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIAGREEK CAPITAL LETTER A" +
	"LPHA WITH PSILI AND OXIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIAGR" +
	"EEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER " +
	"ALPHA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER EPSILON WITH PSILIGRE" +
	"EK SMALL LETTER EPSILON WITH DASIAGREEK SMALL LETTER EPSILON WITH PSILI " +
	"AND VARIAGREEK SMALL LETTER EPSILON WITH DASIA AND VARIAGREEK SMALL LETT" +
	"ER EPSILON WITH PSILI AND OXIAGREEK SMALL LETTER EPSILON WITH DASIA AND " +
	"OXIAGREEK CAPITAL LETTER EPSILON WITH PSILIGREEK CAPITAL LETTER EPSILON " +
	"WITH DASIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIAGREEK CAPITAL" +
	" LETTER EPSILON WITH DASIA AND VARIAGREEK CAPITAL LETTER EPSILON WITH PS" +
	"ILI AND OXIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIAGREEK SMALL " +
	"LETTER ETA WITH PSILIGREEK SMALL LETTER ETA WITH DASIAGREEK SMALL LETTER" +
	" ETA WITH PSILI AND VARIAGREEK SMALL LETTER ETA WITH DASIA AND VARIAGREE" +
	"K SMALL LETTER ETA WITH PSILI AND OXIAGREEK SMALL LETTER ETA WITH DASIA " +
	"AND OXIAGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENIGREEK SMALL LET" +
	"TER ETA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ETA WITH PSILIGRE" +
	"EK CAPITAL LETTER ETA WITH DASIAGREEK CAPITAL LETTER ETA WITH PSILI AND " +
	"VARIAGREEK CAPITAL LETTER ETA WITH DASIA AND VARIAGREEK CAPITAL LETTER E" +
	"TA WITH PSILI AND OXIAGREEK CAPITAL LETTER ETA WITH DASIA AND OXIAGREEK " +
	"CAPITAL LETTER ETA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER ETA WI" +
	"TH DASIA AND PERISPOMENIGREEK SMALL LETTER IOTA WITH PSILIGREEK SMALL LE" +
	"TTER IOTA WITH DASIAGREEK SMALL LETTER IOTA WITH PSILI AND VARIAGREEK SM" +
	"ALL LETTER IOTA WITH DASIA AND VARIAGREEK SMALL LETTER IOTA WITH PSILI A" +
	"ND OXIAGREEK SMALL LETTER IOTA WITH DASIA AND OXIAGREEK SMALL LETTER IOT" +
	"A WITH PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA WITH DASIA AND PERIS" +
	"POMENIGREEK CAPITAL LETTER IOTA WITH PSILIGREEK CAPITAL LETTER IOTA WITH" +
	" DASIAGREEK CAPITAL LETTER IOTA WITH PSILI AND VARIAGREEK CAPITAL LETTER" +
	" IOTA WITH DASIA AND VARIAGREEK CAPITAL LETTER IOTA WITH PSILI AND OXIAG" +
	"REEK CAPITAL LETTER IOTA WITH DASIA AND OXIAGREEK CAPITAL LETTER IOTA WI" +
	"TH PSILI AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPO" +
	"MENIGREEK SMALL LETTER OMICRON WITH PSILIGREEK SMALL LETTER OMICRON WITH" +
	" DASIAGREEK SMALL LETTER OMICRON WITH PSILI AND VARIAGREEK SMALL LETTER " +
	"OMICRON WITH DASIA AND VARIAGREEK SMALL LETTER OMICRON WITH PSILI AND OX" +
	"IAGREEK SMALL LETTER OMICRON WITH DASIA AND OXIAGREEK CAPITAL LETTER OMI" +
	"CRON WITH PSILIGREEK CAPITAL LETTER OMICRON WITH DASIAGREEK CAPITAL LETT" +
	"ER OMICRON WITH PSILI AND VARIAGREEK CAPITAL LETTER OMICRON WITH DASIA A" +
	"ND VARIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIAGREEK CAPITAL LE" +
	"TTER OMICRON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH PSILIGRE" +
	"EK SMALL LETTER UPSILON WITH DASIAGREEK SMALL LETTER UPSILON WITH PSILI " +
	"AND VARIAGREEK SMALL LETTER UPSILON WITH DASIA AND VARIAGREEK SMALL LETT" +
	"ER UPSILON WITH PSILI AND OXIAGREEK SMALL LETTER UPSILON WITH DASIA AND " +
	"OXIAGREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENIGREEK SMALL LET" +
	"TER UPSILON WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH " +
	"DASIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIAGREEK CAPITAL LETT" +
	"ER UPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER UPSILON WITH DASIA AN" +
	"D PERISPOMENIGREEK SMALL LETTER OMEGA WITH PSILIGREEK SMALL LETTER OMEGA" +
	" WITH DASIAGREEK SMALL LETTER OMEGA WITH PSILI AND VARIAGREEK SMALL LETT" +
	"ER OMEGA WITH DASIA AND VARIAGREEK SMALL LETTER OMEGA WITH PSILI AND OXI" +
	"AGREEK SMALL LETTER OMEGA WITH DASIA AND OXIAGREEK SMALL LETTER OMEGA WI" +
	"TH PSILI AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOM") + ("" +
	"ENIGREEK CAPITAL LETTER OMEGA WITH PSILIGREEK CAPITAL LETTER OMEGA WITH " +
	"DASIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIAGREEK CAPITAL LETTER" +
	" OMEGA WITH DASIA AND VARIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND OXI" +
	"AGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIAGREEK CAPITAL LETTER OMEG" +
	"A WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PE" +
	"RISPOMENIGREEK SMALL LETTER ALPHA WITH VARIAGREEK SMALL LETTER ALPHA WIT" +
	"H OXIAGREEK SMALL LETTER EPSILON WITH VARIAGREEK SMALL LETTER EPSILON WI" +
	"TH OXIAGREEK SMALL LETTER ETA WITH VARIAGREEK SMALL LETTER ETA WITH OXIA" +
	"GREEK SMALL LETTER IOTA WITH VARIAGREEK SMALL LETTER IOTA WITH OXIAGREEK" +
	" SMALL LETTER OMICRON WITH VARIAGREEK SMALL LETTER OMICRON WITH OXIAGREE" +
	"K SMALL LETTER UPSILON WITH VARIAGREEK SMALL LETTER UPSILON WITH OXIAGRE" +
	"EK SMALL LETTER OMEGA WITH VARIAGREEK SMALL LETTER OMEGA WITH OXIAGREEK " +
	"SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA " +
	"WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND VARI" +
	"A AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPO" +
	"GEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI" +
	"GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMAL" +
	"L LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL L" +
	"ETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LE" +
	"TTER ALPHA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH " +
	"DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA " +
	"AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PR" +
	"OSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRA" +
	"MMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENIGR" +
	"EEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGR" +
	"EEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGR" +
	"EEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER ETA " +
	"WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND VARIA " +
	"AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGR" +
	"AMMENIGREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK " +
	"SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER" +
	" ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER ETA " +
	"WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ETA WIT" +
	"H PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PROSGE" +
	"GRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI" +
	"GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CA" +
	"PITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LET" +
	"TER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA W" +
	"ITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WIT" +
	"H DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER OMEGA WITH " +
	"PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAM" +
	"MENIGREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK" +
	" SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LE" +
	"TTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA" +
	" WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSIL" +
	"I AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA A" +
	"ND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AN" +
	"D PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI" +
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK " +
	"CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITA" +
	"L LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTE" +
	"R OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA" +
	" WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA" +
	" WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER ALPHA W" +
	"ITH VRACHYGREEK SMALL LETTER ALPHA WITH MACRONGREEK SMALL LETTER ALPHA W" +
	"ITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENIGR" +
	"EEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALP" +
	"HA WITH PERISPOMENIGREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGR" +
	"AMMENIGREEK CAPITAL LETTER ALPHA WITH VRACHYGREEK CAPITAL LETTER ALPHA W" +
	"ITH MACRONGREEK CAPITAL LETTER ALPHA WITH VARIAGREEK CAPITAL LETTER ALPH" +
	"A WITH OXIAGREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENIGREEK KORONISGR" +
	"EEK PROSGEGRAMMENIGREEK PSILIGREEK PERISPOMENIGREEK DIALYTIKA AND PERISP" +
	"OMENIGREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETT" +
	"ER ETA WITH YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMM") + ("" +
	"ENIGREEK SMALL LETTER ETA WITH PERISPOMENIGREEK SMALL LETTER ETA WITH PE" +
	"RISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER EPSILON WITH VARIAGREEK " +
	"CAPITAL LETTER EPSILON WITH OXIAGREEK CAPITAL LETTER ETA WITH VARIAGREEK" +
	" CAPITAL LETTER ETA WITH OXIAGREEK CAPITAL LETTER ETA WITH PROSGEGRAMMEN" +
	"IGREEK PSILI AND VARIAGREEK PSILI AND OXIAGREEK PSILI AND PERISPOMENIGRE" +
	"EK SMALL LETTER IOTA WITH VRACHYGREEK SMALL LETTER IOTA WITH MACRONGREEK" +
	" SMALL LETTER IOTA WITH DIALYTIKA AND VARIAGREEK SMALL LETTER IOTA WITH " +
	"DIALYTIKA AND OXIAGREEK SMALL LETTER IOTA WITH PERISPOMENIGREEK SMALL LE" +
	"TTER IOTA WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH V" +
	"RACHYGREEK CAPITAL LETTER IOTA WITH MACRONGREEK CAPITAL LETTER IOTA WITH" +
	" VARIAGREEK CAPITAL LETTER IOTA WITH OXIAGREEK DASIA AND VARIAGREEK DASI" +
	"A AND OXIAGREEK DASIA AND PERISPOMENIGREEK SMALL LETTER UPSILON WITH VRA" +
	"CHYGREEK SMALL LETTER UPSILON WITH MACRONGREEK SMALL LETTER UPSILON WITH" +
	" DIALYTIKA AND VARIAGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIAGR" +
	"EEK SMALL LETTER RHO WITH PSILIGREEK SMALL LETTER RHO WITH DASIAGREEK SM" +
	"ALL LETTER UPSILON WITH PERISPOMENIGREEK SMALL LETTER UPSILON WITH DIALY" +
	"TIKA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH VRACHYGREEK CAPITA" +
	"L LETTER UPSILON WITH MACRONGREEK CAPITAL LETTER UPSILON WITH VARIAGREEK" +
	" CAPITAL LETTER UPSILON WITH OXIAGREEK CAPITAL LETTER RHO WITH DASIAGREE" +
	"K DIALYTIKA AND VARIAGREEK DIALYTIKA AND OXIAGREEK VARIAGREEK SMALL LETT" +
	"ER OMEGA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH YPOGE" +
	"GRAMMENIGREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL " +
	"LETTER OMEGA WITH PERISPOMENIGREEK SMALL LETTER OMEGA WITH PERISPOMENI A" +
	"ND YPOGEGRAMMENIGREEK CAPITAL LETTER OMICRON WITH VARIAGREEK CAPITAL LET" +
	"TER OMICRON WITH OXIAGREEK CAPITAL LETTER OMEGA WITH VARIAGREEK CAPITAL " +
	"LETTER OMEGA WITH OXIAGREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENIGREE" +
	"K OXIAGREEK DASIAEN QUADEM QUADEN SPACEEM SPACETHREE-PER-EM SPACEFOUR-PE" +
	"R-EM SPACESIX-PER-EM SPACEFIGURE SPACEPUNCTUATION SPACETHIN SPACEHAIR SP" +
	"ACEZERO WIDTH SPACEZERO WIDTH NON-JOINERZERO WIDTH JOINERLEFT-TO-RIGHT M" +
	"ARKRIGHT-TO-LEFT MARKHYPHENNON-BREAKING HYPHENFIGURE DASHEN DASHEM DASHH" +
	"ORIZONTAL BARDOUBLE VERTICAL LINEDOUBLE LOW LINELEFT SINGLE QUOTATION MA" +
	"RKRIGHT SINGLE QUOTATION MARKSINGLE LOW-9 QUOTATION MARKSINGLE HIGH-REVE" +
	"RSED-9 QUOTATION MARKLEFT DOUBLE QUOTATION MARKRIGHT DOUBLE QUOTATION MA" +
	"RKDOUBLE LOW-9 QUOTATION MARKDOUBLE HIGH-REVERSED-9 QUOTATION MARKDAGGER" +
	"DOUBLE DAGGERBULLETTRIANGULAR BULLETONE DOT LEADERTWO DOT LEADERHORIZONT" +
	"AL ELLIPSISHYPHENATION POINTLINE SEPARATORPARAGRAPH SEPARATORLEFT-TO-RIG" +
	"HT EMBEDDINGRIGHT-TO-LEFT EMBEDDINGPOP DIRECTIONAL FORMATTINGLEFT-TO-RIG" +
	"HT OVERRIDERIGHT-TO-LEFT OVERRIDENARROW NO-BREAK SPACEPER MILLE SIGNPER " +
	"TEN THOUSAND SIGNPRIMEDOUBLE PRIMETRIPLE PRIMEREVERSED PRIMEREVERSED DOU" +
	"BLE PRIMEREVERSED TRIPLE PRIMECARETSINGLE LEFT-POINTING ANGLE QUOTATION " +
	"MARKSINGLE RIGHT-POINTING ANGLE QUOTATION MARKREFERENCE MARKDOUBLE EXCLA" +
	"MATION MARKINTERROBANGOVERLINEUNDERTIECHARACTER TIECARET INSERTION POINT" +
	"ASTERISMHYPHEN BULLETFRACTION SLASHLEFT SQUARE BRACKET WITH QUILLRIGHT S" +
	"QUARE BRACKET WITH QUILLDOUBLE QUESTION MARKQUESTION EXCLAMATION MARKEXC" +
	"LAMATION QUESTION MARKTIRONIAN SIGN ETREVERSED PILCROW SIGNBLACK LEFTWAR" +
	"DS BULLETBLACK RIGHTWARDS BULLETLOW ASTERISKREVERSED SEMICOLONCLOSE UPTW" +
	"O ASTERISKS ALIGNED VERTICALLYCOMMERCIAL MINUS SIGNSWUNG DASHINVERTED UN" +
	"DERTIEFLOWER PUNCTUATION MARKTHREE DOT PUNCTUATIONQUADRUPLE PRIMEFOUR DO" +
	"T PUNCTUATIONFIVE DOT PUNCTUATIONTWO DOT PUNCTUATIONFOUR DOT MARKDOTTED " +
	"CROSSTRICOLONVERTICAL FOUR DOTSMEDIUM MATHEMATICAL SPACEWORD JOINERFUNCT" +
	"ION APPLICATIONINVISIBLE TIMESINVISIBLE SEPARATORINVISIBLE PLUSLEFT-TO-R" +
	"IGHT ISOLATERIGHT-TO-LEFT ISOLATEFIRST STRONG ISOLATEPOP DIRECTIONAL ISO" +
	"LATEINHIBIT SYMMETRIC SWAPPINGACTIVATE SYMMETRIC SWAPPINGINHIBIT ARABIC " +
	"FORM SHAPINGACTIVATE ARABIC FORM SHAPINGNATIONAL DIGIT SHAPESNOMINAL DIG" +
	"IT SHAPESSUPERSCRIPT ZEROSUPERSCRIPT LATIN SMALL LETTER ISUPERSCRIPT FOU" +
	"RSUPERSCRIPT FIVESUPERSCRIPT SIXSUPERSCRIPT SEVENSUPERSCRIPT EIGHTSUPERS" +
	"CRIPT NINESUPERSCRIPT PLUS SIGNSUPERSCRIPT MINUSSUPERSCRIPT EQUALS SIGNS" +
	"UPERSCRIPT LEFT PARENTHESISSUPERSCRIPT RIGHT PARENTHESISSUPERSCRIPT LATI" +
	"N SMALL LETTER NSUBSCRIPT ZEROSUBSCRIPT ONESUBSCRIPT TWOSUBSCRIPT THREES" +
	"UBSCRIPT FOURSUBSCRIPT FIVESUBSCRIPT SIXSUBSCRIPT SEVENSUBSCRIPT EIGHTSU" +
	"BSCRIPT NINESUBSCRIPT PLUS SIGNSUBSCRIPT MINUSSUBSCRIPT EQUALS SIGNSUBSC" +
	"RIPT LEFT PARENTHESISSUBSCRIPT RIGHT PARENTHESISLATIN SUBSCRIPT SMALL LE" +
	"TTER ALATIN SUBSCRIPT SMALL LETTER ELATIN SUBSCRIPT SMALL LETTER OLATIN " +
	"SUBSCRIPT SMALL LETTER XLATIN SUBSCRIPT SMALL LETTER SCHWALATIN SUBSCRIP") + ("" +
	"T SMALL LETTER HLATIN SUBSCRIPT SMALL LETTER KLATIN SUBSCRIPT SMALL LETT" +
	"ER LLATIN SUBSCRIPT SMALL LETTER MLATIN SUBSCRIPT SMALL LETTER NLATIN SU" +
	"BSCRIPT SMALL LETTER PLATIN SUBSCRIPT SMALL LETTER SLATIN SUBSCRIPT SMAL" +
	"L LETTER TEURO-CURRENCY SIGNCOLON SIGNCRUZEIRO SIGNFRENCH FRANC SIGNLIRA" +
	" SIGNMILL SIGNNAIRA SIGNPESETA SIGNRUPEE SIGNWON SIGNNEW SHEQEL SIGNDONG" +
	" SIGNEURO SIGNKIP SIGNTUGRIK SIGNDRACHMA SIGNGERMAN PENNY SIGNPESO SIGNG" +
	"UARANI SIGNAUSTRAL SIGNHRYVNIA SIGNCEDI SIGNLIVRE TOURNOIS SIGNSPESMILO " +
	"SIGNTENGE SIGNINDIAN RUPEE SIGNTURKISH LIRA SIGNNORDIC MARK SIGNMANAT SI" +
	"GNRUBLE SIGNLARI SIGNBITCOIN SIGNCOMBINING LEFT HARPOON ABOVECOMBINING R" +
	"IGHT HARPOON ABOVECOMBINING LONG VERTICAL LINE OVERLAYCOMBINING SHORT VE" +
	"RTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE ARROW ABOVECOMBINING CLOCKWIS" +
	"E ARROW ABOVECOMBINING LEFT ARROW ABOVECOMBINING RIGHT ARROW ABOVECOMBIN" +
	"ING RING OVERLAYCOMBINING CLOCKWISE RING OVERLAYCOMBINING ANTICLOCKWISE " +
	"RING OVERLAYCOMBINING THREE DOTS ABOVECOMBINING FOUR DOTS ABOVECOMBINING" +
	" ENCLOSING CIRCLECOMBINING ENCLOSING SQUARECOMBINING ENCLOSING DIAMONDCO" +
	"MBINING ENCLOSING CIRCLE BACKSLASHCOMBINING LEFT RIGHT ARROW ABOVECOMBIN" +
	"ING ENCLOSING SCREENCOMBINING ENCLOSING KEYCAPCOMBINING ENCLOSING UPWARD" +
	" POINTING TRIANGLECOMBINING REVERSE SOLIDUS OVERLAYCOMBINING DOUBLE VERT" +
	"ICAL STROKE OVERLAYCOMBINING ANNUITY SYMBOLCOMBINING TRIPLE UNDERDOTCOMB" +
	"INING WIDE BRIDGE ABOVECOMBINING LEFTWARDS ARROW OVERLAYCOMBINING LONG D" +
	"OUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDSCOM" +
	"BINING LEFTWARDS HARPOON WITH BARB DOWNWARDSCOMBINING LEFT ARROW BELOWCO" +
	"MBINING RIGHT ARROW BELOWCOMBINING ASTERISK ABOVEACCOUNT OFADDRESSED TO " +
	"THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE CELSIUSCENTRE LINE SYMBOLCARE O" +
	"FCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRENHEITSCRIPT SMALL GSCRIPT CAPI" +
	"TAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK CAPITAL HPLANCK CONSTANTPLANCK " +
	"CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-LETTER CAPITAL ISCRIPT CAPITAL" +
	" LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUCK CAPITAL NNUMERO SIGNSOUND RE" +
	"CORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-STRUCK CAPITAL PDOUBLE-STRUCK CA" +
	"PITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITAL RDOUBLE-STRUCK CAPITAL RPRES" +
	"CRIPTION TAKERESPONSESERVICE MARKTELEPHONE SIGNTRADE MARK SIGNVERSICLEDO" +
	"UBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINVERTED OHM SIGNBLACK-LETTER CAP" +
	"ITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN SIGNANGSTROM SIGNSCRIPT CAPIT" +
	"AL BBLACK-LETTER CAPITAL CESTIMATED SYMBOLSCRIPT SMALL ESCRIPT CAPITAL E" +
	"SCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAPITAL MSCRIPT SMALL OALEF SYMBO" +
	"LBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMATION SOURCEROTATED CAPITAL QFA" +
	"CSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-STRUCK SMALL GAMMADOUBLE-STRUCK" +
	" CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUBLE-STRUCK N-ARY SUMMATIONTURNE" +
	"D SANS-SERIF CAPITAL GTURNED SANS-SERIF CAPITAL LREVERSED SANS-SERIF CAP" +
	"ITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-STRUCK ITALIC CAPITAL DDOUBLE-ST" +
	"RUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SMALL EDOUBLE-STRUCK ITALIC SMAL" +
	"L IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LINETURNED AMPERSANDPER SIGNAKTI" +
	"ESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN SOURCEVULGAR FRACTION ONE SEV" +
	"ENTHVULGAR FRACTION ONE NINTHVULGAR FRACTION ONE TENTHVULGAR FRACTION ON" +
	"E THIRDVULGAR FRACTION TWO THIRDSVULGAR FRACTION ONE FIFTHVULGAR FRACTIO" +
	"N TWO FIFTHSVULGAR FRACTION THREE FIFTHSVULGAR FRACTION FOUR FIFTHSVULGA" +
	"R FRACTION ONE SIXTHVULGAR FRACTION FIVE SIXTHSVULGAR FRACTION ONE EIGHT" +
	"HVULGAR FRACTION THREE EIGHTHSVULGAR FRACTION FIVE EIGHTHSVULGAR FRACTIO" +
	"N SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN NUMERAL ONEROMAN NUMERAL TWOR" +
	"OMAN NUMERAL THREEROMAN NUMERAL FOURROMAN NUMERAL FIVEROMAN NUMERAL SIXR" +
	"OMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN NUMERAL NINEROMAN NUMERAL TEN" +
	"ROMAN NUMERAL ELEVENROMAN NUMERAL TWELVEROMAN NUMERAL FIFTYROMAN NUMERAL" +
	" ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMAN NUMERAL ONE THOUSANDSMALL RO" +
	"MAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMALL ROMAN NUMERAL THREESMALL ROM" +
	"AN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMALL ROMAN NUMERAL SIXSMALL ROMA" +
	"N NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSMALL ROMAN NUMERAL NINESMALL RO" +
	"MAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENSMALL ROMAN NUMERAL TWELVESMALL" +
	" ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ONE HUNDREDSMALL ROMAN NUMERAL F" +
	"IVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSANDROMAN NUMERAL ONE THOUSAND C " +
	"DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL TEN THOUSANDROMAN NUMERAL REVE" +
	"RSED ONE HUNDREDLATIN SMALL LETTER REVERSED CROMAN NUMERAL SIX LATE FORM" +
	"ROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERAL FIFTY THOUSANDROMAN NUMERAL " +
	"ONE HUNDRED THOUSANDVULGAR FRACTION ZERO THIRDSTURNED DIGIT TWOTURNED DI" +
	"GIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHTWARDS ARROWDOWNWARDS ARROWLEFT") + ("" +
	" RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWNORTH EAST ARROWSOUTH EAST ARRO" +
	"WSOUTH WEST ARROWLEFTWARDS ARROW WITH STROKERIGHTWARDS ARROW WITH STROKE" +
	"LEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWLEFTWARDS TWO HEADED ARROWUPWAR" +
	"DS TWO HEADED ARROWRIGHTWARDS TWO HEADED ARROWDOWNWARDS TWO HEADED ARROW" +
	"LEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW WITH TAILLEFTWARDS ARROW FROM " +
	"BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW FROM BARDOWNWARDS ARROW FROM B" +
	"ARUP DOWN ARROW WITH BASELEFTWARDS ARROW WITH HOOKRIGHTWARDS ARROW WITH " +
	"HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS ARROW WITH LOOPLEFT RIGHT WAVE A" +
	"RROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS ZIGZAG ARROWUPWARDS ARROW WITH" +
	" TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHTWARDSDOWNWARDS ARROW WITH TIP " +
	"LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWARDSRIGHTWARDS ARROW WITH CORNER" +
	" DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFTWARDSANTICLOCKWISE TOP SEMICIR" +
	"CLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNORTH WEST ARROW TO LONG BARLEFTW" +
	"ARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BARANTICLOCKWISE OPEN CIRCLE " +
	"ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS HARPOON WITH BARB UPWARDSLEFTW" +
	"ARDS HARPOON WITH BARB DOWNWARDSUPWARDS HARPOON WITH BARB RIGHTWARDSUPWA" +
	"RDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS HARPOON WITH BARB UPWARDSRIGHT" +
	"WARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS HARPOON WITH BARB RIGHTWARDSD" +
	"OWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS ARROW OVER LEFTWARDS ARRO" +
	"WUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROWLEFTWARDS ARROW OVER RIGHTWAR" +
	"DS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAIRED ARROWSRIGHTWARDS PAIRED AR" +
	"ROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPOON OVER RIGHTWARDS HARPOONRIGH" +
	"TWARDS HARPOON OVER LEFTWARDS HARPOONLEFTWARDS DOUBLE ARROW WITH STROKEL" +
	"EFT RIGHT DOUBLE ARROW WITH STROKERIGHTWARDS DOUBLE ARROW WITH STROKELEF" +
	"TWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIGHTWARDS DOUBLE ARROWDOWNWARDS " +
	"DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN DOUBLE ARROWNORTH WEST DOUBLE" +
	" ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DOUBLE ARROWSOUTH WEST DOUBLE AR" +
	"ROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE ARROWLEFTWARDS SQUIGGLE ARROW" +
	"RIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WITH DOUBLE STROKEDOWNWARDS ARROW" +
	" WITH DOUBLE STROKELEFTWARDS DASHED ARROWUPWARDS DASHED ARROWRIGHTWARDS " +
	"DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARDS ARROW TO BARRIGHTWARDS ARROW" +
	" TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE ARROWRIGHTWARDS WHITE ARROWDOW" +
	"NWARDS WHITE ARROWUPWARDS WHITE ARROW FROM BARUPWARDS WHITE ARROW ON PED" +
	"ESTALUPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BARUPWARDS WHITE AR" +
	"ROW ON PEDESTAL WITH VERTICAL BARUPWARDS WHITE DOUBLE ARROWUPWARDS WHITE" +
	" DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE ARROW FROM WALLNORTH WEST ARRO" +
	"W TO CORNERSOUTH EAST ARROW TO CORNERUP DOWN WHITE ARROWRIGHT ARROW WITH" +
	" SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROWTHREE RIGHTWARDS " +
	"ARROWSLEFTWARDS ARROW WITH VERTICAL STROKERIGHTWARDS ARROW WITH VERTICAL" +
	" STROKELEFT RIGHT ARROW WITH VERTICAL STROKELEFTWARDS ARROW WITH DOUBLE " +
	"VERTICAL STROKERIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKELEFT RIGHT AR" +
	"ROW WITH DOUBLE VERTICAL STROKELEFTWARDS OPEN-HEADED ARROWRIGHTWARDS OPE" +
	"N-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROWFOR ALLCOMPLEMENTPARTIAL DIFFE" +
	"RENTIALTHERE EXISTSTHERE DOES NOT EXISTEMPTY SETINCREMENTNABLAELEMENT OF" +
	"NOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS AS MEMBERDOES NOT CONTAIN AS M" +
	"EMBERSMALL CONTAINS AS MEMBEREND OF PROOFN-ARY PRODUCTN-ARY COPRODUCTN-A" +
	"RY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDOT PLUSDIVISION SLASHSET MINUSA" +
	"STERISK OPERATORRING OPERATORBULLET OPERATORSQUARE ROOTCUBE ROOTFOURTH R" +
	"OOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLEMEASURED ANGLESPHERICAL ANGLED" +
	"IVIDESDOES NOT DIVIDEPARALLEL TONOT PARALLEL TOLOGICAL ANDLOGICAL ORINTE" +
	"RSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE INTEGRALCONTOUR INTEGRALSURFA" +
	"CE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGRALCLOCKWISE CONTOUR INTEGRALAN" +
	"TICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAUSERATIOPROPORTIONDOT MINUSEXCE" +
	"SSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPERATORREVERSED TILDEINVERTED LAZ" +
	"Y SSINE WAVEWREATH PRODUCTNOT TILDEMINUS TILDEASYMPTOTICALLY EQUAL TONOT" +
	" ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUAL TOAPPROXIMATELY BUT NOT ACTU" +
	"ALLY EQUAL TONEITHER APPROXIMATELY NOR ACTUALLY EQUAL TOALMOST EQUAL TON" +
	"OT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TOTRIPLE TILDEALL EQUAL TOEQUIVA" +
	"LENT TOGEOMETRICALLY EQUIVALENT TODIFFERENCE BETWEENAPPROACHES THE LIMIT" +
	"GEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL TO OR THE IMAGE OFIMAGE OF OR " +
	"APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS COLONRING IN EQUAL TORING EQUAL" +
	" TOCORRESPONDS TOESTIMATESEQUIANGULAR TOSTAR EQUALSDELTA EQUAL TOEQUAL T" +
	"O BY DEFINITIONMEASURED BYQUESTIONED EQUAL TONOT EQUAL TOIDENTICAL TONOT" +
	" IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-THAN OR EQUAL TOGREATER-THAN OR ") + ("" +
	"EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THAN OVER EQUAL TOLESS-THAN BUT N" +
	"OT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMUCH LESS-THANMUCH GREATER-THANB" +
	"ETWEENNOT EQUIVALENT TONOT LESS-THANNOT GREATER-THANNEITHER LESS-THAN NO" +
	"R EQUAL TONEITHER GREATER-THAN NOR EQUAL TOLESS-THAN OR EQUIVALENT TOGRE" +
	"ATER-THAN OR EQUIVALENT TONEITHER LESS-THAN NOR EQUIVALENT TONEITHER GRE" +
	"ATER-THAN NOR EQUIVALENT TOLESS-THAN OR GREATER-THANGREATER-THAN OR LESS" +
	"-THANNEITHER LESS-THAN NOR GREATER-THANNEITHER GREATER-THAN NOR LESS-THA" +
	"NPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCEEDS OR EQUAL TOPRECEDES OR EQU" +
	"IVALENT TOSUCCEEDS OR EQUIVALENT TODOES NOT PRECEDEDOES NOT SUCCEEDSUBSE" +
	"T OFSUPERSET OFNOT A SUBSET OFNOT A SUPERSET OFSUBSET OF OR EQUAL TOSUPE" +
	"RSET OF OR EQUAL TONEITHER A SUBSET OF NOR EQUAL TONEITHER A SUPERSET OF" +
	" NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSUPERSET OF WITH NOT EQUAL TOMUL" +
	"TISETMULTISET MULTIPLICATIONMULTISET UNIONSQUARE IMAGE OFSQUARE ORIGINAL" +
	" OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGINAL OF OR EQUAL TOSQUARE CAPSQ" +
	"UARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED TIMESCIRCLED DIVISION SLASHCIRC" +
	"LED DOT OPERATORCIRCLED RING OPERATORCIRCLED ASTERISK OPERATORCIRCLED EQ" +
	"UALSCIRCLED DASHSQUARED PLUSSQUARED MINUSSQUARED TIMESSQUARED DOT OPERAT" +
	"ORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSERTIONMODELSTRUEFORCESTRIPLE VER" +
	"TICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILEDOES " +
	"NOT PROVENOT TRUEDOES NOT FORCENEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT " +
	"TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS UNDER RELATIONNORMAL SUBGROUP O" +
	"FCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROUP OF OR EQUAL TOCONTAINS AS NO" +
	"RMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE OFMULTIMAPHERMITIAN CONJUGATE " +
	"MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WITH ARCRIGHT TRIANGLEN-ARY LOGIC" +
	"AL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-ARY UNIONDIAMOND OPERATORDOT O" +
	"PERATORSTAR OPERATORDIVISION TIMESBOWTIELEFT NORMAL FACTOR SEMIDIRECT PR" +
	"ODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUCTLEFT SEMIDIRECT PRODUCTRIGHT " +
	"SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCURLY LOGICAL ORCURLY LOGICAL AND" +
	"DOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSECTIONDOUBLE UNIONPITCHFORKEQUA" +
	"L AND PARALLEL TOLESS-THAN WITH DOTGREATER-THAN WITH DOTVERY MUCH LESS-T" +
	"HANVERY MUCH GREATER-THANLESS-THAN EQUAL TO OR GREATER-THANGREATER-THAN " +
	"EQUAL TO OR LESS-THANEQUAL TO OR LESS-THANEQUAL TO OR GREATER-THANEQUAL " +
	"TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT PRECEDE OR EQUALDOES NOT SUCC" +
	"EED OR EQUALNOT SQUARE IMAGE OF OR EQUAL TONOT SQUARE ORIGINAL OF OR EQU" +
	"AL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE ORIGINAL OF OR NOT EQUAL TOLE" +
	"SS-THAN BUT NOT EQUIVALENT TOGREATER-THAN BUT NOT EQUIVALENT TOPRECEDES " +
	"BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUIVALENT TONOT NORMAL SUBGROUP O" +
	"FDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NORMAL SUBGROUP OF OR EQUAL TODO" +
	"ES NOT CONTAIN AS NORMAL SUBGROUP OR EQUALVERTICAL ELLIPSISMIDLINE HORIZ" +
	"ONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDOWN RIGHT DIAGONAL ELLIPSISELEM" +
	"ENT OF WITH LONG HORIZONTAL STROKEELEMENT OF WITH VERTICAL BAR AT END OF" +
	" HORIZONTAL STROKESMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTA" +
	"L STROKEELEMENT OF WITH DOT ABOVEELEMENT OF WITH OVERBARSMALL ELEMENT OF" +
	" WITH OVERBARELEMENT OF WITH UNDERBARELEMENT OF WITH TWO HORIZONTAL STRO" +
	"KESCONTAINS WITH LONG HORIZONTAL STROKECONTAINS WITH VERTICAL BAR AT END" +
	" OF HORIZONTAL STROKESMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONT" +
	"AL STROKECONTAINS WITH OVERBARSMALL CONTAINS WITH OVERBARZ NOTATION BAG " +
	"MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSEUP ARROWHEADDOWN ARROWHEADPROJ" +
	"ECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGHT CEILINGLEFT FLOORRIGHT FLOOR" +
	"BOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT CROPTOP LEFT CROPREVERSED NOT" +
	" SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHONE RECORDERPOSITION INDICATORV" +
	"IEWDATA SQUAREPLACE OF INTEREST SIGNTURNED NOT SIGNWATCHHOURGLASSTOP LEF" +
	"T CORNERTOP RIGHT CORNERBOTTOM LEFT CORNERBOTTOM RIGHT CORNERTOP HALF IN" +
	"TEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARROWHEAD BETWEEN TWO HORIZONTAL " +
	"BARSOPTION KEYERASE TO THE RIGHTX IN A RECTANGLE BOXKEYBOARDLEFT-POINTIN" +
	"G ANGLE BRACKETRIGHT-POINTING ANGLE BRACKETERASE TO THE LEFTBENZENE RING" +
	"CYLINDRICITYALL AROUND-PROFILESYMMETRYTOTAL RUNOUTDIMENSION ORIGINCONICA" +
	"L TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNCTIONAL SYMBOL I-BEAMAPL FUNCTI" +
	"ONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMBOL QUAD EQUALAPL FUNCTIONAL SY" +
	"MBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD DIAMONDAPL FUNCTIONAL SYMBOL " +
	"QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEAPL FUNCTIONAL SYMBOL CIRCLE ST" +
	"ILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUNCTIONAL SYMBOL SLASH BARAPL FU" +
	"NCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONAL SYMBOL QUAD SLASHAPL FUNCTIO" +
	"NAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SYMBOL QUAD LESS-THANAPL FUNCTIO") + ("" +
	"NAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL SYMBOL LEFTWARDS VANEAPL FUNC" +
	"TIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROWA" +
	"PL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROWAPL FUNCTIONAL SYMBOL CIRCLE B" +
	"ACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UNDERBARAPL FUNCTIONAL SYMBOL DE" +
	"LTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN CARETAPL FUNCTIONAL SYMBOL QUAD" +
	" DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTAPL FUNCTIONAL SYMBOL UPWARDS V" +
	"ANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARROWAPL FUNCTIONAL SYMBOL UP TACK" +
	" OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL FUNCTIONAL SYMBOL QUAD UP CAR" +
	"ETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTIONAL SYMBOL UP TACK JOTAPL FUN" +
	"CTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROWA" +
	"PL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUNCTIONAL SYMBOL DELTA UNDERBARA" +
	"PL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL FUNCTIONAL SYMBOL JOT UNDERBARA" +
	"PL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FUNCTIONAL SYMBOL UP SHOE JOTAPL" +
	" FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONAL SYMBOL CIRCLE STARAPL FUNCTI" +
	"ONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBOL UP TACK DIAERESISAPL FUNCTIO" +
	"NAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYMBOL STAR DIAERESISAPL FUNCTION" +
	"AL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMBOL CIRCLE DIAERESISAPL FUNCTIO" +
	"NAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL SYMBOL LEFT SHOE STILEAPL FUNCT" +
	"IONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS" +
	"APL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIONAL SYMBOL DEL TILDEAPL FUNCTI" +
	"ONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STILE TILDEAPL FUNCTIONAL SYMBOL " +
	"SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QUAD NOT EQUALAPL FUNCTIONAL SYM" +
	"BOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOWN CARET TILDEAPL FUNCTIONAL SY" +
	"MBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL IOTAAPL FUNCTIONAL SYMBOL RHOAP" +
	"L FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SYMBOL ALPHA UNDERBARAPL FUNCTIO" +
	"NAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL SYMBOL IOTA UNDERBARAPL FUNCTI" +
	"ONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL SYMBOL ALPHANOT CHECK MARKRIGHT" +
	" ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDERED OPEN BOXBELL SYMBOLVERTICAL" +
	" LINE WITH MIDDLE DOTINSERTION SYMBOLCONTINUOUS UNDERLINE SYMBOLDISCONTI" +
	"NUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPOSITION SYMBOLWHITE SQUARE WITH" +
	" CENTRE VERTICAL LINEENTER SYMBOLALTERNATIVE KEY SYMBOLHELM SYMBOLCIRCLE" +
	"D HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGLE DOWNBROKEN CIRCLE WITH NORTH" +
	"WEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYSTERESIS SYMBOLOPEN-CIRCUIT-OUTP" +
	"UT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE SYMBOLPASSIVE-PULL-DOWN-OUTPU" +
	"T SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIRECT CURRENT SYMBOL FORM TWOSOFTW" +
	"ARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL QUADDECIMAL SEPARATOR KEY SYMBO" +
	"LPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOLCLEAR SCREEN SYMBOLLEFT PARENT" +
	"HESIS UPPER HOOKLEFT PARENTHESIS EXTENSIONLEFT PARENTHESIS LOWER HOOKRIG" +
	"HT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS EXTENSIONRIGHT PARENTHESIS LO" +
	"WER HOOKLEFT SQUARE BRACKET UPPER CORNERLEFT SQUARE BRACKET EXTENSIONLEF" +
	"T SQUARE BRACKET LOWER CORNERRIGHT SQUARE BRACKET UPPER CORNERRIGHT SQUA" +
	"RE BRACKET EXTENSIONRIGHT SQUARE BRACKET LOWER CORNERLEFT CURLY BRACKET " +
	"UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECELEFT CURLY BRACKET LOWER HOOKCU" +
	"RLY BRACKET EXTENSIONRIGHT CURLY BRACKET UPPER HOOKRIGHT CURLY BRACKET M" +
	"IDDLE PIECERIGHT CURLY BRACKET LOWER HOOKINTEGRAL EXTENSIONHORIZONTAL LI" +
	"NE EXTENSIONUPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTIONUPPER RIGHT O" +
	"R LOWER LEFT CURLY BRACKET SECTIONSUMMATION TOPSUMMATION BOTTOMTOP SQUAR" +
	"E BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUARE BRACKET OVER TOP SQUARE BRAC" +
	"KETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX LINERIGHT VERTICAL BOX LINEHOR" +
	"IZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3HORIZONTAL SCAN LINE-7HORIZONTA" +
	"L SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHTDENTISTRY SYMB" +
	"OL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTRY SYMBOL LIGHT VERTICAL WITH C" +
	"IRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLEDENTISTRY SYM" +
	"BOL LIGHT UP AND HORIZONTAL WITH CIRCLEDENTISTRY SYMBOL LIGHT VERTICAL W" +
	"ITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLEDENT" +
	"ISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT" +
	" VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVEDE" +
	"NTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVEDENTISTRY SYMBOL LIGHT D" +
	"OWN AND HORIZONTALDENTISTRY SYMBOL LIGHT UP AND HORIZONTALDENTISTRY SYMB" +
	"OL LIGHT VERTICAL AND TOP LEFTDENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM" +
	" LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLVERTICAL LINE EXTENSIONMETRICAL" +
	" BREVEMETRICAL LONG OVER SHORTMETRICAL SHORT OVER LONGMETRICAL LONG OVER" +
	" TWO SHORTSMETRICAL TWO SHORTS OVER LONGMETRICAL TWO SHORTS JOINEDMETRIC" +
	"AL TRISEMEMETRICAL TETRASEMEMETRICAL PENTASEMEEARTH GROUNDFUSETOP PARENT") + ("" +
	"HESISBOTTOM PARENTHESISTOP CURLY BRACKETBOTTOM CURLY BRACKETTOP TORTOISE" +
	" SHELL BRACKETBOTTOM TORTOISE SHELL BRACKETWHITE TRAPEZIUMBENZENE RING W" +
	"ITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTELECTRICAL INTERSECTIONDECIMAL E" +
	"XPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE TRIANGLEBLACK LEFT-POINTING DO" +
	"UBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIANGLEBLACK DOWN-POINTING DOUBLE" +
	" TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK LEF" +
	"T-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK RIGHT-POINTING TRIANGL" +
	"E WITH DOUBLE VERTICAL BARALARM CLOCKSTOPWATCHTIMER CLOCKHOURGLASS WITH " +
	"FLOWING SANDBLACK MEDIUM LEFT-POINTING TRIANGLEBLACK MEDIUM RIGHT-POINTI" +
	"NG TRIANGLEBLACK MEDIUM UP-POINTING TRIANGLEBLACK MEDIUM DOWN-POINTING T" +
	"RIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR STOPBLACK CIRCLE FOR RECORDPO" +
	"WER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMBOLPOWER SLEEP SYMBOLOBSERVER E" +
	"YE SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSYMBOL FOR START OF T" +
	"EXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSIONSYMBOL FOR ENQUIR" +
	"YSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACKSPACESYMBOL FOR HOR" +
	"IZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERTICAL TABULATIONSYMB" +
	"OL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR SHIFT OUTSYMBOL FOR" +
	" SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE CONTROL ONESYMBOL " +
	"FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREESYMBOL FOR DEVICE C" +
	"ONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR SYNCHRONOUS IDLESYM" +
	"BOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYMBOL FOR END OF MEDI" +
	"UMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FILE SEPARATORSYMBOL " +
	"FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL FOR UNIT SEPARATORS" +
	"YMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXSYMBOL FOR NEWLINESY" +
	"MBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TWOOCR HOOKOCR CHAIRO" +
	"CR FORKOCR INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR BRANCH BANK IDENTI" +
	"FICATIONOCR AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOUNT NUMBEROCR DOUBLE" +
	" BACKSLASHCIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED DIGIT THREECIRCLED D" +
	"IGIT FOURCIRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED DIGIT SEVENCIRCLED D" +
	"IGIT EIGHTCIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED NUMBER ELEVENCIRCL" +
	"ED NUMBER TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER FOURTEENCIRCLED NU" +
	"MBER FIFTEENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVENTEENCIRCLED NUMBER" +
	" EIGHTEENCIRCLED NUMBER NINETEENCIRCLED NUMBER TWENTYPARENTHESIZED DIGIT" +
	" ONEPARENTHESIZED DIGIT TWOPARENTHESIZED DIGIT THREEPARENTHESIZED DIGIT " +
	"FOURPARENTHESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPARENTHESIZED DIGIT S" +
	"EVENPARENTHESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINEPARENTHESIZED NUMBE" +
	"R TENPARENTHESIZED NUMBER ELEVENPARENTHESIZED NUMBER TWELVEPARENTHESIZED" +
	" NUMBER THIRTEENPARENTHESIZED NUMBER FOURTEENPARENTHESIZED NUMBER FIFTEE" +
	"NPARENTHESIZED NUMBER SIXTEENPARENTHESIZED NUMBER SEVENTEENPARENTHESIZED" +
	" NUMBER EIGHTEENPARENTHESIZED NUMBER NINETEENPARENTHESIZED NUMBER TWENTY" +
	"DIGIT ONE FULL STOPDIGIT TWO FULL STOPDIGIT THREE FULL STOPDIGIT FOUR FU" +
	"LL STOPDIGIT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT SEVEN FULL STOPDIGIT" +
	" EIGHT FULL STOPDIGIT NINE FULL STOPNUMBER TEN FULL STOPNUMBER ELEVEN FU" +
	"LL STOPNUMBER TWELVE FULL STOPNUMBER THIRTEEN FULL STOPNUMBER FOURTEEN F" +
	"ULL STOPNUMBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL STOPNUMBER SEVENTEEN" +
	" FULL STOPNUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FULL STOPNUMBER TWENT" +
	"Y FULL STOPPARENTHESIZED LATIN SMALL LETTER APARENTHESIZED LATIN SMALL L" +
	"ETTER BPARENTHESIZED LATIN SMALL LETTER CPARENTHESIZED LATIN SMALL LETTE" +
	"R DPARENTHESIZED LATIN SMALL LETTER EPARENTHESIZED LATIN SMALL LETTER FP" +
	"ARENTHESIZED LATIN SMALL LETTER GPARENTHESIZED LATIN SMALL LETTER HPAREN" +
	"THESIZED LATIN SMALL LETTER IPARENTHESIZED LATIN SMALL LETTER JPARENTHES" +
	"IZED LATIN SMALL LETTER KPARENTHESIZED LATIN SMALL LETTER LPARENTHESIZED" +
	" LATIN SMALL LETTER MPARENTHESIZED LATIN SMALL LETTER NPARENTHESIZED LAT" +
	"IN SMALL LETTER OPARENTHESIZED LATIN SMALL LETTER PPARENTHESIZED LATIN S" +
	"MALL LETTER QPARENTHESIZED LATIN SMALL LETTER RPARENTHESIZED LATIN SMALL" +
	" LETTER SPARENTHESIZED LATIN SMALL LETTER TPARENTHESIZED LATIN SMALL LET" +
	"TER UPARENTHESIZED LATIN SMALL LETTER VPARENTHESIZED LATIN SMALL LETTER " +
	"WPARENTHESIZED LATIN SMALL LETTER XPARENTHESIZED LATIN SMALL LETTER YPAR" +
	"ENTHESIZED LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL LETTER ACIRCLED LAT" +
	"IN CAPITAL LETTER BCIRCLED LATIN CAPITAL LETTER CCIRCLED LATIN CAPITAL L" +
	"ETTER DCIRCLED LATIN CAPITAL LETTER ECIRCLED LATIN CAPITAL LETTER FCIRCL" +
	"ED LATIN CAPITAL LETTER GCIRCLED LATIN CAPITAL LETTER HCIRCLED LATIN CAP" +
	"ITAL LETTER ICIRCLED LATIN CAPITAL LETTER JCIRCLED LATIN CAPITAL LETTER " +
	"KCIRCLED LATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL LETTER MCIRCLED LAT") + ("" +
	"IN CAPITAL LETTER NCIRCLED LATIN CAPITAL LETTER OCIRCLED LATIN CAPITAL L" +
	"ETTER PCIRCLED LATIN CAPITAL LETTER QCIRCLED LATIN CAPITAL LETTER RCIRCL" +
	"ED LATIN CAPITAL LETTER SCIRCLED LATIN CAPITAL LETTER TCIRCLED LATIN CAP" +
	"ITAL LETTER UCIRCLED LATIN CAPITAL LETTER VCIRCLED LATIN CAPITAL LETTER " +
	"WCIRCLED LATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL LETTER YCIRCLED LAT" +
	"IN CAPITAL LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLED LATIN SMALL LETTE" +
	"R BCIRCLED LATIN SMALL LETTER CCIRCLED LATIN SMALL LETTER DCIRCLED LATIN" +
	" SMALL LETTER ECIRCLED LATIN SMALL LETTER FCIRCLED LATIN SMALL LETTER GC" +
	"IRCLED LATIN SMALL LETTER HCIRCLED LATIN SMALL LETTER ICIRCLED LATIN SMA" +
	"LL LETTER JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN SMALL LETTER LCIRCL" +
	"ED LATIN SMALL LETTER MCIRCLED LATIN SMALL LETTER NCIRCLED LATIN SMALL L" +
	"ETTER OCIRCLED LATIN SMALL LETTER PCIRCLED LATIN SMALL LETTER QCIRCLED L" +
	"ATIN SMALL LETTER RCIRCLED LATIN SMALL LETTER SCIRCLED LATIN SMALL LETTE" +
	"R TCIRCLED LATIN SMALL LETTER UCIRCLED LATIN SMALL LETTER VCIRCLED LATIN" +
	" SMALL LETTER WCIRCLED LATIN SMALL LETTER XCIRCLED LATIN SMALL LETTER YC" +
	"IRCLED LATIN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE CIRCLED NUMBER ELE" +
	"VENNEGATIVE CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUMBER THIRTEENNEGATIV" +
	"E CIRCLED NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFTEENNEGATIVE CIRCLED" +
	" NUMBER SIXTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGATIVE CIRCLED NUMBER " +
	"EIGHTEENNEGATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRCLED NUMBER TWENTYDO" +
	"UBLE CIRCLED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE CIRCLED DIGIT THREE" +
	"DOUBLE CIRCLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOUBLE CIRCLED DIGIT S" +
	"IXDOUBLE CIRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGHTDOUBLE CIRCLED DIG" +
	"IT NINEDOUBLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGIT ZEROBOX DRAWINGS " +
	"LIGHT HORIZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAWINGS LIGHT VERTICAL" +
	"BOX DRAWINGS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE DASH HORIZONTALBOX " +
	"DRAWINGS HEAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIGHT TRIPLE DASH VERT" +
	"ICALBOX DRAWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWINGS LIGHT QUADRUPLE " +
	"DASH HORIZONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTALBOX DRAWINGS " +
	"LIGHT QUADRUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADRUPLE DASH VERTICALB" +
	"OX DRAWINGS LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIGHT AND RIGHT HEAVYB" +
	"OX DRAWINGS DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY DOWN AND RIGHTB" +
	"OX DRAWINGS LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGHT AND LEFT HEAVYBOX" +
	" DRAWINGS DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY DOWN AND LEFTBOX D" +
	"RAWINGS LIGHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND RIGHT HEAVYBOX DRAWI" +
	"NGS UP HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND RIGHTBOX DRAWINGS " +
	"LIGHT UP AND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEA" +
	"VY AND LEFT LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DRAWINGS LIGHT VERTIC" +
	"AL AND RIGHTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVYBOX DRAWINGS UP H" +
	"EAVY AND RIGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHTBOX D" +
	"RAWINGS VERTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DOWN LIGHT AND RIGHT " +
	"UP HEAVYBOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX DRAWINGS HEAVY VER" +
	"TICAL AND RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBOX DRAWINGS VERTICAL" +
	" LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHTBOX DRAWIN" +
	"GS DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND LEFT LIGH" +
	"TBOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWINGS UP LIGHT AND LEFT" +
	" DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DRAWINGS LIGHT DOWN A" +
	"ND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS RI" +
	"GHT HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAV" +
	"YBOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AN" +
	"D LEFT DOWN HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVYBOX DRAWING" +
	"S HEAVY DOWN AND HORIZONTALBOX DRAWINGS LIGHT UP AND HORIZONTALBOX DRAWI" +
	"NGS LEFT HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT UP LI" +
	"GHTBOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND H" +
	"ORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVYBOX DRAWINGS LE" +
	"FT LIGHT AND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND HORIZONTALBOX DRAWI" +
	"NGS LIGHT VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT VERTI" +
	"CAL LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHTBOX DRAWINGS VE" +
	"RTICAL LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND DOWN HORIZONT" +
	"AL LIGHTBOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHTBOX DRAWINGS VERT" +
	"ICAL HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN" +
	" LIGHTBOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS LEFT D" +
	"OWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LI" +
	"GHTBOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX DRAWINGS UP LIGHT ") + ("" +
	"AND DOWN HORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAV" +
	"YBOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX DRAWINGS HEAVY VERT" +
	"ICAL AND HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HORIZONTALBOX DRAWINGS" +
	" HEAVY DOUBLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH VERTICALBOX " +
	"DRAWINGS HEAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBLE HORIZONTALBOX DRA" +
	"WINGS DOUBLE VERTICALBOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLEBOX DRAWIN" +
	"GS DOWN DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DOWN AND RIGHTBOX DRA" +
	"WINGS DOWN SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DOUBLE AND LEFT SINGL" +
	"EBOX DRAWINGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SINGLE AND RIGHT DOUBL" +
	"EBOX DRAWINGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE UP AND RIGHT" +
	"BOX DRAWINGS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP DOUBLE AND LEFT SI" +
	"NGLEBOX DRAWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTICAL SINGLE AND RIGH" +
	"T DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE" +
	" VERTICAL AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLEBOX DRAWI" +
	"NGS VERTICAL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE VERTICAL AND LEFT" +
	"BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS DOWN DOUBLE A" +
	"ND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORIZONTALBOX DRAWINGS " +
	"UP SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE AND HORIZONTAL SIN" +
	"GLEBOX DRAWINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS VERTICAL SINGLE AND" +
	" HORIZONTAL DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLEBOX " +
	"DRAWINGS DOUBLE VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT ARC DOWN AND R" +
	"IGHTBOX DRAWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS LIGHT ARC UP AND LE" +
	"FTBOX DRAWINGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIGHT DIAGONAL UPPER R" +
	"IGHT TO LOWER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHTB" +
	"OX DRAWINGS LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LEFTBOX DRAWINGS LIGH" +
	"T UPBOX DRAWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBOX DRAWINGS HEAVY LE" +
	"FTBOX DRAWINGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DRAWINGS HEAVY DOWNBO" +
	"X DRAWINGS LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIGHT UP AND HEAVY DOW" +
	"NBOX DRAWINGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS HEAVY UP AND LIGHT " +
	"DOWNUPPER HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE QUARTER BLOCKLOWER T" +
	"HREE EIGHTHS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS BLOCKLOWER THREE QU" +
	"ARTERS BLOCKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT SEVEN EIGHTHS BLOCKL" +
	"EFT THREE QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT HALF BLOCKLEFT THREE" +
	" EIGHTHS BLOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH BLOCKRIGHT HALF BLOC" +
	"KLIGHT SHADEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BLOCKRIGHT ONE EIGHTH" +
	" BLOCKQUADRANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT UPPER LEFTQUADRANT" +
	" UPPER LEFT AND LOWER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT AND LOWER " +
	"RIGHTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFTQUADRANT UPPER LE" +
	"FT AND UPPER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGHTQUADRANT UPPER RIG" +
	"HT AND LOWER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHTBLAC" +
	"K SQUAREWHITE SQUAREWHITE SQUARE WITH ROUNDED CORNERSWHITE SQUARE CONTAI" +
	"NING BLACK SMALL SQUARESQUARE WITH HORIZONTAL FILLSQUARE WITH VERTICAL F" +
	"ILLSQUARE WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH UPPER LEFT TO LOWER" +
	" RIGHT FILLSQUARE WITH UPPER RIGHT TO LOWER LEFT FILLSQUARE WITH DIAGONA" +
	"L CROSSHATCH FILLBLACK SMALL SQUAREWHITE SMALL SQUAREBLACK RECTANGLEWHIT" +
	"E RECTANGLEBLACK VERTICAL RECTANGLEWHITE VERTICAL RECTANGLEBLACK PARALLE" +
	"LOGRAMWHITE PARALLELOGRAMBLACK UP-POINTING TRIANGLEWHITE UP-POINTING TRI" +
	"ANGLEBLACK UP-POINTING SMALL TRIANGLEWHITE UP-POINTING SMALL TRIANGLEBLA" +
	"CK RIGHT-POINTING TRIANGLEWHITE RIGHT-POINTING TRIANGLEBLACK RIGHT-POINT" +
	"ING SMALL TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLEBLACK RIGHT-POINTIN" +
	"G POINTERWHITE RIGHT-POINTING POINTERBLACK DOWN-POINTING TRIANGLEWHITE D" +
	"OWN-POINTING TRIANGLEBLACK DOWN-POINTING SMALL TRIANGLEWHITE DOWN-POINTI" +
	"NG SMALL TRIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LEFT-POINTING TRIANGL" +
	"EBLACK LEFT-POINTING SMALL TRIANGLEWHITE LEFT-POINTING SMALL TRIANGLEBLA" +
	"CK LEFT-POINTING POINTERWHITE LEFT-POINTING POINTERBLACK DIAMONDWHITE DI" +
	"AMONDWHITE DIAMOND CONTAINING BLACK SMALL DIAMONDFISHEYELOZENGEWHITE CIR" +
	"CLEDOTTED CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLACK CIRCLECIRCLE WITH" +
	" LEFT HALF BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WITH LOWER HALF BLACK" +
	"CIRCLE WITH UPPER HALF BLACKCIRCLE WITH UPPER RIGHT QUADRANT BLACKCIRCLE" +
	" WITH ALL BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLACK CIRCLERIGHT HALF " +
	"BLACK CIRCLEINVERSE BULLETINVERSE WHITE CIRCLEUPPER HALF INVERSE WHITE C" +
	"IRCLELOWER HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRANT CIRCULAR ARCUPPE" +
	"R RIGHT QUADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIRCULAR ARCLOWER LEFT" +
	" QUADRANT CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIRCLEBLACK LOWER RIGH") + ("" +
	"T TRIANGLEBLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT TRIANGLEBLACK UPPER " +
	"RIGHT TRIANGLEWHITE BULLETSQUARE WITH LEFT HALF BLACKSQUARE WITH RIGHT H" +
	"ALF BLACKSQUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQUARE WITH LOWER RIG" +
	"HT DIAGONAL HALF BLACKWHITE SQUARE WITH VERTICAL BISECTING LINEWHITE UP-" +
	"POINTING TRIANGLE WITH DOTUP-POINTING TRIANGLE WITH LEFT HALF BLACKUP-PO" +
	"INTING TRIANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHITE SQUARE WITH UPPER" +
	" LEFT QUADRANTWHITE SQUARE WITH LOWER LEFT QUADRANTWHITE SQUARE WITH LOW" +
	"ER RIGHT QUADRANTWHITE SQUARE WITH UPPER RIGHT QUADRANTWHITE CIRCLE WITH" +
	" UPPER LEFT QUADRANTWHITE CIRCLE WITH LOWER LEFT QUADRANTWHITE CIRCLE WI" +
	"TH LOWER RIGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT QUADRANTUPPER LEFT " +
	"TRIANGLEUPPER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE MEDIUM SQUAREBLACK " +
	"MEDIUM SQUAREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SMALL SQUARELOWER RIG" +
	"HT TRIANGLEBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOMETBLACK STARWHITE S" +
	"TARLIGHTNINGTHUNDERSTORMSUNASCENDING NODEDESCENDING NODECONJUNCTIONOPPOS" +
	"ITIONBLACK TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT BOX WITH CHECKBALLOT" +
	" BOX WITH XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAGEWHITE SHOGI PIECEB" +
	"LACK SHOGI PIECESHAMROCKREVERSED ROTATED FLORAL HEART BULLETBLACK LEFT P" +
	"OINTING INDEXBLACK RIGHT POINTING INDEXWHITE LEFT POINTING INDEXWHITE UP" +
	" POINTING INDEXWHITE RIGHT POINTING INDEXWHITE DOWN POINTING INDEXSKULL " +
	"AND CROSSBONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD SIGNCADUCEUSANKHORTH" +
	"ODOX CROSSCHI RHOCROSS OF LORRAINECROSS OF JERUSALEMSTAR AND CRESCENTFAR" +
	"SI SYMBOLADI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN YANGTRIGRAM FOR HEAV" +
	"ENTRIGRAM FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDERTRIGRAM FOR WINDTRI" +
	"GRAM FOR WATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWHEEL OF DHARMAWHITE " +
	"FROWNING FACEWHITE SMILING FACEBLACK SMILING FACEWHITE SUN WITH RAYSFIRS" +
	"T QUARTER MOONLAST QUARTER MOONMERCURYFEMALE SIGNEARTHMALE SIGNJUPITERSA" +
	"TURNURANUSNEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGOLIBRASCORPIUSSAGITT" +
	"ARIUSCAPRICORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHESS QUEENWHITE CHESS" +
	" ROOKWHITE CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS PAWNBLACK CHESS KIN" +
	"GBLACK CHESS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPBLACK CHESS KNIGHTBL" +
	"ACK CHESS PAWNBLACK SPADE SUITWHITE HEART SUITWHITE DIAMOND SUITBLACK CL" +
	"UB SUITWHITE SPADE SUITBLACK HEART SUITBLACK DIAMOND SUITWHITE CLUB SUIT" +
	"HOT SPRINGSQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTESBEAMED SIXTEENTH NO" +
	"TESMUSIC FLAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNWEST SYRIAC CROSSEAS" +
	"T SYRIAC CROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYMBOL FOR TYPE-1 PLAS" +
	"TICSRECYCLING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYMBOL FOR TYPE-3 PLAS" +
	"TICSRECYCLING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYMBOL FOR TYPE-5 PLAS" +
	"TICSRECYCLING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYMBOL FOR TYPE-7 PLAS" +
	"TICSRECYCLING SYMBOL FOR GENERIC MATERIALSBLACK UNIVERSAL RECYCLING SYMB" +
	"OLRECYCLED PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBOLPERMANENT PAPER SI" +
	"GNWHEELCHAIR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE FACE-4DIE FACE-5DIE" +
	" FACE-6WHITE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH TWO DOTSBLACK CIRCLE" +
	" WITH WHITE DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTSMONOGRAM FOR YANGMO" +
	"NOGRAM FOR YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSER YINDIGRAM FOR LES" +
	"SER YANGDIGRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAMMER AND PICKANCHORC" +
	"ROSSED SWORDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERGEARSTAFF OF HERMESA" +
	"TOM SYMBOLFLEUR-DE-LISOUTLINED WHITE STARTHREE LINES CONVERGING RIGHTTHR" +
	"EE LINES CONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGNDOUBLED FEMALE SIGN" +
	"DOUBLED MALE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE AND FEMALE SIGNMAL" +
	"E WITH STROKE SIGNMALE WITH STROKE AND MALE AND FEMALE SIGNVERTICAL MALE" +
	" WITH STROKE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDIUM WHITE CIRCLEMEDI" +
	"UM BLACK CIRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMBOLDIVORCE SYMBOLUNM" +
	"ARRIED PARTNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERESPALLASJUNOVESTACHIR" +
	"ONBLACK MOON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQUADRATESOCCER BALLBA" +
	"SEBALLSQUARED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KINGBLACK DRAUGHTS MAN" +
	"BLACK DRAUGHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLOUDRAINBLACK SNOWMAN" +
	"THUNDER CLOUD AND RAINTURNED WHITE SHOGI PIECETURNED BLACK SHOGI PIECEWH" +
	"ITE DIAMOND IN SQUARECROSSING LANESDISABLED CAROPHIUCHUSPICKCAR SLIDINGH" +
	"ELMET WITH WHITE CROSSCIRCLED CROSSING LANESCHAINSNO ENTRYALTERNATE ONE-" +
	"WAY LEFT WAY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHITE TWO-WAY LEFT WAY" +
	" TRAFFICBLACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRIVE SLOW SIGNHEAVY W" +
	"HITE DOWN-POINTING TRIANGLELEFT CLOSED ENTRYSQUARED SALTIREFALLING DIAGO" +
	"NAL IN WHITE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRICTED LEFT ENTRY-1RES" +
	"TRICTED LEFT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEAVY CIRCLE WITH STRO") + ("" +
	"KE AND TWO DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED PENTAGRAMLEFT-HAND" +
	"ED INTERLACED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS ON SHIELDSHINTO SHR" +
	"INECHURCHCASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH HANDLESMAP SYMBOL " +
	"FOR LIGHTHOUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG IN HOLEFERRYSAILBOA" +
	"TSQUARE FOUR CORNERSSKIERICE SKATEPERSON WITH BALLTENTJAPANESE BANK SYMB" +
	"OLHEADSTONE GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQUAREWHITE FLAG WITH " +
	"HORIZONTAL MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUPPER BLADE SCISSORSB" +
	"LACK SCISSORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE HEAVY CHECK MARKTEL" +
	"EPHONE LOCATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED FISTRAISED HANDVICT" +
	"ORY HANDWRITING HANDLOWER RIGHT PENCILPENCILUPPER RIGHT PENCILWHITE NIBB" +
	"LACK NIBCHECK MARKHEAVY CHECK MARKMULTIPLICATION XHEAVY MULTIPLICATION X" +
	"BALLOT XHEAVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK CROSSOPEN CENTRE C" +
	"ROSSHEAVY OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE LATIN CROSSOUTLINED" +
	" LATIN CROSSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-SPOKED ASTERISKFOUR " +
	"BALLOON-SPOKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTERISKFOUR CLUB-SPOKE" +
	"D ASTERISKBLACK FOUR POINTED STARWHITE FOUR POINTED STARSPARKLESSTRESS O" +
	"UTLINED WHITE STARCIRCLED WHITE STAROPEN CENTRE BLACK STARBLACK CENTRE W" +
	"HITE STAROUTLINED BLACK STARHEAVY OUTLINED BLACK STARPINWHEEL STARSHADOW" +
	"ED WHITE STARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT SPOKED ASTERISKEIGH" +
	"T POINTED BLACK STAREIGHT POINTED PINWHEEL STARSIX POINTED BLACK STAREIG" +
	"HT POINTED RECTILINEAR BLACK STARHEAVY EIGHT POINTED RECTILINEAR BLACK S" +
	"TARTWELVE POINTED BLACK STARSIXTEEN POINTED ASTERISKTEARDROP-SPOKED ASTE" +
	"RISKOPEN CENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDROP-SPOKED ASTERISKSI" +
	"X PETALLED BLACK AND WHITE FLORETTEBLACK FLORETTEWHITE FLORETTEEIGHT PET" +
	"ALLED OUTLINED BLACK FLORETTECIRCLED OPEN CENTRE EIGHT POINTED STARHEAVY" +
	" TEARDROP-SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIFOLIATE SNOWFLAKEHEA" +
	"VY CHEVRON SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKED ASTERISKEIGHT TEA" +
	"RDROP-SPOKED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-SPOKED PROPELLER AST" +
	"ERISKCROSS MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED CROSS MARKLOWER RIG" +
	"HT DROP-SHADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWED WHITE SQUARELOWER" +
	" RIGHT SHADOWED WHITE SQUAREUPPER RIGHT SHADOWED WHITE SQUAREBLACK QUEST" +
	"ION MARK ORNAMENTWHITE QUESTION MARK ORNAMENTWHITE EXCLAMATION MARK ORNA" +
	"MENTBLACK DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK SYMBOLLIGHT VERTIC" +
	"AL BARMEDIUM VERTICAL BARHEAVY VERTICAL BARHEAVY SINGLE TURNED COMMA QUO" +
	"TATION MARK ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK ORNAMENTHEAVY DOUB" +
	"LE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE COMMA QUOTATION MARK" +
	" ORNAMENTHEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENTHEAVY LOW DOUBLE " +
	"COMMA QUOTATION MARK ORNAMENTCURVED STEM PARAGRAPH SIGN ORNAMENTHEAVY EX" +
	"CLAMATION MARK ORNAMENTHEAVY HEART EXCLAMATION MARK ORNAMENTHEAVY BLACK " +
	"HEARTROTATED HEAVY BLACK HEART BULLETFLORAL HEARTROTATED FLORAL HEART BU" +
	"LLETMEDIUM LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PARENTHESIS ORNAMENTMED" +
	"IUM FLATTENED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTENED RIGHT PARENTHESI" +
	"S ORNAMENTMEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENTMEDIUM RIGHT-POINTI" +
	"NG ANGLE BRACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAME" +
	"NTHEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY LEFT-POINTING " +
	"ANGLE BRACKET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENTLIGHT L" +
	"EFT TORTOISE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOISE SHELL BRACKET OR" +
	"NAMENTMEDIUM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT CURLY BRACKET ORNAM" +
	"ENTDINGBAT NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE CIRCLED DIGIT TWOD" +
	"INGBAT NEGATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE CIRCLED DIGIT FOURDI" +
	"NGBAT NEGATIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIRCLED DIGIT SIXDINGB" +
	"AT NEGATIVE CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCLED DIGIT EIGHTDINGB" +
	"AT NEGATIVE CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLED NUMBER TENDINGBAT" +
	" CIRCLED SANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SERIF DIGIT TWODINGBAT" +
	" CIRCLED SANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-SERIF DIGIT FOURDING" +
	"BAT CIRCLED SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS-SERIF DIGIT SIXDIN" +
	"GBAT CIRCLED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SANS-SERIF DIGIT EIGH" +
	"TDINGBAT CIRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED SANS-SERIF NUMBER " +
	"TENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGBAT NEGATIVE CIRCLED" +
	" SANS-SERIF DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREEDING" +
	"BAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEGATIVE CIRCLED SANS-" +
	"SERIF DIGIT FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIXDINGBAT NEG" +
	"ATIVE CIRCLED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE CIRCLED SANS-SERIF " +
	"DIGIT EIGHTDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINEDINGBAT NEGATIV") + ("" +
	"E CIRCLED SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGHTWARDS ARROWHEAVY P" +
	"LUS SIGNHEAVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUTH EAST ARROWHEAVY R" +
	"IGHTWARDS ARROWHEAVY NORTH EAST ARROWDRAFTING POINT RIGHTWARDS ARROWHEAV" +
	"Y ROUND-TIPPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTWARDS ARROWHEAVY TRI" +
	"ANGLE-HEADED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED RIGHTWARDS ARROWHEAV" +
	"Y DASHED TRIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTWARDS ARROWTHREE-D T" +
	"OP-LIGHTED RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHE" +
	"ADBLACK RIGHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS " +
	"ARROWHEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROWSQUAT BLACK RIGHTWAR" +
	"DS ARROWHEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWRIGHT-SHADED WHITE R" +
	"IGHTWARDS ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK-TILTED SHADOWED WH" +
	"ITE RIGHTWARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROWHEAVY LO" +
	"WER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER RIGHT-SHADOWED WHIT" +
	"E RIGHTWARDS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWCUR" +
	"LY LOOPNOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWCIRCLED HEAVY " +
	"WHITE RIGHTWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARROWBLACK-FEATHERED SO" +
	"UTH EAST ARROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-FEATHERED NORTH EAST" +
	" ARROWHEAVY BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLACK-FEATHERED RIGHTW" +
	"ARDS ARROWHEAVY BLACK-FEATHERED NORTH EAST ARROWTEARDROP-BARBED RIGHTWAR" +
	"DS ARROWHEAVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-TAILED RIGHTWARDS A" +
	"RROWHEAVY WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED RIGHTWARDS ARROWDOU" +
	"BLE CURLY LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE CONTAINING SMALL WHI" +
	"TE TRIANGLEPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT S-SHAPED BAG DELIMI" +
	"TERRIGHT S-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVERSE SOLIDUS PRECEDI" +
	"NG SUBSETSUPERSET PRECEDING SOLIDUSVERTICAL BAR WITH HORIZONTAL STROKEMA" +
	"THEMATICAL RISING DIAGONALLONG DIVISIONMATHEMATICAL FALLING DIAGONALSQUA" +
	"RED LOGICAL ANDSQUARED LOGICAL ORWHITE DIAMOND WITH CENTRED DOTAND WITH " +
	"DOTELEMENT OF OPENING UPWARDSLOWER RIGHT CORNER WITH DOTUPPER LEFT CORNE" +
	"R WITH DOTLEFT OUTER JOINRIGHT OUTER JOINFULL OUTER JOINLARGE UP TACKLAR" +
	"GE DOWN TACKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND RIGHT TACKLEFT MULTI" +
	"MAPLONG RIGHT TACKLONG LEFT TACKUP TACK WITH CIRCLE ABOVELOZENGE DIVIDED" +
	" BY HORIZONTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE CONCAVE-SIDED DIAMON" +
	"D WITH LEFTWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICKWHI" +
	"TE SQUARE WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTWARDS TICKMATHEMATIC" +
	"AL LEFT WHITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE SQUARE BRACKETMATHE" +
	"MATICAL LEFT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BRACKETMATHEMATICAL L" +
	"EFT DOUBLE ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANGLE BRACKETMATHEMATI" +
	"CAL LEFT WHITE TORTOISE SHELL BRACKETMATHEMATICAL RIGHT WHITE TORTOISE S" +
	"HELL BRACKETMATHEMATICAL LEFT FLATTENED PARENTHESISMATHEMATICAL RIGHT FL" +
	"ATTENED PARENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS QUADRUPLE ARROWANTIC" +
	"LOCKWISE GAPPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE ARROWRIGHT ARROW WIT" +
	"H CIRCLED PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARROWLONG LEFT RIGHT A" +
	"RROWLONG LEFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE ARROWLONG LEFT RIG" +
	"HT DOUBLE ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGHTWARDS ARROW FROM B" +
	"ARLONG LEFTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS DOUBLE ARROW FROM " +
	"BARLONG RIGHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLANKBRAILLE PATTERN DO" +
	"TS-1BRAILLE PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAILLE PATTERN DOTS-3B" +
	"RAILLE PATTERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE PATTERN DOTS-123BRA" +
	"ILLE PATTERN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PATTERN DOTS-24BRAILLE" +
	" PATTERN DOTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTERN DOTS-134BRAILLE " +
	"PATTERN DOTS-234BRAILLE PATTERN DOTS-1234BRAILLE PATTERN DOTS-5BRAILLE P" +
	"ATTERN DOTS-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN DOTS-125BRAILLE PAT" +
	"TERN DOTS-35BRAILLE PATTERN DOTS-135BRAILLE PATTERN DOTS-235BRAILLE PATT" +
	"ERN DOTS-1235BRAILLE PATTERN DOTS-45BRAILLE PATTERN DOTS-145BRAILLE PATT" +
	"ERN DOTS-245BRAILLE PATTERN DOTS-1245BRAILLE PATTERN DOTS-345BRAILLE PAT" +
	"TERN DOTS-1345BRAILLE PATTERN DOTS-2345BRAILLE PATTERN DOTS-12345BRAILLE" +
	" PATTERN DOTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN DOTS-26BRAILLE PAT" +
	"TERN DOTS-126BRAILLE PATTERN DOTS-36BRAILLE PATTERN DOTS-136BRAILLE PATT" +
	"ERN DOTS-236BRAILLE PATTERN DOTS-1236BRAILLE PATTERN DOTS-46BRAILLE PATT" +
	"ERN DOTS-146BRAILLE PATTERN DOTS-246BRAILLE PATTERN DOTS-1246BRAILLE PAT" +
	"TERN DOTS-346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN DOTS-2346BRAILLE P" +
	"ATTERN DOTS-12346BRAILLE PATTERN DOTS-56BRAILLE PATTERN DOTS-156BRAILLE " +
	"PATTERN DOTS-256BRAILLE PATTERN DOTS-1256BRAILLE PATTERN DOTS-356BRAILLE" +
	" PATTERN DOTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PATTERN DOTS-12356BRA") + ("" +
	"ILLE PATTERN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE PATTERN DOTS-2456B" +
	"RAILLE PATTERN DOTS-12456BRAILLE PATTERN DOTS-3456BRAILLE PATTERN DOTS-1" +
	"3456BRAILLE PATTERN DOTS-23456BRAILLE PATTERN DOTS-123456BRAILLE PATTERN" +
	" DOTS-7BRAILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27BRAILLE PATTERN DOT" +
	"S-127BRAILLE PATTERN DOTS-37BRAILLE PATTERN DOTS-137BRAILLE PATTERN DOTS" +
	"-237BRAILLE PATTERN DOTS-1237BRAILLE PATTERN DOTS-47BRAILLE PATTERN DOTS" +
	"-147BRAILLE PATTERN DOTS-247BRAILLE PATTERN DOTS-1247BRAILLE PATTERN DOT" +
	"S-347BRAILLE PATTERN DOTS-1347BRAILLE PATTERN DOTS-2347BRAILLE PATTERN D" +
	"OTS-12347BRAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-157BRAILLE PATTERN " +
	"DOTS-257BRAILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS-357BRAILLE PATTERN" +
	" DOTS-1357BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DOTS-12357BRAILLE PAT" +
	"TERN DOTS-457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN DOTS-2457BRAILLE P" +
	"ATTERN DOTS-12457BRAILLE PATTERN DOTS-3457BRAILLE PATTERN DOTS-13457BRAI" +
	"LLE PATTERN DOTS-23457BRAILLE PATTERN DOTS-123457BRAILLE PATTERN DOTS-67" +
	"BRAILLE PATTERN DOTS-167BRAILLE PATTERN DOTS-267BRAILLE PATTERN DOTS-126" +
	"7BRAILLE PATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRAILLE PATTERN DOTS-2" +
	"367BRAILLE PATTERN DOTS-12367BRAILLE PATTERN DOTS-467BRAILLE PATTERN DOT" +
	"S-1467BRAILLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-12467BRAILLE PATTERN" +
	" DOTS-3467BRAILLE PATTERN DOTS-13467BRAILLE PATTERN DOTS-23467BRAILLE PA" +
	"TTERN DOTS-123467BRAILLE PATTERN DOTS-567BRAILLE PATTERN DOTS-1567BRAILL" +
	"E PATTERN DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE PATTERN DOTS-3567BR" +
	"AILLE PATTERN DOTS-13567BRAILLE PATTERN DOTS-23567BRAILLE PATTERN DOTS-1" +
	"23567BRAILLE PATTERN DOTS-4567BRAILLE PATTERN DOTS-14567BRAILLE PATTERN " +
	"DOTS-24567BRAILLE PATTERN DOTS-124567BRAILLE PATTERN DOTS-34567BRAILLE P" +
	"ATTERN DOTS-134567BRAILLE PATTERN DOTS-234567BRAILLE PATTERN DOTS-123456" +
	"7BRAILLE PATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE PATTERN DOTS-28BRA" +
	"ILLE PATTERN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE PATTERN DOTS-138BRAI" +
	"LLE PATTERN DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE PATTERN DOTS-48BRAI" +
	"LLE PATTERN DOTS-148BRAILLE PATTERN DOTS-248BRAILLE PATTERN DOTS-1248BRA" +
	"ILLE PATTERN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE PATTERN DOTS-2348B" +
	"RAILLE PATTERN DOTS-12348BRAILLE PATTERN DOTS-58BRAILLE PATTERN DOTS-158" +
	"BRAILLE PATTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAILLE PATTERN DOTS-35" +
	"8BRAILLE PATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BRAILLE PATTERN DOTS-" +
	"12358BRAILLE PATTERN DOTS-458BRAILLE PATTERN DOTS-1458BRAILLE PATTERN DO" +
	"TS-2458BRAILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS-3458BRAILLE PATTER" +
	"N DOTS-13458BRAILLE PATTERN DOTS-23458BRAILLE PATTERN DOTS-123458BRAILLE" +
	" PATTERN DOTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTERN DOTS-268BRAILLE " +
	"PATTERN DOTS-1268BRAILLE PATTERN DOTS-368BRAILLE PATTERN DOTS-1368BRAILL" +
	"E PATTERN DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE PATTERN DOTS-468BRA" +
	"ILLE PATTERN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILLE PATTERN DOTS-1246" +
	"8BRAILLE PATTERN DOTS-3468BRAILLE PATTERN DOTS-13468BRAILLE PATTERN DOTS" +
	"-23468BRAILLE PATTERN DOTS-123468BRAILLE PATTERN DOTS-568BRAILLE PATTERN" +
	" DOTS-1568BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DOTS-12568BRAILLE PAT" +
	"TERN DOTS-3568BRAILLE PATTERN DOTS-13568BRAILLE PATTERN DOTS-23568BRAILL" +
	"E PATTERN DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE PATTERN DOTS-14568" +
	"BRAILLE PATTERN DOTS-24568BRAILLE PATTERN DOTS-124568BRAILLE PATTERN DOT" +
	"S-34568BRAILLE PATTERN DOTS-134568BRAILLE PATTERN DOTS-234568BRAILLE PAT" +
	"TERN DOTS-1234568BRAILLE PATTERN DOTS-78BRAILLE PATTERN DOTS-178BRAILLE " +
	"PATTERN DOTS-278BRAILLE PATTERN DOTS-1278BRAILLE PATTERN DOTS-378BRAILLE" +
	" PATTERN DOTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PATTERN DOTS-12378BRA" +
	"ILLE PATTERN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE PATTERN DOTS-2478B" +
	"RAILLE PATTERN DOTS-12478BRAILLE PATTERN DOTS-3478BRAILLE PATTERN DOTS-1" +
	"3478BRAILLE PATTERN DOTS-23478BRAILLE PATTERN DOTS-123478BRAILLE PATTERN" +
	" DOTS-578BRAILLE PATTERN DOTS-1578BRAILLE PATTERN DOTS-2578BRAILLE PATTE" +
	"RN DOTS-12578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN DOTS-13578BRAILLE " +
	"PATTERN DOTS-23578BRAILLE PATTERN DOTS-123578BRAILLE PATTERN DOTS-4578BR" +
	"AILLE PATTERN DOTS-14578BRAILLE PATTERN DOTS-24578BRAILLE PATTERN DOTS-1" +
	"24578BRAILLE PATTERN DOTS-34578BRAILLE PATTERN DOTS-134578BRAILLE PATTER" +
	"N DOTS-234578BRAILLE PATTERN DOTS-1234578BRAILLE PATTERN DOTS-678BRAILLE" +
	" PATTERN DOTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PATTERN DOTS-12678BRA" +
	"ILLE PATTERN DOTS-3678BRAILLE PATTERN DOTS-13678BRAILLE PATTERN DOTS-236" +
	"78BRAILLE PATTERN DOTS-123678BRAILLE PATTERN DOTS-4678BRAILLE PATTERN DO" +
	"TS-14678BRAILLE PATTERN DOTS-24678BRAILLE PATTERN DOTS-124678BRAILLE PAT" +
	"TERN DOTS-34678BRAILLE PATTERN DOTS-134678BRAILLE PATTERN DOTS-234678BRA") + ("" +
	"ILLE PATTERN DOTS-1234678BRAILLE PATTERN DOTS-5678BRAILLE PATTERN DOTS-1" +
	"5678BRAILLE PATTERN DOTS-25678BRAILLE PATTERN DOTS-125678BRAILLE PATTERN" +
	" DOTS-35678BRAILLE PATTERN DOTS-135678BRAILLE PATTERN DOTS-235678BRAILLE" +
	" PATTERN DOTS-1235678BRAILLE PATTERN DOTS-45678BRAILLE PATTERN DOTS-1456" +
	"78BRAILLE PATTERN DOTS-245678BRAILLE PATTERN DOTS-1245678BRAILLE PATTERN" +
	" DOTS-345678BRAILLE PATTERN DOTS-1345678BRAILLE PATTERN DOTS-2345678BRAI" +
	"LLE PATTERN DOTS-12345678RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROK" +
	"ERIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS DOUBLE" +
	" ARROW WITH VERTICAL STROKERIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKEL" +
	"EFT RIGHT DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW F" +
	"ROM BARLEFTWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUBLE ARROW FROM BARDO" +
	"WNWARDS ARROW WITH HORIZONTAL STROKEUPWARDS ARROW WITH HORIZONTAL STROKE" +
	"UPWARDS TRIPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS DOUBLE DASH ARROWRIG" +
	"HTWARDS DOUBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWRIGHTWARDS TRIPLE DA" +
	"SH ARROWRIGHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTWARDS ARROW WITH DOT" +
	"TED STEMUPWARDS ARROW TO BARDOWNWARDS ARROW TO BARRIGHTWARDS ARROW WITH " +
	"TAIL WITH VERTICAL STROKERIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL" +
	" STROKERIGHTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARDS TWO-HEADED ARROW " +
	"WITH TAIL WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH" +
	" DOUBLE VERTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS ARROW-TAILLEFTWARD" +
	"S DOUBLE ARROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWARDS ARROW TO BLACK " +
	"DIAMONDRIGHTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARROW FROM BAR TO BLAC" +
	"K DIAMONDRIGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNORTH WEST AND SOUTH " +
	"EAST ARROWNORTH EAST AND SOUTH WEST ARROWNORTH WEST ARROW WITH HOOKNORTH" +
	" EAST ARROW WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH WEST ARROW WITH HOO" +
	"KNORTH WEST ARROW AND NORTH EAST ARROWNORTH EAST ARROW AND SOUTH EAST AR" +
	"ROWSOUTH EAST ARROW AND SOUTH WEST ARROWSOUTH WEST ARROW AND NORTH WEST " +
	"ARROWRISING DIAGONAL CROSSING FALLING DIAGONALFALLING DIAGONAL CROSSING " +
	"RISING DIAGONALSOUTH EAST ARROW CROSSING NORTH EAST ARROWNORTH EAST ARRO" +
	"W CROSSING SOUTH EAST ARROWFALLING DIAGONAL CROSSING NORTH EAST ARROWRIS" +
	"ING DIAGONAL CROSSING SOUTH EAST ARROWNORTH EAST ARROW CROSSING NORTH WE" +
	"ST ARROWNORTH WEST ARROW CROSSING NORTH EAST ARROWWAVE ARROW POINTING DI" +
	"RECTLY RIGHTARROW POINTING RIGHTWARDS THEN CURVING UPWARDSARROW POINTING" +
	" RIGHTWARDS THEN CURVING DOWNWARDSARROW POINTING DOWNWARDS THEN CURVING " +
	"LEFTWARDSARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDSRIGHT-SIDE ARC " +
	"CLOCKWISE ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP ARC ANTICLOCKWISE AR" +
	"ROWBOTTOM ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE ARROW WITH MINUSTOP A" +
	"RC ANTICLOCKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW" +
	"LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKWISE CLOSED CIRCLE A" +
	"RROWCLOCKWISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABOVE SHORT LEFTWARDS " +
	"ARROWLEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHORT RIGHTWARDS ARROW " +
	"ABOVE LEFTWARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOWLEFTWARDS ARROW WIT" +
	"H PLUS BELOWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARROW THROUGH SMALL CIR" +
	"CLEUPWARDS TWO-HEADED ARROW FROM SMALL CIRCLELEFT BARB UP RIGHT BARB DOW" +
	"N HARPOONLEFT BARB DOWN RIGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB LEF" +
	"T HARPOONUP BARB LEFT DOWN BARB RIGHT HARPOONLEFT BARB UP RIGHT BARB UP " +
	"HARPOONUP BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB DOWN RIGHT BARB DO" +
	"WN HARPOONUP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARDS HARPOON WITH BARB" +
	" UP TO BARRIGHTWARDS HARPOON WITH BARB UP TO BARUPWARDS HARPOON WITH BAR" +
	"B RIGHT TO BARDOWNWARDS HARPOON WITH BARB RIGHT TO BARLEFTWARDS HARPOON " +
	"WITH BARB DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOWN TO BARUPWARDS HAR" +
	"POON WITH BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB LEFT TO BARLEFTWAR" +
	"DS HARPOON WITH BARB UP FROM BARRIGHTWARDS HARPOON WITH BARB UP FROM BAR" +
	"UPWARDS HARPOON WITH BARB RIGHT FROM BARDOWNWARDS HARPOON WITH BARB RIGH" +
	"T FROM BARLEFTWARDS HARPOON WITH BARB DOWN FROM BARRIGHTWARDS HARPOON WI" +
	"TH BARB DOWN FROM BARUPWARDS HARPOON WITH BARB LEFT FROM BARDOWNWARDS HA" +
	"RPOON WITH BARB LEFT FROM BARLEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWA" +
	"RDS HARPOON WITH BARB DOWNUPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS " +
	"HARPOON WITH BARB RIGHTRIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS " +
	"HARPOON WITH BARB DOWNDOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS " +
	"HARPOON WITH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS H" +
	"ARPOON WITH BARB UPLEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HAR" +
	"POON WITH BARB DOWNRIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPO" +
	"ON WITH BARB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON") + ("" +
	" WITH BARB DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASHLEFTWARDS H" +
	"ARPOON WITH BARB DOWN BELOW LONG DASHRIGHTWARDS HARPOON WITH BARB UP ABO" +
	"VE LONG DASHRIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHUPWARDS HAR" +
	"POON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHTDOWNWARDS HA" +
	"RPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHTRIGHT DOUBLE " +
	"ARROW WITH ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS ARROWTILDE OPERATOR " +
	"ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARR" +
	"OW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST EQUAL TOLESS-THAN A" +
	"BOVE LEFTWARDS ARROWLEFTWARDS ARROW THROUGH LESS-THANGREATER-THAN ABOVE " +
	"RIGHTWARDS ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW THROUGH SUB" +
	"SETSUPERSET ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT FISH TAILUP FISH TA" +
	"ILDOWN FISH TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATION SPOTZ NOTATION T" +
	"YPE COLONLEFT WHITE CURLY BRACKETRIGHT WHITE CURLY BRACKETLEFT WHITE PAR" +
	"ENTHESISRIGHT WHITE PARENTHESISZ NOTATION LEFT IMAGE BRACKETZ NOTATION R" +
	"IGHT IMAGE BRACKETZ NOTATION LEFT BINDING BRACKETZ NOTATION RIGHT BINDIN" +
	"G BRACKETLEFT SQUARE BRACKET WITH UNDERBARRIGHT SQUARE BRACKET WITH UNDE" +
	"RBARLEFT SQUARE BRACKET WITH TICK IN TOP CORNERRIGHT SQUARE BRACKET WITH" +
	" TICK IN BOTTOM CORNERLEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNERRIGH" +
	"T SQUARE BRACKET WITH TICK IN TOP CORNERLEFT ANGLE BRACKET WITH DOTRIGHT" +
	" ANGLE BRACKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGHT ARC GREATER-THAN " +
	"BRACKETDOUBLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIGHT ARC LESS-THAN BR" +
	"ACKETLEFT BLACK TORTOISE SHELL BRACKETRIGHT BLACK TORTOISE SHELL BRACKET" +
	"DOTTED FENCEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENING LEFTRIGHT ANGLE V" +
	"ARIANT WITH SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE WITH S INSIDEACUTE " +
	"ANGLESPHERICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPENING UPTURNED ANGLER" +
	"EVERSED ANGLEANGLE WITH UNDERBARREVERSED ANGLE WITH UNDERBAROBLIQUE ANGL" +
	"E OPENING UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE WITH OPEN ARM ENDIN" +
	"G IN ARROW POINTING UP AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN A" +
	"RROW POINTING UP AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW PO" +
	"INTING DOWN AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTI" +
	"NG DOWN AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RI" +
	"GHT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND" +
	" UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWNM" +
	"EASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWNREVERS" +
	"ED EMPTY SETEMPTY SET WITH OVERBAREMPTY SET WITH SMALL CIRCLE ABOVEEMPTY" +
	" SET WITH RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW ABOVECIRCLE WITH HO" +
	"RIZONTAL BARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCLED REVERSE SOLIDUSC" +
	"IRCLED PERPENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDE" +
	"D BY VERTICAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED ANTICLOCKWISE-ROTATED" +
	" DIVISION SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BULLETCIRCLED BULLETC" +
	"IRCLED LESS-THANCIRCLED GREATER-THANCIRCLE WITH SMALL CIRCLE TO THE RIGH" +
	"TCIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHTSQUARED RISING DIAGONAL " +
	"SLASHSQUARED FALLING DIAGONAL SLASHSQUARED ASTERISKSQUARED SMALL CIRCLES" +
	"QUARED SQUARETWO JOINED SQUARESTRIANGLE WITH DOT ABOVETRIANGLE WITH UNDE" +
	"RBARS IN TRIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT TRIANGLE ABOVE LEFT" +
	" TRIANGLELEFT TRIANGLE BESIDE VERTICAL BARVERTICAL BAR BESIDE RIGHT TRIA" +
	"NGLEBOWTIE WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF BLACKBLACK BOWTIET" +
	"IMES WITH LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKWHITE HOURGLASSBLACK" +
	" HOURGLASSLEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOUBLE WIGGLY FENCERIG" +
	"HT DOUBLE WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INFINITYINFINITY NEGAT" +
	"ED WITH VERTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH CONTOURED OUTLINEIN" +
	"CREASES ASSHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARALLELEQUALS SIGN AND" +
	" SLANTED PARALLEL WITH TILDE ABOVEIDENTICAL TO AND SLANTED PARALLELGLEIC" +
	"H STARKTHERMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT HALF BLACKDOWN-POIN" +
	"TING TRIANGLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH DOWN ARROWBLACK LO" +
	"ZENGEWHITE CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DOWN ARROWERROR-BARRE" +
	"D WHITE SQUAREERROR-BARRED BLACK SQUAREERROR-BARRED WHITE DIAMONDERROR-B" +
	"ARRED BLACK DIAMONDERROR-BARRED WHITE CIRCLEERROR-BARRED BLACK CIRCLERUL" +
	"E-DELAYEDREVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBARREVERSE SOLIDUS WIT" +
	"H HORIZONTAL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUBLE PLUSTRIPLE PLUSL" +
	"EFT-POINTING CURVED ANGLE BRACKETRIGHT-POINTING CURVED ANGLE BRACKETTINY" +
	"MINYN-ARY CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPERATORN-ARY CIRCLED T" +
	"IMES OPERATORN-ARY UNION OPERATOR WITH DOTN-ARY UNION OPERATOR WITH PLUS" +
	"N-ARY SQUARE INTERSECTION OPERATORN-ARY SQUARE UNION OPERATORTWO LOGICAL") + ("" +
	" AND OPERATORTWO LOGICAL OR OPERATORN-ARY TIMES OPERATORMODULO TWO SUMSU" +
	"MMATION WITH INTEGRALQUADRUPLE INTEGRAL OPERATORFINITE PART INTEGRALINTE" +
	"GRAL WITH DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIRCULATION FUNCTIONAN" +
	"TICLOCKWISE INTEGRATIONLINE INTEGRATION WITH RECTANGULAR PATH AROUND POL" +
	"ELINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLELINE INTEGRATION NOT" +
	" INCLUDING THE POLEINTEGRAL AROUND A POINT OPERATORQUATERNION INTEGRAL O" +
	"PERATORINTEGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRAL WITH TIMES SIGNIN" +
	"TEGRAL WITH INTERSECTIONINTEGRAL WITH UNIONINTEGRAL WITH OVERBARINTEGRAL" +
	" WITH UNDERBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTATION SCHEMA COMPOSIT" +
	"IONZ NOTATION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTIONPLUS SIGN WITH SM" +
	"ALL CIRCLE ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOVEPLUS SIGN WITH TIL" +
	"DE ABOVEPLUS SIGN WITH DOT BELOWPLUS SIGN WITH TILDE BELOWPLUS SIGN WITH" +
	" SUBSCRIPT TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN WITH COMMA ABOVEMI" +
	"NUS SIGN WITH DOT BELOWMINUS SIGN WITH FALLING DOTSMINUS SIGN WITH RISIN" +
	"G DOTSPLUS SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT HALF CIRCLEVECTOR " +
	"OR CROSS PRODUCTMULTIPLICATION SIGN WITH DOT ABOVEMULTIPLICATION SIGN WI" +
	"TH UNDERBARSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH PRODUCTMULTIPLICAT" +
	"ION SIGN IN LEFT HALF CIRCLEMULTIPLICATION SIGN IN RIGHT HALF CIRCLECIRC" +
	"LED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPLICATION SIGN IN DOU" +
	"BLE CIRCLECIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEMINUS SIGN IN TRIANG" +
	"LEMULTIPLICATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGHTHAND INTERIOR PROD" +
	"UCTZ NOTATION RELATIONAL COMPOSITIONAMALGAMATION OR COPRODUCTINTERSECTIO" +
	"N WITH DOTUNION WITH MINUS SIGNUNION WITH OVERBARINTERSECTION WITH OVERB" +
	"ARINTERSECTION WITH LOGICAL ANDUNION WITH LOGICAL ORUNION ABOVE INTERSEC" +
	"TIONINTERSECTION ABOVE UNIONUNION ABOVE BAR ABOVE INTERSECTIONINTERSECTI" +
	"ON ABOVE BAR ABOVE UNIONUNION BESIDE AND JOINED WITH UNIONINTERSECTION B" +
	"ESIDE AND JOINED WITH INTERSECTIONCLOSED UNION WITH SERIFSCLOSED INTERSE" +
	"CTION WITH SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQUARE UNIONCLOSED UNI" +
	"ON WITH SERIFS AND SMASH PRODUCTLOGICAL AND WITH DOT ABOVELOGICAL OR WIT" +
	"H DOT ABOVEDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INTERSECTING LOGICAL A" +
	"NDTWO INTERSECTING LOGICAL ORSLOPING LARGE ORSLOPING LARGE ANDLOGICAL OR" +
	" OVERLAPPING LOGICAL ANDLOGICAL AND WITH MIDDLE STEMLOGICAL OR WITH MIDD" +
	"LE STEMLOGICAL AND WITH HORIZONTAL DASHLOGICAL OR WITH HORIZONTAL DASHLO" +
	"GICAL AND WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBARLOGICAL AND WITH D" +
	"OUBLE UNDERBARSMALL VEE WITH UNDERBARLOGICAL OR WITH DOUBLE OVERBARLOGIC" +
	"AL OR WITH DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTRICTIONZ NOTATION RA" +
	"NGE ANTIRESTRICTIONEQUALS SIGN WITH DOT BELOWIDENTICAL WITH DOT ABOVETRI" +
	"PLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE HORIZONTAL BAR WITH" +
	" TRIPLE VERTICAL STROKETILDE OPERATOR WITH DOT ABOVETILDE OPERATOR WITH " +
	"RISING DOTSSIMILAR MINUS SIMILARCONGRUENT WITH DOT ABOVEEQUALS WITH ASTE" +
	"RISKALMOST EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATELY EQUAL OR EQUAL T" +
	"OEQUALS SIGN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SIGNEQUALS SIGN ABOVE" +
	" TILDE OPERATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUALS SIGNSTHREE CONSE" +
	"CUTIVE EQUALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOWEQU" +
	"IVALENT WITH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INSIDEGREATER-THAN WIT" +
	"H CIRCLE INSIDELESS-THAN WITH QUESTION MARK ABOVEGREATER-THAN WITH QUEST" +
	"ION MARK ABOVELESS-THAN OR SLANTED EQUAL TOGREATER-THAN OR SLANTED EQUAL" +
	" TOLESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDEGREATER-THAN OR SLANTED " +
	"EQUAL TO WITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVEGREA" +
	"TER-THAN OR SLANTED EQUAL TO WITH DOT ABOVELESS-THAN OR SLANTED EQUAL TO" +
	" WITH DOT ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEF" +
	"TLESS-THAN OR APPROXIMATEGREATER-THAN OR APPROXIMATELESS-THAN AND SINGLE" +
	"-LINE NOT EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQUAL TOLESS-THAN AND" +
	" NOT APPROXIMATEGREATER-THAN AND NOT APPROXIMATELESS-THAN ABOVE DOUBLE-L" +
	"INE EQUAL ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE L" +
	"ESS-THANLESS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN ABOVE SIMILAR OR EQ" +
	"UALLESS-THAN ABOVE SIMILAR ABOVE GREATER-THANGREATER-THAN ABOVE SIMILAR " +
	"ABOVE LESS-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUALGREAT" +
	"ER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-THAN ABOVE SLANTED E" +
	"QUAL ABOVE GREATER-THAN ABOVE SLANTED EQUALGREATER-THAN ABOVE SLANTED EQ" +
	"UAL ABOVE LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL TO OR LESS-THANSLAN" +
	"TED EQUAL TO OR GREATER-THANSLANTED EQUAL TO OR LESS-THAN WITH DOT INSID" +
	"ESLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDEDOUBLE-LINE EQUAL TO OR" +
	" LESS-THANDOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-LINE SLANTED EQUAL ") + ("" +
	"TO OR LESS-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATER-THANSIMILAR OR LE" +
	"SS-THANSIMILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGNS" +
	"IMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NESTED LESS-THANDOUBLE" +
	" NESTED GREATER-THANDOUBLE NESTED LESS-THAN WITH UNDERBARGREATER-THAN OV" +
	"ERLAPPING LESS-THANGREATER-THAN BESIDE LESS-THANLESS-THAN CLOSED BY CURV" +
	"EGREATER-THAN CLOSED BY CURVELESS-THAN CLOSED BY CURVE ABOVE SLANTED EQU" +
	"ALGREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMALLER THANLARGER THA" +
	"NSMALLER THAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUALS SIGN WITH BUMPY A" +
	"BOVEPRECEDES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS ABOVE SINGLE-LINE EQU" +
	"ALS SIGNPRECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEEDS ABOVE SINGLE-LIN" +
	"E NOT EQUAL TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOVE EQUALS SIGNPRECED" +
	"ES ABOVE NOT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECEDES ABOVE ALMOST EQ" +
	"UAL TOSUCCEEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NOT ALMOST EQUAL TOSU" +
	"CCEEDS ABOVE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE SUCCEEDSSUBSET WIT" +
	"H DOTSUPERSET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPERSET WITH PLUS SIGN" +
	" BELOWSUBSET WITH MULTIPLICATION SIGN BELOWSUPERSET WITH MULTIPLICATION " +
	"SIGN BELOWSUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSET OF OR EQUAL TO WI" +
	"TH DOT ABOVESUBSET OF ABOVE EQUALS SIGNSUPERSET OF ABOVE EQUALS SIGNSUBS" +
	"ET OF ABOVE TILDE OPERATORSUPERSET OF ABOVE TILDE OPERATORSUBSET OF ABOV" +
	"E ALMOST EQUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUBSET OF ABOVE NOT EQ" +
	"UAL TOSUPERSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN BOX OPERATORSQUARE " +
	"RIGHT OPEN BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCLOSED SUBSET OR EQUA" +
	"L TOCLOSED SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETSUPERSET ABOVE SUBSE" +
	"TSUBSET ABOVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET BESIDE SUBSETSUPERSE" +
	"T BESIDE AND JOINED BY DASH WITH SUBSETELEMENT OF OPENING DOWNWARDSPITCH" +
	"FORK WITH TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFORKINGSHORT LEFT TAC" +
	"KSHORT DOWN TACKSHORT UP TACKPERPENDICULAR WITH SVERTICAL BAR TRIPLE RIG" +
	"HT TURNSTILEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICAL BAR DOUBLE LEFT T" +
	"URNSTILEDOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG DASH FROM LEFT MEM" +
	"BER OF DOUBLE VERTICALSHORT DOWN TACK WITH OVERBARSHORT UP TACK WITH UND" +
	"ERBARSHORT UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN TACKDOUBLE UP TACKDO" +
	"UBLE STROKE NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDOES NOT DIVIDE WITH " +
	"REVERSED NEGATION SLASHVERTICAL LINE WITH CIRCLE ABOVEVERTICAL LINE WITH" +
	" CIRCLE BELOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH HORIZONTAL STROKEP" +
	"ARALLEL WITH TILDE OPERATORTRIPLE VERTICAL BAR BINARY RELATIONTRIPLE VER" +
	"TICAL BAR WITH HORIZONTAL STROKETRIPLE COLON OPERATORTRIPLE NESTED LESS-" +
	"THANTRIPLE NESTED GREATER-THANDOUBLE-LINE SLANTED LESS-THAN OR EQUAL TOD" +
	"OUBLE-LINE SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOLIDUS BINARY RELATIO" +
	"NLARGE TRIPLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPERATORWHITE VERTICAL" +
	" BARN-ARY WHITE VERTICAL BARNORTH EAST WHITE ARROWNORTH WEST WHITE ARROW" +
	"SOUTH EAST WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGHT WHITE ARROWLEFTWA" +
	"RDS BLACK ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARROWNORTH EAST BLACK " +
	"ARROWNORTH WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUTH WEST BLACK ARROWL" +
	"EFT RIGHT BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS ARROW WITH TIP DOWNWA" +
	"RDSRIGHTWARDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW WITH TIP DOWNWARDSLE" +
	"FTWARDS ARROW WITH TIP UPWARDSSQUARE WITH TOP HALF BLACKSQUARE WITH BOTT" +
	"OM HALF BLACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BLACKSQUARE WITH LOWE" +
	"R LEFT DIAGONAL HALF BLACKDIAMOND WITH LEFT HALF BLACKDIAMOND WITH RIGHT" +
	" HALF BLACKDIAMOND WITH TOP HALF BLACKDIAMOND WITH BOTTOM HALF BLACKDOTT" +
	"ED SQUAREBLACK LARGE SQUAREWHITE LARGE SQUAREBLACK VERY SMALL SQUAREWHIT" +
	"E VERY SMALL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE HEXAGONBLACK HEXAGO" +
	"NHORIZONTAL BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDIUM DIAMONDWHITE MED" +
	"IUM DIAMONDBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBLACK SMALL DIAMONDBL" +
	"ACK SMALL LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL ELLIPSEWHITE HORIZO" +
	"NTAL ELLIPSEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLIPSELEFT ARROW WITH " +
	"SMALL CIRCLETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIRCLED PLUSLONG LEFTW" +
	"ARDS SQUIGGLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKELEFTWA" +
	"RDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED ARR" +
	"OW FROM BARLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFTWARDS ARROW WITH DO" +
	"TTED STEMLEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKELEFTWARDS ARROW W" +
	"ITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED ARROW WITH TAIL" +
	"LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKELEFTWARDS TWO-H" +
	"EADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW THROUGH" +
	" XWAVE ARROW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE LEFTWARDS ARROWREVE") + ("" +
	"RSE TILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABOVE REVERSE AL" +
	"MOST EQUAL TORIGHTWARDS ARROW THROUGH GREATER-THANRIGHTWARDS ARROW THROU" +
	"GH SUPERSETLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRUPLE ARROWREVERSE TI" +
	"LDE OPERATOR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW ABOVE REVERSE ALMOST" +
	" EQUAL TOTILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABOVE ALMOS" +
	"T EQUAL TOLEFTWARDS ARROW ABOVE REVERSE TILDE OPERATORRIGHTWARDS ARROW A" +
	"BOVE REVERSE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED ZIGZAG ARROWSHORT S" +
	"LANTED NORTH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE MEDIUM STARBLACK SM" +
	"ALL STARWHITE SMALL STARBLACK RIGHT-POINTING PENTAGONWHITE RIGHT-POINTIN" +
	"G PENTAGONHEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSIDEHEAVY CIRCLE WITH" +
	" CIRCLE INSIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTED NORTH ARROW WITH " +
	"HOOKED HEADBACKSLANTED SOUTH ARROW WITH HOOKED TAILSLANTED NORTH ARROW W" +
	"ITH HORIZONTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZONTAL TAILBENT ARRO" +
	"W POINTING DOWNWARDS THEN NORTH EASTSHORT BENT ARROW POINTING DOWNWARDS " +
	"THEN NORTH EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIANGLE-HEADED AR" +
	"ROWRIGHTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-HEADED ARROWLEFT R" +
	"IGHT TRIANGLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARROWNORTH WEST TRIANG" +
	"LE-HEADED ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH EAST TRIANGLE-HEADE" +
	"D ARROWSOUTH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIANGLE-HEADED DASHED " +
	"ARROWUPWARDS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS TRIANGLE-HEADED DASH" +
	"ED ARROWDOWNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWISE TRIANGLE-HEADED " +
	"OPEN CIRCLE ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROWLEFTWARD" +
	"S TRIANGLE-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED ARROW TO BARRIGHTW" +
	"ARDS TRIANGLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-HEADED ARROW TO BARN" +
	"ORTH WEST TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIANGLE-HEADED ARROW T" +
	"O BARSOUTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH WEST TRIANGLE-HEADED A" +
	"RROW TO BARLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" +
	"UPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKERIGHTWARDS TR" +
	"IANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEDOWNWARDS TRIANGLE-HEAD" +
	"ED ARROW WITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB KEYVERTICAL TAB KEY" +
	"LEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROWUPW" +
	"ARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROWR" +
	"IGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROWDOWN" +
	"WARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROWLE" +
	"FTWARDS TRIANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE-HEADED PAIRED ARRO" +
	"WSRIGHTWARDS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS TRIANGLE-HEADED PAIR" +
	"ED ARROWSLEFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS BLACK CIRCLED WHITE " +
	"ARROWRIGHTWARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BLACK CIRCLED WHITE A" +
	"RROWANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROWANTICLOCKWISE TRIA" +
	"NGLE-HEADED BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED LEFT U-SH" +
	"APED ARROWANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROWRETURN LEFTRET" +
	"URN RIGHTNEWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS CIRCLING ANTICLOCKW" +
	"ISERIGHTWARDS BLACK ARROWTHREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROW" +
	"HEADTHREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEADTHREE-D TOP-LIGHT" +
	"ED RIGHTWARDS EQUILATERAL ARROWHEADTHREE-D LEFT-LIGHTED DOWNWARDS EQUILA" +
	"TERAL ARROWHEADBLACK LEFTWARDS EQUILATERAL ARROWHEADBLACK UPWARDS EQUILA" +
	"TERAL ARROWHEADBLACK RIGHTWARDS EQUILATERAL ARROWHEADBLACK DOWNWARDS EQU" +
	"ILATERAL ARROWHEADDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARD" +
	"SDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSUPWARDS TRIANGL" +
	"E-HEADED ARROW WITH LONG TIP LEFTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH" +
	" LONG TIP RIGHTWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARD" +
	"SRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSLEFTWARDS TRIANGL" +
	"E-HEADED ARROW WITH LONG TIP DOWNWARDSRIGHTWARDS TRIANGLE-HEADED ARROW W" +
	"ITH LONG TIP DOWNWARDSBLACK CURVED DOWNWARDS AND LEFTWARDS ARROWBLACK CU" +
	"RVED DOWNWARDS AND RIGHTWARDS ARROWBLACK CURVED UPWARDS AND LEFTWARDS AR" +
	"ROWBLACK CURVED UPWARDS AND RIGHTWARDS ARROWBLACK CURVED LEFTWARDS AND U" +
	"PWARDS ARROWBLACK CURVED RIGHTWARDS AND UPWARDS ARROWBLACK CURVED LEFTWA" +
	"RDS AND DOWNWARDS ARROWBLACK CURVED RIGHTWARDS AND DOWNWARDS ARROWRIBBON" +
	" ARROW DOWN LEFTRIBBON ARROW DOWN RIGHTRIBBON ARROW UP LEFTRIBBON ARROW " +
	"UP RIGHTRIBBON ARROW LEFT UPRIBBON ARROW RIGHT UPRIBBON ARROW LEFT DOWNR" +
	"IBBON ARROW RIGHT DOWNUPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BARUP" +
	" ARROWHEAD IN A RECTANGLE BOXBALLOT BOX WITH LIGHT XCIRCLED XCIRCLED BOL" +
	"D XBLACK SQUARE CENTREDBLACK DIAMOND CENTREDTURNED BLACK PENTAGONHORIZON" +
	"TAL BLACK OCTAGONBLACK OCTAGONBLACK MEDIUM UP-POINTING TRIANGLE CENTREDB") + ("" +
	"LACK MEDIUM DOWN-POINTING TRIANGLE CENTREDBLACK MEDIUM LEFT-POINTING TRI" +
	"ANGLE CENTREDBLACK MEDIUM RIGHT-POINTING TRIANGLE CENTREDTOP HALF BLACK " +
	"CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR POINTED BLACK CUSPROTATED LIGHT" +
	" FOUR POINTED BLACK CUSPWHITE FOUR POINTED CUSPROTATED WHITE FOUR POINTE" +
	"D CUSPSQUARE POSITION INDICATORUNCERTAINTY SIGNGROUP MARKLEFTWARDS TWO-H" +
	"EADED ARROW WITH TRIANGLE ARROWHEADSUPWARDS TWO-HEADED ARROW WITH TRIANG" +
	"LE ARROWHEADSRIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSDOWNWAR" +
	"DS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSGLAGOLITIC CAPITAL LETTER AZ" +
	"UGLAGOLITIC CAPITAL LETTER BUKYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC " +
	"CAPITAL LETTER GLAGOLIGLAGOLITIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL " +
	"LETTER YESTUGLAGOLITIC CAPITAL LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER D" +
	"ZELOGLAGOLITIC CAPITAL LETTER ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGOL" +
	"ITIC CAPITAL LETTER INITIAL IZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC CA" +
	"PITAL LETTER DJERVIGLAGOLITIC CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LETT" +
	"ER LJUDIJEGLAGOLITIC CAPITAL LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NAS" +
	"HIGLAGOLITIC CAPITAL LETTER ONUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLITI" +
	"C CAPITAL LETTER RITSIGLAGOLITIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL " +
	"LETTER TVRIDOGLAGOLITIC CAPITAL LETTER UKUGLAGOLITIC CAPITAL LETTER FRIT" +
	"UGLAGOLITIC CAPITAL LETTER HERUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC C" +
	"APITAL LETTER PEGLAGOLITIC CAPITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER " +
	"TSIGLAGOLITIC CAPITAL LETTER CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLIT" +
	"IC CAPITAL LETTER YERUGLAGOLITIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL L" +
	"ETTER YATIGLAGOLITIC CAPITAL LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER " +
	"YUGLAGOLITIC CAPITAL LETTER SMALL YUSGLAGOLITIC CAPITAL LETTER SMALL YUS" +
	" WITH TAILGLAGOLITIC CAPITAL LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED " +
	"SMALL YUSGLAGOLITIC CAPITAL LETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOTA" +
	"TED BIG YUSGLAGOLITIC CAPITAL LETTER FITAGLAGOLITIC CAPITAL LETTER IZHIT" +
	"SAGLAGOLITIC CAPITAL LETTER SHTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI " +
	"AGLAGOLITIC CAPITAL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LETTER AZUGL" +
	"AGOLITIC SMALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAGOLITIC SMALL L" +
	"ETTER GLAGOLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL LETTER YESTUG" +
	"LAGOLITIC SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZELOGLAGOLITIC SM" +
	"ALL LETTER ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SMALL LETTER INI" +
	"TIAL IZHEGLAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER DJERVIGLAGOLIT" +
	"IC SMALL LETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLITIC SMALL LETT" +
	"ER MYSLITEGLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LETTER ONUGLAGOL" +
	"ITIC SMALL LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGOLITIC SMALL LE" +
	"TTER SLOVOGLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL LETTER UKUGLAGO" +
	"LITIC SMALL LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOLITIC SMALL LET" +
	"TER OTUGLAGOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER SHTAGLAGOLITIC " +
	"SMALL LETTER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC SMALL LETTER SH" +
	"AGLAGOLITIC SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIGLAGOLITIC SMAL" +
	"L LETTER YATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC SMALL LETTER Y" +
	"UGLAGOLITIC SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER SMALL YUS WITH" +
	" TAILGLAGOLITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOTATED SMALL YUS" +
	"GLAGOLITIC SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOTATED BIG YUSGL" +
	"AGOLITIC SMALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAGLAGOLITIC SMAL" +
	"L LETTER SHTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOLITIC SMALL LET" +
	"TER LATINATE MYSLITELATIN CAPITAL LETTER L WITH DOUBLE BARLATIN SMALL LE" +
	"TTER L WITH DOUBLE BARLATIN CAPITAL LETTER L WITH MIDDLE TILDELATIN CAPI" +
	"TAL LETTER P WITH STROKELATIN CAPITAL LETTER R WITH TAILLATIN SMALL LETT" +
	"ER A WITH STROKELATIN SMALL LETTER T WITH DIAGONAL STROKELATIN CAPITAL L" +
	"ETTER H WITH DESCENDERLATIN SMALL LETTER H WITH DESCENDERLATIN CAPITAL L" +
	"ETTER K WITH DESCENDERLATIN SMALL LETTER K WITH DESCENDERLATIN CAPITAL L" +
	"ETTER Z WITH DESCENDERLATIN SMALL LETTER Z WITH DESCENDERLATIN CAPITAL L" +
	"ETTER ALPHALATIN CAPITAL LETTER M WITH HOOKLATIN CAPITAL LETTER TURNED A" +
	"LATIN CAPITAL LETTER TURNED ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLAT" +
	"IN CAPITAL LETTER W WITH HOOKLATIN SMALL LETTER W WITH HOOKLATIN SMALL L" +
	"ETTER V WITH CURLLATIN CAPITAL LETTER HALF HLATIN SMALL LETTER HALF HLAT" +
	"IN SMALL LETTER TAILLESS PHILATIN SMALL LETTER E WITH NOTCHLATIN SMALL L" +
	"ETTER TURNED R WITH TAILLATIN SMALL LETTER O WITH LOW RING INSIDELATIN L" +
	"ETTER SMALL CAPITAL TURNED ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETTE" +
	"R CAPITAL VLATIN CAPITAL LETTER S WITH SWASH TAILLATIN CAPITAL LETTER Z " +
	"WITH SWASH TAILCOPTIC CAPITAL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC ") + ("" +
	"CAPITAL LETTER VIDACOPTIC SMALL LETTER VIDACOPTIC CAPITAL LETTER GAMMACO" +
	"PTIC SMALL LETTER GAMMACOPTIC CAPITAL LETTER DALDACOPTIC SMALL LETTER DA" +
	"LDACOPTIC CAPITAL LETTER EIECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTER" +
	" SOUCOPTIC SMALL LETTER SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTER" +
	" ZATACOPTIC CAPITAL LETTER HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL LE" +
	"TTER THETHECOPTIC SMALL LETTER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC S" +
	"MALL LETTER IAUDACOPTIC CAPITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPTI" +
	"C CAPITAL LETTER LAULACOPTIC SMALL LETTER LAULACOPTIC CAPITAL LETTER MIC" +
	"OPTIC SMALL LETTER MICOPTIC CAPITAL LETTER NICOPTIC SMALL LETTER NICOPTI" +
	"C CAPITAL LETTER KSICOPTIC SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTIC" +
	" SMALL LETTER OCOPTIC CAPITAL LETTER PICOPTIC SMALL LETTER PICOPTIC CAPI" +
	"TAL LETTER ROCOPTIC SMALL LETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMAL" +
	"L LETTER SIMACOPTIC CAPITAL LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAPI" +
	"TAL LETTER UACOPTIC SMALL LETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL " +
	"LETTER FICOPTIC CAPITAL LETTER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL " +
	"LETTER PSICOPTIC SMALL LETTER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL L" +
	"ETTER OOUCOPTIC CAPITAL LETTER DIALECT-P ALEFCOPTIC SMALL LETTER DIALECT" +
	"-P ALEFCOPTIC CAPITAL LETTER OLD COPTIC AINCOPTIC SMALL LETTER OLD COPTI" +
	"C AINCOPTIC CAPITAL LETTER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOGR" +
	"AMMIC EIECOPTIC CAPITAL LETTER DIALECT-P KAPACOPTIC SMALL LETTER DIALECT" +
	"-P KAPACOPTIC CAPITAL LETTER DIALECT-P NICOPTIC SMALL LETTER DIALECT-P N" +
	"ICOPTIC CAPITAL LETTER CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMIC" +
	" NICOPTIC CAPITAL LETTER OLD COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC OO" +
	"UCOPTIC CAPITAL LETTER SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LETT" +
	"ER CROSSED SHEICOPTIC SMALL LETTER CROSSED SHEICOPTIC CAPITAL LETTER OLD" +
	" COPTIC SHEICOPTIC SMALL LETTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OLD" +
	" COPTIC ESHCOPTIC SMALL LETTER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHMI" +
	"MIC KHEICOPTIC SMALL LETTER AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-P" +
	" HORICOPTIC SMALL LETTER DIALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC " +
	"HORICOPTIC SMALL LETTER OLD COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC " +
	"HACOPTIC SMALL LETTER OLD COPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOPT" +
	"IC SMALL LETTER L-SHAPED HACOPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC SM" +
	"ALL LETTER OLD COPTIC HEICOPTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMAL" +
	"L LETTER OLD COPTIC HATCOPTIC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SMA" +
	"LL LETTER OLD COPTIC GANGIACOPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC SM" +
	"ALL LETTER OLD COPTIC DJACOPTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC SM" +
	"ALL LETTER OLD COPTIC SHIMACOPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC " +
	"SMALL LETTER OLD NUBIAN SHIMACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC " +
	"SMALL LETTER OLD NUBIAN NGICOPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC SM" +
	"ALL LETTER OLD NUBIAN NYICOPTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMAL" +
	"L LETTER OLD NUBIAN WAUCOPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBOL" +
	" PI ROCOPTIC SYMBOL STAUROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPTI" +
	"C SYMBOL SHIMA SIMACOPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL " +
	"LETTER CRYPTOGRAMMIC SHEICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPTI" +
	"C SMALL LETTER CRYPTOGRAMMIC GANGIACOPTIC COMBINING NI ABOVECOPTIC COMBI" +
	"NING SPIRITUS ASPERCOPTIC COMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER " +
	"BOHAIRIC KHEICOPTIC SMALL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL STO" +
	"PCOPTIC OLD NUBIAN DIRECT QUESTION MARKCOPTIC OLD NUBIAN INDIRECT QUESTI" +
	"ON MARKCOPTIC OLD NUBIAN VERSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FUL" +
	"L STOPCOPTIC MORPHOLOGICAL DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMALL" +
	" LETTER BANGEORGIAN SMALL LETTER GANGEORGIAN SMALL LETTER DONGEORGIAN SM" +
	"ALL LETTER ENGEORGIAN SMALL LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN " +
	"SMALL LETTER TANGEORGIAN SMALL LETTER INGEORGIAN SMALL LETTER KANGEORGIA" +
	"N SMALL LETTER LASGEORGIAN SMALL LETTER MANGEORGIAN SMALL LETTER NARGEOR" +
	"GIAN SMALL LETTER ONGEORGIAN SMALL LETTER PARGEORGIAN SMALL LETTER ZHARG" +
	"EORGIAN SMALL LETTER RAEGEORGIAN SMALL LETTER SANGEORGIAN SMALL LETTER T" +
	"ARGEORGIAN SMALL LETTER UNGEORGIAN SMALL LETTER PHARGEORGIAN SMALL LETTE" +
	"R KHARGEORGIAN SMALL LETTER GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL " +
	"LETTER SHINGEORGIAN SMALL LETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN S" +
	"MALL LETTER JILGEORGIAN SMALL LETTER CILGEORGIAN SMALL LETTER CHARGEORGI" +
	"AN SMALL LETTER XANGEORGIAN SMALL LETTER JHANGEORGIAN SMALL LETTER HAEGE" +
	"ORGIAN SMALL LETTER HEGEORGIAN SMALL LETTER HIEGEORGIAN SMALL LETTER WEG" +
	"EORGIAN SMALL LETTER HARGEORGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER Y" +
	"NGEORGIAN SMALL LETTER AENTIFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH ") + ("" +
	"LETTER YABHTIFINAGH LETTER YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERBE" +
	"R ACADEMY YAJTIFINAGH LETTER YAJTIFINAGH LETTER YADTIFINAGH LETTER YADHT" +
	"IFINAGH LETTER YADDTIFINAGH LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LETT" +
	"ER YAFTIFINAGH LETTER YAKTIFINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKHH" +
	"TIFINAGH LETTER YAHTIFINAGH LETTER BERBER ACADEMY YAHTIFINAGH LETTER TUA" +
	"REG YAHTIFINAGH LETTER YAHHTIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFINA" +
	"GH LETTER TUAREG YAKHTIFINAGH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFINA" +
	"GH LETTER YITIFINAGH LETTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LET" +
	"TER TUAREG YAZHTIFINAGH LETTER YALTIFINAGH LETTER YAMTIFINAGH LETTER YAN" +
	"TIFINAGH LETTER TUAREG YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH LETTER YA" +
	"PTIFINAGH LETTER YUTIFINAGH LETTER YARTIFINAGH LETTER YARRTIFINAGH LETTE" +
	"R YAGHTIFINAGH LETTER TUAREG YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETTE" +
	"R YASTIFINAGH LETTER YASSTIFINAGH LETTER YASHTIFINAGH LETTER YATTIFINAGH" +
	" LETTER YATHTIFINAGH LETTER YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAVT" +
	"IFINAGH LETTER YAWTIFINAGH LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER " +
	"TAWELLEMET YAZTIFINAGH LETTER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOTI" +
	"FINAGH MODIFIER LETTER LABIALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAGH" +
	" CONSONANT JOINERETHIOPIC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYLL" +
	"ABLE ROAETHIOPIC SYLLABLE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BOA" +
	"ETHIOPIC SYLLABLE TOAETHIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC " +
	"SYLLABLE NYOAETHIOPIC SYLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC S" +
	"YLLABLE DOAETHIOPIC SYLLABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE " +
	"THOAETHIOPIC SYLLABLE CHOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAETH" +
	"IOPIC SYLLABLE GGWAETHIOPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPIC" +
	" SYLLABLE GGWEETHIOPIC SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLABL" +
	"E SSIETHIOPIC SYLLABLE SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEET" +
	"HIOPIC SYLLABLE SSOETHIOPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC SY" +
	"LLABLE CCIETHIOPIC SYLLABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE " +
	"CCEETHIOPIC SYLLABLE CCOETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIOP" +
	"IC SYLLABLE ZZIETHIOPIC SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYLL" +
	"ABLE ZZEETHIOPIC SYLLABLE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CCH" +
	"UETHIOPIC SYLLABLE CCHIETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEETH" +
	"IOPIC SYLLABLE CCHEETHIOPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC S" +
	"YLLABLE QYUETHIOPIC SYLLABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE " +
	"QYEEETHIOPIC SYLLABLE QYEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHIO" +
	"PIC SYLLABLE KYUETHIOPIC SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYLL" +
	"ABLE KYEEETHIOPIC SYLLABLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XYA" +
	"ETHIOPIC SYLLABLE XYUETHIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPIC" +
	" SYLLABLE XYEEETHIOPIC SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLABL" +
	"E GYAETHIOPIC SYLLABLE GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAETH" +
	"IOPIC SYLLABLE GYEEETHIOPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING C" +
	"YRILLIC LETTER BECOMBINING CYRILLIC LETTER VECOMBINING CYRILLIC LETTER G" +
	"HECOMBINING CYRILLIC LETTER DECOMBINING CYRILLIC LETTER ZHECOMBINING CYR" +
	"ILLIC LETTER ZECOMBINING CYRILLIC LETTER KACOMBINING CYRILLIC LETTER ELC" +
	"OMBINING CYRILLIC LETTER EMCOMBINING CYRILLIC LETTER ENCOMBINING CYRILLI" +
	"C LETTER OCOMBINING CYRILLIC LETTER PECOMBINING CYRILLIC LETTER ERCOMBIN" +
	"ING CYRILLIC LETTER ESCOMBINING CYRILLIC LETTER TECOMBINING CYRILLIC LET" +
	"TER HACOMBINING CYRILLIC LETTER TSECOMBINING CYRILLIC LETTER CHECOMBININ" +
	"G CYRILLIC LETTER SHACOMBINING CYRILLIC LETTER SHCHACOMBINING CYRILLIC L" +
	"ETTER FITACOMBINING CYRILLIC LETTER ES-TECOMBINING CYRILLIC LETTER ACOMB" +
	"INING CYRILLIC LETTER IECOMBINING CYRILLIC LETTER DJERVCOMBINING CYRILLI" +
	"C LETTER MONOGRAPH UKCOMBINING CYRILLIC LETTER YATCOMBINING CYRILLIC LET" +
	"TER YUCOMBINING CYRILLIC LETTER IOTIFIED ACOMBINING CYRILLIC LETTER LITT" +
	"LE YUSCOMBINING CYRILLIC LETTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFIE" +
	"D BIG YUSRIGHT ANGLE SUBSTITUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION " +
	"MARKERLEFT SUBSTITUTION BRACKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SUB" +
	"STITUTION BRACKETRIGHT DOTTED SUBSTITUTION BRACKETRAISED INTERPOLATION M" +
	"ARKERRAISED DOTTED INTERPOLATION MARKERDOTTED TRANSPOSITION MARKERLEFT T" +
	"RANSPOSITION BRACKETRIGHT TRANSPOSITION BRACKETRAISED SQUARELEFT RAISED " +
	"OMISSION BRACKETRIGHT RAISED OMISSION BRACKETEDITORIAL CORONISPARAGRAPHO" +
	"SFORKED PARAGRAPHOSREVERSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOSD" +
	"OWNWARDS ANCORAUPWARDS ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE H" +
	"YPHENINVERTED INTERROBANGPALM BRANCHHYPHEN WITH DIAERESISTILDE WITH RING" +
	" ABOVELEFT LOW PARAPHRASE BRACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH ") + ("" +
	"DOT ABOVETILDE WITH DOT BELOWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL " +
	"BAR WITH QUILLTOP LEFT HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HAL" +
	"F BRACKETBOTTOM RIGHT HALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS " +
	"U BRACKETLEFT DOUBLE PARENTHESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER ON" +
	"E DOT PUNCTUATIONONE DOT OVER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNCT" +
	"UATIONFIVE DOT MARKREVERSED QUESTION MARKVERTICAL TILDERING POINTWORD SE" +
	"PARATOR MIDDLE DOTTURNED COMMARAISED DOTRAISED COMMATURNED SEMICOLONDAGG" +
	"ER WITH LEFT GUARDDAGGER WITH RIGHT GUARDTURNED DAGGERTOP HALF SECTION S" +
	"IGNTWO-EM DASHTHREE-EM DASHSTENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGLY" +
	" VERTICAL LINECAPITULUMDOUBLE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9 " +
	"QUOTATION MARKDASH WITH LEFT UPTURNDOUBLE SUSPENSION MARKINVERTED LOW KA" +
	"VYKAINVERTED LOW KAVYKA WITH KAVYKA ABOVELOW KAVYKALOW KAVYKA WITH DOTDO" +
	"UBLE STACKED COMMACJK RADICAL REPEATCJK RADICAL CLIFFCJK RADICAL SECOND " +
	"ONECJK RADICAL SECOND TWOCJK RADICAL SECOND THREECJK RADICAL PERSONCJK R" +
	"ADICAL BOXCJK RADICAL TABLECJK RADICAL KNIFE ONECJK RADICAL KNIFE TWOCJK" +
	" RADICAL DIVINATIONCJK RADICAL SEALCJK RADICAL SMALL ONECJK RADICAL SMAL" +
	"L TWOCJK RADICAL LAME ONECJK RADICAL LAME TWOCJK RADICAL LAME THREECJK R" +
	"ADICAL LAME FOURCJK RADICAL SNAKECJK RADICAL THREADCJK RADICAL SNOUT ONE" +
	"CJK RADICAL SNOUT TWOCJK RADICAL HEART ONECJK RADICAL HEART TWOCJK RADIC" +
	"AL HANDCJK RADICAL RAPCJK RADICAL CHOKECJK RADICAL SUNCJK RADICAL MOONCJ" +
	"K RADICAL DEATHCJK RADICAL MOTHERCJK RADICAL CIVILIANCJK RADICAL WATER O" +
	"NECJK RADICAL WATER TWOCJK RADICAL FIRECJK RADICAL PAW ONECJK RADICAL PA" +
	"W TWOCJK RADICAL SIMPLIFIED HALF TREE TRUNKCJK RADICAL COWCJK RADICAL DO" +
	"GCJK RADICAL JADECJK RADICAL BOLT OF CLOTHCJK RADICAL EYECJK RADICAL SPI" +
	"RIT ONECJK RADICAL SPIRIT TWOCJK RADICAL BAMBOOCJK RADICAL SILKCJK RADIC" +
	"AL C-SIMPLIFIED SILKCJK RADICAL NET ONECJK RADICAL NET TWOCJK RADICAL NE" +
	"T THREECJK RADICAL NET FOURCJK RADICAL MESHCJK RADICAL SHEEPCJK RADICAL " +
	"RAMCJK RADICAL EWECJK RADICAL OLDCJK RADICAL BRUSH ONECJK RADICAL BRUSH " +
	"TWOCJK RADICAL MEATCJK RADICAL MORTARCJK RADICAL GRASS ONECJK RADICAL GR" +
	"ASS TWOCJK RADICAL GRASS THREECJK RADICAL TIGERCJK RADICAL CLOTHESCJK RA" +
	"DICAL WEST ONECJK RADICAL WEST TWOCJK RADICAL C-SIMPLIFIED SEECJK RADICA" +
	"L SIMPLIFIED HORNCJK RADICAL HORNCJK RADICAL C-SIMPLIFIED SPEECHCJK RADI" +
	"CAL C-SIMPLIFIED SHELLCJK RADICAL FOOTCJK RADICAL C-SIMPLIFIED CARTCJK R" +
	"ADICAL SIMPLIFIED WALKCJK RADICAL WALK ONECJK RADICAL WALK TWOCJK RADICA" +
	"L CITYCJK RADICAL C-SIMPLIFIED GOLDCJK RADICAL LONG ONECJK RADICAL LONG " +
	"TWOCJK RADICAL C-SIMPLIFIED LONGCJK RADICAL C-SIMPLIFIED GATECJK RADICAL" +
	" MOUND ONECJK RADICAL MOUND TWOCJK RADICAL RAINCJK RADICAL BLUECJK RADIC" +
	"AL C-SIMPLIFIED TANNED LEATHERCJK RADICAL C-SIMPLIFIED LEAFCJK RADICAL C" +
	"-SIMPLIFIED WINDCJK RADICAL C-SIMPLIFIED FLYCJK RADICAL EAT ONECJK RADIC" +
	"AL EAT TWOCJK RADICAL EAT THREECJK RADICAL C-SIMPLIFIED EATCJK RADICAL H" +
	"EADCJK RADICAL C-SIMPLIFIED HORSECJK RADICAL BONECJK RADICAL GHOSTCJK RA" +
	"DICAL C-SIMPLIFIED FISHCJK RADICAL C-SIMPLIFIED BIRDCJK RADICAL C-SIMPLI" +
	"FIED SALTCJK RADICAL SIMPLIFIED WHEATCJK RADICAL SIMPLIFIED YELLOWCJK RA" +
	"DICAL C-SIMPLIFIED FROGCJK RADICAL J-SIMPLIFIED EVENCJK RADICAL C-SIMPLI" +
	"FIED EVENCJK RADICAL J-SIMPLIFIED TOOTHCJK RADICAL C-SIMPLIFIED TOOTHCJK" +
	" RADICAL J-SIMPLIFIED DRAGONCJK RADICAL C-SIMPLIFIED DRAGONCJK RADICAL T" +
	"URTLECJK RADICAL J-SIMPLIFIED TURTLECJK RADICAL C-SIMPLIFIED TURTLEKANGX" +
	"I RADICAL ONEKANGXI RADICAL LINEKANGXI RADICAL DOTKANGXI RADICAL SLASHKA" +
	"NGXI RADICAL SECONDKANGXI RADICAL HOOKKANGXI RADICAL TWOKANGXI RADICAL L" +
	"IDKANGXI RADICAL MANKANGXI RADICAL LEGSKANGXI RADICAL ENTERKANGXI RADICA" +
	"L EIGHTKANGXI RADICAL DOWN BOXKANGXI RADICAL COVERKANGXI RADICAL ICEKANG" +
	"XI RADICAL TABLEKANGXI RADICAL OPEN BOXKANGXI RADICAL KNIFEKANGXI RADICA" +
	"L POWERKANGXI RADICAL WRAPKANGXI RADICAL SPOONKANGXI RADICAL RIGHT OPEN " +
	"BOXKANGXI RADICAL HIDING ENCLOSUREKANGXI RADICAL TENKANGXI RADICAL DIVIN" +
	"ATIONKANGXI RADICAL SEALKANGXI RADICAL CLIFFKANGXI RADICAL PRIVATEKANGXI" +
	" RADICAL AGAINKANGXI RADICAL MOUTHKANGXI RADICAL ENCLOSUREKANGXI RADICAL" +
	" EARTHKANGXI RADICAL SCHOLARKANGXI RADICAL GOKANGXI RADICAL GO SLOWLYKAN" +
	"GXI RADICAL EVENINGKANGXI RADICAL BIGKANGXI RADICAL WOMANKANGXI RADICAL " +
	"CHILDKANGXI RADICAL ROOFKANGXI RADICAL INCHKANGXI RADICAL SMALLKANGXI RA" +
	"DICAL LAMEKANGXI RADICAL CORPSEKANGXI RADICAL SPROUTKANGXI RADICAL MOUNT" +
	"AINKANGXI RADICAL RIVERKANGXI RADICAL WORKKANGXI RADICAL ONESELFKANGXI R" +
	"ADICAL TURBANKANGXI RADICAL DRYKANGXI RADICAL SHORT THREADKANGXI RADICAL" +
	" DOTTED CLIFFKANGXI RADICAL LONG STRIDEKANGXI RADICAL TWO HANDSKANGXI RA" +
	"DICAL SHOOTKANGXI RADICAL BOWKANGXI RADICAL SNOUTKANGXI RADICAL BRISTLEK") + ("" +
	"ANGXI RADICAL STEPKANGXI RADICAL HEARTKANGXI RADICAL HALBERDKANGXI RADIC" +
	"AL DOORKANGXI RADICAL HANDKANGXI RADICAL BRANCHKANGXI RADICAL RAPKANGXI " +
	"RADICAL SCRIPTKANGXI RADICAL DIPPERKANGXI RADICAL AXEKANGXI RADICAL SQUA" +
	"REKANGXI RADICAL NOTKANGXI RADICAL SUNKANGXI RADICAL SAYKANGXI RADICAL M" +
	"OONKANGXI RADICAL TREEKANGXI RADICAL LACKKANGXI RADICAL STOPKANGXI RADIC" +
	"AL DEATHKANGXI RADICAL WEAPONKANGXI RADICAL DO NOTKANGXI RADICAL COMPARE" +
	"KANGXI RADICAL FURKANGXI RADICAL CLANKANGXI RADICAL STEAMKANGXI RADICAL " +
	"WATERKANGXI RADICAL FIREKANGXI RADICAL CLAWKANGXI RADICAL FATHERKANGXI R" +
	"ADICAL DOUBLE XKANGXI RADICAL HALF TREE TRUNKKANGXI RADICAL SLICEKANGXI " +
	"RADICAL FANGKANGXI RADICAL COWKANGXI RADICAL DOGKANGXI RADICAL PROFOUNDK" +
	"ANGXI RADICAL JADEKANGXI RADICAL MELONKANGXI RADICAL TILEKANGXI RADICAL " +
	"SWEETKANGXI RADICAL LIFEKANGXI RADICAL USEKANGXI RADICAL FIELDKANGXI RAD" +
	"ICAL BOLT OF CLOTHKANGXI RADICAL SICKNESSKANGXI RADICAL DOTTED TENTKANGX" +
	"I RADICAL WHITEKANGXI RADICAL SKINKANGXI RADICAL DISHKANGXI RADICAL EYEK" +
	"ANGXI RADICAL SPEARKANGXI RADICAL ARROWKANGXI RADICAL STONEKANGXI RADICA" +
	"L SPIRITKANGXI RADICAL TRACKKANGXI RADICAL GRAINKANGXI RADICAL CAVEKANGX" +
	"I RADICAL STANDKANGXI RADICAL BAMBOOKANGXI RADICAL RICEKANGXI RADICAL SI" +
	"LKKANGXI RADICAL JARKANGXI RADICAL NETKANGXI RADICAL SHEEPKANGXI RADICAL" +
	" FEATHERKANGXI RADICAL OLDKANGXI RADICAL ANDKANGXI RADICAL PLOWKANGXI RA" +
	"DICAL EARKANGXI RADICAL BRUSHKANGXI RADICAL MEATKANGXI RADICAL MINISTERK" +
	"ANGXI RADICAL SELFKANGXI RADICAL ARRIVEKANGXI RADICAL MORTARKANGXI RADIC" +
	"AL TONGUEKANGXI RADICAL OPPOSEKANGXI RADICAL BOATKANGXI RADICAL STOPPING" +
	"KANGXI RADICAL COLORKANGXI RADICAL GRASSKANGXI RADICAL TIGERKANGXI RADIC" +
	"AL INSECTKANGXI RADICAL BLOODKANGXI RADICAL WALK ENCLOSUREKANGXI RADICAL" +
	" CLOTHESKANGXI RADICAL WESTKANGXI RADICAL SEEKANGXI RADICAL HORNKANGXI R" +
	"ADICAL SPEECHKANGXI RADICAL VALLEYKANGXI RADICAL BEANKANGXI RADICAL PIGK" +
	"ANGXI RADICAL BADGERKANGXI RADICAL SHELLKANGXI RADICAL REDKANGXI RADICAL" +
	" RUNKANGXI RADICAL FOOTKANGXI RADICAL BODYKANGXI RADICAL CARTKANGXI RADI" +
	"CAL BITTERKANGXI RADICAL MORNINGKANGXI RADICAL WALKKANGXI RADICAL CITYKA" +
	"NGXI RADICAL WINEKANGXI RADICAL DISTINGUISHKANGXI RADICAL VILLAGEKANGXI " +
	"RADICAL GOLDKANGXI RADICAL LONGKANGXI RADICAL GATEKANGXI RADICAL MOUNDKA" +
	"NGXI RADICAL SLAVEKANGXI RADICAL SHORT TAILED BIRDKANGXI RADICAL RAINKAN" +
	"GXI RADICAL BLUEKANGXI RADICAL WRONGKANGXI RADICAL FACEKANGXI RADICAL LE" +
	"ATHERKANGXI RADICAL TANNED LEATHERKANGXI RADICAL LEEKKANGXI RADICAL SOUN" +
	"DKANGXI RADICAL LEAFKANGXI RADICAL WINDKANGXI RADICAL FLYKANGXI RADICAL " +
	"EATKANGXI RADICAL HEADKANGXI RADICAL FRAGRANTKANGXI RADICAL HORSEKANGXI " +
	"RADICAL BONEKANGXI RADICAL TALLKANGXI RADICAL HAIRKANGXI RADICAL FIGHTKA" +
	"NGXI RADICAL SACRIFICIAL WINEKANGXI RADICAL CAULDRONKANGXI RADICAL GHOST" +
	"KANGXI RADICAL FISHKANGXI RADICAL BIRDKANGXI RADICAL SALTKANGXI RADICAL " +
	"DEERKANGXI RADICAL WHEATKANGXI RADICAL HEMPKANGXI RADICAL YELLOWKANGXI R" +
	"ADICAL MILLETKANGXI RADICAL BLACKKANGXI RADICAL EMBROIDERYKANGXI RADICAL" +
	" FROGKANGXI RADICAL TRIPODKANGXI RADICAL DRUMKANGXI RADICAL RATKANGXI RA" +
	"DICAL NOSEKANGXI RADICAL EVENKANGXI RADICAL TOOTHKANGXI RADICAL DRAGONKA" +
	"NGXI RADICAL TURTLEKANGXI RADICAL FLUTEIDEOGRAPHIC DESCRIPTION CHARACTER" +
	" LEFT TO RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOWIDEOGRAPHI" +
	"C DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHTIDEOGRAPHIC DESCRIPTION " +
	"CHARACTER ABOVE TO MIDDLE AND BELOWIDEOGRAPHIC DESCRIPTION CHARACTER FUL" +
	"L SURROUNDIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVEIDEOGRAPH" +
	"IC DESCRIPTION CHARACTER SURROUND FROM BELOWIDEOGRAPHIC DESCRIPTION CHAR" +
	"ACTER SURROUND FROM LEFTIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM " +
	"UPPER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHTIDE" +
	"OGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFTIDEOGRAPHIC DESCR" +
	"IPTION CHARACTER OVERLAIDIDEOGRAPHIC SPACEIDEOGRAPHIC COMMAIDEOGRAPHIC F" +
	"ULL STOPDITTO MARKJAPANESE INDUSTRIAL STANDARD SYMBOLIDEOGRAPHIC ITERATI" +
	"ON MARKIDEOGRAPHIC CLOSING MARKIDEOGRAPHIC NUMBER ZEROLEFT ANGLE BRACKET" +
	"RIGHT ANGLE BRACKETLEFT DOUBLE ANGLE BRACKETRIGHT DOUBLE ANGLE BRACKETLE" +
	"FT CORNER BRACKETRIGHT CORNER BRACKETLEFT WHITE CORNER BRACKETRIGHT WHIT" +
	"E CORNER BRACKETLEFT BLACK LENTICULAR BRACKETRIGHT BLACK LENTICULAR BRAC" +
	"KETPOSTAL MARKGETA MARKLEFT TORTOISE SHELL BRACKETRIGHT TORTOISE SHELL B" +
	"RACKETLEFT WHITE LENTICULAR BRACKETRIGHT WHITE LENTICULAR BRACKETLEFT WH" +
	"ITE TORTOISE SHELL BRACKETRIGHT WHITE TORTOISE SHELL BRACKETLEFT WHITE S" +
	"QUARE BRACKETRIGHT WHITE SQUARE BRACKETWAVE DASHREVERSED DOUBLE PRIME QU" +
	"OTATION MARKDOUBLE PRIME QUOTATION MARKLOW DOUBLE PRIME QUOTATION MARKPO" +
	"STAL MARK FACEHANGZHOU NUMERAL ONEHANGZHOU NUMERAL TWOHANGZHOU NUMERAL T") + ("" +
	"HREEHANGZHOU NUMERAL FOURHANGZHOU NUMERAL FIVEHANGZHOU NUMERAL SIXHANGZH" +
	"OU NUMERAL SEVENHANGZHOU NUMERAL EIGHTHANGZHOU NUMERAL NINEIDEOGRAPHIC L" +
	"EVEL TONE MARKIDEOGRAPHIC RISING TONE MARKIDEOGRAPHIC DEPARTING TONE MAR" +
	"KIDEOGRAPHIC ENTERING TONE MARKHANGUL SINGLE DOT TONE MARKHANGUL DOUBLE " +
	"DOT TONE MARKWAVY DASHVERTICAL KANA REPEAT MARKVERTICAL KANA REPEAT WITH" +
	" VOICED SOUND MARKVERTICAL KANA REPEAT MARK UPPER HALFVERTICAL KANA REPE" +
	"AT WITH VOICED SOUND MARK UPPER HALFVERTICAL KANA REPEAT MARK LOWER HALF" +
	"CIRCLED POSTAL MARKIDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOLHANGZ" +
	"HOU NUMERAL TENHANGZHOU NUMERAL TWENTYHANGZHOU NUMERAL THIRTYVERTICAL ID" +
	"EOGRAPHIC ITERATION MARKMASU MARKPART ALTERNATION MARKIDEOGRAPHIC VARIAT" +
	"ION INDICATORIDEOGRAPHIC HALF FILL SPACEHIRAGANA LETTER SMALL AHIRAGANA " +
	"LETTER AHIRAGANA LETTER SMALL IHIRAGANA LETTER IHIRAGANA LETTER SMALL UH" +
	"IRAGANA LETTER UHIRAGANA LETTER SMALL EHIRAGANA LETTER EHIRAGANA LETTER " +
	"SMALL OHIRAGANA LETTER OHIRAGANA LETTER KAHIRAGANA LETTER GAHIRAGANA LET" +
	"TER KIHIRAGANA LETTER GIHIRAGANA LETTER KUHIRAGANA LETTER GUHIRAGANA LET" +
	"TER KEHIRAGANA LETTER GEHIRAGANA LETTER KOHIRAGANA LETTER GOHIRAGANA LET" +
	"TER SAHIRAGANA LETTER ZAHIRAGANA LETTER SIHIRAGANA LETTER ZIHIRAGANA LET" +
	"TER SUHIRAGANA LETTER ZUHIRAGANA LETTER SEHIRAGANA LETTER ZEHIRAGANA LET" +
	"TER SOHIRAGANA LETTER ZOHIRAGANA LETTER TAHIRAGANA LETTER DAHIRAGANA LET" +
	"TER TIHIRAGANA LETTER DIHIRAGANA LETTER SMALL TUHIRAGANA LETTER TUHIRAGA" +
	"NA LETTER DUHIRAGANA LETTER TEHIRAGANA LETTER DEHIRAGANA LETTER TOHIRAGA" +
	"NA LETTER DOHIRAGANA LETTER NAHIRAGANA LETTER NIHIRAGANA LETTER NUHIRAGA" +
	"NA LETTER NEHIRAGANA LETTER NOHIRAGANA LETTER HAHIRAGANA LETTER BAHIRAGA" +
	"NA LETTER PAHIRAGANA LETTER HIHIRAGANA LETTER BIHIRAGANA LETTER PIHIRAGA" +
	"NA LETTER HUHIRAGANA LETTER BUHIRAGANA LETTER PUHIRAGANA LETTER HEHIRAGA" +
	"NA LETTER BEHIRAGANA LETTER PEHIRAGANA LETTER HOHIRAGANA LETTER BOHIRAGA" +
	"NA LETTER POHIRAGANA LETTER MAHIRAGANA LETTER MIHIRAGANA LETTER MUHIRAGA" +
	"NA LETTER MEHIRAGANA LETTER MOHIRAGANA LETTER SMALL YAHIRAGANA LETTER YA" +
	"HIRAGANA LETTER SMALL YUHIRAGANA LETTER YUHIRAGANA LETTER SMALL YOHIRAGA" +
	"NA LETTER YOHIRAGANA LETTER RAHIRAGANA LETTER RIHIRAGANA LETTER RUHIRAGA" +
	"NA LETTER REHIRAGANA LETTER ROHIRAGANA LETTER SMALL WAHIRAGANA LETTER WA" +
	"HIRAGANA LETTER WIHIRAGANA LETTER WEHIRAGANA LETTER WOHIRAGANA LETTER NH" +
	"IRAGANA LETTER VUHIRAGANA LETTER SMALL KAHIRAGANA LETTER SMALL KECOMBINI" +
	"NG KATAKANA-HIRAGANA VOICED SOUND MARKCOMBINING KATAKANA-HIRAGANA SEMI-V" +
	"OICED SOUND MARKKATAKANA-HIRAGANA VOICED SOUND MARKKATAKANA-HIRAGANA SEM" +
	"I-VOICED SOUND MARKHIRAGANA ITERATION MARKHIRAGANA VOICED ITERATION MARK" +
	"HIRAGANA DIGRAPH YORIKATAKANA-HIRAGANA DOUBLE HYPHENKATAKANA LETTER SMAL" +
	"L AKATAKANA LETTER AKATAKANA LETTER SMALL IKATAKANA LETTER IKATAKANA LET" +
	"TER SMALL UKATAKANA LETTER UKATAKANA LETTER SMALL EKATAKANA LETTER EKATA" +
	"KANA LETTER SMALL OKATAKANA LETTER OKATAKANA LETTER KAKATAKANA LETTER GA" +
	"KATAKANA LETTER KIKATAKANA LETTER GIKATAKANA LETTER KUKATAKANA LETTER GU" +
	"KATAKANA LETTER KEKATAKANA LETTER GEKATAKANA LETTER KOKATAKANA LETTER GO" +
	"KATAKANA LETTER SAKATAKANA LETTER ZAKATAKANA LETTER SIKATAKANA LETTER ZI" +
	"KATAKANA LETTER SUKATAKANA LETTER ZUKATAKANA LETTER SEKATAKANA LETTER ZE" +
	"KATAKANA LETTER SOKATAKANA LETTER ZOKATAKANA LETTER TAKATAKANA LETTER DA" +
	"KATAKANA LETTER TIKATAKANA LETTER DIKATAKANA LETTER SMALL TUKATAKANA LET" +
	"TER TUKATAKANA LETTER DUKATAKANA LETTER TEKATAKANA LETTER DEKATAKANA LET" +
	"TER TOKATAKANA LETTER DOKATAKANA LETTER NAKATAKANA LETTER NIKATAKANA LET" +
	"TER NUKATAKANA LETTER NEKATAKANA LETTER NOKATAKANA LETTER HAKATAKANA LET" +
	"TER BAKATAKANA LETTER PAKATAKANA LETTER HIKATAKANA LETTER BIKATAKANA LET" +
	"TER PIKATAKANA LETTER HUKATAKANA LETTER BUKATAKANA LETTER PUKATAKANA LET" +
	"TER HEKATAKANA LETTER BEKATAKANA LETTER PEKATAKANA LETTER HOKATAKANA LET" +
	"TER BOKATAKANA LETTER POKATAKANA LETTER MAKATAKANA LETTER MIKATAKANA LET" +
	"TER MUKATAKANA LETTER MEKATAKANA LETTER MOKATAKANA LETTER SMALL YAKATAKA" +
	"NA LETTER YAKATAKANA LETTER SMALL YUKATAKANA LETTER YUKATAKANA LETTER SM" +
	"ALL YOKATAKANA LETTER YOKATAKANA LETTER RAKATAKANA LETTER RIKATAKANA LET" +
	"TER RUKATAKANA LETTER REKATAKANA LETTER ROKATAKANA LETTER SMALL WAKATAKA" +
	"NA LETTER WAKATAKANA LETTER WIKATAKANA LETTER WEKATAKANA LETTER WOKATAKA" +
	"NA LETTER NKATAKANA LETTER VUKATAKANA LETTER SMALL KAKATAKANA LETTER SMA" +
	"LL KEKATAKANA LETTER VAKATAKANA LETTER VIKATAKANA LETTER VEKATAKANA LETT" +
	"ER VOKATAKANA MIDDLE DOTKATAKANA-HIRAGANA PROLONGED SOUND MARKKATAKANA I" +
	"TERATION MARKKATAKANA VOICED ITERATION MARKKATAKANA DIGRAPH KOTOBOPOMOFO" +
	" LETTER BBOPOMOFO LETTER PBOPOMOFO LETTER MBOPOMOFO LETTER FBOPOMOFO LET" +
	"TER DBOPOMOFO LETTER TBOPOMOFO LETTER NBOPOMOFO LETTER LBOPOMOFO LETTER ") + ("" +
	"GBOPOMOFO LETTER KBOPOMOFO LETTER HBOPOMOFO LETTER JBOPOMOFO LETTER QBOP" +
	"OMOFO LETTER XBOPOMOFO LETTER ZHBOPOMOFO LETTER CHBOPOMOFO LETTER SHBOPO" +
	"MOFO LETTER RBOPOMOFO LETTER ZBOPOMOFO LETTER CBOPOMOFO LETTER SBOPOMOFO" +
	" LETTER ABOPOMOFO LETTER OBOPOMOFO LETTER EBOPOMOFO LETTER EHBOPOMOFO LE" +
	"TTER AIBOPOMOFO LETTER EIBOPOMOFO LETTER AUBOPOMOFO LETTER OUBOPOMOFO LE" +
	"TTER ANBOPOMOFO LETTER ENBOPOMOFO LETTER ANGBOPOMOFO LETTER ENGBOPOMOFO " +
	"LETTER ERBOPOMOFO LETTER IBOPOMOFO LETTER UBOPOMOFO LETTER IUBOPOMOFO LE" +
	"TTER VBOPOMOFO LETTER NGBOPOMOFO LETTER GNBOPOMOFO LETTER IHBOPOMOFO LET" +
	"TER O WITH DOT ABOVEHANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL " +
	"LETTER KIYEOK-SIOSHANGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LET" +
	"TER NIEUN-HIEUHHANGUL LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTE" +
	"R RIEULHANGUL LETTER RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER " +
	"RIEUL-PIEUPHANGUL LETTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LET" +
	"TER RIEUL-PHIEUPHHANGUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETT" +
	"ER PIEUPHANGUL LETTER SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SI" +
	"OSHANGUL LETTER SSANGSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LE" +
	"TTER SSANGCIEUCHANGUL LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER T" +
	"HIEUTHHANGUL LETTER PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETT" +
	"ER AEHANGUL LETTER YAHANGUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHAN" +
	"GUL LETTER YEOHANGUL LETTER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETT" +
	"ER WAEHANGUL LETTER OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHA" +
	"NGUL LETTER WEHANGUL LETTER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LET" +
	"TER YIHANGUL LETTER IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER " +
	"NIEUN-TIKEUTHANGUL LETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LE" +
	"TTER RIEUL-KIYEOK-SIOSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEU" +
	"P-SIOSHANGUL LETTER RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL L" +
	"ETTER MIEUM-PIEUPHANGUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANG" +
	"UL LETTER KAPYEOUNMIEUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIK" +
	"EUTHANGUL LETTER PIEUP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL " +
	"LETTER PIEUP-CIEUCHANGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUP" +
	"HANGUL LETTER KAPYEOUNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER S" +
	"IOS-NIEUNHANGUL LETTER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER " +
	"SIOS-CIEUCHANGUL LETTER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YES" +
	"IEUNGHANGUL LETTER YESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LET" +
	"TER KAPYEOUNPHIEUPHHANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANG" +
	"UL LETTER YO-YAHANGUL LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YE" +
	"OHANGUL LETTER YU-YEHANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER A" +
	"RAEAEIDEOGRAPHIC ANNOTATION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE M" +
	"ARKIDEOGRAPHIC ANNOTATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRA" +
	"PHIC ANNOTATION THREE MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC AN" +
	"NOTATION TOP MARKIDEOGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATIO" +
	"N BOTTOM MARKIDEOGRAPHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SEC" +
	"OND MARKIDEOGRAPHIC ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH M" +
	"ARKIDEOGRAPHIC ANNOTATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKID" +
	"EOGRAPHIC ANNOTATION MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOF" +
	"O LETTER JIBOPOMOFO LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMO" +
	"FO LETTER OOBOPOMOFO LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPO" +
	"MOFO LETTER INNBOPOMOFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGB" +
	"OPOMOFO LETTER AINNBOPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER" +
	" OMBOPOMOFO LETTER ONGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOF" +
	"O FINAL LETTER TBOPOMOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO L" +
	"ETTER GHBOPOMOFO LETTER LHBOPOMOFO LETTER ZYCJK STROKE TCJK STROKE WGCJK" +
	" STROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZGCJK STR" +
	"OKE HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZPCJK STR" +
	"OKE HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK STROKE " +
	"SCJK STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGCJK STRO" +
	"KE SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STROKE PZC" +
	"JK STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE HZZZGC" +
	"JK STROKE PGCJK STROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER SMALL SI" +
	"KATAKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER SMALL NU" +
	"KATAKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER SMALL HU" +
	"KATAKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER SMALL MU" +
	"KATAKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER SMALL RU" +
	"KATAKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HANGUL KIY") + ("" +
	"EOKPARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHESIZED HA" +
	"NGUL RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPARENTHESI" +
	"ZED HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIEUCPAREN" +
	"THESIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED HANGUL " +
	"THIEUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARENTHESIZ" +
	"ED HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGUL TIKEU" +
	"T APARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENTHESIZED" +
	" HANGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IEUNG APA" +
	"RENTHESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHESIZED HA" +
	"NGUL KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL PHIEUPH" +
	" APARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTHESIZED " +
	"KOREAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHESIZED I" +
	"DEOGRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH THREEPARE" +
	"NTHESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED IDEOGR" +
	"APH SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHTPARENTH" +
	"ESIZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDEOGRAPH " +
	"MOONPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARENTHESIZ" +
	"ED IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOGRAPH EA" +
	"RTHPARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENTHESIZED" +
	" IDEOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOGRAPH NA" +
	"MEPARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIALPARENT" +
	"HESIZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARENTHESIZ" +
	"ED IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED IDEOGRAP" +
	"H STUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH ENTERPRI" +
	"SEPARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANCEPARENT" +
	"HESIZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZED IDEO" +
	"GRAPH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIONCIRCLED" +
	" IDEOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH KOTOCIR" +
	"CLED NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQUARECIRC" +
	"LED NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQUARECIR" +
	"CLED NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQUARECIR" +
	"CLED NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK SQUARE" +
	"PARTNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TWOCIRCLE" +
	"D NUMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWENTY FIV" +
	"ECIRCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMBER TWEN" +
	"TY EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NUMBER TH" +
	"IRTY ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCLED NUMB" +
	"ER THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRCLED HAN" +
	"GUL NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL MIEUMCI" +
	"RCLED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED HANGUL " +
	"CIEUCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL THIEUTHC" +
	"IRCLED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK ACIRCLED " +
	"HANGUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLED HANGU" +
	"L MIEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGUL IEUNG" +
	" ACIRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KHIEUKH A" +
	"CIRCLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HIEUH ACI" +
	"RCLED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLED HANGU" +
	"L IEUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOGRAPH TW" +
	"OCIRCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH FIVECIRC" +
	"LED IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCIRCLED I" +
	"DEOGRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED IDEOGRAP" +
	"H FIRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGRAPH MET" +
	"ALCIRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH STOCKCIR" +
	"CLED IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAMECIRCLE" +
	"D IDEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH CONGRATU" +
	"LATIONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEOGRAPH M" +
	"ALECIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEOGRAPH E" +
	"XCELLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED IDEOGR" +
	"APH ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOGRAPH CO" +
	"RRECTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGRAPH LOW" +
	"CIRCLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH MEDICINEC" +
	"IRCLED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH SUPERV" +
	"ISECIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED IDEOGRA" +
	"PH ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLED NUMBE") + ("" +
	"R THIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NINECIRCL" +
	"ED NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCIRCLED N" +
	"UMBER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FIVECIRCL" +
	"ED NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY EIGHTC" +
	"IRCLED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC TELEGRA" +
	"PH SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDEOGRAPHI" +
	"C TELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCLED KATA" +
	"KANA ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCLED KATA" +
	"KANA OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCIRCLED K" +
	"ATAKANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA SICIRCL" +
	"ED KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAKANA TAC" +
	"IRCLED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED KATAKANA" +
	" TOCIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCLED KATA" +
	"KANA NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HICIRCLED " +
	"KATAKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA MACIRC" +
	"LED KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATAKANA MO" +
	"CIRCLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED KATAKAN" +
	"A RACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRCLED KAT" +
	"AKANA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WECIRCLED" +
	" KATAKANA WOSQUARE APAATOSQUARE ARUHUASQUARE ANPEASQUARE AARUSQUARE ININ" +
	"GUSQUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE EEKAASQUARE ONSUSQUARE OOMU" +
	"SQUARE KAIRISQUARE KARATTOSQUARE KARORIISQUARE GARONSQUARE GANMASQUARE G" +
	"IGASQUARE GINIISQUARE KYURIISQUARE GIRUDAASQUARE KIROSQUARE KIROGURAMUSQ" +
	"UARE KIROMEETORUSQUARE KIROWATTOSQUARE GURAMUSQUARE GURAMUTONSQUARE KURU" +
	"ZEIROSQUARE KUROONESQUARE KEESUSQUARE KORUNASQUARE KOOPOSQUARE SAIKURUSQ" +
	"UARE SANTIIMUSQUARE SIRINGUSQUARE SENTISQUARE SENTOSQUARE DAASUSQUARE DE" +
	"SISQUARE DORUSQUARE TONSQUARE NANOSQUARE NOTTOSQUARE HAITUSQUARE PAASENT" +
	"OSQUARE PAATUSQUARE BAARERUSQUARE PIASUTORUSQUARE PIKURUSQUARE PIKOSQUAR" +
	"E BIRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUSSYERUSQUARE HURANSQUARE HEKU" +
	"TAARUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQUARE PENSUSQUARE PEEZISQUARE" +
	" BEETASQUARE POINTOSQUARE BORUTOSQUARE HONSQUARE PONDOSQUARE HOORUSQUARE" +
	" HOONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHASQUARE MARUKUSQUARE MANSYONSQ" +
	"UARE MIKURONSQUARE MIRISQUARE MIRIBAARUSQUARE MEGASQUARE MEGATONSQUARE M" +
	"EETORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQUARE RITTORUSQUARE RIRASQUARE" +
	" RUPIISQUARE RUUBURUSQUARE REMUSQUARE RENTOGENSQUARE WATTOIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONEIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR H" +
	"OUR THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXIDEOGRAPHI" +
	"C TELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR E" +
	"IGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVENIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THI" +
	"RTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEENIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEENIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEENIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEENIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOU" +
	"R TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWOIDEOGRAPHIC " +
	"TELEGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR H" +
	"OUR TWENTY-FOURSQUARE HPASQUARE DASQUARE AUSQUARE BARSQUARE OVSQUARE PCS" +
	"QUARE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUARE IUSQUARE ERA NAME HEISEIS" +
	"QUARE ERA NAME SYOUWASQUARE ERA NAME TAISYOUSQUARE ERA NAME MEIZISQUARE " +
	"CORPORATIONSQUARE PA AMPSSQUARE NASQUARE MU ASQUARE MASQUARE KASQUARE KB" +
	"SQUARE MBSQUARE GBSQUARE CALSQUARE KCALSQUARE PFSQUARE NFSQUARE MU FSQUA" +
	"RE MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZSQUARE MHZSQUARE GHZSQUARE T" +
	"HZSQUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUARE FMSQUARE NMSQUARE MU MSQU" +
	"ARE MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQUARE CM SQUAREDSQUARE M SQUAR" +
	"EDSQUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM CUBEDSQUARE M CUBEDSQUARE KM") + ("" +
	" CUBEDSQUARE M OVER SSQUARE M OVER S SQUAREDSQUARE PASQUARE KPASQUARE MP" +
	"ASQUARE GPASQUARE RADSQUARE RAD OVER SSQUARE RAD OVER S SQUAREDSQUARE PS" +
	"SQUARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE NVSQUARE MU VSQUARE MVSQUAR" +
	"E KVSQUARE MV MEGASQUARE PWSQUARE NWSQUARE MU WSQUARE MWSQUARE KWSQUARE " +
	"MW MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUARE BQSQUARE CCSQUARE CDSQUAR" +
	"E C OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE HASQUARE HPSQUARE INSQUARE " +
	"KKSQUARE KM CAPITALSQUARE KTSQUARE LMSQUARE LNSQUARE LOGSQUARE LXSQUARE " +
	"MB SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE PMSQUARE PPMSQUARE PRSQUARE " +
	"SRSQUARE SVSQUARE WBSQUARE V OVER MSQUARE A OVER MIDEOGRAPHIC TELEGRAPH " +
	"SYMBOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWOIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINEIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVENID" +
	"EOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEENIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXT" +
	"EENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEENIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEENIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWOIDEOGRAPHIC " +
	"TELEGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DA" +
	"Y TWENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVEIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY" +
	" TWENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHTIDEOGRAPHI" +
	"C TELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONESQUARE GALHEXAGR" +
	"AM FOR THE CREATIVE HEAVENHEXAGRAM FOR THE RECEPTIVE EARTHHEXAGRAM FOR D" +
	"IFFICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTHFUL FOLLYHEXAGRAM FOR WAITIN" +
	"GHEXAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYHEXAGRAM FOR HOLDING TOGETHER" +
	"HEXAGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADINGHEXAGRAM FOR PEACEHEXAGRAM" +
	" FOR STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGRAM FOR GREAT POSSESSIONHEXAG" +
	"RAM FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGRAM FOR FOLLOWINGHEXAGRAM FOR" +
	" WORK ON THE DECAYEDHEXAGRAM FOR APPROACHHEXAGRAM FOR CONTEMPLATIONHEXAG" +
	"RAM FOR BITING THROUGHHEXAGRAM FOR GRACEHEXAGRAM FOR SPLITTING APARTHEXA" +
	"GRAM FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRAM FOR GREAT TAMINGHEXAGRAM F" +
	"OR MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDERANCEHEXAGRAM FOR THE ABYSMAL" +
	" WATERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM FOR INFLUENCEHEXAGRAM FOR D" +
	"URATIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREAT POWERHEXAGRAM FOR PROGRESS" +
	"HEXAGRAM FOR DARKENING OF THE LIGHTHEXAGRAM FOR THE FAMILYHEXAGRAM FOR O" +
	"PPOSITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FOR DELIVERANCEHEXAGRAM FOR DE" +
	"CREASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREAKTHROUGHHEXAGRAM FOR COMING " +
	"TO MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGRAM FOR PUSHING UPWARDHEXAGRA" +
	"M FOR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRAM FOR REVOLUTIONHEXAGRAM FOR" +
	" THE CAULDRONHEXAGRAM FOR THE AROUSING THUNDERHEXAGRAM FOR THE KEEPING S" +
	"TILL MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRAM FOR THE MARRYING MAIDENHEX" +
	"AGRAM FOR ABUNDANCEHEXAGRAM FOR THE WANDERERHEXAGRAM FOR THE GENTLE WIND" +
	"HEXAGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DISPERSIONHEXAGRAM FOR LIMITATI" +
	"ONHEXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL PREPONDERANCEHEXAGRAM FOR A" +
	"FTER COMPLETIONHEXAGRAM FOR BEFORE COMPLETIONYI SYLLABLE ITYI SYLLABLE I" +
	"XYI SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETYI SYLLABLE IEXYI SYLLABLE IE" +
	"YI SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXYI SYLLABLE AYI SYLLABLE APYI" +
	" SYLLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI SYLLABLE OTYI SYLLABLE OXYI" +
	" SYLLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SYLLABLE EYI SYLLABLE WUYI SYL" +
	"LABLE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYLLABLE BIPYI SYLLABLE BIETYI " +
	"SYLLABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEPYI SYLLABLE BATYI SYLLABLE B" +
	"AXYI SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE BUOXYI SYLLABLE BUOYI SYLLABL" +
	"E BUOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLABLE BOYI SYLLABLE BOPYI SYLL" +
	"ABLE BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLLABLE BUTYI SYLLABLE BUXYI SY" +
	"LLABLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI SYLLABLE BURYI SYLLABLE BYTYI" +
	" SYLLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI SYLLABLE BYRXYI SYLLABLE BY" +
	"RYI SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE PIYI SYLLABLE PIPYI SYLLABLE " +
	"PIEXYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLABLE PATYI SYLLABLE PAXYI SYLL") + ("" +
	"ABLE PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYLLABLE PUOYI SYLLABLE PUOPYI " +
	"SYLLABLE POTYI SYLLABLE POXYI SYLLABLE POYI SYLLABLE POPYI SYLLABLE PUTY" +
	"I SYLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPYI SYLLABLE PURXYI SYLLABLE P" +
	"URYI SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE PYYI SYLLABLE PYPYI SYLLABLE" +
	" PYRXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLABLE BBIXYI SYLLABLE BBIYI SY" +
	"LLABLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIEXYI SYLLABLE BBIEYI SYLLABLE" +
	" BBIEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYLLABLE BBAYI SYLLABLE BBAPYI " +
	"SYLLABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BBUOPYI SYLLABLE BBOTYI SYLLAB" +
	"LE BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYLLABLE BBEXYI SYLLABLE BBEYI " +
	"SYLLABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBUXYI SYLLABLE BBUYI SYLLABLE " +
	"BBUPYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLLABLE BBYTYI SYLLABLE BBYXYI " +
	"SYLLABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBITYI SYLLABLE NBIXYI SYLLABLE " +
	"NBIYI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLABLE NBIEYI SYLLABLE NBIEPYI " +
	"SYLLABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBAYI SYLLABLE NBAPYI SYLLABLE " +
	"NBOTYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLABLE NBOPYI SYLLABLE NBUTYI SY" +
	"LLABLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI SYLLABLE NBURXYI SYLLABLE N" +
	"BURYI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLABLE NBYYI SYLLABLE NBYPYI SYL" +
	"LABLE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITYI SYLLABLE HMIXYI SYLLABLE H" +
	"MIYI SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLABLE HMIEYI SYLLABLE HMIEPYI S" +
	"YLLABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAYI SYLLABLE HMAPYI SYLLABLE H" +
	"MUOXYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLLABLE HMOTYI SYLLABLE HMOXYI " +
	"SYLLABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUTYI SYLLABLE HMUXYI SYLLABLE " +
	"HMUYI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLABLE HMURYI SYLLABLE HMYXYI S" +
	"YLLABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRXYI SYLLABLE HMYRYI SYLLABLE " +
	"MITYI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE MIPYI SYLLABLE MIEXYI SYLLAB" +
	"LE MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLLABLE MAXYI SYLLABLE MAYI SYL" +
	"LABLE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI SYLLABLE MUOYI SYLLABLE MUOP" +
	"YI SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MOYI SYLLABLE MOPYI SYLLABLE M" +
	"EXYI SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE MUXYI SYLLABLE MUYI SYLLABLE " +
	"MUPYI SYLLABLE MURXYI SYLLABLE MURYI SYLLABLE MYTYI SYLLABLE MYXYI SYLLA" +
	"BLE MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLABLE FIXYI SYLLABLE FIYI SYLL" +
	"ABLE FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYLLABLE FAYI SYLLABLE FAPYI SY" +
	"LLABLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SYLLABLE FUTYI SYLLABLE FUXYI " +
	"SYLLABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI SYLLABLE FURYI SYLLABLE FYT" +
	"YI SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYPYI SYLLABLE VITYI SYLLABLE V" +
	"IXYI SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE VIETYI SYLLABLE VIEXYI SYLLAB" +
	"LE VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLLABLE VAXYI SYLLABLE VAYI SYL" +
	"LABLE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SYLLABLE VOYI SYLLABLE VOPYI S" +
	"YLLABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI SYLLABLE VUXYI SYLLABLE VUYI" +
	" SYLLABLE VUPYI SYLLABLE VURXYI SYLLABLE VURYI SYLLABLE VYTYI SYLLABLE V" +
	"YXYI SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE VYRXYI SYLLABLE VYRYI SYLLABL" +
	"E DITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABLE DIPYI SYLLABLE DIEXYI SYLL" +
	"ABLE DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SYLLABLE DAXYI SYLLABLE DAYI S" +
	"YLLABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI SYLLABLE DOTYI SYLLABLE DOX" +
	"YI SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEXYI SYLLABLE DEYI SYLLABLE DE" +
	"PYI SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE DUYI SYLLABLE DUPYI SYLLABLE " +
	"DURXYI SYLLABLE DURYI SYLLABLE TITYI SYLLABLE TIXYI SYLLABLE TIYI SYLLAB" +
	"LE TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLLABLE TIEPYI SYLLABLE TATYI S" +
	"YLLABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI SYLLABLE TUOTYI SYLLABLE TUOX" +
	"YI SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE TOTYI SYLLABLE TOXYI SYLLABLE" +
	" TOYI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE TEYI SYLLABLE TEPYI SYLLABL" +
	"E TUTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABLE TUPYI SYLLABLE TURXYI SYLL" +
	"ABLE TURYI SYLLABLE DDITYI SYLLABLE DDIXYI SYLLABLE DDIYI SYLLABLE DDIPY" +
	"I SYLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE DDIEPYI SYLLABLE DDATYI SYLL" +
	"ABLE DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI SYLLABLE DDUOXYI SYLLABLE DDU" +
	"OYI SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABLE DDOXYI SYLLABLE DDOYI SYLL" +
	"ABLE DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI SYLLABLE DDEPYI SYLLABLE DDUT" +
	"YI SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE DDUPYI SYLLABLE DDURXYI SYLLA" +
	"BLE DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI SYLLABLE NDIYI SYLLABLE NDIPY" +
	"I SYLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE NDATYI SYLLABLE NDAXYI SYLLA" +
	"BLE NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SYLLABLE NDOXYI SYLLABLE NDOYI" +
	" SYLLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE NDEYI SYLLABLE NDEPYI SYLLABLE" +
	" NDUTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLABLE NDUPYI SYLLABLE NDURXYI " +
	"SYLLABLE NDURYI SYLLABLE HNITYI SYLLABLE HNIXYI SYLLABLE HNIYI SYLLABLE ") + ("" +
	"HNIPYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYLLABLE HNIEYI SYLLABLE HNIEPY" +
	"I SYLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE HNAYI SYLLABLE HNAPYI SYLLABL" +
	"E HNUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SYLLABLE HNOXYI SYLLABLE HNOPY" +
	"I SYLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HNEPYI SYLLABLE HNUTYI SYLLABL" +
	"E NITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABLE NIPYI SYLLABLE NIEXYI SYLL" +
	"ABLE NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SYLLABLE NAYI SYLLABLE NAPYI S" +
	"YLLABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPYI SYLLABLE NOTYI SYLLABLE NO" +
	"XYI SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NEXYI SYLLABLE NEYI SYLLABLE N" +
	"EPYI SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE NUYI SYLLABLE NUPYI SYLLABLE" +
	" NURXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLABLE HLIXYI SYLLABLE HLIYI SY" +
	"LLABLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIEYI SYLLABLE HLIEPYI SYLLABLE" +
	" HLATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLABLE HLAPYI SYLLABLE HLUOXYI " +
	"SYLLABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HLOXYI SYLLABLE HLOYI SYLLABLE" +
	" HLOPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLABLE HLEPYI SYLLABLE HLUTYI S" +
	"YLLABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPYI SYLLABLE HLURXYI SYLLABLE " +
	"HLURYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLABLE HLYYI SYLLABLE HLYPYI SY" +
	"LLABLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITYI SYLLABLE LIXYI SYLLABLE LI" +
	"YI SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE LIEXYI SYLLABLE LIEYI SYLLABL" +
	"E LIEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLABLE LAYI SYLLABLE LAPYI SYLL" +
	"ABLE LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI SYLLABLE LUOPYI SYLLABLE LOTY" +
	"I SYLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPYI SYLLABLE LEXYI SYLLABLE LE" +
	"YI SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LUXYI SYLLABLE LUYI SYLLABLE L" +
	"UPYI SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE LYTYI SYLLABLE LYXYI SYLLAB" +
	"LE LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLABLE LYRYI SYLLABLE GITYI SYL" +
	"LABLE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYLLABLE GIETYI SYLLABLE GIEXYI" +
	" SYLLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GATYI SYLLABLE GAXYI SYLLABLE G" +
	"AYI SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE GUOXYI SYLLABLE GUOYI SYLLAB" +
	"LE GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLLABLE GOYI SYLLABLE GOPYI SYL" +
	"LABLE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYLLABLE GEPYI SYLLABLE GUTYI S" +
	"YLLABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI SYLLABLE GURXYI SYLLABLE GURY" +
	"I SYLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIYI SYLLABLE KIPYI SYLLABLE KI" +
	"EXYI SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE KATYI SYLLABLE KAXYI SYLLAB" +
	"LE KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLABLE KUOYI SYLLABLE KUOPYI SY" +
	"LLABLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SYLLABLE KOPYI SYLLABLE KETYI " +
	"SYLLABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI SYLLABLE KUTYI SYLLABLE KUXY" +
	"I SYLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURXYI SYLLABLE KURYI SYLLABLE G" +
	"GITYI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABLE GGIEXYI SYLLABLE GGIEYI SY" +
	"LLABLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAXYI SYLLABLE GGAYI SYLLABLE G" +
	"GAPYI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLLABLE GGUOYI SYLLABLE GGUOPYI" +
	" SYLLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GGOYI SYLLABLE GGOPYI SYLLABLE" +
	" GGETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLABLE GGEPYI SYLLABLE GGUTYI S" +
	"YLLABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPYI SYLLABLE GGURXYI SYLLABLE " +
	"GGURYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLLABLE MGATYI SYLLABLE MGAXYI " +
	"SYLLABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUOXYI SYLLABLE MGUOYI SYLLABLE" +
	" MGUOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYLLABLE MGOYI SYLLABLE MGOPYI " +
	"SYLLABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEPYI SYLLABLE MGUTYI SYLLABLE " +
	"MGUXYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLABLE MGURXYI SYLLABLE MGURYI S" +
	"YLLABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIYI SYLLABLE HXIPYI SYLLABLE H" +
	"XIETYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLLABLE HXIEPYI SYLLABLE HXATYI" +
	" SYLLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXAPYI SYLLABLE HXUOTYI SYLLABL" +
	"E HXUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI SYLLABLE HXOTYI SYLLABLE HXOX" +
	"YI SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE HXEXYI SYLLABLE HXEYI SYLLABL" +
	"E HXEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SYLLABLE NGIEPYI SYLLABLE NGAT" +
	"YI SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE NGAPYI SYLLABLE NGUOTYI SYLLA" +
	"BLE NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI SYLLABLE NGOXYI SYLLABLE NGO" +
	"YI SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE NGEYI SYLLABLE NGEPYI SYLLAB" +
	"LE HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLLABLE HATYI SYLLABLE HAXYI SY" +
	"LLABLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI SYLLABLE HUOXYI SYLLABLE HUOY" +
	"I SYLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HOXYI SYLLABLE HOYI SYLLABLE H" +
	"OPYI SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE HEPYI SYLLABLE WATYI SYLLABLE" +
	" WAXYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE WUOXYI SYLLABLE WUOYI SYLLA" +
	"BLE WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLLABLE WOPYI SYLLABLE WEXYI SY" +
	"LLABLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SYLLABLE ZIXYI SYLLABLE ZIYI S" +
	"YLLABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI SYLLABLE ZIEPYI SYLLABLE ZA") + ("" +
	"TYI SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZAPYI SYLLABLE ZUOXYI SYLLABLE" +
	" ZUOYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLABLE ZOXYI SYLLABLE ZOYI SYLLA" +
	"BLE ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLABLE ZEPYI SYLLABLE ZUTYI SYL" +
	"LABLE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYLLABLE ZURXYI SYLLABLE ZURYI " +
	"SYLLABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI SYLLABLE ZYPYI SYLLABLE ZYRX" +
	"YI SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CIXYI SYLLABLE CIYI SYLLABLE C" +
	"IPYI SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABLE CIEYI SYLLABLE CIEPYI SYLL" +
	"ABLE CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLLABLE CAPYI SYLLABLE CUOXYI S" +
	"YLLABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI SYLLABLE COXYI SYLLABLE COY" +
	"I SYLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEYI SYLLABLE CEPYI SYLLABLE CU" +
	"TYI SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CUPYI SYLLABLE CURXYI SYLLABLE" +
	" CURYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABLE CYYI SYLLABLE CYPYI SYLLAB" +
	"LE CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYLLABLE ZZIXYI SYLLABLE ZZIYI " +
	"SYLLABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZIEXYI SYLLABLE ZZIEYI SYLLAB" +
	"LE ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI SYLLABLE ZZAYI SYLLABLE ZZAPY" +
	"I SYLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZOPYI SYLLABLE ZZEXYI SYLLABL" +
	"E ZZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLLABLE ZZUYI SYLLABLE ZZUPYI S" +
	"YLLABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZYTYI SYLLABLE ZZYXYI SYLLABLE" +
	" ZZYYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLLABLE ZZYRYI SYLLABLE NZITYI " +
	"SYLLABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIPYI SYLLABLE NZIEXYI SYLLABLE" +
	" NZIEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYLLABLE NZAXYI SYLLABLE NZAYI " +
	"SYLLABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZUOYI SYLLABLE NZOXYI SYLLABL" +
	"E NZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLLABLE NZUXYI SYLLABLE NZUYI S" +
	"YLLABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZURYI SYLLABLE NZYTYI SYLLABLE" +
	" NZYXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLABLE NZYRXYI SYLLABLE NZYRYI " +
	"SYLLABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI SYLLABLE SIPYI SYLLABLE SIEX" +
	"YI SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE SATYI SYLLABLE SAXYI SYLLABLE" +
	" SAYI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABLE SUOYI SYLLABLE SUOPYI SYLL" +
	"ABLE SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLLABLE SOPYI SYLLABLE SEXYI SY" +
	"LLABLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SYLLABLE SUXYI SYLLABLE SUYI S" +
	"YLLABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI SYLLABLE SYTYI SYLLABLE SYX" +
	"YI SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYRXYI SYLLABLE SYRYI SYLLABLE " +
	"SSITYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLABLE SSIPYI SYLLABLE SSIEXYI S" +
	"YLLABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSATYI SYLLABLE SSAXYI SYLLABLE" +
	" SSAYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLABLE SSOXYI SYLLABLE SSOYI SY" +
	"LLABLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI SYLLABLE SSEPYI SYLLABLE SS" +
	"UTYI SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE SSUPYI SYLLABLE SSYTYI SYLL" +
	"ABLE SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI SYLLABLE SSYRXYI SYLLABLE SSY" +
	"RYI SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE ZHAYI SYLLABLE ZHAPYI SYLLA" +
	"BLE ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI SYLLABLE ZHOTYI SYLLABLE ZH" +
	"OXYI SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE ZHETYI SYLLABLE ZHEXYI SYLL" +
	"ABLE ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI SYLLABLE ZHUXYI SYLLABLE ZHUY" +
	"I SYLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE ZHURYI SYLLABLE ZHYTYI SYLLA" +
	"BLE ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SYLLABLE ZHYRXYI SYLLABLE ZHYR" +
	"YI SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE CHAYI SYLLABLE CHAPYI SYLLAB" +
	"LE CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI SYLLABLE CHUOPYI SYLLABLE CH" +
	"OTYI SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE CHOPYI SYLLABLE CHETYI SYLL" +
	"ABLE CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI SYLLABLE CHUXYI SYLLABLE CHUY" +
	"I SYLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE CHURYI SYLLABLE CHYTYI SYLLA" +
	"BLE CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SYLLABLE CHYRXYI SYLLABLE CHYR" +
	"YI SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE RRUOXYI SYLLABLE RRUOYI SYLLA" +
	"BLE RROTYI SYLLABLE RROXYI SYLLABLE RROYI SYLLABLE RROPYI SYLLABLE RRETY" +
	"I SYLLABLE RREXYI SYLLABLE RREYI SYLLABLE RREPYI SYLLABLE RRUTYI SYLLABL" +
	"E RRUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLLABLE RRURXYI SYLLABLE RRURYI" +
	" SYLLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RRYYI SYLLABLE RRYPYI SYLLABLE" +
	" RRYRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYLLABLE NRAXYI SYLLABLE NRAYI " +
	"SYLLABLE NRAPYI SYLLABLE NROXYI SYLLABLE NROYI SYLLABLE NROPYI SYLLABLE " +
	"NRETYI SYLLABLE NREXYI SYLLABLE NREYI SYLLABLE NREPYI SYLLABLE NRUTYI SY" +
	"LLABLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI SYLLABLE NRURXYI SYLLABLE N" +
	"RURYI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLABLE NRYYI SYLLABLE NRYPYI SYL" +
	"LABLE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATYI SYLLABLE SHAXYI SYLLABLE S" +
	"HAYI SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLABLE SHUOYI SYLLABLE SHUOPYI S" +
	"YLLABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOYI SYLLABLE SHOPYI SYLLABLE S" +
	"HETYI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABLE SHEPYI SYLLABLE SHUTYI SYL") + ("" +
	"LABLE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI SYLLABLE SHURXYI SYLLABLE SH" +
	"URYI SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABLE SHYYI SYLLABLE SHYPYI SYLL" +
	"ABLE SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI SYLLABLE RAXYI SYLLABLE RAYI" +
	" SYLLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUOYI SYLLABLE RUOPYI SYLLABLE " +
	"ROTYI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE ROPYI SYLLABLE REXYI SYLLABL" +
	"E REYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABLE RUXYI SYLLABLE RUYI SYLLAB" +
	"LE RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLLABLE RYTYI SYLLABLE RYXYI SY" +
	"LLABLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI SYLLABLE RYRYI SYLLABLE JITYI" +
	" SYLLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI SYLLABLE JIETYI SYLLABLE JI" +
	"EXYI SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE JUOTYI SYLLABLE JUOXYI SYLL" +
	"ABLE JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SYLLABLE JOXYI SYLLABLE JOYI S" +
	"YLLABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI SYLLABLE JUYI SYLLABLE JUPYI" +
	" SYLLABLE JURXYI SYLLABLE JURYI SYLLABLE JYTYI SYLLABLE JYXYI SYLLABLE J" +
	"YYI SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE JYRYI SYLLABLE QITYI SYLLABL" +
	"E QIXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABLE QIETYI SYLLABLE QIEXYI SYL" +
	"LABLE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI SYLLABLE QUOXYI SYLLABLE QUO" +
	"YI SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE QOXYI SYLLABLE QOYI SYLLABLE " +
	"QOPYI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE QUYI SYLLABLE QUPYI SYLLABL" +
	"E QURXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLABLE QYXYI SYLLABLE QYYI SYLL" +
	"ABLE QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SYLLABLE JJITYI SYLLABLE JJIXY" +
	"I SYLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJIETYI SYLLABLE JJIEXYI SYLLA" +
	"BLE JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI SYLLABLE JJUOYI SYLLABLE JJ" +
	"UOPYI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLABLE JJOYI SYLLABLE JJOPYI SYL" +
	"LABLE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI SYLLABLE JJUPYI SYLLABLE JJU" +
	"RXYI SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABLE JJYXYI SYLLABLE JJYYI SYLL" +
	"ABLE JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI SYLLABLE NJIYI SYLLABLE NJIP" +
	"YI SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABLE NJIEYI SYLLABLE NJIEPYI SY" +
	"LLABLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOTYI SYLLABLE NJOXYI SYLLABLE " +
	"NJOYI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLABLE NJUYI SYLLABLE NJUPYI SYL" +
	"LABLE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTYI SYLLABLE NJYXYI SYLLABLE N" +
	"JYYI SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLABLE NJYRYI SYLLABLE NYITYI SY" +
	"LLABLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI SYLLABLE NYIETYI SYLLABLE N" +
	"YIEXYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLLABLE NYUOXYI SYLLABLE NYUOYI" +
	" SYLLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE NYOXYI SYLLABLE NYOYI SYLLABL" +
	"E NYOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYLLABLE NYUYI SYLLABLE NYUPYI " +
	"SYLLABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI SYLLABLE XIPYI SYLLABLE XIET" +
	"YI SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE XIEPYI SYLLABLE XUOXYI SYLLAB" +
	"LE XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLABLE XOYI SYLLABLE XOPYI SYLL" +
	"ABLE XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLLABLE XYPYI SYLLABLE XYRXYI S" +
	"YLLABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI SYLLABLE YIYI SYLLABLE YIPYI" +
	" SYLLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YIEYI SYLLABLE YIEPYI SYLLABLE" +
	" YUOTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLABLE YUOPYI SYLLABLE YOTYI SY" +
	"LLABLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SYLLABLE YUTYI SYLLABLE YUXYI " +
	"SYLLABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI SYLLABLE YURYI SYLLABLE YYT" +
	"YI SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYPYI SYLLABLE YYRXYI SYLLABLE " +
	"YYRYI RADICAL QOTYI RADICAL LIYI RADICAL KITYI RADICAL NYIPYI RADICAL CY" +
	"PYI RADICAL SSIYI RADICAL GGOPYI RADICAL GEPYI RADICAL MIYI RADICAL HXIT" +
	"YI RADICAL LYRYI RADICAL BBUTYI RADICAL MOPYI RADICAL YOYI RADICAL PUTYI" +
	" RADICAL HXUOYI RADICAL TATYI RADICAL GAYI RADICAL ZUPYI RADICAL CYTYI R" +
	"ADICAL DDURYI RADICAL BURYI RADICAL GGUOYI RADICAL NYOPYI RADICAL TUYI R" +
	"ADICAL OPYI RADICAL JJUTYI RADICAL ZOTYI RADICAL PYTYI RADICAL HMOYI RAD" +
	"ICAL YITYI RADICAL VURYI RADICAL SHYYI RADICAL VEPYI RADICAL ZAYI RADICA" +
	"L JOYI RADICAL NZUPYI RADICAL JJYYI RADICAL GOTYI RADICAL JJIEYI RADICAL" +
	" WOYI RADICAL DUYI RADICAL SHURYI RADICAL LIEYI RADICAL CYYI RADICAL CUO" +
	"PYI RADICAL CIPYI RADICAL HXOPYI RADICAL SHATYI RADICAL ZURYI RADICAL SH" +
	"OPYI RADICAL CHEYI RADICAL ZZIETYI RADICAL NBIEYI RADICAL KELISU LETTER " +
	"BALISU LETTER PALISU LETTER PHALISU LETTER DALISU LETTER TALISU LETTER T" +
	"HALISU LETTER GALISU LETTER KALISU LETTER KHALISU LETTER JALISU LETTER C" +
	"ALISU LETTER CHALISU LETTER DZALISU LETTER TSALISU LETTER TSHALISU LETTE" +
	"R MALISU LETTER NALISU LETTER LALISU LETTER SALISU LETTER ZHALISU LETTER" +
	" ZALISU LETTER NGALISU LETTER HALISU LETTER XALISU LETTER HHALISU LETTER" +
	" FALISU LETTER WALISU LETTER SHALISU LETTER YALISU LETTER GHALISU LETTER" +
	" ALISU LETTER AELISU LETTER ELISU LETTER EULISU LETTER ILISU LETTER OLIS" +
	"U LETTER ULISU LETTER UELISU LETTER UHLISU LETTER OELISU LETTER TONE MYA") + ("" +
	" TILISU LETTER TONE NA POLISU LETTER TONE MYA CYALISU LETTER TONE MYA BO" +
	"LISU LETTER TONE MYA NALISU LETTER TONE MYA JEULISU PUNCTUATION COMMALIS" +
	"U PUNCTUATION FULL STOPVAI SYLLABLE EEVAI SYLLABLE EENVAI SYLLABLE HEEVA" +
	"I SYLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE PEEVAI SYLLABLE BHEEVAI SYLL" +
	"ABLE BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVAI SYLLABLE MGBEEVAI SYLLABLE" +
	" GBEEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYLLABLE TEEVAI SYLLABLE THEEVA" +
	"I SYLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABLE LEEVAI SYLLABLE REEVAI SYL" +
	"LABLE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVAI SYLLABLE SHEEVAI SYLLABLE " +
	"ZEEVAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLLABLE JEEVAI SYLLABLE NJEEVAI" +
	" SYLLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NGGEEVAI SYLLABLE GEEVAI SYLLA" +
	"BLE MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI SYLLABLE IVAI SYLLABLE INVAI" +
	" SYLLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIVAI SYLLABLE WINVAI SYLLABLE " +
	"PIVAI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABLE MBIVAI SYLLABLE KPIVAI SYL" +
	"LABLE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI SYLLABLE VIVAI SYLLABLE TIV" +
	"AI SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE DHHIVAI SYLLABLE LIVAI SYLLA" +
	"BLE RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYLLABLE SIVAI SYLLABLE SHIVAI " +
	"SYLLABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVAI SYLLABLE JIVAI SYLLABLE NJ" +
	"IVAI SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE NGGIVAI SYLLABLE GIVAI SYLLA" +
	"BLE MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYLLABLE AVAI SYLLABLE ANVAI SY" +
	"LLABLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVAI SYLLABLE WAVAI SYLLABLE WA" +
	"NVAI SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE BAVAI SYLLABLE MBAVAI SYLLA" +
	"BLE KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI SYLLABLE GBAVAI SYLLABLE FA" +
	"VAI SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE THAVAI SYLLABLE DHAVAI SYLLAB" +
	"LE DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYLLABLE DAVAI SYLLABLE NDAVAI " +
	"SYLLABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVAI SYLLABLE ZHAVAI SYLLABLE C" +
	"AVAI SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE YAVAI SYLLABLE KAVAI SYLLAB" +
	"LE KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SYLLABLE MAVAI SYLLABLE NAVAI " +
	"SYLLABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONVAI SYLLABLE HOOVAI SYLLABLE " +
	"WOOVAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLLABLE BHOOVAI SYLLABLE BOOVAI" +
	" SYLLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE MGBOOVAI SYLLABLE GBOOVAI SY" +
	"LLABLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVAI SYLLABLE THOOVAI SYLLABLE " +
	"DHOOVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SYLLABLE ROOVAI SYLLABLE DOOVA" +
	"I SYLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE SHOOVAI SYLLABLE ZOOVAI SYLL" +
	"ABLE ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI SYLLABLE NJOOVAI SYLLABLE Y" +
	"OOVAI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLLABLE GOOVAI SYLLABLE MOOVAI " +
	"SYLLABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UVAI SYLLABLE UNVAI SYLLABLE H" +
	"UVAI SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE WUNVAI SYLLABLE PUVAI SYLLA" +
	"BLE BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SYLLABLE KPUVAI SYLLABLE MGBUV" +
	"AI SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE VUVAI SYLLABLE TUVAI SYLLABLE" +
	" THUVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYLLABLE LUVAI SYLLABLE RUVAI S" +
	"YLLABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI SYLLABLE SHUVAI SYLLABLE ZU" +
	"VAI SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE JUVAI SYLLABLE NJUVAI SYLLAB" +
	"LE YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYLLABLE GUVAI SYLLABLE MUVAI S" +
	"YLLABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI SYLLABLE ONVAI SYLLABLE NGON" +
	"VAI SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE WOVAI SYLLABLE WONVAI SYLLAB" +
	"LE POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLLABLE MBOVAI SYLLABLE KPOVAI " +
	"SYLLABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GBONVAI SYLLABLE FOVAI SYLLABL" +
	"E VOVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLABLE DHOVAI SYLLABLE DHHOVAI " +
	"SYLLABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI SYLLABLE NDOVAI SYLLABLE SO" +
	"VAI SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE ZHOVAI SYLLABLE COVAI SYLLAB" +
	"LE JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLLABLE KOVAI SYLLABLE NGGOVAI " +
	"SYLLABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI SYLLABLE NYOVAI SYLLABLE EV" +
	"AI SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE HEVAI SYLLABLE HENVAI SYLLAB" +
	"LE WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLLABLE BHEVAI SYLLABLE BEVAI S" +
	"YLLABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPENVAI SYLLABLE MGBEVAI SYLLABL" +
	"E GBEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYLLABLE VEVAI SYLLABLE TEVAI S" +
	"YLLABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHEVAI SYLLABLE LEVAI SYLLABLE " +
	"REVAI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABLE SEVAI SYLLABLE SHEVAI SYLL" +
	"ABLE ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SYLLABLE JEVAI SYLLABLE NJEVAI" +
	" SYLLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGEVAI SYLLABLE NGGENVAI SYLLAB" +
	"LE GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLLABLE NEVAI SYLLABLE NYEVAI S" +
	"YLLABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVAI FULL STOPVAI QUESTION MARK" +
	"VAI SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVAI SYLLABLE NDOLE SOOVAI SYMB" +
	"OL FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI SYMBOL NIIVAI SYMBOL BANGVAI ") + ("" +
	"SYMBOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI SYMBOL DOONGVAI SYMBOL KUNGVA" +
	"I SYMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGVAI DIGIT ZEROVAI DIGIT ONEVA" +
	"I DIGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI DIGIT FIVEVAI DIGIT SIXVAI D" +
	"IGIT SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI SYLLABLE NDOLE MAVAI SYLLABLE" +
	" NDOLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRILLIC SMALL LETTER ZEMLYACYRIL" +
	"LIC CAPITAL LETTER DZELOCYRILLIC SMALL LETTER DZELOCYRILLIC CAPITAL LETT" +
	"ER REVERSED DZECYRILLIC SMALL LETTER REVERSED DZECYRILLIC CAPITAL LETTER" +
	" IOTACYRILLIC SMALL LETTER IOTACYRILLIC CAPITAL LETTER DJERVCYRILLIC SMA" +
	"LL LETTER DJERVCYRILLIC CAPITAL LETTER MONOGRAPH UKCYRILLIC SMALL LETTER" +
	" MONOGRAPH UKCYRILLIC CAPITAL LETTER BROAD OMEGACYRILLIC SMALL LETTER BR" +
	"OAD OMEGACYRILLIC CAPITAL LETTER NEUTRAL YERCYRILLIC SMALL LETTER NEUTRA" +
	"L YERCYRILLIC CAPITAL LETTER YERU WITH BACK YERCYRILLIC SMALL LETTER YER" +
	"U WITH BACK YERCYRILLIC CAPITAL LETTER IOTIFIED YATCYRILLIC SMALL LETTER" +
	" IOTIFIED YATCYRILLIC CAPITAL LETTER REVERSED YUCYRILLIC SMALL LETTER RE" +
	"VERSED YUCYRILLIC CAPITAL LETTER IOTIFIED ACYRILLIC SMALL LETTER IOTIFIE" +
	"D ACYRILLIC CAPITAL LETTER CLOSED LITTLE YUSCYRILLIC SMALL LETTER CLOSED" +
	" LITTLE YUSCYRILLIC CAPITAL LETTER BLENDED YUSCYRILLIC SMALL LETTER BLEN" +
	"DED YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC SMALL " +
	"LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER YNCYRILLIC SMAL" +
	"L LETTER YNCYRILLIC CAPITAL LETTER REVERSED TSECYRILLIC SMALL LETTER REV" +
	"ERSED TSECYRILLIC CAPITAL LETTER SOFT DECYRILLIC SMALL LETTER SOFT DECYR" +
	"ILLIC CAPITAL LETTER SOFT ELCYRILLIC SMALL LETTER SOFT ELCYRILLIC CAPITA" +
	"L LETTER SOFT EMCYRILLIC SMALL LETTER SOFT EMCYRILLIC CAPITAL LETTER MON" +
	"OCULAR OCYRILLIC SMALL LETTER MONOCULAR OCYRILLIC CAPITAL LETTER BINOCUL" +
	"AR OCYRILLIC SMALL LETTER BINOCULAR OCYRILLIC CAPITAL LETTER DOUBLE MONO" +
	"CULAR OCYRILLIC SMALL LETTER DOUBLE MONOCULAR OCYRILLIC LETTER MULTIOCUL" +
	"AR OCOMBINING CYRILLIC VZMETCOMBINING CYRILLIC TEN MILLIONS SIGNCOMBININ" +
	"G CYRILLIC HUNDRED MILLIONS SIGNCOMBINING CYRILLIC THOUSAND MILLIONS SIG" +
	"NSLAVONIC ASTERISKCOMBINING CYRILLIC LETTER UKRAINIAN IECOMBINING CYRILL" +
	"IC LETTER ICOMBINING CYRILLIC LETTER YICOMBINING CYRILLIC LETTER UCOMBIN" +
	"ING CYRILLIC LETTER HARD SIGNCOMBINING CYRILLIC LETTER YERUCOMBINING CYR" +
	"ILLIC LETTER SOFT SIGNCOMBINING CYRILLIC LETTER OMEGACOMBINING CYRILLIC " +
	"KAVYKACOMBINING CYRILLIC PAYEROKCYRILLIC KAVYKACYRILLIC PAYEROKCYRILLIC " +
	"CAPITAL LETTER DWECYRILLIC SMALL LETTER DWECYRILLIC CAPITAL LETTER DZWEC" +
	"YRILLIC SMALL LETTER DZWECYRILLIC CAPITAL LETTER ZHWECYRILLIC SMALL LETT" +
	"ER ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC SMALL LETTER CCHECYRILLIC CA" +
	"PITAL LETTER DZZECYRILLIC SMALL LETTER DZZECYRILLIC CAPITAL LETTER TE WI" +
	"TH MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH MIDDLE HOOKCYRILLIC CAPITAL " +
	"LETTER TWECYRILLIC SMALL LETTER TWECYRILLIC CAPITAL LETTER TSWECYRILLIC " +
	"SMALL LETTER TSWECYRILLIC CAPITAL LETTER TSSECYRILLIC SMALL LETTER TSSEC" +
	"YRILLIC CAPITAL LETTER TCHECYRILLIC SMALL LETTER TCHECYRILLIC CAPITAL LE" +
	"TTER HWECYRILLIC SMALL LETTER HWECYRILLIC CAPITAL LETTER SHWECYRILLIC SM" +
	"ALL LETTER SHWECYRILLIC CAPITAL LETTER DOUBLE OCYRILLIC SMALL LETTER DOU" +
	"BLE OCYRILLIC CAPITAL LETTER CROSSED OCYRILLIC SMALL LETTER CROSSED OMOD" +
	"IFIER LETTER CYRILLIC HARD SIGNMODIFIER LETTER CYRILLIC SOFT SIGNCOMBINI" +
	"NG CYRILLIC LETTER EFCOMBINING CYRILLIC LETTER IOTIFIED EBAMUM LETTER AB" +
	"AMUM LETTER KABAMUM LETTER UBAMUM LETTER KUBAMUM LETTER EEBAMUM LETTER R" +
	"EEBAMUM LETTER TAEBAMUM LETTER OBAMUM LETTER NYIBAMUM LETTER IBAMUM LETT" +
	"ER LABAMUM LETTER PABAMUM LETTER RIIBAMUM LETTER RIEEBAMUM LETTER LEEEEB" +
	"AMUM LETTER MEEEEBAMUM LETTER TAABAMUM LETTER NDAABAMUM LETTER NJAEMBAMU" +
	"M LETTER MBAMUM LETTER SUUBAMUM LETTER MUBAMUM LETTER SHIIBAMUM LETTER S" +
	"IBAMUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LETTER KYEEBAMUM LETTER KETBAM" +
	"UM LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJUAEBAMUM LETTER YOQBAMUM LET" +
	"TER SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM LETTER NSHABAMUM LETTER KEUX" +
	"BAMUM LETTER PEUXBAMUM LETTER NJEEBAMUM LETTER NTEEBAMUM LETTER PUEBAMUM" +
	" LETTER WUEBAMUM LETTER PEEBAMUM LETTER FEEBAMUM LETTER RUBAMUM LETTER L" +
	"UBAMUM LETTER MIBAMUM LETTER NIBAMUM LETTER REUXBAMUM LETTER RAEBAMUM LE" +
	"TTER KENBAMUM LETTER NGKWAENBAMUM LETTER NGGABAMUM LETTER NGABAMUM LETTE" +
	"R SHOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM LETTER FOMBAMUM LETTER WABAMU" +
	"M LETTER NABAMUM LETTER LIBAMUM LETTER PIBAMUM LETTER LOQBAMUM LETTER KO" +
	"BAMUM LETTER MBENBAMUM LETTER RENBAMUM LETTER MENBAMUM LETTER MABAMUM LE" +
	"TTER TIBAMUM LETTER KIBAMUM LETTER MOBAMUM LETTER MBAABAMUM LETTER TETBA" +
	"MUM LETTER KPABAMUM LETTER TENBAMUM LETTER NTUUBAMUM LETTER SAMBABAMUM L" +
	"ETTER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER KOGHOMBAMUM COMBINING MARK KO") + ("" +
	"QNDONBAMUM COMBINING MARK TUKWENTISBAMUM NJAEMLIBAMUM FULL STOPBAMUM COL" +
	"ONBAMUM COMMABAMUM SEMICOLONBAMUM QUESTION MARKMODIFIER LETTER CHINESE T" +
	"ONE YIN PINGMODIFIER LETTER CHINESE TONE YANG PINGMODIFIER LETTER CHINES" +
	"E TONE YIN SHANGMODIFIER LETTER CHINESE TONE YANG SHANGMODIFIER LETTER C" +
	"HINESE TONE YIN QUMODIFIER LETTER CHINESE TONE YANG QUMODIFIER LETTER CH" +
	"INESE TONE YIN RUMODIFIER LETTER CHINESE TONE YANG RUMODIFIER LETTER EXT" +
	"RA-HIGH DOTTED TONE BARMODIFIER LETTER HIGH DOTTED TONE BARMODIFIER LETT" +
	"ER MID DOTTED TONE BARMODIFIER LETTER LOW DOTTED TONE BARMODIFIER LETTER" +
	" EXTRA-LOW DOTTED TONE BARMODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TO" +
	"NE BARMODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BARMODIFIER LETTER MID " +
	"DOTTED LEFT-STEM TONE BARMODIFIER LETTER LOW DOTTED LEFT-STEM TONE BARMO" +
	"DIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BARMODIFIER LETTER EXTRA-H" +
	"IGH LEFT-STEM TONE BARMODIFIER LETTER HIGH LEFT-STEM TONE BARMODIFIER LE" +
	"TTER MID LEFT-STEM TONE BARMODIFIER LETTER LOW LEFT-STEM TONE BARMODIFIE" +
	"R LETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIER LETTER DOT VERTICAL BARMOD" +
	"IFIER LETTER DOT SLASHMODIFIER LETTER DOT HORIZONTAL BARMODIFIER LETTER " +
	"LOWER RIGHT CORNER ANGLEMODIFIER LETTER RAISED UP ARROWMODIFIER LETTER R" +
	"AISED DOWN ARROWMODIFIER LETTER RAISED EXCLAMATION MARKMODIFIER LETTER R" +
	"AISED INVERTED EXCLAMATION MARKMODIFIER LETTER LOW INVERTED EXCLAMATION " +
	"MARKMODIFIER LETTER STRESS AND HIGH TONEMODIFIER LETTER STRESS AND LOW T" +
	"ONELATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLATIN SMALL LETTER EGYPTOLOGIC" +
	"AL ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AINLATIN SMALL LETTER EGYPTOLO" +
	"GICAL AINLATIN CAPITAL LETTER HENGLATIN SMALL LETTER HENGLATIN CAPITAL L" +
	"ETTER TZLATIN SMALL LETTER TZLATIN CAPITAL LETTER TRESILLOLATIN SMALL LE" +
	"TTER TRESILLOLATIN CAPITAL LETTER CUATRILLOLATIN SMALL LETTER CUATRILLOL" +
	"ATIN CAPITAL LETTER CUATRILLO WITH COMMALATIN SMALL LETTER CUATRILLO WIT" +
	"H COMMALATIN LETTER SMALL CAPITAL FLATIN LETTER SMALL CAPITAL SLATIN CAP" +
	"ITAL LETTER AALATIN SMALL LETTER AALATIN CAPITAL LETTER AOLATIN SMALL LE" +
	"TTER AOLATIN CAPITAL LETTER AULATIN SMALL LETTER AULATIN CAPITAL LETTER " +
	"AVLATIN SMALL LETTER AVLATIN CAPITAL LETTER AV WITH HORIZONTAL BARLATIN " +
	"SMALL LETTER AV WITH HORIZONTAL BARLATIN CAPITAL LETTER AYLATIN SMALL LE" +
	"TTER AYLATIN CAPITAL LETTER REVERSED C WITH DOTLATIN SMALL LETTER REVERS" +
	"ED C WITH DOTLATIN CAPITAL LETTER K WITH STROKELATIN SMALL LETTER K WITH" +
	" STROKELATIN CAPITAL LETTER K WITH DIAGONAL STROKELATIN SMALL LETTER K W" +
	"ITH DIAGONAL STROKELATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROK" +
	"ELATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKELATIN CAPITAL LETTE" +
	"R BROKEN LLATIN SMALL LETTER BROKEN LLATIN CAPITAL LETTER L WITH HIGH ST" +
	"ROKELATIN SMALL LETTER L WITH HIGH STROKELATIN CAPITAL LETTER O WITH LON" +
	"G STROKE OVERLAYLATIN SMALL LETTER O WITH LONG STROKE OVERLAYLATIN CAPIT" +
	"AL LETTER O WITH LOOPLATIN SMALL LETTER O WITH LOOPLATIN CAPITAL LETTER " +
	"OOLATIN SMALL LETTER OOLATIN CAPITAL LETTER P WITH STROKE THROUGH DESCEN" +
	"DERLATIN SMALL LETTER P WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTE" +
	"R P WITH FLOURISHLATIN SMALL LETTER P WITH FLOURISHLATIN CAPITAL LETTER " +
	"P WITH SQUIRREL TAILLATIN SMALL LETTER P WITH SQUIRREL TAILLATIN CAPITAL" +
	" LETTER Q WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER Q WITH STROKE " +
	"THROUGH DESCENDERLATIN CAPITAL LETTER Q WITH DIAGONAL STROKELATIN SMALL " +
	"LETTER Q WITH DIAGONAL STROKELATIN CAPITAL LETTER R ROTUNDALATIN SMALL L" +
	"ETTER R ROTUNDALATIN CAPITAL LETTER RUM ROTUNDALATIN SMALL LETTER RUM RO" +
	"TUNDALATIN CAPITAL LETTER V WITH DIAGONAL STROKELATIN SMALL LETTER V WIT" +
	"H DIAGONAL STROKELATIN CAPITAL LETTER VYLATIN SMALL LETTER VYLATIN CAPIT" +
	"AL LETTER VISIGOTHIC ZLATIN SMALL LETTER VISIGOTHIC ZLATIN CAPITAL LETTE" +
	"R THORN WITH STROKELATIN SMALL LETTER THORN WITH STROKELATIN CAPITAL LET" +
	"TER THORN WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER THORN WITH STR" +
	"OKE THROUGH DESCENDERLATIN CAPITAL LETTER VENDLATIN SMALL LETTER VENDLAT" +
	"IN CAPITAL LETTER ETLATIN SMALL LETTER ETLATIN CAPITAL LETTER ISLATIN SM" +
	"ALL LETTER ISLATIN CAPITAL LETTER CONLATIN SMALL LETTER CONMODIFIER LETT" +
	"ER USLATIN SMALL LETTER DUMLATIN SMALL LETTER LUMLATIN SMALL LETTER MUML" +
	"ATIN SMALL LETTER NUMLATIN SMALL LETTER RUMLATIN LETTER SMALL CAPITAL RU" +
	"MLATIN SMALL LETTER TUMLATIN SMALL LETTER UMLATIN CAPITAL LETTER INSULAR" +
	" DLATIN SMALL LETTER INSULAR DLATIN CAPITAL LETTER INSULAR FLATIN SMALL " +
	"LETTER INSULAR FLATIN CAPITAL LETTER INSULAR GLATIN CAPITAL LETTER TURNE" +
	"D INSULAR GLATIN SMALL LETTER TURNED INSULAR GLATIN CAPITAL LETTER TURNE" +
	"D LLATIN SMALL LETTER TURNED LLATIN CAPITAL LETTER INSULAR RLATIN SMALL " +
	"LETTER INSULAR RLATIN CAPITAL LETTER INSULAR SLATIN SMALL LETTER INSULAR") + ("" +
	" SLATIN CAPITAL LETTER INSULAR TLATIN SMALL LETTER INSULAR TMODIFIER LET" +
	"TER LOW CIRCUMFLEX ACCENTMODIFIER LETTER COLONMODIFIER LETTER SHORT EQUA" +
	"LS SIGNLATIN CAPITAL LETTER SALTILLOLATIN SMALL LETTER SALTILLOLATIN CAP" +
	"ITAL LETTER TURNED HLATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELTLAT" +
	"IN LETTER SINOLOGICAL DOTLATIN CAPITAL LETTER N WITH DESCENDERLATIN SMAL" +
	"L LETTER N WITH DESCENDERLATIN CAPITAL LETTER C WITH BARLATIN SMALL LETT" +
	"ER C WITH BARLATIN SMALL LETTER C WITH PALATAL HOOKLATIN SMALL LETTER H " +
	"WITH PALATAL HOOKLATIN CAPITAL LETTER B WITH FLOURISHLATIN SMALL LETTER " +
	"B WITH FLOURISHLATIN CAPITAL LETTER F WITH STROKELATIN SMALL LETTER F WI" +
	"TH STROKELATIN CAPITAL LETTER VOLAPUK AELATIN SMALL LETTER VOLAPUK AELAT" +
	"IN CAPITAL LETTER VOLAPUK OELATIN SMALL LETTER VOLAPUK OELATIN CAPITAL L" +
	"ETTER VOLAPUK UELATIN SMALL LETTER VOLAPUK UELATIN CAPITAL LETTER G WITH" +
	" OBLIQUE STROKELATIN SMALL LETTER G WITH OBLIQUE STROKELATIN CAPITAL LET" +
	"TER K WITH OBLIQUE STROKELATIN SMALL LETTER K WITH OBLIQUE STROKELATIN C" +
	"APITAL LETTER N WITH OBLIQUE STROKELATIN SMALL LETTER N WITH OBLIQUE STR" +
	"OKELATIN CAPITAL LETTER R WITH OBLIQUE STROKELATIN SMALL LETTER R WITH O" +
	"BLIQUE STROKELATIN CAPITAL LETTER S WITH OBLIQUE STROKELATIN SMALL LETTE" +
	"R S WITH OBLIQUE STROKELATIN CAPITAL LETTER H WITH HOOKLATIN CAPITAL LET" +
	"TER REVERSED OPEN ELATIN CAPITAL LETTER SCRIPT GLATIN CAPITAL LETTER L W" +
	"ITH BELTLATIN CAPITAL LETTER SMALL CAPITAL ILATIN CAPITAL LETTER TURNED " +
	"KLATIN CAPITAL LETTER TURNED TLATIN CAPITAL LETTER J WITH CROSSED-TAILLA" +
	"TIN CAPITAL LETTER CHILATIN CAPITAL LETTER BETALATIN SMALL LETTER BETALA" +
	"TIN CAPITAL LETTER OMEGALATIN SMALL LETTER OMEGALATIN EPIGRAPHIC LETTER " +
	"SIDEWAYS IMODIFIER LETTER CAPITAL H WITH STROKEMODIFIER LETTER SMALL LIG" +
	"ATURE OELATIN LETTER SMALL CAPITAL TURNED MLATIN EPIGRAPHIC LETTER REVER" +
	"SED FLATIN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPHIC LETTER INVERTED " +
	"MLATIN EPIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETTER ARCHAIC MSYLOTI " +
	"NAGRI LETTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN DVISVARASYLOTI NAGR" +
	"I LETTER USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OSYLOTI NAGRI SIGN HA" +
	"SANTASYLOTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYLOTI NAGRI LETTER GO" +
	"SYLOTI NAGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLOTI NAGRI LETTER COS" +
	"YLOTI NAGRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NAGRI LETTER JHOSYLOT" +
	"I NAGRI LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGRI LETTER DDOSYLOTI " +
	"NAGRI LETTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI LETTER THOSYLOTI NAG" +
	"RI LETTER DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTER NOSYLOTI NAGRI LE" +
	"TTER POSYLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI LETTER " +
	"BHOSYLOTI NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI NAGRI LETTER LOSYL" +
	"OTI NAGRI LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGRI LETTER HOSYLOTI N" +
	"AGRI VOWEL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIGN USYLOT" +
	"I NAGRI VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI NAGRI POETRY MARK-1" +
	"SYLOTI NAGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI POETRY " +
	"MARK-4NORTH INDIC FRACTION ONE QUARTERNORTH INDIC FRACTION ONE HALFNORTH" +
	" INDIC FRACTION THREE QUARTERSNORTH INDIC FRACTION ONE SIXTEENTHNORTH IN" +
	"DIC FRACTION ONE EIGHTHNORTH INDIC FRACTION THREE SIXTEENTHSNORTH INDIC " +
	"QUARTER MARKNORTH INDIC PLACEHOLDER MARKNORTH INDIC RUPEE MARKNORTH INDI" +
	"C QUANTITY MARKPHAGS-PA LETTER KAPHAGS-PA LETTER KHAPHAGS-PA LETTER GAPH" +
	"AGS-PA LETTER NGAPHAGS-PA LETTER CAPHAGS-PA LETTER CHAPHAGS-PA LETTER JA" +
	"PHAGS-PA LETTER NYAPHAGS-PA LETTER TAPHAGS-PA LETTER THAPHAGS-PA LETTER " +
	"DAPHAGS-PA LETTER NAPHAGS-PA LETTER PAPHAGS-PA LETTER PHAPHAGS-PA LETTER" +
	" BAPHAGS-PA LETTER MAPHAGS-PA LETTER TSAPHAGS-PA LETTER TSHAPHAGS-PA LET" +
	"TER DZAPHAGS-PA LETTER WAPHAGS-PA LETTER ZHAPHAGS-PA LETTER ZAPHAGS-PA L" +
	"ETTER SMALL APHAGS-PA LETTER YAPHAGS-PA LETTER RAPHAGS-PA LETTER LAPHAGS" +
	"-PA LETTER SHAPHAGS-PA LETTER SAPHAGS-PA LETTER HAPHAGS-PA LETTER APHAGS" +
	"-PA LETTER IPHAGS-PA LETTER UPHAGS-PA LETTER EPHAGS-PA LETTER OPHAGS-PA " +
	"LETTER QAPHAGS-PA LETTER XAPHAGS-PA LETTER FAPHAGS-PA LETTER GGAPHAGS-PA" +
	" LETTER EEPHAGS-PA SUBJOINED LETTER WAPHAGS-PA SUBJOINED LETTER YAPHAGS-" +
	"PA LETTER TTAPHAGS-PA LETTER TTHAPHAGS-PA LETTER DDAPHAGS-PA LETTER NNAP" +
	"HAGS-PA LETTER ALTERNATE YAPHAGS-PA LETTER VOICELESS SHAPHAGS-PA LETTER " +
	"VOICED HAPHAGS-PA LETTER ASPIRATED FAPHAGS-PA SUBJOINED LETTER RAPHAGS-P" +
	"A SUPERFIXED LETTER RAPHAGS-PA LETTER CANDRABINDUPHAGS-PA SINGLE HEAD MA" +
	"RKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA MARK SHADPHAGS-PA MARK DOUBLE SHADSA" +
	"URASHTRA SIGN ANUSVARASAURASHTRA SIGN VISARGASAURASHTRA LETTER ASAURASHT" +
	"RA LETTER AASAURASHTRA LETTER ISAURASHTRA LETTER IISAURASHTRA LETTER USA" +
	"URASHTRA LETTER UUSAURASHTRA LETTER VOCALIC RSAURASHTRA LETTER VOCALIC R") + ("" +
	"RSAURASHTRA LETTER VOCALIC LSAURASHTRA LETTER VOCALIC LLSAURASHTRA LETTE" +
	"R ESAURASHTRA LETTER EESAURASHTRA LETTER AISAURASHTRA LETTER OSAURASHTRA" +
	" LETTER OOSAURASHTRA LETTER AUSAURASHTRA LETTER KASAURASHTRA LETTER KHAS" +
	"AURASHTRA LETTER GASAURASHTRA LETTER GHASAURASHTRA LETTER NGASAURASHTRA " +
	"LETTER CASAURASHTRA LETTER CHASAURASHTRA LETTER JASAURASHTRA LETTER JHAS" +
	"AURASHTRA LETTER NYASAURASHTRA LETTER TTASAURASHTRA LETTER TTHASAURASHTR" +
	"A LETTER DDASAURASHTRA LETTER DDHASAURASHTRA LETTER NNASAURASHTRA LETTER" +
	" TASAURASHTRA LETTER THASAURASHTRA LETTER DASAURASHTRA LETTER DHASAURASH" +
	"TRA LETTER NASAURASHTRA LETTER PASAURASHTRA LETTER PHASAURASHTRA LETTER " +
	"BASAURASHTRA LETTER BHASAURASHTRA LETTER MASAURASHTRA LETTER YASAURASHTR" +
	"A LETTER RASAURASHTRA LETTER LASAURASHTRA LETTER VASAURASHTRA LETTER SHA" +
	"SAURASHTRA LETTER SSASAURASHTRA LETTER SASAURASHTRA LETTER HASAURASHTRA " +
	"LETTER LLASAURASHTRA CONSONANT SIGN HAARUSAURASHTRA VOWEL SIGN AASAURASH" +
	"TRA VOWEL SIGN ISAURASHTRA VOWEL SIGN IISAURASHTRA VOWEL SIGN USAURASHTR" +
	"A VOWEL SIGN UUSAURASHTRA VOWEL SIGN VOCALIC RSAURASHTRA VOWEL SIGN VOCA" +
	"LIC RRSAURASHTRA VOWEL SIGN VOCALIC LSAURASHTRA VOWEL SIGN VOCALIC LLSAU" +
	"RASHTRA VOWEL SIGN ESAURASHTRA VOWEL SIGN EESAURASHTRA VOWEL SIGN AISAUR" +
	"ASHTRA VOWEL SIGN OSAURASHTRA VOWEL SIGN OOSAURASHTRA VOWEL SIGN AUSAURA" +
	"SHTRA SIGN VIRAMASAURASHTRA SIGN CANDRABINDUSAURASHTRA DANDASAURASHTRA D" +
	"OUBLE DANDASAURASHTRA DIGIT ZEROSAURASHTRA DIGIT ONESAURASHTRA DIGIT TWO" +
	"SAURASHTRA DIGIT THREESAURASHTRA DIGIT FOURSAURASHTRA DIGIT FIVESAURASHT" +
	"RA DIGIT SIXSAURASHTRA DIGIT SEVENSAURASHTRA DIGIT EIGHTSAURASHTRA DIGIT" +
	" NINECOMBINING DEVANAGARI DIGIT ZEROCOMBINING DEVANAGARI DIGIT ONECOMBIN" +
	"ING DEVANAGARI DIGIT TWOCOMBINING DEVANAGARI DIGIT THREECOMBINING DEVANA" +
	"GARI DIGIT FOURCOMBINING DEVANAGARI DIGIT FIVECOMBINING DEVANAGARI DIGIT" +
	" SIXCOMBINING DEVANAGARI DIGIT SEVENCOMBINING DEVANAGARI DIGIT EIGHTCOMB" +
	"INING DEVANAGARI DIGIT NINECOMBINING DEVANAGARI LETTER ACOMBINING DEVANA" +
	"GARI LETTER UCOMBINING DEVANAGARI LETTER KACOMBINING DEVANAGARI LETTER N" +
	"ACOMBINING DEVANAGARI LETTER PACOMBINING DEVANAGARI LETTER RACOMBINING D" +
	"EVANAGARI LETTER VICOMBINING DEVANAGARI SIGN AVAGRAHADEVANAGARI SIGN SPA" +
	"CING CANDRABINDUDEVANAGARI SIGN CANDRABINDU VIRAMADEVANAGARI SIGN DOUBLE" +
	" CANDRABINDU VIRAMADEVANAGARI SIGN CANDRABINDU TWODEVANAGARI SIGN CANDRA" +
	"BINDU THREEDEVANAGARI SIGN CANDRABINDU AVAGRAHADEVANAGARI SIGN PUSHPIKAD" +
	"EVANAGARI GAP FILLERDEVANAGARI CARETDEVANAGARI HEADSTROKEDEVANAGARI SIGN" +
	" SIDDHAMDEVANAGARI JAIN OMKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEKAYAH LI " +
	"DIGIT TWOKAYAH LI DIGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT FIVEKAYAH" +
	" LI DIGIT SIXKAYAH LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DIGIT NINE" +
	"KAYAH LI LETTER KAKAYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI LETTER N" +
	"GAKAYAH LI LETTER SAKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH LI LETTER" +
	" NYAKAYAH LI LETTER TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH LI LETT" +
	"ER PAKAYAH LI LETTER PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYAH LI LET" +
	"TER BAKAYAH LI LETTER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYAH LI LET" +
	"TER WAKAYAH LI LETTER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAYAH LI LE" +
	"TTER CAKAYAH LI LETTER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH LI LETT" +
	"ER OOKAYAH LI VOWEL UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI VOWEL EEK" +
	"AYAH LI VOWEL OKAYAH LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI TONE CALY" +
	"A PLOPHUKAYAH LI SIGN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJANG LETTER" +
	" GAREJANG LETTER NGAREJANG LETTER TAREJANG LETTER DAREJANG LETTER NAREJA" +
	"NG LETTER PAREJANG LETTER BAREJANG LETTER MAREJANG LETTER CAREJANG LETTE" +
	"R JAREJANG LETTER NYAREJANG LETTER SAREJANG LETTER RAREJANG LETTER LAREJ" +
	"ANG LETTER YAREJANG LETTER WAREJANG LETTER HAREJANG LETTER MBAREJANG LET" +
	"TER NGGAREJANG LETTER NDAREJANG LETTER NYJAREJANG LETTER AREJANG VOWEL S" +
	"IGN IREJANG VOWEL SIGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIREJANG VO" +
	"WEL SIGN OREJANG VOWEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL SIGN EARE" +
	"JANG CONSONANT SIGN NGREJANG CONSONANT SIGN NREJANG CONSONANT SIGN RREJA" +
	"NG CONSONANT SIGN HREJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEONG TIKEU" +
	"T-MIEUMHANGUL CHOSEONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHANGUL CHO" +
	"SEONG TIKEUT-CIEUCHANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RIEUL-SSAN" +
	"GKIYEOKHANGUL CHOSEONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTIKEUTHANG" +
	"UL CHOSEONG RIEUL-MIEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEONG RIEUL-" +
	"SSANGPIEUPHANGUL CHOSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIEUL-SIOSH" +
	"ANGUL CHOSEONG RIEUL-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CHOSEONG M" +
	"IEUM-KIYEOKHANGUL CHOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIOSHANGUL " +
	"CHOSEONG PIEUP-SIOS-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL CHOSEONG ") + ("" +
	"PIEUP-HIEUHHANGUL CHOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-RIEULHAN" +
	"GUL CHOSEONG IEUNG-HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL CHOSEONG " +
	"SSANGTHIEUTHHANGUL CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-SIOSHANGU" +
	"L CHOSEONG SSANGYEORINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN CECAKJAV" +
	"ANESE SIGN LAYARJAVANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE LETTER I " +
	"KAWIJAVANESE LETTER IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE LETTER " +
	"PA CEREKJAVANESE LETTER NGA LELETJAVANESE LETTER NGA LELET RASWADIJAVANE" +
	"SE LETTER EJAVANESE LETTER AIJAVANESE LETTER OJAVANESE LETTER KAJAVANESE" +
	" LETTER KA SASAKJAVANESE LETTER KA MURDAJAVANESE LETTER GAJAVANESE LETTE" +
	"R GA MURDAJAVANESE LETTER NGAJAVANESE LETTER CAJAVANESE LETTER CA MURDAJ" +
	"AVANESE LETTER JAJAVANESE LETTER NYA MURDAJAVANESE LETTER JA MAHAPRANAJA" +
	"VANESE LETTER NYAJAVANESE LETTER TTAJAVANESE LETTER TTA MAHAPRANAJAVANES" +
	"E LETTER DDAJAVANESE LETTER DDA MAHAPRANAJAVANESE LETTER NA MURDAJAVANES" +
	"E LETTER TAJAVANESE LETTER TA MURDAJAVANESE LETTER DAJAVANESE LETTER DA " +
	"MAHAPRANAJAVANESE LETTER NAJAVANESE LETTER PAJAVANESE LETTER PA MURDAJAV" +
	"ANESE LETTER BAJAVANESE LETTER BA MURDAJAVANESE LETTER MAJAVANESE LETTER" +
	" YAJAVANESE LETTER RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJAVANESE " +
	"LETTER WAJAVANESE LETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAVANESE LE" +
	"TTER SAJAVANESE LETTER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL SIGN TAR" +
	"UNGJAVANESE VOWEL SIGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VOWEL SIGN" +
	" WULU MELIKJAVANESE VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MENDUTJAVANE" +
	"SE VOWEL SIGN TALINGJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL SIGN PE" +
	"PETJAVANESE CONSONANT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJAVANESE " +
	"CONSONANT SIGN CAKRAJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVANESE RIGH" +
	"T RERENGGANJAVANESE PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA LUHURJAVA" +
	"NESE PADA WINDUJAVANESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE PADA LU" +
	"NGSIJAVANESE PADA ADEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISELEHJAVANE" +
	"SE TURNED PADA PISELEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAVANESE DI" +
	"GIT ONEJAVANESE DIGIT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOURJAVANESE" +
	" DIGIT FIVEJAVANESE DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT EIGHTJAV" +
	"ANESE DIGIT NINEJAVANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-ISENMYANMA" +
	"R LETTER SHAN GHAMYANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAMYANMAR L" +
	"ETTER SHAN NNAMYANMAR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMAR MODIFI" +
	"ER LETTER SHAN REDUPLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR LETTER T" +
	"AI LAING FAMYANMAR LETTER TAI LAING GAMYANMAR LETTER TAI LAING GHAMYANMA" +
	"R LETTER TAI LAING JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER TAI LAIN" +
	"G DDAMYANMAR LETTER TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMYANMAR TA" +
	"I LAING DIGIT ZEROMYANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING DIGIT TWO" +
	"MYANMAR TAI LAING DIGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR TAI LAI" +
	"NG DIGIT FIVEMYANMAR TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT SEVENMYA" +
	"NMAR TAI LAING DIGIT EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LETTER TAI" +
	" LAING LLAMYANMAR LETTER TAI LAING DAMYANMAR LETTER TAI LAING DHAMYANMAR" +
	" LETTER TAI LAING BAMYANMAR LETTER TAI LAING BHACHAM LETTER ACHAM LETTER" +
	" ICHAM LETTER UCHAM LETTER ECHAM LETTER AICHAM LETTER OCHAM LETTER KACHA" +
	"M LETTER KHACHAM LETTER GACHAM LETTER GHACHAM LETTER NGUECHAM LETTER NGA" +
	"CHAM LETTER CHACHAM LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM LETTER " +
	"NHUECHAM LETTER NHACHAM LETTER NHJACHAM LETTER TACHAM LETTER THACHAM LET" +
	"TER DACHAM LETTER DHACHAM LETTER NUECHAM LETTER NACHAM LETTER DDACHAM LE" +
	"TTER PACHAM LETTER PPACHAM LETTER PHACHAM LETTER BACHAM LETTER BHACHAM L" +
	"ETTER MUECHAM LETTER MACHAM LETTER BBACHAM LETTER YACHAM LETTER RACHAM L" +
	"ETTER LACHAM LETTER VACHAM LETTER SSACHAM LETTER SACHAM LETTER HACHAM VO" +
	"WEL SIGN AACHAM VOWEL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EICHAM VOW" +
	"EL SIGN UCHAM VOWEL SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICHAM VOWEL" +
	" SIGN AUCHAM VOWEL SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT SIGN RACH" +
	"AM CONSONANT SIGN LACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHAM LETTER" +
	" FINAL GCHAM LETTER FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LETTER FINA" +
	"L CHCHAM LETTER FINAL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHAM LETTER" +
	" FINAL YCHAM LETTER FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL SSCHAM C" +
	"ONSONANT SIGN FINAL MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROCHAM DIGI" +
	"T ONECHAM DIGIT TWOCHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIVECHAM DI" +
	"GIT SIXCHAM DIGIT SEVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCTUATION S" +
	"PIRALCHAM PUNCTUATION DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUNCTUATION" +
	" TRIPLE DANDAMYANMAR LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYANMAR LET" +
	"TER KHAMTI CHAMYANMAR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAMYANMAR L") + ("" +
	"ETTER KHAMTI NYAMYANMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI TTHAMYANM" +
	"AR LETTER KHAMTI DDAMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHAMTI DHAM" +
	"YANMAR LETTER KHAMTI NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KHAMTI HAM" +
	"YANMAR LETTER KHAMTI HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER LETTER " +
	"KHAMTI REDUPLICATIONMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMTI ZAMYAN" +
	"MAR LETTER KHAMTI RAMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM KHAMTI Q" +
	"NMYANMAR LOGOGRAM KHAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANMAR SYMBO" +
	"L AITON ONEMYANMAR SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMAR SIGN P" +
	"AO KAREN TONEMYANMAR SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING TONE-5M" +
	"YANMAR LETTER SHWE PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI VIET LE" +
	"TTER LOW KOTAI VIET LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIET LETTER" +
	" HIGH KHOTAI VIET LETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VIET LETTE" +
	"R LOW GOTAI VIET LETTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET LETTER HI" +
	"GH NGOTAI VIET LETTER LOW COTAI VIET LETTER HIGH COTAI VIET LETTER LOW C" +
	"HOTAI VIET LETTER HIGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER HIGH SOT" +
	"AI VIET LETTER LOW NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LOW DOTAI " +
	"VIET LETTER HIGH DOTAI VIET LETTER LOW TOTAI VIET LETTER HIGH TOTAI VIET" +
	" LETTER LOW THOTAI VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI VIET LE" +
	"TTER HIGH NOTAI VIET LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIET LETTER" +
	" LOW POTAI VIET LETTER HIGH POTAI VIET LETTER LOW PHOTAI VIET LETTER HIG" +
	"H PHOTAI VIET LETTER LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTER LOW MO" +
	"TAI VIET LETTER HIGH MOTAI VIET LETTER LOW YOTAI VIET LETTER HIGH YOTAI " +
	"VIET LETTER LOW ROTAI VIET LETTER HIGH ROTAI VIET LETTER LOW LOTAI VIET " +
	"LETTER HIGH LOTAI VIET LETTER LOW VOTAI VIET LETTER HIGH VOTAI VIET LETT" +
	"ER LOW HOTAI VIET LETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LETTER HIG" +
	"H OTAI VIET MAI KANGTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VOWEL UETA" +
	"I VIET VOWEL UTAI VIET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITTAI VIET " +
	"VOWEL IATAI VIET VOWEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI VIET VO" +
	"WEL AYTAI VIET VOWEL ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI VIET TON" +
	"E MAI NUENGTAI VIET TONE MAI THOTAI VIET TONE MAI SONGTAI VIET SYMBOL KO" +
	"NTAI VIET SYMBOL NUENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOITAI VIET " +
	"SYMBOL KOI KOIMEETEI MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI MAYEK LET" +
	"TER CHAMEETEI MAYEK LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYEK LETTER" +
	" TTHAMEETEI MAYEK LETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK LETTER " +
	"NNAMEETEI MAYEK LETTER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VOWEL SIGN" +
	" IIMEETEI MAYEK VOWEL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI MAYEK VOW" +
	"EL SIGN AUMEETEI MAYEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI MAYEK A" +
	"HANG KHUDAMMEETEI MAYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MARKMEETEI " +
	"MAYEK WORD REPETITION MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI MAYEK VI" +
	"RAMAETHIOPIC SYLLABLE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABLE TTHAAE" +
	"THIOPIC SYLLABLE TTHEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TTHOETHIOP" +
	"IC SYLLABLE DDHUETHIOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETHIOPIC SY" +
	"LLABLE DDHEEETHIOPIC SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC SYLLABL" +
	"E DZUETHIOPIC SYLLABLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABLE DZEEET" +
	"HIOPIC SYLLABLE DZEETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAETHIOPIC " +
	"SYLLABLE CCHHUETHIOPIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETHIOPIC SY" +
	"LLABLE CCHHEEETHIOPIC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIOPIC SYLL" +
	"ABLE BBAETHIOPIC SYLLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLABLE BBAA" +
	"ETHIOPIC SYLLABLE BBEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBOLATIN SM" +
	"ALL LETTER BARRED ALPHALATIN SMALL LETTER A REVERSED-SCHWALATIN SMALL LE" +
	"TTER BLACKLETTER ELATIN SMALL LETTER BARRED ELATIN SMALL LETTER E WITH F" +
	"LOURISHLATIN SMALL LETTER LENIS FLATIN SMALL LETTER SCRIPT G WITH CROSSE" +
	"D-TAILLATIN SMALL LETTER L WITH INVERTED LAZY SLATIN SMALL LETTER L WITH" +
	" DOUBLE MIDDLE TILDELATIN SMALL LETTER L WITH MIDDLE RINGLATIN SMALL LET" +
	"TER M WITH CROSSED-TAILLATIN SMALL LETTER N WITH CROSSED-TAILLATIN SMALL" +
	" LETTER ENG WITH CROSSED-TAILLATIN SMALL LETTER BLACKLETTER OLATIN SMALL" +
	" LETTER BLACKLETTER O WITH STROKELATIN SMALL LETTER OPEN O WITH STROKELA" +
	"TIN SMALL LETTER INVERTED OELATIN SMALL LETTER TURNED OE WITH STROKELATI" +
	"N SMALL LETTER TURNED OE WITH HORIZONTAL STROKELATIN SMALL LETTER TURNED" +
	" O OPEN-OLATIN SMALL LETTER TURNED O OPEN-O WITH STROKELATIN SMALL LETTE" +
	"R STIRRUP RLATIN LETTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMALL LETTER" +
	" R WITHOUT HANDLELATIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R WITH CR" +
	"OSSED-TAILLATIN SMALL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMALL LETTE" +
	"R SCRIPT RLATIN SMALL LETTER SCRIPT R WITH RINGLATIN SMALL LETTER BASELI") + ("" +
	"NE ESHLATIN SMALL LETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTER U BAR " +
	"WITH SHORT RIGHT LEGLATIN SMALL LETTER UILATIN SMALL LETTER TURNED UILAT" +
	"IN SMALL LETTER U WITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMALL LETTER" +
	" CHI WITH LOW RIGHT RINGLATIN SMALL LETTER CHI WITH LOW LEFT SERIFLATIN " +
	"SMALL LETTER X WITH LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG LEFT LE" +
	"GLATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN SMALL L" +
	"ETTER X WITH LONG LEFT LEG WITH SERIFLATIN SMALL LETTER Y WITH SHORT RIG" +
	"HT LEGMODIFIER BREVE WITH INVERTED BREVEMODIFIER LETTER SMALL HENGMODIFI" +
	"ER LETTER SMALL L WITH INVERTED LAZY SMODIFIER LETTER SMALL L WITH MIDDL" +
	"E TILDEMODIFIER LETTER SMALL U WITH LEFT HOOKLATIN SMALL LETTER SAKHA YA" +
	"TLATIN SMALL LETTER IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SMALL LETT" +
	"ER UOLATIN SMALL LETTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL OMEGACH" +
	"EROKEE SMALL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMALL LETTER ICHERO" +
	"KEE SMALL LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL LETTER VCHEROKEE" +
	" SMALL LETTER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LETTER GECHEROKEE" +
	" SMALL LETTER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LETTER GUCHEROKEE" +
	" SMALL LETTER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LETTER HECHEROKEE" +
	" SMALL LETTER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LETTER HUCHEROKEE" +
	" SMALL LETTER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LETTER LECHEROKEE" +
	" SMALL LETTER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LETTER LUCHEROKEE" +
	" SMALL LETTER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LETTER MECHEROKEE" +
	" SMALL LETTER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LETTER MUCHEROKEE" +
	" SMALL LETTER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL LETTER NAHCHEROK" +
	"EE SMALL LETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL LETTER NOCHEROK" +
	"EE SMALL LETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL LETTER QUACHERO" +
	"KEE SMALL LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMALL LETTER QUOCH" +
	"EROKEE SMALL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE SMALL LETTER SA" +
	"CHEROKEE SMALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE SMALL LETTER SIC" +
	"HEROKEE SMALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE SMALL LETTER SVC" +
	"HEROKEE SMALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE SMALL LETTER DEC" +
	"HEROKEE SMALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE SMALL LETTER TIC" +
	"HEROKEE SMALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE SMALL LETTER DVC" +
	"HEROKEE SMALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE SMALL LETTER T" +
	"LECHEROKEE SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHEROKEE SMALL LETTE" +
	"R TLUCHEROKEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACHEROKEE SMALL LE" +
	"TTER TSECHEROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TSOCHEROKEE SMALL" +
	" LETTER TSUCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER WACHEROKEE SMA" +
	"LL LETTER WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER WOCHEROKEE SMA" +
	"LL LETTER WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER YAMEETEI MAYEK" +
	" LETTER KOKMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAIMEETEI MAYEK LE" +
	"TTER MITMEETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETEI MAYEK LETTER " +
	"CHILMEETEI MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI MAYEK LETTER N" +
	"GOUMEETEI MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI MAYEK LETTER YA" +
	"NGMEETEI MAYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAYEK LETTER IMEET" +
	"EI MAYEK LETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK LETTER GOKMEET" +
	"EI MAYEK LETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK LETTER BAMEETEI " +
	"MAYEK LETTER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTER GHOUMEETEI MA" +
	"YEK LETTER DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTER KOK LONSUMMEE" +
	"TEI MAYEK LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUMMEETEI MAYEK LE" +
	"TTER PA LONSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK LETTER TIL LONSU" +
	"MMEETEI MAYEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LONSUMMEETEI MAYEK" +
	" VOWEL SIGN ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK VOWEL SIGN ANAP" +
	"MEETEI MAYEK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUNAPMEETEI MAYEK " +
	"VOWEL SIGN UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYEK VOWEL SIGN NU" +
	"NGMEETEI MAYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK APUN IYEKMEETEI" +
	" MAYEK DIGIT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT TWOMEETEI MAYE" +
	"K DIGIT THREEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FIVEMEETEI MAYEK " +
	"DIGIT SIXMEETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHTMEETEI MAYEK DI" +
	"GIT NINEHANGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGUL JUNGSEONG YO-" +
	"AHANGUL JUNGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGSEONG U-YEOHANGU" +
	"L JUNGSEONG U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG YU-OHANGUL JUNGS" +
	"EONG EU-AHANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGUL JUNGSEONG EU-" +
	"OHANGUL JUNGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNGSEONG I-YEOHANG" +
	"UL JUNGSEONG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I-YOHANGUL JUNGS") + ("" +
	"EONG I-YUHANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANGUL JUNGSEONG AR" +
	"AEA-EHANGUL JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-CHIEUCHHANGUL JO" +
	"NGSEONG SSANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANGUL JONGSEONG TI" +
	"KEUT-PIEUPHANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TIKEUT-SIOS-KIYEO" +
	"KHANGUL JONGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHIEUCHHANGUL JONG" +
	"SEONG TIKEUT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHANGUL JONGSEONG R" +
	"IEUL-KIYEOK-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGUL JONGSEONG RIE" +
	"UL-MIEUM-HIEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL JONGSEONG RIEUL-" +
	"PIEUP-PHIEUPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSEONG RIEUL-YEORI" +
	"NHIEUH-HIEUHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEONG MIEUM-NIEUNHA" +
	"NGUL JONGSEONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEUMHANGUL JONGSEO" +
	"NG MIEUM-PIEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JONGSEONG PIEUP-TI" +
	"KEUTHANGUL JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG PIEUP-MIEUMHANG" +
	"UL JONGSEONG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUTHANGUL JONGSEON" +
	"G PIEUP-CIEUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEONG SIOS-MIEUMHA" +
	"NGUL JONGSEONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSIOS-KIYEOKHANGUL" +
	" JONGSEONG SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSHANGUL JONGSEONG" +
	" SIOS-CIEUCHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG SIOS-THIEUTHHAN" +
	"GUL JONGSEONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHANGUL JONGSEONG P" +
	"ANSIOS-KAPYEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL JONGSEONG YESI" +
	"EUNG-HIEUHHANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CIEUC-SSANGPIEUPH" +
	"ANGUL JONGSEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHANGUL JONGSEONG " +
	"PHIEUPH-THIEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPATIBILITY IDEOGRA" +
	"PH-F901CJK COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY IDEOGRAPH-F903C" +
	"JK COMPATIBILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAPH-F905CJK COMPA" +
	"TIBILITY IDEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJK COMPATIBILITY" +
	" IDEOGRAPH-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPATIBILITY IDEOGRA" +
	"PH-F90ACJK COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY IDEOGRAPH-F90CC" +
	"JK COMPATIBILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAPH-F90ECJK COMPA" +
	"TIBILITY IDEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJK COMPATIBILITY" +
	" IDEOGRAPH-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPATIBILITY IDEOGRA" +
	"PH-F913CJK COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY IDEOGRAPH-F915C" +
	"JK COMPATIBILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAPH-F917CJK COMPA" +
	"TIBILITY IDEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJK COMPATIBILITY" +
	" IDEOGRAPH-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPATIBILITY IDEOGRA" +
	"PH-F91CCJK COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY IDEOGRAPH-F91EC" +
	"JK COMPATIBILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAPH-F920CJK COMPA" +
	"TIBILITY IDEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJK COMPATIBILITY" +
	" IDEOGRAPH-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPATIBILITY IDEOGRA" +
	"PH-F925CJK COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY IDEOGRAPH-F927C" +
	"JK COMPATIBILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAPH-F929CJK COMPA" +
	"TIBILITY IDEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJK COMPATIBILITY" +
	" IDEOGRAPH-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPATIBILITY IDEOGRA" +
	"PH-F92ECJK COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY IDEOGRAPH-F930C" +
	"JK COMPATIBILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAPH-F932CJK COMPA" +
	"TIBILITY IDEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJK COMPATIBILITY" +
	" IDEOGRAPH-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPATIBILITY IDEOGRA" +
	"PH-F937CJK COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY IDEOGRAPH-F939C" +
	"JK COMPATIBILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAPH-F93BCJK COMPA" +
	"TIBILITY IDEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJK COMPATIBILITY" +
	" IDEOGRAPH-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPATIBILITY IDEOGRA" +
	"PH-F940CJK COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY IDEOGRAPH-F942C" +
	"JK COMPATIBILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAPH-F944CJK COMPA" +
	"TIBILITY IDEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJK COMPATIBILITY" +
	" IDEOGRAPH-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPATIBILITY IDEOGRA" +
	"PH-F949CJK COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY IDEOGRAPH-F94BC" +
	"JK COMPATIBILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAPH-F94DCJK COMPA" +
	"TIBILITY IDEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJK COMPATIBILITY" +
	" IDEOGRAPH-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPATIBILITY IDEOGRA" +
	"PH-F952CJK COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY IDEOGRAPH-F954C" +
	"JK COMPATIBILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAPH-F956CJK COMPA" +
	"TIBILITY IDEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJK COMPATIBILITY" +
	" IDEOGRAPH-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPATIBILITY IDEOGRA" +
	"PH-F95BCJK COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY IDEOGRAPH-F95DC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAPH-F95FCJK COMPA" +
	"TIBILITY IDEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJK COMPATIBILITY" +
	" IDEOGRAPH-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPATIBILITY IDEOGRA" +
	"PH-F964CJK COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY IDEOGRAPH-F966C" +
	"JK COMPATIBILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAPH-F968CJK COMPA" +
	"TIBILITY IDEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJK COMPATIBILITY" +
	" IDEOGRAPH-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPATIBILITY IDEOGRA" +
	"PH-F96DCJK COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY IDEOGRAPH-F96FC" +
	"JK COMPATIBILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAPH-F971CJK COMPA" +
	"TIBILITY IDEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJK COMPATIBILITY" +
	" IDEOGRAPH-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPATIBILITY IDEOGRA" +
	"PH-F976CJK COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY IDEOGRAPH-F978C" +
	"JK COMPATIBILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAPH-F97ACJK COMPA" +
	"TIBILITY IDEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJK COMPATIBILITY" +
	" IDEOGRAPH-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPATIBILITY IDEOGRA" +
	"PH-F97FCJK COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY IDEOGRAPH-F981C" +
	"JK COMPATIBILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAPH-F983CJK COMPA" +
	"TIBILITY IDEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJK COMPATIBILITY" +
	" IDEOGRAPH-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPATIBILITY IDEOGRA" +
	"PH-F988CJK COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY IDEOGRAPH-F98AC" +
	"JK COMPATIBILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAPH-F98CCJK COMPA" +
	"TIBILITY IDEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJK COMPATIBILITY" +
	" IDEOGRAPH-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPATIBILITY IDEOGRA" +
	"PH-F991CJK COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY IDEOGRAPH-F993C" +
	"JK COMPATIBILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAPH-F995CJK COMPA" +
	"TIBILITY IDEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJK COMPATIBILITY" +
	" IDEOGRAPH-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPATIBILITY IDEOGRA" +
	"PH-F99ACJK COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY IDEOGRAPH-F99CC" +
	"JK COMPATIBILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAPH-F99ECJK COMPA" +
	"TIBILITY IDEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJK COMPATIBILITY" +
	" IDEOGRAPH-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPATIBILITY IDEOGRA" +
	"PH-F9A3CJK COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY IDEOGRAPH-F9A5C" +
	"JK COMPATIBILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAPH-F9A7CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJK COMPATIBILITY" +
	" IDEOGRAPH-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPATIBILITY IDEOGRA" +
	"PH-F9ACCJK COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY IDEOGRAPH-F9AEC" +
	"JK COMPATIBILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAPH-F9B0CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJK COMPATIBILITY" +
	" IDEOGRAPH-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPATIBILITY IDEOGRA" +
	"PH-F9B5CJK COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY IDEOGRAPH-F9B7C" +
	"JK COMPATIBILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAPH-F9B9CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJK COMPATIBILITY" +
	" IDEOGRAPH-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPATIBILITY IDEOGRA" +
	"PH-F9BECJK COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY IDEOGRAPH-F9C0C" +
	"JK COMPATIBILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAPH-F9C2CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJK COMPATIBILITY" +
	" IDEOGRAPH-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPATIBILITY IDEOGRA" +
	"PH-F9C7CJK COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY IDEOGRAPH-F9C9C" +
	"JK COMPATIBILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAPH-F9CBCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJK COMPATIBILITY" +
	" IDEOGRAPH-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPATIBILITY IDEOGRA" +
	"PH-F9D0CJK COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY IDEOGRAPH-F9D2C" +
	"JK COMPATIBILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAPH-F9D4CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJK COMPATIBILITY" +
	" IDEOGRAPH-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPATIBILITY IDEOGRA" +
	"PH-F9D9CJK COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY IDEOGRAPH-F9DBC" +
	"JK COMPATIBILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAPH-F9DDCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJK COMPATIBILITY" +
	" IDEOGRAPH-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPATIBILITY IDEOGRA" +
	"PH-F9E2CJK COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY IDEOGRAPH-F9E4C" +
	"JK COMPATIBILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAPH-F9E6CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJK COMPATIBILITY" +
	" IDEOGRAPH-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPATIBILITY IDEOGRA" +
	"PH-F9EBCJK COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY IDEOGRAPH-F9EDC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAPH-F9EFCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJK COMPATIBILITY" +
	" IDEOGRAPH-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPATIBILITY IDEOGRA" +
	"PH-F9F4CJK COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY IDEOGRAPH-F9F6C" +
	"JK COMPATIBILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAPH-F9F8CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJK COMPATIBILITY" +
	" IDEOGRAPH-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPATIBILITY IDEOGRA" +
	"PH-F9FDCJK COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY IDEOGRAPH-F9FFC" +
	"JK COMPATIBILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAPH-FA01CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJK COMPATIBILITY" +
	" IDEOGRAPH-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPATIBILITY IDEOGRA" +
	"PH-FA06CJK COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY IDEOGRAPH-FA08C" +
	"JK COMPATIBILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAPH-FA0ACJK COMPA" +
	"TIBILITY IDEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJK COMPATIBILITY" +
	" IDEOGRAPH-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPATIBILITY IDEOGRA" +
	"PH-FA0FCJK COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY IDEOGRAPH-FA11C" +
	"JK COMPATIBILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAPH-FA13CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJK COMPATIBILITY" +
	" IDEOGRAPH-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPATIBILITY IDEOGRA" +
	"PH-FA18CJK COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY IDEOGRAPH-FA1AC" +
	"JK COMPATIBILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAPH-FA1CCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJK COMPATIBILITY" +
	" IDEOGRAPH-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPATIBILITY IDEOGRA" +
	"PH-FA21CJK COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY IDEOGRAPH-FA23C" +
	"JK COMPATIBILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAPH-FA25CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJK COMPATIBILITY" +
	" IDEOGRAPH-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPATIBILITY IDEOGRA" +
	"PH-FA2ACJK COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY IDEOGRAPH-FA2CC" +
	"JK COMPATIBILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAPH-FA2ECJK COMPA" +
	"TIBILITY IDEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJK COMPATIBILITY" +
	" IDEOGRAPH-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPATIBILITY IDEOGRA" +
	"PH-FA33CJK COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY IDEOGRAPH-FA35C" +
	"JK COMPATIBILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAPH-FA37CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJK COMPATIBILITY" +
	" IDEOGRAPH-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPATIBILITY IDEOGRA" +
	"PH-FA3CCJK COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY IDEOGRAPH-FA3EC" +
	"JK COMPATIBILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAPH-FA40CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJK COMPATIBILITY" +
	" IDEOGRAPH-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPATIBILITY IDEOGRA" +
	"PH-FA45CJK COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY IDEOGRAPH-FA47C" +
	"JK COMPATIBILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAPH-FA49CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJK COMPATIBILITY" +
	" IDEOGRAPH-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPATIBILITY IDEOGRA" +
	"PH-FA4ECJK COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY IDEOGRAPH-FA50C" +
	"JK COMPATIBILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAPH-FA52CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJK COMPATIBILITY" +
	" IDEOGRAPH-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPATIBILITY IDEOGRA" +
	"PH-FA57CJK COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY IDEOGRAPH-FA59C" +
	"JK COMPATIBILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAPH-FA5BCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJK COMPATIBILITY" +
	" IDEOGRAPH-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPATIBILITY IDEOGRA" +
	"PH-FA60CJK COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY IDEOGRAPH-FA62C" +
	"JK COMPATIBILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAPH-FA64CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJK COMPATIBILITY" +
	" IDEOGRAPH-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPATIBILITY IDEOGRA" +
	"PH-FA69CJK COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY IDEOGRAPH-FA6BC" +
	"JK COMPATIBILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAPH-FA6DCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJK COMPATIBILITY" +
	" IDEOGRAPH-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPATIBILITY IDEOGRA" +
	"PH-FA74CJK COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY IDEOGRAPH-FA76C" +
	"JK COMPATIBILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAPH-FA78CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJK COMPATIBILITY" +
	" IDEOGRAPH-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPATIBILITY IDEOGRA" +
	"PH-FA7DCJK COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY IDEOGRAPH-FA7FC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAPH-FA81CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJK COMPATIBILITY" +
	" IDEOGRAPH-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPATIBILITY IDEOGRA" +
	"PH-FA86CJK COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY IDEOGRAPH-FA88C" +
	"JK COMPATIBILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAPH-FA8ACJK COMPA" +
	"TIBILITY IDEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJK COMPATIBILITY" +
	" IDEOGRAPH-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPATIBILITY IDEOGRA" +
	"PH-FA8FCJK COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY IDEOGRAPH-FA91C" +
	"JK COMPATIBILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAPH-FA93CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJK COMPATIBILITY" +
	" IDEOGRAPH-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPATIBILITY IDEOGRA" +
	"PH-FA98CJK COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY IDEOGRAPH-FA9AC" +
	"JK COMPATIBILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAPH-FA9CCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJK COMPATIBILITY" +
	" IDEOGRAPH-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPATIBILITY IDEOGRA" +
	"PH-FAA1CJK COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY IDEOGRAPH-FAA3C" +
	"JK COMPATIBILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAPH-FAA5CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJK COMPATIBILITY" +
	" IDEOGRAPH-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPATIBILITY IDEOGRA" +
	"PH-FAAACJK COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY IDEOGRAPH-FAACC" +
	"JK COMPATIBILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAPH-FAAECJK COMPA" +
	"TIBILITY IDEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJK COMPATIBILITY" +
	" IDEOGRAPH-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPATIBILITY IDEOGRA" +
	"PH-FAB3CJK COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY IDEOGRAPH-FAB5C" +
	"JK COMPATIBILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAPH-FAB7CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJK COMPATIBILITY" +
	" IDEOGRAPH-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPATIBILITY IDEOGRA" +
	"PH-FABCCJK COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY IDEOGRAPH-FABEC" +
	"JK COMPATIBILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAPH-FAC0CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJK COMPATIBILITY" +
	" IDEOGRAPH-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPATIBILITY IDEOGRA" +
	"PH-FAC5CJK COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY IDEOGRAPH-FAC7C" +
	"JK COMPATIBILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAPH-FAC9CJK COMPA" +
	"TIBILITY IDEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJK COMPATIBILITY" +
	" IDEOGRAPH-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPATIBILITY IDEOGRA" +
	"PH-FACECJK COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY IDEOGRAPH-FAD0C" +
	"JK COMPATIBILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAPH-FAD2CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJK COMPATIBILITY" +
	" IDEOGRAPH-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPATIBILITY IDEOGRA" +
	"PH-FAD7CJK COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY IDEOGRAPH-FAD9L" +
	"ATIN SMALL LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL LIGATURE FLLATI" +
	"N SMALL LIGATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL LIGATURE LONG S " +
	"TLATIN SMALL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWARMENIAN SMALL LI" +
	"GATURE MEN ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMALL LIGATURE VEW" +
	" NOWARMENIAN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH HIRIQHEBREW PO" +
	"INT JUDEO-SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD PATAHHEBREW LETT" +
	"ER ALTERNATIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER WIDE DALETHEBREW" +
	" LETTER WIDE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE LAMEDHEBREW LETT" +
	"ER WIDE FINAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WIDE TAVHEBREW LET" +
	"TER ALTERNATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOTHEBREW LETTER S" +
	"HIN WITH SIN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN DOTHEBREW LETTER" +
	" SHIN WITH DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATAHHEBREW LETTER " +
	"ALEF WITH QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTER BET WITH DAGE" +
	"SHHEBREW LETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH DAGESHHEBREW L" +
	"ETTER HE WITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LETTER ZAYIN WITH" +
	" DAGESHHEBREW LETTER TET WITH DAGESHHEBREW LETTER YOD WITH DAGESHHEBREW " +
	"LETTER FINAL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESHHEBREW LETTER L" +
	"AMED WITH DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTER NUN WITH DAGE" +
	"SHHEBREW LETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE WITH DAGESHHEBR" +
	"EW LETTER PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHEBREW LETTER QOF" +
	" WITH DAGESHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER SHIN WITH DAGESH" +
	"HEBREW LETTER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAMHEBREW LETTER B" +
	"ET WITH RAFEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE WITH RAFEHEBREW " +
	"LIGATURE ALEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORMARABIC LETTER A") + ("" +
	"LEF WASLA FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABIC LETTER BEEH F" +
	"INAL FORMARABIC LETTER BEEH INITIAL FORMARABIC LETTER BEEH MEDIAL FORMAR" +
	"ABIC LETTER PEH ISOLATED FORMARABIC LETTER PEH FINAL FORMARABIC LETTER P" +
	"EH INITIAL FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER BEHEH ISOLATED" +
	" FORMARABIC LETTER BEHEH FINAL FORMARABIC LETTER BEHEH INITIAL FORMARABI" +
	"C LETTER BEHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED FORMARABIC LETTE" +
	"R TTEHEH FINAL FORMARABIC LETTER TTEHEH INITIAL FORMARABIC LETTER TTEHEH" +
	" MEDIAL FORMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTER TEHEH FINAL F" +
	"ORMARABIC LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH MEDIAL FORMARABIC" +
	" LETTER TTEH ISOLATED FORMARABIC LETTER TTEH FINAL FORMARABIC LETTER TTE" +
	"H INITIAL FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER VEH ISOLATED F" +
	"ORMARABIC LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL FORMARABIC LETT" +
	"ER VEH MEDIAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC LETTER PEHEH F" +
	"INAL FORMARABIC LETTER PEHEH INITIAL FORMARABIC LETTER PEHEH MEDIAL FORM" +
	"ARABIC LETTER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL FORMARABIC LETT" +
	"ER DYEH INITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC LETTER NYEH ISO" +
	"LATED FORMARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH INITIAL FORMAR" +
	"ABIC LETTER NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED FORMARABIC LETT" +
	"ER TCHEH FINAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC LETTER TCHEH M" +
	"EDIAL FORMARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTER TCHEHEH FINAL" +
	" FORMARABIC LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHEHEH MEDIAL FORM" +
	"ARABIC LETTER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FINAL FORMARABIC " +
	"LETTER DAHAL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMARABIC LETTER DU" +
	"L ISOLATED FORMARABIC LETTER DUL FINAL FORMARABIC LETTER DDAL ISOLATED F" +
	"ORMARABIC LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATED FORMARABIC LE" +
	"TTER JEH FINAL FORMARABIC LETTER RREH ISOLATED FORMARABIC LETTER RREH FI" +
	"NAL FORMARABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KEHEH FINAL FORMA" +
	"RABIC LETTER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL FORMARABIC LET" +
	"TER GAF ISOLATED FORMARABIC LETTER GAF FINAL FORMARABIC LETTER GAF INITI" +
	"AL FORMARABIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH ISOLATED FORMARAB" +
	"IC LETTER GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMARABIC LETTER GU" +
	"EH MEDIAL FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LETTER NGOEH FINAL" +
	" FORMARABIC LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH MEDIAL FORMARAB" +
	"IC LETTER NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHUNNA FINAL FORMA" +
	"RABIC LETTER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL FORMARABIC LET" +
	"TER RNOON INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARABIC LETTER HEH W" +
	"ITH YEH ABOVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABOVE FINAL FORMAR" +
	"ABIC LETTER HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL FINAL FORMARABI" +
	"C LETTER HEH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDIAL FORMARABIC L" +
	"ETTER HEH DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOACHASHMEE FINAL F" +
	"ORMARABIC LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTER HEH DOACHASHM" +
	"EE MEDIAL FORMARABIC LETTER YEH BARREE ISOLATED FORMARABIC LETTER YEH BA" +
	"RREE FINAL FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORMAR" +
	"ABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC SYMBOL DOT ABOV" +
	"EARABIC SYMBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABIC SYMBOL TWO DO" +
	"TS BELOWARABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE DOTS BELOWARAB" +
	"IC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBOL THREE DOTS PO" +
	"INTING DOWNWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC SYMBOL FOUR DO" +
	"TS BELOWARABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYMBOL TWO DOTS VE" +
	"RTICALLY ABOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARABIC SYMBOL RINGA" +
	"RABIC SYMBOL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOWARABIC LETTER N" +
	"G ISOLATED FORMARABIC LETTER NG FINAL FORMARABIC LETTER NG INITIAL FORMA" +
	"RABIC LETTER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMARABIC LETTER U " +
	"FINAL FORMARABIC LETTER OE ISOLATED FORMARABIC LETTER OE FINAL FORMARABI" +
	"C LETTER YU ISOLATED FORMARABIC LETTER YU FINAL FORMARABIC LETTER U WITH" +
	" HAMZA ABOVE ISOLATED FORMARABIC LETTER VE ISOLATED FORMARABIC LETTER VE" +
	" FINAL FORMARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC LETTER KIRGHIZ O" +
	"E FINAL FORMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC LETTER KIRGHIZ " +
	"YU FINAL FORMARABIC LETTER E ISOLATED FORMARABIC LETTER E FINAL FORMARAB" +
	"IC LETTER E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC LETTER UIGHUR " +
	"KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIGHUR KAZAKH KIRG" +
	"HIZ ALEF MAKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AL" +
	"EF ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FOR" +
	"MARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORMARABIC LIGATU") + ("" +
	"RE YEH WITH HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE YEH WITH HAMZA" +
	" ABOVE WITH WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH W" +
	"AW FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABIC LIGATURE YEH " +
	"WITH HAMZA ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABO" +
	"VE WITH OE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLAT" +
	"ED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORMARABIC LIG" +
	"ATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIGATURE YEH WITH " +
	"HAMZA ABOVE WITH E FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E" +
	" INITIAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH AL" +
	"EF MAKSURA ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA AB" +
	"OVE WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH " +
	"HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORMARABIC LETTER FARSI YEH ISOLAT" +
	"ED FORMARABIC LETTER FARSI YEH FINAL FORMARABIC LETTER FARSI YEH INITIAL" +
	" FORMARABIC LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA A" +
	"BOVE WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HA" +
	"H ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED F" +
	"ORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORMA" +
	"RABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORMARABIC LIGATUR" +
	"E BEH WITH JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH ISOLATED FORMA" +
	"RABIC LIGATURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE BEH WITH MEEM " +
	"ISOLATED FORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORMARABIC L" +
	"IGATURE BEH WITH YEH ISOLATED FORMARABIC LIGATURE TEH WITH JEEM ISOLATED" +
	" FORMARABIC LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIGATURE TEH WITH " +
	"KHAH ISOLATED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED FORMARABIC LIGA" +
	"TURE TEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TEH WITH YEH ISO" +
	"LATED FORMARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARABIC LIGATURE TH" +
	"EH WITH MEEM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATE" +
	"D FORMARABIC LIGATURE THEH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WI" +
	"TH HAH ISOLATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLATED FORMARABIC L" +
	"IGATURE HAH WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WITH MEEM ISOLATE" +
	"D FORMARABIC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC LIGATURE KHAH W" +
	"ITH HAH ISOLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLATED FORMARABIC " +
	"LIGATURE SEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN WITH HAH ISOLA" +
	"TED FORMARABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SEEN" +
	" WITH MEEM ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOLATED FORMARABIC" +
	" LIGATURE SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD WITH JEEM ISOLA" +
	"TED FORMARABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC LIGATURE DAD WI" +
	"TH KHAH ISOLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLATED FORMARABIC L" +
	"IGATURE TAH WITH HAH ISOLATED FORMARABIC LIGATURE TAH WITH MEEM ISOLATED" +
	" FORMARABIC LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LIGATURE AIN WITH" +
	" JEEM ISOLATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED FORMARABIC LIG" +
	"ATURE GHAIN WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN WITH MEEM ISOLA" +
	"TED FORMARABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC LIGATURE FEH W" +
	"ITH HAH ISOLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLATED FORMARABIC L" +
	"IGATURE FEH WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH ALEF MAKSURA" +
	" ISOLATED FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMARABIC LIGATURE " +
	"QAF WITH HAH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM ISOLATED FORMARA" +
	"BIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE QAF WITH" +
	" YEH ISOLATED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED FORMARABIC LIGA" +
	"TURE KAF WITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH HAH ISOLATED FO" +
	"RMARABIC LIGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGATURE KAF WITH LA" +
	"M ISOLATED FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FORMARABIC LIGATUR" +
	"E KAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF WITH YEH ISOLAT" +
	"ED FORMARABIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC LIGATURE LAM WI" +
	"TH HAH ISOLATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATED FORMARABIC LI" +
	"GATURE LAM WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WITH ALEF MAKSURA " +
	"ISOLATED FORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMARABIC LIGATURE M" +
	"EEM WITH JEEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH ISOLATED FORMAR" +
	"ABIC LIGATURE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE MEEM WITH MEEM" +
	" ISOLATED FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORMARABIC" +
	" LIGATURE MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON WITH JEEM ISOL" +
	"ATED FORMARABIC LIGATURE NOON WITH HAH ISOLATED FORMARABIC LIGATURE NOON" +
	" WITH KHAH ISOLATED FORMARABIC LIGATURE NOON WITH MEEM ISOLATED FORMARAB") + ("" +
	"IC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE NOON WIT" +
	"H YEH ISOLATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED FORMARABIC LIG" +
	"ATURE HEH WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH ALEF MAKSURA I" +
	"SOLATED FORMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARABIC LIGATURE YE" +
	"H WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISOLATED FORMARABI" +
	"C LIGATURE YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH WITH MEEM ISOL" +
	"ATED FORMARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGAT" +
	"URE YEH WITH YEH ISOLATED FORMARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF" +
	" ISOLATED FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORMARA" +
	"BIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGA" +
	"TURE SHADDA WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRA" +
	"TAN ISOLATED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORMARABIC L" +
	"IGATURE SHADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRA" +
	" ISOLATED FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM" +
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMARABIC LIGATURE " +
	"YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE YEH WITH HAMZA " +
	"ABOVE WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON" +
	" FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL " +
	"FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORMARABIC LIGAT" +
	"URE BEH WITH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN FINAL FORMARABI" +
	"C LIGATURE BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WITH NOON FINAL F" +
	"ORMARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE BEH W" +
	"ITH YEH FINAL FORMARABIC LIGATURE TEH WITH REH FINAL FORMARABIC LIGATURE" +
	" TEH WITH ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FINAL FORMARABIC " +
	"LIGATURE TEH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LIGATURE THEH WIT" +
	"H REH FINAL FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORMARABIC LIGATURE" +
	" THEH WITH MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON FINAL FORMARABI" +
	"C LIGATURE THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE THEH WITH YE" +
	"H FINAL FORMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORMARABIC LIGAT" +
	"URE FEH WITH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL F" +
	"ORMARABIC LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE KAF WITH ALEF " +
	"FINAL FORMARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC LIGATURE KAF WIT" +
	"H MEEM FINAL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE KAF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM FINAL FORM" +
	"ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE LAM WITH" +
	" YEH FINAL FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMARABIC LIGATURE " +
	"MEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FINAL FORMARABIC " +
	"LIGATURE NOON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WITH MEEM FINAL F" +
	"ORMARABIC LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATURE NOON WITH AL" +
	"EF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL FORMARABIC LIGA" +
	"TURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC LIGATURE YEH WI" +
	"TH REH FINAL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORMARABIC LIGATURE" +
	" YEH WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FINAL FORMARABIC " +
	"LIGATURE YEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH YEH FI" +
	"NAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORMARABI" +
	"C LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARABIC LIGATURE YEH" +
	" WITH HAMZA ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA A" +
	"BOVE WITH MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH" +
	" INITIAL FORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMARABIC LIGATURE B" +
	"EH WITH HAH INITIAL FORMARABIC LIGATURE BEH WITH KHAH INITIAL FORMARABIC" +
	" LIGATURE BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH HEH INITIAL" +
	" FORMARABIC LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH " +
	"HAH INITIAL FORMARABIC LIGATURE TEH WITH KHAH INITIAL FORMARABIC LIGATUR" +
	"E TEH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH INITIAL FORMARA" +
	"BIC LIGATURE THEH WITH MEEM INITIAL FORMARABIC LIGATURE JEEM WITH HAH IN" +
	"ITIAL FORMARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARABIC LIGATURE HAH" +
	" WITH JEEM INITIAL FORMARABIC LIGATURE HAH WITH MEEM INITIAL FORMARABIC " +
	"LIGATURE KHAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC LIGATURE SEEN W" +
	"ITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIAL FORMARABIC LI" +
	"GATURE SEEN WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH INITIAL F" +
	"ORMARABIC LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGATURE SAD WITH ME" +
	"EM INITIAL FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORMARABIC LIGATURE") + ("" +
	" DAD WITH HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH INITIAL FORMARAB" +
	"IC LIGATURE DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH HAH INITI" +
	"AL FORMARABIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WIT" +
	"H JEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE GHAIN WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WITH MEEM INITIAL" +
	" FORMARABIC LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIGATURE FEH WITH " +
	"HAH INITIAL FORMARABIC LIGATURE FEH WITH KHAH INITIAL FORMARABIC LIGATUR" +
	"E FEH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH INITIAL FORMARA" +
	"BIC LIGATURE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH JEEM INI" +
	"TIAL FORMARABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC LIGATURE KAF WI" +
	"TH KHAH INITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL FORMARABIC LIGA" +
	"TURE KAF WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM INITIAL FOR" +
	"MARABIC LIGATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH KHAH " +
	"INITIAL FORMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARABIC LIGATURE LA" +
	"M WITH HEH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INITIAL FORMARABIC" +
	" LIGATURE MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH INITI" +
	"AL FORMARABIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON W" +
	"ITH JEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH INITIAL FORMARABIC LI" +
	"GATURE NOON WITH KHAH INITIAL FORMARABIC LIGATURE NOON WITH MEEM INITIAL" +
	" FORMARABIC LIGATURE NOON WITH HEH INITIAL FORMARABIC LIGATURE HEH WITH " +
	"JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FORMARABIC LIGATU" +
	"RE HEH WITH SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE YEH WITH JEEM I" +
	"NITIAL FORMARABIC LIGATURE YEH WITH HAH INITIAL FORMARABIC LIGATURE YEH " +
	"WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE YEH WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WI" +
	"TH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL " +
	"FORMARABIC LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGATURE BEH WITH HE" +
	"H MEDIAL FORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARABIC LIGATURE TE" +
	"H WITH HEH MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDIAL FORMARABIC L" +
	"IGATURE THEH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WITH MEEM MEDIAL F" +
	"ORMARABIC LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATURE SHEEN WITH M" +
	"EEM MEDIAL FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORMARABIC LIGATURE" +
	" KAF WITH LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM MEDIAL FORMARABIC" +
	" LIGATURE LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH MEEM MEDIAL" +
	" FORMARABIC LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGATURE YEH WITH M" +
	"EEM MEDIAL FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMARABIC LIGATURE S" +
	"HADDA WITH FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FOR" +
	"MARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGATURE TAH WITH A" +
	"LEF MAKSURA ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISOLATED FORMARABI" +
	"C LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE AIN WITH Y" +
	"EH ISOLATED FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORMARA" +
	"BIC LIGATURE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE SEEN WITH ALEF " +
	"MAKSURA ISOLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLATED FORMARABIC L" +
	"IGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SHEEN WITH " +
	"YEH ISOLATED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORMARAB" +
	"IC LIGATURE HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH ALEF MAK" +
	"SURA ISOLATED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED FORMARABIC LIGA" +
	"TURE KHAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KHAH WITH YEH I" +
	"SOLATED FORMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORMARABIC LI" +
	"GATURE SAD WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH ALEF MAKSURA I" +
	"SOLATED FORMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARABIC LIGATURE SH" +
	"EEN WITH JEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH ISOLATED FORMA" +
	"RABIC LIGATURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SHEEN WITH M" +
	"EEM ISOLATED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED FORMARABIC LIGA" +
	"TURE SEEN WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH REH ISOLATED FO" +
	"RMARABIC LIGATURE DAD WITH REH ISOLATED FORMARABIC LIGATURE TAH WITH ALE" +
	"F MAKSURA FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FORMARABIC LIGATU" +
	"RE AIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WITH YEH FINAL FO" +
	"RMARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHAI" +
	"N WITH YEH FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORMAR" +
	"ABIC LIGATURE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH ALEF MA" +
	"KSURA FINAL FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORMARABIC LIGATURE" +
	" HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH YEH FINAL FORM" +
	"ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WI") + ("" +
	"TH YEH FINAL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC LIGATURE DAD WIT" +
	"H ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH YEH FINAL FORMARABIC L" +
	"IGATURE SHEEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH FINAL F" +
	"ORMARABIC LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH " +
	"MEEM FINAL FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMARABIC LIGATURE " +
	"SEEN WITH REH FINAL FORMARABIC LIGATURE SAD WITH REH FINAL FORMARABIC LI" +
	"GATURE DAD WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH JEEM INITIAL FO" +
	"RMARABIC LIGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGATURE SHEEN WITH " +
	"KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE SEEN WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH HEH INITIAL FO" +
	"RMARABIC LIGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JE" +
	"EM MEDIAL FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMARABIC LIGATURE S" +
	"EEN WITH KHAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORMARAB" +
	"IC LIGATURE SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHEEN WITH KHAH ME" +
	"DIAL FORMARABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC LIGATURE ZAH WI" +
	"TH MEEM MEDIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FINAL FORMARABIC L" +
	"IGATURE ALEF WITH FATHATAN ISOLATED FORMORNATE LEFT PARENTHESISORNATE RI" +
	"GHT PARENTHESISARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATURE TEH WITH HAH" +
	" WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE TE" +
	"H WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH HAH" +
	" INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORMARABIC " +
	"LIGATURE JEEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE JEEM WITH MEE" +
	"M WITH HAH INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM" +
	"ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATUR" +
	"E SEEN WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WIT" +
	"H HAH INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL" +
	" FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE S" +
	"EEN WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH J" +
	"EEM INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORMARABI" +
	"C LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH" +
	" HAH WITH HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FO" +
	"RMARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE SHEE" +
	"N WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH MEEM " +
	"INITIAL FORMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORMARABIC LI" +
	"GATURE SHEEN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH ME" +
	"EM WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL" +
	" FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATU" +
	"RE DAD WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH KHA" +
	"H WITH MEEM FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE TAH W" +
	"ITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORMARABIC LIGATU" +
	"RE AIN WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH " +
	"MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHA" +
	"IN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH YE" +
	"H FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM" +
	"ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE FEH WI" +
	"TH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH MEEM WITH HAH FIN" +
	"AL FORMARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE" +
	" LAM WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH HAH WITH YEH " +
	"FINAL FORMARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORMARABI" +
	"C LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIGATURE LAM WITH " +
	"JEEM WITH JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL F" +
	"ORMARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE L" +
	"AM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH HAH I" +
	"NITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORMARABIC LI" +
	"GATURE MEEM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH HAH" +
	" WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM" +
	"ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE MEE") + ("" +
	"M WITH KHAH WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH ME" +
	"EM INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORMARAB" +
	"IC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH" +
	" MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH MEEM INIT" +
	"IAL FORMARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH J" +
	"EEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSU" +
	"RA FINAL FORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORMARABIC LI" +
	"GATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WI" +
	"TH MEEM WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH MEEM INIT" +
	"IAL FORMARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE" +
	" TEH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH JEEM WITH ALE" +
	"F MAKSURA FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORMARA" +
	"BIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE T" +
	"EH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH MEEM WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORMARAB" +
	"IC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JE" +
	"EM WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH KHAH " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH WITH YEH FINAL " +
	"FORMARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARABIC LIGATURE DA" +
	"D WITH HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH YEH FIN" +
	"AL FORMARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE " +
	"YEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH JEEM WITH YEH F" +
	"INAL FORMARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATUR" +
	"E MEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH Y" +
	"EH FINAL FORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORMARABIC LIG" +
	"ATURE QAF WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH HAH WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORMARA" +
	"BIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH " +
	"JEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL " +
	"FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE " +
	"KAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEE" +
	"M FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORMARABIC LIG" +
	"ATURE JEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HAH WITH JEEM WIT" +
	"H YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORMARABIC" +
	" LIGATURE FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE BEH WITH HAH " +
	"WITH YEH FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD W" +
	"ITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH KHAH WITH YEH F" +
	"INAL FORMARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORMARABIC LIGATU" +
	"RE SALLA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE QALA USE" +
	"D AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE ALLAH ISOLATED FORMA" +
	"RABIC LIGATURE AKBAR ISOLATED FORMARABIC LIGATURE MOHAMMAD ISOLATED FORM" +
	"ARABIC LIGATURE SALAM ISOLATED FORMARABIC LIGATURE RASOUL ISOLATED FORMA" +
	"RABIC LIGATURE ALAYHE ISOLATED FORMARABIC LIGATURE WASALLAM ISOLATED FOR" +
	"MARABIC LIGATURE SALLA ISOLATED FORMARABIC LIGATURE SALLALLAHOU ALAYHE W" +
	"ASALLAMARABIC LIGATURE JALLAJALALOUHOURIAL SIGNARABIC LIGATURE BISMILLAH" +
	" AR-RAHMAN AR-RAHEEMVARIATION SELECTOR-1VARIATION SELECTOR-2VARIATION SE" +
	"LECTOR-3VARIATION SELECTOR-4VARIATION SELECTOR-5VARIATION SELECTOR-6VARI" +
	"ATION SELECTOR-7VARIATION SELECTOR-8VARIATION SELECTOR-9VARIATION SELECT" +
	"OR-10VARIATION SELECTOR-11VARIATION SELECTOR-12VARIATION SELECTOR-13VARI" +
	"ATION SELECTOR-14VARIATION SELECTOR-15VARIATION SELECTOR-16PRESENTATION " +
	"FORM FOR VERTICAL COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMAP" +
	"RESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRESENTATION FORM FOR" +
	" VERTICAL COLONPRESENTATION FORM FOR VERTICAL SEMICOLONPRESENTATION FORM" +
	" FOR VERTICAL EXCLAMATION MARKPRESENTATION FORM FOR VERTICAL QUESTION MA" +
	"RKPRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKETPRESENTATI" +
	"ON FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRESENTATION FORM FOR" +
	" VERTICAL HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT HALFCOMBINING LIGAT" +
	"URE RIGHT HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBINING DOUBLE TILDE RIG" +
	"HT HALFCOMBINING MACRON LEFT HALFCOMBINING MACRON RIGHT HALFCOMBINING CO" +
	"NJOINING MACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBINING LIGATURE RIGH" +
	"T HALF BELOWCOMBINING TILDE LEFT HALF BELOWCOMBINING TILDE RIGHT HALF BE" +
	"LOWCOMBINING MACRON LEFT HALF BELOWCOMBINING MACRON RIGHT HALF BELOWCOMB") + ("" +
	"INING CONJOINING MACRON BELOWCOMBINING CYRILLIC TITLO LEFT HALFCOMBINING" +
	" CYRILLIC TITLO RIGHT HALFPRESENTATION FORM FOR VERTICAL TWO DOT LEADERP" +
	"RESENTATION FORM FOR VERTICAL EM DASHPRESENTATION FORM FOR VERTICAL EN D" +
	"ASHPRESENTATION FORM FOR VERTICAL LOW LINEPRESENTATION FORM FOR VERTICAL" +
	" WAVY LOW LINEPRESENTATION FORM FOR VERTICAL LEFT PARENTHESISPRESENTATIO" +
	"N FORM FOR VERTICAL RIGHT PARENTHESISPRESENTATION FORM FOR VERTICAL LEFT" +
	" CURLY BRACKETPRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKETPRESENTA" +
	"TION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRESENTATION FORM FOR " +
	"VERTICAL RIGHT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTICAL LEFT" +
	" BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL RIGHT BLACK LENT" +
	"ICULAR BRACKETPRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKETPR" +
	"ESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKETPRESENTATION FORM" +
	" FOR VERTICAL LEFT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT ANG" +
	"LE BRACKETPRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKETPRESENTATION" +
	" FORM FOR VERTICAL RIGHT CORNER BRACKETPRESENTATION FORM FOR VERTICAL LE" +
	"FT WHITE CORNER BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER" +
	" BRACKETSESAME DOTWHITE SESAME DOTPRESENTATION FORM FOR VERTICAL LEFT SQ" +
	"UARE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKETDASHED OV" +
	"ERLINECENTRELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVERLINEDASHED LOW LIN" +
	"ECENTRELINE LOW LINEWAVY LOW LINESMALL COMMASMALL IDEOGRAPHIC COMMASMALL" +
	" FULL STOPSMALL SEMICOLONSMALL COLONSMALL QUESTION MARKSMALL EXCLAMATION" +
	" MARKSMALL EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PARENTHESISSMALL LEF" +
	"T CURLY BRACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TORTOISE SHELL BRACKE" +
	"TSMALL RIGHT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSMALL AMPERSANDSMALL" +
	" ASTERISKSMALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-THAN SIGNSMALL GREA" +
	"TER-THAN SIGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMALL DOLLAR SIGNSMAL" +
	"L PERCENT SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLATED FORMARABIC TAT" +
	"WEEL WITH FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMARABIC TAIL FRAGMEN" +
	"TARABIC KASRATAN ISOLATED FORMARABIC FATHA ISOLATED FORMARABIC FATHA MED" +
	"IAL FORMARABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL FORMARABIC KASRA I" +
	"SOLATED FORMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOLATED FORMARABIC SH" +
	"ADDA MEDIAL FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN MEDIAL FORMARABIC" +
	" LETTER HAMZA ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED " +
	"FORMARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORMARABIC LETTER ALEF WIT" +
	"H HAMZA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FOR" +
	"MARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER WAW WITH " +
	"HAMZA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORMA" +
	"RABIC LETTER ALEF WITH HAMZA BELOW FINAL FORMARABIC LETTER YEH WITH HAMZ" +
	"A ABOVE ISOLATED FORMARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORMARABIC" +
	" LETTER YEH WITH HAMZA ABOVE INITIAL FORMARABIC LETTER YEH WITH HAMZA AB" +
	"OVE MEDIAL FORMARABIC LETTER ALEF ISOLATED FORMARABIC LETTER ALEF FINAL " +
	"FORMARABIC LETTER BEH ISOLATED FORMARABIC LETTER BEH FINAL FORMARABIC LE" +
	"TTER BEH INITIAL FORMARABIC LETTER BEH MEDIAL FORMARABIC LETTER TEH MARB" +
	"UTA ISOLATED FORMARABIC LETTER TEH MARBUTA FINAL FORMARABIC LETTER TEH I" +
	"SOLATED FORMARABIC LETTER TEH FINAL FORMARABIC LETTER TEH INITIAL FORMAR" +
	"ABIC LETTER TEH MEDIAL FORMARABIC LETTER THEH ISOLATED FORMARABIC LETTER" +
	" THEH FINAL FORMARABIC LETTER THEH INITIAL FORMARABIC LETTER THEH MEDIAL" +
	" FORMARABIC LETTER JEEM ISOLATED FORMARABIC LETTER JEEM FINAL FORMARABIC" +
	" LETTER JEEM INITIAL FORMARABIC LETTER JEEM MEDIAL FORMARABIC LETTER HAH" +
	" ISOLATED FORMARABIC LETTER HAH FINAL FORMARABIC LETTER HAH INITIAL FORM" +
	"ARABIC LETTER HAH MEDIAL FORMARABIC LETTER KHAH ISOLATED FORMARABIC LETT" +
	"ER KHAH FINAL FORMARABIC LETTER KHAH INITIAL FORMARABIC LETTER KHAH MEDI" +
	"AL FORMARABIC LETTER DAL ISOLATED FORMARABIC LETTER DAL FINAL FORMARABIC" +
	" LETTER THAL ISOLATED FORMARABIC LETTER THAL FINAL FORMARABIC LETTER REH" +
	" ISOLATED FORMARABIC LETTER REH FINAL FORMARABIC LETTER ZAIN ISOLATED FO" +
	"RMARABIC LETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOLATED FORMARABIC LE" +
	"TTER SEEN FINAL FORMARABIC LETTER SEEN INITIAL FORMARABIC LETTER SEEN ME" +
	"DIAL FORMARABIC LETTER SHEEN ISOLATED FORMARABIC LETTER SHEEN FINAL FORM" +
	"ARABIC LETTER SHEEN INITIAL FORMARABIC LETTER SHEEN MEDIAL FORMARABIC LE" +
	"TTER SAD ISOLATED FORMARABIC LETTER SAD FINAL FORMARABIC LETTER SAD INIT" +
	"IAL FORMARABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD ISOLATED FORMARAB" +
	"IC LETTER DAD FINAL FORMARABIC LETTER DAD INITIAL FORMARABIC LETTER DAD " +
	"MEDIAL FORMARABIC LETTER TAH ISOLATED FORMARABIC LETTER TAH FINAL FORMAR" +
	"ABIC LETTER TAH INITIAL FORMARABIC LETTER TAH MEDIAL FORMARABIC LETTER Z") + ("" +
	"AH ISOLATED FORMARABIC LETTER ZAH FINAL FORMARABIC LETTER ZAH INITIAL FO" +
	"RMARABIC LETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLATED FORMARABIC LET" +
	"TER AIN FINAL FORMARABIC LETTER AIN INITIAL FORMARABIC LETTER AIN MEDIAL" +
	" FORMARABIC LETTER GHAIN ISOLATED FORMARABIC LETTER GHAIN FINAL FORMARAB" +
	"IC LETTER GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL FORMARABIC LETTER" +
	" FEH ISOLATED FORMARABIC LETTER FEH FINAL FORMARABIC LETTER FEH INITIAL " +
	"FORMARABIC LETTER FEH MEDIAL FORMARABIC LETTER QAF ISOLATED FORMARABIC L" +
	"ETTER QAF FINAL FORMARABIC LETTER QAF INITIAL FORMARABIC LETTER QAF MEDI" +
	"AL FORMARABIC LETTER KAF ISOLATED FORMARABIC LETTER KAF FINAL FORMARABIC" +
	" LETTER KAF INITIAL FORMARABIC LETTER KAF MEDIAL FORMARABIC LETTER LAM I" +
	"SOLATED FORMARABIC LETTER LAM FINAL FORMARABIC LETTER LAM INITIAL FORMAR" +
	"ABIC LETTER LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED FORMARABIC LETTER" +
	" MEEM FINAL FORMARABIC LETTER MEEM INITIAL FORMARABIC LETTER MEEM MEDIAL" +
	" FORMARABIC LETTER NOON ISOLATED FORMARABIC LETTER NOON FINAL FORMARABIC" +
	" LETTER NOON INITIAL FORMARABIC LETTER NOON MEDIAL FORMARABIC LETTER HEH" +
	" ISOLATED FORMARABIC LETTER HEH FINAL FORMARABIC LETTER HEH INITIAL FORM" +
	"ARABIC LETTER HEH MEDIAL FORMARABIC LETTER WAW ISOLATED FORMARABIC LETTE" +
	"R WAW FINAL FORMARABIC LETTER ALEF MAKSURA ISOLATED FORMARABIC LETTER AL" +
	"EF MAKSURA FINAL FORMARABIC LETTER YEH ISOLATED FORMARABIC LETTER YEH FI" +
	"NAL FORMARABIC LETTER YEH INITIAL FORMARABIC LETTER YEH MEDIAL FORMARABI" +
	"C LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORMARABIC LIGATURE L" +
	"AM WITH ALEF WITH MADDA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WI" +
	"TH HAMZA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABO" +
	"VE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FOR" +
	"MARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORMARABIC LIGATUR" +
	"E LAM WITH ALEF ISOLATED FORMARABIC LIGATURE LAM WITH ALEF FINAL FORMZER" +
	"O WIDTH NO-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWIDTH QUOTATION MARK" +
	"FULLWIDTH NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PERCENT SIGNFULLWIDT" +
	"H AMPERSANDFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHESISFULLWIDTH RIGHT" +
	" PARENTHESISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLWIDTH COMMAFULLWIDT" +
	"H HYPHEN-MINUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULLWIDTH DIGIT ZEROFU" +
	"LLWIDTH DIGIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT THREEFULLWIDTH DIGIT" +
	" FOURFULLWIDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH DIGIT SEVENFULLWID" +
	"TH DIGIT EIGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLWIDTH SEMICOLONFULL" +
	"WIDTH LESS-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GREATER-THAN SIGNFULL" +
	"WIDTH QUESTION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LATIN CAPITAL LETTER" +
	" AFULLWIDTH LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPITAL LETTER CFULLWI" +
	"DTH LATIN CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETTER EFULLWIDTH LATI" +
	"N CAPITAL LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULLWIDTH LATIN CAPITA" +
	"L LETTER HFULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LATIN CAPITAL LETTER" +
	" JFULLWIDTH LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPITAL LETTER LFULLWI" +
	"DTH LATIN CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETTER NFULLWIDTH LATI" +
	"N CAPITAL LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULLWIDTH LATIN CAPITA" +
	"L LETTER QFULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LATIN CAPITAL LETTER" +
	" SFULLWIDTH LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPITAL LETTER UFULLWI" +
	"DTH LATIN CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETTER WFULLWIDTH LATI" +
	"N CAPITAL LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULLWIDTH LATIN CAPITA" +
	"L LETTER ZFULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVERSE SOLIDUSFULLWIDT" +
	"H RIGHT SQUARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLWIDTH LOW LINEFULLW" +
	"IDTH GRAVE ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWIDTH LATIN SMALL LET" +
	"TER BFULLWIDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMALL LETTER DFULLWID" +
	"TH LATIN SMALL LETTER EFULLWIDTH LATIN SMALL LETTER FFULLWIDTH LATIN SMA" +
	"LL LETTER GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LATIN SMALL LETTER IF" +
	"ULLWIDTH LATIN SMALL LETTER JFULLWIDTH LATIN SMALL LETTER KFULLWIDTH LAT" +
	"IN SMALL LETTER LFULLWIDTH LATIN SMALL LETTER MFULLWIDTH LATIN SMALL LET" +
	"TER NFULLWIDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMALL LETTER PFULLWID" +
	"TH LATIN SMALL LETTER QFULLWIDTH LATIN SMALL LETTER RFULLWIDTH LATIN SMA" +
	"LL LETTER SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LATIN SMALL LETTER UF" +
	"ULLWIDTH LATIN SMALL LETTER VFULLWIDTH LATIN SMALL LETTER WFULLWIDTH LAT" +
	"IN SMALL LETTER XFULLWIDTH LATIN SMALL LETTER YFULLWIDTH LATIN SMALL LET" +
	"TER ZFULLWIDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LINEFULLWIDTH RIGHT " +
	"CURLY BRACKETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PARENTHESISFULLWIDTH RI" +
	"GHT WHITE PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHALFWIDTH LEFT CORNE" +
	"R BRACKETHALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOGRAPHIC COMMAHALFWI") + ("" +
	"DTH KATAKANA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHALFWIDTH KATAKANA LE" +
	"TTER SMALL AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH KATAKANA LETTER S" +
	"MALL UHALFWIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAKANA LETTER SMALL O" +
	"HALFWIDTH KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA LETTER SMALL YUHALF" +
	"WIDTH KATAKANA LETTER SMALL YOHALFWIDTH KATAKANA LETTER SMALL TUHALFWIDT" +
	"H KATAKANA-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATAKANA LETTER AHALFW" +
	"IDTH KATAKANA LETTER IHALFWIDTH KATAKANA LETTER UHALFWIDTH KATAKANA LETT" +
	"ER EHALFWIDTH KATAKANA LETTER OHALFWIDTH KATAKANA LETTER KAHALFWIDTH KAT" +
	"AKANA LETTER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH KATAKANA LETTER KEH" +
	"ALFWIDTH KATAKANA LETTER KOHALFWIDTH KATAKANA LETTER SAHALFWIDTH KATAKAN" +
	"A LETTER SIHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAKANA LETTER SEHALFW" +
	"IDTH KATAKANA LETTER SOHALFWIDTH KATAKANA LETTER TAHALFWIDTH KATAKANA LE" +
	"TTER TIHALFWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA LETTER TEHALFWIDTH" +
	" KATAKANA LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWIDTH KATAKANA LETTER" +
	" NIHALFWIDTH KATAKANA LETTER NUHALFWIDTH KATAKANA LETTER NEHALFWIDTH KAT" +
	"AKANA LETTER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH KATAKANA LETTER HIH" +
	"ALFWIDTH KATAKANA LETTER HUHALFWIDTH KATAKANA LETTER HEHALFWIDTH KATAKAN" +
	"A LETTER HOHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAKANA LETTER MIHALFW" +
	"IDTH KATAKANA LETTER MUHALFWIDTH KATAKANA LETTER MEHALFWIDTH KATAKANA LE" +
	"TTER MOHALFWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA LETTER YUHALFWIDTH" +
	" KATAKANA LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWIDTH KATAKANA LETTER" +
	" RIHALFWIDTH KATAKANA LETTER RUHALFWIDTH KATAKANA LETTER REHALFWIDTH KAT" +
	"AKANA LETTER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH KATAKANA LETTER NHA" +
	"LFWIDTH KATAKANA VOICED SOUND MARKHALFWIDTH KATAKANA SEMI-VOICED SOUND M" +
	"ARKHALFWIDTH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYEOKHALFWIDTH HANGUL" +
	" LETTER SSANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOSHALFWIDTH HANGUL L" +
	"ETTER NIEUNHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDTH HANGUL LETTER NI" +
	"EUN-HIEUHHALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGUL LETTER SSANGTIKE" +
	"UTHALFWIDTH HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER RIEUL-KIYEOKHALFW" +
	"IDTH HANGUL LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER RIEUL-PIEUPHALFWID" +
	"TH HANGUL LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIEUL-THIEUTHHALFWIDT" +
	"H HANGUL LETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER RIEUL-HIEUHHALFWIDT" +
	"H HANGUL LETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALFWIDTH HANGUL LETTE" +
	"R SSANGPIEUPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDTH HANGUL LETTER SI" +
	"OSHALFWIDTH HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LETTER IEUNGHALFWIDT" +
	"H HANGUL LETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEUCHALFWIDTH HANGUL " +
	"LETTER CHIEUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH HANGUL LETTER THI" +
	"EUTHHALFWIDTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LETTER HIEUHHALFWIDT" +
	"H HANGUL LETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH HANGUL LETTER YAHAL" +
	"FWIDTH HANGUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALFWIDTH HANGUL LETTE" +
	"R EHALFWIDTH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER YEHALFWIDTH HANGUL" +
	" LETTER OHALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LETTER WAEHALFWIDTH " +
	"HANGUL LETTER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HANGUL LETTER UHALFW" +
	"IDTH HANGUL LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWIDTH HANGUL LETTER " +
	"WIHALFWIDTH HANGUL LETTER YUHALFWIDTH HANGUL LETTER EUHALFWIDTH HANGUL L" +
	"ETTER YIHALFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFULLWIDTH POUND SIGN" +
	"FULLWIDTH NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BARFULLWIDTH YEN SIGN" +
	"FULLWIDTH WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWIDTH LEFTWARDS ARRO" +
	"WHALFWIDTH UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALFWIDTH DOWNWARDS AR" +
	"ROWHALFWIDTH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLINEAR ANNOTATION AN" +
	"CHORINTERLINEAR ANNOTATION SEPARATORINTERLINEAR ANNOTATION TERMINATOROBJ" +
	"ECT REPLACEMENT CHARACTERREPLACEMENT CHARACTERLINEAR B SYLLABLE B008 ALI" +
	"NEAR B SYLLABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B SYLLABLE B061 OLI" +
	"NEAR B SYLLABLE B010 ULINEAR B SYLLABLE B001 DALINEAR B SYLLABLE B045 DE" +
	"LINEAR B SYLLABLE B007 DILINEAR B SYLLABLE B014 DOLINEAR B SYLLABLE B051" +
	" DULINEAR B SYLLABLE B057 JALINEAR B SYLLABLE B046 JELINEAR B SYLLABLE B" +
	"036 JOLINEAR B SYLLABLE B065 JULINEAR B SYLLABLE B077 KALINEAR B SYLLABL" +
	"E B044 KELINEAR B SYLLABLE B067 KILINEAR B SYLLABLE B070 KOLINEAR B SYLL" +
	"ABLE B081 KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE B013 MELINEAR B S" +
	"YLLABLE B073 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLABLE B023 MULINEAR " +
	"B SYLLABLE B006 NALINEAR B SYLLABLE B024 NELINEAR B SYLLABLE B030 NILINE" +
	"AR B SYLLABLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B SYLLABLE B003 PAL" +
	"INEAR B SYLLABLE B072 PELINEAR B SYLLABLE B039 PILINEAR B SYLLABLE B011 " +
	"POLINEAR B SYLLABLE B050 PULINEAR B SYLLABLE B016 QALINEAR B SYLLABLE B0") + ("" +
	"78 QELINEAR B SYLLABLE B021 QILINEAR B SYLLABLE B032 QOLINEAR B SYLLABLE" +
	" B060 RALINEAR B SYLLABLE B027 RELINEAR B SYLLABLE B053 RILINEAR B SYLLA" +
	"BLE B002 ROLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE B031 SALINEAR B SY" +
	"LLABLE B009 SELINEAR B SYLLABLE B041 SILINEAR B SYLLABLE B012 SOLINEAR B" +
	" SYLLABLE B058 SULINEAR B SYLLABLE B059 TALINEAR B SYLLABLE B004 TELINEA" +
	"R B SYLLABLE B037 TILINEAR B SYLLABLE B005 TOLINEAR B SYLLABLE B069 TULI" +
	"NEAR B SYLLABLE B054 WALINEAR B SYLLABLE B075 WELINEAR B SYLLABLE B040 W" +
	"ILINEAR B SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALINEAR B SYLLABLE B07" +
	"4 ZELINEAR B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2LINEAR B SYLLABLE " +
	"B043 A3LINEAR B SYLLABLE B085 AULINEAR B SYLLABLE B071 DWELINEAR B SYLLA" +
	"BLE B090 DWOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABLE B029 PU2LINEAR B" +
	" SYLLABLE B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B SYLLABLE B033 RA3LI" +
	"NEAR B SYLLABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINEAR B SYLLABLE B087" +
	" TWELINEAR B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINEAR B SYMBOL B019LI" +
	"NEAR B SYMBOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL B047LINEAR B SYMBO" +
	"L B049LINEAR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B SYMBOL B064LINEAR" +
	" B SYMBOL B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083LINEAR B SYMBOL B0" +
	"86LINEAR B SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR B IDEOGRAM B102 W" +
	"OMANLINEAR B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 EQUIDLINEAR B IDEO" +
	"GRAM B105F MARELINEAR B IDEOGRAM B105M STALLIONLINEAR B IDEOGRAM B106F E" +
	"WELINEAR B IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F SHE-GOATLINEAR B ID" +
	"EOGRAM B107M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR B IDEOGRAM B108M B" +
	"OARLINEAR B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M BULLLINEAR B IDEOG" +
	"RAM B120 WHEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B IDEOGRAM B122 OLIVEL" +
	"INEAR B IDEOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPERUSLINEAR B MONOGR" +
	"AM B127 KAPOLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEOGRAM B130 OILLINEA" +
	"R B IDEOGRAM B131 WINELINEAR B IDEOGRAM B132LINEAR B MONOGRAM B133 AREPA" +
	"LINEAR B MONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRONZELINEAR B IDEOGRA" +
	"M B141 GOLDLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B145 WOOLLINEAR B IDE" +
	"OGRAM B146LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151 HORNLINEAR B IDEO" +
	"GRAM B152LINEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154LINEAR B MONOGRAM B" +
	"156 TURO2LINEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158LINEAR B IDEOGRAM B" +
	"159 CLOTHLINEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161LINEAR B IDEOGRAM B" +
	"162 GARMENTLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOGRAM B164LINEAR B I" +
	"DEOGRAM B165LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B167LINEAR B IDEOGRA" +
	"M B168LINEAR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINEAR B IDEOGRAM B171" +
	"LINEAR B IDEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINEAR B IDEOGRAM B174" +
	"LINEAR B IDEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEAR B IDEOGRAM B178L" +
	"INEAR B IDEOGRAM B179LINEAR B IDEOGRAM B180LINEAR B IDEOGRAM B181LINEAR " +
	"B IDEOGRAM B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM B184LINEAR B IDEO" +
	"GRAM B185LINEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190LINEAR B IDEOGRAM B" +
	"191 HELMETLINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDEOGRAM B225 BATHTUB" +
	"LINEAR B IDEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARROWLINEAR B IDEOGRA" +
	"M B232LINEAR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B234LINEAR B IDEOGRA" +
	"M B236LINEAR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B IDEOGRAM B241 CHARI" +
	"OTLINEAR B IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRAM B243 WHEELLINEAR" +
	" B IDEOGRAM B245LINEAR B IDEOGRAM B246LINEAR B MONOGRAM B247 DIPTELINEAR" +
	" B IDEOGRAM B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRAM B251LINEAR B IDE" +
	"OGRAM B252LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254 DARTLINEAR B IDEO" +
	"GRAM B255LINEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257LINEAR B IDEOGRAM B" +
	"258LINEAR B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155LINEAR B IDEOGRAM " +
	"VESSEL B200LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOGRAM VESSEL B202LIN" +
	"EAR B IDEOGRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B204LINEAR B IDEOGRAM" +
	" VESSEL B205LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEOGRAM VESSEL B207LI" +
	"NEAR B IDEOGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B209LINEAR B IDEOGRA" +
	"M VESSEL B210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDEOGRAM VESSEL B212L" +
	"INEAR B IDEOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B214LINEAR B IDEOGR" +
	"AM VESSEL B215LINEAR B IDEOGRAM VESSEL B216LINEAR B IDEOGRAM VESSEL B217" +
	"LINEAR B IDEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL B219LINEAR B IDEOG" +
	"RAM VESSEL B221LINEAR B IDEOGRAM VESSEL B222LINEAR B IDEOGRAM VESSEL B22" +
	"6LINEAR B IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL B228LINEAR B IDEO" +
	"GRAM VESSEL B229LINEAR B IDEOGRAM VESSEL B250LINEAR B IDEOGRAM VESSEL B3" +
	"05AEGEAN WORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTAEGEAN CHECK MARKAE" +
	"GEAN NUMBER ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEGEAN NUMBER FOURAEG") + ("" +
	"EAN NUMBER FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEGEAN NUMBER EIGHTAE" +
	"GEAN NUMBER NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYAEGEAN NUMBER THIRT" +
	"YAEGEAN NUMBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER SIXTYAEGEAN NUMBER " +
	"SEVENTYAEGEAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN NUMBER ONE HUNDRED" +
	"AEGEAN NUMBER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAEGEAN NUMBER FOUR H" +
	"UNDREDAEGEAN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUNDREDAEGEAN NUMBER S" +
	"EVEN HUNDREDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER NINE HUNDREDAEGEAN " +
	"NUMBER ONE THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NUMBER THREE THOUSAN" +
	"DAEGEAN NUMBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSANDAEGEAN NUMBER SIX" +
	" THOUSANDAEGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIGHT THOUSANDAEGEAN " +
	"NUMBER NINE THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN NUMBER TWENTY THOUS" +
	"ANDAEGEAN NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY THOUSANDAEGEAN NUMBE" +
	"R FIFTY THOUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUMBER SEVENTY THOUSA" +
	"NDAEGEAN NUMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY THOUSANDAEGEAN WEIGH" +
	"T BASE UNITAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SECOND SUBUNITAEGEAN" +
	" WEIGHT THIRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEAN DRY MEASURE FIRS" +
	"T SUBUNITAEGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEASURE SECOND SUBUNI" +
	"TAEGEAN MEASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ONE QUARTERGREEK ACR" +
	"OPHONIC ATTIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACHMAGREEK ACROPHONIC" +
	" ATTIC FIVEGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONIC ATTIC FIVE HUNDR" +
	"EDGREEK ACROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC ATTIC FIFTY THOUS" +
	"ANDGREEK ACROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC ATTIC TEN TALENTS" +
	"GREEK ACROPHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC ATTIC ONE HUNDRED T" +
	"ALENTSGREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK ACROPHONIC ATTIC " +
	"ONE THOUSAND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTSGREEK AC" +
	"ROPHONIC ATTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN STATERSGREEK ACROP" +
	"HONIC ATTIC FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HUNDRED STATERSGREEK" +
	" ACROPHONIC ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC ATTIC ONE THOUSAN" +
	"D STATERSGREEK ACROPHONIC ATTIC TEN THOUSAND STATERSGREEK ACROPHONIC ATT" +
	"IC FIFTY THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MNASGREEK ACROPHONIC" +
	" HERAEUM ONE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREEK ACROPHONIC HERMI" +
	"ONIAN ONEGREEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHONIC THESPIAN TWOGRE" +
	"EK ACROPHONIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EPIDAUREAN TWO DRACH" +
	"MASGREEK ACROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TROEZENIAN TENGREEK " +
	"ACROPHONIC TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN TENG" +
	"REEK ACROPHONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN TENGREEK ACROPHON" +
	"IC THESPIAN THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGREEK ACROPHONIC TROE" +
	"ZENIAN FIFTY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN FIFTYGREEK ACROPH" +
	"ONIC THESPIAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDREDGREEK ACROPHONIC" +
	" THESPIAN THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIVE HUNDREDGREEK ACR" +
	"OPHONIC TROEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN FIVE HUNDREDGRE" +
	"EK ACROPHONIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC NAXIAN FIVE HUNDRED" +
	"GREEK ACROPHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC THESPIAN FIVE THO" +
	"USANDGREEK ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONIC STRATIAN FIFTY M" +
	"NASGREEK ONE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FORMGREEK TWO THIRDS" +
	" SIGNGREEK THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TALENT SIGNGREEK DRAC" +
	"HMA SIGNGREEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE OBOLS SIGNGREEK F" +
	"OUR OBOLS SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGNGREEK KYATHOS BASE" +
	" SIGNGREEK LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIGNGREEK ARTABE SIGN" +
	"GREEK AROURA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE SIGNGREEK ZERO SIG" +
	"NGREEK ONE QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICTION SIGNNOMISMA SI" +
	"GNROMAN SEXTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIGNROMAN SEXTULA SIG" +
	"NROMAN DIMIDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DENARIUS SIGNROMAN QU" +
	"INARIUS SIGNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNROMAN AS SIGNROMAN " +
	"CENTURIAL SIGNGREEK SYMBOL TAU RHOPHAISTOS DISC SIGN PEDESTRIANPHAISTOS " +
	"DISC SIGN PLUMED HEADPHAISTOS DISC SIGN TATTOOED HEADPHAISTOS DISC SIGN " +
	"CAPTIVEPHAISTOS DISC SIGN CHILDPHAISTOS DISC SIGN WOMANPHAISTOS DISC SIG" +
	"N HELMETPHAISTOS DISC SIGN GAUNTLETPHAISTOS DISC SIGN TIARAPHAISTOS DISC" +
	" SIGN ARROWPHAISTOS DISC SIGN BOWPHAISTOS DISC SIGN SHIELDPHAISTOS DISC " +
	"SIGN CLUBPHAISTOS DISC SIGN MANACLESPHAISTOS DISC SIGN MATTOCKPHAISTOS D" +
	"ISC SIGN SAWPHAISTOS DISC SIGN LIDPHAISTOS DISC SIGN BOOMERANGPHAISTOS D" +
	"ISC SIGN CARPENTRY PLANEPHAISTOS DISC SIGN DOLIUMPHAISTOS DISC SIGN COMB" +
	"PHAISTOS DISC SIGN SLINGPHAISTOS DISC SIGN COLUMNPHAISTOS DISC SIGN BEEH" +
	"IVEPHAISTOS DISC SIGN SHIPPHAISTOS DISC SIGN HORNPHAISTOS DISC SIGN HIDE") + ("" +
	"PHAISTOS DISC SIGN BULLS LEGPHAISTOS DISC SIGN CATPHAISTOS DISC SIGN RAM" +
	"PHAISTOS DISC SIGN EAGLEPHAISTOS DISC SIGN DOVEPHAISTOS DISC SIGN TUNNYP" +
	"HAISTOS DISC SIGN BEEPHAISTOS DISC SIGN PLANE TREEPHAISTOS DISC SIGN VIN" +
	"EPHAISTOS DISC SIGN PAPYRUSPHAISTOS DISC SIGN ROSETTEPHAISTOS DISC SIGN " +
	"LILYPHAISTOS DISC SIGN OX BACKPHAISTOS DISC SIGN FLUTEPHAISTOS DISC SIGN" +
	" GRATERPHAISTOS DISC SIGN STRAINERPHAISTOS DISC SIGN SMALL AXEPHAISTOS D" +
	"ISC SIGN WAVY BANDPHAISTOS DISC SIGN COMBINING OBLIQUE STROKELYCIAN LETT" +
	"ER ALYCIAN LETTER ELYCIAN LETTER BLYCIAN LETTER BHLYCIAN LETTER GLYCIAN " +
	"LETTER DLYCIAN LETTER ILYCIAN LETTER WLYCIAN LETTER ZLYCIAN LETTER THLYC" +
	"IAN LETTER JLYCIAN LETTER KLYCIAN LETTER QLYCIAN LETTER LLYCIAN LETTER M" +
	"LYCIAN LETTER NLYCIAN LETTER MMLYCIAN LETTER NNLYCIAN LETTER ULYCIAN LET" +
	"TER PLYCIAN LETTER KKLYCIAN LETTER RLYCIAN LETTER SLYCIAN LETTER TLYCIAN" +
	" LETTER TTLYCIAN LETTER ANLYCIAN LETTER ENLYCIAN LETTER HLYCIAN LETTER X" +
	"CARIAN LETTER ACARIAN LETTER P2CARIAN LETTER DCARIAN LETTER LCARIAN LETT" +
	"ER UUUCARIAN LETTER RCARIAN LETTER LDCARIAN LETTER A2CARIAN LETTER QCARI" +
	"AN LETTER BCARIAN LETTER MCARIAN LETTER OCARIAN LETTER D2CARIAN LETTER T" +
	"CARIAN LETTER SHCARIAN LETTER SH2CARIAN LETTER SCARIAN LETTER C-18CARIAN" +
	" LETTER UCARIAN LETTER NNCARIAN LETTER XCARIAN LETTER NCARIAN LETTER TT2" +
	"CARIAN LETTER PCARIAN LETTER SSCARIAN LETTER ICARIAN LETTER ECARIAN LETT" +
	"ER UUUUCARIAN LETTER KCARIAN LETTER K2CARIAN LETTER NDCARIAN LETTER UUCA" +
	"RIAN LETTER GCARIAN LETTER G2CARIAN LETTER STCARIAN LETTER ST2CARIAN LET" +
	"TER NGCARIAN LETTER IICARIAN LETTER C-39CARIAN LETTER TTCARIAN LETTER UU" +
	"U2CARIAN LETTER RRCARIAN LETTER MBCARIAN LETTER MB2CARIAN LETTER MB3CARI" +
	"AN LETTER MB4CARIAN LETTER LD2CARIAN LETTER E2CARIAN LETTER UUU3COPTIC E" +
	"PACT THOUSANDS MARKCOPTIC EPACT DIGIT ONECOPTIC EPACT DIGIT TWOCOPTIC EP" +
	"ACT DIGIT THREECOPTIC EPACT DIGIT FOURCOPTIC EPACT DIGIT FIVECOPTIC EPAC" +
	"T DIGIT SIXCOPTIC EPACT DIGIT SEVENCOPTIC EPACT DIGIT EIGHTCOPTIC EPACT " +
	"DIGIT NINECOPTIC EPACT NUMBER TENCOPTIC EPACT NUMBER TWENTYCOPTIC EPACT " +
	"NUMBER THIRTYCOPTIC EPACT NUMBER FORTYCOPTIC EPACT NUMBER FIFTYCOPTIC EP" +
	"ACT NUMBER SIXTYCOPTIC EPACT NUMBER SEVENTYCOPTIC EPACT NUMBER EIGHTYCOP" +
	"TIC EPACT NUMBER NINETYCOPTIC EPACT NUMBER ONE HUNDREDCOPTIC EPACT NUMBE" +
	"R TWO HUNDREDCOPTIC EPACT NUMBER THREE HUNDREDCOPTIC EPACT NUMBER FOUR H" +
	"UNDREDCOPTIC EPACT NUMBER FIVE HUNDREDCOPTIC EPACT NUMBER SIX HUNDREDCOP" +
	"TIC EPACT NUMBER SEVEN HUNDREDCOPTIC EPACT NUMBER EIGHT HUNDREDCOPTIC EP" +
	"ACT NUMBER NINE HUNDREDOLD ITALIC LETTER AOLD ITALIC LETTER BEOLD ITALIC" +
	" LETTER KEOLD ITALIC LETTER DEOLD ITALIC LETTER EOLD ITALIC LETTER VEOLD" +
	" ITALIC LETTER ZEOLD ITALIC LETTER HEOLD ITALIC LETTER THEOLD ITALIC LET" +
	"TER IOLD ITALIC LETTER KAOLD ITALIC LETTER ELOLD ITALIC LETTER EMOLD ITA" +
	"LIC LETTER ENOLD ITALIC LETTER ESHOLD ITALIC LETTER OOLD ITALIC LETTER P" +
	"EOLD ITALIC LETTER SHEOLD ITALIC LETTER KUOLD ITALIC LETTER EROLD ITALIC" +
	" LETTER ESOLD ITALIC LETTER TEOLD ITALIC LETTER UOLD ITALIC LETTER EKSOL" +
	"D ITALIC LETTER PHEOLD ITALIC LETTER KHEOLD ITALIC LETTER EFOLD ITALIC L" +
	"ETTER ERSOLD ITALIC LETTER CHEOLD ITALIC LETTER IIOLD ITALIC LETTER UUOL" +
	"D ITALIC LETTER ESSOLD ITALIC NUMERAL ONEOLD ITALIC NUMERAL FIVEOLD ITAL" +
	"IC NUMERAL TENOLD ITALIC NUMERAL FIFTYOLD ITALIC LETTER YEOLD ITALIC LET" +
	"TER NORTHERN TSEOLD ITALIC LETTER SOUTHERN TSEGOTHIC LETTER AHSAGOTHIC L" +
	"ETTER BAIRKANGOTHIC LETTER GIBAGOTHIC LETTER DAGSGOTHIC LETTER AIHVUSGOT" +
	"HIC LETTER QAIRTHRAGOTHIC LETTER IUJAGOTHIC LETTER HAGLGOTHIC LETTER THI" +
	"UTHGOTHIC LETTER EISGOTHIC LETTER KUSMAGOTHIC LETTER LAGUSGOTHIC LETTER " +
	"MANNAGOTHIC LETTER NAUTHSGOTHIC LETTER JERGOTHIC LETTER URUSGOTHIC LETTE" +
	"R PAIRTHRAGOTHIC LETTER NINETYGOTHIC LETTER RAIDAGOTHIC LETTER SAUILGOTH" +
	"IC LETTER TEIWSGOTHIC LETTER WINJAGOTHIC LETTER FAIHUGOTHIC LETTER IGGWS" +
	"GOTHIC LETTER HWAIRGOTHIC LETTER OTHALGOTHIC LETTER NINE HUNDREDOLD PERM" +
	"IC LETTER ANOLD PERMIC LETTER BUROLD PERMIC LETTER GAIOLD PERMIC LETTER " +
	"DOIOLD PERMIC LETTER EOLD PERMIC LETTER ZHOIOLD PERMIC LETTER DZHOIOLD P" +
	"ERMIC LETTER ZATAOLD PERMIC LETTER DZITAOLD PERMIC LETTER IOLD PERMIC LE" +
	"TTER KOKEOLD PERMIC LETTER LEIOLD PERMIC LETTER MENOEOLD PERMIC LETTER N" +
	"ENOEOLD PERMIC LETTER VOOIOLD PERMIC LETTER PEEIOLD PERMIC LETTER REIOLD" +
	" PERMIC LETTER SIIOLD PERMIC LETTER TAIOLD PERMIC LETTER UOLD PERMIC LET" +
	"TER CHERYOLD PERMIC LETTER SHOOIOLD PERMIC LETTER SHCHOOIOLD PERMIC LETT" +
	"ER YRYOLD PERMIC LETTER YERUOLD PERMIC LETTER OOLD PERMIC LETTER OOOLD P" +
	"ERMIC LETTER EFOLD PERMIC LETTER HAOLD PERMIC LETTER TSIUOLD PERMIC LETT" +
	"ER VEROLD PERMIC LETTER YEROLD PERMIC LETTER YERIOLD PERMIC LETTER YATOL" +
	"D PERMIC LETTER IEOLD PERMIC LETTER YUOLD PERMIC LETTER YAOLD PERMIC LET") + ("" +
	"TER IACOMBINING OLD PERMIC LETTER ANCOMBINING OLD PERMIC LETTER DOICOMBI" +
	"NING OLD PERMIC LETTER ZATACOMBINING OLD PERMIC LETTER NENOECOMBINING OL" +
	"D PERMIC LETTER SIIUGARITIC LETTER ALPAUGARITIC LETTER BETAUGARITIC LETT" +
	"ER GAMLAUGARITIC LETTER KHAUGARITIC LETTER DELTAUGARITIC LETTER HOUGARIT" +
	"IC LETTER WOUGARITIC LETTER ZETAUGARITIC LETTER HOTAUGARITIC LETTER TETU" +
	"GARITIC LETTER YODUGARITIC LETTER KAFUGARITIC LETTER SHINUGARITIC LETTER" +
	" LAMDAUGARITIC LETTER MEMUGARITIC LETTER DHALUGARITIC LETTER NUNUGARITIC" +
	" LETTER ZUUGARITIC LETTER SAMKAUGARITIC LETTER AINUGARITIC LETTER PUUGAR" +
	"ITIC LETTER SADEUGARITIC LETTER QOPAUGARITIC LETTER RASHAUGARITIC LETTER" +
	" THANNAUGARITIC LETTER GHAINUGARITIC LETTER TOUGARITIC LETTER IUGARITIC " +
	"LETTER UUGARITIC LETTER SSUUGARITIC WORD DIVIDEROLD PERSIAN SIGN AOLD PE" +
	"RSIAN SIGN IOLD PERSIAN SIGN UOLD PERSIAN SIGN KAOLD PERSIAN SIGN KUOLD " +
	"PERSIAN SIGN GAOLD PERSIAN SIGN GUOLD PERSIAN SIGN XAOLD PERSIAN SIGN CA" +
	"OLD PERSIAN SIGN JAOLD PERSIAN SIGN JIOLD PERSIAN SIGN TAOLD PERSIAN SIG" +
	"N TUOLD PERSIAN SIGN DAOLD PERSIAN SIGN DIOLD PERSIAN SIGN DUOLD PERSIAN" +
	" SIGN THAOLD PERSIAN SIGN PAOLD PERSIAN SIGN BAOLD PERSIAN SIGN FAOLD PE" +
	"RSIAN SIGN NAOLD PERSIAN SIGN NUOLD PERSIAN SIGN MAOLD PERSIAN SIGN MIOL" +
	"D PERSIAN SIGN MUOLD PERSIAN SIGN YAOLD PERSIAN SIGN VAOLD PERSIAN SIGN " +
	"VIOLD PERSIAN SIGN RAOLD PERSIAN SIGN RUOLD PERSIAN SIGN LAOLD PERSIAN S" +
	"IGN SAOLD PERSIAN SIGN ZAOLD PERSIAN SIGN SHAOLD PERSIAN SIGN SSAOLD PER" +
	"SIAN SIGN HAOLD PERSIAN SIGN AURAMAZDAAOLD PERSIAN SIGN AURAMAZDAA-2OLD " +
	"PERSIAN SIGN AURAMAZDAAHAOLD PERSIAN SIGN XSHAAYATHIYAOLD PERSIAN SIGN D" +
	"AHYAAUSHOLD PERSIAN SIGN DAHYAAUSH-2OLD PERSIAN SIGN BAGAOLD PERSIAN SIG" +
	"N BUUMISHOLD PERSIAN WORD DIVIDEROLD PERSIAN NUMBER ONEOLD PERSIAN NUMBE" +
	"R TWOOLD PERSIAN NUMBER TENOLD PERSIAN NUMBER TWENTYOLD PERSIAN NUMBER H" +
	"UNDREDDESERET CAPITAL LETTER LONG IDESERET CAPITAL LETTER LONG EDESERET " +
	"CAPITAL LETTER LONG ADESERET CAPITAL LETTER LONG AHDESERET CAPITAL LETTE" +
	"R LONG ODESERET CAPITAL LETTER LONG OODESERET CAPITAL LETTER SHORT IDESE" +
	"RET CAPITAL LETTER SHORT EDESERET CAPITAL LETTER SHORT ADESERET CAPITAL " +
	"LETTER SHORT AHDESERET CAPITAL LETTER SHORT ODESERET CAPITAL LETTER SHOR" +
	"T OODESERET CAPITAL LETTER AYDESERET CAPITAL LETTER OWDESERET CAPITAL LE" +
	"TTER WUDESERET CAPITAL LETTER YEEDESERET CAPITAL LETTER HDESERET CAPITAL" +
	" LETTER PEEDESERET CAPITAL LETTER BEEDESERET CAPITAL LETTER TEEDESERET C" +
	"APITAL LETTER DEEDESERET CAPITAL LETTER CHEEDESERET CAPITAL LETTER JEEDE" +
	"SERET CAPITAL LETTER KAYDESERET CAPITAL LETTER GAYDESERET CAPITAL LETTER" +
	" EFDESERET CAPITAL LETTER VEEDESERET CAPITAL LETTER ETHDESERET CAPITAL L" +
	"ETTER THEEDESERET CAPITAL LETTER ESDESERET CAPITAL LETTER ZEEDESERET CAP" +
	"ITAL LETTER ESHDESERET CAPITAL LETTER ZHEEDESERET CAPITAL LETTER ERDESER" +
	"ET CAPITAL LETTER ELDESERET CAPITAL LETTER EMDESERET CAPITAL LETTER ENDE" +
	"SERET CAPITAL LETTER ENGDESERET CAPITAL LETTER OIDESERET CAPITAL LETTER " +
	"EWDESERET SMALL LETTER LONG IDESERET SMALL LETTER LONG EDESERET SMALL LE" +
	"TTER LONG ADESERET SMALL LETTER LONG AHDESERET SMALL LETTER LONG ODESERE" +
	"T SMALL LETTER LONG OODESERET SMALL LETTER SHORT IDESERET SMALL LETTER S" +
	"HORT EDESERET SMALL LETTER SHORT ADESERET SMALL LETTER SHORT AHDESERET S" +
	"MALL LETTER SHORT ODESERET SMALL LETTER SHORT OODESERET SMALL LETTER AYD" +
	"ESERET SMALL LETTER OWDESERET SMALL LETTER WUDESERET SMALL LETTER YEEDES" +
	"ERET SMALL LETTER HDESERET SMALL LETTER PEEDESERET SMALL LETTER BEEDESER" +
	"ET SMALL LETTER TEEDESERET SMALL LETTER DEEDESERET SMALL LETTER CHEEDESE" +
	"RET SMALL LETTER JEEDESERET SMALL LETTER KAYDESERET SMALL LETTER GAYDESE" +
	"RET SMALL LETTER EFDESERET SMALL LETTER VEEDESERET SMALL LETTER ETHDESER" +
	"ET SMALL LETTER THEEDESERET SMALL LETTER ESDESERET SMALL LETTER ZEEDESER" +
	"ET SMALL LETTER ESHDESERET SMALL LETTER ZHEEDESERET SMALL LETTER ERDESER" +
	"ET SMALL LETTER ELDESERET SMALL LETTER EMDESERET SMALL LETTER ENDESERET " +
	"SMALL LETTER ENGDESERET SMALL LETTER OIDESERET SMALL LETTER EWSHAVIAN LE" +
	"TTER PEEPSHAVIAN LETTER TOTSHAVIAN LETTER KICKSHAVIAN LETTER FEESHAVIAN " +
	"LETTER THIGHSHAVIAN LETTER SOSHAVIAN LETTER SURESHAVIAN LETTER CHURCHSHA" +
	"VIAN LETTER YEASHAVIAN LETTER HUNGSHAVIAN LETTER BIBSHAVIAN LETTER DEADS" +
	"HAVIAN LETTER GAGSHAVIAN LETTER VOWSHAVIAN LETTER THEYSHAVIAN LETTER ZOO" +
	"SHAVIAN LETTER MEASURESHAVIAN LETTER JUDGESHAVIAN LETTER WOESHAVIAN LETT" +
	"ER HA-HASHAVIAN LETTER LOLLSHAVIAN LETTER MIMESHAVIAN LETTER IFSHAVIAN L" +
	"ETTER EGGSHAVIAN LETTER ASHSHAVIAN LETTER ADOSHAVIAN LETTER ONSHAVIAN LE" +
	"TTER WOOLSHAVIAN LETTER OUTSHAVIAN LETTER AHSHAVIAN LETTER ROARSHAVIAN L" +
	"ETTER NUNSHAVIAN LETTER EATSHAVIAN LETTER AGESHAVIAN LETTER ICESHAVIAN L" +
	"ETTER UPSHAVIAN LETTER OAKSHAVIAN LETTER OOZESHAVIAN LETTER OILSHAVIAN L") + ("" +
	"ETTER AWESHAVIAN LETTER ARESHAVIAN LETTER ORSHAVIAN LETTER AIRSHAVIAN LE" +
	"TTER ERRSHAVIAN LETTER ARRAYSHAVIAN LETTER EARSHAVIAN LETTER IANSHAVIAN " +
	"LETTER YEWOSMANYA LETTER ALEFOSMANYA LETTER BAOSMANYA LETTER TAOSMANYA L" +
	"ETTER JAOSMANYA LETTER XAOSMANYA LETTER KHAOSMANYA LETTER DEELOSMANYA LE" +
	"TTER RAOSMANYA LETTER SAOSMANYA LETTER SHIINOSMANYA LETTER DHAOSMANYA LE" +
	"TTER CAYNOSMANYA LETTER GAOSMANYA LETTER FAOSMANYA LETTER QAAFOSMANYA LE" +
	"TTER KAAFOSMANYA LETTER LAANOSMANYA LETTER MIINOSMANYA LETTER NUUNOSMANY" +
	"A LETTER WAWOSMANYA LETTER HAOSMANYA LETTER YAOSMANYA LETTER AOSMANYA LE" +
	"TTER EOSMANYA LETTER IOSMANYA LETTER OOSMANYA LETTER UOSMANYA LETTER AAO" +
	"SMANYA LETTER EEOSMANYA LETTER OOOSMANYA DIGIT ZEROOSMANYA DIGIT ONEOSMA" +
	"NYA DIGIT TWOOSMANYA DIGIT THREEOSMANYA DIGIT FOUROSMANYA DIGIT FIVEOSMA" +
	"NYA DIGIT SIXOSMANYA DIGIT SEVENOSMANYA DIGIT EIGHTOSMANYA DIGIT NINEOSA" +
	"GE CAPITAL LETTER AOSAGE CAPITAL LETTER AIOSAGE CAPITAL LETTER AINOSAGE " +
	"CAPITAL LETTER AHOSAGE CAPITAL LETTER BRAOSAGE CAPITAL LETTER CHAOSAGE C" +
	"APITAL LETTER EHCHAOSAGE CAPITAL LETTER EOSAGE CAPITAL LETTER EINOSAGE C" +
	"APITAL LETTER HAOSAGE CAPITAL LETTER HYAOSAGE CAPITAL LETTER IOSAGE CAPI" +
	"TAL LETTER KAOSAGE CAPITAL LETTER EHKAOSAGE CAPITAL LETTER KYAOSAGE CAPI" +
	"TAL LETTER LAOSAGE CAPITAL LETTER MAOSAGE CAPITAL LETTER NAOSAGE CAPITAL" +
	" LETTER OOSAGE CAPITAL LETTER OINOSAGE CAPITAL LETTER PAOSAGE CAPITAL LE" +
	"TTER EHPAOSAGE CAPITAL LETTER SAOSAGE CAPITAL LETTER SHAOSAGE CAPITAL LE" +
	"TTER TAOSAGE CAPITAL LETTER EHTAOSAGE CAPITAL LETTER TSAOSAGE CAPITAL LE" +
	"TTER EHTSAOSAGE CAPITAL LETTER TSHAOSAGE CAPITAL LETTER DHAOSAGE CAPITAL" +
	" LETTER UOSAGE CAPITAL LETTER WAOSAGE CAPITAL LETTER KHAOSAGE CAPITAL LE" +
	"TTER GHAOSAGE CAPITAL LETTER ZAOSAGE CAPITAL LETTER ZHAOSAGE SMALL LETTE" +
	"R AOSAGE SMALL LETTER AIOSAGE SMALL LETTER AINOSAGE SMALL LETTER AHOSAGE" +
	" SMALL LETTER BRAOSAGE SMALL LETTER CHAOSAGE SMALL LETTER EHCHAOSAGE SMA" +
	"LL LETTER EOSAGE SMALL LETTER EINOSAGE SMALL LETTER HAOSAGE SMALL LETTER" +
	" HYAOSAGE SMALL LETTER IOSAGE SMALL LETTER KAOSAGE SMALL LETTER EHKAOSAG" +
	"E SMALL LETTER KYAOSAGE SMALL LETTER LAOSAGE SMALL LETTER MAOSAGE SMALL " +
	"LETTER NAOSAGE SMALL LETTER OOSAGE SMALL LETTER OINOSAGE SMALL LETTER PA" +
	"OSAGE SMALL LETTER EHPAOSAGE SMALL LETTER SAOSAGE SMALL LETTER SHAOSAGE " +
	"SMALL LETTER TAOSAGE SMALL LETTER EHTAOSAGE SMALL LETTER TSAOSAGE SMALL " +
	"LETTER EHTSAOSAGE SMALL LETTER TSHAOSAGE SMALL LETTER DHAOSAGE SMALL LET" +
	"TER UOSAGE SMALL LETTER WAOSAGE SMALL LETTER KHAOSAGE SMALL LETTER GHAOS" +
	"AGE SMALL LETTER ZAOSAGE SMALL LETTER ZHAELBASAN LETTER AELBASAN LETTER " +
	"BEELBASAN LETTER CEELBASAN LETTER CHEELBASAN LETTER DEELBASAN LETTER NDE" +
	"ELBASAN LETTER DHEELBASAN LETTER EIELBASAN LETTER EELBASAN LETTER FEELBA" +
	"SAN LETTER GEELBASAN LETTER GJEELBASAN LETTER HEELBASAN LETTER IELBASAN " +
	"LETTER JEELBASAN LETTER KEELBASAN LETTER LEELBASAN LETTER LLEELBASAN LET" +
	"TER MEELBASAN LETTER NEELBASAN LETTER NAELBASAN LETTER NJEELBASAN LETTER" +
	" OELBASAN LETTER PEELBASAN LETTER QEELBASAN LETTER REELBASAN LETTER RREE" +
	"LBASAN LETTER SEELBASAN LETTER SHEELBASAN LETTER TEELBASAN LETTER THEELB" +
	"ASAN LETTER UELBASAN LETTER VEELBASAN LETTER XEELBASAN LETTER YELBASAN L" +
	"ETTER ZEELBASAN LETTER ZHEELBASAN LETTER GHEELBASAN LETTER GHAMMAELBASAN" +
	" LETTER KHECAUCASIAN ALBANIAN LETTER ALTCAUCASIAN ALBANIAN LETTER BETCAU" +
	"CASIAN ALBANIAN LETTER GIMCAUCASIAN ALBANIAN LETTER DATCAUCASIAN ALBANIA" +
	"N LETTER EBCAUCASIAN ALBANIAN LETTER ZARLCAUCASIAN ALBANIAN LETTER EYNCA" +
	"UCASIAN ALBANIAN LETTER ZHILCAUCASIAN ALBANIAN LETTER TASCAUCASIAN ALBAN" +
	"IAN LETTER CHACAUCASIAN ALBANIAN LETTER YOWDCAUCASIAN ALBANIAN LETTER ZH" +
	"ACAUCASIAN ALBANIAN LETTER IRBCAUCASIAN ALBANIAN LETTER SHACAUCASIAN ALB" +
	"ANIAN LETTER LANCAUCASIAN ALBANIAN LETTER INYACAUCASIAN ALBANIAN LETTER " +
	"XEYNCAUCASIAN ALBANIAN LETTER DYANCAUCASIAN ALBANIAN LETTER CARCAUCASIAN" +
	" ALBANIAN LETTER JHOXCAUCASIAN ALBANIAN LETTER KARCAUCASIAN ALBANIAN LET" +
	"TER LYITCAUCASIAN ALBANIAN LETTER HEYTCAUCASIAN ALBANIAN LETTER QAYCAUCA" +
	"SIAN ALBANIAN LETTER AORCAUCASIAN ALBANIAN LETTER CHOYCAUCASIAN ALBANIAN" +
	" LETTER CHICAUCASIAN ALBANIAN LETTER CYAYCAUCASIAN ALBANIAN LETTER MAQCA" +
	"UCASIAN ALBANIAN LETTER QARCAUCASIAN ALBANIAN LETTER NOWCCAUCASIAN ALBAN" +
	"IAN LETTER DZYAYCAUCASIAN ALBANIAN LETTER SHAKCAUCASIAN ALBANIAN LETTER " +
	"JAYNCAUCASIAN ALBANIAN LETTER ONCAUCASIAN ALBANIAN LETTER TYAYCAUCASIAN " +
	"ALBANIAN LETTER FAMCAUCASIAN ALBANIAN LETTER DZAYCAUCASIAN ALBANIAN LETT" +
	"ER CHATCAUCASIAN ALBANIAN LETTER PENCAUCASIAN ALBANIAN LETTER GHEYSCAUCA" +
	"SIAN ALBANIAN LETTER RATCAUCASIAN ALBANIAN LETTER SEYKCAUCASIAN ALBANIAN" +
	" LETTER VEYZCAUCASIAN ALBANIAN LETTER TIWRCAUCASIAN ALBANIAN LETTER SHOY" +
	"CAUCASIAN ALBANIAN LETTER IWNCAUCASIAN ALBANIAN LETTER CYAWCAUCASIAN ALB") + ("" +
	"ANIAN LETTER CAYNCAUCASIAN ALBANIAN LETTER YAYDCAUCASIAN ALBANIAN LETTER" +
	" PIWRCAUCASIAN ALBANIAN LETTER KIWCAUCASIAN ALBANIAN CITATION MARKLINEAR" +
	" A SIGN AB001LINEAR A SIGN AB002LINEAR A SIGN AB003LINEAR A SIGN AB004LI" +
	"NEAR A SIGN AB005LINEAR A SIGN AB006LINEAR A SIGN AB007LINEAR A SIGN AB0" +
	"08LINEAR A SIGN AB009LINEAR A SIGN AB010LINEAR A SIGN AB011LINEAR A SIGN" +
	" AB013LINEAR A SIGN AB016LINEAR A SIGN AB017LINEAR A SIGN AB020LINEAR A " +
	"SIGN AB021LINEAR A SIGN AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB022LIN" +
	"EAR A SIGN AB022FLINEAR A SIGN AB022MLINEAR A SIGN AB023LINEAR A SIGN AB" +
	"023MLINEAR A SIGN AB024LINEAR A SIGN AB026LINEAR A SIGN AB027LINEAR A SI" +
	"GN AB028LINEAR A SIGN A028BLINEAR A SIGN AB029LINEAR A SIGN AB030LINEAR " +
	"A SIGN AB031LINEAR A SIGN AB034LINEAR A SIGN AB037LINEAR A SIGN AB038LIN" +
	"EAR A SIGN AB039LINEAR A SIGN AB040LINEAR A SIGN AB041LINEAR A SIGN AB04" +
	"4LINEAR A SIGN AB045LINEAR A SIGN AB046LINEAR A SIGN AB047LINEAR A SIGN " +
	"AB048LINEAR A SIGN AB049LINEAR A SIGN AB050LINEAR A SIGN AB051LINEAR A S" +
	"IGN AB053LINEAR A SIGN AB054LINEAR A SIGN AB055LINEAR A SIGN AB056LINEAR" +
	" A SIGN AB057LINEAR A SIGN AB058LINEAR A SIGN AB059LINEAR A SIGN AB060LI" +
	"NEAR A SIGN AB061LINEAR A SIGN AB065LINEAR A SIGN AB066LINEAR A SIGN AB0" +
	"67LINEAR A SIGN AB069LINEAR A SIGN AB070LINEAR A SIGN AB073LINEAR A SIGN" +
	" AB074LINEAR A SIGN AB076LINEAR A SIGN AB077LINEAR A SIGN AB078LINEAR A " +
	"SIGN AB079LINEAR A SIGN AB080LINEAR A SIGN AB081LINEAR A SIGN AB082LINEA" +
	"R A SIGN AB085LINEAR A SIGN AB086LINEAR A SIGN AB087LINEAR A SIGN A100-1" +
	"02LINEAR A SIGN AB118LINEAR A SIGN AB120LINEAR A SIGN A120BLINEAR A SIGN" +
	" AB122LINEAR A SIGN AB123LINEAR A SIGN AB131ALINEAR A SIGN AB131BLINEAR " +
	"A SIGN A131CLINEAR A SIGN AB164LINEAR A SIGN AB171LINEAR A SIGN AB180LIN" +
	"EAR A SIGN AB188LINEAR A SIGN AB191LINEAR A SIGN A301LINEAR A SIGN A302L" +
	"INEAR A SIGN A303LINEAR A SIGN A304LINEAR A SIGN A305LINEAR A SIGN A306L" +
	"INEAR A SIGN A307LINEAR A SIGN A308LINEAR A SIGN A309ALINEAR A SIGN A309" +
	"BLINEAR A SIGN A309CLINEAR A SIGN A310LINEAR A SIGN A311LINEAR A SIGN A3" +
	"12LINEAR A SIGN A313ALINEAR A SIGN A313BLINEAR A SIGN A313CLINEAR A SIGN" +
	" A314LINEAR A SIGN A315LINEAR A SIGN A316LINEAR A SIGN A317LINEAR A SIGN" +
	" A318LINEAR A SIGN A319LINEAR A SIGN A320LINEAR A SIGN A321LINEAR A SIGN" +
	" A322LINEAR A SIGN A323LINEAR A SIGN A324LINEAR A SIGN A325LINEAR A SIGN" +
	" A326LINEAR A SIGN A327LINEAR A SIGN A328LINEAR A SIGN A329LINEAR A SIGN" +
	" A330LINEAR A SIGN A331LINEAR A SIGN A332LINEAR A SIGN A333LINEAR A SIGN" +
	" A334LINEAR A SIGN A335LINEAR A SIGN A336LINEAR A SIGN A337LINEAR A SIGN" +
	" A338LINEAR A SIGN A339LINEAR A SIGN A340LINEAR A SIGN A341LINEAR A SIGN" +
	" A342LINEAR A SIGN A343LINEAR A SIGN A344LINEAR A SIGN A345LINEAR A SIGN" +
	" A346LINEAR A SIGN A347LINEAR A SIGN A348LINEAR A SIGN A349LINEAR A SIGN" +
	" A350LINEAR A SIGN A351LINEAR A SIGN A352LINEAR A SIGN A353LINEAR A SIGN" +
	" A354LINEAR A SIGN A355LINEAR A SIGN A356LINEAR A SIGN A357LINEAR A SIGN" +
	" A358LINEAR A SIGN A359LINEAR A SIGN A360LINEAR A SIGN A361LINEAR A SIGN" +
	" A362LINEAR A SIGN A363LINEAR A SIGN A364LINEAR A SIGN A365LINEAR A SIGN" +
	" A366LINEAR A SIGN A367LINEAR A SIGN A368LINEAR A SIGN A369LINEAR A SIGN" +
	" A370LINEAR A SIGN A371LINEAR A SIGN A400-VASLINEAR A SIGN A401-VASLINEA" +
	"R A SIGN A402-VASLINEAR A SIGN A403-VASLINEAR A SIGN A404-VASLINEAR A SI" +
	"GN A405-VASLINEAR A SIGN A406-VASLINEAR A SIGN A407-VASLINEAR A SIGN A40" +
	"8-VASLINEAR A SIGN A409-VASLINEAR A SIGN A410-VASLINEAR A SIGN A411-VASL" +
	"INEAR A SIGN A412-VASLINEAR A SIGN A413-VASLINEAR A SIGN A414-VASLINEAR " +
	"A SIGN A415-VASLINEAR A SIGN A416-VASLINEAR A SIGN A417-VASLINEAR A SIGN" +
	" A418-VASLINEAR A SIGN A501LINEAR A SIGN A502LINEAR A SIGN A503LINEAR A " +
	"SIGN A504LINEAR A SIGN A505LINEAR A SIGN A506LINEAR A SIGN A508LINEAR A " +
	"SIGN A509LINEAR A SIGN A510LINEAR A SIGN A511LINEAR A SIGN A512LINEAR A " +
	"SIGN A513LINEAR A SIGN A515LINEAR A SIGN A516LINEAR A SIGN A520LINEAR A " +
	"SIGN A521LINEAR A SIGN A523LINEAR A SIGN A524LINEAR A SIGN A525LINEAR A " +
	"SIGN A526LINEAR A SIGN A527LINEAR A SIGN A528LINEAR A SIGN A529LINEAR A " +
	"SIGN A530LINEAR A SIGN A531LINEAR A SIGN A532LINEAR A SIGN A534LINEAR A " +
	"SIGN A535LINEAR A SIGN A536LINEAR A SIGN A537LINEAR A SIGN A538LINEAR A " +
	"SIGN A539LINEAR A SIGN A540LINEAR A SIGN A541LINEAR A SIGN A542LINEAR A " +
	"SIGN A545LINEAR A SIGN A547LINEAR A SIGN A548LINEAR A SIGN A549LINEAR A " +
	"SIGN A550LINEAR A SIGN A551LINEAR A SIGN A552LINEAR A SIGN A553LINEAR A " +
	"SIGN A554LINEAR A SIGN A555LINEAR A SIGN A556LINEAR A SIGN A557LINEAR A " +
	"SIGN A559LINEAR A SIGN A563LINEAR A SIGN A564LINEAR A SIGN A565LINEAR A " +
	"SIGN A566LINEAR A SIGN A568LINEAR A SIGN A569LINEAR A SIGN A570LINEAR A " +
	"SIGN A571LINEAR A SIGN A572LINEAR A SIGN A573LINEAR A SIGN A574LINEAR A ") + ("" +
	"SIGN A575LINEAR A SIGN A576LINEAR A SIGN A577LINEAR A SIGN A578LINEAR A " +
	"SIGN A579LINEAR A SIGN A580LINEAR A SIGN A581LINEAR A SIGN A582LINEAR A " +
	"SIGN A583LINEAR A SIGN A584LINEAR A SIGN A585LINEAR A SIGN A586LINEAR A " +
	"SIGN A587LINEAR A SIGN A588LINEAR A SIGN A589LINEAR A SIGN A591LINEAR A " +
	"SIGN A592LINEAR A SIGN A594LINEAR A SIGN A595LINEAR A SIGN A596LINEAR A " +
	"SIGN A598LINEAR A SIGN A600LINEAR A SIGN A601LINEAR A SIGN A602LINEAR A " +
	"SIGN A603LINEAR A SIGN A604LINEAR A SIGN A606LINEAR A SIGN A608LINEAR A " +
	"SIGN A609LINEAR A SIGN A610LINEAR A SIGN A611LINEAR A SIGN A612LINEAR A " +
	"SIGN A613LINEAR A SIGN A614LINEAR A SIGN A615LINEAR A SIGN A616LINEAR A " +
	"SIGN A617LINEAR A SIGN A618LINEAR A SIGN A619LINEAR A SIGN A620LINEAR A " +
	"SIGN A621LINEAR A SIGN A622LINEAR A SIGN A623LINEAR A SIGN A624LINEAR A " +
	"SIGN A626LINEAR A SIGN A627LINEAR A SIGN A628LINEAR A SIGN A629LINEAR A " +
	"SIGN A634LINEAR A SIGN A637LINEAR A SIGN A638LINEAR A SIGN A640LINEAR A " +
	"SIGN A642LINEAR A SIGN A643LINEAR A SIGN A644LINEAR A SIGN A645LINEAR A " +
	"SIGN A646LINEAR A SIGN A648LINEAR A SIGN A649LINEAR A SIGN A651LINEAR A " +
	"SIGN A652LINEAR A SIGN A653LINEAR A SIGN A654LINEAR A SIGN A655LINEAR A " +
	"SIGN A656LINEAR A SIGN A657LINEAR A SIGN A658LINEAR A SIGN A659LINEAR A " +
	"SIGN A660LINEAR A SIGN A661LINEAR A SIGN A662LINEAR A SIGN A663LINEAR A " +
	"SIGN A664LINEAR A SIGN A701 ALINEAR A SIGN A702 BLINEAR A SIGN A703 DLIN" +
	"EAR A SIGN A704 ELINEAR A SIGN A705 FLINEAR A SIGN A706 HLINEAR A SIGN A" +
	"707 JLINEAR A SIGN A708 KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 L2LINE" +
	"AR A SIGN A709-3 L3LINEAR A SIGN A709-4 L4LINEAR A SIGN A709-6 L6LINEAR " +
	"A SIGN A710 WLINEAR A SIGN A711 XLINEAR A SIGN A712 YLINEAR A SIGN A713 " +
	"OMEGALINEAR A SIGN A714 ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717 DDLIN" +
	"EAR A SIGN A726 EYYYLINEAR A SIGN A732 JELINEAR A SIGN A800LINEAR A SIGN" +
	" A801LINEAR A SIGN A802LINEAR A SIGN A803LINEAR A SIGN A804LINEAR A SIGN" +
	" A805LINEAR A SIGN A806LINEAR A SIGN A807CYPRIOT SYLLABLE ACYPRIOT SYLLA" +
	"BLE ECYPRIOT SYLLABLE ICYPRIOT SYLLABLE OCYPRIOT SYLLABLE UCYPRIOT SYLLA" +
	"BLE JACYPRIOT SYLLABLE JOCYPRIOT SYLLABLE KACYPRIOT SYLLABLE KECYPRIOT S" +
	"YLLABLE KICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE KUCYPRIOT SYLLABLE LACYPRI" +
	"OT SYLLABLE LECYPRIOT SYLLABLE LICYPRIOT SYLLABLE LOCYPRIOT SYLLABLE LUC" +
	"YPRIOT SYLLABLE MACYPRIOT SYLLABLE MECYPRIOT SYLLABLE MICYPRIOT SYLLABLE" +
	" MOCYPRIOT SYLLABLE MUCYPRIOT SYLLABLE NACYPRIOT SYLLABLE NECYPRIOT SYLL" +
	"ABLE NICYPRIOT SYLLABLE NOCYPRIOT SYLLABLE NUCYPRIOT SYLLABLE PACYPRIOT " +
	"SYLLABLE PECYPRIOT SYLLABLE PICYPRIOT SYLLABLE POCYPRIOT SYLLABLE PUCYPR" +
	"IOT SYLLABLE RACYPRIOT SYLLABLE RECYPRIOT SYLLABLE RICYPRIOT SYLLABLE RO" +
	"CYPRIOT SYLLABLE RUCYPRIOT SYLLABLE SACYPRIOT SYLLABLE SECYPRIOT SYLLABL" +
	"E SICYPRIOT SYLLABLE SOCYPRIOT SYLLABLE SUCYPRIOT SYLLABLE TACYPRIOT SYL" +
	"LABLE TECYPRIOT SYLLABLE TICYPRIOT SYLLABLE TOCYPRIOT SYLLABLE TUCYPRIOT" +
	" SYLLABLE WACYPRIOT SYLLABLE WECYPRIOT SYLLABLE WICYPRIOT SYLLABLE WOCYP" +
	"RIOT SYLLABLE XACYPRIOT SYLLABLE XECYPRIOT SYLLABLE ZACYPRIOT SYLLABLE Z" +
	"OIMPERIAL ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC LETTER BETHIMPERIAL ARAMA" +
	"IC LETTER GIMELIMPERIAL ARAMAIC LETTER DALETHIMPERIAL ARAMAIC LETTER HEI" +
	"MPERIAL ARAMAIC LETTER WAWIMPERIAL ARAMAIC LETTER ZAYINIMPERIAL ARAMAIC " +
	"LETTER HETHIMPERIAL ARAMAIC LETTER TETHIMPERIAL ARAMAIC LETTER YODHIMPER" +
	"IAL ARAMAIC LETTER KAPHIMPERIAL ARAMAIC LETTER LAMEDHIMPERIAL ARAMAIC LE" +
	"TTER MEMIMPERIAL ARAMAIC LETTER NUNIMPERIAL ARAMAIC LETTER SAMEKHIMPERIA" +
	"L ARAMAIC LETTER AYINIMPERIAL ARAMAIC LETTER PEIMPERIAL ARAMAIC LETTER S" +
	"ADHEIMPERIAL ARAMAIC LETTER QOPHIMPERIAL ARAMAIC LETTER RESHIMPERIAL ARA" +
	"MAIC LETTER SHINIMPERIAL ARAMAIC LETTER TAWIMPERIAL ARAMAIC SECTION SIGN" +
	"IMPERIAL ARAMAIC NUMBER ONEIMPERIAL ARAMAIC NUMBER TWOIMPERIAL ARAMAIC N" +
	"UMBER THREEIMPERIAL ARAMAIC NUMBER TENIMPERIAL ARAMAIC NUMBER TWENTYIMPE" +
	"RIAL ARAMAIC NUMBER ONE HUNDREDIMPERIAL ARAMAIC NUMBER ONE THOUSANDIMPER" +
	"IAL ARAMAIC NUMBER TEN THOUSANDPALMYRENE LETTER ALEPHPALMYRENE LETTER BE" +
	"THPALMYRENE LETTER GIMELPALMYRENE LETTER DALETHPALMYRENE LETTER HEPALMYR" +
	"ENE LETTER WAWPALMYRENE LETTER ZAYINPALMYRENE LETTER HETHPALMYRENE LETTE" +
	"R TETHPALMYRENE LETTER YODHPALMYRENE LETTER KAPHPALMYRENE LETTER LAMEDHP" +
	"ALMYRENE LETTER MEMPALMYRENE LETTER FINAL NUNPALMYRENE LETTER NUNPALMYRE" +
	"NE LETTER SAMEKHPALMYRENE LETTER AYINPALMYRENE LETTER PEPALMYRENE LETTER" +
	" SADHEPALMYRENE LETTER QOPHPALMYRENE LETTER RESHPALMYRENE LETTER SHINPAL" +
	"MYRENE LETTER TAWPALMYRENE LEFT-POINTING FLEURONPALMYRENE RIGHT-POINTING" +
	" FLEURONPALMYRENE NUMBER ONEPALMYRENE NUMBER TWOPALMYRENE NUMBER THREEPA" +
	"LMYRENE NUMBER FOURPALMYRENE NUMBER FIVEPALMYRENE NUMBER TENPALMYRENE NU" +
	"MBER TWENTYNABATAEAN LETTER FINAL ALEPHNABATAEAN LETTER ALEPHNABATAEAN L") + ("" +
	"ETTER FINAL BETHNABATAEAN LETTER BETHNABATAEAN LETTER GIMELNABATAEAN LET" +
	"TER DALETHNABATAEAN LETTER FINAL HENABATAEAN LETTER HENABATAEAN LETTER W" +
	"AWNABATAEAN LETTER ZAYINNABATAEAN LETTER HETHNABATAEAN LETTER TETHNABATA" +
	"EAN LETTER FINAL YODHNABATAEAN LETTER YODHNABATAEAN LETTER FINAL KAPHNAB" +
	"ATAEAN LETTER KAPHNABATAEAN LETTER FINAL LAMEDHNABATAEAN LETTER LAMEDHNA" +
	"BATAEAN LETTER FINAL MEMNABATAEAN LETTER MEMNABATAEAN LETTER FINAL NUNNA" +
	"BATAEAN LETTER NUNNABATAEAN LETTER SAMEKHNABATAEAN LETTER AYINNABATAEAN " +
	"LETTER PENABATAEAN LETTER SADHENABATAEAN LETTER QOPHNABATAEAN LETTER RES" +
	"HNABATAEAN LETTER FINAL SHINNABATAEAN LETTER SHINNABATAEAN LETTER TAWNAB" +
	"ATAEAN NUMBER ONENABATAEAN NUMBER TWONABATAEAN NUMBER THREENABATAEAN NUM" +
	"BER FOURNABATAEAN CRUCIFORM NUMBER FOURNABATAEAN NUMBER FIVENABATAEAN NU" +
	"MBER TENNABATAEAN NUMBER TWENTYNABATAEAN NUMBER ONE HUNDREDHATRAN LETTER" +
	" ALEPHHATRAN LETTER BETHHATRAN LETTER GIMELHATRAN LETTER DALETH-RESHHATR" +
	"AN LETTER HEHATRAN LETTER WAWHATRAN LETTER ZAYNHATRAN LETTER HETHHATRAN " +
	"LETTER TETHHATRAN LETTER YODHHATRAN LETTER KAPHHATRAN LETTER LAMEDHHATRA" +
	"N LETTER MEMHATRAN LETTER NUNHATRAN LETTER SAMEKHHATRAN LETTER AYNHATRAN" +
	" LETTER PEHATRAN LETTER SADHEHATRAN LETTER QOPHHATRAN LETTER SHINHATRAN " +
	"LETTER TAWHATRAN NUMBER ONEHATRAN NUMBER FIVEHATRAN NUMBER TENHATRAN NUM" +
	"BER TWENTYHATRAN NUMBER ONE HUNDREDPHOENICIAN LETTER ALFPHOENICIAN LETTE" +
	"R BETPHOENICIAN LETTER GAMLPHOENICIAN LETTER DELTPHOENICIAN LETTER HEPHO" +
	"ENICIAN LETTER WAUPHOENICIAN LETTER ZAIPHOENICIAN LETTER HETPHOENICIAN L" +
	"ETTER TETPHOENICIAN LETTER YODPHOENICIAN LETTER KAFPHOENICIAN LETTER LAM" +
	"DPHOENICIAN LETTER MEMPHOENICIAN LETTER NUNPHOENICIAN LETTER SEMKPHOENIC" +
	"IAN LETTER AINPHOENICIAN LETTER PEPHOENICIAN LETTER SADEPHOENICIAN LETTE" +
	"R QOFPHOENICIAN LETTER ROSHPHOENICIAN LETTER SHINPHOENICIAN LETTER TAUPH" +
	"OENICIAN NUMBER ONEPHOENICIAN NUMBER TENPHOENICIAN NUMBER TWENTYPHOENICI" +
	"AN NUMBER ONE HUNDREDPHOENICIAN NUMBER TWOPHOENICIAN NUMBER THREEPHOENIC" +
	"IAN WORD SEPARATORLYDIAN LETTER ALYDIAN LETTER BLYDIAN LETTER GLYDIAN LE" +
	"TTER DLYDIAN LETTER ELYDIAN LETTER VLYDIAN LETTER ILYDIAN LETTER YLYDIAN" +
	" LETTER KLYDIAN LETTER LLYDIAN LETTER MLYDIAN LETTER NLYDIAN LETTER OLYD" +
	"IAN LETTER RLYDIAN LETTER SSLYDIAN LETTER TLYDIAN LETTER ULYDIAN LETTER " +
	"FLYDIAN LETTER QLYDIAN LETTER SLYDIAN LETTER TTLYDIAN LETTER ANLYDIAN LE" +
	"TTER ENLYDIAN LETTER LYLYDIAN LETTER NNLYDIAN LETTER CLYDIAN TRIANGULAR " +
	"MARKMEROITIC HIEROGLYPHIC LETTER AMEROITIC HIEROGLYPHIC LETTER EMEROITIC" +
	" HIEROGLYPHIC LETTER IMEROITIC HIEROGLYPHIC LETTER OMEROITIC HIEROGLYPHI" +
	"C LETTER YAMEROITIC HIEROGLYPHIC LETTER WAMEROITIC HIEROGLYPHIC LETTER B" +
	"AMEROITIC HIEROGLYPHIC LETTER BA-2MEROITIC HIEROGLYPHIC LETTER PAMEROITI" +
	"C HIEROGLYPHIC LETTER MAMEROITIC HIEROGLYPHIC LETTER NAMEROITIC HIEROGLY" +
	"PHIC LETTER NA-2MEROITIC HIEROGLYPHIC LETTER NEMEROITIC HIEROGLYPHIC LET" +
	"TER NE-2MEROITIC HIEROGLYPHIC LETTER RAMEROITIC HIEROGLYPHIC LETTER RA-2" +
	"MEROITIC HIEROGLYPHIC LETTER LAMEROITIC HIEROGLYPHIC LETTER KHAMEROITIC " +
	"HIEROGLYPHIC LETTER HHAMEROITIC HIEROGLYPHIC LETTER SAMEROITIC HIEROGLYP" +
	"HIC LETTER SA-2MEROITIC HIEROGLYPHIC LETTER SEMEROITIC HIEROGLYPHIC LETT" +
	"ER KAMEROITIC HIEROGLYPHIC LETTER QAMEROITIC HIEROGLYPHIC LETTER TAMEROI" +
	"TIC HIEROGLYPHIC LETTER TA-2MEROITIC HIEROGLYPHIC LETTER TEMEROITIC HIER" +
	"OGLYPHIC LETTER TE-2MEROITIC HIEROGLYPHIC LETTER TOMEROITIC HIEROGLYPHIC" +
	" LETTER DAMEROITIC HIEROGLYPHIC SYMBOL VIDJMEROITIC HIEROGLYPHIC SYMBOL " +
	"VIDJ-2MEROITIC CURSIVE LETTER AMEROITIC CURSIVE LETTER EMEROITIC CURSIVE" +
	" LETTER IMEROITIC CURSIVE LETTER OMEROITIC CURSIVE LETTER YAMEROITIC CUR" +
	"SIVE LETTER WAMEROITIC CURSIVE LETTER BAMEROITIC CURSIVE LETTER PAMEROIT" +
	"IC CURSIVE LETTER MAMEROITIC CURSIVE LETTER NAMEROITIC CURSIVE LETTER NE" +
	"MEROITIC CURSIVE LETTER RAMEROITIC CURSIVE LETTER LAMEROITIC CURSIVE LET" +
	"TER KHAMEROITIC CURSIVE LETTER HHAMEROITIC CURSIVE LETTER SAMEROITIC CUR" +
	"SIVE LETTER ARCHAIC SAMEROITIC CURSIVE LETTER SEMEROITIC CURSIVE LETTER " +
	"KAMEROITIC CURSIVE LETTER QAMEROITIC CURSIVE LETTER TAMEROITIC CURSIVE L" +
	"ETTER TEMEROITIC CURSIVE LETTER TOMEROITIC CURSIVE LETTER DAMEROITIC CUR" +
	"SIVE FRACTION ELEVEN TWELFTHSMEROITIC CURSIVE FRACTION ONE HALFMEROITIC " +
	"CURSIVE LOGOGRAM RMTMEROITIC CURSIVE LOGOGRAM IMNMEROITIC CURSIVE NUMBER" +
	" ONEMEROITIC CURSIVE NUMBER TWOMEROITIC CURSIVE NUMBER THREEMEROITIC CUR" +
	"SIVE NUMBER FOURMEROITIC CURSIVE NUMBER FIVEMEROITIC CURSIVE NUMBER SIXM" +
	"EROITIC CURSIVE NUMBER SEVENMEROITIC CURSIVE NUMBER EIGHTMEROITIC CURSIV" +
	"E NUMBER NINEMEROITIC CURSIVE NUMBER TENMEROITIC CURSIVE NUMBER TWENTYME" +
	"ROITIC CURSIVE NUMBER THIRTYMEROITIC CURSIVE NUMBER FORTYMEROITIC CURSIV" +
	"E NUMBER FIFTYMEROITIC CURSIVE NUMBER SIXTYMEROITIC CURSIVE NUMBER SEVEN") + ("" +
	"TYMEROITIC CURSIVE NUMBER ONE HUNDREDMEROITIC CURSIVE NUMBER TWO HUNDRED" +
	"MEROITIC CURSIVE NUMBER THREE HUNDREDMEROITIC CURSIVE NUMBER FOUR HUNDRE" +
	"DMEROITIC CURSIVE NUMBER FIVE HUNDREDMEROITIC CURSIVE NUMBER SIX HUNDRED" +
	"MEROITIC CURSIVE NUMBER SEVEN HUNDREDMEROITIC CURSIVE NUMBER EIGHT HUNDR" +
	"EDMEROITIC CURSIVE NUMBER NINE HUNDREDMEROITIC CURSIVE NUMBER ONE THOUSA" +
	"NDMEROITIC CURSIVE NUMBER TWO THOUSANDMEROITIC CURSIVE NUMBER THREE THOU" +
	"SANDMEROITIC CURSIVE NUMBER FOUR THOUSANDMEROITIC CURSIVE NUMBER FIVE TH" +
	"OUSANDMEROITIC CURSIVE NUMBER SIX THOUSANDMEROITIC CURSIVE NUMBER SEVEN " +
	"THOUSANDMEROITIC CURSIVE NUMBER EIGHT THOUSANDMEROITIC CURSIVE NUMBER NI" +
	"NE THOUSANDMEROITIC CURSIVE NUMBER TEN THOUSANDMEROITIC CURSIVE NUMBER T" +
	"WENTY THOUSANDMEROITIC CURSIVE NUMBER THIRTY THOUSANDMEROITIC CURSIVE NU" +
	"MBER FORTY THOUSANDMEROITIC CURSIVE NUMBER FIFTY THOUSANDMEROITIC CURSIV" +
	"E NUMBER SIXTY THOUSANDMEROITIC CURSIVE NUMBER SEVENTY THOUSANDMEROITIC " +
	"CURSIVE NUMBER EIGHTY THOUSANDMEROITIC CURSIVE NUMBER NINETY THOUSANDMER" +
	"OITIC CURSIVE NUMBER ONE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER TWO HUN" +
	"DRED THOUSANDMEROITIC CURSIVE NUMBER THREE HUNDRED THOUSANDMEROITIC CURS" +
	"IVE NUMBER FOUR HUNDRED THOUSANDMEROITIC CURSIVE NUMBER FIVE HUNDRED THO" +
	"USANDMEROITIC CURSIVE NUMBER SIX HUNDRED THOUSANDMEROITIC CURSIVE NUMBER" +
	" SEVEN HUNDRED THOUSANDMEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSANDMER" +
	"OITIC CURSIVE NUMBER NINE HUNDRED THOUSANDMEROITIC CURSIVE FRACTION ONE " +
	"TWELFTHMEROITIC CURSIVE FRACTION TWO TWELFTHSMEROITIC CURSIVE FRACTION T" +
	"HREE TWELFTHSMEROITIC CURSIVE FRACTION FOUR TWELFTHSMEROITIC CURSIVE FRA" +
	"CTION FIVE TWELFTHSMEROITIC CURSIVE FRACTION SIX TWELFTHSMEROITIC CURSIV" +
	"E FRACTION SEVEN TWELFTHSMEROITIC CURSIVE FRACTION EIGHT TWELFTHSMEROITI" +
	"C CURSIVE FRACTION NINE TWELFTHSMEROITIC CURSIVE FRACTION TEN TWELFTHSKH" +
	"AROSHTHI LETTER AKHAROSHTHI VOWEL SIGN IKHAROSHTHI VOWEL SIGN UKHAROSHTH" +
	"I VOWEL SIGN VOCALIC RKHAROSHTHI VOWEL SIGN EKHAROSHTHI VOWEL SIGN OKHAR" +
	"OSHTHI VOWEL LENGTH MARKKHAROSHTHI SIGN DOUBLE RING BELOWKHAROSHTHI SIGN" +
	" ANUSVARAKHAROSHTHI SIGN VISARGAKHAROSHTHI LETTER KAKHAROSHTHI LETTER KH" +
	"AKHAROSHTHI LETTER GAKHAROSHTHI LETTER GHAKHAROSHTHI LETTER CAKHAROSHTHI" +
	" LETTER CHAKHAROSHTHI LETTER JAKHAROSHTHI LETTER NYAKHAROSHTHI LETTER TT" +
	"AKHAROSHTHI LETTER TTHAKHAROSHTHI LETTER DDAKHAROSHTHI LETTER DDHAKHAROS" +
	"HTHI LETTER NNAKHAROSHTHI LETTER TAKHAROSHTHI LETTER THAKHAROSHTHI LETTE" +
	"R DAKHAROSHTHI LETTER DHAKHAROSHTHI LETTER NAKHAROSHTHI LETTER PAKHAROSH" +
	"THI LETTER PHAKHAROSHTHI LETTER BAKHAROSHTHI LETTER BHAKHAROSHTHI LETTER" +
	" MAKHAROSHTHI LETTER YAKHAROSHTHI LETTER RAKHAROSHTHI LETTER LAKHAROSHTH" +
	"I LETTER VAKHAROSHTHI LETTER SHAKHAROSHTHI LETTER SSAKHAROSHTHI LETTER S" +
	"AKHAROSHTHI LETTER ZAKHAROSHTHI LETTER HAKHAROSHTHI LETTER KKAKHAROSHTHI" +
	" LETTER TTTHAKHAROSHTHI SIGN BAR ABOVEKHAROSHTHI SIGN CAUDAKHAROSHTHI SI" +
	"GN DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI DIGIT ONEKHAROSHTHI DIGIT TWOKHA" +
	"ROSHTHI DIGIT THREEKHAROSHTHI DIGIT FOURKHAROSHTHI NUMBER TENKHAROSHTHI " +
	"NUMBER TWENTYKHAROSHTHI NUMBER ONE HUNDREDKHAROSHTHI NUMBER ONE THOUSAND" +
	"KHAROSHTHI PUNCTUATION DOTKHAROSHTHI PUNCTUATION SMALL CIRCLEKHAROSHTHI " +
	"PUNCTUATION CIRCLEKHAROSHTHI PUNCTUATION CRESCENT BARKHAROSHTHI PUNCTUAT" +
	"ION MANGALAMKHAROSHTHI PUNCTUATION LOTUSKHAROSHTHI PUNCTUATION DANDAKHAR" +
	"OSHTHI PUNCTUATION DOUBLE DANDAKHAROSHTHI PUNCTUATION LINESOLD SOUTH ARA" +
	"BIAN LETTER HEOLD SOUTH ARABIAN LETTER LAMEDHOLD SOUTH ARABIAN LETTER HE" +
	"THOLD SOUTH ARABIAN LETTER MEMOLD SOUTH ARABIAN LETTER QOPHOLD SOUTH ARA" +
	"BIAN LETTER WAWOLD SOUTH ARABIAN LETTER SHINOLD SOUTH ARABIAN LETTER RES" +
	"HOLD SOUTH ARABIAN LETTER BETHOLD SOUTH ARABIAN LETTER TAWOLD SOUTH ARAB" +
	"IAN LETTER SATOLD SOUTH ARABIAN LETTER KAPHOLD SOUTH ARABIAN LETTER NUNO" +
	"LD SOUTH ARABIAN LETTER KHETHOLD SOUTH ARABIAN LETTER SADHEOLD SOUTH ARA" +
	"BIAN LETTER SAMEKHOLD SOUTH ARABIAN LETTER FEOLD SOUTH ARABIAN LETTER AL" +
	"EFOLD SOUTH ARABIAN LETTER AYNOLD SOUTH ARABIAN LETTER DHADHEOLD SOUTH A" +
	"RABIAN LETTER GIMELOLD SOUTH ARABIAN LETTER DALETHOLD SOUTH ARABIAN LETT" +
	"ER GHAYNOLD SOUTH ARABIAN LETTER TETHOLD SOUTH ARABIAN LETTER ZAYNOLD SO" +
	"UTH ARABIAN LETTER DHALETHOLD SOUTH ARABIAN LETTER YODHOLD SOUTH ARABIAN" +
	" LETTER THAWOLD SOUTH ARABIAN LETTER THETHOLD SOUTH ARABIAN NUMBER ONEOL" +
	"D SOUTH ARABIAN NUMBER FIFTYOLD SOUTH ARABIAN NUMERIC INDICATOROLD NORTH" +
	" ARABIAN LETTER HEHOLD NORTH ARABIAN LETTER LAMOLD NORTH ARABIAN LETTER " +
	"HAHOLD NORTH ARABIAN LETTER MEEMOLD NORTH ARABIAN LETTER QAFOLD NORTH AR" +
	"ABIAN LETTER WAWOLD NORTH ARABIAN LETTER ES-2OLD NORTH ARABIAN LETTER RE" +
	"HOLD NORTH ARABIAN LETTER BEHOLD NORTH ARABIAN LETTER TEHOLD NORTH ARABI" +
	"AN LETTER ES-1OLD NORTH ARABIAN LETTER KAFOLD NORTH ARABIAN LETTER NOONO") + ("" +
	"LD NORTH ARABIAN LETTER KHAHOLD NORTH ARABIAN LETTER SADOLD NORTH ARABIA" +
	"N LETTER ES-3OLD NORTH ARABIAN LETTER FEHOLD NORTH ARABIAN LETTER ALEFOL" +
	"D NORTH ARABIAN LETTER AINOLD NORTH ARABIAN LETTER DADOLD NORTH ARABIAN " +
	"LETTER GEEMOLD NORTH ARABIAN LETTER DALOLD NORTH ARABIAN LETTER GHAINOLD" +
	" NORTH ARABIAN LETTER TAHOLD NORTH ARABIAN LETTER ZAINOLD NORTH ARABIAN " +
	"LETTER THALOLD NORTH ARABIAN LETTER YEHOLD NORTH ARABIAN LETTER THEHOLD " +
	"NORTH ARABIAN LETTER ZAHOLD NORTH ARABIAN NUMBER ONEOLD NORTH ARABIAN NU" +
	"MBER TENOLD NORTH ARABIAN NUMBER TWENTYMANICHAEAN LETTER ALEPHMANICHAEAN" +
	" LETTER BETHMANICHAEAN LETTER BHETHMANICHAEAN LETTER GIMELMANICHAEAN LET" +
	"TER GHIMELMANICHAEAN LETTER DALETHMANICHAEAN LETTER HEMANICHAEAN LETTER " +
	"WAWMANICHAEAN SIGN UDMANICHAEAN LETTER ZAYINMANICHAEAN LETTER ZHAYINMANI" +
	"CHAEAN LETTER JAYINMANICHAEAN LETTER JHAYINMANICHAEAN LETTER HETHMANICHA" +
	"EAN LETTER TETHMANICHAEAN LETTER YODHMANICHAEAN LETTER KAPHMANICHAEAN LE" +
	"TTER XAPHMANICHAEAN LETTER KHAPHMANICHAEAN LETTER LAMEDHMANICHAEAN LETTE" +
	"R DHAMEDHMANICHAEAN LETTER THAMEDHMANICHAEAN LETTER MEMMANICHAEAN LETTER" +
	" NUNMANICHAEAN LETTER SAMEKHMANICHAEAN LETTER AYINMANICHAEAN LETTER AAYI" +
	"NMANICHAEAN LETTER PEMANICHAEAN LETTER FEMANICHAEAN LETTER SADHEMANICHAE" +
	"AN LETTER QOPHMANICHAEAN LETTER XOPHMANICHAEAN LETTER QHOPHMANICHAEAN LE" +
	"TTER RESHMANICHAEAN LETTER SHINMANICHAEAN LETTER SSHINMANICHAEAN LETTER " +
	"TAWMANICHAEAN ABBREVIATION MARK ABOVEMANICHAEAN ABBREVIATION MARK BELOWM" +
	"ANICHAEAN NUMBER ONEMANICHAEAN NUMBER FIVEMANICHAEAN NUMBER TENMANICHAEA" +
	"N NUMBER TWENTYMANICHAEAN NUMBER ONE HUNDREDMANICHAEAN PUNCTUATION STARM" +
	"ANICHAEAN PUNCTUATION FLEURONMANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DO" +
	"TMANICHAEAN PUNCTUATION DOT WITHIN DOTMANICHAEAN PUNCTUATION DOTMANICHAE" +
	"AN PUNCTUATION TWO DOTSMANICHAEAN PUNCTUATION LINE FILLERAVESTAN LETTER " +
	"AAVESTAN LETTER AAAVESTAN LETTER AOAVESTAN LETTER AAOAVESTAN LETTER ANAV" +
	"ESTAN LETTER AANAVESTAN LETTER AEAVESTAN LETTER AEEAVESTAN LETTER EAVEST" +
	"AN LETTER EEAVESTAN LETTER OAVESTAN LETTER OOAVESTAN LETTER IAVESTAN LET" +
	"TER IIAVESTAN LETTER UAVESTAN LETTER UUAVESTAN LETTER KEAVESTAN LETTER X" +
	"EAVESTAN LETTER XYEAVESTAN LETTER XVEAVESTAN LETTER GEAVESTAN LETTER GGE" +
	"AVESTAN LETTER GHEAVESTAN LETTER CEAVESTAN LETTER JEAVESTAN LETTER TEAVE" +
	"STAN LETTER THEAVESTAN LETTER DEAVESTAN LETTER DHEAVESTAN LETTER TTEAVES" +
	"TAN LETTER PEAVESTAN LETTER FEAVESTAN LETTER BEAVESTAN LETTER BHEAVESTAN" +
	" LETTER NGEAVESTAN LETTER NGYEAVESTAN LETTER NGVEAVESTAN LETTER NEAVESTA" +
	"N LETTER NYEAVESTAN LETTER NNEAVESTAN LETTER MEAVESTAN LETTER HMEAVESTAN" +
	" LETTER YYEAVESTAN LETTER YEAVESTAN LETTER VEAVESTAN LETTER REAVESTAN LE" +
	"TTER LEAVESTAN LETTER SEAVESTAN LETTER ZEAVESTAN LETTER SHEAVESTAN LETTE" +
	"R ZHEAVESTAN LETTER SHYEAVESTAN LETTER SSHEAVESTAN LETTER HEAVESTAN ABBR" +
	"EVIATION MARKTINY TWO DOTS OVER ONE DOT PUNCTUATIONSMALL TWO DOTS OVER O" +
	"NE DOT PUNCTUATIONLARGE TWO DOTS OVER ONE DOT PUNCTUATIONLARGE ONE DOT O" +
	"VER TWO DOTS PUNCTUATIONLARGE TWO RINGS OVER ONE RING PUNCTUATIONLARGE O" +
	"NE RING OVER TWO RINGS PUNCTUATIONINSCRIPTIONAL PARTHIAN LETTER ALEPHINS" +
	"CRIPTIONAL PARTHIAN LETTER BETHINSCRIPTIONAL PARTHIAN LETTER GIMELINSCRI" +
	"PTIONAL PARTHIAN LETTER DALETHINSCRIPTIONAL PARTHIAN LETTER HEINSCRIPTIO" +
	"NAL PARTHIAN LETTER WAWINSCRIPTIONAL PARTHIAN LETTER ZAYININSCRIPTIONAL " +
	"PARTHIAN LETTER HETHINSCRIPTIONAL PARTHIAN LETTER TETHINSCRIPTIONAL PART" +
	"HIAN LETTER YODHINSCRIPTIONAL PARTHIAN LETTER KAPHINSCRIPTIONAL PARTHIAN" +
	" LETTER LAMEDHINSCRIPTIONAL PARTHIAN LETTER MEMINSCRIPTIONAL PARTHIAN LE" +
	"TTER NUNINSCRIPTIONAL PARTHIAN LETTER SAMEKHINSCRIPTIONAL PARTHIAN LETTE" +
	"R AYININSCRIPTIONAL PARTHIAN LETTER PEINSCRIPTIONAL PARTHIAN LETTER SADH" +
	"EINSCRIPTIONAL PARTHIAN LETTER QOPHINSCRIPTIONAL PARTHIAN LETTER RESHINS" +
	"CRIPTIONAL PARTHIAN LETTER SHININSCRIPTIONAL PARTHIAN LETTER TAWINSCRIPT" +
	"IONAL PARTHIAN NUMBER ONEINSCRIPTIONAL PARTHIAN NUMBER TWOINSCRIPTIONAL " +
	"PARTHIAN NUMBER THREEINSCRIPTIONAL PARTHIAN NUMBER FOURINSCRIPTIONAL PAR" +
	"THIAN NUMBER TENINSCRIPTIONAL PARTHIAN NUMBER TWENTYINSCRIPTIONAL PARTHI" +
	"AN NUMBER ONE HUNDREDINSCRIPTIONAL PARTHIAN NUMBER ONE THOUSANDINSCRIPTI" +
	"ONAL PAHLAVI LETTER ALEPHINSCRIPTIONAL PAHLAVI LETTER BETHINSCRIPTIONAL " +
	"PAHLAVI LETTER GIMELINSCRIPTIONAL PAHLAVI LETTER DALETHINSCRIPTIONAL PAH" +
	"LAVI LETTER HEINSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESHINSCRIPTIONAL PA" +
	"HLAVI LETTER ZAYININSCRIPTIONAL PAHLAVI LETTER HETHINSCRIPTIONAL PAHLAVI" +
	" LETTER TETHINSCRIPTIONAL PAHLAVI LETTER YODHINSCRIPTIONAL PAHLAVI LETTE" +
	"R KAPHINSCRIPTIONAL PAHLAVI LETTER LAMEDHINSCRIPTIONAL PAHLAVI LETTER ME" +
	"M-QOPHINSCRIPTIONAL PAHLAVI LETTER NUNINSCRIPTIONAL PAHLAVI LETTER SAMEK" +
	"HINSCRIPTIONAL PAHLAVI LETTER PEINSCRIPTIONAL PAHLAVI LETTER SADHEINSCRI") + ("" +
	"PTIONAL PAHLAVI LETTER SHININSCRIPTIONAL PAHLAVI LETTER TAWINSCRIPTIONAL" +
	" PAHLAVI NUMBER ONEINSCRIPTIONAL PAHLAVI NUMBER TWOINSCRIPTIONAL PAHLAVI" +
	" NUMBER THREEINSCRIPTIONAL PAHLAVI NUMBER FOURINSCRIPTIONAL PAHLAVI NUMB" +
	"ER TENINSCRIPTIONAL PAHLAVI NUMBER TWENTYINSCRIPTIONAL PAHLAVI NUMBER ON" +
	"E HUNDREDINSCRIPTIONAL PAHLAVI NUMBER ONE THOUSANDPSALTER PAHLAVI LETTER" +
	" ALEPHPSALTER PAHLAVI LETTER BETHPSALTER PAHLAVI LETTER GIMELPSALTER PAH" +
	"LAVI LETTER DALETHPSALTER PAHLAVI LETTER HEPSALTER PAHLAVI LETTER WAW-AY" +
	"IN-RESHPSALTER PAHLAVI LETTER ZAYINPSALTER PAHLAVI LETTER HETHPSALTER PA" +
	"HLAVI LETTER YODHPSALTER PAHLAVI LETTER KAPHPSALTER PAHLAVI LETTER LAMED" +
	"HPSALTER PAHLAVI LETTER MEM-QOPHPSALTER PAHLAVI LETTER NUNPSALTER PAHLAV" +
	"I LETTER SAMEKHPSALTER PAHLAVI LETTER PEPSALTER PAHLAVI LETTER SADHEPSAL" +
	"TER PAHLAVI LETTER SHINPSALTER PAHLAVI LETTER TAWPSALTER PAHLAVI SECTION" +
	" MARKPSALTER PAHLAVI TURNED SECTION MARKPSALTER PAHLAVI FOUR DOTS WITH C" +
	"ROSSPSALTER PAHLAVI FOUR DOTS WITH DOTPSALTER PAHLAVI NUMBER ONEPSALTER " +
	"PAHLAVI NUMBER TWOPSALTER PAHLAVI NUMBER THREEPSALTER PAHLAVI NUMBER FOU" +
	"RPSALTER PAHLAVI NUMBER TENPSALTER PAHLAVI NUMBER TWENTYPSALTER PAHLAVI " +
	"NUMBER ONE HUNDREDOLD TURKIC LETTER ORKHON AOLD TURKIC LETTER YENISEI AO" +
	"LD TURKIC LETTER YENISEI AEOLD TURKIC LETTER ORKHON IOLD TURKIC LETTER Y" +
	"ENISEI IOLD TURKIC LETTER YENISEI EOLD TURKIC LETTER ORKHON OOLD TURKIC " +
	"LETTER ORKHON OEOLD TURKIC LETTER YENISEI OEOLD TURKIC LETTER ORKHON ABO" +
	"LD TURKIC LETTER YENISEI ABOLD TURKIC LETTER ORKHON AEBOLD TURKIC LETTER" +
	" YENISEI AEBOLD TURKIC LETTER ORKHON AGOLD TURKIC LETTER YENISEI AGOLD T" +
	"URKIC LETTER ORKHON AEGOLD TURKIC LETTER YENISEI AEGOLD TURKIC LETTER OR" +
	"KHON ADOLD TURKIC LETTER YENISEI ADOLD TURKIC LETTER ORKHON AEDOLD TURKI" +
	"C LETTER ORKHON EZOLD TURKIC LETTER YENISEI EZOLD TURKIC LETTER ORKHON A" +
	"YOLD TURKIC LETTER YENISEI AYOLD TURKIC LETTER ORKHON AEYOLD TURKIC LETT" +
	"ER YENISEI AEYOLD TURKIC LETTER ORKHON AEKOLD TURKIC LETTER YENISEI AEKO" +
	"LD TURKIC LETTER ORKHON OEKOLD TURKIC LETTER YENISEI OEKOLD TURKIC LETTE" +
	"R ORKHON ALOLD TURKIC LETTER YENISEI ALOLD TURKIC LETTER ORKHON AELOLD T" +
	"URKIC LETTER ORKHON ELTOLD TURKIC LETTER ORKHON EMOLD TURKIC LETTER ORKH" +
	"ON ANOLD TURKIC LETTER ORKHON AENOLD TURKIC LETTER YENISEI AENOLD TURKIC" +
	" LETTER ORKHON ENTOLD TURKIC LETTER YENISEI ENTOLD TURKIC LETTER ORKHON " +
	"ENCOLD TURKIC LETTER YENISEI ENCOLD TURKIC LETTER ORKHON ENYOLD TURKIC L" +
	"ETTER YENISEI ENYOLD TURKIC LETTER YENISEI ANGOLD TURKIC LETTER ORKHON E" +
	"NGOLD TURKIC LETTER YENISEI AENGOLD TURKIC LETTER ORKHON EPOLD TURKIC LE" +
	"TTER ORKHON OPOLD TURKIC LETTER ORKHON ICOLD TURKIC LETTER ORKHON ECOLD " +
	"TURKIC LETTER YENISEI ECOLD TURKIC LETTER ORKHON AQOLD TURKIC LETTER YEN" +
	"ISEI AQOLD TURKIC LETTER ORKHON IQOLD TURKIC LETTER YENISEI IQOLD TURKIC" +
	" LETTER ORKHON OQOLD TURKIC LETTER YENISEI OQOLD TURKIC LETTER ORKHON AR" +
	"OLD TURKIC LETTER YENISEI AROLD TURKIC LETTER ORKHON AEROLD TURKIC LETTE" +
	"R ORKHON ASOLD TURKIC LETTER ORKHON AESOLD TURKIC LETTER ORKHON ASHOLD T" +
	"URKIC LETTER YENISEI ASHOLD TURKIC LETTER ORKHON ESHOLD TURKIC LETTER YE" +
	"NISEI ESHOLD TURKIC LETTER ORKHON ATOLD TURKIC LETTER YENISEI ATOLD TURK" +
	"IC LETTER ORKHON AETOLD TURKIC LETTER YENISEI AETOLD TURKIC LETTER ORKHO" +
	"N OTOLD TURKIC LETTER ORKHON BASHOLD HUNGARIAN CAPITAL LETTER AOLD HUNGA" +
	"RIAN CAPITAL LETTER AAOLD HUNGARIAN CAPITAL LETTER EBOLD HUNGARIAN CAPIT" +
	"AL LETTER AMBOLD HUNGARIAN CAPITAL LETTER ECOLD HUNGARIAN CAPITAL LETTER" +
	" ENCOLD HUNGARIAN CAPITAL LETTER ECSOLD HUNGARIAN CAPITAL LETTER EDOLD H" +
	"UNGARIAN CAPITAL LETTER ANDOLD HUNGARIAN CAPITAL LETTER EOLD HUNGARIAN C" +
	"APITAL LETTER CLOSE EOLD HUNGARIAN CAPITAL LETTER EEOLD HUNGARIAN CAPITA" +
	"L LETTER EFOLD HUNGARIAN CAPITAL LETTER EGOLD HUNGARIAN CAPITAL LETTER E" +
	"GYOLD HUNGARIAN CAPITAL LETTER EHOLD HUNGARIAN CAPITAL LETTER IOLD HUNGA" +
	"RIAN CAPITAL LETTER IIOLD HUNGARIAN CAPITAL LETTER EJOLD HUNGARIAN CAPIT" +
	"AL LETTER EKOLD HUNGARIAN CAPITAL LETTER AKOLD HUNGARIAN CAPITAL LETTER " +
	"UNKOLD HUNGARIAN CAPITAL LETTER ELOLD HUNGARIAN CAPITAL LETTER ELYOLD HU" +
	"NGARIAN CAPITAL LETTER EMOLD HUNGARIAN CAPITAL LETTER ENOLD HUNGARIAN CA" +
	"PITAL LETTER ENYOLD HUNGARIAN CAPITAL LETTER OOLD HUNGARIAN CAPITAL LETT" +
	"ER OOOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OEOLD HUNGARIAN CAPITAL LET" +
	"TER RUDIMENTA OEOLD HUNGARIAN CAPITAL LETTER OEEOLD HUNGARIAN CAPITAL LE" +
	"TTER EPOLD HUNGARIAN CAPITAL LETTER EMPOLD HUNGARIAN CAPITAL LETTER EROL" +
	"D HUNGARIAN CAPITAL LETTER SHORT EROLD HUNGARIAN CAPITAL LETTER ESOLD HU" +
	"NGARIAN CAPITAL LETTER ESZOLD HUNGARIAN CAPITAL LETTER ETOLD HUNGARIAN C" +
	"APITAL LETTER ENTOLD HUNGARIAN CAPITAL LETTER ETYOLD HUNGARIAN CAPITAL L" +
	"ETTER ECHOLD HUNGARIAN CAPITAL LETTER UOLD HUNGARIAN CAPITAL LETTER UUOL") + ("" +
	"D HUNGARIAN CAPITAL LETTER NIKOLSBURG UEOLD HUNGARIAN CAPITAL LETTER RUD" +
	"IMENTA UEOLD HUNGARIAN CAPITAL LETTER EVOLD HUNGARIAN CAPITAL LETTER EZO" +
	"LD HUNGARIAN CAPITAL LETTER EZSOLD HUNGARIAN CAPITAL LETTER ENT-SHAPED S" +
	"IGNOLD HUNGARIAN CAPITAL LETTER USOLD HUNGARIAN SMALL LETTER AOLD HUNGAR" +
	"IAN SMALL LETTER AAOLD HUNGARIAN SMALL LETTER EBOLD HUNGARIAN SMALL LETT" +
	"ER AMBOLD HUNGARIAN SMALL LETTER ECOLD HUNGARIAN SMALL LETTER ENCOLD HUN" +
	"GARIAN SMALL LETTER ECSOLD HUNGARIAN SMALL LETTER EDOLD HUNGARIAN SMALL " +
	"LETTER ANDOLD HUNGARIAN SMALL LETTER EOLD HUNGARIAN SMALL LETTER CLOSE E" +
	"OLD HUNGARIAN SMALL LETTER EEOLD HUNGARIAN SMALL LETTER EFOLD HUNGARIAN " +
	"SMALL LETTER EGOLD HUNGARIAN SMALL LETTER EGYOLD HUNGARIAN SMALL LETTER " +
	"EHOLD HUNGARIAN SMALL LETTER IOLD HUNGARIAN SMALL LETTER IIOLD HUNGARIAN" +
	" SMALL LETTER EJOLD HUNGARIAN SMALL LETTER EKOLD HUNGARIAN SMALL LETTER " +
	"AKOLD HUNGARIAN SMALL LETTER UNKOLD HUNGARIAN SMALL LETTER ELOLD HUNGARI" +
	"AN SMALL LETTER ELYOLD HUNGARIAN SMALL LETTER EMOLD HUNGARIAN SMALL LETT" +
	"ER ENOLD HUNGARIAN SMALL LETTER ENYOLD HUNGARIAN SMALL LETTER OOLD HUNGA" +
	"RIAN SMALL LETTER OOOLD HUNGARIAN SMALL LETTER NIKOLSBURG OEOLD HUNGARIA" +
	"N SMALL LETTER RUDIMENTA OEOLD HUNGARIAN SMALL LETTER OEEOLD HUNGARIAN S" +
	"MALL LETTER EPOLD HUNGARIAN SMALL LETTER EMPOLD HUNGARIAN SMALL LETTER E" +
	"ROLD HUNGARIAN SMALL LETTER SHORT EROLD HUNGARIAN SMALL LETTER ESOLD HUN" +
	"GARIAN SMALL LETTER ESZOLD HUNGARIAN SMALL LETTER ETOLD HUNGARIAN SMALL " +
	"LETTER ENTOLD HUNGARIAN SMALL LETTER ETYOLD HUNGARIAN SMALL LETTER ECHOL" +
	"D HUNGARIAN SMALL LETTER UOLD HUNGARIAN SMALL LETTER UUOLD HUNGARIAN SMA" +
	"LL LETTER NIKOLSBURG UEOLD HUNGARIAN SMALL LETTER RUDIMENTA UEOLD HUNGAR" +
	"IAN SMALL LETTER EVOLD HUNGARIAN SMALL LETTER EZOLD HUNGARIAN SMALL LETT" +
	"ER EZSOLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGNOLD HUNGARIAN SMALL LETT" +
	"ER USOLD HUNGARIAN NUMBER ONEOLD HUNGARIAN NUMBER FIVEOLD HUNGARIAN NUMB" +
	"ER TENOLD HUNGARIAN NUMBER FIFTYOLD HUNGARIAN NUMBER ONE HUNDREDOLD HUNG" +
	"ARIAN NUMBER ONE THOUSANDRUMI DIGIT ONERUMI DIGIT TWORUMI DIGIT THREERUM" +
	"I DIGIT FOURRUMI DIGIT FIVERUMI DIGIT SIXRUMI DIGIT SEVENRUMI DIGIT EIGH" +
	"TRUMI DIGIT NINERUMI NUMBER TENRUMI NUMBER TWENTYRUMI NUMBER THIRTYRUMI " +
	"NUMBER FORTYRUMI NUMBER FIFTYRUMI NUMBER SIXTYRUMI NUMBER SEVENTYRUMI NU" +
	"MBER EIGHTYRUMI NUMBER NINETYRUMI NUMBER ONE HUNDREDRUMI NUMBER TWO HUND" +
	"REDRUMI NUMBER THREE HUNDREDRUMI NUMBER FOUR HUNDREDRUMI NUMBER FIVE HUN" +
	"DREDRUMI NUMBER SIX HUNDREDRUMI NUMBER SEVEN HUNDREDRUMI NUMBER EIGHT HU" +
	"NDREDRUMI NUMBER NINE HUNDREDRUMI FRACTION ONE HALFRUMI FRACTION ONE QUA" +
	"RTERRUMI FRACTION ONE THIRDRUMI FRACTION TWO THIRDSBRAHMI SIGN CANDRABIN" +
	"DUBRAHMI SIGN ANUSVARABRAHMI SIGN VISARGABRAHMI SIGN JIHVAMULIYABRAHMI S" +
	"IGN UPADHMANIYABRAHMI LETTER ABRAHMI LETTER AABRAHMI LETTER IBRAHMI LETT" +
	"ER IIBRAHMI LETTER UBRAHMI LETTER UUBRAHMI LETTER VOCALIC RBRAHMI LETTER" +
	" VOCALIC RRBRAHMI LETTER VOCALIC LBRAHMI LETTER VOCALIC LLBRAHMI LETTER " +
	"EBRAHMI LETTER AIBRAHMI LETTER OBRAHMI LETTER AUBRAHMI LETTER KABRAHMI L" +
	"ETTER KHABRAHMI LETTER GABRAHMI LETTER GHABRAHMI LETTER NGABRAHMI LETTER" +
	" CABRAHMI LETTER CHABRAHMI LETTER JABRAHMI LETTER JHABRAHMI LETTER NYABR" +
	"AHMI LETTER TTABRAHMI LETTER TTHABRAHMI LETTER DDABRAHMI LETTER DDHABRAH" +
	"MI LETTER NNABRAHMI LETTER TABRAHMI LETTER THABRAHMI LETTER DABRAHMI LET" +
	"TER DHABRAHMI LETTER NABRAHMI LETTER PABRAHMI LETTER PHABRAHMI LETTER BA" +
	"BRAHMI LETTER BHABRAHMI LETTER MABRAHMI LETTER YABRAHMI LETTER RABRAHMI " +
	"LETTER LABRAHMI LETTER VABRAHMI LETTER SHABRAHMI LETTER SSABRAHMI LETTER" +
	" SABRAHMI LETTER HABRAHMI LETTER LLABRAHMI LETTER OLD TAMIL LLLABRAHMI L" +
	"ETTER OLD TAMIL RRABRAHMI LETTER OLD TAMIL NNNABRAHMI VOWEL SIGN AABRAHM" +
	"I VOWEL SIGN BHATTIPROLU AABRAHMI VOWEL SIGN IBRAHMI VOWEL SIGN IIBRAHMI" +
	" VOWEL SIGN UBRAHMI VOWEL SIGN UUBRAHMI VOWEL SIGN VOCALIC RBRAHMI VOWEL" +
	" SIGN VOCALIC RRBRAHMI VOWEL SIGN VOCALIC LBRAHMI VOWEL SIGN VOCALIC LLB" +
	"RAHMI VOWEL SIGN EBRAHMI VOWEL SIGN AIBRAHMI VOWEL SIGN OBRAHMI VOWEL SI" +
	"GN AUBRAHMI VIRAMABRAHMI DANDABRAHMI DOUBLE DANDABRAHMI PUNCTUATION DOTB" +
	"RAHMI PUNCTUATION DOUBLE DOTBRAHMI PUNCTUATION LINEBRAHMI PUNCTUATION CR" +
	"ESCENT BARBRAHMI PUNCTUATION LOTUSBRAHMI NUMBER ONEBRAHMI NUMBER TWOBRAH" +
	"MI NUMBER THREEBRAHMI NUMBER FOURBRAHMI NUMBER FIVEBRAHMI NUMBER SIXBRAH" +
	"MI NUMBER SEVENBRAHMI NUMBER EIGHTBRAHMI NUMBER NINEBRAHMI NUMBER TENBRA" +
	"HMI NUMBER TWENTYBRAHMI NUMBER THIRTYBRAHMI NUMBER FORTYBRAHMI NUMBER FI" +
	"FTYBRAHMI NUMBER SIXTYBRAHMI NUMBER SEVENTYBRAHMI NUMBER EIGHTYBRAHMI NU" +
	"MBER NINETYBRAHMI NUMBER ONE HUNDREDBRAHMI NUMBER ONE THOUSANDBRAHMI DIG" +
	"IT ZEROBRAHMI DIGIT ONEBRAHMI DIGIT TWOBRAHMI DIGIT THREEBRAHMI DIGIT FO" +
	"URBRAHMI DIGIT FIVEBRAHMI DIGIT SIXBRAHMI DIGIT SEVENBRAHMI DIGIT EIGHTB") + ("" +
	"RAHMI DIGIT NINEBRAHMI NUMBER JOINERKAITHI SIGN CANDRABINDUKAITHI SIGN A" +
	"NUSVARAKAITHI SIGN VISARGAKAITHI LETTER AKAITHI LETTER AAKAITHI LETTER I" +
	"KAITHI LETTER IIKAITHI LETTER UKAITHI LETTER UUKAITHI LETTER EKAITHI LET" +
	"TER AIKAITHI LETTER OKAITHI LETTER AUKAITHI LETTER KAKAITHI LETTER KHAKA" +
	"ITHI LETTER GAKAITHI LETTER GHAKAITHI LETTER NGAKAITHI LETTER CAKAITHI L" +
	"ETTER CHAKAITHI LETTER JAKAITHI LETTER JHAKAITHI LETTER NYAKAITHI LETTER" +
	" TTAKAITHI LETTER TTHAKAITHI LETTER DDAKAITHI LETTER DDDHAKAITHI LETTER " +
	"DDHAKAITHI LETTER RHAKAITHI LETTER NNAKAITHI LETTER TAKAITHI LETTER THAK" +
	"AITHI LETTER DAKAITHI LETTER DHAKAITHI LETTER NAKAITHI LETTER PAKAITHI L" +
	"ETTER PHAKAITHI LETTER BAKAITHI LETTER BHAKAITHI LETTER MAKAITHI LETTER " +
	"YAKAITHI LETTER RAKAITHI LETTER LAKAITHI LETTER VAKAITHI LETTER SHAKAITH" +
	"I LETTER SSAKAITHI LETTER SAKAITHI LETTER HAKAITHI VOWEL SIGN AAKAITHI V" +
	"OWEL SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL SIGN UKAITHI VOWEL SIGN UUKA" +
	"ITHI VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI VOWEL SIGN OKAITHI VOWEL SIG" +
	"N AUKAITHI SIGN VIRAMAKAITHI SIGN NUKTAKAITHI ABBREVIATION SIGNKAITHI EN" +
	"UMERATION SIGNKAITHI NUMBER SIGNKAITHI SECTION MARKKAITHI DOUBLE SECTION" +
	" MARKKAITHI DANDAKAITHI DOUBLE DANDASORA SOMPENG LETTER SAHSORA SOMPENG " +
	"LETTER TAHSORA SOMPENG LETTER BAHSORA SOMPENG LETTER CAHSORA SOMPENG LET" +
	"TER DAHSORA SOMPENG LETTER GAHSORA SOMPENG LETTER MAHSORA SOMPENG LETTER" +
	" NGAHSORA SOMPENG LETTER LAHSORA SOMPENG LETTER NAHSORA SOMPENG LETTER V" +
	"AHSORA SOMPENG LETTER PAHSORA SOMPENG LETTER YAHSORA SOMPENG LETTER RAHS" +
	"ORA SOMPENG LETTER HAHSORA SOMPENG LETTER KAHSORA SOMPENG LETTER JAHSORA" +
	" SOMPENG LETTER NYAHSORA SOMPENG LETTER AHSORA SOMPENG LETTER EEHSORA SO" +
	"MPENG LETTER IHSORA SOMPENG LETTER UHSORA SOMPENG LETTER OHSORA SOMPENG " +
	"LETTER EHSORA SOMPENG LETTER MAESORA SOMPENG DIGIT ZEROSORA SOMPENG DIGI" +
	"T ONESORA SOMPENG DIGIT TWOSORA SOMPENG DIGIT THREESORA SOMPENG DIGIT FO" +
	"URSORA SOMPENG DIGIT FIVESORA SOMPENG DIGIT SIXSORA SOMPENG DIGIT SEVENS" +
	"ORA SOMPENG DIGIT EIGHTSORA SOMPENG DIGIT NINECHAKMA SIGN CANDRABINDUCHA" +
	"KMA SIGN ANUSVARACHAKMA SIGN VISARGACHAKMA LETTER AACHAKMA LETTER ICHAKM" +
	"A LETTER UCHAKMA LETTER ECHAKMA LETTER KAACHAKMA LETTER KHAACHAKMA LETTE" +
	"R GAACHAKMA LETTER GHAACHAKMA LETTER NGAACHAKMA LETTER CAACHAKMA LETTER " +
	"CHAACHAKMA LETTER JAACHAKMA LETTER JHAACHAKMA LETTER NYAACHAKMA LETTER T" +
	"TAACHAKMA LETTER TTHAACHAKMA LETTER DDAACHAKMA LETTER DDHAACHAKMA LETTER" +
	" NNAACHAKMA LETTER TAACHAKMA LETTER THAACHAKMA LETTER DAACHAKMA LETTER D" +
	"HAACHAKMA LETTER NAACHAKMA LETTER PAACHAKMA LETTER PHAACHAKMA LETTER BAA" +
	"CHAKMA LETTER BHAACHAKMA LETTER MAACHAKMA LETTER YYAACHAKMA LETTER YAACH" +
	"AKMA LETTER RAACHAKMA LETTER LAACHAKMA LETTER WAACHAKMA LETTER SAACHAKMA" +
	" LETTER HAACHAKMA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAKMA VOWEL SIGN IICHA" +
	"KMA VOWEL SIGN UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN ECHAKMA VOWEL SIGN" +
	" AICHAKMA VOWEL SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWEL SIGN OICHAKMA O M" +
	"ARKCHAKMA AU MARKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DIGIT ZEROCHAKMA DIGI" +
	"T ONECHAKMA DIGIT TWOCHAKMA DIGIT THREECHAKMA DIGIT FOURCHAKMA DIGIT FIV" +
	"ECHAKMA DIGIT SIXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHTCHAKMA DIGIT NINECH" +
	"AKMA SECTION MARKCHAKMA DANDACHAKMA DOUBLE DANDACHAKMA QUESTION MARKMAHA" +
	"JANI LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTER EMAHAJANI" +
	" LETTER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER GAMAHAJANI" +
	" LETTER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETTER JAMAHAJA" +
	"NI LETTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI LETTER TTHAM" +
	"AHAJANI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHAJANI LETTER" +
	" TAMAHAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMAHAJANI LETT" +
	"ER NAMAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAMAHAJANI LET" +
	"TER BHAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LAMAHAJANI LE" +
	"TTER VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RRAMAHAJANI S" +
	"IGN NUKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJANI LIGATUR" +
	"E SHRISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SIGN VISARGAS" +
	"HARADA LETTER ASHARADA LETTER AASHARADA LETTER ISHARADA LETTER IISHARADA" +
	" LETTER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LETTER VOCALIC" +
	" RRSHARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA LETTER ESHAR" +
	"ADA LETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER KASHARADA L" +
	"ETTER KHASHARADA LETTER GASHARADA LETTER GHASHARADA LETTER NGASHARADA LE" +
	"TTER CASHARADA LETTER CHASHARADA LETTER JASHARADA LETTER JHASHARADA LETT" +
	"ER NYASHARADA LETTER TTASHARADA LETTER TTHASHARADA LETTER DDASHARADA LET" +
	"TER DDHASHARADA LETTER NNASHARADA LETTER TASHARADA LETTER THASHARADA LET" +
	"TER DASHARADA LETTER DHASHARADA LETTER NASHARADA LETTER PASHARADA LETTER") + ("" +
	" PHASHARADA LETTER BASHARADA LETTER BHASHARADA LETTER MASHARADA LETTER Y" +
	"ASHARADA LETTER RASHARADA LETTER LASHARADA LETTER LLASHARADA LETTER VASH" +
	"ARADA LETTER SHASHARADA LETTER SSASHARADA LETTER SASHARADA LETTER HASHAR" +
	"ADA VOWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHARADA VOWEL " +
	"SIGN USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARADA VOWEL SIG" +
	"N VOCALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VOCALIC LLSHA" +
	"RADA VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHARADA VOWEL " +
	"SIGN AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN JIHVAMULIYAS" +
	"HARADA SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE DANDASHARAD" +
	"A ABBREVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARADA SIGN NUKT" +
	"ASHARADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHARADA SUTRA " +
	"MARKSHARADA DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DIGIT TH" +
	"REESHARADA DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DIGIT SE" +
	"VENSHARADA DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN SIDDHAM" +
	"SHARADA HEADSTROKESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1SHARADA" +
	" SECTION MARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOSINHALA" +
	" ARCHAIC DIGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGIT FIVE" +
	"SINHALA ARCHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAIC DIGI" +
	"T EIGHTSINHALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA ARCHA" +
	"IC NUMBER TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBER FORT" +
	"YSINHALA ARCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA ARCHAIC" +
	" NUMBER SEVENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER NINET" +
	"YSINHALA ARCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOUSANDKH" +
	"OJKI LETTER AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI LETTER" +
	" EKHOJKI LETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAKHOJKI " +
	"LETTER KHAKHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI LETTE" +
	"R NGAKHOJKI LETTER CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTER JJAK" +
	"HOJKI LETTER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER DDAKHOJ" +
	"KI LETTER DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKHOJKI L" +
	"ETTER DAKHOJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI LETTER" +
	" PAKHOJKI LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER BHAKH" +
	"OJKI LETTER MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJKI LET" +
	"TER VAKHOJKI LETTER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWEL SIGN" +
	" AAKHOJKI VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJKI VOWE" +
	"L SIGN EKHOJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN AUKHOJK" +
	"I SIGN ANUSVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHADDAKHOJ" +
	"KI DANDAKHOJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MARKKHOJK" +
	"I DOUBLE SECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNMULTANI LE" +
	"TTER AMULTANI LETTER IMULTANI LETTER UMULTANI LETTER EMULTANI LETTER KAM" +
	"ULTANI LETTER KHAMULTANI LETTER GAMULTANI LETTER GHAMULTANI LETTER CAMUL" +
	"TANI LETTER CHAMULTANI LETTER JAMULTANI LETTER JJAMULTANI LETTER NYAMULT" +
	"ANI LETTER TTAMULTANI LETTER TTHAMULTANI LETTER DDAMULTANI LETTER DDDAMU" +
	"LTANI LETTER DDHAMULTANI LETTER NNAMULTANI LETTER TAMULTANI LETTER THAMU" +
	"LTANI LETTER DAMULTANI LETTER DHAMULTANI LETTER NAMULTANI LETTER PAMULTA" +
	"NI LETTER PHAMULTANI LETTER BAMULTANI LETTER BHAMULTANI LETTER MAMULTANI" +
	" LETTER YAMULTANI LETTER RAMULTANI LETTER LAMULTANI LETTER VAMULTANI LET" +
	"TER SAMULTANI LETTER HAMULTANI LETTER RRAMULTANI LETTER RHAMULTANI SECTI" +
	"ON MARKKHUDAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDAWADI " +
	"LETTER IIKHUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHUDAWAD" +
	"I LETTER AIKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDAWADI LETTER KAKHUDA" +
	"WADI LETTER KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LETTER G" +
	"HAKHUDAWADI LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAWADI L" +
	"ETTER JAKHUDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NYAKHUD" +
	"AWADI LETTER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI LETTE" +
	"R DDDAKHUDAWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNAKHUDA" +
	"WADI LETTER TAKHUDAWADI LETTER THAKHUDAWADI LETTER DAKHUDAWADI LETTER DH" +
	"AKHUDAWADI LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETTER PHAKHUDAWADI LET" +
	"TER BAKHUDAWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKHUDAWA" +
	"DI LETTER YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHUDAWADI LETTER VAKHU" +
	"DAWADI LETTER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER HAKHUDAWADI SIGN AN" +
	"USVARAKHUDAWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL SIGN " +
	"IIKHUDAWADI VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN EKHU" +
	"DAWADI VOWEL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKHUDAWA" +
	"DI SIGN NUKTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIGIT ON") + ("" +
	"EKHUDAWADI DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAWADI D" +
	"IGIT FIVEKHUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EIGHTKH" +
	"UDAWADI DIGIT NINEGRANTHA SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN CAND" +
	"RABINDUGRANTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRANTHA " +
	"LETTER AAGRANTHA LETTER IGRANTHA LETTER IIGRANTHA LETTER UGRANTHA LETTER" +
	" UUGRANTHA LETTER VOCALIC RGRANTHA LETTER VOCALIC LGRANTHA LETTER EEGRAN" +
	"THA LETTER AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTHA LETTER KAGRANTHA " +
	"LETTER KHAGRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRANTHA L" +
	"ETTER CAGRANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LETTER JHAGRANTHA LET" +
	"TER NYAGRANTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA LETTER DDAGRANTHA LE" +
	"TTER DDHAGRANTHA LETTER NNAGRANTHA LETTER TAGRANTHA LETTER THAGRANTHA LE" +
	"TTER DAGRANTHA LETTER DHAGRANTHA LETTER NAGRANTHA LETTER PAGRANTHA LETTE" +
	"R PHAGRANTHA LETTER BAGRANTHA LETTER BHAGRANTHA LETTER MAGRANTHA LETTER " +
	"YAGRANTHA LETTER RAGRANTHA LETTER LAGRANTHA LETTER LLAGRANTHA LETTER VAG" +
	"RANTHA LETTER SHAGRANTHA LETTER SSAGRANTHA LETTER SAGRANTHA LETTER HAGRA" +
	"NTHA SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VOWEL SIGN AAGRANTHA VOWEL S" +
	"IGN IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN UGRANTHA VOWEL SIGN UUGRANT" +
	"HA VOWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCALIC RRGRANTHA VOWEL SIGN E" +
	"EGRANTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRANTHA VOWEL SIGN AUGRANTHA " +
	"SIGN VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRANTHA SIGN PLUTAGRANTHA LET" +
	"TER VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE ANUSVARAGRANTHA LETTER VOC" +
	"ALIC RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL SIGN VOCALIC LGRANTHA VOWE" +
	"L SIGN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROCOMBINING GRANTHA DIGIT ONE" +
	"COMBINING GRANTHA DIGIT TWOCOMBINING GRANTHA DIGIT THREECOMBINING GRANTH" +
	"A DIGIT FOURCOMBINING GRANTHA DIGIT FIVECOMBINING GRANTHA DIGIT SIXCOMBI" +
	"NING GRANTHA LETTER ACOMBINING GRANTHA LETTER KACOMBINING GRANTHA LETTER" +
	" NACOMBINING GRANTHA LETTER VICOMBINING GRANTHA LETTER PANEWA LETTER ANE" +
	"WA LETTER AANEWA LETTER INEWA LETTER IINEWA LETTER UNEWA LETTER UUNEWA L" +
	"ETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LETTER VOCALIC LNEWA LETTER VO" +
	"CALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTER ONEWA LETTER AUNEWA LETTE" +
	"R KANEWA LETTER KHANEWA LETTER GANEWA LETTER GHANEWA LETTER NGANEWA LETT" +
	"ER NGHANEWA LETTER CANEWA LETTER CHANEWA LETTER JANEWA LETTER JHANEWA LE" +
	"TTER NYANEWA LETTER NYHANEWA LETTER TTANEWA LETTER TTHANEWA LETTER DDANE" +
	"WA LETTER DDHANEWA LETTER NNANEWA LETTER TANEWA LETTER THANEWA LETTER DA" +
	"NEWA LETTER DHANEWA LETTER NANEWA LETTER NHANEWA LETTER PANEWA LETTER PH" +
	"ANEWA LETTER BANEWA LETTER BHANEWA LETTER MANEWA LETTER MHANEWA LETTER Y" +
	"ANEWA LETTER RANEWA LETTER RHANEWA LETTER LANEWA LETTER LHANEWA LETTER W" +
	"ANEWA LETTER SHANEWA LETTER SSANEWA LETTER SANEWA LETTER HANEWA VOWEL SI" +
	"GN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA VOWEL SIGN UNEWA VOWEL SIGN" +
	" UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN VOCALIC RRNEWA VOWEL SIGN VO" +
	"CALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL SIGN ENEWA VOWEL SIGN AINEWA" +
	" VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRAMANEWA SIGN CANDRABINDUNEWA" +
	" SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKTANEWA SIGN AVAGRAHANEWA SIG" +
	"N FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDANEWA DOUBLE DANDANEWA COMMAN" +
	"EWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGIT ZERONEWA DIGIT ONENEWA DI" +
	"GIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DIGIT FIVENEWA DIGIT SIXNEWA " +
	"DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEWA PLACEHOLDER MARKNEWA INSE" +
	"RTION SIGNTIRHUTA ANJITIRHUTA LETTER ATIRHUTA LETTER AATIRHUTA LETTER IT" +
	"IRHUTA LETTER IITIRHUTA LETTER UTIRHUTA LETTER UUTIRHUTA LETTER VOCALIC " +
	"RTIRHUTA LETTER VOCALIC RRTIRHUTA LETTER VOCALIC LTIRHUTA LETTER VOCALIC" +
	" LLTIRHUTA LETTER ETIRHUTA LETTER AITIRHUTA LETTER OTIRHUTA LETTER AUTIR" +
	"HUTA LETTER KATIRHUTA LETTER KHATIRHUTA LETTER GATIRHUTA LETTER GHATIRHU" +
	"TA LETTER NGATIRHUTA LETTER CATIRHUTA LETTER CHATIRHUTA LETTER JATIRHUTA" +
	" LETTER JHATIRHUTA LETTER NYATIRHUTA LETTER TTATIRHUTA LETTER TTHATIRHUT" +
	"A LETTER DDATIRHUTA LETTER DDHATIRHUTA LETTER NNATIRHUTA LETTER TATIRHUT" +
	"A LETTER THATIRHUTA LETTER DATIRHUTA LETTER DHATIRHUTA LETTER NATIRHUTA " +
	"LETTER PATIRHUTA LETTER PHATIRHUTA LETTER BATIRHUTA LETTER BHATIRHUTA LE" +
	"TTER MATIRHUTA LETTER YATIRHUTA LETTER RATIRHUTA LETTER LATIRHUTA LETTER" +
	" VATIRHUTA LETTER SHATIRHUTA LETTER SSATIRHUTA LETTER SATIRHUTA LETTER H" +
	"ATIRHUTA VOWEL SIGN AATIRHUTA VOWEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA V" +
	"OWEL SIGN UTIRHUTA VOWEL SIGN UUTIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWE" +
	"L SIGN VOCALIC RRTIRHUTA VOWEL SIGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC " +
	"LLTIRHUTA VOWEL SIGN ETIRHUTA VOWEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIR" +
	"HUTA VOWEL SIGN OTIRHUTA VOWEL SIGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA ") + ("" +
	"SIGN CANDRABINDUTIRHUTA SIGN ANUSVARATIRHUTA SIGN VISARGATIRHUTA SIGN VI" +
	"RAMATIRHUTA SIGN NUKTATIRHUTA SIGN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIA" +
	"TION SIGNTIRHUTA OMTIRHUTA DIGIT ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOT" +
	"IRHUTA DIGIT THREETIRHUTA DIGIT FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXT" +
	"IRHUTA DIGIT SEVENTIRHUTA DIGIT EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER AS" +
	"IDDHAM LETTER AASIDDHAM LETTER ISIDDHAM LETTER IISIDDHAM LETTER USIDDHAM" +
	" LETTER UUSIDDHAM LETTER VOCALIC RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTE" +
	"R VOCALIC LSIDDHAM LETTER VOCALIC LLSIDDHAM LETTER ESIDDHAM LETTER AISID" +
	"DHAM LETTER OSIDDHAM LETTER AUSIDDHAM LETTER KASIDDHAM LETTER KHASIDDHAM" +
	" LETTER GASIDDHAM LETTER GHASIDDHAM LETTER NGASIDDHAM LETTER CASIDDHAM L" +
	"ETTER CHASIDDHAM LETTER JASIDDHAM LETTER JHASIDDHAM LETTER NYASIDDHAM LE" +
	"TTER TTASIDDHAM LETTER TTHASIDDHAM LETTER DDASIDDHAM LETTER DDHASIDDHAM " +
	"LETTER NNASIDDHAM LETTER TASIDDHAM LETTER THASIDDHAM LETTER DASIDDHAM LE" +
	"TTER DHASIDDHAM LETTER NASIDDHAM LETTER PASIDDHAM LETTER PHASIDDHAM LETT" +
	"ER BASIDDHAM LETTER BHASIDDHAM LETTER MASIDDHAM LETTER YASIDDHAM LETTER " +
	"RASIDDHAM LETTER LASIDDHAM LETTER VASIDDHAM LETTER SHASIDDHAM LETTER SSA" +
	"SIDDHAM LETTER SASIDDHAM LETTER HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIG" +
	"N ISIDDHAM VOWEL SIGN IISIDDHAM VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM" +
	" VOWEL SIGN VOCALIC RSIDDHAM VOWEL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESI" +
	"DDHAM VOWEL SIGN AISIDDHAM VOWEL SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN" +
	" CANDRABINDUSIDDHAM SIGN ANUSVARASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMA" +
	"SIDDHAM SIGN NUKTASIDDHAM SIGN SIDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDAS" +
	"IDDHAM SEPARATOR DOTSIDDHAM SEPARATOR BARSIDDHAM REPETITION MARK-1SIDDHA" +
	"M REPETITION MARK-2SIDDHAM REPETITION MARK-3SIDDHAM END OF TEXT MARKSIDD" +
	"HAM SECTION MARK WITH TRIDENT AND U-SHAPED ORNAMENTSSIDDHAM SECTION MARK" +
	" WITH TRIDENT AND DOTTED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOT" +
	"TED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTSS" +
	"IDDHAM SECTION MARK WITH RAYS AND DOTTED TRIPLE CRESCENTSSIDDHAM SECTION" +
	" MARK DOUBLE RINGSIDDHAM SECTION MARK DOUBLE RING WITH RAYSSIDDHAM SECTI" +
	"ON MARK WITH DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH TRIPLE CRESCENTSS" +
	"IDDHAM SECTION MARK WITH QUADRUPLE CRESCENTSSIDDHAM SECTION MARK WITH SE" +
	"PTUPLE CRESCENTSSIDDHAM SECTION MARK WITH CIRCLES AND RAYSSIDDHAM SECTIO" +
	"N MARK WITH CIRCLES AND TWO ENCLOSURESSIDDHAM SECTION MARK WITH CIRCLES " +
	"AND FOUR ENCLOSURESSIDDHAM LETTER THREE-CIRCLE ALTERNATE ISIDDHAM LETTER" +
	" TWO-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE IISIDDHAM LET" +
	"TER ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE USIDDHAM VOWEL SIGN ALTERNAT" +
	"E UUMODI LETTER AMODI LETTER AAMODI LETTER IMODI LETTER IIMODI LETTER UM" +
	"ODI LETTER UUMODI LETTER VOCALIC RMODI LETTER VOCALIC RRMODI LETTER VOCA" +
	"LIC LMODI LETTER VOCALIC LLMODI LETTER EMODI LETTER AIMODI LETTER OMODI " +
	"LETTER AUMODI LETTER KAMODI LETTER KHAMODI LETTER GAMODI LETTER GHAMODI " +
	"LETTER NGAMODI LETTER CAMODI LETTER CHAMODI LETTER JAMODI LETTER JHAMODI" +
	" LETTER NYAMODI LETTER TTAMODI LETTER TTHAMODI LETTER DDAMODI LETTER DDH" +
	"AMODI LETTER NNAMODI LETTER TAMODI LETTER THAMODI LETTER DAMODI LETTER D" +
	"HAMODI LETTER NAMODI LETTER PAMODI LETTER PHAMODI LETTER BAMODI LETTER B" +
	"HAMODI LETTER MAMODI LETTER YAMODI LETTER RAMODI LETTER LAMODI LETTER VA" +
	"MODI LETTER SHAMODI LETTER SSAMODI LETTER SAMODI LETTER HAMODI LETTER LL" +
	"AMODI VOWEL SIGN AAMODI VOWEL SIGN IMODI VOWEL SIGN IIMODI VOWEL SIGN UM" +
	"ODI VOWEL SIGN UUMODI VOWEL SIGN VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI" +
	" VOWEL SIGN VOCALIC LMODI VOWEL SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOW" +
	"EL SIGN AIMODI VOWEL SIGN OMODI VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN" +
	" VISARGAMODI SIGN VIRAMAMODI SIGN ARDHACANDRAMODI DANDAMODI DOUBLE DANDA" +
	"MODI ABBREVIATION SIGNMODI SIGN HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DI" +
	"GIT TWOMODI DIGIT THREEMODI DIGIT FOURMODI DIGIT FIVEMODI DIGIT SIXMODI " +
	"DIGIT SEVENMODI DIGIT EIGHTMODI DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTM" +
	"ONGOLIAN ROTATED BIRGAMONGOLIAN DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIP" +
	"LE BIRGA WITH ORNAMENTMONGOLIAN BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTA" +
	"TED BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENTMONGO" +
	"LIAN INVERTED BIRGAMONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIA" +
	"N SWIRL BIRGAMONGOLIAN SWIRL BIRGA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WI" +
	"TH DOUBLE ORNAMENTMONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI" +
	" LETTER ATAKRI LETTER AATAKRI LETTER ITAKRI LETTER IITAKRI LETTER UTAKRI" +
	" LETTER UUTAKRI LETTER ETAKRI LETTER AITAKRI LETTER OTAKRI LETTER AUTAKR" +
	"I LETTER KATAKRI LETTER KHATAKRI LETTER GATAKRI LETTER GHATAKRI LETTER N" +
	"GATAKRI LETTER CATAKRI LETTER CHATAKRI LETTER JATAKRI LETTER JHATAKRI LE") + ("" +
	"TTER NYATAKRI LETTER TTATAKRI LETTER TTHATAKRI LETTER DDATAKRI LETTER DD" +
	"HATAKRI LETTER NNATAKRI LETTER TATAKRI LETTER THATAKRI LETTER DATAKRI LE" +
	"TTER DHATAKRI LETTER NATAKRI LETTER PATAKRI LETTER PHATAKRI LETTER BATAK" +
	"RI LETTER BHATAKRI LETTER MATAKRI LETTER YATAKRI LETTER RATAKRI LETTER L" +
	"ATAKRI LETTER VATAKRI LETTER SHATAKRI LETTER SATAKRI LETTER HATAKRI LETT" +
	"ER RRATAKRI SIGN ANUSVARATAKRI SIGN VISARGATAKRI VOWEL SIGN AATAKRI VOWE" +
	"L SIGN ITAKRI VOWEL SIGN IITAKRI VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VO" +
	"WEL SIGN ETAKRI VOWEL SIGN AITAKRI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI " +
	"SIGN VIRAMATAKRI SIGN NUKTATAKRI DIGIT ZEROTAKRI DIGIT ONETAKRI DIGIT TW" +
	"OTAKRI DIGIT THREETAKRI DIGIT FOURTAKRI DIGIT FIVETAKRI DIGIT SIXTAKRI D" +
	"IGIT SEVENTAKRI DIGIT EIGHTTAKRI DIGIT NINEAHOM LETTER KAAHOM LETTER KHA" +
	"AHOM LETTER NGAAHOM LETTER NAAHOM LETTER TAAHOM LETTER ALTERNATE TAAHOM " +
	"LETTER PAAHOM LETTER PHAAHOM LETTER BAAHOM LETTER MAAHOM LETTER JAAHOM L" +
	"ETTER CHAAHOM LETTER THAAHOM LETTER RAAHOM LETTER LAAHOM LETTER SAAHOM L" +
	"ETTER NYAAHOM LETTER HAAHOM LETTER AAHOM LETTER DAAHOM LETTER DHAAHOM LE" +
	"TTER GAAHOM LETTER ALTERNATE GAAHOM LETTER GHAAHOM LETTER BHAAHOM LETTER" +
	" JHAAHOM CONSONANT SIGN MEDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSO" +
	"NANT SIGN MEDIAL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWE" +
	"L SIGN IAHOM VOWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL " +
	"SIGN EAHOM VOWEL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SI" +
	"GN AMAHOM SIGN KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIG" +
	"IT THREEAHOM DIGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM" +
	" DIGIT EIGHTAHOM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SM" +
	"ALL SECTIONAHOM SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL VIWARANG CITI CAP" +
	"ITAL LETTER NGAAWARANG CITI CAPITAL LETTER AWARANG CITI CAPITAL LETTER W" +
	"IWARANG CITI CAPITAL LETTER YUWARANG CITI CAPITAL LETTER YAWARANG CITI C" +
	"APITAL LETTER YOWARANG CITI CAPITAL LETTER IIWARANG CITI CAPITAL LETTER " +
	"UUWARANG CITI CAPITAL LETTER EWARANG CITI CAPITAL LETTER OWARANG CITI CA" +
	"PITAL LETTER ANGWARANG CITI CAPITAL LETTER GAWARANG CITI CAPITAL LETTER " +
	"KOWARANG CITI CAPITAL LETTER ENYWARANG CITI CAPITAL LETTER YUJWARANG CIT" +
	"I CAPITAL LETTER UCWARANG CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LET" +
	"TER ODDWARANG CITI CAPITAL LETTER TTEWARANG CITI CAPITAL LETTER NUNGWARA" +
	"NG CITI CAPITAL LETTER DAWARANG CITI CAPITAL LETTER ATWARANG CITI CAPITA" +
	"L LETTER AMWARANG CITI CAPITAL LETTER BUWARANG CITI CAPITAL LETTER PUWAR" +
	"ANG CITI CAPITAL LETTER HIYOWARANG CITI CAPITAL LETTER HOLOWARANG CITI C" +
	"APITAL LETTER HORRWARANG CITI CAPITAL LETTER HARWARANG CITI CAPITAL LETT" +
	"ER SSUUWARANG CITI CAPITAL LETTER SIIWARANG CITI CAPITAL LETTER VIYOWARA" +
	"NG CITI SMALL LETTER NGAAWARANG CITI SMALL LETTER AWARANG CITI SMALL LET" +
	"TER WIWARANG CITI SMALL LETTER YUWARANG CITI SMALL LETTER YAWARANG CITI " +
	"SMALL LETTER YOWARANG CITI SMALL LETTER IIWARANG CITI SMALL LETTER UUWAR" +
	"ANG CITI SMALL LETTER EWARANG CITI SMALL LETTER OWARANG CITI SMALL LETTE" +
	"R ANGWARANG CITI SMALL LETTER GAWARANG CITI SMALL LETTER KOWARANG CITI S" +
	"MALL LETTER ENYWARANG CITI SMALL LETTER YUJWARANG CITI SMALL LETTER UCWA" +
	"RANG CITI SMALL LETTER ENNWARANG CITI SMALL LETTER ODDWARANG CITI SMALL " +
	"LETTER TTEWARANG CITI SMALL LETTER NUNGWARANG CITI SMALL LETTER DAWARANG" +
	" CITI SMALL LETTER ATWARANG CITI SMALL LETTER AMWARANG CITI SMALL LETTER" +
	" BUWARANG CITI SMALL LETTER PUWARANG CITI SMALL LETTER HIYOWARANG CITI S" +
	"MALL LETTER HOLOWARANG CITI SMALL LETTER HORRWARANG CITI SMALL LETTER HA" +
	"RWARANG CITI SMALL LETTER SSUUWARANG CITI SMALL LETTER SIIWARANG CITI SM" +
	"ALL LETTER VIYOWARANG CITI DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI DI" +
	"GIT TWOWARANG CITI DIGIT THREEWARANG CITI DIGIT FOURWARANG CITI DIGIT FI" +
	"VEWARANG CITI DIGIT SIXWARANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWAR" +
	"ANG CITI DIGIT NINEWARANG CITI NUMBER TENWARANG CITI NUMBER TWENTYWARANG" +
	" CITI NUMBER THIRTYWARANG CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARAN" +
	"G CITI NUMBER SIXTYWARANG CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYWA" +
	"RANG CITI NUMBER NINETYWARANG CITI OMZANABAZAR SQUARE LETTER AZANABAZAR " +
	"SQUARE VOWEL SIGN IZANABAZAR SQUARE VOWEL SIGN UEZANABAZAR SQUARE VOWEL " +
	"SIGN UZANABAZAR SQUARE VOWEL SIGN EZANABAZAR SQUARE VOWEL SIGN OEZANABAZ" +
	"AR SQUARE VOWEL SIGN OZANABAZAR SQUARE VOWEL SIGN AIZANABAZAR SQUARE VOW" +
	"EL SIGN AUZANABAZAR SQUARE VOWEL SIGN REVERSED IZANABAZAR SQUARE VOWEL L" +
	"ENGTH MARKZANABAZAR SQUARE LETTER KAZANABAZAR SQUARE LETTER KHAZANABAZAR" +
	" SQUARE LETTER GAZANABAZAR SQUARE LETTER GHAZANABAZAR SQUARE LETTER NGAZ" +
	"ANABAZAR SQUARE LETTER CAZANABAZAR SQUARE LETTER CHAZANABAZAR SQUARE LET" +
	"TER JAZANABAZAR SQUARE LETTER NYAZANABAZAR SQUARE LETTER TTAZANABAZAR SQ") + ("" +
	"UARE LETTER TTHAZANABAZAR SQUARE LETTER DDAZANABAZAR SQUARE LETTER DDHAZ" +
	"ANABAZAR SQUARE LETTER NNAZANABAZAR SQUARE LETTER TAZANABAZAR SQUARE LET" +
	"TER THAZANABAZAR SQUARE LETTER DAZANABAZAR SQUARE LETTER DHAZANABAZAR SQ" +
	"UARE LETTER NAZANABAZAR SQUARE LETTER PAZANABAZAR SQUARE LETTER PHAZANAB" +
	"AZAR SQUARE LETTER BAZANABAZAR SQUARE LETTER BHAZANABAZAR SQUARE LETTER " +
	"MAZANABAZAR SQUARE LETTER TSAZANABAZAR SQUARE LETTER TSHAZANABAZAR SQUAR" +
	"E LETTER DZAZANABAZAR SQUARE LETTER DZHAZANABAZAR SQUARE LETTER ZHAZANAB" +
	"AZAR SQUARE LETTER ZAZANABAZAR SQUARE LETTER -AZANABAZAR SQUARE LETTER Y" +
	"AZANABAZAR SQUARE LETTER RAZANABAZAR SQUARE LETTER LAZANABAZAR SQUARE LE" +
	"TTER VAZANABAZAR SQUARE LETTER SHAZANABAZAR SQUARE LETTER SSAZANABAZAR S" +
	"QUARE LETTER SAZANABAZAR SQUARE LETTER HAZANABAZAR SQUARE LETTER KSSAZAN" +
	"ABAZAR SQUARE FINAL CONSONANT MARKZANABAZAR SQUARE SIGN VIRAMAZANABAZAR " +
	"SQUARE SIGN CANDRABINDUZANABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENTZA" +
	"NABAZAR SQUARE SIGN CANDRA WITH ORNAMENTZANABAZAR SQUARE SIGN ANUSVARAZA" +
	"NABAZAR SQUARE SIGN VISARGAZANABAZAR SQUARE CLUSTER-INITIAL LETTER RAZAN" +
	"ABAZAR SQUARE CLUSTER-FINAL LETTER YAZANABAZAR SQUARE CLUSTER-FINAL LETT" +
	"ER RAZANABAZAR SQUARE CLUSTER-FINAL LETTER LAZANABAZAR SQUARE CLUSTER-FI" +
	"NAL LETTER VAZANABAZAR SQUARE INITIAL HEAD MARKZANABAZAR SQUARE CLOSING " +
	"HEAD MARKZANABAZAR SQUARE MARK TSHEGZANABAZAR SQUARE MARK SHADZANABAZAR " +
	"SQUARE MARK DOUBLE SHADZANABAZAR SQUARE MARK LONG TSHEGZANABAZAR SQUARE " +
	"INITIAL DOUBLE-LINED HEAD MARKZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD" +
	" MARKZANABAZAR SQUARE SUBJOINERSOYOMBO LETTER ASOYOMBO VOWEL SIGN ISOYOM" +
	"BO VOWEL SIGN UESOYOMBO VOWEL SIGN USOYOMBO VOWEL SIGN ESOYOMBO VOWEL SI" +
	"GN OSOYOMBO VOWEL SIGN OESOYOMBO VOWEL SIGN AISOYOMBO VOWEL SIGN AUSOYOM" +
	"BO VOWEL SIGN VOCALIC RSOYOMBO VOWEL SIGN VOCALIC LSOYOMBO VOWEL LENGTH " +
	"MARKSOYOMBO LETTER KASOYOMBO LETTER KHASOYOMBO LETTER GASOYOMBO LETTER G" +
	"HASOYOMBO LETTER NGASOYOMBO LETTER CASOYOMBO LETTER CHASOYOMBO LETTER JA" +
	"SOYOMBO LETTER JHASOYOMBO LETTER NYASOYOMBO LETTER TTASOYOMBO LETTER TTH" +
	"ASOYOMBO LETTER DDASOYOMBO LETTER DDHASOYOMBO LETTER NNASOYOMBO LETTER T" +
	"ASOYOMBO LETTER THASOYOMBO LETTER DASOYOMBO LETTER DHASOYOMBO LETTER NAS" +
	"OYOMBO LETTER PASOYOMBO LETTER PHASOYOMBO LETTER BASOYOMBO LETTER BHASOY" +
	"OMBO LETTER MASOYOMBO LETTER TSASOYOMBO LETTER TSHASOYOMBO LETTER DZASOY" +
	"OMBO LETTER ZHASOYOMBO LETTER ZASOYOMBO LETTER -ASOYOMBO LETTER YASOYOMB" +
	"O LETTER RASOYOMBO LETTER LASOYOMBO LETTER VASOYOMBO LETTER SHASOYOMBO L" +
	"ETTER SSASOYOMBO LETTER SASOYOMBO LETTER HASOYOMBO LETTER KSSASOYOMBO CL" +
	"USTER-INITIAL LETTER RASOYOMBO CLUSTER-INITIAL LETTER LASOYOMBO CLUSTER-" +
	"INITIAL LETTER SHASOYOMBO CLUSTER-INITIAL LETTER SASOYOMBO FINAL CONSONA" +
	"NT SIGN GSOYOMBO FINAL CONSONANT SIGN KSOYOMBO FINAL CONSONANT SIGN NGSO" +
	"YOMBO FINAL CONSONANT SIGN DSOYOMBO FINAL CONSONANT SIGN NSOYOMBO FINAL " +
	"CONSONANT SIGN BSOYOMBO FINAL CONSONANT SIGN MSOYOMBO FINAL CONSONANT SI" +
	"GN RSOYOMBO FINAL CONSONANT SIGN LSOYOMBO FINAL CONSONANT SIGN SHSOYOMBO" +
	" FINAL CONSONANT SIGN SSOYOMBO FINAL CONSONANT SIGN -ASOYOMBO SIGN ANUSV" +
	"ARASOYOMBO SIGN VISARGASOYOMBO GEMINATION MARKSOYOMBO SUBJOINERSOYOMBO M" +
	"ARK TSHEGSOYOMBO MARK SHADSOYOMBO MARK DOUBLE SHADSOYOMBO HEAD MARK WITH" +
	" MOON AND SUN AND TRIPLE FLAMESOYOMBO HEAD MARK WITH MOON AND SUN AND FL" +
	"AMESOYOMBO HEAD MARK WITH MOON AND SUNSOYOMBO TERMINAL MARK-1SOYOMBO TER" +
	"MINAL MARK-2PAU CIN HAU LETTER PAPAU CIN HAU LETTER KAPAU CIN HAU LETTER" +
	" LAPAU CIN HAU LETTER MAPAU CIN HAU LETTER DAPAU CIN HAU LETTER ZAPAU CI" +
	"N HAU LETTER VAPAU CIN HAU LETTER NGAPAU CIN HAU LETTER HAPAU CIN HAU LE" +
	"TTER GAPAU CIN HAU LETTER KHAPAU CIN HAU LETTER SAPAU CIN HAU LETTER BAP" +
	"AU CIN HAU LETTER CAPAU CIN HAU LETTER TAPAU CIN HAU LETTER THAPAU CIN H" +
	"AU LETTER NAPAU CIN HAU LETTER PHAPAU CIN HAU LETTER RAPAU CIN HAU LETTE" +
	"R FAPAU CIN HAU LETTER CHAPAU CIN HAU LETTER APAU CIN HAU LETTER EPAU CI" +
	"N HAU LETTER IPAU CIN HAU LETTER OPAU CIN HAU LETTER UPAU CIN HAU LETTER" +
	" UAPAU CIN HAU LETTER IAPAU CIN HAU LETTER FINAL PPAU CIN HAU LETTER FIN" +
	"AL KPAU CIN HAU LETTER FINAL TPAU CIN HAU LETTER FINAL MPAU CIN HAU LETT" +
	"ER FINAL NPAU CIN HAU LETTER FINAL LPAU CIN HAU LETTER FINAL WPAU CIN HA" +
	"U LETTER FINAL NGPAU CIN HAU LETTER FINAL YPAU CIN HAU RISING TONE LONGP" +
	"AU CIN HAU RISING TONEPAU CIN HAU SANDHI GLOTTAL STOPPAU CIN HAU RISING " +
	"TONE LONG FINALPAU CIN HAU RISING TONE FINALPAU CIN HAU SANDHI GLOTTAL S" +
	"TOP FINALPAU CIN HAU SANDHI TONE LONGPAU CIN HAU SANDHI TONEPAU CIN HAU " +
	"SANDHI TONE LONG FINALPAU CIN HAU SANDHI TONE FINALPAU CIN HAU MID-LEVEL" +
	" TONEPAU CIN HAU GLOTTAL STOP VARIANTPAU CIN HAU MID-LEVEL TONE LONG FIN" +
	"ALPAU CIN HAU MID-LEVEL TONE FINALPAU CIN HAU LOW-FALLING TONE LONGPAU C") + ("" +
	"IN HAU LOW-FALLING TONEPAU CIN HAU GLOTTAL STOPPAU CIN HAU LOW-FALLING T" +
	"ONE LONG FINALPAU CIN HAU LOW-FALLING TONE FINALPAU CIN HAU GLOTTAL STOP" +
	" FINALBHAIKSUKI LETTER ABHAIKSUKI LETTER AABHAIKSUKI LETTER IBHAIKSUKI L" +
	"ETTER IIBHAIKSUKI LETTER UBHAIKSUKI LETTER UUBHAIKSUKI LETTER VOCALIC RB" +
	"HAIKSUKI LETTER VOCALIC RRBHAIKSUKI LETTER VOCALIC LBHAIKSUKI LETTER EBH" +
	"AIKSUKI LETTER AIBHAIKSUKI LETTER OBHAIKSUKI LETTER AUBHAIKSUKI LETTER K" +
	"ABHAIKSUKI LETTER KHABHAIKSUKI LETTER GABHAIKSUKI LETTER GHABHAIKSUKI LE" +
	"TTER NGABHAIKSUKI LETTER CABHAIKSUKI LETTER CHABHAIKSUKI LETTER JABHAIKS" +
	"UKI LETTER JHABHAIKSUKI LETTER NYABHAIKSUKI LETTER TTABHAIKSUKI LETTER T" +
	"THABHAIKSUKI LETTER DDABHAIKSUKI LETTER DDHABHAIKSUKI LETTER NNABHAIKSUK" +
	"I LETTER TABHAIKSUKI LETTER THABHAIKSUKI LETTER DABHAIKSUKI LETTER DHABH" +
	"AIKSUKI LETTER NABHAIKSUKI LETTER PABHAIKSUKI LETTER PHABHAIKSUKI LETTER" +
	" BABHAIKSUKI LETTER BHABHAIKSUKI LETTER MABHAIKSUKI LETTER YABHAIKSUKI L" +
	"ETTER RABHAIKSUKI LETTER LABHAIKSUKI LETTER VABHAIKSUKI LETTER SHABHAIKS" +
	"UKI LETTER SSABHAIKSUKI LETTER SABHAIKSUKI LETTER HABHAIKSUKI VOWEL SIGN" +
	" AABHAIKSUKI VOWEL SIGN IBHAIKSUKI VOWEL SIGN IIBHAIKSUKI VOWEL SIGN UBH" +
	"AIKSUKI VOWEL SIGN UUBHAIKSUKI VOWEL SIGN VOCALIC RBHAIKSUKI VOWEL SIGN " +
	"VOCALIC RRBHAIKSUKI VOWEL SIGN VOCALIC LBHAIKSUKI VOWEL SIGN EBHAIKSUKI " +
	"VOWEL SIGN AIBHAIKSUKI VOWEL SIGN OBHAIKSUKI VOWEL SIGN AUBHAIKSUKI SIGN" +
	" CANDRABINDUBHAIKSUKI SIGN ANUSVARABHAIKSUKI SIGN VISARGABHAIKSUKI SIGN " +
	"VIRAMABHAIKSUKI SIGN AVAGRAHABHAIKSUKI DANDABHAIKSUKI DOUBLE DANDABHAIKS" +
	"UKI WORD SEPARATORBHAIKSUKI GAP FILLER-1BHAIKSUKI GAP FILLER-2BHAIKSUKI " +
	"DIGIT ZEROBHAIKSUKI DIGIT ONEBHAIKSUKI DIGIT TWOBHAIKSUKI DIGIT THREEBHA" +
	"IKSUKI DIGIT FOURBHAIKSUKI DIGIT FIVEBHAIKSUKI DIGIT SIXBHAIKSUKI DIGIT " +
	"SEVENBHAIKSUKI DIGIT EIGHTBHAIKSUKI DIGIT NINEBHAIKSUKI NUMBER ONEBHAIKS" +
	"UKI NUMBER TWOBHAIKSUKI NUMBER THREEBHAIKSUKI NUMBER FOURBHAIKSUKI NUMBE" +
	"R FIVEBHAIKSUKI NUMBER SIXBHAIKSUKI NUMBER SEVENBHAIKSUKI NUMBER EIGHTBH" +
	"AIKSUKI NUMBER NINEBHAIKSUKI NUMBER TENBHAIKSUKI NUMBER TWENTYBHAIKSUKI " +
	"NUMBER THIRTYBHAIKSUKI NUMBER FORTYBHAIKSUKI NUMBER FIFTYBHAIKSUKI NUMBE" +
	"R SIXTYBHAIKSUKI NUMBER SEVENTYBHAIKSUKI NUMBER EIGHTYBHAIKSUKI NUMBER N" +
	"INETYBHAIKSUKI HUNDREDS UNIT MARKMARCHEN HEAD MARKMARCHEN MARK SHADMARCH" +
	"EN LETTER KAMARCHEN LETTER KHAMARCHEN LETTER GAMARCHEN LETTER NGAMARCHEN" +
	" LETTER CAMARCHEN LETTER CHAMARCHEN LETTER JAMARCHEN LETTER NYAMARCHEN L" +
	"ETTER TAMARCHEN LETTER THAMARCHEN LETTER DAMARCHEN LETTER NAMARCHEN LETT" +
	"ER PAMARCHEN LETTER PHAMARCHEN LETTER BAMARCHEN LETTER MAMARCHEN LETTER " +
	"TSAMARCHEN LETTER TSHAMARCHEN LETTER DZAMARCHEN LETTER WAMARCHEN LETTER " +
	"ZHAMARCHEN LETTER ZAMARCHEN LETTER -AMARCHEN LETTER YAMARCHEN LETTER RAM" +
	"ARCHEN LETTER LAMARCHEN LETTER SHAMARCHEN LETTER SAMARCHEN LETTER HAMARC" +
	"HEN LETTER AMARCHEN SUBJOINED LETTER KAMARCHEN SUBJOINED LETTER KHAMARCH" +
	"EN SUBJOINED LETTER GAMARCHEN SUBJOINED LETTER NGAMARCHEN SUBJOINED LETT" +
	"ER CAMARCHEN SUBJOINED LETTER CHAMARCHEN SUBJOINED LETTER JAMARCHEN SUBJ" +
	"OINED LETTER NYAMARCHEN SUBJOINED LETTER TAMARCHEN SUBJOINED LETTER THAM" +
	"ARCHEN SUBJOINED LETTER DAMARCHEN SUBJOINED LETTER NAMARCHEN SUBJOINED L" +
	"ETTER PAMARCHEN SUBJOINED LETTER PHAMARCHEN SUBJOINED LETTER BAMARCHEN S" +
	"UBJOINED LETTER MAMARCHEN SUBJOINED LETTER TSAMARCHEN SUBJOINED LETTER T" +
	"SHAMARCHEN SUBJOINED LETTER DZAMARCHEN SUBJOINED LETTER WAMARCHEN SUBJOI" +
	"NED LETTER ZHAMARCHEN SUBJOINED LETTER ZAMARCHEN SUBJOINED LETTER YAMARC" +
	"HEN SUBJOINED LETTER RAMARCHEN SUBJOINED LETTER LAMARCHEN SUBJOINED LETT" +
	"ER SHAMARCHEN SUBJOINED LETTER SAMARCHEN SUBJOINED LETTER HAMARCHEN SUBJ" +
	"OINED LETTER AMARCHEN VOWEL SIGN AAMARCHEN VOWEL SIGN IMARCHEN VOWEL SIG" +
	"N UMARCHEN VOWEL SIGN EMARCHEN VOWEL SIGN OMARCHEN SIGN ANUSVARAMARCHEN " +
	"SIGN CANDRABINDUMASARAM GONDI LETTER AMASARAM GONDI LETTER AAMASARAM GON" +
	"DI LETTER IMASARAM GONDI LETTER IIMASARAM GONDI LETTER UMASARAM GONDI LE" +
	"TTER UUMASARAM GONDI LETTER EMASARAM GONDI LETTER AIMASARAM GONDI LETTER" +
	" OMASARAM GONDI LETTER AUMASARAM GONDI LETTER KAMASARAM GONDI LETTER KHA" +
	"MASARAM GONDI LETTER GAMASARAM GONDI LETTER GHAMASARAM GONDI LETTER NGAM" +
	"ASARAM GONDI LETTER CAMASARAM GONDI LETTER CHAMASARAM GONDI LETTER JAMAS" +
	"ARAM GONDI LETTER JHAMASARAM GONDI LETTER NYAMASARAM GONDI LETTER TTAMAS" +
	"ARAM GONDI LETTER TTHAMASARAM GONDI LETTER DDAMASARAM GONDI LETTER DDHAM" +
	"ASARAM GONDI LETTER NNAMASARAM GONDI LETTER TAMASARAM GONDI LETTER THAMA" +
	"SARAM GONDI LETTER DAMASARAM GONDI LETTER DHAMASARAM GONDI LETTER NAMASA" +
	"RAM GONDI LETTER PAMASARAM GONDI LETTER PHAMASARAM GONDI LETTER BAMASARA" +
	"M GONDI LETTER BHAMASARAM GONDI LETTER MAMASARAM GONDI LETTER YAMASARAM " +
	"GONDI LETTER RAMASARAM GONDI LETTER LAMASARAM GONDI LETTER VAMASARAM GON") + ("" +
	"DI LETTER SHAMASARAM GONDI LETTER SSAMASARAM GONDI LETTER SAMASARAM GOND" +
	"I LETTER HAMASARAM GONDI LETTER LLAMASARAM GONDI LETTER KSSAMASARAM GOND" +
	"I LETTER JNYAMASARAM GONDI LETTER TRAMASARAM GONDI VOWEL SIGN AAMASARAM " +
	"GONDI VOWEL SIGN IMASARAM GONDI VOWEL SIGN IIMASARAM GONDI VOWEL SIGN UM" +
	"ASARAM GONDI VOWEL SIGN UUMASARAM GONDI VOWEL SIGN VOCALIC RMASARAM GOND" +
	"I VOWEL SIGN EMASARAM GONDI VOWEL SIGN AIMASARAM GONDI VOWEL SIGN OMASAR" +
	"AM GONDI VOWEL SIGN AUMASARAM GONDI SIGN ANUSVARAMASARAM GONDI SIGN VISA" +
	"RGAMASARAM GONDI SIGN NUKTAMASARAM GONDI SIGN CANDRAMASARAM GONDI SIGN H" +
	"ALANTAMASARAM GONDI VIRAMAMASARAM GONDI REPHAMASARAM GONDI RA-KARAMASARA" +
	"M GONDI DIGIT ZEROMASARAM GONDI DIGIT ONEMASARAM GONDI DIGIT TWOMASARAM " +
	"GONDI DIGIT THREEMASARAM GONDI DIGIT FOURMASARAM GONDI DIGIT FIVEMASARAM" +
	" GONDI DIGIT SIXMASARAM GONDI DIGIT SEVENMASARAM GONDI DIGIT EIGHTMASARA" +
	"M GONDI DIGIT NINECUNEIFORM SIGN ACUNEIFORM SIGN A TIMES ACUNEIFORM SIGN" +
	" A TIMES BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEIFORM SIGN A TIMES HACUN" +
	"EIFORM SIGN A TIMES IGICUNEIFORM SIGN A TIMES LAGAR GUNUCUNEIFORM SIGN A" +
	" TIMES MUSHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SIGN A2CUNEIFORM SIGN ABC" +
	"UNEIFORM SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIMES DUN3 GUNUCUNEIFORM SI" +
	"GN AB TIMES GALCUNEIFORM SIGN AB TIMES GAN2 TENUCUNEIFORM SIGN AB TIMES " +
	"HACUNEIFORM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN AB TIMES IMINCUNEIFORM " +
	"SIGN AB TIMES LAGABCUNEIFORM SIGN AB TIMES SHESHCUNEIFORM SIGN AB TIMES " +
	"U PLUS U PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SIGN AB2CUNEIFORM SIGN AB" +
	"2 TIMES BALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCUNEIFORM SIGN AB2 TIMES " +
	"ME PLUS ENCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM SIGN AB2 TIMES TAK4CUNE" +
	"IFORM SIGN ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK TIMES ERIN2CUNEIFORM SIG" +
	"N AK TIMES SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIFORM SIGN AL TIMES ALCUN" +
	"EIFORM SIGN AL TIMES DIM2CUNEIFORM SIGN AL TIMES GISHCUNEIFORM SIGN AL T" +
	"IMES HACUNEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN AL TIMES KICUNEIFORM S" +
	"IGN AL TIMES SHECUNEIFORM SIGN AL TIMES USHCUNEIFORM SIGN ALANCUNEIFORM " +
	"SIGN ALEPHCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR TIMES SHECUNEIFORM SIGN" +
	" ANCUNEIFORM SIGN AN OVER ANCUNEIFORM SIGN AN THREE TIMESCUNEIFORM SIGN " +
	"AN PLUS NAGA OPPOSING AN PLUS NAGACUNEIFORM SIGN AN PLUS NAGA SQUAREDCUN" +
	"EIFORM SIGN ANSHECUNEIFORM SIGN APINCUNEIFORM SIGN ARADCUNEIFORM SIGN AR" +
	"AD TIMES KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN ASAL2CUNEIFORM SIGN ASHCU" +
	"NEIFORM SIGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA TENUCUNEIFORM SIGN ASH" +
	" OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIFORM SIGN ASH OVER ASH O" +
	"VER ASHCUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER A" +
	"SHCUNEIFORM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFORM SIGN BACUNEIFORM SIG" +
	"N BADCUNEIFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNEIFORM SIGN BALCUNEIFORM" +
	" SIGN BAL OVER BALCUNEIFORM SIGN BALAGCUNEIFORM SIGN BARCUNEIFORM SIGN B" +
	"ARA2CUNEIFORM SIGN BICUNEIFORM SIGN BI TIMES ACUNEIFORM SIGN BI TIMES GA" +
	"RCUNEIFORM SIGN BI TIMES IGI GUNUCUNEIFORM SIGN BUCUNEIFORM SIGN BU OVER" +
	" BU ABCUNEIFORM SIGN BU OVER BU UNCUNEIFORM SIGN BU CROSSING BUCUNEIFORM" +
	" SIGN BULUGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFORM SIGN BURCUNEIFORM SI" +
	"GN BUR2CUNEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFORM SIGN DAG KISIM5 TIME" +
	"S A PLUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMARCUNEIFORM SIGN DAG KISI" +
	"M5 TIMES BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BICUNEIFORM SIGN DAG KISIM" +
	"5 TIMES GACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASHCUNEIFORM SIGN DAG" +
	" KISIM5 TIMES GICUNEIFORM SIGN DAG KISIM5 TIMES GIR2CUNEIFORM SIGN DAG K" +
	"ISIM5 TIMES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HACUNEIFORM SIGN DAG KISI" +
	"M5 TIMES IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LUCUNEIFORM SIGN DAG " +
	"KISIM5 TIMES KAKCUNEIFORM SIGN DAG KISIM5 TIMES LACUNEIFORM SIGN DAG KIS" +
	"IM5 TIMES LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2CUNEIFORM SIGN " +
	"DAG KISIM5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIMES NECUNEIFORM SIGN DAG" +
	" KISIM5 TIMES PAP PLUS PAPCUNEIFORM SIGN DAG KISIM5 TIMES SICUNEIFORM SI" +
	"GN DAG KISIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2CUNE" +
	"IFORM SIGN DAG KISIM5 TIMES USHCUNEIFORM SIGN DAMCUNEIFORM SIGN DARCUNEI" +
	"FORM SIGN DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN DICUNEIFORM SIGN DIBCU" +
	"NEIFORM SIGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEIFORM SIGN DIM2CUNEIFORM" +
	" SIGN DINCUNEIFORM SIGN DIN KASKAL U GUNU DISHCUNEIFORM SIGN DISHCUNEIFO" +
	"RM SIGN DUCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN DU GUNUCUNEIFORM SIGN " +
	"DU SHESHIGCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TIMES ESH2CUNEIFORM SIGN " +
	"DUB2CUNEIFORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFORM SIGN DUHCUNEIFORM SI" +
	"GN DUNCUNEIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNUCUNEIFORM SIGN DUN3 GUN" +
	"U GUNUCUNEIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEIFORM SIGN ECUNEIFORM SI") + ("" +
	"GN E TIMES PAPCUNEIFORM SIGN E OVER E NUN OVER NUNCUNEIFORM SIGN E2CUNEI" +
	"FORM SIGN E2 TIMES A PLUS HA PLUS DACUNEIFORM SIGN E2 TIMES GARCUNEIFORM" +
	" SIGN E2 TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEIFORM SIGN E2 TIMES SHEC" +
	"UNEIFORM SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIFORM SIGN EGIRCUNEIFORM " +
	"SIGN ELCUNEIFORM SIGN ENCUNEIFORM SIGN EN TIMES GAN2CUNEIFORM SIGN EN TI" +
	"MES GAN2 TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM SIGN EN CROSSING ENCUNE" +
	"IFORM SIGN EN OPPOSING ENCUNEIFORM SIGN EN SQUAREDCUNEIFORM SIGN ERENCUN" +
	"EIFORM SIGN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIGN EZENCUNEIFORM SIGN EZ" +
	"EN TIMES ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUNEIFORM SIGN EZEN TIMES " +
	"A PLUS LAL TIMES LALCUNEIFORM SIGN EZEN TIMES ANCUNEIFORM SIGN EZEN TIME" +
	"S BADCUNEIFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM SIGN EZEN TIMES DUN3 G" +
	"UNU GUNUCUNEIFORM SIGN EZEN TIMES HACUNEIFORM SIGN EZEN TIMES HA GUNUCUN" +
	"EIFORM SIGN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZEN TIMES KASKALCUNEIFORM" +
	" SIGN EZEN TIMES KASKAL SQUAREDCUNEIFORM SIGN EZEN TIMES KU3CUNEIFORM SI" +
	"GN EZEN TIMES LACUNEIFORM SIGN EZEN TIMES LAL TIMES LALCUNEIFORM SIGN EZ" +
	"EN TIMES LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM SIGN EZEN TIMES U2CUNEI" +
	"FORM SIGN EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM SIGN GA GUNUCUNEIFORM " +
	"SIGN GA2CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HACUNEIFORM SIGN GA2 TIM" +
	"ES A PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS IGICUNEIFORM SIGN GA2 TIMES " +
	"AB2 TENU PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEIFORM SIGN GA2 TIMES ASH" +
	"CUNEIFORM SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM SIGN GA2 TIMES BADCUNEIF" +
	"ORM SIGN GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 TIMES BURCUNEIFORM SIGN" +
	" GA2 TIMES BUR PLUS RACUNEIFORM SIGN GA2 TIMES DACUNEIFORM SIGN GA2 TIME" +
	"S DICUNEIFORM SIGN GA2 TIMES DIM TIMES SHECUNEIFORM SIGN GA2 TIMES DUBCU" +
	"NEIFORM SIGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES EL PLUS LACUNEIFORM SI" +
	"GN GA2 TIMES ENCUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENUCUNEIFORM SIGN" +
	" GA2 TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARCUNEIFORM SIGN GA2 TIMES" +
	" GICUNEIFORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2 TIMES GI4 PLUS ACUNEIF" +
	"ORM SIGN GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS " +
	"ESH2CUNEIFORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA2 TIMES HAL PLUS LACUNE" +
	"IFORM SIGN GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2 TIMES HUB2CUNEIFORM SI" +
	"GN GA2 TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASHCUNEIF" +
	"ORM SIGN GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KASKALCUNEIFORM SIGN GA2 " +
	"TIMES KIDCUNEIFORM SIGN GA2 TIMES KID PLUS LALCUNEIFORM SIGN GA2 TIMES K" +
	"U3 PLUS ANCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SIGN GA2 TIMES ME PLUS EN" +
	"CUNEIFORM SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIMES NUNCUNEIFORM SIGN GA" +
	"2 TIMES NUN OVER NUNCUNEIFORM SIGN GA2 TIMES PACUNEIFORM SIGN GA2 TIMES " +
	"SALCUNEIFORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2 TIMES SHECUNEIFORM SIG" +
	"N GA2 TIMES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES SHIDCUNEIFORM SIGN GA2 " +
	"TIMES SUMCUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM SIGN GA2 TIMES UCUNEIFOR" +
	"M SIGN GA2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PLUS DUCUNEIFORM SIGN GA2" +
	" OVER GA2CUNEIFORM SIGN GABACUNEIFORM SIGN GABA CROSSING GABACUNEIFORM S" +
	"IGN GADCUNEIFORM SIGN GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALCUNEIFO" +
	"RM SIGN GAL GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALAMCUNEIFORM SIGN " +
	"GAMCUNEIFORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM SIGN GAN2 TENUCUNEIFOR" +
	"M SIGN GAN2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING GAN2CUNEIFORM SIGN GAR" +
	"CUNEIFORM SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM SIGN GESHTINCUNEIFORM " +
	"SIGN GESHTIN TIMES KURCUNEIFORM SIGN GICUNEIFORM SIGN GI TIMES ECUNEIFOR" +
	"M SIGN GI TIMES UCUNEIFORM SIGN GI CROSSING GICUNEIFORM SIGN GI4CUNEIFOR" +
	"M SIGN GI4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI4CUNEIFORM SIGN GIDIMCU" +
	"NEIFORM SIGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFORM SIGN GIR3CUNEIFORM SI" +
	"GN GIR3 TIMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES GAN2 TENUCUNEIFORM SIG" +
	"N GIR3 TIMES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS IGICUNEIFORM SIGN GIR3" +
	" TIMES PACUNEIFORM SIGN GISALCUNEIFORM SIGN GISHCUNEIFORM SIGN GISH CROS" +
	"SING GISHCUNEIFORM SIGN GISH TIMES BADCUNEIFORM SIGN GISH TIMES TAK4CUNE" +
	"IFORM SIGN GISH TENUCUNEIFORM SIGN GUCUNEIFORM SIGN GU CROSSING GUCUNEIF" +
	"ORM SIGN GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM SIGN GU2 TIMES KAK TIM" +
	"ES IGI GUNUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM SIGN GU2 TIMES SAL PLUS" +
	" TUG2CUNEIFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUNEIFORM SIGN GUD TIMES A" +
	" PLUS KURCUNEIFORM SIGN GUD TIMES KURCUNEIFORM SIGN GUD OVER GUD LUGALCU" +
	"NEIFORM SIGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN GUM TIMES SHECUNEIFORM " +
	"SIGN GURCUNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCUNEIFORM SIGN GURUSHCUNE" +
	"IFORM SIGN HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN HA GUNUCUNEIFORM SIGN " +
	"HALCUNEIFORM SIGN HICUNEIFORM SIGN HI TIMES ASHCUNEIFORM SIGN HI TIMES A") + ("" +
	"SH2CUNEIFORM SIGN HI TIMES BADCUNEIFORM SIGN HI TIMES DISHCUNEIFORM SIGN" +
	" HI TIMES GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM SIGN HI TIMES NUNCUNEI" +
	"FORM SIGN HI TIMES SHECUNEIFORM SIGN HI TIMES UCUNEIFORM SIGN HUCUNEIFOR" +
	"M SIGN HUB2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM SIGN HUB2 TIMES HALCUNE" +
	"IFORM SIGN HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 TIMES LISHCUNEIFORM SIGN" +
	" HUB2 TIMES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN ICUNEIFORM SIGN I ACUNEI" +
	"FORM SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDIM OVER IDIM BURCUNEIFOR" +
	"M SIGN IDIM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUNEIFORM SIGN IGICUNEIFOR" +
	"M SIGN IGI DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN IGI OVER IGI SHIR OVER" +
	" SHIR UD OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM SIGN ILCUNEIFORM SIGN I" +
	"L TIMES GAN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN IMCUNEIFORM SIGN IM TI" +
	"MES TAK4CUNEIFORM SIGN IM CROSSING IMCUNEIFORM SIGN IM OPPOSING IMCUNEIF" +
	"ORM SIGN IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM SIGN INCUNEIFORM SIGN IR" +
	"CUNEIFORM SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN KA TIMES ACUNEIFORM SI" +
	"GN KA TIMES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3CUNEIFORM SIGN KA TIMES" +
	" ASH2CUNEIFORM SIGN KA TIMES BADCUNEIFORM SIGN KA TIMES BALAGCUNEIFORM S" +
	"IGN KA TIMES BARCUNEIFORM SIGN KA TIMES BICUNEIFORM SIGN KA TIMES ERIN2C" +
	"UNEIFORM SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIMES GACUNEIFORM SIGN KA T" +
	"IMES GALCUNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFORM SIGN KA TIMES GARCUNE" +
	"IFORM SIGN KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM SIGN KA TIMES GICUNEIF" +
	"ORM SIGN KA TIMES GIR2CUNEIFORM SIGN KA TIMES GISH PLUS SARCUNEIFORM SIG" +
	"N KA TIMES GISH CROSSING GISHCUNEIFORM SIGN KA TIMES GUCUNEIFORM SIGN KA" +
	" TIMES GUR7CUNEIFORM SIGN KA TIMES IGICUNEIFORM SIGN KA TIMES IMCUNEIFOR" +
	"M SIGN KA TIMES KAKCUNEIFORM SIGN KA TIMES KICUNEIFORM SIGN KA TIMES KID" +
	"CUNEIFORM SIGN KA TIMES LICUNEIFORM SIGN KA TIMES LUCUNEIFORM SIGN KA TI" +
	"MES MECUNEIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM SIGN KA TIMES ME PLUS " +
	"GICUNEIFORM SIGN KA TIMES ME PLUS TECUNEIFORM SIGN KA TIMES MICUNEIFORM " +
	"SIGN KA TIMES MI PLUS NUNUZCUNEIFORM SIGN KA TIMES NECUNEIFORM SIGN KA T" +
	"IMES NUNCUNEIFORM SIGN KA TIMES PICUNEIFORM SIGN KA TIMES RUCUNEIFORM SI" +
	"GN KA TIMES SACUNEIFORM SIGN KA TIMES SARCUNEIFORM SIGN KA TIMES SHACUNE" +
	"IFORM SIGN KA TIMES SHECUNEIFORM SIGN KA TIMES SHIDCUNEIFORM SIGN KA TIM" +
	"ES SHUCUNEIFORM SIGN KA TIMES SIGCUNEIFORM SIGN KA TIMES SUHURCUNEIFORM " +
	"SIGN KA TIMES TARCUNEIFORM SIGN KA TIMES UCUNEIFORM SIGN KA TIMES U2CUNE" +
	"IFORM SIGN KA TIMES UDCUNEIFORM SIGN KA TIMES UMUM TIMES PACUNEIFORM SIG" +
	"N KA TIMES USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM SIGN KA2CUNEIFORM SIGN" +
	" KA2 CROSSING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN KAD2CUNEIFORM SIGN KAD" +
	"3CUNEIFORM SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM SIGN KAD5 OVER KAD5CUNE" +
	"IFORM SIGN KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCUNEIFORM SIGN KALCUNEIFO" +
	"RM SIGN KAL TIMES BADCUNEIFORM SIGN KAL CROSSING KALCUNEIFORM SIGN KAM2C" +
	"UNEIFORM SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM SIGN KASKAL LAGAB TIMES" +
	" U OVER LAGAB TIMES UCUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVE" +
	"R LAGAB TIMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN KICUNEIFORM SIGN KI TI" +
	"MES BADCUNEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI TIMES UDCUNEIFORM SIGN" +
	" KIDCUNEIFORM SIGN KINCUNEIFORM SIGN KISALCUNEIFORM SIGN KISHCUNEIFORM S" +
	"IGN KISIM5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIFORM SIGN KUCUNEIFORM SI" +
	"GN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2CUNEIFORM SIGN KU3CUNEIFOR" +
	"M SIGN KU4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFORM SIGN KU7CUNEIFORM SIG" +
	"N KULCUNEIFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUNEIFORM SIGN KURCUNEIFOR" +
	"M SIGN KUR OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEIFORM SIGN KWU318CUNEIFO" +
	"RM SIGN LACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGAB TIMES ACUNEIFORM SIGN" +
	" LAGAB TIMES A PLUS DA PLUS HACUNEIFORM SIGN LAGAB TIMES A PLUS GARCUNEI" +
	"FORM SIGN LAGAB TIMES A PLUS LALCUNEIFORM SIGN LAGAB TIMES ALCUNEIFORM S" +
	"IGN LAGAB TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENUCUNEIFORM SIGN" +
	" LAGAB TIMES BADCUNEIFORM SIGN LAGAB TIMES BICUNEIFORM SIGN LAGAB TIMES " +
	"DARCUNEIFORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LAGAB TIMES GACUNEIFORM S" +
	"IGN LAGAB TIMES GARCUNEIFORM SIGN LAGAB TIMES GUDCUNEIFORM SIGN LAGAB TI" +
	"MES GUD PLUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNEIFORM SIGN LAGAB TIMES " +
	"HALCUNEIFORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFORM SIGN LAGAB TIMES IGI" +
	" GUNUCUNEIFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN LAGAB TIMES IM PLUS HAC" +
	"UNEIFORM SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIGN LAGAB TIMES KICUNEIFO" +
	"RM SIGN LAGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES KU3CUNEIFORM SIGN LAGA" +
	"B TIMES KULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS ACUNEIFORM SIGN L" +
	"AGAB TIMES LAGABCUNEIFORM SIGN LAGAB TIMES LISHCUNEIFORM SIGN LAGAB TIME" +
	"S LUCUNEIFORM SIGN LAGAB TIMES LULCUNEIFORM SIGN LAGAB TIMES MECUNEIFORM") + ("" +
	" SIGN LAGAB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB TIMES MUSHCUNEIFORM SIG" +
	"N LAGAB TIMES NECUNEIFORM SIGN LAGAB TIMES SHE PLUS SUMCUNEIFORM SIGN LA" +
	"GAB TIMES SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIGN LAGAB TIMES SHITA PLU" +
	"S GISH TENUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFORM SIGN LAGAB TIMES SHU" +
	"2 PLUS SHU2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFORM SIGN LAGAB TIMES TAGC" +
	"UNEIFORM SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS " +
	"SU PLUS NACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM SIGN LAGAB TIMES U PLUS " +
	"ACUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS UCUNEIFORM SIGN LAGAB TIMES U2" +
	" PLUS ASHCUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM SIGN LAGAB TIMES USHCUNE" +
	"IFORM SIGN LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEIFORM SIGN LAGAR TIMES S" +
	"HECUNEIFORM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAR GUNUCUNEIF" +
	"ORM SIGN LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM SIGN LAHSHUCUNEIFORM SI" +
	"GN LALCUNEIFORM SIGN LAL TIMES LALCUNEIFORM SIGN LAMCUNEIFORM SIGN LAM T" +
	"IMES KURCUNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEIFORM SIGN LICUNEIFORM S" +
	"IGN LILCUNEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCUNEIFORM SIGN LUCUNEIFOR" +
	"M SIGN LU TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SIGN LU2 TIMES ALCUNEIFOR" +
	"M SIGN LU2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2CUNEIFORM SIGN LU2 TIME" +
	"S ESH2 TENUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNEIFORM SIGN LU2 TIMES HI" +
	" TIMES BADCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SIGN LU2 TIMES KAD2CUNEIF" +
	"ORM SIGN LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASHCUNEIFORM S" +
	"IGN LU2 TIMES KICUNEIFORM SIGN LU2 TIMES LA PLUS ASHCUNEIFORM SIGN LU2 T" +
	"IMES LAGABCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNEIFORM SIGN LU2 TIMES NE" +
	"CUNEIFORM SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIMES SI PLUS ASHCUNEIFORM" +
	" SIGN LU2 TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TIMES TUG2CUNEIFORM SIGN " +
	"LU2 TENUCUNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM SIGN LU2 OPPOSING LU2CU" +
	"NEIFORM SIGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHIGCUNEIFORM SIGN LU3CUNE" +
	"IFORM SIGN LUGALCUNEIFORM SIGN LUGAL OVER LUGALCUNEIFORM SIGN LUGAL OPPO" +
	"SING LUGALCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM SIGN LUHCUNEIFORM SIGN L" +
	"ULCUNEIFORM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCUNEIFORM SIGN LUM OVER L" +
	"UM GAR OVER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA TIMES TAK4CUNEIFORM SI" +
	"GN MA GUNUCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUNEIFORM SIGN MARCUNEIFOR" +
	"M SIGN MASHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MECUNEIFORM SIGN MESCUNEIF" +
	"ORM SIGN MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUNEIFORM SIGN MU OVER MUC" +
	"UNEIFORM SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM SIGN MUNSUBCUNEIFORM S" +
	"IGN MURGU2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH TIMES ACUNEIFORM SIGN M" +
	"USH TIMES KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFORM SIGN MUSH OVER MUSHCU" +
	"NEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NACUNEIFORM SIGN MUSH CROSSING " +
	"MUSHCUNEIFORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIMES ACUNEIFORM SIGN MUSH3" +
	" TIMES A PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNEIFORM SIGN MUSH3 GUNUCU" +
	"NEIFORM SIGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN NAGACUNEIFORM SIGN NAGA " +
	"INVERTEDCUNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFORM SIGN NAGA OPPOSING N" +
	"AGACUNEIFORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLUCUNEIFORM SIGN NAMCUNEI" +
	"FORM SIGN NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE TIMES ACUNEIFORM SIGN N" +
	"E TIMES UDCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN NICUNEIFORM SIGN NI TI" +
	"MES ECUNEIFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFORM SIGN NIM TIMES GAN2 T" +
	"ENUCUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUNEIFORM SIGN NINDA2CUNEI" +
	"FORM SIGN NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TIMES ASHCUNEIFORM SIGN N" +
	"INDA2 TIMES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES GUDCUNEIFORM SIGN NI" +
	"NDA2 TIMES ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2 TIMES NECUNEIFORM SIGN" +
	" NINDA2 TIMES NUNCUNEIFORM SIGN NINDA2 TIMES SHECUNEIFORM SIGN NINDA2 TI" +
	"MES SHE PLUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASHCUNEIFORM SIGN " +
	"NINDA2 TIMES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES U2 PLUS AS" +
	"HCUNEIFORM SIGN NINDA2 TIMES USHCUNEIFORM SIGN NISAGCUNEIFORM SIGN NUCUN" +
	"EIFORM SIGN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN NUN LAGAR TIMES GARCUNE" +
	"IFORM SIGN NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN LAGAR TIMES SALCUNEIFO" +
	"RM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SALCUNEIFORM SIGN NUN L" +
	"AGAR TIMES USHCUNEIFORM SIGN NUN TENUCUNEIFORM SIGN NUN OVER NUNCUNEIFOR" +
	"M SIGN NUN CROSSING NUNCUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGARC" +
	"UNEIFORM SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES ASHGABCUNEIFORM SIGN N" +
	"UNUZ AB2 TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES DUGCUNEIFORM SIGN NUNUZ " +
	"AB2 TIMES GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNUCUNEIFORM SIGN NUNUZ" +
	" AB2 TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LACUNEIFORM SIGN NUNUZ AB2" +
	" TIMES NECUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNEIFORM SIGN NUNUZ AB2 TI" +
	"MES U2CUNEIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFORM SIGN NUNUZ KISIM5 TI") + ("" +
	"MES BI UCUNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIFORM SIGN PANCUNEIFORM S" +
	"IGN PAPCUNEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEIFORM SIGN PI TIMES ACUN" +
	"EIFORM SIGN PI TIMES ABCUNEIFORM SIGN PI TIMES BICUNEIFORM SIGN PI TIMES" +
	" BUCUNEIFORM SIGN PI TIMES ECUNEIFORM SIGN PI TIMES ICUNEIFORM SIGN PI T" +
	"IMES IBCUNEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI TIMES U2CUNEIFORM SIGN" +
	" PI CROSSING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN PIRIG TIMES KALCUNEIFO" +
	"RM SIGN PIRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES ZACUNEIFORM SIGN PIRIG " +
	"OPPOSING PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RABCUNEIFORM SIGN RICUNEIF" +
	"ORM SIGN RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NUTILLUCUNEIFORM SIGN SAG" +
	"CUNEIFORM SIGN SAG TIMES ACUNEIFORM SIGN SAG TIMES DUCUNEIFORM SIGN SAG " +
	"TIMES DUBCUNEIFORM SIGN SAG TIMES HACUNEIFORM SIGN SAG TIMES KAKCUNEIFOR" +
	"M SIGN SAG TIMES KURCUNEIFORM SIGN SAG TIMES LUMCUNEIFORM SIGN SAG TIMES" +
	" MICUNEIFORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG TIMES SALCUNEIFORM SIG" +
	"N SAG TIMES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEIFORM SIGN SAG TIMES U2C" +
	"UNEIFORM SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIMES UMCUNEIFORM SIGN SAG " +
	"TIMES URCUNEIFORM SIGN SAG TIMES USHCUNEIFORM SIGN SAG OVER SAGCUNEIFORM" +
	" SIGN SAG GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SAL LAGAB TIMES ASH2CUNEI" +
	"FORM SIGN SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN SHACUNEIFORM SIGN SHA3C" +
	"UNEIFORM SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIMES BADCUNEIFORM SIGN SH" +
	"A3 TIMES GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFORM SIGN SHA3 TIMES SHU2C" +
	"UNEIFORM SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 TIMES UCUNEIFORM SIGN SH" +
	"A3 TIMES U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIGN SHAB6CUNEIFORM SIGN S" +
	"HAR2CUNEIFORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIFORM SIGN SHE OVER SHE G" +
	"AD OVER GAD GAR OVER GARCUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVE" +
	"R GARCUNEIFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEIFORM SIGN SHESHCUNEIFOR" +
	"M SIGN SHESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIGN SHIDCUNEIFORM SIGN SH" +
	"ID TIMES ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM SIGN SHIMCUNEIFORM SIGN " +
	"SHIM TIMES ACUNEIFORM SIGN SHIM TIMES BALCUNEIFORM SIGN SHIM TIMES BULUG" +
	"CUNEIFORM SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM TIMES GARCUNEIFORM SIGN" +
	" SHIM TIMES IGICUNEIFORM SIGN SHIM TIMES IGI GUNUCUNEIFORM SIGN SHIM TIM" +
	"ES KUSHU2CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM SIGN SHIM TIMES MUGCUNEI" +
	"FORM SIGN SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNEIFORM SIGN SHIRCUNEIFOR" +
	"M SIGN SHIR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR OVER BURCUNEIFORM SIGN" +
	" SHITACUNEIFORM SIGN SHUCUNEIFORM SIGN SHU OVER INVERTED SHUCUNEIFORM SI" +
	"GN SHU2CUNEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNEIFORM SIGN SI GUNUCUNEI" +
	"FORM SIGN SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SIG4 OVER SIG4 SHU2CUNEIF" +
	"ORM SIGN SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN SUCUNEIFORM SIGN SU OVER" +
	" SUCUNEIFORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM SIGN SUHURCUNEIFORM SI" +
	"GN SUMCUNEIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNEIFORM SIGN SUR9CUNEIFOR" +
	"M SIGN TACUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN TA TIMES HICUNEIFORM S" +
	"IGN TA TIMES MICUNEIFORM SIGN TA GUNUCUNEIFORM SIGN TABCUNEIFORM SIGN TA" +
	"B OVER TAB NI OVER NI DISH OVER DISHCUNEIFORM SIGN TAB SQUAREDCUNEIFORM " +
	"SIGN TAGCUNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN TAG TIMES GUDCUNEIFORM" +
	" SIGN TAG TIMES SHECUNEIFORM SIGN TAG TIMES SHUCUNEIFORM SIGN TAG TIMES " +
	"TUG2CUNEIFORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK4CUNEIFORM SIGN TARCUNE" +
	"IFORM SIGN TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN TICUNEIFORM SIGN TI TE" +
	"NUCUNEIFORM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM SIGN TIR TIMES TAK4CUNEI" +
	"FORM SIGN TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER " +
	"GARCUNEIFORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM SIGN TUKCUNEIFORM SIGN " +
	"TUMCUNEIFORM SIGN TURCUNEIFORM SIGN TUR OVER TUR ZA OVER ZACUNEIFORM SIG" +
	"N UCUNEIFORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIFORM SIGN U OVER U PA OV" +
	"ER PA GAR OVER GARCUNEIFORM SIGN U OVER U SUR OVER SURCUNEIFORM SIGN U O" +
	"VER U U REVERSED OVER U REVERSEDCUNEIFORM SIGN U2CUNEIFORM SIGN UBCUNEIF" +
	"ORM SIGN UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN UD TIMES BADCUNEIFORM " +
	"SIGN UD TIMES MICUNEIFORM SIGN UD TIMES U PLUS U PLUS UCUNEIFORM SIGN UD" +
	" TIMES U PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNUCUNEIFORM SIGN UD SHESH" +
	"IGCUNEIFORM SIGN UD SHESHIG TIMES BADCUNEIFORM SIGN UDUGCUNEIFORM SIGN U" +
	"MCUNEIFORM SIGN UM TIMES LAGABCUNEIFORM SIGN UM TIMES ME PLUS DACUNEIFOR" +
	"M SIGN UM TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNEIFORM SIGN UMBINCUNEIFO" +
	"RM SIGN UMUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEIFORM SIGN UMUM TIMES PA" +
	"CUNEIFORM SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM SIGN URCUNEIFORM SIGN U" +
	"R CROSSING URCUNEIFORM SIGN UR SHESHIGCUNEIFORM SIGN UR2CUNEIFORM SIGN U" +
	"R2 TIMES A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS NACUNEIFORM SIGN UR2 T" +
	"IMES ALCUNEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN UR2 TIMES NUNCUNEIFORM ") + ("" +
	"SIGN UR2 TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS ASHCUNEIFORM SIGN UR2 " +
	"TIMES U2 PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN URICUNEIFORM SIGN URI3C" +
	"UNEIFORM SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIFORM SIGN URU TIMES ASHG" +
	"ABCUNEIFORM SIGN URU TIMES BARCUNEIFORM SIGN URU TIMES DUNCUNEIFORM SIGN" +
	" URU TIMES GACUNEIFORM SIGN URU TIMES GALCUNEIFORM SIGN URU TIMES GAN2 T" +
	"ENUCUNEIFORM SIGN URU TIMES GARCUNEIFORM SIGN URU TIMES GUCUNEIFORM SIGN" +
	" URU TIMES HACUNEIFORM SIGN URU TIMES IGICUNEIFORM SIGN URU TIMES IMCUNE" +
	"IFORM SIGN URU TIMES ISHCUNEIFORM SIGN URU TIMES KICUNEIFORM SIGN URU TI" +
	"MES LUMCUNEIFORM SIGN URU TIMES MINCUNEIFORM SIGN URU TIMES PACUNEIFORM " +
	"SIGN URU TIMES SHECUNEIFORM SIGN URU TIMES SIG4CUNEIFORM SIGN URU TIMES " +
	"TUCUNEIFORM SIGN URU TIMES U PLUS GUDCUNEIFORM SIGN URU TIMES UDCUNEIFOR" +
	"M SIGN URU TIMES URUDACUNEIFORM SIGN URUDACUNEIFORM SIGN URUDA TIMES UCU" +
	"NEIFORM SIGN USHCUNEIFORM SIGN USH TIMES ACUNEIFORM SIGN USH TIMES KUCUN" +
	"EIFORM SIGN USH TIMES KURCUNEIFORM SIGN USH TIMES TAK4CUNEIFORM SIGN USH" +
	"XCUNEIFORM SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFORM SIGN UTUKICUNEIFORM S" +
	"IGN UZ3CUNEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM SIGN UZUCUNEIFORM SIGN Z" +
	"ACUNEIFORM SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED TIMES KURCUNEIFORM SIGN" +
	" ZAGCUNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFORM SIGN ZICUNEIFORM SIGN" +
	" ZI OVER ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCUNEIFORM SIGN ZIB KABA T" +
	"ENUCUNEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM SIGN ZUCUNEIFORM SIGN " +
	"ZU5CUNEIFORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBURCUNEIFORM SIGN ZUMCUNEI" +
	"FORM SIGN KAP ELAMITECUNEIFORM SIGN AB TIMES NUNCUNEIFORM SIGN AB2 TIMES" +
	" ACUNEIFORM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS M" +
	"ASHCUNEIFORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SHUCUNEIFORM SIGN DUB TIM" +
	"ES SHECUNEIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN EZEN TIMES SHECUNEIFOR" +
	"M SIGN GA2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN GA2 TIMES ASH2CUNEIFOR" +
	"M SIGN GE22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHCUNEIFORM SIGN KA TIMES " +
	"ANSHECUNEIFORM SIGN KA TIMES ASH3CUNEIFORM SIGN KA TIMES GISHCUNEIFORM S" +
	"IGN KA TIMES GUDCUNEIFORM SIGN KA TIMES HI TIMES ASH2CUNEIFORM SIGN KA T" +
	"IMES LUMCUNEIFORM SIGN KA TIMES PACUNEIFORM SIGN KA TIMES SHULCUNEIFORM " +
	"SIGN KA TIMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIFORM SIGN LAGAB TIMES GI" +
	"CUNEIFORM SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2 PLUS L" +
	"ALCUNEIFORM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESHCUNEIFORM SIGN MUSH3 TI" +
	"MES ZACUNEIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFORM SIGN NIN9CUNEIFORM S" +
	"IGN NINDA2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES GICUNEIFORM SIGN NU11 RO" +
	"TATED NINETY DEGREESCUNEIFORM SIGN PESH2 ASTERISKCUNEIFORM SIGN PIR2CUNE" +
	"IFORM SIGN SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CUNEIFORM SIGN UM TIMES M" +
	"ECUNEIFORM SIGN U UCUNEIFORM NUMERIC SIGN TWO ASHCUNEIFORM NUMERIC SIGN " +
	"THREE ASHCUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM NUMERIC SIGN FIVE ASHC" +
	"UNEIFORM NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SIGN SEVEN ASHCUNEIFORM N" +
	"UMERIC SIGN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE ASHCUNEIFORM NUMERIC SI" +
	"GN THREE DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNEIFORM NUMERIC SIGN FIVE" +
	" DISHCUNEIFORM NUMERIC SIGN SIX DISHCUNEIFORM NUMERIC SIGN SEVEN DISHCUN" +
	"EIFORM NUMERIC SIGN EIGHT DISHCUNEIFORM NUMERIC SIGN NINE DISHCUNEIFORM " +
	"NUMERIC SIGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UCUNEIFORM NUMERIC SIGN S" +
	"IX UCUNEIFORM NUMERIC SIGN SEVEN UCUNEIFORM NUMERIC SIGN EIGHT UCUNEIFOR" +
	"M NUMERIC SIGN NINE UCUNEIFORM NUMERIC SIGN ONE GESH2CUNEIFORM NUMERIC S" +
	"IGN TWO GESH2CUNEIFORM NUMERIC SIGN THREE GESH2CUNEIFORM NUMERIC SIGN FO" +
	"UR GESH2CUNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFORM NUMERIC SIGN SIX GESH" +
	"2CUNEIFORM NUMERIC SIGN SEVEN GESH2CUNEIFORM NUMERIC SIGN EIGHT GESH2CUN" +
	"EIFORM NUMERIC SIGN NINE GESH2CUNEIFORM NUMERIC SIGN ONE GESHUCUNEIFORM " +
	"NUMERIC SIGN TWO GESHUCUNEIFORM NUMERIC SIGN THREE GESHUCUNEIFORM NUMERI" +
	"C SIGN FOUR GESHUCUNEIFORM NUMERIC SIGN FIVE GESHUCUNEIFORM NUMERIC SIGN" +
	" TWO SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEIFORM NUMERIC SIGN THREE" +
	" SHAR2 VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHAR2CUNEIFORM NUMERIC SI" +
	"GN FIVE SHAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNEIFORM NUMERIC SIGN SEVE" +
	"N SHAR2CUNEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFORM NUMERIC SIGN NINE SHA" +
	"R2CUNEIFORM NUMERIC SIGN ONE SHARUCUNEIFORM NUMERIC SIGN TWO SHARUCUNEIF" +
	"ORM NUMERIC SIGN THREE SHARUCUNEIFORM NUMERIC SIGN THREE SHARU VARIANT F" +
	"ORMCUNEIFORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUMERIC SIGN FIVE SHARUCUN" +
	"EIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNEIFORM NUMERIC SIGN SHAR" +
	"2 TIMES GAL PLUS MINCUNEIFORM NUMERIC SIGN ONE BURUCUNEIFORM NUMERIC SIG" +
	"N TWO BURUCUNEIFORM NUMERIC SIGN THREE BURUCUNEIFORM NUMERIC SIGN THREE " +
	"BURU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR BURUCUNEIFORM NUMERIC SIGN ") + ("" +
	"FIVE BURUCUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16CUNEIFORM NUMERI" +
	"C SIGN THREE VARIANT FORM ESH21CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM " +
	"LIMMUCUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4CUNEIFORM NUMERIC SI" +
	"GN FOUR VARIANT FORM LIMMU ACUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIM" +
	"MU BCUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9CUNEIFORM NUMERIC SIGN S" +
	"EVEN VARIANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN AC" +
	"UNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN BCUNEIFORM NUMERIC SIGN EI" +
	"GHT VARIANT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3CUNE" +
	"IFORM NUMERIC SIGN NINE VARIANT FORM ILIMMUCUNEIFORM NUMERIC SIGN NINE V" +
	"ARIANT FORM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4CUNEI" +
	"FORM NUMERIC SIGN NINE VARIANT FORM ILIMMU ACUNEIFORM NUMERIC SIGN TWO A" +
	"SH TENUCUNEIFORM NUMERIC SIGN THREE ASH TENUCUNEIFORM NUMERIC SIGN FOUR " +
	"ASH TENUCUNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEIFORM NUMERIC SIGN SIX A" +
	"SH TENUCUNEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM NUMERIC SIGN TWO BAN2CUN" +
	"EIFORM NUMERIC SIGN THREE BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2CUNEIFORM " +
	"NUMERIC SIGN FOUR BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE BAN2CUNEI" +
	"FORM NUMERIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN NIGIDAMIN" +
	"CUNEIFORM NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC SIGN ONE ESHE3CUNEIFOR" +
	"M NUMERIC SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ONE THIRD DISHCUNEIFORM N" +
	"UMERIC SIGN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN FIVE SIXTHS DISHCUNEIF" +
	"ORM NUMERIC SIGN ONE THIRD VARIANT FORM ACUNEIFORM NUMERIC SIGN TWO THIR" +
	"DS VARIANT FORM ACUNEIFORM NUMERIC SIGN ONE EIGHTH ASHCUNEIFORM NUMERIC " +
	"SIGN ONE QUARTER ASHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTHCUNEIFO" +
	"RM NUMERIC SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM NUMERIC SIGN ONE QUART" +
	"ER GURCUNEIFORM NUMERIC SIGN ONE HALF GURCUNEIFORM NUMERIC SIGN ELAMITE " +
	"ONE THIRDCUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDSCUNEIFORM NUMERIC SIGN" +
	" ELAMITE FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFTYCUNEIFORM NUMERIC SIGN" +
	" FOUR U VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U VARIANT FORMCUNEIFORM " +
	"NUMERIC SIGN SIX U VARIANT FORMCUNEIFORM NUMERIC SIGN SEVEN U VARIANT FO" +
	"RMCUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORMCUNEIFORM NUMERIC SIGN NINE" +
	" U VARIANT FORMCUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDERCUNEI" +
	"FORM PUNCTUATION SIGN VERTICAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL " +
	"COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLONCUNEIFORM PUNCTUATION S" +
	"IGN DIAGONAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN TENUCUNEIFORM SIGN AB " +
	"TIMES SHU2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM SIGN BAD TIMES DISH TENU" +
	"CUNEIFORM SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAHAR2 TIMES NICUNEIFORM S" +
	"IGN BAHAR2 TIMES ZACUNEIFORM SIGN BU OVER BU TIMES NA2CUNEIFORM SIGN DA " +
	"TIMES TAK4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM SIGN DIM TIMES IGICUNEIF" +
	"ORM SIGN DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES UDCUNEIFORM SIGN DUG T" +
	"IMES ANSHECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM SIGN DUG TIMES ASH AT LE" +
	"FTCUNEIFORM SIGN DUG TIMES DINCUNEIFORM SIGN DUG TIMES DUNCUNEIFORM SIGN" +
	" DUG TIMES ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIFORM SIGN DUG TIMES GICU" +
	"NEIFORM SIGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DUG TIMES GISHCUNEIFORM S" +
	"IGN DUG TIMES HACUNEIFORM SIGN DUG TIMES HICUNEIFORM SIGN DUG TIMES IGI " +
	"GUNUCUNEIFORM SIGN DUG TIMES KASKALCUNEIFORM SIGN DUG TIMES KURCUNEIFORM" +
	" SIGN DUG TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASKALCUNEIFO" +
	"RM SIGN DUG TIMES LAK-020CUNEIFORM SIGN DUG TIMES LAMCUNEIFORM SIGN DUG " +
	"TIMES LAM TIMES KURCUNEIFORM SIGN DUG TIMES LUH PLUS GISHCUNEIFORM SIGN " +
	"DUG TIMES MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFORM SIGN DUG TIMES MICUN" +
	"EIFORM SIGN DUG TIMES NICUNEIFORM SIGN DUG TIMES PICUNEIFORM SIGN DUG TI" +
	"MES SHECUNEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM SIGN E2 TIMES KURCUNEIF" +
	"ORM SIGN E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIFORM SIGN ESH2 CROSSING " +
	"ESH2CUNEIFORM SIGN EZEN SHESHIG TIMES ASHCUNEIFORM SIGN EZEN SHESHIG TIM" +
	"ES HICUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNUCUNEIFORM SIGN EZEN SHESH" +
	"IG TIMES LACUNEIFORM SIGN EZEN SHESHIG TIMES LALCUNEIFORM SIGN EZEN SHES" +
	"HIG TIMES MECUNEIFORM SIGN EZEN SHESHIG TIMES MESCUNEIFORM SIGN EZEN SHE" +
	"SHIG TIMES SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFORM SIGN GA2 TIMES BAHAR2" +
	"CUNEIFORM SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES IGI " +
	"GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES KASKALCUNEIFORM SIGN GA2 TIMES ER" +
	"ENCUNEIFORM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 TIMES GAR PLUS DICUNEIFO" +
	"RM SIGN GA2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 TIMES HA PLUS ACUNEIFORM" +
	" SIGN GA2 TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN GA2 TIMES LAMCUNEIFORM " +
	"SIGN GA2 TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TIMES LUHCUNEIFORM SIGN G" +
	"A2 TIMES MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM SIGN GA2 TIMES NE PLUS") + ("" +
	" E2CUNEIFORM SIGN GA2 TIMES NE PLUS GICUNEIFORM SIGN GA2 TIMES SHIMCUNEI" +
	"FORM SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTATED NINETY DEGREESCUNEIF" +
	"ORM SIGN GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES GISH CROSSING GISHCUNE" +
	"IFORM SIGN GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD PLUS GISH TIMES TAK4CUNE" +
	"IFORM SIGN HA TENU GUNUCUNEIFORM SIGN HI TIMES ASH OVER HI TIMES ASHCUNE" +
	"IFORM SIGN KA TIMES BUCUNEIFORM SIGN KA TIMES KACUNEIFORM SIGN KA TIMES " +
	"U U UCUNEIFORM SIGN KA TIMES URCUNEIFORM SIGN LAGAB TIMES ZU OVER ZUCUNE" +
	"IFORM SIGN LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM SIGN LAK-025CUNEIFORM " +
	"SIGN LAK-030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN LAK-051CUNEIFORM SIGN L" +
	"AK-062CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNUCUNEIFORM SIGN LAK-080CUNE" +
	"IFORM SIGN LAK-081 OVER LAK-081CUNEIFORM SIGN LAK-092CUNEIFORM SIGN LAK-" +
	"130CUNEIFORM SIGN LAK-142CUNEIFORM SIGN LAK-210CUNEIFORM SIGN LAK-219CUN" +
	"EIFORM SIGN LAK-220CUNEIFORM SIGN LAK-225CUNEIFORM SIGN LAK-228CUNEIFORM" +
	" SIGN LAK-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN LAK-266CUNEIFORM SIGN " +
	"LAK-343CUNEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-348CUNEIFORM SIGN LAK-38" +
	"3CUNEIFORM SIGN LAK-384CUNEIFORM SIGN LAK-390CUNEIFORM SIGN LAK-441CUNEI" +
	"FORM SIGN LAK-449CUNEIFORM SIGN LAK-449 TIMES GUCUNEIFORM SIGN LAK-449 T" +
	"IMES IGICUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3CUNEIFORM SIGN LAK-449 " +
	"TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES U2 PLUS BACUNEIF" +
	"ORM SIGN LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM SIGN LAK-470CUNEIFORM SI" +
	"GN LAK-483CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LAK-492CUNEIFORM SIGN LAK" +
	"-493CUNEIFORM SIGN LAK-495CUNEIFORM SIGN LAK-550CUNEIFORM SIGN LAK-608CU" +
	"NEIFORM SIGN LAK-617CUNEIFORM SIGN LAK-617 TIMES ASHCUNEIFORM SIGN LAK-6" +
	"17 TIMES BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNUCUNEIFORM SIGN LA" +
	"K-617 TIMES KU3CUNEIFORM SIGN LAK-617 TIMES LACUNEIFORM SIGN LAK-617 TIM" +
	"ES TARCUNEIFORM SIGN LAK-617 TIMES TECUNEIFORM SIGN LAK-617 TIMES U2CUNE" +
	"IFORM SIGN LAK-617 TIMES UDCUNEIFORM SIGN LAK-617 TIMES URUDACUNEIFORM S" +
	"IGN LAK-636CUNEIFORM SIGN LAK-648CUNEIFORM SIGN LAK-648 TIMES DUBCUNEIFO" +
	"RM SIGN LAK-648 TIMES GACUNEIFORM SIGN LAK-648 TIMES IGICUNEIFORM SIGN L" +
	"AK-648 TIMES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES NICUNEIFORM SIGN LAK-6" +
	"48 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KI" +
	"CUNEIFORM SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK-648 TIMES URUDACUNEIFO" +
	"RM SIGN LAK-724CUNEIFORM SIGN LAK-749CUNEIFORM SIGN LU2 GUNU TIMES ASHCU" +
	"NEIFORM SIGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIMES HALCUNEIFORM SIGN LU" +
	"2 TIMES PAPCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN " +
	"LU2 TIMES TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM SIGN MUSH OVER MUSH TI" +
	"MES GACUNEIFORM SIGN MUSH OVER MUSH TIMES KAKCUNEIFORM SIGN NINDA2 TIMES" +
	" DIM GUNUCUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFORM SIGN NINDA2 TIMES GUL" +
	"CUNEIFORM SIGN NINDA2 TIMES HICUNEIFORM SIGN NINDA2 TIMES KESH2CUNEIFORM" +
	" SIGN NINDA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 TIMES MASHCUNEIFORM SIGN" +
	" NINDA2 TIMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 TIMES UCUNEIFORM SIGN NI" +
	"NDA2 TIMES U PLUS UCUNEIFORM SIGN NINDA2 TIMES URUDACUNEIFORM SIGN SAG G" +
	"UNU TIMES HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM SIGN SAG TIMES SHE AT L" +
	"EFTCUNEIFORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SHA6 TENUCUNEIFORM SIGN S" +
	"HE OVER SHECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM SIGN SHE PLUS NAM2CUNEI" +
	"FORM SIGN SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DUG TIMES NICUNEIFORM SIG" +
	"N SHU2 PLUS E2 TIMES ANCUNEIFORM SIGN SI TIMES TAK4CUNEIFORM SIGN TAK4 P" +
	"LUS SAGCUNEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFORM SIGN TUM TIMES THREE " +
	"DISHCUNEIFORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2 TIMES UDCUNEIFORM SIGN" +
	" URU TIMES DARA3CUNEIFORM SIGN URU TIMES LAK-668CUNEIFORM SIGN URU TIMES" +
	" LU3CUNEIFORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU PLUS SARCUNEIFORM SIGN Z" +
	"U5 TIMES THREE DISH TENUEGYPTIAN HIEROGLYPH A001EGYPTIAN HIEROGLYPH A002" +
	"EGYPTIAN HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004EGYPTIAN HIEROGLYPH A005" +
	"EGYPTIAN HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006EGYPTIAN HIEROGLYPH A00" +
	"6AEGYPTIAN HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A007EGYPTIAN HIEROGLYPH A" +
	"008EGYPTIAN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A010EGYPTIAN HIEROGLYPH A" +
	"011EGYPTIAN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A013EGYPTIAN HIEROGLYPH A" +
	"014EGYPTIAN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A015EGYPTIAN HIEROGLYPH " +
	"A016EGYPTIAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A017AEGYPTIAN HIEROGLYPH" +
	" A018EGYPTIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH A020EGYPTIAN HIEROGLYPH" +
	" A021EGYPTIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH A023EGYPTIAN HIEROGLYPH" +
	" A024EGYPTIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH A026EGYPTIAN HIEROGLYPH" +
	" A027EGYPTIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH A029EGYPTIAN HIEROGLYPH" +
	" A030EGYPTIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH A032EGYPTIAN HIEROGLYPH") + ("" +
	" A032AEGYPTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH A034EGYPTIAN HIEROGLYP" +
	"H A035EGYPTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH A037EGYPTIAN HIEROGLYP" +
	"H A038EGYPTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH A040EGYPTIAN HIEROGLYP" +
	"H A040AEGYPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYPH A042EGYPTIAN HIEROGLY" +
	"PH A042AEGYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLYPH A043AEGYPTIAN HIEROG" +
	"LYPH A044EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGLYPH A045AEGYPTIAN HIERO" +
	"GLYPH A046EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROGLYPH A048EGYPTIAN HIERO" +
	"GLYPH A049EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROGLYPH A051EGYPTIAN HIERO" +
	"GLYPH A052EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROGLYPH A054EGYPTIAN HIERO" +
	"GLYPH A055EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROGLYPH A057EGYPTIAN HIERO" +
	"GLYPH A058EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROGLYPH A060EGYPTIAN HIERO" +
	"GLYPH A061EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROGLYPH A063EGYPTIAN HIERO" +
	"GLYPH A064EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROGLYPH A066EGYPTIAN HIERO" +
	"GLYPH A067EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROGLYPH A069EGYPTIAN HIERO" +
	"GLYPH A070EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROGLYPH B002EGYPTIAN HIERO" +
	"GLYPH B003EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROGLYPH B005EGYPTIAN HIERO" +
	"GLYPH B005AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIEROGLYPH B007EGYPTIAN HIER" +
	"OGLYPH B008EGYPTIAN HIEROGLYPH B009EGYPTIAN HIEROGLYPH C001EGYPTIAN HIER" +
	"OGLYPH C002EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIEROGLYPH C002BEGYPTIAN HI" +
	"EROGLYPH C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HIEROGLYPH C004EGYPTIAN H" +
	"IEROGLYPH C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HIEROGLYPH C007EGYPTIAN H" +
	"IEROGLYPH C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HIEROGLYPH C010EGYPTIAN H" +
	"IEROGLYPH C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN HIEROGLYPH C012EGYPTIAN " +
	"HIEROGLYPH C013EGYPTIAN HIEROGLYPH C014EGYPTIAN HIEROGLYPH C015EGYPTIAN " +
	"HIEROGLYPH C016EGYPTIAN HIEROGLYPH C017EGYPTIAN HIEROGLYPH C018EGYPTIAN " +
	"HIEROGLYPH C019EGYPTIAN HIEROGLYPH C020EGYPTIAN HIEROGLYPH C021EGYPTIAN " +
	"HIEROGLYPH C022EGYPTIAN HIEROGLYPH C023EGYPTIAN HIEROGLYPH C024EGYPTIAN " +
	"HIEROGLYPH D001EGYPTIAN HIEROGLYPH D002EGYPTIAN HIEROGLYPH D003EGYPTIAN " +
	"HIEROGLYPH D004EGYPTIAN HIEROGLYPH D005EGYPTIAN HIEROGLYPH D006EGYPTIAN " +
	"HIEROGLYPH D007EGYPTIAN HIEROGLYPH D008EGYPTIAN HIEROGLYPH D008AEGYPTIAN" +
	" HIEROGLYPH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN HIEROGLYPH D011EGYPTIAN" +
	" HIEROGLYPH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN HIEROGLYPH D014EGYPTIAN" +
	" HIEROGLYPH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN HIEROGLYPH D017EGYPTIAN" +
	" HIEROGLYPH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN HIEROGLYPH D020EGYPTIAN" +
	" HIEROGLYPH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN HIEROGLYPH D023EGYPTIAN" +
	" HIEROGLYPH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN HIEROGLYPH D026EGYPTIAN" +
	" HIEROGLYPH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN HIEROGLYPH D028EGYPTIA" +
	"N HIEROGLYPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN HIEROGLYPH D031EGYPTIA" +
	"N HIEROGLYPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIAN HIEROGLYPH D033EGYPTI" +
	"AN HIEROGLYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTIAN HIEROGLYPH D035EGYPT" +
	"IAN HIEROGLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTIAN HIEROGLYPH D038EGYPT" +
	"IAN HIEROGLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTIAN HIEROGLYPH D041EGYPT" +
	"IAN HIEROGLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTIAN HIEROGLYPH D044EGYPT" +
	"IAN HIEROGLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTIAN HIEROGLYPH D046AEGYP" +
	"TIAN HIEROGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPTIAN HIEROGLYPH D048AEGY" +
	"PTIAN HIEROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYPTIAN HIEROGLYPH D050AEG" +
	"YPTIAN HIEROGLYPH D050BEGYPTIAN HIEROGLYPH D050CEGYPTIAN HIEROGLYPH D050" +
	"DEGYPTIAN HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D050FEGYPTIAN HIEROGLYPH D" +
	"050GEGYPTIAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH D050IEGYPTIAN HIEROGLYP" +
	"H D051EGYPTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH D052AEGYPTIAN HIEROGLY" +
	"PH D053EGYPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYPH D054AEGYPTIAN HIEROGL" +
	"YPH D055EGYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLYPH D057EGYPTIAN HIEROGL" +
	"YPH D058EGYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLYPH D060EGYPTIAN HIEROGL" +
	"YPH D061EGYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLYPH D063EGYPTIAN HIEROGL" +
	"YPH D064EGYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLYPH D066EGYPTIAN HIEROGL" +
	"YPH D067EGYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGLYPH D067BEGYPTIAN HIERO" +
	"GLYPH D067CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIEROGLYPH D067EEGYPTIAN HI" +
	"EROGLYPH D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN HIEROGLYPH D067HEGYPTIAN" +
	" HIEROGLYPH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN HIEROGLYPH E003EGYPTIAN" +
	" HIEROGLYPH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN HIEROGLYPH E006EGYPTIAN" +
	" HIEROGLYPH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN HIEROGLYPH E008AEGYPTIA" +
	"N HIEROGLYPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIAN HIEROGLYPH E010EGYPTI" +
	"AN HIEROGLYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIAN HIEROGLYPH E013EGYPTI" +
	"AN HIEROGLYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIAN HIEROGLYPH E016EGYPTI") + ("" +
	"AN HIEROGLYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTIAN HIEROGLYPH E017AEGYP" +
	"TIAN HIEROGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPTIAN HIEROGLYPH E020EGYP" +
	"TIAN HIEROGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYPTIAN HIEROGLYPH E022EGY" +
	"PTIAN HIEROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYPTIAN HIEROGLYPH E025EGY" +
	"PTIAN HIEROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYPTIAN HIEROGLYPH E028EGY" +
	"PTIAN HIEROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGYPTIAN HIEROGLYPH E030EG" +
	"YPTIAN HIEROGLYPH E031EGYPTIAN HIEROGLYPH E032EGYPTIAN HIEROGLYPH E033EG" +
	"YPTIAN HIEROGLYPH E034EGYPTIAN HIEROGLYPH E034AEGYPTIAN HIEROGLYPH E036E" +
	"GYPTIAN HIEROGLYPH E037EGYPTIAN HIEROGLYPH E038EGYPTIAN HIEROGLYPH F001E" +
	"GYPTIAN HIEROGLYPH F001AEGYPTIAN HIEROGLYPH F002EGYPTIAN HIEROGLYPH F003" +
	"EGYPTIAN HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005EGYPTIAN HIEROGLYPH F006" +
	"EGYPTIAN HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008EGYPTIAN HIEROGLYPH F009" +
	"EGYPTIAN HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011EGYPTIAN HIEROGLYPH F012" +
	"EGYPTIAN HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013AEGYPTIAN HIEROGLYPH F01" +
	"4EGYPTIAN HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016EGYPTIAN HIEROGLYPH F01" +
	"7EGYPTIAN HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019EGYPTIAN HIEROGLYPH F02" +
	"0EGYPTIAN HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021AEGYPTIAN HIEROGLYPH F0" +
	"22EGYPTIAN HIEROGLYPH F023EGYPTIAN HIEROGLYPH F024EGYPTIAN HIEROGLYPH F0" +
	"25EGYPTIAN HIEROGLYPH F026EGYPTIAN HIEROGLYPH F027EGYPTIAN HIEROGLYPH F0" +
	"28EGYPTIAN HIEROGLYPH F029EGYPTIAN HIEROGLYPH F030EGYPTIAN HIEROGLYPH F0" +
	"31EGYPTIAN HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F032EGYPTIAN HIEROGLYPH F" +
	"033EGYPTIAN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F035EGYPTIAN HIEROGLYPH F" +
	"036EGYPTIAN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F037AEGYPTIAN HIEROGLYPH " +
	"F038EGYPTIAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH F039EGYPTIAN HIEROGLYPH" +
	" F040EGYPTIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH F042EGYPTIAN HIEROGLYPH" +
	" F043EGYPTIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH F045EGYPTIAN HIEROGLYPH" +
	" F045AEGYPTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH F046AEGYPTIAN HIEROGLY" +
	"PH F047EGYPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLYPH F048EGYPTIAN HIEROGL" +
	"YPH F049EGYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLYPH F051EGYPTIAN HIEROGL" +
	"YPH F051AEGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROGLYPH F051CEGYPTIAN HIER" +
	"OGLYPH F052EGYPTIAN HIEROGLYPH F053EGYPTIAN HIEROGLYPH G001EGYPTIAN HIER" +
	"OGLYPH G002EGYPTIAN HIEROGLYPH G003EGYPTIAN HIEROGLYPH G004EGYPTIAN HIER" +
	"OGLYPH G005EGYPTIAN HIEROGLYPH G006EGYPTIAN HIEROGLYPH G006AEGYPTIAN HIE" +
	"ROGLYPH G007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIEROGLYPH G007BEGYPTIAN H" +
	"IEROGLYPH G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HIEROGLYPH G010EGYPTIAN H" +
	"IEROGLYPH G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN HIEROGLYPH G012EGYPTIAN " +
	"HIEROGLYPH G013EGYPTIAN HIEROGLYPH G014EGYPTIAN HIEROGLYPH G015EGYPTIAN " +
	"HIEROGLYPH G016EGYPTIAN HIEROGLYPH G017EGYPTIAN HIEROGLYPH G018EGYPTIAN " +
	"HIEROGLYPH G019EGYPTIAN HIEROGLYPH G020EGYPTIAN HIEROGLYPH G020AEGYPTIAN" +
	" HIEROGLYPH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN HIEROGLYPH G023EGYPTIAN" +
	" HIEROGLYPH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN HIEROGLYPH G026EGYPTIAN" +
	" HIEROGLYPH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN HIEROGLYPH G028EGYPTIA" +
	"N HIEROGLYPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN HIEROGLYPH G031EGYPTIA" +
	"N HIEROGLYPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN HIEROGLYPH G034EGYPTIA" +
	"N HIEROGLYPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN HIEROGLYPH G036AEGYPTI" +
	"AN HIEROGLYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTIAN HIEROGLYPH G038EGYPT" +
	"IAN HIEROGLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTIAN HIEROGLYPH G041EGYPT" +
	"IAN HIEROGLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTIAN HIEROGLYPH G043AEGYP" +
	"TIAN HIEROGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPTIAN HIEROGLYPH G045AEGY" +
	"PTIAN HIEROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYPTIAN HIEROGLYPH G048EGY" +
	"PTIAN HIEROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYPTIAN HIEROGLYPH G051EGY" +
	"PTIAN HIEROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYPTIAN HIEROGLYPH G054EGY" +
	"PTIAN HIEROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYPTIAN HIEROGLYPH H003EGY" +
	"PTIAN HIEROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYPTIAN HIEROGLYPH H006EGY" +
	"PTIAN HIEROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGYPTIAN HIEROGLYPH H008EG" +
	"YPTIAN HIEROGLYPH I001EGYPTIAN HIEROGLYPH I002EGYPTIAN HIEROGLYPH I003EG" +
	"YPTIAN HIEROGLYPH I004EGYPTIAN HIEROGLYPH I005EGYPTIAN HIEROGLYPH I005AE" +
	"GYPTIAN HIEROGLYPH I006EGYPTIAN HIEROGLYPH I007EGYPTIAN HIEROGLYPH I008E" +
	"GYPTIAN HIEROGLYPH I009EGYPTIAN HIEROGLYPH I009AEGYPTIAN HIEROGLYPH I010" +
	"EGYPTIAN HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011EGYPTIAN HIEROGLYPH I01" +
	"1AEGYPTIAN HIEROGLYPH I012EGYPTIAN HIEROGLYPH I013EGYPTIAN HIEROGLYPH I0" +
	"14EGYPTIAN HIEROGLYPH I015EGYPTIAN HIEROGLYPH K001EGYPTIAN HIEROGLYPH K0" +
	"02EGYPTIAN HIEROGLYPH K003EGYPTIAN HIEROGLYPH K004EGYPTIAN HIEROGLYPH K0" +
	"05EGYPTIAN HIEROGLYPH K006EGYPTIAN HIEROGLYPH K007EGYPTIAN HIEROGLYPH K0") + ("" +
	"08EGYPTIAN HIEROGLYPH L001EGYPTIAN HIEROGLYPH L002EGYPTIAN HIEROGLYPH L0" +
	"02AEGYPTIAN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L004EGYPTIAN HIEROGLYPH L" +
	"005EGYPTIAN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L006AEGYPTIAN HIEROGLYPH " +
	"L007EGYPTIAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M001EGYPTIAN HIEROGLYPH " +
	"M001AEGYPTIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH M002EGYPTIAN HIEROGLYP" +
	"H M003EGYPTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYPH M004EGYPTIAN HIEROGLY" +
	"PH M005EGYPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYPH M007EGYPTIAN HIEROGLY" +
	"PH M008EGYPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYPH M010EGYPTIAN HIEROGLY" +
	"PH M010AEGYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLYPH M012EGYPTIAN HIEROGL" +
	"YPH M012AEGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROGLYPH M012CEGYPTIAN HIER" +
	"OGLYPH M012DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIEROGLYPH M012FEGYPTIAN H" +
	"IEROGLYPH M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN HIEROGLYPH M013EGYPTIAN" +
	" HIEROGLYPH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN HIEROGLYPH M015AEGYPTIA" +
	"N HIEROGLYPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIAN HIEROGLYPH M017EGYPTI" +
	"AN HIEROGLYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTIAN HIEROGLYPH M019EGYPT" +
	"IAN HIEROGLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTIAN HIEROGLYPH M022EGYPT" +
	"IAN HIEROGLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPTIAN HIEROGLYPH M024EGYP" +
	"TIAN HIEROGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYPTIAN HIEROGLYPH M026EGY" +
	"PTIAN HIEROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYPTIAN HIEROGLYPH M028AEG" +
	"YPTIAN HIEROGLYPH M029EGYPTIAN HIEROGLYPH M030EGYPTIAN HIEROGLYPH M031EG" +
	"YPTIAN HIEROGLYPH M031AEGYPTIAN HIEROGLYPH M032EGYPTIAN HIEROGLYPH M033E" +
	"GYPTIAN HIEROGLYPH M033AEGYPTIAN HIEROGLYPH M033BEGYPTIAN HIEROGLYPH M03" +
	"4EGYPTIAN HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036EGYPTIAN HIEROGLYPH M03" +
	"7EGYPTIAN HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039EGYPTIAN HIEROGLYPH M04" +
	"0EGYPTIAN HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M041EGYPTIAN HIEROGLYPH M0" +
	"42EGYPTIAN HIEROGLYPH M043EGYPTIAN HIEROGLYPH M044EGYPTIAN HIEROGLYPH N0" +
	"01EGYPTIAN HIEROGLYPH N002EGYPTIAN HIEROGLYPH N003EGYPTIAN HIEROGLYPH N0" +
	"04EGYPTIAN HIEROGLYPH N005EGYPTIAN HIEROGLYPH N006EGYPTIAN HIEROGLYPH N0" +
	"07EGYPTIAN HIEROGLYPH N008EGYPTIAN HIEROGLYPH N009EGYPTIAN HIEROGLYPH N0" +
	"10EGYPTIAN HIEROGLYPH N011EGYPTIAN HIEROGLYPH N012EGYPTIAN HIEROGLYPH N0" +
	"13EGYPTIAN HIEROGLYPH N014EGYPTIAN HIEROGLYPH N015EGYPTIAN HIEROGLYPH N0" +
	"16EGYPTIAN HIEROGLYPH N017EGYPTIAN HIEROGLYPH N018EGYPTIAN HIEROGLYPH N0" +
	"18AEGYPTIAN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N019EGYPTIAN HIEROGLYPH " +
	"N020EGYPTIAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N022EGYPTIAN HIEROGLYPH " +
	"N023EGYPTIAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N025EGYPTIAN HIEROGLYPH " +
	"N025AEGYPTIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH N027EGYPTIAN HIEROGLYPH" +
	" N028EGYPTIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH N030EGYPTIAN HIEROGLYPH" +
	" N031EGYPTIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH N033EGYPTIAN HIEROGLYPH" +
	" N033AEGYPTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH N034AEGYPTIAN HIEROGLY" +
	"PH N035EGYPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLYPH N036EGYPTIAN HIEROGL" +
	"YPH N037EGYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGLYPH N038EGYPTIAN HIEROG" +
	"LYPH N039EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGLYPH N041EGYPTIAN HIEROG" +
	"LYPH N042EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROGLYPH NL002EGYPTIAN HIER" +
	"OGLYPH NL003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIEROGLYPH NL005EGYPTIAN H" +
	"IEROGLYPH NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN HIEROGLYPH NL007EGYPTI" +
	"AN HIEROGLYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPTIAN HIEROGLYPH NL010EGY" +
	"PTIAN HIEROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EGYPTIAN HIEROGLYPH NL013" +
	"EGYPTIAN HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL015EGYPTIAN HIEROGLYPH NL" +
	"016EGYPTIAN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH NL017AEGYPTIAN HIEROGLYP" +
	"H NL018EGYPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLYPH NL020EGYPTIAN HIEROG" +
	"LYPH NU001EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIEROGLYPH NU003EGYPTIAN HIE" +
	"ROGLYPH NU004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HIEROGLYPH NU006EGYPTIAN " +
	"HIEROGLYPH NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN HIEROGLYPH NU009EGYPTI" +
	"AN HIEROGLYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYPTIAN HIEROGLYPH NU011EG" +
	"YPTIAN HIEROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012EGYPTIAN HIEROGLYPH NU0" +
	"13EGYPTIAN HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU015EGYPTIAN HIEROGLYPH " +
	"NU016EGYPTIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH NU018EGYPTIAN HIEROGLY" +
	"PH NU018AEGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROGLYPH NU020EGYPTIAN HIER" +
	"OGLYPH NU021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIEROGLYPH NU022AEGYPTIAN " +
	"HIEROGLYPH O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN HIEROGLYPH O002EGYPTIAN" +
	" HIEROGLYPH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN HIEROGLYPH O005EGYPTIAN" +
	" HIEROGLYPH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN HIEROGLYPH O006AEGYPTI" +
	"AN HIEROGLYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPTIAN HIEROGLYPH O006DEGY" +
	"PTIAN HIEROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEGYPTIAN HIEROGLYPH O007E") + ("" +
	"GYPTIAN HIEROGLYPH O008EGYPTIAN HIEROGLYPH O009EGYPTIAN HIEROGLYPH O010E" +
	"GYPTIAN HIEROGLYPH O010AEGYPTIAN HIEROGLYPH O010BEGYPTIAN HIEROGLYPH O01" +
	"0CEGYPTIAN HIEROGLYPH O011EGYPTIAN HIEROGLYPH O012EGYPTIAN HIEROGLYPH O0" +
	"13EGYPTIAN HIEROGLYPH O014EGYPTIAN HIEROGLYPH O015EGYPTIAN HIEROGLYPH O0" +
	"16EGYPTIAN HIEROGLYPH O017EGYPTIAN HIEROGLYPH O018EGYPTIAN HIEROGLYPH O0" +
	"19EGYPTIAN HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O020EGYPTIAN HIEROGLYPH O" +
	"020AEGYPTIAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O022EGYPTIAN HIEROGLYPH " +
	"O023EGYPTIAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O024AEGYPTIAN HIEROGLYPH" +
	" O025EGYPTIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH O026EGYPTIAN HIEROGLYP" +
	"H O027EGYPTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH O029EGYPTIAN HIEROGLYP" +
	"H O029AEGYPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYPH O030AEGYPTIAN HIEROGL" +
	"YPH O031EGYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLYPH O033EGYPTIAN HIEROGL" +
	"YPH O033AEGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGLYPH O035EGYPTIAN HIEROG" +
	"LYPH O036EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROGLYPH O036BEGYPTIAN HIER" +
	"OGLYPH O036CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIEROGLYPH O037EGYPTIAN HI" +
	"EROGLYPH O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIEROGLYPH O040EGYPTIAN HI" +
	"EROGLYPH O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIEROGLYPH O043EGYPTIAN HI" +
	"EROGLYPH O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIEROGLYPH O046EGYPTIAN HI" +
	"EROGLYPH O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIEROGLYPH O049EGYPTIAN HI" +
	"EROGLYPH O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HIEROGLYPH O050BEGYPTIAN " +
	"HIEROGLYPH O051EGYPTIAN HIEROGLYPH P001EGYPTIAN HIEROGLYPH P001AEGYPTIAN" +
	" HIEROGLYPH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN HIEROGLYPH P003AEGYPTIA" +
	"N HIEROGLYPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN HIEROGLYPH P006EGYPTIA" +
	"N HIEROGLYPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN HIEROGLYPH P009EGYPTIA" +
	"N HIEROGLYPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN HIEROGLYPH Q001EGYPTIA" +
	"N HIEROGLYPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN HIEROGLYPH Q004EGYPTIA" +
	"N HIEROGLYPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN HIEROGLYPH Q007EGYPTIA" +
	"N HIEROGLYPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN HIEROGLYPH R002AEGYPTI" +
	"AN HIEROGLYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTIAN HIEROGLYPH R003BEGYP" +
	"TIAN HIEROGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPTIAN HIEROGLYPH R006EGYP" +
	"TIAN HIEROGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPTIAN HIEROGLYPH R009EGYP" +
	"TIAN HIEROGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYPTIAN HIEROGLYPH R011EGY" +
	"PTIAN HIEROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYPTIAN HIEROGLYPH R014EGY" +
	"PTIAN HIEROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYPTIAN HIEROGLYPH R016AEG" +
	"YPTIAN HIEROGLYPH R017EGYPTIAN HIEROGLYPH R018EGYPTIAN HIEROGLYPH R019EG" +
	"YPTIAN HIEROGLYPH R020EGYPTIAN HIEROGLYPH R021EGYPTIAN HIEROGLYPH R022EG" +
	"YPTIAN HIEROGLYPH R023EGYPTIAN HIEROGLYPH R024EGYPTIAN HIEROGLYPH R025EG" +
	"YPTIAN HIEROGLYPH R026EGYPTIAN HIEROGLYPH R027EGYPTIAN HIEROGLYPH R028EG" +
	"YPTIAN HIEROGLYPH R029EGYPTIAN HIEROGLYPH S001EGYPTIAN HIEROGLYPH S002EG" +
	"YPTIAN HIEROGLYPH S002AEGYPTIAN HIEROGLYPH S003EGYPTIAN HIEROGLYPH S004E" +
	"GYPTIAN HIEROGLYPH S005EGYPTIAN HIEROGLYPH S006EGYPTIAN HIEROGLYPH S006A" +
	"EGYPTIAN HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008EGYPTIAN HIEROGLYPH S009" +
	"EGYPTIAN HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011EGYPTIAN HIEROGLYPH S012" +
	"EGYPTIAN HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014EGYPTIAN HIEROGLYPH S014" +
	"AEGYPTIAN HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S015EGYPTIAN HIEROGLYPH S0" +
	"16EGYPTIAN HIEROGLYPH S017EGYPTIAN HIEROGLYPH S017AEGYPTIAN HIEROGLYPH S" +
	"018EGYPTIAN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S020EGYPTIAN HIEROGLYPH S" +
	"021EGYPTIAN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S023EGYPTIAN HIEROGLYPH S" +
	"024EGYPTIAN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S026EGYPTIAN HIEROGLYPH S" +
	"026AEGYPTIAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH S027EGYPTIAN HIEROGLYPH" +
	" S028EGYPTIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH S030EGYPTIAN HIEROGLYPH" +
	" S031EGYPTIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH S033EGYPTIAN HIEROGLYPH" +
	" S034EGYPTIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH S035AEGYPTIAN HIEROGLYP" +
	"H S036EGYPTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH S038EGYPTIAN HIEROGLYP" +
	"H S039EGYPTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH S041EGYPTIAN HIEROGLYP" +
	"H S042EGYPTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH S044EGYPTIAN HIEROGLYP" +
	"H S045EGYPTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH T001EGYPTIAN HIEROGLYP" +
	"H T002EGYPTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH T003AEGYPTIAN HIEROGLY" +
	"PH T004EGYPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYPH T006EGYPTIAN HIEROGLY" +
	"PH T007EGYPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLYPH T008EGYPTIAN HIEROGL" +
	"YPH T008AEGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGLYPH T009AEGYPTIAN HIERO" +
	"GLYPH T010EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROGLYPH T011AEGYPTIAN HIER" +
	"OGLYPH T012EGYPTIAN HIEROGLYPH T013EGYPTIAN HIEROGLYPH T014EGYPTIAN HIER" +
	"OGLYPH T015EGYPTIAN HIEROGLYPH T016EGYPTIAN HIEROGLYPH T016AEGYPTIAN HIE") + ("" +
	"ROGLYPH T017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIEROGLYPH T019EGYPTIAN HIE" +
	"ROGLYPH T020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIEROGLYPH T022EGYPTIAN HIE" +
	"ROGLYPH T023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIEROGLYPH T025EGYPTIAN HIE" +
	"ROGLYPH T026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIEROGLYPH T028EGYPTIAN HIE" +
	"ROGLYPH T029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIEROGLYPH T031EGYPTIAN HIE" +
	"ROGLYPH T032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIEROGLYPH T033EGYPTIAN HI" +
	"EROGLYPH T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HIEROGLYPH T035EGYPTIAN H" +
	"IEROGLYPH T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HIEROGLYPH U002EGYPTIAN H" +
	"IEROGLYPH U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HIEROGLYPH U005EGYPTIAN H" +
	"IEROGLYPH U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN HIEROGLYPH U006BEGYPTIAN" +
	" HIEROGLYPH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN HIEROGLYPH U009EGYPTIAN" +
	" HIEROGLYPH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN HIEROGLYPH U012EGYPTIAN" +
	" HIEROGLYPH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN HIEROGLYPH U015EGYPTIAN" +
	" HIEROGLYPH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN HIEROGLYPH U018EGYPTIAN" +
	" HIEROGLYPH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN HIEROGLYPH U021EGYPTIAN" +
	" HIEROGLYPH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN HIEROGLYPH U023AEGYPTIA" +
	"N HIEROGLYPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN HIEROGLYPH U026EGYPTIA" +
	"N HIEROGLYPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN HIEROGLYPH U029EGYPTIA" +
	"N HIEROGLYPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIAN HIEROGLYPH U031EGYPTI" +
	"AN HIEROGLYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTIAN HIEROGLYPH U033EGYPT" +
	"IAN HIEROGLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTIAN HIEROGLYPH U036EGYPT" +
	"IAN HIEROGLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTIAN HIEROGLYPH U039EGYPT" +
	"IAN HIEROGLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTIAN HIEROGLYPH U042EGYPT" +
	"IAN HIEROGLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPTIAN HIEROGLYPH V001BEGY" +
	"PTIAN HIEROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEGYPTIAN HIEROGLYPH V001E" +
	"EGYPTIAN HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001GEGYPTIAN HIEROGLYPH V0" +
	"01HEGYPTIAN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V002EGYPTIAN HIEROGLYPH " +
	"V002AEGYPTIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH V004EGYPTIAN HIEROGLYPH" +
	" V005EGYPTIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH V007EGYPTIAN HIEROGLYPH" +
	" V007AEGYPTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYPH V008EGYPTIAN HIEROGLY" +
	"PH V009EGYPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYPH V011EGYPTIAN HIEROGLY" +
	"PH V011AEGYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGLYPH V011CEGYPTIAN HIERO" +
	"GLYPH V012EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIEROGLYPH V012BEGYPTIAN HIE" +
	"ROGLYPH V013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIEROGLYPH V015EGYPTIAN HIE" +
	"ROGLYPH V016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIEROGLYPH V018EGYPTIAN HIE" +
	"ROGLYPH V019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIEROGLYPH V020AEGYPTIAN HI" +
	"EROGLYPH V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN HIEROGLYPH V020DEGYPTIAN" +
	" HIEROGLYPH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIAN HIEROGLYPH V020GEGYPT" +
	"IAN HIEROGLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYPTIAN HIEROGLYPH V020JEG" +
	"YPTIAN HIEROGLYPH V020KEGYPTIAN HIEROGLYPH V020LEGYPTIAN HIEROGLYPH V021" +
	"EGYPTIAN HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023EGYPTIAN HIEROGLYPH V023" +
	"AEGYPTIAN HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025EGYPTIAN HIEROGLYPH V02" +
	"6EGYPTIAN HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028EGYPTIAN HIEROGLYPH V02" +
	"8AEGYPTIAN HIEROGLYPH V029EGYPTIAN HIEROGLYPH V029AEGYPTIAN HIEROGLYPH V" +
	"030EGYPTIAN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V031EGYPTIAN HIEROGLYPH " +
	"V031AEGYPTIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH V033EGYPTIAN HIEROGLYPH" +
	" V033AEGYPTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH V035EGYPTIAN HIEROGLYP" +
	"H V036EGYPTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH V037AEGYPTIAN HIEROGLY" +
	"PH V038EGYPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYPH V040EGYPTIAN HIEROGLY" +
	"PH V040AEGYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLYPH W002EGYPTIAN HIEROGL" +
	"YPH W003EGYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGLYPH W004EGYPTIAN HIEROG" +
	"LYPH W005EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGLYPH W007EGYPTIAN HIEROG" +
	"LYPH W008EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGLYPH W009AEGYPTIAN HIERO" +
	"GLYPH W010EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIEROGLYPH W011EGYPTIAN HIER" +
	"OGLYPH W012EGYPTIAN HIEROGLYPH W013EGYPTIAN HIEROGLYPH W014EGYPTIAN HIER" +
	"OGLYPH W014AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIEROGLYPH W016EGYPTIAN HIE" +
	"ROGLYPH W017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIEROGLYPH W018EGYPTIAN HI" +
	"EROGLYPH W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HIEROGLYPH W020EGYPTIAN H" +
	"IEROGLYPH W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HIEROGLYPH W023EGYPTIAN H" +
	"IEROGLYPH W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN HIEROGLYPH W025EGYPTIAN " +
	"HIEROGLYPH X001EGYPTIAN HIEROGLYPH X002EGYPTIAN HIEROGLYPH X003EGYPTIAN " +
	"HIEROGLYPH X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN HIEROGLYPH X004BEGYPTIA" +
	"N HIEROGLYPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN HIEROGLYPH X006AEGYPTI" +
	"AN HIEROGLYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIAN HIEROGLYPH X008AEGYPT") + ("" +
	"IAN HIEROGLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPTIAN HIEROGLYPH Y002EGYP" +
	"TIAN HIEROGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPTIAN HIEROGLYPH Y005EGYP" +
	"TIAN HIEROGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPTIAN HIEROGLYPH Y008EGYP" +
	"TIAN HIEROGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPTIAN HIEROGLYPH Z002AEGY" +
	"PTIAN HIEROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEGYPTIAN HIEROGLYPH Z002D" +
	"EGYPTIAN HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003AEGYPTIAN HIEROGLYPH Z00" +
	"3BEGYPTIAN HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z004AEGYPTIAN HIEROGLYPH Z" +
	"005EGYPTIAN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z006EGYPTIAN HIEROGLYPH " +
	"Z007EGYPTIAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z009EGYPTIAN HIEROGLYPH " +
	"Z010EGYPTIAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z012EGYPTIAN HIEROGLYPH " +
	"Z013EGYPTIAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z015EGYPTIAN HIEROGLYPH " +
	"Z015AEGYPTIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH Z015CEGYPTIAN HIEROGLY" +
	"PH Z015DEGYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGLYPH Z015FEGYPTIAN HIERO" +
	"GLYPH Z015GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIEROGLYPH Z015IEGYPTIAN HI" +
	"EROGLYPH Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HIEROGLYPH Z016BEGYPTIAN " +
	"HIEROGLYPH Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN HIEROGLYPH Z016EEGYPTI" +
	"AN HIEROGLYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPTIAN HIEROGLYPH Z016HEGY" +
	"PTIAN HIEROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EGYPTIAN HIEROGLYPH AA003" +
	"EGYPTIAN HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA005EGYPTIAN HIEROGLYPH AA" +
	"006EGYPTIAN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH AA007AEGYPTIAN HIEROGLYP" +
	"H AA007BEGYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGLYPH AA009EGYPTIAN HIERO" +
	"GLYPH AA010EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIEROGLYPH AA012EGYPTIAN HI" +
	"EROGLYPH AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN HIEROGLYPH AA015EGYPTIAN" +
	" HIEROGLYPH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIAN HIEROGLYPH AA018EGYPT" +
	"IAN HIEROGLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYPTIAN HIEROGLYPH AA021EG" +
	"YPTIAN HIEROGLYPH AA022EGYPTIAN HIEROGLYPH AA023EGYPTIAN HIEROGLYPH AA02" +
	"4EGYPTIAN HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA026EGYPTIAN HIEROGLYPH A" +
	"A027EGYPTIAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH AA029EGYPTIAN HIEROGLYP" +
	"H AA030EGYPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLYPH AA032ANATOLIAN HIERO" +
	"GLYPH A001ANATOLIAN HIEROGLYPH A002ANATOLIAN HIEROGLYPH A003ANATOLIAN HI" +
	"EROGLYPH A004ANATOLIAN HIEROGLYPH A005ANATOLIAN HIEROGLYPH A006ANATOLIAN" +
	" HIEROGLYPH A007ANATOLIAN HIEROGLYPH A008ANATOLIAN HIEROGLYPH A009ANATOL" +
	"IAN HIEROGLYPH A010ANATOLIAN HIEROGLYPH A010AANATOLIAN HIEROGLYPH A011AN" +
	"ATOLIAN HIEROGLYPH A012ANATOLIAN HIEROGLYPH A013ANATOLIAN HIEROGLYPH A01" +
	"4ANATOLIAN HIEROGLYPH A015ANATOLIAN HIEROGLYPH A016ANATOLIAN HIEROGLYPH " +
	"A017ANATOLIAN HIEROGLYPH A018ANATOLIAN HIEROGLYPH A019ANATOLIAN HIEROGLY" +
	"PH A020ANATOLIAN HIEROGLYPH A021ANATOLIAN HIEROGLYPH A022ANATOLIAN HIERO" +
	"GLYPH A023ANATOLIAN HIEROGLYPH A024ANATOLIAN HIEROGLYPH A025ANATOLIAN HI" +
	"EROGLYPH A026ANATOLIAN HIEROGLYPH A026AANATOLIAN HIEROGLYPH A027ANATOLIA" +
	"N HIEROGLYPH A028ANATOLIAN HIEROGLYPH A029ANATOLIAN HIEROGLYPH A030ANATO" +
	"LIAN HIEROGLYPH A031ANATOLIAN HIEROGLYPH A032ANATOLIAN HIEROGLYPH A033AN" +
	"ATOLIAN HIEROGLYPH A034ANATOLIAN HIEROGLYPH A035ANATOLIAN HIEROGLYPH A03" +
	"6ANATOLIAN HIEROGLYPH A037ANATOLIAN HIEROGLYPH A038ANATOLIAN HIEROGLYPH " +
	"A039ANATOLIAN HIEROGLYPH A039AANATOLIAN HIEROGLYPH A040ANATOLIAN HIEROGL" +
	"YPH A041ANATOLIAN HIEROGLYPH A041AANATOLIAN HIEROGLYPH A042ANATOLIAN HIE" +
	"ROGLYPH A043ANATOLIAN HIEROGLYPH A044ANATOLIAN HIEROGLYPH A045ANATOLIAN " +
	"HIEROGLYPH A045AANATOLIAN HIEROGLYPH A046ANATOLIAN HIEROGLYPH A046AANATO" +
	"LIAN HIEROGLYPH A046BANATOLIAN HIEROGLYPH A047ANATOLIAN HIEROGLYPH A048A" +
	"NATOLIAN HIEROGLYPH A049ANATOLIAN HIEROGLYPH A050ANATOLIAN HIEROGLYPH A0" +
	"51ANATOLIAN HIEROGLYPH A052ANATOLIAN HIEROGLYPH A053ANATOLIAN HIEROGLYPH" +
	" A054ANATOLIAN HIEROGLYPH A055ANATOLIAN HIEROGLYPH A056ANATOLIAN HIEROGL" +
	"YPH A057ANATOLIAN HIEROGLYPH A058ANATOLIAN HIEROGLYPH A059ANATOLIAN HIER" +
	"OGLYPH A060ANATOLIAN HIEROGLYPH A061ANATOLIAN HIEROGLYPH A062ANATOLIAN H" +
	"IEROGLYPH A063ANATOLIAN HIEROGLYPH A064ANATOLIAN HIEROGLYPH A065ANATOLIA" +
	"N HIEROGLYPH A066ANATOLIAN HIEROGLYPH A066AANATOLIAN HIEROGLYPH A066BANA" +
	"TOLIAN HIEROGLYPH A066CANATOLIAN HIEROGLYPH A067ANATOLIAN HIEROGLYPH A06" +
	"8ANATOLIAN HIEROGLYPH A069ANATOLIAN HIEROGLYPH A070ANATOLIAN HIEROGLYPH " +
	"A071ANATOLIAN HIEROGLYPH A072ANATOLIAN HIEROGLYPH A073ANATOLIAN HIEROGLY" +
	"PH A074ANATOLIAN HIEROGLYPH A075ANATOLIAN HIEROGLYPH A076ANATOLIAN HIERO" +
	"GLYPH A077ANATOLIAN HIEROGLYPH A078ANATOLIAN HIEROGLYPH A079ANATOLIAN HI" +
	"EROGLYPH A080ANATOLIAN HIEROGLYPH A081ANATOLIAN HIEROGLYPH A082ANATOLIAN" +
	" HIEROGLYPH A083ANATOLIAN HIEROGLYPH A084ANATOLIAN HIEROGLYPH A085ANATOL" +
	"IAN HIEROGLYPH A086ANATOLIAN HIEROGLYPH A087ANATOLIAN HIEROGLYPH A088ANA" +
	"TOLIAN HIEROGLYPH A089ANATOLIAN HIEROGLYPH A090ANATOLIAN HIEROGLYPH A091") + ("" +
	"ANATOLIAN HIEROGLYPH A092ANATOLIAN HIEROGLYPH A093ANATOLIAN HIEROGLYPH A" +
	"094ANATOLIAN HIEROGLYPH A095ANATOLIAN HIEROGLYPH A096ANATOLIAN HIEROGLYP" +
	"H A097ANATOLIAN HIEROGLYPH A097AANATOLIAN HIEROGLYPH A098ANATOLIAN HIERO" +
	"GLYPH A098AANATOLIAN HIEROGLYPH A099ANATOLIAN HIEROGLYPH A100ANATOLIAN H" +
	"IEROGLYPH A100AANATOLIAN HIEROGLYPH A101ANATOLIAN HIEROGLYPH A101AANATOL" +
	"IAN HIEROGLYPH A102ANATOLIAN HIEROGLYPH A102AANATOLIAN HIEROGLYPH A103AN" +
	"ATOLIAN HIEROGLYPH A104ANATOLIAN HIEROGLYPH A104AANATOLIAN HIEROGLYPH A1" +
	"04BANATOLIAN HIEROGLYPH A104CANATOLIAN HIEROGLYPH A105ANATOLIAN HIEROGLY" +
	"PH A105AANATOLIAN HIEROGLYPH A105BANATOLIAN HIEROGLYPH A106ANATOLIAN HIE" +
	"ROGLYPH A107ANATOLIAN HIEROGLYPH A107AANATOLIAN HIEROGLYPH A107BANATOLIA" +
	"N HIEROGLYPH A107CANATOLIAN HIEROGLYPH A108ANATOLIAN HIEROGLYPH A109ANAT" +
	"OLIAN HIEROGLYPH A110ANATOLIAN HIEROGLYPH A110AANATOLIAN HIEROGLYPH A110" +
	"BANATOLIAN HIEROGLYPH A111ANATOLIAN HIEROGLYPH A112ANATOLIAN HIEROGLYPH " +
	"A113ANATOLIAN HIEROGLYPH A114ANATOLIAN HIEROGLYPH A115ANATOLIAN HIEROGLY" +
	"PH A115AANATOLIAN HIEROGLYPH A116ANATOLIAN HIEROGLYPH A117ANATOLIAN HIER" +
	"OGLYPH A118ANATOLIAN HIEROGLYPH A119ANATOLIAN HIEROGLYPH A120ANATOLIAN H" +
	"IEROGLYPH A121ANATOLIAN HIEROGLYPH A122ANATOLIAN HIEROGLYPH A123ANATOLIA" +
	"N HIEROGLYPH A124ANATOLIAN HIEROGLYPH A125ANATOLIAN HIEROGLYPH A125AANAT" +
	"OLIAN HIEROGLYPH A126ANATOLIAN HIEROGLYPH A127ANATOLIAN HIEROGLYPH A128A" +
	"NATOLIAN HIEROGLYPH A129ANATOLIAN HIEROGLYPH A130ANATOLIAN HIEROGLYPH A1" +
	"31ANATOLIAN HIEROGLYPH A132ANATOLIAN HIEROGLYPH A133ANATOLIAN HIEROGLYPH" +
	" A134ANATOLIAN HIEROGLYPH A135ANATOLIAN HIEROGLYPH A135AANATOLIAN HIEROG" +
	"LYPH A136ANATOLIAN HIEROGLYPH A137ANATOLIAN HIEROGLYPH A138ANATOLIAN HIE" +
	"ROGLYPH A139ANATOLIAN HIEROGLYPH A140ANATOLIAN HIEROGLYPH A141ANATOLIAN " +
	"HIEROGLYPH A142ANATOLIAN HIEROGLYPH A143ANATOLIAN HIEROGLYPH A144ANATOLI" +
	"AN HIEROGLYPH A145ANATOLIAN HIEROGLYPH A146ANATOLIAN HIEROGLYPH A147ANAT" +
	"OLIAN HIEROGLYPH A148ANATOLIAN HIEROGLYPH A149ANATOLIAN HIEROGLYPH A150A" +
	"NATOLIAN HIEROGLYPH A151ANATOLIAN HIEROGLYPH A152ANATOLIAN HIEROGLYPH A1" +
	"53ANATOLIAN HIEROGLYPH A154ANATOLIAN HIEROGLYPH A155ANATOLIAN HIEROGLYPH" +
	" A156ANATOLIAN HIEROGLYPH A157ANATOLIAN HIEROGLYPH A158ANATOLIAN HIEROGL" +
	"YPH A159ANATOLIAN HIEROGLYPH A160ANATOLIAN HIEROGLYPH A161ANATOLIAN HIER" +
	"OGLYPH A162ANATOLIAN HIEROGLYPH A163ANATOLIAN HIEROGLYPH A164ANATOLIAN H" +
	"IEROGLYPH A165ANATOLIAN HIEROGLYPH A166ANATOLIAN HIEROGLYPH A167ANATOLIA" +
	"N HIEROGLYPH A168ANATOLIAN HIEROGLYPH A169ANATOLIAN HIEROGLYPH A170ANATO" +
	"LIAN HIEROGLYPH A171ANATOLIAN HIEROGLYPH A172ANATOLIAN HIEROGLYPH A173AN" +
	"ATOLIAN HIEROGLYPH A174ANATOLIAN HIEROGLYPH A175ANATOLIAN HIEROGLYPH A17" +
	"6ANATOLIAN HIEROGLYPH A177ANATOLIAN HIEROGLYPH A178ANATOLIAN HIEROGLYPH " +
	"A179ANATOLIAN HIEROGLYPH A180ANATOLIAN HIEROGLYPH A181ANATOLIAN HIEROGLY" +
	"PH A182ANATOLIAN HIEROGLYPH A183ANATOLIAN HIEROGLYPH A184ANATOLIAN HIERO" +
	"GLYPH A185ANATOLIAN HIEROGLYPH A186ANATOLIAN HIEROGLYPH A187ANATOLIAN HI" +
	"EROGLYPH A188ANATOLIAN HIEROGLYPH A189ANATOLIAN HIEROGLYPH A190ANATOLIAN" +
	" HIEROGLYPH A191ANATOLIAN HIEROGLYPH A192ANATOLIAN HIEROGLYPH A193ANATOL" +
	"IAN HIEROGLYPH A194ANATOLIAN HIEROGLYPH A195ANATOLIAN HIEROGLYPH A196ANA" +
	"TOLIAN HIEROGLYPH A197ANATOLIAN HIEROGLYPH A198ANATOLIAN HIEROGLYPH A199" +
	"ANATOLIAN HIEROGLYPH A200ANATOLIAN HIEROGLYPH A201ANATOLIAN HIEROGLYPH A" +
	"202ANATOLIAN HIEROGLYPH A202AANATOLIAN HIEROGLYPH A202BANATOLIAN HIEROGL" +
	"YPH A203ANATOLIAN HIEROGLYPH A204ANATOLIAN HIEROGLYPH A205ANATOLIAN HIER" +
	"OGLYPH A206ANATOLIAN HIEROGLYPH A207ANATOLIAN HIEROGLYPH A207AANATOLIAN " +
	"HIEROGLYPH A208ANATOLIAN HIEROGLYPH A209ANATOLIAN HIEROGLYPH A209AANATOL" +
	"IAN HIEROGLYPH A210ANATOLIAN HIEROGLYPH A211ANATOLIAN HIEROGLYPH A212ANA" +
	"TOLIAN HIEROGLYPH A213ANATOLIAN HIEROGLYPH A214ANATOLIAN HIEROGLYPH A215" +
	"ANATOLIAN HIEROGLYPH A215AANATOLIAN HIEROGLYPH A216ANATOLIAN HIEROGLYPH " +
	"A216AANATOLIAN HIEROGLYPH A217ANATOLIAN HIEROGLYPH A218ANATOLIAN HIEROGL" +
	"YPH A219ANATOLIAN HIEROGLYPH A220ANATOLIAN HIEROGLYPH A221ANATOLIAN HIER" +
	"OGLYPH A222ANATOLIAN HIEROGLYPH A223ANATOLIAN HIEROGLYPH A224ANATOLIAN H" +
	"IEROGLYPH A225ANATOLIAN HIEROGLYPH A226ANATOLIAN HIEROGLYPH A227ANATOLIA" +
	"N HIEROGLYPH A227AANATOLIAN HIEROGLYPH A228ANATOLIAN HIEROGLYPH A229ANAT" +
	"OLIAN HIEROGLYPH A230ANATOLIAN HIEROGLYPH A231ANATOLIAN HIEROGLYPH A232A" +
	"NATOLIAN HIEROGLYPH A233ANATOLIAN HIEROGLYPH A234ANATOLIAN HIEROGLYPH A2" +
	"35ANATOLIAN HIEROGLYPH A236ANATOLIAN HIEROGLYPH A237ANATOLIAN HIEROGLYPH" +
	" A238ANATOLIAN HIEROGLYPH A239ANATOLIAN HIEROGLYPH A240ANATOLIAN HIEROGL" +
	"YPH A241ANATOLIAN HIEROGLYPH A242ANATOLIAN HIEROGLYPH A243ANATOLIAN HIER" +
	"OGLYPH A244ANATOLIAN HIEROGLYPH A245ANATOLIAN HIEROGLYPH A246ANATOLIAN H" +
	"IEROGLYPH A247ANATOLIAN HIEROGLYPH A248ANATOLIAN HIEROGLYPH A249ANATOLIA") + ("" +
	"N HIEROGLYPH A250ANATOLIAN HIEROGLYPH A251ANATOLIAN HIEROGLYPH A252ANATO" +
	"LIAN HIEROGLYPH A253ANATOLIAN HIEROGLYPH A254ANATOLIAN HIEROGLYPH A255AN" +
	"ATOLIAN HIEROGLYPH A256ANATOLIAN HIEROGLYPH A257ANATOLIAN HIEROGLYPH A25" +
	"8ANATOLIAN HIEROGLYPH A259ANATOLIAN HIEROGLYPH A260ANATOLIAN HIEROGLYPH " +
	"A261ANATOLIAN HIEROGLYPH A262ANATOLIAN HIEROGLYPH A263ANATOLIAN HIEROGLY" +
	"PH A264ANATOLIAN HIEROGLYPH A265ANATOLIAN HIEROGLYPH A266ANATOLIAN HIERO" +
	"GLYPH A267ANATOLIAN HIEROGLYPH A267AANATOLIAN HIEROGLYPH A268ANATOLIAN H" +
	"IEROGLYPH A269ANATOLIAN HIEROGLYPH A270ANATOLIAN HIEROGLYPH A271ANATOLIA" +
	"N HIEROGLYPH A272ANATOLIAN HIEROGLYPH A273ANATOLIAN HIEROGLYPH A274ANATO" +
	"LIAN HIEROGLYPH A275ANATOLIAN HIEROGLYPH A276ANATOLIAN HIEROGLYPH A277AN" +
	"ATOLIAN HIEROGLYPH A278ANATOLIAN HIEROGLYPH A279ANATOLIAN HIEROGLYPH A28" +
	"0ANATOLIAN HIEROGLYPH A281ANATOLIAN HIEROGLYPH A282ANATOLIAN HIEROGLYPH " +
	"A283ANATOLIAN HIEROGLYPH A284ANATOLIAN HIEROGLYPH A285ANATOLIAN HIEROGLY" +
	"PH A286ANATOLIAN HIEROGLYPH A287ANATOLIAN HIEROGLYPH A288ANATOLIAN HIERO" +
	"GLYPH A289ANATOLIAN HIEROGLYPH A289AANATOLIAN HIEROGLYPH A290ANATOLIAN H" +
	"IEROGLYPH A291ANATOLIAN HIEROGLYPH A292ANATOLIAN HIEROGLYPH A293ANATOLIA" +
	"N HIEROGLYPH A294ANATOLIAN HIEROGLYPH A294AANATOLIAN HIEROGLYPH A295ANAT" +
	"OLIAN HIEROGLYPH A296ANATOLIAN HIEROGLYPH A297ANATOLIAN HIEROGLYPH A298A" +
	"NATOLIAN HIEROGLYPH A299ANATOLIAN HIEROGLYPH A299AANATOLIAN HIEROGLYPH A" +
	"300ANATOLIAN HIEROGLYPH A301ANATOLIAN HIEROGLYPH A302ANATOLIAN HIEROGLYP" +
	"H A303ANATOLIAN HIEROGLYPH A304ANATOLIAN HIEROGLYPH A305ANATOLIAN HIEROG" +
	"LYPH A306ANATOLIAN HIEROGLYPH A307ANATOLIAN HIEROGLYPH A308ANATOLIAN HIE" +
	"ROGLYPH A309ANATOLIAN HIEROGLYPH A309AANATOLIAN HIEROGLYPH A310ANATOLIAN" +
	" HIEROGLYPH A311ANATOLIAN HIEROGLYPH A312ANATOLIAN HIEROGLYPH A313ANATOL" +
	"IAN HIEROGLYPH A314ANATOLIAN HIEROGLYPH A315ANATOLIAN HIEROGLYPH A316ANA" +
	"TOLIAN HIEROGLYPH A317ANATOLIAN HIEROGLYPH A318ANATOLIAN HIEROGLYPH A319" +
	"ANATOLIAN HIEROGLYPH A320ANATOLIAN HIEROGLYPH A321ANATOLIAN HIEROGLYPH A" +
	"322ANATOLIAN HIEROGLYPH A323ANATOLIAN HIEROGLYPH A324ANATOLIAN HIEROGLYP" +
	"H A325ANATOLIAN HIEROGLYPH A326ANATOLIAN HIEROGLYPH A327ANATOLIAN HIEROG" +
	"LYPH A328ANATOLIAN HIEROGLYPH A329ANATOLIAN HIEROGLYPH A329AANATOLIAN HI" +
	"EROGLYPH A330ANATOLIAN HIEROGLYPH A331ANATOLIAN HIEROGLYPH A332AANATOLIA" +
	"N HIEROGLYPH A332BANATOLIAN HIEROGLYPH A332CANATOLIAN HIEROGLYPH A333ANA" +
	"TOLIAN HIEROGLYPH A334ANATOLIAN HIEROGLYPH A335ANATOLIAN HIEROGLYPH A336" +
	"ANATOLIAN HIEROGLYPH A336AANATOLIAN HIEROGLYPH A336BANATOLIAN HIEROGLYPH" +
	" A336CANATOLIAN HIEROGLYPH A337ANATOLIAN HIEROGLYPH A338ANATOLIAN HIEROG" +
	"LYPH A339ANATOLIAN HIEROGLYPH A340ANATOLIAN HIEROGLYPH A341ANATOLIAN HIE" +
	"ROGLYPH A342ANATOLIAN HIEROGLYPH A343ANATOLIAN HIEROGLYPH A344ANATOLIAN " +
	"HIEROGLYPH A345ANATOLIAN HIEROGLYPH A346ANATOLIAN HIEROGLYPH A347ANATOLI" +
	"AN HIEROGLYPH A348ANATOLIAN HIEROGLYPH A349ANATOLIAN HIEROGLYPH A350ANAT" +
	"OLIAN HIEROGLYPH A351ANATOLIAN HIEROGLYPH A352ANATOLIAN HIEROGLYPH A353A" +
	"NATOLIAN HIEROGLYPH A354ANATOLIAN HIEROGLYPH A355ANATOLIAN HIEROGLYPH A3" +
	"56ANATOLIAN HIEROGLYPH A357ANATOLIAN HIEROGLYPH A358ANATOLIAN HIEROGLYPH" +
	" A359ANATOLIAN HIEROGLYPH A359AANATOLIAN HIEROGLYPH A360ANATOLIAN HIEROG" +
	"LYPH A361ANATOLIAN HIEROGLYPH A362ANATOLIAN HIEROGLYPH A363ANATOLIAN HIE" +
	"ROGLYPH A364ANATOLIAN HIEROGLYPH A364AANATOLIAN HIEROGLYPH A365ANATOLIAN" +
	" HIEROGLYPH A366ANATOLIAN HIEROGLYPH A367ANATOLIAN HIEROGLYPH A368ANATOL" +
	"IAN HIEROGLYPH A368AANATOLIAN HIEROGLYPH A369ANATOLIAN HIEROGLYPH A370AN" +
	"ATOLIAN HIEROGLYPH A371ANATOLIAN HIEROGLYPH A371AANATOLIAN HIEROGLYPH A3" +
	"72ANATOLIAN HIEROGLYPH A373ANATOLIAN HIEROGLYPH A374ANATOLIAN HIEROGLYPH" +
	" A375ANATOLIAN HIEROGLYPH A376ANATOLIAN HIEROGLYPH A377ANATOLIAN HIEROGL" +
	"YPH A378ANATOLIAN HIEROGLYPH A379ANATOLIAN HIEROGLYPH A380ANATOLIAN HIER" +
	"OGLYPH A381ANATOLIAN HIEROGLYPH A381AANATOLIAN HIEROGLYPH A382ANATOLIAN " +
	"HIEROGLYPH A383 RA OR RIANATOLIAN HIEROGLYPH A383AANATOLIAN HIEROGLYPH A" +
	"384ANATOLIAN HIEROGLYPH A385ANATOLIAN HIEROGLYPH A386ANATOLIAN HIEROGLYP" +
	"H A386AANATOLIAN HIEROGLYPH A387ANATOLIAN HIEROGLYPH A388ANATOLIAN HIERO" +
	"GLYPH A389ANATOLIAN HIEROGLYPH A390ANATOLIAN HIEROGLYPH A391ANATOLIAN HI" +
	"EROGLYPH A392ANATOLIAN HIEROGLYPH A393 EIGHTANATOLIAN HIEROGLYPH A394ANA" +
	"TOLIAN HIEROGLYPH A395ANATOLIAN HIEROGLYPH A396ANATOLIAN HIEROGLYPH A397" +
	"ANATOLIAN HIEROGLYPH A398ANATOLIAN HIEROGLYPH A399ANATOLIAN HIEROGLYPH A" +
	"400ANATOLIAN HIEROGLYPH A401ANATOLIAN HIEROGLYPH A402ANATOLIAN HIEROGLYP" +
	"H A403ANATOLIAN HIEROGLYPH A404ANATOLIAN HIEROGLYPH A405ANATOLIAN HIEROG" +
	"LYPH A406ANATOLIAN HIEROGLYPH A407ANATOLIAN HIEROGLYPH A408ANATOLIAN HIE" +
	"ROGLYPH A409ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARKANATOLIAN HIERO" +
	"GLYPH A410A END LOGOGRAM MARKANATOLIAN HIEROGLYPH A411ANATOLIAN HIEROGLY") + ("" +
	"PH A412ANATOLIAN HIEROGLYPH A413ANATOLIAN HIEROGLYPH A414ANATOLIAN HIERO" +
	"GLYPH A415ANATOLIAN HIEROGLYPH A416ANATOLIAN HIEROGLYPH A417ANATOLIAN HI" +
	"EROGLYPH A418ANATOLIAN HIEROGLYPH A419ANATOLIAN HIEROGLYPH A420ANATOLIAN" +
	" HIEROGLYPH A421ANATOLIAN HIEROGLYPH A422ANATOLIAN HIEROGLYPH A423ANATOL" +
	"IAN HIEROGLYPH A424ANATOLIAN HIEROGLYPH A425ANATOLIAN HIEROGLYPH A426ANA" +
	"TOLIAN HIEROGLYPH A427ANATOLIAN HIEROGLYPH A428ANATOLIAN HIEROGLYPH A429" +
	"ANATOLIAN HIEROGLYPH A430ANATOLIAN HIEROGLYPH A431ANATOLIAN HIEROGLYPH A" +
	"432ANATOLIAN HIEROGLYPH A433ANATOLIAN HIEROGLYPH A434ANATOLIAN HIEROGLYP" +
	"H A435ANATOLIAN HIEROGLYPH A436ANATOLIAN HIEROGLYPH A437ANATOLIAN HIEROG" +
	"LYPH A438ANATOLIAN HIEROGLYPH A439ANATOLIAN HIEROGLYPH A440ANATOLIAN HIE" +
	"ROGLYPH A441ANATOLIAN HIEROGLYPH A442ANATOLIAN HIEROGLYPH A443ANATOLIAN " +
	"HIEROGLYPH A444ANATOLIAN HIEROGLYPH A445ANATOLIAN HIEROGLYPH A446ANATOLI" +
	"AN HIEROGLYPH A447ANATOLIAN HIEROGLYPH A448ANATOLIAN HIEROGLYPH A449ANAT" +
	"OLIAN HIEROGLYPH A450ANATOLIAN HIEROGLYPH A450AANATOLIAN HIEROGLYPH A451" +
	"ANATOLIAN HIEROGLYPH A452ANATOLIAN HIEROGLYPH A453ANATOLIAN HIEROGLYPH A" +
	"454ANATOLIAN HIEROGLYPH A455ANATOLIAN HIEROGLYPH A456ANATOLIAN HIEROGLYP" +
	"H A457ANATOLIAN HIEROGLYPH A457AANATOLIAN HIEROGLYPH A458ANATOLIAN HIERO" +
	"GLYPH A459ANATOLIAN HIEROGLYPH A460ANATOLIAN HIEROGLYPH A461ANATOLIAN HI" +
	"EROGLYPH A462ANATOLIAN HIEROGLYPH A463ANATOLIAN HIEROGLYPH A464ANATOLIAN" +
	" HIEROGLYPH A465ANATOLIAN HIEROGLYPH A466ANATOLIAN HIEROGLYPH A467ANATOL" +
	"IAN HIEROGLYPH A468ANATOLIAN HIEROGLYPH A469ANATOLIAN HIEROGLYPH A470ANA" +
	"TOLIAN HIEROGLYPH A471ANATOLIAN HIEROGLYPH A472ANATOLIAN HIEROGLYPH A473" +
	"ANATOLIAN HIEROGLYPH A474ANATOLIAN HIEROGLYPH A475ANATOLIAN HIEROGLYPH A" +
	"476ANATOLIAN HIEROGLYPH A477ANATOLIAN HIEROGLYPH A478ANATOLIAN HIEROGLYP" +
	"H A479ANATOLIAN HIEROGLYPH A480ANATOLIAN HIEROGLYPH A481ANATOLIAN HIEROG" +
	"LYPH A482ANATOLIAN HIEROGLYPH A483ANATOLIAN HIEROGLYPH A484ANATOLIAN HIE" +
	"ROGLYPH A485ANATOLIAN HIEROGLYPH A486ANATOLIAN HIEROGLYPH A487ANATOLIAN " +
	"HIEROGLYPH A488ANATOLIAN HIEROGLYPH A489ANATOLIAN HIEROGLYPH A490ANATOLI" +
	"AN HIEROGLYPH A491ANATOLIAN HIEROGLYPH A492ANATOLIAN HIEROGLYPH A493ANAT" +
	"OLIAN HIEROGLYPH A494ANATOLIAN HIEROGLYPH A495ANATOLIAN HIEROGLYPH A496A" +
	"NATOLIAN HIEROGLYPH A497ANATOLIAN HIEROGLYPH A501ANATOLIAN HIEROGLYPH A5" +
	"02ANATOLIAN HIEROGLYPH A503ANATOLIAN HIEROGLYPH A504ANATOLIAN HIEROGLYPH" +
	" A505ANATOLIAN HIEROGLYPH A506ANATOLIAN HIEROGLYPH A507ANATOLIAN HIEROGL" +
	"YPH A508ANATOLIAN HIEROGLYPH A509ANATOLIAN HIEROGLYPH A510ANATOLIAN HIER" +
	"OGLYPH A511ANATOLIAN HIEROGLYPH A512ANATOLIAN HIEROGLYPH A513ANATOLIAN H" +
	"IEROGLYPH A514ANATOLIAN HIEROGLYPH A515ANATOLIAN HIEROGLYPH A516ANATOLIA" +
	"N HIEROGLYPH A517ANATOLIAN HIEROGLYPH A518ANATOLIAN HIEROGLYPH A519ANATO" +
	"LIAN HIEROGLYPH A520ANATOLIAN HIEROGLYPH A521ANATOLIAN HIEROGLYPH A522AN" +
	"ATOLIAN HIEROGLYPH A523ANATOLIAN HIEROGLYPH A524ANATOLIAN HIEROGLYPH A52" +
	"5ANATOLIAN HIEROGLYPH A526ANATOLIAN HIEROGLYPH A527ANATOLIAN HIEROGLYPH " +
	"A528ANATOLIAN HIEROGLYPH A529ANATOLIAN HIEROGLYPH A530BAMUM LETTER PHASE" +
	"-A NGKUE MFONBAMUM LETTER PHASE-A GBIEE FONBAMUM LETTER PHASE-A PON MFON" +
	" PIPAEMGBIEEBAMUM LETTER PHASE-A PON MFON PIPAEMBABAMUM LETTER PHASE-A N" +
	"AA MFONBAMUM LETTER PHASE-A SHUENSHUETBAMUM LETTER PHASE-A TITA MFONBAMU" +
	"M LETTER PHASE-A NZA MFONBAMUM LETTER PHASE-A SHINDA PA NJIBAMUM LETTER " +
	"PHASE-A PON PA NJI PIPAEMGBIEEBAMUM LETTER PHASE-A PON PA NJI PIPAEMBABA" +
	"MUM LETTER PHASE-A MAEMBGBIEEBAMUM LETTER PHASE-A TU MAEMBABAMUM LETTER " +
	"PHASE-A NGANGUBAMUM LETTER PHASE-A MAEMVEUXBAMUM LETTER PHASE-A MANSUAEB" +
	"AMUM LETTER PHASE-A MVEUAENGAMBAMUM LETTER PHASE-A SEUNYAMBAMUM LETTER P" +
	"HASE-A NTOQPENBAMUM LETTER PHASE-A KEUKEUTNDABAMUM LETTER PHASE-A NKINDI" +
	"BAMUM LETTER PHASE-A SUUBAMUM LETTER PHASE-A NGKUENZEUMBAMUM LETTER PHAS" +
	"E-A LAPAQBAMUM LETTER PHASE-A LET KUTBAMUM LETTER PHASE-A NTAP MFAABAMUM" +
	" LETTER PHASE-A MAEKEUPBAMUM LETTER PHASE-A PASHAEBAMUM LETTER PHASE-A G" +
	"HEUAERAEBAMUM LETTER PHASE-A PAMSHAEBAMUM LETTER PHASE-A MON NGGEUAETBAM" +
	"UM LETTER PHASE-A NZUN MEUTBAMUM LETTER PHASE-A U YUQ NAEBAMUM LETTER PH" +
	"ASE-A GHEUAEGHEUAEBAMUM LETTER PHASE-A NTAP NTAABAMUM LETTER PHASE-A SIS" +
	"ABAMUM LETTER PHASE-A MGBASABAMUM LETTER PHASE-A MEUNJOMNDEUQBAMUM LETTE" +
	"R PHASE-A MOOMPUQBAMUM LETTER PHASE-A KAFABAMUM LETTER PHASE-A PA LEERAE" +
	"WABAMUM LETTER PHASE-A NDA LEERAEWABAMUM LETTER PHASE-A PETBAMUM LETTER " +
	"PHASE-A MAEMKPENBAMUM LETTER PHASE-A NIKABAMUM LETTER PHASE-A PUPBAMUM L" +
	"ETTER PHASE-A TUAEPBAMUM LETTER PHASE-A LUAEPBAMUM LETTER PHASE-A SONJAM" +
	"BAMUM LETTER PHASE-A TEUTEUWENBAMUM LETTER PHASE-A MAENYIBAMUM LETTER PH" +
	"ASE-A KETBAMUM LETTER PHASE-A NDAANGGEUAETBAMUM LETTER PHASE-A KUOQBAMUM" +
	" LETTER PHASE-A MOOMEUTBAMUM LETTER PHASE-A SHUMBAMUM LETTER PHASE-A LOM") + ("" +
	"MAEBAMUM LETTER PHASE-A FIRIBAMUM LETTER PHASE-A ROMBAMUM LETTER PHASE-A" +
	" KPOQBAMUM LETTER PHASE-A SOQBAMUM LETTER PHASE-A MAP PIEETBAMUM LETTER " +
	"PHASE-A SHIRAEBAMUM LETTER PHASE-A NTAPBAMUM LETTER PHASE-A SHOQ NSHUT Y" +
	"UMBAMUM LETTER PHASE-A NYIT MONGKEUAEQBAMUM LETTER PHASE-A PAARAEBAMUM L" +
	"ETTER PHASE-A NKAARAEBAMUM LETTER PHASE-A UNKNOWNBAMUM LETTER PHASE-A NG" +
	"GENBAMUM LETTER PHASE-A MAESIBAMUM LETTER PHASE-A NJAMBAMUM LETTER PHASE" +
	"-A MBANYIBAMUM LETTER PHASE-A NYETBAMUM LETTER PHASE-A TEUAENBAMUM LETTE" +
	"R PHASE-A SOTBAMUM LETTER PHASE-A PAAMBAMUM LETTER PHASE-A NSHIEEBAMUM L" +
	"ETTER PHASE-A MAEMBAMUM LETTER PHASE-A NYIBAMUM LETTER PHASE-A KAQBAMUM " +
	"LETTER PHASE-A NSHABAMUM LETTER PHASE-A VEEBAMUM LETTER PHASE-A LUBAMUM " +
	"LETTER PHASE-A NENBAMUM LETTER PHASE-A NAQBAMUM LETTER PHASE-A MBAQBAMUM" +
	" LETTER PHASE-B NSHUETBAMUM LETTER PHASE-B TU MAEMGBIEEBAMUM LETTER PHAS" +
	"E-B SIEEBAMUM LETTER PHASE-B SET TUBAMUM LETTER PHASE-B LOM NTEUMBAMUM L" +
	"ETTER PHASE-B MBA MAELEEBAMUM LETTER PHASE-B KIEEMBAMUM LETTER PHASE-B Y" +
	"EURAEBAMUM LETTER PHASE-B MBAARAEBAMUM LETTER PHASE-B KAMBAMUM LETTER PH" +
	"ASE-B PEESHIBAMUM LETTER PHASE-B YAFU LEERAEWABAMUM LETTER PHASE-B LAM N" +
	"SHUT NYAMBAMUM LETTER PHASE-B NTIEE SHEUOQBAMUM LETTER PHASE-B NDU NJAAB" +
	"AMUM LETTER PHASE-B GHEUGHEUAEMBAMUM LETTER PHASE-B PITBAMUM LETTER PHAS" +
	"E-B TU NSIEEBAMUM LETTER PHASE-B SHET NJAQBAMUM LETTER PHASE-B SHEUAEQTU" +
	"BAMUM LETTER PHASE-B MFON TEUAEQBAMUM LETTER PHASE-B MBIT MBAAKETBAMUM L" +
	"ETTER PHASE-B NYI NTEUMBAMUM LETTER PHASE-B KEUPUQBAMUM LETTER PHASE-B G" +
	"HEUGHENBAMUM LETTER PHASE-B KEUYEUXBAMUM LETTER PHASE-B LAANAEBAMUM LETT" +
	"ER PHASE-B PARUMBAMUM LETTER PHASE-B VEUMBAMUM LETTER PHASE-B NGKINDI MV" +
	"OPBAMUM LETTER PHASE-B NGGEU MBUBAMUM LETTER PHASE-B WUAETBAMUM LETTER P" +
	"HASE-B SAKEUAEBAMUM LETTER PHASE-B TAAMBAMUM LETTER PHASE-B MEUQBAMUM LE" +
	"TTER PHASE-B NGGUOQBAMUM LETTER PHASE-B NGGUOQ LARGEBAMUM LETTER PHASE-B" +
	" MFIYAQBAMUM LETTER PHASE-B SUEBAMUM LETTER PHASE-B MBEURIBAMUM LETTER P" +
	"HASE-B MONTIEENBAMUM LETTER PHASE-B NYAEMAEBAMUM LETTER PHASE-B PUNGAAMB" +
	"AMUM LETTER PHASE-B MEUT NGGEETBAMUM LETTER PHASE-B FEUXBAMUM LETTER PHA" +
	"SE-B MBUOQBAMUM LETTER PHASE-B FEEBAMUM LETTER PHASE-B KEUAEMBAMUM LETTE" +
	"R PHASE-B MA NJEUAENABAMUM LETTER PHASE-B MA NJUQABAMUM LETTER PHASE-B L" +
	"ETBAMUM LETTER PHASE-B NGGAAMBAMUM LETTER PHASE-B NSENBAMUM LETTER PHASE" +
	"-B MABAMUM LETTER PHASE-B KIQBAMUM LETTER PHASE-B NGOMBAMUM LETTER PHASE" +
	"-C NGKUE MAEMBABAMUM LETTER PHASE-C NZABAMUM LETTER PHASE-C YUMBAMUM LET" +
	"TER PHASE-C WANGKUOQBAMUM LETTER PHASE-C NGGENBAMUM LETTER PHASE-C NDEUA" +
	"EREEBAMUM LETTER PHASE-C NGKAQBAMUM LETTER PHASE-C GHARAEBAMUM LETTER PH" +
	"ASE-C MBEEKEETBAMUM LETTER PHASE-C GBAYIBAMUM LETTER PHASE-C NYIR MKPARA" +
	"Q MEUNBAMUM LETTER PHASE-C NTU MBITBAMUM LETTER PHASE-C MBEUMBAMUM LETTE" +
	"R PHASE-C PIRIEENBAMUM LETTER PHASE-C NDOMBUBAMUM LETTER PHASE-C MBAA CA" +
	"BBAGE-TREEBAMUM LETTER PHASE-C KEUSHEUAEPBAMUM LETTER PHASE-C GHAPBAMUM " +
	"LETTER PHASE-C KEUKAQBAMUM LETTER PHASE-C YU MUOMAEBAMUM LETTER PHASE-C " +
	"NZEUMBAMUM LETTER PHASE-C MBUEBAMUM LETTER PHASE-C NSEUAENBAMUM LETTER P" +
	"HASE-C MBITBAMUM LETTER PHASE-C YEUQBAMUM LETTER PHASE-C KPARAQBAMUM LET" +
	"TER PHASE-C KAABAMUM LETTER PHASE-C SEUXBAMUM LETTER PHASE-C NDIDABAMUM " +
	"LETTER PHASE-C TAASHAEBAMUM LETTER PHASE-C NJUEQBAMUM LETTER PHASE-C TIT" +
	"A YUEBAMUM LETTER PHASE-C SUAETBAMUM LETTER PHASE-C NGGUAEN NYAMBAMUM LE" +
	"TTER PHASE-C VEUXBAMUM LETTER PHASE-C NANSANAQBAMUM LETTER PHASE-C MA KE" +
	"UAERIBAMUM LETTER PHASE-C NTAABAMUM LETTER PHASE-C NGGUONBAMUM LETTER PH" +
	"ASE-C LAPBAMUM LETTER PHASE-C MBIRIEENBAMUM LETTER PHASE-C MGBASAQBAMUM " +
	"LETTER PHASE-C NTEUNGBABAMUM LETTER PHASE-C TEUTEUXBAMUM LETTER PHASE-C " +
	"NGGUMBAMUM LETTER PHASE-C FUEBAMUM LETTER PHASE-C NDEUTBAMUM LETTER PHAS" +
	"E-C NSABAMUM LETTER PHASE-C NSHAQBAMUM LETTER PHASE-C BUNGBAMUM LETTER P" +
	"HASE-C VEUAEPENBAMUM LETTER PHASE-C MBERAEBAMUM LETTER PHASE-C RUBAMUM L" +
	"ETTER PHASE-C NJAEMBAMUM LETTER PHASE-C LAMBAMUM LETTER PHASE-C TITUAEPB" +
	"AMUM LETTER PHASE-C NSUOT NGOMBAMUM LETTER PHASE-C NJEEEEBAMUM LETTER PH" +
	"ASE-C KETBAMUM LETTER PHASE-C NGGUBAMUM LETTER PHASE-C MAESIBAMUM LETTER" +
	" PHASE-C MBUAEMBAMUM LETTER PHASE-C LUBAMUM LETTER PHASE-C KUTBAMUM LETT" +
	"ER PHASE-C NJAMBAMUM LETTER PHASE-C NGOMBAMUM LETTER PHASE-C WUPBAMUM LE" +
	"TTER PHASE-C NGGUEETBAMUM LETTER PHASE-C NSOMBAMUM LETTER PHASE-C NTENBA" +
	"MUM LETTER PHASE-C KUOP NKAARAEBAMUM LETTER PHASE-C NSUNBAMUM LETTER PHA" +
	"SE-C NDAMBAMUM LETTER PHASE-C MA NSIEEBAMUM LETTER PHASE-C YAABAMUM LETT" +
	"ER PHASE-C NDAPBAMUM LETTER PHASE-C SHUEQBAMUM LETTER PHASE-C SETFONBAMU" +
	"M LETTER PHASE-C MBIBAMUM LETTER PHASE-C MAEMBABAMUM LETTER PHASE-C MBAN" +
	"YIBAMUM LETTER PHASE-C KEUSEUXBAMUM LETTER PHASE-C MBEUXBAMUM LETTER PHA") + ("" +
	"SE-C KEUMBAMUM LETTER PHASE-C MBAA PICKETBAMUM LETTER PHASE-C YUWOQBAMUM" +
	" LETTER PHASE-C NJEUXBAMUM LETTER PHASE-C MIEEBAMUM LETTER PHASE-C MUAEB" +
	"AMUM LETTER PHASE-C SHIQBAMUM LETTER PHASE-C KEN LAWBAMUM LETTER PHASE-C" +
	" KEN FATIGUEBAMUM LETTER PHASE-C NGAQBAMUM LETTER PHASE-C NAQBAMUM LETTE" +
	"R PHASE-C LIQBAMUM LETTER PHASE-C PINBAMUM LETTER PHASE-C PENBAMUM LETTE" +
	"R PHASE-C TETBAMUM LETTER PHASE-D MBUOBAMUM LETTER PHASE-D WAPBAMUM LETT" +
	"ER PHASE-D NJIBAMUM LETTER PHASE-D MFONBAMUM LETTER PHASE-D NJIEEBAMUM L" +
	"ETTER PHASE-D LIEEBAMUM LETTER PHASE-D NJEUTBAMUM LETTER PHASE-D NSHEEBA" +
	"MUM LETTER PHASE-D NGGAAMAEBAMUM LETTER PHASE-D NYAMBAMUM LETTER PHASE-D" +
	" WUAENBAMUM LETTER PHASE-D NGKUNBAMUM LETTER PHASE-D SHEEBAMUM LETTER PH" +
	"ASE-D NGKAPBAMUM LETTER PHASE-D KEUAETMEUNBAMUM LETTER PHASE-D TEUTBAMUM" +
	" LETTER PHASE-D SHEUAEBAMUM LETTER PHASE-D NJAPBAMUM LETTER PHASE-D SUEB" +
	"AMUM LETTER PHASE-D KETBAMUM LETTER PHASE-D YAEMMAEBAMUM LETTER PHASE-D " +
	"KUOMBAMUM LETTER PHASE-D SAPBAMUM LETTER PHASE-D MFEUTBAMUM LETTER PHASE" +
	"-D NDEUXBAMUM LETTER PHASE-D MALEERIBAMUM LETTER PHASE-D MEUTBAMUM LETTE" +
	"R PHASE-D SEUAEQBAMUM LETTER PHASE-D YENBAMUM LETTER PHASE-D NJEUAEMBAMU" +
	"M LETTER PHASE-D KEUOT MBUAEBAMUM LETTER PHASE-D NGKEURIBAMUM LETTER PHA" +
	"SE-D TUBAMUM LETTER PHASE-D GHAABAMUM LETTER PHASE-D NGKYEEBAMUM LETTER " +
	"PHASE-D FEUFEUAETBAMUM LETTER PHASE-D NDEEBAMUM LETTER PHASE-D MGBOFUMBA" +
	"MUM LETTER PHASE-D LEUAEPBAMUM LETTER PHASE-D NDONBAMUM LETTER PHASE-D M" +
	"ONIBAMUM LETTER PHASE-D MGBEUNBAMUM LETTER PHASE-D PUUTBAMUM LETTER PHAS" +
	"E-D MGBIEEBAMUM LETTER PHASE-D MFOBAMUM LETTER PHASE-D LUMBAMUM LETTER P" +
	"HASE-D NSIEEPBAMUM LETTER PHASE-D MBAABAMUM LETTER PHASE-D KWAETBAMUM LE" +
	"TTER PHASE-D NYETBAMUM LETTER PHASE-D TEUAENBAMUM LETTER PHASE-D SOTBAMU" +
	"M LETTER PHASE-D YUWOQBAMUM LETTER PHASE-D KEUMBAMUM LETTER PHASE-D RAEM" +
	"BAMUM LETTER PHASE-D TEEEEBAMUM LETTER PHASE-D NGKEUAEQBAMUM LETTER PHAS" +
	"E-D MFEUAEBAMUM LETTER PHASE-D NSIEETBAMUM LETTER PHASE-D KEUPBAMUM LETT" +
	"ER PHASE-D PIPBAMUM LETTER PHASE-D PEUTAEBAMUM LETTER PHASE-D NYUEBAMUM " +
	"LETTER PHASE-D LETBAMUM LETTER PHASE-D NGGAAMBAMUM LETTER PHASE-D MFIEEB" +
	"AMUM LETTER PHASE-D NGGWAENBAMUM LETTER PHASE-D YUOMBAMUM LETTER PHASE-D" +
	" PAPBAMUM LETTER PHASE-D YUOPBAMUM LETTER PHASE-D NDAMBAMUM LETTER PHASE" +
	"-D NTEUMBAMUM LETTER PHASE-D SUAEBAMUM LETTER PHASE-D KUNBAMUM LETTER PH" +
	"ASE-D NGGEUXBAMUM LETTER PHASE-D NGKIEEBAMUM LETTER PHASE-D TUOTBAMUM LE" +
	"TTER PHASE-D MEUNBAMUM LETTER PHASE-D KUQBAMUM LETTER PHASE-D NSUMBAMUM " +
	"LETTER PHASE-D TEUNBAMUM LETTER PHASE-D MAENJETBAMUM LETTER PHASE-D NGGA" +
	"PBAMUM LETTER PHASE-D LEUMBAMUM LETTER PHASE-D NGGUOMBAMUM LETTER PHASE-" +
	"D NSHUTBAMUM LETTER PHASE-D NJUEQBAMUM LETTER PHASE-D GHEUAEBAMUM LETTER" +
	" PHASE-D KUBAMUM LETTER PHASE-D REN OLDBAMUM LETTER PHASE-D TAEBAMUM LET" +
	"TER PHASE-D TOQBAMUM LETTER PHASE-D NYIBAMUM LETTER PHASE-D RIIBAMUM LET" +
	"TER PHASE-D LEEEEBAMUM LETTER PHASE-D MEEEEBAMUM LETTER PHASE-D MBAMUM L" +
	"ETTER PHASE-D SUUBAMUM LETTER PHASE-D MUBAMUM LETTER PHASE-D SHIIBAMUM L" +
	"ETTER PHASE-D SHEUXBAMUM LETTER PHASE-D KYEEBAMUM LETTER PHASE-D NUBAMUM" +
	" LETTER PHASE-D SHUBAMUM LETTER PHASE-D NTEEBAMUM LETTER PHASE-D PEEBAMU" +
	"M LETTER PHASE-D NIBAMUM LETTER PHASE-D SHOQBAMUM LETTER PHASE-D PUQBAMU" +
	"M LETTER PHASE-D MVOPBAMUM LETTER PHASE-D LOQBAMUM LETTER PHASE-D REN MU" +
	"CHBAMUM LETTER PHASE-D TIBAMUM LETTER PHASE-D NTUUBAMUM LETTER PHASE-D M" +
	"BAA SEVENBAMUM LETTER PHASE-D SAQBAMUM LETTER PHASE-D FAABAMUM LETTER PH" +
	"ASE-E NDAPBAMUM LETTER PHASE-E TOONBAMUM LETTER PHASE-E MBEUMBAMUM LETTE" +
	"R PHASE-E LAPBAMUM LETTER PHASE-E VOMBAMUM LETTER PHASE-E LOONBAMUM LETT" +
	"ER PHASE-E PAABAMUM LETTER PHASE-E SOMBAMUM LETTER PHASE-E RAQBAMUM LETT" +
	"ER PHASE-E NSHUOPBAMUM LETTER PHASE-E NDUNBAMUM LETTER PHASE-E PUAEBAMUM" +
	" LETTER PHASE-E TAMBAMUM LETTER PHASE-E NGKABAMUM LETTER PHASE-E KPEUXBA" +
	"MUM LETTER PHASE-E WUOBAMUM LETTER PHASE-E SEEBAMUM LETTER PHASE-E NGGEU" +
	"AETBAMUM LETTER PHASE-E PAAMBAMUM LETTER PHASE-E TOOBAMUM LETTER PHASE-E" +
	" KUOPBAMUM LETTER PHASE-E LOMBAMUM LETTER PHASE-E NSHIEEBAMUM LETTER PHA" +
	"SE-E NGOPBAMUM LETTER PHASE-E MAEMBAMUM LETTER PHASE-E NGKEUXBAMUM LETTE" +
	"R PHASE-E NGOQBAMUM LETTER PHASE-E NSHUEBAMUM LETTER PHASE-E RIMGBABAMUM" +
	" LETTER PHASE-E NJEUXBAMUM LETTER PHASE-E PEEMBAMUM LETTER PHASE-E SAABA" +
	"MUM LETTER PHASE-E NGGURAEBAMUM LETTER PHASE-E MGBABAMUM LETTER PHASE-E " +
	"GHEUXBAMUM LETTER PHASE-E NGKEUAEMBAMUM LETTER PHASE-E NJAEMLIBAMUM LETT" +
	"ER PHASE-E MAPBAMUM LETTER PHASE-E LOOTBAMUM LETTER PHASE-E NGGEEEEBAMUM" +
	" LETTER PHASE-E NDIQBAMUM LETTER PHASE-E TAEN NTEUMBAMUM LETTER PHASE-E " +
	"SETBAMUM LETTER PHASE-E PUMBAMUM LETTER PHASE-E NDAA SOFTNESSBAMUM LETTE" +
	"R PHASE-E NGGUAESHAE NYAMBAMUM LETTER PHASE-E YIEEBAMUM LETTER PHASE-E G") + ("" +
	"HEUNBAMUM LETTER PHASE-E TUAEBAMUM LETTER PHASE-E YEUAEBAMUM LETTER PHAS" +
	"E-E POBAMUM LETTER PHASE-E TUMAEBAMUM LETTER PHASE-E KEUAEBAMUM LETTER P" +
	"HASE-E SUAENBAMUM LETTER PHASE-E TEUAEQBAMUM LETTER PHASE-E VEUAEBAMUM L" +
	"ETTER PHASE-E WEUXBAMUM LETTER PHASE-E LAAMBAMUM LETTER PHASE-E PUBAMUM " +
	"LETTER PHASE-E TAAQBAMUM LETTER PHASE-E GHAAMAEBAMUM LETTER PHASE-E NGEU" +
	"REUTBAMUM LETTER PHASE-E SHEUAEQBAMUM LETTER PHASE-E MGBENBAMUM LETTER P" +
	"HASE-E MBEEBAMUM LETTER PHASE-E NZAQBAMUM LETTER PHASE-E NKOMBAMUM LETTE" +
	"R PHASE-E GBETBAMUM LETTER PHASE-E TUMBAMUM LETTER PHASE-E KUETBAMUM LET" +
	"TER PHASE-E YAPBAMUM LETTER PHASE-E NYI CLEAVERBAMUM LETTER PHASE-E YITB" +
	"AMUM LETTER PHASE-E MFEUQBAMUM LETTER PHASE-E NDIAQBAMUM LETTER PHASE-E " +
	"PIEEQBAMUM LETTER PHASE-E YUEQBAMUM LETTER PHASE-E LEUAEMBAMUM LETTER PH" +
	"ASE-E FUEBAMUM LETTER PHASE-E GBEUXBAMUM LETTER PHASE-E NGKUPBAMUM LETTE" +
	"R PHASE-E KETBAMUM LETTER PHASE-E MAEBAMUM LETTER PHASE-E NGKAAMIBAMUM L" +
	"ETTER PHASE-E GHETBAMUM LETTER PHASE-E FABAMUM LETTER PHASE-E NTUMBAMUM " +
	"LETTER PHASE-E PEUTBAMUM LETTER PHASE-E YEUMBAMUM LETTER PHASE-E NGGEUAE" +
	"BAMUM LETTER PHASE-E NYI BETWEENBAMUM LETTER PHASE-E NZUQBAMUM LETTER PH" +
	"ASE-E POONBAMUM LETTER PHASE-E MIEEBAMUM LETTER PHASE-E FUETBAMUM LETTER" +
	" PHASE-E NAEBAMUM LETTER PHASE-E MUAEBAMUM LETTER PHASE-E GHEUAEBAMUM LE" +
	"TTER PHASE-E FU IBAMUM LETTER PHASE-E MVIBAMUM LETTER PHASE-E PUAQBAMUM " +
	"LETTER PHASE-E NGKUMBAMUM LETTER PHASE-E KUTBAMUM LETTER PHASE-E PIETBAM" +
	"UM LETTER PHASE-E NTAPBAMUM LETTER PHASE-E YEUAETBAMUM LETTER PHASE-E NG" +
	"GUPBAMUM LETTER PHASE-E PA PEOPLEBAMUM LETTER PHASE-E FU CALLBAMUM LETTE" +
	"R PHASE-E FOMBAMUM LETTER PHASE-E NJEEBAMUM LETTER PHASE-E ABAMUM LETTER" +
	" PHASE-E TOQBAMUM LETTER PHASE-E OBAMUM LETTER PHASE-E IBAMUM LETTER PHA" +
	"SE-E LAQBAMUM LETTER PHASE-E PA PLURALBAMUM LETTER PHASE-E TAABAMUM LETT" +
	"ER PHASE-E TAQBAMUM LETTER PHASE-E NDAA MY HOUSEBAMUM LETTER PHASE-E SHI" +
	"QBAMUM LETTER PHASE-E YEUXBAMUM LETTER PHASE-E NGUAEBAMUM LETTER PHASE-E" +
	" YUAENBAMUM LETTER PHASE-E YOQ SWIMMINGBAMUM LETTER PHASE-E YOQ COVERBAM" +
	"UM LETTER PHASE-E YUQBAMUM LETTER PHASE-E YUNBAMUM LETTER PHASE-E KEUXBA" +
	"MUM LETTER PHASE-E PEUXBAMUM LETTER PHASE-E NJEE EPOCHBAMUM LETTER PHASE" +
	"-E PUEBAMUM LETTER PHASE-E WUEBAMUM LETTER PHASE-E FEEBAMUM LETTER PHASE" +
	"-E VEEBAMUM LETTER PHASE-E LUBAMUM LETTER PHASE-E MIBAMUM LETTER PHASE-E" +
	" REUXBAMUM LETTER PHASE-E RAEBAMUM LETTER PHASE-E NGUAETBAMUM LETTER PHA" +
	"SE-E NGABAMUM LETTER PHASE-E SHOBAMUM LETTER PHASE-E SHOQBAMUM LETTER PH" +
	"ASE-E FU REMEDYBAMUM LETTER PHASE-E NABAMUM LETTER PHASE-E PIBAMUM LETTE" +
	"R PHASE-E LOQBAMUM LETTER PHASE-E KOBAMUM LETTER PHASE-E MENBAMUM LETTER" +
	" PHASE-E MABAMUM LETTER PHASE-E MAQBAMUM LETTER PHASE-E TEUBAMUM LETTER " +
	"PHASE-E KIBAMUM LETTER PHASE-E MONBAMUM LETTER PHASE-E TENBAMUM LETTER P" +
	"HASE-E FAQBAMUM LETTER PHASE-E GHOMBAMUM LETTER PHASE-F KABAMUM LETTER P" +
	"HASE-F UBAMUM LETTER PHASE-F KUBAMUM LETTER PHASE-F EEBAMUM LETTER PHASE" +
	"-F REEBAMUM LETTER PHASE-F TAEBAMUM LETTER PHASE-F NYIBAMUM LETTER PHASE" +
	"-F LABAMUM LETTER PHASE-F RIIBAMUM LETTER PHASE-F RIEEBAMUM LETTER PHASE" +
	"-F MEEEEBAMUM LETTER PHASE-F TAABAMUM LETTER PHASE-F NDAABAMUM LETTER PH" +
	"ASE-F NJAEMBAMUM LETTER PHASE-F MBAMUM LETTER PHASE-F SUUBAMUM LETTER PH" +
	"ASE-F SHIIBAMUM LETTER PHASE-F SIBAMUM LETTER PHASE-F SEUXBAMUM LETTER P" +
	"HASE-F KYEEBAMUM LETTER PHASE-F KETBAMUM LETTER PHASE-F NUAEBAMUM LETTER" +
	" PHASE-F NUBAMUM LETTER PHASE-F NJUAEBAMUM LETTER PHASE-F YOQBAMUM LETTE" +
	"R PHASE-F SHUBAMUM LETTER PHASE-F YABAMUM LETTER PHASE-F NSHABAMUM LETTE" +
	"R PHASE-F PEUXBAMUM LETTER PHASE-F NTEEBAMUM LETTER PHASE-F WUEBAMUM LET" +
	"TER PHASE-F PEEBAMUM LETTER PHASE-F RUBAMUM LETTER PHASE-F NIBAMUM LETTE" +
	"R PHASE-F REUXBAMUM LETTER PHASE-F KENBAMUM LETTER PHASE-F NGKWAENBAMUM " +
	"LETTER PHASE-F NGGABAMUM LETTER PHASE-F SHOBAMUM LETTER PHASE-F PUAEBAMU" +
	"M LETTER PHASE-F FOMBAMUM LETTER PHASE-F WABAMUM LETTER PHASE-F LIBAMUM " +
	"LETTER PHASE-F LOQBAMUM LETTER PHASE-F KOBAMUM LETTER PHASE-F MBENBAMUM " +
	"LETTER PHASE-F RENBAMUM LETTER PHASE-F MABAMUM LETTER PHASE-F MOBAMUM LE" +
	"TTER PHASE-F MBAABAMUM LETTER PHASE-F TETBAMUM LETTER PHASE-F KPABAMUM L" +
	"ETTER PHASE-F SAMBABAMUM LETTER PHASE-F VUEQMRO LETTER TAMRO LETTER NGIM" +
	"RO LETTER YOMRO LETTER MIMMRO LETTER BAMRO LETTER DAMRO LETTER AMRO LETT" +
	"ER PHIMRO LETTER KHAIMRO LETTER HAOMRO LETTER DAIMRO LETTER CHUMRO LETTE" +
	"R KEAAEMRO LETTER OLMRO LETTER MAEMMRO LETTER NINMRO LETTER PAMRO LETTER" +
	" OOMRO LETTER OMRO LETTER ROMRO LETTER SHIMRO LETTER THEAMRO LETTER EAMR" +
	"O LETTER WAMRO LETTER EMRO LETTER KOMRO LETTER LANMRO LETTER LAMRO LETTE" +
	"R HAIMRO LETTER RIMRO LETTER TEKMRO DIGIT ZEROMRO DIGIT ONEMRO DIGIT TWO" +
	"MRO DIGIT THREEMRO DIGIT FOURMRO DIGIT FIVEMRO DIGIT SIXMRO DIGIT SEVENM") + ("" +
	"RO DIGIT EIGHTMRO DIGIT NINEMRO DANDAMRO DOUBLE DANDABASSA VAH LETTER EN" +
	"NIBASSA VAH LETTER KABASSA VAH LETTER SEBASSA VAH LETTER FABASSA VAH LET" +
	"TER MBEBASSA VAH LETTER YIEBASSA VAH LETTER GAHBASSA VAH LETTER DHIIBASS" +
	"A VAH LETTER KPAHBASSA VAH LETTER JOBASSA VAH LETTER HWAHBASSA VAH LETTE" +
	"R WABASSA VAH LETTER ZOBASSA VAH LETTER GBUBASSA VAH LETTER DOBASSA VAH " +
	"LETTER CEBASSA VAH LETTER UWUBASSA VAH LETTER TOBASSA VAH LETTER BABASSA" +
	" VAH LETTER VUBASSA VAH LETTER YEINBASSA VAH LETTER PABASSA VAH LETTER W" +
	"ADDABASSA VAH LETTER ABASSA VAH LETTER OBASSA VAH LETTER OOBASSA VAH LET" +
	"TER UBASSA VAH LETTER EEBASSA VAH LETTER EBASSA VAH LETTER IBASSA VAH CO" +
	"MBINING HIGH TONEBASSA VAH COMBINING LOW TONEBASSA VAH COMBINING MID TON" +
	"EBASSA VAH COMBINING LOW-MID TONEBASSA VAH COMBINING HIGH-LOW TONEBASSA " +
	"VAH FULL STOPPAHAWH HMONG VOWEL KEEBPAHAWH HMONG VOWEL KEEVPAHAWH HMONG " +
	"VOWEL KIBPAHAWH HMONG VOWEL KIVPAHAWH HMONG VOWEL KAUBPAHAWH HMONG VOWEL" +
	" KAUVPAHAWH HMONG VOWEL KUBPAHAWH HMONG VOWEL KUVPAHAWH HMONG VOWEL KEBP" +
	"AHAWH HMONG VOWEL KEVPAHAWH HMONG VOWEL KAIBPAHAWH HMONG VOWEL KAIVPAHAW" +
	"H HMONG VOWEL KOOBPAHAWH HMONG VOWEL KOOVPAHAWH HMONG VOWEL KAWBPAHAWH H" +
	"MONG VOWEL KAWVPAHAWH HMONG VOWEL KUABPAHAWH HMONG VOWEL KUAVPAHAWH HMON" +
	"G VOWEL KOBPAHAWH HMONG VOWEL KOVPAHAWH HMONG VOWEL KIABPAHAWH HMONG VOW" +
	"EL KIAVPAHAWH HMONG VOWEL KABPAHAWH HMONG VOWEL KAVPAHAWH HMONG VOWEL KW" +
	"BPAHAWH HMONG VOWEL KWVPAHAWH HMONG VOWEL KAABPAHAWH HMONG VOWEL KAAVPAH" +
	"AWH HMONG CONSONANT VAUPAHAWH HMONG CONSONANT NTSAUPAHAWH HMONG CONSONAN" +
	"T LAUPAHAWH HMONG CONSONANT HAUPAHAWH HMONG CONSONANT NLAUPAHAWH HMONG C" +
	"ONSONANT RAUPAHAWH HMONG CONSONANT NKAUPAHAWH HMONG CONSONANT QHAUPAHAWH" +
	" HMONG CONSONANT YAUPAHAWH HMONG CONSONANT HLAUPAHAWH HMONG CONSONANT MA" +
	"UPAHAWH HMONG CONSONANT CHAUPAHAWH HMONG CONSONANT NCHAUPAHAWH HMONG CON" +
	"SONANT HNAUPAHAWH HMONG CONSONANT PLHAUPAHAWH HMONG CONSONANT NTHAUPAHAW" +
	"H HMONG CONSONANT NAUPAHAWH HMONG CONSONANT AUPAHAWH HMONG CONSONANT XAU" +
	"PAHAWH HMONG CONSONANT CAUPAHAWH HMONG MARK CIM TUBPAHAWH HMONG MARK CIM" +
	" SOPAHAWH HMONG MARK CIM KESPAHAWH HMONG MARK CIM KHAVPAHAWH HMONG MARK " +
	"CIM SUAMPAHAWH HMONG MARK CIM HOMPAHAWH HMONG MARK CIM TAUMPAHAWH HMONG " +
	"SIGN VOS THOMPAHAWH HMONG SIGN VOS TSHAB CEEBPAHAWH HMONG SIGN CIM CHEEM" +
	"PAHAWH HMONG SIGN VOS THIABPAHAWH HMONG SIGN VOS FEEMPAHAWH HMONG SIGN X" +
	"YEEM NTXIVPAHAWH HMONG SIGN XYEEM RHOPAHAWH HMONG SIGN XYEEM TOVPAHAWH H" +
	"MONG SIGN XYEEM FAIBPAHAWH HMONG SIGN VOS SEEVPAHAWH HMONG SIGN MEEJ SUA" +
	"BPAHAWH HMONG SIGN VOS NRUAPAHAWH HMONG SIGN IB YAMPAHAWH HMONG SIGN XAU" +
	"SPAHAWH HMONG SIGN CIM TSOV ROGPAHAWH HMONG DIGIT ZEROPAHAWH HMONG DIGIT" +
	" ONEPAHAWH HMONG DIGIT TWOPAHAWH HMONG DIGIT THREEPAHAWH HMONG DIGIT FOU" +
	"RPAHAWH HMONG DIGIT FIVEPAHAWH HMONG DIGIT SIXPAHAWH HMONG DIGIT SEVENPA" +
	"HAWH HMONG DIGIT EIGHTPAHAWH HMONG DIGIT NINEPAHAWH HMONG NUMBER TENSPAH" +
	"AWH HMONG NUMBER HUNDREDSPAHAWH HMONG NUMBER TEN THOUSANDSPAHAWH HMONG N" +
	"UMBER MILLIONSPAHAWH HMONG NUMBER HUNDRED MILLIONSPAHAWH HMONG NUMBER TE" +
	"N BILLIONSPAHAWH HMONG NUMBER TRILLIONSPAHAWH HMONG SIGN VOS LUBPAHAWH H" +
	"MONG SIGN XYOOPAHAWH HMONG SIGN HLIPAHAWH HMONG SIGN THIRD-STAGE HLIPAHA" +
	"WH HMONG SIGN ZWJ THAJPAHAWH HMONG SIGN HNUBPAHAWH HMONG SIGN NQIGPAHAWH" +
	" HMONG SIGN XIABPAHAWH HMONG SIGN NTUJPAHAWH HMONG SIGN AVPAHAWH HMONG S" +
	"IGN TXHEEJ CEEVPAHAWH HMONG SIGN MEEJ TSEEBPAHAWH HMONG SIGN TAUPAHAWH H" +
	"MONG SIGN LOSPAHAWH HMONG SIGN MUSPAHAWH HMONG SIGN CIM HAIS LUS NTOG NT" +
	"OGPAHAWH HMONG SIGN CIM CUAM TSHOOJPAHAWH HMONG SIGN CIM TXWVPAHAWH HMON" +
	"G SIGN CIM TXWV CHWVPAHAWH HMONG SIGN CIM PUB DAWBPAHAWH HMONG SIGN CIM " +
	"NRES TOSPAHAWH HMONG CLAN SIGN TSHEEJPAHAWH HMONG CLAN SIGN YEEGPAHAWH H" +
	"MONG CLAN SIGN LISPAHAWH HMONG CLAN SIGN LAUJPAHAWH HMONG CLAN SIGN XYOO" +
	"JPAHAWH HMONG CLAN SIGN KOOPAHAWH HMONG CLAN SIGN HAWJPAHAWH HMONG CLAN " +
	"SIGN MUASPAHAWH HMONG CLAN SIGN THOJPAHAWH HMONG CLAN SIGN TSABPAHAWH HM" +
	"ONG CLAN SIGN PHABPAHAWH HMONG CLAN SIGN KHABPAHAWH HMONG CLAN SIGN HAMP" +
	"AHAWH HMONG CLAN SIGN VAJPAHAWH HMONG CLAN SIGN FAJPAHAWH HMONG CLAN SIG" +
	"N YAJPAHAWH HMONG CLAN SIGN TSWBPAHAWH HMONG CLAN SIGN KWMPAHAWH HMONG C" +
	"LAN SIGN VWJMIAO LETTER PAMIAO LETTER BAMIAO LETTER YI PAMIAO LETTER PLA" +
	"MIAO LETTER MAMIAO LETTER MHAMIAO LETTER ARCHAIC MAMIAO LETTER FAMIAO LE" +
	"TTER VAMIAO LETTER VFAMIAO LETTER TAMIAO LETTER DAMIAO LETTER YI TTAMIAO" +
	" LETTER YI TAMIAO LETTER TTAMIAO LETTER DDAMIAO LETTER NAMIAO LETTER NHA" +
	"MIAO LETTER YI NNAMIAO LETTER ARCHAIC NAMIAO LETTER NNAMIAO LETTER NNHAM" +
	"IAO LETTER LAMIAO LETTER LYAMIAO LETTER LHAMIAO LETTER LHYAMIAO LETTER T" +
	"LHAMIAO LETTER DLHAMIAO LETTER TLHYAMIAO LETTER DLHYAMIAO LETTER KAMIAO " +
	"LETTER GAMIAO LETTER YI KAMIAO LETTER QAMIAO LETTER QGAMIAO LETTER NGAMI") + ("" +
	"AO LETTER NGHAMIAO LETTER ARCHAIC NGAMIAO LETTER HAMIAO LETTER XAMIAO LE" +
	"TTER GHAMIAO LETTER GHHAMIAO LETTER TSSAMIAO LETTER DZZAMIAO LETTER NYAM" +
	"IAO LETTER NYHAMIAO LETTER TSHAMIAO LETTER DZHAMIAO LETTER YI TSHAMIAO L" +
	"ETTER YI DZHAMIAO LETTER REFORMED TSHAMIAO LETTER SHAMIAO LETTER SSAMIAO" +
	" LETTER ZHAMIAO LETTER ZSHAMIAO LETTER TSAMIAO LETTER DZAMIAO LETTER YI " +
	"TSAMIAO LETTER SAMIAO LETTER ZAMIAO LETTER ZSAMIAO LETTER ZZAMIAO LETTER" +
	" ZZSAMIAO LETTER ARCHAIC ZZAMIAO LETTER ZZYAMIAO LETTER ZZSYAMIAO LETTER" +
	" WAMIAO LETTER AHMIAO LETTER HHAMIAO LETTER NASALIZATIONMIAO SIGN ASPIRA" +
	"TIONMIAO SIGN REFORMED VOICINGMIAO SIGN REFORMED ASPIRATIONMIAO VOWEL SI" +
	"GN AMIAO VOWEL SIGN AAMIAO VOWEL SIGN AHHMIAO VOWEL SIGN ANMIAO VOWEL SI" +
	"GN ANGMIAO VOWEL SIGN OMIAO VOWEL SIGN OOMIAO VOWEL SIGN WOMIAO VOWEL SI" +
	"GN WMIAO VOWEL SIGN EMIAO VOWEL SIGN ENMIAO VOWEL SIGN ENGMIAO VOWEL SIG" +
	"N OEYMIAO VOWEL SIGN IMIAO VOWEL SIGN IAMIAO VOWEL SIGN IANMIAO VOWEL SI" +
	"GN IANGMIAO VOWEL SIGN IOMIAO VOWEL SIGN IEMIAO VOWEL SIGN IIMIAO VOWEL " +
	"SIGN IUMIAO VOWEL SIGN INGMIAO VOWEL SIGN UMIAO VOWEL SIGN UAMIAO VOWEL " +
	"SIGN UANMIAO VOWEL SIGN UANGMIAO VOWEL SIGN UUMIAO VOWEL SIGN UEIMIAO VO" +
	"WEL SIGN UNGMIAO VOWEL SIGN YMIAO VOWEL SIGN YIMIAO VOWEL SIGN AEMIAO VO" +
	"WEL SIGN AEEMIAO VOWEL SIGN ERRMIAO VOWEL SIGN ROUNDED ERRMIAO VOWEL SIG" +
	"N ERMIAO VOWEL SIGN ROUNDED ERMIAO VOWEL SIGN AIMIAO VOWEL SIGN EIMIAO V" +
	"OWEL SIGN AUMIAO VOWEL SIGN OUMIAO VOWEL SIGN NMIAO VOWEL SIGN NGMIAO TO" +
	"NE RIGHTMIAO TONE TOP RIGHTMIAO TONE ABOVEMIAO TONE BELOWMIAO LETTER TON" +
	"E-2MIAO LETTER TONE-3MIAO LETTER TONE-4MIAO LETTER TONE-5MIAO LETTER TON" +
	"E-6MIAO LETTER TONE-7MIAO LETTER TONE-8MIAO LETTER REFORMED TONE-1MIAO L" +
	"ETTER REFORMED TONE-2MIAO LETTER REFORMED TONE-4MIAO LETTER REFORMED TON" +
	"E-5MIAO LETTER REFORMED TONE-6MIAO LETTER REFORMED TONE-8TANGUT ITERATIO" +
	"N MARKNUSHU ITERATION MARKTANGUT COMPONENT-001TANGUT COMPONENT-002TANGUT" +
	" COMPONENT-003TANGUT COMPONENT-004TANGUT COMPONENT-005TANGUT COMPONENT-0" +
	"06TANGUT COMPONENT-007TANGUT COMPONENT-008TANGUT COMPONENT-009TANGUT COM" +
	"PONENT-010TANGUT COMPONENT-011TANGUT COMPONENT-012TANGUT COMPONENT-013TA" +
	"NGUT COMPONENT-014TANGUT COMPONENT-015TANGUT COMPONENT-016TANGUT COMPONE" +
	"NT-017TANGUT COMPONENT-018TANGUT COMPONENT-019TANGUT COMPONENT-020TANGUT" +
	" COMPONENT-021TANGUT COMPONENT-022TANGUT COMPONENT-023TANGUT COMPONENT-0" +
	"24TANGUT COMPONENT-025TANGUT COMPONENT-026TANGUT COMPONENT-027TANGUT COM" +
	"PONENT-028TANGUT COMPONENT-029TANGUT COMPONENT-030TANGUT COMPONENT-031TA" +
	"NGUT COMPONENT-032TANGUT COMPONENT-033TANGUT COMPONENT-034TANGUT COMPONE" +
	"NT-035TANGUT COMPONENT-036TANGUT COMPONENT-037TANGUT COMPONENT-038TANGUT" +
	" COMPONENT-039TANGUT COMPONENT-040TANGUT COMPONENT-041TANGUT COMPONENT-0" +
	"42TANGUT COMPONENT-043TANGUT COMPONENT-044TANGUT COMPONENT-045TANGUT COM" +
	"PONENT-046TANGUT COMPONENT-047TANGUT COMPONENT-048TANGUT COMPONENT-049TA" +
	"NGUT COMPONENT-050TANGUT COMPONENT-051TANGUT COMPONENT-052TANGUT COMPONE" +
	"NT-053TANGUT COMPONENT-054TANGUT COMPONENT-055TANGUT COMPONENT-056TANGUT" +
	" COMPONENT-057TANGUT COMPONENT-058TANGUT COMPONENT-059TANGUT COMPONENT-0" +
	"60TANGUT COMPONENT-061TANGUT COMPONENT-062TANGUT COMPONENT-063TANGUT COM" +
	"PONENT-064TANGUT COMPONENT-065TANGUT COMPONENT-066TANGUT COMPONENT-067TA" +
	"NGUT COMPONENT-068TANGUT COMPONENT-069TANGUT COMPONENT-070TANGUT COMPONE" +
	"NT-071TANGUT COMPONENT-072TANGUT COMPONENT-073TANGUT COMPONENT-074TANGUT" +
	" COMPONENT-075TANGUT COMPONENT-076TANGUT COMPONENT-077TANGUT COMPONENT-0" +
	"78TANGUT COMPONENT-079TANGUT COMPONENT-080TANGUT COMPONENT-081TANGUT COM" +
	"PONENT-082TANGUT COMPONENT-083TANGUT COMPONENT-084TANGUT COMPONENT-085TA" +
	"NGUT COMPONENT-086TANGUT COMPONENT-087TANGUT COMPONENT-088TANGUT COMPONE" +
	"NT-089TANGUT COMPONENT-090TANGUT COMPONENT-091TANGUT COMPONENT-092TANGUT" +
	" COMPONENT-093TANGUT COMPONENT-094TANGUT COMPONENT-095TANGUT COMPONENT-0" +
	"96TANGUT COMPONENT-097TANGUT COMPONENT-098TANGUT COMPONENT-099TANGUT COM" +
	"PONENT-100TANGUT COMPONENT-101TANGUT COMPONENT-102TANGUT COMPONENT-103TA" +
	"NGUT COMPONENT-104TANGUT COMPONENT-105TANGUT COMPONENT-106TANGUT COMPONE" +
	"NT-107TANGUT COMPONENT-108TANGUT COMPONENT-109TANGUT COMPONENT-110TANGUT" +
	" COMPONENT-111TANGUT COMPONENT-112TANGUT COMPONENT-113TANGUT COMPONENT-1" +
	"14TANGUT COMPONENT-115TANGUT COMPONENT-116TANGUT COMPONENT-117TANGUT COM" +
	"PONENT-118TANGUT COMPONENT-119TANGUT COMPONENT-120TANGUT COMPONENT-121TA" +
	"NGUT COMPONENT-122TANGUT COMPONENT-123TANGUT COMPONENT-124TANGUT COMPONE" +
	"NT-125TANGUT COMPONENT-126TANGUT COMPONENT-127TANGUT COMPONENT-128TANGUT" +
	" COMPONENT-129TANGUT COMPONENT-130TANGUT COMPONENT-131TANGUT COMPONENT-1" +
	"32TANGUT COMPONENT-133TANGUT COMPONENT-134TANGUT COMPONENT-135TANGUT COM" +
	"PONENT-136TANGUT COMPONENT-137TANGUT COMPONENT-138TANGUT COMPONENT-139TA") + ("" +
	"NGUT COMPONENT-140TANGUT COMPONENT-141TANGUT COMPONENT-142TANGUT COMPONE" +
	"NT-143TANGUT COMPONENT-144TANGUT COMPONENT-145TANGUT COMPONENT-146TANGUT" +
	" COMPONENT-147TANGUT COMPONENT-148TANGUT COMPONENT-149TANGUT COMPONENT-1" +
	"50TANGUT COMPONENT-151TANGUT COMPONENT-152TANGUT COMPONENT-153TANGUT COM" +
	"PONENT-154TANGUT COMPONENT-155TANGUT COMPONENT-156TANGUT COMPONENT-157TA" +
	"NGUT COMPONENT-158TANGUT COMPONENT-159TANGUT COMPONENT-160TANGUT COMPONE" +
	"NT-161TANGUT COMPONENT-162TANGUT COMPONENT-163TANGUT COMPONENT-164TANGUT" +
	" COMPONENT-165TANGUT COMPONENT-166TANGUT COMPONENT-167TANGUT COMPONENT-1" +
	"68TANGUT COMPONENT-169TANGUT COMPONENT-170TANGUT COMPONENT-171TANGUT COM" +
	"PONENT-172TANGUT COMPONENT-173TANGUT COMPONENT-174TANGUT COMPONENT-175TA" +
	"NGUT COMPONENT-176TANGUT COMPONENT-177TANGUT COMPONENT-178TANGUT COMPONE" +
	"NT-179TANGUT COMPONENT-180TANGUT COMPONENT-181TANGUT COMPONENT-182TANGUT" +
	" COMPONENT-183TANGUT COMPONENT-184TANGUT COMPONENT-185TANGUT COMPONENT-1" +
	"86TANGUT COMPONENT-187TANGUT COMPONENT-188TANGUT COMPONENT-189TANGUT COM" +
	"PONENT-190TANGUT COMPONENT-191TANGUT COMPONENT-192TANGUT COMPONENT-193TA" +
	"NGUT COMPONENT-194TANGUT COMPONENT-195TANGUT COMPONENT-196TANGUT COMPONE" +
	"NT-197TANGUT COMPONENT-198TANGUT COMPONENT-199TANGUT COMPONENT-200TANGUT" +
	" COMPONENT-201TANGUT COMPONENT-202TANGUT COMPONENT-203TANGUT COMPONENT-2" +
	"04TANGUT COMPONENT-205TANGUT COMPONENT-206TANGUT COMPONENT-207TANGUT COM" +
	"PONENT-208TANGUT COMPONENT-209TANGUT COMPONENT-210TANGUT COMPONENT-211TA" +
	"NGUT COMPONENT-212TANGUT COMPONENT-213TANGUT COMPONENT-214TANGUT COMPONE" +
	"NT-215TANGUT COMPONENT-216TANGUT COMPONENT-217TANGUT COMPONENT-218TANGUT" +
	" COMPONENT-219TANGUT COMPONENT-220TANGUT COMPONENT-221TANGUT COMPONENT-2" +
	"22TANGUT COMPONENT-223TANGUT COMPONENT-224TANGUT COMPONENT-225TANGUT COM" +
	"PONENT-226TANGUT COMPONENT-227TANGUT COMPONENT-228TANGUT COMPONENT-229TA" +
	"NGUT COMPONENT-230TANGUT COMPONENT-231TANGUT COMPONENT-232TANGUT COMPONE" +
	"NT-233TANGUT COMPONENT-234TANGUT COMPONENT-235TANGUT COMPONENT-236TANGUT" +
	" COMPONENT-237TANGUT COMPONENT-238TANGUT COMPONENT-239TANGUT COMPONENT-2" +
	"40TANGUT COMPONENT-241TANGUT COMPONENT-242TANGUT COMPONENT-243TANGUT COM" +
	"PONENT-244TANGUT COMPONENT-245TANGUT COMPONENT-246TANGUT COMPONENT-247TA" +
	"NGUT COMPONENT-248TANGUT COMPONENT-249TANGUT COMPONENT-250TANGUT COMPONE" +
	"NT-251TANGUT COMPONENT-252TANGUT COMPONENT-253TANGUT COMPONENT-254TANGUT" +
	" COMPONENT-255TANGUT COMPONENT-256TANGUT COMPONENT-257TANGUT COMPONENT-2" +
	"58TANGUT COMPONENT-259TANGUT COMPONENT-260TANGUT COMPONENT-261TANGUT COM" +
	"PONENT-262TANGUT COMPONENT-263TANGUT COMPONENT-264TANGUT COMPONENT-265TA" +
	"NGUT COMPONENT-266TANGUT COMPONENT-267TANGUT COMPONENT-268TANGUT COMPONE" +
	"NT-269TANGUT COMPONENT-270TANGUT COMPONENT-271TANGUT COMPONENT-272TANGUT" +
	" COMPONENT-273TANGUT COMPONENT-274TANGUT COMPONENT-275TANGUT COMPONENT-2" +
	"76TANGUT COMPONENT-277TANGUT COMPONENT-278TANGUT COMPONENT-279TANGUT COM" +
	"PONENT-280TANGUT COMPONENT-281TANGUT COMPONENT-282TANGUT COMPONENT-283TA" +
	"NGUT COMPONENT-284TANGUT COMPONENT-285TANGUT COMPONENT-286TANGUT COMPONE" +
	"NT-287TANGUT COMPONENT-288TANGUT COMPONENT-289TANGUT COMPONENT-290TANGUT" +
	" COMPONENT-291TANGUT COMPONENT-292TANGUT COMPONENT-293TANGUT COMPONENT-2" +
	"94TANGUT COMPONENT-295TANGUT COMPONENT-296TANGUT COMPONENT-297TANGUT COM" +
	"PONENT-298TANGUT COMPONENT-299TANGUT COMPONENT-300TANGUT COMPONENT-301TA" +
	"NGUT COMPONENT-302TANGUT COMPONENT-303TANGUT COMPONENT-304TANGUT COMPONE" +
	"NT-305TANGUT COMPONENT-306TANGUT COMPONENT-307TANGUT COMPONENT-308TANGUT" +
	" COMPONENT-309TANGUT COMPONENT-310TANGUT COMPONENT-311TANGUT COMPONENT-3" +
	"12TANGUT COMPONENT-313TANGUT COMPONENT-314TANGUT COMPONENT-315TANGUT COM" +
	"PONENT-316TANGUT COMPONENT-317TANGUT COMPONENT-318TANGUT COMPONENT-319TA" +
	"NGUT COMPONENT-320TANGUT COMPONENT-321TANGUT COMPONENT-322TANGUT COMPONE" +
	"NT-323TANGUT COMPONENT-324TANGUT COMPONENT-325TANGUT COMPONENT-326TANGUT" +
	" COMPONENT-327TANGUT COMPONENT-328TANGUT COMPONENT-329TANGUT COMPONENT-3" +
	"30TANGUT COMPONENT-331TANGUT COMPONENT-332TANGUT COMPONENT-333TANGUT COM" +
	"PONENT-334TANGUT COMPONENT-335TANGUT COMPONENT-336TANGUT COMPONENT-337TA" +
	"NGUT COMPONENT-338TANGUT COMPONENT-339TANGUT COMPONENT-340TANGUT COMPONE" +
	"NT-341TANGUT COMPONENT-342TANGUT COMPONENT-343TANGUT COMPONENT-344TANGUT" +
	" COMPONENT-345TANGUT COMPONENT-346TANGUT COMPONENT-347TANGUT COMPONENT-3" +
	"48TANGUT COMPONENT-349TANGUT COMPONENT-350TANGUT COMPONENT-351TANGUT COM" +
	"PONENT-352TANGUT COMPONENT-353TANGUT COMPONENT-354TANGUT COMPONENT-355TA" +
	"NGUT COMPONENT-356TANGUT COMPONENT-357TANGUT COMPONENT-358TANGUT COMPONE" +
	"NT-359TANGUT COMPONENT-360TANGUT COMPONENT-361TANGUT COMPONENT-362TANGUT" +
	" COMPONENT-363TANGUT COMPONENT-364TANGUT COMPONENT-365TANGUT COMPONENT-3" +
	"66TANGUT COMPONENT-367TANGUT COMPONENT-368TANGUT COMPONENT-369TANGUT COM") + ("" +
	"PONENT-370TANGUT COMPONENT-371TANGUT COMPONENT-372TANGUT COMPONENT-373TA" +
	"NGUT COMPONENT-374TANGUT COMPONENT-375TANGUT COMPONENT-376TANGUT COMPONE" +
	"NT-377TANGUT COMPONENT-378TANGUT COMPONENT-379TANGUT COMPONENT-380TANGUT" +
	" COMPONENT-381TANGUT COMPONENT-382TANGUT COMPONENT-383TANGUT COMPONENT-3" +
	"84TANGUT COMPONENT-385TANGUT COMPONENT-386TANGUT COMPONENT-387TANGUT COM" +
	"PONENT-388TANGUT COMPONENT-389TANGUT COMPONENT-390TANGUT COMPONENT-391TA" +
	"NGUT COMPONENT-392TANGUT COMPONENT-393TANGUT COMPONENT-394TANGUT COMPONE" +
	"NT-395TANGUT COMPONENT-396TANGUT COMPONENT-397TANGUT COMPONENT-398TANGUT" +
	" COMPONENT-399TANGUT COMPONENT-400TANGUT COMPONENT-401TANGUT COMPONENT-4" +
	"02TANGUT COMPONENT-403TANGUT COMPONENT-404TANGUT COMPONENT-405TANGUT COM" +
	"PONENT-406TANGUT COMPONENT-407TANGUT COMPONENT-408TANGUT COMPONENT-409TA" +
	"NGUT COMPONENT-410TANGUT COMPONENT-411TANGUT COMPONENT-412TANGUT COMPONE" +
	"NT-413TANGUT COMPONENT-414TANGUT COMPONENT-415TANGUT COMPONENT-416TANGUT" +
	" COMPONENT-417TANGUT COMPONENT-418TANGUT COMPONENT-419TANGUT COMPONENT-4" +
	"20TANGUT COMPONENT-421TANGUT COMPONENT-422TANGUT COMPONENT-423TANGUT COM" +
	"PONENT-424TANGUT COMPONENT-425TANGUT COMPONENT-426TANGUT COMPONENT-427TA" +
	"NGUT COMPONENT-428TANGUT COMPONENT-429TANGUT COMPONENT-430TANGUT COMPONE" +
	"NT-431TANGUT COMPONENT-432TANGUT COMPONENT-433TANGUT COMPONENT-434TANGUT" +
	" COMPONENT-435TANGUT COMPONENT-436TANGUT COMPONENT-437TANGUT COMPONENT-4" +
	"38TANGUT COMPONENT-439TANGUT COMPONENT-440TANGUT COMPONENT-441TANGUT COM" +
	"PONENT-442TANGUT COMPONENT-443TANGUT COMPONENT-444TANGUT COMPONENT-445TA" +
	"NGUT COMPONENT-446TANGUT COMPONENT-447TANGUT COMPONENT-448TANGUT COMPONE" +
	"NT-449TANGUT COMPONENT-450TANGUT COMPONENT-451TANGUT COMPONENT-452TANGUT" +
	" COMPONENT-453TANGUT COMPONENT-454TANGUT COMPONENT-455TANGUT COMPONENT-4" +
	"56TANGUT COMPONENT-457TANGUT COMPONENT-458TANGUT COMPONENT-459TANGUT COM" +
	"PONENT-460TANGUT COMPONENT-461TANGUT COMPONENT-462TANGUT COMPONENT-463TA" +
	"NGUT COMPONENT-464TANGUT COMPONENT-465TANGUT COMPONENT-466TANGUT COMPONE" +
	"NT-467TANGUT COMPONENT-468TANGUT COMPONENT-469TANGUT COMPONENT-470TANGUT" +
	" COMPONENT-471TANGUT COMPONENT-472TANGUT COMPONENT-473TANGUT COMPONENT-4" +
	"74TANGUT COMPONENT-475TANGUT COMPONENT-476TANGUT COMPONENT-477TANGUT COM" +
	"PONENT-478TANGUT COMPONENT-479TANGUT COMPONENT-480TANGUT COMPONENT-481TA" +
	"NGUT COMPONENT-482TANGUT COMPONENT-483TANGUT COMPONENT-484TANGUT COMPONE" +
	"NT-485TANGUT COMPONENT-486TANGUT COMPONENT-487TANGUT COMPONENT-488TANGUT" +
	" COMPONENT-489TANGUT COMPONENT-490TANGUT COMPONENT-491TANGUT COMPONENT-4" +
	"92TANGUT COMPONENT-493TANGUT COMPONENT-494TANGUT COMPONENT-495TANGUT COM" +
	"PONENT-496TANGUT COMPONENT-497TANGUT COMPONENT-498TANGUT COMPONENT-499TA" +
	"NGUT COMPONENT-500TANGUT COMPONENT-501TANGUT COMPONENT-502TANGUT COMPONE" +
	"NT-503TANGUT COMPONENT-504TANGUT COMPONENT-505TANGUT COMPONENT-506TANGUT" +
	" COMPONENT-507TANGUT COMPONENT-508TANGUT COMPONENT-509TANGUT COMPONENT-5" +
	"10TANGUT COMPONENT-511TANGUT COMPONENT-512TANGUT COMPONENT-513TANGUT COM" +
	"PONENT-514TANGUT COMPONENT-515TANGUT COMPONENT-516TANGUT COMPONENT-517TA" +
	"NGUT COMPONENT-518TANGUT COMPONENT-519TANGUT COMPONENT-520TANGUT COMPONE" +
	"NT-521TANGUT COMPONENT-522TANGUT COMPONENT-523TANGUT COMPONENT-524TANGUT" +
	" COMPONENT-525TANGUT COMPONENT-526TANGUT COMPONENT-527TANGUT COMPONENT-5" +
	"28TANGUT COMPONENT-529TANGUT COMPONENT-530TANGUT COMPONENT-531TANGUT COM" +
	"PONENT-532TANGUT COMPONENT-533TANGUT COMPONENT-534TANGUT COMPONENT-535TA" +
	"NGUT COMPONENT-536TANGUT COMPONENT-537TANGUT COMPONENT-538TANGUT COMPONE" +
	"NT-539TANGUT COMPONENT-540TANGUT COMPONENT-541TANGUT COMPONENT-542TANGUT" +
	" COMPONENT-543TANGUT COMPONENT-544TANGUT COMPONENT-545TANGUT COMPONENT-5" +
	"46TANGUT COMPONENT-547TANGUT COMPONENT-548TANGUT COMPONENT-549TANGUT COM" +
	"PONENT-550TANGUT COMPONENT-551TANGUT COMPONENT-552TANGUT COMPONENT-553TA" +
	"NGUT COMPONENT-554TANGUT COMPONENT-555TANGUT COMPONENT-556TANGUT COMPONE" +
	"NT-557TANGUT COMPONENT-558TANGUT COMPONENT-559TANGUT COMPONENT-560TANGUT" +
	" COMPONENT-561TANGUT COMPONENT-562TANGUT COMPONENT-563TANGUT COMPONENT-5" +
	"64TANGUT COMPONENT-565TANGUT COMPONENT-566TANGUT COMPONENT-567TANGUT COM" +
	"PONENT-568TANGUT COMPONENT-569TANGUT COMPONENT-570TANGUT COMPONENT-571TA" +
	"NGUT COMPONENT-572TANGUT COMPONENT-573TANGUT COMPONENT-574TANGUT COMPONE" +
	"NT-575TANGUT COMPONENT-576TANGUT COMPONENT-577TANGUT COMPONENT-578TANGUT" +
	" COMPONENT-579TANGUT COMPONENT-580TANGUT COMPONENT-581TANGUT COMPONENT-5" +
	"82TANGUT COMPONENT-583TANGUT COMPONENT-584TANGUT COMPONENT-585TANGUT COM" +
	"PONENT-586TANGUT COMPONENT-587TANGUT COMPONENT-588TANGUT COMPONENT-589TA" +
	"NGUT COMPONENT-590TANGUT COMPONENT-591TANGUT COMPONENT-592TANGUT COMPONE" +
	"NT-593TANGUT COMPONENT-594TANGUT COMPONENT-595TANGUT COMPONENT-596TANGUT" +
	" COMPONENT-597TANGUT COMPONENT-598TANGUT COMPONENT-599TANGUT COMPONENT-6") + ("" +
	"00TANGUT COMPONENT-601TANGUT COMPONENT-602TANGUT COMPONENT-603TANGUT COM" +
	"PONENT-604TANGUT COMPONENT-605TANGUT COMPONENT-606TANGUT COMPONENT-607TA" +
	"NGUT COMPONENT-608TANGUT COMPONENT-609TANGUT COMPONENT-610TANGUT COMPONE" +
	"NT-611TANGUT COMPONENT-612TANGUT COMPONENT-613TANGUT COMPONENT-614TANGUT" +
	" COMPONENT-615TANGUT COMPONENT-616TANGUT COMPONENT-617TANGUT COMPONENT-6" +
	"18TANGUT COMPONENT-619TANGUT COMPONENT-620TANGUT COMPONENT-621TANGUT COM" +
	"PONENT-622TANGUT COMPONENT-623TANGUT COMPONENT-624TANGUT COMPONENT-625TA" +
	"NGUT COMPONENT-626TANGUT COMPONENT-627TANGUT COMPONENT-628TANGUT COMPONE" +
	"NT-629TANGUT COMPONENT-630TANGUT COMPONENT-631TANGUT COMPONENT-632TANGUT" +
	" COMPONENT-633TANGUT COMPONENT-634TANGUT COMPONENT-635TANGUT COMPONENT-6" +
	"36TANGUT COMPONENT-637TANGUT COMPONENT-638TANGUT COMPONENT-639TANGUT COM" +
	"PONENT-640TANGUT COMPONENT-641TANGUT COMPONENT-642TANGUT COMPONENT-643TA" +
	"NGUT COMPONENT-644TANGUT COMPONENT-645TANGUT COMPONENT-646TANGUT COMPONE" +
	"NT-647TANGUT COMPONENT-648TANGUT COMPONENT-649TANGUT COMPONENT-650TANGUT" +
	" COMPONENT-651TANGUT COMPONENT-652TANGUT COMPONENT-653TANGUT COMPONENT-6" +
	"54TANGUT COMPONENT-655TANGUT COMPONENT-656TANGUT COMPONENT-657TANGUT COM" +
	"PONENT-658TANGUT COMPONENT-659TANGUT COMPONENT-660TANGUT COMPONENT-661TA" +
	"NGUT COMPONENT-662TANGUT COMPONENT-663TANGUT COMPONENT-664TANGUT COMPONE" +
	"NT-665TANGUT COMPONENT-666TANGUT COMPONENT-667TANGUT COMPONENT-668TANGUT" +
	" COMPONENT-669TANGUT COMPONENT-670TANGUT COMPONENT-671TANGUT COMPONENT-6" +
	"72TANGUT COMPONENT-673TANGUT COMPONENT-674TANGUT COMPONENT-675TANGUT COM" +
	"PONENT-676TANGUT COMPONENT-677TANGUT COMPONENT-678TANGUT COMPONENT-679TA" +
	"NGUT COMPONENT-680TANGUT COMPONENT-681TANGUT COMPONENT-682TANGUT COMPONE" +
	"NT-683TANGUT COMPONENT-684TANGUT COMPONENT-685TANGUT COMPONENT-686TANGUT" +
	" COMPONENT-687TANGUT COMPONENT-688TANGUT COMPONENT-689TANGUT COMPONENT-6" +
	"90TANGUT COMPONENT-691TANGUT COMPONENT-692TANGUT COMPONENT-693TANGUT COM" +
	"PONENT-694TANGUT COMPONENT-695TANGUT COMPONENT-696TANGUT COMPONENT-697TA" +
	"NGUT COMPONENT-698TANGUT COMPONENT-699TANGUT COMPONENT-700TANGUT COMPONE" +
	"NT-701TANGUT COMPONENT-702TANGUT COMPONENT-703TANGUT COMPONENT-704TANGUT" +
	" COMPONENT-705TANGUT COMPONENT-706TANGUT COMPONENT-707TANGUT COMPONENT-7" +
	"08TANGUT COMPONENT-709TANGUT COMPONENT-710TANGUT COMPONENT-711TANGUT COM" +
	"PONENT-712TANGUT COMPONENT-713TANGUT COMPONENT-714TANGUT COMPONENT-715TA" +
	"NGUT COMPONENT-716TANGUT COMPONENT-717TANGUT COMPONENT-718TANGUT COMPONE" +
	"NT-719TANGUT COMPONENT-720TANGUT COMPONENT-721TANGUT COMPONENT-722TANGUT" +
	" COMPONENT-723TANGUT COMPONENT-724TANGUT COMPONENT-725TANGUT COMPONENT-7" +
	"26TANGUT COMPONENT-727TANGUT COMPONENT-728TANGUT COMPONENT-729TANGUT COM" +
	"PONENT-730TANGUT COMPONENT-731TANGUT COMPONENT-732TANGUT COMPONENT-733TA" +
	"NGUT COMPONENT-734TANGUT COMPONENT-735TANGUT COMPONENT-736TANGUT COMPONE" +
	"NT-737TANGUT COMPONENT-738TANGUT COMPONENT-739TANGUT COMPONENT-740TANGUT" +
	" COMPONENT-741TANGUT COMPONENT-742TANGUT COMPONENT-743TANGUT COMPONENT-7" +
	"44TANGUT COMPONENT-745TANGUT COMPONENT-746TANGUT COMPONENT-747TANGUT COM" +
	"PONENT-748TANGUT COMPONENT-749TANGUT COMPONENT-750TANGUT COMPONENT-751TA" +
	"NGUT COMPONENT-752TANGUT COMPONENT-753TANGUT COMPONENT-754TANGUT COMPONE" +
	"NT-755KATAKANA LETTER ARCHAIC EHIRAGANA LETTER ARCHAIC YEHENTAIGANA LETT" +
	"ER A-1HENTAIGANA LETTER A-2HENTAIGANA LETTER A-3HENTAIGANA LETTER A-WOHE" +
	"NTAIGANA LETTER I-1HENTAIGANA LETTER I-2HENTAIGANA LETTER I-3HENTAIGANA " +
	"LETTER I-4HENTAIGANA LETTER U-1HENTAIGANA LETTER U-2HENTAIGANA LETTER U-" +
	"3HENTAIGANA LETTER U-4HENTAIGANA LETTER U-5HENTAIGANA LETTER E-2HENTAIGA" +
	"NA LETTER E-3HENTAIGANA LETTER E-4HENTAIGANA LETTER E-5HENTAIGANA LETTER" +
	" E-6HENTAIGANA LETTER O-1HENTAIGANA LETTER O-2HENTAIGANA LETTER O-3HENTA" +
	"IGANA LETTER KA-1HENTAIGANA LETTER KA-2HENTAIGANA LETTER KA-3HENTAIGANA " +
	"LETTER KA-4HENTAIGANA LETTER KA-5HENTAIGANA LETTER KA-6HENTAIGANA LETTER" +
	" KA-7HENTAIGANA LETTER KA-8HENTAIGANA LETTER KA-9HENTAIGANA LETTER KA-10" +
	"HENTAIGANA LETTER KA-11HENTAIGANA LETTER KA-KEHENTAIGANA LETTER KI-1HENT" +
	"AIGANA LETTER KI-2HENTAIGANA LETTER KI-3HENTAIGANA LETTER KI-4HENTAIGANA" +
	" LETTER KI-5HENTAIGANA LETTER KI-6HENTAIGANA LETTER KI-7HENTAIGANA LETTE" +
	"R KI-8HENTAIGANA LETTER KU-1HENTAIGANA LETTER KU-2HENTAIGANA LETTER KU-3" +
	"HENTAIGANA LETTER KU-4HENTAIGANA LETTER KU-5HENTAIGANA LETTER KU-6HENTAI" +
	"GANA LETTER KU-7HENTAIGANA LETTER KE-1HENTAIGANA LETTER KE-2HENTAIGANA L" +
	"ETTER KE-3HENTAIGANA LETTER KE-4HENTAIGANA LETTER KE-5HENTAIGANA LETTER " +
	"KE-6HENTAIGANA LETTER KO-1HENTAIGANA LETTER KO-2HENTAIGANA LETTER KO-3HE" +
	"NTAIGANA LETTER KO-KIHENTAIGANA LETTER SA-1HENTAIGANA LETTER SA-2HENTAIG" +
	"ANA LETTER SA-3HENTAIGANA LETTER SA-4HENTAIGANA LETTER SA-5HENTAIGANA LE" +
	"TTER SA-6HENTAIGANA LETTER SA-7HENTAIGANA LETTER SA-8HENTAIGANA LETTER S") + ("" +
	"I-1HENTAIGANA LETTER SI-2HENTAIGANA LETTER SI-3HENTAIGANA LETTER SI-4HEN" +
	"TAIGANA LETTER SI-5HENTAIGANA LETTER SI-6HENTAIGANA LETTER SU-1HENTAIGAN" +
	"A LETTER SU-2HENTAIGANA LETTER SU-3HENTAIGANA LETTER SU-4HENTAIGANA LETT" +
	"ER SU-5HENTAIGANA LETTER SU-6HENTAIGANA LETTER SU-7HENTAIGANA LETTER SU-" +
	"8HENTAIGANA LETTER SE-1HENTAIGANA LETTER SE-2HENTAIGANA LETTER SE-3HENTA" +
	"IGANA LETTER SE-4HENTAIGANA LETTER SE-5HENTAIGANA LETTER SO-1HENTAIGANA " +
	"LETTER SO-2HENTAIGANA LETTER SO-3HENTAIGANA LETTER SO-4HENTAIGANA LETTER" +
	" SO-5HENTAIGANA LETTER SO-6HENTAIGANA LETTER SO-7HENTAIGANA LETTER TA-1H" +
	"ENTAIGANA LETTER TA-2HENTAIGANA LETTER TA-3HENTAIGANA LETTER TA-4HENTAIG" +
	"ANA LETTER TI-1HENTAIGANA LETTER TI-2HENTAIGANA LETTER TI-3HENTAIGANA LE" +
	"TTER TI-4HENTAIGANA LETTER TI-5HENTAIGANA LETTER TI-6HENTAIGANA LETTER T" +
	"I-7HENTAIGANA LETTER TU-1HENTAIGANA LETTER TU-2HENTAIGANA LETTER TU-3HEN" +
	"TAIGANA LETTER TU-4HENTAIGANA LETTER TU-TOHENTAIGANA LETTER TE-1HENTAIGA" +
	"NA LETTER TE-2HENTAIGANA LETTER TE-3HENTAIGANA LETTER TE-4HENTAIGANA LET" +
	"TER TE-5HENTAIGANA LETTER TE-6HENTAIGANA LETTER TE-7HENTAIGANA LETTER TE" +
	"-8HENTAIGANA LETTER TE-9HENTAIGANA LETTER TO-1HENTAIGANA LETTER TO-2HENT" +
	"AIGANA LETTER TO-3HENTAIGANA LETTER TO-4HENTAIGANA LETTER TO-5HENTAIGANA" +
	" LETTER TO-6HENTAIGANA LETTER TO-RAHENTAIGANA LETTER NA-1HENTAIGANA LETT" +
	"ER NA-2HENTAIGANA LETTER NA-3HENTAIGANA LETTER NA-4HENTAIGANA LETTER NA-" +
	"5HENTAIGANA LETTER NA-6HENTAIGANA LETTER NA-7HENTAIGANA LETTER NA-8HENTA" +
	"IGANA LETTER NA-9HENTAIGANA LETTER NI-1HENTAIGANA LETTER NI-2HENTAIGANA " +
	"LETTER NI-3HENTAIGANA LETTER NI-4HENTAIGANA LETTER NI-5HENTAIGANA LETTER" +
	" NI-6HENTAIGANA LETTER NI-7HENTAIGANA LETTER NI-TEHENTAIGANA LETTER NU-1" +
	"HENTAIGANA LETTER NU-2HENTAIGANA LETTER NU-3HENTAIGANA LETTER NE-1HENTAI" +
	"GANA LETTER NE-2HENTAIGANA LETTER NE-3HENTAIGANA LETTER NE-4HENTAIGANA L" +
	"ETTER NE-5HENTAIGANA LETTER NE-6HENTAIGANA LETTER NE-KOHENTAIGANA LETTER" +
	" NO-1HENTAIGANA LETTER NO-2HENTAIGANA LETTER NO-3HENTAIGANA LETTER NO-4H" +
	"ENTAIGANA LETTER NO-5HENTAIGANA LETTER HA-1HENTAIGANA LETTER HA-2HENTAIG" +
	"ANA LETTER HA-3HENTAIGANA LETTER HA-4HENTAIGANA LETTER HA-5HENTAIGANA LE" +
	"TTER HA-6HENTAIGANA LETTER HA-7HENTAIGANA LETTER HA-8HENTAIGANA LETTER H" +
	"A-9HENTAIGANA LETTER HA-10HENTAIGANA LETTER HA-11HENTAIGANA LETTER HI-1H" +
	"ENTAIGANA LETTER HI-2HENTAIGANA LETTER HI-3HENTAIGANA LETTER HI-4HENTAIG" +
	"ANA LETTER HI-5HENTAIGANA LETTER HI-6HENTAIGANA LETTER HI-7HENTAIGANA LE" +
	"TTER HU-1HENTAIGANA LETTER HU-2HENTAIGANA LETTER HU-3HENTAIGANA LETTER H" +
	"E-1HENTAIGANA LETTER HE-2HENTAIGANA LETTER HE-3HENTAIGANA LETTER HE-4HEN" +
	"TAIGANA LETTER HE-5HENTAIGANA LETTER HE-6HENTAIGANA LETTER HE-7HENTAIGAN" +
	"A LETTER HO-1HENTAIGANA LETTER HO-2HENTAIGANA LETTER HO-3HENTAIGANA LETT" +
	"ER HO-4HENTAIGANA LETTER HO-5HENTAIGANA LETTER HO-6HENTAIGANA LETTER HO-" +
	"7HENTAIGANA LETTER HO-8HENTAIGANA LETTER MA-1HENTAIGANA LETTER MA-2HENTA" +
	"IGANA LETTER MA-3HENTAIGANA LETTER MA-4HENTAIGANA LETTER MA-5HENTAIGANA " +
	"LETTER MA-6HENTAIGANA LETTER MA-7HENTAIGANA LETTER MI-1HENTAIGANA LETTER" +
	" MI-2HENTAIGANA LETTER MI-3HENTAIGANA LETTER MI-4HENTAIGANA LETTER MI-5H" +
	"ENTAIGANA LETTER MI-6HENTAIGANA LETTER MI-7HENTAIGANA LETTER MU-1HENTAIG" +
	"ANA LETTER MU-2HENTAIGANA LETTER MU-3HENTAIGANA LETTER MU-4HENTAIGANA LE" +
	"TTER ME-1HENTAIGANA LETTER ME-2HENTAIGANA LETTER ME-MAHENTAIGANA LETTER " +
	"MO-1HENTAIGANA LETTER MO-2HENTAIGANA LETTER MO-3HENTAIGANA LETTER MO-4HE" +
	"NTAIGANA LETTER MO-5HENTAIGANA LETTER MO-6HENTAIGANA LETTER YA-1HENTAIGA" +
	"NA LETTER YA-2HENTAIGANA LETTER YA-3HENTAIGANA LETTER YA-4HENTAIGANA LET" +
	"TER YA-5HENTAIGANA LETTER YA-YOHENTAIGANA LETTER YU-1HENTAIGANA LETTER Y" +
	"U-2HENTAIGANA LETTER YU-3HENTAIGANA LETTER YU-4HENTAIGANA LETTER YO-1HEN" +
	"TAIGANA LETTER YO-2HENTAIGANA LETTER YO-3HENTAIGANA LETTER YO-4HENTAIGAN" +
	"A LETTER YO-5HENTAIGANA LETTER YO-6HENTAIGANA LETTER RA-1HENTAIGANA LETT" +
	"ER RA-2HENTAIGANA LETTER RA-3HENTAIGANA LETTER RA-4HENTAIGANA LETTER RI-" +
	"1HENTAIGANA LETTER RI-2HENTAIGANA LETTER RI-3HENTAIGANA LETTER RI-4HENTA" +
	"IGANA LETTER RI-5HENTAIGANA LETTER RI-6HENTAIGANA LETTER RI-7HENTAIGANA " +
	"LETTER RU-1HENTAIGANA LETTER RU-2HENTAIGANA LETTER RU-3HENTAIGANA LETTER" +
	" RU-4HENTAIGANA LETTER RU-5HENTAIGANA LETTER RU-6HENTAIGANA LETTER RE-1H" +
	"ENTAIGANA LETTER RE-2HENTAIGANA LETTER RE-3HENTAIGANA LETTER RE-4HENTAIG" +
	"ANA LETTER RO-1HENTAIGANA LETTER RO-2HENTAIGANA LETTER RO-3HENTAIGANA LE" +
	"TTER RO-4HENTAIGANA LETTER RO-5HENTAIGANA LETTER RO-6HENTAIGANA LETTER W" +
	"A-1HENTAIGANA LETTER WA-2HENTAIGANA LETTER WA-3HENTAIGANA LETTER WA-4HEN" +
	"TAIGANA LETTER WA-5HENTAIGANA LETTER WI-1HENTAIGANA LETTER WI-2HENTAIGAN" +
	"A LETTER WI-3HENTAIGANA LETTER WI-4HENTAIGANA LETTER WI-5HENTAIGANA LETT" +
	"ER WE-1HENTAIGANA LETTER WE-2HENTAIGANA LETTER WE-3HENTAIGANA LETTER WE-") + ("" +
	"4HENTAIGANA LETTER WO-1HENTAIGANA LETTER WO-2HENTAIGANA LETTER WO-3HENTA" +
	"IGANA LETTER WO-4HENTAIGANA LETTER WO-5HENTAIGANA LETTER WO-6HENTAIGANA " +
	"LETTER WO-7HENTAIGANA LETTER N-MU-MO-1HENTAIGANA LETTER N-MU-MO-2NUSHU C" +
	"HARACTER-1B170NUSHU CHARACTER-1B171NUSHU CHARACTER-1B172NUSHU CHARACTER-" +
	"1B173NUSHU CHARACTER-1B174NUSHU CHARACTER-1B175NUSHU CHARACTER-1B176NUSH" +
	"U CHARACTER-1B177NUSHU CHARACTER-1B178NUSHU CHARACTER-1B179NUSHU CHARACT" +
	"ER-1B17ANUSHU CHARACTER-1B17BNUSHU CHARACTER-1B17CNUSHU CHARACTER-1B17DN" +
	"USHU CHARACTER-1B17ENUSHU CHARACTER-1B17FNUSHU CHARACTER-1B180NUSHU CHAR" +
	"ACTER-1B181NUSHU CHARACTER-1B182NUSHU CHARACTER-1B183NUSHU CHARACTER-1B1" +
	"84NUSHU CHARACTER-1B185NUSHU CHARACTER-1B186NUSHU CHARACTER-1B187NUSHU C" +
	"HARACTER-1B188NUSHU CHARACTER-1B189NUSHU CHARACTER-1B18ANUSHU CHARACTER-" +
	"1B18BNUSHU CHARACTER-1B18CNUSHU CHARACTER-1B18DNUSHU CHARACTER-1B18ENUSH" +
	"U CHARACTER-1B18FNUSHU CHARACTER-1B190NUSHU CHARACTER-1B191NUSHU CHARACT" +
	"ER-1B192NUSHU CHARACTER-1B193NUSHU CHARACTER-1B194NUSHU CHARACTER-1B195N" +
	"USHU CHARACTER-1B196NUSHU CHARACTER-1B197NUSHU CHARACTER-1B198NUSHU CHAR" +
	"ACTER-1B199NUSHU CHARACTER-1B19ANUSHU CHARACTER-1B19BNUSHU CHARACTER-1B1" +
	"9CNUSHU CHARACTER-1B19DNUSHU CHARACTER-1B19ENUSHU CHARACTER-1B19FNUSHU C" +
	"HARACTER-1B1A0NUSHU CHARACTER-1B1A1NUSHU CHARACTER-1B1A2NUSHU CHARACTER-" +
	"1B1A3NUSHU CHARACTER-1B1A4NUSHU CHARACTER-1B1A5NUSHU CHARACTER-1B1A6NUSH" +
	"U CHARACTER-1B1A7NUSHU CHARACTER-1B1A8NUSHU CHARACTER-1B1A9NUSHU CHARACT" +
	"ER-1B1AANUSHU CHARACTER-1B1ABNUSHU CHARACTER-1B1ACNUSHU CHARACTER-1B1ADN" +
	"USHU CHARACTER-1B1AENUSHU CHARACTER-1B1AFNUSHU CHARACTER-1B1B0NUSHU CHAR" +
	"ACTER-1B1B1NUSHU CHARACTER-1B1B2NUSHU CHARACTER-1B1B3NUSHU CHARACTER-1B1" +
	"B4NUSHU CHARACTER-1B1B5NUSHU CHARACTER-1B1B6NUSHU CHARACTER-1B1B7NUSHU C" +
	"HARACTER-1B1B8NUSHU CHARACTER-1B1B9NUSHU CHARACTER-1B1BANUSHU CHARACTER-" +
	"1B1BBNUSHU CHARACTER-1B1BCNUSHU CHARACTER-1B1BDNUSHU CHARACTER-1B1BENUSH" +
	"U CHARACTER-1B1BFNUSHU CHARACTER-1B1C0NUSHU CHARACTER-1B1C1NUSHU CHARACT" +
	"ER-1B1C2NUSHU CHARACTER-1B1C3NUSHU CHARACTER-1B1C4NUSHU CHARACTER-1B1C5N" +
	"USHU CHARACTER-1B1C6NUSHU CHARACTER-1B1C7NUSHU CHARACTER-1B1C8NUSHU CHAR" +
	"ACTER-1B1C9NUSHU CHARACTER-1B1CANUSHU CHARACTER-1B1CBNUSHU CHARACTER-1B1" +
	"CCNUSHU CHARACTER-1B1CDNUSHU CHARACTER-1B1CENUSHU CHARACTER-1B1CFNUSHU C" +
	"HARACTER-1B1D0NUSHU CHARACTER-1B1D1NUSHU CHARACTER-1B1D2NUSHU CHARACTER-" +
	"1B1D3NUSHU CHARACTER-1B1D4NUSHU CHARACTER-1B1D5NUSHU CHARACTER-1B1D6NUSH" +
	"U CHARACTER-1B1D7NUSHU CHARACTER-1B1D8NUSHU CHARACTER-1B1D9NUSHU CHARACT" +
	"ER-1B1DANUSHU CHARACTER-1B1DBNUSHU CHARACTER-1B1DCNUSHU CHARACTER-1B1DDN" +
	"USHU CHARACTER-1B1DENUSHU CHARACTER-1B1DFNUSHU CHARACTER-1B1E0NUSHU CHAR" +
	"ACTER-1B1E1NUSHU CHARACTER-1B1E2NUSHU CHARACTER-1B1E3NUSHU CHARACTER-1B1" +
	"E4NUSHU CHARACTER-1B1E5NUSHU CHARACTER-1B1E6NUSHU CHARACTER-1B1E7NUSHU C" +
	"HARACTER-1B1E8NUSHU CHARACTER-1B1E9NUSHU CHARACTER-1B1EANUSHU CHARACTER-" +
	"1B1EBNUSHU CHARACTER-1B1ECNUSHU CHARACTER-1B1EDNUSHU CHARACTER-1B1EENUSH" +
	"U CHARACTER-1B1EFNUSHU CHARACTER-1B1F0NUSHU CHARACTER-1B1F1NUSHU CHARACT" +
	"ER-1B1F2NUSHU CHARACTER-1B1F3NUSHU CHARACTER-1B1F4NUSHU CHARACTER-1B1F5N" +
	"USHU CHARACTER-1B1F6NUSHU CHARACTER-1B1F7NUSHU CHARACTER-1B1F8NUSHU CHAR" +
	"ACTER-1B1F9NUSHU CHARACTER-1B1FANUSHU CHARACTER-1B1FBNUSHU CHARACTER-1B1" +
	"FCNUSHU CHARACTER-1B1FDNUSHU CHARACTER-1B1FENUSHU CHARACTER-1B1FFNUSHU C" +
	"HARACTER-1B200NUSHU CHARACTER-1B201NUSHU CHARACTER-1B202NUSHU CHARACTER-" +
	"1B203NUSHU CHARACTER-1B204NUSHU CHARACTER-1B205NUSHU CHARACTER-1B206NUSH" +
	"U CHARACTER-1B207NUSHU CHARACTER-1B208NUSHU CHARACTER-1B209NUSHU CHARACT" +
	"ER-1B20ANUSHU CHARACTER-1B20BNUSHU CHARACTER-1B20CNUSHU CHARACTER-1B20DN" +
	"USHU CHARACTER-1B20ENUSHU CHARACTER-1B20FNUSHU CHARACTER-1B210NUSHU CHAR" +
	"ACTER-1B211NUSHU CHARACTER-1B212NUSHU CHARACTER-1B213NUSHU CHARACTER-1B2" +
	"14NUSHU CHARACTER-1B215NUSHU CHARACTER-1B216NUSHU CHARACTER-1B217NUSHU C" +
	"HARACTER-1B218NUSHU CHARACTER-1B219NUSHU CHARACTER-1B21ANUSHU CHARACTER-" +
	"1B21BNUSHU CHARACTER-1B21CNUSHU CHARACTER-1B21DNUSHU CHARACTER-1B21ENUSH" +
	"U CHARACTER-1B21FNUSHU CHARACTER-1B220NUSHU CHARACTER-1B221NUSHU CHARACT" +
	"ER-1B222NUSHU CHARACTER-1B223NUSHU CHARACTER-1B224NUSHU CHARACTER-1B225N" +
	"USHU CHARACTER-1B226NUSHU CHARACTER-1B227NUSHU CHARACTER-1B228NUSHU CHAR" +
	"ACTER-1B229NUSHU CHARACTER-1B22ANUSHU CHARACTER-1B22BNUSHU CHARACTER-1B2" +
	"2CNUSHU CHARACTER-1B22DNUSHU CHARACTER-1B22ENUSHU CHARACTER-1B22FNUSHU C" +
	"HARACTER-1B230NUSHU CHARACTER-1B231NUSHU CHARACTER-1B232NUSHU CHARACTER-" +
	"1B233NUSHU CHARACTER-1B234NUSHU CHARACTER-1B235NUSHU CHARACTER-1B236NUSH" +
	"U CHARACTER-1B237NUSHU CHARACTER-1B238NUSHU CHARACTER-1B239NUSHU CHARACT" +
	"ER-1B23ANUSHU CHARACTER-1B23BNUSHU CHARACTER-1B23CNUSHU CHARACTER-1B23DN" +
	"USHU CHARACTER-1B23ENUSHU CHARACTER-1B23FNUSHU CHARACTER-1B240NUSHU CHAR") + ("" +
	"ACTER-1B241NUSHU CHARACTER-1B242NUSHU CHARACTER-1B243NUSHU CHARACTER-1B2" +
	"44NUSHU CHARACTER-1B245NUSHU CHARACTER-1B246NUSHU CHARACTER-1B247NUSHU C" +
	"HARACTER-1B248NUSHU CHARACTER-1B249NUSHU CHARACTER-1B24ANUSHU CHARACTER-" +
	"1B24BNUSHU CHARACTER-1B24CNUSHU CHARACTER-1B24DNUSHU CHARACTER-1B24ENUSH" +
	"U CHARACTER-1B24FNUSHU CHARACTER-1B250NUSHU CHARACTER-1B251NUSHU CHARACT" +
	"ER-1B252NUSHU CHARACTER-1B253NUSHU CHARACTER-1B254NUSHU CHARACTER-1B255N" +
	"USHU CHARACTER-1B256NUSHU CHARACTER-1B257NUSHU CHARACTER-1B258NUSHU CHAR" +
	"ACTER-1B259NUSHU CHARACTER-1B25ANUSHU CHARACTER-1B25BNUSHU CHARACTER-1B2" +
	"5CNUSHU CHARACTER-1B25DNUSHU CHARACTER-1B25ENUSHU CHARACTER-1B25FNUSHU C" +
	"HARACTER-1B260NUSHU CHARACTER-1B261NUSHU CHARACTER-1B262NUSHU CHARACTER-" +
	"1B263NUSHU CHARACTER-1B264NUSHU CHARACTER-1B265NUSHU CHARACTER-1B266NUSH" +
	"U CHARACTER-1B267NUSHU CHARACTER-1B268NUSHU CHARACTER-1B269NUSHU CHARACT" +
	"ER-1B26ANUSHU CHARACTER-1B26BNUSHU CHARACTER-1B26CNUSHU CHARACTER-1B26DN" +
	"USHU CHARACTER-1B26ENUSHU CHARACTER-1B26FNUSHU CHARACTER-1B270NUSHU CHAR" +
	"ACTER-1B271NUSHU CHARACTER-1B272NUSHU CHARACTER-1B273NUSHU CHARACTER-1B2" +
	"74NUSHU CHARACTER-1B275NUSHU CHARACTER-1B276NUSHU CHARACTER-1B277NUSHU C" +
	"HARACTER-1B278NUSHU CHARACTER-1B279NUSHU CHARACTER-1B27ANUSHU CHARACTER-" +
	"1B27BNUSHU CHARACTER-1B27CNUSHU CHARACTER-1B27DNUSHU CHARACTER-1B27ENUSH" +
	"U CHARACTER-1B27FNUSHU CHARACTER-1B280NUSHU CHARACTER-1B281NUSHU CHARACT" +
	"ER-1B282NUSHU CHARACTER-1B283NUSHU CHARACTER-1B284NUSHU CHARACTER-1B285N" +
	"USHU CHARACTER-1B286NUSHU CHARACTER-1B287NUSHU CHARACTER-1B288NUSHU CHAR" +
	"ACTER-1B289NUSHU CHARACTER-1B28ANUSHU CHARACTER-1B28BNUSHU CHARACTER-1B2" +
	"8CNUSHU CHARACTER-1B28DNUSHU CHARACTER-1B28ENUSHU CHARACTER-1B28FNUSHU C" +
	"HARACTER-1B290NUSHU CHARACTER-1B291NUSHU CHARACTER-1B292NUSHU CHARACTER-" +
	"1B293NUSHU CHARACTER-1B294NUSHU CHARACTER-1B295NUSHU CHARACTER-1B296NUSH" +
	"U CHARACTER-1B297NUSHU CHARACTER-1B298NUSHU CHARACTER-1B299NUSHU CHARACT" +
	"ER-1B29ANUSHU CHARACTER-1B29BNUSHU CHARACTER-1B29CNUSHU CHARACTER-1B29DN" +
	"USHU CHARACTER-1B29ENUSHU CHARACTER-1B29FNUSHU CHARACTER-1B2A0NUSHU CHAR" +
	"ACTER-1B2A1NUSHU CHARACTER-1B2A2NUSHU CHARACTER-1B2A3NUSHU CHARACTER-1B2" +
	"A4NUSHU CHARACTER-1B2A5NUSHU CHARACTER-1B2A6NUSHU CHARACTER-1B2A7NUSHU C" +
	"HARACTER-1B2A8NUSHU CHARACTER-1B2A9NUSHU CHARACTER-1B2AANUSHU CHARACTER-" +
	"1B2ABNUSHU CHARACTER-1B2ACNUSHU CHARACTER-1B2ADNUSHU CHARACTER-1B2AENUSH" +
	"U CHARACTER-1B2AFNUSHU CHARACTER-1B2B0NUSHU CHARACTER-1B2B1NUSHU CHARACT" +
	"ER-1B2B2NUSHU CHARACTER-1B2B3NUSHU CHARACTER-1B2B4NUSHU CHARACTER-1B2B5N" +
	"USHU CHARACTER-1B2B6NUSHU CHARACTER-1B2B7NUSHU CHARACTER-1B2B8NUSHU CHAR" +
	"ACTER-1B2B9NUSHU CHARACTER-1B2BANUSHU CHARACTER-1B2BBNUSHU CHARACTER-1B2" +
	"BCNUSHU CHARACTER-1B2BDNUSHU CHARACTER-1B2BENUSHU CHARACTER-1B2BFNUSHU C" +
	"HARACTER-1B2C0NUSHU CHARACTER-1B2C1NUSHU CHARACTER-1B2C2NUSHU CHARACTER-" +
	"1B2C3NUSHU CHARACTER-1B2C4NUSHU CHARACTER-1B2C5NUSHU CHARACTER-1B2C6NUSH" +
	"U CHARACTER-1B2C7NUSHU CHARACTER-1B2C8NUSHU CHARACTER-1B2C9NUSHU CHARACT" +
	"ER-1B2CANUSHU CHARACTER-1B2CBNUSHU CHARACTER-1B2CCNUSHU CHARACTER-1B2CDN" +
	"USHU CHARACTER-1B2CENUSHU CHARACTER-1B2CFNUSHU CHARACTER-1B2D0NUSHU CHAR" +
	"ACTER-1B2D1NUSHU CHARACTER-1B2D2NUSHU CHARACTER-1B2D3NUSHU CHARACTER-1B2" +
	"D4NUSHU CHARACTER-1B2D5NUSHU CHARACTER-1B2D6NUSHU CHARACTER-1B2D7NUSHU C" +
	"HARACTER-1B2D8NUSHU CHARACTER-1B2D9NUSHU CHARACTER-1B2DANUSHU CHARACTER-" +
	"1B2DBNUSHU CHARACTER-1B2DCNUSHU CHARACTER-1B2DDNUSHU CHARACTER-1B2DENUSH" +
	"U CHARACTER-1B2DFNUSHU CHARACTER-1B2E0NUSHU CHARACTER-1B2E1NUSHU CHARACT" +
	"ER-1B2E2NUSHU CHARACTER-1B2E3NUSHU CHARACTER-1B2E4NUSHU CHARACTER-1B2E5N" +
	"USHU CHARACTER-1B2E6NUSHU CHARACTER-1B2E7NUSHU CHARACTER-1B2E8NUSHU CHAR" +
	"ACTER-1B2E9NUSHU CHARACTER-1B2EANUSHU CHARACTER-1B2EBNUSHU CHARACTER-1B2" +
	"ECNUSHU CHARACTER-1B2EDNUSHU CHARACTER-1B2EENUSHU CHARACTER-1B2EFNUSHU C" +
	"HARACTER-1B2F0NUSHU CHARACTER-1B2F1NUSHU CHARACTER-1B2F2NUSHU CHARACTER-" +
	"1B2F3NUSHU CHARACTER-1B2F4NUSHU CHARACTER-1B2F5NUSHU CHARACTER-1B2F6NUSH" +
	"U CHARACTER-1B2F7NUSHU CHARACTER-1B2F8NUSHU CHARACTER-1B2F9NUSHU CHARACT" +
	"ER-1B2FANUSHU CHARACTER-1B2FBDUPLOYAN LETTER HDUPLOYAN LETTER XDUPLOYAN " +
	"LETTER PDUPLOYAN LETTER TDUPLOYAN LETTER FDUPLOYAN LETTER KDUPLOYAN LETT" +
	"ER LDUPLOYAN LETTER BDUPLOYAN LETTER DDUPLOYAN LETTER VDUPLOYAN LETTER G" +
	"DUPLOYAN LETTER RDUPLOYAN LETTER P NDUPLOYAN LETTER D SDUPLOYAN LETTER F" +
	" NDUPLOYAN LETTER K MDUPLOYAN LETTER R SDUPLOYAN LETTER THDUPLOYAN LETTE" +
	"R SLOAN DHDUPLOYAN LETTER DHDUPLOYAN LETTER KKDUPLOYAN LETTER SLOAN JDUP" +
	"LOYAN LETTER HLDUPLOYAN LETTER LHDUPLOYAN LETTER RHDUPLOYAN LETTER MDUPL" +
	"OYAN LETTER NDUPLOYAN LETTER JDUPLOYAN LETTER SDUPLOYAN LETTER M NDUPLOY" +
	"AN LETTER N MDUPLOYAN LETTER J MDUPLOYAN LETTER S JDUPLOYAN LETTER M WIT" +
	"H DOTDUPLOYAN LETTER N WITH DOTDUPLOYAN LETTER J WITH DOTDUPLOYAN LETTER") + ("" +
	" J WITH DOTS INSIDE AND ABOVEDUPLOYAN LETTER S WITH DOTDUPLOYAN LETTER S" +
	" WITH DOT BELOWDUPLOYAN LETTER M SDUPLOYAN LETTER N SDUPLOYAN LETTER J S" +
	"DUPLOYAN LETTER S SDUPLOYAN LETTER M N SDUPLOYAN LETTER N M SDUPLOYAN LE" +
	"TTER J M SDUPLOYAN LETTER S J SDUPLOYAN LETTER J S WITH DOTDUPLOYAN LETT" +
	"ER J NDUPLOYAN LETTER J N SDUPLOYAN LETTER S TDUPLOYAN LETTER S T RDUPLO" +
	"YAN LETTER S PDUPLOYAN LETTER S P RDUPLOYAN LETTER T SDUPLOYAN LETTER T " +
	"R SDUPLOYAN LETTER WDUPLOYAN LETTER WHDUPLOYAN LETTER W RDUPLOYAN LETTER" +
	" S NDUPLOYAN LETTER S MDUPLOYAN LETTER K R SDUPLOYAN LETTER G R SDUPLOYA" +
	"N LETTER S KDUPLOYAN LETTER S K RDUPLOYAN LETTER ADUPLOYAN LETTER SLOAN " +
	"OWDUPLOYAN LETTER OADUPLOYAN LETTER ODUPLOYAN LETTER AOUDUPLOYAN LETTER " +
	"IDUPLOYAN LETTER EDUPLOYAN LETTER IEDUPLOYAN LETTER SHORT IDUPLOYAN LETT" +
	"ER UIDUPLOYAN LETTER EEDUPLOYAN LETTER SLOAN EHDUPLOYAN LETTER ROMANIAN " +
	"IDUPLOYAN LETTER SLOAN EEDUPLOYAN LETTER LONG IDUPLOYAN LETTER YEDUPLOYA" +
	"N LETTER UDUPLOYAN LETTER EUDUPLOYAN LETTER XWDUPLOYAN LETTER U NDUPLOYA" +
	"N LETTER LONG UDUPLOYAN LETTER ROMANIAN UDUPLOYAN LETTER UHDUPLOYAN LETT" +
	"ER SLOAN UDUPLOYAN LETTER OOHDUPLOYAN LETTER OWDUPLOYAN LETTER OUDUPLOYA" +
	"N LETTER WADUPLOYAN LETTER WODUPLOYAN LETTER WIDUPLOYAN LETTER WEIDUPLOY" +
	"AN LETTER WOWDUPLOYAN LETTER NASAL UDUPLOYAN LETTER NASAL ODUPLOYAN LETT" +
	"ER NASAL IDUPLOYAN LETTER NASAL ADUPLOYAN LETTER PERNIN ANDUPLOYAN LETTE" +
	"R PERNIN AMDUPLOYAN LETTER SLOAN ENDUPLOYAN LETTER SLOAN ANDUPLOYAN LETT" +
	"ER SLOAN ONDUPLOYAN LETTER VOCALIC MDUPLOYAN AFFIX LEFT HORIZONTAL SECAN" +
	"TDUPLOYAN AFFIX MID HORIZONTAL SECANTDUPLOYAN AFFIX RIGHT HORIZONTAL SEC" +
	"ANTDUPLOYAN AFFIX LOW VERTICAL SECANTDUPLOYAN AFFIX MID VERTICAL SECANTD" +
	"UPLOYAN AFFIX HIGH VERTICAL SECANTDUPLOYAN AFFIX ATTACHED SECANTDUPLOYAN" +
	" AFFIX ATTACHED LEFT-TO-RIGHT SECANTDUPLOYAN AFFIX ATTACHED TANGENTDUPLO" +
	"YAN AFFIX ATTACHED TAILDUPLOYAN AFFIX ATTACHED E HOOKDUPLOYAN AFFIX ATTA" +
	"CHED I HOOKDUPLOYAN AFFIX ATTACHED TANGENT HOOKDUPLOYAN AFFIX HIGH ACUTE" +
	"DUPLOYAN AFFIX HIGH TIGHT ACUTEDUPLOYAN AFFIX HIGH GRAVEDUPLOYAN AFFIX H" +
	"IGH LONG GRAVEDUPLOYAN AFFIX HIGH DOTDUPLOYAN AFFIX HIGH CIRCLEDUPLOYAN " +
	"AFFIX HIGH LINEDUPLOYAN AFFIX HIGH WAVEDUPLOYAN AFFIX HIGH VERTICALDUPLO" +
	"YAN AFFIX LOW ACUTEDUPLOYAN AFFIX LOW TIGHT ACUTEDUPLOYAN AFFIX LOW GRAV" +
	"EDUPLOYAN AFFIX LOW LONG GRAVEDUPLOYAN AFFIX LOW DOTDUPLOYAN AFFIX LOW C" +
	"IRCLEDUPLOYAN AFFIX LOW LINEDUPLOYAN AFFIX LOW WAVEDUPLOYAN AFFIX LOW VE" +
	"RTICALDUPLOYAN AFFIX LOW ARROWDUPLOYAN SIGN O WITH CROSSDUPLOYAN THICK L" +
	"ETTER SELECTORDUPLOYAN DOUBLE MARKDUPLOYAN PUNCTUATION CHINOOK FULL STOP" +
	"SHORTHAND FORMAT LETTER OVERLAPSHORTHAND FORMAT CONTINUING OVERLAPSHORTH" +
	"AND FORMAT DOWN STEPSHORTHAND FORMAT UP STEPBYZANTINE MUSICAL SYMBOL PSI" +
	"LIBYZANTINE MUSICAL SYMBOL DASEIABYZANTINE MUSICAL SYMBOL PERISPOMENIBYZ" +
	"ANTINE MUSICAL SYMBOL OXEIA EKFONITIKONBYZANTINE MUSICAL SYMBOL OXEIA DI" +
	"PLIBYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKONBYZANTINE MUSICAL SYMBOL V" +
	"AREIA DIPLIBYZANTINE MUSICAL SYMBOL KATHISTIBYZANTINE MUSICAL SYMBOL SYR" +
	"MATIKIBYZANTINE MUSICAL SYMBOL PARAKLITIKIBYZANTINE MUSICAL SYMBOL YPOKR" +
	"ISISBYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLIBYZANTINE MUSICAL SYMBOL KRE" +
	"MASTIBYZANTINE MUSICAL SYMBOL APESO EKFONITIKONBYZANTINE MUSICAL SYMBOL " +
	"EXO EKFONITIKONBYZANTINE MUSICAL SYMBOL TELEIABYZANTINE MUSICAL SYMBOL K" +
	"ENTIMATABYZANTINE MUSICAL SYMBOL APOSTROFOSBYZANTINE MUSICAL SYMBOL APOS" +
	"TROFOS DIPLIBYZANTINE MUSICAL SYMBOL SYNEVMABYZANTINE MUSICAL SYMBOL THI" +
	"TABYZANTINE MUSICAL SYMBOL OLIGON ARCHAIONBYZANTINE MUSICAL SYMBOL GORGO" +
	"N ARCHAIONBYZANTINE MUSICAL SYMBOL PSILONBYZANTINE MUSICAL SYMBOL CHAMIL" +
	"ONBYZANTINE MUSICAL SYMBOL VATHYBYZANTINE MUSICAL SYMBOL ISON ARCHAIONBY" +
	"ZANTINE MUSICAL SYMBOL KENTIMA ARCHAIONBYZANTINE MUSICAL SYMBOL KENTIMAT" +
	"A ARCHAIONBYZANTINE MUSICAL SYMBOL SAXIMATABYZANTINE MUSICAL SYMBOL PARI" +
	"CHONBYZANTINE MUSICAL SYMBOL STAVROS APODEXIABYZANTINE MUSICAL SYMBOL OX" +
	"EIAI ARCHAIONBYZANTINE MUSICAL SYMBOL VAREIAI ARCHAIONBYZANTINE MUSICAL " +
	"SYMBOL APODERMA ARCHAIONBYZANTINE MUSICAL SYMBOL APOTHEMABYZANTINE MUSIC" +
	"AL SYMBOL KLASMABYZANTINE MUSICAL SYMBOL REVMABYZANTINE MUSICAL SYMBOL P" +
	"IASMA ARCHAIONBYZANTINE MUSICAL SYMBOL TINAGMABYZANTINE MUSICAL SYMBOL A" +
	"NATRICHISMABYZANTINE MUSICAL SYMBOL SEISMABYZANTINE MUSICAL SYMBOL SYNAG" +
	"MA ARCHAIONBYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROUBYZANTINE MUSICA" +
	"L SYMBOL OYRANISMA ARCHAIONBYZANTINE MUSICAL SYMBOL THEMABYZANTINE MUSIC" +
	"AL SYMBOL LEMOIBYZANTINE MUSICAL SYMBOL DYOBYZANTINE MUSICAL SYMBOL TRIA" +
	"BYZANTINE MUSICAL SYMBOL TESSERABYZANTINE MUSICAL SYMBOL KRATIMATABYZANT" +
	"INE MUSICAL SYMBOL APESO EXO NEOBYZANTINE MUSICAL SYMBOL FTHORA ARCHAION" +
	"BYZANTINE MUSICAL SYMBOL IMIFTHORABYZANTINE MUSICAL SYMBOL TROMIKON ARCH") + ("" +
	"AIONBYZANTINE MUSICAL SYMBOL KATAVA TROMIKONBYZANTINE MUSICAL SYMBOL PEL" +
	"ASTONBYZANTINE MUSICAL SYMBOL PSIFISTONBYZANTINE MUSICAL SYMBOL KONTEVMA" +
	"BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAIONBYZANTINE MUSICAL SYMBOL RAPIS" +
	"MABYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAIONBYZANTINE MUSICAL SYMBOL " +
	"PARAKLITIKI ARCHAIONBYZANTINE MUSICAL SYMBOL ICHADINBYZANTINE MUSICAL SY" +
	"MBOL NANABYZANTINE MUSICAL SYMBOL PETASMABYZANTINE MUSICAL SYMBOL KONTEV" +
	"MA ALLOBYZANTINE MUSICAL SYMBOL TROMIKON ALLOBYZANTINE MUSICAL SYMBOL ST" +
	"RAGGISMATABYZANTINE MUSICAL SYMBOL GRONTHISMATABYZANTINE MUSICAL SYMBOL " +
	"ISON NEOBYZANTINE MUSICAL SYMBOL OLIGON NEOBYZANTINE MUSICAL SYMBOL OXEI" +
	"A NEOBYZANTINE MUSICAL SYMBOL PETASTIBYZANTINE MUSICAL SYMBOL KOUFISMABY" +
	"ZANTINE MUSICAL SYMBOL PETASTOKOUFISMABYZANTINE MUSICAL SYMBOL KRATIMOKO" +
	"UFISMABYZANTINE MUSICAL SYMBOL PELASTON NEOBYZANTINE MUSICAL SYMBOL KENT" +
	"IMATA NEO ANOBYZANTINE MUSICAL SYMBOL KENTIMA NEO ANOBYZANTINE MUSICAL S" +
	"YMBOL YPSILIBYZANTINE MUSICAL SYMBOL APOSTROFOS NEOBYZANTINE MUSICAL SYM" +
	"BOL APOSTROFOI SYNDESMOS NEOBYZANTINE MUSICAL SYMBOL YPORROIBYZANTINE MU" +
	"SICAL SYMBOL KRATIMOYPORROONBYZANTINE MUSICAL SYMBOL ELAFRONBYZANTINE MU" +
	"SICAL SYMBOL CHAMILIBYZANTINE MUSICAL SYMBOL MIKRON ISONBYZANTINE MUSICA" +
	"L SYMBOL VAREIA NEOBYZANTINE MUSICAL SYMBOL PIASMA NEOBYZANTINE MUSICAL " +
	"SYMBOL PSIFISTON NEOBYZANTINE MUSICAL SYMBOL OMALONBYZANTINE MUSICAL SYM" +
	"BOL ANTIKENOMABYZANTINE MUSICAL SYMBOL LYGISMABYZANTINE MUSICAL SYMBOL P" +
	"ARAKLITIKI NEOBYZANTINE MUSICAL SYMBOL PARAKALESMA NEOBYZANTINE MUSICAL " +
	"SYMBOL ETERON PARAKALESMABYZANTINE MUSICAL SYMBOL KYLISMABYZANTINE MUSIC" +
	"AL SYMBOL ANTIKENOKYLISMABYZANTINE MUSICAL SYMBOL TROMIKON NEOBYZANTINE " +
	"MUSICAL SYMBOL EKSTREPTONBYZANTINE MUSICAL SYMBOL SYNAGMA NEOBYZANTINE M" +
	"USICAL SYMBOL SYRMABYZANTINE MUSICAL SYMBOL CHOREVMA NEOBYZANTINE MUSICA" +
	"L SYMBOL EPEGERMABYZANTINE MUSICAL SYMBOL SEISMA NEOBYZANTINE MUSICAL SY" +
	"MBOL XIRON KLASMABYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTONBYZANTINE MUSI" +
	"CAL SYMBOL PSIFISTOLYGISMABYZANTINE MUSICAL SYMBOL TROMIKOLYGISMABYZANTI" +
	"NE MUSICAL SYMBOL TROMIKOPARAKALESMABYZANTINE MUSICAL SYMBOL PSIFISTOPAR" +
	"AKALESMABYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMABYZANTINE MUSICAL SYMBOL " +
	"PSIFISTOSYNAGMABYZANTINE MUSICAL SYMBOL GORGOSYNTHETONBYZANTINE MUSICAL " +
	"SYMBOL ARGOSYNTHETONBYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETONBYZANTI" +
	"NE MUSICAL SYMBOL OYRANISMA NEOBYZANTINE MUSICAL SYMBOL THEMATISMOS ESOB" +
	"YZANTINE MUSICAL SYMBOL THEMATISMOS EXOBYZANTINE MUSICAL SYMBOL THEMA AP" +
	"LOUNBYZANTINE MUSICAL SYMBOL THES KAI APOTHESBYZANTINE MUSICAL SYMBOL KA" +
	"TAVASMABYZANTINE MUSICAL SYMBOL ENDOFONONBYZANTINE MUSICAL SYMBOL YFEN K" +
	"ATOBYZANTINE MUSICAL SYMBOL YFEN ANOBYZANTINE MUSICAL SYMBOL STAVROSBYZA" +
	"NTINE MUSICAL SYMBOL KLASMA ANOBYZANTINE MUSICAL SYMBOL DIPLI ARCHAIONBY" +
	"ZANTINE MUSICAL SYMBOL KRATIMA ARCHAIONBYZANTINE MUSICAL SYMBOL KRATIMA " +
	"ALLOBYZANTINE MUSICAL SYMBOL KRATIMA NEOBYZANTINE MUSICAL SYMBOL APODERM" +
	"A NEOBYZANTINE MUSICAL SYMBOL APLIBYZANTINE MUSICAL SYMBOL DIPLIBYZANTIN" +
	"E MUSICAL SYMBOL TRIPLIBYZANTINE MUSICAL SYMBOL TETRAPLIBYZANTINE MUSICA" +
	"L SYMBOL KORONISBYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOUBYZANTINE MU" +
	"SICAL SYMBOL LEIMMA DYO CHRONONBYZANTINE MUSICAL SYMBOL LEIMMA TRION CHR" +
	"ONONBYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONONBYZANTINE MUSICAL SY" +
	"MBOL LEIMMA IMISEOS CHRONOUBYZANTINE MUSICAL SYMBOL GORGON NEO ANOBYZANT" +
	"INE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERABYZANTINE MUSICAL SYMBOL" +
	" GORGON PARESTIGMENON DEXIABYZANTINE MUSICAL SYMBOL DIGORGONBYZANTINE MU" +
	"SICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATOBYZANTINE MUSICAL SYMBO" +
	"L DIGORGON PARESTIGMENON ARISTERA ANOBYZANTINE MUSICAL SYMBOL DIGORGON P" +
	"ARESTIGMENON DEXIABYZANTINE MUSICAL SYMBOL TRIGORGONBYZANTINE MUSICAL SY" +
	"MBOL ARGONBYZANTINE MUSICAL SYMBOL IMIDIARGONBYZANTINE MUSICAL SYMBOL DI" +
	"ARGONBYZANTINE MUSICAL SYMBOL AGOGI POLI ARGIBYZANTINE MUSICAL SYMBOL AG" +
	"OGI ARGOTERIBYZANTINE MUSICAL SYMBOL AGOGI ARGIBYZANTINE MUSICAL SYMBOL " +
	"AGOGI METRIABYZANTINE MUSICAL SYMBOL AGOGI MESIBYZANTINE MUSICAL SYMBOL " +
	"AGOGI GORGIBYZANTINE MUSICAL SYMBOL AGOGI GORGOTERIBYZANTINE MUSICAL SYM" +
	"BOL AGOGI POLI GORGIBYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOSBYZANT" +
	"INE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOSBYZANTINE MUSICAL SYMBOL MA" +
	"RTYRIA DEYTEROS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICH" +
	"OSBYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOSBYZANTINE MUSICAL SYMBOL" +
	" MARTYRIA TRIFONIASBYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOSBYZAN" +
	"TINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOSBYZANTINE MUSICAL SYM" +
	"BOL MARTYRIA LEGETOS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHO" +
	"SBYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOSBYZANTINE MUSICAL SYMBO") + ("" +
	"L APOSTROFOI TELOUS ICHIMATOSBYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFON" +
	"IASBYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIASBYZANTINE MUSICAL SYMBOL" +
	" FANEROSIS DIFONIASBYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOSBYZANTIN" +
	"E MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOSBYZANTINE MUSICAL SYMBOL MARTY" +
	"RIA PLAGIOS TETARTOS ICHOSBYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUNBY" +
	"ZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUNBYZANTINE MUSICAL SYMBOL ENAR" +
	"XIS KAI FTHORA VOUBYZANTINE MUSICAL SYMBOL IMIFONONBYZANTINE MUSICAL SYM" +
	"BOL IMIFTHORONBYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOUBYZ" +
	"ANTINE MUSICAL SYMBOL FTHORA DIATONIKI PABYZANTINE MUSICAL SYMBOL FTHORA" +
	" DIATONIKI NANABYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOSBYZANTINE MUSIC" +
	"AL SYMBOL FTHORA DIATONIKI DIBYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIA" +
	"TONON DIBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KEBYZANTINE MUSICAL SY" +
	"MBOL FTHORA DIATONIKI ZOBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KAT" +
	"OBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANOBYZANTINE MUSICAL SYMBO" +
	"L FTHORA MALAKON CHROMA DIFONIASBYZANTINE MUSICAL SYMBOL FTHORA MALAKON " +
	"CHROMA MONOFONIASBYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASISBYZ" +
	"ANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFIBYZANTINE MUSICAL SYMB" +
	"OL FTHORA NENANOBYZANTINE MUSICAL SYMBOL CHROA ZYGOSBYZANTINE MUSICAL SY" +
	"MBOL CHROA KLITONBYZANTINE MUSICAL SYMBOL CHROA SPATHIBYZANTINE MUSICAL " +
	"SYMBOL FTHORA I YFESIS TETARTIMORIONBYZANTINE MUSICAL SYMBOL FTHORA ENAR" +
	"MONIOS ANTIFONIABYZANTINE MUSICAL SYMBOL YFESIS TRITIMORIONBYZANTINE MUS" +
	"ICAL SYMBOL DIESIS TRITIMORIONBYZANTINE MUSICAL SYMBOL DIESIS TETARTIMOR" +
	"IONBYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATABYZANTINE MUSICAL SY" +
	"MBOL DIESIS MONOGRAMMOS TESSERA DODEKATABYZANTINE MUSICAL SYMBOL DIESIS " +
	"DIGRAMMOS EX DODEKATABYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DOD" +
	"EKATABYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATABYZANTINE MUSICAL " +
	"SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATABYZANTINE MUSICAL SYMBOL YFESI" +
	"S DIGRAMMOS EX DODEKATABYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO D" +
	"ODEKATABYZANTINE MUSICAL SYMBOL GENIKI DIESISBYZANTINE MUSICAL SYMBOL GE" +
	"NIKI YFESISBYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRIBYZANTINE MUSICAL" +
	" SYMBOL DIASTOLI APLI MEGALIBYZANTINE MUSICAL SYMBOL DIASTOLI DIPLIBYZAN" +
	"TINE MUSICAL SYMBOL DIASTOLI THESEOSBYZANTINE MUSICAL SYMBOL SIMANSIS TH" +
	"ESEOSBYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOUBYZANTINE MUSICAL " +
	"SYMBOL SIMANSIS THESEOS TRISIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS THESEO" +
	"S TETRASIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOSBYZANTINE MUSICAL SY" +
	"MBOL SIMANSIS ARSEOS DISIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRI" +
	"SIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOUBYZANTINE MUSICA" +
	"L SYMBOL DIGRAMMA GGBYZANTINE MUSICAL SYMBOL DIFTOGGOS OUBYZANTINE MUSIC" +
	"AL SYMBOL STIGMABYZANTINE MUSICAL SYMBOL ARKTIKO PABYZANTINE MUSICAL SYM" +
	"BOL ARKTIKO VOUBYZANTINE MUSICAL SYMBOL ARKTIKO GABYZANTINE MUSICAL SYMB" +
	"OL ARKTIKO DIBYZANTINE MUSICAL SYMBOL ARKTIKO KEBYZANTINE MUSICAL SYMBOL" +
	" ARKTIKO ZOBYZANTINE MUSICAL SYMBOL ARKTIKO NIBYZANTINE MUSICAL SYMBOL K" +
	"ENTIMATA NEO MESOBYZANTINE MUSICAL SYMBOL KENTIMA NEO MESOBYZANTINE MUSI" +
	"CAL SYMBOL KENTIMATA NEO KATOBYZANTINE MUSICAL SYMBOL KENTIMA NEO KATOBY" +
	"ZANTINE MUSICAL SYMBOL KLASMA KATOBYZANTINE MUSICAL SYMBOL GORGON NEO KA" +
	"TOMUSICAL SYMBOL SINGLE BARLINEMUSICAL SYMBOL DOUBLE BARLINEMUSICAL SYMB" +
	"OL FINAL BARLINEMUSICAL SYMBOL REVERSE FINAL BARLINEMUSICAL SYMBOL DASHE" +
	"D BARLINEMUSICAL SYMBOL SHORT BARLINEMUSICAL SYMBOL LEFT REPEAT SIGNMUSI" +
	"CAL SYMBOL RIGHT REPEAT SIGNMUSICAL SYMBOL REPEAT DOTSMUSICAL SYMBOL DAL" +
	" SEGNOMUSICAL SYMBOL DA CAPOMUSICAL SYMBOL SEGNOMUSICAL SYMBOL CODAMUSIC" +
	"AL SYMBOL REPEATED FIGURE-1MUSICAL SYMBOL REPEATED FIGURE-2MUSICAL SYMBO" +
	"L REPEATED FIGURE-3MUSICAL SYMBOL FERMATAMUSICAL SYMBOL FERMATA BELOWMUS" +
	"ICAL SYMBOL BREATH MARKMUSICAL SYMBOL CAESURAMUSICAL SYMBOL BRACEMUSICAL" +
	" SYMBOL BRACKETMUSICAL SYMBOL ONE-LINE STAFFMUSICAL SYMBOL TWO-LINE STAF" +
	"FMUSICAL SYMBOL THREE-LINE STAFFMUSICAL SYMBOL FOUR-LINE STAFFMUSICAL SY" +
	"MBOL FIVE-LINE STAFFMUSICAL SYMBOL SIX-LINE STAFFMUSICAL SYMBOL SIX-STRI" +
	"NG FRETBOARDMUSICAL SYMBOL FOUR-STRING FRETBOARDMUSICAL SYMBOL G CLEFMUS" +
	"ICAL SYMBOL G CLEF OTTAVA ALTAMUSICAL SYMBOL G CLEF OTTAVA BASSAMUSICAL " +
	"SYMBOL C CLEFMUSICAL SYMBOL F CLEFMUSICAL SYMBOL F CLEF OTTAVA ALTAMUSIC" +
	"AL SYMBOL F CLEF OTTAVA BASSAMUSICAL SYMBOL DRUM CLEF-1MUSICAL SYMBOL DR" +
	"UM CLEF-2MUSICAL SYMBOL MULTIPLE MEASURE RESTMUSICAL SYMBOL DOUBLE SHARP" +
	"MUSICAL SYMBOL DOUBLE FLATMUSICAL SYMBOL FLAT UPMUSICAL SYMBOL FLAT DOWN" +
	"MUSICAL SYMBOL NATURAL UPMUSICAL SYMBOL NATURAL DOWNMUSICAL SYMBOL SHARP" +
	" UPMUSICAL SYMBOL SHARP DOWNMUSICAL SYMBOL QUARTER TONE SHARPMUSICAL SYM") + ("" +
	"BOL QUARTER TONE FLATMUSICAL SYMBOL COMMON TIMEMUSICAL SYMBOL CUT TIMEMU" +
	"SICAL SYMBOL OTTAVA ALTAMUSICAL SYMBOL OTTAVA BASSAMUSICAL SYMBOL QUINDI" +
	"CESIMA ALTAMUSICAL SYMBOL QUINDICESIMA BASSAMUSICAL SYMBOL MULTI RESTMUS" +
	"ICAL SYMBOL WHOLE RESTMUSICAL SYMBOL HALF RESTMUSICAL SYMBOL QUARTER RES" +
	"TMUSICAL SYMBOL EIGHTH RESTMUSICAL SYMBOL SIXTEENTH RESTMUSICAL SYMBOL T" +
	"HIRTY-SECOND RESTMUSICAL SYMBOL SIXTY-FOURTH RESTMUSICAL SYMBOL ONE HUND" +
	"RED TWENTY-EIGHTH RESTMUSICAL SYMBOL X NOTEHEADMUSICAL SYMBOL PLUS NOTEH" +
	"EADMUSICAL SYMBOL CIRCLE X NOTEHEADMUSICAL SYMBOL SQUARE NOTEHEAD WHITEM" +
	"USICAL SYMBOL SQUARE NOTEHEAD BLACKMUSICAL SYMBOL TRIANGLE NOTEHEAD UP W" +
	"HITEMUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACKMUSICAL SYMBOL TRIANGLE NOT" +
	"EHEAD LEFT WHITEMUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACKMUSICAL SYMBO" +
	"L TRIANGLE NOTEHEAD RIGHT WHITEMUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BL" +
	"ACKMUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITEMUSICAL SYMBOL TRIANGLE NO" +
	"TEHEAD DOWN BLACKMUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITEMUSICAL " +
	"SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACKMUSICAL SYMBOL MOON NOTEHEAD WHIT" +
	"EMUSICAL SYMBOL MOON NOTEHEAD BLACKMUSICAL SYMBOL TRIANGLE-ROUND NOTEHEA" +
	"D DOWN WHITEMUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACKMUSICAL SYM" +
	"BOL PARENTHESIS NOTEHEADMUSICAL SYMBOL VOID NOTEHEADMUSICAL SYMBOL NOTEH" +
	"EAD BLACKMUSICAL SYMBOL NULL NOTEHEADMUSICAL SYMBOL CLUSTER NOTEHEAD WHI" +
	"TEMUSICAL SYMBOL CLUSTER NOTEHEAD BLACKMUSICAL SYMBOL BREVEMUSICAL SYMBO" +
	"L WHOLE NOTEMUSICAL SYMBOL HALF NOTEMUSICAL SYMBOL QUARTER NOTEMUSICAL S" +
	"YMBOL EIGHTH NOTEMUSICAL SYMBOL SIXTEENTH NOTEMUSICAL SYMBOL THIRTY-SECO" +
	"ND NOTEMUSICAL SYMBOL SIXTY-FOURTH NOTEMUSICAL SYMBOL ONE HUNDRED TWENTY" +
	"-EIGHTH NOTEMUSICAL SYMBOL COMBINING STEMMUSICAL SYMBOL COMBINING SPRECH" +
	"GESANG STEMMUSICAL SYMBOL COMBINING TREMOLO-1MUSICAL SYMBOL COMBINING TR" +
	"EMOLO-2MUSICAL SYMBOL COMBINING TREMOLO-3MUSICAL SYMBOL FINGERED TREMOLO" +
	"-1MUSICAL SYMBOL FINGERED TREMOLO-2MUSICAL SYMBOL FINGERED TREMOLO-3MUSI" +
	"CAL SYMBOL COMBINING AUGMENTATION DOTMUSICAL SYMBOL COMBINING FLAG-1MUSI" +
	"CAL SYMBOL COMBINING FLAG-2MUSICAL SYMBOL COMBINING FLAG-3MUSICAL SYMBOL" +
	" COMBINING FLAG-4MUSICAL SYMBOL COMBINING FLAG-5MUSICAL SYMBOL BEGIN BEA" +
	"MMUSICAL SYMBOL END BEAMMUSICAL SYMBOL BEGIN TIEMUSICAL SYMBOL END TIEMU" +
	"SICAL SYMBOL BEGIN SLURMUSICAL SYMBOL END SLURMUSICAL SYMBOL BEGIN PHRAS" +
	"EMUSICAL SYMBOL END PHRASEMUSICAL SYMBOL COMBINING ACCENTMUSICAL SYMBOL " +
	"COMBINING STACCATOMUSICAL SYMBOL COMBINING TENUTOMUSICAL SYMBOL COMBININ" +
	"G STACCATISSIMOMUSICAL SYMBOL COMBINING MARCATOMUSICAL SYMBOL COMBINING " +
	"MARCATO-STACCATOMUSICAL SYMBOL COMBINING ACCENT-STACCATOMUSICAL SYMBOL C" +
	"OMBINING LOUREMUSICAL SYMBOL ARPEGGIATO UPMUSICAL SYMBOL ARPEGGIATO DOWN" +
	"MUSICAL SYMBOL COMBINING DOITMUSICAL SYMBOL COMBINING RIPMUSICAL SYMBOL " +
	"COMBINING FLIPMUSICAL SYMBOL COMBINING SMEARMUSICAL SYMBOL COMBINING BEN" +
	"DMUSICAL SYMBOL COMBINING DOUBLE TONGUEMUSICAL SYMBOL COMBINING TRIPLE T" +
	"ONGUEMUSICAL SYMBOL RINFORZANDOMUSICAL SYMBOL SUBITOMUSICAL SYMBOL ZMUSI" +
	"CAL SYMBOL PIANOMUSICAL SYMBOL MEZZOMUSICAL SYMBOL FORTEMUSICAL SYMBOL C" +
	"RESCENDOMUSICAL SYMBOL DECRESCENDOMUSICAL SYMBOL GRACE NOTE SLASHMUSICAL" +
	" SYMBOL GRACE NOTE NO SLASHMUSICAL SYMBOL TRMUSICAL SYMBOL TURNMUSICAL S" +
	"YMBOL INVERTED TURNMUSICAL SYMBOL TURN SLASHMUSICAL SYMBOL TURN UPMUSICA" +
	"L SYMBOL ORNAMENT STROKE-1MUSICAL SYMBOL ORNAMENT STROKE-2MUSICAL SYMBOL" +
	" ORNAMENT STROKE-3MUSICAL SYMBOL ORNAMENT STROKE-4MUSICAL SYMBOL ORNAMEN" +
	"T STROKE-5MUSICAL SYMBOL ORNAMENT STROKE-6MUSICAL SYMBOL ORNAMENT STROKE" +
	"-7MUSICAL SYMBOL ORNAMENT STROKE-8MUSICAL SYMBOL ORNAMENT STROKE-9MUSICA" +
	"L SYMBOL ORNAMENT STROKE-10MUSICAL SYMBOL ORNAMENT STROKE-11MUSICAL SYMB" +
	"OL HAUPTSTIMMEMUSICAL SYMBOL NEBENSTIMMEMUSICAL SYMBOL END OF STIMMEMUSI" +
	"CAL SYMBOL DEGREE SLASHMUSICAL SYMBOL COMBINING DOWN BOWMUSICAL SYMBOL C" +
	"OMBINING UP BOWMUSICAL SYMBOL COMBINING HARMONICMUSICAL SYMBOL COMBINING" +
	" SNAP PIZZICATOMUSICAL SYMBOL PEDAL MARKMUSICAL SYMBOL PEDAL UP MARKMUSI" +
	"CAL SYMBOL HALF PEDAL MARKMUSICAL SYMBOL GLISSANDO UPMUSICAL SYMBOL GLIS" +
	"SANDO DOWNMUSICAL SYMBOL WITH FINGERNAILSMUSICAL SYMBOL DAMPMUSICAL SYMB" +
	"OL DAMP ALLMUSICAL SYMBOL MAXIMAMUSICAL SYMBOL LONGAMUSICAL SYMBOL BREVI" +
	"SMUSICAL SYMBOL SEMIBREVIS WHITEMUSICAL SYMBOL SEMIBREVIS BLACKMUSICAL S" +
	"YMBOL MINIMAMUSICAL SYMBOL MINIMA BLACKMUSICAL SYMBOL SEMIMINIMA WHITEMU" +
	"SICAL SYMBOL SEMIMINIMA BLACKMUSICAL SYMBOL FUSA WHITEMUSICAL SYMBOL FUS" +
	"A BLACKMUSICAL SYMBOL LONGA PERFECTA RESTMUSICAL SYMBOL LONGA IMPERFECTA" +
	" RESTMUSICAL SYMBOL BREVIS RESTMUSICAL SYMBOL SEMIBREVIS RESTMUSICAL SYM" +
	"BOL MINIMA RESTMUSICAL SYMBOL SEMIMINIMA RESTMUSICAL SYMBOL TEMPUS PERFE" +
	"CTUM CUM PROLATIONE PERFECTAMUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIO") + ("" +
	"NE IMPERFECTAMUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIM" +
	"INUTION-1MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTAMUSICA" +
	"L SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTAMUSICAL SYMBOL TEMP" +
	"US IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1MUSICAL SYMBOL TEMP" +
	"US IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2MUSICAL SYMBOL TEMP" +
	"US IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3MUSICAL SYMBOL CROI" +
	"XMUSICAL SYMBOL GREGORIAN C CLEFMUSICAL SYMBOL GREGORIAN F CLEFMUSICAL S" +
	"YMBOL SQUARE BMUSICAL SYMBOL VIRGAMUSICAL SYMBOL PODATUSMUSICAL SYMBOL C" +
	"LIVISMUSICAL SYMBOL SCANDICUSMUSICAL SYMBOL CLIMACUSMUSICAL SYMBOL TORCU" +
	"LUSMUSICAL SYMBOL PORRECTUSMUSICAL SYMBOL PORRECTUS FLEXUSMUSICAL SYMBOL" +
	" SCANDICUS FLEXUSMUSICAL SYMBOL TORCULUS RESUPINUSMUSICAL SYMBOL PES SUB" +
	"PUNCTISMUSICAL SYMBOL KIEVAN C CLEFMUSICAL SYMBOL KIEVAN END OF PIECEMUS" +
	"ICAL SYMBOL KIEVAN FINAL NOTEMUSICAL SYMBOL KIEVAN RECITATIVE MARKMUSICA" +
	"L SYMBOL KIEVAN WHOLE NOTEMUSICAL SYMBOL KIEVAN HALF NOTEMUSICAL SYMBOL " +
	"KIEVAN QUARTER NOTE STEM DOWNMUSICAL SYMBOL KIEVAN QUARTER NOTE STEM UPM" +
	"USICAL SYMBOL KIEVAN EIGHTH NOTE STEM DOWNMUSICAL SYMBOL KIEVAN EIGHTH N" +
	"OTE STEM UPMUSICAL SYMBOL KIEVAN FLAT SIGNGREEK VOCAL NOTATION SYMBOL-1G" +
	"REEK VOCAL NOTATION SYMBOL-2GREEK VOCAL NOTATION SYMBOL-3GREEK VOCAL NOT" +
	"ATION SYMBOL-4GREEK VOCAL NOTATION SYMBOL-5GREEK VOCAL NOTATION SYMBOL-6" +
	"GREEK VOCAL NOTATION SYMBOL-7GREEK VOCAL NOTATION SYMBOL-8GREEK VOCAL NO" +
	"TATION SYMBOL-9GREEK VOCAL NOTATION SYMBOL-10GREEK VOCAL NOTATION SYMBOL" +
	"-11GREEK VOCAL NOTATION SYMBOL-12GREEK VOCAL NOTATION SYMBOL-13GREEK VOC" +
	"AL NOTATION SYMBOL-14GREEK VOCAL NOTATION SYMBOL-15GREEK VOCAL NOTATION " +
	"SYMBOL-16GREEK VOCAL NOTATION SYMBOL-17GREEK VOCAL NOTATION SYMBOL-18GRE" +
	"EK VOCAL NOTATION SYMBOL-19GREEK VOCAL NOTATION SYMBOL-20GREEK VOCAL NOT" +
	"ATION SYMBOL-21GREEK VOCAL NOTATION SYMBOL-22GREEK VOCAL NOTATION SYMBOL" +
	"-23GREEK VOCAL NOTATION SYMBOL-24GREEK VOCAL NOTATION SYMBOL-50GREEK VOC" +
	"AL NOTATION SYMBOL-51GREEK VOCAL NOTATION SYMBOL-52GREEK VOCAL NOTATION " +
	"SYMBOL-53GREEK VOCAL NOTATION SYMBOL-54GREEK INSTRUMENTAL NOTATION SYMBO" +
	"L-1GREEK INSTRUMENTAL NOTATION SYMBOL-2GREEK INSTRUMENTAL NOTATION SYMBO" +
	"L-4GREEK INSTRUMENTAL NOTATION SYMBOL-5GREEK INSTRUMENTAL NOTATION SYMBO" +
	"L-7GREEK INSTRUMENTAL NOTATION SYMBOL-8GREEK INSTRUMENTAL NOTATION SYMBO" +
	"L-11GREEK INSTRUMENTAL NOTATION SYMBOL-12GREEK INSTRUMENTAL NOTATION SYM" +
	"BOL-13GREEK INSTRUMENTAL NOTATION SYMBOL-14GREEK INSTRUMENTAL NOTATION S" +
	"YMBOL-17GREEK INSTRUMENTAL NOTATION SYMBOL-18GREEK INSTRUMENTAL NOTATION" +
	" SYMBOL-19GREEK INSTRUMENTAL NOTATION SYMBOL-23GREEK INSTRUMENTAL NOTATI" +
	"ON SYMBOL-24GREEK INSTRUMENTAL NOTATION SYMBOL-25GREEK INSTRUMENTAL NOTA" +
	"TION SYMBOL-26GREEK INSTRUMENTAL NOTATION SYMBOL-27GREEK INSTRUMENTAL NO" +
	"TATION SYMBOL-29GREEK INSTRUMENTAL NOTATION SYMBOL-30GREEK INSTRUMENTAL " +
	"NOTATION SYMBOL-32GREEK INSTRUMENTAL NOTATION SYMBOL-36GREEK INSTRUME