
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_lobpcg.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGCreate( mv_InterfaceInterpreter *interpreter, HYPRE_MatvecFunctions *mvfunctions, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGCreate_pre( precision, interpreter, mvfunctions, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGEigenvaluesHistory( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGEigenvaluesHistory_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGIterations( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGIterations_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGResidualNorms( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGResidualNorms_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGResidualNormsHistory( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGResidualNormsHistory_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrecondUsageMode( HYPRE_Solver solver, HYPRE_Int mode )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetPrecondUsageMode_pre( precision, solver, mode );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetRTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetRTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetupB( HYPRE_Solver solver, HYPRE_Matrix B, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetupB_pre( precision, solver, B, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetupT( HYPRE_Solver solver, HYPRE_Matrix T, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSetupT_pre( precision, solver, T, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSolve( HYPRE_Solver solver, mv_MultiVectorPtr y, mv_MultiVectorPtr x, void *lambda )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LOBPCGSolve_pre( precision, solver, y, x, lambda );
}



#endif

