<!--
Thank you for submitting a PR to lmfit!

To ease the process of reviewing your PR, do make sure to complete the following boxes.
-->

#### Description
<!--- Describe your changes in detail: why is it required, what problem does it solve? -->
<!--- If it fixes an open issue, please link to the issue here. -->
<!--- If applicable, please provide the URL to the discussion on the mailing list. -->


###### Type of Changes
<!--- What type of changes does your code introduce? Put an `x` in all the boxes that apply: -->
- [ ] Bug fix
- [ ] New feature
- [ ] Refactoring / maintenance
- [ ] Documentation / examples


###### Tested on
<!-- Generate version information with this command in the Python shell and copy the output here:
import sys, lmfit, numpy, scipy, asteval, uncertainties
print('Python: {}\n\nlmfit: {}, scipy: {}, numpy: {}, asteval: {}, uncertainties: {}'\
      .format(sys.version, lmfit.__version__, scipy.__version__, numpy.__version__, \
      asteval.__version__, uncertainties.__version__))
-->


###### Verification <!-- (delete not applicable items) -->
Have you
<!--- Put an `x` in all the boxes that apply OR describe why you think this is unnecessary. -->
- [ ] included docstrings that follow PEP 257?
<!-- Please use your favorite linter (e.g., pydocstyle) to check your docstrings. -->
- [ ] referenced existing Issue and/or provided relevant link to mailing list?
<!-- Please don't open a new Issue if you are submitting a pull request. -->
- [ ] verified that existing tests pass locally?
<!-- Please run the test-suite locally with pytest and make sure it passes. -->
- [ ] verified that the documentation builds locally?
<!-- Please build the documentation (i.e., type make in the "doc" directory) and make sure it finishes. -->
- [ ] squashed/minimized your commits and written descriptive commit messages?
<!-- We value a clean history with useful commit messages. Ideally, you will take care of this
         before submitting a PR; otherwise you'll be asked to do so before merging. -->
- [ ] added or updated existing tests to cover the changes?
- [ ] updated the documentation and/or added an entry to the release notes (doc/whatsnew.rst)?
- [ ] added an example?
