#pragma once

#define VINYL_PREF_KEY "[VinylControl]"

const QString kVCGroup = QString("[Channel%1]");
constexpr int VINYL_STATUS_DISABLED = 0;
constexpr int VINYL_STATUS_OK = 1;
constexpr int VINYL_STATUS_WARNING = 2;
constexpr int VINYL_STATUS_ERROR = 3;

#define MIXXX_VINYL_SERATOCV02VINYLSIDEA "Serato CV02 Vinyl, Side A"
#define MIXXX_VINYL_SERATOCV02VINYLSIDEB "Serato CV02 Vinyl, Side B"
#define MIXXX_VINYL_SERATOCD "Serato CD"
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEA "Traktor Scratch MK1 Vinyl, Side A"
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEB "Traktor Scratch MK1 Vinyl, Side B"
#define MIXXX_VINYL_MIXVIBESDVS "MixVibes DVS V2 Vinyl"
#define MIXXX_VINYL_MIXVIBES7INCH "MixVibes 7 inch"
#define MIXXX_VINYL_PIONEERA "Pioneer RekordBox DVS Control Vinyl, Side A"
#define MIXXX_VINYL_PIONEERB "Pioneer RekordBox DVS Control Vinyl, Side B"

#define MIXXX_VINYL_SERATOCV02VINYLSIDEA_XWAX_NAME "serato_2a"
#define MIXXX_VINYL_SERATOCV02VINYLSIDEB_XWAX_NAME "serato_2b"
#define MIXXX_VINYL_SERATOCD_XWAX_NAME "serato_cd"
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEA_XWAX_NAME "traktor_a"
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEB_XWAX_NAME "traktor_b"
#define MIXXX_VINYL_MIXVIBESDVS_XWAX_NAME "mixvibes_v2"
#define MIXXX_VINYL_MIXVIBES7INCH_XWAX_NAME "mixvibes_7inch"
#define MIXXX_VINYL_PIONEERA_XWAX_NAME "pioneer_a"
#define MIXXX_VINYL_PIONEERB_XWAX_NAME "pioneer_b"

#define MIXXX_VINYL_DEFAULT_XWAX_NAME MIXXX_VINYL_SERATOCV02VINYLSIDEA_XWAX_NAME

// Default recommended leadin times for various vinyl types.
#define MIXXX_VINYL_SERATOCV02VINYLSIDEA_LEADIN 28
#define MIXXX_VINYL_SERATOCV02VINYLSIDEB_LEADIN 28
#define MIXXX_VINYL_SERATOCD_LEADIN 0
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEA_LEADIN 10
#define MIXXX_VINYL_TRAKTORSCRATCHSIDEB_LEADIN 10
#define MIXXX_VINYL_MIXVIBESDVS_LEADIN 0
#define MIXXX_VINYL_MIXVIBES7INCH_LEADIN 0
#define MIXXX_VINYL_PIONEERA_LEADIN 10
#define MIXXX_VINYL_PIONEERB_LEADIN 10

#define MIXXX_VINYL_SPEED_33 "33.3 RPM"
#define MIXXX_VINYL_SPEED_45 "45 RPM"

#define MIXXX_VINYL_PITCH_FILTER_LEGACY "Alpha-Beta filter (fast)"
#define MIXXX_VINYL_PITCH_FILTER_KALMAN "Kalman filter (accurate)"

#define MIXXX_VINYL_SPEED_33_NUM (100.0 / 3.0)
#define MIXXX_VINYL_SPEED_45_NUM 45.0

#define MIXXX_VCMODE_ABSOLUTE 0
#define MIXXX_VCMODE_RELATIVE 1
#define MIXXX_VCMODE_CONSTANT  2

#define MIXXX_RELATIVE_CUE_OFF 0
#define MIXXX_RELATIVE_CUE_ONECUE 1
#define MIXXX_RELATIVE_CUE_HOTCUE 2

#define MIXXX_VC_DEFAULT_LEADINTIME 0

#define MIXXX_VINYL_SCOPE_UPDATE_LATENCY_MS 66
#define MIXXX_VINYL_SCOPE_SIZE 100

constexpr int kMaximumVinylControlInputs = 4;
