% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_stat_to_d.R, R/convert_stat_to_r.R
\name{t_to_d}
\alias{t_to_d}
\alias{z_to_d}
\alias{F_to_d}
\alias{t_to_r}
\alias{z_to_r}
\alias{F_to_r}
\title{Convert \emph{t}, \emph{z}, and \emph{F} to Cohen's \emph{d} or \strong{partial}-\emph{r}}
\usage{
t_to_d(t, df_error, paired = FALSE, ci = 0.95, alternative = "two.sided", ...)

z_to_d(z, n, paired = FALSE, ci = 0.95, alternative = "two.sided", ...)

F_to_d(
  f,
  df,
  df_error,
  paired = FALSE,
  ci = 0.95,
  alternative = "two.sided",
  ...
)

t_to_r(t, df_error, ci = 0.95, alternative = "two.sided", ...)

z_to_r(z, n, ci = 0.95, alternative = "two.sided", ...)

F_to_r(f, df, df_error, ci = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{t, f, z}{The t, the F or the z statistics.}

\item{paired}{Should the estimate account for the t-value being testing the
difference between dependent means?}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{...}{Arguments passed to or from other methods.}

\item{n}{The number of observations (the sample size).}

\item{df, df_error}{Degrees of freedom of numerator or of the error estimate
(i.e., the residuals).}
}
\value{
A data frame with the effect size(s)(\code{r} or \code{d}), and their CIs
(\code{CI_low} and \code{CI_high}).
}
\description{
These functions are convenience functions to convert t, z and F test
statistics to Cohen's d and \strong{partial} r. These are useful in cases where
the data required to compute these are not easily available or their
computation is not straightforward (e.g., in liner mixed models, contrasts,
etc.).
\cr
See \href{https://easystats.github.io/effectsize/articles/from_test_statistics.html}{Effect Size from Test Statistics vignette.}
}
\details{
These functions use the following formulae to approximate \emph{r} and \emph{d}:
\cr\cr
\deqn{r_{partial} = t / \sqrt{t^2 + df_{error}}}
\cr\cr
\deqn{r_{partial} = z / \sqrt{z^2 + N}}
\cr\cr
\deqn{d = 2 * t / \sqrt{df_{error}}}
\cr\cr
\deqn{d_z = t / \sqrt{df_{error}}}
\cr\cr
\deqn{d = 2 * z / \sqrt{N}}

The resulting \code{d} effect size is an \emph{approximation} to Cohen's \emph{d}, and
assumes two equal group sizes. When possible, it is advised to directly
estimate Cohen's \emph{d}, with \code{\link[=cohens_d]{cohens_d()}}, \code{emmeans::eff_size()}, or similar
functions.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
## t Tests
res <- t.test(1:10, y = c(7:20), var.equal = TRUE)
t_to_d(t = res$statistic, res$parameter)
t_to_r(t = res$statistic, res$parameter)
t_to_r(t = res$statistic, res$parameter, alternative = "less")

res <- with(sleep, t.test(extra[group == 1], extra[group == 2], paired = TRUE))
t_to_d(t = res$statistic, res$parameter, paired = TRUE)
t_to_r(t = res$statistic, res$parameter)
t_to_r(t = res$statistic, res$parameter, alternative = "greater")

\dontshow{if (require(correlation)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Linear Regression
model <- lm(rating ~ complaints + critical, data = attitude)
(param_tab <- parameters::model_parameters(model))

(rs <- t_to_r(param_tab$t[2:3], param_tab$df_error[2:3]))

# How does this compare to actual partial correlations?
correlation::correlation(attitude,
  select = "rating",
  select2 = c("complaints", "critical"),
  partial = TRUE
)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Friedman, H. (1982). Simplified determinations of statistical power,
magnitude of effect and research sample sizes. Educational and Psychological
Measurement, 42(2), 521-526. \doi{10.1177/001316448204200214}
\item Wolf, F. M. (1986). Meta-analysis: Quantitative methods for research
synthesis (Vol. 59). Sage.
\item Rosenthal, R. (1994) Parametric measures of effect size. In H. Cooper and
L.V. Hedges (Eds.). The handbook of research synthesis. New York: Russell
Sage Foundation.
\item Steiger, J. H. (2004). Beyond the F test: Effect size confidence intervals
and tests of close fit in the analysis of variance and contrast analysis.
Psychological Methods, 9, 164-182.
\item Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and
calculation of confidence intervals that are based on central and noncentral
distributions. Educational and Psychological Measurement, 61(4), 532-574.
}
}
\seealso{
\code{\link[=cohens_d]{cohens_d()}}

Other effect size from test statistic: 
\code{\link{F_to_eta2}()},
\code{\link{chisq_to_phi}()}
}
\concept{effect size from test statistic}
