% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{forecast.theta_model}
\alias{forecast.theta_model}
\alias{thetaf}
\title{Theta method forecasts.}
\usage{
\method{forecast}{theta_model}(
  object,
  h = if (frequency(object$y) > 1) 2 * frequency(object$y) else 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = object$lambda,
  biasadj = FALSE,
  ...
)

thetaf(
  y,
  h = if (frequency(y) > 1) 2 * frequency(y) else 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  x = y,
  ...
)
}
\arguments{
\item{object}{An object of class \code{theta_model} created by \code{\link[=theta_model]{theta_model()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{...}{Other arguments passed to \code{forecast.ets}.}

\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{x}{Deprecated. Included for backwards compatibility.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and prediction intervals for a theta method forecast.
\code{thetaf()} is a convenience function that combines \code{theta_model()} and
\code{forecast.theta_model()}.
The theta method of Assimakopoulos and Nikolopoulos (2000) is equivalent to
simple exponential smoothing with drift (Hyndman and Billah, 2003).
The series is tested for seasonality using the test outlined in A&N. If
deemed seasonal, the series is seasonally adjusted using a classical
multiplicative decomposition before applying the theta method. The resulting
forecasts are then reseasonalized.
Prediction intervals are computed using the underlying state space model.
}
\details{
More general theta methods are available in the \CRANpkg{forecTheta}
package.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
nile_fit <- theta_model(Nile)
forecast(nile_fit) |> autoplot()
}
\references{
Assimakopoulos, V. and Nikolopoulos, K. (2000). The theta model:
a decomposition approach to forecasting. \emph{International Journal of
Forecasting} \bold{16}, 521-530.

Hyndman, R.J., and Billah, B. (2003) Unmasking the Theta method.
\emph{International J. Forecasting}, \bold{19}, 287-290.
}
\seealso{
\code{\link[stats:arima]{stats::arima()}}, \code{\link[=meanf]{meanf()}}, \code{\link[=rwf]{rwf()}}, \code{\link[=ses]{ses()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
