% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-.R, R/annotation-custom.R,
%   R/annotation-logticks.R, R/geom-polygon.R, R/geom-map.R, R/annotation-map.R,
%   R/geom-raster.R, R/annotation-raster.R, R/geom-abline.R, R/geom-rect.R,
%   R/geom-bar.R, R/geom-tile.R, R/geom-bin2d.R, R/geom-blank.R,
%   R/geom-boxplot.R, R/geom-col.R, R/geom-path.R, R/geom-contour.R,
%   R/geom-point.R, R/geom-crossbar.R, R/geom-segment.R, R/geom-curve.R,
%   R/geom-ribbon.R, R/geom-density.R, R/geom-density2d.R, R/geom-dotplot.R,
%   R/geom-errorbar.R, R/geom-function.R, R/geom-hex.R, R/geom-hline.R,
%   R/geom-label.R, R/geom-linerange.R, R/geom-pointrange.R, R/geom-quantile.R,
%   R/geom-rug.R, R/geom-smooth.R, R/geom-spoke.R, R/geom-text.R,
%   R/geom-violin.R, R/geom-vline.R
\docType{data}
\name{Geom}
\alias{Geom}
\alias{GeomCustomAnn}
\alias{GeomLogticks}
\alias{GeomPolygon}
\alias{GeomMap}
\alias{GeomAnnotationMap}
\alias{GeomRaster}
\alias{GeomRasterAnn}
\alias{GeomAbline}
\alias{GeomRect}
\alias{GeomBar}
\alias{GeomTile}
\alias{GeomBin2d}
\alias{GeomBlank}
\alias{GeomBoxplot}
\alias{GeomCol}
\alias{GeomPath}
\alias{GeomLine}
\alias{GeomStep}
\alias{GeomContour}
\alias{GeomContourFilled}
\alias{GeomPoint}
\alias{GeomCrossbar}
\alias{GeomSegment}
\alias{GeomCurve}
\alias{GeomRibbon}
\alias{GeomArea}
\alias{GeomDensity}
\alias{GeomDensity2d}
\alias{GeomDensity2dFilled}
\alias{GeomDotplot}
\alias{GeomErrorbar}
\alias{GeomErrorbarh}
\alias{GeomFunction}
\alias{GeomHex}
\alias{GeomHline}
\alias{GeomLabel}
\alias{GeomLinerange}
\alias{GeomPointrange}
\alias{GeomQuantile}
\alias{GeomRug}
\alias{GeomSmooth}
\alias{GeomSpoke}
\alias{GeomText}
\alias{GeomViolin}
\alias{GeomVline}
\title{Geoms}
\description{
All \verb{geom_*()} functions (like \code{geom_point()}) return a layer that
contains a \verb{Geom*} object (like \code{GeomPoint}). The \verb{Geom*}
object is responsible for rendering the data in the plot.
}
\details{
Each of the \verb{Geom*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Geom}, and each implements various methods and
fields. The object and its parameters are chaperoned by the \link{Layer} class.

Compared to \code{Stat} and \code{Position}, \code{Geom} is a little
different because the execution of the setup and compute functions is
split up. \code{setup_data} runs before position adjustments, and
\code{draw_layer()} is not run until render time, much later.

When creating a new Geom class, you may want to consider override one or
more of the following:
\itemize{
\item The \code{required_aes} and \code{default_aes} fields.
\item The \code{setup_data()} and \code{setup_params()} functions.
\item Either the \code{draw_panel()} or \code{draw_group()} function.
\item The \code{draw_key} field.
}
}
\section{Fields}{

\describe{
\item{\code{required_aes}}{A character vector naming aesthetics that are necessary
to render the geom.}

\item{\code{non_missing_aes}}{A character vector naming aesthetics that will cause
removal if they have missing values.}

\item{\code{optional_aes}}{A character vector naming aesthetics that will be
accepted by \code{layer()}, but are not required or described in the
\code{default_aes} field.}

\item{\code{default_aes}}{A \link[=aes]{mapping} of default values for aesthetics.
Aesthetics can be set to \code{NULL} to be included as optional aesthetic.}

\item{\code{rename_size}}{A scalar boolean: whether to rename \code{size} aesthetics to \code{linewidth}.}

\item{\code{extra_params}}{A character vector of parameter names in addition to
those imputed from the \code{draw_panel()} or \code{draw_groups()} methods. This
field can be set to include parameters for \code{setup_data()} or \code{handle_na()}
methods. By default, this only contains \code{"na.rm"}.}

\item{\code{draw_key}}{A function generating a single legend glyph for the geom.
Typically one of the functions prefixed by \code{\link[=draw_key]{draw_key_}}.}

\item{\code{setup_params}}{\strong{Description}

A function method for modifying or checking the parameters based on the
data. The default method returns the parameters unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$setup_params(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of current parameters.}
}

\strong{Value}

A list of parameters}

\item{\code{setup_data}}{\strong{Description}

A function method for modifying or checking the data prior to adding
defaults. The default method returns data unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$setup_data(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A data frame with layer data}

\item{\code{use_defaults}}{\strong{Description}

A function method for completing the layer data by filling in default
aesthetics that are not present. It is not recommended to use as an
extension point.

It takes on these tasks:
\itemize{
\item Evaluation of default aesthetics from the \code{default_aes} field.
\item Handling the \code{\link[=after_scale]{after_scale()}}/\code{stage(after_scale)} stage of delayed
evaluation.
\item Fill in fixed, unmapped aesthetics passed as parameters.
}

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$use_defaults(data, params, modifiers, default_aes, theme, ...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame of the layer's data, coming from the
\code{setup_data()} method. Can be \code{NULL}, in which case resolved defaults
should be returned.}
\item{\code{params}}{A list of fixed aesthetic parameters}
\item{\code{modifiers}}{A \link[=aes]{mapping} with delayed evaluations.}
\item{\code{default_aes}}{A \link[=aes]{mapping} with default aesthetics.}
\item{\code{theme}}{A \link[=complete_theme]{completed theme}.}
}

\strong{Value}

A data frame with completed layer data.}

\item{\code{handle_na}}{\strong{Description}

A function method to handle missing values. The default method will
remove rows that have missing values for the aesthetics listed in the
\code{required_aes} and \code{non_missing_aes} fields. It is not recommended to
use this method as an extension point.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$handle_na(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data coming from the
\code{update_defaults()} method.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method}
}

\strong{Value}

A data frame with layer data}

\item{\code{draw_layer}}{\strong{Description}

A function method orchestrating the drawing of the entire layer. The
default method splits the data and passes on drawing tasks to the
panel-level \code{draw_panel()} method. It is not recommended to use this method
as an extension point.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$draw_layer(data, params, layout, coord)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of parameters}
\item{\code{layout}}{A completed \verb{<Layout>} ggproto object.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
}

\strong{Value}

A list of grobs, one per panel}

\item{\code{draw_panel,draw_group}}{\strong{Description}

A function method orchestrating the drawing of the layer for a single
panel or group. The default \code{draw_panel()} method splits the data into groups,
passes on the drawing tasks to the group-level \code{draw_group()} method and
finally assembles these into a single grob. The default \code{draw_group} method
is not implemented.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$draw_panel(data, panel_params, coord, ...)
Geom$draw_group(data, panel_params, coord, ...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{panel_params}}{A list of per-panel parameters constructed by
\code{Coord$setup_panel_params()}. This should be considered an opaque data
structure that is just passed along when calling coord methods.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object. To correctly scale the
position data, one should always call
\code{coord$transform(data, panel_params)}. When working with non-linear
coordinate systems, data should be converted to fit a primitive geom
(e.g. point, path or polygon) and passed on to the corresponding draw
method for \link[=coord_munch]{munching}.}
\item{\code{...}}{Reserved for extensions. By default, this is passed on to
the \code{draw_group()} method.}
}

\strong{Value}

A single grob or \code{\link[=zeroGrob]{zeroGrob()}} when there is nothing to draw. For
\code{draw_panel()} this can be a \link[grid:grid.grob]{gTree} holding individual grobs
from the \code{draw_group()} method.}

\item{\code{parameters}}{\strong{Description}

A function method for listing out all acceptable parameters for this geom.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$parameters(extra)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{extra}}{A boolean: whether to include the \code{extra_params} field.}
}

\strong{Value}

A character vector of parameter names.}

\item{\code{aesthetics}}{\strong{Description}

A function method for listing out all acceptable aesthetics for this geom.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Geom$aesthetics()
}\if{html}{\out{</div>}}

\strong{Value}

A character vector of aesthetic names.}
}}

\section{Conventions}{


The object name that a new class is assigned to is typically the same as
the class name. Geom class names are in UpperCamelCase and start with the
\verb{Geom*} prefix, like \code{GeomNew}.

A constructor function is usually paired with a Geom class. The constructor
wraps a call to \code{layer()}, where e.g. \code{layer(geom = GeomNew)}. The constructor
function name is formatted by taking the Geom class name and formatting it
with snake_case, so that \code{GeomNew} becomes \code{geom_new()}.
}

\examples{
# Extending the class
GeomSimplePoint <- ggproto(
  "GeomSimplePoint", Geom,
  # Fields
  required_aes = c("x", "y"),
  draw_key     = draw_key_point,
  # Methods
  draw_panel = function(data, panel_params, coord) {
    data <- coord$transform(data, panel_params)
    grid::pointsGrob(data$x, data$y)
  }
)

# Building a constructor
geom_simple_point <- function(mapping = NULL, data = NULL, stat = "identity",
                              position = "identity", ..., na.rm = FALSE,
                              show.legend = NA, inherit.aes = TRUE) {
  layer(
    mapping = mapping, data = data,
    geom = GeomSimplePoint, stat = stat, position = position,
    show.legend = show.legend, inherit.aes = inherit.aes,
    params = list(na.rm = na.rm, ...)
  )
}

# Use new geom in plot
ggplot(mpg, aes(displ, hwy)) +
  geom_simple_point()
}
\seealso{
The \href{https://ggplot2-book.org/extensions#sec-new-geoms}{new geoms section} of the online ggplot2 book.

Run \code{vignette("extending-ggplot2")}, in particular the "Creating a
new geom" section.

Other Layer components: 
\code{\link{Layer-class}},
\code{\link{Position}},
\code{\link{Stat}}
}
\concept{Layer components}
\keyword{datasets}
\keyword{internal}
