#define XERR "group"
#include "group.ih"

//  e.g.,   40 - 50:
//          70 - * :
// separating blanks are optional, the initial age is optional except for 
// the first age-range

    // by group.f (operator>>)

std::istream &Group::extract(std::istream &in)
{
    char sep = 0;

    if (d_series == SINGLE)                     // with SINGLE d_begin is not
    {                                           // used. d_end is inclusive
        in >> sep;                              // maybe '*', then the max
        if (sep == '*')                         // possible value
            d_end = Globals::uint16_max;
        else
        {
            in.unget();                         // or extract the inclusive
            in >> d_end;                        // end value
        }
    }
    else
    {                                           // get '40 - 50', or '70 - *'
        if (in >> d_begin >> sep >> sep)
        {
            if (d_begin < 0)
                Err::msg(Err::NEGATIVE) << d_begin << endl;
        }
        else                                    // no d_begin, then connect
        {                                       // to the previous range
            d_begin = -1;
            in.clear();
            in >> sep;                          // 1st - read by in >> d_begin
        }

        if (sep == '*')
            d_end = END_AGE;                    // either set end-age
        else
        {
            in.unget();                         // or extract the age
            in >> d_end;
        }
    }

    if (not (in >> sep) or sep != ':')      // group must end in ':'
        Err::msgTxt(Err::GROUP_NO_COLON);

    return in;                              // return
}
