/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.memoize;

import aQute.bnd.memoize.Memoize;
import java.util.Objects;
import java.util.function.Supplier;

class MemoizingSupplier<T>
implements Memoize<T> {
    private volatile boolean initial;
    private Object memoized;

    MemoizingSupplier(Supplier<? extends T> supplier) {
        this.memoized = Objects.requireNonNull(supplier);
        this.initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.initial) {
            MemoizingSupplier memoizingSupplier = this;
            synchronized (memoizingSupplier) {
                if (this.initial) {
                    Object result = ((Supplier)this.memoized).get();
                    this.memoized = result;
                    this.initial = false;
                    return result;
                }
            }
        }
        return (T)this.memoized;
    }

    @Override
    public T peek() {
        if (this.initial) {
            return null;
        }
        return (T)this.memoized;
    }

    @Override
    public boolean isPresent() {
        return !this.initial;
    }

    public String toString() {
        return this.initial ? "<empty>" : String.valueOf(this.memoized);
    }
}

