/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyWriter;
import org.openhab.core.io.rest.JSONInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    private final Logger logger = LoggerFactory.getLogger(GsonMessageBodyWriter.class);
    private final Gson gson;

    public GsonMessageBodyWriter(Gson gson) {
        this.gson = gson;
    }

    public long getSize(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void writeTo(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (object == null) {
            return;
        }
        if (object instanceof Response.ResponseBuilder) {
            this.logger.error("A REST endpoint returns a ResponseBuilder object. This is mostly wrong and the call to \"build()\" is missing. Please report or fix it. Got: {}", object);
        }
        try {
            var9_8 = object;
            if (!(var9_8 instanceof InputStream)) ** GOTO lbl-1000
            var8_9 = (InputStream)var9_8;
            (InputStream)var9_8;
            if (object instanceof JSONInputStream) {
                stream.transferTo(entityStream);
            } else if ((var11_11 = object) instanceof StreamingOutput) {
                var10_12 = (StreamingOutput)var11_11;
                (StreamingOutput)var11_11;
                streaming.write(entityStream);
            } else {
                entityStream.write(this.gson.toJson(object).getBytes(StandardCharsets.UTF_8));
            }
            entityStream.flush();
        }
        catch (IOException e) {
            this.logger.debug("Failed writing HTTP response, since other side closed the connection", (Throwable)e);
        }
    }
}

