/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

@NoPublicAPI
public final class ReassemblingHandshakeMessage
extends GenericHandshakeMessage {
    private final byte[] reassembledBytes;
    private final HandshakeType type;
    private final List<FragmentRange> fragments = new ArrayList<FragmentRange>();

    public ReassemblingHandshakeMessage(FragmentedHandshakeMessage message) {
        super(message.getMessageType(), message.getPeer());
        this.setMessageSeq(message.getMessageSeq());
        this.type = message.getMessageType();
        this.reassembledBytes = new byte[message.getMessageLength()];
        this.add(0, 0, new FragmentRange(message.getFragmentOffset(), message.getFragmentLength()), message);
    }

    public boolean isComplete() {
        FragmentRange firstRange = this.fragments.get(0);
        return firstRange.offset == 0 && this.getMessageLength() <= firstRange.end;
    }

    public void add(FragmentedHandshakeMessage message) {
        int position;
        if (this.type != message.getMessageType()) {
            throw new IllegalArgumentException("Fragment message type " + (Object)((Object)message.getMessageType()) + " differs from " + (Object)((Object)this.type) + "!");
        }
        if (this.getMessageSeq() != message.getMessageSeq()) {
            throw new IllegalArgumentException("Fragment message sequence number " + message.getMessageSeq() + " differs from " + this.getMessageSeq() + "!");
        }
        if (this.getMessageLength() != message.getMessageLength()) {
            throw new IllegalArgumentException("Fragment message length " + message.getMessageLength() + " differs from " + this.getMessageLength() + "!");
        }
        if (!this.getPeer().equals(message.getPeer())) {
            throw new IllegalArgumentException("Fragment message peer " + message.getPeer() + " differs from " + this.getPeer() + "!");
        }
        if (this.isComplete()) {
            return;
        }
        FragmentRange newRange = new FragmentRange(message.getFragmentOffset(), message.getFragmentLength());
        if (this.getMessageLength() < newRange.end) {
            throw new IllegalArgumentException("Fragment message " + newRange.end + " bytes exceeds message " + this.getMessageLength() + " bytes!");
        }
        int end = 0;
        for (position = 0; position < this.fragments.size(); ++position) {
            FragmentRange currentRange = this.fragments.get(position);
            if (newRange.offset < currentRange.offset) {
                if (currentRange.offset >= newRange.end || newRange.end > currentRange.end) break;
                newRange.reduceEnd(currentRange.offset);
                break;
            }
            if (newRange.end <= currentRange.end) {
                return;
            }
            if (newRange.offset == currentRange.offset) {
                ++position;
                break;
            }
            end = currentRange.end;
        }
        int skip = newRange.skipToOffset(end);
        if (newRange.length == 0) {
            return;
        }
        this.add(position, skip, newRange, message);
        FragmentRange currentRange = this.fragments.get(0);
        for (position = 1; position < this.fragments.size(); ++position) {
            FragmentRange nextRange = this.fragments.get(position);
            if (nextRange.offset <= currentRange.end) {
                currentRange.amendEnd(nextRange.end);
                this.fragments.remove(position);
                --position;
                continue;
            }
            currentRange = nextRange;
        }
    }

    private void add(int position, int skip, FragmentRange range, FragmentedHandshakeMessage message) {
        this.fragments.add(position, range);
        System.arraycopy(message.fragmentToByteArray(), skip, this.reassembledBytes, range.offset, range.length);
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.reassembledBytes.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tReassembled Handshake Protocol");
        sb.append(StringUtil.lineSeparator()).append("\tType: ").append((Object)this.getMessageType());
        sb.append(StringUtil.lineSeparator()).append("\tPeer: ").append(this.getPeer());
        sb.append(StringUtil.lineSeparator()).append("\tMessage Sequence No: ").append(this.getMessageSeq());
        sb.append(StringUtil.lineSeparator()).append("\tFragment Offset: ").append(this.getFragmentOffset());
        sb.append(StringUtil.lineSeparator()).append("\tFragment Length: ").append(this.getFragmentLength());
        sb.append(StringUtil.lineSeparator()).append("\tLength: ").append(this.getMessageLength());
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.reassembledBytes;
    }

    List<Object> getRanges() {
        return new ArrayList<Object>(this.fragments);
    }

    private static class FragmentRange {
        private int offset;
        private int length;
        private int end;

        private FragmentRange(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.end = offset + length;
        }

        private void reduceEnd(int end) {
            if (this.end > end) {
                if (end < this.offset) {
                    throw new IllegalArgumentException("adjusted end before offset!");
                }
                this.end = end;
                this.length = this.end - this.offset;
            }
        }

        private void amendEnd(int end) {
            if (this.end < end) {
                this.end = end;
                this.length = this.end - this.offset;
            }
        }

        private int skipToOffset(int offset) {
            int skip = 0;
            if (this.offset < offset) {
                if (this.end <= offset) {
                    this.length = 0;
                    this.offset = offset;
                    this.end = offset;
                } else {
                    skip = offset - this.offset;
                    this.offset = offset;
                    this.length = this.end - this.offset;
                }
            }
            return skip;
        }

        public String toString() {
            return String.format("range[%d:%d)", this.offset, this.end);
        }
    }
}

