/* gupnp-1.6.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GUPnP", gir_namespace = "GUPnP", gir_version = "1.6", lower_case_cprefix = "gupnp_")]
namespace GUPnP {
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_bin_base64_get_type ()")]
	[Compact]
	public class BinBase64 {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_bin_hex_get_type ()")]
	[Compact]
	public class BinHex {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_context_get_type ()")]
	public class Context : GSSDP.Client, GLib.Initable {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "1.6.")]
		public Context (string? iface, uint port) throws GLib.Error;
		[Version (since = "0.20.11")]
		public void add_server_handler (bool use_acl, string path, owned Soup.ServerCallback callback);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6.")]
		public Context.for_address (GLib.InetAddress? addr, uint16 port, GSSDP.UDAVersion uda_version) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "1.6.")]
		public Context.full (string? iface, GLib.InetAddress? addr, uint16 port, GSSDP.UDAVersion uda_version) throws GLib.Error;
		[Version (since = "0.20.11")]
		public unowned GUPnP.Acl get_acl ();
		[Version (since = "0.18.0")]
		public unowned string get_default_language ();
		public uint get_port ();
		public unowned Soup.Server get_server ();
		[Version (since = "0.12.3")]
		public unowned Soup.Session get_session ();
		public uint get_subscription_timeout ();
		public void host_path (string local_path, string server_path);
		[Version (since = "0.14.0")]
		public bool host_path_for_agent (string local_path, string server_path, GLib.Regex user_agent);
		[Version (since = "0.20.11")]
		public void remove_server_handler (string path);
		[Version (since = "1.2.0")]
		public string rewrite_uri (string uri);
		[Version (since = "0.20.11")]
		public void set_acl (GUPnP.Acl? acl);
		[Version (since = "0.18.0")]
		public void set_default_language (string language);
		public void set_subscription_timeout (uint timeout);
		public void unhost_path (string server_path);
		[Version (since = "0.20.11")]
		public GUPnP.Acl acl { get; set construct; }
		[Version (since = "0.18.0")]
		public string default_language { get; set construct; }
		public Soup.Server server { get; }
		public Soup.Session session { get; }
		public uint subscription_timeout { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_context_filter_get_type ()")]
	[Version (since = "1.4.0")]
	public class ContextFilter : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ContextFilter ();
		public bool add_entry (string entry);
		public void add_entryv ([CCode (array_length = false, array_null_terminated = true)] string[] entries);
		public bool check_context (GUPnP.Context context);
		public void clear ();
		public bool get_enabled ();
		public GLib.List<weak string>? get_entries ();
		public bool is_empty ();
		public bool remove_entry (string entry);
		public void set_enabled (bool enable);
		public bool enabled { get; set construct; }
		public GLib.List<string> entries { owned get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_context_manager_get_type ()")]
	[Version (since = "0.14.0")]
	public abstract class ContextManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ContextManager ();
		[Version (since = "0.18.0")]
		public static GUPnP.ContextManager create (uint port);
		[Version (since = "1.2.0")]
		public static GUPnP.ContextManager create_full (GSSDP.UDAVersion uda_version, GLib.SocketFamily family, uint port);
		[Version (since = "1.4.0")]
		public unowned GUPnP.ContextFilter get_context_filter ();
		[Version (since = "0.20.0")]
		public uint get_port ();
		[Version (since = "1.2.0")]
		public GLib.SocketFamily get_socket_family ();
		[Version (since = "1.2.0")]
		public GSSDP.UDAVersion get_uda_version ();
		public void manage_control_point (GUPnP.ControlPoint control_point);
		public void manage_root_device (GUPnP.RootDevice root_device);
		[Version (since = "0.20.3")]
		public void rescan_control_points ();
		public GUPnP.ContextFilter context_filter { get; }
		[NoAccessorMethod]
		[Version (since = "1.2.0")]
		public GLib.SocketFamily family { get; construct; }
		public uint port { get; construct; }
		[Version (since = "1.2.0")]
		public GSSDP.UDAVersion uda_version { get; construct; }
		public signal void context_available (GUPnP.Context context);
		public signal void context_unavailable (GUPnP.Context context);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_control_point_get_type ()")]
	public class ControlPoint : GSSDP.ResourceBrowser {
		[CCode (has_construct_function = false)]
		public ControlPoint (GUPnP.Context context, string target);
		[CCode (has_construct_function = false)]
		public ControlPoint.full (GUPnP.Context context, GUPnP.ResourceFactory factory, string target);
		[Version (deprecated = true, deprecated_since = "1.4.0")]
		public unowned GUPnP.Context get_context ();
		public unowned GUPnP.ResourceFactory get_resource_factory ();
		public unowned GLib.List<GUPnP.DeviceProxy> list_device_proxies ();
		public unowned GLib.List<GUPnP.ServiceProxy> list_service_proxies ();
		public GUPnP.ResourceFactory resource_factory { get; construct; }
		public virtual signal void device_proxy_available (GUPnP.DeviceProxy proxy);
		public virtual signal void device_proxy_unavailable (GUPnP.DeviceProxy proxy);
		public virtual signal void service_proxy_available (GUPnP.ServiceProxy proxy);
		public virtual signal void service_proxy_unavailable (GUPnP.ServiceProxy proxy);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_date_get_type ()")]
	[Compact]
	public class Date {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_date_time_get_type ()")]
	[Compact]
	public class DateTime {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_date_time_tz_get_type ()")]
	[Compact]
	public class DateTimeTZ {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_device_get_type ()")]
	public class Device : GUPnP.DeviceInfo {
		[CCode (has_construct_function = false)]
		protected Device ();
		[NoAccessorMethod]
		public GUPnP.RootDevice root_device { owned get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_device_info_get_type ()")]
	public abstract class DeviceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DeviceInfo ();
		public unowned GUPnP.Context get_context ();
		[Version (since = "0.14.0")]
		public string? get_description_value (string element);
		public GUPnP.DeviceInfo? get_device (string type);
		public unowned string get_device_type ();
		public string? get_friendly_name ();
		public async GLib.Bytes get_icon_async (string? requested_mime_type, int requested_depth, int requested_width, int requested_height, bool prefer_bigger, GLib.Cancellable? cancellable, out string mime, out int depth, out int width, out int height) throws GLib.Error;
		public string? get_icon_url (string? requested_mime_type, int requested_depth, int requested_width, int requested_height, bool prefer_bigger, out string mime_type, out int depth, out int width, out int height);
		public unowned string get_location ();
		public string? get_manufacturer ();
		public string? get_manufacturer_url ();
		public string? get_model_description ();
		public string? get_model_name ();
		public string? get_model_number ();
		public string? get_model_url ();
		public string? get_presentation_url ();
		public unowned GUPnP.ResourceFactory get_resource_factory ();
		public string? get_serial_number ();
		public GUPnP.ServiceInfo? get_service (string type);
		public unowned string get_udn ();
		public string? get_upc ();
		public unowned GLib.Uri get_url_base ();
		public GLib.List<string>? list_device_types ();
		public GLib.List<GUPnP.DeviceInfo>? list_devices ();
		[Version (since = "0.14.0")]
		public GLib.List<string>? list_dlna_capabilities ();
		[Version (since = "0.20.4")]
		public GLib.List<string>? list_dlna_device_class_identifier ();
		public GLib.List<string>? list_service_types ();
		public GLib.List<GUPnP.ServiceInfo>? list_services ();
		public GUPnP.Context context { get; construct; }
		public string device_type { get; construct; }
		[NoAccessorMethod]
		public GUPnP.XMLDoc document { owned get; set construct; }
		[NoAccessorMethod]
		public string location { owned get; set construct; }
		public GUPnP.ResourceFactory resource_factory { get; construct; }
		public string udn { get; construct; }
		[NoAccessorMethod]
		public GLib.Uri url_base { owned get; set construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_device_proxy_get_type ()")]
	public class DeviceProxy : GUPnP.DeviceInfo {
		[CCode (has_construct_function = false)]
		protected DeviceProxy ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_resource_factory_get_type ()")]
	public class ResourceFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		public ResourceFactory ();
		public static unowned GUPnP.ResourceFactory get_default ();
		public void register_resource_proxy_type (string upnp_type, GLib.Type type);
		public void register_resource_type (string upnp_type, GLib.Type type);
		public bool unregister_resource_proxy_type (string upnp_type);
		public bool unregister_resource_type (string upnp_type);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_root_device_get_type ()")]
	public class RootDevice : GUPnP.Device, GLib.Initable {
		[CCode (has_construct_function = false)]
		public RootDevice (GUPnP.Context context, string description_path, string description_folder) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public RootDevice.full (GUPnP.Context context, GUPnP.ResourceFactory factory, GUPnP.XMLDoc description_doc, string description_path, string description_folder) throws GLib.Error;
		public bool get_available ();
		public unowned string get_description_dir ();
		public unowned string get_description_document_name ();
		public unowned string get_description_path ();
		[Version (since = "0.20.0")]
		public unowned GSSDP.ResourceGroup get_ssdp_resource_group ();
		public void set_available (bool available);
		public bool available { get; set; }
		public string description_dir { get; construct; }
		[Version (since = "0.13.0")]
		public string description_path { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_service_get_type ()")]
	public class Service : GUPnP.ServiceInfo {
		[CCode (has_construct_function = false)]
		protected Service ();
		public void freeze_notify ();
		public void notify (...);
		public void notify_value (string variable, GLib.Value value);
		public void thaw_notify ();
		[NoAccessorMethod]
		public GUPnP.RootDevice root_device { owned get; construct; }
		[HasEmitter]
		public virtual signal void action_invoked (GUPnP.ServiceAction action);
		[HasEmitter]
		public virtual signal void notify_failed (GLib.List<GLib.Uri> callback_urls, GLib.Error reason);
		[HasEmitter]
		public virtual signal void query_variable (string variable, ref GLib.Value value);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_service_action_get_type ()")]
	[Compact]
	public class ServiceAction {
		public void @get (...);
		[Version (since = "0.18.0")]
		public uint get_argument_count ();
		[Version (since = "0.14.0")]
		public GLib.Value? get_gvalue (string argument, GLib.Type type);
		public GLib.List<string> get_locales ();
		[Version (since = "0.14.0")]
		public Soup.ServerMessage get_message ();
		public unowned string get_name ();
		public void get_value (string argument, ref GLib.Value value);
		[Version (since = "0.14.0")]
		public GLib.List<GLib.Value?> get_values (GLib.List<string> arg_names, GLib.List<GLib.Type?> arg_types);
		public void return_error (uint error_code, string error_description);
		[Version (since = "1.4.2")]
		public void return_success ();
		public void @set (...);
		public void set_value (string argument, GLib.Value value);
		[Version (since = "0.14.0")]
		public void set_values (GLib.List<string> arg_names, GLib.List<GLib.Value?> arg_values);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_service_action_arg_info_get_type ()")]
	[Compact]
	public class ServiceActionArgInfo {
		public GUPnP.ServiceActionArgDirection direction;
		public weak string name;
		public weak string related_state_variable;
		public bool retval;
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_service_action_info_get_type ()")]
	[Compact]
	public class ServiceActionInfo {
		public weak GLib.List<GUPnP.ServiceActionArgInfo> arguments;
		public weak string name;
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_service_info_get_type ()")]
	public abstract class ServiceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ServiceInfo ();
		public unowned GUPnP.Context get_context ();
		public string get_control_url ();
		public string get_event_subscription_url ();
		public string get_id ();
		public unowned string get_location ();
		public string get_scpd_url ();
		public unowned string get_service_type ();
		public unowned string get_udn ();
		public unowned GLib.Uri get_url_base ();
		[Version (since = "1.2.2")]
		public async GUPnP.ServiceIntrospection? introspect_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GUPnP.Context context { get; construct; }
		public string location { get; construct; }
		public string service_type { get; construct; }
		public string udn { get; construct; }
		public GLib.Uri url_base { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_service_introspection_get_type ()")]
	public class ServiceIntrospection : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected ServiceIntrospection ();
		public unowned GUPnP.ServiceActionInfo? get_action (string action_name);
		public unowned GUPnP.ServiceStateVariableInfo? get_state_variable (string variable_name);
		public unowned GLib.List<string> list_action_names ();
		public unowned GLib.List<GUPnP.ServiceActionInfo> list_actions ();
		public unowned GLib.List<string> list_state_variable_names ();
		public unowned GLib.List<GUPnP.ServiceStateVariableInfo> list_state_variables ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_service_proxy_get_type ()")]
	public class ServiceProxy : GUPnP.ServiceInfo {
		[CCode (has_construct_function = false)]
		protected ServiceProxy ();
		public bool add_notify (string variable, GLib.Type type, [CCode (scope = "async")] GUPnP.ServiceProxyNotifyCallback callback);
		[Version (since = "0.20.12")]
		public bool add_notify_full (string variable, GLib.Type type, owned GUPnP.ServiceProxyNotifyCallback callback);
		[Version (since = "0.20.12")]
		public bool add_raw_notify (owned GUPnP.ServiceProxyNotifyCallback callback);
		[Version (since = "1.2.0")]
		public unowned GUPnP.ServiceProxyAction? call_action (GUPnP.ServiceProxyAction action, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.2.0")]
		public async unowned GUPnP.ServiceProxyAction? call_action_async (GUPnP.ServiceProxyAction action, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_subscribed ();
		public bool remove_notify (string variable, GUPnP.ServiceProxyNotifyCallback callback);
		public bool remove_raw_notify (GUPnP.ServiceProxyNotifyCallback callback);
		[Version (since = "1.6.4")]
		public void set_credentials (string user, string password);
		public void set_subscribed (bool subscribed);
		public bool subscribed { get; set; }
		public virtual signal void subscription_lost (GLib.Error reason);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", ref_function = "gupnp_service_proxy_action_ref", type_id = "gupnp_service_proxy_action_get_type ()", unref_function = "gupnp_service_proxy_action_unref")]
	[Compact]
	public class ServiceProxyAction {
		[CCode (has_construct_function = false)]
		public ServiceProxyAction (string action, ...);
		[Version (since = "1.6.6")]
		public unowned GUPnP.ServiceProxyAction add_argument (string name, GLib.Value value);
		[CCode (has_construct_function = false)]
		public ServiceProxyAction.from_list (string action, GLib.List<string> in_names, GLib.List<GLib.Value?> in_values);
		public bool get_result (...) throws GLib.Error;
		[Version (since = "1.2.0")]
		public bool get_result_hash (ref unowned GLib.HashTable<string,GLib.Value?> out_hash) throws GLib.Error;
		[Version (since = "1.2.0")]
		public bool get_result_list (GLib.List<string> out_names, GLib.List<GLib.Type?> out_types, out GLib.List<GLib.Value?> out_values) throws GLib.Error;
		[Version (since = "1.6.6")]
		public GUPnP.ServiceProxyActionIter? iterate () throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "1.6.6")]
		public ServiceProxyAction.plain (string action);
		[Version (since = "1.2.0")]
		public GUPnP.ServiceProxyAction? @ref ();
		[Version (since = "1.4.0")]
		public bool @set (string key, GLib.Value value) throws GLib.Error;
		[Version (since = "1.2.0")]
		public void unref ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_service_proxy_action_iter_get_type ()")]
	[Version (since = "1.6.6")]
	public class ServiceProxyActionIter : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ServiceProxyActionIter ();
		public unowned string get_name ();
		public bool get_value (out GLib.Value value);
		public bool next ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_service_state_variable_info_get_type ()")]
	[Compact]
	public class ServiceStateVariableInfo {
		public weak GLib.List<string> allowed_values;
		public GLib.Value default_value;
		public bool is_numeric;
		public GLib.Value maximum;
		public GLib.Value minimum;
		public weak string name;
		public bool send_events;
		public GLib.Value step;
		public GLib.Type type;
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_time_get_type ()")]
	[Compact]
	public class Time {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_time_tz_get_type ()")]
	[Compact]
	public class TimeTZ {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_uri_get_type ()")]
	[Compact]
	public class URI {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gupnp_uuid_get_type ()")]
	[Compact]
	public class UUID {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_id = "gupnp_xml_doc_get_type ()")]
	[Version (since = "0.14.0")]
	public class XMLDoc : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		public XMLDoc (owned Xml.Doc xml_doc);
		[CCode (has_construct_function = false)]
		public XMLDoc.from_path (string path) throws GLib.Error;
		public unowned Xml.Doc get_doc ();
		[NoAccessorMethod]
		public void* doc { construct; }
		[NoAccessorMethod]
		public string path { construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", type_cname = "GUPnPAclInterface", type_id = "gupnp_acl_get_type ()")]
	[Version (since = "0.20.11")]
	public interface Acl : GLib.Object {
		public abstract bool can_sync ();
		public abstract bool is_allowed (GUPnP.Device? device, GUPnP.Service? service, string path, string address, string? agent);
		public abstract async bool is_allowed_async (GUPnP.Device? device, GUPnP.Service? service, string path, string address, string? agent, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_SERVICE_ACTION_ARG_DIRECTION_", type_id = "gupnp_service_action_arg_direction_get_type ()")]
	public enum ServiceActionArgDirection {
		IN,
		OUT
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_CONTROL_ERROR_", type_id = "gupnp_control_error_get_type ()")]
	public errordomain ControlError {
		INVALID_ACTION,
		INVALID_ARGS,
		OUT_OF_SYNC,
		ACTION_FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_EVENTING_ERROR_", type_id = "gupnp_eventing_error_get_type ()")]
	public errordomain EventingError {
		SUBSCRIPTION_FAILED,
		SUBSCRIPTION_LOST,
		NOTIFY_FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_ROOT_DEVICE_ERROR_", type_id = "gupnp_rootdevice_error_get_type ()")]
	public errordomain RootdeviceError {
		NO_CONTEXT,
		NO_DESCRIPTION_PATH,
		NO_DESCRIPTION_FOLDER,
		NO_NETWORK,
		FAIL;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_SERVER_ERROR_", type_id = "gupnp_server_error_get_type ()")]
	public errordomain ServerError {
		INTERNAL_SERVER_ERROR,
		NOT_FOUND,
		NOT_IMPLEMENTED,
		INVALID_RESPONSE,
		INVALID_URL,
		OTHER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_SERVICE_ERROR_", type_id = "gupnp_service_error_get_type ()")]
	public errordomain ServiceError {
		AUTOCONNECT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_SERVICE_INTROSPECTION_ERROR_", type_id = "gupnp_service_introspection_error_get_type ()")]
	public errordomain ServiceIntrospectionError {
		OTHER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", cprefix = "GUPNP_XML_ERROR_", type_id = "gupnp_xml_error_get_type ()")]
	public errordomain XMLError {
		PARSE,
		NO_NODE,
		EMPTY_NODE,
		INVALID_ATTRIBUTE,
		OTHER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h", instance_pos = 2.9)]
	[Version (deprecated = true, deprecated_since = "1.2.0")]
	public delegate void ServiceProxyActionCallback (GUPnP.ServiceProxy proxy, GUPnP.ServiceProxyAction action);
	[CCode (cheader_filename = "libgupnp/gupnp.h", instance_pos = 3.9)]
	public delegate void ServiceProxyNotifyCallback (GUPnP.ServiceProxy proxy, string variable, GLib.Value value);
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "ControlError.quark")]
	public static GLib.Quark control_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "EventingError.quark")]
	public static GLib.Quark eventing_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (deprecated = true, deprecated_since = "1.6.")]
	public static string get_uuid ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "RootdeviceError.quark")]
	public static GLib.Quark rootdevice_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "ServerError.quark")]
	public static GLib.Quark server_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "ServiceError.quark")]
	public static GLib.Quark service_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "ServiceIntrospectionError.quark")]
	public static GLib.Quark service_introspection_error_quark ();
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	[Version (replacement = "XMLError.quark")]
	public static GLib.Quark xml_error_quark ();
}
