/*
 * Copyright (c) 2017, 2021, 2025 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef ACL_SUPPORT_HALF_H
#define ACL_SUPPORT_HALF_H

#if defined(BARE_METAL)
#define HALF_ENABLE_CPP11_CMATH 0
#endif /* BARE_METAL */

// Set style to round to nearest
#define HALF_ROUND_STYLE        1
#define HALF_ROUND_TIES_TO_EVEN 1

// Treat the rest of this file as a system header (i.e, ignore warnings
// generated by it). This will not effect other translation units.
#if defined(__GNUC__) && !defined(__clang__)
#pragma GCC system_header
#elif defined(__clang__)
#pragma clang system_header
#endif
// CAUTION: All code below will be treated as system header code and will NOT be
// subject to warnings. Consider carefully if your code belongs here or above
// the system_header pragma.

#include "half/half.hpp"

#endif // ACL_SUPPORT_HALF_H
