/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ExportHandler
extends RequestHandler {
    public static final String command = "export";

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    public String[] getOptionalParams() {
        return new String[0];
    }

    @Override
    public String getUsage() {
        return "export data from JOSM";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/export"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        Layer layer = MainApplication.getLayerManager().getActiveLayer();
        if (!(layer instanceof OsmDataLayer)) {
            this.content = "";
            return;
        }
        OsmDataLayer osmLayer = (OsmDataLayer)layer;
        StringWriter sw = new StringWriter();
        OsmWriter w = OsmWriterFactory.createOsmWriter(new PrintWriter(sw), false, osmLayer.data.getVersion());
        osmLayer.data.getReadLock().lock();
        try {
            w.write(osmLayer.data);
        }
        finally {
            osmLayer.data.getReadLock().unlock();
        }
        this.contentType = "application/xml";
        this.content = sw.toString();
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to export data from JOSM", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.EXPORT_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
    }
}

