/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public final class OEmbedRequest
implements Serializable {
    private static final long serialVersionUID = 7454130135274547901L;
    public final long statusId;
    public final String url;
    public final int maxWidth;
    public final boolean hideMedia;
    public final boolean hideThread;
    public final boolean omitScript;
    public final Align align;
    public final String[] related;
    public final String lang;
    public final WidgetType widgetType;
    public final boolean hideTweet = false;

    public static OEmbedRequest of(long statusId, String url) {
        return new OEmbedRequest(statusId, url, -1, true, true, false, Align.NONE, new String[0], null, WidgetType.NONE);
    }

    private OEmbedRequest(long statusId, String url, int maxWidth, boolean hideMedia, boolean hideThread, boolean omitScript, Align align, String[] related, String lang, WidgetType widgetType) {
        this.statusId = statusId;
        this.url = url;
        this.maxWidth = maxWidth;
        this.hideMedia = hideMedia;
        this.hideThread = hideThread;
        this.omitScript = omitScript;
        this.align = align;
        this.related = related;
        this.lang = lang;
        this.widgetType = widgetType;
    }

    public OEmbedRequest MaxWidth(int maxWidth) {
        return new OEmbedRequest(this.statusId, this.url, maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, this.related, this.lang, this.widgetType);
    }

    public OEmbedRequest HideMedia(boolean hideMedia) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, hideMedia, this.hideThread, this.omitScript, this.align, this.related, this.lang, this.widgetType);
    }

    public OEmbedRequest HideThread(boolean hideThread) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, hideThread, this.omitScript, this.align, this.related, this.lang, this.widgetType);
    }

    public OEmbedRequest omitScript(boolean omitScript) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, omitScript, this.align, this.related, this.lang, this.widgetType);
    }

    public OEmbedRequest align(Align align) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, align, this.related, this.lang, this.widgetType);
    }

    public OEmbedRequest related(String[] related) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, related, this.lang, this.widgetType);
    }

    public OEmbedRequest lang(String lang) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, this.related, lang, this.widgetType);
    }

    public OEmbedRequest widgetType(WidgetType widgetType) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, this.related, this.lang, widgetType);
    }

    public OEmbedRequest hideTweet(boolean hideTweet) {
        return new OEmbedRequest(this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, this.related, this.lang, this.widgetType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OEmbedRequest that = (OEmbedRequest)o;
        return this.statusId == that.statusId && this.maxWidth == that.maxWidth && this.hideMedia == that.hideMedia && this.hideThread == that.hideThread && this.omitScript == that.omitScript && false == that.hideTweet && Objects.equals(this.url, that.url) && this.align == that.align && Arrays.equals(this.related, that.related) && Objects.equals(this.lang, that.lang) && this.widgetType == that.widgetType;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.statusId, this.url, this.maxWidth, this.hideMedia, this.hideThread, this.omitScript, this.align, this.lang, this.widgetType, false});
        result = 31 * result + Arrays.hashCode(this.related);
        return result;
    }

    public String toString() {
        return "OEmbedRequest{statusId=" + this.statusId + ", url='" + this.url + '\'' + ", maxWidth=" + this.maxWidth + ", hideMedia=" + this.hideMedia + ", hideThread=" + this.hideThread + ", omitScript=" + this.omitScript + ", align=" + (Object)((Object)this.align) + ", related=" + Arrays.toString(this.related) + ", lang='" + this.lang + '\'' + ", widgetType=" + (Object)((Object)this.widgetType) + ", hideTweet=" + false + '}';
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT,
        NONE;

    }

    public static enum WidgetType {
        VIDEO,
        NONE;

    }
}

