/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.expiration;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.commons.hash.MurmurHash3;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;

@ClientListener(includeCurrentState=true)
class ConsistentHash {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MIN_HEARTBEAT_PERIOD_SECONDS = 30;
    private static final int LIFESPAN_MULTIPLIER = 3;
    private static final int HEARTBEATS_PER_EXPIRATION_ROUND = 4;
    private static final int STOP_TIMEOUT_MILLISECONDS = 500;
    private static final String MEMBER_KEY_PREFIX = "node:";
    private final Set<String> membership = ConcurrentHashMap.newKeySet();
    private final String nodeUUID;
    private final String nodeName;
    private final int heartBeatPeriodSeconds;
    private final int heartBeatLifespan;
    private final ScheduledExecutorService scheduledExecutorService;
    private final RemoteCache<String, String> cache;
    private volatile ScheduledFuture<?> schedule;

    private ConsistentHash(ScheduledExecutorService scheduledExecutorService, RemoteCache<String, String> cache, String nodeUUID, String nodeName, int heartBeatPeriodSeconds, int heartBeatLifespan) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.nodeName = nodeName;
        this.heartBeatPeriodSeconds = heartBeatPeriodSeconds;
        this.cache = cache;
        this.nodeUUID = MEMBER_KEY_PREFIX + nodeUUID;
        this.heartBeatLifespan = heartBeatLifespan;
    }

    static ConsistentHash create(RemoteCache<String, String> cache, ScheduledExecutorService scheduledExecutorService, String nodeUUID, String nodeName, int expirationPeriodSeconds) {
        int period = Math.max(30, expirationPeriodSeconds / 4);
        int lifespan = period * 3;
        return new ConsistentHash(Objects.requireNonNull(scheduledExecutorService), Objects.requireNonNull(cache), nodeUUID, nodeName, period, lifespan);
    }

    void start() {
        if (this.schedule != null) {
            return;
        }
        this.sendHeartBeat();
        this.schedule = this.scheduledExecutorService.scheduleAtFixedRate(this::sendHeartBeat, this.heartBeatPeriodSeconds, this.heartBeatPeriodSeconds, TimeUnit.SECONDS);
        this.cache.addClientListener((Object)this);
    }

    void stop() {
        ScheduledFuture<?> existing = this.schedule;
        if (existing == null) {
            return;
        }
        this.cache.removeClientListener((Object)this);
        existing.cancel(true);
        this.schedule = null;
        try {
            this.cache.removeAsync((Object)this.nodeUUID).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            log.debugf("Exception caught during stop", (Object)e);
        }
    }

    Predicate<RealmModel> consistentHashSnapshot() {
        return new HashingPredicate(this.membership.stream().sorted().toList(), this.nodeUUID);
    }

    int size() {
        return this.membership.size();
    }

    @ClientCacheEntryCreated
    public void onKeycloakConnected(ClientCacheEntryCreatedEvent<String> event) {
        this.addKeycloakNode((String)event.getKey());
    }

    @ClientCacheEntryModified
    public void onHeartbeat(ClientCacheEntryModifiedEvent<String> event) {
        this.addKeycloakNode((String)event.getKey());
    }

    @ClientCacheEntryExpired
    public void onMissingHeartbeat(ClientCacheEntryExpiredEvent<String> event) {
        this.removeKeycloakNode((String)event.getKey());
    }

    @ClientCacheEntryRemoved
    public void onKeycloakDisconnect(ClientCacheEntryRemovedEvent<String> event) {
        this.removeKeycloakNode((String)event.getKey());
    }

    private void addKeycloakNode(String uuid) {
        if (uuid.startsWith(MEMBER_KEY_PREFIX)) {
            log.fatalf("Adding a keycloak instance with ID: %s", (Object)uuid);
            this.membership.add(uuid);
        }
    }

    private void removeKeycloakNode(String uuid) {
        if (uuid.startsWith(MEMBER_KEY_PREFIX)) {
            log.fatalf("Removing keycloak instance with ID: %s", (Object)uuid);
            this.membership.remove(uuid);
        }
    }

    private void sendHeartBeat() {
        this.cache.putAsync((Object)this.nodeUUID, (Object)this.nodeName, (long)this.heartBeatLifespan, TimeUnit.SECONDS);
        this.addKeycloakNode(this.nodeUUID);
    }

    private record HashingPredicate(List<String> members, String myUUID) implements Predicate<RealmModel>
    {
        @Override
        public boolean test(RealmModel realm) {
            int size = this.members.size();
            assert (size > 0);
            int index = Math.abs(MurmurHash3.getInstance().hash((Object)realm.getId())) % size;
            return this.myUUID.equals(this.members.get(index));
        }
    }
}

