/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class FastGlobalView
implements DataRow {
    private static final boolean DEBUG = false;
    private HashSet duplicateColumns;
    private HashSet invalidColumns;
    private boolean modifiableNameCache;
    private HashMap nameCache;
    private String[] columnNames;
    private DataFlags[] columnValue;
    private DataFlags[] columnOldValue;
    private boolean[] columnChanged;
    private int[] columnPrev;
    private int length;
    private boolean warnInvalidColumns;

    public FastGlobalView(FastGlobalView fastGlobalView) {
        if (fastGlobalView.modifiableNameCache) {
            this.duplicateColumns = (HashSet)fastGlobalView.duplicateColumns.clone();
            this.nameCache = (HashMap)fastGlobalView.nameCache.clone();
            this.modifiableNameCache = false;
            this.columnNames = (String[])fastGlobalView.columnNames.clone();
        } else {
            this.duplicateColumns = fastGlobalView.duplicateColumns;
            this.nameCache = fastGlobalView.nameCache;
            this.columnNames = fastGlobalView.columnNames;
            this.modifiableNameCache = false;
        }
        this.columnChanged = (boolean[])fastGlobalView.columnChanged.clone();
        this.columnValue = (DataFlags[])fastGlobalView.columnValue.clone();
        this.columnOldValue = (DataFlags[])fastGlobalView.columnOldValue.clone();
        this.columnPrev = (int[])fastGlobalView.columnPrev.clone();
        this.length = fastGlobalView.length;
        this.warnInvalidColumns = fastGlobalView.warnInvalidColumns;
        this.invalidColumns = fastGlobalView.invalidColumns;
    }

    public FastGlobalView() {
        this.warnInvalidColumns = "true".equals(JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.WarnInvalidColumns"));
        if (this.warnInvalidColumns) {
            this.invalidColumns = new HashSet();
        }
        this.duplicateColumns = new HashSet();
        this.nameCache = new HashMap();
        this.modifiableNameCache = true;
        this.columnChanged = new boolean[20];
        this.columnNames = new String[20];
        this.columnValue = new DataFlags[20];
        this.columnOldValue = new DataFlags[20];
        this.columnPrev = new int[20];
    }

    @Override
    public Object get(int n) throws DataSourceException {
        DataFlags dataFlags = this.getFlags(n);
        if (dataFlags == null) {
            return null;
        }
        return dataFlags.getValue();
    }

    @Override
    public Object get(String string) throws DataSourceException {
        DataFlags dataFlags = this.getFlags(string);
        if (dataFlags == null) {
            return null;
        }
        return dataFlags.getValue();
    }

    @Override
    public String getColumnName(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Column-Index " + n + " is invalid.");
        }
        return this.columnNames[n];
    }

    public int findColumn(String string) {
        Integer n = (Integer)this.nameCache.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        return this.length;
    }

    public FastGlobalView derive() {
        return new FastGlobalView(this);
    }

    public FastGlobalView advance() {
        FastGlobalView fastGlobalView = new FastGlobalView(this);
        System.arraycopy(fastGlobalView.columnValue, 0, fastGlobalView.columnOldValue, 0, this.length);
        Arrays.fill(fastGlobalView.columnChanged, false);
        return fastGlobalView;
    }

    public void removeColumn(String string) {
        int n;
        boolean bl;
        int n2 = -1;
        if (this.duplicateColumns.contains(string)) {
            bl = true;
            for (n = this.length - 1; n >= 0; --n) {
                if (!ObjectUtilities.equal((Object)string, (Object)this.columnNames[n])) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
        } else {
            bl = false;
            Integer n3 = (Integer)this.nameCache.get(string);
            if (n3 == null) {
                return;
            }
            n2 = n3;
        }
        if (!this.modifiableNameCache) {
            this.duplicateColumns = (HashSet)this.duplicateColumns.clone();
            this.columnNames = (String[])this.columnNames.clone();
            this.nameCache = (HashMap)this.nameCache.clone();
            this.modifiableNameCache = true;
        }
        if (n2 == this.length - 1) {
            this.columnChanged[n2] = false;
            this.columnNames[n2] = null;
            this.columnValue[n2] = null;
            if (this.columnPrev[n2] == -1) {
                this.nameCache.remove(string);
            } else {
                this.nameCache.put(string, IntegerCache.getInteger(this.columnPrev[n2]));
            }
            --this.length;
            if (bl) {
                if (this.columnPrev[n2] == -1) {
                    DebugLog.log((Object)("Column marked as duplicate but no duplicate index recorded: " + string));
                } else if (this.columnPrev[this.columnPrev[n2]] == -1) {
                    this.duplicateColumns.remove(string);
                }
            }
            return;
        }
        if (this.columnPrev[n2] == -1) {
            this.nameCache.remove(string);
        } else {
            this.nameCache.put(string, IntegerCache.getInteger(this.columnPrev[n2]));
        }
        n = n2 + 1;
        int n4 = this.length - n;
        System.arraycopy(this.columnNames, n, this.columnNames, n2, n4);
        System.arraycopy(this.columnChanged, n, this.columnChanged, n2, n4);
        System.arraycopy(this.columnOldValue, n, this.columnOldValue, n2, n4);
        System.arraycopy(this.columnValue, n, this.columnValue, n2, n4);
        System.arraycopy(this.columnPrev, n, this.columnPrev, n2, n4);
        this.columnNames[this.length - 1] = null;
        this.columnChanged[this.length - 1] = false;
        this.columnOldValue[this.length - 1] = null;
        this.columnPrev[this.length - 1] = 0;
        int n5 = n4 + n2;
        this.nameCache.clear();
        this.duplicateColumns.clear();
        for (int i = 0; i < n5; ++i) {
            String string2 = this.columnNames[i];
            Integer n6 = (Integer)this.nameCache.get(string2);
            if (this.nameCache.containsKey(string2)) {
                this.duplicateColumns.add(string2);
            }
            this.nameCache.put(string2, IntegerCache.getInteger(i));
            this.columnPrev[i] = n6 != null ? n6 : -1;
        }
        --this.length;
    }

    public void putField(String string, Object object, boolean bl) {
        if (!bl) {
            if (!this.modifiableNameCache) {
                this.columnNames = (String[])this.columnNames.clone();
                this.nameCache = (HashMap)this.nameCache.clone();
                this.modifiableNameCache = true;
            }
            DefaultDataFlags defaultDataFlags = new DefaultDataFlags(string, object, true);
            this.ensureCapacity(this.length + 1);
            this.columnNames[this.length] = string;
            this.columnValue[this.length] = defaultDataFlags;
            Integer n = (Integer)this.nameCache.get(string);
            if (n == null) {
                this.columnPrev[this.length] = -1;
            } else {
                this.columnPrev[this.length] = n;
                this.duplicateColumns.add(string);
            }
            this.columnChanged[this.length] = true;
            this.columnOldValue[this.length] = null;
            this.nameCache.put(string, IntegerCache.getInteger(this.length));
            ++this.length;
        } else {
            try {
                int n;
                Integer n2 = (Integer)this.nameCache.get(string);
                if (n2 == null) {
                    throw new IllegalStateException("Update to a non-existing column: " + string);
                }
                int n3 = -1;
                if (this.duplicateColumns.contains(string)) {
                    for (n = 0; n < this.length; ++n) {
                        if (this.columnChanged[n] || !ObjectUtilities.equal((Object)string, (Object)this.columnNames[n])) continue;
                        n3 = n;
                        break;
                    }
                    if (n3 < 0) {
                        n3 = n2;
                    }
                } else {
                    n3 = n2;
                }
                n = !ObjectUtilities.equal((Object)object, (Object)this.columnValue[n3].getValue()) ? 1 : 0;
                DefaultDataFlags defaultDataFlags = new DefaultDataFlags(string, object, n != 0);
                this.columnNames[n3] = string;
                this.columnOldValue[n3] = this.columnValue[n3];
                this.columnValue[n3] = defaultDataFlags;
                this.columnChanged[n3] = n;
            }
            catch (DataSourceException dataSourceException) {
                dataSourceException.printStackTrace();
            }
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.columnNames.length;
        if (n2 > n) {
            return;
        }
        int n3 = Math.max(n2 << 1, n + 10);
        String[] stringArray = new String[n3];
        System.arraycopy(this.columnNames, 0, stringArray, 0, this.length);
        this.columnNames = stringArray;
        boolean[] blArray = new boolean[n3];
        System.arraycopy(this.columnChanged, 0, blArray, 0, this.length);
        this.columnChanged = blArray;
        int[] nArray = new int[n3];
        System.arraycopy(this.columnPrev, 0, nArray, 0, this.length);
        this.columnPrev = nArray;
        DataFlags[] dataFlagsArray = new DataFlags[n3];
        System.arraycopy(this.columnValue, 0, dataFlagsArray, 0, this.length);
        this.columnValue = dataFlagsArray;
        DataFlags[] dataFlagsArray2 = new DataFlags[n3];
        System.arraycopy(this.columnOldValue, 0, dataFlagsArray2, 0, this.length);
        this.columnOldValue = dataFlagsArray2;
    }

    @Override
    public DataFlags getFlags(String string) throws DataSourceException {
        int n = this.findColumn(string);
        if (n == -1) {
            return null;
        }
        return this.getFlags(n);
    }

    @Override
    public DataFlags getFlags(int n) throws DataSourceException {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Column-Index " + n + " is invalid.");
        }
        if (this.columnChanged[n]) {
            return this.columnValue[n];
        }
        String string = this.columnNames[n];
        if (this.duplicateColumns.contains(string)) {
            for (int i = n - 1; i >= 0; --i) {
                if (!this.columnNames[i].equals(string) || !this.columnChanged[i]) continue;
                return this.columnValue[i];
            }
        }
        return this.columnValue[n];
    }
}

