/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkStridedDeviceAddressRegionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int STRIDE;
    public static final int SIZE;

    public VkStridedDeviceAddressRegionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkStridedDeviceAddressRegionKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long stride() {
        return VkStridedDeviceAddressRegionKHR.nstride(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkStridedDeviceAddressRegionKHR.nsize(this.address());
    }

    public VkStridedDeviceAddressRegionKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR stride(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(long deviceAddress, long stride, long size) {
        this.deviceAddress(deviceAddress);
        this.stride(stride);
        this.size(size);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(VkStridedDeviceAddressRegionKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkStridedDeviceAddressRegionKHR malloc() {
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR calloc() {
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkStridedDeviceAddressRegionKHR create(long address) {
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)address);
    }

    @Nullable
    public static VkStridedDeviceAddressRegionKHR createSafe(long address) {
        return address == 0L ? null : (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkStridedDeviceAddressRegionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkStridedDeviceAddressRegionKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkStridedDeviceAddressRegionKHR malloc(MemoryStack stack) {
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR calloc(MemoryStack stack) {
        return (VkStridedDeviceAddressRegionKHR)VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nstride(long struct) {
        return UNSAFE.getLong(null, struct + (long)STRIDE);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nstride(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)STRIDE, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkStridedDeviceAddressRegionKHR.__struct((Struct.Member[])new Struct.Member[]{VkStridedDeviceAddressRegionKHR.__member((int)8), VkStridedDeviceAddressRegionKHR.__member((int)8), VkStridedDeviceAddressRegionKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkStridedDeviceAddressRegionKHR, Buffer>
    implements NativeResource {
        private static final VkStridedDeviceAddressRegionKHR ELEMENT_FACTORY = VkStridedDeviceAddressRegionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkStridedDeviceAddressRegionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long stride() {
            return VkStridedDeviceAddressRegionKHR.nstride(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkStridedDeviceAddressRegionKHR.nsize(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
            return this;
        }
    }
}

