//
// DigestEngine.h
//
// $Id: //poco/1.4/Crypto/include/Poco/Crypto/DigestEngine.h#1 $
//
// Library: Crypto
// Package: Digest
// Module:  DigestEngine
//
// Definition of the DigestEngine class.
//
// Copyright (c) 2012, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Crypto_DigestEngine_INCLUDED
#define Crypto_DigestEngine_INCLUDED


#include "Poco/Crypto/Crypto.h"
#include "Poco/DigestEngine.h"
#include <openssl/evp.h>


namespace Poco {
namespace Crypto {


class Crypto_API DigestEngine: public Poco::DigestEngine
	/// This class implements a Poco::DigestEngine for all
	/// digest algorithms supported by OpenSSL.
{
public:
	DigestEngine(const std::string& name);
		/// Creates a DigestEngine using the digest with the given name
		/// (e.g., "MD5", "SHA1", "SHA256", "SHA512", etc.).
		/// See the OpenSSL documentation for a list of supported digest algorithms.
		///
		/// Throws a Poco::NotFoundException if no algorithm with the given name exists.
		
	~DigestEngine();
		/// Destroys the DigestEngine.
	
	const std::string& algorithm() const;
		/// Returns the name of the digest algorithm.
	
	// DigestEngine
	unsigned digestLength() const;
	void reset();
	const Poco::DigestEngine::Digest& digest();

protected:
	void updateImpl(const void* data, unsigned length);
	
private:
	std::string _name;
	EVP_MD_CTX* _ctx;
	Poco::DigestEngine::Digest _digest;
};


//
// inlines
//
inline const std::string& DigestEngine::algorithm() const
{
	return _name;
}


} } // namespace Poco::Crypto


#endif // Crypto_DigestEngine_INCLUDED
