/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.util.List;
import javax.swing.Icon;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.common.StringValuePair;

final class BreadcrumbItemChoices<T> {
    private BreadcrumbItem<T>[] choices;
    private BreadcrumbItem ancestor;
    private int selectedIndex = 0;

    public BreadcrumbItemChoices(BreadcrumbItem breadcrumbItem, List<StringValuePair<T>> list) {
        this.ancestor = breadcrumbItem;
        this.choices = new BreadcrumbItem[list.size()];
        int n = 0;
        for (StringValuePair<T> stringValuePair : list) {
            this.choices[n] = new BreadcrumbItem((String)stringValuePair.getKey(), stringValuePair.getValue());
            this.choices[n].setIcon((Icon)stringValuePair.get("icon"));
            ++n;
        }
        this.selectedIndex = -1;
    }

    public int getPosition(String string) {
        assert (string != null && string.length() > 0);
        for (int i = 0; i < this.choices.length; ++i) {
            BreadcrumbItem<T> breadcrumbItem = this.choices[i];
            if (!string.equals(breadcrumbItem.getKey())) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public BreadcrumbItem[] getChoices() {
        return this.choices;
    }

    public BreadcrumbItem getAncestor() {
        return this.ancestor;
    }
}

