/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.impl.S3ServiceImpl;
import com.amazon.aes.util.LangUtils;
import com.amazon.aes.util.XmlUtils;
import com.amazon.aes.webservices.client.cmd.util.S3ProxyUtil;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sun.misc.BASE64Encoder;

public class S3ConnectionImpl
implements S3Connection {
    private static final int STREAM_COPY_BUFFER_SIZE = 8192;
    private final String bucketSignName;
    private final AWSCredentials creds;
    private final String bucketName;
    private final String bucketLocation;
    private AmazonS3 s3Client = null;
    private boolean useSsl;

    public S3ConnectionImpl(S3ServiceImpl.S3ConnectionHelper connectionHelper, String bucketName, String bucketLocation, AWSCredentials creds, boolean useSsl) {
        this.bucketSignName = connectionHelper.getBucketName(bucketName);
        this.bucketName = bucketName;
        this.bucketLocation = bucketLocation;
        this.creds = creds;
        this.useSsl = useSsl;
    }

    @Override
    public S3Connection.OperationResult copy(String key, String source, Map<String, String> options, String sourceBucketName, String sourceKey) {
        AmazonS3 s3Client = this.getS3Client();
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceBucketName, sourceKey, this.bucketSignName, key);
        String cannedAclHeader = "x-amz-acl";
        if (options.containsKey(cannedAclHeader)) {
            copyObjectRequest.putCustomRequestHeader(cannedAclHeader, options.get(cannedAclHeader));
        }
        s3Client.copyObject(copyObjectRequest);
        return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (String)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public S3Connection.OperationResult get(String key, OutputStream outputStream) {
        try {
            AmazonS3 s3Client = this.getS3Client();
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketSignName, key);
            S3Object s3Object = null;
            try {
                s3Object = s3Client.getObject(getObjectRequest);
                S3ConnectionImpl.copyStream((InputStream)s3Object.getObjectContent(), outputStream);
                return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (InputStream)null);
            }
            catch (AmazonServiceException ase) {
                int code = ase.getStatusCode();
                switch (code) {
                    case 403: {
                        S3Connection.OperationResult operationResult = S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.NOT_AUTHORIZED, ase.getErrorMessage());
                        return operationResult;
                    }
                    case 404: {
                        S3Connection.OperationResult operationResult = S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.NOT_FOUND, ase.getErrorMessage());
                        return operationResult;
                    }
                    case 500: {
                        S3Connection.OperationResult operationResult = S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.SERVER_ERROR, ase.getErrorMessage());
                        return operationResult;
                    }
                }
                throw new RuntimeException("Unexpected status code: " + code);
            }
            finally {
                if (s3Object != null) {
                    s3Object.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from bucket", e);
        }
    }

    @Override
    public S3Connection.OperationValueResult<List<String>> getContentList() {
        return this.getContentList(null);
    }

    @Override
    public S3Connection.OperationValueResult<List<String>> getContentList(String prefix) {
        boolean truncated;
        ArrayList<String> contentList = new ArrayList<String>();
        AmazonS3 s3Client = this.getS3Client();
        ObjectListing objectListing = null;
        do {
            try {
                objectListing = objectListing == null ? s3Client.listObjects(this.bucketSignName) : s3Client.listNextBatchOfObjects(objectListing);
                for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                    contentList.add(objectSummary.getKey());
                }
                truncated = objectListing.isTruncated();
            }
            catch (AmazonServiceException ase) {
                int code = ase.getStatusCode();
                switch (code) {
                    case 403: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_AUTHORIZED, ase.getErrorMessage());
                    }
                    case 404: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_FOUND, ase.getErrorMessage());
                    }
                    case 500: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.SERVER_ERROR, ase.getErrorMessage());
                    }
                }
                throw new RuntimeException("Unexpected status code: " + code);
            }
        } while (truncated);
        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.OK, null, contentList);
    }

    @Override
    public S3Connection.OperationResult upload(String key, String mimeType, InputStream inputStream, Map<String, String> options) {
        try {
            int len;
            AmazonS3 s3Client = this.getS3Client();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(mimeType);
            MD5Digest md5Digest = new MD5Digest();
            ByteArrayOutputStream tmpStream = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = inputStream.read(buf)) != -1) {
                md5Digest.update(buf, 0, len);
                tmpStream.write(buf, 0, len);
            }
            byte[] digest = new byte[16];
            md5Digest.doFinal(digest, 0);
            objectMetadata.setContentMD5(new BASE64Encoder().encode(digest));
            String cannedAclHeader = "x-amz-acl";
            if (options.containsKey(cannedAclHeader)) {
                objectMetadata.setHeader(cannedAclHeader, (Object)options.get(cannedAclHeader));
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketSignName, key, (InputStream)new ByteArrayInputStream(tmpStream.toByteArray()), objectMetadata);
            s3Client.putObject(putObjectRequest);
            return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (String)null);
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while doing S3 request", e);
        }
    }

    @Override
    public S3Connection.OperationResult createBucket() {
        return this.createBucket(null);
    }

    @Override
    public S3Connection.OperationResult createBucket(String location) {
        AmazonS3 s3Client = this.getS3Client();
        s3Client.createBucket(this.bucketSignName, Region.fromValue((String)location));
        return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (InputStream)null);
    }

    private AmazonS3 getS3Client() {
        if (this.s3Client == null) {
            ClientConfiguration clientConfig = new ClientConfiguration();
            S3ProxyUtil.populateS3ProxyProperties(clientConfig, this.useSsl, false);
            this.s3Client = new AmazonS3Client(this.creds, clientConfig);
            if (this.bucketLocation != null) {
                this.s3Client.setRegion(Region.fromValue((String)this.bucketLocation).toAWSRegion());
            }
        }
        return this.s3Client;
    }

    @Override
    public S3Connection.OperationResult bucketStatus() {
        try {
            AmazonS3 s3Client = this.getS3Client();
            if (s3Client.doesBucketExist(this.bucketSignName)) {
                return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (InputStream)null);
            }
            return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.NOT_FOUND, (InputStream)null);
        }
        catch (AmazonServiceException e) {
            return S3ConnectionImpl.createOperationResult(this.translateStatusCode(e.getStatusCode()), e.getErrorMessage());
        }
        catch (AmazonClientException e) {
            throw new RuntimeException("Got unexpected exception while doing S3 request", e);
        }
    }

    @Override
    public S3Connection.OperationValueResult<String> bucketLocation() {
        AmazonS3 s3Client = this.getS3Client();
        String location = s3Client.getBucketLocation(this.bucketSignName);
        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.OK, null, location);
    }

    private S3Connection.OperationCode translateStatusCode(int code) {
        switch (code) {
            case 200: {
                return S3Connection.OperationCode.OK;
            }
            case 301: 
            case 307: {
                return S3Connection.OperationCode.RESOURCE_MOVED;
            }
            case 400: {
                return S3Connection.OperationCode.BAD_REQUEST;
            }
            case 403: {
                return S3Connection.OperationCode.NOT_AUTHORIZED;
            }
            case 404: {
                return S3Connection.OperationCode.NOT_FOUND;
            }
            case 409: {
                return S3Connection.OperationCode.CONFLICT;
            }
            case 500: {
                return S3Connection.OperationCode.SERVER_ERROR;
            }
        }
        throw new RuntimeException("Unexpected status code: " + code);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, len);
        }
        outputStream.flush();
    }

    public String toString() {
        return "S3Connection[bucket=" + this.bucketName + "]";
    }

    protected static String getErrorResponse(InputStream inputStream) {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new RuntimeException("Error parsing", e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new RuntimeException("Error parsing", e);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unexpected error creating the document builder");
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            return null;
        }
        if (!"Error".equals(document.getDocumentElement().getNodeName())) {
            return null;
        }
        String errorMessage = XmlUtils.getTextFromDocument(document, "/Error/Message");
        if (!LangUtils.isEmpty(errorMessage)) {
            return errorMessage;
        }
        return LangUtils.defaultStr(XmlUtils.getTextFromDocument(document, "/Error/Code"), "Error");
    }

    private static S3Connection.OperationResult createOperationResult(S3Connection.OperationCode operationCode, InputStream inputStream) {
        return S3ConnectionImpl.createOperationResult(operationCode, inputStream == null ? null : S3ConnectionImpl.getErrorResponse(inputStream));
    }

    private static S3Connection.OperationResult createOperationResult(final S3Connection.OperationCode operationCode, final String msg) {
        return new S3Connection.OperationResult(){

            @Override
            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            @Override
            public String getMsg() {
                return msg;
            }
        };
    }

    private static <T> S3Connection.OperationValueResult<T> createOperationValueResult(final S3Connection.OperationCode operationCode, final String msg, final T value) {
        return new S3Connection.OperationValueResult<T>(){

            @Override
            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            @Override
            public String getMsg() {
                return msg;
            }

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    private static <T> S3Connection.OperationValueResult<T> createOperationValueResult(final S3Connection.OperationCode operationCode, final String msg) {
        if (S3Connection.OperationCode.OK == operationCode) {
            throw new RuntimeException("Must not create an OperationValueResult w/o value where result is OK");
        }
        return new S3Connection.OperationValueResult<T>(){

            @Override
            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            @Override
            public T getValue() {
                throw new RuntimeException("Called getValue() on an operation result that has no value. Operation result: " + (Object)((Object)operationCode));
            }

            @Override
            public String getMsg() {
                return msg;
            }
        };
    }
}

