/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitKey;
import io.quarkus.hibernate.orm.runtime.boot.FastBootMetadataBuilder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.integrator.spi.Integrator;

public final class PersistenceUnitsHolder {
    private static final String NO_NAME_TOKEN = "__no_name";
    private static volatile PersistenceUnits persistenceUnits;

    static void initializeJpa(List<QuarkusPersistenceUnitDefinition> puDefinitions, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies preGeneratedProxies) {
        persistenceUnits = PersistenceUnitsHolder.constructMetadataAdvance(puDefinitions, scanner, additionalIntegrators, preGeneratedProxies);
    }

    public static Map<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor> getPersistenceUnits() {
        PersistenceUnitsHolder.checkJPAInitialization();
        return PersistenceUnitsHolder.persistenceUnits.units;
    }

    public static Collection<QuarkusPersistenceUnitDescriptor> getPersistenceUnitDescriptors() {
        return PersistenceUnitsHolder.getPersistenceUnits().values();
    }

    public static QuarkusPersistenceUnitDescriptor getPersistenceUnitDescriptor(String persistenceUnitName, boolean isReactive) {
        PersistenceUnitsHolder.checkJPAInitialization();
        return PersistenceUnitsHolder.persistenceUnits.units.get(new PersistenceUnitKey(PersistenceUnitsHolder.unitName(persistenceUnitName), isReactive));
    }

    public static RecordedState popRecordedState(String persistenceUnitName, boolean isReactive) {
        PersistenceUnitsHolder.checkJPAInitialization();
        PersistenceUnitKey key = new PersistenceUnitKey(PersistenceUnitsHolder.unitName(persistenceUnitName), isReactive);
        return PersistenceUnitsHolder.persistenceUnits.recordedStates.remove(key);
    }

    private static PersistenceUnits constructMetadataAdvance(List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies proxyClassDefinitions) {
        int size = parsedPersistenceXmlDescriptors.size();
        HashMap<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor> units = new HashMap<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor>(size);
        HashMap<PersistenceUnitKey, RecordedState> recordedStates = new HashMap<PersistenceUnitKey, RecordedState>(size);
        for (QuarkusPersistenceUnitDefinition unit : parsedPersistenceXmlDescriptors) {
            PersistenceUnitKey key = new PersistenceUnitKey(PersistenceUnitsHolder.unitName(unit.getName()), unit.isReactive());
            QuarkusPersistenceUnitDescriptor previous = units.put(key, unit.getPersistenceUnitDescriptor());
            if (previous != null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate persistence unit name: %s", unit.getName() + (unit.isReactive() ? " (reactive)" : "")));
            }
            RecordedState metadata = PersistenceUnitsHolder.createMetadata(unit, scanner, additionalIntegrators, proxyClassDefinitions);
            recordedStates.put(key, metadata);
        }
        return new PersistenceUnits(units, recordedStates);
    }

    private static void checkJPAInitialization() {
        if (persistenceUnits == null) {
            throw new RuntimeException("JPA not initialized yet by Quarkus: this is likely a bug.");
        }
    }

    private static String unitName(String name) {
        if (name == null) {
            return NO_NAME_TOKEN;
        }
        return name;
    }

    public static RecordedState createMetadata(QuarkusPersistenceUnitDefinition unit, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies proxyDefinitions) {
        FastBootMetadataBuilder fastBootMetadataBuilder = new FastBootMetadataBuilder(unit, scanner, additionalIntegrators, proxyDefinitions);
        return fastBootMetadataBuilder.build();
    }

    private static class PersistenceUnits {
        private final Map<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor> units;
        private final Map<PersistenceUnitKey, RecordedState> recordedStates;

        public PersistenceUnits(Map<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor> units, Map<PersistenceUnitKey, RecordedState> recordedStates) {
            this.units = Collections.unmodifiableMap(units);
            this.recordedStates = recordedStates;
        }
    }
}

