/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public class GlobalStateManagerImpl
implements GlobalStateManager {
    public static final String VERSION = "@version";
    public static final String TIMESTAMP = "@timestamp";
    public static final String VERSION_MAJOR = "version-major";
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    TimeService timeService;
    private final List<GlobalStateProvider> stateProviders = new ArrayList<GlobalStateProvider>();
    private FileSystemLock globalLock;
    private boolean persistentState;
    private ScopedPersistentState globalState;

    @Start
    public void start() {
        this.persistentState = this.globalConfiguration.globalState().enabled();
        if (this.persistentState) {
            this.acquireGlobalLock();
            this.loadGlobalState();
        }
    }

    @Stop
    public void stop() {
        if (this.persistentState) {
            this.writeGlobalState();
            this.releaseGlobalLock();
        }
    }

    private void acquireGlobalLock() {
        this.globalLock = new FileSystemLock(Paths.get(this.globalConfiguration.globalState().persistentLocation(), new String[0]), "___global");
        try {
            boolean checkAcquire = true;
            if (!this.globalLock.tryLock()) {
                switch (this.globalConfiguration.globalState().uncleanShutdownAction()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case FAIL: {
                        throw Log.CONTAINER.globalStateLockFilePresent(this.globalLock);
                    }
                    case PURGE: {
                        this.deleteScopedState("___global");
                        this.globalLock.unsafeLock();
                        boolean bl = true;
                        break;
                    }
                    case IGNORE: {
                        boolean bl = checkAcquire = false;
                    }
                }
            }
            if (checkAcquire && !this.globalLock.isAcquired()) {
                throw Log.CONTAINER.globalStateCannotAcquireLockFile(null, this.globalLock);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            throw Log.CONTAINER.globalStateCannotAcquireLockFile(e, this.globalLock);
        }
    }

    private void releaseGlobalLock() {
        if (this.globalLock != null && this.globalLock.isAcquired()) {
            this.globalLock.unlock();
        }
    }

    private void loadGlobalState() {
        File stateFile = this.getStateFile("___global");
        this.globalState = this.readScopedState("___global").orElse(null);
        if (this.globalState != null) {
            ScopedPersistentState state = this.globalState;
            if (!stateFile.canWrite()) {
                throw Log.CONTAINER.nonWritableStateFile(stateFile);
            }
            if (!(state.containsProperty(VERSION) && state.containsProperty(VERSION_MAJOR) && state.containsProperty(TIMESTAMP))) {
                throw Log.CONTAINER.invalidPersistentState("___global");
            }
            Log.CONTAINER.globalStateLoad(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
            this.stateProviders.forEach(provider -> provider.prepareForRestore(state));
        } else {
            stateFile.getParentFile().mkdirs();
        }
    }

    @Override
    public void writeGlobalState() {
        if (this.persistentState) {
            if (this.stateProviders.isEmpty()) {
                Log.CONTAINER.incompleteGlobalState();
            } else {
                ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("___global");
                state.setProperty(VERSION, Version.getVersion());
                state.setProperty(VERSION_MAJOR, Version.getMajor());
                state.setProperty(TIMESTAMP, this.timeService.instant().toString());
                for (GlobalStateProvider provider : this.stateProviders) {
                    provider.prepareForPersist(state);
                }
                this.writeScopedState(state);
                Log.CONTAINER.globalStateWrite(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
            }
        }
    }

    @Override
    public void writeScopedState(ScopedPersistentState state) {
        if (this.persistentState) {
            File stateFile = this.getStateFile(state.getScope());
            try (PrintWriter w = new PrintWriter(stateFile);){
                state.forEach((key, value) -> w.printf("%s=%s%n", Util.unicodeEscapeString((String)key), Util.unicodeEscapeString((String)value)));
            }
            catch (IOException e) {
                throw Log.CONTAINER.failedWritingGlobalState(e, stateFile);
            }
        }
    }

    @Override
    public void deleteScopedState(String scope) {
        if (this.persistentState) {
            File stateFile = this.getStateFile(scope);
            try {
                Files.deleteIfExists(stateFile.toPath());
            }
            catch (IOException e) {
                throw Log.CONTAINER.failedWritingGlobalState(e, stateFile);
            }
        }
    }

    @Override
    public Optional<ScopedPersistentState> readScopedState(String scope) {
        Optional<ScopedPersistentState> optional;
        if (!this.persistentState) {
            return Optional.empty();
        }
        File stateFile = this.getStateFile(scope);
        if (!stateFile.exists()) {
            return Optional.empty();
        }
        BufferedReader r = new BufferedReader(new FileReader(stateFile));
        try {
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(scope);
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    int eq = line.indexOf(61);
                    while (eq > 0 && line.charAt(eq - 1) == '\\') {
                        eq = line.indexOf(61, eq + 1);
                    }
                    if (eq > 0) {
                        state.setProperty(Util.unicodeUnescapeString((String)line.substring(0, eq).trim()), Util.unicodeUnescapeString((String)line.substring(eq + 1).trim()));
                    }
                }
                line = r.readLine();
            }
            optional = Optional.of(state);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Log.CONTAINER.failedReadingPersistentState(e, stateFile);
            }
        }
        r.close();
        return optional;
    }

    private File getStateFile(String scope) {
        return new File(this.globalConfiguration.globalState().persistentLocation(), scope + ".state");
    }

    @Override
    public void registerStateProvider(GlobalStateProvider provider) {
        this.stateProviders.add(provider);
        if (this.globalState != null) {
            provider.prepareForRestore(this.globalState);
        }
    }
}

