/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.awt;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class DisplayParentTest
extends Frame {
    boolean killswitch;

    public DisplayParentTest() throws LWJGLException {
        this.setTitle("LWJGL Display Parent Test");
        this.setSize(640, 320);
        this.setLayout(new GridLayout(1, 2));
        Canvas display_parent = new Canvas();
        display_parent.setFocusable(true);
        display_parent.setIgnoreRepaint(true);
        this.add(display_parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DisplayParentTest.this.killswitch = true;
            }
        });
        this.setResizable(true);
        this.setVisible(true);
        Display.setParent((Canvas)display_parent);
        Display.setVSyncEnabled((boolean)true);
        Display.create();
        float angle = 0.0f;
        block0: while (this.isVisible() && !this.killswitch) {
            int height;
            int width;
            angle += 1.0f;
            if (!Display.isFullscreen()) {
                width = display_parent.getWidth();
                height = display_parent.getHeight();
            } else {
                width = Display.getDisplayMode().getWidth();
                height = Display.getDisplayMode().getHeight();
            }
            if (width < 1 || height < 1) continue;
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            GL11.glClearColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluOrtho2D((float)0.0f, (float)width, (float)0.0f, (float)height);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)width / 2.0f), (float)((float)height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)(2.0f * angle), (float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glRectf((float)-50.0f, (float)-50.0f, (float)50.0f, (float)50.0f);
            GL11.glPopMatrix();
            Display.update();
            while (Keyboard.next()) {
                if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                    Display.destroy();
                    this.dispose();
                    continue block0;
                }
                if (Keyboard.getEventKey() == 57 && Keyboard.getEventKeyState()) {
                    Mouse.setGrabbed((!Mouse.isGrabbed() ? 1 : 0) != 0);
                }
                if (Keyboard.getEventKey() != 33 || !Keyboard.getEventKeyState()) continue;
                Display.setFullscreen((!Display.isFullscreen() ? 1 : 0) != 0);
            }
        }
        Display.destroy();
        this.dispose();
    }

    public static void main(String[] args) throws LWJGLException {
        new DisplayParentTest();
    }
}

