/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.router.crypto.ratchet.NextSessionKey;
import net.i2p.util.HexDump;

class RatchetPayload {
    public static final int BLOCK_HEADER_SIZE = 3;
    private static final int BLOCK_DATETIME = 0;
    private static final int BLOCK_SESSIONID = 1;
    private static final int BLOCK_TERMINATION = 4;
    private static final int BLOCK_OPTIONS = 5;
    private static final int BLOCK_MSGNUM = 6;
    private static final int BLOCK_NEXTKEY = 7;
    private static final int BLOCK_ACK = 8;
    private static final int BLOCK_ACKREQ = 9;
    private static final int BLOCK_GARLIC = 11;
    private static final int BLOCK_PADDING = 254;

    RatchetPayload() {
    }

    public static int processPayload(I2PAppContext ctx, PayloadCallback cb, byte[] payload, int off, int length, boolean isHandshake) throws IOException, DataFormatException, I2NPMessageException {
        int blocks = 0;
        boolean gotPadding = false;
        boolean gotTermination = false;
        int i = off;
        int end = off + length;
        while (i < end) {
            int len;
            int type = payload[i++] & 0xFF;
            if (gotPadding) {
                throw new IOException("Illegal block after padding: " + type);
            }
            if (gotTermination && type != 254) {
                throw new IOException("Illegal block after termination: " + type);
            }
            if ((i += 2) + (len = (int)DataHelper.fromLong(payload, i, 2)) > end) {
                throw new IOException("Block " + blocks + " type " + type + " length " + len + " at offset " + (i - 3 - off) + " runs over frame of size " + length + '\n' + HexDump.dump(payload, off, length));
            }
            switch (type) {
                case 0: {
                    if (len != 4) {
                        throw new IOException("Bad length for DATETIME: " + len);
                    }
                    long time = DataHelper.fromLong(payload, i, 4) * 1000L;
                    cb.gotDateTime(time);
                    break;
                }
                case 5: {
                    byte[] options = new byte[len];
                    System.arraycopy(payload, i, options, 0, len);
                    cb.gotOptions(options, isHandshake);
                    break;
                }
                case 11: {
                    GarlicClove clove = new GarlicClove(ctx);
                    clove.readBytesRatchet(payload, i, len);
                    cb.gotGarlic(clove);
                    break;
                }
                case 7: {
                    NextSessionKey nsk;
                    if (len != 3 && len != 35) {
                        throw new IOException("Bad length for NEXTKEY: " + len);
                    }
                    boolean hasKey = (payload[i] & 1) != 0;
                    boolean isReverse = (payload[i] & 2) != 0;
                    boolean isRequest = (payload[i] & 4) != 0;
                    int id = (int)DataHelper.fromLong(payload, i + 1, 2);
                    if (hasKey) {
                        byte[] data = new byte[32];
                        System.arraycopy(payload, i + 3, data, 0, 32);
                        nsk = new NextSessionKey(data, id, isReverse, isRequest);
                    } else {
                        nsk = new NextSessionKey(id, isReverse, isRequest);
                    }
                    cb.gotNextKey(nsk);
                    break;
                }
                case 8: {
                    if (len < 4 || len % 4 != 0) {
                        throw new IOException("Bad length for ACK: " + len);
                    }
                    for (int j = i; j < i + len; j += 4) {
                        int id = (int)DataHelper.fromLong(payload, j, 2);
                        int n = (int)DataHelper.fromLong(payload, j + 2, 2);
                        cb.gotAck(id, n);
                    }
                    break;
                }
                case 9: {
                    if (len < 1) {
                        throw new IOException("Bad length for ACKREQ: " + len);
                    }
                    cb.gotAckRequest();
                    break;
                }
                case 4: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 1) {
                        throw new IOException("Bad length for TERMINATION: " + len);
                    }
                    int rsn = payload[i] & 0xFF;
                    cb.gotTermination(rsn);
                    gotTermination = true;
                    break;
                }
                case 6: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 2) {
                        throw new IOException("Bad length for PN: " + len);
                    }
                    int pn = (int)DataHelper.fromLong(payload, i, 2);
                    cb.gotPN(pn);
                    break;
                }
                case 254: {
                    gotPadding = true;
                    cb.gotPadding(len, length);
                    break;
                }
                default: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    cb.gotUnknown(type, len);
                }
            }
            i += len;
            ++blocks;
        }
        if (isHandshake && blocks == 0) {
            throw new IOException("No blocks in handshake");
        }
        return blocks;
    }

    public static int writePayload(byte[] payload, int off, List<Block> blocks) {
        for (Block block : blocks) {
            off = block.write(payload, off);
        }
        return off;
    }

    private static void toInt4(byte[] target, int offset, int value) {
        for (int i = offset + 3; i >= offset; --i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static interface PayloadCallback {
        public void gotDateTime(long var1) throws DataFormatException;

        public void gotGarlic(GarlicClove var1);

        public void gotOptions(byte[] var1, boolean var2) throws DataFormatException;

        public void gotTermination(int var1);

        public void gotPN(int var1);

        public void gotNextKey(NextSessionKey var1);

        public void gotAck(int var1, int var2);

        public void gotAckRequest();

        public void gotPadding(int var1, int var2);

        public void gotUnknown(int var1, int var2);
    }

    public static abstract class Block {
        private final int type;

        public Block(int ttype) {
            this.type = ttype;
        }

        public int write(byte[] tgt, int off) {
            tgt[off++] = (byte)this.type;
            int rv = this.writeData(tgt, off + 2);
            DataHelper.toLong(tgt, off, 2, rv - (off + 2));
            return rv;
        }

        public int getTotalLength() {
            return 3 + this.getDataLength();
        }

        public abstract int getDataLength();

        public abstract int writeData(byte[] var1, int var2);

        public String toString() {
            return "Payload block type " + this.type + " length " + this.getDataLength();
        }
    }

    public static class PNBlock
    extends Block {
        private final int pn;

        public PNBlock(int pn) {
            super(6);
            this.pn = pn;
        }

        @Override
        public int getDataLength() {
            return 2;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 2, this.pn);
            return off + 2;
        }
    }

    public static class TerminationBlock
    extends Block {
        private final byte rsn;

        public TerminationBlock(int reason) {
            super(4);
            this.rsn = (byte)reason;
        }

        @Override
        public int getDataLength() {
            return 1;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            tgt[off] = this.rsn;
            return off + 1;
        }
    }

    public static class AckRequestBlock
    extends Block {
        public AckRequestBlock() {
            super(9);
        }

        @Override
        public int getDataLength() {
            return 1;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            tgt[off] = 0;
            return off + 1;
        }
    }

    public static class AckBlock
    extends Block {
        private final byte[] data;

        public AckBlock(int keyID, int n) {
            super(8);
            this.data = new byte[4];
            DataHelper.toLong(this.data, 0, 2, keyID);
            DataHelper.toLong(this.data, 2, 2, n);
        }

        public AckBlock(List<Integer> acks) {
            super(8);
            this.data = new byte[4 * acks.size()];
            int i = 0;
            for (Integer a : acks) {
                RatchetPayload.toInt4(this.data, i, a);
                i += 4;
            }
        }

        @Override
        public int getDataLength() {
            return this.data.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.data, 0, tgt, off, this.data.length);
            return off + this.data.length;
        }
    }

    public static class NextKeyBlock
    extends Block {
        private final NextSessionKey next;

        public NextKeyBlock(NextSessionKey nextKey) {
            super(7);
            this.next = nextKey;
        }

        @Override
        public int getDataLength() {
            return this.next.getData() != null ? 35 : 3;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            if (this.next.getData() != null) {
                tgt[off] = 1;
            }
            if (this.next.isReverse()) {
                int n = off;
                tgt[n] = (byte)(tgt[n] | 2);
            }
            if (this.next.isRequest()) {
                int n = off;
                tgt[n] = (byte)(tgt[n] | 4);
            }
            DataHelper.toLong(tgt, off + 1, 2, this.next.getID());
            if (this.next.getData() != null) {
                System.arraycopy(this.next.getData(), 0, tgt, off + 3, 32);
                return off + 35;
            }
            return off + 3;
        }
    }

    public static class OptionsBlock
    extends Block {
        private final byte[] opts;

        public OptionsBlock(byte[] options) {
            super(5);
            this.opts = options;
        }

        @Override
        public int getDataLength() {
            return this.opts.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.opts, 0, tgt, off, this.opts.length);
            return off + this.opts.length;
        }
    }

    public static class DateTimeBlock
    extends Block {
        private final long now;

        public DateTimeBlock(long time) {
            super(0);
            this.now = time;
        }

        @Override
        public int getDataLength() {
            return 4;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, this.now / 1000L);
            return off + 4;
        }
    }

    public static class PaddingBlock
    extends Block {
        private final int sz;
        private final I2PAppContext ctx;

        public PaddingBlock(int size) {
            this(null, size);
        }

        @Deprecated
        public PaddingBlock(I2PAppContext context, int size) {
            super(254);
            this.sz = size;
            this.ctx = context;
        }

        @Override
        public int getDataLength() {
            return this.sz;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            if (this.ctx != null) {
                this.ctx.random().nextBytes(tgt, off, this.sz);
            } else {
                Arrays.fill(tgt, off, off + this.sz, (byte)0);
            }
            return off + this.sz;
        }
    }

    public static class GarlicBlock
    extends Block {
        private final GarlicClove c;

        public GarlicBlock(GarlicClove clove) {
            super(11);
            this.c = clove;
        }

        @Override
        public int getDataLength() {
            return this.c.getSizeRatchet();
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            return this.c.writeBytesRatchet(tgt, off);
        }
    }
}

