/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CachedIteratorCollection<E>
extends AbstractCollection<E> {
    private final CachedIterator iterator = new CachedIterator();
    private transient int size = 0;
    private transient Node<E> first = null;
    private transient Node<E> last = null;

    @Override
    public boolean add(E element) {
        Node<E> newNode = new Node<E>(this.last, element);
        if (this.size == 0) {
            this.first = newNode;
        } else {
            this.last.next = newNode;
        }
        this.last = newNode;
        ++this.size;
        return true;
    }

    @Override
    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
        this.iterator.reset();
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element) {
            this.item = element;
            this.prev = prev;
            this.next = null;
        }
    }

    private class CachedIterator
    implements Iterator<E> {
        private transient boolean nextCalled;
        private transient Node<E> itrIndexNode;

        private CachedIterator() {
            this.itrIndexNode = CachedIteratorCollection.this.first;
        }

        private void reset() {
            this.itrIndexNode = CachedIteratorCollection.this.first;
            this.nextCalled = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            if (!this.nextCalled) throw new IllegalStateException();
            if (this.itrIndexNode != null) {
                if (this.itrIndexNode != ((CachedIteratorCollection)CachedIteratorCollection.this).first.next) {
                    this.itrIndexNode.prev = this.itrIndexNode.prev.prev;
                    this.itrIndexNode.prev.next = this.itrIndexNode;
                } else {
                    this.itrIndexNode.prev = null;
                    CachedIteratorCollection.this.first = this.itrIndexNode;
                }
            } else if (((CachedIteratorCollection)CachedIteratorCollection.this).last.prev != null) {
                ((CachedIteratorCollection)CachedIteratorCollection.this).last.prev.next = null;
                CachedIteratorCollection.this.last = ((CachedIteratorCollection)CachedIteratorCollection.this).last.prev;
            } else {
                this.nextCalled = false;
                CachedIteratorCollection.this.clear();
                return;
            }
            CachedIteratorCollection.this.size--;
            this.nextCalled = false;
        }

        @Override
        public boolean hasNext() {
            return this.itrIndexNode != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                Node node = this.itrIndexNode;
                this.itrIndexNode = this.itrIndexNode.next;
                this.nextCalled = true;
                return node.item;
            }
            throw new NoSuchElementException();
        }
    }
}

