/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.street_level;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.ImageMetadata;
import org.openstreetmap.josm.gui.layer.geoimage.ImageUtils;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public interface IImageEntry<I extends IImageEntry<I>> {
    default public void selectNextImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getNextImage());
    }

    public I getNextImage();

    default public void selectPreviousImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getPreviousImage());
    }

    public I getPreviousImage();

    default public void selectFirstImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getFirstImage());
    }

    public I getFirstImage();

    default public void selectLastImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getLastImage());
    }

    default public void selectImage(ImageViewerDialog imageViewerDialog, IImageEntry<?> entry) {
        imageViewerDialog.displayImage(entry);
    }

    public I getLastImage();

    default public boolean remove() {
        throw new UnsupportedOperationException("remove is not supported for " + this.getClass().getSimpleName());
    }

    default public boolean isRemoveSupported() {
        return false;
    }

    default public boolean delete() {
        throw new UnsupportedOperationException("remove is not supported for " + this.getClass().getSimpleName());
    }

    default public boolean isDeleteSupported() {
        return false;
    }

    public String getDisplayName();

    default public BufferedImage read(Dimension target) throws IOException {
        URI imageUrl = this.getImageURI();
        if (imageUrl == null) {
            return null;
        }
        Logging.info(I18n.tr("Loading {0}", imageUrl));
        BufferedImage image = ImageProvider.read(imageUrl.toURL(), false, false, r -> target == null ? r.getDefaultReadParam() : ImageUtils.withSubsampling(r, target));
        if (image == null) {
            Logging.warn("Unable to load {0}", imageUrl);
            return null;
        }
        if (this instanceof ImageMetadata) {
            ImageMetadata data = (ImageMetadata)((Object)this);
            Logging.debug("Loaded {0} with dimensions {1}x{2} memoryTaken={3}m exifOrientationSwitchedDimension={4}", imageUrl, image.getWidth(), image.getHeight(), image.getWidth() * image.getHeight() * 4 / 1024 / 1024, ExifReader.orientationSwitchesDimensions(data.getExifOrientation()));
            return ImageUtils.applyExifRotation(image, data.getExifOrientation());
        }
        return image;
    }

    public void setWidth(int var1);

    public void setHeight(int var1);

    public File getFile();

    default public URI getImageURI() {
        File file = this.getFile();
        if (file != null) {
            return file.toURI();
        }
        return null;
    }

    public ILatLon getPos();

    public Double getSpeed();

    public Double getElevation();

    public Integer getGpsDiffMode();

    public Integer getGps2d3dMode();

    public Double getExifGpsDop();

    public String getExifGpsDatum();

    public String getExifGpsProcMethod();

    public Double getExifImgDir();

    public Double getExifGpsTrack();

    public Double getExifHPosErr();

    public boolean hasExifTime();

    public Instant getExifInstant();

    public boolean hasGpsTime();

    public Instant getGpsInstant();

    public Instant getExifGpsInstant();

    public String getIptcCaption();

    public String getIptcHeadline();

    public List<String> getIptcKeywords();

    public String getIptcObjectName();

    default public Projections getProjectionType() {
        return Projections.PERSPECTIVE;
    }
}

