/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Supplier;

public class SecretGenerator {
    public static final int SECRET_LENGTH_256_BITS = 32;
    public static final int SECRET_LENGTH_384_BITS = 48;
    public static final int SECRET_LENGTH_512_BITS = 64;
    private static final int SESSION_ID_BYTES = 18;
    public static final Supplier<String> SECURE_ID_GENERATOR = () -> SecretGenerator.getInstance().generateBase64SecureId(18);
    public static final char[] UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] DIGITS = "0123456789".toCharArray();
    public static final char[] ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final SecretGenerator instance = new SecretGenerator();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private SecretGenerator() {
    }

    public static SecretGenerator getInstance() {
        return instance;
    }

    public String generateSecureID() {
        return this.generateSecureUUID().toString();
    }

    public String generateBase64SecureId(int nBytes) {
        assert (nBytes > 0);
        byte[] data = new byte[nBytes];
        SECURE_RANDOM.nextBytes(data);
        String id = Base64.getUrlEncoder().encodeToString(data);
        assert (!id.contains("."));
        assert (!id.contains(" "));
        return id;
    }

    public String randomString() {
        return this.randomString(32, ALPHANUM);
    }

    public String randomString(int length) {
        return this.randomString(length, ALPHANUM);
    }

    public String randomString(int length, char[] symbols) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (symbols == null || symbols.length < 2) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = symbols[SECURE_RANDOM.nextInt(symbols.length)];
        }
        return new String(buf);
    }

    public byte[] randomBytes() {
        return this.randomBytes(32);
    }

    public byte[] randomBytes(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[length];
        SECURE_RANDOM.nextBytes(buf);
        return buf;
    }

    public String randomBytesHex(int length) {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.randomBytes(length)) {
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    public static int equivalentEntropySize(int byteLengthEntropy, int dstAlphabetLeng) {
        return SecretGenerator.equivalentEntropySize(byteLengthEntropy, 256, dstAlphabetLeng);
    }

    public static int equivalentEntropySize(int length, int srcAlphabetLength, int dstAlphabetLeng) {
        return (int)Math.ceil((double)length * (Math.log(srcAlphabetLength) / Math.log(dstAlphabetLeng)));
    }

    public UUID generateSecureUUID() {
        byte[] data = this.randomBytes(16);
        return new UUID(SecretGenerator.toLong(data, 0), SecretGenerator.toLong(data, 8));
    }

    private static long toLong(byte[] data, int offset) {
        return ((long)data[offset] & 0xFFL) << 56 | ((long)data[offset + 1] & 0xFFL) << 48 | ((long)data[offset + 2] & 0xFFL) << 40 | ((long)data[offset + 3] & 0xFFL) << 32 | ((long)data[offset + 4] & 0xFFL) << 24 | ((long)data[offset + 5] & 0xFFL) << 16 | ((long)data[offset + 6] & 0xFFL) << 8 | (long)data[offset + 7] & 0xFFL;
    }
}

