/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.fgap;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.evaluation.FGAPPolicyEvaluator;
import org.keycloak.authorization.fgap.evaluation.partial.PartialEvaluationStorageProvider;
import org.keycloak.authorization.fgap.evaluation.partial.PartialEvaluator;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationSchema;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceType;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class AdminPermissionsSchema
extends AuthorizationSchema {
    public static final String CLIENTS_RESOURCE_TYPE = "Clients";
    public static final String GROUPS_RESOURCE_TYPE = "Groups";
    public static final String ROLES_RESOURCE_TYPE = "Roles";
    public static final String USERS_RESOURCE_TYPE = "Users";
    public static final String MANAGE = "manage";
    public static final String VIEW = "view";
    public static final String MAP_ROLES = "map-roles";
    public static final String MAP_ROLES_CLIENT_SCOPE = "map-roles-client-scope";
    public static final String MAP_ROLES_COMPOSITE = "map-roles-composite";
    public static final String MANAGE_MEMBERSHIP = "manage-membership";
    public static final String MANAGE_MEMBERS = "manage-members";
    public static final String VIEW_MEMBERS = "view-members";
    public static final String IMPERSONATE_MEMBERS = "impersonate-members";
    public static final String MAP_ROLE = "map-role";
    public static final String MAP_ROLE_CLIENT_SCOPE = "map-role-client-scope";
    public static final String MAP_ROLE_COMPOSITE = "map-role-composite";
    public static final String IMPERSONATE = "impersonate";
    public static final String RESET_PASSWORD = "reset-password";
    public static final String MANAGE_GROUP_MEMBERSHIP = "manage-group-membership";
    public static final ResourceType CLIENTS = new ResourceType("Clients", Set.of("manage", "map-roles", "map-roles-client-scope", "map-roles-composite", "view"));
    public static final ResourceType GROUPS = new ResourceType("Groups", Set.of("manage", "view", "manage-membership", "manage-members", "view-members", "impersonate-members"));
    public static final ResourceType ROLES = new ResourceType("Roles", Set.of("map-role", "map-role-client-scope", "map-role-composite"));
    public static final ResourceType USERS = new ResourceType("Users", Set.of("manage", "view", "impersonate", "map-roles", "manage-group-membership", "reset-password"), Map.of("view", Set.of("view-members"), "manage", Set.of("manage-members"), "impersonate", Set.of("impersonate-members")), GROUPS.getType());
    private static final String SKIP_EVALUATION = "kc.authz.fgap.skip";
    public static final AdminPermissionsSchema SCHEMA = new AdminPermissionsSchema();
    private final PartialEvaluator partialEvaluator = new PartialEvaluator();
    private final PolicyEvaluator policyEvaluator = new FGAPPolicyEvaluator();

    private AdminPermissionsSchema() {
        super(Map.of(CLIENTS_RESOURCE_TYPE, CLIENTS, GROUPS_RESOURCE_TYPE, GROUPS, ROLES_RESOURCE_TYPE, ROLES, USERS_RESOURCE_TYPE, USERS));
    }

    public Resource getOrCreateResource(KeycloakSession session, ResourceServer resourceServer, String policyType, String resourceType, String id) {
        if (!this.supportsAuthorizationSchema(session, resourceServer)) {
            return null;
        }
        StoreFactory storeFactory = this.getStoreFactory(session);
        ResourceStore resourceStore = storeFactory.getResourceStore();
        Resource resource = resourceStore.findById(resourceServer, id);
        if (resource != null) {
            return resource;
        }
        String name = switch (resourceType) {
            case CLIENTS_RESOURCE_TYPE -> this.resolveClient(session, id).map(ClientModel::getId).orElse(resourceType);
            case GROUPS_RESOURCE_TYPE -> this.resolveGroup(session, id).map(GroupModel::getId).orElse(resourceType);
            case ROLES_RESOURCE_TYPE -> this.resolveRole(session, id).map(RoleModel::getId).orElse(resourceType);
            case USERS_RESOURCE_TYPE -> this.resolveUser(session, id).map(UserModel::getId).orElse(resourceType);
            default -> throw new IllegalStateException("Resource type [" + resourceType + "] not found.");
        };
        resource = resourceStore.findByName(resourceServer, name);
        if (resource == null) {
            resource = resourceStore.create(resourceServer, name, resourceServer.getClientId());
            ScopeStore scopeStore = storeFactory.getScopeStore();
            resource.updateScopes(((ResourceType)this.getResourceTypes().get(resourceType)).getScopes().stream().map(scopeName -> {
                Scope findByName = scopeStore.findByName(resourceServer, (String)scopeName);
                if (findByName == null) {
                    throw new ModelException("No scopes found.");
                }
                return findByName;
            }).collect(Collectors.toSet()));
        }
        return resource;
    }

    public Resource getResourceTypeResource(KeycloakSession session, ResourceServer resourceServer, String resourceType) {
        if (!this.supportsAuthorizationSchema(session, resourceServer)) {
            return null;
        }
        if (resourceType == null) {
            return null;
        }
        ResourceType type = (ResourceType)this.getResourceTypes().get(resourceType);
        if (type == null) {
            return null;
        }
        ResourceStore resourceStore = this.getStoreFactory(session).getResourceStore();
        return resourceStore.findByName(resourceServer, type.getType());
    }

    public boolean isSupportedPolicyType(KeycloakSession session, ResourceServer resourceServer, String type) {
        if (!this.supportsAuthorizationSchema(session, resourceServer)) {
            return true;
        }
        return !type.equals("resource");
    }

    public boolean isAdminPermissionClient(RealmModel realm, String id) {
        return realm.getAdminPermissionsClient() != null && realm.getAdminPermissionsClient().getId().equals(id);
    }

    private boolean supportsAuthorizationSchema(KeycloakSession session, ResourceServer resourceServer) {
        RealmModel realm = session.getContext().getRealm();
        if (!this.isAdminPermissionsEnabled(realm)) {
            return false;
        }
        return this.isAdminPermissionClient(realm, resourceServer.getId());
    }

    public void throwExceptionIfAdminPermissionClient(KeycloakSession session, String id) {
        if (this.isAdminPermissionClient(session.getContext().getRealm(), id)) {
            throw new ModelValidationException("Not supported for this client.");
        }
    }

    private Optional<GroupModel> resolveGroup(KeycloakSession session, String id) {
        RealmModel realm = session.getContext().getRealm();
        return Optional.ofNullable(session.groups().getGroupById(realm, id));
    }

    private Optional<RoleModel> resolveRole(KeycloakSession session, String id) {
        RealmModel realm = session.getContext().getRealm();
        RoleModel role = session.roles().getRoleById(realm, id);
        return Optional.ofNullable(role);
    }

    private Optional<UserModel> resolveUser(KeycloakSession session, String id) {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = session.users().getUserById(realm, id);
        if (user == null) {
            user = session.users().getUserByUsername(realm, id);
        }
        return Optional.ofNullable(user);
    }

    private Optional<ClientModel> resolveClient(KeycloakSession session, String id) {
        RealmModel realm = session.getContext().getRealm();
        ClientModel client = session.clients().getClientById(realm, id);
        if (client == null) {
            client = session.clients().getClientByClientId(realm, id);
        }
        return Optional.ofNullable(client);
    }

    private StoreFactory getStoreFactory(KeycloakSession session) {
        AuthorizationProvider authzProvider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        return authzProvider.getStoreFactory();
    }

    public void throwExceptionIfResourceTypeOrScopesNotProvided(KeycloakSession session, ResourceServer resourceServer, AbstractPolicyRepresentation rep) {
        if (!this.supportsAuthorizationSchema(session, resourceServer)) {
            return;
        }
        if (rep instanceof ScopePermissionRepresentation) {
            if (rep.getResourceType() == null || SCHEMA.getResourceTypes().get(rep.getResourceType()) == null) {
                throw new ModelValidationException("Resource type not provided.");
            }
            if (rep.getScopes() == null || rep.getScopes().isEmpty()) {
                throw new ModelValidationException("Scopes not provided.");
            }
        }
    }

    public Scope getScope(KeycloakSession session, ResourceServer resourceServer, String resourceType, String id) {
        StoreFactory storeFactory = this.getStoreFactory(session);
        Scope scope = Optional.ofNullable(storeFactory.getScopeStore().findById(resourceServer, id)).or(() -> Optional.ofNullable(storeFactory.getScopeStore().findByName(resourceServer, id))).orElseThrow(() -> new ModelValidationException(String.format("Scope [%s] does not exist.", id)));
        if (this.supportsAuthorizationSchema(session, resourceServer) && !((ResourceType)SCHEMA.getResourceTypes().get(resourceType)).getScopes().contains(scope.getName())) {
            throw new ModelValidationException(String.format("Scope %s was not found for resource type %s.", scope.getName(), resourceType));
        }
        return scope;
    }

    public void init(KeycloakSession session, RealmModel realm) {
        ClientProvider clients = session.clients();
        ClientModel client = realm.getAdminPermissionsClient();
        if (client != null) {
            return;
        }
        client = clients.addClient(realm, "admin-permissions");
        client.setProtocol("openid-connect");
        realm.setAdminPermissionsClient(client);
        ResourceServer resourceServer = RepresentationToModel.createResourceServer(client, session, false);
        ResourceServerRepresentation resourceServerRep = ModelToRepresentation.toRepresentation(resourceServer, client);
        Set scopes = SCHEMA.getResourceTypes().values().stream().flatMap(resourceType -> resourceType.getScopes().stream()).map(ScopeRepresentation::new).collect(Collectors.toSet());
        resourceServerRep.setScopes(List.copyOf(scopes));
        resourceServerRep.setResources(SCHEMA.getResourceTypes().keySet().stream().map(type -> {
            ResourceRepresentation resource = new ResourceRepresentation(type, (String[])((ResourceType)SCHEMA.getResourceTypes().get(type)).getScopes().toArray(String[]::new));
            resource.setType(type);
            return resource;
        }).collect(Collectors.toList()));
        RepresentationToModel.toModel(resourceServerRep, (AuthorizationProvider)session.getProvider(AuthorizationProvider.class), client);
    }

    public boolean isAdminPermissionsEnabled(RealmModel realm) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2) && realm != null && realm.isAdminPermissionsEnabled();
    }

    public AuthorizationSchema getAuthorizationSchema(ClientModel client) {
        if (this.isAdminPermissionsEnabled(client.getRealm()) && this.isAdminPermissionClient(client.getRealm(), client.getId())) {
            return SCHEMA;
        }
        return null;
    }

    public void removeResource(Resource resource, Policy policy, AuthorizationProvider authorization) {
        ResourceServer resourceServer = resource.getResourceServer();
        if (this.isAdminPermissionClient(authorization.getRealm(), resourceServer.getId())) {
            if (this.getResourceTypes().get(resource.getName()) == null) {
                List<Policy> policies = authorization.getStoreFactory().getPolicyStore().findByResource(resourceServer, resource);
                if (policies.size() == 1 && policy.equals(policies.get(0))) {
                    authorization.getStoreFactory().getResourceStore().delete(resource.getId());
                } else {
                    policy.removeResource(resource);
                }
            }
        } else {
            policy.removeResource(resource);
        }
    }

    public void removeOrphanResources(Policy policy, AuthorizationProvider authorization) {
        if (this.isAdminPermissionClient(authorization.getRealm(), policy.getResourceServer().getId())) {
            Set<Resource> resources = policy.getResources();
            for (Resource resource : resources) {
                List<Policy> policies;
                if (this.getResourceTypes().get(resource.getName()) != null || (policies = authorization.getStoreFactory().getPolicyStore().findByResource(policy.getResourceServer(), resource)).size() != 1 || !policy.equals(policies.get(0))) continue;
                authorization.getStoreFactory().getResourceStore().delete(resource.getId());
            }
        }
    }

    public String getResourceName(KeycloakSession session, Policy policy, Resource resource) {
        ResourceServer resourceServer = policy.getResourceServer();
        if (this.supportsAuthorizationSchema(session, resourceServer)) {
            return this.getResourceName(session, resourceServer, policy.getResourceType(), resource.getName());
        }
        return resource.getDisplayName();
    }

    public String getResourceName(KeycloakSession session, ResourceServer resourceServer, String resourceType, String resourceName) {
        if (resourceType == null) {
            return resourceName;
        }
        if (this.supportsAuthorizationSchema(session, resourceServer)) {
            switch (resourceType) {
                case "Clients": {
                    return this.resolveClient(session, resourceName).map(ClientModel::getClientId).orElse(resourceType);
                }
                case "Groups": {
                    return this.resolveGroup(session, resourceName).map(GroupModel::getName).orElse(resourceType);
                }
                case "Roles": {
                    return this.resolveRole(session, resourceName).map(RoleModel::getName).orElse(resourceType);
                }
                case "Users": {
                    return this.resolveUser(session, resourceName).map(UserModel::getUsername).orElse(resourceType);
                }
            }
            throw new IllegalStateException("Resource type [" + resourceType + "] not found.");
        }
        return resourceName;
    }

    public void addUResourceTypeResource(KeycloakSession session, ResourceServer resourceServer, Policy policy, String resourceType) {
        Resource resourceTypeResource = this.getResourceTypeResource(session, resourceServer, resourceType);
        if (resourceTypeResource != null) {
            Set<Resource> resources = policy.getResources();
            if (resources.isEmpty()) {
                policy.addResource(resourceTypeResource);
            } else if (resources.size() > 1) {
                policy.removeResource(resourceTypeResource);
            }
        }
    }

    public void removeResourceObject(AuthorizationProvider authorization, ProviderEvent event) {
        String id;
        if (!this.isAdminPermissionsEnabled(authorization.getRealm()) || authorization.getRealm().getAdminPermissionsClient() == null) {
            return;
        }
        if (event instanceof UserModel.UserRemovedEvent) {
            UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
            id = userRemovedEvent.getUser().getId();
        } else if (event instanceof ClientModel.ClientRemovedEvent) {
            ClientModel.ClientRemovedEvent clientRemovedEvent = (ClientModel.ClientRemovedEvent)event;
            id = clientRemovedEvent.getClient().getId();
        } else if (event instanceof GroupModel.GroupRemovedEvent) {
            GroupModel.GroupRemovedEvent groupRemovedEvent = (GroupModel.GroupRemovedEvent)event;
            id = groupRemovedEvent.getGroup().getId();
        } else if (event instanceof RoleContainerModel.RoleRemovedEvent) {
            RoleContainerModel.RoleRemovedEvent roleRemovedEvent = (RoleContainerModel.RoleRemovedEvent)event;
            id = roleRemovedEvent.getRole().getId();
        } else {
            return;
        }
        ResourceServer server = authorization.getStoreFactory().getResourceServerStore().findByClient(authorization.getRealm().getAdminPermissionsClient());
        Resource resource = authorization.getStoreFactory().getResourceStore().findByName(server, id);
        if (resource != null) {
            List<Policy> permissions = authorization.getStoreFactory().getPolicyStore().findByResource(server, resource);
            for (Policy permission : permissions) {
                if (permission.getResources().size() == 1) {
                    authorization.getStoreFactory().getPolicyStore().delete(permission.getId());
                    continue;
                }
                permission.removeResource(resource);
            }
            authorization.getStoreFactory().getResourceStore().delete(resource.getId());
        }
    }

    public List<Predicate> applyAuthorizationFilters(KeycloakSession session, ResourceType resourceType, RealmModel realm, CriteriaBuilder builder, CriteriaQuery<?> queryBuilder, Path<?> path) {
        return this.applyAuthorizationFilters(session, resourceType, null, realm, builder, queryBuilder, path);
    }

    public List<Predicate> applyAuthorizationFilters(KeycloakSession session, ResourceType resourceType, PartialEvaluationStorageProvider evaluator, RealmModel realm, CriteriaBuilder builder, CriteriaQuery<?> queryBuilder, Path<?> path) {
        return this.partialEvaluator.getPredicates(session, resourceType, evaluator, realm, builder, queryBuilder, path);
    }

    public PolicyEvaluator getPolicyEvaluator(KeycloakSession session, ResourceServer resourceServer) {
        if (resourceServer == null) {
            return null;
        }
        RealmModel realm = session.getContext().getRealm();
        if (this.isAdminPermissionClient(realm, resourceServer.getId())) {
            return this.policyEvaluator;
        }
        return null;
    }

    public Set<String> getScopeAliases(String resourceType, Scope scope) {
        ResourceType type = (ResourceType)this.getResourceTypes().get(resourceType);
        HashSet<String> aliases = (HashSet<String>)type.getScopeAliases().get(scope.getName());
        if (aliases == null) {
            aliases = new HashSet<String>();
            for (Map.Entry entry : type.getScopeAliases().entrySet()) {
                if (!((Set)entry.getValue()).contains(scope.getName())) continue;
                aliases.add((String)entry.getKey());
            }
        }
        return aliases;
    }

    public static void runWithoutAuthorization(KeycloakSession session, Runnable runnable) {
        if (AdminPermissionsSchema.isSkipEvaluation(session)) {
            runnable.run();
            return;
        }
        try {
            session.setAttribute(SKIP_EVALUATION, (Object)Boolean.TRUE.toString());
            runnable.run();
        }
        finally {
            session.removeAttribute(SKIP_EVALUATION);
        }
    }

    public static boolean isSkipEvaluation(KeycloakSession session) {
        if (session == null) {
            return true;
        }
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            return true;
        }
        if (!SCHEMA.isAdminPermissionsEnabled(realm)) {
            return true;
        }
        return Boolean.parseBoolean((String)session.getAttributeOrDefault(SKIP_EVALUATION, (Object)Boolean.FALSE.toString()));
    }
}

