/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

public class LightweightTypeReferenceSerializer
extends TypeReferenceVisitor {
    private ISourceAppender appender;

    public LightweightTypeReferenceSerializer(ISourceAppender appender) {
        this.appender = appender;
    }

    @Override
    protected void doVisitAnyTypeReference(AnyTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitArrayTypeReference(ArrayTypeReference reference) {
        reference.getComponentType().accept(this);
        this.appender.append("[]");
    }

    @Override
    protected void doVisitCompoundTypeReference(CompoundTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitFunctionTypeReference(FunctionTypeReference reference) {
        if (this.appender.isJava()) {
            this.doVisitParameterizedTypeReference(reference);
        } else {
            this.appender.append("(");
            this.appendCommaSeparated(reference.getParameterTypes());
            this.appender.append(")=>");
            if (reference.getReturnType() == null) {
                this.appender.append("void");
            } else {
                reference.getReturnType().accept(this);
            }
        }
    }

    @Override
    protected void doVisitInnerFunctionTypeReference(InnerFunctionTypeReference reference) {
        if (this.appender.isJava()) {
            reference.getOuter().accept(this);
            this.appender.append(".");
            this.appender.append(reference.getType().getSimpleName());
            if (!reference.getTypeArguments().isEmpty()) {
                this.appender.append("<");
                this.appendCommaSeparated(reference.getTypeArguments());
                this.appender.append(">");
            }
        } else {
            this.appender.append("(");
            this.appendCommaSeparated(reference.getParameterTypes());
            this.appender.append(")=>");
            if (reference.getReturnType() == null) {
                this.appender.append("void");
            } else {
                reference.getReturnType().accept(this);
            }
        }
    }

    @Override
    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        if (reference.isAnonymous()) {
            reference.getNamedType().accept(this);
        } else {
            this.appender.append(reference.getType());
            if (!reference.getTypeArguments().isEmpty()) {
                this.appender.append("<");
                this.appendCommaSeparated(reference.getTypeArguments());
                this.appender.append(">");
            }
        }
    }

    @Override
    protected void doVisitInnerTypeReference(InnerTypeReference reference) {
        reference.getOuter().accept(this);
        this.appender.append(".");
        this.appender.append(reference.getType().getSimpleName());
        if (!reference.getTypeArguments().isEmpty()) {
            this.appender.append("<");
            this.appendCommaSeparated(reference.getTypeArguments());
            this.appender.append(">");
        }
    }

    @Override
    protected void doVisitUnboundTypeReference(UnboundTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitUnknownTypeReference(UnknownTypeReference reference) {
        this.appender.append(reference.getSimpleName());
    }

    @Override
    protected void doVisitWildcardTypeReference(WildcardTypeReference reference) {
        this.appender.append("?");
        if (reference.getLowerBound() != null) {
            this.appender.append(" super ");
            reference.getLowerBound().accept(this);
        } else {
            Iterable relevantUpperBounds = Iterables.filter(reference.getUpperBounds(), it -> !"java.lang.Object".equals(it.getIdentifier()));
            if (!Iterables.isEmpty((Iterable)relevantUpperBounds)) {
                this.appender.append(" extends ");
                boolean isFirst = true;
                for (LightweightTypeReference upperBound : relevantUpperBounds) {
                    if (!isFirst) {
                        this.appender.append(" & ");
                    }
                    isFirst = false;
                    upperBound.accept(this);
                }
            }
        }
    }

    protected void appendCommaSeparated(List<LightweightTypeReference> references) {
        boolean isFirst = true;
        for (LightweightTypeReference reference : references) {
            if (!isFirst) {
                this.appender.append(", ");
            }
            isFirst = false;
            reference.accept(this);
        }
    }
}

