\echo Use "CREATE EXTENSION postgis" to load this file. \quit
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
----
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011 Regina Obe <lr@pcorp.us>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- Author: Regina Obe <lr@pcorp.us>
--
-- This is a suite of SQL helper functions for use during a PostGIS extension install/upgrade
-- The functions get uninstalled after the extension install/upgrade process
---------------------------
CREATE FUNCTION postgis_extension_drop_if_exists(param_extension text, param_statement text)
  RETURNS boolean AS
$$
DECLARE
	var_sql_ext text := 'ALTER EXTENSION ' OPERATOR(pg_catalog.||) pg_catalog.quote_ident(param_extension) OPERATOR(pg_catalog.||) ' ' OPERATOR(pg_catalog.||) pg_catalog.replace(param_statement, 'IF EXISTS', '');
	var_result boolean := false;
BEGIN
	BEGIN
		EXECUTE var_sql_ext;
		var_result := true;
	EXCEPTION
		WHEN OTHERS THEN
			--this is to allow ignoring if the object does not exist in extension
			var_result := false;
	END;
	RETURN var_result;
END;
$$
LANGUAGE plpgsql VOLATILE;

CREATE FUNCTION postgis_extension_AddToSearchPath(a_schema_name text)


RETURNS text
AS
$BODY$
DECLARE
	var_result text;
	var_cur_search_path text;
	a_schema_name text := $1;
BEGIN
	WITH settings AS (
		SELECT unnest(setconfig) config
		FROM pg_db_role_setting
		WHERE setdatabase = (
			SELECT oid
			FROM pg_database
			WHERE datname = current_database()
		) and setrole = 0
	)
	SELECT regexp_replace(config, '^search_path=', '')
	FROM settings WHERE config like 'search_path=%'
	INTO var_cur_search_path;

	RAISE NOTICE 'cur_search_path from pg_db_role_setting is %', var_cur_search_path;

	-- only run this test if person creating the extension is a super user
	IF var_cur_search_path IS NULL AND (SELECT rolsuper FROM pg_roles where rolname = CURRENT_USER) THEN
		SELECT setting
		INTO var_cur_search_path
		FROM pg_file_settings
		WHERE name = 'search_path' AND applied;

		RAISE NOTICE 'cur_search_path from pg_file_settings is %', var_cur_search_path;
	END IF;

	IF var_cur_search_path IS NULL THEN
		SELECT boot_val
		INTO var_cur_search_path
		FROM pg_settings
		WHERE name = 'search_path';

		RAISE NOTICE 'cur_search_path from pg_settings is %', var_cur_search_path;
	END IF;

	IF var_cur_search_path LIKE '%' || quote_ident(a_schema_name) || '%' THEN
		var_result := a_schema_name || ' already in database search_path';
	ELSE
		var_cur_search_path := var_cur_search_path || ', '
                       || quote_ident(a_schema_name);
		EXECUTE 'ALTER DATABASE ' || quote_ident(current_database())
                             || ' SET search_path = ' || var_cur_search_path;
		var_result := a_schema_name || ' has been added to end of database search_path ';
	END IF;

	EXECUTE 'SET search_path = ' || var_cur_search_path;

  RETURN var_result;
END
$BODY$
SET search_path = pg_catalog -- make safe
LANGUAGE 'plpgsql' VOLATILE STRICT
;



DO $unpackage_if_needed$
BEGIN
	IF EXISTS (
		select t.typname from pg_catalog.pg_depend d, pg_catalog.pg_extension e, pg_catalog.pg_type t where
		e.extname = 'postgis' and d.refclassid =
		'pg_catalog.pg_extension'::pg_catalog.regclass and d.refobjid = e.oid
		and d.classid = 'pg_catalog.pg_type'::pg_catalog.regclass and d.objid = t.oid
		and t.typname = 'raster'
	) THEN

		RAISE WARNING 'unpackaging raster';

		EXECUTE $unpackage$
		-- UNPACKAGE_CODE --
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bytea(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box2d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box2d(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebra(raster, integer, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, integer, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFctNgb(raster, integer, text, integer, integer, regprocedure, text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text[] , double precision[] , double precision[] , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , double precision , double precision , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , raster , text , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRaster(geometry,double precision , double precision, integer , integer,text[] , double precision[] ,double precision[] ,  double precision,  double precision, double precision,double precision, double precision, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_Resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Resample(raster, raster, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_HasNoBand(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster,integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster,int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text,integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, integer, boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, integer, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE quantile;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE valuecount;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( raster, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( raster, int, boolean, double precision, int, double precision[], boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE histogram;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE bandmetadata;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE geomvalxy;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_st_samealignment();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minpossibleval(text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygon(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE wktgeomval;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandsurface(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster[], integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, double precision, double precision, double precision, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoord( raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_raster2worldcoord(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, double precision, double precision, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, integer, integer, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile(raster, integer, integer, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer[], integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_regular_blocking(name, name, name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asbinary(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, record[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,boolean,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster,boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster, integer, boolean, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry, raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(raster,raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, raster, regprocedure, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionfinal1(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text, text, text, float8, text, text, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, int, geometry, float8[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra(rastbandarg[],regprocedure,text,integer,integer,text,raster,text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram(text, text, int, boolean, double precision, int,double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int,double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband integer, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband integer, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(rast raster, band integer, pt geometry, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdalopenoptions(text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(rast raster, geom geometry, nodataval float8[], crop boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_overviews;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_samealignment (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, unionarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_AsRasterAgg (geom geometry, val float8, ref raster, pixeltype text, nodataval float8, uniontype text, touched boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR CLASS hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR FAMILY hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR =  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR >>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |&>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |>>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~=  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box3d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_scripts_installed ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_build_date ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_gdal_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_envelope (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_convexhull (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minconvexhull (	rast raster,	nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box3d (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_height (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_numbands (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scalex (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scaley (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewy (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_srid (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperleftx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperlefty (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_width (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelwidth (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelheight (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_geotransform (raster,    OUT imag double precision,    OUT jmag double precision,    OUT theta_i double precision,    OUT theta_ij double precision,    OUT xoffset double precision,    OUT yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rotation (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_metadata (	rast raster,	OUT upperleftx double precision,	OUT upperlefty double precision,	OUT width int,	OUT height int,	OUT scalex double precision,	OUT scaley double precision,	OUT skewx double precision,	OUT skewy double precision,	OUT srid int,	OUT numbands int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summary (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MemSize (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (rast raster, addbandargset addbandarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrast raster,	fromband int ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrasts raster[], fromband integer ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	outdbfile text, outdbindex int[],	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	outdbfile text, outdbindex int[],	index int ,	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands int[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nband int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands text, delimiter char );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	exclude_nodata_value boolean,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_finalfn (internal);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, integer,	boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_finalfn (agg agg_count);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION __st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer , exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	min double precision , max double precision ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	exclude_nodata_value boolean,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	exclude_nodata_value boolean,	sample_percent double precision,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rastertable text,	rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_ReclassExact (rast raster,	inputvalues float8[], outputvalues float8[],	bandnumber integer ,	outputpixeltype text ,	nodatavalue float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_colormap (	rast raster, nband int,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster, nband int ,	colormap text ,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_fromgdalraster (gdaldata bytea, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers (	OUT idx int,	OUT short_name text,	OUT long_name text,	OUT can_read boolean,	OUT can_write boolean,	OUT create_options text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Contour (		rast raster,		bandnumber integer ,		level_interval float8 ,		level_base float8 ,		fixed_levels float8[] ,		polygonize boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_InterpolateRaster (		geom geometry,		options text,		rast raster,		bandnumber integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_asraster (	geom geometry,	scalex double precision , scaley double precision ,	width integer , height integer ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text,	value double precision ,	nodataval double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_gdalwarp (	rast raster,	algorithm text , maxerr double precision ,	srid integer ,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	width integer , height integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	width integer, height integer,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	algorithm text ,	maxerr double precision ,	usescale boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	usescale boolean,	algorithm text ,	maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (	rast raster,	alignto raster,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewx double precision, skewy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewxy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	algorithm text , maxerr double precision ,	scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalex double precision, scaley double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalexy double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width text, height text,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width integer, height integer,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	percentwidth double precision, percentheight double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, band integer, pixeltype text,        expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, pixeltype text, expression text,        nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure,        variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	tworastuserfunc regprocedure,	pixeltype text , extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster,	rast2 raster,	tworastuserfunc regprocedure,	pixeltype text ,	extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafctngb (    rast raster,    band integer,    pixeltype text,    ngbwidth integer,    ngbheight integer,    onerastngbuserfunc regprocedure,    nodatamode text,    variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	distancex integer , distancey integer ,	extenttype text , customextent raster ,	mask double precision[][] , weighted boolean ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, nband1 int,	rast2 raster, nband2 int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	mask double precision [][], weighted boolean,	pixeltype text ,	extenttype text , customextent raster ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband integer,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_convertarray4ma (value double precision[][]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_invdistweight4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mindist4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster,	nband integer,	customextent raster,	pixeltype text ,	units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster,	nband integer ,	pixeltype text ,	units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster,	nband integer,	customextent raster,	pixeltype text ,	units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster,	nband integer ,	pixeltype text ,	units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer,	customextent raster,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer ,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tpi4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_roughness4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_roughness (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_roughness (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tri4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer,	customextent raster,	pixeltype text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_grayscale4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rastbandargset rastbandarg[],	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rast raster, 	redband integer , 	greenband integer , 	blueband integer ,	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_isempty (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hasnoband (rast raster, nband int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandnodatavalue (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, band integer , forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, forceChecking boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandPixelType (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandFileSize (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION St_BandFileTimestamp (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, pt geometry, exclude_nodata_value boolean , resample text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, pt geometry, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setz (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setm (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelofValue (	rast raster,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference (rast raster, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scale float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scalex float8, scaley float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skew float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skewx float8, skewy float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setsrid (rast raster, srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setupperleft (rast raster, upperleftx float8, upperlefty float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setrotation (rast raster, rotation float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeotransform (rast raster,    imag double precision,    jmag double precision,    theta_i double precision,    theta_ij double precision,    xoffset double precision,    yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (rast raster, georef text, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (	rast raster,	upperleftx double precision, upperlefty double precision,	scalex double precision, scaley double precision,	skewx double precision, skewy double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile (	rast raster,	width integer, height integer,	nband integer[] ,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer[],	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, band integer, nodatavalue float8, forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, nodatavalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandpath (rast raster, band integer, outdbpath text, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandindex (rast raster, band integer, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	hasnosetvalue boolean ,	nosetvalue double precision ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	nosetvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	geomvalset geomval[],	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (rast raster, band integer, x integer, y integer, newvalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (rast raster, x integer, y integer, newvalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (	rast raster, nband integer,	geom geometry, newvalue double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (	rast raster,	geom geometry, newvalue double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons (rast raster, band integer , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpvalues (	rast raster, nband integer[] , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpvalues (rast raster, nband integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_pixelaspolygons (	rast raster,	band integer ,	columnx integer ,	rowy integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygons (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygon (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspoints (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspoint (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_pixelascentroids (	rast raster,	band integer ,	columnx integer ,	rowy integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelascentroids (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelascentroid (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_worldtorastercoord (	rast raster,	longitude double precision , latitude double precision ,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoord (	rast raster,	longitude double precision, latitude double precision,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoord (	rast raster, pt geometry,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, xw float8, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, xw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, pt geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, xw float8, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, pt geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_rastertoworldcoord (	rast raster,	columnx integer , rowy integer ,	OUT longitude double precision,	OUT latitude double precision	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoord (	rast raster,	columnx integer, rowy integer,	OUT	longitude double precision,	OUT latitude double precision	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordx (rast raster, xr int, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordx (rast raster, xr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordy (rast raster, xr int, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordy (rast raster, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minpossiblevalue (pixeltype text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastfromwkb (bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastfromhexwkb (text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aswkb (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asbinary (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_ashexwkb (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION bytea (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_hash (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_eq (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overleft (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overright (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_left (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_right (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overabove (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overbelow (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_above (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_below (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_same (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contained (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contain (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overlap (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_geometry_contain (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contained_by_geometry (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_geometry_overlap (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_raster_contain (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_contained_by_raster (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_raster_overlap (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_samealignment (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_samealignment (	ulx1 double precision, uly1 double precision, scalex1 double precision, scaley1 double precision, skewx1 double precision, skewy1 double precision,	ulx2 double precision, uly2 double precision, scalex2 double precision, scaley2 double precision, skewx2 double precision, skewy2 double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_samealignment_transfn (agg agg_samealignment, rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_samealignment_finalfn (agg agg_samealignment);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_notsamealignmentreason (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_iscoveragetile (rast raster, coverage raster, tilewidth integer, tileheight integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects (geom geometry, rast raster, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (geom geometry, rast raster, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast raster, geom geometry, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast raster, nband integer, geom geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_containsproperly (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_containsproperly (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_containsproperly (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_covers (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_covers (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_covers (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_coveredby (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_coveredby (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_coveredby (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_within (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_within (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_within (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_DWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DWithin (rast1 raster, rast2 raster, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_DFullyWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DFullyWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DFullyWithin (rast1 raster, rast2 raster, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_disjoint (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Disjoint (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_IntersectionFractions (rast raster, geom geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (geomin geometry, rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (rast raster, band integer, geomin geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (rast raster, geomin geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	returnband text ,	nodataval double precision[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	returnband text,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	nodataval double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	returnband text ,	nodataval double precision[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	returnband text,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	nodataval double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_finalfn (internal);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, unionarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRasterAgg_transfn (staterast raster, geom geometry, val float8, rast raster, pixeltype text, nodataval float8, uniontype text, touched boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRasterAgg_finalfn (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_clip (	rast raster, nband integer[],	geom geometry,	nodataval float8[] , crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	nband integer[],	geom geometry,	nodataval float8[],	crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster, nband integer,	geom geometry,	nodataval float8, crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	nband integer,	geom geometry,	crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	nodataval float8[] , crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	nodataval double precision, crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	crop boolean, touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster, band integer,	pt geometry,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster,	pt geometry,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster, band integer,	columnx integer, rowy integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster,	columnx integer, rowy integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_neighborhood (	rast raster, band integer,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster, band integer,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster, band integer,	pt geometry,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster,	pt geometry,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint (cn name, sql text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint (rastschema name, rasttable name, cn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_regular_blocking (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_regular_blocking (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_pixel_types (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_nodata_values (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_out_db (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_index (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean , 	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean , 	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean ,	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean ,	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _overview_constraint (ov raster, factor integer, refschema name, reftable name, refcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _overview_constraint_info (	ovschema name, ovtable name, ovcolumn name,		OUT refschema name,		OUT reftable name,		OUT refcolumn name,		OUT factor integer	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_overview_constraint (	ovschema name, ovtable name, ovcolumn name,	refschema name, reftable name, refcolumn name,	factor integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_overview_constraint (ovschema name, ovtable name, ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddOverviewConstraints  (	ovschema name, ovtable name, ovcolumn name,	refschema name, reftable name, refcolumn name,	ovfactor int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddOverviewConstraints  (	ovtable name, ovcolumn name,	reftable name, refcolumn name,	ovfactor int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropOverviewConstraints  (	ovschema name,	ovtable name,	ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropOverviewConstraints  (	ovtable name,	ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _UpdateRasterSRID (	schema_name name, table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION UpdateRasterSRID (	schema_name name, table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION UpdateRasterSRID (	table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Retile (tab regclass, col name, ext geometry, sfx float8, sfy float8, tw int, th int, algo text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_CreateOverview (tab regclass, col name, factor int, algo text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptycoverage (tilewidth int, tileheight int, width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_noop (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE raster;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE rastbandarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE geomval;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE addbandarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE summarystats;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE agg_count;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE reclassarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE agg_samealignment;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE unionarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_in (cstring);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_out (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
		$unpackage$;

		RAISE WARNING 'PostGIS Raster functionality has been unpackaged'
		USING HINT = 'type `SELECT postgis_extensions_upgrade();` to finish the upgrade.'
						' After upgrading, if you want to drop raster, run: DROP EXTENSION postgis_raster;';
	END IF;
END
$unpackage_if_needed$ LANGUAGE 'plpgsql';

-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011-2012 Sandro Santilli <strk@kbt.io>
-- Copyright (C) 2010-2013 Regina Obe <lr@pcorp.us>
-- Copyright (C) 2009      Paul Ramsey <pramsey@cleverelephant.ca>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- This file contains utility functions for use by upgrade scripts
-- Changes to this file affect *upgrade*.sql script.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

--
-- Helper function to drop functions when they match the full signature
--
-- Requires name and __exact arguments__ as extracted from pg_catalog.pg_get_function_arguments
-- You can extract the old function arguments using a query like:
--
--  SELECT pg_get_function_arguments('st_intersection(geometry,geometry,float8)'::regprocedure);
--
-- Or:
--
--  SELECT pg_get_function_arguments(oid) as args
--  FROM pg_catalog.pg_proc
--  WHERE proname = 'st_asgeojson'
--
CREATE OR REPLACE FUNCTION _postgis_drop_function_by_identity(
	function_name text,
	function_arguments text,
	deprecated_in_version text DEFAULT 'xxx'
) RETURNS void AS $$
DECLARE
	sql text;
	postgis_namespace OID;
	matching_function pg_catalog.pg_proc;
	detail TEXT;
	deprecated_suffix TEXT := '_deprecated_by_postgis_' || deprecated_in_version;
  deprecated_suffix_len INT := length(deprecated_suffix);
BEGIN

	-- Fetch install namespace for PostGIS
	SELECT n.oid
	FROM pg_catalog.pg_proc p
	JOIN pg_catalog.pg_namespace n ON p.pronamespace = n.oid
	WHERE proname = 'postgis_full_version'
	INTO postgis_namespace;

	-- Find a function matching the given signature
	SELECT *
	FROM pg_catalog.pg_proc p
	WHERE pronamespace = postgis_namespace
	AND pg_catalog.LOWER(p.proname) = pg_catalog.LOWER(function_name)
	AND pg_catalog.pg_function_is_visible(p.oid)
	AND pg_catalog.LOWER(pg_catalog.pg_get_function_identity_arguments(p.oid)) = pg_catalog.LOWER(function_arguments)
	INTO matching_function;

	IF matching_function.oid IS NOT NULL THEN
		sql := format('ALTER FUNCTION %s RENAME TO %I',
			matching_function.oid::regprocedure,
			SUBSTRING(matching_function.proname,1,63-deprecated_suffix_len) || deprecated_suffix --limit to 63 characters
		);
		RAISE DEBUG 'SQL query: %', sql;
		BEGIN
			EXECUTE sql;
		EXCEPTION
			WHEN OTHERS THEN
				GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
				RAISE EXCEPTION 'Could not rename deprecated function %, got % (%)',
					matching_function, SQLERRM, SQLSTATE
				USING DETAIL = detail;
		END;
	END IF;

END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION _postgis_drop_cast_by_types(
  sourcetype text,
	targettype text,
	deprecated_in_version text DEFAULT 'xxx'
) RETURNS void AS $$
DECLARE
	sql text;
	detail TEXT;
	cast_source TEXT;
	cast_target TEXT;
	new_name TEXT;
BEGIN
	-- Check if the cast exists
	BEGIN
		SELECT castsource::pg_catalog.regtype::text, casttarget::pg_catalog.regtype::text
		INTO STRICT cast_source, cast_target
		FROM pg_catalog.pg_cast
    WHERE castsource::pg_catalog.regtype::text = lower(sourcetype)
		AND casttarget::pg_catalog.regtype::text = lower(targettype);
	EXCEPTION
	WHEN NO_DATA_FOUND THEN
		RAISE DEBUG 'Deprecated cast (topology.% as %) does not exist', sourcetype, targettype;
		RETURN;
	WHEN others THEN
		GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
		RAISE WARNING 'Could not check deprecated cast (% as %) existence, got % (%), assuming it does not exist',
			sourcetype, targettype, SQLERRM, SQLSTATE
		USING DETAIL = detail;
		RETURN;
	END;

	new_name := cast_source || '_' || cast_target;
	sql := pg_catalog.format(
		'DROP CAST IF EXISTS (topology.%s AS %s)',
		cast_source,
		cast_target
	);
  RAISE DEBUG 'SQL: %', sql;
	EXECUTE sql;

END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION _postgis_drop_function_by_signature(
  function_signature text,
  deprecated_in_version text DEFAULT 'xxx'
) RETURNS void AS $$
DECLARE
	sql text;
	detail TEXT;
	newname TEXT;
	proc RECORD;
	deprecated_suffix TEXT := '_deprecated_by_postgis_' || deprecated_in_version;
	deprecated_suffix_len INT := length(deprecated_suffix);
BEGIN

	-- Check if the deprecated function exists
	BEGIN

		SELECT *
		FROM pg_catalog.pg_proc
		WHERE oid = function_signature::regprocedure
		INTO STRICT proc;

	EXCEPTION
	WHEN NO_DATA_FOUND OR UNDEFINED_FUNCTION OR UNDEFINED_OBJECT THEN
		RAISE DEBUG 'Deprecated function % does not exist', function_signature;
		RETURN;
	WHEN others THEN
		GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
		RAISE WARNING 'Could not check deprecated function % existence, got % (%), assuming it does not exist',
			function_signature, SQLERRM, SQLSTATE
		USING DETAIL = detail;
		RETURN;
	END;

	sql := pg_catalog.format(
		'ALTER FUNCTION %s RENAME TO %I',
		proc.oid::regprocedure,
		SUBSTRING(proc.proname,1,63-deprecated_suffix_len) || deprecated_suffix -- limit to 63 characters
	);
	EXECUTE sql;

END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION _postgis_topology_upgrade_domain_type(
  domain_name text,
	old_domain_type text,
	new_domain_type text,
	deprecated_in_version text DEFAULT 'xxx'
) RETURNS void AS $$
DECLARE
	detail TEXT;
	-- We need the base types of the old and new types - if multidimensional (int[][]), we need just one dimension at most
	old_base_type TEXT := regexp_replace(old_domain_type, E'(\\[\\])+$', '[]');
	new_base_type TEXT := regexp_replace(new_domain_type, E'(\\[\\])+$', '[]');
	array_dims INT := (SELECT count(*) FROM regexp_matches (old_domain_type, E'\\[\\]', 'g'));
BEGIN
	IF EXISTS (SELECT 1 FROM pg_catalog.pg_type AS t
		WHERE  typnamespace::regnamespace::text = 'topology'
		AND typname::text = lower(domain_name)
		AND typbasetype::regtype::text = lower(old_base_type)
    AND typndims = array_dims)
  	THEN
		BEGIN
			-- HACK: We need to swap out the base type and number of dimensions
			UPDATE pg_catalog.pg_type
			SET typbasetype = new_base_type::regtype::oid, typndims = array_dims
			WHERE typnamespace::regnamespace::text = 'topology'
			AND typname::text = lower(domain_name)
			AND typbasetype::regtype::text = lower(old_base_type)
			AND typndims = array_dims;

			RAISE INFO 'Upgraded % from % to %', domain_name, old_domain_type, new_domain_type;
		EXCEPTION
		WHEN others THEN
			GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
			RAISE WARNING 'Could not modify % from % to %, got % (%)',
				domain_name, old_domain_type, new_domain_type, SQLERRM, SQLSTATE USING DETAIL = detail;
			RETURN;
		END;
	ELSE
		RAISE DEBUG 'Deprecated domain (topology.% with type %) does not exist', domain_name, old_domain_type;
		RETURN;
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION _postgis_topology_upgrade_user_type_attribute(
  type_name text,
	attr_name text,
	old_attr_type text,
	new_attr_type text,
	deprecated_in_version text DEFAULT 'xxx'
) RETURNS void AS $$
DECLARE
	sql text;
	detail TEXT;
	num_updated integer;
	proc RECORD;
	temp_attr_name TEXT := attr_name || '_tmp';
	colname text;
	excluded_columns text[] := ARRAY['attnum', 'attname', 'attrelid'];
BEGIN
	BEGIN
		-- Check if the attribute exists
		-- Get the attribute id and number of attributes (so we can reset relnatts after adding/deleting temp attribute)
		SELECT pg_type.typrelid attrelid, pg_class.relnatts
		FROM pg_catalog.pg_type
			join pg_class on pg_class.oid = pg_type.typrelid
			join pg_attribute on pg_attribute.attrelid = pg_class.oid
			join pg_type as pg_attr_type on pg_attr_type.oid = pg_attribute.atttypid
		where pg_type.typname::regtype::text = lower(type_name)
		and pg_type.typnamespace::regnamespace::text = 'topology'
		and attname::text = lower(attr_name)
		and pg_attr_type.typname::regtype::text = lower(old_attr_type)
		INTO STRICT proc;

	EXCEPTION
	WHEN NO_DATA_FOUND THEN
		RAISE DEBUG 'Deprecated type (topology.% with attribute %(%)) does not exist', type_name, attr_name, old_attr_type;
		RETURN;
	WHEN others THEN
		GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
		RAISE WARNING 'Could not check deprecated type (topology.% with attribute %(%)) existence, got % (%), assuming it does not exist',
			type_name, attr_name, old_attr_type, SQLERRM, SQLSTATE
		USING DETAIL = detail;
		RETURN;
	END;

	BEGIN
		-- Add a temporary attribute with the required type
		-- This is the cleanest way to ensure the type is valid and all constraints are met
		sql := format(
			'ALTER TYPE topology.%s ADD ATTRIBUTE %s %s',
			type_name,
			temp_attr_name,
			new_attr_type
		);
		--RAISE INFO 'SQL: %', sql;
		EXECUTE sql;

		-- Copy the attributes from the temp attribute to the existing attribute
		sql := 'UPDATE pg_attribute AS tgt SET ';

		BEGIN
  		FOR colname IN
    	SELECT column_name
    	FROM information_schema.columns
    	WHERE table_name = 'pg_attribute'
      AND column_name <> ALL (excluded_columns)
			AND column_name NOT LIKE 'oid%' -- Exclude system columns
  		LOOP
    		sql := sql || format('%I = src.%I, ', colname, colname);
  		END LOOP;

  		-- remove trailing comma and add FROM/WHERE clause
  		sql := left(sql, -2) || ' FROM pg_attribute AS src WHERE ' || format('tgt.attrelid = %s AND tgt.attname = %L AND src.attrelid = %s AND src.attname = %L',
				proc.attrelid,
				attr_name,
				proc.attrelid,
				temp_attr_name
			);

  		--RAISE INFO 'SQL: %', sql;
  		EXECUTE sql;
		END;

		-- Delete temp attribute since we cannot alter the type
		sql := format(
			'DELETE FROM pg_attribute WHERE attname = %L AND attrelid = %s',
			temp_attr_name,
			proc.attrelid
		);
		--RAISE INFO 'SQL: %', sql;
		EXECUTE sql;

		-- Reset the number of attributes in pg_class else postgres will complain
		sql := format(
				'UPDATE pg_class SET relnatts = %s WHERE oid = %s',
				proc.relnatts,
				proc.attrelid
		);
		--RAISE INFO 'SQL: %', sql;
		EXECUTE sql;

		RAISE INFO 'Upgraded %.% from % to %', type_name, attr_name, old_attr_type, new_attr_type;
	EXCEPTION
	WHEN others THEN
		GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
		RAISE WARNING 'Could not modify %.% from % to %, got % (%)',
			type_name, attr_name, old_attr_type, new_attr_type, SQLERRM, SQLSTATE
		USING DETAIL = detail;
		RETURN;
	END;
END;
$$ LANGUAGE plpgsql;

-- Add useslargeids to topology
CREATE OR REPLACE FUNCTION _postgis_add_column_to_table(
  tab regclass,
	columnname name,
	data_type text,
	is_not_null BOOLEAN,
	default_value text,
	deprecated_in_version text DEFAULT 'xxx'
	) RETURNS void
AS $BODY$
DECLARE
	schemaname TEXT;
	tablename TEXT;
	default_clause TEXT := '';
	null_clause TEXT := '';
	sql text;
BEGIN
	-- Check if the table exists and get its schema and name
	SELECT n.nspname::text, c.relname::text INTO schemaname, tablename
  FROM pg_class c
  JOIN pg_namespace n ON c.relnamespace = n.oid
  WHERE c.oid = tab;

  IF NOT EXISTS(SELECT 1 FROM information_schema.columns
    WHERE table_schema=schemaname AND table_name=tablename AND column_name=columnname)
  THEN
		IF is_not_null THEN
			null_clause := 'NOT NULL';
		END IF;

		IF LENGTH(default_value) > 0 THEN
			default_clause := 'DEFAULT ' || default_value;
		END IF;

		-- Add the column
		-- Postgres manages adding the column with default and not null correctly
		-- See https://www.postgresql.org/docs/current/sql-altertable.html
		sql := pg_catalog.format(
			'ALTER TABLE %s ADD COLUMN %s %s %s %s',
			tab::text,
			columnname,
			data_type,
			null_clause,
			default_clause
		);

		--RAISE INFO 'SQL: %', sql;
		EXECUTE sql;


		RAISE INFO 'Modified % added %(%)', tab::text, columnname, data_type;
  END IF;
END;
$BODY$ LANGUAGE 'plpgsql';
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011-2012 Sandro Santilli <strk@kbt.io>
-- Copyright (C) 2010-2013 Regina Obe <lr@pcorp.us>
-- Copyright (C) 2009      Paul Ramsey <pramsey@cleverelephant.ca>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- This file contains drop commands for obsoleted items that need
-- to be dropped _before_ upgrade of old functions.
-- Changes to this file affect postgis_upgrade*.sql script.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


-- FUNCTION AddGeometryColumn signature dropped
-- (catalog_name character varying, schema_name character varying, table_name character varying, column_name character varying, new_srid integer, new_type character varying, new_dim integer, use_typmod boolean)
SELECT _postgis_drop_function_by_identity
	(
	'AddGeometryColumn',
	'catalog_name character varying, schema_name character varying, table_name character varying, column_name character varying, new_srid integer, new_type character varying, new_dim integer, use_typmod boolean'
	);

-- FUNCTION ST_AsX3D was changed to add versioning for 2.0
-- (geom geometry, prec integer, options integer)
SELECT _postgis_drop_function_by_identity
	(
	'ST_AsX3D',
	'geom geometry, prec integer, options integer'
	);

-- FUNCTION UpdateGeometrySRID changed the name of the args (http://trac.osgeo.org/postgis/ticket/1606) for 2.0
-- It changed the parameter `new_srid` to `new_srid_in`
-- (catalogn_name character varying, schema_name character varying, table_name character varying, column_name character varying, new_srid integer)
-- Dropping it conditionally since the same signature still exists.
SELECT _postgis_drop_function_by_identity
	(
	'UpdateGeometrySRID',
	'catalogn_name character varying, schema_name character varying, table_name character varying, column_name character varying, new_srid integer'
	);


--deprecated and removed in 2.1
-- Hack to fix 2.0 naming
-- We can't just drop it since its bound to opclass
-- See ticket 2279 for why we need to do this
-- We can get rid of this DO code when 3.0 comes along
DO  language 'plpgsql' $$
BEGIN
	-- fix geometry ops --
	IF EXISTS(SELECT oprname from pg_operator where oprname = '&&' AND oprrest::text = 'geometry_gist_sel_2d') THEN
	--it is bound to old name, drop new, rename old to new, install will fix body of code
		DROP FUNCTION IF EXISTS gserialized_gist_sel_2d(internal, oid, internal, int4) ;
		ALTER FUNCTION geometry_gist_sel_2d(internal, oid, internal, int4) RENAME TO gserialized_gist_sel_2d;
	END IF;
	IF EXISTS(SELECT oprname from pg_operator where oprname = '&&' AND oprjoin::text = 'geometry_gist_joinsel_2d') THEN
	--it is bound to old name, drop new, rename old to new,  install will fix body of code
		DROP FUNCTION IF EXISTS gserialized_gist_joinsel_2d(internal, oid, internal, smallint) ;
		ALTER FUNCTION geometry_gist_joinsel_2d(internal, oid, internal, smallint) RENAME TO gserialized_gist_joinsel_2d;
	END IF;
	-- fix geography ops --
	IF EXISTS(SELECT oprname from pg_operator where oprname = '&&' AND oprrest::text = 'geography_gist_selectivity') THEN
	--it is bound to old name, drop new, rename old to new, install will fix body of code
		DROP FUNCTION IF EXISTS gserialized_gist_sel_nd(internal, oid, internal, int4) ;
		ALTER FUNCTION geography_gist_selectivity(internal, oid, internal, int4) RENAME TO gserialized_gist_sel_nd;
	END IF;

	IF EXISTS(SELECT oprname from pg_operator where oprname = '&&' AND oprjoin::text = 'geography_gist_join_selectivity') THEN
	--it is bound to old name, drop new, rename old to new, install will fix body of code
		DROP FUNCTION IF EXISTS gserialized_gist_joinsel_nd(internal, oid, internal, smallint) ;
		ALTER FUNCTION geography_gist_join_selectivity(internal, oid, internal, smallint) RENAME TO gserialized_gist_joinsel_nd;
	END IF;
END;
$$ ;


-- FUNCTION ST_AsLatLonText went from multiple signatures to a single one with defaults for 2.2.0
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION IF EXISTS ST_AsLatLonText(geometry)');
DROP FUNCTION IF EXISTS ST_AsLatLonText(geometry); -- Does not conflict

SELECT _postgis_drop_function_by_identity
	(
	'ST_AsLatLonText',
	'geometry, text'
	);

-- FUNCTION ST_LineCrossingDirection changed argument names in 3.0
-- Was (geom1 geometry, geom2 geometry) and now (line1 geometry, line2 geometry)
SELECT _postgis_drop_function_by_identity
	(
	'ST_LineCrossingDirection',
	'geom1 geometry, geom2 geometry'
	);

-- FUNCTION _st_linecrossingdirection changed argument names in 3.0
-- Was (geom1 geometry, geom2 geometry) and now (line1 geometry, line2 geometry)
SELECT _postgis_drop_function_by_identity
	(
	'_ST_LineCrossingDirection',
	'geom1 geometry, geom2 geometry'
	);

-- FUNCTION ST_AsGeoJson changed argument names
-- (pretty_print => pretty_bool) in 3.0alpha4
SELECT _postgis_drop_function_by_identity
	(
	'ST_AsGeoJson',
	$args$r record, geom_column text, maxdecimaldigits integer, pretty_print boolean$args$
	);

-- FUNCTION _st_orderingequals changed argument names in 3.0
-- Was (GeometryA geometry, GeometryB geometry) and now (geom1 geometry, geom2 geometry)
SELECT _postgis_drop_function_by_identity
	(
	'_st_orderingequals',
	'GeometryA geometry, GeometryB geometry'
	);

-- FUNCTION st_orderingequals changed argument names in 3.0
-- Was (GeometryA geometry, GeometryB geometry) and now (geom1 geometry, geom2 geometry)
SELECT _postgis_drop_function_by_identity
	(
	'st_orderingequals',
	'GeometryA geometry, GeometryB geometry'
	);

-- This was renamed mid-cycle in PostGIS 3.4.0 development
-- to ST_CoverageInvalidEdges
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION IF EXISTS ST_CoverageInvalidLocations(geometry, double precision)');
DROP FUNCTION IF EXISTS ST_CoverageInvalidLocations(geometry, double precision);

-- geometry_columns changed parameter types so we verify if it needs to be dropped
-- We check the catalog to see if the view (geometry_columns) has a column
-- with name `f_table_schema` and type `character varying(256)` as it was
-- changed to type `name` in 2.2
DO  language 'plpgsql' $$
BEGIN
	IF EXISTS
		(
			WITH oids AS
			(
				SELECT c.oid as oid,
					n.nspname,
					c.relname
					FROM pg_catalog.pg_class c
					LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
					WHERE c.relname = 'geometry_columns' AND
						n.nspname = 'public'
					AND pg_catalog.pg_table_is_visible(c.oid)
					ORDER BY 2, 3

			),
			name_attribute AS
			(
				SELECT  a.attname as attname,
						pg_catalog.format_type(a.atttypid, a.atttypmod) as format_type
						FROM pg_catalog.pg_attribute a, oids
						WHERE a.attrelid = oids.oid AND a.attnum > 0 AND NOT a.attisdropped
						ORDER BY a.attnum
			)
			SELECT attname, format_type
			FROM name_attribute
			WHERE attname = 'f_table_schema' AND format_type = 'character varying(256)'
		)
		THEN
			DROP VIEW geometry_columns;
		END IF;
END;
$$;

--
-- UPGRADE SCRIPT TO PostGIS 3.6.2
--

LOAD '$libdir/postgis-3';

DO $$
DECLARE
    old_scripts text;
    new_scripts text;
    old_ver_int int[];
    new_ver_int int[];
    old_maj text;
    new_maj text;
    postgis_upgrade_info RECORD;
    postgis_upgrade_info_func_code TEXT;
BEGIN

    old_scripts := postgis_scripts_installed();
    new_scripts := '3.6.2';

    BEGIN
        new_ver_int := pg_catalog.string_to_array(
            pg_catalog.regexp_replace(
                new_scripts,
                E'[^\\d.].*',
                ''
            ),
            '.'
        )::int[];
    EXCEPTION WHEN OTHERS THEN
        RAISE EXCEPTION 'Cannot parse new version % into integers', new_scripts;
    END;

    BEGIN
        old_ver_int := pg_catalog.string_to_array(
            pg_catalog.regexp_replace(
                old_scripts,
                E'[^\\d.].*',
                ''
            ),
            '.'
        )::int[];
    EXCEPTION WHEN OTHERS THEN
        RAISE EXCEPTION 'Cannot parse old version % into integers', old_scripts;
    END;

    -- Guard against downgrade
    IF new_ver_int < old_ver_int
    THEN
        RAISE EXCEPTION 'Downgrade of postgis from version % to version % is forbidden', old_scripts, new_scripts;
    END IF;


    -- Check for hard-upgrade being required
    SELECT into old_maj pg_catalog.substring(old_scripts, 1, 1);
    SELECT into new_maj pg_catalog.substring(new_scripts, 1, 1);

    -- 2.x to 3.x was upgrade-compatible, see
    -- https://trac.osgeo.org/postgis/ticket/4170#comment:1
    IF new_maj = '3' AND old_maj = '2' THEN
        old_maj = '3'; -- let's pretend old major = new major
    END IF;

    IF old_maj != new_maj THEN
        RAISE EXCEPTION 'Upgrade of postgis from version % to version % requires a dump/reload. See PostGIS manual for instructions', old_scripts, new_scripts;
    END IF;

    WITH versions AS (
      SELECT '3.6.2'::text as upgraded,
      postgis_scripts_installed() as installed
    ) SELECT
      upgraded as scripts_upgraded,
      installed as scripts_installed,
      pg_catalog.substring(upgraded, '([0-9]+)\.')::int * 100 +
      pg_catalog.substring(upgraded, '[0-9]+\.([0-9]+)(\.|$)')::int
        as version_to_num,
      pg_catalog.substring(installed, '([0-9]+)\.')::int * 100 +
      pg_catalog.substring(installed, '[0-9]+\.([0-9]+)(\.|$)')::int
        as version_from_num,
      installed ~ 'dev|alpha|beta'
        as version_from_isdev
      FROM versions INTO postgis_upgrade_info
    ;

    postgis_upgrade_info_func_code := pg_catalog.format($func_code$
        CREATE FUNCTION _postgis_upgrade_info(OUT scripts_upgraded TEXT,
                                              OUT scripts_installed TEXT,
                                              OUT version_to_num INT,
                                              OUT version_from_num INT,
                                              OUT version_from_isdev BOOLEAN)
        AS
        $postgis_upgrade_info$
        BEGIN
            scripts_upgraded := %L :: TEXT;
            scripts_installed := %L :: TEXT;
            version_to_num := %L :: INT;
            version_from_num := %L :: INT;
            version_from_isdev := %L :: BOOLEAN;
            RETURN;
        END
        $postgis_upgrade_info$ LANGUAGE 'plpgsql' IMMUTABLE;
        $func_code$,
        postgis_upgrade_info.scripts_upgraded,
        postgis_upgrade_info.scripts_installed,
        postgis_upgrade_info.version_to_num,
        postgis_upgrade_info.version_from_num,
        postgis_upgrade_info.version_from_isdev);
    RAISE DEBUG 'Creating function %', postgis_upgrade_info_func_code;
    EXECUTE postgis_upgrade_info_func_code;
END
$$
LANGUAGE 'plpgsql';


CREATE OR REPLACE FUNCTION _postgis_deprecate(oldname text, newname text, version text)
RETURNS void AS
$$
DECLARE
  curver_text text;
BEGIN
  --
  -- Raises a NOTICE if it was deprecated in this version,
  -- a WARNING if in a previous version (only up to minor version checked)
  --
	curver_text := '3.6.2';
	IF pg_catalog.split_part(curver_text,'.',1)::int > pg_catalog.split_part(version,'.',1)::int OR
	   ( pg_catalog.split_part(curver_text,'.',1) = pg_catalog.split_part(version,'.',1) AND
		 pg_catalog.split_part(curver_text,'.',2) != split_part(version,'.',2) )
	THEN
	  RAISE WARNING '% signature was deprecated in %. Please use %', oldname, version, newname;
	ELSE
	  RAISE DEBUG '% signature was deprecated in %. Please use %', oldname, version, newname;
	END IF;
END;
$$ LANGUAGE 'plpgsql' IMMUTABLE STRICT COST 250;
CREATE OR REPLACE FUNCTION spheroid_in(cstring)
	RETURNS spheroid
	AS '$libdir/postgis-3','ellipsoid_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION spheroid_out(spheroid)
	RETURNS cstring
	AS '$libdir/postgis-3','ellipsoid_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type spheroid -- LastUpdated: 5
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 5 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE spheroid (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION geometry_in(cstring)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_out(geometry)
	RETURNS cstring
	AS '$libdir/postgis-3','LWGEOM_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_typmod_in(cstring[])
	RETURNS integer
	AS '$libdir/postgis-3','geometry_typmod_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_typmod_out(integer)
	RETURNS cstring
	AS '$libdir/postgis-3','postgis_typmod_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_analyze(internal)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_analyze_nd'
	LANGUAGE 'c' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION geometry_recv(internal)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_recv'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_send(geometry)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_send'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 1 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE geometry (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION geometry(geometry, integer, boolean)
	RETURNS geometry
	AS '$libdir/postgis-3','geometry_enforce_typmod'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS geometry)');
DROP CAST IF EXISTS (geometry AS geometry);
CREATE CAST (geometry AS geometry) WITH FUNCTION geometry(geometry, integer, boolean) AS IMPLICIT;
CREATE OR REPLACE FUNCTION geometry(point)
	RETURNS geometry
	AS '$libdir/postgis-3','point_to_geometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION point(geometry)
	RETURNS point
	AS '$libdir/postgis-3','geometry_to_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry(path)
	RETURNS geometry
	AS '$libdir/postgis-3','path_to_geometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION path(geometry)
	RETURNS path
	AS '$libdir/postgis-3','geometry_to_path'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry(polygon)
	RETURNS geometry
	AS '$libdir/postgis-3','polygon_to_geometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION polygon(geometry)
	RETURNS polygon
	AS '$libdir/postgis-3','geometry_to_polygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS point)');
DROP CAST IF EXISTS (geometry AS point);
CREATE CAST (geometry AS point) WITH FUNCTION point(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (point AS geometry)');
DROP CAST IF EXISTS (point AS geometry);
CREATE CAST (point AS geometry) WITH FUNCTION geometry(point);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS path)');
DROP CAST IF EXISTS (geometry AS path);
CREATE CAST (geometry AS path) WITH FUNCTION path(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (path AS geometry)');
DROP CAST IF EXISTS (path AS geometry);
CREATE CAST (path AS geometry) WITH FUNCTION geometry(path);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS polygon)');
DROP CAST IF EXISTS (geometry AS polygon);
CREATE CAST (geometry AS polygon) WITH FUNCTION polygon(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (polygon AS geometry)');
DROP CAST IF EXISTS (polygon AS geometry);
CREATE CAST (polygon AS geometry) WITH FUNCTION geometry(polygon);
CREATE OR REPLACE FUNCTION ST_X(geometry)
	RETURNS float8
	AS '$libdir/postgis-3','LWGEOM_x_point'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION ST_Y(geometry)
	RETURNS float8
	AS '$libdir/postgis-3','LWGEOM_y_point'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION ST_Z(geometry)
	RETURNS float8
	AS '$libdir/postgis-3','LWGEOM_z_point'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION ST_M(geometry)
	RETURNS float8
	AS '$libdir/postgis-3','LWGEOM_m_point'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION box3d_in(cstring)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION box3d_out(box3d)
	RETURNS cstring
	AS '$libdir/postgis-3', 'BOX3D_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type box3d -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 1 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE box3d (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION box2d_in(cstring)
	RETURNS box2d
	AS '$libdir/postgis-3','BOX2D_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION box2d_out(box2d)
	RETURNS cstring
	AS '$libdir/postgis-3','BOX2D_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type box2d -- LastUpdated: 8
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 8 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE box2d (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION box2df_in(cstring)
	RETURNS box2df
	AS '$libdir/postgis-3','box2df_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION box2df_out(box2df)
	RETURNS cstring
	AS '$libdir/postgis-3','box2df_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type box2df -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 200 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE box2df (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION gidx_in(cstring)
	RETURNS gidx
	AS '$libdir/postgis-3','gidx_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION gidx_out(gidx)
	RETURNS cstring
	AS '$libdir/postgis-3','gidx_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Type gidx -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 105 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE gidx (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION geometry_lt(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_lt'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_le(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_le'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gt(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_gt'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_ge(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_ge'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_eq(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_eq'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_neq(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'lwgeom_neq'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_cmp(geom1 geometry, geom2 geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'lwgeom_cmp'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_sortsupport(internal)
	RETURNS void
	AS '$libdir/postgis-3', 'lwgeom_sortsupport'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Operator geometry < geometry -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR < (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_lt,
	COMMUTATOR = '>', NEGATOR = '>=',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
-- Operator geometry <= geometry -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<=' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <= (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_le,
	COMMUTATOR = '>=', NEGATOR = '>',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
-- Operator geometry = geometry -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '=' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR = (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_eq,
	COMMUTATOR = '=', NEGATOR = '<>',
	RESTRICT = contsel, JOIN = contjoinsel, HASHES, MERGES
);

  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
-- Operator geometry <> geometry -- LastUpdated: 305
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_neq,
	COMMUTATOR = '<>', NEGATOR = '=',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 305
END
$postgis_proc_upgrade$;
-- Operator geometry >= geometry -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '>=' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR >= (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_ge,
	COMMUTATOR = '<=', NEGATOR = '<',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
-- Operator geometry > geometry -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR > (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_gt,
	COMMUTATOR = '<', NEGATOR = '<=',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
-- Operator class btree_geometry_ops -- LastUpdated: 9
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 9 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS btree_geometry_ops
	DEFAULT FOR TYPE geometry USING btree AS
	OPERATOR	1	< ,
	OPERATOR	2	<= ,
	OPERATOR	3	= ,
	OPERATOR	4	>= ,
	OPERATOR	5	> ,
	FUNCTION	1	geometry_cmp (geom1 geometry, geom2 geometry),
	FUNCTION	2	geometry_sortsupport(internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 9
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_hash(geometry)
	RETURNS integer
	AS '$libdir/postgis-3','lwgeom_hash'
	LANGUAGE 'c' STRICT IMMUTABLE PARALLEL SAFE;
-- Operator class hash_geometry_ops -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 205 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS hash_geometry_ops
	DEFAULT FOR TYPE geometry USING hash AS
	OPERATOR	1   = ,
	FUNCTION	1   geometry_hash(geometry);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_gist_distance_2d(internal,geometry,integer)
	RETURNS float8
	AS '$libdir/postgis-3' ,'gserialized_gist_distance_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_consistent_2d(internal,geometry,integer)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_gist_consistent_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_compress_2d(internal)
	RETURNS internal
	AS '$libdir/postgis-3','gserialized_gist_compress_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_penalty_2d(internal,internal,internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_penalty_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_picksplit_2d(internal, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_picksplit_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_union_2d(bytea, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_union_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_same_2d(geom1 geometry, geom2 geometry, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_same_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_decompress_2d(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_decompress_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_gist_sortsupport_2d(internal)
	RETURNS void
	AS '$libdir/postgis-3', 'gserialized_gist_sortsupport_2d'
	LANGUAGE 'c' STRICT;
CREATE OR REPLACE FUNCTION _postgis_selectivity(tbl regclass, att_name text, geom geometry, mode text default '2')
	RETURNS float8
	AS '$libdir/postgis-3', '_postgis_gserialized_sel'
	LANGUAGE 'c' STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _postgis_join_selectivity(regclass, text, regclass, text, text default '2')
	RETURNS float8
	AS '$libdir/postgis-3', '_postgis_gserialized_joinsel'
	LANGUAGE 'c' STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _postgis_stats(tbl regclass, att_name text, text default '2')
	RETURNS text
	AS '$libdir/postgis-3', '_postgis_gserialized_stats'
	LANGUAGE 'c' STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _postgis_index_extent(tbl regclass, col text)
	RETURNS box2d
	AS '$libdir/postgis-3','_postgis_gserialized_index_extent'
	LANGUAGE 'c' STABLE STRICT;
CREATE OR REPLACE FUNCTION gserialized_gist_sel_2d (internal, oid, internal, integer)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_gist_sel_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION gserialized_gist_sel_nd (internal, oid, internal, integer)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_gist_sel_nd'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION gserialized_gist_joinsel_2d (internal, oid, internal, smallint)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_gist_joinsel_2d'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION gserialized_gist_joinsel_nd (internal, oid, internal, smallint)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_gist_joinsel_nd'
	LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_overlaps(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_overlaps_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry && geometry -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR && (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overlaps,
	COMMUTATOR = '&&',
	RESTRICT = gserialized_gist_sel_2d,
	JOIN = gserialized_gist_joinsel_2d
);

  END IF; -- version_from >= 200
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_same(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_same_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry ~= geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~=' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~= (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_same,
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_distance_centroid(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_Distance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION geometry_distance_box(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_distance_box_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry <-> geometry -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<->' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <-> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_distance_centroid,
	COMMUTATOR = '<->'
);

  END IF; -- version_from >= 200
END
$postgis_proc_upgrade$;
-- Operator geometry <#> geometry -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<#>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <#> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_distance_box,
	COMMUTATOR = '<#>'
);

  END IF; -- version_from >= 200
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_contains(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_contains_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_within(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_within_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry @ geometry -- LastUpdated: 304
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR @ (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_within,
	COMMUTATOR = '~',
	RESTRICT = gserialized_gist_sel_2d,
	JOIN = gserialized_gist_joinsel_2d
);

    ELSE -- version_from >= 304
    -- Last Updated: 304
    IF 304 > version_from_num FROM _postgis_upgrade_info() THEN
        ALTER OPERATOR @ ( geometry, geometry ) SET ( RESTRICT = gserialized_gist_sel_2d );
    END IF;
    
    -- Last Updated: 304
    IF 304 > version_from_num FROM _postgis_upgrade_info() THEN
        ALTER OPERATOR @ ( geometry, geometry ) SET ( JOIN = gserialized_gist_joinsel_2d );
    END IF;
  END IF; -- version_from >= 304
END
$postgis_proc_upgrade$;
-- Operator geometry ~ geometry -- LastUpdated: 304
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~ (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_contains,
	COMMUTATOR = '@',
	RESTRICT = gserialized_gist_sel_2d,
	JOIN = gserialized_gist_joinsel_2d
);

    ELSE -- version_from >= 304
    -- Last Updated: 304
    IF 304 > version_from_num FROM _postgis_upgrade_info() THEN
        ALTER OPERATOR ~ ( geometry, geometry ) SET ( RESTRICT = gserialized_gist_sel_2d );
    END IF;
    
    -- Last Updated: 304
    IF 304 > version_from_num FROM _postgis_upgrade_info() THEN
        ALTER OPERATOR ~ ( geometry, geometry ) SET ( JOIN = gserialized_gist_joinsel_2d );
    END IF;
  END IF; -- version_from >= 304
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_left(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_left_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry << geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<<' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR << (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_left,
	COMMUTATOR = '>>',
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_overleft(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_overleft_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry &< geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&<' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &< (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overleft,
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_below(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_below_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry <<| geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<<|' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <<| (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_below,
	COMMUTATOR = '|>>',
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_overbelow(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_overbelow_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry &<| geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&<|' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &<| (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overbelow,
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_overright(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_overright_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry &> geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overright,
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_right(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_right_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry >> geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '>>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR >> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_right,
	COMMUTATOR = '<<',
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_overabove(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_overabove_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry |&> geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '|&>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR |&> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overabove,
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_above(geom1 geometry, geom2 geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_above_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry |>> geometry -- LastUpdated: 1
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '|>>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR |>> (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_above,
	COMMUTATOR = '<<|',
	RESTRICT = positionsel, JOIN = positionjoinsel
);

  END IF; -- version_from >= 1
END
$postgis_proc_upgrade$;
-- Operator class gist_geometry_ops_2d -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 200 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS gist_geometry_ops_2d
	DEFAULT FOR TYPE geometry USING GIST AS
	STORAGE box2df,
	OPERATOR        1        <<  ,
	OPERATOR        2        &<	 ,
	OPERATOR        3        &&  ,
	OPERATOR        4        &>	 ,
	OPERATOR        5        >>	 ,
	OPERATOR        6        ~=	 ,
	OPERATOR        7        ~	 ,
	OPERATOR        8        @	 ,
	OPERATOR        9        &<| ,
	OPERATOR        10       <<| ,
	OPERATOR        11       |>> ,
	OPERATOR        12       |&> ,
	OPERATOR        13       <-> FOR ORDER BY pg_catalog.float_ops,
	OPERATOR        14       <#> FOR ORDER BY pg_catalog.float_ops,

	FUNCTION        11       geometry_gist_sortsupport_2d (internal),

	FUNCTION        8        geometry_gist_distance_2d (internal, geometry, integer),
	FUNCTION        1        geometry_gist_consistent_2d (internal, geometry, integer),
	FUNCTION        2        geometry_gist_union_2d (bytea, internal),
	FUNCTION        3        geometry_gist_compress_2d (internal),
	FUNCTION        4        geometry_gist_decompress_2d (internal),
	FUNCTION        5        geometry_gist_penalty_2d (internal, internal, internal),
	FUNCTION        6        geometry_gist_picksplit_2d (internal, internal),
	FUNCTION        7        geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 200
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_gist_consistent_nd(internal,geometry,integer)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_gist_consistent'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_compress_nd(internal)
	RETURNS internal
	AS '$libdir/postgis-3','gserialized_gist_compress'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_penalty_nd(internal,internal,internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_penalty'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_picksplit_nd(internal, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_picksplit'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_union_nd(bytea, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_union'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_same_nd(geometry, geometry, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_same'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_gist_decompress_nd(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_decompress'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION geometry_overlaps_nd(geometry, geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_overlaps'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry &&& geometry -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&&' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &&& (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_overlaps_nd,
	COMMUTATOR = '&&&',
	RESTRICT = gserialized_gist_sel_nd,
	JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 200
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_contains_nd(geometry, geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_contains'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry ~~ geometry -- LastUpdated: 300
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~~' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~~ (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_contains_nd,
	COMMUTATOR = '@@',
	RESTRICT = gserialized_gist_sel_nd,
	JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 300
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_within_nd(geometry, geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_within'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry @@ geometry -- LastUpdated: 300
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@@' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR @@ (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_within_nd,
	COMMUTATOR = '~~',
	RESTRICT = gserialized_gist_sel_nd,
	JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 300
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_same_nd(geometry, geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_same'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Operator geometry ~~= geometry -- LastUpdated: 300
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~~=' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~~= (
	LEFTARG = geometry, RIGHTARG = geometry, PROCEDURE = geometry_same_nd,
	COMMUTATOR = '~~=',
	RESTRICT = gserialized_gist_sel_nd,
	JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 300
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_distance_centroid_nd(geometry,geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_distance_nd'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Operator geometry <<->> geometry -- LastUpdated: 202
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<<->>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <<->> (
	LEFTARG = geometry, RIGHTARG = geometry,
	PROCEDURE = geometry_distance_centroid_nd,
	COMMUTATOR = '<<->>'
);

  END IF; -- version_from >= 202
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_distance_cpa(geometry, geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_DistanceCPA'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Operator geometry |=| geometry -- LastUpdated: 202
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '|=|' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR |=| (
	LEFTARG = geometry, RIGHTARG = geometry,
	PROCEDURE = geometry_distance_cpa,
	COMMUTATOR = '|=|'
);

  END IF; -- version_from >= 202
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_gist_distance_nd(internal,geometry,integer)
	RETURNS float8
	AS '$libdir/postgis-3', 'gserialized_gist_distance'
	LANGUAGE 'c' PARALLEL SAFE
	COST 1;
-- Operator class gist_geometry_ops_nd -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 200 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS gist_geometry_ops_nd
	FOR TYPE geometry USING GIST AS
	STORAGE 	gidx,
	OPERATOR        3        &&&	,
	OPERATOR        6        ~~=	,
	OPERATOR        7        ~~	,
	OPERATOR        8        @@	,
	OPERATOR        13       <<->> FOR ORDER BY pg_catalog.float_ops,
	OPERATOR        20       |=| FOR ORDER BY pg_catalog.float_ops,
	FUNCTION        8        geometry_gist_distance_nd (internal, geometry, integer),
	FUNCTION        1        geometry_gist_consistent_nd (internal, geometry, integer),
	FUNCTION        2        geometry_gist_union_nd (bytea, internal),
	FUNCTION        3        geometry_gist_compress_nd (internal),
	FUNCTION        4        geometry_gist_decompress_nd (internal),
	FUNCTION        5        geometry_gist_penalty_nd (internal, internal, internal),
	FUNCTION        6        geometry_gist_picksplit_nd (internal, internal),
	FUNCTION        7        geometry_gist_same_nd (geometry, geometry, internal);
    $postgis_proc_upgrade_parsed_def$;
  ELSE -- version_from >= 200
    -- Last Updated: 300
    IF 300 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD OPERATOR        6        ~~=	(geometry,geometry) ;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 300
    IF 300 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD OPERATOR        7        ~~	(geometry,geometry) ;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 300
    IF 300 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD OPERATOR        8        @@	(geometry,geometry) ;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 202
    IF 202 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD OPERATOR        13       <<->> (geometry,geometry) FOR ORDER BY pg_catalog.float_ops;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 202
    IF 202 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD OPERATOR        20       |=| (geometry,geometry) FOR ORDER BY pg_catalog.float_ops;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 202
    IF 202 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geometry_ops_nd USING gist
          ADD FUNCTION        8 (geometry,geometry)        geometry_gist_distance_nd (internal, geometry, integer);
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  END IF; -- version_from >= 202
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_ShiftLongitude(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_longitude_shift'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_WrapX(geom geometry, wrap float8, move float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_WrapX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_XMin(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_xmin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_YMin(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_ymin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_ZMin(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_zmin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_XMax(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_xmax'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_YMax(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_ymax'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_ZMax(box3d)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','BOX3D_zmax'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_Expand(box2d,float8)
	RETURNS box2d
	AS '$libdir/postgis-3', 'BOX2D_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_Expand(box box2d, dx float8, dy float8)
	RETURNS box2d
	AS '$libdir/postgis-3', 'BOX2D_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_getbbox(geometry)
	RETURNS box2d
	AS '$libdir/postgis-3','LWGEOM_to_BOX2DF'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_MakeBox2d(geom1 geometry, geom2 geometry)
	RETURNS box2d
	AS '$libdir/postgis-3', 'BOX2D_construct'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_EstimatedExtent(text,text,text,boolean) RETURNS box2d AS
	'$libdir/postgis-3', 'gserialized_estimated_extent'
	LANGUAGE 'c' STABLE STRICT;
CREATE OR REPLACE FUNCTION ST_EstimatedExtent(text,text,text) RETURNS box2d AS
	'$libdir/postgis-3', 'gserialized_estimated_extent'
	LANGUAGE 'c' STABLE STRICT;
CREATE OR REPLACE FUNCTION ST_EstimatedExtent(text,text) RETURNS box2d AS
	'$libdir/postgis-3', 'gserialized_estimated_extent'
	LANGUAGE 'c' STABLE STRICT;
CREATE OR REPLACE FUNCTION ST_FindExtent(text,text,text) RETURNS box2d AS
$$
DECLARE
	schemaname alias for $1;
	tablename alias for $2;
	columnname alias for $3;
	myrec RECORD;
BEGIN
	FOR myrec IN EXECUTE 'SELECT @extschema@.ST_Extent("' || columnname || '") As extent FROM "' || schemaname || '"."' || tablename || '"' LOOP
		return myrec.extent;
	END LOOP;
END;
$$
LANGUAGE 'plpgsql' STABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_FindExtent(text,text) RETURNS box2d AS
$$
DECLARE
	tablename alias for $1;
	columnname alias for $2;
	myrec RECORD;

BEGIN
	FOR myrec IN EXECUTE 'SELECT @extschema@.ST_Extent("' || columnname || '") As extent FROM "' || tablename || '"' LOOP
		return myrec.extent;
	END LOOP;
END;
$$
LANGUAGE 'plpgsql' STABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION postgis_addbbox(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_addBBOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION postgis_dropbbox(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_dropBBOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION postgis_hasbbox(geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'LWGEOM_hasBBOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_QuantizeCoordinates(g geometry, prec_x int, prec_y int DEFAULT NULL, prec_z int DEFAULT NULL, prec_m int DEFAULT NULL)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_QuantizeCoordinates'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MemSize(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_mem_size'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_Summary(geometry)
	RETURNS text
	AS '$libdir/postgis-3', 'LWGEOM_summary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NPoints(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_npoints'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NRings(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_nrings'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_3DLength(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_length_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Length2d(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_length2d_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Length(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_length2d_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LengthSpheroid(geometry, spheroid)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','LWGEOM_length_ellipsoid_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Length2DSpheroid(geometry, spheroid)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','LWGEOM_length2d_ellipsoid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_3DPerimeter(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_perimeter_poly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_perimeter2d(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_perimeter2d_poly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Perimeter(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'LWGEOM_perimeter2d_poly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Area2D(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'ST_Area'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Area(geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','ST_Area'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_IsPolygonCW(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_IsPolygonCW'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_IsPolygonCCW(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_IsPolygonCCW'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_DistanceSpheroid(geom1 geometry, geom2 geometry, spheroid)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','LWGEOM_distance_ellipsoid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_DistanceSpheroid(geom1 geometry, geom2 geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','LWGEOM_distance_ellipsoid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Distance(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_Distance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_PointInsideCircle(geometry,float8,float8,float8)
	RETURNS bool
	AS '$libdir/postgis-3', 'LWGEOM_inside_circle_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_azimuth(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'LWGEOM_azimuth'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Project(geom1 geometry, distance float8, azimuth float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'geometry_project_direction'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Project(geom1 geometry, geom2 geometry, distance float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'geometry_project_geometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Angle(pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry default 'POINT EMPTY'::geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'LWGEOM_angle'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LineExtend(geom geometry, distance_forward float8, distance_backward float8 DEFAULT 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'geometry_line_extend'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Force2D(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Rename st_force3dz ( geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_force3dz(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3dz(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_force3dz(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_force3dz( geometry ) RENAME TO st_force3dz_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3dz(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_force3dz(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Force3DZ(geom geometry, zvalue float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_3dz'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Rename st_force3d ( geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_force3d(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3d(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_force3d(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_force3d( geometry ) RENAME TO st_force3d_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3d(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_force3d(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Force3D(geom geometry, zvalue float8 default 0.0)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Force3DZ($1, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Rename st_force3dm ( geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_force3dm(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3dm(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_force3dm(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_force3dm( geometry ) RENAME TO st_force3dm_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force3dm(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_force3dm(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Force3DM(geom geometry, mvalue float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_3dm'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Rename st_force4d ( geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_force4d(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force4d(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_force4d(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_force4d( geometry ) RENAME TO st_force4d_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_force4d(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_force4d(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Force4D(geom geometry, zvalue float8 default 0.0, mvalue float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_4d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ForceCollection(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_collection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_CollectionExtract(geometry, integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CollectionExtract'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_CollectionExtract(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CollectionExtract'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_CollectionHomogenize(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CollectionHomogenize'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Multi(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_multi'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ForceCurve(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_curve'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_ForceSFS(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_sfs'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_ForceSFS(geometry, version text)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_sfs'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Expand(box3d,float8)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Expand(box box3d, dx float8, dy float8, dz float8 DEFAULT 0)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Expand(geometry,float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Expand(geom geometry, dx float8, dy float8, dz float8 DEFAULT 0, dm float8 DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Envelope(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_envelope'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_BoundingDiagonal(geom geometry, fits boolean DEFAULT false)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_BoundingDiagonal'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_Reverse(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_reverse'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Scroll(geometry, geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Scroll'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION postgis_noop(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_noop'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_geos_noop(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'GEOSnoop'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_Normalize(geom geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Normalize'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_zmflag(geometry)
	RETURNS smallint
	AS '$libdir/postgis-3', 'LWGEOM_zmflag'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_NDims(geometry)
	RETURNS smallint
	AS '$libdir/postgis-3', 'LWGEOM_ndims'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_HasZ(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_hasz'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_HasM(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_hasm'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_AsEWKT(geometry)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asEWKT'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsEWKT(geometry, integer)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asEWKT'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsTWKB(geom geometry, prec integer default NULL, prec_z integer default NULL, prec_m integer default NULL, with_sizes boolean default NULL, with_boxes boolean default NULL)
	RETURNS bytea
	AS '$libdir/postgis-3','TWKBFromLWGEOM'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsTWKB(geom geometry[], ids bigint[], prec integer default NULL, prec_z integer default NULL, prec_m integer default NULL, with_sizes boolean default NULL, with_boxes boolean default NULL)
	RETURNS bytea
	AS '$libdir/postgis-3','TWKBFromLWGEOMArray'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsEWKB(geometry)
	RETURNS BYTEA
	AS '$libdir/postgis-3','WKBFromLWGEOM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsHEXEWKB(geometry)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asHEXEWKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsHEXEWKB(geometry, text)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asHEXEWKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsEWKB(geometry,text)
	RETURNS bytea
	AS '$libdir/postgis-3','WKBFromLWGEOM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsLatLonText(geom geometry, tmpl text DEFAULT '')
	RETURNS text
	AS '$libdir/postgis-3','LWGEOM_to_latlon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION GeomFromEWKB(bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOMFromEWKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomFromEWKB(bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOMFromEWKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomFromTWKB(bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOMFromTWKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION GeomFromEWKT(text)
	RETURNS geometry
	AS '$libdir/postgis-3','parse_WKT_lwgeom'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomFromEWKT(text)
	RETURNS geometry
	AS '$libdir/postgis-3','parse_WKT_lwgeom'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION postgis_cache_bbox()
	RETURNS trigger
	AS '$libdir/postgis-3', 'cache_bbox'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION ST_MakePoint(float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakePoint(float8, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakePoint(float8, float8, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakePointM(float8, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoint3dm'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_3DMakeBox(geom1 geometry, geom2 geometry)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_construct'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakeLine (geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makeline_garray'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LineFromMultiPoint(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_line_from_mpoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakeLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makeline'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AddPoint(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_addpoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AddPoint(geom1 geometry, geom2 geometry, integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_addpoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_RemovePoint(geometry, integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_removepoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SetPoint(geometry, integer, geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_setpoint_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakeEnvelope(float8, float8, float8, float8, integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_MakeEnvelope'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Rename st_tileenvelope ( zoom integer, x integer, y integer, bounds geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_tileenvelope(integer,integer,integer,geometry)'::regprocedure
        INTO argnames;

        -- Check if the deprecated function has the expected 4 argument names
        IF argnames[1:4] != ARRAY['zoom','x','y','bounds']::text[]
        THEN
            RAISE DEBUG
                'Function st_tileenvelope(integer,integer,integer,geometry) exist but has argnames % (not %)',
                argnames, ARRAY['zoom','x','y','bounds'];
            RETURN; -- nothing to do
        END IF;

    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_tileenvelope(integer,integer,integer,geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_tileenvelope(zoom integer, x integer, y integer, bounds geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_tileenvelope( zoom integer, x integer, y integer, bounds geometry ) RENAME TO st_tileenvelope_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_tileenvelope(zoom integer, x integer, y integer, bounds geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_tileenvelope(zoom integer, x integer, y integer, bounds geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_TileEnvelope(zoom integer, x integer, y integer, bounds geometry DEFAULT 'SRID=3857;LINESTRING(-20037508.342789244 -20037508.342789244, 20037508.342789244 20037508.342789244)'::geometry, margin float8 DEFAULT 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_TileEnvelope'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakePolygon(geometry, geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MakePolygon(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_BuildArea(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_BuildArea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Polygonize (geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3', 'polygonize_garray'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClusterIntersecting(geometry[])
	RETURNS geometry[]
	AS '$libdir/postgis-3',  'clusterintersecting_garray'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClusterWithin(geometry[], float8)
	RETURNS geometry[]
	AS '$libdir/postgis-3',  'cluster_within_distance_garray'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClusterDBSCAN (geometry, eps float8, minpoints int)
	RETURNS int
	AS '$libdir/postgis-3', 'ST_ClusterDBSCAN'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClusterWithinWin(geometry, distance float8)
	RETURNS int
	AS '$libdir/postgis-3', 'ST_ClusterWithinWin'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClusterIntersectingWin(geometry)
	RETURNS int
	AS '$libdir/postgis-3', 'ST_ClusterIntersectingWin'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_LineMerge(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'linemerge'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_LineMerge(geometry, boolean)
	RETURNS geometry
	AS '$libdir/postgis-3', 'linemerge'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Affine(geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_affine'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Affine(geometry,float8,float8,float8,float8,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  $2, $3, 0,  $4, $5, 0,  0, 0, 1,  $6, $7, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Rotate(geometry,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  cos($2), -sin($2), 0,  sin($2), cos($2), 0,  0, 0, 1,  0, 0, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Rotate(geometry,float8,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  cos($2), -sin($2), 0,  sin($2),  cos($2), 0, 0, 0, 1,	$3 - cos($2) * $3 + sin($2) * $4, $4 - sin($2) * $3 - cos($2) * $4, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Rotate(geometry,float8,geometry)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  cos($2), -sin($2), 0,  sin($2),  cos($2), 0, 0, 0, 1, @extschema@.ST_X($3) - cos($2) * @extschema@.ST_X($3) + sin($2) * @extschema@.ST_Y($3), @extschema@.ST_Y($3) - sin($2) * @extschema@.ST_X($3) - cos($2) * @extschema@.ST_Y($3), 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_RotateZ(geometry,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Rotate($1, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_RotateX(geometry,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1, 1, 0, 0, 0, cos($2), -sin($2), 0, sin($2), cos($2), 0, 0, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_RotateY(geometry,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  cos($2), 0, sin($2),  0, 1, 0,  -sin($2), 0, cos($2), 0,  0, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Translate(geometry,float8,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1, 1, 0, 0, 0, 1, 0, 0, 0, 1, $2, $3, $4)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Translate(geometry,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Translate($1, $2, $3, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Scale(geometry,geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Scale'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Scale(geometry,geometry,origin geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Scale'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Scale(geometry,float8,float8,float8)
	RETURNS geometry
	--AS 'SELECT ST_Affine($1,  $2, 0, 0,  0, $3, 0,  0, 0, $4,  0, 0, 0)'
	AS 'SELECT @extschema@.ST_Scale($1, @extschema@.ST_MakePoint($2, $3, $4))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Scale(geometry,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Scale($1, $2, $3, 1)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Transscale(geometry,float8,float8,float8,float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_Affine($1,  $4, 0, 0,  0, $5, 0,
		0, 0, 1,  $2 * $4, $3 * $5, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Type geometry_dump -- LastUpdated: 100
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 100 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE geometry_dump AS (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION ST_Dump(geometry)
	RETURNS SETOF geometry_dump
	AS '$libdir/postgis-3', 'LWGEOM_dump'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_DumpRings(geometry)
	RETURNS SETOF geometry_dump
	AS '$libdir/postgis-3', 'LWGEOM_dump_rings'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_DumpPoints(geometry)
	RETURNS SETOF geometry_dump
	AS '$libdir/postgis-3', 'LWGEOM_dumppoints'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_DumpSegments(geometry)
	RETURNS SETOF geometry_dump
	AS '$libdir/postgis-3', 'LWGEOM_dumpsegments'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION populate_geometry_columns(use_typmod boolean DEFAULT true)
	RETURNS text AS
$$
DECLARE
	inserted	integer;
	oldcount	integer;
	probed	  integer;
	stale	   integer;
	gcs		 RECORD;
	gc		  RECORD;
	gsrid	   integer;
	gndims	  integer;
	gtype	   text;
	query	   text;
	gc_is_valid boolean;

BEGIN
	SELECT count(*) INTO oldcount FROM @extschema@.geometry_columns;
	inserted := 0;

	-- Count the number of geometry columns in all tables and views
	SELECT count(DISTINCT c.oid) INTO probed
	FROM pg_class c,
		 pg_attribute a,
		 pg_type t,
		 pg_namespace n
	WHERE c.relkind IN('r','v','f', 'p')
		AND t.typname = 'geometry'
		AND a.attisdropped = false
		AND a.atttypid = t.oid
		AND a.attrelid = c.oid
		AND c.relnamespace = n.oid
		AND n.nspname NOT ILIKE 'pg_temp%' AND c.relname != 'raster_columns' ;

	-- Iterate through all non-dropped geometry columns
	RAISE DEBUG 'Processing Tables.....';

	FOR gcs IN
	SELECT DISTINCT ON (c.oid) c.oid, n.nspname, c.relname
		FROM pg_class c,
			 pg_attribute a,
			 pg_type t,
			 pg_namespace n
		WHERE c.relkind IN( 'r', 'f', 'p')
		AND t.typname = 'geometry'
		AND a.attisdropped = false
		AND a.atttypid = t.oid
		AND a.attrelid = c.oid
		AND c.relnamespace = n.oid
		AND n.nspname NOT ILIKE 'pg_temp%' AND c.relname != 'raster_columns'
	LOOP

		inserted := inserted + @extschema@.populate_geometry_columns(gcs.oid, use_typmod);
	END LOOP;

	IF oldcount > inserted THEN
		stale = oldcount-inserted;
	ELSE
		stale = 0;
	END IF;

	RETURN 'probed:' ||probed|| ' inserted:'||inserted;
END

$$
LANGUAGE 'plpgsql' VOLATILE;
CREATE OR REPLACE FUNCTION populate_geometry_columns(tbl_oid oid, use_typmod boolean DEFAULT true)
	RETURNS integer AS
$$
DECLARE
	gcs		 RECORD;
	gc		  RECORD;
	gc_old	  RECORD;
	gsrid	   integer;
	gndims	  integer;
	gtype	   text;
	query	   text;
	gc_is_valid boolean;
	inserted	integer;
	constraint_successful boolean := false;

BEGIN
	inserted := 0;

	-- Iterate through all geometry columns in this table
	FOR gcs IN
	SELECT n.nspname, c.relname, a.attname, c.relkind
		FROM pg_class c,
			 pg_attribute a,
			 pg_type t,
			 pg_namespace n
		WHERE c.relkind IN('r', 'f', 'p')
		AND t.typname = 'geometry'
		AND a.attisdropped = false
		AND a.atttypid = t.oid
		AND a.attrelid = c.oid
		AND c.relnamespace = n.oid
		AND n.nspname NOT ILIKE 'pg_temp%'
		AND c.oid = tbl_oid
	LOOP

		RAISE DEBUG 'Processing column %.%.%', gcs.nspname, gcs.relname, gcs.attname;

		gc_is_valid := true;
		-- Find the srid, coord_dimension, and type of current geometry
		-- in geometry_columns -- which is now a view

		SELECT type, srid, coord_dimension, gcs.relkind INTO gc_old
			FROM geometry_columns
			WHERE f_table_schema = gcs.nspname AND f_table_name = gcs.relname AND f_geometry_column = gcs.attname;

		IF upper(gc_old.type) = 'GEOMETRY' THEN
		-- This is an unconstrained geometry we need to do something
		-- We need to figure out what to set the type by inspecting the data
			EXECUTE 'SELECT @extschema@.ST_srid(' || quote_ident(gcs.attname) || ') As srid, @extschema@.GeometryType(' || quote_ident(gcs.attname) || ') As type, @extschema@.ST_NDims(' || quote_ident(gcs.attname) || ') As dims ' ||
					 ' FROM ONLY ' || quote_ident(gcs.nspname) || '.' || quote_ident(gcs.relname) ||
					 ' WHERE ' || quote_ident(gcs.attname) || ' IS NOT NULL LIMIT 1;'
				INTO gc;
			IF gc IS NULL THEN -- there is no data so we can not determine geometry type
				RAISE WARNING 'No data in table %.%, so no information to determine geometry type and srid', gcs.nspname, gcs.relname;
				RETURN 0;
			END IF;
			gsrid := gc.srid; gtype := gc.type; gndims := gc.dims;

			IF use_typmod THEN
				BEGIN
					EXECUTE 'ALTER TABLE ' || quote_ident(gcs.nspname) || '.' || quote_ident(gcs.relname) || ' ALTER COLUMN ' || quote_ident(gcs.attname) ||
						' TYPE geometry(' || postgis_type_name(gtype, gndims, true) || ', ' || gsrid::text  || ') ';
					inserted := inserted + 1;
				EXCEPTION
						WHEN invalid_parameter_value OR feature_not_supported THEN
						RAISE WARNING 'Could not convert ''%'' in ''%.%'' to use typmod with srid %, type %: %', quote_ident(gcs.attname), quote_ident(gcs.nspname), quote_ident(gcs.relname), gsrid, postgis_type_name(gtype, gndims, true), SQLERRM;
							gc_is_valid := false;
				END;

			ELSE
				-- Try to apply srid check to column
				constraint_successful = false;
				IF (gsrid > 0 AND postgis_constraint_srid(gcs.nspname, gcs.relname,gcs.attname) IS NULL ) THEN
					BEGIN
						EXECUTE 'ALTER TABLE ONLY ' || quote_ident(gcs.nspname) || '.' || quote_ident(gcs.relname) ||
								 ' ADD CONSTRAINT ' || quote_ident('enforce_srid_' || gcs.attname) ||
								 ' CHECK (ST_srid(' || quote_ident(gcs.attname) || ') = ' || gsrid || ')';
						constraint_successful := true;
					EXCEPTION
						WHEN check_violation THEN
							RAISE WARNING 'Not inserting ''%'' in ''%.%'' into geometry_columns: could not apply constraint CHECK (st_srid(%) = %)', quote_ident(gcs.attname), quote_ident(gcs.nspname), quote_ident(gcs.relname), quote_ident(gcs.attname), gsrid;
							gc_is_valid := false;
					END;
				END IF;

				-- Try to apply ndims check to column
				IF (gndims IS NOT NULL AND postgis_constraint_dims(gcs.nspname, gcs.relname,gcs.attname) IS NULL ) THEN
					BEGIN
						EXECUTE 'ALTER TABLE ONLY ' || quote_ident(gcs.nspname) || '.' || quote_ident(gcs.relname) || '
								 ADD CONSTRAINT ' || quote_ident('enforce_dims_' || gcs.attname) || '
								 CHECK (st_ndims(' || quote_ident(gcs.attname) || ') = '||gndims||')';
						constraint_successful := true;
					EXCEPTION
						WHEN check_violation THEN
							RAISE WARNING 'Not inserting ''%'' in ''%.%'' into geometry_columns: could not apply constraint CHECK (st_ndims(%) = %)', quote_ident(gcs.attname), quote_ident(gcs.nspname), quote_ident(gcs.relname), quote_ident(gcs.attname), gndims;
							gc_is_valid := false;
					END;
				END IF;

				-- Try to apply geometrytype check to column
				IF (gtype IS NOT NULL AND postgis_constraint_type(gcs.nspname, gcs.relname,gcs.attname) IS NULL ) THEN
					BEGIN
						EXECUTE 'ALTER TABLE ONLY ' || quote_ident(gcs.nspname) || '.' || quote_ident(gcs.relname) || '
						ADD CONSTRAINT ' || quote_ident('enforce_geotype_' || gcs.attname) || '
						CHECK (geometrytype(' || quote_ident(gcs.attname) || ') = ' || quote_literal(gtype) || ')';
						constraint_successful := true;
					EXCEPTION
						WHEN check_violation THEN
							-- No geometry check can be applied. This column contains a number of geometry types.
							RAISE WARNING 'Could not add geometry type check (%) to table column: %.%.%', gtype, quote_ident(gcs.nspname),quote_ident(gcs.relname),quote_ident(gcs.attname);
					END;
				END IF;
				 --only count if we were successful in applying at least one constraint
				IF constraint_successful THEN
					inserted := inserted + 1;
				END IF;
			END IF;
		END IF;

	END LOOP;

	RETURN inserted;
END

$$
LANGUAGE 'plpgsql' VOLATILE;
CREATE OR REPLACE FUNCTION AddGeometryColumn(catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean DEFAULT true)
	RETURNS text
	AS
$$
DECLARE
	rec RECORD;
	sr varchar;
	real_schema name;
	sql text;
	new_srid integer;

BEGIN

	-- Verify geometry type
	IF (postgis_type_name(new_type,new_dim) IS NULL )
	THEN
		RAISE EXCEPTION 'Invalid type name "%(%)" - valid ones are:
	POINT, MULTIPOINT,
	LINESTRING, MULTILINESTRING,
	POLYGON, MULTIPOLYGON,
	CIRCULARSTRING, COMPOUNDCURVE, MULTICURVE,
	CURVEPOLYGON, MULTISURFACE,
	GEOMETRY, GEOMETRYCOLLECTION,
	POINTM, MULTIPOINTM,
	LINESTRINGM, MULTILINESTRINGM,
	POLYGONM, MULTIPOLYGONM,
	CIRCULARSTRINGM, COMPOUNDCURVEM, MULTICURVEM
	CURVEPOLYGONM, MULTISURFACEM, TRIANGLE, TRIANGLEM,
	POLYHEDRALSURFACE, POLYHEDRALSURFACEM, TIN, TINM
	or GEOMETRYCOLLECTIONM', new_type, new_dim;
		RETURN 'fail';
	END IF;

	-- Verify dimension
	IF ( (new_dim >4) OR (new_dim <2) ) THEN
		RAISE EXCEPTION 'invalid dimension';
		RETURN 'fail';
	END IF;

	IF ( (new_type LIKE '%M') AND (new_dim!=3) ) THEN
		RAISE EXCEPTION 'TypeM needs 3 dimensions';
		RETURN 'fail';
	END IF;

	-- Verify SRID
	IF ( new_srid_in > 0 ) THEN
		IF new_srid_in > 998999 THEN
			RAISE EXCEPTION 'AddGeometryColumn() - SRID must be <= %', 998999;
		END IF;
		new_srid := new_srid_in;
		SELECT SRID INTO sr FROM @extschema@.spatial_ref_sys WHERE SRID = new_srid;
		IF NOT FOUND THEN
			RAISE EXCEPTION 'AddGeometryColumn() - invalid SRID';
			RETURN 'fail';
		END IF;
	ELSE
		new_srid := @extschema@.ST_SRID('POINT EMPTY'::@extschema@.geometry);
		IF ( new_srid_in != new_srid ) THEN
			RAISE NOTICE 'SRID value % converted to the officially unknown SRID value %', new_srid_in, new_srid;
		END IF;
	END IF;

	-- Verify schema
	IF ( schema_name IS NOT NULL AND schema_name != '' ) THEN
		sql := 'SELECT nspname FROM pg_namespace ' ||
			'WHERE text(nspname) = ' || quote_literal(schema_name) ||
			'LIMIT 1';
		RAISE DEBUG '%', sql;
		EXECUTE sql INTO real_schema;

		IF ( real_schema IS NULL ) THEN
			RAISE EXCEPTION 'Schema % is not a valid schemaname', quote_literal(schema_name);
			RETURN 'fail';
		END IF;
	END IF;

	IF ( real_schema IS NULL ) THEN
		RAISE DEBUG 'Detecting schema';
		sql := 'SELECT n.nspname AS schemaname ' ||
			'FROM pg_catalog.pg_class c ' ||
			  'JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace ' ||
			'WHERE c.relkind = ' || quote_literal('r') ||
			' AND n.nspname NOT IN (' || quote_literal('pg_catalog') || ', ' || quote_literal('pg_toast') || ')' ||
			' AND pg_catalog.pg_table_is_visible(c.oid)' ||
			' AND c.relname = ' || quote_literal(table_name);
		RAISE DEBUG '%', sql;
		EXECUTE sql INTO real_schema;

		IF ( real_schema IS NULL ) THEN
			RAISE EXCEPTION 'Table % does not occur in the search_path', quote_literal(table_name);
			RETURN 'fail';
		END IF;
	END IF;

	-- Add geometry column to table
	IF use_typmod THEN
		 sql := 'ALTER TABLE ' ||
			quote_ident(real_schema) || '.' || quote_ident(table_name)
			|| ' ADD COLUMN ' || quote_ident(column_name) ||
			' geometry(' || @extschema@.postgis_type_name(new_type, new_dim) || ', ' || new_srid::text || ')';
		RAISE DEBUG '%', sql;
	ELSE
		sql := 'ALTER TABLE ' ||
			quote_ident(real_schema) || '.' || quote_ident(table_name)
			|| ' ADD COLUMN ' || quote_ident(column_name) ||
			' geometry ';
		RAISE DEBUG '%', sql;
	END IF;
	EXECUTE sql;

	IF NOT use_typmod THEN
		-- Add table CHECKs
		sql := 'ALTER TABLE ' ||
			quote_ident(real_schema) || '.' || quote_ident(table_name)
			|| ' ADD CONSTRAINT '
			|| quote_ident('enforce_srid_' || column_name)
			|| ' CHECK (st_srid(' || quote_ident(column_name) ||
			') = ' || new_srid::text || ')' ;
		RAISE DEBUG '%', sql;
		EXECUTE sql;

		sql := 'ALTER TABLE ' ||
			quote_ident(real_schema) || '.' || quote_ident(table_name)
			|| ' ADD CONSTRAINT '
			|| quote_ident('enforce_dims_' || column_name)
			|| ' CHECK (st_ndims(' || quote_ident(column_name) ||
			') = ' || new_dim::text || ')' ;
		RAISE DEBUG '%', sql;
		EXECUTE sql;

		IF ( NOT (new_type = 'GEOMETRY')) THEN
			sql := 'ALTER TABLE ' ||
				quote_ident(real_schema) || '.' || quote_ident(table_name) || ' ADD CONSTRAINT ' ||
				quote_ident('enforce_geotype_' || column_name) ||
				' CHECK (GeometryType(' ||
				quote_ident(column_name) || ')=' ||
				quote_literal(new_type) || ' OR (' ||
				quote_ident(column_name) || ') is null)';
			RAISE DEBUG '%', sql;
			EXECUTE sql;
		END IF;
	END IF;

	RETURN
		real_schema || '.' ||
		table_name || '.' || column_name ||
		' SRID:' || new_srid::text ||
		' TYPE:' || new_type ||
		' DIMS:' || new_dim::text || ' ';
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION AddGeometryColumn(schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean DEFAULT true) RETURNS text AS $$
DECLARE
	ret  text;
BEGIN
	SELECT @extschema@.AddGeometryColumn('',$1,$2,$3,$4,$5,$6,$7) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' STABLE STRICT;
CREATE OR REPLACE FUNCTION AddGeometryColumn(table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean DEFAULT true) RETURNS text AS $$
DECLARE
	ret  text;
BEGIN
	SELECT @extschema@.AddGeometryColumn('','',$1,$2,$3,$4,$5, $6) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryColumn(catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar)
	RETURNS text
	AS
$$
DECLARE
	myrec RECORD;
	okay boolean;
	real_schema name;

BEGIN

	-- Find, check or fix schema_name
	IF ( schema_name != '' ) THEN
		okay = false;

		FOR myrec IN SELECT nspname FROM pg_namespace WHERE text(nspname) = schema_name LOOP
			okay := true;
		END LOOP;

		IF ( okay <>  true ) THEN
			RAISE NOTICE 'Invalid schema name - using current_schema()';
			SELECT current_schema() into real_schema;
		ELSE
			real_schema = schema_name;
		END IF;
	ELSE
		SELECT current_schema() into real_schema;
	END IF;

	-- Find out if the column is in the geometry_columns table
	okay = false;
	FOR myrec IN SELECT * from @extschema@.geometry_columns where f_table_schema = text(real_schema) and f_table_name = table_name and f_geometry_column = column_name LOOP
		okay := true;
	END LOOP;
	IF (okay <> true) THEN
		RAISE EXCEPTION 'column not found in geometry_columns table';
		RETURN false;
	END IF;

	-- Remove table column
	EXECUTE 'ALTER TABLE ' || quote_ident(real_schema) || '.' ||
		quote_ident(table_name) || ' DROP COLUMN ' ||
		quote_ident(column_name);

	RETURN real_schema || '.' || table_name || '.' || column_name ||' effectively removed.';

END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryColumn(schema_name varchar, table_name varchar,column_name varchar)
	RETURNS text
	AS
$$
DECLARE
	ret text;
BEGIN
	SELECT @extschema@.DropGeometryColumn('',$1,$2,$3) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryColumn(table_name varchar, column_name varchar)
	RETURNS text
	AS
$$
DECLARE
	ret text;
BEGIN
	SELECT @extschema@.DropGeometryColumn('','',$1,$2) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryTable(catalog_name varchar, schema_name varchar, table_name varchar)
	RETURNS text
	AS
$$
DECLARE
	real_schema name;

BEGIN

	IF ( schema_name = '' ) THEN
		SELECT current_schema() into real_schema;
	ELSE
		real_schema = schema_name;
	END IF;

	-- TODO: Should we warn if table doesn't exist probably instead just saying dropped
	-- Remove table
	EXECUTE 'DROP TABLE IF EXISTS '
		|| quote_ident(real_schema) || '.' ||
		quote_ident(table_name) || ' RESTRICT';

	RETURN
		real_schema || '.' ||
		table_name ||' dropped.';

END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryTable(schema_name varchar, table_name varchar) RETURNS text AS
$$ SELECT @extschema@.DropGeometryTable('',$1,$2) $$
LANGUAGE 'sql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION DropGeometryTable(table_name varchar) RETURNS text AS
$$ SELECT @extschema@.DropGeometryTable('','',$1) $$
LANGUAGE 'sql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION UpdateGeometrySRID(catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer)
	RETURNS text
	AS
$$
DECLARE
	myrec RECORD;
	okay boolean;
	cname varchar;
	real_schema name;
	unknown_srid integer;
	new_srid integer := new_srid_in;

BEGIN

	-- Find, check or fix schema_name
	IF ( schema_name != '' ) THEN
		okay = false;

		FOR myrec IN SELECT nspname FROM pg_namespace WHERE text(nspname) = schema_name LOOP
			okay := true;
		END LOOP;

		IF ( okay <> true ) THEN
			RAISE EXCEPTION 'Invalid schema name';
		ELSE
			real_schema = schema_name;
		END IF;
	ELSE
		SELECT INTO real_schema current_schema()::text;
	END IF;

	-- Ensure that column_name is in geometry_columns
	okay = false;
	FOR myrec IN SELECT type, coord_dimension FROM @extschema@.geometry_columns WHERE f_table_schema = text(real_schema) and f_table_name = table_name and f_geometry_column = column_name LOOP
		okay := true;
	END LOOP;
	IF (NOT okay) THEN
		RAISE EXCEPTION 'column not found in geometry_columns table';
		RETURN false;
	END IF;

	-- Ensure that new_srid is valid
	IF ( new_srid > 0 ) THEN
		IF ( SELECT count(*) = 0 from @extschema@.spatial_ref_sys where srid = new_srid ) THEN
			RAISE EXCEPTION 'invalid SRID: % not found in spatial_ref_sys', new_srid;
			RETURN false;
		END IF;
	ELSE
		unknown_srid := @extschema@.ST_SRID('POINT EMPTY'::@extschema@.geometry);
		IF ( new_srid != unknown_srid ) THEN
			new_srid := unknown_srid;
			RAISE NOTICE 'SRID value % converted to the officially unknown SRID value %', new_srid_in, new_srid;
		END IF;
	END IF;

	IF postgis_constraint_srid(real_schema, table_name, column_name) IS NOT NULL THEN
	-- srid was enforced with constraints before, keep it that way.
		-- Make up constraint name
		cname = 'enforce_srid_'  || column_name;

		-- Drop enforce_srid constraint
		EXECUTE 'ALTER TABLE ' || quote_ident(real_schema) ||
			'.' || quote_ident(table_name) ||
			' DROP constraint ' || quote_ident(cname);

		-- Update geometries SRID
		EXECUTE 'UPDATE ' || quote_ident(real_schema) ||
			'.' || quote_ident(table_name) ||
			' SET ' || quote_ident(column_name) ||
			' = @extschema@.ST_SetSRID(' || quote_ident(column_name) ||
			', ' || new_srid::text || ')';

		-- Reset enforce_srid constraint
		EXECUTE 'ALTER TABLE ' || quote_ident(real_schema) ||
			'.' || quote_ident(table_name) ||
			' ADD constraint ' || quote_ident(cname) ||
			' CHECK (st_srid(' || quote_ident(column_name) ||
			') = ' || new_srid::text || ')';
	ELSE
		-- We will use typmod to enforce if no srid constraints
		-- We are using postgis_type_name to lookup the new name
		-- (in case Paul changes his mind and flips geometry_columns to return old upper case name)
		EXECUTE 'ALTER TABLE ' || quote_ident(real_schema) || '.' || quote_ident(table_name) ||
		' ALTER COLUMN ' || quote_ident(column_name) || ' TYPE  geometry(' || @extschema@.postgis_type_name(myrec.type, myrec.coord_dimension, true) || ', ' || new_srid::text || ') USING @extschema@.ST_SetSRID(' || quote_ident(column_name) || ',' || new_srid::text || ');' ;
	END IF;

	RETURN real_schema || '.' || table_name || '.' || column_name ||' SRID changed to ' || new_srid::text;

END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION UpdateGeometrySRID(varchar,varchar,varchar,integer)
	RETURNS text
	AS $$
DECLARE
	ret  text;
BEGIN
	SELECT @extschema@.UpdateGeometrySRID('',$1,$2,$3,$4) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION UpdateGeometrySRID(varchar,varchar,integer)
	RETURNS text
	AS $$
DECLARE
	ret  text;
BEGIN
	SELECT @extschema@.UpdateGeometrySRID('','',$1,$2,$3) into ret;
	RETURN ret;
END;
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
CREATE OR REPLACE FUNCTION find_srid(varchar,varchar,varchar) RETURNS integer AS
$$
DECLARE
	schem varchar =  $1;
	tabl varchar = $2;
	sr int4;
BEGIN
-- if the table contains a . and the schema is empty
-- split the table into a schema and a table
-- otherwise drop through to default behavior
	IF ( schem = '' and strpos(tabl,'.') > 0 ) THEN
	 schem = substr(tabl,1,strpos(tabl,'.')-1);
	 tabl = substr(tabl,length(schem)+2);
	END IF;

	select SRID into sr from @extschema@.geometry_columns where (f_table_schema = schem or schem = '') and f_table_name = tabl and f_geometry_column = $3;
	IF NOT FOUND THEN
	   RAISE EXCEPTION 'find_srid() - could not find the corresponding SRID - is the geometry registered in the GEOMETRY_COLUMNS table?  Is there an uppercase/lowercase mismatch?';
	END IF;
	return sr;
END;
$$
LANGUAGE 'plpgsql' STABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION get_proj4_from_srid(integer) RETURNS text AS
	$$
	BEGIN
	RETURN proj4text::text FROM @extschema@.spatial_ref_sys WHERE srid= $1;
	END;
	$$
	LANGUAGE 'plpgsql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_SetSRID(geom geometry, srid integer)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_set_srid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_SRID(geom geometry)
	RETURNS integer
	AS '$libdir/postgis-3','LWGEOM_get_srid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_transform_geometry(geom geometry, text, text, int)
	RETURNS geometry
	AS '$libdir/postgis-3','transform_geom'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION postgis_srs_codes(auth_name text)
	RETURNS SETOF TEXT
	AS '$libdir/postgis-3', 'postgis_srs_codes'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION postgis_srs(auth_name text, auth_srid text)
	RETURNS TABLE(
		auth_name TEXT,
		auth_srid TEXT,
		srname TEXT,
		srtext TEXT,
		proj4text TEXT,
		point_sw GEOMETRY,
		point_ne GEOMETRY
		)
	AS '$libdir/postgis-3', 'postgis_srs_entry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION postgis_srs_all()
	RETURNS TABLE(
		auth_name TEXT,
		auth_srid TEXT,
		srname TEXT,
		srtext TEXT,
		proj4text TEXT,
		point_sw GEOMETRY,
		point_ne GEOMETRY
		)
	AS '$libdir/postgis-3', 'postgis_srs_entry_all'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION postgis_srs_search(
		bounds geometry,
		authname text DEFAULT 'EPSG')
	RETURNS TABLE(
		auth_name TEXT,
		auth_srid TEXT,
		srname TEXT,
		srtext TEXT,
		proj4text TEXT,
		point_sw GEOMETRY,
		point_ne GEOMETRY
		)
	AS '$libdir/postgis-3', 'postgis_srs_search'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Transform(geometry,integer)
	RETURNS geometry
	AS '$libdir/postgis-3','transform'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Transform(geom geometry, to_proj text)
	RETURNS geometry AS
	'SELECT @extschema@.postgis_transform_geometry($1, proj4text, $2, 0)
	FROM @extschema@.spatial_ref_sys WHERE srid=@extschema@.ST_SRID($1);'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Transform(geom geometry, from_proj text, to_proj text)
	RETURNS geometry AS
	'SELECT @extschema@.postgis_transform_geometry($1, $2, $3, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Transform(geom geometry, from_proj text, to_srid integer)
	RETURNS geometry AS
	'SELECT @extschema@.postgis_transform_geometry($1, $2, proj4text, $3)
	FROM @extschema@.spatial_ref_sys WHERE srid=$3;'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION postgis_transform_pipeline_geometry(geom geometry, pipeline text, forward boolean, to_srid integer)
	RETURNS geometry
	AS '$libdir/postgis-3','transform_pipeline_geom'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_TransformPipeline(geom geometry, pipeline text, to_srid integer DEFAULT 0)
	RETURNS geometry AS
	'SELECT @extschema@.postgis_transform_pipeline_geometry($1, $2, TRUE, $3)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_InverseTransformPipeline(geom geometry, pipeline text, to_srid integer DEFAULT 0)
	RETURNS geometry AS
	'SELECT @extschema@.postgis_transform_pipeline_geometry($1, $2, FALSE, $3)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION postgis_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_liblwgeom_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_proj_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_proj_compiled_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_wagyu_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE
	COST 1;
CREATE OR REPLACE FUNCTION postgis_scripts_installed() RETURNS text
	AS $$ SELECT trim('3.6.2'::text || $rev$ 08d9b9f $rev$) AS version $$
	LANGUAGE 'sql' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_lib_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE; -- a new lib will require a new session
CREATE OR REPLACE FUNCTION postgis_scripts_released() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_geos_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_geos_compiled_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_lib_revision() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_svn_version()
RETURNS text AS $$
	SELECT @extschema@._postgis_deprecate(
		'postgis_svn_version', 'postgis_lib_revision', '3.1.0');
	SELECT @extschema@.postgis_lib_revision();
$$
LANGUAGE 'sql' IMMUTABLE SECURITY INVOKER;
CREATE OR REPLACE FUNCTION postgis_libxml_version() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_scripts_build_date() RETURNS text
	AS 'SELECT ''2026-02-27 00:51:45''::text AS version'
	LANGUAGE 'sql' IMMUTABLE;
CREATE OR REPLACE FUNCTION postgis_lib_build_date() RETURNS text
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE;
CREATE OR REPLACE FUNCTION _postgis_scripts_pgsql_version() RETURNS text
	AS 'SELECT ''180''::text AS version'
	LANGUAGE 'sql' IMMUTABLE;
CREATE OR REPLACE FUNCTION _postgis_pgsql_version() RETURNS text
AS $$
	SELECT CASE WHEN pg_catalog.split_part(s,'.',1)::integer > 9 THEN pg_catalog.split_part(s,'.',1) || '0'
	ELSE pg_catalog.split_part(s,'.', 1) || pg_catalog.split_part(s,'.', 2) END AS v
	FROM pg_catalog.substring(version(), E'PostgreSQL ([0-9\\.]+)') AS s;
$$ LANGUAGE 'sql' STABLE;
-- Rename postgis_extensions_upgrade (  ) deprecated in PostGIS 304, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'postgis_extensions_upgrade()'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function postgis_extensions_upgrade() does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function postgis_extensions_upgrade() exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION postgis_extensions_upgrade(  ) RENAME TO postgis_extensions_upgrade_deprecated_by_postgis_304;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function postgis_extensions_upgrade() does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function postgis_extensions_upgrade() got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION postgis_extensions_upgrade(target_version text DEFAULT NULL) RETURNS text
AS $BODY$
DECLARE
	rec record;
	sql text;
	var_schema text;
BEGIN

	FOR rec IN
		SELECT name, default_version, installed_version
		FROM pg_catalog.pg_available_extensions
		WHERE name IN (
			'postgis',
			'postgis_raster',
			'postgis_sfcgal',
			'postgis_topology',
			'postgis_tiger_geocoder'
		)
		ORDER BY length(name) -- this is to make sure 'postgis' is first !
	LOOP --{

		IF target_version IS NULL THEN
			target_version := rec.default_version;
		END IF;

		IF rec.installed_version IS NULL THEN --{
			-- If the support installed by available extension
			-- is found unpackaged, we package it
			IF --{
				 -- PostGIS is always available (this function is part of it)
				 rec.name = 'postgis'

				 -- PostGIS raster is available if type 'raster' exists
				 OR ( rec.name = 'postgis_raster' AND EXISTS (
							SELECT 1 FROM pg_catalog.pg_type
							WHERE typname = 'raster' ) )

				 -- PostGIS SFCGAL is available if
				 -- 'postgis_sfcgal_version' function exists
				 OR ( rec.name = 'postgis_sfcgal' AND EXISTS (
							SELECT 1 FROM pg_catalog.pg_proc
							WHERE proname = 'postgis_sfcgal_version' ) )

				 -- PostGIS Topology is available if
				 -- 'topology.topology' table exists
				 -- NOTE: watch out for https://trac.osgeo.org/postgis/ticket/2503
				 OR ( rec.name = 'postgis_topology' AND EXISTS (
							SELECT 1 FROM pg_catalog.pg_class c
							JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid )
							WHERE n.nspname = 'topology' AND c.relname = 'topology') )

				 OR ( rec.name = 'postgis_tiger_geocoder' AND EXISTS (
							SELECT 1 FROM pg_catalog.pg_class c
							JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid )
							WHERE n.nspname = 'tiger' AND c.relname = 'geocode_settings') )
			THEN --}{ -- the code is unpackaged
				-- Force install in same schema as postgis
				SELECT INTO var_schema n.nspname
				  FROM pg_namespace n, pg_proc p
				  WHERE p.proname = 'postgis_full_version'
					AND n.oid = p.pronamespace
				  LIMIT 1;
				IF rec.name NOT IN('postgis_topology', 'postgis_tiger_geocoder')
				THEN
					sql := format(
							  'CREATE EXTENSION %1$I SCHEMA %2$I VERSION unpackaged;'
							  'ALTER EXTENSION %1$I UPDATE TO %3$I',
							  rec.name, var_schema, target_version);
				ELSE
					sql := format(
							 'CREATE EXTENSION %1$I VERSION unpackaged;'
							 'ALTER EXTENSION %1$I UPDATE TO %2$I',
							 rec.name, target_version);
				END IF;
				RAISE NOTICE 'Packaging and updating %', rec.name;
				RAISE DEBUG '%', sql;
				EXECUTE sql;
			ELSE
				RAISE DEBUG 'Skipping % (not in use)', rec.name;
			END IF; --}
		ELSE -- The code is already packaged, upgrade it --}{
			sql = format(
				'ALTER EXTENSION %1$I UPDATE TO "ANY";'
				'ALTER EXTENSION %1$I UPDATE TO %2$I',
				rec.name, target_version
				);
			RAISE NOTICE 'Updating extension % %', rec.name, rec.installed_version;
			RAISE DEBUG '%', sql;
			EXECUTE sql;
		END IF; --}

	END LOOP; --}

	RETURN format(
		'Upgrade to version %s completed, run SELECT postgis_full_version(); for details',
		target_version
	);


END
$BODY$ LANGUAGE plpgsql VOLATILE;
CREATE OR REPLACE FUNCTION postgis_full_version() RETURNS text
AS $$
DECLARE
	libver text;
	librev text;
	projver text;
	projver_compiled text;
	geosver text;
	geosver_compiled text;
	sfcgalver text;
	gdalver text := NULL;
	libxmlver text;
	liblwgeomver text;
	dbproc text;
	relproc text;
	fullver text;
	rast_lib_ver text := NULL;
	rast_scr_ver text := NULL;
	topo_scr_ver text := NULL;
	json_lib_ver text;
	protobuf_lib_ver text;
	wagyu_lib_ver text;
	sfcgal_lib_ver text;
	sfcgal_scr_ver text;
	pgsql_scr_ver text;
	pgsql_ver text;
	core_is_extension bool;
BEGIN
	SELECT @extschema@.postgis_lib_version() INTO libver;
	SELECT @extschema@.postgis_proj_version() INTO projver;
	SELECT @extschema@.postgis_geos_version() INTO geosver;
	SELECT @extschema@.postgis_geos_compiled_version() INTO geosver_compiled;
	SELECT @extschema@.postgis_proj_compiled_version() INTO projver_compiled;
	SELECT @extschema@.postgis_libjson_version() INTO json_lib_ver;
	SELECT @extschema@.postgis_libprotobuf_version() INTO protobuf_lib_ver;
	SELECT @extschema@.postgis_wagyu_version() INTO wagyu_lib_ver;
	SELECT @extschema@._postgis_scripts_pgsql_version() INTO pgsql_scr_ver;
	SELECT @extschema@._postgis_pgsql_version() INTO pgsql_ver;
	BEGIN
		SELECT @extschema@.postgis_gdal_version() INTO gdalver;
	EXCEPTION
		WHEN undefined_function THEN
			RAISE DEBUG 'Function postgis_gdal_version() not found.  Is raster support enabled and rtpostgis.sql installed?';
	END;
	BEGIN
		SELECT @extschema@.postgis_sfcgal_full_version() INTO sfcgalver;
		BEGIN
			SELECT @extschema@.postgis_sfcgal_scripts_installed() INTO sfcgal_scr_ver;
		EXCEPTION
			WHEN undefined_function THEN
				sfcgal_scr_ver := 'missing';
		END;
	EXCEPTION
		WHEN undefined_function THEN
			RAISE DEBUG 'Function postgis_sfcgal_scripts_installed() not found. Is sfcgal support enabled and sfcgal.sql installed?';
	END;
	SELECT @extschema@.postgis_liblwgeom_version() INTO liblwgeomver;
	SELECT @extschema@.postgis_libxml_version() INTO libxmlver;
	SELECT @extschema@.postgis_scripts_installed() INTO dbproc;
	SELECT @extschema@.postgis_scripts_released() INTO relproc;
	SELECT @extschema@.postgis_lib_revision() INTO librev;
	BEGIN
		SELECT topology.postgis_topology_scripts_installed() INTO topo_scr_ver;
	EXCEPTION
		WHEN undefined_function OR invalid_schema_name THEN
			RAISE DEBUG 'Function postgis_topology_scripts_installed() not found. Is topology support enabled and topology.sql installed?';
		WHEN insufficient_privilege THEN
			RAISE NOTICE 'Topology support cannot be inspected. Is current user granted USAGE on schema "topology" ?';
		WHEN OTHERS THEN
			RAISE NOTICE 'Function postgis_topology_scripts_installed() could not be called: % (%)', SQLERRM, SQLSTATE;
	END;

	BEGIN
		SELECT postgis_raster_scripts_installed() INTO rast_scr_ver;
	EXCEPTION
		WHEN undefined_function THEN
			RAISE DEBUG 'Function postgis_raster_scripts_installed() not found. Is raster support enabled and rtpostgis.sql installed?';
		WHEN OTHERS THEN
			RAISE NOTICE 'Function postgis_raster_scripts_installed() could not be called: % (%)', SQLERRM, SQLSTATE;
	END;

	BEGIN
		SELECT @extschema@.postgis_raster_lib_version() INTO rast_lib_ver;
	EXCEPTION
		WHEN undefined_function THEN
			RAISE DEBUG 'Function postgis_raster_lib_version() not found. Is raster support enabled and rtpostgis.sql installed?';
		WHEN OTHERS THEN
			RAISE NOTICE 'Function postgis_raster_lib_version() could not be called: % (%)', SQLERRM, SQLSTATE;
	END;

	fullver = 'POSTGIS="' || libver;

	IF  librev IS NOT NULL THEN
		fullver = fullver || ' ' || librev;
	END IF;

	fullver = fullver || '"';

	IF EXISTS (
		SELECT * FROM pg_catalog.pg_extension
		WHERE extname = 'postgis')
	THEN
			fullver = fullver || ' [EXTENSION]';
			core_is_extension := true;
	ELSE
			core_is_extension := false;
	END IF;

	IF liblwgeomver != relproc THEN
		fullver = fullver || ' (liblwgeom version mismatch: "' || liblwgeomver || '")';
	END IF;

	fullver = fullver || ' PGSQL="' || pgsql_scr_ver || '"';
	IF pgsql_scr_ver != pgsql_ver THEN
		fullver = fullver || ' (procs need upgrade for use with PostgreSQL "' || pgsql_ver || '")';
	END IF;

	IF  geosver IS NOT NULL THEN
		fullver = fullver || ' GEOS="' || geosver || '"';
		IF (string_to_array(geosver, '.'))[1:2] != (string_to_array(geosver_compiled, '.'))[1:2]
		THEN
			fullver = format('%s (compiled against GEOS %s)', fullver, geosver_compiled);
		END IF;
	END IF;

	IF  sfcgalver IS NOT NULL THEN
		fullver = fullver || ' SFCGAL="' || sfcgalver || '"';
	END IF;

	IF  projver IS NOT NULL THEN
		fullver = fullver || ' PROJ="' || projver || '"';
		IF (string_to_array(projver, '.'))[1:3] != (string_to_array(projver_compiled, '.'))[1:3]
		THEN
			fullver = format('%s (compiled against PROJ %s)', fullver, projver_compiled);
		END IF;
	END IF;

	IF  gdalver IS NOT NULL THEN
		fullver = fullver || ' GDAL="' || gdalver || '"';
	END IF;

	IF  libxmlver IS NOT NULL THEN
		fullver = fullver || ' LIBXML="' || libxmlver || '"';
	END IF;

	IF json_lib_ver IS NOT NULL THEN
		fullver = fullver || ' LIBJSON="' || json_lib_ver || '"';
	END IF;

	IF protobuf_lib_ver IS NOT NULL THEN
		fullver = fullver || ' LIBPROTOBUF="' || protobuf_lib_ver || '"';
	END IF;

	IF wagyu_lib_ver IS NOT NULL THEN
		fullver = fullver || ' WAGYU="' || wagyu_lib_ver || '"';
	END IF;

	IF dbproc != relproc THEN
		fullver = fullver || ' (core procs from "' || dbproc || '" need upgrade)';
	END IF;

	IF topo_scr_ver IS NOT NULL THEN
		fullver = fullver || ' TOPOLOGY';
		IF topo_scr_ver != relproc THEN
			fullver = fullver || ' (topology procs from "' || topo_scr_ver || '" need upgrade)';
		END IF;
		IF core_is_extension AND NOT EXISTS (
			SELECT * FROM pg_catalog.pg_extension
			WHERE extname = 'postgis_topology')
		THEN
				fullver = fullver || ' [UNPACKAGED!]';
		END IF;
	END IF;

	IF rast_lib_ver IS NOT NULL THEN
		fullver = fullver || ' RASTER';
		IF rast_lib_ver != relproc THEN
			fullver = fullver || ' (raster lib from "' || rast_lib_ver || '" need upgrade)';
		END IF;
		IF core_is_extension AND NOT EXISTS (
			SELECT * FROM pg_catalog.pg_extension
			WHERE extname = 'postgis_raster')
		THEN
				fullver = fullver || ' [UNPACKAGED!]';
		END IF;
	END IF;

	IF rast_scr_ver IS NOT NULL AND rast_scr_ver != relproc THEN
		fullver = fullver || ' (raster procs from "' || rast_scr_ver || '" need upgrade)';
	END IF;

	IF sfcgal_scr_ver IS NOT NULL AND sfcgal_scr_ver != relproc THEN
		fullver = fullver || ' (sfcgal procs from "' || sfcgal_scr_ver || '" need upgrade)';
	END IF;

	-- Check for the presence of deprecated functions
	IF EXISTS ( SELECT oid FROM pg_catalog.pg_proc WHERE proname LIKE '%_deprecated_by_postgis_%' )
	THEN
		fullver = fullver || ' (deprecated functions exist, upgrade is not complete)';
	END IF;

	RETURN fullver;
END
$$
LANGUAGE 'plpgsql' IMMUTABLE;
CREATE OR REPLACE FUNCTION box2d(geometry)
	RETURNS box2d
	AS '$libdir/postgis-3','LWGEOM_to_BOX2D'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box3d(geometry)
	RETURNS box3d
	AS '$libdir/postgis-3','LWGEOM_to_BOX3D'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box(geometry)
	RETURNS box
	AS '$libdir/postgis-3','LWGEOM_to_BOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box2d(box3d)
	RETURNS box2d
	AS '$libdir/postgis-3','BOX3D_to_BOX2D'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box3d(box2d)
	RETURNS box3d
	AS '$libdir/postgis-3','BOX2D_to_BOX3D'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box(box3d)
	RETURNS box
	AS '$libdir/postgis-3','BOX3D_to_BOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION text(geometry)
	RETURNS text
	AS '$libdir/postgis-3','LWGEOM_to_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION box3dtobox(box3d)
	RETURNS box
	AS '$libdir/postgis-3','BOX3D_to_BOX'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION geometry(box2d)
	RETURNS geometry
	AS '$libdir/postgis-3','BOX2D_to_LWGEOM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION geometry(box3d)
	RETURNS geometry
	AS '$libdir/postgis-3','BOX3D_to_LWGEOM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION geometry(text)
	RETURNS geometry
	AS '$libdir/postgis-3','parse_WKT_lwgeom'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION geometry(bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_bytea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION bytea(geometry)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_to_bytea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS box2d)');
DROP CAST IF EXISTS (geometry AS box2d);
CREATE CAST (geometry AS box2d) WITH FUNCTION box2d(geometry) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS box3d)');
DROP CAST IF EXISTS (geometry AS box3d);
CREATE CAST (geometry AS box3d) WITH FUNCTION box3d(geometry) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS box)');
DROP CAST IF EXISTS (geometry AS box);
CREATE CAST (geometry AS box) WITH FUNCTION box(geometry) AS ASSIGNMENT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (box3d AS box2d)');
DROP CAST IF EXISTS (box3d AS box2d);
CREATE CAST (box3d AS box2d) WITH FUNCTION box2d(box3d) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (box2d AS box3d)');
DROP CAST IF EXISTS (box2d AS box3d);
CREATE CAST (box2d AS box3d) WITH FUNCTION box3d(box2d) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (box2d AS geometry)');
DROP CAST IF EXISTS (box2d AS geometry);
CREATE CAST (box2d AS geometry) WITH FUNCTION geometry(box2d) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (box3d AS box)');
DROP CAST IF EXISTS (box3d AS box);
CREATE CAST (box3d AS box) WITH FUNCTION box(box3d) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (box3d AS geometry)');
DROP CAST IF EXISTS (box3d AS geometry);
CREATE CAST (box3d AS geometry) WITH FUNCTION geometry(box3d) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (text AS geometry)');
DROP CAST IF EXISTS (text AS geometry);
CREATE CAST (text AS geometry) WITH FUNCTION geometry(text) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS text)');
DROP CAST IF EXISTS (geometry AS text);
CREATE CAST (geometry AS text) WITH FUNCTION text(geometry) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (bytea AS geometry)');
DROP CAST IF EXISTS (bytea AS geometry);
CREATE CAST (bytea AS geometry) WITH FUNCTION geometry(bytea) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS bytea)');
DROP CAST IF EXISTS (geometry AS bytea);
CREATE CAST (geometry AS bytea) WITH FUNCTION bytea(geometry) AS IMPLICIT;
CREATE OR REPLACE FUNCTION ST_Simplify(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_simplify2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Simplify(geometry, float8, boolean)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_simplify2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SimplifyVW(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_SetEffectiveArea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_SetEffectiveArea(geometry,  float8 default -1, integer default 1)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_SetEffectiveArea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_FilterByM(geometry, double precision, double precision default null, boolean default false)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_FilterByM'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ChaikinSmoothing(geometry, integer default 1, boolean default false)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_ChaikinSmoothing'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_SnapToGrid(geometry, float8, float8, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_snaptogrid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SnapToGrid(geometry, float8, float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_SnapToGrid($1, 0, 0, $2, $3)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SnapToGrid(geometry, float8)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_SnapToGrid($1, 0, 0, $2, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SnapToGrid(geom1 geometry, geom2 geometry, float8, float8, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_snaptogrid_pointoff'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Segmentize(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_segmentize2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoint(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_line_interpolate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoints(geometry, float8, repeat boolean DEFAULT true)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_line_interpolate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineSubstring(geometry, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_line_substring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineLocatePoint(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'LWGEOM_line_locate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AddMeasure(geometry, float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_AddMeasure'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_ClosestPointOfApproach(geometry, geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_ClosestPointOfApproach'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_DistanceCPA(geometry, geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_DistanceCPA'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CPAWithin(geometry, geometry, float8)
	RETURNS bool
	AS '$libdir/postgis-3', 'ST_CPAWithin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsValidTrajectory(geometry)
	RETURNS bool
	AS '$libdir/postgis-3', 'ST_IsValidTrajectory'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Rename st_intersection ( geometry, geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_intersection(geometry, geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_intersection(geometry, geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_intersection(geometry, geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_intersection( geometry, geometry ) RENAME TO st_intersection_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_intersection(geometry, geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_intersection(geometry, geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Intersection(geom1 geometry, geom2 geometry, gridSize float8 DEFAULT -1)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_Intersection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Rename st_buffer ( geometry, float8 ) deprecated in PostGIS 300, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_buffer(geometry, float8)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_buffer(geometry, float8) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_buffer(geometry, float8) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_buffer( geometry, float8 ) RENAME TO st_buffer_deprecated_by_postgis_300;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_buffer(geometry, float8) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_buffer(geometry, float8) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Buffer(geom geometry, radius float8, options text DEFAULT '')
	RETURNS geometry
	AS '$libdir/postgis-3','buffer'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Buffer(geom geometry, radius float8, quadsegs integer)
	RETURNS geometry
	AS $$ SELECT @extschema@.ST_Buffer($1, $2, CAST('quad_segs='||CAST($3 AS text) as text)) $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MinimumBoundingRadius(geometry, OUT center geometry, OUT radius double precision)
	AS '$libdir/postgis-3', 'ST_MinimumBoundingRadius'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MinimumBoundingCircle(inputgeom geometry, segs_per_quarter integer DEFAULT 48)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_MinimumBoundingCircle'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_OrientedEnvelope(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_OrientedEnvelope'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_OffsetCurve(line geometry, distance float8, params text DEFAULT '')
RETURNS geometry
	AS '$libdir/postgis-3','ST_OffsetCurve'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_GeneratePoints(area geometry, npoints integer)
RETURNS geometry
	AS '$libdir/postgis-3','ST_GeneratePoints'
	LANGUAGE 'c' VOLATILE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeneratePoints(area geometry, npoints integer, seed integer)
RETURNS geometry
	AS '$libdir/postgis-3','ST_GeneratePoints'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_ConvexHull(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','convexhull'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_SimplifyPreserveTopology(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3','topologypreservesimplify'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsValidReason(geometry)
	RETURNS text
	AS '$libdir/postgis-3', 'isvalidreason'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Type valid_detail -- LastUpdated: 200
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 200 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE valid_detail AS (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION ST_IsValidDetail(geom geometry, flags integer DEFAULT 0)
	RETURNS valid_detail
	AS '$libdir/postgis-3', 'isvaliddetail'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsValidReason(geometry, integer)
	RETURNS text
	AS $$
	SELECT CASE WHEN valid THEN 'Valid Geometry' ELSE reason END FROM (
		SELECT (@extschema@.ST_isValidDetail($1, $2)).*
	) foo
	$$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsValid(geometry, integer)
	RETURNS boolean
	AS 'SELECT (@extschema@.ST_isValidDetail($1, $2)).valid'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_HausdorffDistance(geom1 geometry, geom2 geometry)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'hausdorffdistance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_HausdorffDistance(geom1 geometry, geom2 geometry, float8)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'hausdorffdistancedensify'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_FrechetDistance(geom1 geometry, geom2 geometry, float8 default -1)
	RETURNS FLOAT8
	AS '$libdir/postgis-3', 'ST_FrechetDistance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MaximumInscribedCircle(geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision)
	AS '$libdir/postgis-3', 'ST_MaximumInscribedCircle'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_LargestEmptyCircle(geom geometry, tolerance float8 DEFAULT 0.0, boundary geometry DEFAULT 'POINT EMPTY'::geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision)
	AS '$libdir/postgis-3', 'ST_LargestEmptyCircle'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Rename st_difference ( geometry, geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_difference(geometry, geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_difference(geometry, geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_difference(geometry, geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_difference( geometry, geometry ) RENAME TO st_difference_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_difference(geometry, geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_difference(geometry, geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Difference(geom1 geometry, geom2 geometry, gridSize float8 DEFAULT -1.0)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_Difference'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Boundary(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','boundary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Points(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Points'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
-- Rename st_symdifference ( geometry, geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_symdifference(geometry, geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_symdifference(geometry, geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_symdifference(geometry, geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_symdifference( geometry, geometry ) RENAME TO st_symdifference_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_symdifference(geometry, geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_symdifference(geometry, geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_SymDifference(geom1 geometry, geom2 geometry, gridSize float8 DEFAULT -1.0)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_SymDifference'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_SymmetricDifference(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_SymDifference(geom1, geom2, -1.0);'
	LANGUAGE 'sql';
CREATE OR REPLACE FUNCTION ST_Union(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_Union'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Union(geom1 geometry, geom2 geometry, gridSize float8)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_Union'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Rename st_unaryunion ( geometry ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_unaryunion(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_unaryunion(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_unaryunion(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_unaryunion( geometry ) RENAME TO st_unaryunion_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_unaryunion(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_unaryunion(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_UnaryUnion(geometry, gridSize float8 DEFAULT -1.0)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_UnaryUnion'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_RemoveRepeatedPoints(geom geometry, tolerance float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_RemoveRepeatedPoints'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ClipByBox2d(geom geometry, box box2d)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_ClipByBox2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
-- Rename st_subdivide ( geometry, integer ) deprecated in PostGIS 301, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_subdivide(geometry, integer)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_subdivide(geometry, integer) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_subdivide(geometry, integer) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_subdivide( geometry, integer ) RENAME TO st_subdivide_deprecated_by_postgis_301;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_subdivide(geometry, integer) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_subdivide(geometry, integer) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Subdivide(geom geometry, maxvertices integer DEFAULT 256, gridSize float8 DEFAULT -1.0)
	RETURNS setof geometry
	AS '$libdir/postgis-3', 'ST_Subdivide'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ReducePrecision(geom geometry, gridsize float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_ReducePrecision'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MakeValid(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_MakeValid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MakeValid(geom geometry, params text)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_MakeValid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CleanGeometry(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CleanGeometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Split(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Split'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_SharedPaths(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_SharedPaths'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Snap(geom1 geometry, geom2 geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Snap'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_RelateMatch(text, text)
	RETURNS bool
	AS '$libdir/postgis-3', 'ST_RelateMatch'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Node(g geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Node'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_DelaunayTriangles(g1 geometry, tolerance float8 DEFAULT 0.0, flags integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_DelaunayTriangles'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_TriangulatePolygon(g1 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_TriangulatePolygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Voronoi(g1 geometry, clip geometry DEFAULT NULL, tolerance float8 DEFAULT 0.0, return_polygons boolean DEFAULT true)
	   RETURNS geometry
	   AS '$libdir/postgis-3', 'ST_Voronoi'
	   LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	   COST 5000;
CREATE OR REPLACE FUNCTION ST_VoronoiPolygons(g1 geometry, tolerance float8 DEFAULT 0.0, extend_to geometry DEFAULT NULL)
	   RETURNS geometry
	   AS $$ SELECT @extschema@._ST_Voronoi(g1, extend_to, tolerance, true) $$
	   LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_VoronoiLines(g1 geometry, tolerance float8 DEFAULT 0.0, extend_to geometry DEFAULT NULL)
	   RETURNS geometry
	   AS $$ SELECT @extschema@._ST_Voronoi(g1, extend_to, tolerance, false) $$
	   LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_CombineBBox(box3d,geometry)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_combine'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_CombineBBox(box3d,box3d)
	RETURNS box3d
	AS '$libdir/postgis-3', 'BOX3D_combine_BOX3D'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_CombineBbox(box2d,geometry)
	RETURNS box2d
	AS '$libdir/postgis-3', 'BOX2D_combine'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 1;
-- Aggregate ST_Extent(geometry) -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_Extent(geometry) (
	sfunc = ST_CombineBBox,
	stype = box3d,
	combinefunc = ST_CombineBBox,
	parallel = safe,
	finalfunc = box2d
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 203 > version_from_num OR (
      203 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_Extent(geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_Extent(geometry) (
	sfunc = ST_CombineBBox,
	stype = box3d,
	combinefunc = ST_CombineBBox,
	parallel = safe,
	finalfunc = box2d
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_3DExtent(geometry) -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_3DExtent(geometry)(
	sfunc = ST_CombineBBox,
	combinefunc = ST_CombineBBox,
	parallel = safe,
	stype = box3d
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 203 > version_from_num OR (
      203 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_3DExtent(geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_3DExtent(geometry)(
	sfunc = ST_CombineBBox,
	combinefunc = ST_CombineBBox,
	parallel = safe,
	stype = box3d
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Collect(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_collect'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
-- Aggregate ST_MemCollect(geometry) -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_MemCollect(geometry)(
	sfunc = ST_collect,
	combinefunc = ST_collect,
	parallel = safe,
	stype = geometry
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 203 > version_from_num OR (
      203 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_MemCollect(geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_MemCollect(geometry)(
	sfunc = ST_collect,
	combinefunc = ST_collect,
	parallel = safe,
	stype = geometry
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Collect(geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_collect_garray'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
-- Aggregate ST_MemUnion(geometry) -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_MemUnion(geometry) (
	sfunc = ST_Union,
	combinefunc = ST_Union,
	parallel = safe,
	stype = geometry
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 203 > version_from_num OR (
      203 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_MemUnion(geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_MemUnion(geometry) (
	sfunc = ST_Union,
	combinefunc = ST_Union,
	parallel = safe,
	stype = geometry
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION pgis_geometry_accum_transfn(internal, geometry)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_geometry_accum_transfn(internal, geometry, float8)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_geometry_accum_transfn(internal, geometry, float8, int)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_geometry_collect_finalfn(internal)
	RETURNS geometry
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_polygonize_finalfn(internal)
	RETURNS geometry
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_clusterintersecting_finalfn(internal)
	RETURNS geometry[]
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_clusterwithin_finalfn(internal)
	RETURNS geometry[]
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_makeline_finalfn(internal)
	RETURNS geometry
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_coverageunion_finalfn(internal)
	RETURNS geometry
	AS '$libdir/postgis-3'
	LANGUAGE 'c' PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_transfn(internal, geometry)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_transfn(internal, geometry, float8)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_combinefn(internal, internal)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_serialfn(internal)
	RETURNS bytea
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE STRICT
	COST 1;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_deserialfn(bytea, internal)
	RETURNS internal
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE STRICT
	COST 1;
CREATE OR REPLACE FUNCTION pgis_geometry_union_parallel_finalfn(internal)
	RETURNS geometry
	AS '$libdir/postgis-3'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE STRICT
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Union (geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3','pgis_union_geometry_array'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Aggregate ST_Union(geometry) -- LastUpdated: 303
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_Union(geometry) (
	sfunc = pgis_geometry_union_parallel_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_geometry_union_parallel_serialfn,
	deserialfunc = pgis_geometry_union_parallel_deserialfn,
	combinefunc = pgis_geometry_union_parallel_combinefn,
	finalfunc = pgis_geometry_union_parallel_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 303 > version_from_num OR (
      303 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_Union(geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_Union(geometry) (
	sfunc = pgis_geometry_union_parallel_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_geometry_union_parallel_serialfn,
	deserialfunc = pgis_geometry_union_parallel_deserialfn,
	combinefunc = pgis_geometry_union_parallel_combinefn,
	finalfunc = pgis_geometry_union_parallel_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_Union (geometry,gridSize float8) -- LastUpdated: 303
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_Union (geometry, gridSize float8) (
	sfunc = pgis_geometry_union_parallel_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_geometry_union_parallel_serialfn,
	deserialfunc = pgis_geometry_union_parallel_deserialfn,
	combinefunc = pgis_geometry_union_parallel_combinefn,
	finalfunc = pgis_geometry_union_parallel_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 303 > version_from_num OR (
      303 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_Union (geometry,gridSize float8)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_Union (geometry, gridSize float8) (
	sfunc = pgis_geometry_union_parallel_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_geometry_union_parallel_serialfn,
	deserialfunc = pgis_geometry_union_parallel_deserialfn,
	combinefunc = pgis_geometry_union_parallel_combinefn,
	finalfunc = pgis_geometry_union_parallel_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_Collect (geometry) -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_Collect (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_collect_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 205 > version_from_num OR (
      205 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_Collect (geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_Collect (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_collect_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_ClusterIntersecting (geometry) -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_ClusterIntersecting (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_clusterintersecting_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 205 > version_from_num OR (
      205 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_ClusterIntersecting (geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_ClusterIntersecting (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_clusterintersecting_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_ClusterWithin (geometry,float8) -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_ClusterWithin (geometry, float8) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_clusterwithin_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 205 > version_from_num OR (
      205 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_ClusterWithin (geometry,float8)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_ClusterWithin (geometry, float8) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_clusterwithin_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_Polygonize (geometry) -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_Polygonize (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_polygonize_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 205 > version_from_num OR (
      205 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_Polygonize (geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_Polygonize (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_polygonize_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_MakeLine (geometry) -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_MakeLine (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_makeline_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 205 > version_from_num OR (
      205 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_MakeLine (geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_MakeLine (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	parallel = safe,
	FINALFUNC = pgis_geometry_makeline_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_CoverageUnion (geometry[])
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CoverageUnion'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
-- Aggregate ST_CoverageUnion (geometry) -- LastUpdated: 304
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_CoverageUnion (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	PARALLEL = safe,
	FINALFUNC = pgis_geometry_coverageunion_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 304 > version_from_num OR (
      304 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_CoverageUnion (geometry)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_CoverageUnion (geometry) (
	SFUNC = pgis_geometry_accum_transfn,
	STYPE = internal,
	PARALLEL = safe,
	FINALFUNC = pgis_geometry_coverageunion_finalfn
	);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_CoverageSimplify (geom geometry, tolerance float8, simplifyBoundary boolean default true)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CoverageSimplify'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CoverageInvalidEdges (geom geometry, tolerance float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CoverageInvalidEdges'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CoverageClean (geom geometry, gapMaximumWidth float8 default 0.0, snappingDistance float8 default -1.0, overlapMergeStrategy text default 'MERGE_LONGEST_BORDER')
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CoverageClean'
	LANGUAGE 'c' IMMUTABLE STRICT WINDOW PARALLEL SAFE
	COST 5000;
-- Rename st_clusterkmeans ( geometry, integer ) deprecated in PostGIS 302, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_clusterkmeans(geometry, integer)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_clusterkmeans(geometry, integer) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_clusterkmeans(geometry, integer) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_clusterkmeans( geometry, integer ) RENAME TO st_clusterkmeans_deprecated_by_postgis_302;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_clusterkmeans(geometry, integer) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_clusterkmeans(geometry, integer) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_ClusterKMeans(geom geometry, k integer, max_radius float8 default null)
	RETURNS integer
	AS '$libdir/postgis-3', 'ST_ClusterKMeans'
	LANGUAGE 'c' VOLATILE STRICT WINDOW
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Relate(geom1 geometry, geom2 geometry)
	RETURNS text
	AS '$libdir/postgis-3','relate_full'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Relate(geom1 geometry, geom2 geometry, integer)
	RETURNS text
	AS '$libdir/postgis-3','relate_full'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Relate(geom1 geometry, geom2 geometry, text)
	RETURNS boolean
	AS '$libdir/postgis-3','relate_pattern'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Disjoint(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','disjoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_LineCrossingDirection(line1 geometry, line2 geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'ST_LineCrossingDirection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dwithin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Touches(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','touches'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Intersects(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_Intersects'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Crosses(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','crosses'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Contains(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','contains'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_ContainsProperly(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','containsproperly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Covers(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'covers'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_CoveredBy(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'coveredby'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Within(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS 'SELECT @extschema@._ST_Contains($2,$1)'
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _ST_Overlaps(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','overlaps'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DFullyWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dfullywithin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_3DDWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dwithin3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_3DDFullyWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dfullywithin3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_3DIntersects(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'ST_3DIntersects'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_OrderingEquals(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_same'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_Equals(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_Equals'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION postgis_index_supportfn (internal)
	RETURNS internal
	AS '$libdir/postgis-3', 'postgis_index_supportfn'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION ST_LineCrossingDirection(line1 geometry, line2 geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'ST_LineCrossingDirection'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_DWithin(geom1 geometry, geom2 geometry, float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dwithin'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Touches(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','touches'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Intersects(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_Intersects'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Crosses(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','crosses'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Contains(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','contains'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ContainsProperly(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','containsproperly'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Within(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','within'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Covers(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'covers'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CoveredBy(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'coveredby'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Overlaps(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','overlaps'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_DFullyWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dfullywithin'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_3DDWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dwithin3d'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_3DDFullyWithin(geom1 geometry, geom2 geometry,float8)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_dfullywithin3d'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_3DIntersects(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'ST_3DIntersects'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_OrderingEquals(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_same'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Equals(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_Equals'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsValid(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'isvalid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MinimumClearance(geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_MinimumClearance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_MinimumClearanceLine(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_MinimumClearanceLine'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Centroid(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'centroid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeometricMedian(g geometry, tolerance float8 DEFAULT NULL, max_iter int DEFAULT 10000, fail_if_not_converged boolean DEFAULT false)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_GeometricMedian'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_IsRing(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'isring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PointOnSurface(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'pointonsurface'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_IsSimple(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'issimple'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_IsCollection(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'ST_IsCollection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION Equals(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3','ST_Equals'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION _ST_GeomFromGML(text, integer)
	RETURNS geometry
	AS '$libdir/postgis-3','geom_from_gml'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromGML(text, integer)
	RETURNS geometry
	AS '$libdir/postgis-3','geom_from_gml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromGML(text)
	RETURNS geometry
	AS 'SELECT @extschema@._ST_GeomFromGML($1, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GMLToSQL(text)
	RETURNS geometry
	AS 'SELECT @extschema@._ST_GeomFromGML($1, 0)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GMLToSQL(text, integer)
	RETURNS geometry
	AS '$libdir/postgis-3','geom_from_gml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromKML(text)
	RETURNS geometry
	AS '$libdir/postgis-3','geom_from_kml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromMARC21(marc21xml text)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_GeomFromMARC21'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 500;
CREATE OR REPLACE FUNCTION ST_AsMARC21(geom geometry, format text DEFAULT 'hdddmmss')
	RETURNS TEXT
	AS '$libdir/postgis-3','ST_AsMARC21'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromGeoJson(text)
	RETURNS geometry
	AS '$libdir/postgis-3','geom_from_geojson'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromGeoJson(json)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_GeomFromGeoJson($1::text)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromGeoJson(jsonb)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_GeomFromGeoJson($1::text)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION postgis_libjson_version()
	RETURNS text
	AS '$libdir/postgis-3','postgis_libjson_version'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineFromEncodedPolyline(txtin text, nprecision integer DEFAULT 5)
	RETURNS geometry
	AS '$libdir/postgis-3','line_from_encoded_polyline'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsEncodedPolyline(geom geometry, nprecision integer DEFAULT 5)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asEncodedPolyline'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsSVG(geom geometry, rel integer DEFAULT 0, maxdecimaldigits integer DEFAULT 15)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asSVG'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION _ST_AsGML(integer, geometry, integer, integer, text, text)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asGML'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGML(geom geometry, maxdecimaldigits integer DEFAULT 15, options integer DEFAULT 0)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asGML'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGML(version integer, geom geometry, maxdecimaldigits integer DEFAULT 15, options integer DEFAULT 0, nprefix text DEFAULT null, id text DEFAULT null)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asGML'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
-- Rename st_askml ( geometry, integer ) deprecated in PostGIS 200, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_askml(geometry, integer)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_askml(geometry, integer) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_askml(geometry, integer) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_askml( geometry, integer ) RENAME TO st_askml_deprecated_by_postgis_200;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_askml(geometry, integer) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_askml(geometry, integer) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_AsKML(geom geometry, maxdecimaldigits integer DEFAULT 15, nprefix TEXT default '')
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asKML'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGeoJson(geom geometry, maxdecimaldigits integer DEFAULT 9, options integer DEFAULT 8)
	RETURNS text
	AS '$libdir/postgis-3','LWGEOM_asGeoJson'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
-- Rename st_asgeojson ( record, text, integer, bool ) deprecated in PostGIS 305, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_asgeojson(record, text, integer, bool)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_asgeojson(record, text, integer, bool) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_asgeojson(record, text, integer, bool) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_asgeojson( record, text, integer, bool ) RENAME TO st_asgeojson_deprecated_by_postgis_305;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_asgeojson(record, text, integer, bool) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_asgeojson(record, text, integer, bool) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_AsGeoJson(r record, geom_column text DEFAULT '', maxdecimaldigits integer DEFAULT 9, pretty_bool boolean DEFAULT false, id_column text DEFAULT '')
	RETURNS text
	AS '$libdir/postgis-3','ST_AsGeoJsonRow'
	LANGUAGE 'c' STABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION "json"(geometry)
	RETURNS json
	AS '$libdir/postgis-3','geometry_to_json'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION "jsonb"(geometry)
	RETURNS jsonb
	AS '$libdir/postgis-3','geometry_to_jsonb'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS json)');
DROP CAST IF EXISTS (geometry AS json);
CREATE CAST (geometry AS json) WITH FUNCTION "json"(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS jsonb)');
DROP CAST IF EXISTS (geometry AS jsonb);
CREATE CAST (geometry AS jsonb) WITH FUNCTION "jsonb"(geometry);
CREATE OR REPLACE FUNCTION pgis_asmvt_transfn(internal, anyelement)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_transfn(internal, anyelement, text)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_transfn(internal, anyelement, text, integer)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_transfn(internal, anyelement, text, integer, text)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_transfn(internal, anyelement, text, integer, text, text)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_finalfn(internal)
	RETURNS bytea
	AS '$libdir/postgis-3', 'pgis_asmvt_finalfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_combinefn(internal, internal)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_combinefn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_serialfn(internal)
	RETURNS bytea
	AS '$libdir/postgis-3', 'pgis_asmvt_serialfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION pgis_asmvt_deserialfn(bytea, internal)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asmvt_deserialfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
-- Aggregate ST_AsMVT(anyelement) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsMVT(anyelement)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsMVT(anyelement)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsMVT(anyelement)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsMVT(anyelement,text) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsMVT(anyelement, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn
	,finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsMVT(anyelement,text)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsMVT(anyelement, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn
	,finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsMVT(anyelement,text,integer) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsMVT(anyelement, text, integer)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsMVT(anyelement,text,integer)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsMVT(anyelement, text, integer)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsMVT(anyelement,text,integer,text) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsMVT(anyelement, text, integer, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsMVT(anyelement,text,integer,text)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsMVT(anyelement, text, integer, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsMVT(anyelement,text,integer,text,text) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsMVT(anyelement, text, integer, text, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsMVT(anyelement,text,integer,text,text)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsMVT(anyelement, text, integer, text, text)
(
	sfunc = pgis_asmvt_transfn,
	stype = internal,
	parallel = safe,
	serialfunc = pgis_asmvt_serialfn,
	deserialfunc = pgis_asmvt_deserialfn,
	combinefunc = pgis_asmvt_combinefn,
	finalfunc = pgis_asmvt_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_AsMVTGeom(geom geometry, bounds box2d, extent integer default 4096, buffer integer default 256, clip_geom bool default true)
	RETURNS geometry
	AS '$libdir/postgis-3','ST_AsMVTGeom'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION postgis_libprotobuf_version()
	RETURNS text
	AS '$libdir/postgis-3','postgis_libprotobuf_version'
	LANGUAGE 'c' IMMUTABLE STRICT;
CREATE OR REPLACE FUNCTION pgis_asgeobuf_transfn(internal, anyelement)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asgeobuf_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_asgeobuf_transfn(internal, anyelement, text)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asgeobuf_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_asgeobuf_finalfn(internal)
	RETURNS bytea
	AS '$libdir/postgis-3', 'pgis_asgeobuf_finalfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
-- Aggregate ST_AsGeobuf(anyelement) -- LastUpdated: 204
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsGeobuf(anyelement)
(
	sfunc = pgis_asgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 204 > version_from_num OR (
      204 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsGeobuf(anyelement)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsGeobuf(anyelement)
(
	sfunc = pgis_asgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsGeobuf(anyelement,text) -- LastUpdated: 204
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsGeobuf(anyelement, text)
(
	sfunc = pgis_asgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 204 > version_from_num OR (
      204 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsGeobuf(anyelement,text)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsGeobuf(anyelement, text)
(
	sfunc = pgis_asgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION pgis_asflatgeobuf_transfn(internal, anyelement)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asflatgeobuf_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_asflatgeobuf_transfn(internal, anyelement, bool)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asflatgeobuf_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_asflatgeobuf_transfn(internal, anyelement, bool, text)
	RETURNS internal
	AS '$libdir/postgis-3', 'pgis_asflatgeobuf_transfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION pgis_asflatgeobuf_finalfn(internal)
	RETURNS bytea
	AS '$libdir/postgis-3', 'pgis_asflatgeobuf_finalfn'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
-- Aggregate ST_AsFlatGeobuf(anyelement) -- LastUpdated: 303
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsFlatGeobuf(anyelement)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 303 > version_from_num OR (
      303 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsFlatGeobuf(anyelement)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsFlatGeobuf(anyelement)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsFlatGeobuf(anyelement,bool) -- LastUpdated: 303
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsFlatGeobuf(anyelement, bool)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 303 > version_from_num OR (
      303 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsFlatGeobuf(anyelement,bool)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsFlatGeobuf(anyelement, bool)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn,
	finalfunc_modify = read_write
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
-- Aggregate ST_AsFlatGeobuf(anyelement,bool,text) -- LastUpdated: 302
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
  IF pg_catalog.current_setting('server_version_num')::integer >= 120000
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE OR REPLACE AGGREGATE ST_AsFlatGeobuf(anyelement, bool, text)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  ELSIF 302 > version_from_num OR (
      302 = version_from_num AND version_from_isdev
    ) FROM _postgis_upgrade_info()
  THEN
    EXECUTE 'DROP AGGREGATE IF EXISTS ST_AsFlatGeobuf(anyelement,bool,text)';
    EXECUTE $postgis_proc_upgrade_parsed_def$ CREATE AGGREGATE ST_AsFlatGeobuf(anyelement, bool, text)
(
	sfunc = pgis_asflatgeobuf_transfn,
	stype = internal,
	parallel = safe,
	finalfunc = pgis_asflatgeobuf_finalfn
);
 $postgis_proc_upgrade_parsed_def$;
  END IF;
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_FromFlatGeobufToTable(text, text, bytea)
	RETURNS void
	AS '$libdir/postgis-3','pgis_tablefromflatgeobuf'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_FromFlatGeobuf(anyelement, bytea)
	RETURNS setof anyelement
	AS '$libdir/postgis-3','pgis_fromflatgeobuf'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeoHash(geom geometry, maxchars integer DEFAULT 0)
	RETURNS TEXT
	AS '$libdir/postgis-3', 'ST_GeoHash'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION _ST_SortableHash(geom geometry)
	RETURNS bigint
	AS '$libdir/postgis-3', '_ST_SortableHash'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Box2dFromGeoHash(text, integer DEFAULT NULL)
	RETURNS box2d
	AS '$libdir/postgis-3','box2d_from_geohash'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointFromGeoHash(text, integer DEFAULT NULL)
	RETURNS geometry
	AS '$libdir/postgis-3','point_from_geohash'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomFromGeoHash(text, integer DEFAULT NULL)
	RETURNS geometry
	AS $$ SELECT CAST(@extschema@.ST_Box2dFromGeoHash($1, $2) AS @extschema@.geometry); $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NumPoints(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_numpoints_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NumGeometries(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_numgeometries_collection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeometryN(geometry,integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_geometryn_collection'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Dimension(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_dimension'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ExteriorRing(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_exteriorring_polygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NumInteriorRings(geometry)
	RETURNS integer
	AS '$libdir/postgis-3','LWGEOM_numinteriorrings_polygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NumInteriorRing(geometry)
	RETURNS integer
	AS '$libdir/postgis-3','LWGEOM_numinteriorrings_polygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_InteriorRingN(geometry,integer)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_interiorringn_polygon'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION GeometryType(geometry)
	RETURNS text
	AS '$libdir/postgis-3', 'LWGEOM_getTYPE'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_GeometryType(geometry)
	RETURNS text
	AS '$libdir/postgis-3', 'geometry_geometrytype'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
CREATE OR REPLACE FUNCTION ST_ForcePolygonCW(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_clockwise_poly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ForceRHR(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_force_clockwise_poly'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_ForcePolygonCCW(geometry)
	RETURNS geometry
	AS $$ SELECT
	  CASE WHEN @extschema@.ST_GeometryType($1) IN ('ST_Polygon', 'ST_MultiPolygon')
	  THEN @extschema@.ST_Reverse(@extschema@.ST_ForcePolygonCW($1))
	  ELSE $1 END $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointN(geometry,integer)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_pointn_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_NumPatches(geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_numpatches'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PatchN(geometry, integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_patchn'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_StartPoint(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_startpoint_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_EndPoint(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_endpoint_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_IsClosed(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_isclosed'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_IsEmpty(geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_isempty'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsBinary(geometry,text)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_asBinary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsBinary(geometry)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_asBinary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsText(geometry)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asText'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsText(geometry, integer)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asText'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeometryFromText(text)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeometryFromText(text, integer)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromText(text)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromText(text, integer)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_WKTToSQL(text)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PointFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_Point''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PointFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_Point''
	THEN @extschema@.ST_GeomFromText($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LineFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromText($1,$2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PolyFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PolyFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromText($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PolygonFromText(text, integer)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_PolyFromText($1, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_PolygonFromText(text)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_PolyFromText($1)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MLineFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE
	WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_MultiLineString''
	THEN @extschema@.ST_GeomFromText($1,$2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MLineFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_MultiLineString''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MultiLineStringFromText(text)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_MLineFromText($1)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MultiLineStringFromText(text, integer)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_MLineFromText($1, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MPointFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromText($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MPointFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MultiPointFromText(text)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_MPointFromText($1)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MPolyFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromText($1,$2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MPolyFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MultiPolygonFromText(text, integer)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_MPolyFromText($1, $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MultiPolygonFromText(text)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_MPolyFromText($1)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomCollFromText(text, integer)
	RETURNS geometry
	AS '
	SELECT CASE
	WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1, $2)) = ''ST_GeometryCollection''
	THEN @extschema@.ST_GeomFromText($1,$2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomCollFromText(text)
	RETURNS geometry
	AS '
	SELECT CASE
	WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromText($1)) = ''ST_GeometryCollection''
	THEN @extschema@.ST_GeomFromText($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeomFromWKB(bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_WKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomFromWKB(bytea, int)
	RETURNS geometry
	AS 'SELECT @extschema@.ST_SetSRID(@extschema@.ST_GeomFromWKB($1), $2)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_Point''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_Point''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LineFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LineFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LinestringFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LinestringFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_LineString''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PolyFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PolyFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PolygonFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1,$2)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PolygonFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_Polygon''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MPointFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MPointFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MultiPointFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1,$2)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MultiPointFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiPoint''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MultiLineFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiLineString''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MLineFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_MultiLineString''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MLineFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiLineString''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MPolyFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MPolyFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_MultiPolyFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_MultiPolyFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_MultiPolygon''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomCollFromWKB(bytea, int)
	RETURNS geometry
	AS '
	SELECT CASE
	WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1, $2)) = ''ST_GeometryCollection''
	THEN @extschema@.ST_GeomFromWKB($1, $2)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeomCollFromWKB(bytea)
	RETURNS geometry
	AS '
	SELECT CASE
	WHEN @extschema@.ST_GeometryType(@extschema@.ST_GeomFromWKB($1)) = ''ST_GeometryCollection''
	THEN @extschema@.ST_GeomFromWKB($1)
	ELSE NULL END
	'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION _ST_MaxDistance(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'LWGEOM_maxdistance2d_linestring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_MaxDistance(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS 'SELECT @extschema@._ST_MaxDistance(@extschema@.ST_ConvexHull($1), @extschema@.ST_ConvexHull($2))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_ClosestPoint(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_closestpoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_ShortestLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_shortestline2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION _ST_LongestLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_longestline2d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LongestLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS 'SELECT @extschema@._ST_LongestLine(@extschema@.ST_ConvexHull($1), @extschema@.ST_ConvexHull($2))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_SwapOrdinates(geom geometry, ords cstring)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_SwapOrdinates'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_FlipCoordinates(geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_FlipCoordinates'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_BdPolyFromText(text, integer)
RETURNS geometry
AS $$
DECLARE
	geomtext alias for $1;
	srid alias for $2;
	mline @extschema@.geometry;
	geom @extschema@.geometry;
BEGIN
	mline := @extschema@.ST_MultiLineStringFromText(geomtext, srid);

	IF mline IS NULL
	THEN
		RAISE EXCEPTION 'Input is not a MultiLinestring';
	END IF;

	geom := @extschema@.ST_BuildArea(mline);

	IF @extschema@.ST_GeometryType(geom) != 'ST_Polygon'
	THEN
		RAISE EXCEPTION 'Input returns more then a single polygon, try using BdMPolyFromText instead';
	END IF;

	RETURN geom;
END;
$$
LANGUAGE 'plpgsql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_BdMPolyFromText(text, integer)
RETURNS geometry
AS $$
DECLARE
	geomtext alias for $1;
	srid alias for $2;
	mline @extschema@.geometry;
	geom @extschema@.geometry;
BEGIN
	mline := @extschema@.ST_MultiLineStringFromText(geomtext, srid);

	IF mline IS NULL
	THEN
		RAISE EXCEPTION 'Input is not a MultiLinestring';
	END IF;

	geom := @extschema@.ST_Multi(@extschema@.ST_BuildArea(mline));

	RETURN geom;
END;
$$
LANGUAGE 'plpgsql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_typmod_in(cstring[])
	RETURNS integer
	AS '$libdir/postgis-3','geography_typmod_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_typmod_out(integer)
	RETURNS cstring
	AS '$libdir/postgis-3','postgis_typmod_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_in(cstring, oid, integer)
	RETURNS geography
	AS '$libdir/postgis-3','geography_in'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_out(geography)
	RETURNS cstring
	AS '$libdir/postgis-3','geography_out'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_recv(internal, oid, integer)
	RETURNS geography
	AS '$libdir/postgis-3','geography_recv'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_send(geography)
	RETURNS bytea
	AS '$libdir/postgis-3','geography_send'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_analyze(internal)
	RETURNS bool
	AS '$libdir/postgis-3','gserialized_analyze_nd'
	LANGUAGE 'c' VOLATILE STRICT;
-- Type geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_type_upgrade$
BEGIN
  IF 105 > version_from_num
     FROM _postgis_upgrade_info()
  THEN
      EXECUTE $postgis_type_upgrade_parsed_def$ CREATE TYPE geography (
 $postgis_type_upgrade_parsed_def$;
  END IF;
END
$postgis_type_upgrade$;


CREATE OR REPLACE FUNCTION geography(geography, integer, boolean)
	RETURNS geography
	AS '$libdir/postgis-3','geography_enforce_typmod'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geography AS geography)');
DROP CAST IF EXISTS (geography AS geography);
CREATE CAST (geography AS geography) WITH FUNCTION geography(geography, integer, boolean) AS IMPLICIT;
CREATE OR REPLACE FUNCTION geography(bytea)
	RETURNS geography
	AS '$libdir/postgis-3','geography_from_binary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION bytea(geography)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_to_bytea'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (bytea AS geography)');
DROP CAST IF EXISTS (bytea AS geography);
CREATE CAST (bytea AS geography) WITH FUNCTION geography(bytea) AS IMPLICIT;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geography AS bytea)');
DROP CAST IF EXISTS (geography AS bytea);
CREATE CAST (geography AS bytea) WITH FUNCTION bytea(geography) AS IMPLICIT;
CREATE OR REPLACE FUNCTION ST_AsText(geography)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asText'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsText(geography, integer)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asText'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsText(text)
	RETURNS text AS
	$$ SELECT @extschema@.ST_AsText($1::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
CREATE OR REPLACE FUNCTION ST_GeographyFromText(text)
	RETURNS geography
	AS '$libdir/postgis-3','geography_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeogFromText(text)
	RETURNS geography
	AS '$libdir/postgis-3','geography_from_text'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_GeogFromWKB(bytea)
	RETURNS geography
	AS '$libdir/postgis-3','geography_from_binary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION postgis_typmod_dims(integer)
	RETURNS integer
	AS '$libdir/postgis-3','postgis_typmod_dims'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION postgis_typmod_srid(integer)
	RETURNS integer
	AS '$libdir/postgis-3','postgis_typmod_srid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION postgis_typmod_type(integer)
	RETURNS text
	AS '$libdir/postgis-3','postgis_typmod_type'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE VIEW geography_columns AS
	SELECT
		pg_catalog.current_database() AS f_table_catalog,
		n.nspname AS f_table_schema,
		c.relname AS f_table_name,
		a.attname AS f_geography_column,
		postgis_typmod_dims(a.atttypmod) AS coord_dimension,
		postgis_typmod_srid(a.atttypmod) AS srid,
		postgis_typmod_type(a.atttypmod) AS type
	FROM
		pg_class c,
		pg_attribute a,
		pg_type t,
		pg_namespace n
	WHERE t.typname = 'geography'
		AND a.attisdropped = false
		AND a.atttypid = t.oid
		AND a.attrelid = c.oid
		AND c.relnamespace = n.oid
		AND c.relkind = ANY (ARRAY['r'::"char", 'v'::"char", 'm'::"char", 'f'::"char", 'p'::"char"] )
		AND NOT pg_is_other_temp_schema(c.relnamespace)
		AND has_table_privilege( c.oid, 'SELECT'::text );
CREATE OR REPLACE FUNCTION geography(geometry)
	RETURNS geography
	AS '$libdir/postgis-3','geography_from_geometry'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geometry AS geography)');
DROP CAST IF EXISTS (geometry AS geography);
CREATE CAST (geometry AS geography) WITH FUNCTION geography(geometry) AS IMPLICIT;
CREATE OR REPLACE FUNCTION geometry(geography)
	RETURNS geometry
	AS '$libdir/postgis-3','geometry_from_geography'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP CAST IF EXISTS (geography AS geometry)');
DROP CAST IF EXISTS (geography AS geometry);
CREATE CAST (geography AS geometry) WITH FUNCTION geometry(geography) ;
CREATE OR REPLACE FUNCTION geography_gist_consistent(internal,geography,integer)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_gist_consistent'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_compress(internal)
	RETURNS internal
	AS '$libdir/postgis-3','gserialized_gist_compress'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_penalty(internal,internal,internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_penalty'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_picksplit(internal, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_picksplit'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_union(bytea, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_union'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_same(box2d, box2d, internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_same'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_gist_decompress(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_gist_decompress'
	LANGUAGE 'c';
CREATE OR REPLACE FUNCTION geography_overlaps(geography, geography)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_overlaps'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Operator geography && geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR && (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_overlaps,
	COMMUTATOR = '&&',
	RESTRICT = gserialized_gist_sel_nd,
	JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geography_distance_knn(geography, geography)
  RETURNS float8
  AS '$libdir/postgis-3','geography_distance_knn'
  LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
  COST 100;
-- Operator geography <-> geography -- LastUpdated: 202
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<->' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR <-> (
  LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_distance_knn,
  COMMUTATOR = '<->'
);

  END IF; -- version_from >= 202
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geography_gist_distance(internal, geography, integer)
	RETURNS float8
	AS '$libdir/postgis-3' ,'gserialized_gist_geog_distance'
	LANGUAGE 'c';
-- Operator class gist_geography_ops -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 105 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS gist_geography_ops
	DEFAULT FOR TYPE geography USING GIST AS
	STORAGE 	gidx,
	OPERATOR        3        &&	,
	OPERATOR        13       <-> FOR ORDER BY pg_catalog.float_ops,
	FUNCTION        8        geography_gist_distance (internal, geography, integer),
	FUNCTION        1        geography_gist_consistent (internal, geography, integer),
	FUNCTION        2        geography_gist_union (bytea, internal),
	FUNCTION        3        geography_gist_compress (internal),
	FUNCTION        4        geography_gist_decompress (internal),
	FUNCTION        5        geography_gist_penalty (internal, internal, internal),
	FUNCTION        6        geography_gist_picksplit (internal, internal),
	FUNCTION        7        geography_gist_same (box2d, box2d, internal);
    $postgis_proc_upgrade_parsed_def$;
  ELSE -- version_from >= 105
    -- Last Updated: 202
    IF 202 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geography_ops USING gist
          ADD OPERATOR        13       <-> (geography,geography) FOR ORDER BY pg_catalog.float_ops;
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  
    -- Last Updated: 202
    IF 202 > version_from_num FROM _postgis_upgrade_info() THEN
      EXECUTE $postgis_proc_upgrade_parsed_def$
        ALTER OPERATOR FAMILY gist_geography_ops USING gist
          ADD FUNCTION        8 (geography,geography)        geography_gist_distance (internal, geography, integer);
      $postgis_proc_upgrade_parsed_def$;
    END IF;
  END IF; -- version_from >= 202
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION overlaps_geog(gidx, geography)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_gidx_geog_overlaps'
LANGUAGE 'c' IMMUTABLE STRICT;
CREATE OR REPLACE FUNCTION overlaps_geog(gidx, gidx)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_gidx_gidx_overlaps'
LANGUAGE 'c' IMMUTABLE STRICT;
-- Operator gidx && geography -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'gidx' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR && (
  LEFTARG    = gidx,
  RIGHTARG   = geography,
  PROCEDURE  = overlaps_geog,
  COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION overlaps_geog(geography, gidx)
RETURNS boolean
AS
  'SELECT $2 OPERATOR(@extschema@.&&) $1;'
 LANGUAGE SQL IMMUTABLE STRICT;
-- Operator geography && gidx -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'geography' AND
            tr.typname = 'gidx'
    )
    THEN
CREATE OPERATOR && (
  LEFTARG    = geography,
  RIGHTARG   = gidx,
  PROCEDURE  = overlaps_geog,
  COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator gidx && gidx -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'gidx' AND
            tr.typname = 'gidx'
    )
    THEN
CREATE OPERATOR && (
  LEFTARG   = gidx,
  RIGHTARG  = gidx,
  PROCEDURE = overlaps_geog,
  COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geog_brin_inclusion_add_value(internal, internal, internal, internal)
RETURNS boolean
        AS '$libdir/postgis-3','geog_brin_inclusion_add_value'
        LANGUAGE 'c' PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geog_brin_inclusion_merge(internal, internal)
RETURNS internal
        AS '$libdir/postgis-3','geog_brin_inclusion_merge'
        LANGUAGE 'c' PARALLEL SAFE;
-- Operator class brin_geography_inclusion_ops -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 203 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS brin_geography_inclusion_ops
  DEFAULT FOR TYPE geography
  USING brin AS
    FUNCTION      1        brin_inclusion_opcinfo(internal),
    FUNCTION      2        geog_brin_inclusion_add_value(internal, internal, internal, internal),
    FUNCTION      3        brin_inclusion_consistent(internal, internal, internal),
    FUNCTION      4        brin_inclusion_union(internal, internal, internal),
    FUNCTION      11       geog_brin_inclusion_merge(internal, internal),
    OPERATOR      3        &&(geography, geography),
    OPERATOR      3        &&(geography, gidx),
    OPERATOR      3        &&(gidx, geography),
    OPERATOR      3        &&(gidx, gidx),
  STORAGE gidx;
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geography_lt(geography, geography)
	RETURNS bool
	AS '$libdir/postgis-3', 'geography_lt'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_le(geography, geography)
	RETURNS bool
	AS '$libdir/postgis-3', 'geography_le'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_gt(geography, geography)
	RETURNS bool
	AS '$libdir/postgis-3', 'geography_gt'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_ge(geography, geography)
	RETURNS bool
	AS '$libdir/postgis-3', 'geography_ge'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_eq(geography, geography)
	RETURNS bool
	AS '$libdir/postgis-3', 'geography_eq'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_cmp(geography, geography)
	RETURNS integer
	AS '$libdir/postgis-3', 'geography_cmp'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Operator geography < geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR < (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_lt,
	COMMUTATOR = '>', NEGATOR = '>=',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
-- Operator geography <= geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<=' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR <= (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_le,
	COMMUTATOR = '>=', NEGATOR = '>',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
-- Operator geography = geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '=' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR = (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_eq,
	COMMUTATOR = '=', -- we might implement a faster negator here
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
-- Operator geography >= geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '>=' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR >= (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_ge,
	COMMUTATOR = '<=', NEGATOR = '<',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
-- Operator geography > geography -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '>' AND
            tl.typname = 'geography' AND
            tr.typname = 'geography'
    )
    THEN
CREATE OPERATOR > (
	LEFTARG = geography, RIGHTARG = geography, PROCEDURE = geography_gt,
	COMMUTATOR = '<', NEGATOR = '<=',
	RESTRICT = contsel, JOIN = contjoinsel
);

  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
-- Operator class btree_geography_ops -- LastUpdated: 105
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 105 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS btree_geography_ops
	DEFAULT FOR TYPE geography USING btree AS
	OPERATOR	1	< ,
	OPERATOR	2	<= ,
	OPERATOR	3	= ,
	OPERATOR	4	>= ,
	OPERATOR	5	> ,
	FUNCTION	1	geography_cmp (geography, geography);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 105
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_AsSVG(geog geography, rel integer DEFAULT 0, maxdecimaldigits integer DEFAULT 15)
	RETURNS text
	AS '$libdir/postgis-3','geography_as_svg'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsSVG(text)
	RETURNS text AS
	$$ SELECT @extschema@.ST_AsSVG($1::@extschema@.geometry,0,15);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
CREATE OR REPLACE FUNCTION ST_AsGML(version integer, geog geography, maxdecimaldigits integer DEFAULT 15, options integer DEFAULT 0, nprefix text DEFAULT 'gml', id text DEFAULT '')
	RETURNS text
	AS '$libdir/postgis-3','geography_as_gml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGML(geog geography, maxdecimaldigits integer DEFAULT 15, options integer DEFAULT 0, nprefix text DEFAULT 'gml', id text DEFAULT '')
	RETURNS text
	AS '$libdir/postgis-3','geography_as_gml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGML(text)
	RETURNS text AS
	$$ SELECT @extschema@._ST_AsGML(2,$1::@extschema@.geometry,15,0, NULL, NULL);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
-- Rename st_askml ( geography, integer ) deprecated in PostGIS 200, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_askml(geography, integer)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_askml(geography, integer) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_askml(geography, integer) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_askml( geography, integer ) RENAME TO st_askml_deprecated_by_postgis_200;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_askml(geography, integer) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_askml(geography, integer) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_AsKML(geog geography, maxdecimaldigits integer DEFAULT 15, nprefix text DEFAULT '')
	RETURNS text
	AS '$libdir/postgis-3','geography_as_kml'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsKML(text)
	RETURNS text AS
	$$ SELECT @extschema@.ST_AsKML($1::@extschema@.geometry, 15);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
CREATE OR REPLACE FUNCTION ST_AsGeoJson(geog geography, maxdecimaldigits integer DEFAULT 9, options integer DEFAULT 0)
	RETURNS text
	AS '$libdir/postgis-3','geography_as_geojson'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsGeoJson(text)
	RETURNS text AS
	$$ SELECT @extschema@.ST_AsGeoJson($1::@extschema@.geometry, 9, 0);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
-- Rename st_distance ( geography, geography ) deprecated in PostGIS 300, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_distance(geography, geography)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_distance(geography, geography) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_distance(geography, geography) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_distance( geography, geography ) RENAME TO st_distance_deprecated_by_postgis_300;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_distance(geography, geography) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_distance(geography, geography) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Distance(geog1 geography, geog2 geography, use_spheroid boolean DEFAULT true)
	RETURNS float8
	AS '$libdir/postgis-3','geography_distance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Distance(text, text)
	RETURNS float8 AS
	$$ SELECT @extschema@.ST_Distance($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _ST_Expand(geography, float8)
	RETURNS geography
	AS '$libdir/postgis-3','geography_expand'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION _ST_DistanceUnCached(geography, geography, float8, boolean)
	RETURNS float8
	AS '$libdir/postgis-3','geography_distance_uncached'
	LANGUAGE 'c' IMMUTABLE STRICT
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DistanceUnCached(geography, geography, boolean)
	RETURNS float8
	AS 'SELECT @extschema@._ST_DistanceUnCached($1, $2, 0.0, $3)'
	LANGUAGE 'sql' IMMUTABLE STRICT;
CREATE OR REPLACE FUNCTION _ST_DistanceUnCached(geography, geography)
	RETURNS float8
	AS 'SELECT @extschema@._ST_DistanceUnCached($1, $2, 0.0, true)'
	LANGUAGE 'sql' IMMUTABLE STRICT;
CREATE OR REPLACE FUNCTION _ST_DistanceTree(geography, geography, float8, boolean)
	RETURNS float8
	AS '$libdir/postgis-3','geography_distance_tree'
	LANGUAGE 'c' IMMUTABLE STRICT
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DistanceTree(geography, geography)
	RETURNS float8
	AS 'SELECT @extschema@._ST_DistanceTree($1, $2, 0.0, true)'
	LANGUAGE 'sql' IMMUTABLE STRICT;
CREATE OR REPLACE FUNCTION _ST_DWithinUnCached(geography, geography, float8, boolean)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_dwithin_uncached'
	LANGUAGE 'c' IMMUTABLE STRICT
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DWithinUnCached(geography, geography, float8)
	RETURNS boolean
	AS 'SELECT $1 OPERATOR(@extschema@.&&) @extschema@._ST_Expand($2,$3) AND $2 OPERATOR(@extschema@.&&) @extschema@._ST_Expand($1,$3) AND @extschema@._ST_DWithinUnCached($1, $2, $3, true)'
	LANGUAGE 'sql' IMMUTABLE;
CREATE OR REPLACE FUNCTION ST_Area(geog geography, use_spheroid boolean DEFAULT true)
	RETURNS float8
	AS '$libdir/postgis-3','geography_area'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Area(text)
	RETURNS float8 AS
	$$ SELECT @extschema@.ST_Area($1::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Length(geog geography, use_spheroid boolean DEFAULT true)
	RETURNS float8
	AS '$libdir/postgis-3','geography_length'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Length(text)
	RETURNS float8 AS
	$$ SELECT @extschema@.ST_Length($1::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Project(geog geography, distance float8, azimuth float8)
	RETURNS geography
	AS '$libdir/postgis-3','geography_project'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Project(geog_from geography, geog_to geography, distance float8)
	RETURNS geography
	AS '$libdir/postgis-3','geography_project_geography'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Azimuth(geog1 geography, geog2 geography)
	RETURNS float8
	AS '$libdir/postgis-3','geography_azimuth'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Perimeter(geog geography, use_spheroid boolean DEFAULT true)
	RETURNS float8
	AS '$libdir/postgis-3','geography_perimeter'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION _ST_PointOutside(geography)
	RETURNS geography
	AS '$libdir/postgis-3','geography_point_outside'
	LANGUAGE 'c' IMMUTABLE STRICT
	COST 1;
CREATE OR REPLACE FUNCTION ST_Segmentize(geog geography, max_segment_length float8)
	RETURNS geography
	AS '$libdir/postgis-3','geography_segmentize'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION _ST_BestSRID(geography, geography)
	RETURNS integer
	AS '$libdir/postgis-3','geography_bestsrid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION _ST_BestSRID(geography)
	RETURNS integer
	AS '$libdir/postgis-3','geography_bestsrid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsBinary(geography)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_asBinary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsBinary(geography, text)
	RETURNS bytea
	AS '$libdir/postgis-3','LWGEOM_asBinary'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_AsEWKT(geography)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asEWKT'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsEWKT(geography, integer)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asEWKT'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsEWKT(text)
	RETURNS text AS
	$$ SELECT @extschema@.ST_AsEWKT($1::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
        COST 250;
CREATE OR REPLACE FUNCTION GeometryType(geography)
	RETURNS text
	AS '$libdir/postgis-3', 'LWGEOM_getTYPE'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Summary(geography)
	RETURNS text
	AS '$libdir/postgis-3', 'LWGEOM_summary'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_GeoHash(geog geography, maxchars integer DEFAULT 0)
	RETURNS TEXT
	AS '$libdir/postgis-3', 'ST_GeoHash'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_SRID(geog geography)
	RETURNS integer
	AS '$libdir/postgis-3', 'LWGEOM_get_srid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_SetSRID(geog geography, srid integer)
	RETURNS geography
	AS '$libdir/postgis-3', 'LWGEOM_set_srid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Centroid(geography, use_spheroid boolean DEFAULT true)
	RETURNS geography
	AS '$libdir/postgis-3','geography_centroid'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Centroid(text)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_Centroid($1::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION _ST_Covers(geog1 geography, geog2 geography)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_covers'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_DWithin(geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean DEFAULT true)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_dwithin'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_CoveredBy(geog1 geography, geog2 geography)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_coveredby'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Covers(geog1 geography, geog2 geography)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_covers'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
-- Rename st_dwithin ( geography, geography, float8 ) deprecated in PostGIS 300, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_dwithin(geography, geography, float8)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_dwithin(geography, geography, float8) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_dwithin(geography, geography, float8) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_dwithin( geography, geography, float8 ) RENAME TO st_dwithin_deprecated_by_postgis_300;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_dwithin(geography, geography, float8) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_dwithin(geography, geography, float8) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_DWithin(geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean DEFAULT true)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_dwithin'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CoveredBy(geog1 geography, geog2 geography)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_coveredby'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Intersects(geog1 geography, geog2 geography)
	RETURNS boolean
	AS '$libdir/postgis-3','geography_intersects'
	SUPPORT postgis_index_supportfn
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Buffer(geography, float8)
	RETURNS geography
	AS 'SELECT @extschema@.geography(@extschema@.ST_Transform(@extschema@.ST_Buffer(@extschema@.ST_Transform(@extschema@.geometry($1), @extschema@._ST_BestSRID($1)), $2), @extschema@.ST_SRID($1)))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Buffer(geography, float8, integer)
	RETURNS geography
	AS 'SELECT @extschema@.geography(@extschema@.ST_Transform(@extschema@.ST_Buffer(@extschema@.ST_Transform(@extschema@.geometry($1), @extschema@._ST_BestSRID($1)), $2, $3), @extschema@.ST_SRID($1)))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Buffer(geography, float8, text)
	RETURNS geography
	AS 'SELECT @extschema@.geography(@extschema@.ST_Transform(@extschema@.ST_Buffer(@extschema@.ST_Transform(@extschema@.geometry($1), @extschema@._ST_BestSRID($1)), $2, $3), @extschema@.ST_SRID($1)))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Buffer(text, float8)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_Buffer($1::@extschema@.geometry, $2);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Buffer(text, float8, integer)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_Buffer($1::@extschema@.geometry, $2, $3);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Buffer(text, float8, text)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_Buffer($1::@extschema@.geometry, $2, $3);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Intersection(geography, geography)
	RETURNS geography
	AS 'SELECT @extschema@.geography(@extschema@.ST_Transform(@extschema@.ST_Intersection(@extschema@.ST_Transform(@extschema@.geometry($1), @extschema@._ST_BestSRID($1, $2)), @extschema@.ST_Transform(@extschema@.geometry($2), @extschema@._ST_BestSRID($1, $2))), @extschema@.ST_SRID($1)))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Intersection(text, text)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_Intersection($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Covers(text, text)
	RETURNS boolean AS
	$$ SELECT @extschema@.ST_Covers($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_CoveredBy(text, text)
	RETURNS boolean AS
	$$ SELECT @extschema@.ST_CoveredBy($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_DWithin(text, text, float8)
	RETURNS boolean AS
	$$ SELECT @extschema@.ST_DWithin($1::@extschema@.geometry, $2::@extschema@.geometry, $3);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_Intersects(text, text)
	RETURNS boolean AS
	$$ SELECT @extschema@.ST_Intersects($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_ClosestPoint(geography, geography, use_spheroid boolean DEFAULT true)
 	RETURNS geography
	AS '$libdir/postgis-3', 'geography_closestpoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_ClosestPoint(text, text)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_ClosestPoint($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_ShortestLine(geography, geography, use_spheroid boolean DEFAULT true)
	RETURNS geography
	AS '$libdir/postgis-3', 'geography_shortestline'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_ShortestLine(text, text)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_ShortestLine($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineSubstring(geography, float8, float8)
	RETURNS geography
	AS '$libdir/postgis-3', 'geography_line_substring'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineSubstring(text, float8, float8)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_LineSubstring($1::@extschema@.geometry, $2, $3);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineLocatePoint(geography, geography, use_spheroid boolean DEFAULT true)
	RETURNS float
	AS '$libdir/postgis-3', 'geography_line_locate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineLocatePoint(text, text)
	RETURNS float AS
	$$ SELECT @extschema@.ST_LineLocatePoint($1::@extschema@.geometry, $2::@extschema@.geometry);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoints(geography, float8, use_spheroid boolean DEFAULT true, repeat boolean DEFAULT true)
	RETURNS geography
	AS '$libdir/postgis-3', 'geography_line_interpolate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoints(text, float8)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_LineInterpolatePoints($1::@extschema@.geometry, $2);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoint(geography, float8, use_spheroid boolean DEFAULT true)
	RETURNS geography
	AS '$libdir/postgis-3', 'geography_line_interpolate_point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_LineInterpolatePoint(text, float8)
	RETURNS geometry AS
	$$ SELECT @extschema@.ST_LineInterpolatePoint($1::@extschema@.geometry, $2);  $$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_DistanceSphere(geom1 geometry, geom2 geometry)
	RETURNS FLOAT8 AS
	'select @extschema@.ST_distance( @extschema@.geography($1), @extschema@.geography($2),false)'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_DistanceSphere(geom1 geometry, geom2 geometry, radius float8)
	RETURNS FLOAT8
	AS '$libdir/postgis-3','LWGEOM_distance_sphere'
	LANGUAGE 'c' IMMUTABLE STRICT
 	COST 5000;
CREATE OR REPLACE FUNCTION postgis_type_name(geomname varchar, coord_dimension integer, use_new_name boolean DEFAULT true)
	RETURNS varchar
AS
$$
	SELECT CASE WHEN $3 THEN new_name ELSE old_name END As geomname
	FROM
	( VALUES
			('GEOMETRY', 'Geometry', 2),
			('GEOMETRY', 'GeometryZ', 3),
			('GEOMETRYM', 'GeometryM', 3),
			('GEOMETRY', 'GeometryZM', 4),

			('GEOMETRYCOLLECTION', 'GeometryCollection', 2),
			('GEOMETRYCOLLECTION', 'GeometryCollectionZ', 3),
			('GEOMETRYCOLLECTIONM', 'GeometryCollectionM', 3),
			('GEOMETRYCOLLECTION', 'GeometryCollectionZM', 4),

			('POINT', 'Point', 2),
			('POINT', 'PointZ', 3),
			('POINTM','PointM', 3),
			('POINT', 'PointZM', 4),

			('MULTIPOINT','MultiPoint', 2),
			('MULTIPOINT','MultiPointZ', 3),
			('MULTIPOINTM','MultiPointM', 3),
			('MULTIPOINT','MultiPointZM', 4),

			('POLYGON', 'Polygon', 2),
			('POLYGON', 'PolygonZ', 3),
			('POLYGONM', 'PolygonM', 3),
			('POLYGON', 'PolygonZM', 4),

			('MULTIPOLYGON', 'MultiPolygon', 2),
			('MULTIPOLYGON', 'MultiPolygonZ', 3),
			('MULTIPOLYGONM', 'MultiPolygonM', 3),
			('MULTIPOLYGON', 'MultiPolygonZM', 4),

			('MULTILINESTRING', 'MultiLineString', 2),
			('MULTILINESTRING', 'MultiLineStringZ', 3),
			('MULTILINESTRINGM', 'MultiLineStringM', 3),
			('MULTILINESTRING', 'MultiLineStringZM', 4),

			('LINESTRING', 'LineString', 2),
			('LINESTRING', 'LineStringZ', 3),
			('LINESTRINGM', 'LineStringM', 3),
			('LINESTRING', 'LineStringZM', 4),

			('CIRCULARSTRING', 'CircularString', 2),
			('CIRCULARSTRING', 'CircularStringZ', 3),
			('CIRCULARSTRINGM', 'CircularStringM' ,3),
			('CIRCULARSTRING', 'CircularStringZM', 4),

			('COMPOUNDCURVE', 'CompoundCurve', 2),
			('COMPOUNDCURVE', 'CompoundCurveZ', 3),
			('COMPOUNDCURVEM', 'CompoundCurveM', 3),
			('COMPOUNDCURVE', 'CompoundCurveZM', 4),

			('CURVEPOLYGON', 'CurvePolygon', 2),
			('CURVEPOLYGON', 'CurvePolygonZ', 3),
			('CURVEPOLYGONM', 'CurvePolygonM', 3),
			('CURVEPOLYGON', 'CurvePolygonZM', 4),

			('MULTICURVE', 'MultiCurve', 2),
			('MULTICURVE', 'MultiCurveZ', 3),
			('MULTICURVEM', 'MultiCurveM', 3),
			('MULTICURVE', 'MultiCurveZM', 4),

			('MULTISURFACE', 'MultiSurface', 2),
			('MULTISURFACE', 'MultiSurfaceZ', 3),
			('MULTISURFACEM', 'MultiSurfaceM', 3),
			('MULTISURFACE', 'MultiSurfaceZM', 4),

			('POLYHEDRALSURFACE', 'PolyhedralSurface', 2),
			('POLYHEDRALSURFACE', 'PolyhedralSurfaceZ', 3),
			('POLYHEDRALSURFACEM', 'PolyhedralSurfaceM', 3),
			('POLYHEDRALSURFACE', 'PolyhedralSurfaceZM', 4),

			('TRIANGLE', 'Triangle', 2),
			('TRIANGLE', 'TriangleZ', 3),
			('TRIANGLEM', 'TriangleM', 3),
			('TRIANGLE', 'TriangleZM', 4),

			('TIN', 'Tin', 2),
			('TIN', 'TinZ', 3),
			('TINM', 'TinM', 3),
			('TIN', 'TinZM', 4) )
			 As g(old_name, new_name, coord_dimension)
	WHERE (upper(old_name) = upper($1) OR upper(new_name) = upper($1))
		AND coord_dimension = $2;
$$
LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE COST 5000;
CREATE OR REPLACE FUNCTION postgis_constraint_srid(geomschema text, geomtable text, geomcolumn text) RETURNS integer AS
$$
SELECT replace(replace(split_part(s.consrc, ' = ', 2), ')', ''), '(', '')::integer
		 FROM pg_class c, pg_namespace n, pg_attribute a
		 , (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
			FROM pg_constraint) AS s
		 WHERE n.nspname = $1
		 AND c.relname = $2
		 AND a.attname = $3
		 AND a.attrelid = c.oid
		 AND s.connamespace = n.oid
		 AND s.conrelid = c.oid
		 AND a.attnum = ANY (s.conkey)
		 AND s.consrc LIKE '%srid(% = %';
$$
LANGUAGE 'sql' STABLE STRICT PARALLEL SAFE COST 250;
CREATE OR REPLACE FUNCTION postgis_constraint_dims(geomschema text, geomtable text, geomcolumn text) RETURNS integer AS
$$
SELECT  replace(split_part(s.consrc, ' = ', 2), ')', '')::integer
		 FROM pg_class c, pg_namespace n, pg_attribute a
		 , (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
			FROM pg_constraint) AS s
		 WHERE n.nspname = $1
		 AND c.relname = $2
		 AND a.attname = $3
		 AND a.attrelid = c.oid
		 AND s.connamespace = n.oid
		 AND s.conrelid = c.oid
		 AND a.attnum = ANY (s.conkey)
		 AND s.consrc LIKE '%ndims(% = %';
$$
LANGUAGE 'sql' STABLE STRICT PARALLEL SAFE COST 250;
CREATE OR REPLACE FUNCTION postgis_constraint_type(geomschema text, geomtable text, geomcolumn text) RETURNS varchar AS
$$
SELECT  replace(split_part(s.consrc, '''', 2), ')', '')::varchar
		 FROM pg_class c, pg_namespace n, pg_attribute a
		 , (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
			FROM pg_constraint) AS s
		 WHERE n.nspname = $1
		 AND c.relname = $2
		 AND a.attname = $3
		 AND a.attrelid = c.oid
		 AND s.connamespace = n.oid
		 AND s.conrelid = c.oid
		 AND a.attnum = ANY (s.conkey)
		 AND s.consrc LIKE '%geometrytype(% = %';
$$
LANGUAGE 'sql' STABLE STRICT PARALLEL SAFE COST 250;
CREATE OR REPLACE VIEW geometry_columns AS
SELECT current_database()::character varying(256) AS f_table_catalog,
    n.nspname AS f_table_schema,
    c.relname AS f_table_name,
    a.attname AS f_geometry_column,
    COALESCE(postgis_typmod_dims(a.atttypmod), sn.ndims, 2) AS coord_dimension,
    COALESCE(NULLIF(postgis_typmod_srid(a.atttypmod), 0), sr.srid, 0) AS srid,
    replace(replace(COALESCE(NULLIF(upper(postgis_typmod_type(a.atttypmod)), 'GEOMETRY'::text), st.type, 'GEOMETRY'::text), 'ZM'::text, ''::text), 'Z'::text, ''::text)::character varying(30) AS type
   FROM pg_class c
     JOIN pg_attribute a ON a.attrelid = c.oid AND NOT a.attisdropped
     JOIN pg_namespace n ON c.relnamespace = n.oid
     JOIN pg_type t ON a.atttypid = t.oid
     LEFT JOIN ( SELECT s.connamespace,
            s.conrelid,
            s.conkey,
            (regexp_match(s.consrc, $$geometrytype\(\w+\)\s*=\s*'(\w+)'$$, 'i'))[1]::text AS type
           FROM (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
                FROM pg_constraint) AS s
          WHERE s.consrc ~* $$geometrytype\(\w+\)\s*=\s*'\w+'$$::text

) st ON st.connamespace = n.oid AND st.conrelid = c.oid AND (a.attnum = ANY (st.conkey))
     LEFT JOIN ( SELECT s.connamespace,
            s.conrelid,
            s.conkey,
            (regexp_match(s.consrc, $$ndims\(\w+\)\s*=\s*(\d+)$$, 'i'))[1]::integer AS ndims
           FROM (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
            FROM pg_constraint) AS s
          WHERE s.consrc ~* $$ndims\(\w+\)\s*=\s*\d+$$::text
) sn ON sn.connamespace = n.oid AND sn.conrelid = c.oid AND (a.attnum = ANY (sn.conkey))
     LEFT JOIN ( SELECT s.connamespace,
            s.conrelid,
            s.conkey,
            (regexp_match(s.consrc, $$srid\(\w+\)\s*=\s*(\d+)$$, 'i'))[1]::integer As srid
           FROM (SELECT connamespace, conrelid, conkey, pg_get_constraintdef(oid) As consrc
            FROM pg_constraint) AS s
          WHERE s.consrc ~* $$srid\(\w+\)\s*=\s*\d+$$::text

) sr ON sr.connamespace = n.oid AND sr.conrelid = c.oid AND (a.attnum = ANY (sr.conkey))
  WHERE (c.relkind = ANY (ARRAY['r'::"char", 'v'::"char", 'm'::"char", 'f'::"char", 'p'::"char"]))
  AND NOT c.relname = 'raster_columns'::name AND t.typname = 'geometry'::name
  AND NOT pg_is_other_temp_schema(c.relnamespace) AND has_table_privilege(c.oid, 'SELECT'::text);
CREATE OR REPLACE RULE geometry_columns_insert AS
		ON INSERT TO geometry_columns
		DO INSTEAD NOTHING;
CREATE OR REPLACE RULE geometry_columns_update AS
		ON UPDATE TO geometry_columns
		DO INSTEAD NOTHING;
CREATE OR REPLACE RULE geometry_columns_delete AS
		ON DELETE TO geometry_columns
		DO INSTEAD NOTHING;
CREATE OR REPLACE FUNCTION ST_3DDistance(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_3DDistance'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_3DMaxDistance(geom1 geometry, geom2 geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'LWGEOM_maxdistance3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_3DClosestPoint(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_closestpoint3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_3DShortestLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_shortestline3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_3DLongestLine(geom1 geometry, geom2 geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_longestline3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_CoordDim(Geometry geometry)
	RETURNS smallint
	AS '$libdir/postgis-3', 'LWGEOM_ndims'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 1;
-- Rename st_curvetoline ( geometry, integer ) deprecated in PostGIS 205, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_curvetoline(geometry, integer)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_curvetoline(geometry, integer) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_curvetoline(geometry, integer) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_curvetoline( geometry, integer ) RENAME TO st_curvetoline_deprecated_by_postgis_205;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_curvetoline(geometry, integer) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_curvetoline(geometry, integer) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
-- Rename st_curvetoline ( geometry ) deprecated in PostGIS 205, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = 'st_curvetoline(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_curvetoline(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function st_curvetoline(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION st_curvetoline( geometry ) RENAME TO st_curvetoline_deprecated_by_postgis_205;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function st_curvetoline(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function st_curvetoline(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_CurveToLine(geom geometry, tol float8 DEFAULT 32, toltype integer DEFAULT 0, flags integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CurveToLine'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_HasArc(Geometry geometry)
	RETURNS boolean
	AS '$libdir/postgis-3', 'LWGEOM_has_arc'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LineToCurve(Geometry geometry)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_line_desegmentize'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_NumCurves(Geometry geometry)
	RETURNS integer
	AS '$libdir/postgis-3', 'ST_NumCurves'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_CurveN(Geometry geometry, i integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_CurveN'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION ST_Point(float8, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'LWGEOM_makepoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Point(float8, float8, srid integer)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Point'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointZ(XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_PointZ'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointM(XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_PointM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_PointZM(XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer DEFAULT 0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_PointZM'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Polygon(geometry, int)
	RETURNS geometry
	AS $$
	SELECT @extschema@.ST_SetSRID(@extschema@.ST_MakePolygon($1), $2)
	$$
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_WKBToSQL(WKB bytea)
	RETURNS geometry
	AS '$libdir/postgis-3','LWGEOM_from_WKB'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_LocateBetween(Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_LocateBetween'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LocateAlong(Geometry geometry, Measure float8, LeftRightOffset float8 default 0.0)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_LocateAlong'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_LocateBetweenElevations(Geometry geometry, FromElevation float8, ToElevation float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_LocateBetweenElevations'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_InterpolatePoint(Line geometry, Point geometry)
	RETURNS float8
	AS '$libdir/postgis-3', 'ST_InterpolatePoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Hexagon(size float8, cell_i integer, cell_j integer, origin geometry DEFAULT 'POINT(0 0)')
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Hexagon'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_Square(size float8, cell_i integer, cell_j integer, origin geometry DEFAULT 'POINT(0 0)')
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_Square'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION ST_HexagonGrid(size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)
	RETURNS SETOF record
	AS '$libdir/postgis-3', 'ST_ShapeGrid'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_SquareGrid(size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)
	RETURNS SETOF record
	AS '$libdir/postgis-3', 'ST_ShapeGrid'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION contains_2d(box2df, geometry)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_contains_box2df_geom_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION is_contained_2d(box2df, geometry)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_within_box2df_geom_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION overlaps_2d(box2df, geometry)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_overlaps_box2df_geom_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION overlaps_2d(box2df, box2df)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_contains_box2df_box2df_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION contains_2d(box2df, box2df)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_contains_box2df_box2df_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION is_contained_2d(box2df, box2df)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_contains_box2df_box2df_2d'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
-- Operator box2df ~ geometry -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~' AND
            tl.typname = 'box2df' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~ (
	LEFTARG    = box2df,
	RIGHTARG   = geometry,
	PROCEDURE  = contains_2d,
	COMMUTATOR = @
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator box2df @ geometry -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@' AND
            tl.typname = 'box2df' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR @ (
	LEFTARG    = box2df,
	RIGHTARG   = geometry,
	PROCEDURE  = is_contained_2d,
	COMMUTATOR = ~
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator box2df && geometry -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'box2df' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR && (
	LEFTARG    = box2df,
	RIGHTARG   = geometry,
	PROCEDURE  = overlaps_2d,
	COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION contains_2d(geometry, box2df)
RETURNS boolean
AS
	'SELECT $2 OPERATOR(@extschema@.@) $1;'
LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION is_contained_2d(geometry, box2df)
RETURNS boolean
AS
	'SELECT $2 OPERATOR(@extschema@.~) $1;'
LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION overlaps_2d(geometry, box2df)
RETURNS boolean
AS
	'SELECT $2 OPERATOR(@extschema@.&&) $1;'
LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE COST 1;
-- Operator geometry ~ box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~' AND
            tl.typname = 'geometry' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR ~ (
	LEFTARG = geometry,
	RIGHTARG = box2df,
	COMMUTATOR = @,
	PROCEDURE  = contains_2d
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator geometry @ box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@' AND
            tl.typname = 'geometry' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR @ (
	LEFTARG = geometry,
	RIGHTARG = box2df,
	COMMUTATOR = ~,
	PROCEDURE = is_contained_2d
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator geometry && box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'geometry' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR && (
	LEFTARG    = geometry,
	RIGHTARG   = box2df,
	PROCEDURE  = overlaps_2d,
	COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator box2df && box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&' AND
            tl.typname = 'box2df' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR && (
	LEFTARG   = box2df,
	RIGHTARG  = box2df,
	PROCEDURE = overlaps_2d,
	COMMUTATOR = &&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator box2df @ box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@' AND
            tl.typname = 'box2df' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR @ (
	LEFTARG   = box2df,
	RIGHTARG  = box2df,
	PROCEDURE = is_contained_2d,
	COMMUTATOR = ~
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator box2df ~ box2df -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~' AND
            tl.typname = 'box2df' AND
            tr.typname = 'box2df'
    )
    THEN
CREATE OPERATOR ~ (
	LEFTARG   = box2df,
	RIGHTARG  = box2df,
	PROCEDURE = contains_2d,
	COMMUTATOR = @
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION overlaps_nd(gidx, geometry)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_gidx_geom_overlaps'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION overlaps_nd(gidx, gidx)
RETURNS boolean
AS '$libdir/postgis-3','gserialized_gidx_gidx_overlaps'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE COST 1;
-- Operator gidx &&& geometry -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&&' AND
            tl.typname = 'gidx' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &&& (
	LEFTARG    = gidx,
	RIGHTARG   = geometry,
	PROCEDURE  = overlaps_nd,
	COMMUTATOR = &&&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION overlaps_nd(geometry, gidx)
RETURNS boolean
AS
	'SELECT $2 OPERATOR(@extschema@.&&&) $1;'
LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE COST 1;
-- Operator geometry &&& gidx -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&&' AND
            tl.typname = 'geometry' AND
            tr.typname = 'gidx'
    )
    THEN
CREATE OPERATOR &&& (
	LEFTARG    = geometry,
	RIGHTARG   = gidx,
	PROCEDURE  = overlaps_nd,
	COMMUTATOR = &&&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator gidx &&& gidx -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&&&' AND
            tl.typname = 'gidx' AND
            tr.typname = 'gidx'
    )
    THEN
CREATE OPERATOR &&& (
	LEFTARG   = gidx,
	RIGHTARG  = gidx,
	PROCEDURE = overlaps_nd,
	COMMUTATOR = &&&
);

  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geom2d_brin_inclusion_add_value(internal, internal, internal, internal)
RETURNS boolean
AS '$libdir/postgis-3','geom2d_brin_inclusion_add_value'
LANGUAGE 'c' PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION geom2d_brin_inclusion_merge(internal, internal)
RETURNS internal
AS '$libdir/postgis-3','geom2d_brin_inclusion_merge'
LANGUAGE 'c' PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION geom3d_brin_inclusion_add_value(internal, internal, internal, internal)
RETURNS boolean
AS '$libdir/postgis-3','geom3d_brin_inclusion_add_value'
LANGUAGE 'c' PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION geom3d_brin_inclusion_merge(internal, internal)
RETURNS internal
AS '$libdir/postgis-3','geom3d_brin_inclusion_merge'
LANGUAGE 'c' PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION geom4d_brin_inclusion_add_value(internal, internal, internal, internal)
RETURNS boolean
AS '$libdir/postgis-3','geom4d_brin_inclusion_add_value'
LANGUAGE 'c' PARALLEL SAFE COST 1;
CREATE OR REPLACE FUNCTION geom4d_brin_inclusion_merge(internal, internal)
RETURNS internal
AS '$libdir/postgis-3','geom4d_brin_inclusion_merge'
LANGUAGE 'c' PARALLEL SAFE COST 1;
-- Operator class brin_geometry_inclusion_ops_2d -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 203 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS brin_geometry_inclusion_ops_2d
  DEFAULT FOR TYPE geometry
  USING brin AS
    FUNCTION      1        brin_inclusion_opcinfo(internal),
    FUNCTION      2        geom2d_brin_inclusion_add_value(internal, internal, internal, internal),
    FUNCTION      3        brin_inclusion_consistent(internal, internal, internal),
    FUNCTION      4        brin_inclusion_union(internal, internal, internal),
    FUNCTION      11       geom2d_brin_inclusion_merge(internal, internal),
    OPERATOR      3         &&(box2df, box2df),
    OPERATOR      3         &&(box2df, geometry),
    OPERATOR      3         &&(geometry, box2df),
    OPERATOR      3        &&(geometry, geometry),
    OPERATOR      7         ~(box2df, box2df),
    OPERATOR      7         ~(box2df, geometry),
    OPERATOR      7         ~(geometry, box2df),
    OPERATOR      7        ~(geometry, geometry),
    OPERATOR      8         @(box2df, box2df),
    OPERATOR      8         @(box2df, geometry),
    OPERATOR      8         @(geometry, box2df),
    OPERATOR      8        @(geometry, geometry),
  STORAGE box2df;
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator class brin_geometry_inclusion_ops_3d -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 203 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS brin_geometry_inclusion_ops_3d
  FOR TYPE geometry
  USING brin AS
    FUNCTION      1        brin_inclusion_opcinfo(internal) ,
    FUNCTION      2        geom3d_brin_inclusion_add_value(internal, internal, internal, internal),
    FUNCTION      3        brin_inclusion_consistent(internal, internal, internal),
    FUNCTION      4        brin_inclusion_union(internal, internal, internal),
    FUNCTION      11       geom3d_brin_inclusion_merge(internal, internal),
    OPERATOR      3        &&&(geometry, geometry),
    OPERATOR      3        &&&(geometry, gidx),
    OPERATOR      3        &&&(gidx, geometry),
    OPERATOR      3        &&&(gidx, gidx),
  STORAGE gidx;
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
-- Operator class brin_geometry_inclusion_ops_4d -- LastUpdated: 203
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 203 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS brin_geometry_inclusion_ops_4d
  FOR TYPE geometry
  USING brin AS
    FUNCTION      1        brin_inclusion_opcinfo(internal),
    FUNCTION      2        geom4d_brin_inclusion_add_value(internal, internal, internal, internal),
    FUNCTION      3        brin_inclusion_consistent(internal, internal, internal),
    FUNCTION      4        brin_inclusion_union(internal, internal, internal),
    FUNCTION      11       geom4d_brin_inclusion_merge(internal, internal),
    OPERATOR      3        &&&(geometry, geometry),
    OPERATOR      3        &&&(geometry, gidx),
    OPERATOR      3        &&&(gidx, geometry),
    OPERATOR      3        &&&(gidx, gidx),
  STORAGE gidx;
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 203
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_SimplifyPolygonHull(geom geometry, vertex_fraction float8, is_outer boolean DEFAULT true)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_SimplifyPolygonHull'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 5000;
-- Rename _st_concavehull ( geometry ) deprecated in PostGIS 303, if needed
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
DECLARE
    detail TEXT;
    argnames TEXT[];
BEGIN

    -- Check if the deprecated function exists
    BEGIN

        SELECT proargnames
        FROM pg_catalog.pg_proc
        WHERE oid = '_st_concavehull(geometry)'::regprocedure
        INTO argnames;


    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function _st_concavehull(geometry) does not exist';
        RETURN; -- nothing to do
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Checking if replaced function _st_concavehull(geometry) exists got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

    -- Rename the replaced function, to avoid ambiguities.
    -- The renamed function will eventually be drop.
    BEGIN
        ALTER FUNCTION _st_concavehull( geometry ) RENAME TO _st_concavehull_deprecated_by_postgis_303;
    EXCEPTION
    WHEN undefined_function THEN
        RAISE DEBUG 'Replaced function _st_concavehull(geometry) does not exist';
    WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
        RAISE EXCEPTION 'Attempting to rename replaced function _st_concavehull(geometry) got % (%)', SQLERRM, SQLSTATE
            USING DETAIL = detail;
    END;

END;
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_ConcaveHull(param_geom geometry, param_pctconvex float, param_allow_holes boolean DEFAULT false)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_ConcaveHull'
	LANGUAGE 'c' IMMUTABLE STRICT
	PARALLEL SAFE
	COST 5000;
CREATE OR REPLACE FUNCTION _ST_AsX3D(integer, geometry, integer, integer, text)
	RETURNS TEXT
	AS '$libdir/postgis-3','LWGEOM_asX3D'
	LANGUAGE 'c' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_AsX3D(geom geometry, maxdecimaldigits integer DEFAULT 15, options integer DEFAULT 0)
	RETURNS TEXT
	AS $$SELECT @extschema@._ST_AsX3D(3,$1,$2,$3,'');$$
	LANGUAGE 'sql' IMMUTABLE PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_Angle(line1 geometry, line2 geometry)
	RETURNS float8 AS 'SELECT @extschema@.ST_Angle(@extschema@.St_StartPoint($1), @extschema@.ST_EndPoint($1), @extschema@.ST_StartPoint($2), @extschema@.ST_EndPoint($2))'
	LANGUAGE 'sql' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
GRANT SELECT ON TABLE geography_columns TO public;
GRANT SELECT ON TABLE geometry_columns TO public;
GRANT SELECT ON TABLE spatial_ref_sys TO public;
CREATE OR REPLACE FUNCTION ST_3DLineInterpolatePoint(geometry, float8)
	RETURNS geometry
	AS '$libdir/postgis-3', 'ST_3DLineInterpolatePoint'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 50;
CREATE OR REPLACE FUNCTION geometry_spgist_config_2d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_config_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_choose_2d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_choose_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_picksplit_2d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_picksplit_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_inner_consistent_2d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_inner_consistent_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_leaf_consistent_2d(internal, internal)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_spgist_leaf_consistent_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_compress_2d(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_spgist_compress_2d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
-- Operator class spgist_geometry_ops_2d -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 205 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS spgist_geometry_ops_2d
	DEFAULT FOR TYPE geometry USING SPGIST AS
	OPERATOR        1        <<  ,
	OPERATOR        2        &<	 ,
	OPERATOR        3        &&  ,
	OPERATOR        4        &>	 ,
	OPERATOR        5        >>	 ,
	OPERATOR        6        ~=	 ,
	OPERATOR        7        ~	 ,
	OPERATOR        8        @	 ,
	OPERATOR        9        &<| ,
	OPERATOR        10       <<| ,
	OPERATOR        11       |>> ,
	OPERATOR        12       |&> ,
	FUNCTION		1		geometry_spgist_config_2d(internal, internal),
	FUNCTION		2		geometry_spgist_choose_2d(internal, internal),
	FUNCTION		3		geometry_spgist_picksplit_2d(internal, internal),
	FUNCTION		4		geometry_spgist_inner_consistent_2d(internal, internal),
	FUNCTION		5		geometry_spgist_leaf_consistent_2d(internal, internal),
	FUNCTION		6		geometry_spgist_compress_2d(internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_overlaps_3d(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_overlaps_3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_contains_3d(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_contains_3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_contained_3d(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_contained_3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_same_3d(geom1 geometry, geom2 geometry)
	RETURNS boolean
	AS '$libdir/postgis-3' ,'gserialized_same_3d'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE;
-- Operator geometry &/& geometry -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '&/&' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR &/& (
	PROCEDURE = geometry_overlaps_3d,
	LEFTARG = geometry, RIGHTARG = geometry,
	COMMUTATOR = &/&,
	RESTRICT = gserialized_gist_sel_nd, JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
-- Operator geometry @>> geometry -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '@>>' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR @>> (
	PROCEDURE = geometry_contains_3d,
	LEFTARG = geometry, RIGHTARG = geometry,
	COMMUTATOR = <<@,
	RESTRICT = gserialized_gist_sel_nd, JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
-- Operator geometry <<@ geometry -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '<<@' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR <<@ (
	PROCEDURE = geometry_contained_3d,
	LEFTARG = geometry, RIGHTARG = geometry,
	COMMUTATOR = @>>,
	RESTRICT = gserialized_gist_sel_nd, JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
-- Operator geometry ~== geometry -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN
    IF NOT EXISTS (
        SELECT o.oprname
        FROM
            pg_catalog.pg_operator o,
            pg_catalog.pg_type tl,
            pg_catalog.pg_type tr
        WHERE
            o.oprleft = tl.oid AND
            o.oprright = tr.oid AND
            o.oprcode != 0 AND
            o.oprname = '~==' AND
            tl.typname = 'geometry' AND
            tr.typname = 'geometry'
    )
    THEN
CREATE OPERATOR ~== (
	PROCEDURE = geometry_same_3d,
	LEFTARG = geometry, RIGHTARG = geometry,
	COMMUTATOR = ~==,
	RESTRICT = gserialized_gist_sel_nd, JOIN = gserialized_gist_joinsel_nd
);

  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_spgist_config_3d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3', 'gserialized_spgist_config_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_choose_3d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3', 'gserialized_spgist_choose_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_picksplit_3d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3', 'gserialized_spgist_picksplit_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_inner_consistent_3d(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3', 'gserialized_spgist_inner_consistent_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_leaf_consistent_3d(internal, internal)
	RETURNS bool
	AS '$libdir/postgis-3', 'gserialized_spgist_leaf_consistent_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_compress_3d(internal)
	RETURNS internal
	AS '$libdir/postgis-3', 'gserialized_spgist_compress_3d'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
-- Operator class spgist_geometry_ops_3d -- LastUpdated: 205
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 205 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS spgist_geometry_ops_3d
	FOR TYPE geometry USING SPGIST AS
	OPERATOR        3        &/&	,
	OPERATOR        6        ~==	,
	OPERATOR        7        @>>	,
	OPERATOR        8        <<@	,
	FUNCTION	1	geometry_spgist_config_3d(internal, internal),
	FUNCTION	2	geometry_spgist_choose_3d(internal, internal),
	FUNCTION	3	geometry_spgist_picksplit_3d(internal, internal),
	FUNCTION	4	geometry_spgist_inner_consistent_3d(internal, internal),
	FUNCTION	5	geometry_spgist_leaf_consistent_3d(internal, internal),
	FUNCTION	6	geometry_spgist_compress_3d(internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 205
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geometry_spgist_config_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_config_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_choose_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_choose_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_picksplit_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_picksplit_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_inner_consistent_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_inner_consistent_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_leaf_consistent_nd(internal, internal)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_spgist_leaf_consistent_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geometry_spgist_compress_nd(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_spgist_compress_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
-- Operator class spgist_geometry_ops_nd -- LastUpdated: 300
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 300 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS spgist_geometry_ops_nd
	FOR TYPE geometry USING SPGIST AS
	OPERATOR        3        &&& ,
	OPERATOR        6        ~~=	,
	OPERATOR        7        ~~	,
	OPERATOR        8       @@ 	,
	FUNCTION		1		geometry_spgist_config_nd(internal, internal),
	FUNCTION		2		geometry_spgist_choose_nd(internal, internal),
	FUNCTION		3		geometry_spgist_picksplit_nd(internal, internal),
	FUNCTION		4		geometry_spgist_inner_consistent_nd(internal, internal),
	FUNCTION		5		geometry_spgist_leaf_consistent_nd(internal, internal),
	FUNCTION		6		geometry_spgist_compress_nd(internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 300
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION geography_spgist_config_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_config_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_spgist_choose_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_choose_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_spgist_picksplit_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_picksplit_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_spgist_inner_consistent_nd(internal, internal)
	RETURNS void
	AS '$libdir/postgis-3' ,'gserialized_spgist_inner_consistent_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_spgist_leaf_consistent_nd(internal, internal)
	RETURNS bool
	AS '$libdir/postgis-3' ,'gserialized_spgist_leaf_consistent_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
CREATE OR REPLACE FUNCTION geography_spgist_compress_nd(internal)
	RETURNS internal
	AS '$libdir/postgis-3' ,'gserialized_spgist_compress_nd'
	LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE;
-- Operator class spgist_geography_ops_nd -- LastUpdated: 300
DO LANGUAGE 'plpgsql'
$postgis_proc_upgrade$
BEGIN

  IF 300 > version_from_num FROM _postgis_upgrade_info()
  THEN
    EXECUTE $postgis_proc_upgrade_parsed_def$
    CREATE OPERATOR CLASS spgist_geography_ops_nd
	DEFAULT FOR TYPE geography USING SPGIST AS
	OPERATOR        3        && ,
	FUNCTION		1		geography_spgist_config_nd(internal, internal),
	FUNCTION		2		geography_spgist_choose_nd(internal, internal),
	FUNCTION		3		geography_spgist_picksplit_nd(internal, internal),
	FUNCTION		4		geography_spgist_inner_consistent_nd(internal, internal),
	FUNCTION		5		geography_spgist_leaf_consistent_nd(internal, internal),
	FUNCTION		6		geography_spgist_compress_nd(internal);
    $postgis_proc_upgrade_parsed_def$;
  END IF; -- version_from >= 300
END
$postgis_proc_upgrade$;
CREATE OR REPLACE FUNCTION ST_Letters(letters text, font json DEFAULT NULL)
RETURNS geometry
AS
$$
DECLARE
  letterarray text[];
  letter text;
  geom geometry;
  prevgeom geometry = NULL;
  adjustment float8 = 0.0;
  position float8 = 0.0;
  text_height float8 = 100.0;
  width float8;
  m_width float8;
  spacing float8;
  dist float8;
  wordarr geometry[];
  wordgeom geometry;
  -- geometry has been run through replace(encode(st_astwkb(geom),'base64'), E'\n', '')
  font_default_height float8 = 1000.0;
  font_default json = '{
  "!":"BgACAQhUrgsTFOQCABQAExELiwi5AgAJiggBYQmJCgAOAg4CDAIOBAoEDAYKBgoGCggICAgICAgGCgYKBgoGCgQMBAoECgQMAgoADAIKAAoADAEKAAwBCgMKAQwDCgMKAwoFCAUKBwgHBgcIBwYJBgkECwYJBAsCDQILAg0CDQANAQ0BCwELAwsDCwUJBQkFCQcHBwcHBwcFCQUJBQkFCQMLAwkDCQMLAQkACwEJAAkACwIJAAsCCQQJAgsECQQJBAkGBwYJCAcIBQgHCAUKBQoDDAUKAQwDDgEMAQ4BDg==",
  "&":"BgABAskBygP+BowEAACZAmcAANsCAw0FDwUNBQ0FDQcLBw0HCwcLCQsJCwkLCQkJCwsJCwkLCQ0HCwcNBw8HDQUPBQ8DDwMRAw8DEQERAREBEQERABcAFQIXAhUCEwQVBBMGEwYTBhEIEQgPChEKDwoPDA0MDQwNDgsOCRAJEAkQBxAHEgUSBRQFFAMUAxQBFgEWARgAigEAFAISABICEgQQAhAEEAQQBg4GEAoOCg4MDg4ODgwSDgsMCwoJDAcMBwwFDgUMAw4DDgEOARABDgEQARIBEAASAHgAIAQeBB4GHAgaChoMGA4WDhYQFBISEhISDhQQFAwWDBYKFgoYBhgIGAQYBBgCGgAaABgBGAMYAxYHFgUWCRYJFAsUCxIPEg0SERARDhMOFQwVDBcIGQYbBhsCHQIfAR+dAgAADAAKAQoBCgEIAwgFBgUGBQYHBAUEBwQHAgcCBwIHAAcABwAHAQcBBwMHAwUDBwUFBQUHBQUBBwMJAQkBCQAJAJcBAAUCBQAFAgUEBQIDBAUEAwQDBgMEAQYDBgEGAAgBBgAKSeECAJ8BFi84HUQDQCAAmAKNAQAvExMx",
  "\"":"BgACAQUmwguEAgAAkwSDAgAAlAQBBfACAIACAACTBP8BAACUBA==",
  "''":"BgABAQUmwguEAgAAkwSDAgAAlAQ=",
  "(":"BgABAUOQBNwLDScNKw0rCysLLwsxCTEJMwc1BzcHNwM7AzsDPwE/AEEANwI1AjMEMwIzBjEGLwYvCC0ILQgrCCkKKQonCicMJbkCAAkqCSoHLAksBywFLgcuBS4FMAMwAzADMgEwATQBMgA0ADwCOgI6BDoEOAY4BjYINgg2CjQKMgoyCjIMMAwwDi7AAgA=",
  ")":"BgABAUMQ3Au6AgAOLQwvDC8KMQoxCjEKMwg1CDUGNQY3BDcEOQI5AjkAOwAzATEBMQExAy8DLwMvBS8FLQctBS0HKwktBykJKwkpswIADCYKKAooCioIKggsCC4ILgYwBjAGMgQ0AjQCNAI2ADgAQgFAAz4DPAM8BzgHOAc2CTQJMgsyCzALLg0sDSoNKg==",
  "+":"BgABAQ3IBOwGALcBuAEAANUBtwEAALcB0wEAALgBtwEAANYBuAEAALgB1AEA",
  "/":"BgABAQVCAoIDwAuyAgCFA78LrQIA",
  "4":"BgABAhDkBr4EkgEAEREApwJ/AADxARIR5QIAEhIA9AHdAwAA7ALIA9AG6gIAEREA8QYFqwIAAIIDwwH/AgABxAEA",
  "v":"BgABASDmA5AEPu4CROwBExb6AgAZFdMC0wgUFaECABIU0wLWCBcW+AIAExVE6wEEFQQXBBUEFwQVBBUEFwQVBBUEFwQVBBUEFwQXBBUEFwYA",
  ",":"BgABAWMYpAEADgIOAgwCDgQMBAoGDAYKBgoICAgICAgICAoGCgYKBAoEDAQKBAoCDAIKAgwCCgAKAAwACgEMAQoBCgMMAwoDCgUKBQgFCgUIBwYJCAcGCQYJBAsGCQQLAg0CCwINAg0AAwABAAMAAwADAQMAAwADAAMBBQAFAQcBBwEHAwcBCQMJAQsDCwMLAw0FDQMNBQ8FDwURBxMFEwkTBxcJFwkXswEAIMgBCQYJBgkGBwYJCAcIBQgHCgUKBQoFDAEMAwwBDgEOABA=",
  "-":"BgABAQUq0AMArALEBAAAqwLDBAA=",
  ".":"BgABAWFOrAEADgIOAg4CDgQMBAoGDAYKBgoICAgKCAgIBgoGCgYKBgoEDAQKBAwECgIMAAwCDAAMAAwBCgAMAQoDDAMKAwoDCgUKBQgFCgUIBwgJBgcICQYJBgsGCQQLAg0CDQINAA0ADQENAQ0BCwMNAwkFCwUJBQkHBwcJBwUHBwkFCQUJBQkDCwMJAwsDCQELAAsBCwALAAsCCQALAgkECwQJBAkECQYJBgcGBwgJBgcKBQgHCgUKBQwFCgEOAwwBDgEOAA4=",
  "0":"BgABAoMB+APaCxwAHAEaARoDFgMYBRYFFAcUBxIJEgkQCRALEAsOCwwNDA0MDQoPCg0IDwgPBhEGDwYRBA8EEQIRAhMCEQITABMA4QUAEQETAREBEQMRAxEFEQURBREHDwkPBw8JDwsNCw0LDQ0NDQsNCw8JEQkRCREJEwcTBxUFFQUVAxUDFwEXARkAGQAZAhcCFwQXBBUGEwYTCBMIEQoRCg8KDwoPDA0MDQ4NDgsOCQ4JEAkQBxAHEAUSBRIDEgMSAxIDEgESARQAEgDiBQASAhQCEgISBBIEEgYSBhIGEggQChAIEAoQDBAMDgwODg4ODA4MEgwQChIKEggUCBQIFgYWBBYGGAQYAhgCGgILZIcDHTZBEkMRHTUA4QUeOUITRBIePADiBQ==",
  "2":"BgABAWpUwALUA44GAAoBCAEKAQgDBgMGBQYFBgUEBwQFBAUCBwIHAgUABwAHAAUBBwMFAQcFBQMHBQUHBQcFBwMJAwkBCQELAQsAC68CAAAUAhIAFAISBBQCEgQUBBIEEgYUCBIGEAgSChAKEAoQDBAMDg4ODgwQDBIMEgoSChQIFggWCBgGGAQaAhwCHAIWABQBFgEUARQDFAMSAxQFEgUSBxIHEAkQCRALDgsODQ4NDA8KDwwRCBMKEwgTBhUGFwQXBBcEGwAbABsAHQEftwPJBdIDAACpAhIPzwYAFBIArgI=",
  "1":"BgABARCsBLALAJ0LEhERADcA2QEANwATABQSAOYIpwEAALgCERKEBAASABER",
  "3":"BgABAZ0B/gbEC/sB0QQOAwwBDAMMAwwFCgMKBQoFCgUIBwoFCAcICQgJBgkICQYLCAsECwYLBA0GDwINBA8CDwQRAhECEQITABUCFQAVAH0AEQETAREBEQETAxEDEQURBREFDwcRBw8JDwkNCQ8LDQsNDQsNCw0LDwsPCREJEQcRBxMFFQUVBRUDFwEXARkAGQAZAhkCFwQVBBUEEwYTCBEIEQgRCg0MDwoNDA0OCw4LDgkQCRAHEAkQBRAFEgUSAxIDFAMSAxYBFAEWARYAFqQCAAALAgkCCQQHAgcGBwYHBgUIBQYDCAMIAwYDCAEIAQgACAAIAAgCCAIIAgYCCAQIBAgGBgYEBgQIBAoCCgAKAAwAvAEABgEIAAYBBgMGAwQDBgMEBQQDBAUCBQQFAgUABwIFAJkBAACmAaIB3ALbAgAREQDmAhIRggYA",
  "5":"BgABAaAB0APgBxIAFAESABIBEgMSARADEgMQAxIFEAcOBRAHDgkOCQ4JDgsMCwwLCgsKDQoPCA0IDwgPBhEEEwYTAhMEFwIXABcAiQIAEwETABEBEQMTAxEDDwMRBQ8FDwUPBw8JDQcNCQ0LDQsLCwsNCw0JDwkPCREHEQcTBxMFEwMVAxcDGQEZARkAFwAVAhUCFQQTBBMGEwYRCBEIDwoPCg8KDQwNDA0MCw4LDgkOCRAJEAcOBxAHEgUQBRIDEAMSAxIBEgEUARIAFLgCAAAFAgUABQIFBAUCBQQDBAUEAwYDBgMIAwgBCAEIAQoACAAIAgYACAQGAgQEBgQEBAQGBAQCBgIGAgYCBgIIAAYA4AEABgEIAAYBBgMGAQQDBgMEAwQFBAMCBQQFAgUABwIFAPkBAG+OAQCCBRESAgAAAuYFABMRAK8CjQMAAJ8BNgA=",
  "7":"BgABAQrQBsILhQOvCxQR7wIAEhK+AvYIiwMAAKgCERKwBgA=",
  "6":"BgABAsYBnAOqBxgGFgYYBBYEFgIWABQBFgEUAxQDFAUUBRIFEAcSCRAJEAkOCw4NDgsMDQoPCg8KDwgRCBEGEQYRBBMCEwITAhUAkwIBAAERAREBEQEPAxEFEQMPBREFDwcPBw8HDwkNCQ0LDQsNCwsNCw0LDQkPCQ8JDwcRBxEHEwUTAxMFFQEXAxcBGQAVABUCEwIVBBMEEQYTBhEIEQgPChEKDQoPDA0MDQwNDgsOCxALDgkQCRAHEgcQBxIFEgUSBRIBFAMSARIBFAASAOIFABACEgIQAhIEEAQQBhIGEAYQCBAKEAgOChAMDgwMDA4ODA4MDgwODBAKEAoQChIIEggSBhQGFgYUAhYCGAIYABoAGAEYARYBFgMUBRQFEgUSBxAHEAcQCQ4LDgkMCwwNDA0KDQgPCg0GEQgPBhEEEQQRBBMEEwITAhMCFQIVABWrAgAACgEIAQoBCAEGAwYDBgUGBQQFBAUEBQQFAgUABwIFAAUABwEFAAUBBQMFAwUDBQMFBQMFAwUBBQEHAQkBBwAJAJcBDUbpBDASFi4A4AETLC8SBQAvERUrAN8BFC0yEQQA",
  "8":"BgABA9gB6gPYCxYAFAEUARYBEgMUBRQFEgUSBxIHEAcSCQ4JEAkOCw4LDgsMDQwNCg0KDQoPCg8IDwgPBhEGEQQPBBMCEQIRABMAQwAxAA8BEQEPAREDDwMRAw8FEQUPBxEJDwkPCQ8NDw0PDQ8IBwYHCAcGBwgHBgkGBwYJBgcECQYJBAkGCQQJBAsECwQLBA0CCwINAg8CDwIPAA8AaQATAREBEwERAxEFEQURBREHEQcPBw8JDwkPCw8LDQsNDQ0LCw0LDwsNCQ8JDwcPBw8HEQURAxEFEQMRARMBEwFDABEAEwIRAhEEEQQRBg8GEQgPCA8KDwoPCg0MDQwNDAsOCw4LDgkQCRAJDgkQBxIHEAcSBRADEgMUAxIBFAEUABQAagAOAhAADgIOAg4EDAIOBAwEDAQMBgwECgYMBAoGCAYKBgoGCggKBgoICgYICAoICA0MCwwLDgsOCRAHEAcQBxIFEgUSAxIDEgMSARABEgASADIARAASAhICEgQSAhIGEAYSBhAIEAgQCBAKDgoODA4MDgwMDgwODA4KEAwQCBIKEggSCBQIFAYUBBQEFgQWAhYCGAANT78EFis0EwYANBIYLgC0ARcsMRQFADERGS0AswELogHtAhcuNxA3DRkvALMBGjE6ETYSGDIAtAE=",
  "9":"BgABAsYBpASeBBcFFQUXAxUDFQEVABMCFQITBBMEEwYRBhMGDwgRCg8KDwoNDA0OCwwNDgkQCRAJEAcSBxIFEgUSAxQBFAEUARYAlAICAAISAhICEgQSAhAGEgQQBhIGEAgSCA4IEAoOChAMDAwODAwODA4MEAoOChAKEAgSCBIIFAYUBBQGFgIYBBgCGgAWABYBFAEWAxQDEgUUBRIHEgcQCRIJEAkOCw4LDgsODQwNDA0MDwoPCg8IDwgRCBEGEQYRBhEEEQITAhECEwARAOEFAA8BEQEPAREDDwMPBREFDwUPBw8JDwcNCQ8LDQsLCw0NCw0LDQsNCw8JEQkPCREHEQcTBRMFEwUTARUBFQEXABkAFwIXAhcCFQQTBhMGEQYRCA8IDwgNCg8MCwoLDAsOCQ4JDgkQBxAHEAUQBRIFEgMSAxQDFAEUAxQAFgEWABamAgAACwIJAgkCCQIHBAcEBwYFBgUGAwYDBgMGAQgBBgEIAAgABgIIAgYCBgQGBAYEBgYGBgQIBAgECAIKAgoCCgAMAJgBDUXqBC8RFS0A3wEUKzARBgAwEhYsAOABEy4xEgMA",
  ":":"BgACAWE0rAEADgIOAg4CDgQMBAoGDAYKBgoICAgKCAgIBgoGCgYKBgoEDAQKBAwECgIMAAwCDAAMAAwBCgAMAQoDDAMKAwoDCgUKBQgFCgUIBwgJBgcICQYJBgsGCQQLAg0CDQINAA0ADQENAQ0BCwMNAwkFCwUJBQkHBwcJBwUHBwkFCQUJBQkDCwMJAwsDCQELAAsBCwALAAsCCQALAgkECwQJBAkECQYJBgcGBwgJBgcKBQgHCgUKBQwFCgEOAwwBDgEOAA4BYQDqBAAOAg4CDgIOBAwECgYMBgoGCggICAoICAgGCgYKBgoGCgQMBAoEDAQKAgwADAIMAAwADAEKAAwBCgMMAwoDCgMKBQoFCAUKBQgHCAkGBwgJBgkGCwYJBAsCDQINAg0ADQANAQ0BDQELAw0DCQULBQkFCQcHBwkHBQcHCQUJBQkFCQMLAwkDCwEJAwsACwELAAsACwIJAAsECQILBAkECQQJBgkGBwYHCAkGBwoFCAcKBQoFDAUKAQ4DDAEOAQ4ADg==",
  "x":"BgABARHmAoAJMIMBNLUBNrYBMIQB1AIA9QG/BI4CvwTVAgA5hgFBwAFFxwE1fdUCAI4CwATzAcAE1AIA",
  ";":"BgACAWEslgYADgIOAg4CDgQMBAoGDAYKBgoICAgKCAgIBgoGCgYKBgoEDAQKBAwECgIMAAwCDAAMAAwBCgAMAQoDDAMKAwoDCgUKBQgFCgUIBwgJBgcICQYJBgsGCQQLAg0CDQINAA0ADQENAQ0BCwMNAwkFCwUJBQkHBwcJBwUHBwkFCQUJBQkDCwMJAwsBCQMLAAsBCwALAAsCCQALBAkCCwQJBAkECQYJBgcGBwgJBgcKBQgHCgUKBQwFCgEOAwwBDgEOAA4BYwjxBAAOAg4CDAIOBAwECgYMBgoGCggICAgICAgICgYKBgoECgQMBAoECgIMAgoCDAIKAAoADAAKAQwBCgEKAwwDCgMKBQoFCAUKBQgHBgkIBwYJBgkECwYJBAsCDQILAg0CDQADAAEAAwADAAMBAwADAAMAAwEFAAUBBwEHAQcDBwEJAwkBCwMLAwsDDQUNAw0FDwUPBREHEwUTCRMHFwkXCRezAQAgyAEJBgkGCQYHBgkIBwgFCAcKBQoFCgUMAQwDDAEOAQ4AEA==",
  "=":"BgACAQUawAUA5gHEBAAA5QHDBAABBQC5AgDsAcQEAADrAcMEAA==",
  "B":"BgABA2e2BMQLFgAUARQBFAEUAxIDEgUSBRIFEAcQBxAJDgkOCQ4LDgsMCwwNDA0KDQgNCg0IDwYPBg8GDwQRBBEEEQIRAhMAEwAHAAkABwEHAAkBCQAHAQkBCQEHAQkBCQMJAwcDCQMJAwkFBwUJAwkHCQUHBQkHCQcJBwcHBwkHBwcJBwsHCQUQBQ4FDgcOCQ4JDAkMCwoNCg0IDwgRBhMEFQQXAhcCGwDJAQEvAysFJwklDSMPHREbFRkXFRsTHw8fCyUJJwcrAy0B6wMAEhIAoAsREuYDAAiRAYEElgEAKioSSA1EOR6JAQAA0wEJkAGPBSwSEiwAzAETKikSjwEAAMUCkAEA",
  "A":"BgABAg/KBfIBqQIAN98BEhHzAgAWEuwCngsREvwCABMR8gKdCxIR8QIAFBI54AEFlwGCBk3TA6ABAE3UAwMA",
  "?":"BgACAe4BsgaYCAAZABkBFwEXBRUDEwUTBxEHEQcPCQ8JDQkNCQ0LCwsLCwsLCQsJCwcNBwsHDQcLBQsFDQULAwkFCwMLAwkDCQMBAAABAQABAAEBAQABAAEAAQABAAABAQAAAQEAEwcBAQABAAMBAwADAAUABQAFAAcABwAFAAcABwAFAgcABQAHAAUAW7cCAABcABgBFgAUAhQAFAISAhACEAIQBA4EDgQMBgwGDAYMBgoICgYKCAgKCggICAgKBgoICgYMCAwGDAgOBg4GEAYQBgIAAgIEAAICBAACAgQCBAIKBAoGCAQKBggIBgYICAYIBggGCgQIBAoECAQKAggCCgIKAAgACgAKAAgBCAEKAwgDCAMIAwgFBgMIBQYHBAUGBQQFBAcCBQQHAgcCCQIHAgkCBwAJAgkACQAJAAkBCQAJAQsACQELAQsDCwELAwsDCwMLAwsDCwULAwsFCwMLBV2YAgYECAQKBAwGDAQMBhAIEAYSBhIIEgYUBhIEFgYUBBYEFgQWAhgCFgIYABYAGAAYARgBGAMWBRYHFgcWCRYLFA0IBQYDCAUIBwYFCAcGBwgHBgcICQYJCAkGCQYJCAsGCwYLBgsGDQYNBA0GDQQNBA8EDwQPAg8EEQIRAhEAEQITAWGpBesGAA4CDgIOAg4EDAQKBgwGCgYKCAgICggICAYKBgoGCgYKBAwECgQMBAoCDAAMAgwADAAMAQoADAEKAwwDCgMKAwoFCgUIBQoFCAcICQYHCAkGCQYLBgkECwINAg0CDQANAA0BDQENAQsDDQMJBQsFCQUJBwcHCQcFBwcJBQkFCQUJAwsDCQMLAwkBCwALAQsACwALAgkACwIJBAsECQQJBAkGCQYHBgcICQYHCgUIBwoFCgUMBQoBDgMMAQ4BDgAO",
  "C":"BgABAWmmA4ADAAUCBQAFAgUEBQIDBAUEAwQDBgMEAQYDBgEGAAgBBgDWAgAAwQLVAgATABMCEQITBBEEEQQRBhEIEQgPCA8KDwoNCg0MDQwNDAsOCw4LDgkOCxAHEAkQBxIHEgUSBRIDEgEUARIBFAAUAMIFABQCFAISBBQEEgQSBhIIEggSCBAKEAoQCg4MDgwODA4ODA4MDgwQDA4KEggQChIIEggSBhIGFAQSAhQCEgIUAMYCAADBAsUCAAUABwEFAAUBBQMDAQUDAwMDAwMFAQMDBQEFAAUBBwAFAMEF",
  "L":"BgABAQmcBhISEdkFABIQALQLwgIAAIEJ9AIAAK8C",
  "D":"BgABAkeyBMQLFAAUARIBFAESAxIDEgMSBRIFEAcQBxAHDgkOCQ4LDgsMCwwNDA0KDwoPCg8IDwgRCBEGEwQTBBMEEwIVAhUAFwDBBQAXARcBFwMTAxUDEwUTBxEHEQcPCQ8JDwkNCw0LCwsLDQsNCQ0JDQcPBw8HDwcRBREFEQMRAxEDEwERARMBEwDfAwASEgCgCxES4AMACT6BAxEuKxKLAQAAvwaMAQAsEhIsAMIF",
  "F":"BgABARGABoIJ2QIAAIECsgIAEhIA4QIRErECAACvBBIR5QIAEhIAsgucBQASEgDlAhES",
  "E":"BgABARRkxAuWBQAQEgDlAhES0QIAAP0BtgIAEhIA5wIRFLUCAAD/AfACABISAOUCERLDBQASEgCyCw==",
  "G":"BgABAZsBjgeIAgMNBQ8FDQUNBQ0HCwcNBwsHCwkLCQsJCwsJCwsLCQsJDQkLBw0HDwcNBw8FDwUPAw8DEQMPAxEBEQERARMBEQAXABUCFwIVAhMEFQQTBhMGEwYRCBEIDwoRCg8KDwwNDA0MDQ4LDgkQCRAJEAcQBxIFEgUUBRQDFAMUARYBFgEYAMoFABQCFAASBBQCEgQSBBIEEgYSBhAGEAgQCBAKDgoOCg4MDgwMDgwOChAKEAoSCBIIFAgUBhQEGAYWAhgEGAIaAOoCAAC3AukCAAcABwEFAQUBBQMFAwMFAwUDBQEFAQcBBQEFAQUABwAFAMUFAAUCBwIFAgUCBQQFBAMGBQYDBgUGAwgDBgMIAQgDCAEIAQoBCAEIAAgACgAIAAgCCAIIAggECgQGBAgECAYIBgC6AnEAAJwCmAMAAJcF",
  "H":"BgABARbSB7ILAQAAnwsSEeUCABISAOAE5QEAAN8EEhHlAgASEgCiCxEQ5gIAEREA/QPmAQAAgAQPEOYCABER",
  "I":"BgABAQmuA7ILAJ8LFBHtAgAUEgCgCxMS7gIAExE=",
  "J":"BgABAWuqB7ILALEIABEBEwERAREDEwMRAxEFEQURBw8HEQcPCQ0LDwsNCw0NDQ0LDwsPCxEJEQkTCRMJFQcVBxcFFwMZAxsBGwEbAB8AHQIbAhsEGQYXBhcGFQgTCBMKEwoRDA8KDwwNDA0OCw4LDgkQCRAJEAcQBRIFEgUSAxQDEgESARIBFAESABIAgAEREtoCABERAn8ACQIHBAcEBwYHBgUIBQoDCgMKAwoDDAEKAQwBCgEMAAwACgAMAgoCDAIKBAoECgYKBggGBgYGCAQGBAgCCgAIALIIERLmAgAREQ==",
  "M":"BgACAQRm1gsUABMAAAABE5wIAQDBCxIR5QIAEhIA6gIK5gLVAe0B1wHuAQztAgDhAhIR5QIAEhIAxAsUAPoDtwT4A7YEFgA=",
  "K":"BgABAVXMCRoLBQsDCQMLAwsDCwMLAwsBCwELAQsBCwELAQ0ACwELAAsADQALAg0ACwILAA0CCwILAgsCDQQLBAsECwYNBAsGCwYLCAsGCwgJCgsICQoJCgkMCQwJDAkOCRALEAkQCRKZAdICUQAAiwQSEecCABQSAKALExLoAgAREQC3BEIA+AG4BAEAERKCAwAREdkCzQXGAYUDCA0KDQgJCgkMBwoFDAUMAQwBDgAMAg4CDAQOBAwGDghmlQI=",
  "O":"BgABAoMBsATaCxwAHAEaARoDGgMYBRYFFgcWBxQJEgkSCRILEAsODQ4NDg0MDwoNDA8KDwgPCBEIDwYRBg8GEQQRAhMCEQITABMA0QUAEQETAREBEQMTBREFEQURBxEHDwcRCQ8LDQsPCw0NDQ0NDwsPCw8LEQkTCRMJEwkVBxUHFwUXAxkDGQEbARsAGwAZAhkCGQQXBhcGFQYVCBUIEwoRChEMEQoRDA8MDQ4NDg0OCxAJEAsQCRAHEgcSBxIFFAMSAxIDEgEUARIAEgDSBQASAhQCEgISBBIEEgYSBhIIEggQCBAKEgwODBAMEA4ODg4QDhIMEAwSChQKFAgUCBYIFgYYBBoGGgQcAh4CHgILggGLAylCWxZbFSlBANEFKklcGVwYKkwA0gU=",
  "N":"BgABAQ+YA/oEAOUEEhHVAgASEgC+CxQAwATnBQDIBRMS2AIAExEAzQsRAL8ElgU=",
  "P":"BgABAkqoB5AGABcBFQEVAxMDEwMTBREHEQcRBw8JDwkNCQ0LDQsNCwsNCw0JDQkNCQ8HDwcPBxEFEQURAxEDEQMTAREBEwETAH8AAIMDEhHlAgASEgCgCxES1AMAFAAUARIAFAESAxIDEgMSAxIFEAUQBRAHDgkOCQ4JDgsMCwwNDA0KDQoNCg8IDwgRCBEGEwQTBBUEFQIXAhkAGQCzAgnBAsoCESwrEn8AANUDgAEALBISLgDYAg==",
  "R":"BgABAj9msgsREvYDABQAFAESARQBEgESAxIDEgUSBRAFEAcQBw4JDgkOCQ4LDAsMDQwLCg0KDwoNCA8IDwgPBhEEEwYTAhMEFQIXABcAowIAEwEVARMDEwMTBRMFEQcTBxELEQsRDQ8PDREPEQ0VC8QB/QMSEfkCABQSiQGyA3EAALEDFBHnAgASEgCgCwnCAscFogEALhISLACqAhEsLRKhAQAApQM=",
  "Q":"BgABA4YBvAniAbkB8wGZAYABBQUFAwUFBQUHBQUDBwUFBQcFBQMHBQcDBwUJAwcDCQMJAwkDCQMJAQsDCwMLAQsDCwENAw0BDQEPAA8BDwAPABsAGwIZAhcEGQQXBBUGFQgVCBMIEQoTChEKDwwPDA8ODQ4NDgsQCxAJEAkQBxIHEgUSBRQFFAMUARQDFAEWABYAxgUAEgIUAhICEgQSBBIGEgYSCBIIEAgQChIMDgwQDBAODg4OEA4SDBAMEgoUChQIFAgWCBYGGAQaBhoEHAIeAh4CHAAcARoBGgMaAxgFFgUWBxYHFAkSCRIJEgsQCw4NDg0ODQwPCg0MDwoPCA8IEQgPBhEGDwYRBBECEwIRAhMAEwC7BdgBrwEImQSyAwC6AylAWxZbFSk/AP0BjAK7AQeLAoMCGEc4J0wHVBbvAaYBAEM=",
  "S":"BgABAYMC8gOEBxIFEgUQBxIFEgcSBxIJEgcSCRIJEAkQCRALEAsOCw4NDg0MDQ4PDA0KEQoPChEKEQgRCBMGFQQTBBcCFQAXABkBEwARAREBEQMPAQ8DDwMPAw0DDQUNAw0FCwULBwsFCwUJBwsFCQcHBQkHCQUHBwcHBwUHBwUFBQcHBwUHAwcFEQsRCxMJEwkTBxMFEwUVBRUDFQMVARMBFwEVABUAFQIVAhUCFQQVBBUEEwYVBhMIEwgTCBMIEwgRCBMKEQgRCmK6AgwFDgUMAw4FEAUOBRAFEAUQBRAFEAMSAw4DEAMQAxABEAEOAQ4AEAIMAg4CDgQMBAwGCggKCAoKBgwGDgYQBBACCgAMAAoBCAMKBQgFCAcIBwgJCAsGCQgLCA0IDQgNCA8IDQgPCA8IDwgPChEIDwgPCBEKDwoPDBEMDwwPDg8ODw4NEA0QCxALEgsSCRIHEgcUBRQFGAUYAxgBGgEcAR4CJAYkBiAIIAweDBwQHBAYEhgUFBYUFhQWEBoQGg4aDBwKHAoeBh4GIAQgAiACIgEiASIFIgUiBSAJIgkgCyINZ58CBwQJAgkECwQLAgsECwINBA0CDQQNAg0CDQALAg0ADQANAAsBCwELAQsDCwULBQkFCQcHBwcJBwkFCwMLAw0BDQENAAsCCwQLBAkGCQgJCAkKBwoJCgcMBQoHDAcMBQwF",
  "V":"BgABARG2BM4DXrYEbKwDERL0AgAVEesCnQsSEfsCABQS8QKeCxES8gIAExFuqwNgtQQEAA==",
  "T":"BgABAQskxAv0BgAAtQKVAgAA+wgSEeUCABISAPwImwIAALYC",
  "U":"BgABAW76B7ALAKMIABcBFwMXARUFFQUTBxMHEwkRCREJEQsPDQ0LDw0NDwsPCw8LEQkPCRMJEQcTBxMFEwUVBRUDEwMXARUBFQEXABUAEwIVAhMCFQQTBBUEEwYTBhMIEwgRChEIEQwRDA8MDw4PDg0OCxANEAsSCRIJEgcUBxQHFAMWBRYBGAEYARgApggBAREU9AIAExMAAgClCAALAgkECQQHBAcIBwgHCAUKBQoDCgMKAwwBCgEMAQwADAAMAgoCDAIKAgoECgQKBggGCAYICAYKBAgCCgIMAgwApggAARMU9AIAExM=",
  "X":"BgABARmsCBISEYkDABQSS54BWYICXYkCRZUBEhGJAwAUEtYCzgXVAtIFExKIAwATEVClAVj3AVb0AVKqAREShgMAERHXAtEF2ALNBQ==",
  "W":"BgABARuODcQLERHpAp8LFBHlAgASEnW8A2+7AxIR6wIAFBKNA6ALERKSAwATEdQB7wZigARZ8AIREugCAA8RaKsDYsMDXsoDaqYDExLqAgA=",
  "Y":"BgABARK4BcQLhgMAERHnAvMGAKsEEhHnAgAUEgCsBOkC9AYREoYDABERWOEBUJsCUqICVtwBERI=",
  "Z":"BgABAQmAB8QLnwOBCaADAADBAusGAMgDggmhAwAAwgLGBgA=",
  "`":"BgABAQfqAd4JkQHmAQAOlgJCiAGpAgALiwIA",
  "c":"BgABAW3UA84GBQAFAQUABQEFAwMBBQMDAwMDAwUBAwMFAQUABQEHAAUAnQMABQIFAAUCBQQFAgMEBQQDBAMGAwQBBgMGAQYABgEGAPABABoMAMsCGw7tAQATABMCEwARAhMEEQIPBBEEDwQPBg8IDwYNCA0KDQoNCgsMCwwLDAkOCRAHDgcQBxIFEgUUBRQDFAEWAxgBGAAYAKQDABQCFAISBBQCEgYSBhAGEggQCBAIEAoQCg4MDAwODAwODAwKDgwQCg4IEAgQCBAIEAYSBhIGEgQSAhQCFAIUAOABABwOAM0CGQzbAQA=",
  "a":"BgABApoB8AYCxwF+BwkHCQcJCQkHBwkHBwcJBQkFBwUJBQkFCQMHBQkDCQMJAwcDCQEHAQkBBwEJAQcABwAHAQcABQAHAAUBBQAFABMAEwITAhEEEwQPBBEGDwgPCA0IDwoLCg0KCwwLDAsMCQ4JDgkOBw4HEAcQBRAFEAUSAxADEgESAxIBFAESABQAFAISAhQCEgQSBBIEEgYSBhIIEAgQChAIDgwODA4MDg4MDgwODBAMEAoSCBIKEggUCBQGFgYWBBgEGAIaAhoAcgAADgEMAQoBCgEIAwgDBgUEBQQFBAcCBwIHAgkCCQAJAKsCABcPAMwCHAvCAgAUABYBEgAUARIDFAMQAxIDEAUSBQ4FEAcOCRAJDAkOCwwLDA0MCwoNCg8IDwgPCA8GEQYRBhMEEwIXAhUCFwAZAIMGFwAKmQLqA38ATxchQwgnGiMwD1AMUDYAdg==",
  "b":"BgABAkqmBIIJGAAYARYBFgEUAxQDEgUSBRIFEAcQCQ4HDgkOCw4LDAsMDQoNCg0KDQgPBg8GDwYRBBEEEQQTBBECEwIVAhMAFQD/AgAZARcBFwEXAxUDEwUTBREFEQcPBw8JDwkNCQ0LDQsLCwsNCQ0JDQcPBw8HDwURAxEDEQMTAxMBEwMVARUAFQHPAwAUEgCWCxEY5gIAERkAowKCAQAJOvECESwrEn8AAJsEgAEALBISLgCeAw==",
  "d":"BgABAkryBgDLAXAREQ8NEQ0PDREJDwkRBw8FDwURAw8DDwERAw8BEQEPACMCHwQfCB0MGw4bEhcUFxgVGhEeDSANJAkmBSgDKgEuAIADABYCFAIUAhQCFAQUBBIGEgYSBhAIEAgQCBAKDgoODAwMDAwMDgoOCg4KEAgQCBIGEgYSBhQEFgQWBBYCGAIYAHwAAKQCERrmAgARFwCnCxcADOsCugJGMgDmA3sAKxERLQCfAwolHBUmBSQKBAA=",
  "e":"BgABAqMBigP+AgAJAgkCCQQHBAcGBwYFCAUIBQgDCgMIAQoDCAEKAQoACgAKAAoCCAIKAggECgQIBAgGCAYGBgQIBAoECAIKAAyiAgAAGQEXARcBFwMVBRMFEwURBxEHDwcPCQ8LDQkNCwsNCw0LDQkNBw8JDwcPBQ8FEQURAxEDEwMTAxMBFQAVARcALwIrBCkIJwwlDiESHxQbGBkaFR4TIA0iCyQJKAMqASwAggMAFAIUABIEFAISBBIEEgQSBhIGEAgQCBAIEAoODA4MDgwODgwQDBAKEAoSChIIFAgUCBYGGAQYBhoCGgQcAh4ALgEqAygFJgkkDSANHhEaFRgXFBsSHQ4fDCUIJwQpAi0AGQEXAxcDFQcTBRMJEQkPCw8LDQ0PDQsNDQ8LEQsRCxEJEwkTCRMJEwcTBxUHFQUVBRUHFQUVBRUHFwcVBRUHCs4BkAMfOEUURxEfMwBvbBhAGBwaBiA=",
  "h":"BgABAUHYBJAGAAYBBgAGAQYDBgEEAwYDBAMEBQQDAgUEBQIFAAUCBQB1AAC5BhIT5wIAFhQAlAsRGOYCABEZAKMCeAAYABgBFgEWARQDFAMSBRIFEgUQBxAJDgcOCQ4LDgsMCwwNCg0KDQoNCA8GDwYPBhEEEQQRBBMEEQITAhUCEwAVAO0FFhPnAgAUEgD+BQ==",
  "g":"BgABArkBkAeACQCNCw8ZERkRFxEVExMVERUPFQ8XDRcLGQkZBxsFGwUdAR0BDQALAA0ADQINAAsCDQANAg0CDQILAg0EDQINBA0GDQQNBg0EDQYNCA0GDwgNCA0IDQgPCg0KDwwNDA8MDw4PDqIB7gEQDRALEAkQCQ4JEAcOBw4FDgUOAwwFDgMMAQwBDAEMAQwACgEKAAoACAIIAAgCCAIGAggCBgIGBAYCBgQEAgYEAqIBAQADAAEBAwADAAMABQADAAUAAwAFAAMABQAFAAMABQA3ABMAEwIRAhMCEQQRBBEEEQYRBg8IDwgPCA0KDQoNCg0MCwwLDgsOCQ4JDgkQBxAHEgcSBRIDFAMWAxQBFgEYABgA/gIAFgIWAhQEFgQUBBIGFAgSCBIIEAoSChAKDgwODA4MDg4MDgwODA4KEAgQCBAIEgYSBhIEEgYSBBQCEgIUAhQCOgAQABABDgEQAQ4BEAMOAw4FDgUOBQwFDgcMBQ4HDAkMB4oBUBgACbsCzQYAnAR/AC0RES0AnQMSKy4RgAEA",
  "f":"BgABAUH8A6QJBwAHAAUABwEFAQcBBQEFAwUDBQMDAwMDAwUDAwMFAQUAwQHCAQAWEgDZAhUUwQEAAOMEFhftAgAWFADKCQoSChIKEAoQCg4KDgwOCgwMDAoKDAwMCgwIDAgMCAwIDAYOCAwEDgYMBA4GDAIOBA4CDgQOAg4CDgAOAg4ADgC2AQAcDgDRAhkQowEA",
  "i":"BgACAQlQABISALoIERLqAgAREQC5CBIR6QIAAWELyAoADgIOAgwEDgIKBgwGCgYKCAoGCAgICggIBggGCgYKBAoECgQMBAoCDAIMAgwCDAAMAAwADAEMAQoBDAMKAwoDCgUKBQgFCgUIBwgHCAcICQgJBgkECwQJBA0CCwANAA0ADQELAQ0BCwMJBQsFCQUJBwkFBwcHBwcJBQcFCQUJBQkDCQMLAwkBCwELAQsACwALAAsCCwILAgkCCwIJBAkECQQJBgcGCQYHCAcIBwgHCgUKBQwFCgMMAQwBDgEMAA4=",
  "j":"BgACAWFKyAoADgIOAgwEDgIKBgwGCgYKCAoGCAgICggIBggGCgYKBAoECgQMBAoCDAIMAgwCDAAMAAwADAEMAQoBDAMKAwoDCgUKBQgFCgUIBwgHCAcICQgJBgkECwQJBA0CCwANAA0ADQELAQ0BCwMJBQsFCQUJBwkFBwcHBwcJBQcFCQUJBQkDCQMLAwkBCwELAQsACwALAAsCCwILAgkCCwIJBAkECQQJBgcGCQYHCAcIBwgHCgUKBQwFCgMMAQwBDgEMAA4BO+YCnwwJEQkRCQ8JDwsNCQ0LDQkLCwsJCQsLCQkLBwsHCwcLBwsFCwcNAwsFDQMLBQ0BDQMNAQ0DDQENAQ0ADQENAA0AVwAbDQDSAhoPQgAIAAgABgAIAgYCCAIGAgYEBgQGBAQEBAQEBgQEBAYCBgC4CRES6gIAEREAowo=",
  "k":"BgABARKoA/QFIAC0AYoD5gIAjwK5BJICwwTfAgDDAbIDFwAAnwMSEeUCABISAJILERLmAgAREQCvBQ==",
  "n":"BgABAW1yggmQAU8GBAgEBgQGBgYCCAQGBAYEBgQIAgYECAQGAggEBgIIBAgCCAQIAggCCAIIAgoACAIKAAgCCgAKAgoADAAKAgwAFgAWARQAFAEUAxQDFAMSAxIFEgUQBRIHEAkOBxAJDgsOCwwLDA0MDQoPCA8IEQgRBhEGEwYVBBUEFQIXAhkCGQDtBRQR5QIAFBAA/AUACAEIAQYBCAMGBQQFBgUEBwQFBAcCBwIHAgcCCQIHAAcACQAHAQcABwMHAQUDBwMFAwUFBQUDBQEFAwcBBwAHAPkFEhHjAgASEgDwCBAA",
  "m":"BgABAZoBfoIJigFbDAwMCg4KDggOCA4IDgYQBhAGEAQQBBAEEAISAhACEgAmASQDJAciCyANHhEcFRwXDg4QDBAKEAwQCBAKEggSBhIGEgYSBBQEEgIUAhICFAAUABQBEgEUARIDEgMSAxIFEgUQBxAHEAcQBw4JDgkOCw4LDAsMDQoNCg8KDwgPCBEIEQYRBBMEEwQTAhMCFQAVAP0FEhHlAgASEgCCBgAIAQgBBgEGAwYFBgUEBQQHBAUEBwIHAgcCBwIJAAcABwAJAAcBBwEHAQUBBwMFAwUDBQMDBQMFAwUBBQEHAQcAgQYSEeUCABISAIIGAAgBCAEGAQYDBgUGBQQFBAcEBQQHAgcCBwIHAgkABwAHAAkABwEHAQcBBQEHAwUDBQMFAwMFAwUDBQEFAQcBBwCBBhIR5QIAEhIA8AgYAA==",
  "l":"BgABAQnAAwDrAgASFgDWCxEa6gIAERkA0wsUFw==",
  "y":"BgABAZ8BogeNAg8ZERkRFxEVExMVERUPFQ8XDRcLGQkZBxsFGwUdAR0BDQALAA0ADQINAAsCDQANAg0CDQILAg0EDQINBA0GDQQNBg0EDQYNCA0GDwgNCA0IDQgPCg0KDwwNDA8MDw4PDqIB7gEQDRALEAkQCQ4JEAcOBw4FDgUOAwwFDgMMAQwBDAEMAQwACgEKAAoACAIIAAgCCAIGAggCBgIGBAYCBgQEAgYEAqIBAQADAAEBAwADAAMABQADAAUAAwAFAAMABQAFAAMABQA3ABMAEwIRABECEwQRAg8EEQQPBBEGDwgNCA8IDQgNCg0MDQwLDAkOCw4JDgcQBxAHEgUSBRQFFAMWARgDGAEaABwA9AUTEuQCABEPAP8FAAUCBQAFAgUEBQIDBAUEAwQDBgMEAQYDBgEGAAgBBgCAAQAAvAYREuICABMPAP0K",
  "q":"BgABAmj0A4YJFgAWARQAEgESAxADEAMOAw4FDgUMBQ4HDgcOBwwJDgmeAU4A2QwWGesCABYaAN4DAwADAAMBAwADAAUAAwADAAMABQAFAAUABwAHAQcACQAVABUCFQATAhUCEwQRAhMEEQQRBhEGDwgPCA8IDQoNDA0MCwwLDgkOCRAJEAkQBxIHEgUUBRYDFgMYARoBGgAcAP4CABYCFgIWBBYEFAQSBhQIEggSCBAKEgoQDA4MDgwODg4ODBAMDgwQChIIEAoSCBIGEgYUBhQEFAQWAhYCFgIWAApbkQYSKy4ReAAAjARTEjkRHykJMwDvAg==",
  "p":"BgABAmiCBIYJFgAWARYBFAEWAxQDEgUUBRIFEgcSBxAJEAkQCQ4LDgsOCwwNDA0KDwoPCg8IEQgRCBEGEwQTBhMCFQQVAhUAFQD9AgAbARkBFwMXAxcDEwUTBxMHEQcRCQ8JDQsNCw0LCw0LDQkPCQ0JDwURBxEFEQURAxMDEQMTARUBEwEVARUBFQAJAAcABwAFAAcABQAFAAMAAwADAAUAAwIDAAMAAwIDAADdAxYZ6wIAFhoA2gyeAU0OCgwIDgoMCA4GDgYMBg4GDgQQBBAEEgQUAhQCFgIWAApcoQMJNB8qNxJVEQCLBHgALhISLADwAg==",
  "o":"BgABAoMB8gOICRYAFgEWARQBFgMUAxIDFAUSBRIHEgcQBxAJEAkOCw4LDgsMDQwNCg8KDwoPCg8IEQgRBhMGEwQTBBMCFQIVABcAiwMAFwEVARUDEwMTAxMFEwcRBxEHDwkPCQ8LDQsNCw0NCw0LDwkNCw8HEQkPBxEHEQcRBRMFEwMTAxUDFQEVABUAFQAVAhUCFQITBBMEEwYTBhEGEQgRCA8KDwoPCg0KDQwNDAsOCw4JDgkQCRAJEgcSBxIFFAUUAxQDFgEWARYAFgCMAwAYAhYCFgQUBBQEFAYUCBIIEggQChAKEAwODA4MDg4MDgwQCg4KEgoQChIIEggSBhQGEgYUBBYEFAIWAhYCFgALYv0CHTZBFEMRHTcAjwMcNUITQhIiOACQAw==",
  "r":"BgACAQRigAkQAA8AAAABShAAhAFXDAwODAwKDgoOCBAIDgYQBhAEEAQQBBAEEAISABACEAAQAA4BEAAQARADEAEQAxADEAUSBRIHFAcUCxQLFA0WDVJFsQHzAQsMDQwLCgkICwgLCAkGCQYJBAkGBwIJBAcCBwQHAAcCBwAFAgcABQAHAQUABQEFAQUBBQEDAQUBAwMDAQMDAwEAmwYSEeMCABISAO4IEAA=",
  "u":"BgABAV2KBwGPAVANCQsHDQcNBw0FCwUNBQ0FDQMPAw8DEQMTARMBFQEVABUAFQITABMEEwITBBMEEQQRBhEGDwYRCA8KDQgPCg0MDQwLDAsOCRALDgcQBxIHEgUUBRQFFAMWAxgBGAEYARoA7gUTEuYCABMPAPsFAAcCBwIFBAcCBQYDBgUGAwgDBgMIAQgBCAEIAQoBCAAIAAoACAIIAggCCAIGBAgEBgQGBgYGBAYCBgQIAggACAD6BRES5AIAEREA7wgPAA==",
  "s":"BgABAasC/gLwBQoDCgMMBQ4DDgUOBRAFEAUSBRAHEgcQCRIJEAkSCxALEAsQDRANDg0ODw4PDA8MDwoRChEIEwYTBBcCFQIXABkBGQEXAxcFFQUTBRMHEwcRCREJDwkNCQ8LDQ0LCwsNCw0JDQkPBw8HDwUPBREDEQMRAREDEQETABEBEwARABMADwIRABECEQIRBBMCEwQVBBUEFQYVBhMIFwgVChUKFQxgsAIIAwYDCAMKAQgDCAMKAQoDCgEKAwoBCgMKAQwDCgEKAwoBDAMKAQoBCgEMAQoACgEKAAoBCgAKAQgACgAIAQgABgoECAIKAgoCCgAMAQoBDAUEBwIHBAcEBwIHBAkECQQJBAkECQYLBAkGCwYJBgsGCwYJCAsGCwgJBgsICQgLCAkICwgJCgkKCQoJCgcKCQwHDAcMBwwFDAcMAw4FDAMOAw4BDgMQARAAEAESABIAEgIQAg4CDgIOBA4CDgQMBAwEDAQMBgoECgYKBgoGCgYIBggGCAgIBggGBgYIBgYGBgYGBgYGBAgGBgQIBAYECAQQChIIEggSBhIEEgQSBBQCFAISABQAEgASABIAEgESARIBEAEQAxIDDgMQAxADDgUOBQwDDAMMAwoDCAMIAQYBe6cCAwIDAgUAAwIFAgUCBwIFAgcCBQIHAgUCBwIHAAUCBwIHAgUABwIHAgcABQIHAAcCBwAFAgUABQIFAAUABQIDAAEAAQABAQEAAQEBAQEBAQEBAQEDAQEAAwEBAQMAAwEDAAMBAwADAQMAAwABAQMAAwADAAEAAwIBAAMCAQQDAgE=",
  "t":"BgABAUe8BLACWAAaEADRAhsOaQANAA0ADwINAA0CDQANAg0CDQINBA0CCwYNBA0GCwYNBgsIDQgLCAsKCwgJDAsKCQwJDAkOCQ4HEAcSBxIHEgUUAOAEawAVEQDWAhYTbAAAygIVFOYCABUXAMUCogEAFhQA1QIVEqEBAADzAwIFBAMEBQQDBAMEAwYDBgMGAwYBCAEGAQgBBgEIAAgA",
  "w":"BgABARz8BsAEINYCKNgBERLuAgARD+8B3QgSEc0CABQSW7YCV7UCFBHJAgASEpMC3AgREvACABERmAHxBDDaAVeYAxES7gIAEREo1QE81wIIAA==",
  "z":"BgABAQ6cA9AGuQIAFw8AzAIaC9QFAAAr9wKjBuACABYQAMsCGQyZBgCaA9AG"
   }';
BEGIN

  IF font IS NULL THEN
    font := font_default;
  END IF;

  -- For character spacing, use m as guide size
  geom := ST_GeomFromTWKB(decode(font->>'m', 'base64'));
  m_width := ST_XMax(geom) - ST_XMin(geom);
  spacing := m_width / 12;

  letterarray := regexp_split_to_array(replace(letters, ' ', E'\t'), E'');
  FOREACH letter IN ARRAY letterarray
  LOOP
    geom := ST_GeomFromTWKB(decode(font->>(letter), 'base64'));
    -- Chars are not already zeroed out, so do it now
    geom := ST_Translate(geom, -1 * ST_XMin(geom), 0.0);
    -- unknown characters are treated as spaces
    IF geom IS NULL THEN
      -- spaces are a "quarter m" in width
      width := m_width / 3.5;
    ELSE
      width := (ST_XMax(geom) - ST_XMin(geom));
    END IF;
    geom := ST_Translate(geom, position, 0.0);
    -- Tighten up spacing when characters have a large gap
    -- between them like Yo or To
    adjustment := 0.0;
    IF prevgeom IS NOT NULL AND geom IS NOT NULL THEN
      dist = ST_Distance(prevgeom, geom);
      IF dist > spacing THEN
        adjustment = spacing - dist;
        geom := ST_Translate(geom, adjustment, 0.0);
      END IF;
    END IF;
    prevgeom := geom;
    position := position + width + spacing + adjustment;
    wordarr := array_append(wordarr, geom);
  END LOOP;
  -- apply the start point and scaling options
  wordgeom := ST_CollectionExtract(ST_Collect(wordarr));
  wordgeom := ST_Scale(wordgeom,
                text_height/font_default_height,
                text_height/font_default_height);
  return wordgeom;
END;
$$
LANGUAGE 'plpgsql'
SET standard_conforming_strings = ON
IMMUTABLE COST 250 PARALLEL SAFE;
CREATE OR REPLACE FUNCTION ST_RemoveIrrelevantPointsForView(geometry, box2d, boolean default false)
RETURNS geometry
AS '$libdir/postgis-3','ST_RemoveIrrelevantPointsForView'
	LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
CREATE OR REPLACE FUNCTION ST_RemoveSmallParts(geometry, double precision, double precision)
RETURNS geometry
AS '$libdir/postgis-3','ST_RemoveSmallParts'
LANGUAGE 'c' IMMUTABLE STRICT PARALLEL SAFE
	COST 250;
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_upgrade_info()');
DROP FUNCTION _postgis_upgrade_info();
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011-2020 Sandro Santilli <strk@kbt.io>
-- Copyright (C) 2010-2012 Regina Obe <lr@pcorp.us>
-- Copyright (C) 2009      Paul Ramsey <pramsey@cleverelephant.ca>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- This file contains drop commands for obsoleted items that need
-- to be dropped _after_ upgrade of old functions.
-- Changes to this file affect postgis_upgrade*.sql script.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

-- First drop old aggregates
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS memgeomunion(geometry)');
DROP AGGREGATE IF EXISTS memgeomunion(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS geomunion(geometry)');
DROP AGGREGATE IF EXISTS geomunion(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS polygonize(geometry)');
DROP AGGREGATE IF EXISTS polygonize(geometry); -- Deprecated in 1.2.3, Dropped in 2.0.0
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS collect(geometry)');
DROP AGGREGATE IF EXISTS collect(geometry); -- Deprecated in 1.2.3, Dropped in 2.0.0
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_geomunion(geometry)');
DROP AGGREGATE IF EXISTS st_geomunion(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS accum_old(geometry)');
DROP AGGREGATE IF EXISTS accum_old(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_accum_old(geometry)');
DROP AGGREGATE IF EXISTS st_accum_old(geometry);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_accum(geometry)');
DROP AGGREGATE IF EXISTS st_accum(geometry); -- Dropped in 3.0.0
SELECT _postgis_drop_function_by_signature('pgis_geometry_accum_finalfn(internal)');

SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkb_agg(geometry, integer)');
DROP AGGREGATE IF EXISTS st_astwkb_agg(geometry, integer); -- temporarily introduced before 2.2.0 final
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkb_agg(geometry, integer, bigint)');
DROP AGGREGATE IF EXISTS st_astwkb_agg(geometry, integer, bigint); -- temporarily introduced before 2.2.0 final
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer)');
DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer); -- temporarily introduced before 2.2.0 final
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint)');
DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint); -- temporarily introduced before 2.2.0 final
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint, boolean)');
DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint, boolean); -- temporarily introduced before 2.2.0 final
SELECT postgis_extension_drop_if_exists('postgis', 'DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint, boolean, boolean)');
DROP AGGREGATE IF EXISTS st_astwkbagg(geometry, integer, bigint, boolean, boolean); -- temporarily introduced before 2.2.0 final

-- BEGIN Management functions that now have default param for typmod --
SELECT _postgis_drop_function_by_signature('AddGeometryColumn(varchar, varchar, varchar, varchar, integer, varchar, integer)');
SELECT _postgis_drop_function_by_signature('AddGeometryColumn(varchar, varchar, varchar, integer, varchar, integer)');
SELECT _postgis_drop_function_by_signature('AddGeometryColumn(varchar, varchar, integer, varchar, integer)');
SELECT _postgis_drop_function_by_signature('populate_geometry_columns()');
SELECT _postgis_drop_function_by_signature('populate_geometry_columns(oid)');

-- END Management functions now have default parameter for typmod --
-- Then drop old functions
SELECT _postgis_drop_function_by_signature('box2d_overleft(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_overright(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_left(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_right(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_contain(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_contained(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_overlap(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_same(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('box2d_intersects(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_area(geography)'); -- this one changed to use default parameters
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(geometry)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(geography)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(geometry, int4)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(geography, int4)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geometry)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geography)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geometry, int4)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geography, int4)'); -- this one changed to use default args
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geography, int4, int4)', '3.0.0'); -- dropped because the version-first signature is dumb
SELECT _postgis_drop_function_by_signature('ST_AsGeoJson(int4, geometry, int4, int4)', '3.0.0'); -- dropped because the version-first signature is dumb
SELECT _postgis_drop_function_by_signature('_ST_AsGeoJson(int4, geometry, int4, int4)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('_ST_AsGeoJson(int4, geography, int4, int4)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('st_asgml(geometry)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(geometry, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geometry)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geometry, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geometry, int4, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geometry, int4, int4, text)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(geography)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(geography, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geography)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geography, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geography, int4, int4)');  -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(int4, geography, int4, int4, text)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('_st_asgml(int4, geometry, int4, int4, text)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('_st_asgml(int4, geography, int4, int4, text)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('_st_asgml(int4, geography, int4, int4, text, text)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_asgml(geography, int4, int4)');
SELECT _postgis_drop_function_by_signature('_st_askml(int4, geography, int4, text)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('_st_askml(int4, geometry, int4, text)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('st_askml(geometry)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_askml(geography)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_askml(int4, geometry, int4)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_askml(int4, geography, int4)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_askml(int4, geometry, int4, text)', '3.0.0'); -- dropped because the version-first signature is dumb
SELECT _postgis_drop_function_by_signature('st_askml(int4, geography, int4, text)', '3.0.0'); -- dropped because the version-first signature is dumb

SELECT _postgis_drop_function_by_signature('st_asx3d(geometry)'); -- this one changed to use default parameters so full function deals with it
SELECT _postgis_drop_function_by_signature('st_asx3d(geometry, int4)'); -- introduce variant with opts so get rid of other without ops
SELECT _postgis_drop_function_by_signature('st_assvg(geometry)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_assvg(geometry, int4)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_assvg(geography)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_assvg(geography, int4)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_box2d_overleft(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_overright(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_left(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_right(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_contain(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_contained(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_overlap(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_same(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_intersects(box2d, box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d_in(cstring)');
SELECT _postgis_drop_function_by_signature('st_box2d_out(box2d)');
SELECT _postgis_drop_function_by_signature('st_box2d(geometry)');
SELECT _postgis_drop_function_by_signature('st_box2d(box3d)');
SELECT _postgis_drop_function_by_signature('st_box3d(box2d)');
SELECT _postgis_drop_function_by_signature('st_box(box3d)');
SELECT _postgis_drop_function_by_signature('st_box3d(geometry)');
SELECT _postgis_drop_function_by_signature('st_box(geometry)');
SELECT _postgis_drop_function_by_signature('_st_buffer(geometry, float8, cstring)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('ST_ConcaveHull(geometry,float)'); -- this one changed to use default parameters
SELECT _postgis_drop_function_by_signature('st_text(geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry(box2d)');
SELECT _postgis_drop_function_by_signature('st_geometry(box3d)');
SELECT _postgis_drop_function_by_signature('st_geometry(text)');
SELECT _postgis_drop_function_by_signature('st_geometry(bytea)');
SELECT _postgis_drop_function_by_signature('st_bytea(geometry)');
SELECT _postgis_drop_function_by_signature('st_addbbox(geometry)');
SELECT _postgis_drop_function_by_signature('_st_distance(geography, geography, float8, boolean)'); -- dropped in PostGIS-3.0 (r17300)
SELECT _postgis_drop_function_by_signature('st_dropbbox(geometry)');
SELECT _postgis_drop_function_by_signature('st_hasbbox(geometry)');
SELECT _postgis_drop_function_by_signature('cache_bbox()');
SELECT _postgis_drop_function_by_signature('st_cache_bbox()');
SELECT _postgis_drop_function_by_signature('ST_GeoHash(geometry)'); -- changed to use default args
SELECT _postgis_drop_function_by_signature('st_length(geography)'); -- this one changed to use default parameters
SELECT _postgis_drop_function_by_signature('st_perimeter(geography)'); -- this one changed to use default parameters
SELECT _postgis_drop_function_by_signature('transform_geometry(geometry, text, text, int)');
SELECT _postgis_drop_function_by_signature('collector(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_collector(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('geom_accum (geometry[],geometry)');
SELECT _postgis_drop_function_by_signature('st_geom_accum (geometry[],geometry)');
SELECT _postgis_drop_function_by_signature('collect_garray (geometry[])');
SELECT _postgis_drop_function_by_signature('st_collect_garray (geometry[])');
SELECT _postgis_drop_function_by_signature('geosnoop(geometry)');
SELECT _postgis_drop_function_by_signature('jtsnoop(geometry)');
SELECT _postgis_drop_function_by_signature('st_noop(geometry)');
SELECT _postgis_drop_function_by_signature('st_max_distance(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('ST_MinimumBoundingCircle(geometry)'); --changed to use default parameters
-- Drop internals that should never have existed --
SELECT _postgis_drop_function_by_signature('st_geometry_analyze(internal)');
SELECT _postgis_drop_function_by_signature('st_geometry_in(cstring)');
SELECT _postgis_drop_function_by_signature('st_geometry_out(geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry_recv(internal)');
SELECT _postgis_drop_function_by_signature('st_geometry_send(geometry)');
SELECT _postgis_drop_function_by_signature('st_spheroid_in(cstring)');
SELECT _postgis_drop_function_by_signature('st_spheroid_out(spheroid)');
SELECT _postgis_drop_function_by_signature('st_geometry_lt(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry_gt(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry_ge(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry_eq(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_geometry_cmp(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('SnapToGrid(geometry, float8, float8)');
SELECT _postgis_drop_function_by_signature('st_removerepeatedpoints(geometry)');
SELECT _postgis_drop_function_by_signature('st_voronoi(geometry, geometry, double precision, boolean)'); --temporarely introduced before 2.3.0 final

SELECT _postgis_drop_function_by_signature('geometry_gist_sel_2d (internal, oid, internal, int4)');
SELECT _postgis_drop_function_by_signature('geometry_gist_joinsel_2d(internal, oid, internal, smallint)');
SELECT _postgis_drop_function_by_signature('geography_gist_selectivity (internal, oid, internal, int4)');
SELECT _postgis_drop_function_by_signature('geography_gist_join_selectivity(internal, oid, internal, smallint)');

SELECT _postgis_drop_function_by_signature('ST_AsBinary(text)'); -- deprecated in 2.0
SELECT _postgis_drop_function_by_signature('postgis_uses_stats()'); -- deprecated in 2.0
SELECT _postgis_drop_function_by_signature('ST_GeneratePoints(geometry, numeric)'); -- numeric -> integer

-- Old accum aggregate support type, removed in 2.5.0 See #4035
SELECT _postgis_drop_function_by_signature('pgis_abs_in(cstring)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_abs_out(pgis_abs)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_accum_finalfn(pgis_abs)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_accum_transfn(pgis_abs, geometry)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_collect_finalfn(pgis_abs)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_makeline_finalfn(pgis_abs)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_polygonize_finalfn(pgis_abs)', '2.5.0');
SELECT _postgis_drop_function_by_signature('pgis_geometry_union_finalfn(pgis_abs)', '2.5.0');
SELECT postgis_extension_drop_if_exists('postgis', 'DROP TYPE IF EXISTS pgis_abs CASCADE');
DROP TYPE IF EXISTS pgis_abs CASCADE; -- TODO: use a _postgis_drop_type ?


SELECT _postgis_drop_function_by_signature('st_astwkb(geometry, integer, bigint, bool, bool)'); -- temporarily introduced before 2.2.0 final
SELECT _postgis_drop_function_by_signature('pgis_twkb_accum_transfn(internal, geometry, integer)'); -- temporarily introduced before 2.2.0 final
SELECT _postgis_drop_function_by_signature('pgis_twkb_accum_transfn(internal, geometry, integer, bigint)'); -- temporarily introduced before 2.2.0 final
SELECT _postgis_drop_function_by_signature('pgis_twkb_accum_transfn(internal, geometry, integer, bigint, bool)'); -- temporarily introduced before 2.2.0 final
SELECT _postgis_drop_function_by_signature('pgis_twkb_accum_transfn(internal, geometry, integer, bigint, bool, bool)'); -- temporarily introduced before 2.2.0 final
SELECT _postgis_drop_function_by_signature('pgis_twkb_accum_finalfn(internal)'); -- temporarily introduced before 2.2.0 final

SELECT _postgis_drop_function_by_signature('st_seteffectivearea(geometry, double precision)'); -- temporarily introduced before 2.2.0 final

SELECT _postgis_drop_function_by_signature('geometry_distance_box_nd(geometry, geometry)'); -- temporarily introduced before 2.2.0 final

SELECT _postgis_drop_function_by_signature('_ST_DumpPoints(geometry, integer[])'); -- removed 2.4.0, but really should have been removed 2.1.0 when ST_DumpPoints got reimpmented in C

-- Temporary clean-up while we wait to return these to action in dev
SELECT _postgis_drop_function_by_identity('_ST_DistanceRectTree','g1 geometry, g2 geometry');
SELECT _postgis_drop_function_by_identity('_ST_DistanceRectTreeCached','g1 geometry, g2 geometry');

-- Deplicative signatures removed
SELECT _postgis_drop_function_by_signature('ST_Distance(geography, geography)'); -- dropped in PostGIS-3.0 (r17300 aka ce70e4906)
SELECT _postgis_drop_function_by_signature('ST_Distance(geography, geography, float8, boolean)');
SELECT _postgis_drop_function_by_signature('ST_Buffer(geometry, float8, cstring)');
SELECT _postgis_drop_function_by_signature('ST_IsValidDetail(geometry)');
SELECT _postgis_drop_function_by_signature('ST_RemoveIrrelevantPointsForView(geometry, box2d)'); -- temporarily introduced in 3.5.0dev, replaced by ST_RemoveIrrelevantPointsForView(geometry, box2d, boolean) in 3.5.0dev
SELECT _postgis_drop_function_by_identity('ST_AsKML','int4, geometry, int4, text');
SELECT _postgis_drop_function_by_identity('ST_AsGeoJson','int4, geometry, int4, int4');
SELECT _postgis_drop_function_by_identity('_ST_AsGeoJson','int4, geometry, int4, int4');

-- Underscore_signatures removed for CamelCase
SELECT _postgis_drop_function_by_signature('st_shift_longitude(geometry)');
SELECT _postgis_drop_function_by_signature('st_estimated_extent(text,text,text)');
SELECT _postgis_drop_function_by_signature('st_estimated_extent(text,text)');
SELECT _postgis_drop_function_by_signature('st_find_extent(text,text,text)');
SELECT _postgis_drop_function_by_signature('st_find_extent(text,text)');
SELECT _postgis_drop_function_by_signature('st_mem_size(geometry)');
SELECT _postgis_drop_function_by_signature('st_3dlength_spheroid(geometry, spheroid)');
SELECT _postgis_drop_function_by_signature('st_length_spheroid(geometry, spheroid)');
SELECT _postgis_drop_function_by_signature('st_length2d_spheroid(geometry, spheroid)');
SELECT _postgis_drop_function_by_signature('st_distance_spheroid(geometry, geometry, spheroid)');
SELECT _postgis_drop_function_by_signature('st_point_inside_circle(geometry, float8, float8, float8)');
SELECT _postgis_drop_function_by_signature('st_force_2d(geometry)');
SELECT _postgis_drop_function_by_signature('st_force_3dz(geometry)');
SELECT _postgis_drop_function_by_signature('st_force_3dm(geometry)');
SELECT _postgis_drop_function_by_signature('st_force_collection(geometry)');
SELECT _postgis_drop_function_by_signature('st_force_4d(geometry)');
SELECT _postgis_drop_function_by_signature('st_force_3d(geometry)');
SELECT _postgis_drop_function_by_signature('st_line_interpolate_point(geometry, float8)');
SELECT _postgis_drop_function_by_signature('st_line_substring(geometry, float8, float8)');
SELECT _postgis_drop_function_by_signature('st_line_locate_point(geometry, geometry)');
SELECT _postgis_drop_function_by_signature('st_locate_between_measures(geometry, float8, float8)');
SELECT _postgis_drop_function_by_signature('st_locate_along_measure(geometry, float8)');
SELECT _postgis_drop_function_by_signature('st_combine_bbox(box3d, geometry)');
SELECT _postgis_drop_function_by_signature('st_combine_bbox(box2d, geometry)');
SELECT _postgis_drop_function_by_signature('st_distance_sphere(geometry, geometry)');

-- dev function 3.0 cycle
SELECT _postgis_drop_function_by_signature('pgis_geometry_union_transfn(internal, geometry)');
SELECT _postgis_drop_function_by_signature('pgis_geometry_union_finalfn(internal)');

-- Long Xact support dropped in 3.5.0
-- See https://trac.osgeo.org/postgis/ticket/5723
SELECT _postgis_drop_function_by_signature('UnlockRows(text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('LockRow(text, text, text, text, timestamp)', '3.5.0');
SELECT _postgis_drop_function_by_signature('LockRow(text, text, text, text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('LockRow(text, text, text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('LockRow(text, text, text, timestamp)', '3.5.0');
SELECT _postgis_drop_function_by_signature('AddAuth(text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('CheckAuth(text, text, text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('CheckAuth(text, text)', '3.5.0');
SELECT _postgis_drop_function_by_signature('CheckAuthTrigger()', '3.5.0');
SELECT _postgis_drop_function_by_signature('GetTransactionID()', '3.5.0');
SELECT _postgis_drop_function_by_signature('EnableLongTransactions()', '3.5.0');
SELECT _postgis_drop_function_by_signature('LongTransactionsEnabled()', '3.5.0');
SELECT _postgis_drop_function_by_signature('DisableLongTransactions()', '3.5.0');


-- #4394
update pg_operator set oprcanhash = true, oprcanmerge = true where oprname = '=' and oprcode = 'geometry_eq'::regproc;


DO language 'plpgsql'
$$
BEGIN
IF _postgis_scripts_pgsql_version()::integer >= 96 THEN
-- mark ST_Union agg as parallel safe if it is not already
        BEGIN
            UPDATE pg_catalog.pg_proc SET proparallel = 's'
            WHERE oid = 'st_union(geometry)'::regprocedure AND proparallel = 'u';
        EXCEPTION WHEN OTHERS THEN
            RAISE DEBUG 'Could not update st_union(geometry): %', SQLERRM;
        END;
END IF;
END;
$$;

-- #5564 fix up the brin op classes for upgrades
DO language plpgsql
$$
BEGIN
    -- Check if the function is already associated with any operator class
    IF NOT EXISTS (
        SELECT 1 FROM pg_catalog.pg_amproc
        WHERE amproc::text = 'geom2d_brin_inclusion_merge' AND
              amprocfamily IN (
                  SELECT oid FROM pg_catalog.pg_opfamily
                  WHERE opfname = 'brin_geometry_inclusion_ops_2d'
              )
    ) THEN
        BEGIN
            -- Create a temporary operator class for 'brin_geometry_inclusion_ops_2d_temp'
            CREATE OPERATOR CLASS brin_geometry_inclusion_ops_2d_temp
                FOR TYPE geometry USING brin AS
                    FUNCTION 11 geom2d_brin_inclusion_merge(internal, internal);

            -- find current and new operator family OIDs
            WITH a AS (
                SELECT n.oid AS oid_nfamily, o.oid AS oid_ofamily
                FROM pg_catalog.pg_opfamily AS n
                CROSS JOIN (
                    SELECT oid
                    FROM pg_catalog.pg_opfamily
                    WHERE opfname = 'brin_geometry_inclusion_ops_2d_temp'
                ) AS o
                WHERE n.opfname = 'brin_geometry_inclusion_ops_2d'
            ),
            -- Update the amprocfamily in pg_amproc
            amupdate AS (
                UPDATE pg_catalog.pg_amproc AS amp
                SET amprocfamily = a.oid_nfamily
                FROM a
                WHERE amp.amprocfamily = a.oid_ofamily AND
                      amp.amproc::text = 'geom2d_brin_inclusion_merge'
                RETURNING amp.*
            )
            -- Update dependencies in pg_depend to the existing operator class
            UPDATE pg_depend AS d
            SET refobjid = (
                SELECT n.oid
                FROM pg_catalog.pg_opclass AS n
                WHERE opcname = 'brin_geometry_inclusion_ops_2d'
            )
            FROM amupdate
            WHERE d.objid = amupdate.oid AND
                  refobjid = (
                      SELECT o.oid
                      FROM pg_catalog.pg_opclass AS o
                      WHERE opcname = 'brin_geometry_inclusion_ops_2d_temp'
                  );

            -- Drop the temporary operator family after use
            DROP OPERATOR FAMILY brin_geometry_inclusion_ops_2d_temp USING brin;
        EXCEPTION WHEN OTHERS THEN
            RAISE EXCEPTION
                'Could not add geom2d_brin_inclusion_merge to brin_geometry_inclusion_ops_2d class: %',
                SQLERRM;
        END;
    END IF;

    -- Check if the function is already associated with any operator class
    IF NOT EXISTS (
        SELECT 1
        FROM pg_catalog.pg_amproc
        WHERE amproc::text = 'geom3d_brin_inclusion_merge'
    ) THEN
        BEGIN
            -- Create a temporary operator class with the new function
            CREATE OPERATOR CLASS brin_geometry_inclusion_ops_3d_temp
            FOR TYPE geometry USING brin AS
                FUNCTION 11 geom3d_brin_inclusion_merge(internal, internal);

            -- Change the pg_amproc association to the existing opclass
             WITH a AS (
                SELECT n.oid AS oid_nfamily, o.oid AS oid_ofamily
                FROM pg_catalog.pg_opfamily AS n
                CROSS JOIN (
                    SELECT oid FROM pg_catalog.pg_opfamily
                    WHERE opfname = 'brin_geometry_inclusion_ops_3d_temp'
                ) AS o
                WHERE n.opfname = 'brin_geometry_inclusion_ops_3d'
            ), amupdate AS (
                UPDATE pg_catalog.pg_amproc AS amp
                SET amprocfamily = a.oid_nfamily
                FROM a
                WHERE
                    amp.amprocfamily = a.oid_ofamily
                    AND amp.amproc::text = 'geom3d_brin_inclusion_merge'
                RETURNING amp.*
            )
            -- Change the opclass dependency to the existing one
            UPDATE pg_depend AS d
            SET refobjid = (
                SELECT n.oid
                FROM pg_catalog.pg_opclass AS n
                WHERE opcname = 'brin_geometry_inclusion_ops_3d'
            )
            FROM amupdate
            WHERE d.objid = amupdate.oid AND
                  refobjid = (
                    SELECT o.oid
                    FROM pg_catalog.pg_opclass AS o
                    WHERE opcname = 'brin_geometry_inclusion_ops_3d_temp'
                );

            -- Dropping the autogenerated temporary family which cascades to temporary class
            DROP OPERATOR FAMILY brin_geometry_inclusion_ops_3d_temp USING brin;
        EXCEPTION WHEN OTHERS THEN
            RAISE EXCEPTION 'Could not add geom3d_brin_inclusion_merge to brin_geometry_inclusion_ops_3d class: %', SQLERRM;
        END;
    END IF;

    -- Check if the function is already associated with any operator class
    IF NOT EXISTS (
        SELECT 1
        FROM pg_catalog.pg_amproc
        WHERE amproc::text = 'geom4d_brin_inclusion_merge'
    ) THEN
        BEGIN
            -- Create a temporary operator class with the new function
            CREATE OPERATOR CLASS brin_geometry_inclusion_ops_4d_temp
            FOR TYPE geometry USING brin AS
                FUNCTION 11 geom4d_brin_inclusion_merge(internal, internal);

            -- Change the pg_amproc association to the existing opclass
             WITH a AS (
                SELECT n.oid AS oid_nfamily, o.oid AS oid_ofamily
                FROM pg_catalog.pg_opfamily AS n
                CROSS JOIN (
                    SELECT oid FROM pg_catalog.pg_opfamily
                    WHERE opfname = 'brin_geometry_inclusion_ops_4d_temp'
                ) AS o
                WHERE n.opfname = 'brin_geometry_inclusion_ops_4d'
            ) , amupdate AS (
                UPDATE pg_catalog.pg_amproc AS amp
                SET amprocfamily = a.oid_nfamily
                FROM a
                WHERE
                    amp.amprocfamily = a.oid_ofamily
                    AND amp.amproc::text = 'geom4d_brin_inclusion_merge'
                RETURNING amp.*
            )
            -- Change the opclass dependency to the existing one
            UPDATE pg_depend AS d
            SET refobjid = (
                SELECT n.oid
                FROM pg_catalog.pg_opclass AS n
                WHERE opcname = 'brin_geometry_inclusion_ops_4d'
            )
            FROM amupdate
            WHERE d.objid = amupdate.oid AND
                  refobjid = (
                    SELECT o.oid
                    FROM pg_catalog.pg_opclass AS o
                    WHERE opcname = 'brin_geometry_inclusion_ops_4d_temp'
                );

            -- Dropping the autogenerated temporary family also drops the temporary class
            DROP OPERATOR FAMILY brin_geometry_inclusion_ops_4d_temp USING brin;
        EXCEPTION WHEN OTHERS THEN
            RAISE EXCEPTION
                'Could not add geom4d_brin_inclusion_merge to brin_geometry_inclusion_ops_4d class: %',
                SQLERRM;
        END;
    END IF;

-- geography brin
    -- Check if the function 'geog_brin_inclusion_merge' already exists
    IF NOT EXISTS (
        SELECT 1
        FROM pg_catalog.pg_amproc
        WHERE amproc::text = 'geog_brin_inclusion_merge'
    ) THEN
        BEGIN
            -- Create a temporary operator class for 'brin_geography_inclusion_ops_temp'
            CREATE OPERATOR CLASS brin_geography_inclusion_ops_temp
                FOR TYPE geography USING brin AS
                    FUNCTION 11 geog_brin_inclusion_merge(internal, internal);

            -- find current and new operator family OIDs
            WITH a AS (
                SELECT n.oid AS oid_nfamily, o.oid AS oid_ofamily
                FROM pg_catalog.pg_opfamily AS n
                CROSS JOIN (
                    SELECT oid
                    FROM pg_catalog.pg_opfamily
                    WHERE opfname = 'brin_geography_inclusion_ops_temp'
                ) AS o
                WHERE n.opfname = 'brin_geography_inclusion_ops'
            ),
            -- Update the amprocfamily in pg_amproc
            amupdate AS (
                UPDATE pg_catalog.pg_amproc AS amp
                SET amprocfamily = a.oid_nfamily
                FROM a
                WHERE amp.amprocfamily = a.oid_ofamily AND
                      amp.amproc::text = 'geog_brin_inclusion_merge'
                RETURNING amp.*
            )
            -- Update dependencies in pg_depend to the existing operator class
            UPDATE pg_depend AS d
            SET refobjid = (
                SELECT n.oid
                FROM pg_catalog.pg_opclass AS n
                WHERE opcname = 'brin_geography_inclusion_ops'
            )
            FROM amupdate
            WHERE d.objid = amupdate.oid AND
                  refobjid = (
                      SELECT o.oid
                      FROM pg_catalog.pg_opclass AS o
                      WHERE opcname = 'brin_geography_inclusion_ops_temp'
                  );

            -- Drop the temporary operator family after use
            DROP OPERATOR FAMILY brin_geography_inclusion_ops_temp USING brin;
        EXCEPTION WHEN OTHERS THEN
            RAISE EXCEPTION
                'Could not add geog_brin_inclusion_merge to brin_geography_inclusion_ops class: %',
                SQLERRM;
        END;
    END IF;
END;

$$;
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011-2020 Sandro Santilli <strk@kbt.io>
-- Copyright (C) 2010-2012 Regina Obe <lr@pcorp.us>
-- Copyright (C) 2009      Paul Ramsey <pramsey@cleverelephant.ca>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- This file will be appended at the very end of every
-- sql upgrade script.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

-- DROP auxiliary function (created by common_before_upgrade.sql)
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_drop_function_by_identity(text, text, text)');
DROP FUNCTION _postgis_drop_function_by_identity(text, text, text);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_drop_function_by_signature(text, text)');
DROP FUNCTION _postgis_drop_function_by_signature(text, text);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_topology_upgrade_domain_type(text, text, text, text)');
DROP FUNCTION _postgis_topology_upgrade_domain_type(text, text, text, text);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_drop_cast_by_types(text, text, text)');
DROP FUNCTION _postgis_drop_cast_by_types(text, text, text);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_topology_upgrade_user_type_attribute(text, text, text, text, text)');
DROP FUNCTION _postgis_topology_upgrade_user_type_attribute(text, text, text, text, text);
SELECT postgis_extension_drop_if_exists('postgis', 'DROP FUNCTION _postgis_add_column_to_table(regclass, name, text, boolean, text, text)');
DROP FUNCTION _postgis_add_column_to_table(regclass, name, text, boolean, text, text);


-- Drop deprecated functions if possible
DO LANGUAGE 'plpgsql'
$POSTGIS_PROC_UPGRADE$
DECLARE
    new_name TEXT;
    rec RECORD;
    extrec RECORD;
    sql TEXT;
    detail TEXT;
    hint TEXT;
BEGIN

    -- Try to drop all deprecated functions,
    -- and report failure to do so as a WARNING
    -- for the user to handle.
    --
    FOR rec IN

        SELECT *, oid::regprocedure as proc
        FROM pg_catalog.pg_proc
        WHERE proname ~ 'deprecated_by_postgis'

    LOOP --{

        RAISE DEBUG 'Handling deprecated function %', rec.proc;

        new_name := pg_catalog.regexp_replace(
            rec.proc::text,
            E'_deprecated_by_postgis[^(]*\\(.*',
            ''
        );

        sql := pg_catalog.format('DROP FUNCTION %s', rec.proc);
        --RAISE DEBUG 'SQL: %', sql;
        BEGIN --{
            EXECUTE sql;
        EXCEPTION
        WHEN OTHERS THEN -- }{
            hint = 'Resolve the issue';
            GET STACKED DIAGNOSTICS detail := PG_EXCEPTION_DETAIL;
            IF detail LIKE '%view % depends%' THEN
                hint = pg_catalog.format(
                    'Replace the view changing all occurrences of %s in its definition with %s',
                    rec.proc,
                    new_name
                );
            END IF;
            hint = hint || ' and upgrade again';

            RAISE WARNING 'Deprecated function % left behind: %',
                rec.proc, SQLERRM
            USING DETAIL = detail, HINT = hint;

            -- Drop the function from any extension it is part of
            -- so dump/reloads still work
            FOR extrec IN
                SELECT e.extname
                FROM
                    pg_catalog.pg_extension e,
                    pg_catalog.pg_depend d
                WHERE
                    d.refclassid = 'pg_catalog.pg_extension'::pg_catalog.regclass AND
                    d.refobjid = e.oid AND
                    d.classid = 'pg_catalog.pg_proc'::pg_catalog.regclass AND
                    d.objid = rec.proc::oid
            LOOP
                RAISE DEBUG 'Unpackaging % from extension %', rec.proc, extrec.extname;
                sql := pg_catalog.format('ALTER EXTENSION %I DROP FUNCTION %s', extrec.extname, rec.proc);
                EXECUTE sql;
            END LOOP;

        END; --}

    END LOOP; --}
END
$POSTGIS_PROC_UPGRADE$;

INSERT INTO "spatial_ref_sys" ("srid", "auth_name", "auth_srid", "srtext", "proj4text") VALUES
--
-- EPSG 2000 : Anguilla 1957 / British West Indies Grid 
--
(2000, 'EPSG', 2000, 'PROJCS["Anguilla 1957 / British West Indies Grid",GEOGCS["Anguilla 1957",DATUM["Anguilla_1957",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6600"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4600"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2000"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs '),
--
-- EPSG 2001 : Antigua 1943 / British West Indies Grid 
--
(2001, 'EPSG', 2001, 'PROJCS["Antigua 1943 / British West Indies Grid",GEOGCS["Antigua 1943",DATUM["Antigua_1943",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY["EPSG","6601"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4601"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2001"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2002 : Dominica 1945 / British West Indies Grid 
--
(2002, 'EPSG', 2002, 'PROJCS["Dominica 1945 / British West Indies Grid",GEOGCS["Dominica 1945",DATUM["Dominica_1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY["EPSG","6602"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4602"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2002"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2003 : Grenada 1953 / British West Indies Grid 
--
(2003, 'EPSG', 2003, 'PROJCS["Grenada 1953 / British West Indies Grid",GEOGCS["Grenada 1953",DATUM["Grenada_1953",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY["EPSG","6603"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4603"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2003"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2004 : Montserrat 1958 / British West Indies Grid 
--
(2004, 'EPSG', 2004, 'PROJCS["Montserrat 1958 / British West Indies Grid",GEOGCS["Montserrat 1958",DATUM["Montserrat_1958",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[174,359,365,0,0,0,0],AUTHORITY["EPSG","6604"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4604"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2004"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2005 : St. Kitts 1955 / British West Indies Grid 
--
(2005, 'EPSG', 2005, 'PROJCS["St. Kitts 1955 / British West Indies Grid",GEOGCS["St. Kitts 1955",DATUM["St_Kitts_1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY["EPSG","6605"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4605"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2005"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2006 : St. Lucia 1955 / British West Indies Grid 
--
(2006, 'EPSG', 2006, 'PROJCS["St. Lucia 1955 / British West Indies Grid",GEOGCS["St. Lucia 1955",DATUM["St_Lucia_1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-149,128,296,0,0,0,0],AUTHORITY["EPSG","6606"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4606"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2006"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2007 : St. Vincent 45 / British West Indies Grid 
--
(2007, 'EPSG', 2007, 'PROJCS["St. Vincent 45 / British West Indies Grid",GEOGCS["St. Vincent 1945",DATUM["St_Vincent_1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[195.671,332.517,274.607,0,0,0,0],AUTHORITY["EPSG","6607"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4607"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-62],PARAMETER["scale_factor",0.9995],PARAMETER["false_easting",400000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2007"]]', '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2008 : NAD27(CGQ77) / SCoPQ zone 2 (deprecated) 
--
(2008, 'EPSG', 2008, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 2 (deprecated)",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-55.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2008"]]', '+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2009 : NAD27(CGQ77) / SCoPQ zone 3 
--
(2009, 'EPSG', 2009, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 3",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-58.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2009"]]', '+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2010 : NAD27(CGQ77) / SCoPQ zone 4 
--
(2010, 'EPSG', 2010, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 4",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-61.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2010"]]', '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2011 : NAD27(CGQ77) / SCoPQ zone 5 
--
(2011, 'EPSG', 2011, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 5",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-64.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2011"]]', '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2012 : NAD27(CGQ77) / SCoPQ zone 6 
--
(2012, 'EPSG', 2012, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 6",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-67.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2012"]]', '+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2013 : NAD27(CGQ77) / SCoPQ zone 7 
--
(2013, 'EPSG', 2013, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 7",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-70.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2013"]]', '+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2014 : NAD27(CGQ77) / SCoPQ zone 8 
--
(2014, 'EPSG', 2014, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 8",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-73.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2014"]]', '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2015 : NAD27(CGQ77) / SCoPQ zone 9 
--
(2015, 'EPSG', 2015, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 9",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-76.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2015"]]', '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2016 : NAD27(CGQ77) / SCoPQ zone 10 
--
(2016, 'EPSG', 2016, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 10",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-79.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2016"]]', '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2017 : NAD27(76) / MTM zone 8 
--
(2017, 'EPSG', 2017, 'PROJCS["NAD27(76) / MTM zone 8",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-73.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2017"]]', '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2018 : NAD27(76) / MTM zone 9 
--
(2018, 'EPSG', 2018, 'PROJCS["NAD27(76) / MTM zone 9",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-76.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2018"]]', '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2019 : NAD27(76) / MTM zone 10 
--
(2019, 'EPSG', 2019, 'PROJCS["NAD27(76) / MTM zone 10",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-79.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2019"]]', '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2020 : NAD27(76) / MTM zone 11 
--
(2020, 'EPSG', 2020, 'PROJCS["NAD27(76) / MTM zone 11",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-82.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2020"]]', '+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2021 : NAD27(76) / MTM zone 12 
--
(2021, 'EPSG', 2021, 'PROJCS["NAD27(76) / MTM zone 12",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2021"]]', '+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2022 : NAD27(76) / MTM zone 13 
--
(2022, 'EPSG', 2022, 'PROJCS["NAD27(76) / MTM zone 13",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-84],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2022"]]', '+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2023 : NAD27(76) / MTM zone 14 
--
(2023, 'EPSG', 2023, 'PROJCS["NAD27(76) / MTM zone 14",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-87],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2023"]]', '+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2024 : NAD27(76) / MTM zone 15 
--
(2024, 'EPSG', 2024, 'PROJCS["NAD27(76) / MTM zone 15",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-90],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2024"]]', '+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2025 : NAD27(76) / MTM zone 16 
--
(2025, 'EPSG', 2025, 'PROJCS["NAD27(76) / MTM zone 16",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-93],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2025"]]', '+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2026 : NAD27(76) / MTM zone 17 
--
(2026, 'EPSG', 2026, 'PROJCS["NAD27(76) / MTM zone 17",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-96],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2026"]]', '+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2027 : NAD27(76) / UTM zone 15N 
--
(2027, 'EPSG', 2027, 'PROJCS["NAD27(76) / UTM zone 15N",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-93],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2027"]]', '+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2028 : NAD27(76) / UTM zone 16N 
--
(2028, 'EPSG', 2028, 'PROJCS["NAD27(76) / UTM zone 16N",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-87],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2028"]]', '+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2029 : NAD27(76) / UTM zone 17N 
--
(2029, 'EPSG', 2029, 'PROJCS["NAD27(76) / UTM zone 17N",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2029"]]', '+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2030 : NAD27(76) / UTM zone 18N 
--
(2030, 'EPSG', 2030, 'PROJCS["NAD27(76) / UTM zone 18N",GEOGCS["NAD27(76)",DATUM["North_American_Datum_1927_1976",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-75],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2030"]]', '+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2031 : NAD27(CGQ77) / UTM zone 17N 
--
(2031, 'EPSG', 2031, 'PROJCS["NAD27(CGQ77) / UTM zone 17N",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2031"]]', '+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2032 : NAD27(CGQ77) / UTM zone 18N 
--
(2032, 'EPSG', 2032, 'PROJCS["NAD27(CGQ77) / UTM zone 18N",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-75],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2032"]]', '+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2033 : NAD27(CGQ77) / UTM zone 19N 
--
(2033, 'EPSG', 2033, 'PROJCS["NAD27(CGQ77) / UTM zone 19N",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2033"]]', '+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2034 : NAD27(CGQ77) / UTM zone 20N 
--
(2034, 'EPSG', 2034, 'PROJCS["NAD27(CGQ77) / UTM zone 20N",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2034"]]', '+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2035 : NAD27(CGQ77) / UTM zone 21N 
--
(2035, 'EPSG', 2035, 'PROJCS["NAD27(CGQ77) / UTM zone 21N",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-57],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2035"]]', '+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2036 : NAD83(CSRS98) / New Brunswick Stereo (deprecated) 
--
(2036, 'EPSG', 2036, 'PROJCS["NAD83(CSRS98) / New Brunswick Stereo (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",46.5],PARAMETER["central_meridian",-66.5],PARAMETER["scale_factor",0.999912],PARAMETER["false_easting",2500000],PARAMETER["false_northing",7500000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2036"]]', '+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2037 : NAD83(CSRS98) / UTM zone 19N (deprecated) 
--
(2037, 'EPSG', 2037, 'PROJCS["NAD83(CSRS98) / UTM zone 19N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2037"]]', '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2038 : NAD83(CSRS98) / UTM zone 20N (deprecated) 
--
(2038, 'EPSG', 2038, 'PROJCS["NAD83(CSRS98) / UTM zone 20N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2038"]]', '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2039 : Israel 1993 / Israeli TM Grid 
--
(2039, 'EPSG', 2039, 'PROJCS["Israel 1993 / Israeli TM Grid",GEOGCS["Israel 1993",DATUM["Israel_1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-48,55,52,0,0,0,0],AUTHORITY["EPSG","6141"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4141"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31.73439361111111],PARAMETER["central_meridian",35.20451694444445],PARAMETER["scale_factor",1.0000067],PARAMETER["false_easting",219529.584],PARAMETER["false_northing",626907.39],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2039"]]', '+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.20451694444445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2040 : Locodjo 1965 / UTM zone 30N 
--
(2040, 'EPSG', 2040, 'PROJCS["Locodjo 1965 / UTM zone 30N",GEOGCS["Locodjo 1965",DATUM["Locodjo_1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-3],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2040"]]', '+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2041 : Abidjan 1987 / UTM zone 30N 
--
(2041, 'EPSG', 2041, 'PROJCS["Abidjan 1987 / UTM zone 30N",GEOGCS["Abidjan 1987",DATUM["Abidjan_1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-3],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2041"]]', '+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2042 : Locodjo 1965 / UTM zone 29N 
--
(2042, 'EPSG', 2042, 'PROJCS["Locodjo 1965 / UTM zone 29N",GEOGCS["Locodjo 1965",DATUM["Locodjo_1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2042"]]', '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2043 : Abidjan 1987 / UTM zone 29N 
--
(2043, 'EPSG', 2043, 'PROJCS["Abidjan 1987 / UTM zone 29N",GEOGCS["Abidjan 1987",DATUM["Abidjan_1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2043"]]', '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2044 : Hanoi 1972 / Gauss-Kruger zone 18 
--
(2044, 'EPSG', 2044, 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 18",GEOGCS["Hanoi 1972",DATUM["Hanoi_1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",105],PARAMETER["scale_factor",1],PARAMETER["false_easting",18500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2044"]]', '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2045 : Hanoi 1972 / Gauss-Kruger zone 19 
--
(2045, 'EPSG', 2045, 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 19",GEOGCS["Hanoi 1972",DATUM["Hanoi_1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",111],PARAMETER["scale_factor",1],PARAMETER["false_easting",19500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2045"]]', '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2046 : Hartebeesthoek94 / Lo15 
--
(2046, 'EPSG', 2046, 'PROJCS["Hartebeesthoek94 / Lo15",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2046"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2047 : Hartebeesthoek94 / Lo17 
--
(2047, 'EPSG', 2047, 'PROJCS["Hartebeesthoek94 / Lo17",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",17],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2047"]]', '+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2048 : Hartebeesthoek94 / Lo19 
--
(2048, 'EPSG', 2048, 'PROJCS["Hartebeesthoek94 / Lo19",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",19],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2048"]]', '+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2049 : Hartebeesthoek94 / Lo21 
--
(2049, 'EPSG', 2049, 'PROJCS["Hartebeesthoek94 / Lo21",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2049"]]', '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2050 : Hartebeesthoek94 / Lo23 
--
(2050, 'EPSG', 2050, 'PROJCS["Hartebeesthoek94 / Lo23",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",23],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2050"]]', '+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2051 : Hartebeesthoek94 / Lo25 
--
(2051, 'EPSG', 2051, 'PROJCS["Hartebeesthoek94 / Lo25",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",25],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2051"]]', '+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2052 : Hartebeesthoek94 / Lo27 
--
(2052, 'EPSG', 2052, 'PROJCS["Hartebeesthoek94 / Lo27",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",27],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2052"]]', '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2053 : Hartebeesthoek94 / Lo29 
--
(2053, 'EPSG', 2053, 'PROJCS["Hartebeesthoek94 / Lo29",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",29],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2053"]]', '+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2054 : Hartebeesthoek94 / Lo31 
--
(2054, 'EPSG', 2054, 'PROJCS["Hartebeesthoek94 / Lo31",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",31],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2054"]]', '+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2055 : Hartebeesthoek94 / Lo33 
--
(2055, 'EPSG', 2055, 'PROJCS["Hartebeesthoek94 / Lo33",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse_Mercator_South_Orientated"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",33],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2055"]]', '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2056 : CH1903+ / LV95 
--
(2056, 'EPSG', 2056, 'PROJCS["CH1903+ / LV95",GEOGCS["CH1903+",DATUM["CH1903+",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[674.374,15.056,405.346,0,0,0,0],AUTHORITY["EPSG","6150"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4150"]],PROJECTION["Hotine_Oblique_Mercator_Azimuth_Center"],PARAMETER["latitude_of_center",46.95240555555556],PARAMETER["longitude_of_center",7.439583333333333],PARAMETER["azimuth",90],PARAMETER["rectified_grid_angle",90],PARAMETER["scale_factor",1],PARAMETER["false_easting",2600000],PARAMETER["false_northing",1200000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2056"]]', '+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2057 : Rassadiran / Nakhl e Taqi 
--
(2057, 'EPSG', 2057, 'PROJCS["Rassadiran / Nakhl e Taqi",GEOGCS["Rassadiran",DATUM["Rassadiran",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-133.63,-157.5,-158.62,0,0,0,0],AUTHORITY["EPSG","6153"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4153"]],PROJECTION["Hotine_Oblique_Mercator_Azimuth_Center"],PARAMETER["latitude_of_center",27.51882880555555],PARAMETER["longitude_of_center",52.60353916666667],PARAMETER["azimuth",0.5716611944444444],PARAMETER["rectified_grid_angle",0.5716611944444444],PARAMETER["scale_factor",0.999895934],PARAMETER["false_easting",658377.437],PARAMETER["false_northing",3044969.194],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2057"]]', '+proj=omerc +lat_0=27.51882880555555 +lonc=52.60353916666667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=658377.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2058 : ED50(ED77) / UTM zone 38N 
--
(2058, 'EPSG', 2058, 'PROJCS["ED50(ED77) / UTM zone 38N",GEOGCS["ED50(ED77)",DATUM["European_Datum_1950_1977",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2058"]]', '+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2059 : ED50(ED77) / UTM zone 39N 
--
(2059, 'EPSG', 2059, 'PROJCS["ED50(ED77) / UTM zone 39N",GEOGCS["ED50(ED77)",DATUM["European_Datum_1950_1977",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",51],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2059"]]', '+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2060 : ED50(ED77) / UTM zone 40N 
--
(2060, 'EPSG', 2060, 'PROJCS["ED50(ED77) / UTM zone 40N",GEOGCS["ED50(ED77)",DATUM["European_Datum_1950_1977",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",57],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2060"]]', '+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2061 : ED50(ED77) / UTM zone 41N 
--
(2061, 'EPSG', 2061, 'PROJCS["ED50(ED77) / UTM zone 41N",GEOGCS["ED50(ED77)",DATUM["European_Datum_1950_1977",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2061"]]', '+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2062 : Madrid 1870 (Madrid) / Spain 
--
(2062, 'EPSG', 2062, 'PROJCS["Madrid 1870 (Madrid) / Spain",GEOGCS["Madrid 1870 (Madrid)",DATUM["Madrid_1870_Madrid",SPHEROID["Struve 1860",6378298.3,294.73,AUTHORITY["EPSG","7028"]],AUTHORITY["EPSG","6903"]],PRIMEM["Madrid",-3.687938888888889,AUTHORITY["EPSG","8905"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4903"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",40],PARAMETER["central_meridian",0],PARAMETER["scale_factor",0.9988085293],PARAMETER["false_easting",600000],PARAMETER["false_northing",600000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2062"]]', '+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293 +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.142669561 +pm=madrid +units=m +no_defs '),
--
-- EPSG 2063 : Dabola 1981 / UTM zone 28N (deprecated) 
--
(2063, 'EPSG', 2063, 'PROJCS["Dabola 1981 / UTM zone 28N (deprecated)",GEOGCS["Conakry 1905",DATUM["Conakry_1905",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY["EPSG","6315"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4315"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2063"]]', '+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2064 : Dabola 1981 / UTM zone 29N (deprecated) 
--
(2064, 'EPSG', 2064, 'PROJCS["Dabola 1981 / UTM zone 29N (deprecated)",GEOGCS["Conakry 1905",DATUM["Conakry_1905",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY["EPSG","6315"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4315"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2064"]]', '+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2065 : S-JTSK (Ferro) / Krovak 
--
(2065, 'EPSG', 2065, 'PROJCS["S-JTSK (Ferro) / Krovak",GEOGCS["S-JTSK (Ferro)",DATUM["System_Jednotne_Trigonometricke_Site_Katastralni_Ferro",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[570.8,85.7,462.8,4.998,1.587,5.261,3.56],AUTHORITY["EPSG","6818"]],PRIMEM["Ferro",-17.66666666666667,AUTHORITY["EPSG","6818"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4818"]],PROJECTION["Krovak"],PARAMETER["latitude_of_center",49.5],PARAMETER["longitude_of_center",42.5],PARAMETER["azimuth",30.28813972222222],PARAMETER["pseudo_standard_parallel_1",78.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",SOUTH],AXIS["Y",WEST],AUTHORITY["EPSG","2065"]]', '+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=570.8,85.7,462.8,4.998,1.587,5.261,3.56 +pm=ferro +units=m +no_defs '),
--
-- EPSG 2066 : Mount Dillon / Tobago Grid 
--
(2066, 'EPSG', 2066, 'PROJCS["Mount Dillon / Tobago Grid",GEOGCS["Mount Dillon",DATUM["Mount_Dillon",SPHEROID["Clarke 1858",6378293.645208759,294.2606763692606,AUTHORITY["EPSG","7007"]],AUTHORITY["EPSG","6157"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4157"]],PROJECTION["Cassini_Soldner"],PARAMETER["latitude_of_origin",11.25217861111111],PARAMETER["central_meridian",-60.68600888888889],PARAMETER["false_easting",187500],PARAMETER["false_northing",180000],UNIT["Clarke''s link",0.201166195164,AUTHORITY["EPSG","9039"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2066"]]', '+proj=cass +lat_0=11.25217861111111 +lon_0=-60.68600888888889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs '),
--
-- EPSG 2067 : Naparima 1955 / UTM zone 20N 
--
(2067, 'EPSG', 2067, 'PROJCS["Naparima 1955 / UTM zone 20N",GEOGCS["Naparima 1955",DATUM["Naparima_1955",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-0.465,372.095,171.736,0,0,0,0],AUTHORITY["EPSG","6158"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4158"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2067"]]', '+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2068 : ELD79 / Libya zone 5 
--
(2068, 'EPSG', 2068, 'PROJCS["ELD79 / Libya zone 5",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2068"]]', '+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2069 : ELD79 / Libya zone 6 
--
(2069, 'EPSG', 2069, 'PROJCS["ELD79 / Libya zone 6",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",11],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2069"]]', '+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2070 : ELD79 / Libya zone 7 
--
(2070, 'EPSG', 2070, 'PROJCS["ELD79 / Libya zone 7",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",13],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2070"]]', '+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2071 : ELD79 / Libya zone 8 
--
(2071, 'EPSG', 2071, 'PROJCS["ELD79 / Libya zone 8",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2071"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2072 : ELD79 / Libya zone 9 
--
(2072, 'EPSG', 2072, 'PROJCS["ELD79 / Libya zone 9",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",17],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2072"]]', '+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2073 : ELD79 / Libya zone 10 
--
(2073, 'EPSG', 2073, 'PROJCS["ELD79 / Libya zone 10",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",19],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2073"]]', '+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2074 : ELD79 / Libya zone 11 
--
(2074, 'EPSG', 2074, 'PROJCS["ELD79 / Libya zone 11",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2074"]]', '+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2075 : ELD79 / Libya zone 12 
--
(2075, 'EPSG', 2075, 'PROJCS["ELD79 / Libya zone 12",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",23],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2075"]]', '+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2076 : ELD79 / Libya zone 13 
--
(2076, 'EPSG', 2076, 'PROJCS["ELD79 / Libya zone 13",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",25],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2076"]]', '+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2077 : ELD79 / UTM zone 32N 
--
(2077, 'EPSG', 2077, 'PROJCS["ELD79 / UTM zone 32N",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2077"]]', '+proj=utm +zone=32 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2078 : ELD79 / UTM zone 33N 
--
(2078, 'EPSG', 2078, 'PROJCS["ELD79 / UTM zone 33N",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2078"]]', '+proj=utm +zone=33 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2079 : ELD79 / UTM zone 34N 
--
(2079, 'EPSG', 2079, 'PROJCS["ELD79 / UTM zone 34N",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2079"]]', '+proj=utm +zone=34 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2080 : ELD79 / UTM zone 35N 
--
(2080, 'EPSG', 2080, 'PROJCS["ELD79 / UTM zone 35N",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",27],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2080"]]', '+proj=utm +zone=35 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2081 : Chos Malal 1914 / Argentina 2 
--
(2081, 'EPSG', 2081, 'PROJCS["Chos Malal 1914 / Argentina 2",GEOGCS["Chos Malal 1914",DATUM["Chos_Malal_1914",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6160"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4160"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-90],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",1],PARAMETER["false_easting",2500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2081"]]', '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2082 : Pampa del Castillo / Argentina 2 
--
(2082, 'EPSG', 2082, 'PROJCS["Pampa del Castillo / Argentina 2",GEOGCS["Pampa del Castillo",DATUM["Pampa_del_Castillo",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[27.5,14,186.4,0,0,0,0],AUTHORITY["EPSG","6161"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4161"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-90],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",1],PARAMETER["false_easting",2500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2082"]]', '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2083 : Hito XVIII 1963 / Argentina 2 
--
(2083, 'EPSG', 2083, 'PROJCS["Hito XVIII 1963 / Argentina 2",GEOGCS["Hito XVIII 1963",DATUM["Hito_XVIII_1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[16,196,93,0,0,0,0],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-90],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",1],PARAMETER["false_easting",2500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2083"]]', '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2084 : Hito XVIII 1963 / UTM zone 19S 
--
(2084, 'EPSG', 2084, 'PROJCS["Hito XVIII 1963 / UTM zone 19S",GEOGCS["Hito XVIII 1963",DATUM["Hito_XVIII_1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[16,196,93,0,0,0,0],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2084"]]', '+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2085 : NAD27 / Cuba Norte (deprecated) 
--
(2085, 'EPSG', 2085, 'PROJCS["NAD27 / Cuba Norte (deprecated)",GEOGCS["NAD27",DATUM["North_American_Datum_1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4267"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",22.35],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.99993602],PARAMETER["false_easting",500000],PARAMETER["false_northing",280296.016],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2085"]]', '+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99993602 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m +no_defs '),
--
-- EPSG 2086 : NAD27 / Cuba Sur (deprecated) 
--
(2086, 'EPSG', 2086, 'PROJCS["NAD27 / Cuba Sur (deprecated)",GEOGCS["NAD27",DATUM["North_American_Datum_1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4267"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",20.71666666666667],PARAMETER["central_meridian",-76.83333333333333],PARAMETER["scale_factor",0.99994848],PARAMETER["false_easting",500000],PARAMETER["false_northing",229126.939],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2086"]]', '+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=500000 +y_0=229126.939 +datum=NAD27 +units=m +no_defs '),
--
-- EPSG 2087 : ELD79 / TM 12 NE 
--
(2087, 'EPSG', 2087, 'PROJCS["ELD79 / TM 12 NE",GEOGCS["ELD79",DATUM["European_Libyan_Datum_1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0,0,0],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",12],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2087"]]', '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2088 : Carthage / TM 11 NE 
--
(2088, 'EPSG', 2088, 'PROJCS["Carthage / TM 11 NE",GEOGCS["Carthage",DATUM["Carthage",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-263,6,431,0,0,0,0],AUTHORITY["EPSG","6223"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4223"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",11],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2088"]]', '+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_0=0 +datum=carthage +units=m +no_defs '),
--
-- EPSG 2089 : Yemen NGN96 / UTM zone 38N 
--
(2089, 'EPSG', 2089, 'PROJCS["Yemen NGN96 / UTM zone 38N",GEOGCS["Yemen NGN96",DATUM["Yemen_National_Geodetic_Network_1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2089"]]', '+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2090 : Yemen NGN96 / UTM zone 39N 
--
(2090, 'EPSG', 2090, 'PROJCS["Yemen NGN96 / UTM zone 39N",GEOGCS["Yemen NGN96",DATUM["Yemen_National_Geodetic_Network_1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",51],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2090"]]', '+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2091 : South Yemen / Gauss Kruger zone 8 (deprecated) 
--
(2091, 'EPSG', 2091, 'PROJCS["South Yemen / Gauss Kruger zone 8 (deprecated)",GEOGCS["South Yemen",DATUM["South_Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",1],PARAMETER["false_easting",8500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2091"]]', '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2092 : South Yemen / Gauss Kruger zone 9 (deprecated) 
--
(2092, 'EPSG', 2092, 'PROJCS["South Yemen / Gauss Kruger zone 9 (deprecated)",GEOGCS["South Yemen",DATUM["South_Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",51],PARAMETER["scale_factor",1],PARAMETER["false_easting",9500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2092"]]', '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2093 : Hanoi 1972 / GK 106 NE 
--
(2093, 'EPSG', 2093, 'PROJCS["Hanoi 1972 / GK 106 NE",GEOGCS["Hanoi 1972",DATUM["Hanoi_1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",106],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2093"]]', '+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2094 : WGS 72BE / TM 106 NE 
--
(2094, 'EPSG', 2094, 'PROJCS["WGS 72BE / TM 106 NE",GEOGCS["WGS 72BE",DATUM["WGS_1972_Transit_Broadcast_Ephemeris",SPHEROID["WGS 72",6378135,298.26,AUTHORITY["EPSG","7043"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY["EPSG","6324"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4324"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",106],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2094"]]', '+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs '),
--
-- EPSG 2095 : Bissau / UTM zone 28N 
--
(2095, 'EPSG', 2095, 'PROJCS["Bissau / UTM zone 28N",GEOGCS["Bissau",DATUM["Bissau",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-173,253,27,0,0,0,0],AUTHORITY["EPSG","6165"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4165"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2095"]]', '+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2096 : Korean 1985 / East Belt 
--
(2096, 'EPSG', 2096, 'PROJCS["Korean 1985 / East Belt",GEOGCS["Korean 1985",DATUM["Korean_Datum_1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",38],PARAMETER["central_meridian",129],PARAMETER["scale_factor",1],PARAMETER["false_easting",200000],PARAMETER["false_northing",500000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2096"]]', '+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs '),
--
-- EPSG 2097 : Korean 1985 / Central Belt 
--
(2097, 'EPSG', 2097, 'PROJCS["Korean 1985 / Central Belt",GEOGCS["Korean 1985",DATUM["Korean_Datum_1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",38],PARAMETER["central_meridian",127],PARAMETER["scale_factor",1],PARAMETER["false_easting",200000],PARAMETER["false_northing",500000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2097"]]', '+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs '),
--
-- EPSG 2098 : Korean 1985 / West Belt 
--
(2098, 'EPSG', 2098, 'PROJCS["Korean 1985 / West Belt",GEOGCS["Korean 1985",DATUM["Korean_Datum_1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",38],PARAMETER["central_meridian",125],PARAMETER["scale_factor",1],PARAMETER["false_easting",200000],PARAMETER["false_northing",500000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2098"]]', '+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs '),
--
-- EPSG 2099 : Qatar 1948 / Qatar Grid 
--
(2099, 'EPSG', 2099, 'PROJCS["Qatar 1948 / Qatar Grid",GEOGCS["Qatar 1948",DATUM["Qatar_1948",SPHEROID["Helmert 1906",6378200,298.3,AUTHORITY["EPSG","7020"]],AUTHORITY["EPSG","6286"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4286"]],PROJECTION["Cassini_Soldner"],PARAMETER["latitude_of_origin",25.38236111111111],PARAMETER["central_meridian",50.76138888888889],PARAMETER["false_easting",100000],PARAMETER["false_northing",100000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2099"]]', '+proj=cass +lat_0=25.38236111111111 +lon_0=50.76138888888889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no_defs '),
--
-- EPSG 2100 : GGRS87 / Greek Grid 
--
(2100, 'EPSG', 2100, 'PROJCS["GGRS87 / Greek Grid",GEOGCS["GGRS87",DATUM["Greek_Geodetic_Reference_System_1987",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-199.87,74.79,246.62,0,0,0,0],AUTHORITY["EPSG","6121"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4121"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",24],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2100"]]', '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +datum=GGRS87 +units=m +no_defs '),
--
-- EPSG 2101 : Lake / Maracaibo Grid M1 
--
(2101, 'EPSG', 2101, 'PROJCS["Lake / Maracaibo Grid M1",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",10.16666666666667],PARAMETER["central_meridian",-71.60561777777777],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",-52684.972],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2101"]]', '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.972 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2102 : Lake / Maracaibo Grid 
--
(2102, 'EPSG', 2102, 'PROJCS["Lake / Maracaibo Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",10.16666666666667],PARAMETER["central_meridian",-71.60561777777777],PARAMETER["scale_factor",1],PARAMETER["false_easting",200000],PARAMETER["false_northing",147315.028],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2102"]]', '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=147315.028 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2103 : Lake / Maracaibo Grid M3 
--
(2103, 'EPSG', 2103, 'PROJCS["Lake / Maracaibo Grid M3",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",10.16666666666667],PARAMETER["central_meridian",-71.60561777777777],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",447315.028],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2103"]]', '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=447315.028 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2104 : Lake / Maracaibo La Rosa Grid 
--
(2104, 'EPSG', 2104, 'PROJCS["Lake / Maracaibo La Rosa Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",10.16666666666667],PARAMETER["central_meridian",-71.60561777777777],PARAMETER["scale_factor",1],PARAMETER["false_easting",-17044],PARAMETER["false_northing",-23139.97],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2104"]]', '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-23139.97 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2105 : NZGD2000 / Mount Eden 2000 
--
(2105, 'EPSG', 2105, 'PROJCS["NZGD2000 / Mount Eden 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-36.87972222222222],PARAMETER["central_meridian",174.7641666666667],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2105"]]', '+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2106 : NZGD2000 / Bay of Plenty 2000 
--
(2106, 'EPSG', 2106, 'PROJCS["NZGD2000 / Bay of Plenty 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-37.76111111111111],PARAMETER["central_meridian",176.4661111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2106"]]', '+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2107 : NZGD2000 / Poverty Bay 2000 
--
(2107, 'EPSG', 2107, 'PROJCS["NZGD2000 / Poverty Bay 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-38.62444444444444],PARAMETER["central_meridian",177.8855555555556],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2107"]]', '+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2108 : NZGD2000 / Hawkes Bay 2000 
--
(2108, 'EPSG', 2108, 'PROJCS["NZGD2000 / Hawkes Bay 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-39.65083333333333],PARAMETER["central_meridian",176.6736111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2108"]]', '+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2109 : NZGD2000 / Taranaki 2000 
--
(2109, 'EPSG', 2109, 'PROJCS["NZGD2000 / Taranaki 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-39.13555555555556],PARAMETER["central_meridian",174.2277777777778],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2109"]]', '+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2110 : NZGD2000 / Tuhirangi 2000 
--
(2110, 'EPSG', 2110, 'PROJCS["NZGD2000 / Tuhirangi 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-39.51222222222222],PARAMETER["central_meridian",175.64],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2110"]]', '+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2111 : NZGD2000 / Wanganui 2000 
--
(2111, 'EPSG', 2111, 'PROJCS["NZGD2000 / Wanganui 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-40.24194444444444],PARAMETER["central_meridian",175.4880555555555],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2111"]]', '+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2112 : NZGD2000 / Wairarapa 2000 
--
(2112, 'EPSG', 2112, 'PROJCS["NZGD2000 / Wairarapa 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-40.92527777777777],PARAMETER["central_meridian",175.6472222222222],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2112"]]', '+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2113 : NZGD2000 / Wellington 2000 
--
(2113, 'EPSG', 2113, 'PROJCS["NZGD2000 / Wellington 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-41.3011111111111],PARAMETER["central_meridian",174.7763888888889],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2113"]]', '+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.7763888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2114 : NZGD2000 / Collingwood 2000 
--
(2114, 'EPSG', 2114, 'PROJCS["NZGD2000 / Collingwood 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-40.71472222222223],PARAMETER["central_meridian",172.6719444444444],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2114"]]', '+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2115 : NZGD2000 / Nelson 2000 
--
(2115, 'EPSG', 2115, 'PROJCS["NZGD2000 / Nelson 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-41.27444444444444],PARAMETER["central_meridian",173.2991666666667],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2115"]]', '+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2116 : NZGD2000 / Karamea 2000 
--
(2116, 'EPSG', 2116, 'PROJCS["NZGD2000 / Karamea 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-41.28972222222222],PARAMETER["central_meridian",172.1088888888889],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2116"]]', '+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2117 : NZGD2000 / Buller 2000 
--
(2117, 'EPSG', 2117, 'PROJCS["NZGD2000 / Buller 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-41.81055555555555],PARAMETER["central_meridian",171.5811111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2117"]]', '+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2118 : NZGD2000 / Grey 2000 
--
(2118, 'EPSG', 2118, 'PROJCS["NZGD2000 / Grey 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-42.33361111111111],PARAMETER["central_meridian",171.5497222222222],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2118"]]', '+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2119 : NZGD2000 / Amuri 2000 
--
(2119, 'EPSG', 2119, 'PROJCS["NZGD2000 / Amuri 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-42.68888888888888],PARAMETER["central_meridian",173.01],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2119"]]', '+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2120 : NZGD2000 / Marlborough 2000 
--
(2120, 'EPSG', 2120, 'PROJCS["NZGD2000 / Marlborough 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-41.54444444444444],PARAMETER["central_meridian",173.8019444444444],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2120"]]', '+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2121 : NZGD2000 / Hokitika 2000 
--
(2121, 'EPSG', 2121, 'PROJCS["NZGD2000 / Hokitika 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-42.88611111111111],PARAMETER["central_meridian",170.9797222222222],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2121"]]', '+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2122 : NZGD2000 / Okarito 2000 
--
(2122, 'EPSG', 2122, 'PROJCS["NZGD2000 / Okarito 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-43.11],PARAMETER["central_meridian",170.2608333333333],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2122"]]', '+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2123 : NZGD2000 / Jacksons Bay 2000 
--
(2123, 'EPSG', 2123, 'PROJCS["NZGD2000 / Jacksons Bay 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-43.97777777777778],PARAMETER["central_meridian",168.6061111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2123"]]', '+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2124 : NZGD2000 / Mount Pleasant 2000 
--
(2124, 'EPSG', 2124, 'PROJCS["NZGD2000 / Mount Pleasant 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-43.59055555555556],PARAMETER["central_meridian",172.7269444444445],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2124"]]', '+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2125 : NZGD2000 / Gawler 2000 
--
(2125, 'EPSG', 2125, 'PROJCS["NZGD2000 / Gawler 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-43.74861111111111],PARAMETER["central_meridian",171.3605555555555],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2125"]]', '+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2126 : NZGD2000 / Timaru 2000 
--
(2126, 'EPSG', 2126, 'PROJCS["NZGD2000 / Timaru 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-44.40194444444445],PARAMETER["central_meridian",171.0572222222222],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2126"]]', '+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2127 : NZGD2000 / Lindis Peak 2000 
--
(2127, 'EPSG', 2127, 'PROJCS["NZGD2000 / Lindis Peak 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-44.735],PARAMETER["central_meridian",169.4675],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2127"]]', '+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2128 : NZGD2000 / Mount Nicholas 2000 
--
(2128, 'EPSG', 2128, 'PROJCS["NZGD2000 / Mount Nicholas 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-45.13277777777778],PARAMETER["central_meridian",168.3986111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2128"]]', '+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2129 : NZGD2000 / Mount York 2000 
--
(2129, 'EPSG', 2129, 'PROJCS["NZGD2000 / Mount York 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-45.56361111111111],PARAMETER["central_meridian",167.7386111111111],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2129"]]', '+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2130 : NZGD2000 / Observation Point 2000 
--
(2130, 'EPSG', 2130, 'PROJCS["NZGD2000 / Observation Point 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-45.81611111111111],PARAMETER["central_meridian",170.6283333333333],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2130"]]', '+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2131 : NZGD2000 / North Taieri 2000 
--
(2131, 'EPSG', 2131, 'PROJCS["NZGD2000 / North Taieri 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-45.86138888888889],PARAMETER["central_meridian",170.2825],PARAMETER["scale_factor",0.99996],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2131"]]', '+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2132 : NZGD2000 / Bluff 2000 
--
(2132, 'EPSG', 2132, 'PROJCS["NZGD2000 / Bluff 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",-46.6],PARAMETER["central_meridian",168.3427777777778],PARAMETER["scale_factor",1],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2132"]]', '+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2133 : NZGD2000 / UTM zone 58S 
--
(2133, 'EPSG', 2133, 'PROJCS["NZGD2000 / UTM zone 58S",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",165],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2133"]]', '+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2134 : NZGD2000 / UTM zone 59S 
--
(2134, 'EPSG', 2134, 'PROJCS["NZGD2000 / UTM zone 59S",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",171],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2134"]]', '+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2135 : NZGD2000 / UTM zone 60S 
--
(2135, 'EPSG', 2135, 'PROJCS["NZGD2000 / UTM zone 60S",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",177],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2135"]]', '+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2136 : Accra / Ghana National Grid 
--
(2136, 'EPSG', 2136, 'PROJCS["Accra / Ghana National Grid",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",4.666666666666667],PARAMETER["central_meridian",-1],PARAMETER["scale_factor",0.99975],PARAMETER["false_easting",900000],PARAMETER["false_northing",0],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2136"]]', '+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997101815088 +no_defs '),
--
-- EPSG 2137 : Accra / TM 1 NW 
--
(2137, 'EPSG', 2137, 'PROJCS["Accra / TM 1 NW",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-1],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2137"]]', '+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2138 : NAD27(CGQ77) / Quebec Lambert 
--
(2138, 'EPSG', 2138, 'PROJCS["NAD27(CGQ77) / Quebec Lambert",GEOGCS["NAD27(CGQ77)",DATUM["North_American_Datum_1927_CGQ77",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4609"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",60],PARAMETER["standard_parallel_2",46],PARAMETER["latitude_of_origin",44],PARAMETER["central_meridian",-68.5],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2138"]]', '+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs '),
--
-- EPSG 2139 : NAD83(CSRS98) / SCoPQ zone 2 (deprecated) 
--
(2139, 'EPSG', 2139, 'PROJCS["NAD83(CSRS98) / SCoPQ zone 2 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-55.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2139"]]', '+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2140 : NAD83(CSRS98) / MTM zone 3 (deprecated) 
--
(2140, 'EPSG', 2140, 'PROJCS["NAD83(CSRS98) / MTM zone 3 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-58.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2140"]]', '+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2141 : NAD83(CSRS98) / MTM zone 4 (deprecated) 
--
(2141, 'EPSG', 2141, 'PROJCS["NAD83(CSRS98) / MTM zone 4 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-61.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2141"]]', '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2142 : NAD83(CSRS98) / MTM zone 5 (deprecated) 
--
(2142, 'EPSG', 2142, 'PROJCS["NAD83(CSRS98) / MTM zone 5 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-64.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2142"]]', '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2143 : NAD83(CSRS98) / MTM zone 6 (deprecated) 
--
(2143, 'EPSG', 2143, 'PROJCS["NAD83(CSRS98) / MTM zone 6 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-67.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2143"]]', '+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2144 : NAD83(CSRS98) / MTM zone 7 (deprecated) 
--
(2144, 'EPSG', 2144, 'PROJCS["NAD83(CSRS98) / MTM zone 7 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-70.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2144"]]', '+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2145 : NAD83(CSRS98) / MTM zone 8 (deprecated) 
--
(2145, 'EPSG', 2145, 'PROJCS["NAD83(CSRS98) / MTM zone 8 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-73.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2145"]]', '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2146 : NAD83(CSRS98) / MTM zone 9 (deprecated) 
--
(2146, 'EPSG', 2146, 'PROJCS["NAD83(CSRS98) / MTM zone 9 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-76.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2146"]]', '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2147 : NAD83(CSRS98) / MTM zone 10 (deprecated) 
--
(2147, 'EPSG', 2147, 'PROJCS["NAD83(CSRS98) / MTM zone 10 (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-79.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",304800],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2147"]]', '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2148 : NAD83(CSRS98) / UTM zone 21N (deprecated) 
--
(2148, 'EPSG', 2148, 'PROJCS["NAD83(CSRS98) / UTM zone 21N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-57],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2148"]]', '+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2149 : NAD83(CSRS98) / UTM zone 18N (deprecated) 
--
(2149, 'EPSG', 2149, 'PROJCS["NAD83(CSRS98) / UTM zone 18N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-75],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2149"]]', '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2150 : NAD83(CSRS98) / UTM zone 17N (deprecated) 
--
(2150, 'EPSG', 2150, 'PROJCS["NAD83(CSRS98) / UTM zone 17N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2150"]]', '+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2151 : NAD83(CSRS98) / UTM zone 13N (deprecated) 
--
(2151, 'EPSG', 2151, 'PROJCS["NAD83(CSRS98) / UTM zone 13N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-105],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2151"]]', '+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2152 : NAD83(CSRS98) / UTM zone 12N (deprecated) 
--
(2152, 'EPSG', 2152, 'PROJCS["NAD83(CSRS98) / UTM zone 12N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-111],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2152"]]', '+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2153 : NAD83(CSRS98) / UTM zone 11N (deprecated) 
--
(2153, 'EPSG', 2153, 'PROJCS["NAD83(CSRS98) / UTM zone 11N (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-117],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2153"]]', '+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2154 : RGF93 / Lambert-93 
--
(2154, 'EPSG', 2154, 'PROJCS["RGF93 / Lambert-93",GEOGCS["RGF93",DATUM["Reseau_Geodesique_Francais_1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6171"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4171"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",49],PARAMETER["standard_parallel_2",44],PARAMETER["latitude_of_origin",46.5],PARAMETER["central_meridian",3],PARAMETER["false_easting",700000],PARAMETER["false_northing",6600000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2154"]]', '+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2155 : American Samoa 1962 / American Samoa Lambert (deprecated) 
--
(2155, 'EPSG', 2155, 'PROJCS["American Samoa 1962 / American Samoa Lambert (deprecated)",GEOGCS["American Samoa 1962",DATUM["American_Samoa_1962",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115,118,426,0,0,0,0],AUTHORITY["EPSG","6169"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4169"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",-14.26666666666667],PARAMETER["central_meridian",170],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2155"]]', '+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs '),
--
-- EPSG 2156 : NAD83(HARN) / UTM zone 59S (deprecated) 
--
(2156, 'EPSG', 2156, 'PROJCS["NAD83(HARN) / UTM zone 59S (deprecated)",GEOGCS["NAD83(HARN)",DATUM["NAD83_High_Accuracy_Reference_Network",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",171],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2156"]]', '+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2157 : IRENET95 / Irish Transverse Mercator 
--
(2157, 'EPSG', 2157, 'PROJCS["IRENET95 / Irish Transverse Mercator",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",53.5],PARAMETER["central_meridian",-8],PARAMETER["scale_factor",0.99982],PARAMETER["false_easting",600000],PARAMETER["false_northing",750000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2157"]]', '+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2158 : IRENET95 / UTM zone 29N 
--
(2158, 'EPSG', 2158, 'PROJCS["IRENET95 / UTM zone 29N",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2158"]]', '+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2159 : Sierra Leone 1924 / New Colony Grid 
--
(2159, 'EPSG', 2159, 'PROJCS["Sierra Leone 1924 / New Colony Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra_Leone_Colony_1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",6.666666666666667],PARAMETER["central_meridian",-12],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2159"]]', '+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs '),
--
-- EPSG 2160 : Sierra Leone 1924 / New War Office Grid 
--
(2160, 'EPSG', 2160, 'PROJCS["Sierra Leone 1924 / New War Office Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra_Leone_Colony_1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",6.666666666666667],PARAMETER["central_meridian",-12],PARAMETER["scale_factor",1],PARAMETER["false_easting",800000],PARAMETER["false_northing",600000],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2160"]]', '+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs '),
--
-- EPSG 2161 : Sierra Leone 1968 / UTM zone 28N 
--
(2161, 'EPSG', 2161, 'PROJCS["Sierra Leone 1968 / UTM zone 28N",GEOGCS["Sierra Leone 1968",DATUM["Sierra_Leone_1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2161"]]', '+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2162 : Sierra Leone 1968 / UTM zone 29N 
--
(2162, 'EPSG', 2162, 'PROJCS["Sierra Leone 1968 / UTM zone 29N",GEOGCS["Sierra Leone 1968",DATUM["Sierra_Leone_1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2162"]]', '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2163 : US National Atlas Equal Area 
--
(2163, 'EPSG', 2163, 'PROJCS["US National Atlas Equal Area",GEOGCS["Unspecified datum based upon the Clarke 1866 Authalic Sphere",DATUM["Not_specified_based_on_Clarke_1866_Authalic_Sphere",SPHEROID["Clarke 1866 Authalic Sphere",6370997,0,AUTHORITY["EPSG","7052"]],AUTHORITY["EPSG","6052"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4052"]],PROJECTION["Lambert_Azimuthal_Equal_Area"],PARAMETER["latitude_of_center",45],PARAMETER["longitude_of_center",-100],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2163"]]', '+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 +b=6370997 +units=m +no_defs '),
--
-- EPSG 2164 : Locodjo 1965 / TM 5 NW 
--
(2164, 'EPSG', 2164, 'PROJCS["Locodjo 1965 / TM 5 NW",GEOGCS["Locodjo 1965",DATUM["Locodjo_1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-5],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2164"]]', '+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2165 : Abidjan 1987 / TM 5 NW 
--
(2165, 'EPSG', 2165, 'PROJCS["Abidjan 1987 / TM 5 NW",GEOGCS["Abidjan 1987",DATUM["Abidjan_1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-5],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2165"]]', '+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2166 : Pulkovo 1942(83) / Gauss Kruger zone 3 (deprecated) 
--
(2166, 'EPSG', 2166, 'PROJCS["Pulkovo 1942(83) / Gauss Kruger zone 3 (deprecated)",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9],PARAMETER["scale_factor",1],PARAMETER["false_easting",3500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2166"]]', '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2167 : Pulkovo 1942(83) / Gauss Kruger zone 4 (deprecated) 
--
(2167, 'EPSG', 2167, 'PROJCS["Pulkovo 1942(83) / Gauss Kruger zone 4 (deprecated)",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",12],PARAMETER["scale_factor",1],PARAMETER["false_easting",4500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2167"]]', '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2168 : Pulkovo 1942(83) / Gauss Kruger zone 5 (deprecated) 
--
(2168, 'EPSG', 2168, 'PROJCS["Pulkovo 1942(83) / Gauss Kruger zone 5 (deprecated)",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",1],PARAMETER["false_easting",5500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2168"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2169 : Luxembourg 1930 / Gauss 
--
(2169, 'EPSG', 2169, 'PROJCS["Luxembourg 1930 / Gauss",GEOGCS["Luxembourg 1930",DATUM["Luxembourg_1930",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598],AUTHORITY["EPSG","6181"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4181"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",49.83333333333334],PARAMETER["central_meridian",6.166666666666667],PARAMETER["scale_factor",1],PARAMETER["false_easting",80000],PARAMETER["false_northing",100000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2169"]]', '+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.166666666666667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +units=m +no_defs '),
--
-- EPSG 2170 : MGI / Slovenia Grid (deprecated) 
--
(2170, 'EPSG', 2170, 'PROJCS["MGI / Slovenia Grid (deprecated)",GEOGCS["MGI",DATUM["Militar_Geographische_Institute",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUTHORITY["EPSG","6312"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4312"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2170"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=0 +datum=hermannskogel +units=m +no_defs '),
--
-- EPSG 2171 : Pulkovo 1942(58) / Poland zone I (deprecated) 
--
(2171, 'EPSG', 2171, 'PROJCS["Pulkovo 1942(58) / Poland zone I (deprecated)",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo_1942_58",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",50.625],PARAMETER["central_meridian",21.08333333333333],PARAMETER["scale_factor",0.9998],PARAMETER["false_easting",4637000],PARAMETER["false_northing",5647000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2171"]]', '+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs '),
--
-- EPSG 2172 : Pulkovo 1942(58) / Poland zone II 
--
(2172, 'EPSG', 2172, 'PROJCS["Pulkovo 1942(58) / Poland zone II",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo_1942_58",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",53.00194444444445],PARAMETER["central_meridian",21.50277777777778],PARAMETER["scale_factor",0.9998],PARAMETER["false_easting",4603000],PARAMETER["false_northing",5806000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2172"]]', '+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs '),
--
-- EPSG 2173 : Pulkovo 1942(58) / Poland zone III 
--
(2173, 'EPSG', 2173, 'PROJCS["Pulkovo 1942(58) / Poland zone III",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo_1942_58",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",53.58333333333334],PARAMETER["central_meridian",17.00833333333333],PARAMETER["scale_factor",0.9998],PARAMETER["false_easting",3501000],PARAMETER["false_northing",5999000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2173"]]', '+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs '),
--
-- EPSG 2174 : Pulkovo 1942(58) / Poland zone IV 
--
(2174, 'EPSG', 2174, 'PROJCS["Pulkovo 1942(58) / Poland zone IV",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo_1942_58",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",51.67083333333333],PARAMETER["central_meridian",16.67222222222222],PARAMETER["scale_factor",0.9998],PARAMETER["false_easting",3703000],PARAMETER["false_northing",5627000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2174"]]', '+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs '),
--
-- EPSG 2175 : Pulkovo 1942(58) / Poland zone V 
--
(2175, 'EPSG', 2175, 'PROJCS["Pulkovo 1942(58) / Poland zone V",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo_1942_58",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4179"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",18.95833333333333],PARAMETER["scale_factor",0.999983],PARAMETER["false_easting",237000],PARAMETER["false_northing",-4700000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2175"]]', '+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.999983 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs '),
--
-- EPSG 2176 : ETRS89 / Poland CS2000 zone 5 
--
(2176, 'EPSG', 2176, 'PROJCS["ETRS89 / Poland CS2000 zone 5",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.999923],PARAMETER["false_easting",5500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2176"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2177 : ETRS89 / Poland CS2000 zone 6 
--
(2177, 'EPSG', 2177, 'PROJCS["ETRS89 / Poland CS2000 zone 6",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",18],PARAMETER["scale_factor",0.999923],PARAMETER["false_easting",6500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2177"]]', '+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2178 : ETRS89 / Poland CS2000 zone 7 
--
(2178, 'EPSG', 2178, 'PROJCS["ETRS89 / Poland CS2000 zone 7",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",0.999923],PARAMETER["false_easting",7500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2178"]]', '+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2179 : ETRS89 / Poland CS2000 zone 8 
--
(2179, 'EPSG', 2179, 'PROJCS["ETRS89 / Poland CS2000 zone 8",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",24],PARAMETER["scale_factor",0.999923],PARAMETER["false_easting",8500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2179"]]', '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2180 : ETRS89 / Poland CS92 
--
(2180, 'EPSG', 2180, 'PROJCS["ETRS89 / Poland CS92",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",19],PARAMETER["scale_factor",0.9993],PARAMETER["false_easting",500000],PARAMETER["false_northing",-5300000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2180"]]', '+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2188 : Azores Occidental 1939 / UTM zone 25N 
--
(2188, 'EPSG', 2188, 'PROJCS["Azores Occidental 1939 / UTM zone 25N",GEOGCS["Azores Occidental 1939",DATUM["Azores_Occidental_Islands_1939",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-425,-169,81,0,0,0,0],AUTHORITY["EPSG","6182"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4182"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-33],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2188"]]', '+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2189 : Azores Central 1948 / UTM zone 26N 
--
(2189, 'EPSG', 2189, 'PROJCS["Azores Central 1948 / UTM zone 26N",GEOGCS["Azores Central 1948",DATUM["Azores_Central_Islands_1948",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-104,167,-38,0,0,0,0],AUTHORITY["EPSG","6183"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4183"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-27],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2189"]]', '+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2190 : Azores Oriental 1940 / UTM zone 26N 
--
(2190, 'EPSG', 2190, 'PROJCS["Azores Oriental 1940 / UTM zone 26N",GEOGCS["Azores Oriental 1940",DATUM["Azores_Oriental_Islands_1940",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-203,141,53,0,0,0,0],AUTHORITY["EPSG","6184"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4184"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-27],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2190"]]', '+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2191 : Madeira 1936 / UTM zone 28N (deprecated) 
--
(2191, 'EPSG', 2191, 'PROJCS["Madeira 1936 / UTM zone 28N (deprecated)",GEOGCS["Madeira 1936",DATUM["Madeira_1936",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6185"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4185"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2191"]]', '+proj=utm +zone=28 +ellps=intl +units=m +no_defs '),
--
-- EPSG 2192 : ED50 / France EuroLambert (deprecated) 
--
(2192, 'EPSG', 2192, 'PROJCS["ED50 / France EuroLambert (deprecated)",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",46.8],PARAMETER["central_meridian",2.337229166666667],PARAMETER["scale_factor",0.99987742],PARAMETER["false_easting",600000],PARAMETER["false_northing",2200000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2192"]]', '+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.337229166666667 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2193 : NZGD2000 / New Zealand Transverse Mercator 2000 
--
(2193, 'EPSG', 2193, 'PROJCS["NZGD2000 / New Zealand Transverse Mercator 2000",GEOGCS["NZGD2000",DATUM["New_Zealand_Geodetic_Datum_2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",173],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",1600000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2193"]]', '+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2194 : American Samoa 1962 / American Samoa Lambert (deprecated) 
--
(2194, 'EPSG', 2194, 'PROJCS["American Samoa 1962 / American Samoa Lambert (deprecated)",GEOGCS["American Samoa 1962",DATUM["American_Samoa_1962",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115,118,426,0,0,0,0],AUTHORITY["EPSG","6169"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4169"]],PROJECTION["Lambert_Conformal_Conic_1SP"],PARAMETER["latitude_of_origin",-14.26666666666667],PARAMETER["central_meridian",-170],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2194"]]', '+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs '),
--
-- EPSG 2195 : NAD83(HARN) / UTM zone 2S 
--
(2195, 'EPSG', 2195, 'PROJCS["NAD83(HARN) / UTM zone 2S",GEOGCS["NAD83(HARN)",DATUM["NAD83_High_Accuracy_Reference_Network",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-171],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2195"]]', '+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2196 : ETRS89 / Kp2000 Jutland 
--
(2196, 'EPSG', 2196, 'PROJCS["ETRS89 / Kp2000 Jutland",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9.5],PARAMETER["scale_factor",0.99995],PARAMETER["false_easting",200000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2196"]]', '+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2197 : ETRS89 / Kp2000 Zealand 
--
(2197, 'EPSG', 2197, 'PROJCS["ETRS89 / Kp2000 Zealand",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",12],PARAMETER["scale_factor",0.99995],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2197"]]', '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2198 : ETRS89 / Kp2000 Bornholm 
--
(2198, 'EPSG', 2198, 'PROJCS["ETRS89 / Kp2000 Bornholm",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",1],PARAMETER["false_easting",900000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2198"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2199 : Albanian 1987 / Gauss Kruger zone 4 (deprecated) 
--
(2199, 'EPSG', 2199, 'PROJCS["Albanian 1987 / Gauss Kruger zone 4 (deprecated)",GEOGCS["Albanian 1987",DATUM["Albanian_1987",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703],AUTHORITY["EPSG","6191"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4191"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",1],PARAMETER["false_easting",4500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2199"]]', '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703 +units=m +no_defs '),
--
-- EPSG 2200 : ATS77 / New Brunswick Stereographic (ATS77) 
--
(2200, 'EPSG', 2200, 'PROJCS["ATS77 / New Brunswick Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",46.5],PARAMETER["central_meridian",-66.5],PARAMETER["scale_factor",0.999912],PARAMETER["false_easting",300000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2200"]]', '+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=300000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2201 : REGVEN / UTM zone 18N 
--
(2201, 'EPSG', 2201, 'PROJCS["REGVEN / UTM zone 18N",GEOGCS["REGVEN",DATUM["Red_Geodesica_Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-75],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2201"]]', '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2202 : REGVEN / UTM zone 19N 
--
(2202, 'EPSG', 2202, 'PROJCS["REGVEN / UTM zone 19N",GEOGCS["REGVEN",DATUM["Red_Geodesica_Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2202"]]', '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2203 : REGVEN / UTM zone 20N 
--
(2203, 'EPSG', 2203, 'PROJCS["REGVEN / UTM zone 20N",GEOGCS["REGVEN",DATUM["Red_Geodesica_Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2203"]]', '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2204 : NAD27 / Tennessee 
--
(2204, 'EPSG', 2204, 'PROJCS["NAD27 / Tennessee",GEOGCS["NAD27",DATUM["North_American_Datum_1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4267"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",35.25],PARAMETER["standard_parallel_2",36.41666666666666],PARAMETER["latitude_of_origin",34.66666666666666],PARAMETER["central_meridian",-86],PARAMETER["false_easting",2000000],PARAMETER["false_northing",100000],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2204"]]', '+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=30480.06096012192 +datum=NAD27 +units=us-ft +no_defs '),
--
-- EPSG 2205 : NAD83 / Kentucky North 
--
(2205, 'EPSG', 2205, 'PROJCS["NAD83 / Kentucky North",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",37.96666666666667],PARAMETER["standard_parallel_2",38.96666666666667],PARAMETER["latitude_of_origin",37.5],PARAMETER["central_meridian",-84.25],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2205"]]', '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +datum=NAD83 +units=m +no_defs '),
--
-- EPSG 2206 : ED50 / 3-degree Gauss-Kruger zone 9 
--
(2206, 'EPSG', 2206, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 9",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",27],PARAMETER["scale_factor",1],PARAMETER["false_easting",9500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2206"]]', '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2207 : ED50 / 3-degree Gauss-Kruger zone 10 
--
(2207, 'EPSG', 2207, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 10",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",30],PARAMETER["scale_factor",1],PARAMETER["false_easting",10500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2207"]]', '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2208 : ED50 / 3-degree Gauss-Kruger zone 11 
--
(2208, 'EPSG', 2208, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 11",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",33],PARAMETER["scale_factor",1],PARAMETER["false_easting",11500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2208"]]', '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2209 : ED50 / 3-degree Gauss-Kruger zone 12 
--
(2209, 'EPSG', 2209, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 12",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",36],PARAMETER["scale_factor",1],PARAMETER["false_easting",12500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2209"]]', '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2210 : ED50 / 3-degree Gauss-Kruger zone 13 
--
(2210, 'EPSG', 2210, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 13",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",39],PARAMETER["scale_factor",1],PARAMETER["false_easting",13500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2210"]]', '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2211 : ED50 / 3-degree Gauss-Kruger zone 14 
--
(2211, 'EPSG', 2211, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 14",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",42],PARAMETER["scale_factor",1],PARAMETER["false_easting",14500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2211"]]', '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2212 : ED50 / 3-degree Gauss-Kruger zone 15 
--
(2212, 'EPSG', 2212, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 15",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",1],PARAMETER["false_easting",15500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2212"]]', '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2213 : ETRS89 / TM 30 NE 
--
(2213, 'EPSG', 2213, 'PROJCS["ETRS89 / TM 30 NE",GEOGCS["ETRS89",DATUM["European_Terrestrial_Reference_System_1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",30],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2213"]]', '+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2214 : Douala 1948 / AOF west (deprecated) 
--
(2214, 'EPSG', 2214, 'PROJCS["Douala 1948 / AOF west (deprecated)",GEOGCS["Douala 1948",DATUM["Douala_1948",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-206.1,-174.7,-87.7,0,0,0,0],AUTHORITY["EPSG","6192"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4192"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",10.5],PARAMETER["scale_factor",0.999],PARAMETER["false_easting",1000000],PARAMETER["false_northing",1000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2214"]]', '+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2215 : Manoca 1962 / UTM zone 32N 
--
(2215, 'EPSG', 2215, 'PROJCS["Manoca 1962 / UTM zone 32N",GEOGCS["Manoca 1962",DATUM["Manoca_1962",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY["EPSG","6193"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4193"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2215"]]', '+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2216 : Qornoq 1927 / UTM zone 22N 
--
(2216, 'EPSG', 2216, 'PROJCS["Qornoq 1927 / UTM zone 22N",GEOGCS["Qornoq 1927",DATUM["Qornoq_1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[164,138,-189,0,0,0,0],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-51],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2216"]]', '+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2217 : Qornoq 1927 / UTM zone 23N 
--
(2217, 'EPSG', 2217, 'PROJCS["Qornoq 1927 / UTM zone 23N",GEOGCS["Qornoq 1927",DATUM["Qornoq_1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[164,138,-189,0,0,0,0],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-45],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2217"]]', '+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2219 : ATS77 / UTM zone 19N 
--
(2219, 'EPSG', 2219, 'PROJCS["ATS77 / UTM zone 19N",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2219"]]', '+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2220 : ATS77 / UTM zone 20N 
--
(2220, 'EPSG', 2220, 'PROJCS["ATS77 / UTM zone 20N",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2220"]]', '+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2222 : NAD83 / Arizona East (ft) 
--
(2222, 'EPSG', 2222, 'PROJCS["NAD83 / Arizona East (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-110.1666666666667],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",700000],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2222"]]', '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2223 : NAD83 / Arizona Central (ft) 
--
(2223, 'EPSG', 2223, 'PROJCS["NAD83 / Arizona Central (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-111.9166666666667],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",700000],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2223"]]', '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2224 : NAD83 / Arizona West (ft) 
--
(2224, 'EPSG', 2224, 'PROJCS["NAD83 / Arizona West (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-113.75],PARAMETER["scale_factor",0.999933333],PARAMETER["false_easting",700000],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2224"]]', '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2225 : NAD83 / California zone 1 (ftUS) 
--
(2225, 'EPSG', 2225, 'PROJCS["NAD83 / California zone 1 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.66666666666666],PARAMETER["standard_parallel_2",40],PARAMETER["latitude_of_origin",39.33333333333334],PARAMETER["central_meridian",-122],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2225"]]', '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2226 : NAD83 / California zone 2 (ftUS) 
--
(2226, 'EPSG', 2226, 'PROJCS["NAD83 / California zone 2 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",39.83333333333334],PARAMETER["standard_parallel_2",38.33333333333334],PARAMETER["latitude_of_origin",37.66666666666666],PARAMETER["central_meridian",-122],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2226"]]', '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2227 : NAD83 / California zone 3 (ftUS) 
--
(2227, 'EPSG', 2227, 'PROJCS["NAD83 / California zone 3 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",38.43333333333333],PARAMETER["standard_parallel_2",37.06666666666667],PARAMETER["latitude_of_origin",36.5],PARAMETER["central_meridian",-120.5],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2227"]]', '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2228 : NAD83 / California zone 4 (ftUS) 
--
(2228, 'EPSG', 2228, 'PROJCS["NAD83 / California zone 4 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",37.25],PARAMETER["standard_parallel_2",36],PARAMETER["latitude_of_origin",35.33333333333334],PARAMETER["central_meridian",-119],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2228"]]', '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2229 : NAD83 / California zone 5 (ftUS) 
--
(2229, 'EPSG', 2229, 'PROJCS["NAD83 / California zone 5 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",35.46666666666667],PARAMETER["standard_parallel_2",34.03333333333333],PARAMETER["latitude_of_origin",33.5],PARAMETER["central_meridian",-118],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2229"]]', '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2230 : NAD83 / California zone 6 (ftUS) 
--
(2230, 'EPSG', 2230, 'PROJCS["NAD83 / California zone 6 (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",33.88333333333333],PARAMETER["standard_parallel_2",32.78333333333333],PARAMETER["latitude_of_origin",32.16666666666666],PARAMETER["central_meridian",-116.25],PARAMETER["false_easting",6561666.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2230"]]', '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2231 : NAD83 / Colorado North (ftUS) 
--
(2231, 'EPSG', 2231, 'PROJCS["NAD83 / Colorado North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",40.78333333333333],PARAMETER["standard_parallel_2",39.71666666666667],PARAMETER["latitude_of_origin",39.33333333333334],PARAMETER["central_meridian",-105.5],PARAMETER["false_easting",3000000],PARAMETER["false_northing",1000000],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2231"]]', '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2232 : NAD83 / Colorado Central (ftUS) 
--
(2232, 'EPSG', 2232, 'PROJCS["NAD83 / Colorado Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",39.75],PARAMETER["standard_parallel_2",38.45],PARAMETER["latitude_of_origin",37.83333333333334],PARAMETER["central_meridian",-105.5],PARAMETER["false_easting",3000000],PARAMETER["false_northing",1000000],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2232"]]', '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2233 : NAD83 / Colorado South (ftUS) 
--
(2233, 'EPSG', 2233, 'PROJCS["NAD83 / Colorado South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",38.43333333333333],PARAMETER["standard_parallel_2",37.23333333333333],PARAMETER["latitude_of_origin",36.66666666666666],PARAMETER["central_meridian",-105.5],PARAMETER["false_easting",3000000],PARAMETER["false_northing",1000000],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2233"]]', '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2234 : NAD83 / Connecticut (ftUS) 
--
(2234, 'EPSG', 2234, 'PROJCS["NAD83 / Connecticut (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.86666666666667],PARAMETER["standard_parallel_2",41.2],PARAMETER["latitude_of_origin",40.83333333333334],PARAMETER["central_meridian",-72.75],PARAMETER["false_easting",1000000],PARAMETER["false_northing",500000],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2234"]]', '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2235 : NAD83 / Delaware (ftUS) 
--
(2235, 'EPSG', 2235, 'PROJCS["NAD83 / Delaware (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",38],PARAMETER["central_meridian",-75.41666666666667],PARAMETER["scale_factor",0.999995],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2235"]]', '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2236 : NAD83 / Florida East (ftUS) 
--
(2236, 'EPSG', 2236, 'PROJCS["NAD83 / Florida East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",24.33333333333333],PARAMETER["central_meridian",-81],PARAMETER["scale_factor",0.999941177],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2236"]]', '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2237 : NAD83 / Florida West (ftUS) 
--
(2237, 'EPSG', 2237, 'PROJCS["NAD83 / Florida West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",24.33333333333333],PARAMETER["central_meridian",-82],PARAMETER["scale_factor",0.999941177],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2237"]]', '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2238 : NAD83 / Florida North (ftUS) 
--
(2238, 'EPSG', 2238, 'PROJCS["NAD83 / Florida North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",30.75],PARAMETER["standard_parallel_2",29.58333333333333],PARAMETER["latitude_of_origin",29],PARAMETER["central_meridian",-84.5],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2238"]]', '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2239 : NAD83 / Georgia East (ftUS) 
--
(2239, 'EPSG', 2239, 'PROJCS["NAD83 / Georgia East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",30],PARAMETER["central_meridian",-82.16666666666667],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2239"]]', '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2240 : NAD83 / Georgia West (ftUS) 
--
(2240, 'EPSG', 2240, 'PROJCS["NAD83 / Georgia West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",30],PARAMETER["central_meridian",-84.16666666666667],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",2296583.333],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2240"]]', '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2241 : NAD83 / Idaho East (ftUS) 
--
(2241, 'EPSG', 2241, 'PROJCS["NAD83 / Idaho East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",41.66666666666666],PARAMETER["central_meridian",-112.1666666666667],PARAMETER["scale_factor",0.999947368],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2241"]]', '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2242 : NAD83 / Idaho Central (ftUS) 
--
(2242, 'EPSG', 2242, 'PROJCS["NAD83 / Idaho Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",41.66666666666666],PARAMETER["central_meridian",-114],PARAMETER["scale_factor",0.999947368],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2242"]]', '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2243 : NAD83 / Idaho West (ftUS) 
--
(2243, 'EPSG', 2243, 'PROJCS["NAD83 / Idaho West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",41.66666666666666],PARAMETER["central_meridian",-115.75],PARAMETER["scale_factor",0.999933333],PARAMETER["false_easting",2624666.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2243"]]', '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2244 : NAD83 / Indiana East (ftUS) (deprecated) 
--
(2244, 'EPSG', 2244, 'PROJCS["NAD83 / Indiana East (ftUS) (deprecated)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",37.5],PARAMETER["central_meridian",-85.66666666666667],PARAMETER["scale_factor",0.999966667],PARAMETER["false_easting",328083.333],PARAMETER["false_northing",818125],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2244"]]', '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2245 : NAD83 / Indiana West (ftUS) (deprecated) 
--
(2245, 'EPSG', 2245, 'PROJCS["NAD83 / Indiana West (ftUS) (deprecated)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",37.5],PARAMETER["central_meridian",-87.08333333333333],PARAMETER["scale_factor",0.999966667],PARAMETER["false_easting",2952750],PARAMETER["false_northing",818125],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2245"]]', '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2246 : NAD83 / Kentucky North (ftUS) 
--
(2246, 'EPSG', 2246, 'PROJCS["NAD83 / Kentucky North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",37.96666666666667],PARAMETER["standard_parallel_2",38.96666666666667],PARAMETER["latitude_of_origin",37.5],PARAMETER["central_meridian",-84.25],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2246"]]', '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2247 : NAD83 / Kentucky South (ftUS) 
--
(2247, 'EPSG', 2247, 'PROJCS["NAD83 / Kentucky South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",37.93333333333333],PARAMETER["standard_parallel_2",36.73333333333333],PARAMETER["latitude_of_origin",36.33333333333334],PARAMETER["central_meridian",-85.75],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",1640416.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2247"]]', '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2248 : NAD83 / Maryland (ftUS) 
--
(2248, 'EPSG', 2248, 'PROJCS["NAD83 / Maryland (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",39.45],PARAMETER["standard_parallel_2",38.3],PARAMETER["latitude_of_origin",37.66666666666666],PARAMETER["central_meridian",-77],PARAMETER["false_easting",1312333.333],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2248"]]', '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2249 : NAD83 / Massachusetts Mainland (ftUS) 
--
(2249, 'EPSG', 2249, 'PROJCS["NAD83 / Massachusetts Mainland (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",42.68333333333333],PARAMETER["standard_parallel_2",41.71666666666667],PARAMETER["latitude_of_origin",41],PARAMETER["central_meridian",-71.5],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",2460625],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2249"]]', '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2250 : NAD83 / Massachusetts Island (ftUS) 
--
(2250, 'EPSG', 2250, 'PROJCS["NAD83 / Massachusetts Island (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.48333333333333],PARAMETER["standard_parallel_2",41.28333333333333],PARAMETER["latitude_of_origin",41],PARAMETER["central_meridian",-70.5],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2250"]]', '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2251 : NAD83 / Michigan North (ft) 
--
(2251, 'EPSG', 2251, 'PROJCS["NAD83 / Michigan North (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",47.08333333333334],PARAMETER["standard_parallel_2",45.48333333333333],PARAMETER["latitude_of_origin",44.78333333333333],PARAMETER["central_meridian",-87],PARAMETER["false_easting",26246719.16],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2251"]]', '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2252 : NAD83 / Michigan Central (ft) 
--
(2252, 'EPSG', 2252, 'PROJCS["NAD83 / Michigan Central (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",45.7],PARAMETER["standard_parallel_2",44.18333333333333],PARAMETER["latitude_of_origin",43.31666666666667],PARAMETER["central_meridian",-84.36666666666666],PARAMETER["false_easting",19685039.37],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2252"]]', '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2253 : NAD83 / Michigan South (ft) 
--
(2253, 'EPSG', 2253, 'PROJCS["NAD83 / Michigan South (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",43.66666666666666],PARAMETER["standard_parallel_2",42.1],PARAMETER["latitude_of_origin",41.5],PARAMETER["central_meridian",-84.36666666666666],PARAMETER["false_easting",13123359.58],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2253"]]', '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2254 : NAD83 / Mississippi East (ftUS) 
--
(2254, 'EPSG', 2254, 'PROJCS["NAD83 / Mississippi East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",29.5],PARAMETER["central_meridian",-88.83333333333333],PARAMETER["scale_factor",0.99995],PARAMETER["false_easting",984250.0000000002],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2254"]]', '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2255 : NAD83 / Mississippi West (ftUS) 
--
(2255, 'EPSG', 2255, 'PROJCS["NAD83 / Mississippi West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",29.5],PARAMETER["central_meridian",-90.33333333333333],PARAMETER["scale_factor",0.99995],PARAMETER["false_easting",2296583.333],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2255"]]', '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2256 : NAD83 / Montana (ft) 
--
(2256, 'EPSG', 2256, 'PROJCS["NAD83 / Montana (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",49],PARAMETER["standard_parallel_2",45],PARAMETER["latitude_of_origin",44.25],PARAMETER["central_meridian",-109.5],PARAMETER["false_easting",1968503.937],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2256"]]', '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2257 : NAD83 / New Mexico East (ftUS) 
--
(2257, 'EPSG', 2257, 'PROJCS["NAD83 / New Mexico East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-104.3333333333333],PARAMETER["scale_factor",0.999909091],PARAMETER["false_easting",541337.5],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2257"]]', '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2258 : NAD83 / New Mexico Central (ftUS) 
--
(2258, 'EPSG', 2258, 'PROJCS["NAD83 / New Mexico Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-106.25],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2258"]]', '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2259 : NAD83 / New Mexico West (ftUS) 
--
(2259, 'EPSG', 2259, 'PROJCS["NAD83 / New Mexico West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",31],PARAMETER["central_meridian",-107.8333333333333],PARAMETER["scale_factor",0.999916667],PARAMETER["false_easting",2723091.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2259"]]', '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2260 : NAD83 / New York East (ftUS) 
--
(2260, 'EPSG', 2260, 'PROJCS["NAD83 / New York East (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",38.83333333333334],PARAMETER["central_meridian",-74.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",492125],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2260"]]', '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2261 : NAD83 / New York Central (ftUS) 
--
(2261, 'EPSG', 2261, 'PROJCS["NAD83 / New York Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",40],PARAMETER["central_meridian",-76.58333333333333],PARAMETER["scale_factor",0.9999375],PARAMETER["false_easting",820208.3330000002],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2261"]]', '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2262 : NAD83 / New York West (ftUS) 
--
(2262, 'EPSG', 2262, 'PROJCS["NAD83 / New York West (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",40],PARAMETER["central_meridian",-78.58333333333333],PARAMETER["scale_factor",0.9999375],PARAMETER["false_easting",1148291.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2262"]]', '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2263 : NAD83 / New York Long Island (ftUS) 
--
(2263, 'EPSG', 2263, 'PROJCS["NAD83 / New York Long Island (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.03333333333333],PARAMETER["standard_parallel_2",40.66666666666666],PARAMETER["latitude_of_origin",40.16666666666666],PARAMETER["central_meridian",-74],PARAMETER["false_easting",984250.0000000002],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2263"]]', '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2264 : NAD83 / North Carolina (ftUS) 
--
(2264, 'EPSG', 2264, 'PROJCS["NAD83 / North Carolina (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",36.16666666666666],PARAMETER["standard_parallel_2",34.33333333333334],PARAMETER["latitude_of_origin",33.75],PARAMETER["central_meridian",-79],PARAMETER["false_easting",2000000],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2264"]]', '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2265 : NAD83 / North Dakota North (ft) 
--
(2265, 'EPSG', 2265, 'PROJCS["NAD83 / North Dakota North (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",48.73333333333333],PARAMETER["standard_parallel_2",47.43333333333333],PARAMETER["latitude_of_origin",47],PARAMETER["central_meridian",-100.5],PARAMETER["false_easting",1968503.937],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2265"]]', '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2266 : NAD83 / North Dakota South (ft) 
--
(2266, 'EPSG', 2266, 'PROJCS["NAD83 / North Dakota South (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",47.48333333333333],PARAMETER["standard_parallel_2",46.18333333333333],PARAMETER["latitude_of_origin",45.66666666666666],PARAMETER["central_meridian",-100.5],PARAMETER["false_easting",1968503.937],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2266"]]', '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2267 : NAD83 / Oklahoma North (ftUS) 
--
(2267, 'EPSG', 2267, 'PROJCS["NAD83 / Oklahoma North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",36.76666666666667],PARAMETER["standard_parallel_2",35.56666666666667],PARAMETER["latitude_of_origin",35],PARAMETER["central_meridian",-98],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2267"]]', '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2268 : NAD83 / Oklahoma South (ftUS) 
--
(2268, 'EPSG', 2268, 'PROJCS["NAD83 / Oklahoma South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",35.23333333333333],PARAMETER["standard_parallel_2",33.93333333333333],PARAMETER["latitude_of_origin",33.33333333333334],PARAMETER["central_meridian",-98],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2268"]]', '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2269 : NAD83 / Oregon North (ft) 
--
(2269, 'EPSG', 2269, 'PROJCS["NAD83 / Oregon North (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",46],PARAMETER["standard_parallel_2",44.33333333333334],PARAMETER["latitude_of_origin",43.66666666666666],PARAMETER["central_meridian",-120.5],PARAMETER["false_easting",8202099.738],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2269"]]', '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2270 : NAD83 / Oregon South (ft) 
--
(2270, 'EPSG', 2270, 'PROJCS["NAD83 / Oregon South (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",44],PARAMETER["standard_parallel_2",42.33333333333334],PARAMETER["latitude_of_origin",41.66666666666666],PARAMETER["central_meridian",-120.5],PARAMETER["false_easting",4921259.843],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2270"]]', '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2271 : NAD83 / Pennsylvania North (ftUS) 
--
(2271, 'EPSG', 2271, 'PROJCS["NAD83 / Pennsylvania North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.95],PARAMETER["standard_parallel_2",40.88333333333333],PARAMETER["latitude_of_origin",40.16666666666666],PARAMETER["central_meridian",-77.75],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2271"]]', '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2272 : NAD83 / Pennsylvania South (ftUS) 
--
(2272, 'EPSG', 2272, 'PROJCS["NAD83 / Pennsylvania South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",40.96666666666667],PARAMETER["standard_parallel_2",39.93333333333333],PARAMETER["latitude_of_origin",39.33333333333334],PARAMETER["central_meridian",-77.75],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2272"]]', '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2273 : NAD83 / South Carolina (ft) 
--
(2273, 'EPSG', 2273, 'PROJCS["NAD83 / South Carolina (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",34.83333333333334],PARAMETER["standard_parallel_2",32.5],PARAMETER["latitude_of_origin",31.83333333333333],PARAMETER["central_meridian",-81],PARAMETER["false_easting",2000000],PARAMETER["false_northing",0],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2273"]]', '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2274 : NAD83 / Tennessee (ftUS) 
--
(2274, 'EPSG', 2274, 'PROJCS["NAD83 / Tennessee (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",36.41666666666666],PARAMETER["standard_parallel_2",35.25],PARAMETER["latitude_of_origin",34.33333333333334],PARAMETER["central_meridian",-86],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2274"]]', '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2275 : NAD83 / Texas North (ftUS) 
--
(2275, 'EPSG', 2275, 'PROJCS["NAD83 / Texas North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",36.18333333333333],PARAMETER["standard_parallel_2",34.65],PARAMETER["latitude_of_origin",34],PARAMETER["central_meridian",-101.5],PARAMETER["false_easting",656166.667],PARAMETER["false_northing",3280833.333],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2275"]]', '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2276 : NAD83 / Texas North Central (ftUS) 
--
(2276, 'EPSG', 2276, 'PROJCS["NAD83 / Texas North Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",33.96666666666667],PARAMETER["standard_parallel_2",32.13333333333333],PARAMETER["latitude_of_origin",31.66666666666667],PARAMETER["central_meridian",-98.5],PARAMETER["false_easting",1968500],PARAMETER["false_northing",6561666.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2276"]]', '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2277 : NAD83 / Texas Central (ftUS) 
--
(2277, 'EPSG', 2277, 'PROJCS["NAD83 / Texas Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",31.88333333333333],PARAMETER["standard_parallel_2",30.11666666666667],PARAMETER["latitude_of_origin",29.66666666666667],PARAMETER["central_meridian",-100.3333333333333],PARAMETER["false_easting",2296583.333],PARAMETER["false_northing",9842500.000000002],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2277"]]', '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2278 : NAD83 / Texas South Central (ftUS) 
--
(2278, 'EPSG', 2278, 'PROJCS["NAD83 / Texas South Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",30.28333333333333],PARAMETER["standard_parallel_2",28.38333333333333],PARAMETER["latitude_of_origin",27.83333333333333],PARAMETER["central_meridian",-99],PARAMETER["false_easting",1968500],PARAMETER["false_northing",13123333.333],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2278"]]', '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2279 : NAD83 / Texas South (ftUS) 
--
(2279, 'EPSG', 2279, 'PROJCS["NAD83 / Texas South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",27.83333333333333],PARAMETER["standard_parallel_2",26.16666666666667],PARAMETER["latitude_of_origin",25.66666666666667],PARAMETER["central_meridian",-98.5],PARAMETER["false_easting",984250.0000000002],PARAMETER["false_northing",16404166.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2279"]]', '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2280 : NAD83 / Utah North (ft) 
--
(2280, 'EPSG', 2280, 'PROJCS["NAD83 / Utah North (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",41.78333333333333],PARAMETER["standard_parallel_2",40.71666666666667],PARAMETER["latitude_of_origin",40.33333333333334],PARAMETER["central_meridian",-111.5],PARAMETER["false_easting",1640419.948],PARAMETER["false_northing",3280839.895],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2280"]]', '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2281 : NAD83 / Utah Central (ft) 
--
(2281, 'EPSG', 2281, 'PROJCS["NAD83 / Utah Central (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",40.65],PARAMETER["standard_parallel_2",39.01666666666667],PARAMETER["latitude_of_origin",38.33333333333334],PARAMETER["central_meridian",-111.5],PARAMETER["false_easting",1640419.948],PARAMETER["false_northing",6561679.79],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2281"]]', '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2282 : NAD83 / Utah South (ft) 
--
(2282, 'EPSG', 2282, 'PROJCS["NAD83 / Utah South (ft)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",38.35],PARAMETER["standard_parallel_2",37.21666666666667],PARAMETER["latitude_of_origin",36.66666666666666],PARAMETER["central_meridian",-111.5],PARAMETER["false_easting",1640419.948],PARAMETER["false_northing",9842519.685],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2282"]]', '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +datum=NAD83 +units=ft +no_defs '),
--
-- EPSG 2283 : NAD83 / Virginia North (ftUS) 
--
(2283, 'EPSG', 2283, 'PROJCS["NAD83 / Virginia North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",39.2],PARAMETER["standard_parallel_2",38.03333333333333],PARAMETER["latitude_of_origin",37.66666666666666],PARAMETER["central_meridian",-78.5],PARAMETER["false_easting",11482916.667],PARAMETER["false_northing",6561666.667],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2283"]]', '+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2284 : NAD83 / Virginia South (ftUS) 
--
(2284, 'EPSG', 2284, 'PROJCS["NAD83 / Virginia South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",37.96666666666667],PARAMETER["standard_parallel_2",36.76666666666667],PARAMETER["latitude_of_origin",36.33333333333334],PARAMETER["central_meridian",-78.5],PARAMETER["false_easting",11482916.667],PARAMETER["false_northing",3280833.333],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2284"]]', '+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2285 : NAD83 / Washington North (ftUS) 
--
(2285, 'EPSG', 2285, 'PROJCS["NAD83 / Washington North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",48.73333333333333],PARAMETER["standard_parallel_2",47.5],PARAMETER["latitude_of_origin",47],PARAMETER["central_meridian",-120.8333333333333],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2285"]]', '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2286 : NAD83 / Washington South (ftUS) 
--
(2286, 'EPSG', 2286, 'PROJCS["NAD83 / Washington South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",47.33333333333334],PARAMETER["standard_parallel_2",45.83333333333334],PARAMETER["latitude_of_origin",45.33333333333334],PARAMETER["central_meridian",-120.5],PARAMETER["false_easting",1640416.667],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2286"]]', '+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2287 : NAD83 / Wisconsin North (ftUS) 
--
(2287, 'EPSG', 2287, 'PROJCS["NAD83 / Wisconsin North (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",46.76666666666667],PARAMETER["standard_parallel_2",45.56666666666667],PARAMETER["latitude_of_origin",45.16666666666666],PARAMETER["central_meridian",-90],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2287"]]', '+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2288 : NAD83 / Wisconsin Central (ftUS) 
--
(2288, 'EPSG', 2288, 'PROJCS["NAD83 / Wisconsin Central (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",45.5],PARAMETER["standard_parallel_2",44.25],PARAMETER["latitude_of_origin",43.83333333333334],PARAMETER["central_meridian",-90],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2288"]]', '+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2289 : NAD83 / Wisconsin South (ftUS) 
--
(2289, 'EPSG', 2289, 'PROJCS["NAD83 / Wisconsin South (ftUS)",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",44.06666666666667],PARAMETER["standard_parallel_2",42.73333333333333],PARAMETER["latitude_of_origin",42],PARAMETER["central_meridian",-90],PARAMETER["false_easting",1968500],PARAMETER["false_northing",0],UNIT["US survey foot",0.3048006096012192,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2289"]]', '+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs '),
--
-- EPSG 2290 : ATS77 / Prince Edward Isl. Stereographic (ATS77) 
--
(2290, 'EPSG', 2290, 'PROJCS["ATS77 / Prince Edward Isl. Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",47.25],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.999912],PARAMETER["false_easting",700000],PARAMETER["false_northing",400000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2290"]]', '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=700000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2291 : NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated) 
--
(2291, 'EPSG', 2291, 'PROJCS["NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated)",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",47.25],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.999912],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2291"]]', '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2292 : NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated) 
--
(2292, 'EPSG', 2292, 'PROJCS["NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated)",GEOGCS["NAD83(CSRS98)",DATUM["NAD83_Canadian_Spatial_Reference_System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4140"]],PROJECTION["Oblique_Stereographic"],PARAMETER["latitude_of_origin",47.25],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.999912],PARAMETER["false_easting",400000],PARAMETER["false_northing",800000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2292"]]', '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2294 : ATS77 / MTM Nova Scotia zone 4 
--
(2294, 'EPSG', 2294, 'PROJCS["ATS77 / MTM Nova Scotia zone 4",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-61.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",4500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2294"]]', '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2295 : ATS77 / MTM Nova Scotia zone 5 
--
(2295, 'EPSG', 2295, 'PROJCS["ATS77 / MTM Nova Scotia zone 5",GEOGCS["ATS77",DATUM["Average_Terrestrial_System_1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-64.5],PARAMETER["scale_factor",0.9999],PARAMETER["false_easting",5500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2295"]]', '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs '),
--
-- EPSG 2308 : Batavia / TM 109 SE 
--
(2308, 'EPSG', 2308, 'PROJCS["Batavia / TM 109 SE",GEOGCS["Batavia",DATUM["Batavia",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-377,681,-50,0,0,0,0],AUTHORITY["EPSG","6211"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4211"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",109],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2308"]]', '+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2309 : WGS 84 / TM 116 SE 
--
(2309, 'EPSG', 2309, 'PROJCS["WGS 84 / TM 116 SE",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",116],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2309"]]', '+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs '),
--
-- EPSG 2310 : WGS 84 / TM 132 SE 
--
(2310, 'EPSG', 2310, 'PROJCS["WGS 84 / TM 132 SE",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",132],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2310"]]', '+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs '),
--
-- EPSG 2311 : WGS 84 / TM 6 NE 
--
(2311, 'EPSG', 2311, 'PROJCS["WGS 84 / TM 6 NE",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",6],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2311"]]', '+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +datum=WGS84 +units=m +no_defs '),
--
-- EPSG 2312 : Garoua / UTM zone 33N 
--
(2312, 'EPSG', 2312, 'PROJCS["Garoua / UTM zone 33N",GEOGCS["Garoua",DATUM["Garoua",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6197"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4197"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2312"]]', '+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs '),
--
-- EPSG 2313 : Kousseri / UTM zone 33N 
--
(2313, 'EPSG', 2313, 'PROJCS["Kousseri / UTM zone 33N",GEOGCS["Kousseri",DATUM["Kousseri",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6198"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4198"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2313"]]', '+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs '),
--
-- EPSG 2314 : Trinidad 1903 / Trinidad Grid (ftCla) 
--
(2314, 'EPSG', 2314, 'PROJCS["Trinidad 1903 / Trinidad Grid (ftCla)",GEOGCS["Trinidad 1903",DATUM["Trinidad_1903",SPHEROID["Clarke 1858",6378293.645208759,294.2606763692606,AUTHORITY["EPSG","7007"]],TOWGS84[-61.702,284.488,472.052,0,0,0,0],AUTHORITY["EPSG","6302"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4302"]],PROJECTION["Cassini_Soldner"],PARAMETER["latitude_of_origin",10.44166666666667],PARAMETER["central_meridian",-61.33333333333334],PARAMETER["false_easting",283800],PARAMETER["false_northing",214500],UNIT["Clarke''s foot",0.3047972654,AUTHORITY["EPSG","9005"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2314"]]', '+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs '),
--
-- EPSG 2315 : Campo Inchauspe / UTM zone 19S 
--
(2315, 'EPSG', 2315, 'PROJCS["Campo Inchauspe / UTM zone 19S",GEOGCS["Campo Inchauspe",DATUM["Campo_Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-69],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2315"]]', '+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2316 : Campo Inchauspe / UTM zone 20S 
--
(2316, 'EPSG', 2316, 'PROJCS["Campo Inchauspe / UTM zone 20S",GEOGCS["Campo Inchauspe",DATUM["Campo_Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",-63],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",10000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2316"]]', '+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2317 : PSAD56 / ICN Regional 
--
(2317, 'EPSG', 2317, 'PROJCS["PSAD56 / ICN Regional",GEOGCS["PSAD56",DATUM["Provisional_South_American_Datum_1956",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY["EPSG","6248"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4248"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",9],PARAMETER["standard_parallel_2",3],PARAMETER["latitude_of_origin",6],PARAMETER["central_meridian",-66],PARAMETER["false_easting",1000000],PARAMETER["false_northing",1000000],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2317"]]', '+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2318 : Ain el Abd / Aramco Lambert 
--
(2318, 'EPSG', 2318, 'PROJCS["Ain el Abd / Aramco Lambert",GEOGCS["Ain el Abd",DATUM["Ain_el_Abd_1970",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-143,-236,7,0,0,0,0],AUTHORITY["EPSG","6204"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4204"]],PROJECTION["Lambert_Conformal_Conic_2SP"],PARAMETER["standard_parallel_1",17],PARAMETER["standard_parallel_2",33],PARAMETER["latitude_of_origin",25.08951],PARAMETER["central_meridian",48],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH],AUTHORITY["EPSG","2318"]]', '+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 +x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2319 : ED50 / TM27 
--
(2319, 'EPSG', 2319, 'PROJCS["ED50 / TM27",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",27],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2319"]]', '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2320 : ED50 / TM30 
--
(2320, 'EPSG', 2320, 'PROJCS["ED50 / TM30",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",30],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2320"]]', '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2321 : ED50 / TM33 
--
(2321, 'EPSG', 2321, 'PROJCS["ED50 / TM33",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",33],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2321"]]', '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2322 : ED50 / TM36 
--
(2322, 'EPSG', 2322, 'PROJCS["ED50 / TM36",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",36],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2322"]]', '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2323 : ED50 / TM39 
--
(2323, 'EPSG', 2323, 'PROJCS["ED50 / TM39",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",39],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2323"]]', '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2324 : ED50 / TM42 
--
(2324, 'EPSG', 2324, 'PROJCS["ED50 / TM42",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",42],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2324"]]', '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2325 : ED50 / TM45 
--
(2325, 'EPSG', 2325, 'PROJCS["ED50 / TM45",GEOGCS["ED50",DATUM["European_Datum_1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2325"]]', '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2326 : Hong Kong 1980 Grid System 
--
(2326, 'EPSG', 2326, 'PROJCS["Hong Kong 1980 Grid System",GEOGCS["Hong Kong 1980",DATUM["Hong_Kong_1980",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246],AUTHORITY["EPSG","6611"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4611"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",22.31213333333334],PARAMETER["central_meridian",114.1785555555556],PARAMETER["scale_factor",1],PARAMETER["false_easting",836694.05],PARAMETER["false_northing",819069.8],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2326"]]', '+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.1785555555556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246 +units=m +no_defs '),
--
-- EPSG 2327 : Xian 1980 / Gauss-Kruger zone 13 
--
(2327, 'EPSG', 2327, 'PROJCS["Xian 1980 / Gauss-Kruger zone 13",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",75],PARAMETER["scale_factor",1],PARAMETER["false_easting",13500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2327"]]', '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2328 : Xian 1980 / Gauss-Kruger zone 14 
--
(2328, 'EPSG', 2328, 'PROJCS["Xian 1980 / Gauss-Kruger zone 14",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",81],PARAMETER["scale_factor",1],PARAMETER["false_easting",14500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2328"]]', '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2329 : Xian 1980 / Gauss-Kruger zone 15 
--
(2329, 'EPSG', 2329, 'PROJCS["Xian 1980 / Gauss-Kruger zone 15",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",87],PARAMETER["scale_factor",1],PARAMETER["false_easting",15500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2329"]]', '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2330 : Xian 1980 / Gauss-Kruger zone 16 
--
(2330, 'EPSG', 2330, 'PROJCS["Xian 1980 / Gauss-Kruger zone 16",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",93],PARAMETER["scale_factor",1],PARAMETER["false_easting",16500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2330"]]', '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2331 : Xian 1980 / Gauss-Kruger zone 17 
--
(2331, 'EPSG', 2331, 'PROJCS["Xian 1980 / Gauss-Kruger zone 17",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",99],PARAMETER["scale_factor",1],PARAMETER["false_easting",17500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2331"]]', '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2332 : Xian 1980 / Gauss-Kruger zone 18 
--
(2332, 'EPSG', 2332, 'PROJCS["Xian 1980 / Gauss-Kruger zone 18",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",105],PARAMETER["scale_factor",1],PARAMETER["false_easting",18500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2332"]]', '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2333 : Xian 1980 / Gauss-Kruger zone 19 
--
(2333, 'EPSG', 2333, 'PROJCS["Xian 1980 / Gauss-Kruger zone 19",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",111],PARAMETER["scale_factor",1],PARAMETER["false_easting",19500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2333"]]', '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2334 : Xian 1980 / Gauss-Kruger zone 20 
--
(2334, 'EPSG', 2334, 'PROJCS["Xian 1980 / Gauss-Kruger zone 20",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",117],PARAMETER["scale_factor",1],PARAMETER["false_easting",20500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2334"]]', '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2335 : Xian 1980 / Gauss-Kruger zone 21 
--
(2335, 'EPSG', 2335, 'PROJCS["Xian 1980 / Gauss-Kruger zone 21",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",123],PARAMETER["scale_factor",1],PARAMETER["false_easting",21500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2335"]]', '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2336 : Xian 1980 / Gauss-Kruger zone 22 
--
(2336, 'EPSG', 2336, 'PROJCS["Xian 1980 / Gauss-Kruger zone 22",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",129],PARAMETER["scale_factor",1],PARAMETER["false_easting",22500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2336"]]', '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2337 : Xian 1980 / Gauss-Kruger zone 23 
--
(2337, 'EPSG', 2337, 'PROJCS["Xian 1980 / Gauss-Kruger zone 23",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",135],PARAMETER["scale_factor",1],PARAMETER["false_easting",23500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2337"]]', '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2338 : Xian 1980 / Gauss-Kruger CM 75E 
--
(2338, 'EPSG', 2338, 'PROJCS["Xian 1980 / Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",75],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2338"]]', '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2339 : Xian 1980 / Gauss-Kruger CM 81E 
--
(2339, 'EPSG', 2339, 'PROJCS["Xian 1980 / Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",81],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2339"]]', '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2340 : Xian 1980 / Gauss-Kruger CM 87E 
--
(2340, 'EPSG', 2340, 'PROJCS["Xian 1980 / Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",87],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2340"]]', '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2341 : Xian 1980 / Gauss-Kruger CM 93E 
--
(2341, 'EPSG', 2341, 'PROJCS["Xian 1980 / Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",93],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2341"]]', '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2342 : Xian 1980 / Gauss-Kruger CM 99E 
--
(2342, 'EPSG', 2342, 'PROJCS["Xian 1980 / Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",99],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2342"]]', '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2343 : Xian 1980 / Gauss-Kruger CM 105E 
--
(2343, 'EPSG', 2343, 'PROJCS["Xian 1980 / Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",105],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2343"]]', '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2344 : Xian 1980 / Gauss-Kruger CM 111E 
--
(2344, 'EPSG', 2344, 'PROJCS["Xian 1980 / Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",111],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2344"]]', '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2345 : Xian 1980 / Gauss-Kruger CM 117E 
--
(2345, 'EPSG', 2345, 'PROJCS["Xian 1980 / Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",117],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2345"]]', '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2346 : Xian 1980 / Gauss-Kruger CM 123E 
--
(2346, 'EPSG', 2346, 'PROJCS["Xian 1980 / Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",123],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2346"]]', '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2347 : Xian 1980 / Gauss-Kruger CM 129E 
--
(2347, 'EPSG', 2347, 'PROJCS["Xian 1980 / Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",129],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2347"]]', '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2348 : Xian 1980 / Gauss-Kruger CM 135E 
--
(2348, 'EPSG', 2348, 'PROJCS["Xian 1980 / Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",135],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2348"]]', '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2349 : Xian 1980 / 3-degree Gauss-Kruger zone 25 
--
(2349, 'EPSG', 2349, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 25",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",75],PARAMETER["scale_factor",1],PARAMETER["false_easting",25500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2349"]]', '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2350 : Xian 1980 / 3-degree Gauss-Kruger zone 26 
--
(2350, 'EPSG', 2350, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 26",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",78],PARAMETER["scale_factor",1],PARAMETER["false_easting",26500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2350"]]', '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2351 : Xian 1980 / 3-degree Gauss-Kruger zone 27 
--
(2351, 'EPSG', 2351, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 27",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",81],PARAMETER["scale_factor",1],PARAMETER["false_easting",27500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2351"]]', '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2352 : Xian 1980 / 3-degree Gauss-Kruger zone 28 
--
(2352, 'EPSG', 2352, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 28",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",84],PARAMETER["scale_factor",1],PARAMETER["false_easting",28500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2352"]]', '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2353 : Xian 1980 / 3-degree Gauss-Kruger zone 29 
--
(2353, 'EPSG', 2353, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 29",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",87],PARAMETER["scale_factor",1],PARAMETER["false_easting",29500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2353"]]', '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2354 : Xian 1980 / 3-degree Gauss-Kruger zone 30 
--
(2354, 'EPSG', 2354, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 30",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",90],PARAMETER["scale_factor",1],PARAMETER["false_easting",30500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2354"]]', '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2355 : Xian 1980 / 3-degree Gauss-Kruger zone 31 
--
(2355, 'EPSG', 2355, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 31",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",93],PARAMETER["scale_factor",1],PARAMETER["false_easting",31500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2355"]]', '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2356 : Xian 1980 / 3-degree Gauss-Kruger zone 32 
--
(2356, 'EPSG', 2356, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 32",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",96],PARAMETER["scale_factor",1],PARAMETER["false_easting",32500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2356"]]', '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2357 : Xian 1980 / 3-degree Gauss-Kruger zone 33 
--
(2357, 'EPSG', 2357, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 33",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",99],PARAMETER["scale_factor",1],PARAMETER["false_easting",33500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2357"]]', '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2358 : Xian 1980 / 3-degree Gauss-Kruger zone 34 
--
(2358, 'EPSG', 2358, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 34",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",102],PARAMETER["scale_factor",1],PARAMETER["false_easting",34500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2358"]]', '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2359 : Xian 1980 / 3-degree Gauss-Kruger zone 35 
--
(2359, 'EPSG', 2359, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 35",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",105],PARAMETER["scale_factor",1],PARAMETER["false_easting",35500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2359"]]', '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2360 : Xian 1980 / 3-degree Gauss-Kruger zone 36 
--
(2360, 'EPSG', 2360, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 36",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",108],PARAMETER["scale_factor",1],PARAMETER["false_easting",36500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2360"]]', '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2361 : Xian 1980 / 3-degree Gauss-Kruger zone 37 
--
(2361, 'EPSG', 2361, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 37",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",111],PARAMETER["scale_factor",1],PARAMETER["false_easting",37500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2361"]]', '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2362 : Xian 1980 / 3-degree Gauss-Kruger zone 38 
--
(2362, 'EPSG', 2362, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 38",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",114],PARAMETER["scale_factor",1],PARAMETER["false_easting",38500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2362"]]', '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2363 : Xian 1980 / 3-degree Gauss-Kruger zone 39 
--
(2363, 'EPSG', 2363, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 39",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",117],PARAMETER["scale_factor",1],PARAMETER["false_easting",39500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2363"]]', '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2364 : Xian 1980 / 3-degree Gauss-Kruger zone 40 
--
(2364, 'EPSG', 2364, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 40",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",120],PARAMETER["scale_factor",1],PARAMETER["false_easting",40500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2364"]]', '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2365 : Xian 1980 / 3-degree Gauss-Kruger zone 41 
--
(2365, 'EPSG', 2365, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 41",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",123],PARAMETER["scale_factor",1],PARAMETER["false_easting",41500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2365"]]', '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2366 : Xian 1980 / 3-degree Gauss-Kruger zone 42 
--
(2366, 'EPSG', 2366, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 42",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",126],PARAMETER["scale_factor",1],PARAMETER["false_easting",42500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2366"]]', '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2367 : Xian 1980 / 3-degree Gauss-Kruger zone 43 
--
(2367, 'EPSG', 2367, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 43",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",129],PARAMETER["scale_factor",1],PARAMETER["false_easting",43500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2367"]]', '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2368 : Xian 1980 / 3-degree Gauss-Kruger zone 44 
--
(2368, 'EPSG', 2368, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 44",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",132],PARAMETER["scale_factor",1],PARAMETER["false_easting",44500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2368"]]', '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2369 : Xian 1980 / 3-degree Gauss-Kruger zone 45 
--
(2369, 'EPSG', 2369, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 45",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",135],PARAMETER["scale_factor",1],PARAMETER["false_easting",45500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2369"]]', '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2370 : Xian 1980 / 3-degree Gauss-Kruger CM 75E 
--
(2370, 'EPSG', 2370, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",75],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2370"]]', '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2371 : Xian 1980 / 3-degree Gauss-Kruger CM 78E 
--
(2371, 'EPSG', 2371, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",78],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2371"]]', '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2372 : Xian 1980 / 3-degree Gauss-Kruger CM 81E 
--
(2372, 'EPSG', 2372, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",81],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2372"]]', '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2373 : Xian 1980 / 3-degree Gauss-Kruger CM 84E 
--
(2373, 'EPSG', 2373, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",84],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2373"]]', '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2374 : Xian 1980 / 3-degree Gauss-Kruger CM 87E 
--
(2374, 'EPSG', 2374, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",87],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2374"]]', '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2375 : Xian 1980 / 3-degree Gauss-Kruger CM 90E 
--
(2375, 'EPSG', 2375, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",90],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2375"]]', '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2376 : Xian 1980 / 3-degree Gauss-Kruger CM 93E 
--
(2376, 'EPSG', 2376, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",93],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2376"]]', '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2377 : Xian 1980 / 3-degree Gauss-Kruger CM 96E 
--
(2377, 'EPSG', 2377, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",96],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2377"]]', '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2378 : Xian 1980 / 3-degree Gauss-Kruger CM 99E 
--
(2378, 'EPSG', 2378, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",99],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2378"]]', '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2379 : Xian 1980 / 3-degree Gauss-Kruger CM 102E 
--
(2379, 'EPSG', 2379, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",102],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2379"]]', '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2380 : Xian 1980 / 3-degree Gauss-Kruger CM 105E 
--
(2380, 'EPSG', 2380, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",105],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2380"]]', '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2381 : Xian 1980 / 3-degree Gauss-Kruger CM 108E 
--
(2381, 'EPSG', 2381, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",108],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2381"]]', '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2382 : Xian 1980 / 3-degree Gauss-Kruger CM 111E 
--
(2382, 'EPSG', 2382, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",111],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2382"]]', '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2383 : Xian 1980 / 3-degree Gauss-Kruger CM 114E 
--
(2383, 'EPSG', 2383, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",114],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2383"]]', '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2384 : Xian 1980 / 3-degree Gauss-Kruger CM 117E 
--
(2384, 'EPSG', 2384, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",117],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2384"]]', '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2385 : Xian 1980 / 3-degree Gauss-Kruger CM 120E 
--
(2385, 'EPSG', 2385, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",120],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2385"]]', '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2386 : Xian 1980 / 3-degree Gauss-Kruger CM 123E 
--
(2386, 'EPSG', 2386, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",123],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2386"]]', '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2387 : Xian 1980 / 3-degree Gauss-Kruger CM 126E 
--
(2387, 'EPSG', 2387, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",126],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2387"]]', '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2388 : Xian 1980 / 3-degree Gauss-Kruger CM 129E 
--
(2388, 'EPSG', 2388, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",129],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2388"]]', '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2389 : Xian 1980 / 3-degree Gauss-Kruger CM 132E 
--
(2389, 'EPSG', 2389, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",132],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2389"]]', '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2390 : Xian 1980 / 3-degree Gauss-Kruger CM 135E 
--
(2390, 'EPSG', 2390, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian_1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",135],PARAMETER["scale_factor",1],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2390"]]', '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs '),
--
-- EPSG 2391 : KKJ / Finland zone 1 
--
(2391, 'EPSG', 2391, 'PROJCS["KKJ / Finland zone 1",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma_1966",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",21],PARAMETER["scale_factor",1],PARAMETER["false_easting",1500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2391"]]', '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs '),
--
-- EPSG 2392 : KKJ / Finland zone 2 
--
(2392, 'EPSG', 2392, 'PROJCS["KKJ / Finland zone 2",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma_1966",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",24],PARAMETER["scale_factor",1],PARAMETER["false_easting",2500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2392"]]', '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs '),
--
-- EPSG 2393 : KKJ / Finland Uniform Coordinate System 
--
(2393, 'EPSG', 2393, 'PROJCS["KKJ / Finland Uniform Coordinate System",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma_1966",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",27],PARAMETER["scale_factor",1],PARAMETER["false_easting",3500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2393"]]', '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs '),
--
-- EPSG 2394 : KKJ / Finland zone 4 
--
(2394, 'EPSG', 2394, 'PROJCS["KKJ / Finland zone 4",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma_1966",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",30],PARAMETER["scale_factor",1],PARAMETER["false_easting",4500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2394"]]', '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs '),
--
-- EPSG 2395 : South Yemen / Gauss-Kruger zone 8 
--
(2395, 'EPSG', 2395, 'PROJCS["South Yemen / Gauss-Kruger zone 8",GEOGCS["South Yemen",DATUM["South_Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",45],PARAMETER["scale_factor",1],PARAMETER["false_easting",8500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2395"]]', '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2396 : South Yemen / Gauss-Kruger zone 9 
--
(2396, 'EPSG', 2396, 'PROJCS["South Yemen / Gauss-Kruger zone 9",GEOGCS["South Yemen",DATUM["South_Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",51],PARAMETER["scale_factor",1],PARAMETER["false_easting",9500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2396"]]', '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2397 : Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3 
--
(2397, 'EPSG', 2397, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",9],PARAMETER["scale_factor",1],PARAMETER["false_easting",3500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2397"]]', '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs '),
--
-- EPSG 2398 : Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4 
--
(2398, 'EPSG', 2398, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",12],PARAMETER["scale_factor",1],PARAMETER["false_easting",4500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2398"]]', '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs '),
--
-- EPSG 2399 : Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5 
--
(2399, 'EPSG', 2399, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo_1942_83",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",1],PARAMETER["false_easting",5500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2399"]]', '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs '),
--
-- EPSG 2400 : RT90 2.5 gon W (deprecated) 
--
(2400, 'EPSG', 2400, 'PROJCS["RT90 2.5 gon W (deprecated)",GEOGCS["RT90",DATUM["Rikets_koordinatsystem_1990",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[414.1,41.3,603.1,-0.855,2.141,-7.023,0],AUTHORITY["EPSG","6124"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4124"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15.80827777777778],PARAMETER["scale_factor",1],PARAMETER["false_easting",1500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2400"]]', '+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs '),
--
-- EPSG 2401 : Beijing 1954 / 3-degree Gauss-Kruger zone 25 
--
(2401, 'EPSG', 2401, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 25",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",75],PARAMETER["scale_factor",1],PARAMETER["false_easting",25500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2401"]]', '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2402 : Beijing 1954 / 3-degree Gauss-Kruger zone 26 
--
(2402, 'EPSG', 2402, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 26",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",78],PARAMETER["scale_factor",1],PARAMETER["false_easting",26500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2402"]]', '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2403 : Beijing 1954 / 3-degree Gauss-Kruger zone 27 
--
(2403, 'EPSG', 2403, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 27",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",81],PARAMETER["scale_factor",1],PARAMETER["false_easting",27500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2403"]]', '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2404 : Beijing 1954 / 3-degree Gauss-Kruger zone 28 
--
(2404, 'EPSG', 2404, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 28",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",84],PARAMETER["scale_factor",1],PARAMETER["false_easting",28500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2404"]]', '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2405 : Beijing 1954 / 3-degree Gauss-Kruger zone 29 
--
(2405, 'EPSG', 2405, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 29",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",87],PARAMETER["scale_factor",1],PARAMETER["false_easting",29500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2405"]]', '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs '),
--
-- EPSG 2406 : Beijing 1954 / 3-degree Gauss-Kruger zone 30 
--
(2406, 'EPSG', 2406, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 30",GEOGCS["Beijing 1954",DATUM["Beijing_1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",90],PARAMETER["scale_factor",1],PARAMETER["false_easting",30500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","2406"]]', '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=15.8,-15