import sys

if sys.platform == "win32":
    from collections.abc import Sequence
    from socket import AddressFamily, SocketKind
    from typing import Final

    version: Final[int]
    ABOVE_NORMAL_PRIORITY_CLASS: Final = 32768
    BELOW_NORMAL_PRIORITY_CLASS: Final = 16384
    HIGH_PRIORITY_CLASS: Final = 128
    IDLE_PRIORITY_CLASS: Final = 64
    NORMAL_PRIORITY_CLASS: Final = 32
    REALTIME_PRIORITY_CLASS: Final = 256
    MIB_TCP_STATE_CLOSED: Final = 1
    MIB_TCP_STATE_CLOSING: Final = 9
    MIB_TCP_STATE_CLOSE_WAIT: Final = 8
    MIB_TCP_STATE_LISTEN: Final = 2
    MIB_TCP_STATE_ESTAB: Final = 5
    MIB_TCP_STATE_SYN_SENT: Final = 3
    MIB_TCP_STATE_SYN_RCVD: Final = 4
    MIB_TCP_STATE_FIN_WAIT1: Final = 6
    MIB_TCP_STATE_FIN_WAIT2: Final = 7
    MIB_TCP_STATE_LAST_ACK: Final = 10
    MIB_TCP_STATE_TIME_WAIT: Final = 11
    MIB_TCP_STATE_DELETE_TCB: Final = 12
    PSUTIL_CONN_NONE: Final = 128
    INFINITE: Final[int]
    ERROR_ACCESS_DENIED: Final = 5
    ERROR_INVALID_NAME: Final = 123
    ERROR_SERVICE_DOES_NOT_EXIST: Final = 1060
    ERROR_PRIVILEGE_NOT_HELD: Final = 1314
    WINVER: Final[int]
    WINDOWS_VISTA: Final = 60
    WINDOWS_7: Final = 61
    WINDOWS_8: Final = 62
    WINDOWS_8_1: Final = 63
    WINDOWS_10: Final = 100

    class TimeoutAbandoned(Exception): ...
    class TimeoutExpired(Exception): ...

    def proc_cmdline(pid: int, use_peb: bool = True) -> list[str]: ...
    def proc_cpu_affinity_get(pid: int, /) -> int: ...
    def proc_cpu_affinity_set(pid: int, mask: int, /) -> None: ...
    def proc_cwd(pid: int, /) -> str: ...
    def proc_environ(pid: int, /) -> str: ...
    def proc_exe(pid: int, /) -> str: ...
    def proc_io_counters(pid: int, /) -> tuple[int, int, int, int, int, int]: ...
    def proc_io_priority_get(pid: int, /) -> int: ...
    def proc_io_priority_set(pid: int, priority: int, /) -> None: ...
    def proc_is_suspended(pid: int, /) -> bool: ...
    def proc_kill(pid: int, /) -> None: ...
    def proc_memory_info(pid: int, /) -> tuple[int, int, int, int, int, int, int, int, int, int]: ...
    def proc_memory_maps(pid: int, /) -> list[tuple[int, str, str, int]]: ...
    def proc_memory_uss(pid: int, /) -> int: ...
    def proc_num_handles(pid: int, /) -> int: ...
    def proc_open_files(pid: int, /) -> list[str]: ...
    def proc_priority_get(pid: int, /) -> int: ...
    def proc_priority_set(pid: int, priority: int, /) -> None: ...
    def proc_suspend_or_resume(pid: int, suspend: bool | None, /) -> None: ...
    def proc_threads(pid: int, /) -> list[tuple[int, float, float]]: ...
    def proc_times(pid: int, /) -> tuple[float, float, float]: ...
    def proc_username(pid: int, /) -> tuple[str, str]: ...
    def proc_wait(pid: int, timeout: int, /) -> int | None: ...
    def proc_info(
        pid: int, /
    ) -> tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...
    def uptime() -> float: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_freq() -> tuple[int, int]: ...
    def cpu_stats() -> tuple[int, int, int, int]: ...
    def cpu_times() -> tuple[float, float, float]: ...
    def disk_io_counters() -> dict[str, tuple[int, int, int, int, int, int]]: ...
    def disk_partitions(all: bool, /) -> list[tuple[str, str, str, str]]: ...
    def disk_usage(path: str, /) -> tuple[int, int, int]: ...
    def getloadavg() -> tuple[float, float, float]: ...
    def getpagesize() -> int: ...
    def swap_percent() -> float: ...
    def init_loadavg_counter() -> None: ...
    def net_connections(
        pid: int, af_filter: Sequence[AddressFamily | int | None], type_filter: Sequence[SocketKind | int | None], /
    ) -> list[tuple[int, int, int, tuple[str | None, int], tuple[str | None, int], int, int]]: ...
    def net_if_addrs() -> list[tuple[str, int, str, str | None, None, None]]: ...
    def net_if_stats() -> dict[str, tuple[bool, int, int, int]]: ...
    def net_io_counters() -> dict[str, tuple[int, int, int, int, int, int, int, int]]: ...
    def per_cpu_times() -> list[tuple[float, float, float, float, float]]: ...
    def pid_exists(pid: int, /) -> bool: ...
    def pids() -> list[int]: ...
    def ppid_map() -> dict[int, int]: ...
    def sensors_battery() -> tuple[int, int, int, int]: ...
    def users() -> list[tuple[str, str | None, float]]: ...
    def virtual_mem() -> tuple[int, int, int, int]: ...
    def winservice_enumerate() -> list[tuple[str, str]]: ...
    def winservice_query_config(service_name: str, /) -> tuple[str, str, str, str]: ...
    def winservice_query_descr(service_name: str, /) -> str: ...
    def winservice_query_status(service_name: str, /) -> tuple[str, int] | str: ...
    def winservice_start(service_name: str, /) -> None: ...
    def winservice_stop(service_name: str, /) -> None: ...
    def QueryDosDevice(device_path: str, /) -> str: ...
    def check_pid_range(pid: int, /) -> None: ...
    def set_debug(value: bool, /) -> None: ...
