#! /usr/local/bin/tclsh8.6
## -*- tcl -*-

package require Tk

# plotdemos15.tcl --
#     Demo adapted from the Wiki:
#
##+##########################################################################
#
# Plotchart extension--3d ribbon graph
# by Keith Vetter, April 2010
#

package require Plotchart

set yscale [list 0 40 5]          ;# Y axis is miles along route
set zscale [list 900 1300 100]    ;# Z axis is altitude
set xscale [list 0 .1 .1]         ;# X axis is 3-d depth

# Each duple is distance along route (Y) and its altitude (Z)
set YZ {
    { 0    971} { 0.2  977} { 0.3  981} { 0.8 1010} { 1.0 1022} { 1.6 1060}
    { 1.7 1059} { 1.7 1060} { 1.8 1059} { 1.8 1059} { 1.8 1054} { 1.9 1071}
    { 2.0 1073} { 2.0 1060} { 2.0 1060} { 2.1 1050} { 2.2 1051} { 2.2 1049}
    { 2.3 1040} { 2.3 1039} { 2.4 1030} { 2.4 1050} { 2.5 1050} { 2.5 1059}
    { 2.6 1055} { 2.6 1052} { 2.6 1050} { 2.7 1041} { 2.7 1034} { 2.8 1025}
    { 2.9 1020} { 3.0 1049} { 3.2 1017} { 3.6 1010} { 3.9 1019} { 4.0 1029}
    { 4.1 1019} { 4.4 1049} { 4.6 1059} { 4.7 1067} { 4.8 1084} { 4.9 1029}
    { 5.2 1047} { 5.2 1058} { 5.7 1085} { 5.9 1087} { 6.4 1120} { 6.9 1169}
    { 7.3 1225} { 7.6 1265} { 8.0 1263} { 8.5 1189} { 8.8 1238} { 8.9 1245}
    { 9.1 1202} { 9.3 1199} {10.2 1148} {10.3 1148} {10.4 1141} {10.5 1135}
    {10.7 1159} {11.1 1157} {11.3 1159} {11.5 1139} {11.6 1139} {11.8 1141}
    {12.6 1160} {12.9 1150} {13.5 1150} {13.9 1150} {14.0 1129} {14.1 1120}
    {14.4 1128} {14.5 1155} {14.7 1161} {14.7 1154} {14.8 1116} {14.9 1106}
    {15.0 1110} {15.1 1113} {15.2 1104} {15.3 1108} {15.3 1118} {15.3 1131}
    {15.3 1148} {15.4 1161} {15.5 1146} {15.6 1160} {15.9 1141} {16.1 1121}
    {16.4 1100} {16.5 1102} {16.7 1097} {16.9 1088} {17.1 1091} {17.2 1082}
    {17.2 1080} {17.4 1129} {17.5 1120} {17.6 1115} {17.7 1090} {18.0 1105}
    {18.1 1109} {18.1 1104} {18.1 1084} {18.2 1071} {18.2 1091} {18.4 1073}
    {18.5 1067} {18.5 1065} {18.6 1069} {18.8 1071} {19.2 1051} {19.2 1050}
    {19.5 1051} {19.6 1059} {19.8 1046} {19.9 1048} {20.0 1053} {20.1 1039}
    {20.3 1068} {20.7 1053} {20.8 1066} {21.0 1053} {21.1 1047} {21.3 1049}
    {21.6 1048} {22.4 1019} {22.6 1026} {22.7 1030} {23.1 1026} {23.4 1054}
    {24.1 1029} {24.9 1025} {25.1 1011} {25.2 1002} {25.3 1042} {25.3 1047}
    {25.3 1048} {25.4 1049} {25.6 1080} {25.7 1090} {25.8 1089} {25.9 1107}
    {26.0 1103} {27.0 1165} {27.0 1171} {27.1 1170} {27.2 1159} {27.2 1169}
    {27.4 1180} {27.7 1154} {27.8 1139} {28.0 1139} {28.5 1130} {28.7 1139}
    {29.1 1139} {29.3 1140} {29.4 1146} {29.5 1141} {29.5 1148} {29.6 1148}
    {30.5 1199} {30.6 1202} {30.9 1245} {31.1 1238} {31.3 1189} {31.8 1263}
    {32.2 1265} {32.6 1225} {32.9 1169} {33.4 1120} {33.9 1087} {34.2 1085}
    {34.6 1058} {34.7 1047} {35.2 1012} {35.5 1001} {35.7  993} {35.8  989}
    {35.9 1019} {36.2 1050} {36.2 1029} {36.3 1051} {36.4 1034} {36.8 1086}
    {36.9 1067} {37.1 1121} {37.5 1053} {37.8 1059} {37.9 1060} {38.4 1022}
    {38.6 1010} {39.1  981} {39.2  977} {39.5  971}
}

wm title . "3D Ribbon Plotchart"
canvas .c1 -width 800 -height 400 -bg #aaeeff -bd 0 -highlightthickness 0
pack .c1 -side top -fill both -expand 1

foreach {xmin xmax xstep} $xscale break
foreach {ymin ymax ystep} $yscale break
foreach {zmin zmax zstep} $zscale break

# Example with full 3d axes
set s [::Plotchart::create3DPlot .c1 $xscale $yscale $zscale]
$s ribbon $YZ

# Example with minimal axes
canvas .c2 -width 800 -height 400 -bg #aaeeff -bd 0 -highlightthickness 0
pack .c2 -side top -fill both -expand 1 -pady {1 0}

set s [::Plotchart::create3DRibbonPlot .c2 $yscale $zscale]
$s plot $YZ
