(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/digest#digest::t
    (make-struct-type
     'std/crypto#digest::t
     '#f
     '2
     'digest
     '()
     ':init!
     '(type ctx)))
  (define std/crypto/digest#digest?
    (make-struct-predicate std/crypto/digest#digest::t))
  (define std/crypto/digest#make-digest
    (lambda _$args871_
      (apply make-struct-instance std/crypto/digest#digest::t _$args871_)))
  (define std/crypto/digest#digest-type
    (make-struct-field-accessor std/crypto/digest#digest::t '0))
  (define std/crypto/digest#digest-ctx
    (make-struct-field-accessor std/crypto/digest#digest::t '1))
  (define std/crypto/digest#digest-type-set!
    (make-struct-field-mutator std/crypto/digest#digest::t '0))
  (define std/crypto/digest#digest-ctx-set!
    (make-struct-field-mutator std/crypto/digest#digest::t '1))
  (define std/crypto/digest#digest:::init!
    (lambda (_self863_ _type864_)
      (if (std/crypto/libcrypto#EVP_MD? _type864_)
          '#!void
          (error '"Invalid digest type" _type864_))
      (let ((_ctx866_ (std/crypto/libcrypto#EVP_MD_CTX_create)))
        (if _ctx866_ '#!void (error '"Failed to allocate digest context"))
        (let ((_res868_
               (std/crypto/libcrypto#EVP_DigestInit _ctx866_ _type864_)))
          (if (let () (declare (not safe)) (##fxzero? _res868_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        (if (let ((__tmp4537
                   (let () (declare (not safe)) (##vector-length _self863_))))
              (declare (not safe))
              (##fx< '2 __tmp4537))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! _self863_ '1 _type864_))
              (let ()
                (declare (not safe))
                (##vector-set! _self863_ '2 _ctx866_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self863_)))))
  (bind-method!
   std/crypto/digest#digest::t
   ':init!
   std/crypto/digest#digest:::init!
   '#f)
  (define std/crypto/digest#digest-size
    (lambda (_digest739_)
      (if (std/crypto/libcrypto#EVP_MD? _digest739_)
          (std/crypto/libcrypto#EVP_MD_size _digest739_)
          (std/crypto/libcrypto#EVP_MD_size
           (##structure-ref _digest739_ '1 std/crypto/digest#digest::t '#f)))))
  (define std/crypto/digest#digest-name
    (lambda (_digest737_)
      (if (std/crypto/libcrypto#EVP_MD? _digest737_)
          (std/crypto/libcrypto#EVP_MD_name _digest737_)
          (std/crypto/libcrypto#EVP_MD_name
           (##structure-ref _digest737_ '1 std/crypto/digest#digest::t '#f)))))
  (define std/crypto/digest#digest-copy
    (lambda (_digest727_)
      (let* ((_ctx729_ (std/crypto/digest#digest-context _digest727_))
             (_copy731_
              (let ((__obj4528 (make-object std/crypto/digest#digest::t '2)))
                (std/crypto/digest#digest:::init!
                 __obj4528
                 (##structure-ref
                  _digest727_
                  '1
                  std/crypto/digest#digest::t
                  '#f))
                __obj4528)))
        (let ((_res734_
               (std/crypto/libcrypto#EVP_MD_CTX_copy
                (##structure-ref _copy731_ '2 std/crypto/digest#digest::t '#f)
                _ctx729_)))
          (if (let () (declare (not safe)) (##fxzero? _res734_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _copy731_)))
  (define std/crypto/digest#digest-context
    (lambda (_digest722_)
      (let ((_$e724_ (##structure-ref
                      _digest722_
                      '2
                      std/crypto/digest#digest::t
                      '#f)))
        (if _$e724_
            _$e724_
            (error '"Digest has been finalized" _digest722_)))))
  (define std/crypto/digest#digest-update!__%
    (lambda (_digest682_ _bytes683_ _start684_ _end685_)
      (let* ((_start690_ (let ((_$e687_ _start684_)) (if _$e687_ _$e687_ '0)))
             (_end695_
              (let ((_$e692_ _end685_))
                (if _$e692_ _$e692_ (u8vector-length _bytes683_)))))
        (let ((_res698_
               (std/crypto/libcrypto#EVP_DigestUpdate
                (std/crypto/digest#digest-context _digest682_)
                _bytes683_
                _start690_
                _end695_)))
          (if (let () (declare (not safe)) (##fxzero? _res698_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void)))))
  (define std/crypto/digest#digest-update!__0
    (lambda (_digest704_ _bytes705_)
      (let* ((_start707_ '#f) (_end709_ '#f))
        (std/crypto/digest#digest-update!__%
         _digest704_
         _bytes705_
         _start707_
         _end709_))))
  (define std/crypto/digest#digest-update!__1
    (lambda (_digest711_ _bytes712_ _start713_)
      (let ((_end715_ '#f))
        (std/crypto/digest#digest-update!__%
         _digest711_
         _bytes712_
         _start713_
         _end715_))))
  (define std/crypto/digest#digest-update!
    (lambda _g4539_
      (let ((_g4538_ (let () (declare (not safe)) (##length _g4539_))))
        (cond ((let () (declare (not safe)) (##fx= _g4538_ 2))
               (apply std/crypto/digest#digest-update!__0 _g4539_))
              ((let () (declare (not safe)) (##fx= _g4538_ 3))
               (apply std/crypto/digest#digest-update!__1 _g4539_))
              ((let () (declare (not safe)) (##fx= _g4538_ 4))
               (apply std/crypto/digest#digest-update!__% _g4539_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/digest#digest-update!
                _g4539_))))))
  (define std/crypto/digest#digest-update*
    (lambda (_digest670_ _in671_ . _args672_)
      (apply std/crypto/etc#call-with-binary-input
             (lambda (_bytes674_ _start675_ _end676_)
               (let ((_res678_
                      (std/crypto/libcrypto#EVP_DigestUpdate
                       (std/crypto/digest#digest-context _digest670_)
                       _bytes674_
                       _start675_
                       _end676_)))
                 (if (let () (declare (not safe)) (##fxzero? _res678_))
                     (apply std/crypto/etc#raise-libcrypto-error '())
                     '#!void)))
             _in671_
             _args672_)))
  (define std/crypto/digest#digest-final!__%
    (lambda (_digest644_ _bytes645_)
      (let* ((_ctx647_ (std/crypto/digest#digest-context _digest644_))
             (_size649_ (std/crypto/libcrypto#EVP_MD_CTX_size _ctx647_))
             (_bytes654_
              (let ((_$e651_ _bytes645_))
                (if _$e651_ _$e651_ (make-u8vector _size649_)))))
        (let ((_res657_
               (std/crypto/libcrypto#EVP_DigestFinal _ctx647_ _bytes654_)))
          (if (let () (declare (not safe)) (##fxzero? _res657_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        (##structure-set! _digest644_ '#f '2 std/crypto/digest#digest::t '#f)
        _bytes654_)))
  (define std/crypto/digest#digest-final!__0
    (lambda (_digest663_)
      (let ((_bytes665_ '#f))
        (std/crypto/digest#digest-final!__% _digest663_ _bytes665_))))
  (define std/crypto/digest#digest-final!
    (lambda _g4541_
      (let ((_g4540_ (let () (declare (not safe)) (##length _g4541_))))
        (cond ((let () (declare (not safe)) (##fx= _g4540_ 1))
               (apply std/crypto/digest#digest-final!__0 _g4541_))
              ((let () (declare (not safe)) (##fx= _g4540_ 2))
               (apply std/crypto/digest#digest-final!__% _g4541_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/digest#digest-final!
                _g4541_))))))
  (define std/crypto/digest#digest::md5 (std/crypto/libcrypto#EVP_md5))
  (define std/crypto/digest#make-md5-digest
    (lambda ()
      (let ((__obj4529 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4529
         std/crypto/digest#digest::md5)
        __obj4529)))
  (define std/crypto/digest#md5-digest?
    (lambda (_obj639_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj639_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj639_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::md5)))
          '#f)))
  (define std/crypto/digest#md5
    (lambda _args633_
      (let ((_digest636_ (std/crypto/digest#make-md5-digest)))
        (apply std/crypto/digest#digest-update* _digest636_ _args633_)
        (std/crypto/digest#digest-final!__0 _digest636_))))
  (define std/crypto/digest#digest::sha1 (std/crypto/libcrypto#EVP_sha1))
  (define std/crypto/digest#make-sha1-digest
    (lambda ()
      (let ((__obj4530 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4530
         std/crypto/digest#digest::sha1)
        __obj4530)))
  (define std/crypto/digest#sha1-digest?
    (lambda (_obj629_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj629_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj629_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha1)))
          '#f)))
  (define std/crypto/digest#sha1
    (lambda _args623_
      (let ((_digest626_ (std/crypto/digest#make-sha1-digest)))
        (apply std/crypto/digest#digest-update* _digest626_ _args623_)
        (std/crypto/digest#digest-final!__0 _digest626_))))
  (define std/crypto/digest#digest::sha224 (std/crypto/libcrypto#EVP_sha224))
  (define std/crypto/digest#make-sha224-digest
    (lambda ()
      (let ((__obj4531 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4531
         std/crypto/digest#digest::sha224)
        __obj4531)))
  (define std/crypto/digest#sha224-digest?
    (lambda (_obj619_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj619_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj619_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha224)))
          '#f)))
  (define std/crypto/digest#sha224
    (lambda _args613_
      (let ((_digest616_ (std/crypto/digest#make-sha224-digest)))
        (apply std/crypto/digest#digest-update* _digest616_ _args613_)
        (std/crypto/digest#digest-final!__0 _digest616_))))
  (define std/crypto/digest#digest::sha256 (std/crypto/libcrypto#EVP_sha256))
  (define std/crypto/digest#make-sha256-digest
    (lambda ()
      (let ((__obj4532 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4532
         std/crypto/digest#digest::sha256)
        __obj4532)))
  (define std/crypto/digest#sha256-digest?
    (lambda (_obj609_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj609_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj609_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha256)))
          '#f)))
  (define std/crypto/digest#sha256
    (lambda _args603_
      (let ((_digest606_ (std/crypto/digest#make-sha256-digest)))
        (apply std/crypto/digest#digest-update* _digest606_ _args603_)
        (std/crypto/digest#digest-final!__0 _digest606_))))
  (define std/crypto/digest#digest::sha384 (std/crypto/libcrypto#EVP_sha384))
  (define std/crypto/digest#make-sha384-digest
    (lambda ()
      (let ((__obj4533 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4533
         std/crypto/digest#digest::sha384)
        __obj4533)))
  (define std/crypto/digest#sha384-digest?
    (lambda (_obj599_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj599_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj599_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha384)))
          '#f)))
  (define std/crypto/digest#sha384
    (lambda _args593_
      (let ((_digest596_ (std/crypto/digest#make-sha384-digest)))
        (apply std/crypto/digest#digest-update* _digest596_ _args593_)
        (std/crypto/digest#digest-final!__0 _digest596_))))
  (define std/crypto/digest#digest::sha512 (std/crypto/libcrypto#EVP_sha512))
  (define std/crypto/digest#make-sha512-digest
    (lambda ()
      (let ((__obj4534 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4534
         std/crypto/digest#digest::sha512)
        __obj4534)))
  (define std/crypto/digest#sha512-digest?
    (lambda (_obj589_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj589_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj589_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha512)))
          '#f)))
  (define std/crypto/digest#sha512
    (lambda _args583_
      (let ((_digest586_ (std/crypto/digest#make-sha512-digest)))
        (apply std/crypto/digest#digest-update* _digest586_ _args583_)
        (std/crypto/digest#digest-final!__0 _digest586_))))
  (define std/crypto/digest#digest::ripemd160
    (std/crypto/libcrypto#EVP_ripemd160))
  (define std/crypto/digest#make-ripemd160-digest
    (lambda ()
      (let ((__obj4535 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4535
         std/crypto/digest#digest::ripemd160)
        __obj4535)))
  (define std/crypto/digest#ripemd160-digest?
    (lambda (_obj579_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj579_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj579_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::ripemd160)))
          '#f)))
  (define std/crypto/digest#ripemd160
    (lambda _args573_
      (let ((_digest576_ (std/crypto/digest#make-ripemd160-digest)))
        (apply std/crypto/digest#digest-update* _digest576_ _args573_)
        (std/crypto/digest#digest-final!__0 _digest576_))))
  (define std/crypto/digest#digest::whirlpool
    (std/crypto/libcrypto#EVP_whirlpool))
  (define std/crypto/digest#make-whirlpool-digest
    (lambda ()
      (let ((__obj4536 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj4536
         std/crypto/digest#digest::whirlpool)
        __obj4536)))
  (define std/crypto/digest#whirlpool-digest?
    (lambda (_obj569_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj569_ 'std/crypto#digest::t))
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref _obj569_ '1 std/crypto/digest#digest::t '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::whirlpool)))
          '#f)))
  (define std/crypto/digest#whirlpool
    (lambda _args563_
      (let ((_digest566_ (std/crypto/digest#make-whirlpool-digest)))
        (apply std/crypto/digest#digest-update* _digest566_ _args563_)
        (std/crypto/digest#digest-final!__0 _digest566_)))))
