
module DCE_RPC;

export {
	const uuid_endpoint_map: table[string] of string = {
		["367abb81-9844-35f1-ad32-98f038001003"] = "svcctl",
		["86d35949-83c9-4044-b424-db363231fd0c"] = "ITaskSchedulerService",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f"] = "sasec",
		["1ff70682-0a51-30e8-076d-740be8cee98b"] = "atsvc",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53"] = "idletask",
		["906b0ce0-c70b-1067-b317-00dd010662da"] = "IXnRemote",
		["ae33069b-a2a8-46ee-a235-ddfd339be281"] = "IRPCRemoteObject",
		["0b6edbfa-4a24-4fc6-8a23-942b1eca65d1"] = "IRPCAsyncNotify",
		["afa8bd80-7d8a-11c9-bef4-08002b102989"] = "mgmt",
		["f5cc59b4-4264-101a-8c59-08002b2f8426"] = "FrsRpc",
		["000001a0-0000-0000-c000-000000000046"] = "IRemoteSCMActivator",
		["00000143-0000-0000-c000-000000000046"] = "IRemUnknown2",
		["12345778-1234-abcd-ef00-0123456789ab"] = "lsarpc",
		["76f03f96-cdfd-44fc-a22c-64950a001209"] = "IRemoteWinspool",
		["12345678-1234-abcd-ef00-01234567cffb"] = "netlogon",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2"] = "drsuapi",
		["5261574a-4572-206e-b268-6b199213b4e4"] = "AsyncEMSMDB",
		["4d9f4ab8-7d1c-11cf-861e-0020af6e7c57"] = "IActivation",
		["99fcfec4-5260-101b-bbcb-00aa0021347a"] = "IObjectExporter",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa"] = "epmapper",
		["12345778-1234-abcd-ef00-0123456789ac"] = "samr",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188"] = "srvsvc",
		["45f52c28-7f9f-101a-b52b-08002b2efabe"] = "winspipe",
		["6bffd098-a112-3610-9833-46c3f87e345a"] = "wkssvc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5"] = "dssetup",
		["12345678-1234-abcd-ef00-0123456789ab"] = "spoolss",

		# Exchange
		["1544f5e0-613c-11d1-93df-00c04fd7bd09"] = "exchange_rfr",
		["f5cc5a18-4264-101a-8c59-08002b2f8426"] = "nspi",
		["a4f1db00-ca47-1067-b31f-00dd010662da"] = "exchange_mapi",

		# IWbem
		["9556dc99-828c-11cf-a37e-00aa003240c7"] = "IWbemServices",
		["f309ad18-d86a-11d0-a075-00c04fb68820"] = "IWbemLevel1Login",
		["d4781cd6-e5d3-44df-ad94-930efe48a887"] = "IWbemLoginClientID",
		["44aca674-e8fc-11d0-a07c-00c04fb68820"] = "IWbemContext interface",
		["674b6698-ee92-11d0-ad71-00c04fd8fdff"] = "IWbemContext unmarshaler",
		["dc12a681-737f-11cf-884d-00aa004b2e24"] = "IWbemClassObject interface",
		["4590f812-1d3a-11d0-891f-00aa004b2e24"] = "IWbemClassObject unmarshaler",
		["9a653086-174f-11d2-b5f9-00104b703efd"] = "IWbemClassObject interface",
		["c49e32c6-bc8b-11d2-85d4-00105a1f8304"] = "IWbemBackupRestoreEx interface",
		["7c857801-7381-11cf-884d-00aa004b2e24"] = "IWbemObjectSink interface",
		["027947e1-d731-11ce-a357-000000000001"] = "IEnumWbemClassObject interface",
		["44aca675-e8fc-11d0-a07c-00c04fb68820"] = "IWbemCallResult interface",
		["c49e32c7-bc8b-11d2-85d4-00105a1f8304"] = "IWbemBackupRestore interface",
		["a359dec5-e813-4834-8a2a-ba7f1d777d76"] = "IWbemBackupRestoreEx interface",
		["f1e9c5b2-f59b-11d2-b362-00105a1f8177"] = "IWbemRemoteRefresher interface",
		["2c9273e0-1dc3-11d3-b364-00105a1f8177"] = "IWbemRefreshingServices interface",
		["423ec01e-2e35-11d2-b604-00104b703efd"] = "IWbemWCOSmartEnum interface",
		["1c1c45ee-4395-11d2-b60b-00104b703efd"] = "IWbemFetchSmartEnum interface",
		["541679AB-2E5F-11d3-B34E-00104BCC4B4A"] = "IWbemLoginHelper interface",
		["51c82175-844e-4750-b0d8-ec255555bc06"] = "KMS",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076"] = "dnsserver",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5"] = "AudioSrv",
		["c386ca3e-9061-4a72-821e-498d83be188f"] = "AudioRpc",
		["6bffd098-a112-3610-9833-012892020162"] = "browser",
		["91ae6020-9e3c-11cf-8d7c-00aa00c091be"] = "ICertPassage",
		["c8cb7687-e6d3-11d2-a958-00c04f682e16"] = "DAV RPC SERVICE",
		["82273fdc-e32a-18c3-3f78-827929dc23ea"] = "eventlog",
		["3d267954-eeb7-11d1-b94e-00c04fa3080d"] = "HydraLsPipe",
		["894de0c0-0d55-11d3-a322-00c04fa321a1"] = "InitShutdown",
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d"] = "WindowsShutdown",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b"] = "IKeySvc",
		["68b58241-c259-4f03-a2e5-a2651dcbc930"] = "IKeySvc2",
		["0d72a7d4-6148-11d1-b4aa-00c04fb66ea0"] = "ICertProtect",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43"] = "ICatDBSvc",
		["338cd001-2244-31f1-aaaa-900038001003"] = "winreg",
		["3dde7c30-165d-11d1-ab8f-00805f14db40"] = "BackupKey", # https://msdn.microsoft.com/en-us/library/cc224123.aspx
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5"] = "RpcSrvDHCPC",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6"] = "dhcpcsvc6",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8"] = "lcrpc",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed"] = "winstation_rpc",
		["12b81e99-f207-4a4c-85d3-77b42f76fd14"] = "ISeclogon",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3"] = "NsiS",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3"] = "NsiC",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4"] = "NsiM",
		["17fdd703-1827-4e34-79d4-24a55c53bb37"] = "msgsvc",
		["5a7b91f8-ff00-11d0-a9b2-00c04fb6e6fc"] = "msgsvcsend",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b"] = "pnp",
		["57674cd0-5200-11ce-a897-08002b2e9c6d"] = "lls_license",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d"] = "llsrpc",
		["4fc742e0-4a10-11cf-8273-00aa004ae673"] = "netdfs",
		["83da7c00-e84f-11d2-9807-00c04f8ec850"] = "sfcapi",
		["2f5f3220-c126-1076-b549-074d078619da"] = "nddeapi",

		# Added from BZAR
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7"] = "authzr",
		["e3d0d746-d2af-40fd-8a7a-0d7078bb7092"] = "BitsPeerAuth",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f"] = "clusapi",
		["d61a27c6-8f53-11d0-bfa0-00a024151983"] = "CNtmsSvr",
		["6bffd098-a112-3610-9833-46c3f874532d"] = "dhcpsrv",
		["5b821720-f63b-11d0-aad2-00c04fc324db"] = "dhcpsrv2",
		["8f09f000-b7ed-11ce-bbd2-00001a181cad"] = "dimsvc",
		["7c44d7d4-31d5-424c-bd5e-2b3e1f323d22"] = "dsaop",
		["77df7a80-f298-11d0-8358-00a024c480a8"] = "dscomm",
		["708cca10-9569-11d1-b2a5-0060977d8118"] = "dscomm2",
		["df1941c5-fe89-4e79-bf10-463657acf44d"] = "efsrpc",
		["c681d488-d850-11d0-8c52-00c04fd90f7e"] = "efsrpc2",
		["ea0a3165-4834-11d2-a6f8-00c04fa346cc"] = "fax",
		["6099fc12-3eff-11d0-abd0-00c04fd91a4e"] = "faxclient",
		["a8e0653c-2744-4389-a61d-7373df8b2292"] = "FileServerVssAgent",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27"] = "FrsTransport",
		["4bb8ab1d-9ef9-4100-8eb6-dd4b4e418b72"] = "IADProxy",
		["c4b0c7d9-abe0-4733-a1e1-9fdedf260c7a"] = "IADProxy2",
		["03837516-098b-11d8-9414-505054503030"] = "IAlertDataCollector",
		["0383751a-098b-11d8-9414-505054503030"] = "IApiTracingDataCollector",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3"] = "ICertAdminD",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd"] = "ICertAdminD2",
		["d99e6e70-fc88-11d0-b498-00a0c90312f3"] = "ICertRequestD",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90"] = "ICertRequestD2",
		["879c8bbe-41b0-11d1-be11-00c04fb6bf70"] = "IClientSink",
		["03837514-098b-11d8-9414-505054503030"] = "IConfigurationDataCollector",
		["038374ff-098b-11d8-9414-505054503030"] = "IDataCollector",
		["03837502-098b-11d8-9414-505054503030"] = "IDataCollectorCollection",
		["03837520-098b-11d8-9414-505054503030"] = "IDataCollectorSet",
		["03837524-098b-11d8-9414-505054503030"] = "IDataCollectorSetCollection",
		["03837541-098b-11d8-9414-505054503030"] = "IDataManager",
		["00020400-0000-0000-c000-000000000046"] = "IDispatch",
		["d2d79df7-3400-11d0-b40b-00aa005ff586"] = "IDMNotify",
		["3a410f21-553f-11d1-8e5e-00a0c92c9d5d"] = "IDMRemoteServer",
		["00020404-0000-0000-c000-000000000046"] = "IEnumVARIANT",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c"] = "IEventService",
		["03837543-098b-11d8-9414-505054503030"] = "IFolderAction",
		["03837544-098b-11d8-9414-505054503030"] = "IFolderActionCollection",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18"] = "IIISApplicationAdmin",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2"] = "IIISCertObj",
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe"] = "IIisServiceControl",
		["c3fcc19e-a970-11d2-8b5a-00a0c9b7c9c4"] = "IManagedObject",
		["034634fd-ba3f-11d1-856a-00a0c944138c"] = "IManageTelnetSessions",
		["081e7188-c080-4ff3-9238-29f66d6cabfd"] = "IMessenger",
		["8298d101-f992-43b7-8eca-5052d885b995"] = "IMSAdminBase2W",
		["f612954d-3b0b-4c56-9563-227b7be624b4"] = "IMSAdminBase3W",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750"] = "IMSAdminBaseW",
		["82ad4280-036b-11cf-972c-00aa006887b0"] = "inetinfo",
		["4e934f30-341a-11d1-8fb1-00a024cb6019"] = "INtmsLibraryControl1",
		["db90832f-6910-4d46-9f5e-9fd6bfa73903"] = "INtmsLibraryControl2",
		["d02e4be0-3419-11d1-8fb1-00a024cb6019"] = "INtmsMediaServices1",
		["bb39332c-bfee-4380-ad8a-badc8aff5bb6"] = "INtmsNotifySink",
		["69ab7050-3059-11d1-8faf-00a024cb6019"] = "INtmsObjectInfo1",
		["b057dc50-3059-11d1-8faf-00a024cb6019"] = "INtmsObjectManagement1",
		["895a2c86-270d-489d-a6c0-dc2a9b35280e"] = "INtmsObjectManagement2",
		["3bbed8d9-2c9a-4b21-8936-acb2f995be6c"] = "INtmsObjectManagement3",
		["8da03f40-3419-11d1-8fb1-00a024cb6019"] = "INtmsSession1",
		["784b693d-95f3-420b-8126-365c098659f2"] = "IOCSPAdminD",
		["833e4100-aff7-4ac3-aac2-9f24c1457bce"] = "IPCHCollection",
		["833e4200-aff7-4ac3-aac2-9f24c1457bce"] = "IPCHService",
		["03837506-098b-11d8-9414-505054503030"] = "IPerformanceCounterDataCollector",
		["f120a684-b926-447f-9df4-c966cb785648"] = "IRASrv",
		["6619a740-8154-43be-a186-0319578e02db"] = "IRemoteDispatch",
		["66a2db22-d706-11d0-a37b-00c04fc9da04"] = "IRemoteICFICSConfig",
		["6139d8a4-e508-4ebb-bac7-d7f275145897"] = "IRemoteIPV6Config",
		["66a2db1b-d706-11d0-a37b-00c04fc9da04"] = "IRemoteNetworkConfig",
		["66a2db20-d706-11d0-a37b-00c04fc9da04"] = "IRemoteRouterRestart",
		["66a2db21-d706-11d0-a37b-00c04fc9da04"] = "IRemoteSetDnsConfig",
		["5ff9bdf6-bd91-4d8b-a614-d6317acc8dd8"] = "IRemoteSstpCertCheck",
		["67e08fc2-2984-4b62-b92e-fc1aae64bbbb"] = "IRemoteStringIdConfig",
		["00000131-0000-0000-c000-000000000046"] = "IRemUnknown",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4"] = "IResourceManager",
		["2a3eb639-d134-422d-90d8-aaa1b5216202"] = "IResourceManager2",
		["7d07f313-a53f-459a-bb12-012c15b1846e"] = "IRobustNtmsMediaServices1",
		["833e41aa-aff7-4ac3-aac2-9f24c1457bce"] = "ISAFSession",
		["0383753a-098b-11d8-9414-505054503030"] = "ISchedule",
		["0383753d-098b-11d8-9414-505054503030"] = "IScheduleCollection",
		["b9785960-524f-11df-8b6d-83dcded72085"] = "ISDKey",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce"] = "IServerHealthReport",
		["20d15747-6c48-4254-a358-65039fd8c63c"] = "IServerHealthReport2",
		["8165b19e-8d3a-4d0b-80c8-97de310db583"] = "IServicedComponentInfo",
		["112b1dff-d9dc-41f7-869f-d67fee7cb591"] = "ITpmVirtualSmartCardManager",
		["fdf8a2b9-02de-47f4-bc26-aa85ab5e5267"] = "ITpmVirtualSmartCardManager2",
		["3c745a97-f375-4150-be17-5950f694c699"] = "ITpmVirtualSmartCardManager3",
		["1a1bb35f-abb8-451c-a1ae-33d98f1bef4a"] = "ITpmVirtualSmartCardManagerStatusCallback",
		["0383750b-098b-11d8-9414-505054503030"] = "ITraceDataCollector",
		["03837512-098b-11d8-9414-505054503030"] = "ITraceDataProvider",
		["03837510-098b-11d8-9414-505054503030"] = "ITraceDataProviderCollection",
		["00020403-0000-0000-c000-000000000046"] = "ITypeComp",
		["00020401-0000-0000-c000-000000000046"] = "ITypeInfo",
		["00020412-0000-0000-c000-000000000046"] = "ITypeInfo2",
		["00020402-0000-0000-c000-000000000046"] = "ITypeLib",
		["00020411-0000-0000-c000-000000000046"] = "ITypeLib2",
		["00000000-0000-0000-c000-000000000046"] = "IUnknown",
		["03837534-098b-11d8-9414-505054503030"] = "IValueMap",
		["03837533-098b-11d8-9414-505054503030"] = "IValueMapItem",
		["d2d79df5-3400-11d0-b40b-00aa005ff586"] = "IVolumeClient",
		["4bdafc52-fe6a-11d2-93f8-00105a11164a"] = "IVolumeClient2",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61"] = "IVolumeClient3",
		["deb01010-3a37-4d26-99df-e2bb6ae3ac61"] = "IVolumeClient4",
		["214a0f28-b737-4026-b847-4f9e37d79529"] = "IVssDifferentialSoftwareSnapshotMgmt",
		["01954e6b-9254-4e6e-808c-c9e05d007696"] = "IVssEnumMgmtObject",
		["ae1c7110-2f60-11d3-8a39-00c04f72d8e3"] = "IVssEnumObject",
		["fa7df749-66e7-4986-a27f-e2f04ae53772"] = "IVssSnapshotMgmt",
		["29822ab7-f302-11d0-9953-00c04fd919c1"] = "IWamAdmin",
		["29822ab8-f302-11d0-9953-00c04fd919c1"] = "IWamAdmin2",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d"] = "IWRMAccounting",
		["481e06cf-ab04-4498-8ffe-124a0a34296d"] = "IWRMCalendar",
		["21546ae8-4da5-445e-987f-627fea39c5e8"] = "IWRMConfig",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b"] = "IWRMMachineGroup",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15"] = "IWRMPolicy",
		["f31931a9-832d-481c-9503-887a0e6a79f0"] = "IWRMProtocol",
		["fc910418-55ca-45ef-b264-83d4ce7d30e0"] = "IWRMRemoteSessionMgmt",
		["bc681469-9dd9-4bf4-9b3d-709f69efe431"] = "IWRMResourceGroup",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218"] = "locator",
		["afc07e2e-311c-4435-808c-c483ffeec7c9"] = "lsacap",
		["22e5386d-8b12-4bf0-b0ec-6a1ea419e366"] = "NetEventForwarder",
		["d049b186-814f-11d1-9a3c-00c04fc9b232"] = "NtFrsApi",
		["da5a86c5-12c2-4943-ab30-7f74a813d853"] = "PerflibV2",
		["1088a980-eae5-11d0-8d9b-00a02453c337"] = "qm2qm",
		["fdb3a030-065f-11d1-bb9b-00a024ea5525"] = "qmcomm",
		["76d12b80-3467-11d3-91ff-0090272f9ea3"] = "qmcomm2",
		["41208ee0-e970-11d1-9b9e-00e02c064c39"] = "qmmgmt",
		["20610036-fa22-11cf-9823-00a0c911e5df"] = "rasrpc",
		["497d95a6-2d27-4bf5-9bbd-a6046957133c"] = "RCMListener",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe"] = "RCMPublic",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48"] = "RemoteFW",
		["1a9134dd-7b39-45ba-ad88-44d01ca47f28"] = "RemoteRead",
		["2f5f6521-ca47-1068-b319-00dd010662db"] = "remotesp",
		["1257b580-ce2f-4109-82d6-a9459d0bf6bc"] = "SessEnvPublicRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f"] = "ssdpsrv",
		["2f5f6520-ca46-1067-b319-00dd010662da"] = "tapsrv",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390"] = "TermServEnumeration",
		["11899a43-2b68-4a76-92e3-a3d6ad8c26ce"] = "TermServNotification",
		["484809d6-4239-471b-b5bc-61df8c23ac48"] = "TermSrvSession",
		["4da1c422-943d-11d1-acae-00c04fc2aa3f"] = "trksvr",
		["300f3532-38cc-11d0-a3f0-0020af6b0add"] = "trkwks",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729"] = "TsProxyRpcInterface",
		["53b46b02-c73b-4a3e-8dee-b16b80672fc0"] = "TSVIPPublic",
		["8fb6d884-2388-11d0-8c35-00c04fda2795"] = "W32Time",
		["1a927394-352e-4553-ae3f-7cf4aafca620"] = "WdsRpcInterface",
		["811109bf-a4e1-11d1-ab54-00a0c91e9b45"] = "winsi2",
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28"] = "Witness",

	} &redef &default=function(uuid: string): string { return fmt("unknown-%s", uuid); };

	## This table is to map pipe names to the most common
	## service used over that pipe.  It helps in cases
	## where the pipe binding wasn't seen.
	const pipe_name_to_common_uuid: table[string] of string = {
		["winreg"] = "338cd001-2244-31f1-aaaa-900038001003",
		["spoolss"] = "12345678-1234-abcd-ef00-0123456789ab",
		["srvsvc"] = "4b324fc8-1670-01d3-1278-5a47bf6ee188",
	} &redef;

	const operations: table[string,count] of string = {
		# atsvc
		["1ff70682-0a51-30e8-076d-740be8cee98b",0x00] = "NetrJobAdd",
		["1ff70682-0a51-30e8-076d-740be8cee98b",0x01] = "NetrJobDel",
		["1ff70682-0a51-30e8-076d-740be8cee98b",0x02] = "NetrJobEnum",
		["1ff70682-0a51-30e8-076d-740be8cee98b",0x03] = "NetrJobGetInfo",

		# sasec
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",0x00] = "SASetAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",0x01] = "SASetNSAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",0x02] = "SAGetNSAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",0x03] = "SAGetAccountInformation",

		# idletask
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",0x00] = "ItSrvRegisterIdleTask",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",0x01] = "ItSrvUnregisterIdleTask",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",0x02] = "ItSrvProcessIdleTasks",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",0x03] = "ItSrvSetDetectionParameters",

		# ITaskSchedulerService
		["86d35949-83c9-4044-b424-db363231fd0c",0x00] = "SchRpcHighestVersion",
		["86d35949-83c9-4044-b424-db363231fd0c",0x01] = "SchRpcRegisterTask",
		["86d35949-83c9-4044-b424-db363231fd0c",0x02] = "SchRpcRetrieveTask",
		["86d35949-83c9-4044-b424-db363231fd0c",0x03] = "SchRpcCreateFolder",
		["86d35949-83c9-4044-b424-db363231fd0c",0x04] = "SchRpcSetSecurity",
		["86d35949-83c9-4044-b424-db363231fd0c",0x05] = "SchRpcGetSecurity",
		["86d35949-83c9-4044-b424-db363231fd0c",0x06] = "SchRpcEnumFolder",
		["86d35949-83c9-4044-b424-db363231fd0c",0x07] = "SchRpcEnumTasks",
		["86d35949-83c9-4044-b424-db363231fd0c",0x08] = "SchRpcEnumInstances",
		["86d35949-83c9-4044-b424-db363231fd0c",0x09] = "SchRpcGetInstanceInfo",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0a] = "SchRpcStopInstance",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0b] = "SchRpcStop",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0c] = "SchRpcRun",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0d] = "SchRpcDelete",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0e] = "SchRpcRename",
		["86d35949-83c9-4044-b424-db363231fd0c",0x0f] = "SchRpcScheduledRuntimes",
		["86d35949-83c9-4044-b424-db363231fd0c",0x10] = "SchRpcGetLastRunInfo",
		["86d35949-83c9-4044-b424-db363231fd0c",0x11] = "SchRpcGetTaskInfo",

		# IObjectExporter
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x00] = "ResolveOxid",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x01] = "SimplePing",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x02] = "ComplexPing",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x03] = "ServerAlive",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x04] = "ResolveOxid2",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0x05] = "ServerAlive2",

		# IActivation
		["4d9f4ab8-7d1c-11cf-861e-0020af6e7c57",0x00] = "RemoteActivation",

		# nspi
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x00] = "NspiBind",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x01] = "NspiUnbind",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x02] = "NspiUpdateStat",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x03] = "NspiQueryRows",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x04] = "NspiSeekEntries",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x05] = "NspiGetMatches",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x06] = "NspiResortRestriction",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x07] = "NspiDNToEph",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x08] = "NspiGetPropList",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0x09] = "NspiGetProps",

		# IWbemServices
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x03] = "OpenNamespace",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x04] = "CancelAsyncCall",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x05] = "QueryObjectSink",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x06] = "GetObject",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x07] = "GetObjectAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x08] = "PutClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x09] = "PutClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0a] = "DeleteClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0b] = "DeleteClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0c] = "CreateClassEnum",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0d] = "CreateClassEnumAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0e] = "PutInstance",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x0f] = "PutInstanceAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x10] = "DeleteClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x11] = "DeleteClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x12] = "CreateInstanceEnum",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x13] = "CreateInstanceEnumAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x14] = "ExecQuery",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x15] = "ExecQueryAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x16] = "ExecNotificationQuery",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x17] = "ExecNotificationQueryAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x18] = "ExecMethod",
		["9556dc99-828c-11cf-a37e-00aa003240c7",0x19] = "ExecMethodAsync",

		# IWbemLevel1Login
		["f309ad18-d86a-11d0-a075-00c04fb68820",0x03] = "EstablishPosition",
		["f309ad18-d86a-11d0-a075-00c04fb68820",0x04] = "RequestChallenge",
		["f309ad18-d86a-11d0-a075-00c04fb68820",0x05] = "WBEMLogin",
		["f309ad18-d86a-11d0-a075-00c04fb68820",0x06] = "NTLMLogin",

		# FrsRpc
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x00] = "FrsRpcSendCommPkt",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x01] = "FrsRpcVerifyPromotionParent",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x02] = "FrsRpcStartPromotionParent",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x03] = "FrsNOP",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x04] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x05] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x06] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x07] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x08] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x09] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0x0a] = "FrsRpcVerifyPromotionParentEx",

		# IRemUnknown2
		["00000143-0000-0000-c000-000000000046",0x00] = "QueryInterface",
		["00000143-0000-0000-c000-000000000046",0x01] = "AddRef",
		["00000143-0000-0000-c000-000000000046",0x02] = "Release",
		["00000143-0000-0000-c000-000000000046",0x03] = "RemQueryInterface",
		["00000143-0000-0000-c000-000000000046",0x04] = "RemAddRef",
		["00000143-0000-0000-c000-000000000046",0x05] = "RemRelease",
		["00000143-0000-0000-c000-000000000046",0x06] = "RemQueryInterface2",

		# IRemoteSCMActivator
		["000001a0-0000-0000-c000-000000000046",0x00] = "QueryInterfaceIRemoteSCMActivator",
		["000001a0-0000-0000-c000-000000000046",0x01] = "AddRefIRemoteISCMActivator",
		["000001a0-0000-0000-c000-000000000046",0x02] = "ReleaseIRemoteISCMActivator",
		["000001a0-0000-0000-c000-000000000046",0x03] = "RemoteGetClassObject",
		["000001a0-0000-0000-c000-000000000046",0x04] = "RemoteCreateInstance",

		# netlogon
		["12345678-1234-abcd-ef00-01234567cffb",0x00] = "NetrLogonUasLogon",
		["12345678-1234-abcd-ef00-01234567cffb",0x01] = "NetrLogonUasLogoff",
		["12345678-1234-abcd-ef00-01234567cffb",0x02] = "NetrLogonSamLogon",
		["12345678-1234-abcd-ef00-01234567cffb",0x03] = "NetrLogonSamLogoff",
		["12345678-1234-abcd-ef00-01234567cffb",0x04] = "NetrServerReqChallenge",
		["12345678-1234-abcd-ef00-01234567cffb",0x05] = "NetrServerAuthenticate",
		["12345678-1234-abcd-ef00-01234567cffb",0x06] = "NetrServerPasswordSet",
		["12345678-1234-abcd-ef00-01234567cffb",0x07] = "NetrDatabaseDeltas",
		["12345678-1234-abcd-ef00-01234567cffb",0x08] = "NetrDatabaseSync",
		["12345678-1234-abcd-ef00-01234567cffb",0x09] = "NetrAccountDeltas",
		["12345678-1234-abcd-ef00-01234567cffb",0x0a] = "NetrAccountSync",
		["12345678-1234-abcd-ef00-01234567cffb",0x0b] = "NetrGetDCName",
		["12345678-1234-abcd-ef00-01234567cffb",0x0c] = "NetrLogonControl",
		["12345678-1234-abcd-ef00-01234567cffb",0x0d] = "NetrGetAnyDCName",
		["12345678-1234-abcd-ef00-01234567cffb",0x0e] = "NetrLogonControl2",
		["12345678-1234-abcd-ef00-01234567cffb",0x0f] = "NetrServerAuthenticate2",
		["12345678-1234-abcd-ef00-01234567cffb",0x10] = "NetrDatabaseSync2",
		["12345678-1234-abcd-ef00-01234567cffb",0x11] = "NetrDatabaseRedo",
		["12345678-1234-abcd-ef00-01234567cffb",0x12] = "NetrLogonControl2Ex",
		["12345678-1234-abcd-ef00-01234567cffb",0x13] = "NetrEnumerateTrustedDomains",
		["12345678-1234-abcd-ef00-01234567cffb",0x14] = "DsrGetDcName",
		["12345678-1234-abcd-ef00-01234567cffb",0x15] = "NetrLogonGetCapabilities",
		["12345678-1234-abcd-ef00-01234567cffb",0x16] = "NetrLogonSetServiceBits",
		["12345678-1234-abcd-ef00-01234567cffb",0x17] = "NetrLogonGetTrustRid",
		["12345678-1234-abcd-ef00-01234567cffb",0x18] = "NetrLogonComputeServerDigest",
		["12345678-1234-abcd-ef00-01234567cffb",0x19] = "NetrLogonComputeClientDigest",
		["12345678-1234-abcd-ef00-01234567cffb",0x1a] = "NetrServerAuthenticate3",
		["12345678-1234-abcd-ef00-01234567cffb",0x1b] = "DsrGetDcNameEx",
		["12345678-1234-abcd-ef00-01234567cffb",0x1c] = "DsrGetSiteName",
		["12345678-1234-abcd-ef00-01234567cffb",0x1d] = "NetrLogonGetDomainInfo",
		["12345678-1234-abcd-ef00-01234567cffb",0x1e] = "NetrServerPasswordSet2",
		["12345678-1234-abcd-ef00-01234567cffb",0x1f] = "NetrServerPasswordGet",
		["12345678-1234-abcd-ef00-01234567cffb",0x20] = "NetrLogonSendToSam",
		["12345678-1234-abcd-ef00-01234567cffb",0x21] = "DsrAddressToSiteNamesW",
		["12345678-1234-abcd-ef00-01234567cffb",0x22] = "DsrGetDcNameEx2",
		["12345678-1234-abcd-ef00-01234567cffb",0x23] = "NetrLogonGetTimeServiceParentDomain",
		["12345678-1234-abcd-ef00-01234567cffb",0x24] = "NetrEnumerateTrustedDomainsEx",
		["12345678-1234-abcd-ef00-01234567cffb",0x25] = "DsrAddressToSiteNamesExW",
		["12345678-1234-abcd-ef00-01234567cffb",0x26] = "DsrGetDcSiteCoverageW",
		["12345678-1234-abcd-ef00-01234567cffb",0x27] = "NetrLogonSamLogonEx",
		["12345678-1234-abcd-ef00-01234567cffb",0x28] = "DsrEnumerateDomainTrusts",
		["12345678-1234-abcd-ef00-01234567cffb",0x29] = "DsrDeregisterDnsHostRecords",
		["12345678-1234-abcd-ef00-01234567cffb",0x2a] = "NetrServerTrustPasswordsGet",
		["12345678-1234-abcd-ef00-01234567cffb",0x2b] = "DsrGetForestTrustInformation",
		["12345678-1234-abcd-ef00-01234567cffb",0x2c] = "NetrGetForestTrustInformation",
		["12345678-1234-abcd-ef00-01234567cffb",0x2d] = "NetrLogonSamLogonWithFlags",
		["12345678-1234-abcd-ef00-01234567cffb",0x2e] = "NetrServerGetTrustInfo",
		["12345678-1234-abcd-ef00-01234567cffb",0x2f] = "unused",
		["12345678-1234-abcd-ef00-01234567cffb",0x30] = "DsrUpdateReadOnlyServerDnsRecords",
		["12345678-1234-abcd-ef00-01234567cffb",0x31] = "NetrChainSetClientAttributes",

		# IRemoteWinspool
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x00] = "RpcAsyncOpenPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x01] = "RpcAsyncAddPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x02] = "RpcAsyncSetJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x03] = "RpcAsyncGetJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x04] = "RpcAsyncEnumJobs",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x05] = "RpcAsyncAddJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x06] = "RpcAsyncScheduleJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x07] = "RpcAsyncDeletePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x08] = "RpcAsyncSetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x09] = "RpcAsyncGetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0a] = "RpcAsyncStartDocPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0b] = "RpcAsyncStartPagePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0c] = "RpcAsyncWritePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0d] = "RpcAsyncEndPagePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0e] = "RpcAsyncEndDocPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x0f] = "RpcAsyncAbortPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x10] = "RpcAsyncGetPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x11] = "RpcAsyncGetPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x12] = "RpcAsyncSetPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x13] = "RpcAsyncSetPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x14] = "RpcAsyncClosePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x15] = "RpcAsyncAddForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x16] = "RpcAsyncDeleteForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x17] = "RpcAsyncGetForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x18] = "RpcAsyncSetForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x19] = "RpcAsyncEnumForms",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1a] = "RpcAsyncGetPrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1b] = "RpcAsyncEnumPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1c] = "RpcAsyncEnumPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1d] = "RpcAsyncEnumPrinterKey",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1e] = "RpcAsyncDeletePrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x1f] = "RpcAsyncDeletePrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x20] = "RpcAsyncDeletePrinterKey",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x21] = "RpcAsyncXcvData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x22] = "RpcAsyncSendRecvBidiData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x23] = "RpcAsyncCreatePrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x24] = "RpcAsyncPlayGdiScriptOnPrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x25] = "RpcAsyncDeletePrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x26] = "RpcAsyncEnumPrinters",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x27] = "RpcAsyncAddPrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x28] = "RpcAsyncEnumPrinterDrivers",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x29] = "RpcAsyncGetPrinterDriverDirectory",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2a] = "RpcAsyncDeletePrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2b] = "RpcAsyncDeletePrinterDriverEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2c] = "RpcAsyncAddPrintProcessor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2d] = "RpcAsyncEnumPrintProcessors",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2e] = "RpcAsyncGetPrintProcessorDirectory",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x2f] = "RpcAsyncEnumPorts",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x30] = "RpcAsyncEnumMonitors",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x31] = "RpcAsyncAddPort",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x32] = "RpcAsyncSetPort",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x33] = "RpcAsyncAddMonitor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x34] = "RpcAsyncDeleteMonitor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x35] = "RpcAsyncDeletePrintProcessor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x36] = "RpcAsyncEnumPrintProcessorDatatypes",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x37] = "RpcAsyncAddPerMachineConnection",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x38] = "RpcAsyncDeletePerMachineConnection",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x39] = "RpcAsyncEnumPerMachineConnections",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3a] = "RpcSyncRegisterForRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3b] = "RpcSyncUnRegisterForRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3c] = "RpcSyncRefreshRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3d] = "RpcAsyncGetRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3e] = "RpcAsyncInstallPrinterDriverFromPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x3f] = "RpcAsyncUploadPrinterDriverPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x40] = "RpcAsyncGetCorePrinterDrivers",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x41] = "RpcAsyncCorePrinterDriverInstalled",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x42] = "RpcAsyncGetPrinterDriverPackagePath",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x43] = "RpcAsyncDeletePrinterDriverPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x44] = "RpcAsyncReadPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x45] = "RpcAsyncResetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x46] = "RpcAsyncGetJobNamedPropertyValue",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x47] = "RpcAsyncSetJobNamedProperty",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x48] = "RpcAsyncDeleteJobNamedProperty",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x49] = "RpcAsyncEnumJobNamedProperties",
		["76f03f96-cdfd-44fc-a22c-64950a001209",0x4a] = "RpcAsyncLogJobInfoForBranchOffice",

		# InitShutdown
		["894de0c0-0d55-11d3-a322-00c04fa321a1",0x00]  = "BaseInitiateShutdown",
		["894de0c0-0d55-11d3-a322-00c04fa321a1",0x01]  = "BaseAbortShutdown",
		["894de0c0-0d55-11d3-a322-00c04fa321a1",0x02]  = "BaseInitiateShutdownEx",

		# WindowsShutdown
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d",0x00] = "WsdrInitiateShutdown",
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d",0x01] = "WsdrAbortShutdown",

		# spoolss
		["12345678-1234-abcd-ef00-0123456789ab",0x00] = "RpcEnumPrinters",
		["12345678-1234-abcd-ef00-0123456789ab",0x01] = "RpcOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x02] = "RpcSetJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x03] = "RpcGetJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x04] = "RpcEnumJobs",
		["12345678-1234-abcd-ef00-0123456789ab",0x05] = "RpcAddPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x06] = "RpcDeletePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x07] = "RpcSetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x08] = "RpcGetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x09] = "RpcAddPrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0a] = "RpcEnumPrinterDrivers",
		["12345678-1234-abcd-ef00-0123456789ab",0x0b] = "RpcGetPrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0c] = "RpcGetPrinterDriverDirectory",
		["12345678-1234-abcd-ef00-0123456789ab",0x0d] = "RpcDeletePrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0e] = "RpcAddPrintProcessor",
		["12345678-1234-abcd-ef00-0123456789ab",0x0f] = "RpcEnumPrintProcessors",
		["12345678-1234-abcd-ef00-0123456789ab",0x10] = "RpcGetPrintProcessorDirectory",
		["12345678-1234-abcd-ef00-0123456789ab",0x11] = "RpcStartDocPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x12] = "RpcStartPagePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x13] = "RpcWritePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x14] = "RpcEndPagePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x15] = "RpcAbortPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x16] = "RpcReadPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x17] = "RpcEndDocPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x18] = "RpcAddJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x19] = "RpcScheduleJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x1a] = "RpcGetPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x1b] = "RpcSetPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x1c] = "RpcWaitForPrinterChange",
		["12345678-1234-abcd-ef00-0123456789ab",0x1d] = "RpcClosePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x1e] = "RpcAddForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x1f] = "RpcDeleteForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x20] = "RpcGetForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x21] = "RpcSetForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x22] = "RpcEnumForms",
		["12345678-1234-abcd-ef00-0123456789ab",0x23] = "RpcEnumPorts",
		["12345678-1234-abcd-ef00-0123456789ab",0x24] = "RpcEnumMonitors",
		["12345678-1234-abcd-ef00-0123456789ab",0x25] = "RpcAddPort",
		["12345678-1234-abcd-ef00-0123456789ab",0x26] = "RpcConfigurePort",
		["12345678-1234-abcd-ef00-0123456789ab",0x27] = "RpcDeletePort",
		["12345678-1234-abcd-ef00-0123456789ab",0x28] = "RpcCreatePrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x29] = "RpcPlayGdiScriptOnPrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x2a] = "RpcDeletePrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x2b] = "RpcAddPrinterConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x2c] = "RpcDeletePrinterConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x2d] = "RpcPrinterMessageBox",
		["12345678-1234-abcd-ef00-0123456789ab",0x2e] = "RpcAddMonitor",
		["12345678-1234-abcd-ef00-0123456789ab",0x2f] = "RpcDeleteMonitor",
		["12345678-1234-abcd-ef00-0123456789ab",0x30] = "RpcDeletePrintProcessor",
		["12345678-1234-abcd-ef00-0123456789ab",0x31] = "RpcAddPrintProvidor",
		["12345678-1234-abcd-ef00-0123456789ab",0x32] = "RpcDeletePrintProvidor",
		["12345678-1234-abcd-ef00-0123456789ab",0x33] = "RpcEnumPrintProcessorDatatypes",
		["12345678-1234-abcd-ef00-0123456789ab",0x34] = "RpcResetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x35] = "RpcGetPrinterDriver2",
		["12345678-1234-abcd-ef00-0123456789ab",0x36] = "RpcClientFindFirstPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x37] = "RpcFindNextPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x38] = "RpcFindClosePrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x39] = "RpcRouterFindFirstPrinterChangeNotificationOld",
		["12345678-1234-abcd-ef00-0123456789ab",0x3a] = "RpcReplyOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3b] = "RpcRouterReplyPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3c] = "RpcReplyClosePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3d] = "RpcAddPortEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x3e] = "RpcRemoteFindFirstPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x3f] = "RpcSpoolerInit",
		["12345678-1234-abcd-ef00-0123456789ab",0x40] = "RpcResetPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x41] = "RpcRemoteFindFirstPrinterChangeNotificationEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x42] = "RpcRouterReplyPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x43] = "RpcRouterRefreshPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x44] = "RpcSetAllocFailCount",
		["12345678-1234-abcd-ef00-0123456789ab",0x45] = "RpcSplOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x46] = "RpcAddPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x47] = "RpcSetPort",
		["12345678-1234-abcd-ef00-0123456789ab",0x48] = "RpcEnumPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x49] = "RpcDeletePrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x4a] = "RpcClusterSplOpen",
		["12345678-1234-abcd-ef00-0123456789ab",0x4b] = "RpcClusterSplClose",
		["12345678-1234-abcd-ef00-0123456789ab",0x4c] = "RpcClusterSplIsAlive",
		["12345678-1234-abcd-ef00-0123456789ab",0x4d] = "RpcSetPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x4e] = "RpcGetPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x4f] = "RpcEnumPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x50] = "RpcEnumPrinterKey",
		["12345678-1234-abcd-ef00-0123456789ab",0x51] = "RpcDeletePrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x52] = "RpcDeletePrinterKey",
		["12345678-1234-abcd-ef00-0123456789ab",0x53] = "RpcSeekPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x54] = "RpcDeletePrinterDriverEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x55] = "RpcAddPerMachineConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x56] = "RpcDeletePerMachineConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x57] = "RpcEnumPerMachineConnections",
		["12345678-1234-abcd-ef00-0123456789ab",0x58] = "RpcXcvData",
		["12345678-1234-abcd-ef00-0123456789ab",0x59] = "RpcAddPrinterDriverEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x5a] = "RpcSplOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x5b] = "RpcGetSpoolFileInfo",
		["12345678-1234-abcd-ef00-0123456789ab",0x5c] = "RpcCommitSpoolData",
		["12345678-1234-abcd-ef00-0123456789ab",0x5d] = "RpcCloseSpoolFileHandle",
		["12345678-1234-abcd-ef00-0123456789ab",0x5e] = "RpcFlushPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x5f] = "RpcSendRecvBidiData",
		["12345678-1234-abcd-ef00-0123456789ab",0x60] = "RpcAddDriverCatalog",
		["12345678-1234-abcd-ef00-0123456789ab",0x61] = "RpcAddPrinterConnection2",
		["12345678-1234-abcd-ef00-0123456789ab",0x62] = "RpcDeletePrinterConnection2",
		["12345678-1234-abcd-ef00-0123456789ab",0x63] = "RpcInstallPrinterDriverFromPackage",
		["12345678-1234-abcd-ef00-0123456789ab",0x64] = "RpcUploadPrinterDriverPackage",
		["12345678-1234-abcd-ef00-0123456789ab",0x65] = "RpcGetCorePrinterDrivers",
		["12345678-1234-abcd-ef00-0123456789ab",0x66] = "RpcCorePrinterDriverInstalled",
		["12345678-1234-abcd-ef00-0123456789ab",0x67] = "RpcGetPrinterDriverPackagePath",
		["12345678-1234-abcd-ef00-0123456789ab",0x68] = "RpcReportJobProcessingProgress",

		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x00] = "NetrCharDevEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x01] = "NetrCharDevGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x02] = "NetrCharDevControl",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x03] = "NetrCharDevQEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x04] = "NetrCharDevQGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x05] = "NetrCharDevQSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x06] = "NetrCharDevQPurge",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x07] = "NetrCharDevQPurgeSelf",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x08] = "NetrConnectionEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x09] = "NetrFileEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0a] = "NetrFileGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0b] = "NetrFileClose",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0c] = "NetrSessionEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0d] = "NetrSessionDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0e] = "NetrShareAdd",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0f] = "NetrShareEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x10] = "NetrShareGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x11] = "NetrShareSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x12] = "NetrShareDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x13] = "NetrShareDelSticky",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x14] = "NetrShareCheck",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x15] = "NetrServerGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x16] = "NetrServerSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x17] = "NetrServerDiskEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x18] = "NetrServerStatisticsGet",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x19] = "NetrServerTransportAdd",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1a] = "NetrServerTransportEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1b] = "NetrServerTransportDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1c] = "NetrRemoteTOD",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1d] = "NetrServerSetServiceBits",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1e] = "NetprPathType",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1f] = "NetprPathCanonicalize",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x20] = "NetprPathCompare",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x21] = "NetprNameValidate",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x22] = "NetprNameCanonicalize",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x23] = "NetprNameCompare",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x24] = "NetrShareEnumSticky",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x25] = "NetrShareDelStart",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x26] = "NetrShareDelCommit",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x27] = "NetrpGetFileSecurity",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x28] = "NetrpSetFileSecurity",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x29] = "NetrServerTransportAddEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2a] = "NetrServerSetServiceBitsEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2b] = "NetrDfsGetVersion",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2c] = "NetrDfsCreateLocalPartition",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2d] = "NetrDfsDeleteLocalPartition",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2e] = "NetrDfsSetLocalVolumeState",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2f] = "NetrDfsSetServerInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x30] = "NetrDfsCreateExitPoint",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x31] = "NetrDfsDeleteExitPoint",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x32] = "NetrDfsModifyPrefix",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x33] = "NetrDfsFixLocalVolume",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x34] = "NetrDfsManagerReportSiteInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x35] = "NetrServerTransportDelEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x37] = "NetrServerAliasEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x38] = "NetrServerAliasDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x39] = "NetrShareDelEx",

		["12345778-1234-abcd-ef00-0123456789ac",0x00] = "SamrConnect",
		["12345778-1234-abcd-ef00-0123456789ac",0x01] = "SamrCloseHandle",
		["12345778-1234-abcd-ef00-0123456789ac",0x02] = "SamrSetSecurityObject",
		["12345778-1234-abcd-ef00-0123456789ac",0x03] = "SamrQuerySecurityObject",
		["12345778-1234-abcd-ef00-0123456789ac",0x04] = "SamrShutdownSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x05] = "SamrLookupDomainInSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x06] = "SamrEnumerateDomainsInSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x07] = "SamrOpenDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x08] = "SamrQueryInformationDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x09] = "SamrSetInformationDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0a] = "SamrCreateGroupInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0b] = "SamrEnumerateGroupsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0c] = "SamrCreateUserInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0d] = "SamrEnumerateUsersInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0e] = "SamrCreateAliasInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0f] = "SamrEnumerateAliasesInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x10] = "SamrGetAliasMembership",
		["12345778-1234-abcd-ef00-0123456789ac",0x11] = "SamrLookupNamesInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x12] = "SamrLookupIdsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x13] = "SamrOpenGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x14] = "SamrQueryInformationGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x15] = "SamrSetInformationGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x16] = "SamrAddMemberToGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x17] = "SamrDeleteGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x18] = "SamrRemoveMemberFromGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x19] = "SamrGetMembersInGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x1a] = "SamrSetMemberAttributesOfGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x1b] = "SamrOpenAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1c] = "SamrQueryInformationAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1d] = "SamrSetInformationAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1e] = "SamrDeleteAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1f] = "SamrAddMemberToAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x20] = "SamrRemoveMemberFromAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x21] = "SamrGetMembersInAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x22] = "SamrOpenUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x23] = "SamrDeleteUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x24] = "SamrQueryInformationUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x25] = "SamrSetInformationUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x26] = "SamrChangePasswordUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x27] = "SamrGetGroupsForUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x28] = "SamrQueryDisplayInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x29] = "SamrGetDisplayEnumerationIndex",
		["12345778-1234-abcd-ef00-0123456789ac",0x2a] = "SamrTestPrivateFunctionsDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x2b] = "SamrTestPrivateFunctionsUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x2c] = "SamrGetUserDomainPasswordInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x2d] = "SamrRemoveMemberFromForeignDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x2e] = "SamrQueryInformationDomain2",
		["12345778-1234-abcd-ef00-0123456789ac",0x2f] = "SamrQueryInformationUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x30] = "SamrQueryDisplayInformation2",
		["12345778-1234-abcd-ef00-0123456789ac",0x31] = "SamrGetDisplayEnumerationIndex2",
		["12345778-1234-abcd-ef00-0123456789ac",0x32] = "SamrCreateUser2InDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x33] = "SamrQueryDisplayInformation3",
		["12345778-1234-abcd-ef00-0123456789ac",0x34] = "SamrAddMultipleMembersToAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x35] = "SamrRemoveMultipleMembersFromAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x36] = "SamrOemChangePasswordUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x37] = "SamrUnicodeChangePasswordUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x38] = "SamrGetDomainPasswordInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x39] = "SamrConnect2",
		["12345778-1234-abcd-ef00-0123456789ac",0x3a] = "SamrSetInformationUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x3b] = "SamrSetBootKeyInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x3c] = "SamrGetBootKeyInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x3d] = "SamrConnect3",
		["12345778-1234-abcd-ef00-0123456789ac",0x3e] = "SamrConnect4",
		["12345778-1234-abcd-ef00-0123456789ac",0x3f] = "SamrUnicodeChangePasswordUser3",
		["12345778-1234-abcd-ef00-0123456789ac",0x40] = "SamrConnect5",
		["12345778-1234-abcd-ef00-0123456789ac",0x41] = "SamrRidToSid",
		["12345778-1234-abcd-ef00-0123456789ac",0x42] = "SamrSetDSRMPassword",
		["12345778-1234-abcd-ef00-0123456789ac",0x43] = "SamrValidatePassword",
		["12345778-1234-abcd-ef00-0123456789ac",0x44] = "SamrQueryLocalizableAccountsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x45] = "SamrPerformGenericOperation",

		["338cd001-2244-31f1-aaaa-900038001003",0x00] = "OpenClassesRoot",
		["338cd001-2244-31f1-aaaa-900038001003",0x01] = "OpenCurrentUser",
		["338cd001-2244-31f1-aaaa-900038001003",0x02] = "OpenLocalMachine",
		["338cd001-2244-31f1-aaaa-900038001003",0x03] = "OpenPerformanceData",
		["338cd001-2244-31f1-aaaa-900038001003",0x04] = "OpenUsers",
		["338cd001-2244-31f1-aaaa-900038001003",0x05] = "BaseRegCloseKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x06] = "BaseRegCreateKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x07] = "BaseRegDeleteKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x08] = "BaseRegDeleteValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x09] = "BaseRegEnumKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0a] = "BaseRegEnumValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x0b] = "BaseRegFlushKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0c] = "BaseRegGetKeySecurity",
		["338cd001-2244-31f1-aaaa-900038001003",0x0d] = "BaseRegLoadKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0e] = "BaseRegNotifyChangeKeyValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x0f] = "BaseRegOpenKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x10] = "BaseRegQueryInfoKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x11] = "BaseRegQueryValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x12] = "BaseRegReplaceKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x13] = "BaseRegRestoreKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x14] = "BaseRegSaveKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x15] = "BaseRegSetKeySecurity",
		["338cd001-2244-31f1-aaaa-900038001003",0x16] = "BaseRegSetValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x17] = "BaseRegUnLoadKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x18] = "BaseInitiateSystemShutdown",
		["338cd001-2244-31f1-aaaa-900038001003",0x19] = "BaseAbortSystemShutdown",
		["338cd001-2244-31f1-aaaa-900038001003",0x1a] = "BaseRegGetVersion",
		["338cd001-2244-31f1-aaaa-900038001003",0x1b] = "OpenCurrentConfig",
		["338cd001-2244-31f1-aaaa-900038001003",0x1c] = "OpenDynData",
		["338cd001-2244-31f1-aaaa-900038001003",0x1d] = "BaseRegQueryMultipleValues",
		["338cd001-2244-31f1-aaaa-900038001003",0x1e] = "BaseInitiateSystemShutdownEx",
		["338cd001-2244-31f1-aaaa-900038001003",0x1f] = "BaseRegSaveKeyEx",
		["338cd001-2244-31f1-aaaa-900038001003",0x20] = "OpenPerformanceText",
		["338cd001-2244-31f1-aaaa-900038001003",0x21] = "OpenPerformanceNlsText",
		["338cd001-2244-31f1-aaaa-900038001003",0x22] = "BaseRegQueryMultipleValues2",
		["338cd001-2244-31f1-aaaa-900038001003",0x23] = "BaseRegDeleteKeyEx",

		# dssetup
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x00] = "DsRolerGetPrimaryDomainInformation",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x01] = "DsRolerDnsNameToFlatName",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x02] = "DsRolerDcAsDc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x03] = "DsRolerDcAsReplica",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x04] = "DsRolerDemoteDc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x05] = "DsRolerGetDcOperationProgress",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x06] = "DsRolerGetDcOperationResults",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x07] = "DsRolerCancel",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x08] = "DsRolerServerSaveStateForUpgrade",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x09] = "DsRolerUpgradeDownlevelServer",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x0a] = "DsRolerAbortDownlevelServerUpgrade",

		# svcctl
		["367abb81-9844-35f1-ad32-98f038001003",0x00] = "CloseServiceHandle",
		["367abb81-9844-35f1-ad32-98f038001003",0x01] = "ControlService",
		["367abb81-9844-35f1-ad32-98f038001003",0x02] = "DeleteService",
		["367abb81-9844-35f1-ad32-98f038001003",0x03] = "LockServiceDatabase",
		["367abb81-9844-35f1-ad32-98f038001003",0x04] = "QueryServiceObjectSecurity",
		["367abb81-9844-35f1-ad32-98f038001003",0x05] = "SetServiceObjectSecurity",
		["367abb81-9844-35f1-ad32-98f038001003",0x06] = "QueryServiceStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x07] = "SetServiceStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x08] = "UnlockServiceDatabase",
		["367abb81-9844-35f1-ad32-98f038001003",0x09] = "NotifyBootConfigStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x0a] = "ScSetServiceBitsW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0b] = "ChangeServiceConfigW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0c] = "CreateServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0d] = "EnumDependentServicesW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0e] = "EnumServicesStatusW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0f] = "OpenSCManagerW",
		["367abb81-9844-35f1-ad32-98f038001003",0x10] = "OpenServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x11] = "QueryServiceConfigW",
		["367abb81-9844-35f1-ad32-98f038001003",0x12] = "QueryServiceLockStatusW",
		["367abb81-9844-35f1-ad32-98f038001003",0x13] = "StartServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x14] = "GetServiceDisplayNameW",
		["367abb81-9844-35f1-ad32-98f038001003",0x15] = "GetServiceKeyNameW",
		["367abb81-9844-35f1-ad32-98f038001003",0x16] = "ScSetServiceBitsA",
		["367abb81-9844-35f1-ad32-98f038001003",0x17] = "ChangeServiceConfigA",
		["367abb81-9844-35f1-ad32-98f038001003",0x18] = "CreateServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x19] = "EnumDependentServicesA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1a] = "EnumServicesStatusA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1b] = "OpenSCManagerA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1c] = "OpenServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1d] = "QueryServiceConfigA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1e] = "QueryServiceLockStatusA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1f] = "StartServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x20] = "GetServiceDisplayNameA",
		["367abb81-9844-35f1-ad32-98f038001003",0x21] = "GetServiceKeyNameA",
		["367abb81-9844-35f1-ad32-98f038001003",0x22] = "ScGetCurrentGroupStateW",
		["367abb81-9844-35f1-ad32-98f038001003",0x23] = "EnumServiceGroupW",
		["367abb81-9844-35f1-ad32-98f038001003",0x24] = "ChangeServiceConfig2A",
		["367abb81-9844-35f1-ad32-98f038001003",0x25] = "ChangeServiceConfig2W",
		["367abb81-9844-35f1-ad32-98f038001003",0x26] = "QueryServiceConfig2A",
		["367abb81-9844-35f1-ad32-98f038001003",0x27] = "QueryServiceConfig2W",
		["367abb81-9844-35f1-ad32-98f038001003",0x28] = "QueryServiceStatusEx",
		["367abb81-9844-35f1-ad32-98f038001003",0x29] = "EnumServicesStatusExA",
		["367abb81-9844-35f1-ad32-98f038001003",0x2a] = "EnumServicesStatusExW",
		["367abb81-9844-35f1-ad32-98f038001003",0x2b] = "ScSendTSMessage",
		["367abb81-9844-35f1-ad32-98f038001003",0x2c] = "CreateServiceWOW64A",
		["367abb81-9844-35f1-ad32-98f038001003",0x2d] = "CreateServiceWOW64W",
		["367abb81-9844-35f1-ad32-98f038001003",0x2e] = "ScQueryServiceTagInfo",
		["367abb81-9844-35f1-ad32-98f038001003",0x2f] = "NotifyServiceStatusChange",
		["367abb81-9844-35f1-ad32-98f038001003",0x30] = "GetNotifyResult",
		["367abb81-9844-35f1-ad32-98f038001003",0x31] = "CloseNotifyHandle",
		["367abb81-9844-35f1-ad32-98f038001003",0x32] = "ControlServiceExA",
		["367abb81-9844-35f1-ad32-98f038001003",0x33] = "ControlServiceExW",
		["367abb81-9844-35f1-ad32-98f038001003",0x34] = "ScSendPnPMessage",
		["367abb81-9844-35f1-ad32-98f038001003",0x35] = "ScValidatePnPService",
		["367abb81-9844-35f1-ad32-98f038001003",0x36] = "ScOpenServiceStatusHandle",

		# browser
		["6bffd098-a112-3610-9833-012892020162",0x00] = "BrowserrServerEnum",
		["6bffd098-a112-3610-9833-012892020162",0x01] = "BrowserrDebugCall",
		["6bffd098-a112-3610-9833-012892020162",0x02] = "BrowserrQueryOtherDomains",
		["6bffd098-a112-3610-9833-012892020162",0x03] = "BrowserrResetNetlogonState",
		["6bffd098-a112-3610-9833-012892020162",0x04] = "BrowserrDebugTrace",
		["6bffd098-a112-3610-9833-012892020162",0x05] = "BrowserrQueryStatistics",
		["6bffd098-a112-3610-9833-012892020162",0x06] = "BrowserrResetStatistics",
		["6bffd098-a112-3610-9833-012892020162",0x07] = "NetrBrowserStatisticsClear",
		["6bffd098-a112-3610-9833-012892020162",0x08] = "NetrBrowserStatisticsGet",
		["6bffd098-a112-3610-9833-012892020162",0x09] = "BrowserrSetNetlogonState",
		["6bffd098-a112-3610-9833-012892020162",0x0a] = "BrowserrQueryEmulatedDomains",
		["6bffd098-a112-3610-9833-012892020162",0x0b] = "BrowserrServerEnumEx",

		# AudioSrv
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x00] = "gfxCreateZoneFactoriesList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x01] = "gfxCreateGfxFactoriesList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x02] = "gfxCreateGfxList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x03] = "gfxRemoveGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x04] = "gfxAddGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x05] = "gfxModifyGx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x06] = "gfxOpenGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x07] = "gfxLogon",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x08] = "gfxLogoff",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x09] = "winmmRegisterSessionNotificationEvent",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0a] = "winmmUnregisterSessionNotification",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0b] = "winmmSessionConnectState",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0c] = "wdmDriverOpenDrvRegKey",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0d] = "winmmAdvisePreferredDeviceChange",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0e] = "winmmGetPnpInfo",

		# AudioRpc
		["c386ca3e-9061-4a72-821e-498d83be188f",0x00] = "AudioServerConnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x01] = "AudioServerDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x02] = "AudioServerInitialize",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x03] = "AudioServerGetAudioSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x04] = "AudioServerCreateStream",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x05] = "AudioServerDestroyStream",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x06] = "AudioServerGetStreamLatency",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x07] = "AudioServerGetMixFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x08] = "AudioServerIsFormatSupported",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x09] = "AudioServerGetDevicePeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0a] = "AudioVolumeGetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0b] = "AudioSessionGetProcessId",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0c] = "AudioSessionGetState",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0d] = "AudioSessionGetLastActivation",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0e] = "AudioSessionGetLastInactivation",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0f] = "AudioSessionIsSystemSoundsSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x10] = "AudioSessionGetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x11] = "AudioSessionSetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x12] = "AudioSessionGetSessionClass",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x13] = "AudioSessionSetSessionClass",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x14] = "AudioSessionGetVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x15] = "AudioSessionSetVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x16] = "AudioSessionGetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x17] = "AudioSessionSetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x18] = "AudioSessionGetChannelCount",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x19] = "AudioSessionSetChannelVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1a] = "AudioSessionGetChannelVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1b] = "AudioSessionSetAllVolumes",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1c] = "AudioSessionGetAllVolumes",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1d] = "AudioServerDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1e] = "AudioServerGetMixFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1f] = "PolicyConfigGetDeviceFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x20] = "PolicyConfigSetDeviceFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x21] = "AudioServerGetDevicePeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x22] = "PolicyConfigSetProcessingPeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x23] = "PolicyConfigGetShareMode",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x24] = "PolicyConfigSetShareMode",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x25] = "GetAudioSessionManager",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x26] = "AudioSessionManagerDestroy",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x27] = "AudioSessionManagerGetAudioSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x28] = "AudioSessionManagerGetCurrentSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x29] = "AudioSessionManagerGetExistingSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2a] = "AudioSessionManagerAddAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2b] = "AudioSessionManagerDeleteAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2c] = "AudioSessionManagerAddAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2d] = "AudioVolumeConnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2e] = "AudioVolumeDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2f] = "AudioVolumeGetChannelCount",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x30] = "AudioVolumeSetMasterVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x31] = "AudioVolumeSetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x32] = "AudioVolumeGetMasterVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x33] = "AudioVolumeGetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x34] = "AudioVolumeSetChannelVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x35] = "AudioVolumeSetChannelVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x36] = "AudioVolumeGetChannelVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x37] = "AudioVolumeGetChannelVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x38] = "AudioVolumeSetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x39] = "AudioSessionGetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3a] = "AudioVolumeAddMasterVolumeNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3b] = "AudioVolumeDeleteMasterVolumeNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3c] = "AudioMeterGetAverageRMS",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3d] = "AudioMeterGetChannelsRMS",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3e] = "AudioMeterGetPeakValue",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3f] = "AudioMeterGetChannelsPeakValues",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x40] = "AudioVolumeGetStepInfo",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x41] = "AudioVolumeStepUp",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x42] = "AudioVolumeStepDown",

		# dhcpcsvc6
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x00] = "RpcSrvRequestPrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x01] = "RpcSrvRenewPrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x02] = "RpcSrvReleasePrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x03] = "RpcSrvRequestParams",

		# RpcSrvDHCPC
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x00] = "RpcSrvEnableDhcp",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x01] = "RpcSrvRenewLease",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x02] = "RpcSrvRenewLeaseByBroadcast",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x03] = "RpcSrvReleaseLease",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x04] = "RpcSrvSetFallbackParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x05] = "RpcSrvGetFallbackParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x06] = "RpcSrvFallbackRefreshParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x07] = "RpcSrvStaticRefreshParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x08] = "RpcSrvRemoveDnsRegistrations",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x09] = "RpcSrvRequestParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0a] = "RpcSrvPersistentRequestParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0b] = "RpcSrvRegisterParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0c] = "RpcSrvDeRegisterParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0d] = "RpcSrvEnumInterfaces",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0e] = "RpcSrvQueryLeaseInfo",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0f] = "RpcSrvSetClassId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x10] = "RpcSrvGetClassId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x11] = "RpcSrvSetClientId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x12] = "RpcSrvGetClientId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x13] = "RpcSrvNotifyMediaReconnected",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x14] = "RpcSrvGetOriginalSubnetMask",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x15] = "RpcSrvSetMSFTVendorSpecificOptions",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x16] = "RpcSrvRequestCachedParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x17] = "RpcSrvRegisterConnectionStateNotification",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x18] = "RpcSrvDeRegisterConnectionStateNotification",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x19] = "RpcSrvGetNotificationStatus",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x1a] = "RpcSrvGetDhcpServicedConnections",

		# lcrpc
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x00] = "RpcLicensingOpenServer",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x01] = "RpcLicensingCloseServer",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x02] = "RpcLicensingLoadPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x03] = "RpcLicensingUnloadPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x04] = "RpcLicensingSetPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x05] = "RpcLicensingGetAvailablePolicyIds",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x06] = "RpcLicensingGetPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x07] = "RpcLicensingGetPolicyInformation",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x08] = "RpcLicensingDeactivateCurrentPolicy",

		# winstation_rpc
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x00] = "RpcWinStationOpenServer",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x01] = "RpcWinStationCloseServer",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x02] = "RpcIcaServerPing",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x03] = "RpcWinStationEnumerate",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x04] = "RpcWinStationRename",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x05] = "RpcWinStationQueryInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x06] = "RpcWinStationSetInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x07] = "RpcWinStationSendMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x08] = "RpcLogonIdFromWinStationName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x09] = "RpcWinStationNameFromLogonId",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0a] = "RpcWinStationConnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0b] = "RpcWinStationVirtualOpen",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0c] = "RpcWinStationBeepOpen",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0d] = "RpcWinStationDisconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0e] = "RpcWinStationReset",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0f] = "RpcWinStationShutdownSystem",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x10] = "RpcWinStationWaitSystemEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x11] = "RpcWinStationShadow",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x12] = "RpcWinStationShadowTargetSetup",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x13] = "RpcWinStationShadowTarget",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x14] = "RpcWinStationGenerateLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x15] = "RpcWinStationInstallLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x16] = "RpcWinStationEnumerateLicenses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x17] = "RpcWinStationActivateLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x18] = "RpcWinStationRemoveLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x19] = "RpcWinStationQueryLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1a] = "RpcWinStationSetPoolCount",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1b] = "RpcWinStationQueryUpdateRequired",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1c] = "RpcWinStationCallback",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1d] = "RpcWinStationGetApplicationInfo",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1e] = "RpcWinStationReadRegistry",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1f] = "RpcWinStationWaitForConnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x20] = "RpcWinStationNotifyLogon",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x21] = "RpcWinStationNotifyLogoff",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x22] = "RpcWinStationEnumerateProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x23] = "RpcWinStationAnnoyancePopup",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x24] = "RpcWinStationEnumerateProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x25] = "RpcWinStationTerminateProcess",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x26] = "RpcServerNWLogonSetAdmin",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x27] = "RpcServerNWLogonQueryAdmin",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x28] = "RpcWinStationNtsdDebug",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x29] = "RpcWinStationBreakPoint",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2a] = "RpcWinStationCheckForApplicationName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2b] = "RpcWinStationGetAllProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2c] = "RpcWinStationGetProcessSid",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2d] = "RpcWinStationGetTermSrvCountersValue",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2e] = "RpcWinStationReInitializeSecurity",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2f] = "RpcWinStationBroadcastSystemMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x30] = "RpcWinStationSendWindowMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x31] = "RpcWinStationNotifyNewSession",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x32] = "RpcServerGetInternetConnectorStatus",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x33] = "RpcServerSetInternetConnectorStatus",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x34] = "RpcServerQueryInetConnectorInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x35] = "RpcWinStationGetLanAdapterName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x36] = "RpcWinStationUpdateUserConfig",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x37] = "RpcWinStationQueryLogonCredentials",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x38] = "RpcWinStationRegisterConsoleNotification",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x39] = "RpcWinStationUnRegisterConsoleNotification",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3a] = "RpcWinStationUpdateSettings",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3b] = "RpcWinStationShadowStop",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3c] = "RpcWinStationCloseServerEx",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3d] = "RpcWinStationIsHelpAssistantSession",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3e] = "RpcWinStationGetMachinePolicy",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3f] = "RpcWinStationUpdateClientCachedCredentials",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x40] = "RpcWinStationFUSCanRemoteUserDisconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x41] = "RpcWinStationCheckLoopBack",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x42] = "RpcConnectCallback",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x43] = "RpcWinStationNotifyDisconnectPipe",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x44] = "RpcWinStationSessionInitialized",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x45] = "RpcRemoteAssistancePrepareSystemRestore",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x46] = "RpcWinStationGetAllProcesses_NT6",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x47] = "RpcWinStationRegisterNotificationEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x48] = "RpcWinStationUnRegisterNotificationEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x49] = "RpcWinStationAutoReconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x4a] = "RpcWinStationCheckAccess",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x4b] = "RpcWinStationOpenSessionDirectory",

		# NsiS
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3",0x00] = "nsi_binding_export",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3",0x01] = "nsi_binding_unexport",

		# NsiC
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x00] = "nsi_binding_lookup_begin",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x01] = "nsi_binding_lookup_done",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x02] = "nsi_binding_lookup_next",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x03] = "nsi_mgmt_handle_set_exp_age",

		# NsiM
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x00] = "nsi_group_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x01] = "nsi_group_mbr_add",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x02] = "nsi_group_mbr_remove",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x03] = "nsi_group_mbr_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x04] = "nsi_group_mbr_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x05] = "nsi_group_mbr_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x06] = "nsi_profile_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x07] = "nsi_profile_elt_add",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x08] = "nsi_profile_elt_remove",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x09] = "nsi_profile_elt_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0a] = "nsi_profile_elt_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0b] = "nsi_profile_elt_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0c] = "nsi_entry_object_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0d] = "nsi_entry_object_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0e] = "nsi_entry_object_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0f] = "nsi_entry_expand_name",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x10] = "nsi_mgmt_binding_unexport",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x11] = "nsi_mgmt_entry_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x12] = "nsi_mgmt_entry_create",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x13] = "nsi_mgmt_entry_inq_if_ids",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x14] = "nsi_mgmt_inq_exp_age",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x15] = "nsi_mgmt_inq_set_age",

		# eventlog
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x00] = "ElfrClearELFW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x01] = "ElfrBackupELFW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x02] = "ElfrCloseEL",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x03] = "ElfrDeregisterEventSource",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x04] = "ElfrNumberOfRecords",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x05] = "ElfrOldestRecord",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x06] = "ElfrChangeNotify",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x07] = "ElfrOpenELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x08] = "ElfrRegisterEventSourceW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x09] = "ElfrOpenBELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0a] = "ElfrReadELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0b] = "ElfrReportEventW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0c] = "ElfrClearELFA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0d] = "ElfrBackupELFA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0e] = "ElfrOpenELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0f] = "ElfrRegisterEventSourceA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x10] = "ElfrOpenBELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x11] = "ElfrReadELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x12] = "ElfrReportEventA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x13] = "ElfrRegisterClusterSvc",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x14] = "ElfrDeregisterClusterSvc",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x15] = "ElfrWriteClusterEvents",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x16] = "ElfrGetLogInformation",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x17] = "ElfrFlushEL",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x18] = "ElfrReportEventAndSourceW",

		# ISeclogon
		["12b81e99-f207-4a4c-85d3-77b42f76fd14",0x00] = "SeclCreateProcessWithLogonW",
		["12b81e99-f207-4a4c-85d3-77b42f76fd14",0x01] = "SeclCreateProcessWithLogonExW",

		# IKeySvc
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x00] = "KeyrOpenKeyService",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x01] = "KeyrEnumerateProviders",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x02] = "KeyrEnumerateProviderTypes",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x03] = "KeyrEnumerateProvContainers",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x04] = "KeyrCloseKeyService",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x05] = "KeyrGetDefaultProvider",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x06] = "KeyrSetDefaultProvider",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x07] = "KeyrEnroll",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x08] = "KeyrExportCert",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x09] = "KeyrImportCert",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0a] = "KeyrEnumerateAvailableCertTypes",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0b] = "KeyrEnumerateCAs",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0c] = "KeyrEnroll_V2",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0d] = "KeyrQueryRequestStatus",

		# IKeySvc2
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x00] = "KSrSubmitRequest",
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x01] = "KSrGetTemplates",
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x02] = "KSrGetCAs",

		# ICertProtect
		["0d72a7d4-6148-11d1-b4aa-00c04fb66ea0",0x00] = "SSCertProtectFunction",

		# ICatDBSvc
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x00] = "SSCatDBAddCatalog",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x01] = "SSCatDBDeleteCatalog",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x02] = "SSCatDBEnumCatalogs",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x03] = "SSCatDBRegisterForChangeNotification",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x04] = "KeyrCloseKeyService",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x05] = "SSCatDBRebuildDatabase",

		# lsarpc
		["12345778-1234-abcd-ef00-0123456789ab",0x00] = "LsarClose",
		["12345778-1234-abcd-ef00-0123456789ab",0x01] = "LsarDelete",
		["12345778-1234-abcd-ef00-0123456789ab",0x02] = "LsarEnumeratePrivileges",
		["12345778-1234-abcd-ef00-0123456789ab",0x03] = "LsarQuerySecurityObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x04] = "LsarSetSecurityObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x05] = "LsarChangePassword",
		["12345778-1234-abcd-ef00-0123456789ab",0x06] = "LsarOpenPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x07] = "LsarQueryInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x08] = "LsarSetInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x09] = "LsarClearAuditLog",
		["12345778-1234-abcd-ef00-0123456789ab",0x0a] = "LsarCreateAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x0b] = "LsarEnumerateAccounts",
		["12345778-1234-abcd-ef00-0123456789ab",0x0c] = "LsarCreateTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x0d] = "LsarEnumerateTrustedDomains",
		["12345778-1234-abcd-ef00-0123456789ab",0x0e] = "LsarLookupNames",
		["12345778-1234-abcd-ef00-0123456789ab",0x0f] = "LsarLookupSids",
		["12345778-1234-abcd-ef00-0123456789ab",0x10] = "LsarCreateSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x11] = "LsarOpenAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x12] = "LsarEnumeratePrivilegesAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x13] = "LsarAddPrivilegesToAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x14] = "LsarRemovePrivilegesFromAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x15] = "LsarGetQuotasForAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x16] = "LsarSetQuotasForAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x17] = "LsarGetSystemAccessAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x18] = "LsarSetSystemAccessAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x19] = "LsarOpenTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1a] = "LsarQueryInfoTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1b] = "LsarSetInformationTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1c] = "LsarOpenSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1d] = "LsarSetSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1e] = "LsarQuerySecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1f] = "LsarLookupPrivilegeValue",
		["12345778-1234-abcd-ef00-0123456789ab",0x20] = "LsarLookupPrivilegeName",
		["12345778-1234-abcd-ef00-0123456789ab",0x21] = "LsarLookupPrivilegeDisplayName",
		["12345778-1234-abcd-ef00-0123456789ab",0x22] = "LsarDeleteObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x23] = "LsarEnumerateAccountsWithUserRight",
		["12345778-1234-abcd-ef00-0123456789ab",0x24] = "LsarEnumerateAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x25] = "LsarAddAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x26] = "LsarRemoveAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x27] = "LsarQueryTrustedDomainInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x28] = "LsarSetTrustedDomainInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x29] = "LsarDeleteTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x2a] = "LsarStorePrivateData",
		["12345778-1234-abcd-ef00-0123456789ab",0x2b] = "LsarRetrievePrivateData",
		["12345778-1234-abcd-ef00-0123456789ab",0x2c] = "LsarOpenPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x2d] = "LsarGetUserName",
		["12345778-1234-abcd-ef00-0123456789ab",0x2e] = "LsarQueryInformationPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x2f] = "LsarSetInformationPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x30] = "LsarQueryTrustedDomainInfoByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x31] = "LsarSetTrustedDomainInfoByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x32] = "LsarEnumerateTrustedDomainsEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x33] = "LsarCreateTrustedDomainEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x34] = "LsarCloseTrustedDomainEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x35] = "LsarQueryDomainInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x36] = "LsarSetDomainInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x37] = "LsarOpenTrustedDomainByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x38] = "LsarTestCall",
		["12345778-1234-abcd-ef00-0123456789ab",0x39] = "LsarLookupSids2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3a] = "LsarLookupNames2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3b] = "LsarCreateTrustedDomainEx2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3c] = "CredrWrite",
		["12345778-1234-abcd-ef00-0123456789ab",0x3d] = "CredrRead",
		["12345778-1234-abcd-ef00-0123456789ab",0x3e] = "CredrEnumerate",
		["12345778-1234-abcd-ef00-0123456789ab",0x3f] = "CredrWriteDomainCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x40] = "CredrReadDomainCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x41] = "CredrDelete",
		["12345778-1234-abcd-ef00-0123456789ab",0x42] = "CredrGetTargetInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x43] = "CredrProfileLoaded",
		["12345778-1234-abcd-ef00-0123456789ab",0x44] = "LsarLookupNames3",
		["12345778-1234-abcd-ef00-0123456789ab",0x45] = "CredrGetSessionTypes",
		["12345778-1234-abcd-ef00-0123456789ab",0x46] = "LsarRegisterAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x47] = "LsarGenAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x48] = "LsarUnregisterAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x49] = "LsarQueryForestTrustInformation",
		["12345778-1234-abcd-ef00-0123456789ab",0x4a] = "LsarSetForestTrustInformation",
		["12345778-1234-abcd-ef00-0123456789ab",0x4b] = "CredrRename",
		["12345778-1234-abcd-ef00-0123456789ab",0x4c] = "LsarLookupSids3",
		["12345778-1234-abcd-ef00-0123456789ab",0x4d] = "LsarLookupNames4",
		["12345778-1234-abcd-ef00-0123456789ab",0x4e] = "LsarOpenPolicySce",
		["12345778-1234-abcd-ef00-0123456789ab",0x4f] = "LsarAdtRegisterSecurityEventSource",
		["12345778-1234-abcd-ef00-0123456789ab",0x50] = "LsarAdtUnregisterSecurityEventSource",
		["12345778-1234-abcd-ef00-0123456789ab",0x51] = "LsarAdtReportSecurityEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x52] = "CredrFindBestCredential",
		["12345778-1234-abcd-ef00-0123456789ab",0x53] = "LsarSetAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x54] = "LsarQueryAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x55] = "LsarEnumerateAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x56] = "LsarEnumerateAuditCategories",
		["12345778-1234-abcd-ef00-0123456789ab",0x57] = "LsarEnumerateAuditSubCategories",
		["12345778-1234-abcd-ef00-0123456789ab",0x58] = "LsarLookupAuditCategoryName",
		["12345778-1234-abcd-ef00-0123456789ab",0x59] = "LsarLookupAuditSubCategoryName",
		["12345778-1234-abcd-ef00-0123456789ab",0x5a] = "LsarSetAuditSecurity",
		["12345778-1234-abcd-ef00-0123456789ab",0x5b] = "LsarQueryAuditSecurity",
		["12345778-1234-abcd-ef00-0123456789ab",0x5c] = "CredReadByTokenHandle",
		["12345778-1234-abcd-ef00-0123456789ab",0x5d] = "CredrRestoreCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x5e] = "CredrBackupCredentials",

		# msgsvc
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x00] = "NetrMessageNameAdd",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x01] = "NetrMessageNameEnum",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x02] = "NetrMessageNameGetInfo",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x03] = "NetrMessageNameDel",

		# msgsvcsend
		["5a7b91f8-ff00-11d0-a9b2-00c04fb6e6fc",0x00] = "NetrSendMessage",

		# pnp
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x00] = "PNP_Disconnect",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x01] = "PNP_Connect",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x02] = "PNP_GetVersion",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x03] = "PNP_GetGlobalState",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x04] = "PNP_InitDetection",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x05] = "PNP_ReportLogOn",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x06] = "PNP_ValidateDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x07] = "PNP_GetRootDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x08] = "PNP_GetRelatedDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x09] = "PNP_EnumerateSubKeys",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0a] = "PNP_GetDeviceList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0b] = "PNP_GetDeviceListSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0c] = "PNP_GetDepth",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0d] = "PNP_GetDeviceRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0e] = "PNP_SetDeviceRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0f] = "PNP_GetClassInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x10] = "PNP_CreateKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x11] = "PNP_DeleteRegistryKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x12] = "PNP_GetClassCount",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x13] = "PNP_GetClassName",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x14] = "PNP_DeleteClassKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x15] = "PNP_GetInterfaceDeviceAlias",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x16] = "PNP_GetInterfaceDeviceList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x17] = "PNP_GetInterfaceDeviceListSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x18] = "PNP_RegisterDeviceClassAssociation",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x19] = "PNP_UnregisterDeviceClassAssociation",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1a] = "PNP_GetClassRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1b] = "PNP_SetClassRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1c] = "PNP_CreateDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1d] = "PNP_DeviceInstanceAction",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1e] = "PNP_GetDeviceStatus",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1f] = "PNP_SetDeviceProblem",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x20] = "PNP_DisableDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x21] = "PNP_UninstallDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x22] = "PNP_AddID",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x23] = "PNP_RegisterDriver",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x24] = "PNP_QueryRemove",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x25] = "PNP_RequestDeviceEject",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x26] = "PNP_IsDockStationPresent",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x27] = "PNP_RequestEjectPC",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x28] = "PNP_HwProfFlags",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x29] = "PNP_GetHwProfInfo",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2a] = "PNP_AddEmptyLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2b] = "PNP_FreeLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2c] = "PNP_GetFirstLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2d] = "PNP_GetNextLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2e] = "PNP_GetLogConfPriority",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2f] = "PNP_AddResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x30] = "PNP_FreeResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x31] = "PNP_GetNextResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x32] = "PNP_GetResDesData",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x33] = "PNP_GetResDesDataSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x34] = "PNP_ModifyResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x35] = "PNP_DetectResourceConflict",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x36] = "PNP_QueryResConfList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x37] = "PNP_SetHwProf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x38] = "PNP_QueryArbitratorFreeData",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x39] = "PNP_QueryArbitratorFreeSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3a] = "PNP_RunDetection",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3b] = "PNP_RegisterNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3c] = "PNP_UnregisterNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3d] = "PNP_GetCustomDevProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3e] = "PNP_GetVersionInternal",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3f] = "PNP_GetBlockedDriverInfo",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x40] = "PNP_GetServerSideDeviceInstallFlags",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x41] = "PNP_GetObjectPropKeys",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x42] = "PNP_GetObjectProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x43] = "PNP_SetObjectProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x44] = "PNP_InstallDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x45] = "PNP_ApplyPowerSettings",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x46] = "PNP_DriverStoreAddDriverPackage",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x47] = "PNP_DriverStoreDeleteDriverPackage",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x48] = "PNP_RegisterServiceNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x49] = "PNP_SetActiveService",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x4a] = "PNP_DeleteServiceDevices",

		# DnsServer
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x00] = "DnssrvOperation",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x01] = "DnssrvQuery",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x02] = "DnssrvComplexOperation",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x03] = "DnssrvEnumRecords",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x04] = "DnssrvUpdateRecord",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x05] = "DnssrvOperation2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x06] = "DnssrvQuery2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x07] = "DnssrvComplexOperation2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x08] = "DnssrvEnumRecords2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x09] = "DnssrvUpdateRecord2",

		# lls_license
		["57674cd0-5200-11ce-a897-08002b2e9c6d",0x00] = "LlsrLicenseRequestW",
		["57674cd0-5200-11ce-a897-08002b2e9c6d",0x01] = "LlsrLicenseFree",

		# llsrpc
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x00] = "LlsrConnect",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x01] = "LlsrClose",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x02] = "LlsrLicenseEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x03] = "LlsrLicenseEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x04] = "LlsrLicenseAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x05] = "LlsrLicenseAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x06] = "LlsrProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x07] = "LlsrProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x08] = "LlsrProductAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x09] = "LlsrProductAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0a] = "LlsrProductUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0b] = "LlsrProductUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0c] = "LlsrProductServerEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0d] = "LlsrProductServerEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0e] = "LlsrProductLicenseEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0f] = "LlsrProductLicenseEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x10] = "LlsrUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x11] = "LlsrUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x12] = "LlsrUserInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x13] = "LlsrUserInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x14] = "LlsrUserInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x15] = "LlsrUserInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x16] = "LlsrUserDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x17] = "LlsrUserDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x18] = "LlsrUserProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x19] = "LlsrUserProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1a] = "LlsrUserProductDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1b] = "LlsrUserProductDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1c] = "LlsrMappingEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1d] = "LlsrMappingEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1e] = "LlsrMappingInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1f] = "LlsrMappingInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x20] = "LlsrMappingInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x21] = "LlsrMappingInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x22] = "LlsrMappingUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x23] = "LlsrMappingUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x24] = "LlsrMappingUserAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x25] = "LlsrMappingUserAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x26] = "LlsrMappingUserDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x27] = "LlsrMappingUserDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x28] = "LlsrMappingAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x29] = "LlsrMappingAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2a] = "LlsrMappingDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2b] = "LlsrMappingDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2c] = "LlsrServerEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2d] = "LlsrServerEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2e] = "LlsrServerProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2f] = "LlsrServerProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x30] = "LlsrLocalProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x31] = "LlsrLocalProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x32] = "LlsrLocalProductInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x33] = "LlsrLocalProductInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x34] = "LlsrLocalProductInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x35] = "LlsrLocalProductInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x36] = "LlsrServiceInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x37] = "LlsrServiceInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x38] = "LlsrServiceInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x39] = "LlsrServiceInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3a] = "LlsrReplConnect",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3b] = "LlsrReplClose",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3c] = "LlsrReplicationRequestW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3d] = "LlsrReplicationServerAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3e] = "LlsrReplicationServerServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3f] = "LlsrReplicationServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x40] = "LlsrReplicationUserAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x41] = "LlsrProductSecurityGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x42] = "LlsrProductSecurityGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x43] = "LlsrProductSecuritySetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x44] = "LlsrProductSecuritySetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x45] = "LlsrProductLicensesGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x46] = "LlsrProductLicensesGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x47] = "LlsrCertificateClaimEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x48] = "LlsrCertificateClaimEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x49] = "LlsrCertificateClaimAddCheckA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4a] = "LlsrCertificateClaimAddCheckW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4b] = "LlsrCertificateClaimAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4c] = "LlsrCertificateClaimAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4d] = "LlsrReplicationCertDbAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4e] = "LlsrReplicationProductSecurityAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4f] = "LlsrReplicationUserAddExW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x50] = "LlsrCapabilityGet",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x51] = "LlsrLocalServiceEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x52] = "LlsrLocalServiceEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x53] = "LlsrLocalServiceAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x54] = "LlsrLocalServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x55] = "LlsrLocalServiceInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x56] = "LlsrLocalServiceInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x57] = "LlsrLocalServiceInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x58] = "LlsrLocalServiceInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x59] = "LlsrCloseEx",

		# ICertPassage
		["91ae6020-9e3c-11cf-8d7c-00aa00c091be",0x00] = "CertServerRequest",

		# netdfs
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x00] = "NetrDfsManagerGetVersion",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x01] = "NetrDfsAdd",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x02] = "NetrDfsRemove",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x03] = "NetrDfsSetInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x04] = "NetrDfsGetInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x05] = "NetrDfsEnum",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x06] = "NetrDfsRename",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x07] = "NetrDfsMove",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x08] = "NetrDfsManagerGetConfigInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x09] = "NetrDfsManagerSendSiteInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0a] = "NetrDfsAddFtRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0b] = "NetrDfsRemoveFtRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0c] = "NetrDfsAddStdRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0d] = "NetrDfsRemoveStdRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0e] = "NetrDfsManagerInitialize",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0f] = "NetrDfsAddStdRootForced",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x10] = "NetrDfsGetDcAddress",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x11] = "NetrDfsSetDcAddress",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x12] = "NetrDfsFlushFtTable",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x13] = "NetrDfsAdd2",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x14] = "NetrDfsRemove2",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x15] = "NetrDfsEnumEx",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x16] = "NetrDfsSetInfo2",

		# sfcapi
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x00] = "SfcSrv_GetNextProtectedFile",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x01] = "SfcSrv_IsFileProtected",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x02] = "SfcSrv_FileException",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x03] = "SfcSrv_InitiateScan",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x04] = "SfcSrv_PurgeCache",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x05] = "SfcSrv_SetCacheSize",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x06] = "SfcSrv_SetDisable",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x07] = "SfcSrv_InstallProtectedFiles",

		# nddeapi
		["2f5f3220-c126-1076-b549-074d078619da",0x00] = "NDdeShareAddW",
		["2f5f3220-c126-1076-b549-074d078619da",0x01] = "NDdeShareDelA",
		["2f5f3220-c126-1076-b549-074d078619da",0x02] = "NDdeShareDelW",
		["2f5f3220-c126-1076-b549-074d078619da",0x03] = "NDdeGetShareSecurityA",
		["2f5f3220-c126-1076-b549-074d078619da",0x04] = "NDdeGetShareSecurityW",
		["2f5f3220-c126-1076-b549-074d078619da",0x05] = "NDdeSetShareSecurityA",
		["2f5f3220-c126-1076-b549-074d078619da",0x06] = "NDdeSetShareSecurityW",
		["2f5f3220-c126-1076-b549-074d078619da",0x07] = "NDdeShareEnumA",
		["2f5f3220-c126-1076-b549-074d078619da",0x08] = "NDdeShareEnumW",
		["2f5f3220-c126-1076-b549-074d078619da",0x09] = "NDdeShareGetInfoW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0a] = "NDdeShareSetInfoW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0b] = "NDdeSetTrustedShareA",
		["2f5f3220-c126-1076-b549-074d078619da",0x0c] = "NDdeSetTrustedShareW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0d] = "NDdeGetTrustedShareA",
		["2f5f3220-c126-1076-b549-074d078619da",0x0e] = "NDdeGetTrustedShareW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0f] = "NDdeTrustedShareEnumA",
		["2f5f3220-c126-1076-b549-074d078619da",0x10] = "NDdeTrustedShareEnumW",
		["2f5f3220-c126-1076-b549-074d078619da",0x12] = "NDdeSpecialCommand",

		# BackupKey
		["3dde7c30-165d-11d1-ab8f-00805f14db40",0x00] = "bkrp_BackupKey",

		# wkssvc
		["6bffd098-a112-3610-9833-46c3f87e345a",0x00] = "NetrWkstaGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x01] = "NetrWkstaSetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x02] = "NetrWkstaUserEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x03] = "NetrWkstaUserGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x04] = "NetrWkstaUserSetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x05] = "NetrWkstaTransportEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x06] = "NetrWkstaTransportAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x07] = "NetrWkstaTransportDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x08] = "NetrUseAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x09] = "NetrUseGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0a] = "NetrUseDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0b] = "NetrUseEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0c] = "NetrMessageBufferSend",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0d] = "NetrWorkstationStatisticsGet",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0e] = "NetrLogonDomainNameAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0f] = "NetrLogonDomainNameDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x10] = "NetrJoinDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x11] = "NetrUnjoinDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x12] = "NetrValidateName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x13] = "NetrRenameMachineInDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x14] = "NetrGetJoinInformation",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x15] = "NetrGetJoinableOUs",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x16] = "NetrJoinDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x17] = "NetrUnjoinDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x18] = "NetrRenameMachineInDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x19] = "NetrValidateName2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1a] = "NetrGetJoinableOUs2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1b] = "NetrAddAlternateComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1c] = "NetrRemoveAlternateComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1d] = "NetrSetPrimaryComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1e] = "NetrEnumerateComputerNames",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1f] = "NetrWorkstationResetDfsCache",

		# epmp
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x00] = "ept_insert",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x01] = "ept_delete",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x02] = "ept_lookup",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x03] = "ept_map",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x04] = "ept_lookup_handle_free",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x05] = "ept_inq_object",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x06] = "ept_mgmt_delete",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x07] = "ept_map_auth",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x08] = "ept_map_auth_async",

		# exchange_mapi
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x00] = "EcDoConnect",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x01] = "EcDoDisconnect",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x02] = "EcDoRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x03] = "EcGetMoreRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x04] = "EcRRegisterPushNotification",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x05] = "EcRUnregisterPushNotification",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x06] = "EcDummyRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x07] = "EcRGetDCName",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x08] = "EcRNetGetDCName",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x09] = "EcDoRpcExt",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x0a] = "EcDoConnectEx",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x0b] = "EcDoRpcExt2",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x0c] = "EcUnknown0xC",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x0d] = "EcUnknown0xD",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x0e] = "EcDoAsyncConnectEx",

		# drsuapi
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x00] = "DRSBind",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x01] = "DRSUnbind",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x02] = "DRSReplicaSync",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x03] = "DRSGetNCChanges",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x04] = "DRSUpdateRefs",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x05] = "DRSReplicaAdd",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x06] = "DRSReplicaDel",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x07] = "DRSReplicaModify",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x08] = "DRSVerifyNames",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x09] = "DRSGetMemberships",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0a] = "DRSInterDomainMove",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0b] = "DRSGetNT4ChangeLog",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0c] = "DRSCrackNames",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0d] = "DRSWriteSPN",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0e] = "DRSRemoveDsServer",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0f] = "DRSRemoveDsDomain",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x10] = "DRSDomainControllerInfo",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x11] = "DRSAddEntry",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x12] = "DRSExecuteKCC",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x13] = "DRSGetReplInfo",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x14] = "DRSAddSidHistory",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x15] = "DRSGetMemberships2",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x16] = "DRSReplicaVerifyObjects",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x17] = "DRSGetObjectExistence",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x18] = "DRSQuerySitesByCost",

		# winspipe
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x00] = "R_WinsRecordAction",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x01] = "R_WinsStatus",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x02] = "R_WinsTrigger",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x03] = "R_WinsDoStaticInit",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x04] = "R_WinsDoScavenging",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x05] = "R_WinsGetDbRecs",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x06] = "R_WinsTerm",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x07] = "R_WinsBackup",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x08] = "R_WinsDelDbRecs",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x09] = "R_WinsPullRange",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0a] = "R_WinsSetPriorityClass",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0b] = "R_WinsResetCounters",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0c] = "R_WinsWorkerThdUpd",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0d] = "R_WinsGetNameAndAdd",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0e] = "R_WinsGetBrowserNames_Old",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0f] = "R_WinsDeleteWins",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x10] = "R_WinsSetFlags",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x11] = "R_WinsGetDbRecsByName",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x12] = "R_WinsStatusWHdl",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x13] = "R_WinsDoScavengingNew",

		# mgmt
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x00] = "inq_if_ids",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x01] = "inq_stats",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x02] = "is_server_listening",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x03] = "stop_server_listening",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x04] = "inq_princ_name",

		# authzr - MSDN Ref: Remote Authorization API Protocol [ms-raa]
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x00] = "AuthzrFreeContext",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x01] = "AuthzrInitializeContextFromSid",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x02] = "AuthrzInitializeCompoundContext",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x03] = "AuthrzAccessCheck",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x04] = "AuthrzGetInformationFromContext",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x05] = "AuthrzModifyClaims",
		["0b1c2170-5732-4e0e-8cd3-d9b16f3b84d7",0x06] = "AuthrzModifySids",

		# BitsPeerAuth - MSDN Ref: BITS Peer-Caching: Peer Authentication Protocol [ms-bpau]
		["e3d0d746-d2af-40fd-8a7a-0d7078bb7092",0x00] = "ExchangePublicKeys",

		# clusapi (v2) - MSDN Ref: Failover Cluster Mgmt API Protocol [ms-cmrp]
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x00] = "ApiOpenCluster",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x01] = "ApiCloseCluster",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x02] = "ApiSetClusterName",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x03] = "ApiGetClusterName",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x04] = "ApiGetClusterVersion",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x05] = "ApiGetQuorumResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x06] = "ApiSetQuorumResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x07] = "ApiCreateEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x08] = "ApiOpenResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x09] = "ApiCreateResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0A] = "ApiDeleteResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0B] = "ApiCloseResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0C] = "ApiGetResourceState",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0D] = "ApiSetResourceName",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0E] = "ApiGetResourceId",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x0F] = "ApiGetResourceType",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x10] = "ApiFailResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x11] = "ApiOnlineResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x12] = "ApiOfflineResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x13] = "ApiAddResourceDependency",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x14] = "ApiRemoveResourceDependency",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x15] = "ApiCanResourceBeDependent",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x16] = "ApiCreateResEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x17] = "ApiAddResourceNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x18] = "ApiRemoveResourceNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x19] = "ApiChangeResourceGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1A] = "ApiCreateResourceType",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1B] = "ApiDeleteResourceType",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1C] = "ApiGetRootKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1D] = "ApiCreateKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1E] = "ApiOpenKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x1F] = "ApiEnumKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x20] = "ApiSetValue",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x21] = "ApiDeleteValue",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x22] = "ApiQueryValue",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x23] = "ApiDeleteKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x24] = "ApiEnumValue",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x25] = "ApiCloseKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x26] = "ApiQueryInfoKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x27] = "ApiSetKeySecurity",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x28] = "ApiGetKeySecurity",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x29] = "ApiOpenGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2A] = "ApiCreateGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2B] = "ApiDeleteGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2C] = "ApiCloseGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2D] = "ApiGetGroupState",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2E] = "ApiSetGroupName",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x2F] = "ApiGetGroupId",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x30] = "ApiGetNodeId",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x31] = "ApiOnlineGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x32] = "ApiOfflineGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x33] = "ApiMoveGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x34] = "ApiMoveGroupToNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x35] = "ApiCreateGroupResourceEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x36] = "ApiSetGroupNodeList",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x37] = "ApiCreateNotify",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x38] = "ApiCloseNotify",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x39] = "ApiAddNotifyCluster",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3A] = "ApiAddNotifyNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3B] = "ApiAddNotifyGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3C] = "ApiAddNotifyResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3D] = "ApiAddNotifyKey",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3E] = "ApiReAddNotifyNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x3F] = "ApiReAddNotifyGroup",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x40] = "ApiReAddNotifyResource",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x41] = "ApiGetNotify",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x42] = "ApiOpenNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x43] = "ApiCloseNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x44] = "ApiGetNodeState",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x45] = "ApiPauseNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x46] = "ApiResumeNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x47] = "ApiEvictNode",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x48] = "ApiNodeResourceControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x49] = "ApiResourceControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4A] = "ApiNodeResourceTypeControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4B] = "ApiResourceTypeControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4C] = "ApiNodeGroupControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4D] = "ApiGroupControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4E] = "ApiNodeNodeControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x4F] = "ApiNodeControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x50] = "Opnum80NotUsedOnWire",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x51] = "ApiOpenNetwork",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x52] = "ApiCloseNetwork",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x53] = "ApiGetNetworkState",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x54] = "ApiSetNetworkName",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x55] = "ApiCreateNetworkEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x56] = "ApiGetNetworkId",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x57] = "ApiSetNetworkPriorityOrder",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x58] = "ApiNodeNetworkControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x59] = "ApiNetworkControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5A] = "ApiAddNotifyNetwork",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5B] = "ApiReAddNotifyNetwork",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5C] = "ApiOpenNetInterface",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5D] = "ApiCloseNetInterface",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5E] = "ApiGetNetInterfaceState",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x5F] = "ApiGetNetInterface",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x60] = "ApiGetNetInterfaceId",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x61] = "ApiNodeNetInterfaceControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x62] = "ApiNetInterfaceControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x63] = "ApiAddNotifyNetInterface",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x64] = "ApiReAddNotifyNetInterface",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x65] = "ApiCreateNodeEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x66] = "ApiGetClusterVersion2",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x67] = "ApiCreateResTypeEnum",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x68] = "ApiBackupClusterDatabase",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x69] = "ApiNodeClusterControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x6A] = "ApiClusterControl",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x6B] = "ApiUnblockGetNotifyCall",
		["b97db8b2-4c63-11cf-bff6-08002be23f2f",0x6C] = "ApiSetServiceAccountPassword",

		# dhcpsrv - MSDN Ref: DHCP Server Mgmt Protocol [ms-dhcpm]
		["6bffd098-a112-3610-9833-46c3f874532d",0x00] = "R_DhcpCreateSubnet",
		["6bffd098-a112-3610-9833-46c3f874532d",0x01] = "R_DhcpSetSubnetInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x02] = "R_DhcpGetSubnetInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x03] = "R_DhcpEnumSubnets",
		["6bffd098-a112-3610-9833-46c3f874532d",0x04] = "R_DhcpAddSubnetElement",
		["6bffd098-a112-3610-9833-46c3f874532d",0x05] = "R_DhcpEnumSubnetElements",
		["6bffd098-a112-3610-9833-46c3f874532d",0x06] = "R_DhcpRemoveSubnetElement",
		["6bffd098-a112-3610-9833-46c3f874532d",0x07] = "R_DhcpDeleteSubnet",
		["6bffd098-a112-3610-9833-46c3f874532d",0x08] = "R_DhcpCreateOption",
		["6bffd098-a112-3610-9833-46c3f874532d",0x09] = "R_DhcpSetOptionInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0A] = "R_DhcpGetOptionInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0B] = "R_DhcpRemoveOption",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0C] = "R_DhcpSetOptionValue",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0D] = "R_DhcpGetOptionValue",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0E] = "R_DhcpEnumOptionValues",
		["6bffd098-a112-3610-9833-46c3f874532d",0x0F] = "R_DhcpRemoveOptionValue",
		["6bffd098-a112-3610-9833-46c3f874532d",0x10] = "R_DhcpCreateClientInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x11] = "R_DhcpSetClientInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x12] = "R_DhcpGetClientInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x13] = "R_DhcpDeleteClientInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x14] = "R_DhcpEnumSubnetClients",
		["6bffd098-a112-3610-9833-46c3f874532d",0x15] = "R_DhcpGetClientOptions",
		["6bffd098-a112-3610-9833-46c3f874532d",0x16] = "R_DhcpGetMibInfo",
		["6bffd098-a112-3610-9833-46c3f874532d",0x17] = "R_DhcpEnumOptions",
		["6bffd098-a112-3610-9833-46c3f874532d",0x18] = "R_DhcpSetOptionValues",
		["6bffd098-a112-3610-9833-46c3f874532d",0x19] = "R_DhcpServerSetConfig",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1A] = "R_DhcpServerGetConfig",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1B] = "R_DhcpScanDatabase",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1C] = "R_DhcpGetVersion",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1D] = "R_DhcpAddSubnetElementV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1E] = "R_DhcpEnumSubnetElementsV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x1F] = "R_DhcpRemoveSubnetElementV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x20] = "R_DhcpCreateClientInfoV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x21] = "R_DhcpSetClientInfoV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x22] = "R_DhcpGetClientInfoV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x23] = "R_DhcpEnumSubnetClientsV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x24] = "R_DhcpSetSuperScopeV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x25] = "R_DhcpGetSuperScopeInfoV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x26] = "R_DhcpDeleteSuperScopeV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x27] = "R_DhcpServerSetConfigV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x28] = "R_DhcpServerGetConfigV4",
		["6bffd098-a112-3610-9833-46c3f874532d",0x29] = "R_DhcpServerSetConfigVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2A] = "R_DhcpServerGetConfigVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2B] = "R_DhcpGetMibInfoVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2C] = "R_DhcpCreateClientInfoVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2D] = "R_DhcpSetClientInfoVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2E] = "R_DhcpGetClientInfoVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x2F] = "R_DhcpEnumSubnetClientsVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x30] = "R_DhcpCreateSubnetVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x31] = "R_DhcpGetSubnetInfoVQ",
		["6bffd098-a112-3610-9833-46c3f874532d",0x32] = "R_DhcpSetSubnetInfoVQ",

		# dhcpsrv2 - MSDN Ref: DHCP Server Mgmt Protocol [ms-dhcpm]
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x00] = "R_DhcpEnumSubnetClientsV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x01] = "R_DhcpSetMScopeInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x02] = "R_DhcpGetMScopeInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x03] = "R_DhcpEnumMScopes",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x04] = "R_DhcpAddMScopeElement",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x05] = "R_DhcpEnumMScopeElements",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x06] = "R_DhcpRemoveMScopeElement",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x07] = "R_DhcpDeleteMScope",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x08] = "R_DhcpScanMDatabase",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x09] = "R_DhcpCreateMClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0A] = "R_DhcpSetMClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0B] = "R_DhcpGetMClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0C] = "R_DhcpDeleteMClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0D] = "R_DhcpEnumMScopeClients",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0E] = "R_DhcpCreateOptionV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x0F] = "R_DhcpSetOptionInfoV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x10] = "R_DhcpGetOptionInfoV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x11] = "R_DhcpEnumOptionsV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x12] = "R_DhcpRemoveOptionV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x13] = "R_DhcpSetOptionValueV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x14] = "R_DhcpSetOptionValuesV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x15] = "R_DhcpGetOptionValueV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x16] = "R_DhcpEnumOptionValuesV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x17] = "R_DhcpRemoveOptionValueV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x18] = "R_DhcpCreateClass",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x19] = "R_DhcpModifyClass",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1A] = "R_DhcpDeleteClass",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1B] = "R_DhcpGetClassInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1C] = "R_DhcpEnumClasses",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1D] = "R_DhcpGetAllOptions",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1E] = "R_DhcpGetAllOptionValues",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x1F] = "R_DhcpGetMCastMibInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x20] = "R_DhcpAuditLogSetParams",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x21] = "R_DhcpAuditLogGetParams",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x22] = "R_DhcpServerQueryAttribute",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x23] = "R_DhcpServerQueryAttributes",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x24] = "R_DhcpServerRedoAuthorization",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x25] = "R_DhcpAddSubnetElementV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x26] = "R_DhcpEnumSubnetElementsV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x27] = "R_DhcpRemoveSubnetElementV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x28] = "R_DhcpGetServerBindingInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x29] = "R_DhcpSetServerBindingInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2A] = "R_DhcpQueryDnsRegCredentials",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2B] = "R_DhcpSetDnsRegCredentials",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2C] = "R_DhcpBackupDatabase",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2D] = "R_DhcpRestoreDatabase",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2E] = "R_DhcpGetServerSpecificStrings",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x2F] = "R_DhcpCreateOptionV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x30] = "R_DhcpSetOptionInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x31] = "R_DhcpGetOptionInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x32] = "R_DhcpEnumOptionsV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x33] = "R_DhcpRemoveOptionV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x34] = "R_DhcpSetOptionValueV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x35] = "R_DhcpEnumOptionValuesV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x36] = "R_DhcpRemoveOptionValueV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x37] = "R_DhcpGetAllOptionsV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x38] = "R_DhcpGetAllOptionValuesV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x39] = "R_DhcpCreateSubnetV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3A] = "R_DhcpEnumSubnetsV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3B] = "R_DhcpAddSubnetElementV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3C] = "R_DhcpEnumSubnetElementsV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3D] = "R_DhcpRemoveSubnetElementV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3E] = "R_DhcpDeleteSubnetV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x3F] = "R_DhcpGetSubnetInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x40] = "R_DhcpEnumSubnetClientsV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x41] = "R_DhcpServerSetConfigV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x42] = "R_DhcpServerGetConfigV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x43] = "R_DhcpGetMibInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x45] = "R_DhcpGetServerBindingInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x46] = "R_DhcpSetServerBindingInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x47] = "R_DhcpSetClientInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x48] = "R_DhcpGetClientInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x49] = "R_DhcpDeleteClientInfoV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4A] = "R_DhcpCreateClassV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4B] = "R_DhcpModifyClassV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4C] = "R_DhcpDeleteClassV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4D] = "R_DhcpEnumClassesV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4E] = "R_DhcpGetOptionValueV6",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x4F] = "R_DhcpSetSubnetDelayOffer",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x50] = "R_DhcpGetSubnetDelayOffer",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x51] = "R_DhcpGetMibInfoV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x52] = "R_DhcpAddFilterV4",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x53] = "R_DhcpDeleteFilterV4",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x54] = "R_DhcpSetFilterV4",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x55] = "R_DhcpGetFilterV4",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x56] = "R_DhcpEnumFilterV4",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x57] = "R_DhcpSetDnsRegCredentialsV5",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x58] = "R_DhcpEnumSubnetClientsFilterStatusInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x59] = "R_DhcpV4FailoverCreateRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5A] = "R_DhcpV4FailoverSetRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5B] = "R_DhcpV4FailoverDeleteRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5C] = "R_DhcpV4FailoverGetRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5D] = "R_DhcpV4FailoverEnumRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5E] = "R_DhcpV4FailoverAddScopeToRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x5F] = "R_DhcpV4FailoverDeleteScopeFromRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x60] = "R_DhcpV4FailoverGetScopeRelationship",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x61] = "R_DhcpV4FailoverGetScopeStatistics",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x62] = "R_DhcpV4FailoverGetClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x63] = "R_DhcpV4FailoverGetSystemTime",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x64] = "R_DhcpV4FailoverTriggerAddrAllocation",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x65] = "R_DhcpV4SetOptionValue",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x66] = "R_DhcpV4SetOptionValues",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x67] = "R_DhcpV4GetOptionValue",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x68] = "R_DhcpV4RemoveOptionValue",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x69] = "R_DhcpV4GetAllOptionValues",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6A] = "R_DhcpV4QueryPolicyEnforcement",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6B] = "R_DhcpSetPolicyEnforcement",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6C] = "R_DhcpV4CreatePolicy",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6D] = "R_DhcpV4GetPolicy",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6E] = "R_DhcpV4SetPolicy",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x6F] = "R_DhcpV4DeletePolicy",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x70] = "R_DhcpV4EnumPolicies",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x71] = "R_DhcpV4AddPolicyRange",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x72] = "R_DhcpV4RemovePolicyRange",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x73] = "R_DhcpV4EnumSubnetClients",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x74] = "R_DhcpV6SetStatelessStoreParams",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x75] = "R_DhcpV6GetStatelessStoreParams",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x76] = "R_DhcpV6GetStatelessStatistics",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x77] = "R_DhcpV4EnumSubnetReservations",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x78] = "R_DhcpV4GetFreeIPAddress",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x79] = "R_DhcpV6GetFreeIPAddress",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7A] = "R_DhcpV4CreateClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7B] = "R_DhcpV4GetClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7C] = "R_DhcpV6CreateClientInfo",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7D] = "R_DhcpV4FailoverGetAddressStatus",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7E] = "R_DhcpV4CreatePolicyEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x7F] = "R_DhcpV4GetPolicyEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x80] = "R_DhcpV4SetPolicyEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x81] = "R_DhcpV4EnumPoliciesEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x82] = "R_DhcpV4EnumSubnetClientsEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x83] = "R_DhcpV4CreateClientInfoEx",
		["5b821720-f63b-11d0-aad2-00c04fc324db",0x84] = "R_DhcpV4GetClientInfoEx",

		# dsaop - MSDN Ref: Directory Replication Service (DRS) Remote Protocol [ms-drsr]
		["7c44d7d4-31d5-424c-bd5e-2b3e1f323d22",0x00] = "IDL_DSAPrepareScript",
		["7c44d7d4-31d5-424c-bd5e-2b3e1f323d22",0x01] = "IDL_DSAExecuteScript",

		# dscomm - MSDN Ref: Msg Queuing - Directory Service Protocol [ms-mqds]
		["77df7a80-f298-11d0-8358-00a024c480a8",0x00] = "S_DSCreateObject",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x01] = "S_DSDeleteObject",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x02] = "S_DSGetProps",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x03] = "S_DSSetProps",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x04] = "S_DSGetObjectSecurity",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x05] = "S_DSSetObjectSecurity",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x06] = "S_DSLookupBegin",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x07] = "S_DSLookupNext",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x08] = "S_DSLookupEnd",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x09] = "Opnum9NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0A] = "S_DSDeleteObjectGuid",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0B] = "S_DSGetPropsGuid",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0C] = "S_DSSetPropsGuid",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0D] = "S_DSGetObjectSecurityGuid",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0E] = "S_DSSetObjectSecurityGuid",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x0F] = "Opnum15NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x10] = "Opnum16NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x11] = "Opnum17NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x12] = "Opnum18NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x13] = "S_DSQMSetMachineProperties",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x14] = "S_DSCreateServersCache",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x15] = "S_DSQMGetObjectSecurity",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x16] = "S_DSValidateServer",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x17] = "S_DSCloseServerHandle",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x18] = "Opnum24NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x19] = "Opnum25NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x1A] = "Opnum26NotUsedOnWire",
		["77df7a80-f298-11d0-8358-00a024c480a8",0x1B] = "S_DSGetServerPort",

		# dscomm2 - MSDN Ref: Msg Queuing - Directory Service Protocol [ms-mqds]
		["708cca10-9569-11d1-b2a5-0060977d8118",0x00] = "S_DSGetComputerSites",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x01] = "S_DSGetPropsEx",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x02] = "S_DSGetPropsGuidEx",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x03] = "S_DSBeginDeleteNotification",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x04] = "S_DSNotifyDelete",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x05] = "S_DSEndDeleteNotification",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x06] = "S_DSIsServerGC",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x07] = "Opnum7NotUsedOnWire",
		["708cca10-9569-11d1-b2a5-0060977d8118",0x08] = "S_DSGetGCListInDomain",

		# efsrpc - MSDN Ref: Encrypting File System Remote Protocol [ms-efsr]
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x00] = "EfsRpcOpenFileRaw",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x01] = "EfsRpcReadFileRaw",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x02] = "EfsRpcWriteFileRaw",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x03] = "EfsRpcCloseRaw",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x04] = "EfsRpcEncryptFileSrv",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x05] = "EfsDecryptFileSrv",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x06] = "EfsRpcQueryUsersOnFile",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x07] = "EfsRpcQueryRecoveryAgents",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x08] = "EfsRpcRemoveUsersFromFile",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x09] = "EfsRpcAddUsersToFile",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0A] = "Opnum10NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0B] = "EfsRpcNotSupported",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0C] = "EfsRpcFileKeyInfo",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0D] = "EfsRpcDuplicateEncryptionInfoFile",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0E] = "Opnum14NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x0F] = "EfsRpcAddUsersToFileEx",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x10] = "EfsRpcFileKeyInfoEx",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x11] = "Opnum17NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x12] = "EfsRpcGetEncryptedFileMetadata",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x13] = "EfsRpcSetEncryptedFileMetadata",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x14] = "EfsRpcFlushEfsCache",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x15] = "EfsRpcEncryptFileExServ",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x16] = "EfsRpcQueryProtectors",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x17] = "Opnum23NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x18] = "Opnum24NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x19] = "Opnum25NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1A] = "Opnum26NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1B] = "Opnum27NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1C] = "Opnum28NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1D] = "Opnum29NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1E] = "Opnum30NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x1F] = "Opnum31NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x20] = "Opnum32NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x21] = "Opnum33NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x22] = "Opnum34NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x23] = "Opnum35NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x24] = "Opnum36NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x25] = "Opnum37NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x26] = "Opnum38NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x27] = "Opnum39NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x28] = "Opnum40NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x29] = "Opnum41NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x2A] = "Opnum42NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x2B] = "Opnum43NotUsedOnWire",
		["df1941c5-fe89-4e79-bf10-463657acf44d",0x2C] = "Opnum44NotUsedOnWire",

		# efsrpc2 - MSDN Ref: Encrypting File System Remote Protocol [ms-efsr]
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x00] = "EfsRpcOpenFileRaw",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x01] = "EfsRpcReadFileRaw",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x02] = "EfsRpcWriteFileRaw",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x03] = "EfsRpcCloseRaw",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x04] = "EfsRpcEncryptFileSrv",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x05] = "EfsDecryptFileSrv",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x06] = "EfsRpcQueryUsersOnFile",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x07] = "EfsRpcQueryRecoveryAgents",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x08] = "EfsRpcRemoveUsersFromFile",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x09] = "EfsRpcAddUsersToFile",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0A] = "Opnum10NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0B] = "EfsRpcNotSupported",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0C] = "EfsRpcFileKeyInfo",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0D] = "EfsRpcDuplicateEncryptionInfoFile",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0E] = "Opnum14NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x0F] = "EfsRpcAddUsersToFileEx",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x10] = "EfsRpcFileKeyInfoEx",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x11] = "Opnum17NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x12] = "EfsRpcGetEncryptedFileMetadata",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x13] = "EfsRpcSetEncryptedFileMetadata",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x14] = "EfsRpcFlushEfsCache",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x15] = "EfsRpcEncryptFileExServ",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x16] = "EfsRpcQueryProtectors",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x17] = "Opnum23NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x18] = "Opnum24NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x19] = "Opnum25NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1A] = "Opnum26NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1B] = "Opnum27NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1C] = "Opnum28NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1D] = "Opnum29NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1E] = "Opnum30NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x1F] = "Opnum31NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x20] = "Opnum32NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x21] = "Opnum33NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x22] = "Opnum34NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x23] = "Opnum35NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x24] = "Opnum36NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x25] = "Opnum37NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x26] = "Opnum38NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x27] = "Opnum39NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x28] = "Opnum40NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x29] = "Opnum41NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x2A] = "Opnum42NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x2B] = "Opnum43NotUsedOnWire",
		["c681d488-d850-11d0-8c52-00c04fd90f7e",0x2C] = "Opnum44NotUsedOnWire",

		# FileServerVssAgent - MSDN Ref: File Server Remote VSS Protocol [ms-fsrvp]
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x00] = "GetSupportedVersion",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x01] = "SetContext",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x02] = "StartShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x03] = "AddToShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x04] = "CommitShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x05] = "ExposeShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x06] = "RecoveryCompleteShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x07] = "AbortShadowCopySet",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x08] = "IsPathSupported",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x09] = "IsPathShadowCopied",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x0A] = "GetShareMapping",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x0B] = "DeleteShareMapping",
		["a8e0653c-2744-4389-a61d-7373df8b2292",0x0C] = "PrepareShadowCopy",

		# FrsTransport - MSDN Ref: DFS Replication Protocol [ms-frs2]
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x00] = "CheckConnectivity",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x01] = "EstablishConnection",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x02] = "EstablishSession",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x03] = "RequestUpdates",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x04] = "RequestVersionVector",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x05] = "AsyncPoll",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x06] = "RequestRecords",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x07] = "UpdateCancel",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x08] = "RawGetFileData",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x09] = "RdcGetSignatures",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0A] = "RdcPushSourceNeeds",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0B] = "RdcGetFileData",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0C] = "RdcClose",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0D] = "InitializeFileTransferAsync",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0E] = "Opnum14NotUsedOnWire",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x0F] = "RawGetFileDataAsync",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x10] = "RdcGetFileDataAsync",
		["897e2e5f-93f3-4376-9c9c-fd2277495c27",0x11] = "RdcFileDataTransferKeepAlive",

		# IADProxy - MSDN Ref: DFS Replication Helper Protocol [ms-dfsrh]
		["4bb8ab1d-9ef9-4100-8eb6-dd4b4e418b72",0x03] = "CreateObject",
		["4bb8ab1d-9ef9-4100-8eb6-dd4b4e418b72",0x04] = "DeleteObject",
		["4bb8ab1d-9ef9-4100-8eb6-dd4b4e418b72",0x05] = "ModifyObject",

		# IADProxy2 - MSDN Ref: DFS Replication Helper Protocol [ms-dfsrh]
		["c4b0c7d9-abe0-4733-a1e1-9fdedf260c7a",0x06] = "CreateObject",
		["c4b0c7d9-abe0-4733-a1e1-9fdedf260c7a",0x07] = "DeleteObject",
		["c4b0c7d9-abe0-4733-a1e1-9fdedf260c7a",0x08] = "ModifyObject",

		# ICertAdminD - MSDN Ref: Certificate Services Remote Administration Protocol [ms-csra]
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x03] = "SetExtension",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x04] = "SetAttributes",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x05] = "ResubmitRequest",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x06] = "DenyRequest",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x07] = "IsValidCertificate",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x08] = "PublishCRL",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x09] = "GetCRL",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0A] = "RevokeCertificate",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0B] = "EnumViewColumn",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0C] = "GetViewDefaultColumnSet",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0D] = "EnumAttributesOrExtensions",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0E] = "OpenView",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x0F] = "EnumView",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x10] = "CloseView",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x11] = "ServerControl",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x12] = "Ping",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x13] = "GetServerState",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x14] = "BackupPrepare",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x15] = "BackupEnd",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x16] = "BackupGetAttachmentInformation",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x17] = "BackupGetBackupLogs",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x18] = "BackupOpenFile",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x19] = "BackupReadFile",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x1A] = "BackupCloseFile",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x1B] = "BackupTruncateLogs",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x1C] = "ImportCertificate",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x1D] = "BackupGetDynamicFiles",
		["d99e6e71-fc88-11d0-b498-00a0c90312f3",0x1E] = "RestoreGetDatabaseLocations",

		# ICertAdminD2 - MSDN Ref: Certificate Services Remote Administration Protocol [ms-csra]
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x1F] = "PublishCRLs",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x20] = "GetCAProperty",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x21] = "SetCAProperty",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x22] = "GetCAPropertyInfo",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x23] = "EnumViewColumnTable",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x24] = "GetCASecurity",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x25] = "SetCASecurity",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x26] = "Ping2",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x27] = "GetArchivedKey",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x28] = "GetAuditFilter",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x29] = "SetAuditFilter",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2A] = "GetOfficerRights",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2B] = "SetOfficerRights",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2C] = "GetConfigEntry",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2D] = "SetConfigEntry",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2E] = "ImportKey",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x2F] = "GetMyRoles",
		["7fe0d935-dda6-443f-85d0-1cfb58fe41dd",0x30] = "DeleteRow",

		# ICertRequestD - MSDN Ref: Windows Client Certificate Enrollment Protocol [ms-wcce]
		["d99e6e70-fc88-11d0-b498-00a0c90312f3",0x03] = "Request",
		["d99e6e70-fc88-11d0-b498-00a0c90312f3",0x04] = "GetCACert",
		["d99e6e70-fc88-11d0-b498-00a0c90312f3",0x05] = "Ping",

		# ICertRequestD2 - MSDN Ref: Windows Client Certificate Enrollment Protocol [ms-wcce]
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x03] = "Request",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x04] = "GetCACert",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x05] = "Ping",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x06] = "Request2",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x07] = "GetCAProperty",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x08] = "GetCAPropertyInfo",
		["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90",0x09] = "Ping2",

		# IDMNotify - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["d2d79df7-3400-11d0-b40b-00aa005ff586",0x00] = "ObjectsChanged",

		# IDMRemoteServer - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["3a410f21-553f-11d1-8e5e-00a0c92c9d5d",0x03] = "CreateRemoteObject",

		# IEnumWbemClassObject - MSDN Ref: WMI Remote Protocol [ms-wmi]
		["027947e1-d731-11ce-a357-000000000001",0x03] = "Reset",
		["027947e1-d731-11ce-a357-000000000001",0x04] = "Next",
		["027947e1-d731-11ce-a357-000000000001",0x05] = "NextAsync",
		["027947e1-d731-11ce-a357-000000000001",0x06] = "Clone",
		["027947e1-d731-11ce-a357-000000000001",0x07] = "Skip",

		# IEventService I Eventlog - MSDN Ref: Eventlog Remoting Protocol v6.0 [ms-even6]
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x00] = "EvtRpcRegisterRemoteSubscription",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x01] = "EvtRpcRemoteSubscriptionNextAsync",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x02] = "EvtRpcRemoteSubscriptionNext",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x03] = "EvtRpcRemoteSubscriptionWaitAsync",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x04] = "EvtRpcRegisterControllableOperation",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x05] = "EvtRpcRegisterLogQuery",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x06] = "EvtRpcClearLog",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x07] = "EvtRpcExportLog",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x08] = "EvtRpcLocalizeExportLog",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x09] = "EvtRpcMessageRender",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0A] = "EvtRpcMessageRenderDefault",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0B] = "EvtRpcQueryNext",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0C] = "EvtRpcQuerySeek",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0D] = "EvtRpcClose",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0E] = "EvtRpcCancel",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x0F] = "EvtRpcAssertConfig",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x10] = "EvtRpcRetractConfig",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x11] = "EvtRpcOpenLogHandle",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x12] = "EvtRpcGetLogFileInfo",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x13] = "EvtRpcGetChannelList",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x14] = "EvtRpcGetChannelConfig",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x15] = "EvtRpcPutChannelConfig",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x16] = "EvtRpcGetPublisherList",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x17] = "EvtRpcGetPublisherListForChannel",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x18] = "EvtRpcGetPublisherMetadata",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x19] = "EvtRpcGetPublisherResourceMetadata",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x1A] = "EvtRpcGetEventMetadataEnum",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x1B] = "EvtRpcGetNextEventMetadata",
		["f6beaff7-1e19-4fbb-9f8f-b89e2018337c",0x1C] = "EvtRpcGetClassicLogDisplayName",

		# IIISApplicationAdmin - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x03] = "CreateApplication",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x04] = "DeleteApplication",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x05] = "CreateApplicationPool",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x06] = "DeleteApplicationPool",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x07] = "EnumerateApplicationsInPool",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x08] = "RecycleApplicationPool",
		["7c4e1804-e342-483d-a43e-a850cfcc8d18",0x09] = "GetProcessMode",

		# IIISCertObj - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x07] = "Opnum7NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x08] = "Opnum8NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x09] = "Opnum9NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0A] = "InstanceName",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0B] = "Opnum11NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0C] = "IsInstallRemote",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0D] = "Opnum13NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0E] = "IsExportableRemote",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x0F] = "Opnum15NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x10] = "GetCertInfoRemote",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x11] = "Opnum17NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x12] = "Opnum18NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x13] = "Opnum19NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x14] = "Opnum20NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x15] = "Opnum21NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x16] = "ImportFromBlob",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x17] = "ImportFromBlobGetHash",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x18] = "Opnum24NotUsedOnWire",
		["bd0c73bc-805b-4043-9c30-9a28d64dd7d2",0x19] = "ExportToBlob",

		# IIisServiceControl - MSDN Ref: IIS Service Control Protocol [ms-iiss]
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe",0x07] = "Stop",
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe",0x08] = "Start",
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe",0x09] = "Reboot",
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe",0x0A] = "Status",
		["e8fb8620-588f-11d2-9d61-00c04f79c5fe",0x0B] = "Kill",

		# IManagedObject - MSDN Ref: IManagedObject Interface Protocol [ms-ioi]
		["c3fcc19e-a970-11d2-8b5a-00a0c9b7c9c4",0x03] = "GetSerializedBuffer",
		["c3fcc19e-a970-11d2-8b5a-00a0c9b7c9c4",0x04] = "GetObjectIdentify",

		# IManageTelnetSessions - MSDN Ref: Telnet Server Remote Administration Protocol [ms-tsrap]
		["034634fd-ba3f-11d1-856a-00a0c944138c",0x07] = "GetTelnetSessions",
		["034634fd-ba3f-11d1-856a-00a0c944138c",0x08] = "TerminateSession",
		["034634fd-ba3f-11d1-856a-00a0c944138c",0x09] = "SendMsgToASession",

		# IMSAdminBase2W - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["8298d101-f992-43b7-8eca-5052d885b995",0x22] = "BackupWithPasswrd",
		["8298d101-f992-43b7-8eca-5052d885b995",0x23] = "RestoreWithPasswrd",
		["8298d101-f992-43b7-8eca-5052d885b995",0x24] = "Export",
		["8298d101-f992-43b7-8eca-5052d885b995",0x25] = "Import",
		["8298d101-f992-43b7-8eca-5052d885b995",0x26] = "RestoreHistory",
		["8298d101-f992-43b7-8eca-5052d885b995",0x27] = "EnumHistory",

		# IMSAdminBase3W - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["f612954d-3b0b-4c56-9563-227b7be624b4",0x28] = "GetChildPaths",

		# IMSAdminBaseW - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x03] = "AddKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x04] = "DeleteKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x05] = "DeleteChildKEys",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x06] = "EnumKeys",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x07] = "CopyKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x08] = "RenameKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x09] = "R_SetData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0A] = "R_GetData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0B] = "DeleteDate",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0C] = "R_EnumData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0D] = "R_GetAllData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0E] = "DeleteAllData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x0F] = "CopyData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x10] = "GetDataPaths",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x11] = "OpenKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x12] = "CloseKey",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x13] = "ChangePermissions",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x14] = "SaveData",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x15] = "GetHandleInfo",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x16] = "GetSystemChangeNumber",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x17] = "GetDataSetNumber",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x18] = "SetLastChangeTime",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x19] = "GetLastChangeTime",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1A] = "R_KeyExchangePhase1",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1B] = "R_KeyExchangePhase2",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1C] = "Backup",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1D] = "Restore",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1E] = "EnumBackups",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x1F] = "DeleteBackup",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x20] = "UnmarshalInterface",
		["70b51430-b6ca-11d0-b9b9-00a0c922e750",0x21] = "R_GetServerGuid",

		# inetinfo - MSDN Ref: IIS Inetinfo Remote Protocol [ms-irp]
		["82ad4280-036b-11cf-972c-00aa006887b0",0x00] = "R_InetInfoGetVersion",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x01] = "R_InetInfoGetAdminInformation",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x02] = "R_InsetInfoGetSites",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x03] = "R_InetInfoSetAdminInformation",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x04] = "R_InetInfoGetGlobalAdminInformation",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x05] = "R_InetInfoSetGlobalAdminInformation",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x06] = "R_InetInfoQueryStatistics",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x07] = "R_InetInfoClearStatistics",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x08] = "R_InetInfoFlushMemoryCache",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x09] = "R_InetInfoGetServerCapabilities",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0A] = "R_W3QueryStatistics2",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0B] = "R_W3ClearStatistics2",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0C] = "R_FtpQueryStatistics2",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0D] = "R_FtpClearStatistics2",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0E] = "R_IISDEnumerateUsers",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x0F] = "R_IISDisconnectedUser",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x10] = "Opnum16NotUsedOnWire",
		["82ad4280-036b-11cf-972c-00aa006887b0",0x11] = "Opnum17NotUsedOnWire",

		# IRemoteDispatch - MSDN Ref: IManagedObject Interface Protocol [ms-ioi]
		["6619a740-8154-43be-a186-0319578e02db",0x07] = "RemoteDispatchAutoDone",
		["6619a740-8154-43be-a186-0319578e02db",0x08] = "RemoteDispatchNotAutoDone",

		# IRemUnknown - MSDN Ref: DCOM Remote Protocol [ms-dcom]
		["00000131-0000-0000-c000-000000000046",0x03] = "RemQueryInterface",
		["00000131-0000-0000-c000-000000000046",0x04] = "RemAddRef",
		["00000131-0000-0000-c000-000000000046",0x05] = "RemRelease",

		# IResourceManager - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x07] = "RetrieveEventList",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x08] = "GetSystemAffinity",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x09] = "ImportXMLFiles",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0A] = "ExportXMLFiles",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0B] = "RestoreXMLFiles",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0C] = "GetDependencies",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0D] = "GetServiceList",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0E] = "GetllSAppPoolNames",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x0F] = "GetServerName",
		["c5cebee2-9df5-4cdd-a08c-c2471bc144b4",0x10] = "GetCurrentMemory",

		# IResourceManager2 - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["2a3eb639-d134-422d-90d8-aaa1b5216202",0x07] = "ExportObjects",
		["2a3eb639-d134-422d-90d8-aaa1b5216202",0x08] = "GetImportConflicts",
		["2a3eb639-d134-422d-90d8-aaa1b5216202",0x09] = "ImportXml",
		["2a3eb639-d134-422d-90d8-aaa1b5216202",0x0A] = "ExportXml",

		# ISDKey - MSDN Ref: Group Key Distribution Protocol [ms-gkdi]
		["b9785960-524f-11df-8b6d-83dcded72085",0x00] = "GetKey",

		# IServerHealthReport - MSDN Ref: DFS Replication Helper Protocol [ms-dfsrh]
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x03] = "GetReport",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x04] = "GetCompressedReport",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x05] = "GetRawReportEx",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x06] = "GetReferenceVersionVectors",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x07] = "Opnum7NotUsedOnWire",
		["e65e8028-83e8-491b-9af7-aaf6bd51a0ce",0x08] = "GetReferenceBacklogCounts",

		# IServerHealthReport2 - MSDN Ref: DFS Replication Helper Protocol [ms-dfsrh]
		["20d15747-6c48-4254-a358-65039fd8c63c",0x09] = "GetReport",
		["20d15747-6c48-4254-a358-65039fd8c63c",0x10] = "GetCompressedReport",

		# IServicedComponentInfo - MSDN Ref: IManagedObject Interface Protocol [ms-ioi]
		["8165b19e-8d3a-4d0b-80c8-97de310db583",0x03] = "GetComponentInfo",

		# ITpmVirtualSmartCardManager - MSDN Ref: TPM Virtual Smart Card Mgmt Protocol [ms-tpmvsc]
		["112b1dff-d9dc-41f7-869f-d67fee7cb591",0x03] = "CreateVirtualSmartCard",
		["112b1dff-d9dc-41f7-869f-d67fee7cb591",0x04] = "DestroyVirtualSmartCard",

		# ITpmVirtualSmartCardManager2 - MSDN Ref: TPM Virtual Smart Card Mgmt Protocol [ms-tpmvsc]
		["fdf8a2b9-02de-47f4-bc26-aa85ab5e5267",0x05] = "CreateVirtualSmartCardWithPinPolicy",

		# ITpmVirtualSmartCardManager3 - MSDN Ref: TPM Virtual Smart Card Mgmt Protocol [ms-tpmvsc]
		["3c745a97-f375-4150-be17-5950f694c699",0x06] = "CreateVirtualSmartCardWithAttestation",

		# ITpmVirtualSmartCardManagerStatusCallback - MSDN Ref: TPM Virtual Smart Card Mgmt Protocol [ms-tpmvsc]
		["1a1bb35f-abb8-451c-a1ae-33d98f1bef4a",0x03] = "ReportProgress",
		["1a1bb35f-abb8-451c-a1ae-33d98f1bef4a",0x04] = "ReportError",

		# IUnknown - MSDN Ref: DCOM Remote Protocol [ms-dcom]
		["00000000-0000-0000-c000-000000000046",0x00] = "Opnum0NotUsedOnWire",
		["00000000-0000-0000-c000-000000000046",0x01] = "Opnum1NotUsedOnWire",
		["00000000-0000-0000-c000-000000000046",0x02] = "Opnum2NotUsedOnWire",

		# IVolumeClient - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x03] = "EnumDisksEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x04] = "EnumDiskRegionsEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x05] = "CreatePartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x06] = "CreatePartitionAssignAndFormat",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x07] = "CreatePartitionAssignandFormatEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x08] = "DeletePartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x09] = "WriteSignature",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0A] = "MarkActivePartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0B] = "Eject",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0C] = "Opnum12NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0D] = "FTEnumVolumes",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0E] = "FTEnumLogicalDiskMembers",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x0F] = "FTDeleteVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x10] = "FTBreakMirror",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x11] = "FTResyncMirror",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x12] = "FTRegenerateParityStripe",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x13] = "FTReplaceMirrorPartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x14] = "FTReplaceParityStripePartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x15] = "EnumDriveLetters",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x16] = "AssignDriveLetter",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x17] = "FreeDriveLetter",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x18] = "EnumLocalFileSystems",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x19] = "GetInstalledFileSystems",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1A] = "Format",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1B] = "Opnum27NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1C] = "EnumVolumes",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1D] = "EnumVolumeMembers",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1E] = "CreateVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x1F] = "CreateVolumeAssignAndFormat",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x20] = "CreateVolumeAssignAndFormatEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x21] = "GetVolumeMountName",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x22] = "GrowVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x23] = "DeleteVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x24] = "AddMirror",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x25] = "RemoveMirror",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x26] = "SplitMirror",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x27] = "InitializeDiskEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x28] = "UninitializeDisk",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x29] = "ReConnectDisk",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2A] = "Opnum42NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2B] = "ImportDiskGroup",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2C] = "DiskMergeQuery",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2D] = "DiskMerge",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2E] = "Opnum46NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x2F] = "ReAttachDisk",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x30] = "Opnum48NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x31] = "Opnum49NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x32] = "Opnum50NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x33] = "ReplaceRaid5Column",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x34] = "RestartVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x35] = "GetEncapsulateDiskInfoEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x36] = "EncapsulateDiskEx",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x37] = "QueryChangePartitionNumbers",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x38] = "DeletePartitionNumberInfoFromRegistry",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x39] = "SetDontShow",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3A] = "GetDontShow",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3B] = "Opnum59NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3C] = "Opnum60NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3D] = "Opnum61NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3E] = "Opnum62NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x3F] = "Opnum63NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x40] = "Opnum64NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x41] = "Opnum65NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x42] = "Opnum66NotUsedOnWire",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x43] = "EnumTasks",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x44] = "GetTaskDetail",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x45] = "AbortTask",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x46] = "HrGetErrorData",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x47] = "Initialize",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x48] = "Uninitialize",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x49] = "Refresh",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4A] = "RescanDisks",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4B] = "RefreshFileSys",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4C] = "SecureSystemPartition",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4D] = "ShutDownSystem",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4E] = "EnumAccessPath",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x4F] = "EnumAccessPathForVolume",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x50] = "AddAccessPath",
		["d2d79df5-3400-11d0-b40b-00aa005ff586",0x51] = "DeleteAccessPath",

		# IVolumeClient2 - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["4bdafc52-fe6a-11d2-93f8-00105a11164a",0x03] = "GetMaxAdjustedFreeSpace",

		# IVolumeClient3 - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x03] = "EnumDisksEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x04] = "EnumDiskRegionsEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x05] = "CreatePartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x06] = "CreatePartitionAssignAndFormat",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x07] = "CreatePartitionAssignandFormatEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x08] = "DeletePartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x09] = "InitializeDiskStyle",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0A] = "MarkActivePartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0B] = "Eject",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0C] = "Opnum12NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0D] = "FTEnumVolumes",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0E] = "FTEnumLogicalDiskMembers",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x0F] = "FTDeleteVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x10] = "FTBreakMirror",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x11] = "FTResyncMirror",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x12] = "FTRegenerateParityStripe",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x13] = "FTReplaceMirrorPartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x14] = "FTReplaceParityStripePartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x15] = "EnumDriveLetters",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x16] = "AssignDriveLetter",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x17] = "FreeDriveLetter",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x18] = "EnumLocalFileSystems",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x19] = "GetInstalledFileSystems",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1A] = "Format",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1B] = "EnumVolumes",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1C] = "EnumVolumeMembers",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1D] = "CreateVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1E] = "CreateVolumeAssignAndFormat",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x1F] = "CreateVolumeAssignAndFormatEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x20] = "GetVolumeMountName",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x21] = "GrowVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x22] = "DeleteVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x23] = "CreatePartitionsForVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x24] = "DeletePartitionsForVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x25] = "GetMaxAdjustedFreeSpace",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x26] = "AddMirror",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x27] = "RemoveMirror",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x28] = "SplitMirror",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x29] = "InitializeDiskEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2A] = "UninitializeDisk",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2B] = "ReConnectDisk",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2C] = "ImportDiskGroup",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2D] = "DiskMergeQuery",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2E] = "DiskMerge",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x2F] = "ReAttachDisk",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x30] = "ReplaceRaid5Column",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x31] = "RestartVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x32] = "GetEncapsulateDiskInfoEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x33] = "EncapsulateDiskEx",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x34] = "QueryChangePartitionNumbers",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x35] = "DeletePartitionNumberInfoFromRegistry",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x36] = "SetDontShow",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x37] = "GetDontShow",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x38] = "Opnum56NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x39] = "Opnum57NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3A] = "Opnum58NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3B] = "Opnum59NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3C] = "Opnum60NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3D] = "Opnum61NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3E] = "Opnum62NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x3F] = "Opnum63NotUsedOnWire",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x40] = "EnumTasks",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x41] = "GetTaskDetail",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x42] = "AbortTask",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x43] = "HrGetErrorData",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x44] = "Initialize",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x45] = "Uninitialize",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x46] = "Refresh",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x47] = "RescanDisks",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x48] = "RefreshFileSys",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x49] = "SecureSystemPartition",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x4A] = "ShutDownSystem",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x4B] = "EnumAccessPath",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x4C] = "EnumAccessPathForVolume",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x4D] = "AddAccessPath",
		["135698d2-3a37-4d26-99df-e2bb6ae3ac61",0x4E] = "DeleteAccessPath",

		# IVolumeClient4 - MSDN Ref: Disk Mgmt Remote Protocol [ms-dmrp]
		["deb01010-3a37-4d26-99df-e2bb6ae3ac61",0x03] = "RefreshEx",
		["deb01010-3a37-4d26-99df-e2bb6ae3ac61",0x04] = "GetVolumeDeviceName",

		# IVssDifferentialSoftwareSnapshotMgmt - MSDN Ref: Shadow Copy Mgmt Protocol [ms-scmp]
		["214a0f28-b737-4026-b847-4f9e37d79529",0x03] = "AddDiffArea",
		["214a0f28-b737-4026-b847-4f9e37d79529",0x04] = "ChangeDiffAreaMaximizeSize",
		["214a0f28-b737-4026-b847-4f9e37d79529",0x05] = "QueryVolumesSupportedForDiffAreas",
		["214a0f28-b737-4026-b847-4f9e37d79529",0x06] = "QueryDiffAreasForVolume",
		["214a0f28-b737-4026-b847-4f9e37d79529",0x07] = "QueryDiffAreaOnVolume",
		["214a0f28-b737-4026-b847-4f9e37d79529",0x08] = "Opnum08NotUsedOnWire",

		# IVssEnumMgmtObject - MSDN Ref: Shadow Copy Mgmt Protocol [ms-scmp]
		["01954e6b-9254-4e6e-808c-c9e05d007696",0x03] = "Next",
		["01954e6b-9254-4e6e-808c-c9e05d007696",0x04] = "Skip",
		["01954e6b-9254-4e6e-808c-c9e05d007696",0x05] = "Reset",
		["01954e6b-9254-4e6e-808c-c9e05d007696",0x06] = "Clone",

		# IVssEnumObject - MSDN Ref: Shadow Copy Mgmt Protocol [ms-scmp]
		["ae1c7110-2f60-11d3-8a39-00c04f72d8e3",0x03] = "Next",
		["ae1c7110-2f60-11d3-8a39-00c04f72d8e3",0x04] = "Skip",
		["ae1c7110-2f60-11d3-8a39-00c04f72d8e3",0x05] = "Reset",
		["ae1c7110-2f60-11d3-8a39-00c04f72d8e3",0x06] = "Clone",

		# IVssSnapshotMgmt - MSDN Ref: Shadow Copy Mgmt Protocol [ms-scmp]
		["fa7df749-66e7-4986-a27f-e2f04ae53772",0x03] = "GetProviderMgmtInterface",
		["fa7df749-66e7-4986-a27f-e2f04ae53772",0x04] = "QueryVolumesSupportedForSnapshots",
		["fa7df749-66e7-4986-a27f-e2f04ae53772",0x05] = "QuerySnapshotsByVolume",

		# IWamAdmin - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x03] = "AppCreate",
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x04] = "AppDelete",
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x05] = "AppUnLoad",
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x06] = "AppGetStatus",
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x07] = "AppDeleteRecoverable",
		["29822ab7-f302-11d0-9953-00c04fd919c1",0x08] = "AppRecover",

		# IWamAdmin2 - MSDN Ref: IIS IMSAdminBaseW Remote Protocol [ms-imsa]
		["29822ab8-f302-11d0-9953-00c04fd919c1",0x09] = "AppCreate2",

		# IWRMAccounting - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x07] = "CreateAccountingDb",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x08] = "GetAccountingMetadata",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x09] = "ExecuteAccountingQuery",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0A] = "GetRawAccountingData",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0B] = "GetNextAccountingDataBatch",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0C] = "DeleteAccountingData",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0D] = "DefragmentDB",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0E] = "CancelAccountingQuery",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x0F] = "RegisterAccountingClient",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x10] = "DumpAccountingData",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x11] = "GetAccountingClients",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x12] = "SetAccountingClientStatus",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x13] = "CheckAccountingConnection",
		["4f7ca01c-a9e5-45b6-b142-2332a1339c1d",0x14] = "SetClientPermissions",

		# IWRMCalendar - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x07] = "GetCalendarInfo",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x08] = "CreateCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x09] = "ModifyCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0A] = "DeleteCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0B] = "RenameCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0C] = "ComputeEvents",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0D] = "GetScheduleInfo",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0E] = "CreateSchedule",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x0F] = "ModifySchedule",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x10] = "DeleteSchedule",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x11] = "RenameSchedule",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x12] = "MoveBeforeCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x13] = "MoveAfterCalendar",
		["481e06cf-ab04-4498-8ffe-124a0a34296d",0x14] = "GetServerTimeZone",

		# IWRMConfig - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x07] = "GetConfig",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x08] = "SetConfig",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x09] = "IsEnabled",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0A] = "EnableDisable",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0B] = "GetExclusionList",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0C] = "SetExclusionList",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0D] = "WSRMActivate",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0E] = "IsWSRMActivated",
		["21546ae8-4da5-445e-987f-627fea39c5e8",0x0F] = "RestoreExclusionList",

		# IWRMMachineGroup - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x07] = "CreateMachineGroup",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x08] = "GetMachineGroupInfo",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x09] = "ModifyMachineGroup",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0A] = "DeleteMachineGroup",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0B] = "RenameMachineGroup",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0C] = "AddMachine",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0D] = "GetMachineInfo",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0E] = "ModifyMachineInfo",
		["943991a5-b3fe-41fa-9696-7f7b656ee34b",0x0F] = "DeleteMachine",

		# IWRMPolicy - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x07] = "GetPolicyInfo",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x08] = "CreatePolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x09] = "ModifyPolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0A] = "DeletePolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0B] = "RenameAllocationPolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0C] = "MoveBefore",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0D] = "MoveAfter",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0E] = "SetCalDefaultPolicyName",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x0F] = "GetCalDefaultPolicyName",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x10] = "GetProcessList",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x11] = "GetCurrentPolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x12] = "SetCurrentPolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x13] = "GetCurrentStateAndActivePolicyName",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x14] = "GetConditionalPolicy",
		["59602eb6-57b0-4fd8-aa4b-ebf06971fe15",0x15] = "SetConditionalPolicy",

		# IWRMProtocol - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["f31931a9-832d-481c-9503-887a0e6a79f0",0x07] = "GetSupportedClient",

		# IWRMRemoteSessionMgmt - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["fc910418-55ca-45ef-b264-83d4ce7d30e0",0x07] = "GetRemoteUserCategories",
		["fc910418-55ca-45ef-b264-83d4ce7d30e0",0x08] = "SetRemoteUserCategories",
		["fc910418-55ca-45ef-b264-83d4ce7d30e0",0x09] = "RefreshRemoteSessionWeights",

		# IWRMResourceGroup - MSDN Ref: Windows System Resource Manager Protocol [ms-wsrm]
		["bc681469-9dd9-4bf4-9b3d-709f69efe431",0x07] = "GetResourceGroupInfo",
		["bc681469-9dd9-4bf4-9b3d-709f69efe431",0x08] = "ModifyResourceGroup",
		["bc681469-9dd9-4bf4-9b3d-709f69efe431",0x09] = "CreateResourceGroup",
		["bc681469-9dd9-4bf4-9b3d-709f69efe431",0x0A] = "DeleteResourceGroup",
		["bc681469-9dd9-4bf4-9b3d-709f69efe431",0x0B] = "RenameResourceGroup",

		# locator - MSDN Ref: RPC Location Services Extensions [ms-rpcl]
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x00] = "I_nsi_lookup_begin",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x01] = "I_nsi_lookup_done",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x02] = "I_nsi_lookup_next",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x03] = "I_nsi_entry_object_inq_next",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x04] = "I_nsi_ping_locator",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x05] = "I_nsi_entry_object_inq_done",
		["e33c0cc4-0482-101a-bc0c-02608c6ba218",0x06] = "I_nsi_entry_object_inq_begin",

		# lsacap - MSDN Ref: Central Access Policy Identifier Retreival Protocol [ms-capr]
		["afc07e2e-311c-4435-808c-c483ffeec7c9",0x00] = "LsarGetAvailableCAPIDs",

		# NetEventForwarder - MSDN Ref: Live Remote Event Capture Protocol [ms-lrec]
		["22e5386d-8b12-4bf0-b0ec-6a1ea419e366",0x00] = "RpcNetEventOpenSession",
		["22e5386d-8b12-4bf0-b0ec-6a1ea419e366",0x01] = "RpcNetEventReceiveData",
		["22e5386d-8b12-4bf0-b0ec-6a1ea419e366",0x02] = "RpcNetEventCloseSession",

		# NtFrsApi - MSDN Ref: File Replication Service Protocol [ms-frs1]
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x00] = "Opnum0NotUsedOnWire",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x01] = "Opnum1NotUsedOnWire",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x02] = "Opnum2NotUsedOnWire",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x03] = "Opnum3NotUsedOnWire",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x04] = "NtFrsApi_Rpc_Set_DsPollingIntervalW",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x05] = "NtFrsApi_Rpc_Get_DsPollingIntervalW",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x06] = "Opnum6NotUsedOnWire",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x07] = "NtFrsApi_Rpc_InfoW",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x08] = "NtFrsApi_Rpc_IsPathReplicated",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x09] = "NtFrsApi_Rpc_WriterCommand",
		["d049b186-814f-11d1-9a3c-00c04fc9b232",0x0A] = "NtFrsApi_Rpc_ForceReplication",

		# RCMListener - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["497d95a6-2d27-4bf5-9bbd-a6046957133c",0x00] = "RpcOpenListener",
		["497d95a6-2d27-4bf5-9bbd-a6046957133c",0x01] = "RpcCloseListener",
		["497d95a6-2d27-4bf5-9bbd-a6046957133c",0x02] = "RpcStopListener",
		["497d95a6-2d27-4bf5-9bbd-a6046957133c",0x03] = "RpcStartListener",
		["497d95a6-2d27-4bf5-9bbd-a6046957133c",0x04] = "RpcIsListening",

		# RCMPublic - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x00] = "RpcGetClientData",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x01] = "RpcGetConfigData",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x02] = "RpcGetProtocolStatus",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x03] = "RpcGetLastInputTime",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x04] = "RpcGetRemoteAddress",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x05] = "Opnum5NotUsedOnWire",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x06] = "Opnum6NotUsedOnWire",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x07] = "Opnum7NotUsedOnWire",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x08] = "RpcGetAllListeners",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x09] = "RpcGetSessionProtocolLastInputTime",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x0A] = "RpcGetUserCertificates",
		["bde95fdf-eee0-45de-9e12-e5a61cd0d4fe",0x0B] = "RpcQuerySessionData",

		# RemoteFW - MSDN Ref: Firewall and Advanced Security Protocol [ms-fasp]
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x00] = "RRPC_FWOpenPolicyStore",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x01] = "RRPC_FWClosePolicyStore",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x02] = "RRPC_FWRestoreDefaults",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x03] = "RRPC_FWGetGlobalConfig",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x04] = "RRPC_FWSetGlobalConfig",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x05] = "RRPC_FWAddFirewallRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x06] = "RRPC_FWSetFirewallRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x07] = "RRPC_FWDeleteFirewallRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x08] = "RRPC_FWDeleteAllFirewallRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x09] = "RRPC_FWEnumFirewallRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0A] = "RRPC_FWGetConfig",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0B] = "RRPC_FWSetConfig",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0C] = "RRPC_FWAddConnectionSecurityRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0D] = "RRPC_FWSetConnectionSecurityRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0E] = "RRPC_FWDeleteConnectionSecurityRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x0F] = "RRPC_FWEnumConnectionSecurityRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x10] = "RRPC_FWEnumConnectionSecurityRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x11] = "RRPC_FWAddAuthenticationSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x12] = "RRPC_FWSetAuthenticationSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x13] = "RRPC_FWDeleteAuthenticationSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x14] = "RRPC_FWDeleteAllAuthenticationSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x15] = "RRPC_FWEnumAuthenticationSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x16] = "RRPC_FWAddCryptoSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x17] = "RRPC_FWSetCryptoSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x18] = "RRPC_FWDeleteCryptoSet",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x19] = "RRPC_FWDeleteAllCryptoSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1A] = "RRPC_FWEnumCryptoSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1B] = "RRPC_FWEnumPhase1SAs",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1C] = "RRPC_FWEnumPhase2SAs",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1D] = "RRPC_FWDeletePhase1SAs",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1E] = "RRPC_FWDeletePhase2SAs",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x1F] = "RRPC_FWEnumProducts",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x20] = "RRPC_FWAddMainModeRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x21] = "RRPC_FWSetMainModeRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x22] = "RRPC_FWDeleteMainModeRule",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x23] = "RRPC_FWDeleteAllMainModeRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x24] = "RRPC_FWEnumMainModeRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x25] = "RRPC_FWQueryFirewallRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x26] = "RRPC_FWQueryConnectionSecurityRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x27] = "RRPC_FWQueryMainModeRules",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x28] = "RRPC_FWQueryAuthenticationSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x29] = "RRPC_FWQueryCryptoSets",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2A] = "RRPC_FWEnumNetworks",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2B] = "RRPC_FWEnumAdapters",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2C] = "RRPC_FWGetGlobalConfig2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2D] = "RRPC_FWGetConfig2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2E] = "RRPC_FWAddFirewallRule2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x2F] = "RRPC_FWSetFirewallRule2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x30] = "RRPC_FWEnumFirewallRules2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x31] = "RRPC_FWAddConnectionSecurityRule2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x32] = "RRPC_FWSetConnectionSecurityRule2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x33] = "RRPC_FWEnumConnectionSecurityRules2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x34] = "RRPC_FWAddAuthenticationSet2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x35] = "RRPC_FWSetAuthenticationSet2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x36] = "RRPC_FWEnumAuthenticationSets2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x37] = "RRPC_FWAddCryptoSet2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x38] = "RRPC_FWSetCryptoSet2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x39] = "RRPC_FWEnumCryptoSets2_10",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3A] = "RRPC_FWAddConnectionSecurityRule2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3B] = "RRPC_FWSetConnectionSecurityRule2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3C] = "RRPC_FWEnumConnectionSecurityRules2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3D] = "RRPC_FWQueryConnectionSecurityRules2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3E] = "RRPC_FWAddAuthenticationSet2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x3F] = "RRPC_FWEnumAuthenticationSets2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x40] = "RRPC_FWQueryAuthenticationSets2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x41] = "RRPC_FWAddFirewallRule2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x42] = "RRPC_FWSetFirewallRule2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x43] = "RRPC_FWEnumFirewallRules2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x45] = "RRPC_FWQueryFirewallRules2_20",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x46] = "RRPC_FWAddFirewallRule2_24",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x47] = "RRPC_FWSetFirewallRule2_24",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x48] = "RRPC_FWEnumFirewallRules2_24",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x49] = "RRPC_FWQueryFirewallRules2_24",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4A] = "RRPC_FWAddFirewallRule2_25",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4B] = "RRPC_FWSetFirewallRule2_25",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4C] = "RRPC_FWEnumFirewallRules2_25",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4D] = "RRPC_FWQueryFirewallRules2_25",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4E] = "RRPC_FWAddFirewallRule2_26",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x4F] = "RRPC_FWSetFirewallRule2_26",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x50] = "RRPC_FWEnumFirewallRules2_26",
		["6b5bdd1e-528c-422c-af8c-a4079be4fe48",0x51] = "RRPC_FWQueryFirewallRules2_26",

		# remotesp - MSDN Ref: Telephony Remote Protocol [ms-trp]
		["2f5f6521-ca47-1068-b319-00dd010662db",0x00] = "RemoteSPAttach",
		["2f5f6521-ca47-1068-b319-00dd010662db",0x01] = "RemoteSPEventProc",
		["2f5f6521-ca47-1068-b319-00dd010662db",0x02] = "RemoteSPDetach",

		# SessEnvPublicRpc - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["1257b580-ce2f-4109-82d6-a9459d0bf6bc",0x00] = "RpcShadow2",

		# ssdpsrv - Marchand Ref: Simple Service Discovery Protocol (SSDP) [ssdp]
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x00] = "RegisterServiceRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x01] = "DeregisterServiceRpcByUSN",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x02] = "DeregisterServiceRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x03] = "UpdateCacheRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x04] = "LookupCacheRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x05] = "CleanupCacheRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x06] = "InitializeSyncHandle",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x07] = "RemoveSyncHandle",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x08] = "RegisterNotificationRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x09] = "GetNotificationRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0A] = "WakeupGetNotificationRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0B] = "DeregisterNotificationRpc",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0C] = "EnableDeviceHost",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0D] = "DisableDeviceHost",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0E] = "SetICSInterfaces",
		["4b112204-0e19-11d3-b42b-0000f81feb9f",0x0F] = "SetICSOff",

		# tapsrv - MSDN Ref: Telephony Remote Protocol [ms-trp]
		["2f5f6520-ca46-1067-b319-00dd010662da",0x00] = "ClientAttach",
		["2f5f6520-ca46-1067-b319-00dd010662da",0x01] = "ClientRequest",
		["2f5f6520-ca46-1067-b319-00dd010662da",0x02] = "ClientDetach",

		# TermServEnumeration - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x00] = "RpcOpenEnum",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x01] = "RpcCloseEnum",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x02] = "RpcFilterByState",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x03] = "RpcFilterByCallersName",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x04] = "RpcEnumAddFilter",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x05] = "RpcGetEnumResult",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x06] = "RpcFilterBySessionType",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x07] = "Opnum7NotUsedOnWire",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x08] = "RpcGetSessionIds",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x09] = "RpcGetEnumResultEx",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x0A] = "RpcGetAllSessions",
		["88143fd0-c28d-4b2b-8fef-8d882f6a9390",0x0B] = "RpcGetAllSessionsEx",

		# TermServNotification - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["11899a43-2b68-4a76-92e3-a3d6ad8c26ce",0x00] = "RpcWaitForSessionState",
		["11899a43-2b68-4a76-92e3-a3d6ad8c26ce",0x01] = "RpcRegisterAsyncNotification",
		["11899a43-2b68-4a76-92e3-a3d6ad8c26ce",0x02] = "RpcWaitAsyncNotification",
		["11899a43-2b68-4a76-92e3-a3d6ad8c26ce",0x03] = "RpcUnRegisterAsyncNotification",

		# TermSrvSession - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["484809d6-4239-471b-b5bc-61df8c23ac48",0x00] = "RpcWaitForSessionState",
		["484809d6-4239-471b-b5bc-61df8c23ac48",0x01] = "RpcRegisterAsyncNotification",
		["484809d6-4239-471b-b5bc-61df8c23ac48",0x02] = "RpcWaitAsyncNotification",
		["484809d6-4239-471b-b5bc-61df8c23ac48",0x03] = "RpcUnRegisterAsyncNotification",

		# trksvr - MSDN Ref: Distributed Link Tracking: Central Manager Protocol [ms-dltm]
		["4da1c422-943d-11d1-acae-00c04fc2aa3f",0x00] = "LnkSvrMessage",
		["4da1c422-943d-11d1-acae-00c04fc2aa3f",0x01] = "LnkSvrMessageCallback",

		# trkwks - MSDN Ref: Distributed Link Tracking: Workstation Protocol [ms-dltw]
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x00] = "Opnum0NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x01] = "Opnum1NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x02] = "Opnum2NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x03] = "Opnum3NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x04] = "Opnum4NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x05] = "Opnum5NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x06] = "Opnum6NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x07] = "Opnum7NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x08] = "Opnum8NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x09] = "Opnum9NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x0A] = "Opnum10NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x0B] = "Opnum11NotUsedOnWire",
		["300f3532-38cc-11d0-a3f0-0020af6b0add",0x0C] = "LnkSearchMachine",

		# TsProxyRpcInterface - MSDN Ref: Terminal Services Gateway Server Protocol [ms-tsgu]
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x00] = "Opnum0NotUsedOnWire",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x01] = "TsProxyCreateTunnel",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x02] = "TsProxyAuthorizeTunnel",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x03] = "TsProxyMakeTunnelCall",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x04] = "TsProxyCreateChannel",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x05] = "Opnum5NotUsedOnWire",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x06] = "TsProxyCloseChannel",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x07] = "TsProxyCloseTunnel",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x08] = "TsProxySetupReceivePipe",
		["44e265dd-7daf-42cd-8560-3cdb6e7a2729",0x09] = "TsProxySendToServer",

		# TSVIPPublic - MSDN Ref: Terminal Services Runtime Interface Protocol [ms-tsts]
		["53b46b02-c73b-4a3e-8dee-b16b80672fc0",0x00] = "RpcGetSessionIP",

		# W32Time - MSDN Ref: W32Time Remote Protocol [ms-w32t]
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x00] = "W32TimeSync",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x01] = "W32TimeGetNetlogonServiceBits",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x02] = "W32TimeQueryProviderStatus",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x03] = "W32TimeQuerySource",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x04] = "W32TimeQueryProviderConfiguration",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x05] = "W32TimeQueryConfiguration",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x06] = "W32TimeQueryStatus",
		["8fb6d884-2388-11d0-8c35-00c04fda2795",0x07] = "W32TimeLog",

		# WdsRpcInterface - MSDN Ref: Windows Deployment Services Control Protocol [ms-wdsc]
		["1a927394-352e-4553-ae3f-7cf4aafca620",0x00] = "WdsRpcMessage",

		# winsi2 - MSDN Ref: Remote Administrative Interface: WINS [ms-raiw]
		["811109bf-a4e1-11d1-ab54-00a0c91e9b45",0x00] = "R_WinsTombstoneDbRecs",
		["811109bf-a4e1-11d1-ab54-00a0c91e9b45",0x01] = "R_WinsCheckAccess",

		# Witness - MSDN Ref: Service Witness Protocol [ms-swn]
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28",0x00] = "WitnessrGetInterfaceList",
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28",0x01] = "WitnessrRegister",
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28",0x02] = "WitnessrUnRegister",
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28",0x03] = "WitnessrAsyncNotify",
		["ccd8c074-d0e5-4a40-92b4-d074faa6ba28",0x04] = "WitnessrRegisterEx",

	} &redef &default=function(uuid: string, i: count): string { return fmt("unknown-%d", i); };
}
