/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.HashMap;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.service.component.Main;

public class BasicJamesService
extends TurbineBaseService
implements Runnable {
    private static final String PHOENIX_HOME = "phoenix.home";
    private String m_phoenixHome = null;
    private Thread m_thread = null;
    private boolean m_threadStop = false;

    private void start() {
        this.m_threadStop = false;
        this.m_thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_thread.start();
    }

    private void stop() {
        if (this.m_thread == null) {
            return;
        }
        Main.shutdown();
        this.m_thread = null;
    }

    public void run() {
        System.setProperty(PHOENIX_HOME, this.m_phoenixHome);
        Log.info("chef", this + ".run: starting James service");
        try {
            int exitCode = Main.startup(new String[0], new HashMap(), true);
            Log.info("chef", this + ".run: James service stopped: " + exitCode);
        }
        catch (Exception e) {
            Log.warn("chef", this + ".run: exception:", (Throwable)e);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_phoenixHome = data.getServletContext().getRealPath(this.getProperties().getProperty(PHOENIX_HOME, "phoenix"));
        Log.info("chef", this + ".init(RunData): PHOENIX.HOME: " + this.m_phoenixHome);
        this.start();
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        this.stop();
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    static {
        PHOENIX_HOME = PHOENIX_HOME;
    }
}

