# Policy for commit titles in pmbootstrap

This document defines policy titling commits for inclusion in pmbootstrap.

## Commit types

### Changes to Python code

If you are changing some Python code, the commit title should be prefixed by the
module path to whatever code you are changing, as narrowly as possible, followed
by a colon and then a blank space.

So, if you are changing the file `pmb/build/kconfig.py`, the prefix should be
`pmb.build.kconfig`, and the full commit title something like
`pmb.build.kconfig: Support kconfig fragments even better`. If you're instead
changing multiple files, for instance `pmb/build/kconfig.py`
and `pmb/build/autodetect.py` and these changes somehow are related and similar
in size, you would instead use the broader `pmb.build` prefix. If, however, most
changes are concentrated in one file and the others only are cursory (e.g.,
changing call sites to align with a new function signature), you should specify
the module path to that file where the bulk of the changes are.

The same rules apply to the Python modules in the `test` directory.

If you're making significant changes to both `pmb` and `test`, you can include
both separated by a comma and a space like
`pmb, test: Reintroduce args everywhere because I'm evil!`.

### Changes to CI-related files

If you're making changes to CI-related files (including both files inside the
`.ci/` directory and the `.gitlab-ci.yml` file), you should prefix your commit
with `CI` followed by a colon and a space like `CI:`. You can also add a slash
like `CI/Ruff:` if you're making changes specific to for example Ruff.

### Changes to envkernel helper files

If you're making changes to the envkernel-related files in the top-level
`helpers` directory, prefix your commits with `envkernel` followed by a colon
and a space, like `envkernel: Fix compatibility with something, not sure what`.

### Changes to other files

If you're changing other files not covered in the previous categories, for
instance README.md, pyproject.toml, or .gitignore, then you just prefix the
commit title with the full filename along with a space and a colon, for instance
`.gitignore: Hide files generated by recurring bee invasions in my computer`.
