# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementGalleryInVMAccessControlProfilesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profiles_list_by_gallery(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profiles.list_by_gallery(
            resource_group_name=resource_group.name,
            gallery_name="str",
            api_version="2025-03-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profiles_get(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profiles.get(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            api_version="2025-03-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profiles_begin_create_or_update(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profiles.begin_create_or_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            gallery_in_vm_access_control_profile={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "applicableHostEndpoint": "str",
                    "osType": "str",
                    "description": "str",
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profiles_begin_update(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profiles.begin_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            gallery_in_vm_access_control_profile={
                "id": "str",
                "name": "str",
                "properties": {
                    "applicableHostEndpoint": "str",
                    "osType": "str",
                    "description": "str",
                    "provisioningState": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profiles_begin_delete(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profiles.begin_delete(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
