% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{log_setup}
\alias{log_setup}
\alias{log_init}
\alias{log_filesetup}
\alias{log_drop}
\alias{log_set_pattern}
\alias{log_set_level}
\alias{log_trace}
\alias{log_debug}
\alias{log_info}
\alias{log_warn}
\alias{log_error}
\alias{log_critical}
\title{R Accessor Functions for spdlog Logger}
\usage{
log_setup(name = "default", level = "warn")

log_init(level = "warn")

log_filesetup(filename, name = "default", level = "warn")

log_drop(name)

log_set_pattern(s)

log_set_level(s)

log_trace(s)

log_debug(s)

log_info(s)

log_warn(s)

log_error(s)

log_critical(s)
}
\arguments{
\item{name}{A character variable with the logging instance name, default value is \sQuote{default}.}

\item{level}{A character variable with the default logging level, default value is \sQuote{warn}.}

\item{filename}{A character variable with the logging filename if a file-based logger is
instantiated.}

\item{s}{A character variable with the logging pattern, level or message.}
}
\value{
Nothing is returned from these functions as they are invoked for their side-effects.
}
\description{
Several R-level functions can access the \code{spdlog} logging facilties. As \code{spdlog}
is a C++-level logging library, these are R function permit concurrent logging from both
R and C++.
}
\details{
Several functions are provided:
\describe{
   \item{\code{log_setup}}{Initializes a logger (which becomes the default logger).}
   \item{\code{log_filesetup}}{Initializes a file-based logger (which becomes the default).}
   \item{\code{log_drop}}{Removes logger (which in general should not be needed).}
   \item{\code{log_set_pattern}}{Changes the default logging message pattern.}
   \item{\code{log_set_level}}{Sets the logging level threshold.}
   \item{\code{log_trace}}{Logs a trace-level message.}
   \item{\code{log_debug}}{Logs a debug-level message.}
   \item{\code{log_info}}{Logs a info-level message.}
   \item{\code{log_warn}}{Logs a warn-level message.}
   \item{\code{log_error}}{Logs a error-level message.}
   \item{\code{log_critical}}{Logs a critical-level message.}
}

Supported logging levels are, in order of increasing threshold values, \sQuote{trace},
\sQuote{debug}, \sQuote{info}, \sQuote{warn}, \sQuote{error}, and
\sQuote{critical}.  A message issued below the current threshold is not displayed whereas
a message at or above the current threshold is displayed.  The default level is \sQuote{warn}.
}
\examples{
log_setup("demo")  # at default level 'warn'
log_info("this message is NOT seen")
log_set_level("debug")
log_info("this message is seen")
log_warn("as is this message")

}
\seealso{
The logging pattern format is described in at the repo in the page
\url{https://github.com/gabime/spdlog/wiki/3.-Custom-formatting}.
}
